import React from "react";

function Icon() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="400"
      height="200"
      version="1.1"
      viewBox="0 0 400 200"
    >
      <g fillRule="evenodd" stroke="none">
        <path
          fill="#2a2a42"
          d="M302.815.374c0 .643-1.405 1.064-3.987 1.194-2.052.103-2.361.166-2.794.573-.425.399-.786.48-2.829.629-1.287.094-2.36.176-2.382.182-.023.006-.221.203-.44.438-.341.366-.727.451-2.723.603-2.034.154-2.423.242-3.089.701-.679.468-1.009.539-3.014.649-1.944.106-2.315.182-2.711.554-.39.366-.808.457-2.786.604-1.944.146-2.427.248-2.936.624-.499.369-.996.48-2.764.617-2.039.159-2.84.365-3.128.806-.069.106-.949.269-1.956.362-2.226.206-2.506.287-2.662.779-.067.212-.237.385-.377.385-.141 0-.597.322-1.014.716-.418.393-1.004.8-1.304.905-.3.104-.596.351-.659.549-.062.197-.348.418-.634.489-.287.072-.75.35-1.03.617-1.36 1.297-2.143 1.918-2.731 2.164-.353.147-.643.362-.643.478 0 .115-.355.351-.79.525-.434.174-.79.442-.79.596 0 .154-.208.358-.462.455-.253.097-.799.494-1.212.884-.414.39-.873.708-1.022.708-.148 0-.463.223-.699.494-.236.272-.588.494-.783.494-.194 0-.546.261-.782.58-.236.32-.671.681-.966.803-.295.122-.72.471-.945.775-.227.306-.679.606-1.016.674-.337.067-.607.246-.607.403 0 .155-.244.369-.543.474-.299.106-.825.448-1.17.761-1.487 1.346-1.977 1.724-2.559 1.97-.34.144-.67.395-.732.559-.063.163-.429.429-.814.59-.385.161-.7.384-.7.497 0 .113-.378.45-.84.75-.462.3-.951.694-1.087.876-.135.182-.524.392-.863.466-.339.075-.657.29-.706.478-.049.189-.438.497-.865.685-.426.188-.775.462-.775.609 0 .147-.378.474-.84.727-.607.332-.962.717-1.284 1.391-.245.512-.623 1.026-.84 1.142-.26.14-.394.414-.394.807 0 .413-.212.813-.692 1.307-.46.474-.691.899-.691 1.273 0 .369-.195.734-.57 1.069-.314.279-.622.762-.684 1.073-.062.31-.286.727-.498.925-.213.198-.544.761-.737 1.25-.193.489-.504.999-.691 1.134-.187.136-.4.602-.474 1.036-.094.557-.303.911-.709 1.2-.316.225-.575.587-.575.804 0 .51-.283 1.029-.894 1.64-.269.269-.489.681-.489.916s-.267.731-.592 1.102c-.326.372-.593.854-.593 1.073 0 .219-.213.595-.474.837s-.573.805-.693 1.253c-.125.464-.419.944-.683 1.117-.295.193-.508.575-.584 1.044-.076.468-.34.939-.72 1.286-.373.342-.599.741-.599 1.062 0 .291-.225.738-.519 1.033-.286.286-.598.803-.694 1.149-.095.347-.391.865-.657 1.152-.265.286-.54.828-.611 1.202-.073.39-.32.808-.577.976-.264.173-.505.588-.583 1.005-.078.419-.372.923-.715 1.229-.32.285-.582.688-.582.894 0 .488-.37 1.176-.795 1.477-.289.206-.356.803-.481 4.247-.105 2.909-.228 4.198-.448 4.7-.525 1.196-.659 2.342-.822 7.012-.138 3.95-.217 4.711-.605 5.827-.389 1.118-.468 1.885-.612 5.926-.133 3.705-.245 4.901-.556 5.926-.532 1.757-.635 2.749-.669 6.439l-.028 3.179.631.953c.507.765.631 1.156.631 1.979 0 .842.106 1.159.593 1.771.494.621.593.924.593 1.815 0 1.085.315 1.956.876 2.421.187.156.311.578.314 1.072.007 1.217.307 2.289.759 2.711.392.364.502.765.688 2.498.055.513.288 1.073.603 1.447.373.443.513.834.513 1.435 0 1.08.293 2.07.765 2.583.264.287.422.855.521 1.867.1 1.036.251 1.564.522 1.835.534.535.76 1.226.76 2.326 0 .756.12 1.099.592 1.694.473.594.593.937.593 1.693 0 1.072.269 1.924.708 2.245.184.135.397.886.557 1.968.178 1.205.358 1.806.577 1.928.176.098.409.511.518.918.179.666.854 1.555 2.283 3.008.271.276.493.656.493.845 0 .188.223.428.497.532.274.104.577.397.673.652.097.254.407.614.688.798.282.184.512.437.512.562 0 .124.536.767 1.192 1.427 2.073 2.089 3.944 4.124 3.944 4.288 0 .088.289.47.642.85a78.17 78.17 0 012.454 2.801c.284.337.814.934 1.179 1.326.365.393.663.791.663.886 0 .095.222.273.494.397s.494.344.494.489c0 .146.289.529.642.853.886.812 3.385 3.615 3.506 3.933.054.142.343.451.642.685.299.234.543.583.543.775 0 .192.225.451.499.576.275.126.555.384.623.575.067.191.354.59.636.885l.849.889c.597.624 2.665 2.677 3.438 3.413.229.217.832.452 1.341.522.603.082 1.043.275 1.264.552.209.264.768.521 1.472.677.624.139 1.246.403 1.383.587.313.423 1.207.823 1.838.823.266 0 .655.171.864.38.564.563 1.101.805 1.79.805.399 0 .772.17 1.064.485.261.281.853.576 1.408.7.532.119 1.147.419 1.383.672.266.288.765.509 1.344.596.507.076 1.034.29 1.171.475.313.421 1.206.825 1.825.825.258 0 .732.221 1.054.492.321.271 1.049.599 1.616.73.568.131 1.078.357 1.134.503.151.394 1.133.843 1.842.843.43 0 .744.153 1.012.494.214.271.591.494.839.494.713 0 1.685.404 1.89.787.117.22.532.403 1.106.489.579.087 1.076.308 1.346.598.236.256.918.59 1.531.749.607.159 1.283.469 1.503.688.22.22.787.459 1.26.532 1.421.217 1.947.492 1.947 1.02v.47h40.444l.116-.581c.123-.615.947-.996 2.157-.998.334-.001.711-.193.974-.495.236-.272.63-.494.875-.494.663 0 1.499-.365 1.792-.783.146-.209.701-.464 1.277-.588.602-.129 1.195-.408 1.447-.68.273-.295.767-.512 1.366-.602.525-.079 1.115-.318 1.34-.542.22-.221.892-.542 1.493-.712.6-.171 1.285-.505 1.522-.742.248-.248.813-.488 1.328-.565.592-.089 1.041-.3 1.32-.621.315-.362.62-.486 1.197-.486.605 0 .898-.13 1.334-.593.308-.326.754-.592.992-.592.636 0 1.502-.365 1.84-.774.163-.198.735-.465 1.27-.594.535-.13 1.217-.442 1.517-.693.299-.252.956-.52 1.46-.595.601-.091 1.058-.301 1.327-.61.263-.302.724-.519 1.285-.603.542-.081 1.04-.309 1.307-.598.264-.283.809-.536 1.393-.645.62-.116 1.128-.362 1.437-.694.359-.388.67-.515 1.259-.515.609 0 .945-.147 1.523-.665.407-.366.941-.728 1.185-.804.245-.076.445-.262.445-.414 0-.152.289-.577.642-.944.353-.368.953-1.044 1.333-1.504 1.084-1.31 2.041-2.403 2.44-2.786.201-.192.467-.457.592-.588.125-.132.516-.525.869-.874.354-.349.642-.733.642-.854s.267-.409.593-.641c.326-.232.593-.547.593-.701 0-.153.23-.429.511-.613.282-.185.594-.551.694-.814.1-.263.359-.525.575-.581.216-.057.394-.248.396-.425.004-.296.845-1.255 4.146-4.729.651-.684 1.184-1.327 1.184-1.427 0-.101.227-.331.504-.513.277-.181.635-.583.795-.893.16-.31.406-.564.546-.564s.403-.311.584-.691c.181-.38.448-.691.593-.691.144 0 .411-.311.592-.692.182-.38.459-.691.616-.691.158 0 .347-.191.421-.424.074-.233.413-.714.754-1.068.341-.354 1.242-1.335 2.002-2.18.761-.845 1.672-1.815 2.025-2.156.353-.341.642-.717.642-.836s.225-.381.501-.581c.423-.309.524-.587.653-1.791.109-1.023.269-1.552.566-1.874.281-.303.486-.926.635-1.929.146-.979.341-1.584.577-1.782.401-.338.821-1.793.821-2.849 0-.405.146-.85.346-1.051.544-.549.839-1.372.839-2.341 0-.914.255-1.603.724-1.953.148-.11.354-.913.468-1.824.158-1.271.303-1.727.664-2.088.368-.368.49-.768.604-1.979.11-1.175.229-1.578.526-1.787.473-.331.767-1.302.767-2.535 0-.734.103-1.027.484-1.384.39-.364.522-.759.678-2.03.145-1.174.294-1.658.584-1.893.457-.369.819-1.537.821-2.64.001-.515.14-.925.413-1.215.445-.474.761-1.557.769-2.635.002-.373.109-.966.236-1.319.178-.492.176-1.021-.008-2.285-.132-.905-.313-3.823-.401-6.485-.138-4.116-.216-4.942-.526-5.53-.309-.586-.4-1.52-.595-6.096-.166-3.881-.3-5.448-.476-5.557-.433-.267-.608-1.77-.773-6.625-.141-4.147-.213-4.864-.569-5.669-.255-.576-.462-1.607-.551-2.747-.131-1.673-.19-1.868-.714-2.347a2.282 2.282 0 01-.691-1.26c-.073-.451-.29-.851-.555-1.024-.239-.157-.553-.662-.697-1.122-.144-.461-.469-1.041-.722-1.29-.253-.249-.46-.623-.46-.832 0-.21-.267-.684-.592-1.056-.326-.371-.593-.814-.593-.985 0-.538-.441-1.304-.82-1.424-.2-.064-.417-.355-.482-.646-.245-1.106-.344-1.315-.784-1.661-.248-.196-.512-.643-.586-.995a2.899 2.899 0 00-.585-1.134c-.247-.271-.57-.835-.717-1.252-.146-.417-.411-.836-.587-.93-.177-.095-.434-.572-.571-1.062-.148-.528-.439-1.014-.719-1.197-.324-.213-.47-.494-.47-.908 0-.408-.183-.768-.575-1.131-.317-.292-.675-.908-.797-1.368-.122-.46-.393-.928-.603-1.04-.21-.113-.491-.581-.625-1.041-.134-.46-.448-1.032-.698-1.271-.25-.239-.455-.614-.455-.833 0-.218-.267-.701-.593-1.072-.326-.371-.592-.815-.592-.985 0-.535-.44-1.305-.814-1.423-.223-.071-.406-.389-.487-.843-.071-.402-.374-.997-.673-1.323-.299-.325-.603-.844-.676-1.152-.072-.308-.343-.772-.602-1.031-.258-.258-.5-.628-.538-.822-.037-.193-.4-.508-.806-.7-.406-.191-.738-.436-.738-.545 0-.108-.35-.337-.778-.509-.428-.171-.924-.533-1.101-.804-.178-.27-.579-.581-.893-.691-.313-.109-.62-.356-.681-.549-.061-.192-.465-.489-.897-.659-.454-.178-.785-.44-.785-.62 0-.179-.166-.313-.388-.313-.212 0-.749-.355-1.193-.79-.443-.434-.933-.79-1.09-.79-.156 0-.425-.215-.597-.479-.173-.263-.576-.57-.896-.682-.32-.112-.637-.346-.704-.52-.067-.175-.461-.453-.875-.619-.414-.166-.884-.502-1.045-.748-.161-.246-.564-.559-.894-.696-.331-.137-.653-.412-.716-.611-.064-.198-.418-.461-.788-.583-.37-.122-.727-.394-.794-.605-.066-.211-.286-.383-.487-.383s-.735-.355-1.188-.79c-.452-.434-.946-.79-1.098-.79-.151 0-.415-.214-.587-.475-.171-.261-.507-.524-.747-.584-.24-.061-.779-.425-1.199-.809-.42-.385-.876-.7-1.013-.7-.137 0-.385-.209-.552-.463-.167-.255-.575-.576-.905-.713-.331-.137-.655-.417-.72-.623-.066-.206-.279-.374-.474-.374-.357 0-1.748-.999-2.853-2.048-.328-.312-.837-.651-1.13-.754-.294-.102-.579-.358-.634-.568a.528.528 0 00-.493-.383c-.216 0-.683-.271-1.037-.602-.946-.884-1.208-.978-2.716-.978-1.094 0-1.475-.084-1.9-.418-.42-.33-1.041-.471-2.971-.671-1.914-.2-2.563-.345-3.01-.676-.456-.337-1.021-.459-2.803-.604-2.034-.165-2.628-.337-3.015-.87-.071-.098-1.201-.24-2.513-.315-2.137-.123-2.462-.192-3.141-.662-.536-.372-1.013-.527-1.635-.531-1.927-.013-3.761-.367-4.105-.793-.288-.356-.659-.433-2.772-.582-2.14-.15-2.499-.227-2.923-.625-.432-.406-.737-.465-2.918-.569-2.61-.123-3.469-.416-3.469-1.182 0-.215-.089-.391-.198-.391-.108 0-.197.168-.197.374M112.099 52.549c-.435.093-1.251.174-1.815.18-1.219.014-2.013.284-2.382.811-.148.212-.442.386-.652.386-.219 0-.572.293-.828.689-.246.379-.549.69-.674.691-.125.002-.333.444-.462.983-.156.651-.36 1.019-.606 1.097-.731.232-.862 6.627-.143 7.029.186.105.505.566.708 1.025.204.459.696 1.101 1.094 1.426l1.406 1.147.681.555 3.546-.062 3.546-.062.503-.543c.277-.299.619-.544.76-.544.141-.001.612-.363 1.046-.805.435-.442 1.033-1.045 1.33-1.339.417-.412.58-.821.713-1.794.118-.866.289-1.345.546-1.533.594-.434.544-3.309-.07-4.09a2.149 2.149 0 01-.445-1.336c0-.69-.146-.917-1.404-2.188l-1.404-1.418-1.411-.136a57.374 57.374 0 01-2.102-.237c-.38-.056-1.047-.026-1.481.068m141.475 4.002c.334.335.349 1.365.29 20.049-.072 23.143.092 30.005.74 30.881.314.425.49 1.115.674 2.649.211 1.751.318 2.123.684 2.379.275.193.433.511.433.872 0 .793.282 1.451.876 2.044.279.279.507.695.507.925 0 .574.352 1.181.685 1.181.152 0 .33.171.397.381.066.209.526.765 1.022 1.234.496.47 1.136 1.087 1.423 1.371.287.285.778.578 1.091.652.314.075.724.326.912.558.272.336.657.452 1.883.569 1.146.11 1.698.265 2.151.605.812.61 9.454.722 10.119.131.468-.416 1.714-.758 2.771-.759.584-.001.991-.142 1.396-.482.314-.265.832-.544 1.151-.622.881-.213 4.628-4.085 4.628-4.783 0-.339.218-.741.593-1.095.472-.445.593-.725.593-1.371 0-.608.13-.948.52-1.355.437-.457.547-.806.683-2.184.189-1.905.333-2.512.694-2.932.404-.47.667-3.466.669-7.618.001-2.075.096-4.92.212-6.321.148-1.801.148-4.196-.001-8.177-.412-10.991-.371-28.333.068-28.818.488-.54 8.772-.65 9.777-.13 1.284.664 1.701 5.289.89 9.887-.263 1.487-.34 4.761-.475 20.049-.158 18-.199 19.164-.698 19.753-.422.499-.683 1.801-.684 3.417-.001 1.406-.046 1.582-.517 2.018-.425.394-.535.707-.62 1.772-.086 1.069-.198 1.387-.645 1.833-.365.364-.584.84-.673 1.46-.082.569-.32 1.122-.626 1.452-.271.292-.545.792-.609 1.11-.064.319-.369.758-.682.981-.312.222-.567.572-.567.779 0 .206-.267.647-.593.981-.326.333-.593.677-.593.765 0 .128-1.214 1.544-1.925 2.245-.602.595-2.338 1.928-2.509 1.928-.116 0-.32.173-.452.386-.133.212-.597.492-1.032.622-.452.136-.84.393-.906.602-.063.2-.332.409-.596.463l-.937.193c-.252.051-.701.303-.999.559-.38.326-.987.535-2.03.697-1.102.171-1.578.342-1.832.656-.782.964-17.231.958-18.013-.007-.253-.313-.726-.474-1.887-.643-.982-.143-1.66-.349-1.853-.564a2.338 2.338 0 00-1.755-.791c-.404 0-.686-.138-.852-.417-.137-.23-.626-.582-1.088-.783-.462-.202-.84-.457-.84-.568 0-.111-.289-.325-.642-.475-.939-.398-4.225-3.773-4.368-4.486-.068-.342-.241-.58-.422-.58-.18 0-.353-.237-.422-.579-.116-.583-.729-1.396-1.051-1.396-.095 0-.267-.438-.382-.974-.116-.542-.417-1.182-.68-1.445-.334-.333-.513-.802-.612-1.596-.091-.722-.302-1.319-.59-1.666-.357-.43-.497-.966-.681-2.606-.127-1.136-.305-2.114-.395-2.173-.562-.37-.691-1.331-.933-6.966-.139-3.233-.321-5.99-.405-6.125-.166-.269-.631-23.91-.647-32.943-.012-6.331.012-6.459 1.27-6.852 1.344-.419 9.464-.261 9.917.193M1.58 57.932c-.239.195-.3.853-.319 3.421-.025 3.614-.297 5.215-.886 5.215-.32 0-.375.149-.375 1.019v1.018l4-.135c3.849-.13 5.724-.296 8.049-.711.598-.107 2.832-.254 4.964-.327l3.878-.132.369.563c.315.481.389 1.13.502 4.424.073 2.124.235 5.194.361 6.824.29 3.758.296 21.097.008 24.395-.482 5.534-.822 23.533-.477 25.259l.124.618H35.753l.03-.543c.062-1.101-.065-2.935-.253-3.666-.697-2.71-1.15-54.931-.49-56.51.537-1.285.985-1.377 6.04-1.24 2.448.066 4.851.216 5.34.333 1.37.327 6.652.806 8.197.743L56 68.444l.053-5.22c.041-4.046-.004-5.257-.198-5.38-.438-.279-53.93-.191-54.275.088m176.395 10.63c-.706.202-1.717.421-2.246.486-.654.081-1.102.27-1.398.589-.239.259-.682.564-.983.678-.3.115-.592.381-.647.592-.055.211-.313.523-.573.693-.261.171-.474.492-.474.714 0 .512-.346 1.163-.827 1.554-.285.232-.417.726-.555 2.074-.269 2.619-1.677 3.845-2.874 2.502-.374-.42-.741-.594-1.408-.67-.633-.071-1.045-.255-1.38-.617-.263-.283-.541-.518-.618-.522-2.161-.102-4.305-.431-4.609-.706-.817-.74-10.133-.747-11.259-.009-.33.216-1.367.418-3 .586-2.046.209-2.578.33-2.946.673-.259.24-.942.507-1.61.629-.803.147-1.302.365-1.62.708-.253.273-.597.496-.765.496-.168 0-.639.301-1.047.669-.407.367-.916.701-1.131.742-.215.041-.499.292-.631.558-.133.266-.425.552-.65.635-.225.083-.492.37-.594.638-.102.268-.357.579-.566.691-.209.112-.518.548-.686.968-.168.42-.522.905-.786 1.078-.34.222-.514.56-.593 1.149-.072.543-.289.999-.62 1.306-.28.259-.514.623-.52.809a79.56 79.56 0 01-.221 2.412c-.247 2.437-.254 4.485-.024 7.21.171 2.023.283 2.39.86 2.807.183.132.387.518.455.857.068.34.48 1.022.915 1.517.436.494.792 1.01.792 1.146 0 .136.216.301.48.368.265.066.538.299.607.517.069.218.391.534.715.702.325.167.915.611 1.312.985.396.374.92.681 1.164.681 1.071 0 .99 2.255-.101 2.8-.364.181-.791.515-.949.74-.158.226-.418.41-.577.41-.159 0-.39.221-.513.491a2.16 2.16 0 01-.663.779c-.241.158-.5.533-.576.832-.075.299-.397.84-.715 1.203-.528.602-.581.794-.599 2.184-.011.838-.077 1.729-.148 1.98-.116.412.048 3.084.291 4.74.053.359.314.842.579 1.072.266.231.484.56.484.73.002.347 1.434 1.809 2.122 2.167.368.192.445.396.445 1.188 0 1.126-.173 1.304-1.456 1.489-.638.093-1.111.3-1.404.616-.243.262-.762.61-1.154.774-.392.164-.805.47-.917.68-.113.21-.384.439-.603.509-.219.069-.526.431-.682.803-.155.372-.406.677-.557.677-.151 0-.395.378-.542.839-.148.462-.508 1.121-.801 1.464-1.011 1.185-1.019 10.94-.01 11.701.236.178.523.666.639 1.085.115.419.422.958.68 1.197.258.24.563.682.678.983.114.301.388.594.608.652.221.057.527.349.682.649.192.37.493.584.945.668.414.078.826.346 1.099.715.315.426.6.59 1.025.59.384 0 .803.206 1.208.593.513.489.785.592 1.566.592 1.099 0 1.79.226 2.324.761.329.329.786.399 3.317.51 1.614.071 3.513.266 4.219.432 3.236.761 6.737.796 8.866.088.765-.255 1.983-.407 3.922-.491 2.74-.119 3.805-.31 3.805-.683 0-.299 1.169-.617 2.268-.617.889 0 1.094-.078 1.552-.592.369-.414.71-.593 1.132-.593.709 0 1.364-.312 1.725-.821.15-.211.5-.364.833-.364.394 0 .793-.218 1.267-.691.416-.417.885-.692 1.178-.692.316 0 .635-.208.909-.592.232-.326.534-.593.672-.593s.485-.244.772-.543c.288-.299.969-.943 1.515-1.431.545-.488.991-.978.991-1.088 0-.111.173-.309.383-.44.211-.132.532-.553.714-.936.182-.384.448-.698.592-.698.266 0 .358-.209.583-1.327.07-.35.338-.794.596-.988.385-.289.507-.642.688-1.991.134-1.002.407-1.993.702-2.548.736-1.383.65-7.368-.105-7.368-.221 0-.366-.456-.599-1.891-.121-.74-.351-1.317-.659-1.649-.26-.28-.533-.763-.607-1.073-.074-.318-.299-.608-.512-.664a.796.796 0 01-.5-.478c-.066-.208-.358-.529-.649-.713a6.244 6.244 0 01-.963-.785c-.239-.248-.621-.451-.848-.451-.228 0-.642-.228-.921-.507-.604-.604-1.253-.875-2.092-.875-.363 0-.807-.179-1.079-.435-.399-.374-.849-.469-3.258-.682-1.947-.173-3.086-.373-3.75-.659-.902-.388-1.452-.418-10.001-.552l-9.047-.141-.616-.519c-.378-.319-.984-.573-1.568-.659-.644-.094-1.121-.31-1.474-.666a9.134 9.134 0 00-.933-.823c-.234-.168-.521-.725-.662-1.284-.137-.543-.406-1.104-.597-1.246-.466-.345-.441-1.25.052-1.876.22-.28.532-.826.694-1.212.161-.387.409-.703.551-.703.141 0 .544-.324.895-.72l.637-.72 1.621.12c.932.069 2.084.302 2.708.549 1.686.666 8.735.688 10.118.031.663-.314 1.576-.499 3.151-.637 1.978-.174 2.268-.248 2.674-.686.317-.342.758-.532 1.449-.624.594-.079 1.089-.268 1.232-.471.276-.39 1.365-.99 1.797-.99.161 0 .346-.168.412-.374.065-.206.379-.482.698-.614.318-.132.633-.409.698-.616.066-.207.374-.507.684-.668.318-.164.593-.487.628-.738.035-.246.27-.536.522-.645.258-.111.504-.428.565-.727.099-.488.404-.894 1.112-1.476.152-.126.337-.603.41-1.06.08-.498.307-.972.567-1.182.354-.287.458-.637.564-1.904.071-.853.23-2.381.354-3.395.184-1.517.171-2.147-.075-3.556-.165-.942-.3-2.128-.3-2.636-.001-.75-.094-.997-.496-1.313-.272-.214-.551-.687-.62-1.051-.171-.903-.425-1.354-.761-1.354-.411 0-.783-1.52-.515-2.107.115-.254.326-.461.469-.461.143 0 .574-.297.959-.66.618-.583.868-.675 2.149-.794.934-.087 1.687-.282 2.12-.55.541-.334 1.101-.435 2.88-.517 2.615-.121 2.498-.003 2.505-2.516.004-1.086.095-3.042.203-4.346.233-2.803.265-2.751-1.788-2.923-.766-.064-1.669-.255-2.008-.424-.771-.384-1.493-.36-3.123.107M347.2 74.384c.63.17 2.05.371 3.155.445 1.665.112 2.089.208 2.469.559.253.233.963.527 1.579.652.644.131 1.167.353 1.232.524.062.162.504.468.981.68.477.211 1.014.606 1.192.878.179.273.502.495.719.495.226 0 .488.205.613.479.12.263.428.531.684.596a.842.842 0 01.589.607c.068.27.25.491.405.491.155 0 .467.314.693.697.226.383.578.786.783.895.205.11.373.323.373.473 0 .15.303.56.674.91.384.362.727.914.796 1.28.068.362.323.778.582.947.303.199.504.575.588 1.099.072.452.331.992.598 1.248.331.317.535.833.688 1.735.121.711.354 1.384.524 1.509.436.321.685 1.351.685 2.836 0 .706.138 1.907.306 2.667.78 3.532.782 4.891.008 8.297-.172.76-.314 2.05-.314 2.865 0 1.659-.232 2.698-.679 3.033-.171.129-.4.857-.538 1.707-.188 1.169-.356 1.601-.795 2.048-.416.424-.555.759-.555 1.332 0 .601-.127.878-.593 1.293-.38.338-.593.718-.593 1.057 0 .338-.25.788-.691 1.242-.38.391-.691.847-.691 1.013 0 .166-.214.442-.475.613-.262.171-.53.527-.596.791-.273 1.087-4.576 5.249-5.726 5.537-.274.069-.549.285-.61.48-.067.211-.528.491-1.138.69-.563.184-1.136.495-1.273.691-.161.23-.717.437-1.563.585-.894.156-1.419.359-1.644.637-.758.935-15.244.964-16 .031-.179-.221-.811-.523-1.403-.67-.64-.159-1.394-.532-1.855-.918-1.46-1.223-1.396-1.814-1.396 12.899 0 10.774-.048 13.112-.271 13.382-.239.289-.831.328-4.943.328h-4.672l-.736-.607c-.832-.685-.941-1.292-.405-2.257.99-1.784.958-62.024-.034-63.886-.293-.55-.402-1.495-.583-5.051-.205-4.033-.257-4.418-.66-4.931-.311-.395-.437-.825-.437-1.486 0-1.481.305-1.641 3.419-1.801 2.131-.109 2.758-.212 3.442-.569 2.705-1.41 4.402-.464 4.587 2.556.134 2.205.342 2.466 1.15 1.446.331-.419.854-.891 1.163-1.05.308-.159.676-.445.818-.635.142-.19.465-.346.717-.346.253 0 .72-.267 1.039-.592.428-.438.883-.649 1.744-.808.695-.129 1.394-.408 1.731-.692.509-.428.75-.476 2.394-.476 1.847 0 4.008-.308 4.354-.62.312-.282 3.172-.191 4.395.14m-262.403 1.06c-.458.075-1.006.293-1.218.486-.213.192-.994.453-1.736.581-1.023.175-1.479.363-1.883.774-.294.298-.665.542-.824.542-.159 0-.577.305-.928.678-.352.372-.848.73-1.103.794-.288.072-.463.262-.463.502 0 .23-.241.511-.593.693-.326.168-.592.43-.592.581 0 .602-.719 1.475-1.516 1.842-1.215.559-1.54.209-1.727-1.861-.077-.852-.313-1.939-.523-2.414-.21-.476-.382-1.065-.382-1.31 0-.806-.301-.861-3.963-.72-2.95.113-3.555.19-4.049.514-.422.277-1.041.404-2.26.466-.923.046-1.78.166-1.904.265-.365.292-.118 4.293.304 4.908.679.992.79 1.705.864 5.531.06 3.119.142 4.021.429 4.741.701 1.755.946 20.265.303 22.815-.668 2.649-1.082 11.738-.593 13.024l.192.507h12.644l.114-.451c.062-.248.13-8.205.151-17.682l.039-17.23.521-.442c.287-.243.617-.734.733-1.09.116-.356.482-.875.812-1.153.331-.278.601-.63.601-.781 0-.151.372-.464.826-.696.454-.231.965-.576 1.136-.766.17-.19.843-.466 1.495-.613.657-.148 1.32-.433 1.489-.639.599-.734 6.621-.708 7.426.032.381.35 2.088.819 2.979.819.571 0 1.028-.487 1.038-1.105.003-.228.184-.619.401-.87.255-.293.397-.743.399-1.265.008-1.67.358-3.316.806-3.793.428-.456.976-4.479.654-4.804-.062-.062-.865-.214-1.785-.338-1.018-.136-1.816-.354-2.038-.555-.645-.584-4.112-.869-6.276-.517m28.359 1.174c-2.28.097-2.97.192-3.259.448-.441.392-3.677.869-4.732.697-1.018-.165-1.534.146-1.362.821.073.29.204 2.047.29 3.906.115 2.477.237 3.505.458 3.852.789 1.235 1.092 37.425.341 40.732-.242 1.068-.232 1.184.137 1.679l.396.531 6.349.052 6.349.052.022-.546c.037-.906-.05-1.521-.247-1.762-.863-1.053-.806-47.337.061-49.511.408-1.022-.216-1.146-4.803-.951m42.855 6.286c.314.231 1 .485 1.526.564.579.087 1.131.318 1.398.584.242.243.719.539 1.06.657.837.292 2.758 2.289 2.904 3.019.064.32.285.701.491.845 1.048.734 1.112 9.468.072 9.867-.156.06-.464.462-.684.894-.221.432-.576.841-.789.909a.889.889 0 00-.514.519c-.069.218-.43.541-.801.718-.37.177-.674.388-.674.468 0 .355-.641.73-1.453.852-.51.077-1.094.331-1.389.604-1.048.971-6.254 1.007-7.142.05-.325-.351-.703-.54-1.076-.54-.787 0-1.529-.368-1.646-.815a.516.516 0 00-.469-.371c-.419 0-2.232-1.556-2.232-1.917 0-.128-.178-.358-.396-.51-.217-.152-.517-.682-.666-1.178-.149-.495-.46-1.104-.691-1.352-.695-.746-.638-6.283.074-7.128.271-.323.55-.942.62-1.375.083-.52.285-.893.592-1.094.257-.168.467-.433.467-.589 0-.155.266-.434.591-.619.325-.185.592-.446.593-.581 0-.134.297-.368.659-.519a4.368 4.368 0 001.177-.793c.346-.347.732-.518 1.168-.52.358-.002.873-.133 1.145-.291 1.464-.854 1.66-.899 3.597-.839 1.589.049 2.017.132 2.488.481m182.172.043c-.483.083-.912.253-.953.377-.09.269-1.103.543-2.677.724-.86.099-1.255.251-1.558.6-.224.258-.649.521-.945.586-.296.065-.783.374-1.082.687-.3.313-.802.675-1.115.805-.313.129-.569.328-.569.441 0 .113-.279.64-.619 1.171l-.62.965.22 1.818c.12.999.306 2.395.413 3.101.107.706.239 6.953.293 13.881.101 13.008.1 12.983.693 12.983.195 0 .678.257 1.073.57.42.334 1.079.625 1.589.701.495.074 1.087.331 1.371.594 1.042.965 11.577.968 12.584.003.276-.265.899-.557 1.383-.649a3.193 3.193 0 001.542-.792c.365-.343.833-.624 1.041-.624.21 0 .477-.216.599-.484.122-.266.475-.573.786-.681.318-.111.566-.342.566-.527 0-.182.276-.645.613-1.029.338-.384.7-.946.805-1.248.105-.301.407-.69.67-.862.36-.235.479-.491.479-1.02 0-.524.148-.844.569-1.238.47-.439.591-.75.703-1.807.139-1.318.447-2.363.696-2.363.442 0 .6-1.858.6-7.056 0-5.184-.136-6.772-.58-6.772-.252 0-.605-.976-.605-1.675 0-.874-.32-1.692-.791-2.022-.208-.145-.438-.595-.51-1-.073-.409-.378-.981-.688-1.29-.306-.306-.657-.862-.78-1.235-.124-.375-.358-.679-.523-.679-.164 0-.397-.263-.519-.585-.122-.324-.459-.684-.754-.807-.293-.121-.576-.384-.628-.584-.057-.217-.398-.447-.847-.571-.413-.114-.934-.429-1.158-.701-.31-.376-.708-.541-1.671-.691-.849-.132-1.423-.345-1.745-.647-.519-.488-5.279-.727-7.351-.368m-178.164 48.189c3.117.135 3.522.193 3.913.557.426.397 1.355.646 2.424.651.319.001.675.187.896.469.202.257.653.614 1.002.795.349.18.635.443.635.583 0 .14.298.519.662.841.519.46.694.8.804 1.568.078.539.257 1.38.398 1.869.207.719.209 1.078.009 1.877-.136.543-.31 1.51-.386 2.149-.1.832-.266 1.28-.588 1.58-.247.23-.511.616-.587.857-.076.242-.499.775-.941 1.186-.443.41-1 .936-1.24 1.167-.24.231-.651.483-.913.56-.263.077-.657.353-.877.613-.265.314-.753.54-1.448.672-.665.126-1.176.356-1.397.629-.295.365-.644.454-2.305.589-2.108.171-3.025.33-3.344.579-.902.705-5.278.63-6.764-.116-.391-.197-1.384-.369-2.526-.437-1.639-.098-1.937-.172-2.318-.576-.24-.256-.792-.562-1.227-.681-.434-.119-1.073-.497-1.42-.84-.675-.667-.98-.971-1.987-1.982-.489-.491-.642-.816-.642-1.364 0-.518-.166-.909-.593-1.395l-.592-.675v-3.049c0-2.998.008-3.057.488-3.474.269-.234.536-.65.593-.925l.203-.98c.055-.264.261-.532.458-.595.198-.062.507-.424.688-.803.181-.379.46-.689.621-.689.161 0 .397-.2.524-.445.307-.59.254-.548 1.02-.811.738-.254 10.455-.227 16.757.046M1.706 168.988c-.161.419-.166 14.412-.006 14.572.685.685.77-.175.723-7.32-.047-6.943-.208-8.578-.717-7.252m86.211.069c-.305.571-.295 14.091.011 14.397.679.679.764-.121.757-7.193-.006-7.116-.141-8.376-.768-7.204m-77.968.052c-.343.097-.662.34-.716.547-.054.205-.348.494-.654.643-.395.191-.653.551-.891 1.243-.184.536-.501 1.095-.703 1.243-.599.438-.551 5.748.058 6.408.234.254.517.801.63 1.217.231.851 1.435 2.109 2.02 2.109.242 0 .381.136.381.373 0 .494.378.618 2.29.753 2.004.142 3.636-.196 3.636-.751 0-.261.14-.375.457-.375.439 0 1.508-.976 2.055-1.877.356-.588.311-1.417-.087-1.57-.382-.146-.845.348-.845.903 0 .19-.508.861-1.129 1.492l-1.129 1.147-1.445.073c-2.194.111-3.543-.105-3.669-.587-.056-.217-.376-.497-.709-.623-.507-.191-.658-.41-.918-1.322-.171-.601-.461-1.208-.644-1.349-.482-.37-.497-5.285-.017-5.637.174-.127.44-.585.593-1.018.326-.925 1.554-2.271 2.081-2.281.478-.01 1.364-.5 1.136-.629-.412-.235-1.206-.294-1.781-.132m5.003-.084c-.558.148-.284.531.577.808.574.185.843.41 1.005.84.122.322.341.587.486.588.145 0 .417.269.604.598.295.518.389.565.717.36.48-.299.193-1.113-.619-1.751-.295-.233-.537-.546-.537-.698 0-.479-1.431-.957-2.233-.745m6.688.203c-.165.432.354.542 2.264.478 2.755-.091 2.549-.658 2.612 7.195.051 6.357.061 6.506.447 6.506s.396-.147.444-6.518c.058-7.813-.179-7.21 2.825-7.21 1.789 0 2.481-.175 1.961-.497-.415-.256-10.453-.213-10.553.046m22.49-.066c-.222.576.027.953.806 1.22.929.319 1.14.174 1.054-.727-.073-.757-1.603-1.162-1.86-.493m85.13.014c-.177.462.194.795.489.439.179-.216.165-.334-.065-.525-.242-.2-.32-.185-.424.086m37.95-.115c-.327.069-.674.309-.773.534-.099.226-.432.555-.741.732-.308.176-.56.478-.56.669 0 .191-.224.528-.497.75-1.061.859-1.074 7.52-.016 8.501.255.236.575.737.711 1.111.189.524.446.765 1.11 1.04.476.196.865.442.865.545 0 1.062 5.577.966 5.987-.102.06-.157.39-.347.734-.422.456-.101.697-.312.895-.785.148-.356.403-.699.566-.761.296-.114.721-1.285.567-1.564-.191-.348-.868-.121-1.048.35-.104.275-.316.548-.47.607-.155.06-.389.368-.521.686-.132.319-.315.579-.407.579-.091 0-.439.267-.772.592-.886.866-5.334.861-5.334-.006 0-.211-.235-.432-.594-.557a1.353 1.353 0 01-.803-.76 3.675 3.675 0 00-.641-1.013c-.4-.427-.436-.691-.497-3.676l-.066-3.215.511-.551c.28-.303.51-.661.51-.795 0-.324 1.503-1.673 1.864-1.673.817 0 1.41-.414 1.012-.707-.405-.296-.632-.312-1.592-.109m5.037-.03c-.9.162-.814.378.303.758.846.287 1.172.514 1.395.972.482.991.802 1.305 1.371 1.347.753.056.795-.279.122-.983-.314-.329-.649-.723-.745-.877-.275-.441-1.465-1.362-1.721-1.332a17.77 17.77 0 00-.725.115m-48.072.407c-.064.103-.175.711-.247 1.35-.154 1.378-.334 1.784-.866 1.953-.548.174-.494.654.103.927.653.297.665.382.743 4.999.081 4.854.428 5.562 2.332 4.761l.592-.249-.811-.366c-1.152-.519-1.181-.642-1.181-4.884 0-3.933.068-4.299.805-4.299.789 0 .792-.525.005-.88l-.768-.346-.077-1.359c-.073-1.283-.366-2.034-.63-1.607m80 0c-.064.103-.175.711-.247 1.35-.154 1.378-.334 1.784-.866 1.953-.565.179-.489.598.197 1.086l.593.422.001 3.789c.001 5.249.429 6.213 2.387 5.39l.592-.249-.811-.366c-1.152-.519-1.181-.642-1.181-4.884 0-3.933.068-4.299.805-4.299.789 0 .792-.525.005-.88l-.768-.346-.077-1.359c-.073-1.283-.366-2.034-.63-1.607m-161.298 2.184c-.281.68-.203 2.44.113 2.544.548.181.908-2.459.393-2.886-.214-.178-.319-.107-.506.342m3.674-.231c-.399.399.114 3.029.591 3.029.332 0 .363-1.636.049-2.539-.215-.615-.384-.745-.64-.49m21.603 1.411c-1.081.061-1.586.285-1.586.704 0 .284 4.594.267 4.689-.018.175-.525-1.072-.801-3.103-.686m39.251.044c-.846.148-1.031.273-.845.573.195.316 2.187.264 2.459-.064.318-.383-.627-.681-1.614-.509m6.965-.006c-1.093.084-1.292.157-1.341.493-.054.378.039.393 2.105.334 1.821-.052 2.203-.01 2.427.266.147.179.458.52.692.758.544.55.589.833.292 1.803-.197.644-.19.987.042 1.858.326 1.221.186 1.866-.641 2.962-.495.655-.498.677-.12.889.213.119.669.513 1.013.874.902.949.954.708.887-4.094-.064-4.615-.072-4.676-.626-4.821-.209-.054-.468-.332-.576-.617-.108-.285-.31-.554-.447-.598-.471-.149-2.423-.206-3.707-.107m23.013-.052c-1.152.119-1.497.265-1.705.721-.116.253-.502.6-.858.77-.801.382-.885.769-.886 4.091 0 2.746.212 3.753.791 3.753.206 0 .569.263.806.584.702.95 2.741 1.32 4.291.78 1.355-.472.753-.771-1.555-.771-2.121 0-2.183-.012-2.359-.477-.1-.262-.348-.53-.552-.594-.973-.309-.939-6.057.04-6.929.244-.217.499-.551.567-.741.107-.299.401-.345 2.21-.345 1.808 0 2.103.046 2.209.345.068.19.333.524.589.741.614.522.938 2.88.66 4.805a35.617 35.617 0 00-.195 1.476c-.002.087-.234.371-.516.632-.666.617-.484.895.405.617.947-.297 1.661-3.305.897-3.777-.133-.082-.133-.245 0-.493.593-1.109.085-3.648-.764-3.818a1.13 1.13 0 01-.772-.609c-.125-.276-.431-.542-.679-.593-.75-.153-1.996-.233-2.624-.168m12.444.031c-1.456.22-1.013.696.765.822 1.908.135 2.449.75 2.509 2.853l.018.592.271-.592c.773-1.69-.092-3.654-1.609-3.654-.351 0-.756-.032-.901-.07-.144-.039-.618-.016-1.053.049m32.889-.027c-2.305.276-1.918.838.576.838 1.078 0 2.1.054 2.272.12.225.086.313.001.313-.303 0-.232-.112-.458-.247-.501-.369-.117-2.348-.221-2.914-.154m-127.253.964c-1.484 1.303-1.585 1.631-1.506 4.872.066 2.653.083 2.753.562 3.121 1.346 1.036 1.253.993 1.434.67.211-.376.035-.668-.534-.884-.907-.344-.886-6.388.022-6.733.257-.098.552-.401.656-.675.295-.776 3.857-.774 4.152.002.22.578.635.791 1.068.549.252-.141.174-.312-.459-1.004l-.763-.834h-3.588l-1.044.916m22.163-.615c-.368.443-.286.463 2.141.501 2.356.038 2.612-.02 2.212-.501-.192-.233-.691-.301-2.177-.301-1.485 0-1.984.068-2.176.301m16.632-.048c-.422.509.081.635 2.285.574 2.152-.06 2.888-.332 1.91-.708-.62-.237-3.976-.131-4.195.134m9.972-.122c-.203.203-.156 10.299.048 10.425.697.431.808-.067.809-3.615.001-3.357.019-3.514.488-4.275.55-.892.636-1.481.216-1.481-.155 0-.473-.267-.705-.593-.426-.599-.616-.701-.856-.461m87.309 0c-.28.28-.149 10.275.138 10.513.565.469.693-.243.755-4.197l.062-3.912.543-.395c.667-.485.682-.703.071-.981a1.62 1.62 0 01-.687-.687c-.208-.457-.61-.612-.882-.341m2.535.066c-.266.431.191.593 1.677.593 1.531 0 1.563.01 2.006.642.248.353.587.745.754.872.251.191.316.912.371 4.149.067 3.851.21 4.707.704 4.212.207-.207.214-7.967.008-8.692-.046-.164-.285-.386-.529-.494-.245-.107-.476-.373-.513-.591-.136-.803-4.036-1.406-4.478-.691m17.333-.067c-.915.37-.134.639 2.025.697 2.001.054 2.272.023 2.272-.263-.001-.512-3.282-.843-4.297-.434m10.157.001c-.241.241-.153 10.238.092 10.483.615.614.764-.219.764-4.265v-3.95l.539-.424.539-.424-.417-.331a2.856 2.856 0 01-.645-.776c-.223-.435-.611-.574-.872-.313m2.436.238c0 .503 1.508.775 1.934.349.453-.453.098-.718-.958-.718-.822 0-.976.058-.976.369m-94.625-.123c-.209 1.391-.032 10.223.205 10.223.257 0 .289-.678.241-5.136-.034-3.139-.13-5.136-.247-5.136-.105 0-.195.022-.199.049m17.122 1.284c-.278 2.869-.049 9.037.335 9.037.34 0 .366-.264.399-4.082.032-3.66.073-4.124.4-4.485.356-.392.353-.417-.102-.993-.69-.872-.908-.762-1.032.523m-69.948-.293c-.166.237-.302.544-.302.683s-.168.252-.374.252c-.573 0-.969 4.639-.497 5.82.215.537 1.508 1.883 1.809 1.884.136 0 .247.119.247.265 0 .944 4.563.974 4.699.03.054-.378-.039-.391-2.321-.324l-2.378.071v-.524c0-.371-.167-.62-.571-.852-.719-.412-.999-1.808-.512-2.551.297-.454.356-.461 3.804-.464 3.806-.003 4.229-.09 3.75-.773-.2-.286-.266-.705-.2-1.282.138-1.225-.259-2.328-.808-2.249-.47.067-.473.133-.102 1.798.4 1.793.376 1.808-3.084 1.873-3.44.064-3.462.054-3.462-1.561 0-.986.053-1.161.355-1.161.448 0 .83-.372.83-.808 0-.529-.547-.607-.883-.127m133.728 0c-.166.237-.302.523-.302.636 0 .113-.2.293-.444.401-.878.385-.707 6.417.181 6.417.145 0 .263.119.263.266 0 .415.663.922.963.737.397-.245.182-.871-.395-1.148-.662-.317-.94-1.83-.468-2.551.291-.444.389-.457 3.803-.509l3.505-.054.057-1.284c.089-2.013-.149-2.851-.833-2.93-.509-.059-.549-.021-.418.395.985 3.136.821 3.325-2.885 3.325h-2.943l-.193-.507c-.32-.842-.246-2.259.118-2.259.39 0 .874-.472.874-.853 0-.491-.56-.543-.883-.082m-138.877-.04c-.143.231.268 1.37.493 1.37.079 0 .24-.213.359-.474.291-.64-.497-1.47-.852-.896m27.64.071c-.126.33.244 1.102.529 1.102.322 0 .428-.532.192-.972-.254-.476-.566-.532-.721-.13m81.345-.044c-.13.131-.237.439-.237.685 0 .294-.091.413-.265.347-.53-.204-.779.503-.859 2.44-.1 2.434.058 3.616.5 3.732.183.048.483.349.667.669.331.577.813.758 1.04.39.153-.248-.462-1.191-.776-1.191-.345 0-.69-1.648-.44-2.106.34-.622.535-.654 4.117-.657 1.92-.001 3.631-.057 3.802-.123.502-.192.432-1.657-.078-1.657-.421 0-.554-.348-.643-1.678-.039-.586-.146-.806-.419-.858-.592-.112-.763.235-.43.872.165.318.355.866.422 1.219.067.353.201.642.296.642.096 0-.019.222-.255.494-.493.567-5.915.783-6.442.257-.422-.423-.304-2.351.152-2.47.414-.108.705-.714.501-1.045-.163-.263-.363-.251-.653.038m-115.109.504c-.063.299-.146.7-.184.892-.166.838.548 1.031.828.223.145-.418.35-.846.455-.952.38-.379.196-.706-.396-.706-.483 0-.609.097-.703.543m27.565-.249c-.154.185-.196.547-.115.981.14.747.509 1.147.509.552 0-.203.13-.542.29-.753.623-.824-.029-1.569-.684-.78m18.804-.047c-.143.173-.13.388.046.717l.251.469.325-.464c.566-.808-.002-1.468-.622-.722m-69.865.342c-.067.107-.203.699-.303 1.315-.109.672-.351 1.3-.603 1.568-.265.282-.522.982-.695 1.895-.151.796-.395 1.536-.54 1.645-.696.518-.974 2.017-.455 2.447.364.303.628-.049.781-1.042.065-.423.295-.933.512-1.135.216-.202.452-.701.524-1.109.286-1.63.285-1.63 3.904-1.63 3.659 0 3.805.049 4.106 1.388.109.486.374 1.071.589 1.3.215.228.444.762.509 1.185.164 1.064.375 1.292.952 1.029.367-.167.431-.298.307-.63a36.13 36.13 0 01-.408-1.203c-.138-.431-.368-.9-.511-1.044-.267-.267-.668-1.485-.67-2.036-.001-.169-.222-.607-.493-.974-.27-.366-.543-.983-.607-1.371-.358-2.175-1.204-2.569-1.008-.47.181 1.932.044 2.036-2.679 2.036-2.729 0-2.814-.064-2.621-1.981.134-1.334-.149-1.899-.591-1.183m58.624.758c-.121.074-.284.49-.362.925-.278 1.535-.148 1.481-3.547 1.481h-3.046l-.552-.692c-.944-1.183-1.245-.879-1.24 1.251.004 1.706.234 2.105.677 1.173.497-1.047.899-1.14 4.959-1.14h3.645v-1.469c0-1.461-.114-1.789-.534-1.529m-36.071 2.172c-.163.815.069 2.241.278 1.707.206-.528.21-1.711.006-2.032-.118-.187-.2-.093-.284.325m48.504.464c-.618.618-.291.802 1.188.668 2.006-.181 2.551-.307 2.463-.571-.109-.33-3.332-.416-3.651-.097m-1.184 1.004c-.364.453-.412 2.753-.072 3.473.522 1.108 3.233 1.67 4.544.944.693-.384.243-.561-1.623-.639-1.767-.074-1.972-.193-2.279-1.335-.16-.599-.141-.923.088-1.471.421-1.008-.059-1.717-.658-.972m-46.336 1.268c-.165.164-.173 1.31-.012 1.729.121.316 1.065.449 1.065.15 0-.09-.141-.579-.314-1.087-.306-.896-.465-1.066-.739-.792m-3.845.303a.893.893 0 00-.237.545c0 .17-.2.397-.445.504-.244.107-.473.395-.507.64-.061.428-.138.444-2.124.444-1.59 0-2.06.06-2.06.265 0 .625 2.647 1.011 3.565.52.668-.358 2.558-2.423 2.558-2.795 0-.41-.398-.476-.75-.123m31.176.503c.008.944.377 1.45.947 1.301.491-.128.559-.503.153-.84-.153-.126-.332-.448-.399-.716-.199-.794-.708-.608-.701.255m-21.034.09c-.358.719-.385 1.072-.095 1.251.337.209.975-.514.975-1.103 0-.798-.512-.884-.88-.148m11.064.26c-.292.543-.323.751-.139.935.393.393.918-.09.918-.845 0-.892-.327-.929-.779-.09m103.834.007c-.486.749-.438 1.076.159 1.076.548 0 .793-.582.519-1.232l-.227-.541-.451.697m29.995-.129c-.224.316-.408.705-.408.865 0 .39-.847.537-3.087.537-1.996 0-2.458.293-1.25.794 1.208.5 4.337.055 4.337-.618 0-.228.138-.373.355-.373.536 0 .83-.4.83-1.126 0-.804-.243-.829-.777-.079m-117.301.266c-.11.136-.234.425-.275.642-.069.369-.23.395-2.399.395-2.21 0-2.322.02-2.268.394.087.601 3.199.981 4.098.5.88-.471 1.822-1.6 1.579-1.892-.29-.35-.474-.36-.735-.039m53.888.988c-.005.53.077.741.289.741.363 0 .363.001.007-.817l-.288-.665-.008.741m-84.436.148c-2.833.143-2.842.715-.016.925 1.47.109 2.469-.135 2.469-.603 0-.399-.257-.433-2.453-.322m112.882-.033c-.113.036-.207.183-.207.326 0 .927 4.564.92 4.699-.007.053-.362-3.551-.618-4.492-.319"
        ></path>
       
        <path
          fill="#868694"
          d="M299.457.395c0 .243-.133.397-.346.399-1.153.015-4.447.586-5.01.869-.368.185-1.422.423-2.341.529-2.044.235-2.408.311-3.661.769-.543.198-1.781.463-2.751.589-.97.125-2.098.389-2.507.587-.408.197-1.659.472-2.779.61-1.121.138-2.603.46-3.295.715-.692.255-1.598.464-2.012.464-.96 0-3.397.509-4.096.856-.295.146-1.424.378-2.511.515-1.086.137-2.325.418-2.753.624-.428.206-.917.376-1.086.376-.688.003-1.767.427-2.268.89-.292.271-.637.493-.767.495-.13.001-.63.357-1.11.79-.48.433-.985.787-1.122.787-.138 0-.306.178-.375.395-.069.217-.343.449-.609.516-.266.067-.642.322-.834.566-.193.245-.54.506-.771.579-.232.074-.757.441-1.167.817-.41.375-.818.683-.907.683-.088 0-.439.266-.78.592-.342.326-.74.593-.886.593-.146 0-.377.185-.514.411-.137.227-.602.594-1.034.817-.431.223-1.025.638-1.318.922-.848.822-1.882 1.603-2.122 1.603-.122 0-.406.212-.631.471-.225.259-.756.627-1.179.818-.424.191-.82.503-.88.693-.06.19-.363.451-.673.579-.309.128-.75.449-.98.713-.229.263-.535.479-.68.479-.144 0-.477.228-.739.507a4.497 4.497 0 01-1.127.816c-.359.17-.741.475-.85.679-.109.203-.506.498-.882.655-.376.157-.684.378-.684.49 0 .112-.334.373-.741.581-.407.208-.903.557-1.101.776-.198.219-.617.505-.931.635-.315.13-.622.396-.684.59-.062.193-.365.457-.675.585-.309.129-.75.449-.98.713-.229.264-.534.479-.677.479-.144 0-.51.261-.815.579-.304.318-.799.68-1.1.804-.343.142-.682.532-.913 1.051-.203.454-.512.959-.688 1.122-.176.163-.438.607-.582.988-.144.38-.467.966-.718 1.302-.252.336-.457.755-.457.932 0 .176-.254.612-.564.969-.311.356-.673.981-.805 1.388-.133.406-.355.806-.496.889-.301.177-.9 1.298-.9 1.685 0 .15-.213.471-.472.715-.26.244-.52.684-.579.978-.059.293-.38.877-.713 1.297-.334.42-.607.929-.607 1.132 0 .203-.209.552-.466.775-.256.222-.586.777-.733 1.233-.147.455-.413.934-.59 1.065-.177.13-.484.663-.682 1.185-.198.521-.507 1.053-.686 1.181-.179.128-.45.61-.602 1.071-.152.461-.48 1.041-.728 1.289s-.451.626-.451.84c0 .214-.212.641-.471.949-.259.308-.61.89-.778 1.294-.169.404-.477.917-.684 1.14-.208.222-.496.762-.64 1.199-.144.437-.373.857-.509.933-.137.076-.429.562-.651 1.078-.221.517-.573 1.123-.782 1.347a2.3 2.3 0 00-.486.94c-.058.293-.302.753-.541 1.023a5.012 5.012 0 00-.703 1.121 9.383 9.383 0 01-.73 1.309c-.378.557-.506 1.141-.707 3.211-.135 1.391-.323 2.675-.418 2.853-.095.178-.267 1.428-.383 2.778l-.495 5.812c-.157 1.847-.411 4.025-.565 4.84-.154.814-.394 3.392-.533 5.728s-.334 4.514-.434 4.84c-.277.903-.741 4.962-.745 6.518-.002.761-.104 2.349-.227 3.529-.226 2.157-.205 2.405.432 5.23.107.472.315.978.462 1.126.147.147.378.872.512 1.611s.419 1.651.634 2.026c.214.376.512 1.32.661 2.099.149.778.455 1.728.681 2.11.225.383.493 1.204.594 1.826.101.622.362 1.498.579 1.947.217.449.518 1.408.67 2.131.151.722.457 1.611.681 1.975.223.364.464 1.106.536 1.649.148 1.123.465 2.057.822 2.422.134.138.301.671.37 1.186.164 1.212.476 2.242.791 2.615.138.163.352.829.476 1.481.371 1.948.397 2.035.691 2.329.156.155.387.851.514 1.545s.489 1.795.804 2.447c.315.652.572 1.419.572 1.704 0 .957.232 1.693.71 2.249.262.304.475.63.475.725 0 .181.862 1.187 1.899 2.217.339.336.72.811.847 1.056.127.244.35.444.496.444.146 0 .375.264.509.586.133.322.411.64.618.705.207.066.509.378.672.693.163.315.473.667.69.783.216.115.393.338.393.495 0 .156.218.428.485.602.267.175.645.565.839.867.411.636 2.429 2.95 3.367 3.86.353.342.642.729.642.859 0 .131.216.336.48.456.265.121.587.475.716.786.129.312.354.567.5.567.146 0 .367.2.491.445.217.426.458.712 1.699 2.019.307.324.692.781.856 1.018.367.531 3.326 3.883 4.69 5.314.353.37.642.759.642.863 0 .105.168.245.374.31.205.065.478.371.606.679.127.308.448.659.712.779.265.121.481.332.481.47 0 .138.267.518.592.844.326.326 1.204 1.224 1.95 1.995 1.095 1.132 1.507 1.427 2.128 1.526.424.068 1.065.341 1.426.607.36.266 1.091.588 1.625.716s.97.31.97.405c0 .246.96.7 1.8.852.393.071.864.295 1.047.497.183.203.751.486 1.262.629.51.142 1.233.466 1.605.719.372.252.906.505 1.185.561.28.057.731.229 1.002.384.935.533 1.681.863 2.186.968.279.058.702.274.939.481.238.206.855.488 1.37.627.516.139 1.115.4 1.333.58.504.419 1.394.799 1.87.799.204 0 .625.213.935.474.31.261.941.576 1.402.7a6.028 6.028 0 011.518.688c.375.254 1.013.524 1.42.6.406.076.993.354 1.305.616.313.263.93.535 1.373.606.442.071.962.286 1.155.479.467.468.933.693 1.753.849.375.071.866.303 1.091.514.225.212.896.509 1.491.661.694.178 1.105.393 1.146.6.077.391.825.438.825.052 0-.406-.372-.633-1.62-.991-.619-.177-1.181-.412-1.248-.521-.15-.242-1.414-.784-1.829-.784-.167 0-.596-.224-.955-.497-.358-.273-.944-.553-1.302-.621-.358-.068-1.002-.378-1.431-.688-.429-.311-.944-.564-1.146-.564-.364 0-1.54-.53-1.729-.778-.054-.072-.498-.245-.987-.384s-1.2-.462-1.581-.716a6 6 0 00-1.505-.676c-.447-.117-1.053-.401-1.345-.631-.292-.23-.877-.496-1.299-.591-.422-.095-1.086-.389-1.476-.653-.39-.265-.985-.542-1.322-.616-.337-.074-1.019-.392-1.514-.706-.495-.313-1.057-.57-1.249-.57-.193 0-.756-.258-1.251-.572-.496-.314-1.213-.63-1.594-.702-.38-.071-1.003-.341-1.383-.599-.381-.258-.968-.53-1.305-.604-.338-.074-1.019-.392-1.514-.706-.495-.314-1.093-.57-1.329-.57-.235 0-.66-.183-.943-.406-.284-.223-.94-.547-1.459-.72-1.196-.398-2.136-1.08-3.217-2.331a29.487 29.487 0 00-1.364-1.482c-.466-.451-1.972-2.144-3.474-3.907-1.122-1.318-1.779-2.066-2.271-2.59-.272-.289-.837-.95-1.257-1.469-.694-.858-1.706-1.97-3-3.295-.266-.273-.484-.548-.484-.612 0-.064-.527-.685-1.171-1.381-1.309-1.414-1.718-1.879-3.888-4.425-.834-.978-1.963-2.237-2.509-2.8-.546-.562-1.062-1.146-1.147-1.298-.085-.152-.67-.827-1.3-1.499a80.66 80.66 0 01-1.837-2.025c-.38-.441-.852-.952-1.048-1.133-.765-.71-1.891-3.093-2.11-4.466-.12-.748-.386-1.596-.592-1.885-.206-.289-.48-1.142-.61-1.895-.129-.753-.394-1.594-.587-1.87-.194-.275-.481-1.122-.638-1.883-.158-.76-.433-1.665-.611-2.01-.179-.345-.461-1.273-.627-2.062-.166-.789-.463-1.709-.66-2.043-.197-.334-.473-1.226-.614-1.981-.14-.754-.412-1.597-.605-1.872-.193-.276-.484-1.147-.647-1.936-.164-.79-.443-1.658-.622-1.93-.178-.272-.448-1.145-.6-1.941-.153-.795-.452-1.746-.665-2.112-.213-.367-.497-1.245-.63-1.951-.133-.707-.453-1.707-.71-2.224-.258-.517-.524-1.361-.592-1.876-.068-.516-.32-1.337-.56-1.826-.977-1.987-.935-7.472.103-13.358.215-1.219.393-2.957.397-3.861.007-1.941.42-5.936.844-8.164.165-.869.4-3.358.523-5.531.129-2.277.39-4.758.616-5.855.216-1.048.461-3.202.545-4.787.13-2.487.209-2.959.572-3.451.232-.313.56-.901.729-1.305.169-.405.523-.993.787-1.306.264-.314.54-.843.613-1.177.073-.334.303-.713.51-.842.208-.13.515-.649.682-1.153.168-.504.479-1.074.692-1.267.212-.193.387-.456.387-.586 0-.311.569-1.443.797-1.584.098-.061.345-.485.548-.942.202-.457.515-.953.695-1.101.18-.149.42-.615.533-1.036.114-.421.415-.966.67-1.212.255-.245.576-.797.713-1.227.137-.43.402-.919.588-1.087.187-.167.457-.615.6-.995.144-.381.467-.943.719-1.25.252-.307.458-.709.458-.893 0-.185.253-.644.563-1.022.309-.378.668-1.01.797-1.404.129-.394.406-.872.615-1.061.209-.189.485-.667.614-1.061.128-.394.443-.968.698-1.275.256-.307.466-.663.466-.79.001-.128.201-.538.445-.913a37.477 37.477 0 002.027-3.513c.284-.568.604-1.087.711-1.154.108-.066.403-.59.657-1.163.254-.574.558-1.103.675-1.176.118-.072.387-.522.598-.999.232-.525.609-.983.958-1.164.317-.163.862-.565 1.213-.893.35-.327.81-.65 1.022-.717.212-.067.385-.204.385-.304s.333-.404.741-.675a64.816 64.816 0 001.827-1.289c.597-.438 1.397-1.018 1.778-1.289a56.58 56.58 0 001.58-1.181 33.903 33.903 0 011.679-1.213c.435-.288.861-.644.948-.791.087-.147.415-.4.73-.563a6.118 6.118 0 001.106-.79c.293-.272.621-.494.728-.494.107 0 .338-.164.514-.364.176-.201.675-.601 1.11-.89.434-.29 1.19-.836 1.679-1.216a52.62 52.62 0 013.153-2.277c.486-.325.957-.724 1.048-.886.091-.163.516-.475.945-.694.429-.219.78-.474.78-.567 0-.093.256-.276.569-.406.313-.129.819-.496 1.123-.814.305-.318.638-.578.74-.578.103 0 .508-.272.902-.605a38.755 38.755 0 013.389-2.555c.567-.381 1.279-.938 1.582-1.238.436-.433.832-.584 1.901-.727.742-.099 1.879-.371 2.527-.606.648-.234 1.892-.503 2.765-.598.874-.095 2.21-.397 2.971-.671.76-.274 1.712-.5 2.114-.502.853-.005 2.65-.342 3.219-.605.631-.291 2.045-.578 3.822-.775.907-.101 1.84-.307 2.074-.458.593-.382 1.173-.522 2.993-.723.869-.096 2.247-.397 3.062-.669.815-.271 2.059-.541 2.765-.599.706-.058 1.966-.329 2.799-.602.834-.274 2.123-.55 2.865-.614 2.051-.178 3.028-.471 3.028-.911 0-.306-.153-.369-.889-.369-.758 0-.889.059-.889.395m4.938-.015c0 .485.805.738 2.765.87.815.055 2.184.33 3.042.611.858.282 2.192.563 2.963.626 1.305.105 1.997.264 2.983.684.756.322 1.981.58 2.766.582.906.003 2.065.281 3.054.733.376.172 1.487.398 2.469.502.982.103 2.426.397 3.21.651.784.255 1.984.521 2.667.591 1.51.156 2.608.411 3.472.807.357.164 1.379.377 2.271.473 1.686.182 2.306.334 3.542.865a4.59 4.59 0 001.518.316c.982 0 1.677.261 2.518.946l1.329 1.079c.369.299.764.543.879.543.115 0 .325.164.467.364.142.2.658.614 1.147.92.489.306 1.005.721 1.147.921.142.2.37.363.506.363.137 0 .504.267.816.593.312.326.671.592.796.592.126 0 .398.188.605.416.207.229.688.576 1.068.771.38.195.907.586 1.17.868.264.282.58.513.704.513s.48.267.793.593c.312.326.648.592.746.592.098 0 .542.312.986.692.445.38.903.691 1.02.691.117 0 .464.267.771.593.308.326.683.592.835.592.151 0 .418.219.593.486.175.268.466.534.647.591.18.057.558.318.839.579.281.261.77.609 1.086.773.317.165.791.53 1.054.812.264.282.564.512.668.512.103 0 .524.289.934.642 1.058.912 2.47 1.926 2.68 1.926.099 0 .431.267.738.593.308.326.683.593.835.593.151 0 .418.218.593.486.175.267.487.539.692.604.205.065.728.402 1.162.749.435.346 1.159.896 1.61 1.222 1.261.912 2.457 2.237 2.737 3.034.139.395.412.897.606 1.114.193.218.498.75.677 1.183.178.433.486.966.683 1.185.197.219.46.703.585 1.076.125.374.382.849.571 1.057.353.389.824 1.232 1.715 3.066.28.576.681 1.232.892 1.458.211.226.438.662.505.968.068.306.316.799.553 1.096.438.548.883 1.326 1.814 3.179.285.569.61 1.089.72 1.158.111.068.378.537.593 1.041.216.504.552 1.094.747 1.311.195.217.451.684.569 1.037.118.352.427.93.687 1.284.26.353.584.925.72 1.27s.412.776.613.959c.201.182.42.581.488.886.067.305.333.801.591 1.102.258.3.524.763.59 1.028.067.265.373.804.681 1.199.308.394.612.944.676 1.223.064.278.338.764.609 1.08.272.315.549.825.616 1.132.068.307.348.783.623 1.059.275.275.579.804.674 1.176.095.372.265 1.01.377 1.417.371 1.351.771 4.47.791 6.173.02 1.727.416 5.585.771 7.506.11.598.294 2.286.409 3.753.39 4.988.598 7.01.894 8.691.162.924.378 3.443.48 5.599.202 4.311.465 6.056.91 6.056.225 0 .282-.382.282-1.877 0-1.501-.057-1.876-.284-1.876-.343 0-.378-.269-.783-6.025-.168-2.39-.397-4.79-.51-5.333-.205-.99-.417-3.235-.81-8.593-.116-1.575-.341-3.309-.501-3.852-.161-.543-.373-2.512-.472-4.374-.262-4.918-.398-6.022-.816-6.619-.202-.289-.367-.626-.367-.751 0-.331-.577-1.391-1.009-1.855-.206-.221-.374-.555-.374-.744 0-.188-.216-.6-.481-.914-.264-.314-.631-.946-.814-1.403-.183-.458-.481-.941-.663-1.073-.182-.133-.436-.603-.566-1.044-.129-.441-.458-1.012-.732-1.269-.273-.257-.497-.654-.497-.881 0-.228-.253-.724-.562-1.102-.309-.378-.617-.915-.685-1.193-.069-.278-.351-.767-.627-1.086a3.991 3.991 0 01-.703-1.315c-.11-.404-.324-.804-.476-.889-.152-.085-.465-.593-.695-1.13-.23-.536-.592-1.097-.804-1.245-.212-.149-.386-.45-.386-.668 0-.482-.297-1.063-.8-1.566-.207-.206-.435-.622-.509-.923-.073-.302-.387-.84-.696-1.197-.31-.357-.563-.828-.563-1.046 0-.219-.205-.603-.456-.853-.251-.251-.613-.868-.806-1.372-.192-.504-.436-.969-.542-1.035-.106-.065-.397-.577-.647-1.138-.25-.56-.646-1.188-.879-1.395-.233-.207-.423-.564-.423-.794 0-.23-.254-.728-.565-1.105-.31-.378-.634-.91-.718-1.181-.085-.272-.364-.745-.621-1.053-.257-.307-.526-.796-.598-1.086-.158-.639-1.604-2.404-1.969-2.404-.144 0-.404-.219-.579-.487-.176-.267-.511-.546-.746-.62a1.924 1.924 0 01-.729-.483c-.167-.191-.67-.539-1.119-.773-.449-.234-.867-.557-.929-.719-.062-.161-.358-.4-.659-.532a4.492 4.492 0 01-1.04-.698c-.88-.821-2.456-2.009-2.664-2.009-.111 0-.453-.267-.761-.593-.307-.326-.68-.593-.827-.593-.148 0-.386-.167-.529-.371-.29-.414-2.819-2.197-3.117-2.197-.106 0-.331-.213-.502-.473-.171-.261-.573-.583-.893-.716-.321-.133-.583-.358-.583-.5 0-.143-.174-.314-.387-.382-.212-.067-.811-.473-1.329-.902-.519-.429-1.05-.78-1.179-.78-.13 0-.502-.244-.827-.543a25.037 25.037 0 00-1.447-1.196L352 15.299c-.489-.373-.978-.679-1.087-.68-.109-.001-.45-.268-.758-.594-.307-.326-.682-.593-.831-.593-.15 0-.368-.177-.483-.393-.116-.216-.497-.54-.847-.719-.35-.179-.928-.58-1.285-.891-.357-.31-.728-.565-.824-.565-.097 0-.471-.267-.833-.594-1.413-1.278-1.62-1.425-2.385-1.695-.435-.153-.985-.279-1.223-.279-.237 0-.782-.169-1.209-.375-.428-.206-1.667-.485-2.754-.619-1.086-.134-2.286-.398-2.666-.587-.728-.361-2.855-.789-3.923-.789-.346 0-1.139-.188-1.761-.417-.622-.229-2.064-.546-3.205-.704-1.141-.159-2.374-.425-2.74-.592-.732-.334-3.304-.837-4.332-.848-.358-.004-.936-.155-1.284-.336-.781-.407-2.728-.84-3.818-.849-.449-.004-1.382-.22-2.074-.48-.741-.278-2.172-.573-3.48-.717-1.953-.214-2.223-.289-2.223-.614 0-.299-.15-.369-.79-.369-.648 0-.79.068-.79.38M111.111 51.293c-.217.059-.751.267-1.185.463a8.24 8.24 0 01-1.536.496c-.41.077-.87.317-1.022.534-.152.218-.55.562-.884.765-.334.203-.607.489-.607.637 0 .147-.225.369-.499.494-.316.144-.542.447-.618.829-.067.331-.273.71-.458.842-1.266.899-1.403 7.535-.184 8.922.315.36.573.786.573.948 0 .264.725.991 2.257 2.263.289.241.855.493 1.258.56a34.08 34.08 0 011.884.403c1.366.331 2.09.351 2.81.078.292-.111 1.105-.283 1.807-.383 1.48-.209 3.717-1.564 4.395-2.66.215-.349.572-.797.793-.997.221-.2.403-.505.404-.678.002-.173.13-.537.285-.809.865-1.518.924-1.82.861-4.379-.055-2.215-.112-2.571-.498-3.092-.24-.323-.496-.827-.569-1.118-.203-.809-2.152-2.805-3.005-3.077a8.124 8.124 0 01-1.418-.649c-.691-.417-3.822-.671-4.844-.392m4.642.95c1.908.5 3.91 2.178 4.358 3.652.116.384.402 1.053.634 1.488.642 1.2.599 3.759-.088 5.234-.279.598-.569 1.351-.646 1.674-.186.781-2.093 2.932-2.969 3.348-.383.181-.696.404-.696.494 0 .555-4.1 1.083-6.223.803-.76-.1-1.523-.185-1.696-.189-.67-.014-2.886-1.975-3.467-3.068a6.116 6.116 0 00-.736-1.053c-.775-.846-.532-7.737.272-7.737.084 0 .287-.333.452-.741.358-.884 1.097-1.73 2.328-2.666.986-.75 1.448-.922 3.835-1.429.869-.184 1.667-.356 1.773-.382.239-.057 1.198.134 2.869.572M.642 57.155c-.815.267-1.037 2.697-.247 2.697.34 0 .395-.132.395-.945 0-1.771-2.554-1.623 27.987-1.623 24.5 0 26.879.028 27.299.322l.46.323-.095 5.242c-.078 4.311-.147 5.28-.386 5.456-.209.152-1.771.143-5.507-.034-14.766-.698-14.624-.703-15.072.464-.193.504-.115 39.982.086 43.634.293 5.31.594 16.098.464 16.616l-.118.471h-7.066c-5.945 0-7.103-.046-7.304-.288-.29-.349-.294-16.406-.005-24.009.429-11.331.081-36.128-.52-37.046-.318-.485-2.826-.515-7.581-.089-1.141.102-4.63.246-7.753.32C.991 68.778 0 68.85 0 69.079c0 .212.2.254.84.174 1.135-.14 18.661-.581 19.407-.488l.593.075.124 2.765c.172 3.847.166 30.489-.011 45.333-.122 10.25-.102 12.421.121 12.79l.268.445h7.29c6.618 0 7.322-.031 7.629-.338.31-.311.326-.817.199-6.173-.489-20.525-.52-53.56-.052-54.507l.234-.474 5.728.127c3.151.07 7.509.185 9.685.257 5.005.164 4.557.546 4.714-4.021.066-1.932.167-4.337.223-5.345.099-1.752.082-1.853-.386-2.321l-.489-.489-27.417.028c-18.807.019-27.618.094-28.058.238m242.967.045c-.893.391-.903.499-.667 7.226.115 3.297.257 10.616.315 16.265.181 17.685.545 25.666 1.266 27.753.207.598.44 1.754.519 2.568.092.955.313 1.807.621 2.397.263.504.53 1.259.593 1.679.063.42.359 1.208.658 1.752.298.543.596 1.215.66 1.493.065.278.343.767.618 1.087.274.319.499.679.499.799 0 .121.311.61.69 1.087.379.477.69.933.691 1.014.002.136 1.823 2.17 2.274 2.54.108.09.508.427.889.75 1.687 1.435 2.422 1.995 2.617 1.995.115 0 .506.226.869.503.362.276 1.068.626 1.568.776.5.151 1.056.406 1.236.567.18.161 1.034.439 1.899.617.864.177 1.842.451 2.173.608 2.019.958 14.539.955 16.605-.004.329-.153 1.242-.412 2.03-.577.789-.164 1.69-.481 2.004-.704a3.736 3.736 0 011.229-.532c.362-.069 1.009-.38 1.438-.69.429-.31.887-.564 1.018-.564.221 0 .966-.547 2.614-1.921.907-.756 3.387-3.282 3.389-3.453.001-.076.213-.351.472-.609.259-.259.532-.666.608-.904.076-.239.339-.631.585-.872.247-.241.567-.75.713-1.13.145-.38.457-.928.694-1.216.236-.289.485-.876.554-1.304.068-.428.311-1.016.54-1.307.229-.291.541-1.127.693-1.857.153-.731.451-1.684.662-2.118.212-.435.516-1.724.677-2.865.161-1.14.446-2.651.633-3.358.302-1.138.357-3.058.487-16.889.081-8.582.215-18.828.299-22.768l.152-7.163-.461-.491-.461-.491h-9.028l-.192.507c-.273.717-.231 6.201.118 15.493.512 13.612.567 19.943.208 24.099-.174 2.01-.405 5.01-.514 6.668-.19 2.901-.471 4.651-.819 5.1-.091.117-.258.873-.371 1.679-.113.806-.414 1.911-.669 2.454a17.79 17.79 0 00-.711 1.778c-.136.434-.406.968-.6 1.185-.194.217-.488.724-.654 1.127-.384.931-3.494 4.026-4.558 4.535-.444.213-1.119.559-1.5.769-.38.211-.958.385-1.283.388-.326.002-.993.186-1.482.409-2.295 1.043-9.758 1.043-12.543-.002a19.244 19.244 0 00-1.955-.595c-.533-.124-1.228-.445-1.546-.712-.319-.268-.693-.487-.833-.487-.478 0-4.259-3.914-4.259-4.409 0-.14-.257-.605-.572-1.034-.315-.428-.679-1.179-.809-1.668-.129-.489-.35-1.022-.489-1.185-.323-.379-.63-1.42-.777-2.634-.063-.525-.24-1.236-.392-1.58-.605-1.369-.541-.754-1.328-12.813-.208-3.185-.206-5.868.008-14.814.553-23.001.552-22.932.285-23.616l-.251-.642-4.504.016c-3.419.012-4.658.083-5.142.295m8.698.406c1.164.159 1.106-.264.807 5.9-.773 15.912-.769 33.509.009 38.716.162 1.087.298 2.515.302 3.174.009 1.575.333 3.351.79 4.332.202.435.471 1.36.597 2.057.126.696.445 1.583.708 1.971.264.388.48.868.48 1.065 0 .457.546 1.525.78 1.525.097 0 .28.311.405.69.125.38.378.803.562.939.184.136.503.514.709.84.599.948 2.531 2.672 3.138 2.801.306.065.686.316.845.558.205.314.644.515 1.517.695.676.14 1.472.423 1.768.629 1.336.929 12.099.92 13.676-.011.362-.213 1.153-.499 1.758-.634.66-.148 1.276-.432 1.537-.71.24-.255.587-.464.771-.464.185 0 .725-.356 1.2-.79.476-.435.913-.79.973-.79.191 0 2.163-2.57 2.164-2.821 0-.132.264-.55.586-.927.323-.377.644-.955.715-1.284.071-.329.338-.957.594-1.397.256-.439.548-1.386.65-2.103.101-.718.317-1.514.479-1.769.382-.602.727-2.285.736-3.586.003-.565.138-1.871.3-2.903.702-4.496.761-5.683.745-15.013-.015-8.611-.177-14.478-.645-23.407-.264-5.02-.3-6.988-.131-7.157.395-.396 8.7-.304 9.067.101.334.369.341 1.101.147 14.882-.112 7.972-.204 17.701-.205 21.62-.001 5.509-.064 7.345-.278 8.098-.152.536-.38 1.73-.505 2.653-.53 3.891-.625 4.413-.907 4.956-.162.314-.437 1.261-.61 2.104-.174.843-.48 1.764-.681 2.047-.2.283-.459.94-.576 1.462-.117.521-.431 1.208-.699 1.526-.267.318-.487.726-.488.908-.001.182-.312.721-.692 1.198-.379.477-.689.975-.689 1.107 0 .423-4.908 5.631-5.307 5.631-.097 0-.432.254-.744.566-.311.311-.804.622-1.094.691-.291.069-.78.332-1.087.584-.307.253-1.085.606-1.729.786-.643.179-1.223.411-1.288.516-.172.278-1.137.61-1.775.61-.305 0-1.477.266-2.605.591-2.494.72-11.028.906-13.217.29-2.174-.613-2.487-.686-3.805-.881-.738-.109-1.582-.371-1.876-.581-.294-.211-.932-.486-1.418-.612-.486-.126-1.137-.442-1.448-.703-.31-.261-.801-.531-1.091-.599-.291-.068-.751-.337-1.022-.598-.272-.26-1.14-1.01-1.93-1.666-.789-.655-1.583-1.418-1.765-1.695a11.645 11.645 0 00-.887-1.124c-1.135-1.263-1.274-1.465-1.611-2.349-.19-.496-.464-.948-.608-1.004-.145-.055-.426-.619-.624-1.252-.199-.633-.502-1.303-.674-1.49-.172-.186-.427-.897-.566-1.58-.139-.683-.424-1.534-.632-1.893-.238-.407-.486-1.48-.663-2.864-.155-1.217-.47-2.924-.699-3.793-.401-1.521-.423-2.224-.598-18.864-.195-18.654-.351-27.155-.519-28.247-.184-1.203.362-1.371 4.489-1.377 1.913-.003 3.886.05 4.384.119m-75.418 10.066c-.435.176-1.279.493-1.877.704-.597.212-1.219.536-1.382.721-.163.184-.534.488-.825.676-.29.187-.584.516-.652.73-.068.215-.287.442-.488.506-.2.063-.478.401-.618.751-.14.349-.457.882-.705 1.184-.247.302-.503.88-.569 1.284-.276 1.702-1.313 3.77-1.731 3.454-.132-.099-.628-.292-1.104-.428-.475-.136-1.042-.414-1.26-.616-.364-.34-1.876-.784-2.675-.787-.185-.001-.568-.122-.851-.27-1.998-1.043-13.759-1.167-16.671-.176-.651.222-1.819.508-2.595.636-.777.129-1.574.387-1.777.576-.203.188-.813.459-1.356.603-.543.144-1.121.407-1.284.584-.163.177-.679.493-1.148.702-.468.209-.931.529-1.029.712-.098.183-.448.445-.778.581-.33.137-.6.321-.6.409 0 .089-.473.641-1.05 1.227-.577.586-1.264 1.369-1.528 1.739-.263.37-.633.827-.822 1.016-.189.189-.4.59-.47.891-.07.302-.337.863-.595 1.246-.257.384-.557 1.168-.666 1.743-.109.575-.334 1.333-.501 1.683-.902 1.903-.898 7.314.008 8.698.149.227.332.813.407 1.302.153.999.586 1.975.876 1.975.106 0 .193.156.193.346.003 1.118 4.117 5.224 5.777 5.765.816.266 1.182 1.791.429 1.791-.171 0-.561.25-.867.555a8.241 8.241 0 01-1.071.894c-.283.185-.515.434-.515.551 0 .118-.223.389-.494.603-.272.213-.494.495-.494.626s-.256.518-.568.86c-.312.342-.631.957-.708 1.368-.077.411-.329 1.106-.56 1.546-.552 1.052-.633 4.859-.12 5.647.174.267.437.974.584 1.572.147.597.493 1.377.77 1.733 1.178 1.513 1.898 2.269 2.309 2.426.971.369.029 1.509-1.525 1.845-.279.06-.79.378-1.134.707-.343.329-.696.597-.783.597-.257 0-2.018 1.664-2.018 1.906 0 .122-.222.367-.493.545-.271.177-.631.653-.8 1.057-.168.404-.471.913-.671 1.132-.201.219-.472.931-.602 1.583-.129.652-.375 1.445-.546 1.763-.447.834-.457 5.494-.013 6.335.171.326.42 1.238.551 2.027.152.909.363 1.523.577 1.679.186.135.458.556.604.936.147.381.47.914.719 1.186 1.807 1.972 2.598 2.765 2.759 2.766.103 0 .492.261.865.58.373.319.906.636 1.185.705.279.069.729.332 1.001.585.293.274.968.557 1.664.699.643.131 1.509.415 1.924.631.414.216 1.443.476 2.286.577.843.102 1.977.308 2.521.459 1.97.547 3.92.701 8.729.691 4.874-.011 5.951-.112 9.147-.864.706-.167 1.56-.304 1.897-.307.714-.005 1.827-.35 2.251-.698.163-.134.909-.356 1.658-.493.828-.153 1.514-.404 1.752-.642.216-.216.848-.512 1.405-.658.557-.146 1.146-.427 1.309-.623.163-.197.725-.521 1.249-.72.524-.199.996-.474 1.049-.611.052-.138.446-.408.874-.601s.778-.425.778-.516c0-.091.341-.38.758-.643 1.117-.706 3.718-3.361 4.181-4.269.222-.434.495-.789.607-.789.113 0 .38-.396.594-.88.214-.484.512-1.002.66-1.151.149-.149.417-.842.595-1.54.178-.698.521-1.669.761-2.157.673-1.369.67-9.186-.003-10.325-.242-.41-.583-1.236-.757-1.836-.175-.6-.488-1.198-.696-1.328-.208-.13-.379-.346-.379-.48 0-.312-1.764-2.132-2.222-2.293-.19-.066-.346-.246-.346-.4 0-.153-.288-.395-.641-.538-.354-.143-.954-.499-1.334-.791-.38-.291-.988-.584-1.35-.651a3.62 3.62 0 01-1.211-.514c-.309-.22-1.192-.492-2.008-.619-.8-.124-1.811-.357-2.246-.518-1.513-.558-3.213-.681-11.654-.845-8.215-.16-8.555-.182-10.37-.67-1.032-.277-2.116-.506-2.408-.508-.331-.004-.875-.303-1.444-.796-.502-.434-.982-.79-1.067-.79-.581 0-.986-3.046-.563-4.233.227-.636.48-.882 1.395-1.361l1.117-.585 1.139.367c1.67.538 13.099.544 14.473.008 1.155-.451 1.817-.633 3.242-.891.643-.116 1.354-.383 1.581-.592.226-.21.81-.487 1.297-.616.487-.13 1.179-.493 1.538-.808.358-.315.777-.573.93-.573.153 0 .41-.188.572-.419.161-.231.5-.521.752-.646.252-.124.546-.425.654-.668.107-.244.353-.493.545-.554.192-.061.479-.361.637-.666.157-.305.418-.605.58-.667.161-.062.431-.38.6-.707a5.24 5.24 0 01.785-1.071c.262-.263.564-.794.671-1.181.107-.387.373-.896.592-1.131.231-.248.487-.94.611-1.652.117-.674.395-1.602.617-2.061.6-1.244.614-6.499.02-7.729-.22-.455-.506-1.301-.636-1.881-.129-.579-.446-1.298-.702-1.596-.257-.299-.467-.671-.467-.828 0-.156-.171-.526-.382-.821-.65-.913-.715-1.538-.178-1.701.254-.077.77-.372 1.148-.655.719-.54.889-.571 5.529-1.026 3.762-.368 3.606-.197 3.946-4.34.102-1.249.328-2.894.502-3.654.434-1.898.344-2.88-.293-3.195-2.562-1.269-2.774-1.323-5.432-1.389-2.02-.05-2.737.005-3.358.256m5.728.536a9.534 9.534 0 001.517.425c1.435.238 1.672.634 1.378 2.308-.14.8-.334 2.824-.431 4.499-.098 1.679-.274 3.141-.392 3.259-.198.198-4.056.896-7.109 1.287-1.383.177-1.975.359-1.975.609 0 .087-.406.395-.901.686-1.027.601-1.083 1.293-.187 2.275.248.271.514.716.592.987.077.272.356.813.62 1.204.263.39.559 1.19.658 1.777.098.588.318 1.458.488 1.933.413 1.15.411 4.328-.002 5.654-.17.543-.384 1.495-.476 2.116-.169 1.138-1.482 4.047-2.165 4.798-.198.217-.414.574-.48.793-.066.219-.854 1.134-1.751 2.032-2.372 2.377-2.568 2.548-3.112 2.71-.272.082-.745.358-1.052.615-.308.257-.796.519-1.087.582-.807.175-1.614.509-1.614.667 0 .192-1.262.556-2.443.707-.529.067-1.506.313-2.173.546-1.89.661-11.466.653-13.311-.01-1.818-.655-1.926-.638-3.751.581-1.784 1.191-1.777 5.167.01 6.339.262.171.615.45.785.62.169.17.801.437 1.403.594.602.156 1.387.42 1.744.584 1.098.507 4.211.713 10.864.721 6.42.007 7.576.094 11.613.877.923.179 2.158.407 2.745.507.586.099 1.208.303 1.382.453.174.15.761.381 1.305.512.543.132 1.166.407 1.385.611.219.205.708.503 1.086.663.713.302 3.553 2.884 3.553 3.231 0 .107.26.522.577.921.317.399.635 1.077.708 1.507.073.43.324 1.16.56 1.623.64 1.261.644 7.872.004 9.245-.23.495-.478 1.295-.553 1.778-.159 1.036-.492 1.966-.704 1.966-.083 0-.35.492-.594 1.093-.244.602-.61 1.182-.813 1.291-.204.109-.37.308-.37.443s-.244.521-.543.857c-.299.337-.682.779-.851.983-.285.342-1.842 1.745-3.57 3.216-.395.336-.81.611-.923.611-.113 0-.472.223-.796.496a6.162 6.162 0 01-1.349.81c-.417.172-.901.44-1.075.595-.174.154-.752.435-1.284.623s-1.282.538-1.667.777c-.386.239-1.097.488-1.581.554-.483.066-1.368.335-1.966.598-.727.32-1.902.576-3.555.774-1.358.163-3.136.426-3.951.586-2.693.527-8.998.374-11.753-.286-.435-.104-1.787-.276-3.006-.382-1.715-.15-2.439-.307-3.203-.694-.543-.275-1.2-.501-1.459-.501-.661 0-1.741-.387-2.209-.791a2.563 2.563 0 00-.918-.465c-.287-.068-.896-.435-1.352-.816-.456-.381-.935-.693-1.065-.693-.207 0-.825-.617-2.574-2.568-.243-.271-.561-.805-.706-1.185-.145-.38-.42-.869-.612-1.086-.867-.982-1.521-5.897-1.112-8.353.176-1.056.377-2.3.447-2.765.07-.466.325-1.088.566-1.383.242-.295.56-.848.707-1.228.147-.38.497-.95.777-1.266.841-.95 2.473-2.484 2.644-2.486.088 0 .488-.261.889-.58.401-.318 1.218-.696 1.816-.839l1.086-.261.06-.828c.053-.724-.009-.872-.494-1.177-.704-.444-1.592-1.393-1.959-2.094-.156-.299-.366-.543-.466-.543-.168 0-.449-.827-.973-2.864-.585-2.277-.042-6.806.947-7.891.203-.223.508-.672.677-.998.436-.842 2.521-2.936 3.319-3.333.828-.413.677-1.882-.246-2.394-2.162-1.199-5.319-4.248-5.677-5.484-.039-.135-.273-.557-.518-.937-.246-.38-.557-1.269-.692-1.976a33.869 33.869 0 00-.519-2.258c-.303-1.076-.35-3.723-.088-4.951l.587-2.754c.23-1.08.555-2.114.721-2.297.167-.184.389-.645.493-1.025.105-.379.5-1.079.878-1.554.378-.475.688-.917.689-.981.003-.221 3.064-3.342 3.276-3.341.117 0 .414-.214.661-.477.247-.263.73-.59 1.072-.727a5.418 5.418 0 001.171-.7c.302-.247.88-.51 1.284-.584.405-.073.957-.285 1.229-.471.687-.469 1.713-.793 2.512-.793.372 0 1.581-.24 2.687-.533 2.904-.768 11.384-.819 13.757-.081.81.252 2.054.54 2.764.641.768.108 1.575.371 1.991.646.385.254.987.526 1.338.603.352.077.884.346 1.183.598.968.814 2.41-1.255 2.41-3.457 0-.231.267-.808.593-1.281.326-.474.592-.963.592-1.086 0-.312 1.803-2.371 2.076-2.371.123 0 .407-.211.631-.469.25-.288.815-.561 1.467-.708.584-.132 1.327-.357 1.653-.5.326-.143.771-.308.988-.367.726-.198 3.743.018 4.543.326m-98.568 6.651c-1.233.138-2.148.436-2.352.766-.065.106-.477.253-.915.327-.438.074-1.037.336-1.332.582a7.474 7.474 0 01-1.149.761c-.337.173-.757.534-.933.803-.176.269-.486.542-.689.606-.203.065-.486.337-.63.605-.143.268-.414.536-.603.596-.188.059-.451.372-.585.695-.283.684-1.515 1.832-1.786 1.664-.103-.063-.187-.531-.188-1.041-.007-4.416-.949-6.306-2.854-5.731-.33.099-2.734.348-5.342.553-6.654.521-8.072 1.168-6.737 3.075.152.217.381 1.413.509 2.661s.409 2.979.625 3.849c.77 3.1 1.293 15.264.989 23.012-.493 12.545-.519 21.07-.066 21.313.274.146 2.581.218 7.038.218 8.048 0 7.53.186 7.347-2.639-.065-.993-.173-8.606-.241-16.917l-.124-15.111.482-.7c.265-.385.574-.964.686-1.287.254-.727 2.518-3.188 3.094-3.362.233-.071.606-.295.83-.5 1.394-1.272 10.183-1.316 12.309-.06 1.246.736 2.211-.523 2.583-3.375.128-.978.444-2.266.702-2.864.258-.598.559-1.8.668-2.672.109-.872.336-1.85.504-2.173.75-1.439.253-2.312-1.469-2.584a6.545 6.545 0 01-1.658-.538c-1.179-.611-5.596-.88-8.713-.532m256.297.122c-2.096.209-3.156.412-3.951.754-.597.257-1.411.525-1.807.594-.396.069-.931.291-1.189.494-.257.202-.812.512-1.232.687-.421.176-.919.497-1.106.714-.188.216-.439.393-.557.393-.118 0-.709.483-1.314 1.074l-1.099 1.073-.307-.468c-.169-.258-.395-1.118-.504-1.913-.286-2.094-1.137-3.271-2.102-2.905-.927.353-3.33.736-5.239.835-2.812.147-3.379.692-2.791 2.684.146.497.364 2.282.484 3.966.12 1.684.3 3.375.4 3.757.452 1.737.756 5.716.869 11.394.068 3.39.215 7.612.327 9.383.273 4.316.267 18.67-.011 24.552-.123 2.608-.312 8.208-.42 12.445-.108 4.237-.244 8.293-.303 9.015-.159 1.969-.218 1.948 5.279 1.948 3.668 0 4.518-.052 4.713-.287.18-.217.232-3.394.214-13.186-.028-15.328-.167-14.607 2.405-12.487.296.244 1.006.543 1.578.666.572.123 1.238.353 1.48.511 1.531 1.004 13.026.948 15.17-.073a7.36 7.36 0 011.581-.514c.434-.076 1.116-.351 1.514-.611.399-.26.977-.532 1.284-.605.308-.072.782-.332 1.053-.576.272-.244.716-.558.988-.697 1.025-.523 4.821-4.243 5.616-5.502.282-.447.589-.812.684-.812.094 0 .285-.289.424-.642.14-.353.413-.821.607-1.04.195-.219.5-.752.679-1.185.178-.433.478-.965.667-1.182.188-.218.456-.795.596-1.284.139-.489.41-1.111.602-1.383s.459-1.027.592-1.679a18.41 18.41 0 01.697-2.37c.435-1.138.672-2.951.995-7.605.107-1.537-.09-5.111-.473-8.593-.083-.761-.332-1.738-.553-2.173-.22-.434-.509-1.294-.642-1.911-.132-.616-.364-1.223-.516-1.348-.151-.125-.421-.688-.601-1.25-.179-.562-.476-1.155-.659-1.318-.183-.163-.457-.607-.609-.988-.316-.789-1.472-2.314-3.069-4.046a41.997 41.997 0 01-.908-1.014c-.174-.204-.601-.594-.95-.866a80.945 80.945 0 01-1.264-1.01c-.347-.284-1.031-.718-1.52-.965-.489-.246-.933-.512-.988-.589-.165-.238-.942-.596-1.291-.596-.182 0-.762-.217-1.29-.482-1.741-.875-7.576-1.248-12.233-.784m-248.605.662c.536.233 1.381.477 1.876.542 1.338.174 2.047.585 1.922 1.113-.056.237-.208 1.142-.338 2.011-.229 1.534-.436 2.307-1.058 3.95a5.703 5.703 0 00-.307 1.626c-.012 1.137-.752 3.311-1.321 3.88-.518.517-.117.557-3.922-.392-2.17-.54-5.629-.59-6.994-.1-.608.218-1.396.453-1.752.523-.356.069-.889.329-1.185.576-.296.248-.731.511-.966.584-.535.167-2.527 2.417-2.728 3.081-.082.272-.339.701-.571.954l-.422.46-.098 17.417c-.055 9.579-.171 17.527-.259 17.663-.262.405-13.038.352-13.376-.056-.276-.332-.164-9.001.198-15.302.415-7.247.461-14.329.116-18.074a244.19 244.19 0 01-.52-6.914c-.143-2.482-.32-3.821-.68-5.136-.267-.977-.572-2.533-.678-3.456a404.44 404.44 0 00-.25-2.147c-.138-1.119 4.268-2.115 9.894-2.237l2.841-.061.387.515c.434.579.943 2.944.944 4.387 0 1.097.266 1.715.739 1.715.368 0 1.829-1.34 1.829-1.678 0-.183.677-.929 1.748-1.925.146-.137.503-.48.792-.762.29-.283.836-.673 1.215-.868.379-.194.94-.563 1.248-.819.307-.256.762-.466 1.011-.466.25 0 .888-.194 1.417-.431 2.016-.9 7.347-1.001 9.248-.173m25.836-.177c-.518.206-1.602.306-6.367.587-8.098.478-9.186.966-8.304 3.726.276.864.447 2.252.594 4.816.313 5.45.569 8.777.803 10.417.279 1.954.153 19.974-.169 24.198-.602 7.907-.604 10.408-.008 10.786.51.323 14.31.218 14.583-.111.29-.349.195-6.113-.216-13.144-.347-5.946-.352-22.126-.009-28.939.538-10.689.539-11.41.007-11.998-.377-.418-.552-.482-.914-.338m232.263-.007c.58.11 1.608.421 2.283.692.676.27 1.401.491 1.612.491.211 0 .719.267 1.129.593.41.325.904.592 1.097.592.193 0 .598.261.899.581.302.319.751.631.999.693.248.063.545.289.66.504.115.215.473.527.795.694.323.167.587.429.587.582 0 .152.262.463.581.691.32.227.635.584.702.793a.858.858 0 00.495.499c.206.066.433.315.504.554.071.238.382.757.692 1.151.309.394.621.952.693 1.239.072.287.29.633.483.768.193.136.488.706.655 1.269.167.562.487 1.272.711 1.576.224.305.505 1.088.624 1.739.119.652.381 1.497.582 1.877 1.08 2.042 1.076 14.006-.006 16.608-.207.497-.471 1.495-.586 2.218-.122.759-.406 1.602-.674 1.997-.254.375-.52 1.037-.589 1.47-.069.433-.337 1.039-.594 1.346-.258.307-.529.837-.603 1.177-.074.34-.397.911-.717 1.27-.32.358-.582.813-.582 1.01 0 .197-.267.595-.593.886-.326.29-.593.623-.593.74 0 .247-.344.623-2.59 2.833l-2.158 2.123c-.275.272-.606.495-.734.495s-.524.254-.881.564c-.357.311-1.004.678-1.439.817-.435.139-1.146.452-1.58.696-.435.244-1.221.498-1.747.565-.525.066-1.37.317-1.876.558-.857.407-1.257.442-5.813.51-4.878.073-5.679.004-7.443-.646a14.162 14.162 0 00-1.866-.511c-.543-.103-1.176-.364-1.406-.58-.23-.216-.514-.393-.631-.393-.118 0-.511-.277-.874-.617-.615-.575-.694-.597-1.156-.337l-.497.279v26.65l-4.565.053c-5.532.065-5.053.395-4.813-3.321.102-1.57.189-4.144.195-5.719.006-1.576.094-3.487.196-4.247.679-5.054.859-30.783.269-38.42-.181-2.336-.358-5.091-.393-6.123-.185-5.321-.542-10.18-.874-11.884-.205-1.049-.467-3.071-.581-4.494-.304-3.755-.154-3.943 3.159-3.977.706-.007 2.039-.129 2.963-.272 1.78-.275 2.37-.115 2.37.643 0 .292.669 2.648 1.002 3.527.244.645.889.934 1.211.543.623-.758 1.698-1.744 2.38-2.183.407-.262.74-.561.74-.664 0-.103.344-.28.765-.393.42-.113 1.001-.392 1.29-.62.29-.228 1.165-.546 1.946-.708.78-.161 1.673-.425 1.985-.586 1.16-.6 9.755-.924 12.2-.461m-231.464 1.044c.174.251.114 1.381-.297 5.571-.388 3.953-.353 35.528.044 40.296.163 1.956.297 4.4.297 5.432v1.877l-6.618.055c-8.686.073-8.026.464-7.413-4.393.697-5.521.644-32.049-.075-37.045-.101-.706-.286-2.661-.411-4.345-.223-3.004-.428-4.614-.695-5.465-.199-.635.503-.985 2.471-1.232a65.02 65.02 0 003.358-.531c3.164-.603 8.977-.74 9.339-.22m219.402 5.841c-1.06.087-2.007.293-2.568.559-.489.232-1.315.531-1.836.664-.52.133-1.054.393-1.185.577-.131.185-.495.399-.808.476-.314.078-.868.448-1.231.823-.364.374-.746.68-.849.68-.103 0-.392.289-.641.642-.25.354-.62.779-.823.946-.623.512-.445 12.799.261 18.067.102.76.188 4.378.192 8.04.007 6.977.069 7.533.876 7.786.228.071.604.333.835.581.232.249.81.567 1.284.708.475.14 1.029.407 1.231.593.204.187.998.437 1.778.56.775.122 2.032.36 2.792.53 2.387.531 3.607.551 5.431.09.911-.231 1.858-.419 2.103-.419.88 0 2.397-.423 2.773-.773.21-.196.733-.471 1.161-.61.429-.14 1.062-.5 1.408-.801.346-.301.808-.603 1.027-.673.219-.069.449-.285.51-.48.062-.194.333-.471.603-.615.27-.145.491-.338.491-.429 0-.091.275-.454.613-.806.337-.352.775-.957.973-1.345.198-.387.489-.811.646-.942.158-.13.398-.636.534-1.122.136-.487.323-.886.415-.886.266 0 .703-1.01.849-1.966.075-.484.318-1.175.541-1.537 1.474-2.384 1.471-14.712-.003-17.098-.225-.364-.508-1.123-.629-1.685-.12-.563-.38-1.135-.576-1.273-.196-.137-.468-.622-.605-1.076-.136-.455-.501-1.07-.811-1.367-.311-.297-.565-.638-.565-.756s-.244-.453-.543-.744a96.792 96.792 0 01-.895-.883c-1.054-1.066-1.485-1.425-2.044-1.708-.34-.171-.664-.431-.72-.578-.056-.146-.489-.376-.962-.51a13.742 13.742 0 01-1.848-.724c-1.106-.539-5.728-.799-9.185-.516m8.691.877c.598.29 1.273.529 1.502.53.228.001.717.221 1.086.488.369.267 1 .667 1.402.887.401.221.801.516.888.655.088.139.404.409.702.599.299.19.544.441.544.558 0 .117.244.451.543.742.547.535.816.941 1.96 2.965.908 1.606 1.171 2.205 1.321 3.004.073.39.313 1.084.534 1.541 1.081 2.238 1.062 12.904-.026 15.158-.218.449-.476 1.312-.574 1.917-.192 1.181-.409 1.703-.863 2.079-.157.131-.344.546-.415.922-.07.377-.324.885-.563 1.129a4.77 4.77 0 00-.727 1.037c-.292.594-1.121 1.715-1.678 2.272-.164.163-.579.585-.924.938-.345.353-.693.642-.773.642-.08 0-.608.311-1.173.691-.565.381-1.185.692-1.376.692-.192 0-.561.163-.82.363-.646.499-1.663.822-2.586.822-.425 0-1.395.103-2.157.229-2.579.426-7.374-.101-9.506-1.044-.951-.421-1.783-.765-1.848-.765-.066 0-.384-.223-.706-.494-.323-.272-.711-.494-.861-.494-.619 0-.684-.787-.681-8.234.003-7.172-.179-12.392-.602-17.248a85.63 85.63 0 01-.244-4.904l-.046-2.633.544-.396c.298-.218.543-.521.543-.673 0-.153.355-.502.79-.776.435-.275.79-.567.79-.649 0-.083.333-.321.741-.53a12.366 12.366 0 001.35-.82c.334-.242.957-.503 1.382-.58.426-.078 1.232-.31 1.792-.516 2.614-.965 8.843-1.025 10.735-.104m-194.963-.076c-.163.093-.941.325-1.729.514-.788.19-1.633.52-1.877.732a6.026 6.026 0 01-.981.667c-.461.24-1.745 1.439-2.621 2.448-.141.163-.391.752-.555 1.308-.165.557-.441 1.286-.614 1.62-.475.918-.446 5.047.041 5.862.195.326.463.965.597 1.421.133.455.44 1.067.682 1.36.695.842 2.153 2.256 2.326 2.256.087 0 .447.245.801.544.354.298 1.05.648 1.546.776.497.128 1.392.414 1.989.636 1.569.581 3.478.544 5.235-.102.76-.279 1.605-.555 1.876-.613 1.269-.273 3.811-2.623 4.819-4.455l.736-1.338-.061-3.634c-.058-3.402-.089-3.664-.487-4.095-.234-.252-.555-.771-.712-1.151-.314-.758-1.753-2.241-2.778-2.863a56.88 56.88 0 01-1.331-.84c-.374-.244-.857-.444-1.075-.446-.217-.001-.973-.178-1.679-.394-1.319-.403-3.611-.521-4.148-.213m4.97.898c1.076.205 1.67.434 2.054.79.297.275.653.5.79.5.418 0 2.667 2.351 2.99 3.126.167.399.459.948.649 1.22.658.94.737 6.745.1 7.382-.327.327-.802 1.289-.958 1.938-.069.292-.31.588-.533.659-.224.071-.504.342-.622.602-.119.26-.402.528-.63.596-.228.067-.726.364-1.106.659-1.403 1.09-5.515 1.848-7.309 1.347-.597-.167-1.62-.41-2.271-.539-.778-.155-1.341-.399-1.638-.712-.249-.261-.568-.475-.71-.475-.275 0-1.922-1.576-2.614-2.502-.438-.587-.702-1.493-1.197-4.115-.336-1.776.402-5.824 1.239-6.796.954-1.109 2.325-2.39 2.558-2.39.142 0 .538-.236.88-.524 1.159-.975 5.263-1.353 8.328-.766m242.723 27.582c-.122.229-.297.943-.388 1.588-.091.645-.347 1.547-.568 2.005-.221.457-.525 1.409-.676 2.115-.151.707-.468 1.65-.704 2.097-.237.447-.509 1.294-.605 1.883-.095.588-.404 1.503-.685 2.031-.283.533-.511 1.286-.511 1.689 0 .4-.222 1.164-.493 1.699-.272.534-.59 1.5-.707 2.146-.118.646-.392 1.522-.608 1.947-.217.425-.509 1.321-.65 1.992-.14.67-.479 1.705-.753 2.3-.275.594-.559 1.563-.631 2.153-.072.589-.296 1.302-.497 1.584-.2.281-.473 1.088-.605 1.792s-.416 1.589-.631 1.967c-.215.378-.521 1.312-.679 2.074-.158.763-.417 1.586-.575 1.828-.158.243-.41 1.028-.56 1.746-.188.895-.45 1.5-.837 1.929-.772.858-1.481 1.655-2.375 2.67a78.517 78.517 0 01-1.154 1.284c-.219.233-.604.69-.856 1.015-.484.622-2.095 2.478-3.093 3.563-.326.354-1.081 1.204-1.679 1.89a181.386 181.386 0 01-3.16 3.526 51.81 51.81 0 00-1.482 1.762c-.543.671-1.188 1.353-1.432 1.516-.245.163-.445.387-.445.496 0 .11-.244.449-.543.752-.476.485-2.107 2.307-3.605 4.027-.271.313-.805.909-1.185 1.325a63.168 63.168 0 00-1.481 1.703 66.18 66.18 0 01-1.284 1.491c-.272.301-.828.929-1.236 1.397-1.558 1.785-2.383 2.415-3.661 2.794-.573.171-1.298.492-1.61.714-.311.222-.74.404-.953.404-.213 0-.728.232-1.146.515a7.012 7.012 0 01-1.594.767c-.458.138-1.084.428-1.391.645a3.986 3.986 0 01-1.249.536c-.38.078-1.004.354-1.387.613s-1.11.596-1.616.748c-.505.152-1.17.456-1.478.675-.308.219-.926.497-1.374.617-.448.121-.925.352-1.059.514-.134.162-.697.429-1.251.593-.554.165-1.341.52-1.75.791-.409.27-.905.492-1.104.492-.198 0-.76.253-1.248.563-.489.31-1.201.622-1.584.694-.383.071-.989.347-1.348.611-.358.265-.93.54-1.27.611-.339.072-1.072.388-1.629.702-.556.315-1.139.572-1.295.572-.155 0-.696.262-1.201.582-.505.321-1.28.68-1.722.799a6.048 6.048 0 00-1.518.702c-.393.266-.949.485-1.236.485-.621 0-1.399.5-1.399.9 0 .157.178.285.395.285.217 0 .395-.131.395-.291 0-.183.41-.41 1.107-.613.609-.177 1.422-.535 1.806-.795.384-.261.869-.474 1.078-.474.449 0 1.088-.308 1.639-.79.217-.191.726-.405 1.13-.477.404-.072.982-.331 1.284-.575.302-.244.993-.557 1.536-.696.544-.138 1.166-.414 1.383-.612.217-.199.891-.502 1.496-.675.606-.173 1.254-.483 1.441-.69.188-.207.685-.431 1.106-.498.422-.067 1.017-.326 1.325-.574.307-.248.993-.563 1.526-.698.532-.136 1.227-.467 1.546-.734.318-.268.78-.487 1.027-.487.247 0 .84-.265 1.318-.589.478-.324 1.021-.591 1.206-.593.45-.005 1.349-.397 1.836-.802.218-.18.815-.441 1.328-.579.513-.138 1.219-.462 1.569-.72.35-.259.828-.47 1.063-.47.234 0 .816-.265 1.295-.589.478-.324 1.029-.591 1.224-.593.444-.004 1.373-.476 1.69-.858.132-.158.648-.349 1.147-.424.62-.093 1.073-.31 1.426-.683.285-.301.675-.603.868-.671a.89.89 0 00.476-.474c.069-.193.4-.617.736-.943.7-.679 2.661-2.894 3.848-4.345 1.187-1.453 1.682-2.023 3.087-3.556a88.873 88.873 0 001.765-1.975 77.27 77.27 0 011.735-1.937c.68-.74 1.637-1.821 2.126-2.404.489-.583 1.4-1.615 2.025-2.295.624-.679 1.136-1.355 1.136-1.502 0-.147.223-.352.497-.456.273-.104.576-.398.673-.652.097-.255.407-.614.688-.798.282-.185.512-.43.512-.545 0-.114.511-.73 1.136-1.368 1.111-1.135 1.741-1.85 3.388-3.846.448-.543.969-1.14 1.158-1.326 1.151-1.136 1.826-2.094 1.939-2.75.063-.365.328-1.109.59-1.652.262-.543.535-1.432.608-1.976.073-.543.385-1.487.694-2.098.308-.611.561-1.42.561-1.798 0-.378.218-1.097.485-1.598.266-.502.587-1.47.712-2.153.126-.683.324-1.419.441-1.636.597-1.111.726-1.483.912-2.644.111-.694.327-1.405.48-1.58.329-.378.639-1.364.813-2.582.069-.484.287-1.151.484-1.482.197-.331.471-1.179.609-1.885s.4-1.551.582-1.877c.334-.595.682-1.786.892-3.049.062-.373.24-.818.395-.99.156-.171.383-.755.505-1.297.223-.987.566-2.078 1.117-3.549.161-.432.345-1.222.408-1.755.085-.716.21-.993.48-1.064.247-.065.364-.277.364-.665 0-.681-.47-.771-.801-.154m-255.452 19.656c-1.232.426-3.296 2.78-3.711 4.231-.139.486-.393 1.048-.564 1.249-.523.613-.56 4.985-.051 5.983.214.42.492 1.143.616 1.606.209.775 1.677 3.008 1.978 3.008.071 0 .471.313.889.695.417.382.99.75 1.273.819.283.068.767.301 1.076.517 1.055.738 7.946 1.517 10.262 1.161a99.757 99.757 0 013.497-.447c1.325-.146 2.431-.391 3.062-.679a16.9 16.9 0 011.817-.694c.456-.134.874-.36.929-.502.054-.143.447-.437.873-.654.844-.431 3.196-2.591 3.196-2.935 0-.118.232-.489.515-.826.882-1.048 1.165-4.776.566-7.46-.054-.241-.307-.648-.564-.904-.257-.257-.569-.659-.695-.894s-.497-.566-.825-.736a6.033 6.033 0 01-.984-.644c-.366-.316-2.402-.9-5.322-1.527-.943-.202-3.041-.28-7.901-.293-3.639-.009-7.21-.083-7.934-.164-.874-.097-1.546-.067-1.998.09m15.759.675c.869.097 2.158.304 2.864.46.707.155 1.788.342 2.404.414.769.091 1.294.284 1.679.617.307.267.848.59 1.201.719.353.129.643.328.644.442.001.114.305.588.675 1.054 1.133 1.425 1.262 6.495.195 7.646-.262.283-.477.64-.477.793 0 .245-.416.694-2.57 2.777-.272.264-.639.48-.815.48-.176 0-.435.139-.576.309-.338.407-1.118.79-1.918.942-.355.068-1.111.341-1.679.607-2.203 1.032-13.792 1.05-14.96.024-.163-.143-.734-.407-1.268-.586s-1.239-.588-1.566-.908c-.327-.32-.751-.631-.941-.691-.191-.061-.578-.506-.862-.99-.284-.484-.591-.88-.684-.88-.483 0-1.5-5.318-1.223-6.396.115-.447.361-1.473.547-2.278.229-.994.517-1.669.896-2.1.307-.35.558-.778.558-.951 0-.173.264-.451.586-.617.323-.167.678-.475.79-.683.112-.209.403-.413.648-.454.828-.14 14.261.072 15.852.25M1.52 167.859c-.672.742-.73 1.419-.73 8.518 0 6.596.024 7.09.361 7.395.479.433 1.345.415 1.731-.035.476-.557.483-14.605.007-15.332-.493-.752-1-.954-1.369-.546m9.64.003c-.325.194-.97.464-1.432.6-.481.14-.975.45-1.154.724-.172.263-.473.528-.669.591-.196.062-.472.399-.614.748-.141.35-.408.771-.592.936-1.128 1.013-1.095 7.733.044 8.996.203.224.368.56.368.745 0 .393 1.801 2.186 2.667 2.655.774.419 5.671.477 6.385.075 1.085-.61 2.99-2.59 2.994-3.112.002-.227.188-.626.413-.886l.41-.473-.61-.545c-.902-.806-2.185-.672-2.185.228 0 .288-.188.528-1.255 1.597-1.919 1.924-4.248 1.818-6.369-.289-1.251-1.243-1.165-8.489.105-8.892.189-.06.46-.325.6-.587.606-1.132 5.267-1.022 5.718.135.778 1.991 3.721 2.355 3.252.402-.2-.833-.65-1.633-.92-1.635-.133 0-.388-.257-.565-.57-.202-.354-.611-.662-1.087-.817-.419-.137-.975-.414-1.234-.615-.662-.515-3.414-.522-4.27-.011m76.445.12l-.593.474-.06 7.345c-.067 8.119-.043 8.298 1.112 8.298 1.032 0 1.022.071 1.022-7.892-.001-7.045-.021-7.449-.392-8.059-.466-.764-.361-.748-1.089-.166m80.839-.246c-.298.109-.543.27-.543.357 0 .088-.314.218-.699.291-.649.121-2.659 1.718-2.659 2.111 0 .085-.215.369-.478.632-.309.309-.526.817-.615 1.441a24.11 24.11 0 01-.411 2.041c-.348 1.371-.345 1.871.016 2.971.161.489.343 1.304.406 1.812.079.64.322 1.184.794 1.778.374.47.68.947.681 1.059.001.112.271.363.6.558.329.194.805.559 1.057.812.974.974 6.144.916 7.302-.081.343-.296.78-.595.972-.665.192-.07.428-.329.525-.576.097-.248.358-.6.579-.785.549-.455.917-1.861.645-2.458-.549-1.205-2-.704-2.863.988-.375.737-.689 1.114-.927 1.114-.198 0-.496.196-.664.435-1.016 1.45-5.112.096-5.654-1.87-.143-.517-.421-1.086-.618-1.265-.525-.475-.522-3.912.005-4.85.2-.356.473-.981.607-1.388.135-.408.323-.741.419-.741.096 0 .401-.245.677-.543 1.285-1.387 5.098-.777 6.059.969.453.823.514.86 1.494.917 1.461.085 1.93-1.113.883-2.255a19.439 19.439 0 01-.887-1.092c-.3-.396-.83-.827-1.179-.958a14.897 14.897 0 01-1.353-.613c-.8-.418-3.196-.502-4.171-.146m-147.083.379c-1.261 1.353-.53 2.143 2.049 2.217 2.725.078 2.467-.637 2.467 6.825 0 7.027-.014 6.942 1.114 6.942 1.231 0 1.256-.141 1.256-7.136v-6.258l.622-.217c.342-.119 1.336-.216 2.209-.216 2.447 0 3.152-1.083 1.472-2.26-.775-.543-10.672-.452-11.189.103m22.59.033c-1.035 1.463-1.503 2.38-1.673 3.275-.106.557-.409 1.347-.674 1.757-.265.41-.543 1.146-.616 1.635-.074.489-.342 1.21-.596 1.603-.253.392-.553 1.214-.666 1.825-.113.612-.386 1.357-.606 1.657-.22.299-.478.964-.573 1.477-.095.513-.313 1.146-.485 1.408-.292.446-.284.502.135.895.757.711 2.297.362 2.297-.521 0-.119.111-.335.247-.478.371-.393.698-1.166.828-1.955.216-1.322.406-1.425 2.799-1.522 2.968-.121 3.688.092 4.018 1.19.372 1.237.664 2 .853 2.223.092.109.338.487.548.84.469.791 1.606.908 2.324.239.529-.493.534-.605.047-1.166-.211-.244-.483-.916-.602-1.493-.12-.577-.394-1.252-.609-1.499-.214-.248-.441-.678-.503-.957-.335-1.498-.502-1.966-.842-2.359-.206-.237-.433-.763-.503-1.166-.161-.931-.508-1.821-.709-1.821-.198 0-.588-1.114-.588-1.681 0-.241-.208-.744-.463-1.12-.255-.375-.522-.918-.594-1.206-.342-1.36-2.112-2.045-2.794-1.08m85.286-.272c-.632.412-.857 1.973-.346 2.397.338.281 1.552.151 1.991-.214.879-.73-.687-2.809-1.645-2.183m-114.028.542c1.996.629 3.754 2.273 3.754 3.512 0 .173-.621.712-.82.712-.238 0-1.789-1.526-2.075-2.042-.752-1.352-4.712-1.183-6.268.268-1.526 1.424-2.36 5.275-1.576 7.282.196.502.492 1.301.658 1.777 1.21 3.454 6.359 3.4 8.328-.089.948-1.68 2.261-1.405 1.764.369-.221.792-1.586 2.509-1.993 2.509-.096 0-.402.244-.679.543-.798.861-5.364.84-6.54-.03-2.688-1.991-3.494-3.674-3.493-7.297l.001-2.599.729-1.382c.801-1.519 2.222-3.001 3.043-3.174.289-.061 1.015-.275 1.612-.475 1.46-.488 1.656-.481 3.555.116m157.038-.053c1.89.679 2.225.873 2.721 1.57.247.348.67.936.94 1.307.459.63.469.697.165 1.034-.594.656-1.786.09-2.36-1.121-.877-1.847-5.112-1.941-6.829-.151-2.524 2.631-2.32 8.694.348 10.343.368.228.669.492.669.587 0 1.31 5.359.244 5.878-1.168.23-.627 1.484-2.001 1.826-2.001 2.272 0-.925 4.668-3.457 5.048-2.838.425-6.967-.746-7.006-1.988-.003-.111-.317-.663-.698-1.227-.435-.647-.693-1.267-.696-1.677-.002-.357-.095-1.043-.206-1.525-.387-1.676.288-5.755 1.017-6.145.209-.112.38-.311.381-.443.004-.739 1.719-1.92 3.471-2.391 2.244-.603 2.303-.604 3.836-.052m-169.789.37c.33.471.476 14.22.156 14.687-.278.406-.797.455-1.114.105-.824-.911-.377-15.231.475-15.231.097 0 .314.198.483.439m29.929.046c.456.485.37 1.079-.161 1.122-.179.015-1.04.037-1.913.05-1.17.016-1.733.116-2.134.379l-.544.356.031 6.355c.033 7.029-.022 7.343-1.157 6.548-.433-.304-.435-.329-.435-6.8 0-7.502.256-6.793-2.469-6.833-2.594-.038-2.827-.166-2.066-1.133l.381-.485h5.026c4.946 0 5.033.007 5.441.441m13.687.13c.19.229.346.615.346.858s.215.691.477.997c.263.306.535.875.605 1.265.07.391.335 1.113.589 1.606.254.493.593 1.337.754 1.876.16.54.476 1.292.7 1.672.225.38.505 1.122.622 1.649.118.527.338 1.082.491 1.235.152.152.425.788.606 1.413.181.624.42 1.246.532 1.382.477.58-.988 1.25-1.535.702-.157-.157-.343-.523-.413-.814a3.616 3.616 0 00-.474-1.025c-.19-.273-.452-.895-.583-1.383-.377-1.41-.298-1.381-3.754-1.381s-3.377-.029-3.754 1.381c-.131.488-.406 1.124-.612 1.413-.206.289-.375.696-.375.903 0 .637-.72 1.255-1.236 1.059-.604-.23-.54-1.486.147-2.892.281-.573.642-1.548.803-2.167.161-.618.469-1.349.685-1.623.215-.274.391-.697.391-.94 0-.573.528-2.064.869-2.458.147-.168.38-.795.518-1.392.139-.598.461-1.396.717-1.774.255-.379.464-.817.464-.975 0-1.084 1.671-1.489 2.42-.587m42.565-.007c.413.81.35 14.277-.069 14.696-.28.279-.373.284-.741.039-.598-.397-.778-13.605-.2-14.706.381-.725.651-.733 1.01-.029m35.304-.133c-.338.247-1.057 2.106-1.078 2.785-.006.217-.318.617-.692.888-.877.637-.863.873.091 1.533l.783.542.01 3.456c.014 4.98.326 5.997 1.895 6.174 2.608.294 3.659-1.106 1.528-2.036-1.039-.453-1.085-.668-1.008-4.724l.059-3.056.764-.214c1.578-.442 1.523-1.442-.104-1.881l-.759-.204v-1.165c0-1.875-.613-2.738-1.489-2.098m6.233.167l.413.443-.427.347c-.836.677-1.655.049-1.055-.809.376-.537.554-.534 1.069.019m73.697-.08c-.388.34-1.005 1.972-1.014 2.683-.003.236-.295.62-.686.903-.863.627-.859.822.039 1.562l.731.602.131 3.807c.173 5.062.331 5.536 1.908 5.736 2.547.324 3.607-1.118 1.498-2.038-1.039-.453-1.085-.668-1.008-4.724l.059-3.056.764-.214c1.578-.442 1.523-1.442-.104-1.881l-.759-.204v-1.165c0-1.942-.663-2.798-1.559-2.011m-78.935.695c.053.232.118.911.147 1.509.05 1.071.063 1.092.89 1.466 1.036.468 1.065.831.099 1.233-1.041.433-1.033.401-1.014 4.017.019 3.835.082 4.144.919 4.566 1.644.829 1.44 1.457-.464 1.43-1.829-.027-2.055-.711-2.057-6.232l-.001-3.297-.587-.347c-.841-.497-.868-.786-.122-1.355.572-.436.676-.654.788-1.647.197-1.737 1.115-2.617 1.402-1.343m80 0c.053.232.118.911.147 1.509.05 1.071.063 1.092.89 1.466 1.036.468 1.065.831.099 1.233-1.041.433-1.033.401-1.014 4.017.019 3.835.082 4.144.919 4.566 1.644.829 1.44 1.457-.464 1.43-1.832-.027-2.058-.691-2.059-6.073v-3.38l-.59-.395c-.842-.564-.863-.814-.118-1.383.582-.444.675-.646.797-1.733.192-1.699 1.107-2.526 1.393-1.257m-160.705 1.361c-.008.027-.177.825-.377 1.773-.207.98-.542 1.951-.777 2.249-1.184 1.506-.464 2.651 1.652 2.625 2.806-.035 3.249-.539 2.198-2.499-.277-.516-.632-1.503-.79-2.193-.157-.69-.314-1.279-.348-1.308-.307-.265-1.524-.77-1.558-.647m.884 1.36c.495.226.907 1.055.909 1.83 0 .228.22.77.487 1.205.268.434.49 1.037.493 1.34l.006.55-2.024-.056-2.025-.057.066-.657c.036-.362.267-.955.514-1.318.246-.363.501-1.113.567-1.668.172-1.454.231-1.522 1.007-1.169m11.076.042c-4.791 1.371-4.164 11.317.749 11.888 2.412.28 4.688-.353 4.688-1.304 0-.087.164-.209.365-.273.813-.258 1.114-2.152.439-2.762-.638-.577-1.902.227-2.697 1.715-.491.919-2.646.82-3.217-.148-.224-.38-.496-.691-.603-.691-.502 0-.804-2.975-.434-4.267.543-1.89 3.592-3.101 4.287-1.701 1.036 2.087 3.26 2.196 2.86.141-.439-2.258-3.422-3.462-6.437-2.598m10.89-.046c-.783.183-2.49 1.616-2.49 2.089 0 .132-.223.568-.494.968-.455.67-.494.905-.494 2.957 0 2.089.031 2.266.494 2.816.271.323.494.714.494.869 0 .283.162.473 1.301 1.514 1.097 1.003 5.105 1.075 5.742.103.165-.253.466-.512.668-.576.202-.064.423-.293.491-.508.069-.215.344-.628.612-.918.719-.775.576-1.484-.343-1.711-.95-.235-1.697-.026-1.864.523-.882 2.905-4.366 2.259-4.783-.886-.436-3.298.511-5.264 2.544-5.28 1.055-.009 1.764.444 2.148 1.371.284.684.866.906 1.62.62.728-.277.771-.425.443-1.515-.671-2.231-2.997-3.162-6.089-2.436m11.238-.124c-.109.037-.443.12-.742.187-2.371.523-3.736 4.639-2.817 8.489 1.039 4.351 7.693 4.838 9.77.716l.444-.882-.436-.353c-.685-.554-1.697-.463-2.104.191-.773 1.242-1.392 1.63-2.596 1.626-1.281-.003-1.304-.015-2.129-1.083-1.503-1.947-1.683-1.836 3.099-1.916 4.488-.074 4.411-.037 4.282-2.053-.071-1.091-.188-1.516-.517-1.87-.235-.252-.427-.592-.427-.756 0-1.383-3.926-2.93-5.827-2.296m16.232.108c-.416.105-1.023.457-1.349.783-.326.326-.665.593-.753.593-.089 0-.22.234-.292.52-.072.285-.326.678-.564.871-.411.332-.435.506-.435 3.152s.024 2.82.435 3.152c.238.193.493.588.566.876.072.289.321.626.553.748.232.122.606.419.832.659.504.537 2.403.789 4.367.578 2.102-.225 4.129-2.516 3.412-3.856-.48-.898-2.366-.165-3.002 1.166-.692 1.449-3.752.553-4.377-1.281-.376-1.101-.527-1.055 3.432-1.055 3.235 0 3.517-.028 3.918-.402.763-.711.505-3.436-.417-4.398-.239-.249-.612-.68-.83-.957-.909-1.158-3.396-1.678-5.496-1.149m12.249-.004c-.306.092-.681.271-.834.398-.216.179-.348.16-.594-.085-.372-.372-1.293-.417-1.631-.079-.173.173-.237 1.712-.237 5.689 0 5.902.005 5.929 1.077 5.921 1.332-.009 1.441-.299 1.552-4.143.133-4.622.558-5.517 2.621-5.528.901-.005 1.622-.824 1.283-1.459-.403-.752-1.963-1.096-3.237-.714m6.634.008c-1.904.375-3.395 3.029-2.157 3.84.498.326 1.314.261 1.314-.105 0-.858 1.494-1.771 2.9-1.771h1.436l.382.791.382.79-.69.569c-.528.435-.975.598-1.908.696-2.844.299-2.891.314-3.825 1.275-1.855 1.908-1.792 3.281.248 5.393.7.724 4.148.674 5.778-.085l.851-.397.296.422c.378.54 1.562.591 1.806.077.09-.19.116-2.444.056-5.008l-.107-4.663-.692-.798c-.997-1.15-3.391-1.555-6.07-1.026m22.689.018c-.658.19-2.594 1.902-2.594 2.295 0 .113-.221.68-.492 1.261-1.506 3.235.685 7.998 3.848 8.365 2.159.251 3.697-.027 4.478-.808.37-.37.754-.673.854-.673.525 0 1.476-2.68 1.548-4.362.072-1.693-.924-4.724-1.552-4.724-.103 0-.417-.258-.698-.573-.818-.918-3.543-1.313-5.392-.781m13.011.007c-.38.109-.751.295-.824.414-.094.152-.226.139-.444-.042-.443-.367-1.858-.303-2.308.104-.391.354-.595 10.112-.224 10.668.421.63 1.799.883 2.197.403.146-.177.24-1.655.271-4.28.04-3.361.096-4.027.344-4.109.163-.055.532-.351.82-.659.375-.401.712-.559 1.185-.557 2.009.008 2.143.331 2.143 5.178 0 4.362.093 4.696 1.308 4.696 1.493 0 1.458.114 1.454-4.797l-.005-4.388-.773-1.209c-1.009-1.573-2.844-2.081-5.144-1.422m32.445-.013c-3.609 1.042-4.546 8.009-1.465 10.89 2.327 2.178 6.718 1.366 8.258-1.526l.515-.968-.442-.358c-.752-.609-2.373-.349-2.373.38 0 .946-2.375 1.8-3.648 1.312-.414-.159-1.922-2.419-1.774-2.658.062-.1 1.551-.184 3.31-.186 3.303-.005 4.617-.172 4.903-.623.388-.611.04-3.133-.478-3.466-.131-.084-.393-.487-.581-.894-.189-.408-.43-.741-.536-.741-.106 0-.404-.228-.663-.508-.746-.804-3.337-1.142-5.026-.654m12.946-.033c-.403.078-.911.357-1.129.619-.324.389-.398.415-.404.139-.013-.688-1.314-.992-1.869-.438-.267.267-.31 1.056-.31 5.616 0 5.818.021 5.926 1.175 5.926.892 0 .96-.267 1.03-4.064l.066-3.569.692-1.01c.695-1.016 1.037-1.226 2.008-1.231 1.649-.009 1.942.808 1.942 5.407v3.648l.521.409c.577.455 1.446.537 1.81.173.171-.171.237-1.523.237-4.836v-4.599l-.489-.547a22.95 22.95 0 01-.839-1.001c-.562-.728-2.533-1.013-4.441-.642m17.522-.104a6.67 6.67 0 01-.74.199c-3.328.734-4.339 7.836-1.507 10.59 2.366 2.3 7.528 1.639 8.183-1.047.073-.3.212-.594.308-.654.291-.179.199-.716-.17-.995-.634-.482-1.595-.342-1.978.289-.708 1.164-1.475 1.608-2.774 1.608h-1.189l-.913-1.213c-1.261-1.678-1.336-1.634 2.969-1.764 2.056-.062 3.894-.183 4.085-.269.723-.324.696-2.663-.043-3.603-.222-.282-.403-.654-.403-.827 0-.321-1.353-1.669-2.049-2.042-.383-.205-3.402-.422-3.779-.272m11.642.287c-.523.319-.656.332-.976.098-.488-.357-1.092-.343-1.634.036-.435.305-.439.355-.439 5.599 0 5.812.027 5.946 1.226 5.946.945 0 1.038-.361 1.144-4.425l.099-3.773.715-.694c.609-.593.805-.677 1.334-.568.547.112 1.803-.791 1.803-1.296 0-1.09-2.05-1.668-3.272-.923m-94.772.121c-.419.419-.502 10.908-.089 11.321.324.324 1.048.297 1.748-.065l.582-.301v-5.304c0-4.003-.06-5.354-.246-5.508-.495-.409-1.646-.491-1.995-.143m-68.741.15c1.043.476 2.052 1.749 1.996 2.519-.049.665-.701.937-.907.377-.036-.099-.19-.18-.343-.18-.153 0-.479-.306-.725-.682-.831-1.269-2.915-1.208-4.209.125l-.78.803-.069 1.967c-.09 2.596.022 3.064.975 4.059.983 1.028 3.005 1.257 3.688.417.189-.233.719-.833 1.176-1.334l.832-.91.411.409c1.197 1.191-1.586 3.648-4.112 3.631-3.69-.025-5.564-3.687-4.305-8.415.628-2.356 4.04-3.848 6.372-2.786m11.398.474c.969.755 1.241 1.319 1.034 2.144-.19.759-.796.619-1.436-.334-.637-.946-1.414-1.245-2.828-1.087-2.533.283-3.494 4.582-1.694 7.577.894 1.485 3.89 1.479 4.478-.009.399-1.011.688-1.238 1.458-1.148.618.072 1.109.828.538.828-.087 0-.27.311-.408.691-.137.38-.322.692-.411.692-.089 0-.444.288-.79.641-.903.923-4.318.995-5.203.11-.293-.293-.655-.604-.805-.691-1.223-.713-1.9-4.844-1.1-6.71.787-1.836 1.021-2.239 1.299-2.239.154 0 .335-.144.402-.319.432-1.127 4.082-1.224 5.466-.146m11.123.23c1.143.964 1.902 2.61 1.928 4.179.019 1.109-.2 1.164-4.704 1.18-3.877.014-4.492.545-2.756 2.382.257.271.59.668.74.881.795 1.13 3.641.578 4.565-.886.506-.802 1.052-1.003 1.443-.532.281.339-.036 1.734-.446 1.964-.171.096-.541.387-.822.648-.609.564-1.721.765-3.639.656l-1.388-.078-1.193-1.193c-1.527-1.527-1.89-3.166-1.436-6.48.137-.999 1.332-2.562 2.537-3.317 1.209-.757 3.94-.443 5.171.596m16.006-.611c1.45.95 2.628 2.82 2.628 4.171 0 1.798.003 1.797-3.99 1.804-4.411.009-4.61.096-3.81 1.672.805 1.587 1.527 2.089 2.997 2.085 1.395-.004 1.789-.164 2.252-.914.758-1.226 2.156-1.663 2.156-.673 0 .432-.274.878-1.058 1.72l-1.058 1.137-1.412.08c-2.065.117-3.081-.087-3.826-.767-.349-.319-.694-.58-.767-.58-.073 0-.28-.334-.46-.741-.18-.408-.46-.963-.622-1.235-.438-.733-.311-4.554.169-5.084.188-.208.343-.491.343-.628 0-.318 1.689-1.967 2.245-2.191.803-.325 3.646-.227 4.213.144m6.518.306c.431.387.435.387.958-.024.719-.566 1.744-.726 2.677-.418 1.41.466.859 1.173-1.153 1.481-1.631.249-2.069 1.417-2.214 5.915-.108 3.331-.111 3.354-.602 3.598-.978.487-1.027.217-1.009-5.473.02-6.016.074-6.22 1.343-5.079m13.699.28c1.073 1.084 1.177 1.615 1.157 5.889-.009 1.956.014 3.674.051 3.819.184.714-.796.892-1.393.254-.361-.388-.767-.616-1.094-.616-.689 0-.831-.452-.354-1.129 1.519-2.155 1.169-3.718-.671-2.995-.204.08-.71.152-1.123.16-2.183.04-3.306.965-2.989 2.46.243 1.145.551 1.307 2.494 1.307 1.414 0 1.776.06 1.873.311.273.713-.429.972-2.631.972h-2.088l-.57-.683c-2.469-2.958-.06-6.076 4.389-5.68l1.109.099.692-.898.693-.898-.616-.841c-1.147-1.563-3.607-1.512-5.084.106-.972 1.064-1.172 1.058-1.436-.047-.346-1.449 1.676-2.515 4.659-2.458l2.114.041.818.827m21.41-.648c.366.153.74.406.833.562.093.156.395.429.672.607 1.018.656 1.706 4.247 1.158 6.046-.118.388-.326 1.061-.462 1.495-.149.479-.434.884-.723 1.029-.262.132-.623.42-.802.64-.956 1.174-4.993 1.112-5.78-.088-.167-.256-.477-.519-.688-.586-1.398-.444-1.572-8.402-.183-8.402.099 0 .42-.245.714-.544 1.017-1.034 3.682-1.418 5.261-.759m12.144-.062c1.687.505 2.218 2.232 2.147 6.982l-.055 3.741-.669.173c-1.023.265-1.06.127-1.085-4.036-.033-5.273-.388-5.913-3.086-5.563-.73.095-1.003.256-1.53.903l-.642.788v3.715c0 4.507-.122 4.884-1.336 4.127-.404-.252-.41-9.917-.007-10.402.308-.371.966-.3 1.452.157l.432.405.603-.603c.671-.671 2.278-.836 3.776-.387m33.673.389c.239.279.588.565.774.637.187.071.442.377.566.679.125.302.436.988.69 1.526 1.174 2.477.801 2.75-3.941 2.874-4.173.11-4.394.184-3.917 1.31 1.166 2.758 4.342 3.37 5.94 1.145.345-.481.661-.874.701-.874 1.346 0 1.199 1.512-.263 2.711l-.911.745h-2.079c-2.357 0-3.001-.322-4.328-2.17l-.616-.857v-5.296l.609-.678c.334-.373.667-.769.74-.881 1.014-1.555 4.958-2.124 6.035-.871m6.535.103c.372.568.824.62.985.113.436-1.373 4.244-1.096 5.443.395.879 1.094.977 1.686.982 5.931.005 4.085-.109 4.52-1.071 4.082-.466-.213-.469-.234-.536-4.022-.058-3.289-.114-3.86-.413-4.189-.19-.21-.346-.472-.346-.583 0-1.069-3.034-1.343-3.87-.348-1.198 1.425-1.164 1.281-1.196 5.209-.032 3.978-.207 4.583-1.131 3.907-.5-.365-.502-10.568-.002-10.942.397-.297.759-.157 1.155.447m22.527-.536c.954.277 2.202 1.58 2.485 2.594.136.489.321.973.411 1.076.091.104.165.601.165 1.105 0 1.23-.494 1.374-4.711 1.374h-3.183l-.124.494c-.776 3.092 4.437 4.466 6.141 1.618.503-.839 1.166-.666 1.248.326.141 1.725-1.898 2.834-4.902 2.665l-1.384-.078-1.188-1.177c-1.393-1.378-1.574-1.878-1.574-4.341 0-4.414 2.762-6.775 6.616-5.656m7.456.47c.403.428.633.556.692.384.331-.966 1.963-1.359 2.807-.676l.432.35-.41.52c-.346.44-.524.506-1.151.425-.665-.087-.822-.013-1.531.719l-.79.815-.099 3.949c-.106 4.246-.209 4.632-1.085 4.05-.642-.426-.718-10.312-.083-10.832.545-.446.513-.454 1.218.296m-92.612-.186c.321.234.355.711.383 5.33l.031 5.072-.531.22c-.292.121-.626.162-.741.09-.323-.2-.287-10.708.038-10.839.387-.156.445-.147.82.127m-51.447 1.088c-1.17.314-2.229 2.083-1.846 3.082.154.401 5.175.469 5.569.076 1.472-1.473-1.285-3.811-3.723-3.158m16.487.018c-1.148.5-1.913 2.455-1.228 3.14.298.298 4.561.325 5.109.032.634-.339.505-1.521-.263-2.419-.682-.798-2.599-1.197-3.618-.753m41.992-.044c-2.378.495-3.066 5.855-1.001 7.799 2.015 1.898 4.945.597 5.228-2.321.413-4.265-1.035-6.141-4.227-5.478m45.396.005c-1.338.205-2.605 2.994-1.495 3.291.845.227 4.994.138 5.244-.112.63-.63-.082-2.525-1.152-3.066-.47-.238-1.489-.282-2.597-.113m29.863-.009c-.719.142-1.976 1.572-1.976 2.248 0 1.177.001 1.177 2.963 1.177 3.003 0 2.963.017 2.963-1.303 0-1.562-1.824-2.541-3.95-2.122m-130.825.896c.627.607.787 1.156.532 1.821-.198.517-3.695.449-4.226-.082-.404-.404-.543-1.186-.211-1.186.102 0 .243-.183.314-.407.316-.997 2.617-1.091 3.591-.146m16.671-.018c1.285 1.375.594 2.152-1.912 2.152-1.94 0-2.255-.168-2.255-1.202 0-1.383 3.102-2.091 4.167-.95m41.669-.053c.271.309.624.605.785.659.237.079.292.562.292 2.573v2.476l-.816.816c-1.22 1.22-2.698 1.211-3.898-.023l-.817-.84V175.901l.791-.833c1.052-1.109 2.819-1.246 3.663-.285m45.508.131c.688.668.787 1.182.37 1.926-.229.407-3.786.154-4.098-.291-1.267-1.809 2.052-3.264 3.728-1.635m29.805-.045c.7.623.869 1.125.607 1.806-.252.657-3.756.434-4.425-.282l-.555-.595.78-.788c1.077-1.088 2.467-1.142 3.593-.141m-97.781 4.341c.458.34.084 1.541-.727 2.334-.737.721-3.373.892-3.625.235-.591-1.539.151-2.441 2.161-2.626a91.492 91.492 0 001.649-.161c.115-.016.359.082.542.218"
        ></path>
        <path
          fill="#7c7c84"
          d="M304 .374c0 .36.54.732.753.52.056-.057-.001-.104-.127-.104-.127 0-.231-.178-.231-.395 0-.217-.089-.395-.197-.395-.109 0-.198.168-.198.374m3.012.947c.19.05.502.05.692 0 .19-.049.034-.09-.346-.09s-.536.041-.346.09m9.729 2.235c.217.093.573.167.79.164.317-.005.298-.037-.099-.164-.675-.217-1.195-.217-.691 0m-61.05 10.913l-.58.642.642-.58c.598-.541.733-.704.58-.704-.034 0-.323.289-.642.642m97.099 1.988c0 .034.289.323.642.642l.642.58-.58-.642c-.541-.598-.704-.733-.704-.58m19.105 14.362c.35.367.669.627.71.578.041-.048-.245-.349-.636-.667l-.71-.578.636.667m5.592 6.659c-.003.134.239.494.538.8.298.306.399.374.224.151a7.21 7.21 0 01-.537-.799c-.12-.218-.221-.286-.225-.152M243.802 56.895c-.244.098-.444.236-.444.305s.156.05.346-.043c.19-.092 2.301-.216 4.691-.275l4.346-.107-4.247-.029c-2.336-.016-4.447.051-4.692.149m47.883-.055c-.051.081 1.957.122 4.461.091 4.465-.055 4.563-.048 5.019.38.255.24.465.365.465.277 0-.778-9.485-1.492-9.945-.748m-276.54.592c7.406.029 19.584.029 27.062 0 7.477-.029 1.418-.052-13.466-.052-14.884 0-21.002.023-13.596.052m286.566 3.803c0 1.901.029 2.679.066 1.728.036-.951.036-2.506 0-3.457-.037-.95-.066-.173-.066 1.729m-59.077-1.778c0 .815.035 1.148.078.741a8.731 8.731 0 000-1.482c-.043-.407-.078-.074-.078.741m48.576-.692c.003.435.043.59.09.344s.046-.601-.004-.79c-.049-.189-.088.012-.086.446m-170.067 1.186c.001.543.04.742.085.441.046-.3.044-.744-.003-.987-.046-.243-.084.002-.082.546m132.57 3.16c0 2.282.029 3.188.064 2.014.035-1.174.035-3.04 0-4.148-.035-1.108-.064-.147-.064 2.134m-197.338-.988c.001 1.63.031 2.27.068 1.424a39.55 39.55 0 000-2.963c-.038-.783-.068-.09-.068 1.539M0 61.235c0 1.251.038 1.382.395 1.382.357 0 .395-.131.395-1.382s-.038-1.383-.395-1.383c-.357 0-.395.132-.395 1.383m242.837 2.37c0 1.032.033 1.454.074.938.04-.516.04-1.36 0-1.876-.041-.516-.074-.094-.074.938m-139.087-.79c0 .38.04.536.09.345.05-.19.05-.501 0-.691-.05-.19-.09-.034-.09.346m187.674 5.531c0 .814.035 1.148.078.74a8.518 8.518 0 000-1.481c-.043-.407-.078-.074-.078.741m-274.041-.388l-2.272.135 2.81-.042c2.65-.04 2.828-.019 3.127.373.302.396.303.392.032-.078-.329-.57-.433-.581-3.697-.388m18.815.188c-.354.215-.642.447-.642.516 0 .068.244-.037.543-.233a4.134 4.134 0 011.234-.494c.678-.134.68-.137.099-.158-.326-.013-.881.154-1.234.369m142.814-.249a8.529 8.529 0 001.482 0c.407-.043.074-.078-.741-.078s-1.148.035-.741.078m-139.447.201c.847.037 2.18.036 2.963-.001.782-.037.089-.068-1.54-.067-1.63 0-2.27.03-1.423.068m203.422 4.807c.013 2.762.084 5.954.157 7.095.072 1.141.094-1.081.048-4.938-.046-3.857-.117-7.05-.157-7.095-.039-.045-.061 2.177-.048 4.938m58.519-2.88c0 1.195.033 1.658.072 1.03.04-.629.039-1.607-.001-2.173-.039-.567-.071-.052-.071 1.143M13.187 68.288c.246.047.602.045.791-.004.188-.05-.013-.088-.447-.086-.435.002-.589.043-.344.09m31.504-.004c.19.05.502.05.692 0 .19-.049.034-.09-.346-.09s-.536.041-.346.09m-33.479.201c.246.048.601.046.79-.004.189-.049-.012-.088-.446-.086-.435.003-.59.043-.344.09m35.257-.003c.19.05.501.05.691 0 .191-.05.035-.09-.345-.09s-.536.04-.346.09m-40.691.197c.19.05.501.05.691 0 .19-.049.035-.09-.346-.09-.38 0-.535.041-.345.09m45.333.004c.245.047.645.047.889 0s.044-.086-.444-.086c-.489 0-.689.039-.445.086m202.393 1.934c.001 1.087.034 1.506.074.932.04-.574.04-1.463-.001-1.975-.041-.513-.073-.043-.073 1.043m-142.245-1.543c.19.05.501.05.692 0 .19-.049.034-.09-.346-.09s-.536.041-.346.09m-89.854 2.037c0 1.032.033 1.454.074.938.04-.516.04-1.36 0-1.876-.041-.516-.074-.094-.074.938m13.851 18.568c0 11.244.023 15.844.053 10.222.029-5.622.029-14.822 0-20.444-.03-5.622-.053-1.022-.053 10.222m174.776-19.457c.001.543.04.742.085.442.045-.3.044-.745-.003-.988s-.084.003-.082.546m-24.505-.099c0 .381.041.536.091.346.049-.19.049-.501 0-.691-.05-.19-.091-.035-.091.345m209.963.198c.01.513.321 1.356.328.889a2.302 2.302 0 00-.164-.79c-.104-.242-.167-.281-.164-.099m-210.354 2.272c.002.434.043.589.09.343.047-.246.046-.601-.004-.79-.049-.189-.088.012-.086.447m106.44 3.177c.012 1.62.087 3.746.166 4.724.083 1.018.105-.207.051-2.864-.052-2.553-.127-4.679-.166-4.725-.039-.045-.062 1.244-.051 2.865m54.745-.967c.19.05.501.05.691 0 .19-.05.035-.091-.345-.091-.381 0-.536.041-.346.091m-261.333.395c.19.05.501.05.691 0 .19-.05.035-.09-.346-.09-.38 0-.535.04-.345.09m3.555 0c.19.05.501.05.692 0 .19-.05.034-.09-.346-.09s-.536.04-.346.09m63.615.011c.956.036 2.467.036 3.358 0 .891-.037.109-.067-1.738-.066-1.847 0-2.576.03-1.62.066m57.323.84c-.075.45-.093.862-.039.916.055.054.161-.269.237-.718.076-.449.094-.861.039-.916-.054-.054-.161.269-.237.718m116.792-.214c.352.352.641.737.641.855s.051.164.114.101c.171-.172-.505-1.121-.98-1.375-.268-.143-.189.005.225.419m-24.959 2.486c0 1.63.03 2.27.068 1.423.037-.847.036-2.18-.001-2.963-.037-.783-.068-.09-.067 1.54m-279.708-.395c.001 1.304.033 1.811.071 1.128.039-.683.039-1.75 0-2.37-.039-.621-.071-.062-.071 1.242m60.567-1.975c-.272.155-.405.282-.296.282.108 0 .419-.127.691-.282.272-.156.405-.283.296-.283-.108 0-.42.127-.691.283m171.105 3.061a226.157 226.157 0 01-.133 5.432l-.087 1.976.187-1.877c.103-1.032.163-3.476.133-5.432l-.054-3.555-.046 3.456m-107.895-2.963c-.397.128-.417.16-.099.164.217.004.573-.07.79-.164.503-.216-.016-.216-.691 0m39.552.593c0 .38.04.536.09.346.05-.19.05-.502 0-.692-.05-.19-.09-.034-.09.346m-119.7-.259c.19.05.501.05.691 0 .19-.05.034-.09-.346-.09s-.536.04-.345.09m46.716.003c.244.047.644.047.889 0 .244-.047.044-.085-.445-.085s-.689.038-.444.085m-6.519.988c.245.047.645.047.889 0s.044-.086-.444-.086c-.489 0-.689.039-.445.086m211.341.29c-.062.236-.045.549.037.696.09.161.156-.007.168-.43.023-.797-.043-.883-.205-.266m-213.286.139c-.4.324-.428.43-.218.839l.239.469-.123-.475c-.092-.357-.006-.566.345-.836.257-.197.411-.361.341-.364-.069-.002-.332.163-.584.367m223.871.913c.003.435.043.589.09.343.048-.245.046-.601-.004-.79-.049-.189-.088.012-.086.447m68.943.099c0 .489.038.689.085.444a2.82 2.82 0 000-.889c-.047-.244-.085-.044-.085.445m-214.968.402c-.318.106-.108.124.593.052.597-.062 1.123-.145 1.169-.185.158-.138-1.272-.031-1.762.133M118.169 80c0 .38.041.536.091.346.049-.19.049-.502 0-.692-.05-.19-.091-.034-.091.346m278.329.79c0 .489.039.689.086.445a2.82 2.82 0 000-.889c-.047-.245-.086-.045-.086.444m-278.661 2.183c-.077.991-.099 1.843-.048 1.894.051.052.157-.717.236-1.707.078-.989.1-1.842.048-1.894-.052-.052-.158.716-.236 1.707m-43.576-.85l-.681.741.741-.681c.407-.374.741-.707.741-.74 0-.151-.167-.009-.801.68m243.221-.049c.002.435.043.589.09.343.047-.245.045-.601-.004-.79-.05-.189-.088.013-.086.447m-213.724.494c0 .489.038.689.085.444a2.82 2.82 0 000-.889c-.047-.244-.085-.044-.085.445m48.888.341c.355.044.888.043 1.185-.002.297-.045.006-.081-.646-.08-.652.001-.895.038-.539.082m139.392 6.079c0 3.259.027 4.62.06 3.024s.034-4.262 0-5.926c-.033-1.663-.06-.358-.06 2.902m-83.381-4.346c.001.76.037 1.047.08.638a7.33 7.33 0 00-.002-1.383c-.043-.351-.078-.016-.078.745m-76.595-.346c-.426.546-.461.638-.129.348.396-.346.918-1.088.765-1.088-.031 0-.317.333-.636.74m-72.772-.444c0 .108.119.508.266.889.146.38.269.558.272.395.003-.163-.116-.563-.265-.889-.15-.326-.272-.504-.273-.395m100.611 1.212c.109.095.509.44.888.765l.691.591-.493-.562c-.271-.308-.671-.653-.888-.765-.218-.111-.306-.125-.198-.029m157.96 1.553c-.003.218.07.573.164.79.216.504.216-.016 0-.691-.127-.397-.16-.416-.164-.099m-257.959.593c.002.434.042.589.09.343.047-.245.045-.601-.004-.79-.05-.189-.089.012-.086.447m148.52.099a8.79 8.79 0 01-.134.987l-.102.494.213-.486c.116-.268.177-.712.134-.988l-.079-.501-.032.494m189.071 1.284c.001.651.038.894.082.539a5.263 5.263 0 00-.002-1.185c-.045-.297-.081-.006-.08.646m-313.691-.744c.517.041 1.361.041 1.877 0s.094-.074-.938-.074-1.455.033-.939.074m92.611.546c-.007.109.16.731.369 1.383.21.652.38 1.007.377.79-.005-.416-.724-2.513-.746-2.173m-72.1.494c.006.163.087.474.181.691l.17.395.01-.395a1.426 1.426 0 00-.18-.691c-.17-.263-.19-.263-.181 0m223.437.79c0 .38.04.536.09.346.05-.19.05-.502 0-.692-.05-.19-.09-.034-.09.346m-222.989 2.469c0 .978.033 1.403.075.944.041-.458.042-1.258.001-1.777-.041-.52-.075-.145-.076.833m-82.968-.197c.001.76.037 1.047.08.637a7.415 7.415 0 00-.002-1.383c-.044-.35-.079-.015-.078.746m107.688-.692c-.075.342-.095.662-.044.713.05.05.148-.193.217-.54.165-.823.005-.983-.173-.173m13.208 2.074c.001 1.087.034 1.506.074.932.04-.574.04-1.463-.001-1.975-.04-.513-.073-.043-.073 1.043m254.99-1.185c.003.435.043.589.09.344.048-.246.046-.602-.004-.791-.049-.188-.088.013-.086.447m-233.86 1.482c0 .814.035 1.148.078.74a8.518 8.518 0 000-1.481c-.043-.408-.078-.074-.078.741m89.271-.099c-.006.652.054 1.985.134 2.963l.146 1.778.005-1.482a36.708 36.708 0 00-.134-2.963l-.14-1.481-.011 1.185m-135.468 8.988c0 5.377.026 7.577.057 4.888.031-2.688.031-7.088 0-9.777-.031-2.689-.057-.489-.057 4.889m59.415-8.791c.003.435.043.589.09.344.048-.246.046-.601-.004-.79-.049-.189-.088.012-.086.446m150.91.494c0 .38.041.536.09.346.05-.19.05-.501 0-.691-.049-.191-.09-.035-.09.345m69.914-.296c-.003.217.07.573.164.79.216.503.216-.016 0-.691-.127-.397-.16-.417-.164-.099m-190.408.494c0 .38.041.536.091.345.049-.19.049-.501 0-.691-.05-.19-.091-.034-.091.346m-146.952.494c.001.543.04.742.085.441.046-.3.044-.744-.003-.987-.046-.243-.084.002-.082.546m182.923 1.284c0 .814.035 1.148.078.74a8.518 8.518 0 000-1.481c-.043-.408-.078-.074-.078.741m-138.443 9.481c0 5.921.025 8.343.056 5.383.031-2.961.031-7.805 0-10.766-.031-2.96-.056-.538-.056 5.383m223.168-9.975c.002.434.042.589.089.343.048-.246.046-.601-.004-.79-.049-.189-.088.012-.085.447M73.772 107.457c0 6.79.025 9.568.055 6.173.03-3.395.03-8.951 0-12.346-.03-3.395-.055-.617-.055 6.173m102.736-11.739c-.073.289-.094.564-.048.611.047.046.145-.152.217-.442.073-.289.094-.564.048-.611-.047-.046-.144.152-.217.442m115.145 1.52c-.077.913-.103 1.831-.059 2.038.044.208.145-.501.224-1.575.08-1.074.106-1.991.059-2.038-.048-.048-.148.661-.224 1.575m-230.957.342c0 .489.038.689.085.445a2.82 2.82 0 000-.889c-.047-.245-.085-.045-.085.444m267.673 1.383c0 1.141.033 1.607.073 1.037.04-.57.04-1.504 0-2.074-.04-.57-.073-.104-.073 1.037m39.483.099c.002.434.043.589.09.343.047-.246.046-.601-.004-.79-.049-.189-.088.012-.086.447m-10.265.395c.002.543.04.742.086.442a3.54 3.54 0 00-.003-.988c-.047-.243-.084.003-.083.546m-113.978.099c0 .488.039.688.086.444a2.82 2.82 0 000-.889c-.047-.244-.086-.044-.086.445m9.873.098c.002.435.043.589.09.344.047-.246.045-.602-.004-.79-.05-.189-.088.012-.086.446m-46.424.297c0 .38.041.535.091.345.049-.19.049-.501 0-.691-.05-.19-.091-.035-.091.346m-146.137 3.16c0 2.01.03 2.832.066 1.827a61.827 61.827 0 000-3.654c-.036-1.005-.066-.183-.066 1.827m257.971-.889c0 1.413.031 1.964.069 1.227.039-.738.038-1.894 0-2.568-.039-.675-.07-.071-.069 1.341m49.167-.889c0 .598.037.842.082.544a4.298 4.298 0 000-1.087c-.045-.299-.082-.054-.082.543m-76.655.198c0 .38.041.536.09.346.05-.191.05-.502 0-.692-.049-.19-.09-.034-.09.346m37.155 1.086c.001.761.036 1.048.079.638a7.33 7.33 0 00-.002-1.383c-.043-.351-.078-.015-.077.745m-74.87.099c0 .598.037.842.082.543a4.385 4.385 0 000-1.086c-.045-.299-.082-.054-.082.543m-232.082 1.975c0 1.358.032 1.914.07 1.235.039-.679.039-1.79 0-2.469-.038-.679-.07-.124-.07 1.234m128.63-1.556c.12.195 1.424.617 1.651.535.1-.036-.251-.203-.78-.373-.528-.169-.92-.242-.871-.162m217.615.47c.002.435.043.589.09.343.047-.245.046-.601-.004-.79-.049-.189-.088.012-.086.447m-212.395-.099c-.407.13-.424.161-.099.175.217.009.528-.07.691-.175.346-.223.106-.223-.592 0m243.378 1.202c.01.588.089 1.292.174 1.564.087.278.109-.152.051-.988-.121-1.755-.253-2.092-.225-.576m-107.625.082c.003.435.043.589.09.343.047-.245.046-.601-.004-.79-.049-.188-.088.013-.086.447m-158.469-.432c0 .049.326.338.725.642.399.304.663.452.587.329-.157-.253-1.312-1.108-1.312-.971m111.062 1.025c.002.434.043.589.09.343.047-.246.045-.601-.004-.79-.05-.189-.088.012-.086.447m113.784.395c.002.543.04.742.086.442a3.54 3.54 0 00-.003-.988c-.047-.243-.084.003-.083.546m-38.51.987c.001.761.037 1.048.08.638a7.415 7.415 0 00-.002-1.383c-.044-.35-.079-.015-.078.745m-112.798 0c.001.544.04.742.085.442.045-.3.044-.745-.003-.987-.047-.243-.084.002-.082.545m192.996.789c.04.937.725 1.326.725.411 0-.308-.111-.508-.282-.508-.155 0-.326-.156-.379-.346-.054-.19-.083.009-.064.443m-261.858.3c.128.165.269.654.313 1.087l.08.787.033-.815c.024-.571-.07-.897-.312-1.086-.302-.237-.316-.233-.114.027m-76.707 1.479c0 .869.035 1.2.077.736a9.91 9.91 0 00-.001-1.58c-.043-.405-.077-.025-.076.844m-39.305.988c.001 1.086.034 1.506.074.932.04-.574.04-1.463-.001-1.976-.04-.512-.073-.042-.073 1.044m297.89 9.185c-.002 8.34.02 9.268.115 4.741.065-3.096.066-7.763.003-10.37-.082-3.352-.116-1.703-.118 5.629m-175.31-8.741l-.479.544.494-.42c.272-.23.627-.468.79-.527.254-.093.252-.111-.015-.124-.171-.009-.527.229-.79.527M35.43 112.296c.001 1.087.034 1.506.074.932.04-.574.039-1.463-.001-1.975-.041-.513-.073-.043-.073 1.043m363.692-.845c-.169.242-.304.575-.299.741.004.166.129.021.279-.322.149-.344.435-.667.634-.718.309-.08.313-.097.028-.117-.184-.012-.473.175-.642.416m-338.604 2.327c0 1.141.032 1.607.072 1.037.04-.571.04-1.504 0-2.074-.04-.571-.072-.104-.072 1.037m184.618-1.043c0 .115.183.419.407.675l.406.467-.347-.593c-.456-.78-.466-.792-.466-.549M35.62 116.247c.001.76.037 1.047.08.637a7.404 7.404 0 00-.002-1.382c-.044-.351-.079-.016-.078.745m24.673.889c0 .38.04.536.09.345.05-.19.05-.501 0-.691-.05-.19-.09-.034-.09.346M104.768 120c0 1.412.032 1.964.07 1.226.038-.737.038-1.893-.001-2.568-.038-.674-.069-.07-.069 1.342m-68.942.099c0 1.141.033 1.607.073 1.037.04-.571.04-1.504 0-2.074-.04-.571-.073-.104-.073 1.037m81.967-.297c.001.761.037 1.048.08.638a7.415 7.415 0 00-.002-1.383c-.044-.35-.079-.015-.078.745m167.729-.444l-.781.84.839-.781c.781-.726.931-.898.781-.898-.032 0-.41.377-.839.839m-153.712.247c.001.543.039.742.085.442a3.54 3.54 0 00-.003-.988c-.047-.243-.084.003-.082.546m231.269-.023l-.477.616.565-.538c.311-.295.525-.572.477-.616-.049-.043-.303.199-.565.538m-214.881.258c.19.05.501.05.691 0 .19-.05.034-.09-.346-.09s-.536.04-.345.09m1.878.201c.246.047.602.045.791-.004.188-.049-.013-.088-.447-.086-.435.002-.589.043-.344.09m-89.977.749c.002.435.043.589.09.343.047-.245.046-.601-.004-.79-.049-.188-.088.013-.086.447m107.605-.099c.675.217 1.194.217.691 0a2.325 2.325 0 00-.79-.164c-.318.005-.298.037.099.164m-35.72.494c-.003.217.071.573.164.79.216.504.216-.016 0-.691-.127-.397-.159-.416-.164-.099m-14.008.79c.002.435.042.589.09.344.047-.246.045-.602-.004-.79-.05-.189-.088.012-.086.446m175.246 1.136l-.58.642.642-.58c.598-.541.733-.704.58-.704-.034 0-.323.289-.642.642m-26.978-.045c.473.215.918.387.987.383.25-.017-1.262-.766-1.552-.77-.163-.002.091.172.565.387m-148.059 1.477c.001.652.038.895.082.54a5.263 5.263 0 00-.002-1.185c-.045-.297-.081-.007-.08.645m133.272-.395c.368.38.714.692.769.692.054 0-.203-.312-.572-.692-.368-.38-.714-.691-.769-.691-.054 0 .203.311.572.691m-147.039.616c-.073.615-.092 1.158-.044 1.206.048.049.15-.412.226-1.024.077-.612.096-1.155.044-1.207-.052-.052-.154.409-.226 1.025m165.461-.968c.301.045.745.044.988-.003s-.003-.084-.546-.082c-.543.001-.742.04-.442.085m4.148 0c.301.045.745.044.988-.003s-.003-.084-.546-.082c-.543.001-.742.04-.442.085m84.783 1.29l-1.378 1.433 1.432-1.378c1.33-1.279 1.523-1.487 1.378-1.487-.03 0-.675.645-1.432 1.432m-21.674-1.095c.244.047.644.047.889 0 .244-.047.044-.085-.445-.085s-.689.038-.444.085m2.37.203c.462.042 1.217.042 1.679 0 .462-.042.084-.076-.839-.076-.924 0-1.302.034-.84.076m-129.134.493c-.001.078.176.434.393.79.217.355.394.558.393.449 0-.109-.177-.464-.393-.79-.215-.326-.393-.528-.393-.449m-174.368 2.128c0 .489.039.689.086.444a2.82 2.82 0 000-.889c-.047-.244-.086-.044-.086.445m68.156 1.086c.001.652.038.895.082.54a5.263 5.263 0 00-.002-1.185c-.045-.297-.081-.007-.08.645m40.68 3.198c.19.05.501.05.691 0 .19-.05.034-.09-.346-.09s-.536.04-.345.09m174.242 1.543c0 .978.033 1.403.075.944.041-.458.042-1.258.001-1.778-.041-.519-.075-.144-.076.834m-172.267-1.345c.19.049.501.049.691 0 .19-.05.035-.091-.346-.091-.38 0-.535.041-.345.091m118.913 0c.191.049.502.049.692 0 .19-.05.034-.091-.346-.091s-.536.041-.346.091m70.124 0c.19.049.501.049.691 0 .19-.05.035-.091-.345-.091-.381 0-.536.041-.346.091m10.864 0c.19.049.501.049.691 0 .191-.05.035-.091-.345-.091-.381 0-.536.041-.346.091m-75.457.205a8.529 8.529 0 001.482 0c.407-.043.074-.078-.741-.078s-1.148.035-.741.078m69.926 0a8.529 8.529 0 001.482 0c.407-.043.074-.078-.741-.078s-1.148.035-.741.078m-22.293 6.572c0 1.467.031 2.067.069 1.333.038-.733.038-1.933 0-2.666-.038-.734-.069-.134-.069 1.333m-179.958 1.679c0 .978.033 1.403.075.944.041-.458.041-1.258.001-1.777-.041-.52-.075-.145-.076.833m31.383-1.086c0 .38.041.535.091.345.049-.19.049-.501 0-.691-.05-.19-.091-.035-.091.346m0 1.58c0 .38.041.536.091.346a1.647 1.647 0 000-.692c-.05-.19-.091-.034-.091.346m-43.443 2.173c0 .597.037.842.082.543a4.29 4.29 0 000-1.086c-.045-.299-.082-.055-.082.543m201.903 6.321c0 2.661.028 3.75.062 2.419.034-1.33.034-3.508 0-4.839-.034-1.331-.062-.242-.062 2.42m-162.752-1.37c-.326.209-.492.38-.368.381.124.001.435-.174.691-.387.588-.49.446-.487-.323.006m152.638 3.148c0 .38.041.535.09.345.05-.19.05-.501 0-.691-.049-.19-.09-.035-.09.346m-165.626.34c.353.044.931.044 1.284 0s.064-.08-.642-.08-.995.036-.642.08m165.231 3.215c0 .38.041.536.09.346.05-.19.05-.501 0-.692-.049-.19-.09-.034-.09.346m10.111 1.181c-.111.112-2.078.218-4.632.251l-4.438.058 4.469.045c3.771.038 4.508-.001 4.716-.251.273-.329.188-.406-.115-.103m53.139.844l-.58.642.642-.58c.599-.541.733-.704.58-.704-.034 0-.322.289-.642.642m-240.432 1.469c.191.05.502.05.692 0 .19-.049.034-.09-.346-.09s-.536.041-.346.09m4.198.457c.217.093.573.167.79.164.318-.005.298-.037-.099-.164-.675-.217-1.194-.217-.691 0m12.642 0c-.249.107-.286.169-.099.169.163 0 .474-.076.692-.169.249-.107.285-.17.098-.17-.163 0-.474.076-.691.17m70.025 2.469c.368.38.714.691.768.691.055 0-.202-.311-.571-.691-.368-.38-.714-.692-.769-.692-.054 0 .203.312.572.692m144.876 5.481l-.58.642.642-.58c.598-.541.733-.704.58-.704-.034 0-.323.289-.642.642m-359.938 2.062c.19.05.501.05.691 0 .19-.049.035-.09-.345-.09-.381 0-.536.041-.346.09m157.778.057c.38.081.941.249 1.247.373.306.123.661.219.79.213.514-.024-1.584-.756-2.136-.745-.579.011-.577.015.099.159m-159.21.313l-.692.262.618.011c.34.006.729-.122.864-.285.287-.346.151-.344-.79.012m3.062-.005c.325.149.77.272.987.272.217 0 .04-.128-.395-.285-.992-.357-1.382-.348-.592.013m154.074.016l-.791.277.774-.093c.425-.052.865-.186.977-.299.261-.261.03-.233-.96.115m-145.729.024c.571.04 1.504.04 2.074 0 .571-.04.104-.073-1.037-.073s-1.607.033-1.037.073m7.102.002c1.9.06 2.039.093 2.42.577.222.283.404.428.404.324 0-.732-.905-1.049-2.877-1.007l-1.962.042 2.015.064m-3.346.19c.245.047.601.045.79-.004.189-.05-.012-.089-.447-.086-.435.002-.589.042-.343.09m-13.583.655c0 .172.767.479.889.357.039-.039-.146-.172-.41-.296-.263-.125-.479-.152-.479-.061m74.361 7.007c0 3.911.026 5.539.058 3.618.033-1.921.033-5.121.001-7.111-.033-1.99-.059-.418-.059 3.493m1.383 0c-.001 3.911.026 5.539.058 3.618.032-1.921.033-5.121 0-7.111-.032-1.99-.058-.418-.058 3.493m80.43-6.658c-.053.086.23.125.63.087 1.222-.116 1.366-.197.393-.221-.51-.012-.97.048-1.023.134m-125.912.643c-.152.244-.165.386-.035.386.113 0 .258-.138.322-.305.178-.463-.014-.518-.287-.081m-40.643 6.114c0 3.422.027 4.822.06 3.111.033-1.711.033-4.511 0-6.222-.033-1.711-.06-.311-.06 3.111m23.461.532c-.024 3.497.024 6.4.105 6.45.082.051.126-1.789.098-4.087-.096-7.94-.161-8.699-.203-2.363m17.764-5.421c.024.668.047.719.114.247.136-.955 1.253-.968 1.879-.022.102.155.146.148.148-.023.003-.268-1.383-1.041-1.866-1.041-.231 0-.297.202-.275.839m79.607-.237c-.017.386-.142.83-.277.988-.138.161-.088.147.114-.032.254-.225.335-.513.277-.987l-.082-.67-.032.701m80 0c-.017.386-.142.83-.277.988-.138.161-.088.147.114-.032.254-.225.335-.513.277-.987l-.082-.67-.032.701m-38.07 1.663c-.176.268-.289.567-.251.665.037.098.212-.121.388-.487.378-.783.314-.866-.137-.178m-89.08.945l-.98 1.037 1.037-.981c.57-.539 1.037-1.005 1.037-1.037 0-.147-.183.017-1.094.981m122.336-.541c.111.218.411.573.666.788.446.378.445.371-.028-.199-.787-.948-.853-1.009-.638-.589m22.449 4.837c0 2.879.028 4.057.062 2.617a138.37 138.37 0 000-5.234c-.034-1.44-.062-.262-.062 2.617m-75.091-4.05c.001.544.04.742.085.442.045-.3.044-.745-.003-.987-.047-.243-.084.002-.082.545m2.337-.719c-.015.167-.153.222-.369.145-.206-.073-.147.034.146.262l.491.385-.393.467c-.22.263-.161.232.135-.071.29-.296.779-.576 1.087-.622.478-.072.454-.088-.168-.113-.509-.021-.753-.133-.816-.376-.05-.19-.101-.225-.113-.077m-41.728.966c-.235.301-.232.317.026.12.163-.124.474-.269.691-.322.375-.093.374-.099-.025-.12-.231-.013-.542.132-.692.322m-44.626.785c-.054.459-.023.759.069.667.092-.092.136-.467.098-.834-.067-.651-.071-.646-.167.167m61.523 2.722c.001 1.955.03 2.728.066 1.718.036-1.01.036-2.61 0-3.556-.036-.945-.066-.118-.066 1.838m80.001.098c0 2.01.029 2.832.065 1.827a61.827 61.827 0 000-3.654c-.036-1.005-.065-.183-.065 1.827m-131.022-3.127a3.637 3.637 0 01-.137.691c-.108.343-.102.344.112.01.124-.193.186-.504.137-.691-.081-.306-.092-.307-.112-.01m-66.344 1.053c.002.435.043.589.09.344.047-.246.046-.602-.004-.791-.049-.188-.088.013-.086.447m113.808 2.568c0 1.738.031 2.423.067 1.522.037-.902.037-2.324 0-3.161-.037-.837-.067-.099-.067 1.639m60.443-2.782c-.059.154-.076.532-.037.84.058.456.089.405.168-.28.1-.864.056-1.05-.131-.56m-86.96.536c-.021.476.084.807.314.987.301.237.316.233.115-.026-.127-.163-.269-.607-.314-.987l-.084-.691-.031.717m5.921.014c-.017.467-.152.804-.373.932-.325.19-.325.202-.003.208.384.006.627-.689.491-1.406-.06-.317-.097-.231-.115.266m55.129 3.154c-.033 2.888-.108 3.91-.292 3.984-.193.078-.192.103.006.116.418.025.45-.331.389-4.238l-.058-3.747-.045 3.885m8.894-3.095c.002.435.042.589.09.344.047-.246.045-.602-.004-.79-.05-.189-.088.012-.086.446m36.576 3.161c0 2.173.029 3.088.064 2.035.036-1.053.036-2.831.001-3.951-.036-1.119-.065-.257-.065 1.916m-57.07-1.383c0 1.011.065 1.736.145 1.611.08-.126.145-.85.145-1.611 0-.76-.065-1.485-.145-1.611-.08-.125-.145.6-.145 1.611m-25.392-1.117c-.406.55-.448.56-1.932.469-.834-.051-1.471-.05-1.417.004.054.053.783.146 1.619.206l1.521.11.399-.676c.484-.82.379-.882-.19-.113m-62.539 1.216c0 .923.034 1.301.075.839.042-.461.042-1.217 0-1.679-.041-.461-.075-.084-.075.84m78.321-.741a8.478 8.478 0 00.051 1.63c.088.582.127.36.148-.84.03-1.734-.084-2.185-.199-.79m14.134 2.321c0 1.793.03 2.526.067 1.63.037-.897.037-2.363 0-3.26-.037-.896-.067-.163-.067 1.63m-81.924-2.831c-.187.187-.164 2.634.025 2.634.086 0 .162-.623.169-1.383.007-.761-.004-1.383-.025-1.383-.02 0-.096.059-.169.132m122.98.559c.002.435.043.59.09.344s.046-.601-.004-.79c-.049-.189-.088.012-.086.446m-106.235-.303c-.105.105-1.212.219-2.46.254l-2.268.064 2.297.042c1.838.034 2.346-.017 2.542-.254.272-.328.189-.406-.111-.106m63.794 2.378c0 1.466.031 2.066.069 1.333.038-.733.038-1.933 0-2.667-.038-.733-.069-.133-.069 1.334m76.444 0c0 1.466.031 2.066.069 1.333.038-.733.038-1.933 0-2.667-.038-.733-.069-.133-.069 1.334m-127.231-2.027c.629.039 1.607.039 2.173-.001.567-.04.052-.072-1.143-.071-1.195 0-1.658.033-1.03.072m87.302 0c.625.039 1.647.039 2.272 0 .624-.04.113-.072-1.136-.072-1.25 0-1.761.032-1.136.072m29.827 0c.625.039 1.647.039 2.272 0 .624-.04.113-.072-1.136-.072-1.25 0-1.761.032-1.136.072m-94.824.982c.315.048.585.244.66.479.069.219.17.354.223.301.265-.265-.382-.919-.881-.891l-.536.03.534.081m-38.32.203c.728.038 1.973.038 2.765.001.792-.038.196-.069-1.325-.069s-2.169.03-1.44.068m16.601.001c.842.037 2.22.037 3.062 0 .842-.037.153-.068-1.531-.068s-2.373.031-1.531.068m87.3-.001c.728.038 1.973.038 2.765.001.793-.038.197-.069-1.324-.069-1.521 0-2.17.03-1.441.068m29.055.001c.956.036 2.467.036 3.358 0 .891-.037.109-.067-1.738-.066-1.847 0-2.576.03-1.62.066m-170.553.396c-.239.305-.235.317.039.104.203-.158 1.322-.262 3.259-.302l2.949-.06-2.988-.044c-2.643-.039-3.019-.004-3.259.302m51.531-.132c-.19.111-.344.308-.342.438.002.164.047.171.148.023.079-.118.323-.315.54-.439.217-.123.306-.224.197-.224-.108 0-.353.091-.543.202m17.464 1.079c-.126.277-.225.655-.221.84.005.185.135-.016.288-.446.318-.895.276-1.146-.067-.394m-11.044.681c-.892.543-.809.676.099.157.912-.522.949-.551.724-.55-.1.001-.47.177-.823.393m117.867.451c.096.814.1.818.167.168.038-.367-.006-.743-.098-.835-.092-.092-.123.208-.069.667m-29.847-.005c.095.616.105.622.231.148.138-.517.076-.79-.179-.79-.084 0-.107.289-.052.642m22.745-.382c0 .034.289.322.642.642l.642.58-.58-.642c-.541-.599-.704-.733-.704-.58m-38.113 1.21c-.13.156-.43.322-.666.368-.418.081-.419.084-.017.111.228.014.575-.151.772-.369.196-.217.31-.395.252-.395-.058 0-.211.128-.341.285m-55.276.209c.043.284.226.405.65.431.362.021.44-.007.201-.073a1.497 1.497 0 01-.65-.43c-.234-.292-.254-.284-.201.072m13.435.494c0 .38.041.536.091.346.049-.19.049-.502 0-.692-.05-.19-.091-.034-.091.346m-75.7-.333c0 .034.289.323.642.642l.642.58-.58-.642c-.541-.598-.704-.733-.704-.58m97.999.343c-.027.568.3.985.757.964.211-.01.184-.062-.089-.168-.218-.085-.451-.412-.52-.727-.12-.549-.126-.552-.148-.069m-36.259.073c.414.302.601.269.392-.07-.072-.116-.276-.21-.453-.21-.27 0-.26.045.061.28m76.16.026c-.013.222-.112.512-.22.642-.108.131-.056.115.118-.036.173-.15.271-.439.219-.642-.085-.333-.097-.329-.117.036m147.9 6.421l-.467.407.593-.347c.78-.457.792-.466.549-.466-.115 0-.419.183-.675.406m-2.568 1.185l-.467.407.593-.347c.78-.456.792-.466.549-.466-.115 0-.419.183-.675.406m-5.729 2.568l-.466.407.593-.347c.78-.457.791-.466.548-.466-.114 0-.418.183-.675.406"
        ></path>
        <path
          fill="#6c6c7c"
          d="M301.432.374c0 .516-.364.632-2.897.92-1.213.139-2.502.387-2.864.553-1.004.458-2.142.719-3.148.72-.925.001-1.731.203-2.909.729-.362.161-1.429.37-2.371.463-1.772.176-2.411.326-3.589.839-.38.166-1.569.4-2.642.521s-2.229.346-2.568.501a7.904 7.904 0 01-3.205.7c-1.024.001-1.807.192-3.034.741-.376.168-1.354.376-2.173.462-2.002.211-2.743.372-3.563.774-.38.187-1.312.401-2.071.476-1.172.116-1.466.224-1.95.719-.313.32-.675.582-.805.582s-.485.26-.79.578c-.304.318-.81.685-1.123.814-.313.13-.57.316-.57.413 0 .097-.288.35-.641.561-.642.386-.937.612-2.42 1.856-.435.364-1.057.81-1.383.99-.581.32-1.059.673-3.421 2.522-.646.505-1.385 1.03-1.642 1.166-.63.332-1.409 1.174-1.087 1.174.139 0 .445-.222.681-.494.236-.271.551-.494.699-.494.149 0 .608-.318 1.022-.708.413-.39.959-.787 1.212-.884.254-.097.462-.301.462-.455 0-.154.356-.422.79-.596.435-.174.79-.41.79-.525 0-.116.29-.331.643-.478.588-.246 1.371-.867 2.731-2.164.28-.267.743-.545 1.03-.617.286-.071.572-.292.634-.489.063-.198.359-.445.659-.549.3-.105.886-.512 1.304-.905.417-.394.873-.716 1.014-.716.14 0 .31-.173.377-.385.156-.492.436-.573 2.662-.779 1.007-.093 1.887-.256 1.956-.362.288-.441 1.089-.647 3.128-.806 1.768-.137 2.265-.248 2.764-.617.509-.376.992-.478 2.936-.624 1.978-.147 2.396-.238 2.786-.604.396-.372.767-.448 2.711-.554 2.005-.11 2.335-.181 3.014-.649.666-.459 1.055-.547 3.089-.701 1.996-.152 2.382-.237 2.723-.603.219-.235.417-.432.44-.438.022-.006 1.095-.088 2.382-.182 2.043-.149 2.404-.23 2.829-.629.433-.407.742-.47 2.794-.573 2.582-.13 3.987-.551 3.987-1.194 0-.296-.145-.374-.692-.374-.546 0-.691.078-.691.374m1.778.017c0 .766.859 1.059 3.469 1.182 2.181.104 2.486.163 2.918.569.424.398.783.475 2.923.625 2.113.149 2.484.226 2.772.582.344.426 2.178.78 4.105.793.622.004 1.099.159 1.635.531.679.47 1.004.539 3.141.662 1.312.075 2.442.217 2.513.315.387.533.981.705 3.015.87 1.782.145 2.347.267 2.803.604.447.331 1.096.476 3.01.676 1.93.2 2.551.341 2.971.671.438.345.777.413 1.937.389l1.405-.029-1.086-.127c-.598-.069-1.353-.268-1.679-.44-.758-.402-2.435-.758-3.572-.758-.487 0-1.216-.142-1.62-.316-1.248-.537-1.858-.683-3.668-.879-.962-.104-2.029-.316-2.371-.473-.916-.419-2.019-.663-3.683-.814-.815-.074-1.792-.267-2.173-.428-1.213-.514-2.636-.838-3.688-.841-.671-.001-1.531-.206-2.503-.595-1.062-.425-1.81-.592-2.652-.592-1.168 0-1.934-.175-3.163-.723-.357-.16-1.513-.375-2.568-.479C304.81 1.11 304 .877 304 .387c0-.255-.134-.387-.395-.387-.262 0-.395.132-.395.391m38.937 8.697c.176.103.607.455.959.784.352.328.816.597 1.032.597.222 0 .436.166.493.383.055.21.34.466.634.568.293.103.802.442 1.13.754 1.105 1.049 2.496 2.048 2.853 2.048.195 0 .408.168.474.374.065.206.389.486.72.623.33.137.738.458.905.713.167.254.415.463.552.463.137 0 .593.315 1.013.7.42.384.959.748 1.199.809.24.06.576.323.747.584.172.261.436.475.587.475.152 0 .646.356 1.098.79.453.435.987.79 1.188.79.201 0 .421.172.487.383.067.211.424.483.794.605.37.122.724.385.788.583.063.199.385.474.716.611.33.137.733.45.894.696.161.246.631.582 1.045.748.414.166.808.444.875.619.067.174.384.408.704.52.32.112.723.419.896.682.172.264.441.479.597.479.157 0 .647.356 1.09.79.444.435.981.79 1.193.79.222 0 .388.134.388.313 0 .18.331.442.785.62.432.17.836.467.897.659.061.193.368.44.681.549.314.11.715.421.893.691.177.271.673.633 1.101.804.428.172.778.401.778.509 0 .109.332.354.738.545.406.192.769.507.806.7.038.194.28.564.538.822.259.259.53.723.602 1.031.073.308.377.827.676 1.152.299.326.602.921.673 1.323.081.454.264.772.487.843.374.118.814.888.814 1.423 0 .17.266.614.592.985.326.371.593.854.593 1.072 0 .219.205.594.455.833s.564.811.698 1.271c.134.46.415.928.625 1.041.21.112.481.58.603 1.04.122.46.48 1.076.797 1.368.392.363.575.723.575 1.131 0 .414.146.695.47.908.28.183.571.669.719 1.197.137.49.394.967.571 1.062.176.094.441.513.587.93.147.417.47.981.717 1.252.247.272.51.782.585 1.134.074.352.345.805.602 1.007.257.202.525.626.596.941.25 1.116.313 1.245.664 1.357.371.117.81.888.81 1.421 0 .171.267.614.593.985.325.372.592.846.592 1.056 0 .209.207.583.46.832s.578.829.722 1.29c.144.46.458.965.697 1.122.265.173.482.573.555 1.024.074.457.338.938.691 1.26.524.479.583.674.714 2.347.089 1.14.296 2.171.551 2.747.356.805.428 1.522.569 5.669.165 4.855.34 6.358.773 6.625.176.109.31 1.676.476 5.557.195 4.576.286 5.51.595 6.096.31.588.388 1.414.526 5.53.088 2.662.269 5.58.401 6.485.184 1.264.186 1.793.008 2.285a4.752 4.752 0 00-.236 1.319c-.008 1.078-.324 2.161-.769 2.635-.273.29-.412.7-.413 1.215-.002 1.103-.364 2.271-.821 2.64-.29.235-.439.719-.584 1.893-.156 1.271-.288 1.666-.678 2.03-.381.357-.484.65-.484 1.384 0 1.233-.294 2.204-.767 2.535-.297.209-.416.612-.526 1.787-.114 1.211-.236 1.611-.604 1.979-.361.361-.506.817-.664 2.088-.114.911-.32 1.714-.468 1.824-.469.35-.724 1.039-.724 1.953 0 .969-.295 1.792-.839 2.341-.2.201-.346.646-.346 1.051 0 1.056-.42 2.511-.821 2.849-.236.198-.431.803-.577 1.782-.149 1.003-.354 1.626-.635 1.929-.297.322-.457.851-.566 1.874-.129 1.204-.23 1.482-.653 1.791-.276.2-.501.462-.501.581 0 .119-.289.495-.642.836-.353.341-1.264 1.311-2.025 2.156-.76.845-1.661 1.826-2.002 2.18-.341.354-.68.835-.754 1.068-.074.233-.263.424-.421.424-.157 0-.434.311-.616.691-.181.381-.448.692-.592.692-.145 0-.412.311-.593.691-.181.38-.444.691-.584.691-.14 0-.386.254-.546.564-.16.31-.518.712-.795.893-.277.182-.504.412-.504.513 0 .1-.533.743-1.184 1.427-3.301 3.474-4.142 4.433-4.146 4.729-.002.177-.18.368-.396.425-.216.056-.475.318-.575.581-.1.263-.412.629-.694.814-.281.184-.511.46-.511.613 0 .154-.267.469-.593.701-.326.232-.593.52-.593.641s-.288.505-.642.854c-.353.349-.744.742-.869.874a22.41 22.41 0 01-.592.588c-.399.383-1.356 1.476-2.44 2.786-.38.46-.98 1.136-1.333 1.504-.353.367-.642.792-.642.944 0 .152-.2.338-.445.414-.244.076-.778.438-1.185.804-.578.518-.914.665-1.523.665-.589 0-.9.127-1.259.515-.309.332-.817.578-1.437.694-.584.109-1.129.362-1.393.645-.267.289-.765.517-1.307.598-.561.084-1.022.301-1.285.603-.269.309-.726.519-1.327.61-.504.075-1.161.343-1.46.595-.3.251-.982.563-1.517.693-.535.129-1.107.396-1.27.594-.338.409-1.204.774-1.84.774-.238 0-.684.266-.992.592-.436.463-.729.593-1.334.593-.577 0-.882.124-1.197.486-.279.321-.728.532-1.32.621-.515.077-1.08.317-1.328.565-.237.237-.922.571-1.522.742-.601.17-1.273.491-1.493.712-.225.224-.815.463-1.34.542-.599.09-1.093.307-1.366.602-.252.272-.845.551-1.447.68-.576.124-1.131.379-1.277.588-.293.418-1.129.783-1.792.783-.245 0-.639.222-.875.494-.264.304-.639.494-.975.494-.769 0-1.869.341-2.057.638-.261.411-.187.942.131.942.163 0 .296-.175.296-.388 0-.432.543-.797 1.182-.797.453 0 1.514-.495 1.91-.891.136-.136.584-.31.997-.386a3.838 3.838 0 001.357-.599c.333-.253.958-.555 1.388-.671.43-.115 1.085-.434 1.457-.708.371-.274.81-.498.975-.498.46 0 1.993-.625 1.993-.812 0-.091.475-.303 1.055-.472.58-.168 1.353-.526 1.717-.795.365-.269.855-.489 1.089-.489.234 0 .817-.265 1.295-.589.478-.324 1.098-.591 1.378-.593.281-.002.903-.262 1.383-.578.48-.316 1.247-.674 1.704-.795.457-.122.971-.362 1.143-.534.172-.172.73-.438 1.239-.591.509-.153 1.239-.491 1.622-.75s.998-.534 1.366-.61c.368-.077 1.074-.396 1.569-.71.495-.314 1.083-.573 1.306-.575.223-.002.797-.269 1.275-.592.478-.324 1.071-.589 1.318-.589.247 0 .701-.21 1.008-.466.307-.255 1.011-.572 1.565-.703 1.504-.357 2.374-1.168 6.905-6.436.841-.978 1.76-2.027 2.043-2.33.283-.304.781-.859 1.107-1.235.326-.375.903-1.025 1.284-1.444.38-.42.913-1.029 1.185-1.354.272-.325.999-1.16 1.616-1.855.617-.695 1.307-1.486 1.533-1.758.453-.544 1.094-1.262 2.759-3.087 1.146-1.257 2.066-2.302 2.6-2.954.983-1.199 6.954-7.969 7.724-8.758.378-.387.594-.903.757-1.809.126-.698.392-1.535.591-1.861.2-.326.466-1.167.593-1.869.126-.702.435-1.636.686-2.074.251-.439.516-1.242.589-1.785.074-.543.355-1.418.626-1.944.271-.527.544-1.416.609-1.976.064-.56.342-1.455.618-1.989.276-.533.567-1.449.646-2.034.08-.585.363-1.482.63-1.993.266-.51.549-1.398.628-1.973.078-.574.353-1.44.61-1.923.257-.483.528-1.346.603-1.918.075-.572.389-1.54.699-2.151.309-.611.562-1.421.562-1.8 0-.378.254-1.167.565-1.753.311-.586.628-1.509.705-2.052.077-.544.301-1.344.499-1.778.566-1.244.799-2.075.799-2.85 0-.789.455-1.595.9-1.595.484 0 .4-2.491-.088-2.619-.478-.125-.563-.785-.809-6.27-.105-2.335-.326-4.958-.491-5.827-.506-2.662-.684-4.206-.901-7.802-.25-4.142-.379-5.367-.591-5.63-.253-.313-.588-3.825-.588-6.153 0-1.166-.088-2.614-.196-3.218a207.89 207.89 0 00-.974-4.99c-.086-.403-.436-1.051-.777-1.439-.342-.389-.621-.91-.621-1.157 0-.248-.257-.697-.571-.998-.314-.301-.621-.794-.681-1.095-.06-.302-.337-.819-.614-1.148-.277-.33-.504-.723-.504-.874 0-.151-.311-.757-.692-1.348-.38-.59-.691-1.175-.691-1.299 0-.125-.217-.443-.481-.708-.265-.265-.616-.871-.779-1.346-.164-.476-.43-.939-.591-1.029-.161-.09-.399-.496-.529-.903-.13-.407-.397-.917-.594-1.134-.197-.218-.538-.818-.759-1.335-.221-.517-.583-1.134-.804-1.371-.221-.237-.404-.569-.407-.739-.003-.17-.264-.651-.581-1.069-.317-.419-.63-1.006-.696-1.306-.066-.3-.333-.731-.593-.958-.261-.226-.566-.755-.68-1.175-.113-.421-.429-.974-.701-1.23-.273-.257-.496-.616-.496-.799 0-.184-.216-.651-.479-1.039a12.425 12.425 0 01-.878-1.607c-.219-.497-.486-.903-.592-.903-.107 0-.302-.334-.435-.741-.132-.407-.495-1.033-.805-1.39-.311-.356-.565-.816-.565-1.021 0-.206-.234-.652-.521-.993-.286-.34-.622-.903-.747-1.249-.286-.799-1.504-2.507-1.787-2.507-.118 0-.506-.267-.863-.593-.357-.326-.744-.593-.86-.593-.116 0-.555-.288-.975-.642l-1.53-1.284c-.42-.353-.854-.641-.963-.641-.11 0-.32-.146-.467-.324-.148-.177-.625-.546-1.061-.819-.437-.272-.865-.616-.952-.764-.087-.148-.51-.448-.938-.667-.429-.219-.78-.483-.78-.587 0-.104-.356-.371-.79-.593-.435-.221-.79-.494-.79-.606 0-.111-.247-.31-.548-.44-.574-.249-1.573-.982-2.814-2.065-.404-.353-.831-.642-.947-.642-.117 0-.328-.159-.47-.354-.142-.194-.68-.598-1.197-.897-.516-.299-.938-.612-.938-.696 0-.084-.355-.353-.79-.597-.434-.244-.79-.532-.79-.639 0-.107-.289-.316-.642-.464a3.915 3.915 0 01-1.121-.78c-.263-.281-.56-.511-.66-.511-.099 0-.544-.311-.989-.691-.444-.381-.89-.692-.99-.692-.101 0-.348-.21-.551-.467-.202-.257-.637-.579-.966-.715-.33-.137-.6-.319-.6-.405 0-.086-.444-.43-.987-.764-.543-.334-.988-.683-.988-.774 0-.091-.244-.29-.543-.441-.535-.272-.886-.526-2.587-1.876-.472-.375-1.005-.678-1.185-.675-.299.005-.3.022-.007.193m-94.753 11.546c-.175.268-.49.541-.701.608-.21.067-.774.448-1.251.847a25.96 25.96 0 01-1.59 1.22c-.397.271-1.112.805-1.589 1.185-2.145 1.708-2.519 1.975-2.767 1.975-.145 0-.382.169-.527.376-.144.206-.594.57-.999.809-.404.239-.735.513-.735.608 0 .096-.351.353-.78.572-.429.219-.999.599-1.266.844a17.9 17.9 0 01-1.308 1.038c-.452.326-1.149.863-1.549 1.194-.4.331-.975.758-1.278.948-.303.191-.703.676-.888 1.078-.186.402-.493.874-.683 1.05-.19.175-.482.704-.648 1.175-.166.471-.469 1.012-.674 1.202-.204.191-.482.684-.617 1.097-.135.412-.393.883-.573 1.046-.179.163-.447.608-.594.988-.147.38-.427.87-.622 1.089-.194.219-.5.752-.678 1.185-.179.433-.482.965-.675 1.183a2.464 2.464 0 00-.47.905c-.067.281-.389.849-.718 1.262-.328.413-.597.862-.597.998s-.311.699-.691 1.252c-.38.553-.691 1.11-.691 1.238 0 .128-.21.508-.466.844-.256.337-.529.812-.606 1.057-.078.245-.344.69-.592.988-.249.298-.562.88-.697 1.292-.134.413-.452.958-.706 1.212-.254.254-.561.832-.683 1.285-.122.452-.344.869-.492.927-.149.057-.418.474-.598.928-.18.453-.484 1.002-.675 1.219-.191.217-.465.706-.609 1.086-.144.381-.416.87-.606 1.087-.189.217-.49.749-.668 1.182-.179.433-.487.967-.685 1.186a2.433 2.433 0 00-.48.908c-.066.28-.384.842-.706 1.248-.322.405-.687 1.042-.81 1.415s-.295.678-.382.678c-.364 0-.595 1.278-.803 4.445-.122 1.847-.357 3.891-.522 4.543-.166.652-.334 1.852-.374 2.666l-.072 1.482.26-1.482c.143-.814.398-1.792.567-2.172.223-.506.345-1.769.45-4.7.125-3.444.192-4.041.481-4.247.425-.301.795-.989.795-1.477 0-.206.262-.609.582-.894.343-.306.637-.81.715-1.229.078-.417.319-.832.583-1.005.257-.168.504-.586.577-.976.071-.374.346-.916.611-1.202.266-.287.562-.805.657-1.152.096-.346.408-.863.694-1.149.294-.295.519-.742.519-1.033 0-.321.226-.72.599-1.062.38-.347.644-.818.72-1.286.076-.469.289-.851.584-1.044.264-.173.558-.653.683-1.117.12-.448.432-1.011.693-1.253.261-.242.474-.618.474-.837 0-.219.267-.701.593-1.073.325-.371.592-.867.592-1.102 0-.235.22-.647.489-.916.611-.611.894-1.13.894-1.64 0-.217.259-.579.575-.804.406-.289.615-.643.709-1.2.074-.434.287-.9.474-1.036.187-.135.498-.645.691-1.134.193-.489.524-1.052.737-1.25.212-.198.436-.615.498-.925.062-.311.37-.794.684-1.073.375-.335.57-.7.57-1.069 0-.374.231-.799.691-1.273.48-.494.692-.894.692-1.307 0-.393.134-.667.394-.807.217-.116.595-.63.84-1.142.322-.674.677-1.059 1.284-1.391.462-.253.84-.58.84-.727 0-.147.349-.421.775-.609.427-.188.816-.496.865-.685.049-.188.367-.403.706-.478.339-.074.728-.284.863-.466.136-.182.625-.576 1.087-.876.462-.3.84-.637.84-.75 0-.113.315-.336.7-.497.385-.161.751-.427.814-.59.062-.164.392-.415.732-.559.582-.246 1.072-.624 2.559-1.97.345-.313.871-.655 1.17-.761.299-.105.543-.319.543-.474 0-.157.27-.336.607-.403.337-.068.789-.368 1.016-.674.225-.304.65-.653.945-.775.553-.229 1.55-1.383 1.196-1.383-.11 0-.343.219-.518.486M110.519 52.277c-1.855.378-2.466.586-2.809.952-.241.258-.619.526-.84.596-.22.07-.401.203-.401.296 0 .092-.311.461-.691.82-.38.359-.692.793-.692.965 0 .172-.283.698-.63 1.17l-.631.858-.008 2.887c-.006 2.653.029 2.944.432 3.577.242.378.568.962.726 1.297.158.335.669.938 1.137 1.339.468.401 1.06.917 1.315 1.146 1.127 1.01 7.697.927 8.933-.113.335-.281.671-.511.747-.511.137 0 1.04-.889 2.165-2.132.324-.357.649-.974.724-1.372.074-.397.35-1.146.613-1.664.64-1.264.678-3.64.078-4.815a9.644 9.644 0 01-.606-1.544c-.136-.501-.623-1.189-1.427-2.014l-1.222-1.254-2.102-.504c-1.156-.277-2.178-.495-2.271-.484-.094.011-1.237.238-2.54.504m5.163.441l1.411.136 1.404 1.418c1.258 1.271 1.404 1.498 1.404 2.188 0 .5.156.969.445 1.336.614.781.664 3.656.07 4.09-.257.188-.428.667-.546 1.533-.133.973-.296 1.382-.713 1.794-.297.294-.895.897-1.33 1.339-.434.442-.905.804-1.046.805-.141 0-.483.245-.76.544l-.503.543-3.546.062-3.546.062-.681-.555-1.406-1.147c-.398-.325-.89-.967-1.094-1.426-.203-.459-.522-.92-.708-1.025-.719-.402-.588-6.797.143-7.029.246-.078.45-.446.606-1.097.129-.539.337-.981.462-.983.125-.001.428-.312.674-.691.256-.396.609-.689.828-.689.21 0 .504-.174.652-.386.369-.527 1.163-.797 2.382-.811.564-.006 1.38-.087 1.815-.18.434-.094 1.101-.124 1.481-.068.38.056 1.326.162 2.102.237m127.975 3.64c-1.258.393-1.282.521-1.27 6.852.016 9.033.481 32.674.647 32.943.084.135.266 2.892.405 6.125.242 5.635.371 6.596.933 6.966.09.059.268 1.037.395 2.173.184 1.64.324 2.176.681 2.606.288.347.499.944.59 1.666.099.794.278 1.263.612 1.596.263.263.564.903.68 1.445.115.536.287.974.382.974.322 0 .935.813 1.051 1.396.069.342.242.579.422.579.181 0 .354.238.422.58.143.713 3.429 4.088 4.368 4.486.353.15.642.364.642.475 0 .111.378.366.84.568.462.201.951.553 1.088.783.166.279.448.417.852.417.673 0 1.296.281 1.755.791.193.215.871.421 1.853.564 1.161.169 1.634.33 1.887.643.782.965 17.231.971 18.013.007.254-.314.73-.485 1.832-.656 1.043-.162 1.65-.371 2.03-.697.298-.256.747-.508.999-.559l.937-.193c.264-.054.533-.263.596-.463.066-.209.454-.466.906-.602.435-.13.899-.41 1.032-.622.132-.213.336-.386.452-.386.171 0 1.907-1.333 2.509-1.928.711-.701 1.925-2.117 1.925-2.245 0-.088.267-.432.593-.765.326-.334.593-.775.593-.981 0-.207.255-.557.567-.779.313-.223.618-.662.682-.981.064-.318.338-.818.609-1.11.306-.33.544-.883.626-1.452.089-.62.308-1.096.673-1.46.447-.446.559-.764.645-1.833.085-1.065.195-1.378.62-1.772.481-.446.514-.587.49-2.117l-.025-1.639-.183 1.465c-.112.893-.327 1.646-.55 1.931-.202.256-.477 1.108-.611 1.893-.133.785-.362 1.525-.508 1.645-.329.27-.863 1.517-.863 2.017 0 .204-.213.619-.474.923-.261.304-.526.805-.587 1.114-.062.309-.3.719-.529.911-.229.191-.591.659-.804 1.039-.924 1.652-2.744 3.692-4.493 5.037-.565.435-1.268.998-1.562 1.252a5.278 5.278 0 01-1.173.729c-.352.147-.827.442-1.057.655-.229.214-.731.448-1.115.52-.385.072-1.025.346-1.422.609s-1.164.536-1.704.607c-.539.072-1.336.291-1.771.489-2.654 1.208-15.322 1.191-17.836-.024-.446-.216-1.016-.393-1.265-.393-.698-.002-1.997-.4-2.362-.724-.18-.16-.742-.415-1.249-.568-.508-.153-1.19-.502-1.516-.776-.326-.275-.715-.499-.865-.499-.151 0-.522-.221-.825-.492-.303-.27-1.262-1.103-2.131-1.85-.869-.748-1.847-1.735-2.173-2.194a29.366 29.366 0 00-1.109-1.458c-.284-.343-.577-.816-.65-1.05-.073-.235-.396-.759-.718-1.163-.322-.405-.585-.884-.585-1.066 0-.181-.266-.749-.592-1.263-.326-.514-.594-1.087-.596-1.273-.005-.527-.459-1.867-.817-2.413-.182-.277-.414-1.278-.528-2.277-.111-.98-.397-2.269-.634-2.864-.539-1.349-.729-4.891-.98-18.267-.345-18.343-.568-27.686-.707-29.569-.261-3.542-.001-3.715 5.6-3.715 4.753 0 5.071.049 5.393.827.259.625.212 4.44-.251 20.704-.305 10.686-.305 13.789-.001 18.469.141 2.173.332 5.373.425 7.111.113 2.114.279 3.455.502 4.05.388 1.035.591 1.834.869 3.414.11.628.372 1.361.582 1.628.21.267.444.819.521 1.226.076.407.397 1.092.714 1.522.316.43.574.903.574 1.052 0 .576 3.488 4.285 4.247 4.516.217.066.662.317.988.558.722.534 1.74.899 2.506.899.314 0 .933.184 1.374.409 1.753.895 9.576.915 11.725.03.543-.223 1.304-.449 1.69-.503.745-.102 1.515-.427 2.935-1.236 1.108-.631 4.124-3.69 4.481-4.544.149-.357.484-.963.744-1.347.261-.383.535-1.023.61-1.422.074-.399.305-.957.511-1.241.207-.284.51-1.272.674-2.196.163-.923.444-2.079.623-2.568.178-.489.353-1.555.388-2.37l.062-1.481-.184 1.463c-.101.805-.306 1.605-.455 1.778-.371.43-.513 1.026-.703 2.942-.136 1.378-.246 1.727-.683 2.184-.39.407-.52.747-.52 1.355 0 .646-.121.926-.593 1.371-.375.354-.593.756-.593 1.095 0 .698-3.747 4.57-4.628 4.783-.319.078-.837.357-1.151.622-.405.34-.812.481-1.396.482-1.057.001-2.303.343-2.771.759-.665.591-9.307.479-10.119-.131-.453-.34-1.005-.495-2.151-.605-1.226-.117-1.611-.233-1.883-.569-.188-.232-.598-.483-.912-.558-.313-.074-.804-.367-1.091-.652-.287-.284-.927-.901-1.423-1.371-.496-.469-.956-1.025-1.022-1.234-.067-.21-.245-.381-.397-.381-.333 0-.685-.607-.685-1.181 0-.23-.228-.646-.507-.925-.594-.593-.876-1.251-.876-2.044 0-.361-.158-.679-.433-.872-.366-.256-.473-.628-.684-2.379-.184-1.534-.36-2.224-.674-2.649-.648-.876-.812-7.738-.74-30.881.059-18.684.044-19.714-.29-20.049-.453-.454-8.573-.612-9.917-.193m47.781.157c-.439.485-.48 17.827-.068 28.818.149 3.981.149 6.376.001 8.177-.116 1.401-.198 4.379-.182 6.617l.029 4.071.163-2.667c.089-1.467.263-3.778.388-5.136.239-2.617.182-9.783-.179-22.321-.328-11.366-.348-16.427-.067-16.938.36-.655 8.961-.7 9.71-.051.652.565.676 1.223.399 10.809-.134 4.649-.308 14.718-.385 22.378-.138 13.543-.154 13.961-.568 15.209-.235.707-.42 1.507-.412 1.778.013.411.048.378.212-.197.108-.381.311-.825.45-.988.502-.586.542-1.732.701-19.753.135-15.288.212-18.562.475-20.049.811-4.598.394-9.223-.89-9.887-1.005-.52-9.289-.41-9.777.13M1.229 57.789c-.41.287-.439.456-.439 2.568 0 2.129-.023 2.26-.395 2.26-.369 0-.395.132-.395 1.976 0 1.809.032 1.975.375 1.975.589 0 .861-1.601.886-5.215.019-2.568.08-3.226.319-3.421.345-.279 53.837-.367 54.275-.088.194.123.239 1.334.198 5.38L56 68.444l-1.877.111-1.876.11 1.803.038c1.242.026 1.866-.039 2.006-.209.333-.403.388-10.3.06-10.695-.397-.478-54.204-.488-54.887-.01m12.302 9.781c-.869.087-2.025.256-2.568.375-.543.119-1.965.29-3.161.379l-2.172.164 2.147.028c1.182.015 3.537-.101 5.235-.258a129.52 129.52 0 015.414-.379l2.327-.094.335.513c.61.929.937 30.884.451 41.233-.295 6.266-.267 19.495.041 19.916.226.308.842.332 7.256.284l7.009-.052.114-.701c.141-.866-.116-8.468-.43-12.731-.15-2.032-.262-10.932-.314-24.923-.089-23.922-.15-22.618 1.085-23.247.596-.304 7.48-.13 10.219.257.76.108 2.36.188 3.555.177l2.173-.019-2.469-.258c-1.358-.143-2.869-.356-3.358-.474-.489-.118-2.892-.27-5.34-.336-5.055-.137-5.503-.045-6.04 1.24-.66 1.579-.207 53.8.49 56.51.188.731.315 2.565.253 3.666l-.03.543H21.778l-.124-.618c-.345-1.726-.005-19.725.477-25.259.288-3.298.282-20.637-.008-24.395-.126-1.63-.288-4.7-.361-6.824-.11-3.212-.191-3.95-.483-4.395l-.35-.534-2.909.026c-1.6.015-3.62.098-4.489.186m163.995.669c-.302.157-1.05.379-1.664.492-1.135.21-2.035.653-2.035 1.002 0 .106-.118.193-.262.193-.144 0-.404.155-.578.346l-.849.921c-.292.317-.66.885-.818 1.261a7.072 7.072 0 01-.685 1.226c-.222.3-.515 1.202-.659 2.031-.371 2.137-1.499 3.403-2.256 2.53-.179-.206-.723-.478-1.208-.604s-1.105-.386-1.376-.578c-.675-.477-1.705-.812-2.496-.812-.362 0-1.426-.222-2.363-.494-1.353-.392-2.096-.487-3.608-.462l-1.904.031 2.114.126c1.598.096 2.205.21 2.491.469.319.288 2.411.613 4.622.718.077.004.355.239.618.522.335.362.747.546 1.38.617.667.076 1.034.25 1.408.67 1.197 1.343 2.605.117 2.874-2.502.138-1.348.27-1.842.555-2.074.481-.391.827-1.042.827-1.554 0-.222.213-.543.474-.714.26-.17.518-.482.573-.693.055-.211.347-.477.647-.592.301-.114.744-.419.983-.678.297-.32.743-.507 1.398-.587.529-.065 1.605-.295 2.39-.51 1.721-.472 2.176-.485 2.979-.085.339.169 1.242.36 2.008.424 2.053.172 2.021.12 1.788 2.923a67.246 67.246 0 00-.203 4.346c-.007 2.513.11 2.395-2.505 2.516-1.779.082-2.339.183-2.88.517-.433.268-1.186.463-2.12.55-1.281.119-1.531.211-2.149.794-.385.363-.816.66-.959.66-.143 0-.354.207-.469.461-.268.587.104 2.107.515 2.107.336 0 .59.451.761 1.354.069.364.348.837.62 1.051.402.316.495.563.496 1.313 0 .508.135 1.694.3 2.636.246 1.409.259 2.039.075 3.556a107.696 107.696 0 00-.354 3.395c-.106 1.267-.21 1.617-.564 1.904-.26.21-.487.684-.567 1.182-.073.457-.258.934-.41 1.06-.708.582-1.013.988-1.112 1.476-.061.299-.307.616-.565.727-.252.109-.487.399-.522.645-.035.251-.31.574-.628.738-.31.161-.618.461-.684.668-.065.207-.38.484-.698.616-.319.132-.633.408-.698.614-.066.206-.251.374-.412.374-.432 0-1.521.6-1.797.99-.143.203-.638.392-1.232.471-.691.092-1.132.282-1.449.624-.406.438-.696.512-2.674.686-1.575.138-2.488.323-3.151.637-1.383.657-8.432.635-10.118-.031-.624-.247-1.776-.48-2.708-.549l-1.621-.12-.637.72c-.351.396-.754.72-.895.72-.142 0-.39.316-.551.703a6.324 6.324 0 01-.694 1.212c-.493.626-.518 1.531-.052 1.876.191.142.46.703.597 1.246.141.559.428 1.116.662 1.284.227.163.647.533.933.823.353.356.83.572 1.474.666.584.086 1.19.34 1.568.659l.616.519 9.047.141c8.549.134 9.099.164 10.001.552.664.286 1.803.486 3.75.659 2.409.213 2.859.308 3.258.682.272.256.716.435 1.079.435.839 0 1.488.271 2.092.875.279.279.693.507.921.507.227 0 .609.203.848.451s.673.602.963.785c.291.184.583.505.649.713a.796.796 0 00.5.478c.213.056.438.346.512.664.074.31.347.793.607 1.073.308.332.538.909.659 1.649.233 1.435.378 1.891.599 1.891.755 0 .841 5.985.105 7.368-.295.555-.568 1.546-.702 2.548-.181 1.349-.303 1.702-.688 1.991-.258.194-.526.638-.596.988-.225 1.118-.317 1.327-.583 1.327-.144 0-.41.314-.592.698-.182.383-.503.804-.714.936-.21.131-.383.329-.383.44 0 .11-.446.6-.991 1.088a35.941 35.941 0 00-1.515 1.431c-.287.299-.634.543-.772.543s-.44.267-.672.593c-.274.384-.593.592-.909.592-.293 0-.762.275-1.178.692-.474.473-.873.691-1.267.691-.333 0-.683.153-.833.364-.36.508-1.015.821-1.718.821-.396 0-.765.181-1.093.534-.618.667-.51.818.221.306.305-.214 1.02-.542 1.589-.728.569-.187 1.09-.429 1.158-.538.067-.11.524-.371 1.015-.582.491-.21 1.155-.603 1.475-.872.32-.27.705-.49.856-.49.15 0 .521-.223.824-.496.303-.273 1.218-1.069 2.033-1.77 1.869-1.607 4.054-4.276 4.277-5.224.066-.28.28-.688.476-.905.452-.502.688-1.137.862-2.325.076-.518.333-1.362.57-1.876.65-1.407.653-7.436.004-8.648-.235-.44-.492-1.151-.569-1.58-.163-.902-.39-1.387-.906-1.942-.203-.217-.369-.497-.369-.622s-.289-.506-.642-.845c-.735-.707-.928-.893-1.813-1.738-.352-.337-.861-.667-1.13-.735-.268-.067-.741-.34-1.051-.606-.309-.266-.882-.543-1.272-.616-.39-.073-1.194-.362-1.787-.642-.737-.349-1.61-.558-2.765-.662-.928-.084-2.031-.254-2.451-.377-1.795-.528-3.241-.624-11.484-.766l-8.691-.149-.988-.503c-.543-.277-1.327-.554-1.742-.617-.471-.071-1.037-.368-1.503-.789-.412-.372-.855-.712-.986-.755-.434-.145-1.173-2.801-1.016-3.652.167-.9.775-2.247 1.016-2.247.092 0 .481-.274.863-.61.814-.714 1.831-.811 3.269-.312 2.563.889 11.104.978 12.939.135.681-.313 1.946-.593 2.686-.594.825-.001 1.917-.334 2.367-.722.172-.148.762-.402 1.31-.565.548-.163 1.112-.434 1.252-.603.14-.169.561-.435.935-.591.602-.252 1.079-.598 2.297-1.668.959-.843 2.684-2.808 2.684-3.058 0-.158.249-.579.554-.936.843-.987 1.974-3.504 2.118-4.711.07-.59.25-1.473.399-1.962.525-1.711.577-3.768.134-5.264-.22-.744-.461-1.798-.536-2.341-.079-.573-.378-1.355-.711-1.861-.317-.48-.576-1.033-.576-1.228 0-.195-.266-.627-.592-.96-.736-.754-.836-1.872-.185-2.079.225-.071.716-.4 1.093-.73.537-.472.951-.634 1.913-.749.676-.081 2.066-.336 3.091-.567 1.024-.23 2.322-.419 2.883-.419 1.565 0 1.612-.105 1.855-4.149.114-1.9.282-3.928.374-4.505.19-1.191-.031-1.42-1.642-1.703a13.846 13.846 0 01-1.636-.422c-1.117-.373-3.921-.369-4.64.006M1.333 68.69c.788.037 2.077.037 2.865 0 .787-.038.143-.068-1.433-.068-1.575 0-2.219.03-1.432.068m341.518 5.515c-.089.091-.612.254-1.163.363-.795.157-.141.197 3.184.197 3.95 0 4.119-.015 3.038-.267-1.383-.323-4.834-.523-5.059-.293m-18.877.887c-.367.105-.876.329-1.131.496-.327.214-1.252.344-3.123.44-3.174.162-3.473.318-3.473 1.803 0 .661.126 1.091.437 1.486.403.513.455.898.66 4.931.181 3.556.29 4.501.583 5.051.992 1.862 1.024 62.102.034 63.886-.536.965-.427 1.572.405 2.257l.736.607h4.672c4.112 0 4.704-.039 4.943-.328.223-.27.271-2.608.271-13.382 0-14.713-.064-14.122 1.396-12.899.461.386 1.215.759 1.855.918.592.147 1.224.449 1.403.67.756.933 15.242.904 16-.031.225-.278.75-.481 1.644-.637.846-.148 1.402-.355 1.563-.585.137-.196.71-.507 1.273-.691.61-.199 1.071-.479 1.138-.69.061-.195.336-.411.61-.48 1.15-.288 5.453-4.45 5.726-5.537.066-.264.334-.62.596-.791.261-.171.475-.447.475-.613 0-.166.311-.622.691-1.013.441-.454.691-.904.691-1.242 0-.339.213-.719.593-1.057.469-.418.589-.683.575-1.267l-.018-.74-.196.682c-.107.376-.353.82-.545.988-.192.168-.462.661-.6 1.096-.138.434-.453 1.012-.699 1.284-.246.271-.508.691-.581.933-.073.241-.337.6-.588.797-.25.198-.516.551-.591.787-.232.731-4.983 5.384-5.498 5.384-.149 0-.523.262-.83.583-.307.321-.832.643-1.165.716-.334.073-.931.348-1.328.61-.396.263-1.066.531-1.489.598-.422.066-1.257.344-1.854.617-2.251 1.028-13.025 1.008-15.266-.028-.627-.291-1.296-.528-1.486-.528-.19 0-.986-.399-1.769-.886l-1.424-.887-.329.502c-.303.462-.318 1.533-.186 13.146.129 11.404.113 12.69-.172 13.125l-.316.481h-4.351c-5.764 0-5.956-.096-5.514-2.765.116-.706.296-5.462.398-10.568.102-5.106.263-12.51.356-16.453.095-4.032.094-9.866-.002-13.333-.095-3.391-.255-9.676-.356-13.967-.128-5.439-.276-8.311-.488-9.482-.493-2.725-.663-4.109-.813-6.617-.081-1.364-.291-2.827-.495-3.446-.676-2.062.102-2.77 3.057-2.783a14.844 14.844 0 003.18-.409c2.691-.686 2.599-.686 3.243.003.582.624 1 1.963 1.009 3.237.002.348.158.831.345 1.073l.342.44.974-.984c.536-.54 1.035-.983 1.109-.983.074 0 .469-.266.879-.592.621-.493.677-.593.335-.593-.226 0-.527.156-.669.346-.142.19-.51.476-.818.635-.309.159-.832.631-1.163 1.05-.808 1.02-1.016.759-1.15-1.446-.169-2.76-1.274-3.629-3.721-2.925m12.083.248c-.337.284-1.036.563-1.731.692-.861.159-1.316.37-1.744.808-.736.752-.481.751.633-.004.478-.324 1.083-.589 1.345-.589s.963-.23 1.556-.511c.75-.354 1.606-.557 2.803-.664l1.723-.153-2.01-.027c-1.856-.026-2.052.008-2.575.448m14.524-.257c.943.11 1.619.305 1.946.562.275.217.825.449 1.221.516.397.068.946.281 1.221.473.275.193.897.552 1.383.798.485.245.954.568 1.041.717.086.149.426.409.754.579.768.397 3.545 3.251 4.533 4.658.256.365.567.752.69.861.123.109.338.509.479.889.14.38.407.828.594.996.186.167.45.656.586 1.086.137.43.457 1.093.712 1.473.255.381.524 1.092.599 1.581.075.488.335 1.288.579 1.777.705 1.414 1.369 8.54 1.066 11.435-.262 2.5-.165 3.393.185 1.701.713-3.445.704-4.631-.062-8.099-.168-.76-.306-1.961-.306-2.667 0-1.485-.249-2.515-.685-2.836-.17-.125-.403-.798-.524-1.509-.153-.902-.357-1.418-.688-1.735-.267-.256-.526-.796-.598-1.248-.084-.524-.285-.9-.588-1.099-.259-.169-.514-.585-.582-.947-.069-.366-.412-.918-.796-1.28-.371-.35-.674-.76-.674-.91 0-.15-.168-.363-.373-.473-.205-.109-.557-.512-.783-.895-.226-.383-.538-.697-.693-.697-.155 0-.337-.221-.405-.491a.842.842 0 00-.589-.607c-.256-.065-.564-.333-.684-.596-.125-.274-.387-.479-.613-.479-.217 0-.54-.222-.719-.495-.178-.272-.715-.667-1.192-.878-.477-.212-.919-.518-.981-.68-.065-.17-.592-.395-1.232-.528-.616-.128-1.37-.444-1.677-.702-.49-.412-.746-.467-2.074-.444l-1.516.025 1.445.168m-264.112.122c.353.043.931.043 1.284 0 .353-.044.064-.08-.642-.08s-.995.036-.642.08m-3.605.551c-.543.259-1.331.527-1.75.593-.42.067-.964.322-1.209.568-.245.245-.758.594-1.139.774-.381.181-.839.553-1.018.825-.179.273-.426.496-.549.496-.238 0-1.94 1.767-1.94 2.014 0 .27-1.259 1.582-1.668 1.738-.625.239-1.096-.303-1.101-1.264-.01-2.132-.718-4.683-1.419-5.118-.487-.302-5.568-.138-7.466.241-1.899.379-3.09.602-3.768.706-1.324.203-1.379.33-1.141 2.671.116 1.141.431 2.775.701 3.631.377 1.196.526 2.229.64 4.445l.15 2.887.03-3.286c.03-3.328-.04-3.768-.788-4.912-.408-.623-.649-4.626-.296-4.908.124-.099.981-.219 1.904-.265 1.219-.062 1.838-.189 2.26-.466.494-.324 1.099-.401 4.049-.514 3.662-.141 3.963-.086 3.963.72 0 .245.172.834.382 1.31.21.475.446 1.562.523 2.414.187 2.07.512 2.42 1.727 1.861.797-.367 1.516-1.24 1.516-1.842 0-.151.266-.413.592-.581.352-.182.593-.463.593-.693 0-.24.175-.43.463-.502.255-.064.751-.422 1.103-.794.351-.373.769-.678.928-.678.159 0 .53-.244.824-.542.404-.411.86-.599 1.883-.774.742-.128 1.523-.389 1.736-.581.212-.193.76-.411 1.218-.486l.833-.135-.889-.013c-.553-.008-1.263.166-1.877.46m6.777-.295c.577.084 1.217.305 1.423.492.233.21 1.008.424 2.047.563.92.124 1.723.276 1.785.338.322.325-.226 4.348-.654 4.804-.448.477-.798 2.123-.806 3.793-.002.522-.144.972-.399 1.265-.217.251-.398.642-.401.87-.01.618-.467 1.105-1.038 1.105-.891 0-2.598-.469-2.979-.819-.805-.74-6.827-.766-7.426-.032-.169.206-.832.491-1.489.639-.652.147-1.325.423-1.495.613-.171.19-.682.535-1.136.766-.454.232-.826.545-.826.696 0 .151-.27.503-.601.781-.33.278-.696.797-.812 1.153a2.845 2.845 0 01-.733 1.09l-.521.442-.039 17.23c-.021 9.477-.089 17.434-.151 17.682l-.114.451h-6.305c-4.828 0-6.343-.058-6.466-.247-.087-.136-.212-1.936-.276-4l-.117-3.753.018 4.007c.015 3.334.068 4.039.314 4.195.582.367 12.751.242 13.063-.134.225-.272.271-3.245.271-17.565V94.648l.439-.558a8.87 8.87 0 00.819-1.349c.838-1.746 3.099-3.527 5.26-4.144.652-.186 1.31-.441 1.463-.566.379-.312 5.584-.313 5.964-.001.357.293 4.266 1.117 4.529.954.64-.395 1.575-3.233 1.575-4.777 0-.392.235-1.208.522-1.815.287-.607.593-1.682.679-2.39.086-.707.217-1.734.291-2.281.156-1.159-.216-1.472-1.748-1.476-.466-.001-1.293-.217-1.887-.494-.737-.343-1.364-.484-2.074-.467l-1.017.025 1.048.152m57.816.216c-.761.211-2.094.462-2.963.558-1.714.189-2.111.303-2.864.815-.272.185-.939.451-1.482.592-.543.141-1.121.398-1.284.572-.163.174-.68.486-1.15.692-.47.207-.958.524-1.086.704-.128.18-.411.422-.628.538-.587.314-2.074 1.734-2.074 1.981 0 .118-.267.404-.593.636-.326.233-.592.547-.592.698 0 .152-.254.568-.564.925-.683.787-1.017 1.396-1.017 1.858 0 .19-.177.535-.395.767-.271.288-.519 1.093-.788 2.556-.215 1.174-.481 2.457-.591 2.851-.256.924-.248 2.673.017 3.679.115.434.329 1.368.475 2.074l.267 1.284-.092-1.778c-.156-3.014-.134-4.854.085-7.012a79.56 79.56 0 00.221-2.412c.006-.186.24-.55.52-.809.331-.307.548-.763.62-1.306.079-.589.253-.927.593-1.149.264-.173.618-.658.786-1.078.168-.42.477-.856.686-.968.209-.112.464-.423.566-.691.102-.268.369-.555.594-.638.225-.083.517-.369.65-.635.132-.266.416-.517.631-.558.215-.041.724-.375 1.131-.742.408-.368.879-.669 1.047-.669.168 0 .512-.223.765-.496.318-.343.817-.561 1.62-.708.668-.122 1.351-.389 1.61-.629.368-.343.9-.464 2.946-.673 1.672-.172 2.665-.368 3.007-.595.366-.242 1.126-.374 2.684-.463l2.173-.125-2.074-.014c-1.484-.011-2.468.094-3.457.368m-35.852.779c-.924.085-2.5.339-3.504.565-1.004.226-2.293.413-2.864.415-1.548.007-2.019.434-1.746 1.587.115.483.304 2.3.421 4.039.234 3.489.426 5.133.809 6.913.376 1.751.353 30.249-.028 33.581-.149 1.303-.277 3.166-.284 4.138l-.014 1.769.769.16c1.565.326 12.991.095 13.219-.268.204-.323.025-2.975-.511-7.577-.459-3.944-.281-37.024.224-41.363.314-2.706.365-3.703.201-3.901-.25-.301-3.723-.33-6.692-.058m6.391.374c.114.115.101.396-.037.739-.867 2.174-.924 48.458-.061 49.511.197.241.284.856.247 1.762l-.022.546-6.349-.052-6.349-.052-.396-.531c-.369-.495-.379-.611-.137-1.679.751-3.307.448-39.497-.341-40.732-.221-.347-.343-1.375-.458-3.852-.086-1.859-.217-3.616-.29-3.906-.172-.675.344-.986 1.362-.821 1.055.172 4.291-.305 4.732-.697.601-.533 7.598-.737 8.099-.236m90.753 7.713c-.089 1.954-.278 3.598-.521 4.543-.231.9-.469 2.878-.604 5.037-.244 3.872-.461 5.954-.906 8.692-.16.978-.28 2.311-.268 2.963.022 1.146.028 1.131.196-.478.096-.915.355-2.249.577-2.963.33-1.061.434-2.154.57-5.942.145-4.063.222-4.802.617-5.926.375-1.068.464-1.8.53-4.346.109-4.231-.021-5.307-.191-1.58m-57.737-1.874c-.326.168-.814.435-1.086.593-.272.158-.787.289-1.145.291-.436.002-.822.173-1.168.52a4.368 4.368 0 01-1.177.793c-.362.151-.659.385-.659.519-.001.135-.268.396-.593.581-.325.185-.591.464-.591.619 0 .156-.21.421-.467.589-.307.201-.509.574-.592 1.094-.07.433-.349 1.052-.62 1.375-.712.845-.769 6.382-.074 7.128.231.248.542.857.691 1.352.149.496.449 1.026.666 1.178.218.152.396.382.396.51 0 .361 1.813 1.917 2.232 1.917.205 0 .416.167.469.371.117.447.859.815 1.646.815.373 0 .751.189 1.076.54.888.957 6.094.921 7.142-.05.295-.273.879-.527 1.389-.604.812-.122 1.453-.497 1.453-.852 0-.08.304-.291.674-.468.371-.177.732-.5.801-.718a.889.889 0 01.514-.519c.213-.068.568-.477.789-.909.22-.432.528-.834.684-.894 1.04-.399.976-9.133-.072-9.867-.206-.144-.427-.525-.491-.845-.146-.73-2.067-2.727-2.904-3.019a3.302 3.302 0 01-1.06-.657c-.267-.266-.819-.497-1.398-.584-.526-.079-1.212-.333-1.526-.564-.758-.561-4.065-.716-4.999-.235m189.292.045c.683.039 1.75.039 2.37 0 .621-.039.062-.071-1.242-.071-1.304.001-1.811.033-1.128.071m-184.302.634c.572.223 1.283.405 1.58.406.315 0 .83.247 1.233.592.38.325.808.592.95.592.437.001 2.444 2.027 2.837 2.864.204.435.56 1.03.792 1.323.394.5.421.764.431 4.25l.011 3.718-.634.921c-.349.507-.634 1.012-.634 1.123 0 .225-1.914 2.196-2.133 2.197-.076 0-.45.267-.83.592-.38.325-.849.592-1.041.592-.193 0-.939.267-1.657.593-1.797.815-4.875.87-6.468.117-.554-.262-1.342-.539-1.752-.616-.411-.076-.855-.293-.988-.48-.133-.188-.464-.457-.736-.599-1.405-.733-2.93-2.596-3.464-4.231-.181-.553-.431-1.069-.556-1.147-.403-.25-.302-5.28.119-5.899.191-.28.482-.964.646-1.519.165-.555.498-1.247.74-1.538.783-.94 2.212-2.254 2.455-2.257.131-.002.479-.228.775-.502.296-.275.767-.543 1.047-.598.28-.054 1.176-.319 1.991-.59 1.766-.586 3.623-.552 5.286.096m180.294-.107c-.76.252-1.827.565-2.37.695-.543.13-1.166.399-1.383.597-.217.198-.6.422-.851.498-.63.192-2.239 1.617-3.369 2.983-.522.63-.533 4.536-.023 8.085.135.941.28 6.219.358 13.056.136 11.798.16 12.128.897 12.129.123 0 .484.225.803.499.319.274 1.045.634 1.613.799.568.165 1.136.425 1.262.577.9 1.084 12.214 1.082 13.434-.003.163-.145.74-.414 1.284-.598.543-.184 1.279-.59 1.636-.903.357-.313.724-.569.816-.569.414 0 2.827-2.689 3.38-3.766.198-.387.5-.82.67-.961.17-.141.407-.624.526-1.073.119-.449.389-1.003.599-1.23.411-.444.768-1.474.768-2.216 0-.252.222-.944.494-1.538.271-.593.486-1.277.478-1.518-.013-.369-.049-.344-.227.154-.117.326-.274.637-.35.692-.327.233-.553.978-.687 2.26-.121 1.16-.231 1.453-.716 1.906-.425.398-.573.717-.573 1.242 0 .529-.119.785-.479 1.02-.263.172-.565.561-.67.862-.105.302-.467.864-.805 1.248-.337.384-.613.847-.613 1.029 0 .185-.248.416-.566.527-.311.108-.664.415-.786.681-.122.268-.389.484-.599.484-.208 0-.676.281-1.041.624a3.193 3.193 0 01-1.542.792c-.484.092-1.107.384-1.383.649-1.007.965-11.542.962-12.584-.003-.284-.263-.876-.52-1.371-.594-.51-.076-1.169-.367-1.589-.701-.395-.313-.878-.57-1.073-.57-.593 0-.592.025-.693-12.983-.054-6.928-.186-13.175-.293-13.881-.107-.706-.293-2.102-.413-3.101l-.22-1.818.62-.965c.34-.531.619-1.058.619-1.171 0-.113.256-.312.569-.441.313-.13.815-.492 1.115-.805.299-.313.786-.622 1.082-.687.296-.065.721-.328.945-.586.303-.349.698-.501 1.558-.6 1.574-.181 2.587-.455 2.677-.724.041-.124.47-.289.953-.367.816-.132.829-.143.187-.158-.38-.009-1.313.189-2.074.442m8.395-.333c.272.049.681.262.908.473.248.229.925.464 1.68.581.963.15 1.361.315 1.671.691.224.272.745.587 1.158.701.449.124.79.354.847.571.052.2.335.463.628.584.295.123.632.483.754.807.122.322.355.585.519.585.165 0 .399.304.523.679.123.373.474.929.78 1.235.31.309.615.881.688 1.29.072.405.302.855.51 1 .471.33.791 1.148.791 2.022 0 .699.353 1.675.605 1.675.439 0 .582 1.616.61 6.894.028 5.554.032 5.601.214 2.785.279-4.336-.031-8.846-.71-10.308-.287-.618-.521-1.329-.522-1.58 0-.252-.172-.768-.383-1.149-.21-.38-.566-1.077-.79-1.549a9.262 9.262 0 00-1-1.576c-.326-.395-.592-.816-.592-.937 0-.354-2.612-2.918-3.362-3.3-.378-.193-.989-.57-1.358-.84-.369-.269-.872-.489-1.117-.489-.244 0-.92-.221-1.501-.492-.581-.27-1.279-.48-1.551-.467l-.493.025.493.089m-284.357 9.24c.809 10.485.787 9.795.529 16.396-.135 3.476-.329 7.139-.431 8.14-.298 2.926-.205 4.648.115 2.131.138-1.087.366-2.464.508-3.062.398-1.681.39-21.239-.009-21.926-.158-.271-.4-.983-.538-1.58l-.251-1.087.077.988m69.948 7.901c.065.326.277.771.472.988.195.217.408.623.474.901.193.822 3.017 3.882 4.097 4.441.317.164.576.385.576.492 0 .107.422.394.939.639 1.245.589 1.463 2.515.284 2.515-.32 0-2.941 2.67-3.298 3.359-.185.359-.502.83-.703 1.046-.201.216-.459.891-.573 1.5-.113.609-.295 1.536-.403 2.06-.41 1.99.246 6.03 1.169 7.202 1.145 1.453 2.049 2.404 2.388 2.512.811.257.673 2.005-.175 2.195-1.619.363-2.059.539-2.439.976-.231.265-.535.483-.675.483-.223 0-1.402.94-1.859 1.482l-.832.987c-.366.435-.789 1.101-.94 1.482-.152.38-.428.856-.614 1.058-.758.823-1.33 5.474-.98 7.978.396 2.838.65 3.984.938 4.222.149.124.448.624.663 1.11.215.487.663 1.208.997 1.604 1.103 1.31 2.205 2.398 2.432 2.4.124.001.603.303 1.065.67.462.368 1.085.729 1.383.803.298.074.725.305.949.514.223.209.935.477 1.58.597.645.119 1.573.421 2.062.67.631.322 1.405.492 2.667.587.978.073 2.311.221 2.963.328 4.026.659 4.983.76 7.21.76 2.183 0 3.526-.153 6.913-.79a12.272 12.272 0 011.717-.179c.455-.006.882-.098.947-.205.203-.328-4.215.003-5.452.409-2.142.702-5.639.666-8.866-.093-.706-.166-2.605-.361-4.219-.432-2.531-.111-2.988-.181-3.317-.51-.534-.535-1.225-.761-2.324-.761-.781 0-1.053-.103-1.566-.592-.405-.387-.824-.593-1.208-.593-.425 0-.71-.164-1.025-.59-.273-.369-.685-.637-1.099-.715-.452-.084-.753-.298-.945-.668-.155-.3-.461-.592-.682-.649-.22-.058-.494-.351-.608-.652-.115-.301-.42-.743-.678-.983-.258-.239-.565-.778-.68-1.197-.116-.419-.403-.907-.639-1.085-1.009-.761-1.001-10.516.01-11.701.293-.343.653-1.002.801-1.464.147-.461.391-.839.542-.839.151 0 .402-.305.557-.677.156-.372.463-.734.682-.803.219-.07.49-.299.603-.509.112-.21.525-.516.917-.68.392-.164.911-.512 1.154-.774.293-.316.766-.523 1.404-.616 1.283-.185 1.456-.363 1.456-1.489 0-.792-.077-.996-.445-1.188-.688-.358-2.12-1.82-2.122-2.167 0-.17-.218-.499-.484-.73-.265-.23-.526-.713-.579-1.072-.243-1.656-.407-4.328-.291-4.74.071-.251.137-1.142.148-1.98.018-1.39.071-1.582.599-2.184.318-.363.64-.904.715-1.203.076-.299.335-.674.576-.832a2.16 2.16 0 00.663-.779c.123-.27.354-.491.513-.491.159 0 .419-.184.577-.41.158-.225.585-.559.949-.74 1.091-.545 1.172-2.8.101-2.8-.244 0-.768-.307-1.164-.681-.397-.374-.987-.818-1.312-.985-.324-.168-.646-.484-.715-.702-.069-.218-.342-.451-.607-.517-.264-.067-.48-.232-.48-.368 0-.136-.356-.652-.792-1.146-.435-.495-.847-1.177-.915-1.517-.068-.339-.286-.731-.485-.871-.2-.139-.457-.469-.571-.733-.196-.449-.201-.441-.091.112m237.252 8.099c-.098 1.029-.324 2.081-.536 2.497-.201.395-.499 1.353-.66 2.129-.162.777-.477 1.643-.699 1.926-.597.758-.491.991.151.336.437-.446.608-.882.797-2.04.156-.955.372-1.595.616-1.823.457-.425.645-1.573.563-3.42l-.062-1.383-.17 1.778m-161.231-.366c-.262 1.396.043 4.31.56 5.342.262.522.589 1.526.727 2.23.137.704.416 1.512.618 1.796.202.284.465 1.13.584 1.881.12.75.424 1.72.677 2.154.253.435.523 1.26.601 1.835.078.574.355 1.445.616 1.936.261.491.475 1.087.477 1.326.003.592.531 2.289.876 2.817.156.237.412 1.113.569 1.947.158.834.431 1.677.609 1.872.177.196.454 1.05.616 1.897.163.848.462 1.817.665 2.153.203.337.466 1.178.584 1.87.118.692.403 1.577.634 1.967.23.39.504 1.246.609 1.903.105.656.374 1.504.597 1.883.223.38.48 1.215.57 1.856.218 1.543 1.347 3.701 2.763 5.281.62.693 1.371 1.539 1.668 1.88.998 1.149 3.369 3.773 5.559 6.154.629.683 1.281 1.449 1.448 1.702.365.549 1.092 1.368 1.835 2.065.299.28.544.595.544.698 0 .104.289.47.642.812.353.343 1.175 1.229 1.827 1.971.652.741 1.363 1.54 1.58 1.775.217.235.806.911 1.309 1.5.502.59 1.225 1.429 1.607 1.863.382.435.936 1.07 1.231 1.411.296.342.817.934 1.158 1.317a74.6 74.6 0 011.214 1.402c2.225 2.648 4.425 4.627 5.487 4.935.593.173 1.19.449 1.327.614.137.165.749.446 1.36.623.61.177 1.376.519 1.702.759.326.24 1.015.55 1.531.689.516.139.938.313.938.387 0 .215 1.351.801 1.846.801.248 0 .628.166.845.369.571.531 1.166.817 1.703.817.259 0 .648.165.865.368.55.512 1.039.743 1.902.899.408.073.909.312 1.112.531.204.219.804.512 1.333.653.529.14 1.308.491 1.73.778.423.288.94.524 1.149.524.426 0 1.103.324 1.496.717.143.143.704.392 1.246.553.542.161 1.218.476 1.502.699.284.223.872.463 1.306.532.435.07.948.284 1.141.477.503.503 1.073.775 1.624.775.263 0 .8.255 1.192.566.392.312 1.056.621 1.475.688.419.068.969.302 1.223.522.254.22.824.497 1.268.616 1.347.359 1.731.563 1.838.971.145.552.649.49.649-.08 0-.528-.526-.803-1.947-1.02-.473-.073-1.04-.312-1.26-.532-.22-.219-.896-.529-1.503-.688-.613-.159-1.295-.493-1.531-.749-.27-.29-.767-.511-1.346-.598-.574-.086-.989-.269-1.106-.489-.205-.383-1.177-.787-1.89-.787-.248 0-.625-.223-.839-.494-.268-.341-.582-.494-1.012-.494-.709 0-1.691-.449-1.842-.843-.056-.146-.566-.372-1.134-.503-.567-.131-1.295-.459-1.616-.73-.322-.271-.796-.492-1.054-.492-.619 0-1.512-.404-1.825-.825-.137-.185-.664-.399-1.171-.475-.579-.087-1.078-.308-1.344-.596-.236-.253-.851-.553-1.383-.672-.555-.124-1.147-.419-1.408-.7a1.438 1.438 0 00-1.064-.485c-.689 0-1.226-.242-1.79-.805-.209-.209-.598-.38-.864-.38-.631 0-1.525-.4-1.838-.823-.137-.184-.759-.448-1.383-.587-.704-.156-1.263-.413-1.472-.677-.221-.277-.661-.47-1.264-.552-.509-.07-1.112-.305-1.341-.522a280.235 280.235 0 01-2.815-2.773c-.235-.237-.59-.606-1.472-1.529-.282-.295-.569-.694-.636-.885-.068-.191-.348-.449-.623-.575-.274-.125-.499-.384-.499-.576 0-.192-.244-.541-.543-.775-.299-.234-.588-.543-.642-.685-.121-.318-2.62-3.121-3.506-3.933-.353-.324-.642-.707-.642-.853 0-.145-.222-.365-.494-.489s-.494-.302-.494-.396c0-.094-.289-.484-.642-.865a83.97 83.97 0 01-2.413-2.759 44.17 44.17 0 00-1.213-1.361c-.369-.396-.67-.791-.67-.879 0-.164-1.871-2.199-3.944-4.288-.656-.66-1.192-1.303-1.192-1.427 0-.125-.23-.378-.512-.562-.281-.184-.591-.544-.688-.798-.096-.255-.399-.548-.673-.652-.274-.104-.497-.344-.497-.532 0-.189-.222-.569-.493-.845-1.429-1.453-2.104-2.342-2.283-3.008-.109-.407-.342-.82-.518-.918-.219-.122-.399-.723-.577-1.928-.16-1.082-.373-1.833-.557-1.968-.439-.321-.708-1.173-.708-2.245 0-.756-.12-1.099-.593-1.693-.472-.595-.592-.938-.592-1.694 0-1.1-.226-1.791-.76-2.326-.271-.271-.422-.799-.522-1.835-.099-1.012-.257-1.58-.521-1.867-.472-.513-.765-1.503-.765-2.583 0-.601-.14-.992-.513-1.435a2.846 2.846 0 01-.603-1.447c-.186-1.733-.296-2.134-.688-2.498-.452-.422-.752-1.494-.759-2.711-.003-.494-.127-.916-.314-1.072-.561-.465-.876-1.336-.876-2.421 0-.891-.099-1.194-.593-1.815-.487-.612-.593-.929-.593-1.771 0-.824-.124-1.214-.635-1.984l-.635-.959.037-2.433c.038-2.509-.032-2.962-.266-1.713m-63.041 23.308c-.766.263-.713.221-1.02.811-.127.245-.363.445-.524.445-.161 0-.44.31-.621.689-.181.379-.49.741-.688.803-.197.063-.403.331-.458.595l-.203.98c-.057.275-.324.691-.593.925-.48.417-.488.476-.488 3.474v3.049l.592.675c.694.79.786.473.151-.524-.597-.938-.677-5.625-.106-6.196.187-.187.473-.788.636-1.336.307-1.033.897-1.864 2.32-3.264 1.198-1.18 1.846-1.342 4.285-1.077 1.108.12 4.88.219 8.383.219 5.162 0 6.573.058 7.449.307.594.168 1.789.483 2.657.7.867.216 1.756.557 1.975.756.219.2.687.51 1.04.688.353.179.642.408.642.51 0 .102.274.498.609.879 1.451 1.653 1.517 7.133.107 8.81-.285.338-.518.701-.518.807 0 .371-2.82 2.938-3.228 2.938-.142 0-.466.221-.72.491-.253.27-.78.546-1.17.614-.39.068-1.02.307-1.401.532-.38.224-1.358.52-2.172.657l-1.482.25 1.649-.04c1.445-.035 1.694-.094 2.009-.484.233-.287.728-.514 1.408-.643.695-.132 1.183-.358 1.448-.672.22-.26.614-.536.877-.613.262-.077.673-.329.913-.56.24-.231.797-.757 1.24-1.167.442-.411.865-.944.941-1.186.076-.241.34-.627.587-.857.322-.3.488-.748.588-1.58.076-.639.25-1.606.386-2.149.2-.799.198-1.158-.009-1.877-.141-.489-.32-1.33-.398-1.869-.11-.768-.285-1.108-.804-1.568-.364-.322-.662-.701-.662-.841s-.286-.403-.635-.583c-.349-.181-.8-.538-1.002-.795-.221-.282-.577-.468-.896-.469-1.069-.005-1.998-.254-2.424-.651-.684-.637-19.014-1.172-20.67-.603m-3.395 13.884c-.011.512.141.834.627 1.321a284.202 284.202 0 001.987 1.982c.347.343.986.721 1.42.84.435.119.987.425 1.227.681.381.404.679.478 2.318.576 1.142.068 2.135.24 2.526.437 1.465.735 5.71.823 6.758.14.114-.075.608-.237 1.097-.36l.889-.223-.72-.024c-.395-.012-1.416.121-2.268.297-1.566.324-3.284.286-5.088-.112-.447-.099-1.722-.285-2.832-.413-1.446-.167-2.141-.339-2.449-.605-.236-.205-.732-.456-1.103-.559-.37-.102-1.046-.507-1.502-.9-.455-.392-.917-.788-1.026-.879-.446-.375-1.398-1.715-1.614-2.276l-.232-.601-.015.678m24.694 11.291c-.262.104-.573.322-.691.483-.119.162-.616.372-1.105.467-.802.157-.825.176-.237.195.358.012 1.025-.166 1.482-.395.456-.23 1.363-.531 2.015-.668l1.185-.251-1.087-.011c-.597-.006-1.3.075-1.562.18m-152.314 12.13c-.14.169-.571.296-.999.296-1.011 0-1.75.305-2.432 1.002-.312.318-.635.579-.72.579-.084 0-.525.74-.98 1.646l-.827 1.646.065 2.684c.059 2.399.112 2.746.501 3.272.24.324.494.819.565 1.1.274 1.094 2.718 3.099 3.73 3.061.384-.015.46-.053.208-.107l-.839-.178c-.28-.06-.445-.24-.445-.486 0-.255-.133-.391-.381-.391-.585 0-1.789-1.258-2.02-2.109-.113-.416-.396-.963-.63-1.217-.609-.66-.657-5.97-.058-6.408.202-.148.519-.707.703-1.243.238-.692.496-1.052.891-1.243.306-.149.6-.436.653-.639.095-.364 1.226-.817 1.696-.679 1.048.306 1.055.314.529.607-.272.151-.66.278-.863.282-.382.007-1.903 1.435-1.903 1.787 0 .111.403-.19.894-.668.68-.661 1.2-.956 2.173-1.235.703-.202 1.279-.445 1.279-.541 0-.096.111-.085.247.025.136.109.761.36 1.39.556.912.285 1.292.54 1.873 1.257 1.255 1.549 1.679 1.866 1.073.802-.185-.325-.455-.592-.6-.592-.145-.001-.364-.266-.486-.588-.162-.43-.431-.655-1.005-.84-.92-.296-1.121-.651-.464-.816.749-.188 1.917.228 2.117.753.097.254.375.601.618.772.646.452 1.032 1.439.625 1.596-.17.065-.254.173-.186.24.067.068.255.012.417-.123.391-.324-.013-1.346-.872-2.205-.329-.329-.599-.667-.599-.75 0-.083-.378-.258-.839-.389a85.16 85.16 0 01-1.755-.526c-1.176-.368-2.034-.364-2.344.01m157.037.008c-.272.155-.833.284-1.248.285-1.373.006-3.023 1.468-4.015 3.559-.672 1.415-.399 8.099.331 8.099.086 0 .347.394.58.876.233.482.708 1.059 1.055 1.283.347.223.897.584 1.223.802.326.217.77.392.988.388.284-.005.215-.085-.247-.286-.353-.153-.642-.363-.642-.466 0-.103-.389-.349-.865-.545-.664-.275-.921-.516-1.11-1.04-.136-.374-.456-.875-.711-1.111-1.058-.981-1.045-7.642.016-8.501.273-.222.497-.559.497-.75 0-.191.252-.493.56-.669.309-.177.642-.504.741-.726.226-.504 1.56-.819 2.216-.522.594.269.4.551-.492.719-.735.138-2.235 1.314-2.235 1.752 0 .134-.222.484-.494.777-.44.474-.49.689-.463 1.955l.031 1.422.117-1.313c.075-.84.242-1.451.463-1.695.19-.21.346-.482.346-.605 0-.39 1.455-1.722 2.173-1.99.38-.141.845-.339 1.034-.438 1.126-.595 4.02.287 4.595 1.399.442.854 1.09 1.382 1.696 1.382.559 0 .884-.449.626-.865-.659-1.062-1.941-2.486-2.379-2.643-2.059-.737-3.686-.935-4.387-.533m-167.753.508c-.446.777-.537 14.191-.099 14.554.197.164.236-1.221.191-6.84-.06-7.485-.017-8.19.468-7.706.441.442.518 14.177.082 14.532-.19.153-.212.242-.061.246.451.012.479-.433.484-7.527.005-6.663-.019-7.162-.357-7.5-.351-.351-.373-.344-.708.241m86.291-.187c-.504.719-.476 14.679.03 14.872.277.105.297.082.099-.118-.188-.189-.247-1.89-.247-7.135 0-7.089.098-8.117.7-7.322.151.199.275.273.275.164 0-.627-.538-.917-.857-.461m-66.291.165c-.294.549-.245.751.247 1.009.423.222.429.216.124-.141-.176-.206-.287-.463-.247-.572.081-.219 10.183-.222 10.538-.003.52.322-.172.497-1.961.497-3.004 0-2.767-.603-2.825 7.21-.048 6.371-.058 6.518-.444 6.518s-.396-.149-.447-6.506c-.063-7.772.115-7.241-2.398-7.182l-1.698.04 1.58.062c2.41.096 2.272-.334 2.272 7.074 0 6.46.029 6.809.574 6.809.778 0 .808-.257.808-6.83 0-7.51-.253-6.857 2.707-6.967 2.216-.082 2.601-.282 1.942-1.01-.517-.572-10.467-.579-10.772-.008m22.442.092c-.175.267-.32.69-.322.938-.002.248-.224.661-.494.917-.27.255-.487.611-.483.79.005.236.076.2.261-.133.321-.579.648-.258.77.755.059.483.093.349.115-.446.036-1.292.179-1.371 1.373-.761.691.354.753.464 1.086 1.958.194.871.523 1.8.731 2.064.473.602.593 2.075.19 2.33-.498.315-4.067.23-4.402-.105-.381-.381-.227-1.788.274-2.503.202-.288.416-.777.476-1.086l.109-.563-.219.553c-.326.827-.66.539-.773-.667l-.1-1.071-.16.767c-.089.423-.325 1-.524 1.284-.199.284-.472 1.005-.606 1.603-.134.597-.408 1.32-.608 1.606-.2.286-.486 1.042-.636 1.679-.149.638-.461 1.47-.693 1.851-.233.38-.421.824-.418.987.004.209.073.18.232-.098.125-.218.345-.484.489-.593.145-.109.387-.849.538-1.645.173-.913.43-1.613.695-1.895.252-.268.494-.896.603-1.568.352-2.165 1.109-2.277.894-.132-.193 1.917-.108 1.981 2.621 1.981 2.723 0 2.86-.104 2.679-2.036-.196-2.099.65-1.705 1.008.47.064.388.337 1.005.607 1.371.271.367.492.805.493.974.002.551.403 1.769.67 2.036.143.144.373.613.511 1.044.138.43.324.978.414 1.217.13.344.081.46-.237.561-.221.07-.362.167-.313.215.193.194 1.12-.388.954-.599-.093-.119-.366-.815-.607-1.547-.24-.733-.512-1.379-.606-1.436-.093-.058-.316-.614-.495-1.237-.18-.623-.489-1.399-.687-1.725-.197-.326-.463-.992-.591-1.481-.127-.489-.365-1.097-.529-1.352a7.502 7.502 0 01-.562-1.185l-.266-.722-.014 1.037c-.017 1.307-.451 1.408-.793.185-.432-1.542.055-3.123.547-1.775.171.469.204.488.217.129.008-.233-.205-.633-.475-.889s-.492-.671-.494-.923c-.011-1.474-1.71-2.258-2.45-1.129m85.146-.158c-.225.226-.144 1.007.116 1.105.386.147 1.135-.204 1.135-.532 0-.456-.938-.886-1.251-.573m-83.129.832c.086.901-.125 1.046-1.054.727-1.336-.458-1.224-1.554.149-1.455.797.057.844.096.905.728m83.759-.04c-.295.356-.666.023-.489-.439.104-.271.182-.286.424-.086.23.191.244.309.065.525m44.112-.186c.362.297.736.665.832.819.096.154.431.548.745.877.673.704.631 1.039-.122.983-.569-.042-.889-.356-1.371-1.347-.223-.458-.549-.685-1.395-.972-1.311-.446-1.195-.685.422-.873.128-.015.528.216.889.513m-49.986.269c-.122.348-.221.997-.221 1.443 0 .69-.109.904-.74 1.451l-.741.641.494.396c.271.217.605.488.74.601.183.152.247 1.233.247 4.135 0 4.74.16 5.354 1.383 5.318.445-.013.432-.033-.127-.195-.889-.257-.929-.448-1.002-4.821-.078-4.617-.09-4.702-.743-4.999-.629-.287-.638-.701-.022-.982.538-.245.623-.465.805-2.066.223-1.96.892-1.42.892.721 0 1.026.013 1.049.789 1.4.806.363.816.889.016.889-.737 0-.805.366-.805 4.299 0 4.243.029 4.365 1.184 4.885l.813.367-.554.245c-.482.213-.499.248-.134.262 1.142.043 1.018-.752-.188-1.206-.823-.31-.924-.824-.924-4.713v-3.539l.777-.396c1.081-.551 1.128-.739.275-1.095-.924-.386-1.04-.569-1.069-1.677-.047-1.85-.703-2.632-1.145-1.364m80.012-.116c-.128.281-.233.929-.233 1.44 0 .827-.08.998-.74 1.57l-.741.641.741.612.74.613v3.919c0 4.728.161 5.342 1.383 5.306.438-.013.423-.035-.14-.198-.905-.262-1.043-.982-1.044-5.447l-.001-3.789-.593-.422c-.717-.51-.751-.852-.116-1.141.538-.245.623-.465.805-2.066.223-1.96.892-1.42.892.721 0 1.026.013 1.049.789 1.4.806.363.816.889.016.889-.737 0-.805.366-.805 4.299 0 4.243.029 4.365 1.184 4.885l.813.367-.554.245c-.482.213-.499.248-.134.262 1.142.043 1.018-.752-.188-1.206-.823-.31-.924-.824-.924-4.713v-3.539l.777-.396c1.081-.551 1.128-.739.275-1.095-.924-.386-1.04-.569-1.069-1.677-.045-1.78-.642-2.559-1.133-1.48m-195.49 2.862c-.087.271-.301.597-.475.725-.482.352-.468 5.266.015 5.637.183.141.473.748.644 1.349.26.912.411 1.131.918 1.322.333.126.653.406.709.623.126.482 1.475.698 3.669.587l1.445-.073 1.129-1.147c.621-.631 1.129-1.302 1.129-1.492 0-.555.463-1.049.845-.903.398.153.443.982.087 1.57-.547.901-1.616 1.877-2.055 1.877-.317 0-.457.114-.457.375 0 .267-.214.432-.741.572-.684.182-.698.198-.175.217 1.666.06 4.685-3.724 3.652-4.578-.562-.466-.772-.369-1.312.601-.416.746-1.151 1.595-1.857 2.144-2.046 1.59-6.068.427-6.776-1.96-.163-.547-.433-1.204-.601-1.459-.353-.54-.453-3.91-.133-4.527.517-.999.673-1.443.589-1.687-.055-.163-.152-.075-.249.227m48.082.268c-2.467.79-3.633 4.629-2.559 8.428.216.761 2.166 2.574 2.743 2.55.236-.009.203-.072-.12-.227-1.041-.503-.513-.747 1.616-.747 1.986 0 2.063-.016 2.124-.444.034-.245.263-.533.507-.64.245-.107.445-.334.445-.504 0-.375.38-.782.73-.782.754 0-.962 2.388-2.259 3.143-.325.19-.323.203.029.209.576.009 2.685-2.193 2.685-2.803 0-1.275-1.142-.726-2.488 1.195-.949 1.356-4.381.079-4.826-1.796-.149-.628-.152-.625-.172.205-.017.719.05.871.454 1.025.598.227.779.513.565.895-.181.323-.088.366-1.434-.67-.479-.368-.496-.468-.562-3.121-.079-3.241.022-3.569 1.506-4.872l1.044-.916h3.588l.763.834c.633.692.711.863.459 1.004-.433.242-.848.029-1.068-.549-.295-.776-3.857-.778-4.152-.002a1.35 1.35 0 01-.686.686c-.43.164-.495.304-.477 1.034.018.778.031.798.163.252.49-2.033 3.88-3.172 4.987-1.675.37.501 1.55 1.378 1.853 1.378.048 0 .088-.296.088-.658 0-1.926-3.008-3.245-5.546-2.432m10.884-.066c-.378.089-.822.329-.988.533-.165.204-.457.431-.648.504-.191.073-.448.38-.572.682-.123.302-.41.949-.638 1.437-.595 1.274-.582 3.528.026 4.729.245.482.445 1.036.445 1.23 0 .194.244.511.542.704.298.192.72.551.938.797.333.376.647.46 1.976.533l1.581.087-1.32-.17c-1.673-.216-2.178-.378-2.083-.667.071-.214 3.808-.528 4.296-.362.356.122.198.637-.251.817-.312.125-.347.182-.117.191.374.014 2.141-1.627 2.141-1.989 0-.131.152-.407.338-.612.404-.447.107-.736-.76-.741-.425-.003-.598.16-.936.877-1.05 2.235-4.389 1.801-5.238-.68-.167-.488-.395-.918-.508-.955-.881-.294.429-4.489 1.667-5.337 1.303-.893 3.363-.515 4.071.746.348.619.971 1.101.971.752 0-.028.084-.344.187-.703.495-1.727-2.339-3.057-5.12-2.403m10.746.011c-.337.097-1.139.729-1.8 1.417l-1.192 1.242-.145 1.539c-.153 1.639.006 3.728.334 4.38.318.633 2.329 2.47 2.687 2.455.242-.01.212-.069-.116-.227-1.019-.492-.515-.747 1.481-.75 1.059-.001 2.134-.058 2.388-.126.4-.107.453-.061.395.347-.048.34-.232.506-.66.597l-.592.126.631.023c.395.015.727-.107.889-.325.142-.192.491-.498.777-.681.69-.44.961-1.696.447-2.072-.482-.352-.539-.334-.912.298-.986 1.669-3.892 2.382-4.846 1.189a17.548 17.548 0 00-.77-.88c-.234-.247-.533-.774-.664-1.17-.414-1.254-.178-1.339 4-1.435 4.006-.091 4.287-.157 4.164-.967-.237-1.553-.971-3.474-1.445-3.784a4.303 4.303 0 01-.79-.677c-.535-.643-2.861-.926-4.261-.519m16.72-.013c-.372.088-.817.333-.988.544-.17.211-.457.436-.637.498-1.245.434-2.285 5.874-1.335 6.985.172.201.43.662.573 1.023.143.362.491.805.773.985.283.179.63.484.772.676.161.218.493.34.888.325l.631-.023-.592-.126c-.387-.082-.613-.263-.65-.52-.054-.374.058-.394 2.272-.394 2.241 0 2.33-.016 2.389-.43.097-.678.583-.986.96-.609.313.314-.472 1.332-1.481 1.921-.298.174-.295.193.039.199.749.012 2.664-2.43 2.415-3.08-.163-.424-1.491.309-2.168 1.196-.796 1.044-3.25 1.08-4.2.063-2.58-2.764-2.012-3.333 3.27-3.282 3.693.035 4.095-.286 3.399-2.713-.165-.574-.363-.83-1.864-2.403-.916-.961-2.596-1.275-4.466-.835m12.355.005c-.313.093-.786.374-1.052.624-.445.418-.497.426-.674.111-.259-.463-.867-.767-1.246-.621-.47.18-.471 10.694-.001 10.874 1.062.408 1.27-.177 1.273-3.572.004-4.269.608-6.04 2.061-6.04.751 0 2.085-.506 2.085-.79 0-.205-1.279-.802-1.654-.774-.123.01-.479.094-.792.188m6.502-.009c-.456.088-.898.326-1.061.57-.153.231-.363.42-.466.42-.225 0-.752.502-.752.716 0 .084.107.046.237-.084.686-.686 1.196-.086.623.732l-.325.464-.26-.47c-.251-.452-.261-.454-.268-.049-.01.637.566 1.047.824.586.743-1.327 1.228-1.596 3.009-1.669l1.7-.07.786.86c.94 1.029.929.9.184 2.098l-.602.968-2.015-.039c-1.917-.038-1.939-.034-.451.082 1.59.124 2.203.486 1.161.686-2.59.498-3.925.319-3.18-.426.577-.578-.23-.167-.883.449-1.355 1.278-1.583 2.327-.823 3.778.577 1.102.972 1.469 1.556 1.446.326-.013.289-.068-.19-.279-1.181-.519-1.659-3.882-.644-4.52.612-.384.851.119.487 1.028-.246.615-.269.943-.108 1.543.305 1.136.511 1.256 2.277 1.33 1.866.078 2.316.255 1.623.639-.279.155-.35.261-.174.261.163.001.457-.121.653-.27.65-.493-.281-.901-2.056-.901-1.654 0-1.804-.085-2.1-1.186-.414-1.536.337-2.329 2.454-2.591.849-.105 1.918-.24 2.377-.301 1.463-.192 1.606 1.079.32 2.829-.486.661-.443 1.249.092 1.249.173 0 .62.288.993.641.655.621.666.624.325.089-.193-.304-.605-.684-.915-.844-.68-.352-.683-.382-.102-1.152.78-1.034.916-1.697.595-2.901-.232-.871-.239-1.214-.042-1.858.297-.97.252-1.253-.292-1.803a14.273 14.273 0 01-.692-.758c-.224-.276-.606-.318-2.427-.266-2.066.059-2.159.044-2.105-.334.131-.901 5.022-.746 5.461.173.149.312.439.611.644.665.205.053.39.109.411.124.022.014.092 1.848.156 4.075l.118 4.05.041-3.959.041-3.958-.766-.847c-1.043-1.152-2.92-1.502-5.449-1.016m22.642.056c-.362.116-.8.426-.973.689-.172.263-.509.553-.749.644-1.462.556-1.478 7.549-.018 8.328.233.125.66.479.948.787.297.317.725.556.988.551.452-.009.45-.015-.068-.247-.292-.131-.72-.483-.952-.781-.232-.299-.586-.544-.787-.544-.57 0-.783-1.023-.783-3.753.001-3.338.082-3.708.904-4.1.365-.174.716-.478.778-.676.368-1.157 4.758-1.12 5.127.044.075.236.362.45.693.516.87.174 1.389 2.696.786 3.822-.133.248-.133.411 0 .493.764.472.05 3.48-.897 3.777-.889.278-1.071 0-.405-.617.282-.261.514-.545.516-.632.002-.087.09-.751.195-1.476.278-1.925-.046-4.283-.66-4.805-.256-.217-.521-.551-.589-.741-.197-.554-4.275-.517-4.421.04-.056.213-.3.517-.544.677-.546.357-.984 3.211-.716 4.666.141.766.167.629.188-.989.046-3.504.745-4.443 3.307-4.443 2.685 0 3.747 1.877 3.186 5.63-.534 3.562-4.96 4.327-6.282 1.086-.134-.327-.164-.287-.174.234-.009.467.092.661.394.757.223.071.488.344.588.606.176.465.238.477 2.359.477 2.27 0 2.904.294 1.634.758-.504.184-.51.2-.089.214.253.009.67-.217.942-.511.269-.29.687-.626.929-.747 1.16-.578 1.7-4.126 1.025-6.734-.646-2.493-3.609-3.887-6.38-3m12.857.043c-1.16.504-.881 1.088.519 1.088 2.989 0 3.185.352 3.185 5.733 0 4.076.016 4.134 1.087 3.865l.493-.124-.003-3.799c-.003-3.839-.083-4.392-.836-5.799-.598-1.116-2.931-1.622-4.445-.964m32.767-.082c-.673.269-1.593 1.071-2.444 2.128l-.738.919-.002 2.432c-.002 1.463.088 2.605.225 2.865.429.81 2.536 2.703 2.991 2.687.387-.014.374-.038-.107-.214-.481-.175-.783-.756-.396-.759.082-.001 1.152-.024 2.378-.052 2.121-.048 2.227-.031 2.173.339-.032.22-.272.449-.551.526l-.493.136.493.016c.817.026 2.219-1.529 2.138-2.371-.097-1.02-.782-1.024-1.353-.007-1.169 2.078-4.24 1.725-5.743-.66-1.036-1.644-.513-1.935 3.641-2.022 4.471-.093 4.281-.04 4.279-1.192-.001-.6-.142-1.146-.394-1.527-.215-.326-.393-.776-.393-1.001-.005-1.53-3.78-3.014-5.704-2.243m12.813-.077c-.271.044-.738.362-1.037.706l-.543.625-.577-.684c-.484-.573-.636-.648-.939-.465-.549.333-.658 10.347-.117 10.757.298.225.313.223.102-.012-.422-.474-.348-10.443.078-10.607.202-.078.423.018.585.253.319.465.464.611.967.979.387.284.384.299-.198.779l-.592.49-.062 3.899c-.041 2.623-.138 3.997-.296 4.201-.205.264-.192.268.111.03.305-.239.346-.669.346-3.69 0-3.568.072-4.015.786-4.829.238-.271.504-.619.59-.772.172-.306 2.058-.536 2.825-.343.268.067.733.53 1.095 1.088l.63.971v3.637c0 2.565.069 3.706.237 3.874.314.314.658.306.397-.01-.119-.145-.231-1.872-.271-4.164-.055-3.237-.12-3.958-.371-4.149-.167-.127-.504-.516-.748-.865-.433-.615-.492-.635-2.067-.691-2.483-.088-2.326-.628.204-.707 1.967-.061 2.555.111 2.654.777.035.234.241.523.458.643.218.12.44.247.494.283.054.036.147 1.769.206 3.852l.107 3.786.041-3.685.041-3.685-.691-.827c-.38-.455-.691-.898-.691-.983 0-.401-2.361-.692-3.754-.462m17.07.077c-.612.178-2.847 2.236-2.847 2.622 0 .128.091.116.237-.03.485-.485.75-.26.75.639 0 .482.087 1.104.193 1.383l.193.507h2.943c3.706 0 3.87-.189 2.885-3.325-.131-.416-.091-.454.418-.395.684.079.922.917.833 2.93l-.057 1.284-3.505.054c-3.414.052-3.512.065-3.803.509-.472.721-.194 2.234.468 2.551.577.277.792.903.395 1.148-.3.185-.963-.322-.963-.737 0-.147-.101-.266-.225-.266-.585 0-.75-.714-.778-3.358-.023-2.226-.059-2.52-.216-1.778-.266 1.256-.044 4.295.358 4.909.557.85 2.244 2.4 2.598 2.386.26-.01.236-.062-.107-.227-1.007-.486-.515-.747 1.407-.747 1.019 0 2.13-.056 2.469-.123.851-.171.924.641.075.828-.903.199-.967.251-.329.267.421.011.767-.152 1.123-.528.283-.298.653-.657.823-.797.347-.287.428-1.723.107-1.921-.111-.068-.669.371-1.242.976l-1.04 1.101-1.474-.004c-1.615-.003-1.583.01-2.527-1.013-2.026-2.196-1.289-2.934 2.927-2.934 3.91 0 4.348-.106 4.348-1.049 0-.365-.064-.727-.141-.804-.078-.078-.281-.691-.452-1.364-.233-.921-.428-1.281-.788-1.461a2.737 2.737 0 01-.783-.627c-.56-.715-2.804-1.033-4.273-.606m12.209.095c-.242.169-.439.43-.439.581 0 .538-.378.491-.946-.117-.438-.468-.681-.586-1.001-.484-.601.19-.675 10.636-.078 10.864.277.105.297.082.099-.118-.429-.432-.348-10.415.086-10.581.214-.082.408.003.543.24.116.203.423.574.683.825l.472.456-.522.41c-.44.346-.517.555-.497 1.334l.025.924.133-.807c.197-1.201 1.284-2.254 2.326-2.254.538 0 .902-.126 1.146-.395.781-.863-.97-1.621-2.03-.878m-152.976.341c.562.445.04.591-2.188.613-2.294.022-2.699-.102-2.059-.633.488-.405 3.729-.39 4.247.02m37.951.262c-.272.328-2.264.38-2.459.064-.186-.3-.001-.425.845-.573.987-.172 1.932.126 1.614.509m42.762-.515c1.517 0 2.382 1.964 1.609 3.654l-.271.592-.018-.592c-.06-2.103-.601-2.718-2.509-2.853-1.202-.085-1.555-.177-1.555-.406 0-.295 1.274-.616 1.843-.465.145.038.55.07.901.07m33.849.106c.135.043.247.269.247.501 0 .304-.088.389-.313.303-.172-.066-1.194-.12-2.272-.12-1.598 0-1.959-.054-1.959-.293 0-.523 3.016-.797 4.297-.391m-103.651.195c.4.481.144.539-2.212.501-2.427-.038-2.509-.058-2.141-.501.192-.233.691-.301 2.176-.301 1.486 0 1.985.068 2.177.301m16.474-.182c.978.376.242.648-1.91.708-2.204.061-2.707-.065-2.285-.574.219-.265 3.575-.371 4.195-.134m6.633.473c.232.326.55.593.705.593.42 0 .334.589-.216 1.481-.469.761-.487.918-.488 4.275-.001 3.548-.112 4.046-.809 3.615-.204-.126-.251-10.222-.048-10.425.24-.24.43-.138.856.461m24.033-.461c-.239.239-.153 10.237.09 10.48.161.161.351.164.692.008l.469-.214v-5.083c0-4.453-.038-5.098-.312-5.203-.409-.156-.775-.152-.939.012m17.275.047c-.543.344-.431 10.294.119 10.544.458.209 1.043-.078 1.043-.513 0-.116-.119-.048-.265.15-.681.932-.82.327-.863-3.759-.064-6.133.083-6.88 1.101-5.593.432.547.443.617.148.943-.191.211-.31.663-.296 1.127l.022.774.145-.745c.079-.409.352-.965.605-1.235l.46-.49-.775-.691c-.817-.726-1.002-.792-1.444-.512m68.997-.059a.518.518 0 01.313.445c0 .286-.271.317-2.272.263-2.159-.058-2.94-.327-2.025-.697.357-.144 3.614-.153 3.984-.011m10.695.097c.073.119.005.345-.152.502-.426.426-1.934.154-1.934-.349 0-.424 1.835-.559 2.086-.153m-96.265 5.117c.048 4.458.016 5.136-.241 5.136s-.29-.678-.254-5.087c.049-5.934.013-5.185.248-5.185.117 0 .213 1.997.247 5.136m-52.389-3.969c0 .436-.382.808-.83.808-.435 0-.455-.361-.053-.935.336-.48.883-.402.883.127m133.728-.045c0 .381-.484.853-.874.853-.394 0-.397-.381-.009-.935.323-.461.883-.409.883.082m-139.04-.017c.283.257.308.404.132.791-.284.622-.449.599-.741-.106-.367-.886-.031-1.263.609-.685m9.783.391c.714.757.948 2.29.428 2.81-.255.255-3.62.33-4.948.11-1.022-.168-1.1-1.476-.148-2.472.325-.341.592-.689.592-.774 0-.74 3.32-.475 4.076.326m15.859-.581c1.148.23 2.185 2.308 1.607 3.222-.289.457-4.778.564-5.441.13-.929-.609-.384-2.578.893-3.224.528-.267 1.937-.328 2.941-.128m1.999.286c.236.44.13.972-.192.972-.285 0-.655-.772-.529-1.102.155-.402.467-.346.721.13m81.277-.212c.204.331-.087.937-.501 1.045-.3.079-.389.002-.389-.334 0-.677.61-1.164.89-.711m4.134-.006c1.165.443 1.795 2.885.872 3.379-.641.343-5.271.156-5.511-.223-.27-.427-.225-1.528.07-1.709.141-.087.454-.441.695-.787.241-.346.637-.667.879-.714.857-.166 2.495-.136 2.995.054m30.416.495c.626.608.708.802.708 1.672 0 1.269-.234 1.394-2.604 1.391-2.957-.003-3.27-.096-3.425-1.014-.381-2.253 3.552-3.767 5.321-2.049m-149.02-.234a.737.737 0 01-.193.45c-.105.106-.31.534-.455.952-.28.808-.994.615-.828-.223.286-1.439.283-1.435.887-1.435.352 0 .589.103.589.256m16.995.458c.13.394.193 1.101.14 1.573-.066.577 0 .996.2 1.282.479.683.056.77-3.75.773-3.448.003-3.507.01-3.804.464-.487.743-.207 2.139.512 2.551.589.338.831 1.334.324 1.334-.301-.001-1.594-1.347-1.809-1.884-.176-.44-.17-4.649.007-5.356.26-1.037.864-.56.864.682 0 1.612.015 1.62 3.358 1.62 3.611 0 3.775-.132 3.071-2.472-.317-1.051-.266-1.281.283-1.281.248 0 .445.233.604.714m10.258-.369c-.004.19-.137.519-.296.729-.16.211-.29.55-.29.753 0 .595-.369.195-.509-.552-.081-.434-.039-.796.115-.981.341-.411.988-.377.98.051m93.392.544c.089 1.331.222 1.679.643 1.679.51 0 .58 1.465.078 1.657-.171.066-1.882.122-3.802.123-3.582.003-3.777.035-4.117.657-.25.458.095 2.106.44 2.106.314 0 .929.943.776 1.191-.227.368-.709.187-1.04-.39-.184-.32-.484-.621-.667-.669-.66-.173-.758-5.353-.114-5.997.479-.479.738-.128.738.997 0 1.49.044 1.51 3.362 1.51 2.834 0 2.896-.009 3.317-.494.236-.272.351-.494.255-.494-.095 0-.229-.289-.296-.642a5.244 5.244 0 00-.416-1.206c-.347-.665-.224-.963.365-.879.344.049.436.212.478.851m-86.275 1.987v1.469h-3.645c-4.06 0-4.462.093-4.959 1.14-.443.932-.673.533-.677-1.173-.005-2.13.296-2.434 1.24-1.251l.552.692h3.046c3.399 0 3.269.054 3.547-1.481.14-.778.429-1.155.739-.964.086.054.157.759.157 1.568m64.082.728c.038 1.447.112 1.799.462 2.172.23.245.512.695.627.999.128.338.441.634.803.76.359.125.594.346.594.557 0 .867 4.448.872 5.334.006.333-.325.681-.592.772-.592.092 0 .275-.26.407-.579.132-.318.366-.626.521-.686.154-.059.366-.332.47-.607.18-.471.857-.698 1.048-.35.154.279-.271 1.45-.567 1.564-.163.062-.418.405-.566.761-.198.473-.439.684-.895.785-.344.075-.674.266-.735.424-.06.158-.388.409-.727.558-.501.22-.539.274-.2.287.912.035 3.355-2.234 3.8-3.531.207-.602.188-.728-.161-1.077l-.395-.395-.614.583c-.337.321-.75.846-.918 1.167-.348.667-.737 1.096-.994 1.096-.098 0-.393.23-.657.511-.809.863-3.671.657-4.98-.358-1.304-1.012-2.152-2.61-2.334-4.4l-.14-1.383.045 1.728m-100.247.544c-.006.38-.079.865-.162 1.078-.209.534-.441-.892-.278-1.707.153-.767.455-.335.44.629m82.465 1.481c.001 1.521.032 2.117.069 1.325.038-.792.038-2.037 0-2.765-.038-.729-.069-.081-.069 1.44m-92.463-1.481c0 .597.037.842.083.543a4.385 4.385 0 000-1.086c-.046-.299-.083-.055-.083.543m-13.366.839c-.153.245-.337.778-.408 1.186-.072.408-.308.907-.524 1.109-.217.202-.447.712-.512 1.135-.065.422-.217.901-.338 1.064-.189.255-.173.26.113.036.184-.143.393-.543.467-.889.073-.346.262-.775.42-.954.158-.179.408-.784.556-1.345.426-1.616.365-1.589 3.573-1.589 3.497 0 3.695.076 4.118 1.583.176.628.449 1.249.607 1.38.157.131.342.537.411.902.069.366.271.779.45.919.277.216.292.21.105-.043-.121-.163-.273-.642-.338-1.065-.065-.423-.294-.957-.509-1.185-.215-.229-.48-.814-.589-1.3-.301-1.339-.447-1.388-4.106-1.388-3.122 0-3.225.013-3.496.444m24.647 2.06c.408 1.198.401 1.249-.158 1.249-.53 0-.713-.324-.713-1.267 0-1.231.448-1.221.871.018m27.293-.241c.067.268.246.59.399.716.406.337.338.712-.153.84-.57.149-.939-.357-.947-1.301-.007-.863.502-1.049.701-.255m-20.855.493c0 .589-.638 1.312-.975 1.103-.29-.179-.263-.532.095-1.251.368-.736.88-.65.88.148m10.963.202c0 .755-.525 1.238-.918.845-.184-.184-.153-.392.139-.935.452-.839.779-.802.779.09m103.776.647c-.198.37-.862.468-1.055.156-.065-.105.085-.503.334-.886l.451-.697.227.541c.148.35.163.661.043.886m30.051-.78c0 .726-.294 1.126-.83 1.126-.472 0-.45-.498.053-1.205.534-.75.777-.725.777.079m-63.605 1.84c0 .041-.133.076-.296.076-.212 0-.294-.211-.289-.741l.008-.741.288.665c.159.365.289.699.289.741m-114.998-.616c-.126.586.095 1.087.478 1.087.129 0 .126-.087-.006-.247-.113-.136-.236-.514-.275-.84l-.07-.592-.127.592m183.768.05c-.016.353-.118.642-.227.642-.108 0-.197.108-.197.24 0 .157.107.132.312-.073.193-.193.279-.529.227-.881-.084-.564-.085-.563-.115.072m-102.525.158c-.012.222-.111.512-.22.642-.108.131-.055.115.118-.036.173-.15.272-.439.22-.642-.086-.333-.097-.329-.118.036m-107.533 1.021c.35.044.973.045 1.382.002.41-.043.123-.079-.637-.079-.761-.001-1.096.034-.745.077m45.337-.001c.299.045.788.045 1.087 0 .299-.045.054-.082-.543-.082-.598 0-.842.037-.544.082m21.531 0c.299.045.788.045 1.087 0 .298-.045.054-.082-.544-.082-.597 0-.842.037-.543.082m16.79 0c.299.045.788.045 1.087 0 .299-.045.054-.082-.543-.082-.598 0-.842.037-.544.082m17.581 0c.298.045.787.045 1.086 0 .299-.045.054-.082-.543-.082-.598 0-.842.037-.543.082m24.003.002c.355.044.889.043 1.185-.002.297-.045.007-.081-.645-.08-.652.001-.895.038-.54.082m31.795-.001c.35.044.973.045 1.382.002.41-.043.123-.079-.637-.079-.761-.001-1.096.034-.745.077m13.732-.001c.299.045.788.045 1.087 0 .299-.045.054-.082-.543-.082-.598 0-.842.037-.544.082m29.828 0c.298.045.787.045 1.086 0 .299-.045.054-.082-.543-.082-.598 0-.842.037-.543.082"
        ></path>
      </g>
    </svg>
  );
}

export default Icon;
