import React from "react";

function Icon() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      enableBackground="new 0 0 483 381"
      viewBox="0 100 483 381"
    >
      <defs>
        <linearGradient
          id="LinearGradient"
          x1="122.148"
          x2="-12.488"
          y1="279.78"
          y2="400.157"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset="0" stopColor="#00255F"></stop>
          <stop offset="1" stopColor="#D3D3D3"></stop>
        </linearGradient>
        <linearGradient
          id="LinearGradient_2"
          x1="299.202"
          x2="33.993"
          y1="185.104"
          y2="185.104"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset="0" stopColor="#F99373"></stop>
          <stop offset="1" stopColor="#FFA979"></stop>
        </linearGradient>
        <mask id="mask">
          <path
            fill="url(#LinearGradient_2)"
            d="M299.202 184.861l-37.542 27.065-87.73 62.971c-4.399 3.314-10.493 3.314-14.925.031l-87.404-62.644-37.608-26.936 16.049-54.767 43.83-30.915 65.361-4.355c4.399-3.314 10.493-3.314 14.925-.032l6.094 4.386 54.674-4.386 26.734 16.974 37.542 23.906v48.702z"
          ></path>
        </mask>
        <linearGradient
          id="LinearGradient_3"
          x1="42.471"
          x2="134.547"
          y1="143.257"
          y2="153.835"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset="0" stopColor="#FF9AA0"></stop>
          <stop offset="1" stopColor="#F94973"></stop>
        </linearGradient>
        <filter id="gaussianBlur" colorInterpolationFilters="sRGB">
          <feGaussianBlur stdDeviation="12.5"></feGaussianBlur>
        </filter>
        <linearGradient
          id="LinearGradient_4"
          x1="322.912"
          x2="150.42"
          y1="123.715"
          y2="242.159"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset="0.001" stopColor="#24C2E4"></stop>
          <stop offset="0.996" stopColor="#045FF2"></stop>
        </linearGradient>
        <mask id="mask_2">
          <path
            fill="#FFF"
            d="M283.766 162.719l-39.391-22.742-22.742 39.391 39.391 22.743 22.742-39.392z"
          ></path>
        </mask>
        <linearGradient
          id="LinearGradient_5"
          x1="160.282"
          x2="109.08"
          y1="149.383"
          y2="157.775"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset="0" stopColor="#BAEDFF"></stop>
          <stop offset="1" stopColor="#46C7FF"></stop>
        </linearGradient>
        <linearGradient
          id="LinearGradient_6"
          x1="127.043"
          x2="144.903"
          y1="198.299"
          y2="291.083"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset="0" stopColor="#AE8DEF"></stop>
          <stop offset="0.999" stopColor="#7546D9"></stop>
        </linearGradient>
        <linearGradient
          id="LinearGradient_7"
          x1="223.75"
          x2="237.014"
          y1="139.365"
          y2="276.072"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset="0" stopColor="#FF9AA0"></stop>
          <stop offset="1" stopColor="#F94973"></stop>
        </linearGradient>
        <filter id="gaussianBlur_2" colorInterpolationFilters="sRGB">
          <feGaussianBlur stdDeviation="12.5"></feGaussianBlur>
        </filter>
        <linearGradient
          id="LinearGradient_8"
          x1="134.264"
          x2="381.125"
          y1="219.196"
          y2="426.415"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset="0" stopColor="#00255F"></stop>
          <stop offset="1" stopColor="#D3D3D3"></stop>
        </linearGradient>
        <linearGradient
          id="LinearGradient_9"
          x1="329.236"
          x2="307.833"
          y1="318.661"
          y2="298.725"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset="0" stopColor="#87DFFF"></stop>
          <stop offset="1" stopColor="#3CA5FF"></stop>
        </linearGradient>
      </defs>
      <g>
        <path
          fill="url(#LinearGradient)"
          d="M299.504 346.602c0 3.203-1.106 5.872-3.288 7.977-2.214 1.601-4.395 2.669-7.716 2.669l-242.88.44c-2.768 0-5.536-1.068-7.75-2.638-2.214-2.136-3.32-4.774-3.32-7.977l-.294-161.196h264.955l.293 160.725z"
        ></path>
        <path
          fill="#00255F"
          d="M299.202 184.86l-37.542 27.066-87.73 62.97c-4.399 3.314-10.493 3.314-14.926.032l-87.403-62.645-37.608-26.936 37.51-27.066 81.668-58.55 6.062-4.42c4.399-3.314 10.493-3.314 14.925-.032l6.094 4.386 39.27 28.008 19.358 13.745 22.682 16.473 37.64 26.969z"
        ></path>
        <g >
          <path
            fill="url(#LinearGradient_3)"
            d="M84.309 226.952c-23.106 0-41.838-18.737-41.838-41.849 0-23.11 18.732-41.847 41.838-41.847 23.107 0 41.838 18.737 41.838 41.847 0 23.112-18.731 41.849-41.838 41.849z"
            filter="url(#gaussianBlur)"
          ></path>
          <path
            fill="#FFF"
            d="M92.321 211.044l14.657-25.392c3.65-6.325 1.488-14.396-4.836-18.047-6.324-3.653-14.392-1.49-18.043 4.834l-1.449 2.511-2.976-1.718c-6.324-3.653-14.392-1.491-18.043 4.834-3.651 6.325-1.488 14.394 4.836 18.047l25.854 14.931z"
          ></path>
          <path
            fill="url(#LinearGradient_4)"
            d="M249.533 220.861c-25.822 0-46.755-20.939-46.755-46.767 0-25.828 20.933-46.767 46.755-46.767 25.823 0 46.756 20.939 46.756 46.767 0 25.828-20.933 46.767-46.756 46.767z"
          ></path>
          <g mask="url(#mask_2)">
            <path
              fill="none"
              stroke="#FFF"
              strokeLinecap="round"
              strokeLinejoin="round"
              strokeWidth="2"
              d="M251.43 192.195l4.924 2.841a3.78 3.78 0 002.876.379 3.782 3.782 0 002.302-1.765l6.633-11.489a3.792 3.792 0 00-1.387-5.179l-4.924-2.843-10.424 18.056h0zm.83-27.97l3.791-6.566a5.682 5.682 0 017.766-2.08l-1.963 18.56-10.424 18.056-18.513-10.69a3.792 3.792 0 01-1.672-4.685l6.264-16.08a3.787 3.787 0 015.462-1.879l9.289 5.364h0z"
            ></path>
          </g>
          <path
            fill="#FAF9F9"
            d="M108.427 190.053c-20.173-14.47-24.775-42.539-10.277-62.694 14.498-20.154 42.605-24.761 62.778-10.29 20.174 14.47 24.775 42.54 10.277 62.693-14.497 20.155-42.604 24.763-62.778 10.291z"
          ></path>
          <path
            fill="url(#LinearGradient_5)"
            d="M138.855 179.15c-14.145 2.319-27.489-7.252-29.804-21.379-2.316-14.125 7.274-27.458 21.419-29.776 14.145-2.319 27.489 7.253 29.804 21.379 2.316 14.127-7.274 27.457-21.419 29.776z"
            opacity="0.65"
          ></path>
          <path
            fill="#FF666A"
            d="M169.815 196.818a1.738 1.738 0 00.727-3.116l-7.823-5.612a1.746 1.746 0 00-2.412.394 1.74 1.74 0 00.395 2.409l7.823 5.612c.389.311.851.384 1.29.313zM115.194 205.771a1.748 1.748 0 001.122-.707l5.652-7.858a1.74 1.74 0 00-.395-2.409 1.745 1.745 0 00-2.411.396l-5.653 7.858c-.55.763-.37 1.858.395 2.407.389.311.851.386 1.29.313z"
          ></path>
          <path
            fill="#FCC072"
            d="M98.819 128.312a1.738 1.738 0 00.728-3.115l-5.953-4.271a1.746 1.746 0 00-2.411.396c-.55.765-.371 1.86.395 2.407L97.53 128c.389.311.851.384 1.289.312zM160.602 118.186a1.747 1.747 0 001.122-.709l4.277-5.946a1.74 1.74 0 00-.394-2.409 1.745 1.745 0 00-2.412.396l-4.277 5.946a1.74 1.74 0 00.394 2.408c.389.312.851.385 1.29.314z"
          ></path>
          <path
            fill="#FFD844"
            d="M142.486 201.297c26.342-4.317 44.278-29.251 39.966-55.557-4.313-26.307-29.27-44.21-55.613-39.892-26.342 4.318-44.278 29.252-39.965 55.558 4.312 26.308 29.269 44.21 55.612 39.891zm-14.528-88.625c22.579-3.702 43.965 11.639 47.662 34.187 3.696 22.55-11.673 43.914-34.252 47.616-22.58 3.701-43.966-11.64-47.662-34.189-3.697-22.548 11.673-43.914 34.252-47.614z"
          ></path>
          <path
            fill="#FB7668"
            d="M128.203 114.168a1.736 1.736 0 011.999 1.433l.281 1.714a1.735 1.735 0 01-1.436 1.996 1.737 1.737 0 01-1.999-1.432l-.281-1.716c-.119-.954.523-1.847 1.436-1.995zM140.219 187.469a1.739 1.739 0 011.999 1.433l.281 1.716a1.739 1.739 0 01-1.436 1.997 1.74 1.74 0 01-1.999-1.435l-.281-1.715c-.119-.953.523-1.845 1.436-1.996zM96.829 157.827l1.718-.281a1.737 1.737 0 11.562 3.429l-1.717.281a1.737 1.737 0 11-.563-3.429zM170.194 145.801l1.717-.282a1.737 1.737 0 11.562 3.43l-1.717.281a1.736 1.736 0 01-1.998-1.433c-.119-.955.522-1.847 1.436-1.996zM104.768 129.811l1.403 1.006a1.74 1.74 0 01-.727 3.118c-.439.07-.907-.04-1.29-.315l-1.403-1.005a1.74 1.74 0 01-.394-2.409 1.744 1.744 0 012.411-.395zM165.142 173.118l1.403 1.006a1.74 1.74 0 01-.727 3.117 1.739 1.739 0 01-1.289-.313l-1.403-1.007a1.737 1.737 0 01-.395-2.407 1.745 1.745 0 012.411-.396zM112.055 181.82a1.746 1.746 0 012.412-.396 1.74 1.74 0 01.394 2.409l-1.008 1.401a1.733 1.733 0 01-1.122.709 1.739 1.739 0 01-1.684-2.722l1.008-1.401zM155.443 121.505a1.746 1.746 0 012.412-.396 1.74 1.74 0 01.394 2.409l-1.008 1.401a1.744 1.744 0 01-1.122.709 1.74 1.74 0 01-1.684-2.721l1.008-1.402zM155.159 150.214a1.738 1.738 0 01-1.436 1.996l-12.203 2c-.288 3.045-2.56 5.664-5.739 6.186-3.763.616-7.335-1.944-7.951-5.703-.52-3.175 1.242-6.16 4.039-7.407l-2.835-17.294a1.738 1.738 0 011.436-1.997 1.736 1.736 0 011.998 1.435l2.835 17.293a6.936 6.936 0 015.698 4.088l12.203-2c.913-.15 1.8.453 1.955 1.403zm-17.062 2.796a3.434 3.434 0 00-3.954-2.836 3.435 3.435 0 00-2.842 3.95 3.434 3.434 0 003.954 2.836c1.87-.269 3.153-2.052 2.842-3.95z"
          ></path>
          <path
            fill="#FFD844"
            d="M82.894 114.7c-3.972 5.523-2.71 13.221 2.811 17.15l14.398-19.97c-5.564-3.959-13.237-2.702-17.209 2.82zM171.348 100.2c5.527 3.965 6.789 11.665 2.811 17.15l-19.983-14.335c3.935-5.516 11.644-6.78 17.172-2.815z"
          ></path>
          <path
            fill="url(#LinearGradient_6)"
            d="M141.817 264.842c-20.971 5.124-42.131-7.727-47.261-28.705-5.131-20.979 7.711-42.14 28.683-47.265 20.971-5.125 42.131 7.726 47.261 28.705 5.13 20.978-7.711 42.14-28.683 47.265z"
          ></path>
          <path
            fill="#FFF"
            d="M139.632 241.684c-3.321 0-6.276-.668-8.846-1.823-.512-.228-1.738.843-1.738.843s-.794-2.198-1.287-2.533c-6.048-4.112-9.252-11.183-9.252-17.609 0-.321.007-.641.021-.96a15.09 15.09 0 01-3.703-3.844c1.33.592 3.714.965 5.215 1.144-1.533-.92-3.661-2.347-4.216-4.08a14.927 14.927 0 004.714 1.802c1.355-1.444 4.442-2.224 6.578-2.224 4.099 0 6.265 3.202 6.265 7.3 0 .584-.065 1.15-.192 1.693 6.17-.31 11.641-3.265 15.302-7.756 2.518 6.925-2.781 8.45-6.58 10.985 1.218-.037 6.644-1.446 7.644-2.002l.001.095c0 3.594-6.358 8.103-10.218 7.053.624.169 5.542.485 6.219.485.478 0 3.621.244 4.073.158-.945 2.95-6.432 5.789-9.612 4.864a14.894 14.894 0 009.22 3.177c.598 0 1.19-.033 1.771-.102a21.014 21.014 0 01-11.379 3.334z"
          ></path>
          <path
            fill="#E0DAEF"
            d="M142.17 167.747l25.563 95.403c1.868 6.971 9.054 11.096 16.062 9.217l57.847-15.499c7.009-1.878 11.17-9.043 9.301-16.016l-25.562-95.4c-1.869-6.974-9.055-11.098-16.063-9.22l-57.847 15.5c-7.008 1.879-11.17 9.043-9.301 16.015z"
          ></path>
          <path
            fill="url(#LinearGradient_7)"
            d="M143.92 174.277l25.562 95.401c1.869 6.973 9.054 11.098 16.063 9.219l57.847-15.499c7.008-1.879 11.169-9.043 9.301-16.015l-25.563-95.401c-1.868-6.974-9.054-11.097-16.062-9.22l-57.847 15.5c-7.009 1.879-11.17 9.043-9.301 16.015z"
            filter="url(#gaussianBlur_2)"
          ></path>
          <path
            fill="#FFF"
            d="M185.578 232.745l34.709-9.3c2.781-.745 3.73-4.321 1.521-6.338l-24.679-22.686c-2.04-1.827-5.266-.963-6.119 1.638l-9.918 31.957c-.905 2.852 1.594 5.505 4.486 4.729z"
          ></path>
        </g>
        <path
          fill="url(#LinearGradient_8)"
          d="M296.204 354.534c-2.216 1.657-4.4 2.762-7.724 2.762l-243.113.455c-2.77 0-5.54-1.105-7.756-2.729l116.097-99.798c7.475-6.425 18.517-6.446 26.017-.049l116.479 99.359z"
        ></path>
        <path
          fill="#FFF"
          d="M328.232 123.689a2.68 2.68 0 002.673 2.664 2.68 2.68 0 002.672-2.664 2.681 2.681 0 00-2.672-2.665 2.681 2.681 0 00-2.673 2.665z"
          opacity="0.31"
        ></path>
        <path
          fill="#C5D5FF"
          d="M333.577 115.208c-6.159 0-11.178 5.004-11.178 11.145h-3.65c0-8.156 6.648-14.784 14.828-14.784v3.639z"
          opacity="0.31"
        ></path>
        <path
          fill="#C5D5FF"
          d="M333.577 105.721c-11.406 0-20.694 9.26-20.694 20.632h-4.171c0-13.679 11.145-24.791 24.865-24.791v4.159z"
          opacity="0.31"
        ></path>
        <path
          fill="#C5D5FF"
          d="M333.577 96.363c-16.588 0-30.08 13.452-30.08 29.99H299c0-19.007 15.512-34.474 34.577-34.474v4.484zM373.287 246.027a1.5 1.5 0 001.5-1.5v-4.863a1.5 1.5 0 00-1.5-1.5h-2.085a14.325 14.325 0 00-1.434-3.412l1.476-1.472a1.5 1.5 0 000-2.124l-3.448-3.438a1.5 1.5 0 00-2.118 0l-1.483 1.478a14.391 14.391 0 00-3.422-1.43v-2.074a1.5 1.5 0 00-1.5-1.5h-4.886a1.5 1.5 0 00-1.5 1.5v2.074a14.391 14.391 0 00-3.422 1.43l-1.483-1.478a1.5 1.5 0 00-2.118 0l-3.448 3.438a1.5 1.5 0 000 2.124l1.476 1.472a14.325 14.325 0 00-1.434 3.412h-2.084a1.5 1.5 0 00-1.5 1.5v4.863a1.5 1.5 0 001.5 1.5h2.084c.326 1.202.815 2.34 1.434 3.412l-1.476 1.472a1.5 1.5 0 000 2.125l3.448 3.438a1.501 1.501 0 002.118 0l1.483-1.479a14.391 14.391 0 003.422 1.43v2.074a1.5 1.5 0 001.5 1.5h4.886a1.5 1.5 0 001.5-1.5v-2.074a14.391 14.391 0 003.422-1.43l1.483 1.479a1.501 1.501 0 002.118 0l3.448-3.438a1.5 1.5 0 000-2.125l-1.476-1.472a14.307 14.307 0 001.434-3.412h2.085zm-16.49 3.054c-3.878 0-7.039-3.151-7.039-7.018 0-3.866 3.161-7.018 7.039-7.018 3.879 0 7.04 3.152 7.04 7.018-.033 3.899-3.161 7.018-7.04 7.018zM76.677 128.424a1.5 1.5 0 001.5-1.5v-1.179c.895-.26 1.754-.595 2.575-1.079l.844.842a1.5 1.5 0 002.118 0l2.055-2.049a1.501 1.501 0 000-2.124l-.838-.836c.448-.781.821-1.674 1.082-2.567H87.2a1.5 1.5 0 001.5-1.5v-2.878a1.5 1.5 0 00-1.5-1.5h-1.187c-.26-.893-.597-1.749-1.082-2.567l.838-.836a1.501 1.501 0 000-2.124l-2.055-2.049a1.501 1.501 0 00-2.118 0l-.844.842a12.104 12.104 0 00-2.575-1.079v-1.179a1.5 1.5 0 00-1.5-1.5h-2.896a1.5 1.5 0 00-1.5 1.5v1.179c-.895.26-1.754.595-2.575 1.079l-.844-.842a1.501 1.501 0 00-2.118 0l-2.055 2.049a1.501 1.501 0 000 2.124l.838.836a12.025 12.025 0 00-1.082 2.567h-1.187a1.5 1.5 0 00-1.5 1.5v2.878a1.5 1.5 0 001.5 1.5h1.187c.261.893.597 1.749 1.082 2.567l-.838.836a1.501 1.501 0 000 2.124l2.055 2.049a1.5 1.5 0 002.118 0l.844-.842c.784.447 1.68.819 2.575 1.079v1.179a1.5 1.5 0 001.5 1.5h2.896zm-6.709-13.431a5.247 5.247 0 015.261-5.246 5.247 5.247 0 110 10.492 5.247 5.247 0 01-5.26-5.246zM12.587 18.735l6.748 21.012h38.111l-6.748-21.012h-38.11z"
          opacity="0.31"
        ></path>
        <path
          fill="#C5D5FF"
          d="M50.698 17.466h.885l.277.882 5.586 17.262V14.598h-30.09l-1.66-2.757h-6.36v5.625h31.362zM278.964 67.198l-23.692 11.99-20.498-32.428 44.19 20.438z"
          opacity="0.31"
        ></path>
        <path
          fill="#04659B"
          d="M234.774 46.76L269.84 71.81v13.225l-6.029-10.17-29.037-28.106z"
          opacity="0.1"
        ></path>
        <path
          fill="#C5D5FF"
          d="M234.774 46.76L269.84 71.81v13.225l-6.029-10.17-29.037-28.106z"
          opacity="0.1"
        ></path>
        <path
          fill="#1B2B7C"
          d="M169.725 13.954c.03-.439.411-.77.85-.74.288.02.57.048.847.085a.797.797 0 11-.212 1.58c-.242-.033-.49-.058-.744-.075a.797.797 0 01-.741-.85zm-4.568.605a.796.796 0 01-.546.986c-.235.067-.473.139-.713.216a.797.797 0 11-.484-1.519c.255-.081.507-.158.757-.23a.797.797 0 01.986.547zm11.097 1.622a.797.797 0 011.127.031c.195.207.38.422.556.647a.797.797 0 11-1.254.983 7.65 7.65 0 00-.461-.535.797.797 0 01.032-1.126zm-17.631.911a.797.797 0 01-.331 1.078c-.217.115-.436.234-.657.355a.797.797 0 11-.77-1.395c.228-.126.455-.249.681-.368a.797.797 0 011.077.33zm-6.007 3.609a.798.798 0 01-.192 1.11c-.217.153-.435.309-.653.467a.797.797 0 01-.934-1.292c.224-.162.447-.32.668-.477a.798.798 0 011.111.192zm26.74 1.62a.798.798 0 01.869.718c.026.274.045.551.057.832a.796.796 0 11-1.592.07 13.9 13.9 0 00-.052-.75.797.797 0 01.718-.87zm-32.34 2.64a.797.797 0 01-.094 1.123c-.189.16-.379.32-.569.484a.797.797 0 01-1.038-1.21c.193-.165.386-.33.578-.492a.797.797 0 011.123.095zm31.944 4.348c.426.11.683.544.573.97-.064.252-.133.505-.206.76a.798.798 0 01-1.532-.44c.069-.24.134-.48.195-.717a.796.796 0 01.97-.573zm-37.157.298a.796.796 0 01-.022 1.127c-.181.175-.364.351-.546.53a.797.797 0 01-1.113-1.142l.554-.536a.797.797 0 011.127.021zm-4.947 4.964a.797.797 0 01.037 1.127l-.523.56a.797.797 0 11-1.168-1.084c.176-.19.352-.379.528-.566a.797.797 0 011.126-.037zm39.77 1.334a.796.796 0 01.357 1.069 36.6 36.6 0 01-.358.7.796.796 0 11-1.412-.737c.118-.226.232-.45.344-.674a.797.797 0 011.069-.358zm-44.484 3.87c.333.287.371.79.083 1.124-.165.191-.33.384-.496.579a.797.797 0 01-1.212-1.035l.501-.585a.797.797 0 011.124-.083zm40.962 2.211a.797.797 0 01.191 1.11c-.149.21-.299.42-.452.63a.797.797 0 11-1.288-.938c.148-.204.294-.408.438-.611a.797.797 0 011.111-.191zm-45.481 3.189a.797.797 0 01.123 1.12l-.471.59a.797.797 0 01-1.248-.992c.159-.2.317-.398.476-.595a.797.797 0 011.12-.123zm41.17 2.322c.326.295.351.8.055 1.126-.179.197-.36.395-.544.593a.797.797 0 11-1.168-1.085c.179-.193.356-.386.531-.578a.797.797 0 011.126-.056zm-45.509 3.228a.796.796 0 01.158 1.116 151.336 151.336 0 00-.489.656.797.797 0 01-1.287-.941l.258-.348.244-.325a.797.797 0 011.116-.158zm40.586 1.781a.797.797 0 01-.059 1.126c-.192.172-.385.344-.58.516a.797.797 0 01-1.054-1.195c.191-.169.38-.337.567-.506a.798.798 0 011.126.06zm-5.362 4.498a.797.797 0 01-.158 1.116c-.21.158-.422.316-.635.473a.796.796 0 11-.946-1.282l.623-.464a.797.797 0 011.116.157zm-39.102-.197c.402.18.582.651.403 1.053-.101.225-.198.45-.291.677a.797.797 0 01-1.473-.609c.099-.24.202-.479.308-.718a.798.798 0 011.053-.403zm33.358 4.246a.797.797 0 01-.245 1.1c-.224.143-.45.286-.678.428a.797.797 0 01-.845-1.352l.668-.42a.797.797 0 011.1.244zm-35.533 2.485c.436.06.741.461.681.897-.034.25-.064.502-.09.753a.797.797 0 01-1.586-.164c.028-.269.06-.537.097-.805a.797.797 0 01.898-.681zm29.494 1.126c.21.387.066.871-.321 1.08-.118.065-.236.129-.355.192l-.359.192a.798.798 0 01-.748-1.407l.353-.189.35-.189a.797.797 0 011.08.321zm-6.449 3.248a.797.797 0 01-.403 1.052c-.246.11-.493.219-.74.327a.797.797 0 01-.637-1.461c.243-.106.485-.213.728-.321a.796.796 0 011.052.403zm-6.664 2.745a.797.797 0 01-.479 1.02c-.253.091-.506.182-.76.271a.796.796 0 11-.53-1.503c.25-.088.499-.177.749-.267a.797.797 0 011.02.479zm-16.547-.072a.796.796 0 01.905.671c.038.255.08.51.125.766a.796.796 0 11-1.569.28c-.048-.271-.092-.542-.132-.812a.796.796 0 01.671-.905zm9.697 2.342a.797.797 0 01-.546.986l-.777.22a.797.797 0 01-.429-1.535l.766-.217a.797.797 0 01.986.546zm-6.973 1.823a.797.797 0 01-.604.951c-.264.059-.527.117-.791.174a.796.796 0 11-.337-1.558l.78-.171a.797.797 0 01.952.604zm-7.077 1.424a.797.797 0 01-.653.919l-.794.132a.797.797 0 01-.257-1.573l.785-.13a.798.798 0 01.919.652zm-7.131 1.074a.797.797 0 01-.693.889c-.268.033-.535.066-.802.097a.797.797 0 11-.189-1.582l.795-.097a.797.797 0 01.889.693zm-7.17.782a.798.798 0 01-.726.863c-.266.024-.53.047-.797.069a.797.797 0 01-.134-1.588l.792-.068a.798.798 0 01.864.724zm20.344-.59a.796.796 0 011.034.447c.095.24.194.48.295.722a.797.797 0 01-1.468.62 39.884 39.884 0 01-.309-.755.797.797 0 01.448-1.035zm-27.544 1.142a.797.797 0 01-.746.845l-.8.048a.796.796 0 01-.094-1.591l.412-.025.384-.023a.797.797 0 01.844.746zm-7.202.394c.02.44-.32.812-.76.832l-.803.037a.797.797 0 01-.073-1.592l.464-.021.34-.016c.438-.02.811.32.832.76zm-7.204.319c.02.44-.32.812-.76.832l-.807.036a.796.796 0 11-.072-1.592l.808-.037c.44-.02.812.321.831.761zm-7.204.356a.796.796 0 01-.746.845l-.806.051a.796.796 0 11-.104-1.59l.812-.052a.796.796 0 01.844.746zm-7.199.556a.797.797 0 01-.706.879l-.795.09a.796.796 0 11-.186-1.583c.267-.031.537-.062.808-.091a.797.797 0 01.88.705zm-7.143 1.026a.796.796 0 01-.61.947c-.256.055-.508.111-.757.169a.797.797 0 11-.36-1.552c.257-.06.518-.119.781-.175a.796.796 0 01.946.611zm-6.915 2.016c.185.4.01.873-.39 1.057-.235.109-.465.22-.69.335a.797.797 0 11-.72-1.422c.242-.124.49-.244.743-.36a.796.796 0 011.057.39zm73.485.593a.796.796 0 011.095.266c.133.217.268.435.405.653a.797.797 0 11-1.348.85c-.142-.225-.281-.45-.418-.674a.797.797 0 01.266-1.095zm-79.457 3.355a.797.797 0 01.1 1.123c-.162.192-.318.389-.467.591a.797.797 0 01-1.282-.948c.17-.228.345-.45.526-.667a.797.797 0 011.123-.1zm83.508 2.585a.797.797 0 011.12.129c.155.194.311.389.469.584a.796.796 0 11-1.237 1.004c-.162-.199-.322-.398-.48-.597a.797.797 0 01.128-1.12zm-86.866 3.711a.797.797 0 01.624.939c-.026.129-.05.259-.074.39l-.068.395a.798.798 0 01-1.572-.265l.071-.41c.025-.142.052-.284.08-.425a.797.797 0 01.94-.624zm91.463 1.657a.796.796 0 011.126.027l.564.586a.797.797 0 01-1.144 1.11 77.178 77.178 0 01-.573-.596.796.796 0 01.027-1.127zm5.025 4.981a.797.797 0 011.126-.051l.578.524a.797.797 0 01-1.066 1.185l-.587-.532a.797.797 0 01-.051-1.126zm-97.429.7c.44.018.781.39.762.83l-.029.811a.797.797 0 11-1.593-.047c.008-.278.018-.556.03-.832a.797.797 0 01.83-.762zm102.897 4.064a.797.797 0 011.121-.115l.586.475a.796.796 0 11-.999 1.241l-.593-.48a.797.797 0 01-.115-1.121zm-102.89 3.34a.798.798 0 01.845.746c.017.272.035.544.055.817a.797.797 0 01-1.59.115c-.02-.278-.039-.556-.056-.833a.798.798 0 01.746-.845zm108.386.973a.797.797 0 011.115-.165l.422.312.217.16a.796.796 0 11-.944 1.284l-.645-.476a.798.798 0 01-.165-1.115zm5.848 4.203a.796.796 0 011.108-.208l.633.432a.797.797 0 01-.895 1.318l-.402-.273-.236-.162a.797.797 0 01-.208-1.107zM38.785 115.61a.796.796 0 01.901.676l.12.807a.797.797 0 01-1.577.238l-.12-.819a.796.796 0 01.676-.902zm119.395 1.706a.797.797 0 011.101-.243c.223.143.447.286.672.428a.797.797 0 11-.853 1.347l-.677-.431a.797.797 0 01-.243-1.101zm6.101 3.798a.798.798 0 011.094-.274l.661.395a.796.796 0 11-.815 1.37l-.665-.398a.797.797 0 01-.275-1.093zm-124.258 1.798a.796.796 0 01.942.618c.056.266.112.533.17.8a.797.797 0 01-1.559.334c-.058-.27-.115-.54-.17-.81a.796.796 0 01.617-.942zm130.346 1.768a.797.797 0 011.086-.301l.693.39a.798.798 0 01-.782 1.39l-.696-.393a.797.797 0 01-.301-1.086zm235.768 2.57a.796.796 0 01-.792.801l-.783.007a.796.796 0 11-.018-1.593c.264-.003.527-.006.791-.007a.797.797 0 01.802.792zm4.709.07a.798.798 0 01.826-.768l.79.031a.797.797 0 01-.066 1.592c-.26-.011-.521-.021-.782-.03a.798.798 0 01-.768-.825zm-11.796.105a.796.796 0 01-.753.839l-.781.045a.796.796 0 01-.096-1.591l.79-.045a.797.797 0 01.84.752zm18.876.28a.798.798 0 01.861-.728c.263.023.526.045.788.069a.797.797 0 11-.142 1.587l-.779-.067a.798.798 0 01-.728-.861zm-25.946.242a.797.797 0 01-.709.876c-.26.027-.519.055-.779.084a.797.797 0 11-.175-1.584c.262-.029.525-.058.788-.085a.796.796 0 01.875.709zm33 .483a.797.797 0 01.895-.685c.261.035.523.07.783.107a.796.796 0 11-.219 1.578l-.402-.055-.373-.05a.796.796 0 01-.684-.895zm-248.312-.26a.797.797 0 011.079-.325l.68.364a.796.796 0 11-.75 1.406l-.684-.366a.797.797 0 01-.325-1.079zm208.28.659a.796.796 0 01-.662.912l-.774.125a.797.797 0 11-.259-1.573l.783-.126a.796.796 0 01.912.662zm47.04.676a.797.797 0 01.929-.637c.26.048.519.097.777.147a.796.796 0 11-.302 1.565l-.767-.145a.797.797 0 01-.637-.93zm-54.013.586a.797.797 0 01-.609.948l-.766.169a.797.797 0 11-.35-1.555l.777-.172c.43-.093.855.18.948.61zm-336.293.04a.799.799 0 01.973.569l.21.792a.797.797 0 01-1.54.412c-.072-.266-.142-.533-.212-.8a.797.797 0 01.57-.973zm397.246.823a.797.797 0 01.964-.584l.465.116.3.075a.798.798 0 01-.391 1.545l-.755-.188a.797.797 0 01-.583-.964zm-256.031.496a.798.798 0 011.073-.347l.704.36a.795.795 0 01.349 1.071.795.795 0 01-1.071.349l-.708-.36a.798.798 0 01-.347-1.073zm188.192.309a.797.797 0 01-.55.984c-.252.071-.503.144-.754.217a.797.797 0 01-.446-1.531l.766-.22a.798.798 0 01.984.55zm74.676 1.053a.798.798 0 011-.52l.747.239a.798.798 0 01-.492 1.516l-.735-.235a.797.797 0 01-.52-1zm-81.44 1.053a.797.797 0 01-.482 1.019l-.738.268a.796.796 0 11-.55-1.496l.751-.272a.798.798 0 011.019.481zm-174.987.818a.798.798 0 011.066-.367l.715.349a.796.796 0 11-.696 1.433l-.297-.144-.421-.205a.797.797 0 01-.367-1.066zm263.107.452a.798.798 0 011.038-.441c.24.097.479.195.717.294a.796.796 0 11-.61 1.472 64.565 64.565 0 00-.704-.288.797.797 0 01-.441-1.037zm-94.718 1.312a.796.796 0 01-.403 1.052c-.239.107-.477.215-.715.324a.797.797 0 01-.663-1.449c.242-.111.485-.221.728-.33a.798.798 0 011.053.403zm-314.044.818c.42-.13.866.106.996.527l.242.779a.796.796 0 11-1.52.476c-.083-.261-.164-.523-.245-.786a.796.796 0 01.527-.996zm152.006.465a.797.797 0 011.059-.385l.713.333a.797.797 0 11-.672 1.445l-.716-.334a.796.796 0 01-.384-1.059zm263.225.293a.796.796 0 011.076-.335c.242.127.482.255.72.384a.798.798 0 01-.76 1.402 51.11 51.11 0 00-.701-.375.796.796 0 01-.335-1.076zm-107.56 1.52a.797.797 0 01-.311 1.083c-.229.127-.457.254-.684.383a.797.797 0 01-.786-1.387c.232-.131.465-.261.698-.39a.797.797 0 011.083.311zm-149.169 1.174a.798.798 0 011.054-.402l.731.327a.798.798 0 01-.65 1.456l-.733-.328c-.402-.18-.582-.652-.402-1.053zm262.853.923a.797.797 0 011.112-.181c.217.156.431.313.642.471a.797.797 0 01-.956 1.275 44.801 44.801 0 00-.617-.452.798.798 0 01-.181-1.113zm-119.756 1.554a.797.797 0 01-.207 1.108c-.215.147-.429.295-.642.445a.797.797 0 01-.916-1.305c.218-.153.437-.305.657-.455a.797.797 0 011.108.207zm-136.59.393a.797.797 0 011.047-.417l.72.31a.796.796 0 11-.628 1.464l-.722-.31a.797.797 0 01-.417-1.047zm-162.724.719a.796.796 0 011.015.489l.273.778a.796.796 0 11-1.502.531l-.275-.783a.796.796 0 01.49-1.015zm169.266 2.055a.797.797 0 011.041-.432l.734.304a.796.796 0 11-.607 1.473l-.39-.161a50.555 50.555 0 01-.346-.143.797.797 0 01-.432-1.041zm255.2-.19a.796.796 0 011.125.061c.187.208.369.418.547.629a.796.796 0 11-1.22 1.026 23.035 23.035 0 00-.513-.591.796.796 0 01.061-1.125zm-130.83 1.258a.797.797 0 01-.089 1.123c-.197.169-.394.339-.589.51a.798.798 0 01-1.05-1.199c.2-.176.401-.35.604-.523a.798.798 0 011.124.089zm-117.736 1.638a.797.797 0 011.035-.446l.727.289a.796.796 0 01-.588 1.482l-.362-.144-.367-.146a.797.797 0 01-.445-1.035zm6.587 2.586a.796.796 0 011.029-.458l.738.283a.796.796 0 11-.57 1.488l-.739-.283a.797.797 0 01-.458-1.03zm-179.949-.378a.795.795 0 011.03.456l.297.763a.796.796 0 11-1.485.58l-.298-.768a.797.797 0 01.456-1.031zm425.956.693a.796.796 0 011.032.452c.101.258.195.518.282.779a.797.797 0 01-1.512.504 14.842 14.842 0 00-.255-.703.797.797 0 01.453-1.032zm-140.035.294a.797.797 0 01.043 1.126c-.176.19-.351.381-.524.573a.797.797 0 01-1.183-1.068c.178-.198.357-.394.538-.589a.798.798 0 011.126-.042zm-99.29 1.92a.797.797 0 011.024-.471l.747.276a.797.797 0 11-.551 1.495l-.749-.276a.797.797 0 01-.471-1.024zm6.68 2.436a.797.797 0 011.019-.483l.741.263a.798.798 0 01-.533 1.502 116.538 116.538 0 01-.743-.264.798.798 0 01-.484-1.018zm88.05 1.058a.797.797 0 01.182 1.113c-.15.209-.299.419-.446.631a.797.797 0 01-1.308-.912c.152-.218.306-.434.46-.65a.798.798 0 011.112-.182zm-278.608.469a.797.797 0 011.044.424l.324.765a.796.796 0 11-1.466.625l-.326-.77a.796.796 0 01.424-1.044zm197.269.831a.797.797 0 011.013-.495l.749.257a.797.797 0 01-.516 1.508l-.751-.258a.796.796 0 01-.495-1.012zm227.22-.1a.798.798 0 01.694.889c-.018.14-.037.28-.058.421l-.067.417a.797.797 0 01-1.572-.262 24.882 24.882 0 00.095-.616l.02-.156a.797.797 0 01.888-.693zm-220.455 2.391a.797.797 0 011.007-.507l.747.247a.796.796 0 11-.499 1.514l-.475-.157-.274-.09a.798.798 0 01-.506-1.007zm6.752 2.202a.797.797 0 011.001-.517l.753.239a.797.797 0 01-.482 1.519l-.755-.24a.796.796 0 01-.517-1.001zm63.982.152a.796.796 0 01.323 1.079l-.179.334-.182.347a.797.797 0 11-1.414-.737c.123-.235.247-.468.372-.701a.796.796 0 011.08-.322zm-271.8 1.326a.796.796 0 011.057.391l.337.731a.796.796 0 11-1.446.67 121.21 121.21 0 01-.339-.736.795.795 0 01.391-1.056zm214.614.657a.798.798 0 01.996-.529l.757.232a.796.796 0 11-.466 1.524l-.759-.232a.797.797 0 01-.528-.995zm205.211.22a.797.797 0 01.408 1.05c-.108.246-.22.489-.335.73a.797.797 0 01-1.438-.688c.108-.226.213-.454.314-.684a.797.797 0 011.051-.408zm-198.392 1.84a.797.797 0 01.99-.539l.758.223a.797.797 0 11-.449 1.529l-.76-.224a.796.796 0 01-.539-.989zm6.836 1.984c.12-.424.56-.67.984-.55l.76.215a.798.798 0 01-.433 1.534 54.223 54.223 0 00-.381-.107l-.381-.108a.797.797 0 01-.549-.984zm40.483.359c.411.158.615.62.457 1.03-.092.239-.182.479-.271.719a.798.798 0 01-1.495-.552c.091-.248.184-.494.279-.74a.797.797 0 011.03-.457zm-33.631 1.55a.796.796 0 01.978-.56l.764.206a.797.797 0 11-.416 1.539l-.765-.207a.797.797 0 01-.561-.978zm-231.934.086a.797.797 0 011.072.347c.056.109.1.191.127.246l.032.062.008.015.002.003v.001a.797.797 0 11-1.412.739v-.001l-.012-.021-.033-.065-.13-.253a.798.798 0 01.346-1.073zm413.091.301a.796.796 0 01.103 1.122c-.175.212-.354.421-.537.627a.796.796 0 11-1.195-1.054c.172-.195.341-.393.507-.592a.797.797 0 011.122-.103zm-174.265 1.452a.797.797 0 01.972-.571l.765.198a.797.797 0 01-.399 1.544l-.767-.199a.797.797 0 01-.571-.972zm6.892 1.758a.796.796 0 01.965-.581l.765.189a.797.797 0 01-.381 1.547l-.767-.189a.798.798 0 01-.582-.966zm6.917 1.683a.798.798 0 01.959-.593l.773.182a.797.797 0 01-.364 1.552l-.775-.182a.798.798 0 01-.593-.959zm155.452.086a.796.796 0 01-.155 1.116c-.219.165-.44.328-.664.49a.797.797 0 01-.932-1.293c.215-.155.426-.311.635-.469a.797.797 0 011.116.156zm-144.751-.194c.427.107.686.54.578.967-.062.247-.123.495-.182.743a.797.797 0 01-1.55-.369l.08-.334.107-.429a.796.796 0 01.967-.578zm-3.75 1.715a.796.796 0 01.952-.603l.48.107.29.064a.797.797 0 11-.346 1.556l-.772-.172a.797.797 0 01-.604-.952zm6.922 1.516a.797.797 0 01.945-.615l.766.162a.796.796 0 11-.328 1.559l-.768-.162a.797.797 0 01-.615-.944zm135.645.818a.797.797 0 01-.344 1.073c-.237.122-.477.243-.718.363a.797.797 0 11-.707-1.429c.234-.115.466-.233.695-.351a.798.798 0 011.074.344zm-128.636.629a.797.797 0 01.937-.627l.777.154a.797.797 0 11-.308 1.564l-.78-.155a.796.796 0 01-.626-.936zm6.98 1.35a.797.797 0 01.928-.639l.437.081.334.062a.796.796 0 11-.288 1.567l-.773-.143a.795.795 0 01-.638-.928zm115.138.959a.796.796 0 01-.475 1.021c-.243.089-.487.176-.733.263a.798.798 0 01-.529-1.504l.412-.146.303-.11a.797.797 0 011.022.476zm-108.142.3a.797.797 0 01.921-.65l.786.134a.796.796 0 11-.267 1.571l-.618-.105-.171-.03a.797.797 0 01-.651-.92zm-25.585-.338c.437.06.742.461.683.897l-.047.346-.052.407a.797.797 0 11-1.581-.197 79.1 79.1 0 01.065-.511l.035-.26a.797.797 0 01.897-.682zm32.639 1.509a.797.797 0 01.911-.663l.778.121a.797.797 0 11-.245 1.575l-.78-.122a.797.797 0 01-.664-.911zm94.259.724a.797.797 0 01-.569.973l-.448.116-.365.093a.798.798 0 01-.39-1.546l.52-.132.28-.073a.796.796 0 01.972.569zm-87.29.331a.797.797 0 01.901-.677l.787.111a.797.797 0 11-.221 1.578l-.79-.111a.797.797 0 01-.677-.901zm7.132.968a.797.797 0 01.89-.692l.786.098a.797.797 0 11-.196 1.582l-.788-.098a.798.798 0 01-.692-.89zm73.324.282a.797.797 0 01-.637.93l-.359.067-.43.078a.797.797 0 11-.283-1.569c.26-.047.52-.094.779-.143a.797.797 0 01.93.637zm-66.296.555a.797.797 0 01.878-.707l.772.083a.798.798 0 01-.169 1.585l-.388-.041-.387-.042a.796.796 0 01-.706-.878zm59.197.605a.798.798 0 01-.689.892l-.414.052-.352.044a.797.797 0 01-.195-1.582l.757-.095a.798.798 0 01.893.689zm-52.08.116a.797.797 0 01.865-.723l.794.07a.797.797 0 01-.139 1.588l-.797-.07a.798.798 0 01-.723-.865zm7.088.581a.797.797 0 01.85-.74l.776.053a.797.797 0 11-.107 1.59l-.779-.053a.798.798 0 01-.74-.85zm37.963.074a.797.797 0 01-.729.86l-.809.064a.797.797 0 11-.123-1.589l.527-.041.275-.023a.797.797 0 01.859.729zm-30.865.357a.797.797 0 01.834-.758l.436.02.365.016a.797.797 0 01-.07 1.593l-.806-.037a.798.798 0 01-.759-.834zm23.747.116a.797.797 0 01-.762.83l-.78.032a.797.797 0 01-.062-1.593l.773-.031a.797.797 0 01.831.762zm-16.609.151a.797.797 0 01.814-.779l.778.016a.796.796 0 11-.03 1.593c-.261-.004-.521-.01-.782-.015a.798.798 0 01-.78-.815zm9.491.06a.797.797 0 01-.789.805l-.407.004a54.14 54.14 0 01-.404.002.797.797 0 11-.011-1.593l.806-.007a.797.797 0 01.805.789zm-92.377.633a.798.798 0 01.768.825l-.014.402-.011.386a.797.797 0 01-1.593-.049l.011-.385.014-.411a.796.796 0 01.825-.768zm-.241 7.107c.44.016.782.387.766.826l-.031.788a.796.796 0 11-1.592-.062l.03-.786a.797.797 0 01.827-.766zm-.297 7.121c.44.021.78.394.759.834l-.038.797a.797.797 0 01-1.592-.076l.023-.491.015-.305a.798.798 0 01.833-.759zm-.361 7.132c.44.025.776.401.751.841l-.045.801a.798.798 0 01-1.591-.092l.045-.799a.798.798 0 01.84-.751zm-.428 7.12c.44.029.772.408.743.848l-.053.785a.797.797 0 11-1.59-.107l.053-.784a.796.796 0 01.847-.742zm-.499 7.105a.796.796 0 01.733.855l-.061.789a.797.797 0 01-1.589-.124l.024-.308.037-.479a.797.797 0 01.856-.733zm-.579 7.104a.797.797 0 01.723.864l-.07.79a.797.797 0 01-1.588-.143l.071-.788a.796.796 0 01.864-.723zm-.665 7.099a.798.798 0 01.712.874l-.081.789a.797.797 0 11-1.585-.164l.037-.364.043-.423a.798.798 0 01.874-.712zm-.761 7.09c.437.05.75.446.7.883l-.093.788a.797.797 0 01-1.583-.187l.092-.785a.797.797 0 01.884-.699zm-.867 7.075a.796.796 0 01.684.895l-.105.784a.796.796 0 11-1.579-.214l.105-.78a.796.796 0 01.895-.685zm-.989 7.054a.797.797 0 01.668.908l-.121.788a.796.796 0 11-1.575-.243l.12-.785a.797.797 0 01.908-.668zm-1.131 7.044a.797.797 0 01.648.922l-.068.386-.07.401a.797.797 0 11-1.57-.278l.06-.335.078-.448a.797.797 0 01.922-.648zm-1.296 7.018c.431.087.71.507.623.939l-.158.78a.797.797 0 01-1.562-.32l.158-.776a.797.797 0 01.939-.623zm92.013 1.449a.797.797 0 01.487 1.016c-.047.133-.096.265-.148.396a.798.798 0 01-1.481-.59c.044-.111.086-.222.125-.334a.798.798 0 011.017-.488zm-3.642 5.545a.797.797 0 01-.118 1.121c-.205.165-.415.329-.631.49a.797.797 0 01-.953-1.278c.2-.149.394-.299.582-.452a.797.797 0 011.12.119zm-89.865-.022c.429.101.694.53.594.958l-.183.769a.798.798 0 01-1.55-.371l.181-.763a.797.797 0 01.958-.593zm83.832 3.818a.797.797 0 01-.402 1.052c-.237.106-.476.21-.718.314a.798.798 0 01-.625-1.467c.234-.099.465-.2.692-.302a.798.798 0 011.053.403zm-6.604 2.528a.797.797 0 01-.531.994l-.462.139-.307.091a.796.796 0 11-.449-1.529c.254-.075.505-.15.755-.226a.797.797 0 01.994.531zm-78.959.552a.798.798 0 01.554.982l-.128.457-.087.306a.796.796 0 11-1.533-.435l.134-.477.078-.279a.798.798 0 01.982-.554zm72.059 1.311a.798.798 0 01-.603.953l-.799.178a.798.798 0 01-.341-1.558c.265-.057.528-.116.79-.175a.798.798 0 01.953.602zm-7.006 1.431a.797.797 0 01-.647.923l-.767.133a.797.797 0 11-.269-1.571c.254-.043.508-.087.76-.132a.797.797 0 01.923.647zm-7.019 1.133a.797.797 0 01-.677.901l-.778.109a.797.797 0 11-.219-1.579l.39-.054.383-.054a.797.797 0 01.901.677zm-7.061.93a.797.797 0 01-.699.884l-.783.091a.796.796 0 11-.183-1.583l.501-.058.279-.033a.797.797 0 01.885.699zm-7.085.779a.796.796 0 01-.714.872l-.787.078a.796.796 0 11-.155-1.586l.784-.078a.797.797 0 01.872.714zm-7.097.67a.798.798 0 01-.725.863l-.789.068a.798.798 0 01-.136-1.588l.787-.068a.797.797 0 01.863.725zm-7.106.591a.797.797 0 01-.732.856l-.79.061a.797.797 0 11-.123-1.589l.789-.061a.797.797 0 01.856.733zm-7.11.537a.797.797 0 01-.737.853l-.79.057a.797.797 0 11-.115-1.59l.79-.057a.796.796 0 01.852.737zm-24.625-.538a.797.797 0 01.501 1.01c-.085.255-.172.508-.259.76a.797.797 0 01-1.506-.519l.255-.75a.797.797 0 011.009-.501zm17.513 1.047c.031.439-.3.82-.739.85l-.791.056a.797.797 0 01-.112-1.59l.791-.056c.439-.03.82.3.851.74zm-7.114.501a.797.797 0 01-.738.852l-.79.057a.798.798 0 01-.114-1.59l.791-.057a.796.796 0 01.851.738zm-7.112.52a.798.798 0 01-.734.856l-.407.031-.381.029a.797.797 0 11-.123-1.589l.789-.061a.798.798 0 01.856.734zm-7.108.568a.798.798 0 01-.726.863l-.783.068a.797.797 0 01-.139-1.588l.785-.068a.798.798 0 01.863.725zm-7.093.655a.796.796 0 01-.71.875l-.456.047-.316.034a.797.797 0 01-.168-1.585l.776-.081a.796.796 0 01.874.71zm-7.046.798a.797.797 0 01-.686.894l-.285.038-.518.07a.797.797 0 01-.215-1.579l.81-.109a.798.798 0 01.894.686zm-7.103 1.059a.796.796 0 01-.64.927l-.391.073-.383.072a.797.797 0 11-.3-1.565c.259-.05.522-.099.786-.147a.797.797 0 01.928.64zm-6.914 1.504a.798.798 0 01-.54.99 35.26 35.26 0 00-.785.239.798.798 0 01-.48-1.52 44.8 44.8 0 01.816-.249.797.797 0 01.989.54zm29.527.036a.797.797 0 01.425 1.044l-.13.305-.177.414a.797.797 0 01-1.463-.634c.101-.233.201-.467.301-.704a.797.797 0 011.044-.425zm-36.176 2.621c.267.35.2.85-.151 1.117a6.948 6.948 0 00-.536.451.798.798 0 01-1.088-1.166c.205-.19.424-.375.658-.553a.797.797 0 011.117.151zm33.15 3.844c.385.215.522.7.307 1.085-.131.235-.263.467-.397.697a.796.796 0 11-1.379-.799c.129-.223.258-.448.385-.676a.797.797 0 011.084-.307zm-35.482 2.134a.797.797 0 011.089.289c.115.198.245.401.391.61a.797.797 0 01-1.306.913 9.702 9.702 0 01-.463-.723.796.796 0 01.289-1.089zm31.629 3.847a.796.796 0 01.104 1.122c-.175.212-.353.419-.531.623a.798.798 0 01-1.198-1.052c.169-.192.337-.388.503-.589a.797.797 0 011.122-.104zm-26.919 1.443a.797.797 0 011.118-.144l.184.141.161.123.33.247a.797.797 0 11-.947 1.281l-.231-.171-.112-.085a41.659 41.659 0 01-.359-.274.797.797 0 01-.144-1.118zm21.8 3.477a.795.795 0 01-.267 1.094c-.236.144-.475.281-.716.412a.797.797 0 11-.759-1.402c.217-.117.433-.241.647-.372a.797.797 0 011.095.268zm-15.757.475a.796.796 0 011.056-.395c.227.104.454.202.678.295a.797.797 0 11-.611 1.472c-.241-.1-.484-.206-.728-.317a.797.797 0 01-.395-1.055zm9.147 1.983a.797.797 0 01-.768.825c-.273.01-.547.012-.824.006a.797.797 0 11.033-1.593c.246.005.491.003.734-.006a.797.797 0 01.825.768z"
          opacity="0.3"
        ></path>
        <path
          fill="#1B2B7C"
          d="M152.249 72.825c-3.966 3.64-8.729 7.057-14.401 10.102-24.086 12.933-50.566 5.942-71.002-.507a1009.64 1009.64 0 01-5.279-1.686c-8.074-2.597-14.887-4.787-20.18-5.342-3.178-.333-5.447-.025-6.996.86-1.44.825-2.586 2.342-3.107 5.27-1.294 7.27.057 16.896 2.985 27.442 2.912 10.491 7.316 21.662 11.913 31.92 4.595 10.25 9.362 19.546 12.983 26.283a399.125 399.125 0 004.4 7.972 271.776 271.776 0 001.51 2.622l.057.1.083.14.025.043.001.002c.001.001.001.001-1.713 1.016a187.098 187.098 0 01-1.715 1.014l-.002-.002-.028-.049-.087-.148-.336-.574c-.292-.504-.719-1.244-1.26-2.197a397.888 397.888 0 01-4.444-8.053c-3.652-6.793-8.465-16.178-13.11-26.54-4.64-10.354-9.13-21.726-12.117-32.483-2.97-10.704-4.522-21.035-3.068-29.207.668-3.754 2.322-6.468 5.051-8.029 2.622-1.5 5.894-1.731 9.39-1.365 5.746.602 13.07 2.96 21.142 5.56 1.671.538 3.374 1.086 5.101 1.631 20.533 6.48 45.466 12.852 67.918.797 5.616-3.015 10.267-6.398 14.084-9.984-5.299-8.622-8.029-16.885-7.151-24.355 1.009-8.573 2.582-15.05 4.496-19.726 1.891-4.622 4.224-7.75 6.934-9.214 2.909-1.572 5.884-1.036 8.286.846 2.294 1.798 4.082 4.799 5.245 8.383 3.575 11.022 1.84 29.341-12.716 44.622a90.611 90.611 0 002.282 3.241c7.746 10.524 19.32 21.905 33.572 33.478 28.494 23.136 67.426 46.823 107.05 65.738a597.689 597.689 0 0025.895 11.628c3.52-15.36 11.988-25.994 23.25-32.742 14.321-8.581 32.911-10.733 50.99-8.81 18.099 1.925 35.954 7.961 48.968 16.07 6.505 4.053 11.888 8.679 15.467 13.654 3.586 4.986 5.435 10.438 4.591 16.011-1.748 11.532-8.653 18.962-19.1 22.875-10.299 3.858-24.033 4.317-39.793 2.273-23.474-3.044-51.945-11.712-81.372-23.772a73.787 73.787 0 00-.768 8.746c-.806 26.579-10.038 67.086-23.991 97.301a167.77 167.77 0 01-5.347 10.622c4.124-.404 8.348-.797 12.621-1.189l4.776-.436c20.329-1.856 41.473-3.786 58.506-6.862 9.191-1.66 17.071-3.635 22.933-6.062 5.986-2.48 9.317-5.209 10.307-8.028a1.993 1.993 0 013.76 1.321c-1.6 4.552-6.413 7.849-12.542 10.388-6.254 2.59-14.462 4.625-23.75 6.302-17.215 3.109-38.531 5.054-58.807 6.905l-4.819.44c-5.277.484-10.447.967-15.424 1.468-5.081 8.478-10.655 15.492-16.621 20.124-4.622 3.589-9.581 5.828-14.798 6.099-5.246.273-10.516-1.456-15.703-5.373-2.538-1.916-4.374-3.813-5.34-5.743-1.025-2.047-1.06-4.137.02-6.039.995-1.751 2.803-3.102 4.931-4.194 2.166-1.113 4.897-2.074 8.041-2.927 9.061-2.458 22.251-4.187 37.06-5.708 2.28-3.944 4.478-8.229 6.579-12.778 13.74-29.754 22.837-69.735 23.625-95.752.109-3.591.436-6.986.966-10.192a601.28 601.28 0 01-26.827-12.024c-39.836-19.016-79.052-42.861-107.846-66.241-14.391-11.685-26.246-23.309-34.269-34.209a98.944 98.944 0 01-1.965-2.767zm137.146 238.241c-13.491 1.436-25.255 3.059-33.426 5.276-3.008.816-5.444 1.691-7.264 2.625-1.858.954-2.855 1.86-3.286 2.619-.345.607-.427 1.278.078 2.286.564 1.126 1.835 2.578 4.178 4.348 4.575 3.454 8.942 4.789 13.095 4.573 4.181-.218 8.38-2.02 12.561-5.267 4.889-3.796 9.614-9.459 14.064-16.46zm38.28-125.439c29.492 12.139 57.912 20.813 81.15 23.827 15.506 2.011 28.478 1.47 37.883-2.053 9.257-3.468 15.052-9.801 16.558-19.741.645-4.255-.712-8.675-3.886-13.087-3.182-4.423-8.114-8.721-14.34-12.6-12.448-7.756-29.714-13.62-47.281-15.489-17.587-1.871-35.207.289-48.521 8.266-10.425 6.246-18.365 16.149-21.563 30.877zM152.937 66.513c12.937-14.09 14.187-30.49 11.13-39.916-1.024-3.155-2.466-5.342-3.913-6.476-1.339-1.05-2.616-1.19-3.934-.478-1.517.82-3.387 2.935-5.14 7.218-1.731 4.23-3.243 10.321-4.226 18.683-.71 6.03 1.394 13.101 6.083 20.969zM64.543 180.776a1.992 1.992 0 01-2.729-.698l1.714-1.016 1.713-1.016a1.992 1.992 0 01-.698 2.73z"
          opacity="0.03"
        ></path>
        <path
          fill="#FFD844"
          d="M388.655 256.163l9.157 10.43 57.064-16.571-66.221 6.141z"
        ></path>
        <path
          fill="#F6AF00"
          d="M400.29 288.363l-2.51-21.77 57.063-16.571-48.622 25.669-5.931 12.672z"
        ></path>
        <path
          fill="#FFD844"
          d="M421.635 291.255l-15.414-15.564 48.622-25.669-33.208 41.233z"
        ></path>
        <path
          fill="#FFDA32"
          d="M16.445 290.64c2.62.147 5.051 2.221 7.121 3.688.23.163.675.561 1.127.923-.687-1.207-1.367-2.45-2.054-3.656-.467-.82-.942-1.603-1.41-2.422-.675-.032-1.996-.581-3.627-.743-1.893-.18-2.845.372-4.243-1.404-1.304-1.68-1.494-4.142 1.125-3.994 2.206.134 3.93 1.98 5.4 3.772-1.432-2.502-2.695-5.081-3.549-7.799-5.965-4.838-7.019-15.428-4.548-22.158.25-.627.55-1.319 1.121-1.687 1.267-.787 2.921.326 3.63 1.613 1.012 1.806 1.184 3.999.965 6.07-.218 2.071-.806 4.1-1.133 6.147-.294 1.715-.282 3.419-.182 5.067.03.044.03.044.021.08.49 2.829 1.54 5.513 2.847 8.063-.3-1.766-.122-4.186-.028-5.149.234-2.673 1.151-5.35 2.973-7.303.346-.379.766-.743 1.28-.67.631.06 1.03.676 1.238 1.288.77 2.056.75 4.435-.1 6.446-1.09 2.602-3.074 4.784-4.229 7.334l-.109-.023c.85 1.507 1.716 2.941 2.617 4.383.012-2.342.624-5.009 1.141-6.184.391-.937.927-1.843 1.807-2.41.843-.575 2.071-.651 2.84.006.451.362.704.946.805 1.535.322 1.847-.714 3.666-1.702 5.269-.989 1.603-1.92 3.293-2.982 4.88.114.176.227.352.305.52a329.126 329.126 0 014.4 7.716 30.902 30.902 0 01-.446-4.974c-.03-3.373.584-6.758 2.23-9.657.662-1.143 1.506-2.247 2.662-2.868.468-.24 1.073-.412 1.497-.094.23.163.401.426.491.711.74 1.671.435 3.61-.163 5.335-.96 2.705-2.607 5.074-3.95 7.622-.769 1.46-1.62 3.13-1.906 4.809a212.61 212.61 0 014.225 8.17c-.668-3.055-.518-6.919-.284-9.591.226-2.637 1.154-5.539 3.531-6.729.336-.155.71-.301 1.122-.288 1.205.032 2.03 1.307 2.194 2.477.203 1.518-.32 3.07-1.029 4.43-.746 1.352-1.693 2.586-2.438 3.938-1.349 2.395-1.885 4.889-2.2 7.583a207.003 207.003 0 012.921 6.49c-.05-1.524.131-3.073.23-3.884a19.145 19.145 0 012.641-7.525c.47-.769 1.17-1.563 2.05-1.601.798-.017 1.457.616 1.883 1.275 1.116 1.678 1.353 3.922.643 5.812-.489 1.218-1.317 2.25-2.145 3.282-.872 1.061-1.7 2.093-2.572 3.153a8.165 8.165 0 00-1.476 2.633 182.482 182.482 0 012.771 7.366 19.753 19.753 0 01.061-3.278c.224-2.448 1.014-4.887 2.595-6.778.554-.638 1.252-1.244 2.095-1.289 1.184-.048 2.184 1.113 2.27 2.303.083 1.191-.47 2.358-1.203 3.297a11.712 11.712 0 01-2.3 2.417c-.639.506-1.299.931-1.78 1.584-.585.782-.839 1.786-1.077 2.718l-.132.614c.64 1.954 1.272 3.943 1.868 5.924.394-2.184 1.58-4.349 2.975-5.903.884-.944 2.248-1.823 3.408-1.233.375.194.646.518.838.861.663 1.315-.072 2.973-1.197 3.979-1.126 1.005-2.535 1.572-3.718 2.49-.682.534-1.125 1.535-1.7 2.093.826 3.203 1.5 6.411 1.787 9.65.095.966-1.185 1.106-1.448.218-.656-2.411-1.275-4.813-1.894-7.215-1.203.308-6.03.215-6.757.247-1.184.048-2.564-.4-3.006-1.516-.413-1.072.281-2.36 1.297-2.86 1.024-.536 2.258-.46 3.372-.182.608.168 3.262 1.382 4.632 2.585-.647-2.446-1.323-4.937-2.087-7.37-.717-.192-1.425-.42-2.208-.476-1.205-.032-2.408.277-3.605.208-1.197-.068-2.51-.654-2.872-1.79-.423-1.377.868-2.801 2.28-3.027 1.412-.226 2.818.455 4.005 1.278.36.266.928.615 1.445 1.029l-.21-.612c-.376-1.064-.789-2.137-1.166-3.201-1.59-.002-3.617-.968-5.262-1.246-1.527-.291-3.15-.489-4.387-1.435-1.235-.947-1.839-2.892-.79-4.066.943-1.045 2.647-.868 3.96-.282 1.386.6 3.767 2.209 5.281 3.972-.92-2.24-1.839-4.48-2.846-6.663-2.572-.894-6.454.426-9.059-1.193-1.073-.647-2.342-2.32-1.45-3.641.718-1.055 2.688-.707 3.725-.597 1.768.229 3.831 1.202 5.467 2.576a50.952 50.952 0 00-1.227-2.571c-.52-1.096-1.079-2.199-1.6-3.295-.999-.29-2.728-.7-4.419-.762-2.17-.126-4.52.238-5.773-2.036-1.147-2.062-1.085-5.869 2.098-4.995 1.786.498 4.303 2.174 6.236 4.103A668.954 668.954 0 0025 296.112c-1.63-.162-2.916-.704-5.36-.435-1.978.217-4.559 1.477-5.926-.443-1.457-2.205.111-4.742 2.731-4.594z"
        ></path>
        <path
          fill="url(#LinearGradient_9)"
          d="M319.903 291.35c1.338 2.258.956 5.438.89 7.954.009.261-.074.84-.156 1.471.636-1.226 1.27-2.505 1.907-3.731.415-.826.803-1.677 1.218-2.503-.361-.59-.647-1.967-1.407-3.433-.899-1.696-1.884-2.159-1.203-4.304.661-2.012 2.595-3.545 3.933-1.288 1.143 1.923.55 4.352-.155 6.576 1.294-2.585 2.697-5.068 4.529-7.252.692-7.642 8.929-14.421 15.883-16.129.674-.181 1.378-.284 2.042-.019 1.357.608 1.376 2.596.691 3.929-.927 1.865-2.685 3.209-4.508 4.188-1.85.955-3.842 1.626-5.748 2.478-1.597.736-2.977 1.674-4.302 2.663l-.076.081c-2.101 1.984-3.718 4.318-5.119 6.854 1.291-1.223 3.421-2.423 4.267-2.898 2.362-1.286 5.084-2.035 7.745-1.578.499.061 1.03.252 1.281.688.308.539.019 1.23-.356 1.74-1.27 1.799-3.266 3.072-5.397 3.513-2.781.542-5.676.119-8.461.556-.028-.025-.029-.077-.004-.104a123.865 123.865 0 00-2.189 4.631c1.969-1.299 4.526-2.252 5.774-2.505.988-.191 2.059-.255 2.99.158.931.412 1.672 1.355 1.578 2.379-.057.605-.404 1.14-.834 1.548-1.367 1.304-3.429 1.454-5.337 1.547-1.883.065-3.814.237-5.725.225-.072.186-.196.374-.268.559-1.265 2.662-2.609 5.301-3.954 7.939a31.867 31.867 0 013.892-3.146c2.784-1.903 5.981-3.271 9.272-3.49 1.305-.098 2.723.01 3.871.624.48.245.94.674.907 1.199a1.607 1.607 0 01-.285.795c-.966 1.526-2.768 2.374-4.506 2.827-2.801.726-5.683.669-8.526.952-1.617.161-3.494.383-5.065 1.092a241.817 241.817 0 01-4.421 8.06c2.169-2.275 5.448-4.274 7.835-5.587 2.337-1.259 5.237-2.146 7.536-.812.322.198.645.449.865.755.666 1.024.062 2.432-.853 3.197-1.166 1.036-2.722 1.456-4.262 1.588-1.54.133-3.087.055-4.654.162-2.768.201-5.141 1.174-7.505 2.408a155.194 155.194 0 01-3.76 6.047 23.536 23.536 0 013.358-1.975 18.55 18.55 0 017.704-1.97c.889-.031 1.94.09 2.464.831.443.665.291 1.534.004 2.277-.77 1.859-2.472 3.306-4.471 3.768-1.273.28-2.586.169-3.899.057-1.34-.136-2.705-.246-4.045-.382-1.025-.096-2.043-.034-3.002.235a141.221 141.221 0 01-4.586 6.39 19.206 19.206 0 012.763-1.772c2.157-1.174 4.644-1.889 7.088-1.634.84.076 1.741.358 2.236 1.022.716.97.271 2.425-.644 3.19-.942.739-2.218.915-3.425.852a11.797 11.797 0 01-3.294-.592c-.741-.236-1.512-.55-2.3-.627-.997-.07-1.927.277-2.857.623-.18.085-.387.144-.568.229-1.25 1.615-2.526 3.256-3.908 4.848 2.036-.882 4.488-1.124 6.568-.804 1.289.191 2.78.872 2.905 2.15a2.13 2.13 0 01-.245 1.187c-.712 1.307-2.535 1.58-3.962 1.211s-2.714-1.215-4.12-1.715c-.821-.26-1.888-.092-2.705-.247-2.189 2.459-4.513 4.791-7.03 6.842-.739.575-1.584-.364-.981-1.065a487.12 487.12 0 014.955-5.592c-.921-.858-3.527-4.851-3.968-5.464-.715-.969-1.105-2.343-.407-3.31.673-.94 2.108-1.068 3.122-.528 1.014.541 1.629 1.619 2.01 2.731.205.595.675 3.459.452 5.273a176.294 176.294 0 004.946-5.853c-.209-.7-.444-1.424-.835-2.091-.638-.999-1.559-1.857-2.172-2.883-.613-1.026-.848-2.457-.096-3.374.929-1.105 2.797-.83 3.778.235.981 1.066 1.193 2.577 1.167 4.017-.011.446-.013 1.1-.041 1.782.124-.188.25-.323.374-.51.7-.915 1.348-1.828 2.021-2.767-.886-1.331-1.229-3.57-1.859-5.066-.601-1.419-1.335-2.912-1.233-4.434.075-1.547 1.377-3.163 2.931-2.929 1.394.187 2.183 1.73 2.468 3.108.289 1.482.289 4.361-.337 6.608a222.074 222.074 0 003.97-6.054c-.697-2.62-3.929-5.125-4.041-8.21-.045-1.255.59-3.241 2.213-3.245 1.257.009 2.082 1.839 2.562 2.791.817 1.62 1.133 3.834.922 5.962.495-.802.989-1.605 1.482-2.46.617-1.042 1.259-2.112 1.848-3.179-.297-.985-.96-2.663-1.822-4.073-1.114-1.846-2.697-3.623-1.55-5.941 1.075-2.131 4.274-4.154 5.303-1.022.588 1.76.593 4.796.034 7.459a468.904 468.904 0 003.335-6.241c-.785-1.439-1.045-2.843-2.63-4.673-1.284-1.5-3.772-2.958-2.935-5.16.823-2.568 3.804-2.671 5.115-.44z"
          opacity="0.65"
        ></path>
        <path
          fill="#00255f"
          d="M298.557 335.96c-3.433 6.361-9.332 18.221-33.717 25.072 0 0-.027-22.818 23.35-42.95 6.868-5.915 15.382-10.882 15.382-10.882s.678 16.792-5.015 28.76z"
        ></path>
        <path
          fill="#FFF"
          d="M289.71 335.32c-4.9 7.978-15.766 15.493-15.766 15.493s8.68-7.742 14.268-16.306c5.588-8.564 8.395-14.675 8.395-14.675s-1.996 7.509-6.897 15.488z"
        ></path>
        <path
          fill="#1B2B7C"
          d="M294.787 369.189c8.686-1.995 24.716-5.117 40.854-31.852 0 0-27.11-7.513-58.703 13.668-9.281 6.223-17.976 14.714-17.976 14.714s19.735 6.312 35.825 3.47z"
        ></path>
        <path
          fill="#FFF"
          d="M296.927 358.464c11.089-3.207 23.584-13.657 23.584-13.657s-12.048 7.777-24.058 11.61c-12.011 3.833-20.195 5.166-20.195 5.166s9.58.089 20.669-3.119z"
        ></path>
        <path
          fill="#1B2B7C"
          d="M47.184 331.692c.737 6.201 1.707 17.602 19.118 30.852 0 0 7.271-18.319-5.11-41.919-3.637-6.933-8.898-13.628-8.898-13.628s-5.88 13.274-5.11 24.695z"
        ></path>
        <path
          fill="#FFF"
          d="M54.494 333.989c1.401 7.965 7.741 17.454 7.741 17.454s-4.512-8.976-6.279-17.631c-1.768-8.654-2.08-14.455-2.08-14.455s-.783 6.666.618 14.632z"
        ></path>
        <path
          fill="#00255f"
          d="M39.655 359.582c-6.343-4.362-18.227-11.963-22.696-38.565 0 0 24.163 2.578 42.81 29.629 5.48 7.948 9.765 17.531 9.765 17.531s-17.858-1.2-29.879-8.595z"
        ></path>
        <path
          fill="#FFF"
          d="M41.343 350.288c-7.888-6.1-14.604-18.463-14.604-18.463s7.206 10.074 15.636 16.969c8.43 6.895 14.58 10.566 14.58 10.566s-7.723-2.972-15.612-9.072z"
        ></path>
        <path
          fill="#00255f"
          d="M13.384 175.208a6.376 6.376 0 11.001-12.75 6.376 6.376 0 010 12.75zm0 5.578c-6.602 0-11.954-5.352-11.954-11.953 0-6.602 5.352-11.954 11.954-11.954s11.954 5.352 11.954 11.954c0 6.601-5.352 11.953-11.954 11.953z"
          opacity="0.3"
        ></path>
        <path
          fill="#1B2B7C"
          d="M334.079 71.608a7.683 7.683 0 110-15.366 7.683 7.683 0 010 15.366zm0 7.97c-8.645 0-15.652-7.008-15.652-15.652 0-8.645 7.007-15.652 15.652-15.652 8.644 0 15.651 7.007 15.651 15.652 0 8.644-7.007 15.651-15.651 15.651z"
          opacity="0.2"
        ></path>
        <path
          fill="#1B2B7C"
          d="M358.713 329.371a3.985 3.985 0 11.001-7.97 3.985 3.985 0 01-.001 7.97zm0 3.984a7.97 7.97 0 110-15.938 7.97 7.97 0 010 15.938z"
          opacity="0.3"
        ></path>
      </g>
    </svg>
  );
}

export default Icon;
