/** @format */

import React from "react";

const Svg = () => (
  <svg
    width="120"
    height="130"
    viewBox="0 0 120 130"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M12.0033 66.0532C12.0026 66.0532 12.0016 66.0532 12.001 66.0532C11.7071 66.0526 11.4009 65.9842 11.0776 65.8397C11.0762 65.839 11.0749 65.8384 11.0736 65.838C11.0652 65.834 11.0565 65.8303 11.0481 65.8263C11.0441 65.8247 11.0401 65.8227 11.0361 65.821C10.2931 65.4757 10.2422 65.6108 10.1077 65.2161C9.92429 64.6779 9.83994 64.0392 9.18765 63.9592C9.12206 63.9511 9.03269 63.7429 9.03303 63.6182C9.03303 63.5978 9.03537 63.5795 9.04073 63.5648C9.09227 63.4246 9.11336 63.2978 9.11336 63.1804C9.11303 62.6842 8.73617 62.3552 8.67191 61.8904C8.67158 61.8871 8.67092 61.8834 8.67059 61.8801C8.66958 61.8734 8.66824 61.8668 8.66724 61.8604C8.6659 61.8524 8.66455 61.8447 8.66322 61.8374C8.60866 61.5518 8.45973 61.4894 8.28469 61.4894C8.21709 61.4894 8.14547 61.4987 8.07418 61.508C8.00256 61.5171 7.93094 61.5264 7.86367 61.5264C7.85563 61.5264 7.84794 61.5264 7.83991 61.5261C7.83221 61.5257 7.82451 61.5254 7.81681 61.5247C7.81046 61.5244 7.80409 61.5237 7.7974 61.5231C7.7887 61.5221 7.78033 61.5211 7.77163 61.5194C7.78067 61.4436 7.78536 61.3706 7.78536 61.3002C7.7867 60.8447 7.60965 60.4957 7.30643 60.2218C7.30677 60.2071 7.3071 60.1928 7.3071 60.1781C7.3071 59.9976 7.27799 59.8154 7.27832 59.6342C7.27832 59.4136 7.32217 59.1951 7.51528 58.9835C7.52264 58.9755 7.52564 58.9622 7.52564 58.9452C7.52564 58.8578 7.44432 58.6686 7.41252 58.5414C7.48381 58.3803 7.54539 58.2154 7.59726 58.0466C8.05778 57.9919 8.19601 57.5645 8.35565 57.1621C8.58055 57.112 8.69099 57.0319 8.69132 56.9228C8.69199 56.8407 8.63008 56.7423 8.50859 56.6285V56.6282C8.84528 56.1758 9.31282 55.8317 9.44301 55.2088L9.44469 55.2145C9.44837 55.2168 9.45171 55.2195 9.4554 55.2221C9.46376 55.2282 9.47214 55.2341 9.48017 55.2408C9.48184 55.2422 9.48351 55.2432 9.48484 55.2445C9.4912 55.2495 9.49723 55.2545 9.50292 55.2595C9.66825 55.4 9.79877 55.6159 10.0488 55.6175C10.0498 55.6175 10.0508 55.6175 10.0518 55.6175C10.0525 55.6175 10.0528 55.6175 10.0531 55.6175C10.0919 55.6175 10.1334 55.6122 10.1786 55.6008C10.1813 55.6002 10.184 55.5995 10.1867 55.5989C10.1904 55.5979 10.1944 55.5965 10.1984 55.5955C10.2948 55.3843 10.4149 55.1524 10.509 54.9098C10.6395 54.5742 10.7693 54.4177 10.9691 54.417C10.9698 54.417 10.9702 54.417 10.9708 54.417C10.9725 54.417 10.9742 54.417 10.9758 54.417C11.0679 54.418 11.175 54.4517 11.3038 54.5158C11.3075 54.5178 11.3115 54.5198 11.3155 54.5218C11.3289 54.5285 11.3423 54.5354 11.3564 54.5431C11.3594 54.5448 11.3627 54.5465 11.3661 54.5481C11.3711 54.5508 11.3764 54.5535 11.3818 54.5562C11.3821 54.5565 11.3828 54.5568 11.3831 54.5572C11.5645 54.6483 11.7526 54.688 11.9441 54.6883C11.9447 54.6883 11.9454 54.6883 11.9461 54.6883C11.9477 54.6883 11.9494 54.6883 11.9511 54.6883C12.3725 54.6866 12.8102 54.4968 13.2275 54.2529C13.2483 54.2405 13.2691 54.2285 13.2898 54.2161C13.83 53.8928 13.5562 53.2435 13.8059 52.8128C13.8839 52.678 13.914 52.5628 13.9136 52.4597C13.9126 52.1047 13.5519 51.8955 13.5522 51.5471C13.5522 51.5178 13.5549 51.4874 13.5602 51.4561C13.5609 51.4561 13.5612 51.4564 13.5616 51.4567C13.5636 51.4554 13.5652 51.4544 13.5669 51.4534C13.6312 51.4451 13.6988 51.4487 13.7567 51.4197C13.7938 51.4014 13.8149 51.3286 13.843 51.2802C13.751 51.3379 13.659 51.3957 13.5669 51.4534C13.5649 51.4534 13.5629 51.4537 13.5606 51.4541C13.5606 51.4548 13.5606 51.4554 13.5602 51.4561C13.3564 51.36 13.0555 51.2472 13.0565 51.0163C13.0565 50.9559 13.0776 50.8872 13.1265 50.8087C13.4491 50.2892 13.4217 49.8094 13.4682 49.2869C13.4946 48.9923 13.7366 48.8548 13.9782 48.8208C14.2011 48.7894 14.4234 48.7838 14.6339 48.7681C14.8394 48.1531 14.8815 47.4905 15.497 47.2052C15.6426 47.1378 15.7734 47.015 15.918 46.9429C16.7577 46.5235 17.3923 45.8956 17.7437 44.8645C17.8796 44.4665 18.2022 44.1318 18.4746 43.7154C18.2056 42.968 17.9582 42.2156 17.9592 41.4024C17.9596 41.0194 18.0151 40.6227 18.149 40.2069C18.1537 40.1932 18.1557 40.1785 18.1554 40.1632C18.1543 40.0477 18.0345 39.8949 17.981 39.7631C17.9997 38.7087 18.7451 38.1695 19.3485 37.625C19.6413 37.361 20.0155 37.269 20.3927 37.269C20.5654 37.269 20.7384 37.288 20.9051 37.319C21.0516 37.3464 21.1976 37.3807 21.3388 37.4275C23.2465 38.0571 25.2462 38.4815 27.038 39.3714C29.4973 40.5933 31.84 42.0844 34.2396 43.4461C34.2346 43.4908 34.2319 43.5339 34.2319 43.5759C34.2316 43.8158 34.3129 44.0087 34.4819 44.1518C34.6232 44.1985 34.7634 44.2482 34.9023 44.3016C34.7711 44.5569 34.7477 44.9533 34.423 44.955C34.4224 44.955 34.4217 44.955 34.421 44.955C34.4207 44.955 34.4203 44.955 34.42 44.955C34.3872 44.955 34.3511 44.9506 34.3112 44.9419C34.3082 44.9412 34.3056 44.9406 34.3025 44.9399C34.09 44.8899 33.8511 44.8829 33.675 44.7654C33.6734 44.7644 33.6717 44.7634 33.6704 44.7624C33.668 44.7611 33.666 44.7594 33.664 44.7581C33.4692 44.6306 33.2774 44.5702 33.0873 44.5692C33.0857 44.5692 33.084 44.5692 33.0826 44.5692C33.0816 44.5692 33.0803 44.5692 33.0793 44.5692C32.7888 44.5706 32.502 44.71 32.2128 44.9616C32.0224 45.1275 31.8423 45.312 31.6583 45.4881C31.6522 45.4871 31.6462 45.4858 31.6402 45.4848C31.6312 45.4831 31.6225 45.4815 31.6134 45.4798C31.6091 45.4788 31.6044 45.4778 31.6 45.4771C31.4849 45.4541 31.3607 45.4257 31.2432 45.4251C31.2422 45.4251 31.2413 45.4251 31.2399 45.4251C31.2392 45.4251 31.2389 45.4251 31.2382 45.4251C31.0907 45.4254 30.9541 45.4711 30.8607 45.629C30.8604 45.63 30.8597 45.631 30.8591 45.632C30.8587 45.6326 30.8584 45.6333 30.858 45.6339C30.8564 45.6363 30.855 45.6389 30.8537 45.6413C30.7848 45.7654 30.7556 45.8692 30.7553 45.9579C30.7546 46.2359 31.0344 46.369 31.2409 46.5399C31.514 46.7668 31.7426 47.0617 31.9906 47.327C31.999 47.8388 32.3169 47.9996 32.6623 48.1288C32.6656 48.1431 32.669 48.1571 32.6723 48.1708C32.6727 48.1715 32.6727 48.1718 32.6727 48.1721C32.674 48.1775 32.6753 48.1832 32.6767 48.1885C32.677 48.1895 32.677 48.1905 32.6774 48.1918C32.7935 48.6706 32.84 48.8234 33.084 48.8248C33.085 48.8248 33.086 48.8248 33.087 48.8248C33.1054 48.8248 33.1248 48.8238 33.1456 48.8221C33.2252 48.8161 33.3229 48.7984 33.4451 48.7734C33.4508 48.7724 33.4565 48.7711 33.4625 48.7701C33.4906 48.7641 33.5201 48.7581 33.5509 48.7517C33.5586 48.7501 33.5666 48.7484 33.5746 48.7467C33.5763 48.7464 33.5783 48.7457 33.58 48.7454C33.5843 48.7444 33.5887 48.7437 33.5934 48.7427C33.6463 48.7314 33.7005 48.7127 33.7543 48.6943C33.8367 48.6659 33.9187 48.6376 33.9956 48.6369C33.9967 48.6369 33.9977 48.6369 33.9987 48.6369C33.999 48.6369 33.9993 48.6369 33.9993 48.6369C34.0087 48.6369 34.0177 48.6373 34.0268 48.6383C34.0291 48.6383 34.0315 48.6386 34.0335 48.6389C34.5335 48.7 35.0271 48.7948 35.5121 48.8752C35.5097 48.9109 35.5091 48.9439 35.5091 48.9746C35.5091 49.0053 35.5097 49.033 35.5097 49.058C35.5097 49.1147 35.5067 49.1565 35.487 49.1815C34.5797 50.347 33.2229 50.8261 32.3698 52.0951C32.3664 52.1004 32.3624 52.1057 32.3584 52.1111C32.3577 52.1117 32.3567 52.1127 32.3561 52.1137C32.355 52.1151 32.3541 52.1161 32.353 52.1174C32.352 52.1184 32.3514 52.1194 32.3504 52.1204C32.2376 52.2492 31.9792 52.2962 31.7831 52.2976C31.7797 52.2976 31.7764 52.2976 31.773 52.2976C31.7727 52.2976 31.7724 52.2976 31.7724 52.2976C31.758 52.2976 31.744 52.2972 31.7302 52.2969C31.7276 52.2969 31.7252 52.2966 31.7225 52.2966C31.4257 52.2842 31.1422 52.1684 30.8534 52.097C30.7145 52.049 30.5756 52.0006 30.437 51.9526C30.437 51.9522 30.4373 51.9519 30.4373 51.9515C30.437 51.9515 30.437 51.9515 30.4367 51.9515C30.6867 51.4157 30.6649 50.7434 31.1552 50.3219C31.3112 50.4988 31.4578 50.6646 31.6044 50.8304C31.8032 50.3463 31.9207 50.06 31.9203 49.7731C31.92 49.3576 31.6723 48.9416 31.0652 47.9225C31.0555 47.9279 31.0455 47.9329 31.0361 47.9379C30.7285 48.1011 30.5612 48.1848 30.3959 48.1855C30.3952 48.1855 30.3945 48.1855 30.3938 48.1855C30.3925 48.1855 30.3912 48.1855 30.3898 48.1855C30.2272 48.1841 30.0652 48.1021 29.7717 47.9362C29.771 47.9359 29.77 47.9356 29.7693 47.9349C29.7613 47.9306 29.7536 47.9262 29.7456 47.9216C29.7426 47.9199 29.7399 47.9182 29.7372 47.9169C29.7305 47.9132 29.7242 47.9095 29.7175 47.9055C29.7171 47.9055 29.7168 47.9052 29.7164 47.9049C29.7118 47.9022 29.7068 47.8995 29.7021 47.8969C29.696 47.8935 29.6903 47.8902 29.6843 47.8869C29.6813 47.8852 29.678 47.8832 29.675 47.8815C29.6723 47.8799 29.6693 47.8785 29.6666 47.8768C29.6626 47.8748 29.6586 47.8725 29.6549 47.8705C29.6522 47.8692 29.6495 47.8678 29.6465 47.8665C29.5498 47.8165 29.4598 47.7914 29.3774 47.7908C29.3764 47.7908 29.3758 47.7908 29.3751 47.7908C29.3744 47.7908 29.3737 47.7908 29.3731 47.7908C29.1987 47.7918 29.0571 47.9039 28.9504 48.1261C28.948 48.1311 28.9457 48.1364 28.943 48.1418C28.942 48.1438 28.941 48.1461 28.94 48.1481C28.9394 48.1498 28.9387 48.1511 28.938 48.1528C28.9373 48.1548 28.9363 48.1565 28.9357 48.1585C28.9343 48.1618 28.9326 48.1648 28.9313 48.1681C28.8587 48.3353 28.8219 48.5008 28.8222 48.6463C28.8225 48.8515 28.8962 49.0163 29.0451 49.0874C29.2412 49.1808 29.4611 49.2242 29.6753 49.2699C30.007 49.341 30.1927 49.5115 30.1917 49.7317C30.1914 49.8338 30.1509 49.9462 30.0662 50.0644C29.6023 50.7127 29.1495 51.3486 28.9474 52.1705C28.9129 52.3099 28.8965 52.4337 28.8965 52.5442C28.8955 52.9673 29.1301 53.1941 29.4912 53.3516C29.2824 54.2345 28.8172 54.8508 28.0862 55.2558C27.7603 55.436 27.4788 55.751 27.1773 56.0046L27.1756 56.0056C27.0343 55.9595 26.8928 55.9142 26.7512 55.8691C26.2418 55.7657 26.0029 55.2615 25.6491 54.9272C25.6494 54.9269 25.6494 54.9265 25.6498 54.9259L25.6484 54.9265C25.6484 54.9268 25.6488 54.9272 25.6491 54.9272C25.5336 55.2682 25.4182 55.6089 25.3031 55.9495C25.1608 55.9062 25.0189 55.8604 24.8777 55.8131C24.8777 55.8127 24.878 55.8124 24.878 55.8121C24.8777 55.8111 24.877 55.8097 24.8767 55.8084C24.8767 55.8077 24.8767 55.8067 24.8767 55.8057C24.8767 55.765 24.88 55.723 24.88 55.6823C24.88 55.6489 24.8777 55.6169 24.8693 55.5875C24.8573 55.5468 24.797 55.5308 24.7582 55.5031C24.7977 55.6052 24.8372 55.7066 24.8767 55.8084C24.8767 55.8101 24.8767 55.8114 24.8767 55.8127C24.877 55.8131 24.8774 55.8131 24.8777 55.8131C24.8208 55.9826 24.7622 56.1514 24.7023 56.3196C24.4366 56.2498 24.1775 56.1451 23.9051 56.118C23.9014 56.1177 23.8981 56.1174 23.8947 56.1174C23.8683 56.115 23.8429 56.1137 23.8188 56.1137C23.8184 56.1137 23.8184 56.1137 23.8181 56.1137C23.8174 56.1137 23.8164 56.1137 23.8158 56.1137C23.4429 56.1147 23.3402 56.395 23.4851 56.9785C23.4858 56.9806 23.4864 56.9829 23.4868 56.9852C23.4874 56.9869 23.4878 56.9886 23.4881 56.9906C23.4928 57.0083 23.4975 57.0266 23.5025 57.045C23.5048 57.0536 23.5072 57.062 23.5095 57.0703C23.4513 57.2415 23.3931 57.413 23.3352 57.5842C22.6789 57.4377 22.1842 57.125 22.1852 56.2912C22.1852 56.2205 22.1889 56.1461 22.1962 56.0677C22.226 55.7523 22.2585 55.4344 22.2588 55.1224C22.2588 55.09 22.2585 55.058 22.2578 55.0256C22.2548 54.8905 22.1373 54.7734 22.0714 54.6486C22.0644 54.6502 22.0577 54.6519 22.0507 54.6533C22.049 54.6539 22.0473 54.6543 22.0456 54.6546C22.04 54.6556 22.0343 54.6569 22.0286 54.6579C22.0189 54.6596 22.0092 54.6612 21.9995 54.6626C21.962 54.6679 21.9248 54.6703 21.8873 54.6703C21.7799 54.6703 21.6731 54.6513 21.5654 54.6322C21.4593 54.6136 21.3529 54.5948 21.2441 54.5942C21.2424 54.5942 21.2407 54.5942 21.2391 54.5942C21.2377 54.5942 21.2367 54.5942 21.2354 54.5942C21.0834 54.5948 20.9275 54.6319 20.7638 54.755C20.7615 54.7567 20.7591 54.7587 20.7568 54.7604C20.7548 54.762 20.7528 54.7634 20.7511 54.7647C20.7742 55.0843 20.7983 55.42 20.8234 55.7654C20.4619 56.0757 20.0336 56.3286 19.7504 56.718C19.409 57.1871 19.1795 57.7657 18.9315 58.3126C18.9224 58.3322 18.9188 58.3596 18.9188 58.391C18.9188 58.5167 18.981 58.7046 19.0222 58.7063C19.7019 58.737 19.3923 59.5051 19.6099 59.8728C19.6159 59.8834 19.6222 59.8938 19.6286 59.9035C19.6293 59.9045 19.6299 59.9055 19.6303 59.9065C19.7059 60.0226 19.7859 60.081 19.8806 60.0816C19.8813 60.0816 19.8816 60.0816 19.882 60.0816C19.8856 60.0816 19.889 60.0816 19.8927 60.0813C19.9583 60.0783 20.0309 60.0483 20.1139 59.9906C20.1199 59.9866 20.1259 59.9822 20.1323 59.9775C20.135 59.9755 20.1377 59.9739 20.1403 59.9719C20.3344 59.827 20.5443 59.7156 20.7474 59.5895C20.7806 59.9779 20.8137 60.3666 20.8468 60.7553C20.6166 61.2525 20.5302 61.7543 20.5299 62.2588C20.5299 62.488 20.5476 62.7179 20.5777 62.9485C20.3006 62.8554 20.0232 62.7623 19.7457 62.6696C19.8087 62.453 19.8686 62.2371 19.8689 62.0356C19.8692 61.8404 19.8137 61.6585 19.6514 61.5024C19.1564 61.3482 18.6634 61.1867 18.1651 61.0429C18.161 61.0416 18.157 61.0406 18.153 61.0396C18.0961 61.0239 18.0402 61.0166 17.9857 61.0166C17.9853 61.0166 17.985 61.0166 17.9843 61.0166C17.9833 61.0166 17.9827 61.0166 17.9817 61.0166C17.7628 61.0176 17.5626 61.1354 17.3816 61.3222C17.3776 61.3262 17.3732 61.3306 17.3692 61.3349C17.3658 61.3386 17.3622 61.3422 17.3588 61.3459C17.3575 61.3472 17.3565 61.3486 17.3555 61.3496C17.3531 61.3519 17.3511 61.3542 17.3491 61.3566C17.3424 61.3636 17.3361 61.3709 17.3294 61.3783C17.1008 61.6355 16.8511 61.8788 16.66 62.1684C16.5225 62.3766 16.4538 62.5871 16.4545 62.7913C16.4548 62.9895 16.5205 63.1817 16.6513 63.3609C16.6473 63.3642 16.6436 63.3676 16.6399 63.3709C16.6232 63.3853 16.6068 63.3996 16.5911 63.4133C16.5877 63.4163 16.5844 63.4193 16.581 63.422C16.5569 63.443 16.5335 63.4633 16.5111 63.483C16.5097 63.484 16.5084 63.4853 16.5071 63.4863C16.4984 63.494 16.4897 63.5014 16.4813 63.5087C16.479 63.5107 16.4766 63.5127 16.4746 63.5144C16.4686 63.5197 16.4626 63.5247 16.4569 63.5297C16.1794 63.7683 16.0174 63.8904 15.8819 63.8927C15.8805 63.8927 15.8792 63.8927 15.8782 63.8927C15.8769 63.8927 15.8759 63.8927 15.8749 63.8927C15.743 63.8907 15.6356 63.7736 15.4686 63.5387C15.4649 63.5334 15.4612 63.5281 15.4572 63.5224C15.4545 63.5184 15.4515 63.5144 15.4488 63.5104C15.4471 63.508 15.4458 63.5061 15.4441 63.5037C15.4394 63.497 15.4344 63.49 15.4294 63.4827C15.0432 62.9275 14.4183 62.9465 13.9488 62.6068C13.9136 62.5811 13.8741 62.5694 13.8326 62.5691C13.832 62.5691 13.8316 62.5691 13.8313 62.5691C13.826 62.5691 13.8209 62.5691 13.8156 62.5695C13.5612 62.5865 13.2289 63.0092 13.1533 63.3355C13.1509 63.3452 13.1489 63.3549 13.1472 63.3646C13.1278 63.469 13.1188 63.5648 13.1188 63.6539C13.1191 64.3235 13.6268 64.5935 13.9391 65.0195C13.9347 65.0242 13.9304 65.0289 13.926 65.0336C13.9254 65.0342 13.9247 65.0352 13.924 65.0359C13.9197 65.0402 13.9153 65.0446 13.9113 65.0489C13.9026 65.0579 13.8942 65.0669 13.8855 65.0756C13.8825 65.0789 13.8792 65.0819 13.8762 65.0853C13.8748 65.0866 13.8738 65.0876 13.8725 65.089C13.2741 65.7009 12.672 66.0516 12.0073 66.0532C12.006 66.0532 12.0046 66.0532 12.0033 66.0532ZM14.6101 59.725C14.6101 59.789 14.6523 59.8638 14.67 59.9322C14.7805 59.8698 14.9521 59.8347 14.991 59.7403C15.154 59.3439 15.3692 58.9518 15.3688 58.4423C15.3685 58.3366 15.3591 58.2258 15.338 58.1087C14.8303 58.6596 14.755 59.1921 14.6141 59.6922C14.6111 59.7029 14.6098 59.7136 14.6101 59.725ZM13.4103 59.8908C13.4123 59.8908 13.4146 59.8908 13.4166 59.8908C13.5375 59.8898 13.679 59.8571 13.8474 59.7827C13.8477 59.7827 13.8477 59.7823 13.848 59.7823C13.8517 59.7807 13.8554 59.779 13.8594 59.7773C13.8701 59.7727 13.8808 59.7677 13.8919 59.7623C13.8501 59.6512 13.833 59.5368 13.833 59.4193C13.8327 58.9035 14.16 58.3352 14.1596 57.7814C14.1596 57.5128 14.0826 57.2475 13.8537 56.9932C13.3651 57.3259 13.007 57.6879 12.7664 58.1801C12.6663 58.3849 12.6211 58.5878 12.6208 58.7833C12.6208 59.0119 12.6824 59.2301 12.7901 59.4273C12.7938 59.4343 12.7975 59.441 12.8012 59.448C12.8022 59.4497 12.8032 59.4514 12.8042 59.4527C12.9377 59.6909 13.1074 59.8898 13.4079 59.8908C13.4086 59.8908 13.4096 59.8908 13.4103 59.8908ZM25.6488 54.9255C25.6485 54.9258 25.6484 54.9262 25.6484 54.9265L25.6498 54.9259C25.6494 54.9259 25.6491 54.9255 25.6488 54.9255C25.6769 54.8407 25.7053 54.7567 25.7335 54.6719C25.8569 54.3012 25.9774 53.9322 25.9774 53.6132C25.9774 53.2462 25.8178 52.9456 25.3188 52.7851C25.1535 52.732 25.108 52.6136 25.1083 52.4737C25.1086 52.3733 25.1324 52.2619 25.1525 52.1554C25.1826 51.9973 25.1963 51.8468 25.1966 51.7033C25.1973 51.0483 24.9095 50.5388 24.5333 50.0954C24.4051 49.9439 24.1294 49.9256 23.9125 49.9209C23.9115 49.9209 23.9101 49.9209 23.9091 49.9209C23.9081 49.9209 23.9075 49.9209 23.9065 49.9209C23.6769 49.9246 23.376 50.3807 23.3409 50.713C23.3318 50.7974 23.3271 50.8762 23.3271 50.9499C23.3271 51.4657 23.5537 51.7343 24.1257 51.9469C24.2505 51.9936 24.3697 52.055 24.4995 52.1131C24.4911 52.74 23.7578 53.0734 23.7575 53.7427C23.7575 53.8314 23.7706 53.9262 23.7997 54.0283C24.0765 53.9596 24.3717 53.8338 24.6571 53.8271C24.6588 53.8271 24.6605 53.8271 24.6625 53.8271C24.6625 53.8271 24.6621 53.8271 24.6625 53.8271C24.6642 53.8271 24.6658 53.8271 24.6675 53.8271C24.6682 53.8271 24.6688 53.8271 24.6695 53.8271C25.0889 53.8287 24.9466 54.4137 25.1615 54.6496C25.1846 54.6749 25.2117 54.6963 25.2442 54.7126C25.2482 54.7146 25.2522 54.7163 25.2565 54.7183C25.3911 54.7774 25.5183 54.8558 25.6488 54.9255ZM19.5644 52.1217C19.5797 52.1217 19.5958 52.1207 19.6122 52.1187C19.7247 52.1061 19.8595 52.0497 19.9305 51.9673C19.9312 51.9663 19.9318 51.9656 19.9325 51.9649C19.9332 51.9639 19.9338 51.9632 19.9345 51.9622C19.9358 51.9606 19.9372 51.9592 19.9382 51.9576C19.9402 51.9552 19.9419 51.9529 19.9435 51.9506C19.9452 51.9482 19.9469 51.9459 19.9482 51.9439C20.1755 51.6039 20.6842 51.4434 20.6855 50.9476C20.6855 50.8742 20.6745 50.7934 20.65 50.7037C20.3488 50.7621 20.0523 50.8191 19.5991 50.9065C19.6028 50.5278 19.6316 50.2035 19.6313 49.9125C19.631 49.7547 19.6222 49.6069 19.5968 49.4651C19.5188 49.0363 19.2451 48.7334 18.8207 48.726C18.8177 48.726 18.8147 48.7257 18.8117 48.7257C18.8106 48.7257 18.8093 48.7257 18.8083 48.7257C18.6774 48.7267 18.5081 48.7731 18.4127 48.8702C18.412 48.8712 18.4111 48.8718 18.4104 48.8728C18.408 48.8752 18.406 48.8775 18.4037 48.8798C18.3227 48.9703 18.2454 49.1615 18.2447 49.2889C18.2444 49.3136 18.2474 49.3363 18.2537 49.355C18.5422 50.2138 18.8548 51.06 19.1855 51.8938C19.2347 52.0183 19.4097 52.1117 19.5416 52.1211C19.5439 52.1211 19.5463 52.1214 19.5486 52.1214C19.5533 52.1217 19.5583 52.1217 19.5637 52.1217C19.564 52.1217 19.564 52.1217 19.5644 52.1217Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M26.1569 81.343C26.1563 81.343 26.1556 81.343 26.1553 81.343C26.0947 81.343 26.0328 81.335 25.9695 81.3187C25.9688 81.3187 25.9682 81.3183 25.9675 81.3183C25.9635 81.3173 25.9595 81.316 25.9555 81.315C24.9042 81.0237 23.8634 80.7077 22.857 79.9596C22.5732 80.2529 22.279 80.5573 21.9567 80.8906C21.9233 80.7261 21.9079 80.5713 21.9079 80.4248C21.9069 79.1559 23.0404 78.5039 23.2275 77.4728C23.1438 77.3871 23.102 77.3003 23.0468 77.2953C22.8309 77.275 22.6107 77.2806 22.3918 77.2766C22.435 77.0818 22.4932 76.8759 22.4936 76.6871C22.4939 76.5402 22.4591 76.4041 22.3546 76.2917C22.348 76.2847 22.3413 76.278 22.3349 76.2713C22.3346 76.271 22.3346 76.271 22.3342 76.2707C22.1987 76.1332 22.0521 76.0664 21.8941 76.0654C21.8928 76.0654 21.8915 76.0654 21.8901 76.0654C21.8888 76.0654 21.8874 76.0654 21.8861 76.0654C21.7208 76.0664 21.5427 76.1388 21.351 76.2756C21.3493 76.2766 21.3479 76.278 21.3463 76.279C21.3443 76.2803 21.3423 76.2817 21.3406 76.283C21.3382 76.2847 21.3362 76.286 21.3342 76.2877C21.0079 76.5259 20.6317 76.6667 20.271 76.8222C19.945 76.9623 19.8067 77.2209 19.6652 77.5809C19.5588 77.8505 19.2498 78.0354 19.0316 78.258C19.1608 78.4535 19.3047 78.6377 19.4142 78.8485C19.4778 78.9717 19.538 79.1262 19.538 79.2713C19.538 79.2876 19.5373 79.304 19.5357 79.32C19.5209 79.4622 19.4142 79.651 19.3047 79.7328C19.3007 79.7358 19.296 79.7391 19.2917 79.7424C19.2836 79.7478 19.275 79.7535 19.2662 79.7588C19.2659 79.7591 19.2656 79.7594 19.2652 79.7594C19.1812 79.8112 19.0681 79.8519 18.9804 79.8532C18.9788 79.8532 18.9771 79.8535 18.9754 79.8535C18.9751 79.8535 18.9744 79.8535 18.9737 79.8535C18.9389 79.8532 18.9085 79.8465 18.8854 79.8315C18.8841 79.8305 18.8824 79.8295 18.881 79.8285C18.874 79.8235 18.8673 79.8182 18.8606 79.8129C18.8573 79.8102 18.8536 79.8072 18.8502 79.8042C18.8496 79.8035 18.8486 79.8028 18.8479 79.8022C18.4804 79.4892 18.4175 78.693 17.9068 78.6907C17.9061 78.6907 17.9054 78.6907 17.9048 78.6907C17.9048 78.6907 17.9048 78.6907 17.9044 78.6907C17.8847 78.6907 17.8643 78.6921 17.8429 78.6944C17.7846 78.7014 17.7277 78.7044 17.6725 78.7044C17.6695 78.7044 17.6668 78.7044 17.6638 78.7044C17.0939 78.7011 16.6772 78.3567 16.2177 78.1222C16.1434 78.0845 16.0677 78.0494 15.9904 78.019C15.9857 78.0174 15.9814 78.0157 15.9767 78.0137C15.9723 78.0121 15.968 78.0104 15.9636 78.009C15.9586 78.007 15.9536 78.005 15.9482 78.0034C15.9369 77.999 15.9252 77.995 15.9134 77.991C15.9091 77.9894 15.9047 77.988 15.9004 77.9867C15.9004 77.9864 15.9004 77.9864 15.9001 77.9864C15.8967 77.9854 15.893 77.984 15.8897 77.983C15.8843 77.9813 15.8793 77.9797 15.874 77.978C15.8636 77.9747 15.8529 77.9713 15.8425 77.9683C15.8318 77.9653 15.8211 77.9623 15.8104 77.9593C15.8057 77.958 15.801 77.9567 15.7966 77.9557C15.7287 77.9383 15.6628 77.93 15.5985 77.9296C15.5978 77.9296 15.5972 77.9296 15.5968 77.9296C15.5958 77.9296 15.5948 77.9296 15.5942 77.9296C15.3867 77.9303 15.1949 78.0187 15.0138 78.1882C15.0122 78.1899 15.0105 78.1916 15.0085 78.1932C15.0048 78.1969 15.0008 78.2006 14.9968 78.2046C14.9941 78.2073 14.9914 78.2099 14.9887 78.2126C14.9884 78.2126 14.9884 78.2129 14.9881 78.2129C14.9834 78.2176 14.979 78.2223 14.9743 78.2269C14.9713 78.2299 14.9683 78.2329 14.9653 78.2359L14.9646 78.2369C14.9589 78.2343 14.9536 78.2316 14.9479 78.2293C14.9469 78.2286 14.9459 78.2283 14.9446 78.2276C14.7039 78.1168 14.4653 78.0431 14.2287 78.0427C14.2283 78.0427 14.2277 78.0427 14.227 78.0427C14.2257 78.0427 14.2243 78.0427 14.2233 78.0427C13.9131 78.0437 13.6065 78.1716 13.3026 78.5076C13.2969 78.5139 13.2909 78.5206 13.2852 78.5272C13.2812 78.5316 13.2775 78.5359 13.2735 78.5406C13.1681 78.662 12.9917 78.7001 12.8478 78.7765L12.8224 78.7691C13.1309 78.1969 13.2313 77.6097 13.231 76.992C13.231 76.8943 13.2283 76.7958 13.224 76.6964C13.223 76.6787 13.2226 76.6614 13.2226 76.644C13.2213 76.2156 13.4532 75.8309 13.7946 75.5443C14.0503 75.329 14.3077 75.1028 14.5225 74.8369C14.564 74.7858 14.5844 74.6814 14.5844 74.5796C14.5844 74.4952 14.5704 74.4128 14.5429 74.3634C14.5409 74.3601 14.5389 74.3568 14.5369 74.3534C14.5359 74.3521 14.5352 74.3508 14.5342 74.3494C14.4716 74.2567 14.3231 74.1996 14.2016 74.1986C14.2006 74.1986 14.1996 74.1986 14.1986 74.1986C14.1982 74.1986 14.1979 74.1986 14.1979 74.1986C14.1875 74.1986 14.1775 74.1989 14.1674 74.1999C13.7544 74.235 13.4957 74.6614 13.1584 74.8869C12.4074 75.3894 12.3083 75.4301 12.3083 75.7084C12.3083 75.7455 12.31 75.7865 12.3123 75.8335C12.3274 76.1602 12.3481 76.4872 12.3481 76.8155C12.3481 76.925 12.3458 77.0347 12.3401 77.1445C12.3337 77.2756 12.1801 77.4869 12.066 77.5349C12.0643 77.5356 12.0626 77.5363 12.0613 77.5369C12.0405 77.5446 12.0171 77.5486 11.9924 77.5486C11.9917 77.5486 11.9914 77.5486 11.991 77.5486C11.986 77.5486 11.981 77.5486 11.976 77.5483C11.8822 77.5429 11.7725 77.4905 11.7075 77.4235C11.7019 77.4175 11.6965 77.4111 11.6915 77.4051C11.5091 77.1802 11.5067 76.7945 11.1309 76.7375C10.3953 76.6257 9.67404 76.4455 8.94645 76.2933C8.94645 76.2877 8.94645 76.282 8.94645 76.2763C8.94612 75.953 8.86111 75.6784 8.59035 75.57C8.21284 75.4185 7.82126 75.3034 7.43571 75.1726C5.98656 74.7521 4.9755 73.5743 3.82119 72.6437C2.89213 70.9303 2.14245 69.1659 3.17895 66.9C3.2817 66.5313 3.38411 66.1629 3.48686 65.7942L3.48753 65.7923C4.06786 65.6701 4.18131 65.1646 4.2854 64.6184C4.39249 64.0565 4.41659 64.0622 5.05582 64.0502C5.49158 64.1059 5.98857 64.0385 6.35002 64.245C6.98256 64.6071 7.57963 65.0455 8.20314 65.4306C8.73126 65.7569 9.01038 66.5587 9.39559 67.1536C9.52344 67.3508 9.60811 67.601 9.76775 67.7518C9.76876 67.7528 9.77009 67.7542 9.77143 67.7552C9.77311 67.7572 9.77512 67.7589 9.77679 67.7605C9.77913 67.7625 9.78115 67.7642 9.78349 67.7662C9.78416 67.7669 9.78515 67.7679 9.78616 67.7685C9.85376 67.8273 9.92874 67.8646 9.99969 67.8656C10.0007 67.8656 10.002 67.8656 10.0034 67.8656C10.004 67.8656 10.005 67.8656 10.006 67.8656C10.1162 67.8643 10.2156 67.7746 10.2601 67.5427C10.2621 67.532 10.2644 67.5216 10.2664 67.5113C10.2671 67.5079 10.2681 67.5046 10.2688 67.5013C10.2701 67.4956 10.2711 67.4899 10.2725 67.4843C10.3591 67.1149 10.5686 66.8953 10.8732 66.894C10.8739 66.894 10.8749 66.894 10.8755 66.894C10.8759 66.894 10.8759 66.894 10.8759 66.894C10.8792 66.894 10.8822 66.894 10.8852 66.8944H10.8856C10.8889 66.8944 10.8923 66.8944 10.8953 66.8944C11.2731 66.906 11.3049 67.3067 11.3156 67.6474C11.317 67.6788 11.3173 67.7105 11.3173 67.7422C11.3173 68.0495 11.2728 68.3638 11.2514 68.6684C11.2531 68.6688 11.2547 68.6688 11.2561 68.6691C11.2648 68.6698 11.2731 68.6704 11.2812 68.6714C11.3652 68.6798 11.4237 68.6905 11.4773 68.6911C11.4793 68.6911 11.4813 68.6911 11.4833 68.6911C11.4836 68.6911 11.4843 68.6911 11.4846 68.6911C11.497 68.6911 11.5091 68.6904 11.5211 68.6891C11.5948 68.6814 11.6694 68.6494 11.7434 68.6274C11.7614 68.6221 11.7792 68.6167 11.7966 68.6114C11.7993 68.6107 11.8019 68.61 11.8046 68.609C11.8059 68.6087 11.8073 68.6084 11.8086 68.608C12.0707 68.5303 12.247 68.4806 12.3806 68.4783C12.3843 68.4779 12.3876 68.4779 12.391 68.4779C12.392 68.4779 12.393 68.4779 12.394 68.4779C12.644 68.4796 12.7444 68.6551 12.9981 69.1379C13.0011 69.1439 13.0044 69.1502 13.0074 69.1562C13.0108 69.1622 13.0138 69.1679 13.0168 69.1739C13.0192 69.1786 13.0218 69.1836 13.0245 69.1886C13.0268 69.1903 13.0295 69.1919 13.0319 69.1936C13.055 69.2093 13.0784 69.2213 13.1018 69.2303C13.1038 69.231 13.1062 69.232 13.1082 69.2326C13.1085 69.2326 13.1085 69.2326 13.1085 69.2326C13.1125 69.234 13.1165 69.2353 13.1202 69.2367C13.1202 69.2367 13.1202 69.2367 13.1206 69.2367C13.1527 69.2467 13.1852 69.251 13.2176 69.251C13.3197 69.2507 13.4231 69.2086 13.5245 69.1666C13.5379 69.1609 13.5513 69.1553 13.5647 69.1499C13.5667 69.1489 13.5687 69.1482 13.5707 69.1476C13.571 69.1472 13.5717 69.1469 13.572 69.1469C13.6564 69.1126 13.7387 69.0828 13.818 69.0822C13.8187 69.0822 13.8194 69.0822 13.82 69.0822C13.8207 69.0822 13.8217 69.0822 13.8224 69.0822C13.9094 69.0828 13.9924 69.1192 14.0687 69.2243C14.071 69.2273 14.073 69.2303 14.0754 69.2333C14.0777 69.2373 14.0804 69.241 14.0831 69.245C14.0764 69.4242 14.0774 69.597 14.0623 69.7702C14.0583 69.8182 14.0556 69.8653 14.056 69.911C14.056 70.1309 14.1139 70.3144 14.3244 70.3584C14.3461 70.3631 14.3702 70.3654 14.3957 70.3654C14.396 70.3654 14.3964 70.3654 14.3967 70.3654C14.3977 70.3654 14.3987 70.3654 14.3997 70.3654C14.5061 70.3648 14.634 70.3257 14.7136 70.2573C14.7153 70.256 14.7166 70.2547 14.718 70.2534C14.7217 70.25 14.7253 70.2467 14.7287 70.2433C14.7327 70.2393 14.7364 70.2357 14.7401 70.2317C15.0811 69.8496 15.5309 69.5573 15.6715 68.9894C15.6812 68.95 15.6862 68.905 15.6862 68.8583C15.6862 68.7525 15.6618 68.6407 15.6142 68.5807C15.6096 68.575 15.6055 68.5697 15.6012 68.5643C15.6002 68.5627 15.5989 68.5613 15.5978 68.5596C15.5975 68.5593 15.5972 68.559 15.5968 68.5583C15.5948 68.556 15.5932 68.5533 15.5911 68.551C15.5891 68.5483 15.5871 68.5453 15.5851 68.5426C15.5677 68.5196 15.5567 68.5029 15.55 68.4916C15.547 68.4792 15.5416 68.4709 15.5406 68.4709C15.5393 68.4709 15.5413 68.4769 15.55 68.4916C15.5503 68.4936 15.551 68.4959 15.5513 68.4983C15.556 68.5323 15.5389 68.588 15.4004 68.6007C15.2598 68.6137 15.1186 68.6394 14.9777 68.6591C15.3482 67.3541 15.3482 67.3591 16.2565 67.195C16.48 67.1543 16.713 67.1026 16.9208 66.9904C17.0366 66.9281 17.1223 66.7375 17.1966 66.59C17.215 66.554 17.224 66.5026 17.2244 66.4526C17.2244 66.4082 17.2174 66.3648 17.2036 66.3341C17.0771 66.0498 17.0212 65.7839 17.0209 65.5326C17.0202 64.865 17.4141 64.3001 17.9292 63.7649C17.9898 63.6028 18.0514 63.4412 18.115 63.2804C18.3074 63.3288 18.4905 63.4059 18.6695 63.4946C19.2197 63.7672 19.7335 64.149 20.3744 64.15C20.3757 64.15 20.3767 64.15 20.3777 64.15C20.378 64.15 20.3784 64.15 20.3787 64.15C20.459 64.15 20.5414 64.1439 20.6264 64.1309C20.6314 64.1303 20.6364 64.1293 20.6414 64.1286C20.6451 64.1279 20.6488 64.1273 20.6528 64.1266C20.6535 64.898 20.958 65.3898 21.5872 65.5827C21.357 66.264 21.1271 66.9454 20.8971 67.6267C20.8248 67.6517 20.7361 67.6531 20.6833 67.7052C20.3439 68.0398 20.1759 68.2694 20.1746 68.4602C20.1736 68.6341 20.3108 68.7755 20.5832 68.935C21.0735 69.222 21.5765 69.4829 22.0745 69.7552C21.9604 70.0938 21.7978 70.4288 21.7429 70.7725C21.6374 71.4332 20.9135 71.6724 20.8847 72.3721C21.0548 72.5913 21.4299 72.621 21.4289 73.0084C21.4289 73.0778 21.4165 73.1589 21.3888 73.255C21.2439 73.7552 21.1833 74.2813 21.1224 74.7972C21.1224 74.7989 21.122 74.8009 21.122 74.8025C21.122 74.8793 21.3031 74.977 21.4129 75.0287C21.4142 75.0291 21.4155 75.0297 21.4169 75.0301C21.4216 75.0317 21.4269 75.0327 21.4323 75.0327C21.4329 75.0327 21.4333 75.0327 21.434 75.0327C21.4403 75.0327 21.4473 75.0317 21.4547 75.0301C21.4607 75.0287 21.4668 75.0271 21.4728 75.0248C21.4791 75.0224 21.4855 75.0201 21.4922 75.0171C21.4965 75.0147 21.5009 75.0127 21.5056 75.0104C21.5089 75.0084 21.5123 75.0067 21.5159 75.0047C21.5377 74.9924 21.5595 74.977 21.5792 74.9614C21.5795 74.9607 21.5802 74.9604 21.5809 74.96C21.5923 74.9507 21.6026 74.941 21.612 74.9317C21.9547 74.5857 21.9467 74.1462 21.9805 73.7051C21.9879 73.6037 22.1659 73.4966 22.2663 73.3918C22.6371 73.601 23.0073 73.8105 23.3654 74.0134C23.3567 74.2323 23.3496 74.4108 23.3496 74.567C23.35 75.253 23.4872 75.5126 24.2262 76.9103C24.5009 76.7561 24.7754 76.602 25.0498 76.4475C25.3865 76.3157 25.7299 76.2083 26.0579 76.0461C26.0622 76.0441 26.0662 76.0421 26.0706 76.0401C26.0743 76.0381 26.0779 76.0364 26.0816 76.0347C26.084 76.0337 26.0863 76.0324 26.0887 76.0314C26.0974 76.0274 26.1057 76.0234 26.1144 76.0197C26.1164 76.0187 26.1184 76.0181 26.1208 76.0171C26.2865 75.9453 26.4464 75.9163 26.6037 75.916C26.6047 75.916 26.6057 75.916 26.6067 75.916C26.6074 75.916 26.6081 75.916 26.6091 75.916C26.755 75.9163 26.8993 75.941 27.0438 75.9797C27.0455 75.98 27.0472 75.9807 27.0492 75.981C27.0572 75.9834 27.0656 75.9857 27.0739 75.988C27.5147 76.4335 27.926 76.8919 27.927 77.5309C27.9274 77.8085 27.8504 78.1201 27.665 78.4792C27.3762 79.3354 27.0873 80.1919 26.7988 81.0481C26.7915 81.0551 26.7838 81.0618 26.7764 81.0684C26.7754 81.0691 26.7747 81.0697 26.7741 81.0704C26.5803 81.2416 26.3771 81.3424 26.1596 81.343C26.1586 81.343 26.1576 81.343 26.1569 81.343ZM19.6166 72.5943C19.6173 72.5943 19.6183 72.5943 19.619 72.5943C19.704 72.5937 19.7957 72.551 19.8777 72.4822C19.878 72.4819 19.878 72.4815 19.8784 72.4815C19.8807 72.4795 19.8827 72.4775 19.8851 72.4759C19.8877 72.4735 19.8907 72.4709 19.8934 72.4685C19.8968 72.4655 19.9001 72.4625 19.9035 72.4595C20.0752 72.2994 20.2991 72.0328 20.3027 71.8346C20.3034 71.7972 20.3037 71.7595 20.3037 71.7221C20.3034 71.1586 20.2261 70.598 20.1736 69.9374C20.1558 69.935 20.1381 69.933 20.1207 69.931C20.1197 69.9307 20.119 69.9307 20.1183 69.9307C20.1093 69.9297 20.1006 69.9287 20.0919 69.9273C20.0397 69.921 19.9885 69.9147 19.9383 69.908C19.9062 69.904 19.8743 69.8996 19.8432 69.8956C19.8422 69.8953 19.8409 69.8953 19.8399 69.895C19.7924 69.8887 19.7452 69.8823 19.699 69.876C19.1598 69.8012 18.7231 69.7292 18.288 69.7285C18.286 69.7285 18.2836 69.7285 18.2816 69.7285C18.2813 69.7285 18.2813 69.7285 18.281 69.7285C18.2478 69.7285 18.2147 69.7292 18.1816 69.7298C17.9235 69.7365 17.6263 70.0064 17.379 70.214C17.3224 70.2613 17.2876 70.4145 17.288 70.5423C17.288 70.5983 17.295 70.6494 17.3097 70.6844C17.3101 70.6854 17.3104 70.6861 17.3107 70.6868C17.3144 70.6951 17.3191 70.7031 17.3241 70.7108C17.3773 70.7902 17.5062 70.8463 17.6129 70.8499C17.617 70.8499 17.6206 70.8499 17.6243 70.8499C17.6394 70.8499 17.6541 70.8489 17.6678 70.8466C17.8676 70.8136 18.0658 70.6911 18.2649 70.606C18.2656 70.6087 18.2662 70.6114 18.2666 70.614C18.2682 70.6214 18.2699 70.6287 18.2716 70.6364C18.2716 70.6367 18.2716 70.6367 18.2716 70.6371C18.377 71.1586 18.119 71.915 18.8141 71.916C18.8144 71.916 18.8151 71.916 18.8154 71.916C18.8479 71.916 18.8824 71.9143 18.9192 71.911C18.9232 71.9103 18.9272 71.91 18.9312 71.9097C18.9359 71.9093 18.9403 71.9087 18.945 71.9083C18.949 71.9077 18.9533 71.9073 18.957 71.907C18.9687 71.906 18.9801 71.9056 18.9908 71.9056C18.9911 71.9056 18.9915 71.9056 18.9915 71.9056C18.9935 71.9056 18.9952 71.9056 18.9972 71.9056C19.2284 71.909 19.288 72.1299 19.3603 72.3534C19.3613 72.3564 19.3623 72.3594 19.363 72.3621C19.364 72.3648 19.365 72.3678 19.3656 72.3701C19.4172 72.5286 19.5102 72.5933 19.6143 72.5943C19.615 72.5943 19.616 72.5943 19.6166 72.5943Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M40.6324 58.2297C40.6288 58.2267 40.6248 58.2238 40.6211 58.2204C40.6197 58.2194 40.6184 58.2181 40.6171 58.2171C40.6144 58.2147 40.6121 58.2127 40.6094 58.2104C40.607 58.2084 40.6047 58.2061 40.6023 58.2041C40.6 58.2024 40.598 58.2004 40.596 58.1984C40.5883 58.1917 40.5806 58.1844 40.5729 58.1774C40.3708 57.9879 40.1997 57.7183 39.931 57.7169C39.9303 57.7169 39.9296 57.7169 39.9293 57.7169C39.9283 57.7169 39.9276 57.7169 39.9266 57.7169C39.8209 57.7176 39.6997 57.76 39.5558 57.8647C39.5461 57.8721 39.5364 57.8787 39.5267 57.8857C39.2884 58.0512 39.0571 58.113 38.8305 58.114C38.8285 58.114 38.8269 58.114 38.8249 58.114C38.8239 58.114 38.8225 58.114 38.8212 58.114C38.5216 58.1133 38.2298 58.0068 37.941 57.8947C37.9353 57.8924 37.9296 57.8904 37.9239 57.8881C37.9189 57.8861 37.9139 57.8844 37.9088 57.8824C38.0507 57.3135 38.452 57.0532 38.8724 56.7947C38.5454 56.3145 38.1475 55.9091 38.0092 55.2625C37.9711 55.082 37.6752 55.0075 37.4975 54.8844C37.5996 54.7446 37.7228 54.6165 37.7967 54.4617C37.849 54.3539 37.9038 54.1561 37.9042 54.0703C37.9042 54.0496 37.9011 54.0352 37.8938 54.0306C37.8918 54.0292 37.8898 54.0279 37.8878 54.0266C37.8797 54.0212 37.8714 54.0159 37.8633 54.0106C37.701 53.9065 37.5153 53.8104 37.3295 53.8077C37.3272 53.8077 37.3248 53.8077 37.3225 53.8077C37.3208 53.8077 37.3191 53.8077 37.3175 53.8077C37.3161 53.8077 37.3145 53.8077 37.3128 53.808C37.0762 53.8124 36.8968 54.0516 36.8777 54.3252C36.8757 54.3579 36.8744 54.3899 36.8744 54.4213C36.8744 54.4316 36.8747 54.4423 36.875 54.4527C36.8847 54.8521 37.0748 55.151 37.3302 55.3956C37.3295 55.418 37.3295 55.4403 37.3295 55.4627C37.3295 55.5704 37.3336 55.6789 37.3336 55.7867C37.3336 55.9168 37.3275 56.0462 37.3024 56.173C37.2753 56.3102 37.1307 56.475 37.0102 56.5461C37.0072 56.5481 37.0039 56.5497 37.0009 56.5514C36.9979 56.5531 36.9952 56.5548 36.9922 56.5564C36.9912 56.5571 36.9898 56.5578 36.9888 56.5581C36.9245 56.5931 36.866 56.6105 36.8135 56.6111C36.8125 56.6111 36.8114 56.6111 36.8104 56.6111C36.8094 56.6111 36.8084 56.6111 36.8074 56.6111C36.6832 56.6095 36.5912 56.5137 36.5317 56.3319C36.531 56.3295 36.53 56.3269 36.5293 56.3245C36.529 56.3232 36.5286 56.3218 36.5283 56.3208C36.527 56.3168 36.5256 56.3129 36.5246 56.3089C36.4885 56.1904 36.3516 56.1243 36.2475 56.0219C36.0624 56.4253 35.88 56.8224 35.6407 57.3432C35.3285 57.1974 35.3248 56.6849 34.9533 56.6011C34.5464 56.5094 34.2023 56.1774 33.8311 55.9502C33.551 55.8497 33.2709 55.749 32.9907 55.6485C32.9827 55.3973 32.9329 55.2705 32.8405 55.2695C32.8402 55.2695 32.8398 55.2695 32.8395 55.2695C32.8365 55.2695 32.8338 55.2695 32.8308 55.2698C32.7639 55.2751 32.6765 55.3429 32.5681 55.4727C32.5657 55.4753 32.5634 55.4783 32.561 55.481C32.5587 55.484 32.5563 55.4867 32.554 55.4894C32.5523 55.4917 32.5503 55.494 32.5486 55.4964C32.5476 55.4977 32.5466 55.4987 32.5456 55.5C32.4054 55.4607 32.2658 55.4186 32.127 55.3743L32.1263 55.3739C32.1303 55.3359 32.1323 55.2985 32.1323 55.2628C32.133 55.0286 32.0473 54.8474 31.8776 54.7179C31.9362 54.5191 31.974 54.3312 31.974 54.161C31.9743 53.8678 31.8629 53.6262 31.554 53.4684C31.0633 53.2178 30.8615 52.7276 30.8535 52.0967C31.1423 52.1681 31.4258 52.2839 31.7227 52.2962C31.7253 52.2962 31.7277 52.2965 31.7304 52.2965C31.7441 52.2969 31.7581 52.2972 31.7725 52.2972C31.7725 52.2972 31.7729 52.2972 31.7732 52.2972C31.7765 52.2972 31.7799 52.2972 31.7832 52.2972C31.9793 52.2958 32.2377 52.2488 32.3505 52.12C32.3515 52.119 32.3522 52.118 32.3532 52.117C32.3542 52.1157 32.3552 52.1147 32.3562 52.1133C32.3569 52.1123 32.3579 52.1113 32.3586 52.1107C32.3626 52.1053 32.3666 52.1 32.3699 52.0947C33.223 50.8257 34.5798 50.3466 35.4871 49.1811C35.5069 49.1561 35.5099 49.1144 35.5099 49.0576C35.5099 49.0326 35.5092 49.0049 35.5092 48.9742C35.5092 48.9435 35.5099 48.9105 35.5122 48.8748C35.0273 48.7944 34.5336 48.6996 34.0336 48.6386C34.0316 48.6382 34.0293 48.6379 34.0269 48.6379C34.0179 48.6369 34.0089 48.6365 33.9995 48.6365C33.9995 48.6365 33.9991 48.6365 33.9988 48.6365C33.9978 48.6365 33.9968 48.6365 33.9958 48.6365C33.9188 48.6372 33.8372 48.6656 33.7545 48.6939C33.7006 48.7123 33.6464 48.731 33.5935 48.7423C33.5888 48.7433 33.5845 48.744 33.5801 48.745C33.5785 48.7453 33.5764 48.746 33.5748 48.7463C33.5667 48.748 33.5587 48.7497 33.551 48.7513C33.5202 48.7577 33.4908 48.7637 33.4627 48.7697C33.4566 48.7707 33.4509 48.772 33.4452 48.773C33.3231 48.798 33.2254 48.8157 33.1457 48.8217C33.1249 48.8234 33.1055 48.8244 33.0871 48.8244C33.0861 48.8244 33.0851 48.8244 33.0841 48.8244C32.8401 48.8231 32.7936 48.6703 32.6775 48.1914C32.6772 48.1901 32.6772 48.1891 32.6768 48.1881C32.6755 48.1828 32.6741 48.1771 32.6728 48.1718C32.6728 48.1714 32.6728 48.1711 32.6725 48.1704C32.6691 48.1567 32.6658 48.1427 32.6624 48.1284L32.6788 48.114C32.8847 47.9912 33.0925 47.8741 33.295 47.7443C33.2993 47.7413 33.3037 47.7386 33.308 47.736C33.3137 47.7323 33.3198 47.7283 33.3258 47.7246C33.7441 47.4584 34.1558 47.2281 34.5621 47.2268C34.5634 47.2268 34.5644 47.2268 34.5654 47.2268C34.5664 47.2268 34.5678 47.2268 34.5688 47.2268C34.8382 47.2278 35.1053 47.3296 35.3703 47.5889C35.3713 47.5895 35.372 47.5902 35.373 47.5908C35.3733 47.5915 35.374 47.5918 35.3747 47.5925C35.3904 47.6055 35.4138 47.6112 35.4423 47.6115C35.4429 47.6115 35.4433 47.6115 35.444 47.6115C35.4925 47.6115 35.5557 47.5952 35.6233 47.5688C35.625 47.5682 35.6267 47.5675 35.628 47.5668C35.6367 47.5632 35.6454 47.5598 35.6541 47.5558C35.6561 47.5552 35.6578 47.5545 35.6595 47.5538C35.6699 47.5491 35.6802 47.5445 35.6906 47.5395C35.6909 47.5395 35.6909 47.5395 35.6913 47.5391C35.7164 47.5275 35.7418 47.5141 35.7669 47.5004C35.7823 47.4918 35.7974 47.4831 35.8121 47.4741C35.8158 47.4717 35.8194 47.4694 35.8231 47.4671C35.8248 47.4661 35.8265 47.4651 35.8285 47.4641C35.8442 47.4541 35.8599 47.4437 35.8747 47.4334C35.8777 47.4314 35.8804 47.4293 35.8834 47.427C35.8857 47.4253 35.8881 47.4237 35.8907 47.4217C35.8917 47.421 35.8924 47.4203 35.8934 47.4197C35.8971 47.4173 35.9004 47.4147 35.9038 47.4123C35.9088 47.4083 35.9138 47.4043 35.9189 47.4003C35.9235 47.3967 35.9282 47.3933 35.9326 47.3896C35.9363 47.3866 35.9396 47.3836 35.9433 47.3806C35.9443 47.3796 35.9453 47.379 35.9463 47.378C35.9513 47.3736 35.956 47.3693 35.9607 47.3653C36.0571 47.2769 36.0919 47.1808 36.0919 47.0844C36.0919 46.9412 36.0152 46.7971 35.9483 46.6763C35.9429 46.6666 35.9376 46.6569 35.9323 46.6476C35.9286 46.6419 35.9252 46.6359 35.9219 46.6302C35.9192 46.6259 35.9169 46.6219 35.9142 46.6175C35.6658 46.2108 35.2923 46.028 34.8817 46.025C34.8783 46.025 34.875 46.025 34.8713 46.025C34.871 46.025 34.8706 46.025 34.87 46.025C34.7846 46.0253 34.6976 46.033 34.6099 46.0483C34.0329 46.1481 33.4606 46.4207 32.8709 46.6232C32.723 45.9846 32.2997 45.6079 31.6695 45.5091L31.6584 45.4877C31.8425 45.3116 32.0225 45.1271 32.213 44.9612C32.5021 44.7097 32.7889 44.5702 33.0795 44.5688C33.0805 44.5688 33.0818 44.5688 33.0828 44.5688C33.0841 44.5688 33.0858 44.5688 33.0875 44.5688C33.2776 44.5698 33.4693 44.6302 33.6641 44.7577C33.6661 44.759 33.6682 44.7607 33.6705 44.762C33.6718 44.763 33.6735 44.764 33.6752 44.765C33.8512 44.8825 34.0902 44.8895 34.3027 44.9395C34.3057 44.9402 34.3084 44.9409 34.3114 44.9415C34.3512 44.9502 34.3874 44.9546 34.4202 44.9546C34.4205 44.9546 34.4208 44.9546 34.4212 44.9546C34.4218 44.9546 34.4225 44.9546 34.4232 44.9546C34.7478 44.9529 34.7712 44.5565 34.9024 44.3013C39.2887 45.7684 43.6747 47.2382 48.063 48.7C48.6273 48.8878 49.1969 49.0693 49.7819 49.1774C49.7939 49.1794 49.8063 49.1808 49.819 49.1808C49.8194 49.1808 49.8194 49.1808 49.8197 49.1808C49.8361 49.1808 49.8528 49.1788 49.8699 49.1758C49.9593 49.1587 50.058 49.101 50.1581 49.0376C50.1627 49.0346 50.1674 49.0316 50.1721 49.0286C50.1795 49.0239 50.1865 49.0196 50.1939 49.0149C50.2518 48.9779 50.3097 48.9402 50.3659 48.9088C50.3662 48.9085 50.3669 48.9082 50.3672 48.9082C50.3826 48.8995 50.398 48.8911 50.4134 48.8838C50.552 48.9208 50.6905 48.9579 50.8294 48.9949C50.9302 49.2482 51.0349 49.4991 51.13 49.756C51.2022 49.9512 51.2622 50.1541 51.3274 50.3536C51.3204 50.3519 51.3134 50.3506 51.3067 50.3489C51.2946 50.3463 51.2823 50.3433 51.2702 50.3403C51.2635 50.3383 51.2565 50.3366 51.2498 50.3346C51.2481 50.3343 51.2464 50.3336 51.2447 50.3333C51.222 50.3269 51.1993 50.3202 51.1768 50.3132C51.1742 50.3125 51.1718 50.3119 51.1694 50.3112C51.1671 50.3102 51.1648 50.3095 51.1624 50.3089C50.9395 50.2381 50.718 50.1364 50.4914 50.1347C50.489 50.1347 50.4867 50.1347 50.4847 50.1347C50.483 50.1347 50.4817 50.1347 50.48 50.1347C50.2889 50.1357 50.0941 50.2091 49.8913 50.4323C49.8873 50.4367 49.883 50.4414 49.8789 50.446C49.8702 50.443 49.8612 50.44 49.8525 50.437C49.7203 50.3916 49.5881 50.3483 49.4546 50.3059V50.3062V50.3059C49.1691 50.2368 48.8903 50.0726 48.6001 50.0726C48.5442 50.0726 48.4884 50.0787 48.4315 50.0927C48.3006 50.1247 48.1671 50.1988 48.0285 50.3372C48.0262 50.3396 48.0238 50.3419 48.0215 50.3446C48.0148 50.3509 48.0084 50.3579 48.0017 50.3646C47.5804 50.2261 47.1587 50.0877 46.737 49.9489C46.6302 49.7443 46.5429 49.365 46.4137 49.363C45.5669 49.3496 44.8956 48.8882 44.1703 48.5578C44.1673 48.5565 44.1643 48.5552 44.1613 48.5538C44.1596 48.5531 44.1583 48.5525 44.157 48.5518C44.156 48.5515 44.1553 48.5512 44.1543 48.5508C44.081 48.5198 44.0077 48.5051 43.9344 48.5051C43.9341 48.5051 43.9334 48.5051 43.9327 48.5051C43.9317 48.5051 43.931 48.5051 43.9304 48.5051C43.7255 48.5058 43.5244 48.6195 43.3407 48.7994C43.3376 48.802 43.3346 48.8051 43.332 48.8081C43.329 48.8107 43.326 48.8137 43.3229 48.8167L43.3209 48.8197C43.0016 48.5692 42.6874 48.3106 42.3617 48.07C42.3597 48.0687 42.358 48.0673 42.356 48.066C42.2714 48.0049 42.1884 47.9776 42.1067 47.9772C42.106 47.9772 42.1054 47.9772 42.1047 47.9772C42.1034 47.9772 42.102 47.9772 42.101 47.9772C41.9434 47.9789 41.7921 48.0807 41.6479 48.2315C41.6438 48.2358 41.6398 48.2398 41.6358 48.2442C41.6325 48.2478 41.6291 48.2515 41.6258 48.2552C41.6245 48.2565 41.6231 48.2579 41.6218 48.2592C41.6117 48.2592 41.602 48.2589 41.592 48.2589C41.5823 48.2585 41.5729 48.2585 41.5632 48.2585C41.5625 48.2585 41.5622 48.2585 41.5615 48.2585C41.5589 48.2585 41.5562 48.2585 41.5532 48.2585C41.4692 48.2588 41.3835 48.2635 41.2978 48.2682C41.2948 48.2685 41.2914 48.2689 41.2884 48.2689C41.2851 48.2692 41.2817 48.2692 41.278 48.2695C41.1907 48.2745 41.1034 48.2792 41.0177 48.2792C41.017 48.2792 41.016 48.2792 41.015 48.2792C41.0137 48.2792 41.0127 48.2792 41.0113 48.2792C40.8728 48.2792 40.7392 48.2662 40.6191 48.2218C40.6164 48.2208 40.6137 48.2198 40.6107 48.2185C40.6087 48.2178 40.6064 48.2168 40.604 48.2158C40.5943 48.2121 40.5846 48.2078 40.5749 48.2035C40.5578 48.1961 40.5411 48.1885 40.5244 48.1811C40.5217 48.1801 40.5193 48.1791 40.517 48.1781C40.516 48.1778 40.5153 48.1774 40.5143 48.1771C40.2546 48.0653 40.0003 47.9936 39.7308 47.9932C39.7295 47.9932 39.7285 47.9932 39.7275 47.9932C39.7265 47.9932 39.7258 47.9932 39.7252 47.9932C39.605 47.9932 39.4822 48.0076 39.3543 48.0386C39.354 48.0343 39.3537 48.03 39.353 48.0256C39.3523 48.0186 39.3516 48.0119 39.351 48.0053C39.3279 47.7907 39.267 47.6876 39.1712 47.6853C39.1702 47.6853 39.1692 47.6853 39.1682 47.6853C39.1652 47.6853 39.1622 47.6853 39.1589 47.6856C39.0913 47.6899 39.0076 47.7417 38.9089 47.8374C38.8968 47.8494 38.8844 47.8618 38.8717 47.8748C38.6666 47.8211 38.4648 47.7473 38.2539 47.7203C38.2496 47.7196 38.2449 47.7193 38.2402 47.7186C38.2238 47.7173 38.2057 47.7166 38.1866 47.7163C38.1863 47.7163 38.186 47.7163 38.1856 47.7163C38.1803 47.7163 38.1749 47.7167 38.1692 47.7167C38.0334 47.7193 37.8593 47.7537 37.856 47.778C37.8369 47.9078 37.8094 48.065 37.8098 48.1988C37.8101 48.2902 37.8232 48.3703 37.861 48.4233C38.0263 48.6559 38.2914 48.7887 38.5146 48.9635C38.4745 49.1274 38.4309 49.2902 38.3834 49.4527C38.1505 50.14 37.9179 50.8271 37.685 51.5144C37.6846 51.5147 37.6843 51.5151 37.684 51.5154C37.3757 51.3356 37.5584 50.6689 37.0835 50.6495C36.8285 51.4083 36.5765 52.157 36.1274 53.4914C36.8858 52.5494 37.2599 52.0002 37.684 51.5154C37.684 51.5154 37.6843 51.5154 37.6843 51.5157C37.6846 51.5151 37.6846 51.5147 37.685 51.5144C37.8319 51.5618 37.9781 51.6012 38.122 51.6015C38.1227 51.6015 38.1237 51.6015 38.1244 51.6015C38.1261 51.6015 38.1274 51.6015 38.1291 51.6015C38.3212 51.6005 38.5086 51.5291 38.6866 51.3142C38.6873 51.3135 38.688 51.3129 38.6886 51.3122C38.6913 51.3089 38.6943 51.3052 38.697 51.3015C38.701 51.2969 38.7047 51.2922 38.7087 51.2872C38.8503 51.3329 38.9905 51.3816 39.1298 51.4333C39.1345 51.6836 39.181 51.8091 39.2683 51.8111C39.269 51.8111 39.2696 51.8111 39.2703 51.8111C39.273 51.8111 39.276 51.811 39.2787 51.8107C39.3446 51.805 39.4326 51.734 39.5421 51.5978C39.5441 51.5952 39.5461 51.5928 39.5481 51.5902C39.5484 51.5898 39.5488 51.5895 39.5488 51.5892C39.5504 51.5875 39.5518 51.5858 39.5531 51.5838C39.5551 51.5811 39.5575 51.5781 39.5598 51.5755L39.5628 51.5735C39.5645 51.5735 39.5662 51.5735 39.5682 51.5735C39.5692 51.5735 39.5699 51.5735 39.5709 51.5735C39.7948 51.5728 39.9782 51.4674 40.1214 51.2592C40.1221 51.2582 40.1227 51.2572 40.1234 51.2565C40.1254 51.2532 40.1278 51.2502 40.1298 51.2468C40.1338 51.2408 40.1378 51.2348 40.1415 51.2288C40.1442 51.2248 40.1465 51.2211 40.1488 51.2171C40.1522 51.2121 40.1552 51.2071 40.1582 51.2021L40.1602 51.2014C40.525 51.458 40.6723 51.5631 40.6733 51.6906C40.6736 51.7747 40.61 51.8684 40.5029 52.0222C40.4072 52.1594 40.2984 52.2845 40.2004 52.42C39.9142 52.8154 39.7743 53.0086 39.7743 53.2178C39.774 53.4176 39.9012 53.6322 40.1488 54.0513C40.4303 54.146 40.7121 54.2408 40.9939 54.3355C41.1375 54.3832 41.2807 54.4306 41.424 54.478C41.4588 54.5398 41.5331 54.6178 41.5338 54.6652C41.5338 54.6702 41.5331 54.6749 41.5314 54.6789C41.4106 54.9869 41.1971 55.2805 41.1495 55.5888C41.1191 55.7883 41.103 55.9952 41.103 56.2001C41.103 56.4246 41.1221 56.6468 41.1633 56.8541C41.1803 56.9405 41.188 57.0216 41.1877 57.0983C41.1867 57.5684 40.8912 57.8807 40.6324 58.2297Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M26.8412 85.1174C25.2659 84.7411 23.6845 84.397 22.2394 83.6126C21.6587 83.2973 21.0011 83.1438 20.3762 82.9222C19.0546 82.4538 17.7751 81.9112 16.5984 81.0904C15.6847 80.4538 14.6589 80.0137 13.6854 79.4805C13.3674 79.3063 12.9939 79.2106 12.8477 78.7761C12.9916 78.6997 13.168 78.6617 13.2734 78.5402C13.2774 78.5355 13.2811 78.5312 13.2851 78.5269C13.2908 78.5202 13.2968 78.5135 13.3025 78.5072C13.6064 78.1712 13.9129 78.0434 14.2232 78.0424C14.2242 78.0424 14.2255 78.0424 14.2269 78.0424C14.2275 78.0424 14.2282 78.0424 14.2285 78.0424C14.4652 78.0427 14.7038 78.1165 14.9444 78.2272C14.9458 78.2279 14.9468 78.2283 14.9478 78.2289C14.9534 78.2313 14.9588 78.2339 14.9645 78.2366C14.9119 78.4301 14.847 78.6306 14.8474 78.8182C14.8474 78.9346 14.8728 79.0464 14.9421 79.1482C14.9434 79.1498 14.9444 79.1515 14.9458 79.1532C14.9464 79.1538 14.9471 79.1548 14.9478 79.1555C14.9478 79.1558 14.9481 79.1558 14.9481 79.1558C14.9886 79.2035 15.0733 79.2096 15.161 79.2096C15.175 79.2096 15.1897 79.2092 15.2038 79.2092C15.2142 79.2092 15.2245 79.2089 15.2346 79.2089C15.2379 79.2089 15.2413 79.2089 15.2446 79.2089C15.247 79.2089 15.2493 79.2089 15.252 79.2089C15.2543 79.2089 15.2567 79.2089 15.259 79.2089C15.266 79.2089 15.2734 79.2092 15.2804 79.2092C15.2848 79.2096 15.2891 79.2096 15.2935 79.2099C15.2958 79.2099 15.2982 79.2102 15.3005 79.2102C15.3065 79.2102 15.3447 79.1125 15.3514 79.0471C15.3521 79.0411 15.3524 79.0351 15.3524 79.0297C15.3524 79.0201 15.3514 79.0114 15.349 79.0047C15.3487 79.004 15.3484 79.003 15.348 79.0024C15.2302 78.7401 15.0943 78.4902 14.9652 78.2356C14.9682 78.2326 14.9712 78.2296 14.9742 78.2266C14.9789 78.2219 14.9832 78.2172 14.9879 78.2126C14.9883 78.2126 14.9883 78.2122 14.9886 78.2122C14.9913 78.2096 14.994 78.2069 14.9966 78.2042C15.0007 78.2002 15.0047 78.1966 15.0083 78.1929C15.0103 78.1912 15.012 78.1895 15.0137 78.1879C15.1948 78.0184 15.3865 77.9303 15.594 77.9293C15.5947 77.9293 15.5957 77.9293 15.5967 77.9293C15.597 77.9293 15.5977 77.9293 15.5984 77.9293C15.6626 77.9296 15.7286 77.938 15.7965 77.9553C15.8009 77.9563 15.8055 77.9576 15.8102 77.959C15.8209 77.962 15.8316 77.965 15.8424 77.968C15.8527 77.971 15.8635 77.9743 15.8738 77.9777C15.8792 77.9793 15.8842 77.981 15.8895 77.9827C15.8929 77.9837 15.8966 77.985 15.8999 77.986C15.9003 77.986 15.9003 77.986 15.9003 77.9863C15.9046 77.9877 15.909 77.989 15.9133 77.9907C15.925 77.9947 15.9367 77.9987 15.9481 78.003C15.9535 78.0047 15.9585 78.0067 15.9635 78.0087C15.9679 78.01 15.9722 78.0117 15.9766 78.0134C15.9813 78.0154 15.9856 78.017 15.9903 78.0187C16.0676 78.0491 16.1432 78.0841 16.2175 78.1218C16.6771 78.3564 17.0937 78.7007 17.6637 78.704C17.6667 78.704 17.6694 78.704 17.6724 78.704C17.7279 78.704 17.7845 78.701 17.8427 78.694C17.8641 78.6917 17.8846 78.6904 17.9043 78.6904C17.9046 78.6904 17.9046 78.6904 17.9046 78.6904C17.9053 78.6904 17.906 78.6904 17.9067 78.6904C18.4174 78.6927 18.4803 79.4888 18.8478 79.8018C18.8484 79.8025 18.8494 79.8031 18.8501 79.8038C18.8535 79.8068 18.8571 79.8098 18.8605 79.8125C18.8672 79.8178 18.8739 79.8232 18.8809 79.8282C18.8822 79.8292 18.8839 79.8302 18.8853 79.8312C18.9083 79.8462 18.9388 79.8529 18.9736 79.8532C18.9743 79.8532 18.9749 79.8532 18.9753 79.8532C18.977 79.8532 18.9786 79.8529 18.9803 79.8529C19.068 79.8515 19.1811 79.8108 19.2651 79.7591C19.2654 79.7591 19.2658 79.7588 19.2661 79.7584C19.2748 79.7531 19.2835 79.7474 19.2915 79.7421C19.2959 79.7388 19.3006 79.7354 19.3046 79.7324C19.414 79.6507 19.5208 79.4618 19.5355 79.3197C19.5372 79.3036 19.5379 79.2873 19.5379 79.2709C19.5379 79.1258 19.4776 78.9713 19.414 78.8482C19.3046 78.6373 19.1607 78.4531 19.0315 78.2576C19.2497 78.0351 19.5586 77.8502 19.665 77.5806C19.8066 77.2206 19.9448 76.962 20.2708 76.8218C20.6316 76.6663 21.0078 76.5256 21.3341 76.2873C21.3361 76.2857 21.3381 76.2843 21.3404 76.2827C21.3421 76.2813 21.3441 76.28 21.3461 76.2787C21.3478 76.2777 21.3492 76.2763 21.3508 76.2753C21.5426 76.1385 21.7206 76.0661 21.886 76.0651C21.8873 76.0651 21.8886 76.0651 21.89 76.0651C21.8913 76.0651 21.8927 76.0651 21.894 76.0651C22.052 76.0661 22.1986 76.1328 22.3341 76.2703C22.3344 76.2706 22.3344 76.2706 22.3348 76.271C22.3411 76.2776 22.3478 76.2843 22.3545 76.2913C22.4589 76.4038 22.4938 76.5399 22.4934 76.6867C22.4931 76.8756 22.4349 77.0814 22.3917 77.2763C22.1654 77.332 21.9379 77.3751 21.714 77.4462C21.0389 77.66 21.0593 77.6617 21.0493 78.6256C21.0456 78.994 20.8943 79.3931 20.8937 79.7501C20.8937 79.7975 20.8963 79.8439 20.9024 79.8896C20.9067 79.9229 20.9087 79.9539 20.9087 79.9833C20.9094 80.5382 20.1748 80.4545 20.1774 81.035C20.1778 81.0787 20.1821 81.1258 20.1912 81.1772C20.7002 81.3477 21.3458 81.4011 21.7993 81.7584C21.8033 81.7618 21.8077 81.7651 21.812 81.7684C21.8274 81.7804 21.8428 81.7928 21.8579 81.8051C21.8595 81.8065 21.8612 81.8078 21.8629 81.8091C21.8669 81.8125 21.8709 81.8155 21.8749 81.8188C22.1641 82.0524 22.4185 82.2773 22.718 82.279C22.719 82.279 22.7203 82.279 22.7217 82.279C22.7223 82.279 22.723 82.279 22.724 82.279C22.9014 82.2786 23.0945 82.1992 23.3204 81.9973H23.3207C23.3298 81.989 23.3391 81.9806 23.3485 81.972C23.9991 82.0704 24.6688 82.1061 25.2947 82.286C25.8716 82.4515 26.7428 82.0908 26.8733 83.1812C27.4995 83.3096 28.1692 83.2709 28.7452 83.6009C28.7506 83.6039 28.7569 83.6053 28.7643 83.6056C28.7643 83.6056 28.7646 83.6056 28.7649 83.6056C28.7733 83.6056 28.7827 83.6036 28.7927 83.6003C28.7937 83.6003 28.7947 83.5999 28.7957 83.5996C28.8001 83.5979 28.8044 83.5963 28.8091 83.5943C28.8101 83.5939 28.8108 83.5936 28.8118 83.5932C28.8218 83.5886 28.8325 83.5833 28.8432 83.5772C28.8439 83.5769 28.8442 83.5766 28.8449 83.5762C28.8526 83.5719 28.8607 83.5669 28.869 83.5619C28.8838 83.5525 28.8988 83.5425 28.9132 83.5329C28.9282 83.5229 28.9427 83.5128 28.9557 83.5042C29.4206 83.1972 29.5899 82.6914 29.6863 82.1525C29.6984 82.0848 29.7041 82.0224 29.7041 81.965C29.7037 81.5492 29.4038 81.3954 29.1053 81.2482C29.3315 80.5652 29.5585 79.8822 29.7854 79.1992C29.7613 78.8061 29.7369 78.4134 29.7128 78.0207C30.4236 78.2566 31.1341 78.4925 31.8447 78.7284C31.9755 79.1265 32.0324 79.2993 32.1683 79.2993C32.257 79.2993 32.3788 79.2259 32.5769 79.0931C32.5809 79.0904 32.5849 79.0878 32.589 79.0851C32.5946 79.0811 32.6 79.0774 32.6057 79.0737C32.6187 79.0651 32.6318 79.0561 32.6452 79.0471C32.6603 79.0367 32.6757 79.0264 32.6914 79.0157C32.8346 79.0607 32.9782 79.1054 33.1214 79.1502C33.2607 79.2012 33.4006 79.2489 33.5421 79.294C33.6633 79.4798 33.7419 79.6797 33.7416 79.9056C33.7416 80.012 33.7239 80.1241 33.6847 80.2436C33.4926 80.8325 33.2995 81.4211 33.1067 82.01C33.0478 82.1835 32.9889 82.3563 32.93 82.5299V82.5295C32.5337 82.7768 32.1368 83.024 31.7402 83.2712C31.6536 83.0527 31.5669 82.8345 31.4802 82.6159C31.4638 82.5335 31.4578 82.4451 31.4296 82.3697C31.4273 82.3637 31.425 82.3574 31.4226 82.3514C31.4209 82.3467 31.4189 82.342 31.4169 82.3373C31.4159 82.3343 31.4146 82.3316 31.4136 82.3286C31.4132 82.328 31.4129 82.3273 31.4126 82.3263C31.4109 82.3223 31.4092 82.3183 31.4072 82.3143C31.4072 82.314 31.4072 82.3136 31.4069 82.3133C31.4049 82.3086 31.4029 82.3043 31.4009 82.2996C31.284 82.0431 31.093 81.9189 30.8353 81.9169C30.8329 81.9169 30.8309 81.9169 30.8286 81.9169C30.8282 81.9169 30.8282 81.9169 30.8279 81.9169C30.8034 81.9169 30.7787 81.9179 30.7533 81.9203C30.7526 81.9203 30.7519 81.9203 30.7513 81.9203C30.7479 81.9206 30.7449 81.9209 30.7416 81.9212C30.3821 81.9563 30.2359 82.2693 30.0809 82.5946C29.9373 82.8956 29.9012 83.1908 29.9015 83.4848C29.9015 83.7858 29.9396 84.0847 29.9393 84.386C29.9393 84.3884 29.9393 84.3907 29.9393 84.393C29.9152 84.4137 29.8911 84.4338 29.8667 84.4531C29.8667 84.4531 29.8664 84.4534 29.866 84.4538C29.445 84.7888 29.0099 84.9035 28.5712 84.9042C28.5702 84.9042 28.5688 84.9042 28.5675 84.9042C28.5672 84.9042 28.5665 84.9042 28.5658 84.9042C28.3325 84.9039 28.0983 84.8719 27.8643 84.8231C27.8603 84.8221 27.8563 84.8215 27.8523 84.8205C27.8453 84.8191 27.8386 84.8178 27.8315 84.8165C27.8255 84.8151 27.8192 84.8138 27.8131 84.8128C27.8078 84.8118 27.8028 84.8108 27.7977 84.8098C27.7077 84.7931 27.6203 84.7831 27.5347 84.7828C27.5337 84.7828 27.533 84.7828 27.532 84.7828C27.5313 84.7828 27.5303 84.7828 27.5293 84.7828C27.2987 84.7834 27.0829 84.8572 26.8794 85.0747C26.8777 85.0767 26.8757 85.0787 26.874 85.0807C26.863 85.0927 26.8519 85.1048 26.8412 85.1174ZM30.5601 80.1228C30.5601 80.1458 30.6405 80.1865 30.7265 80.2533C30.8276 80.0297 30.9701 79.8215 31.0076 79.6026C31.0079 79.6016 31.008 79.6003 31.0083 79.5989C31.0086 79.5963 31.0093 79.5936 31.0096 79.5909C31.0304 79.4501 30.9755 79.3654 30.9042 79.3621C30.9029 79.3621 30.9015 79.3621 30.8998 79.3621C30.8992 79.3621 30.8985 79.3621 30.8979 79.3621C30.855 79.3631 30.8068 79.3931 30.7663 79.4575C30.6505 79.6426 30.6171 79.8952 30.5605 80.1208C30.5605 80.1215 30.5605 80.1221 30.5601 80.1228Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M46.085 87.8591C45.8651 87.8591 45.6459 87.8548 45.428 87.8408C43.932 87.7443 42.4393 87.6239 40.9493 87.4904C40.7321 87.4711 40.5357 87.3273 40.3298 87.2408C40.3834 87.0844 40.4366 86.9279 40.4898 86.7714C40.4942 86.7737 40.4985 86.7764 40.5032 86.7791C40.5059 86.7807 40.5085 86.7821 40.5112 86.7837C40.5179 86.7874 40.5246 86.7911 40.531 86.7947C40.5313 86.7947 40.5313 86.7951 40.5317 86.7951C40.7713 86.9262 41.0246 86.9646 41.284 86.9649C41.2854 86.9649 41.2864 86.9649 41.2874 86.9649C41.2884 86.9649 41.2894 86.9649 41.2904 86.9649C41.4487 86.9646 41.6093 86.9506 41.7703 86.9345C41.783 86.9332 41.7961 86.9319 41.8088 86.9305C41.8141 86.9299 41.8195 86.9295 41.8248 86.9289C41.8292 86.9285 41.8332 86.9282 41.8372 86.9279C41.8978 86.9215 41.958 86.9155 42.0186 86.9102C42.1394 86.8992 42.2596 86.8908 42.3788 86.8905C42.3814 86.8905 42.3844 86.8905 42.3871 86.8905C42.3881 86.8905 42.3888 86.8905 42.3894 86.8905C42.5163 86.8905 42.6418 86.8998 42.765 86.9245H42.7653C42.7733 86.9262 42.7814 86.9279 42.7894 86.9299C42.7904 86.9299 42.7911 86.9302 42.7921 86.9302C42.7958 86.9312 42.7994 86.9319 42.8031 86.9329C42.8088 86.9332 42.8142 86.9339 42.8195 86.9342C42.8205 86.9342 42.8212 86.9342 42.8222 86.9345C42.8266 86.9349 42.8309 86.9352 42.8352 86.9355C42.8389 86.9359 42.8426 86.9362 42.8463 86.9366C42.8513 86.9369 42.8563 86.9372 42.861 86.9375C42.8647 86.9379 42.8684 86.9382 42.872 86.9386C42.8724 86.9386 42.8724 86.9386 42.8724 86.9386C42.8791 86.9392 42.8861 86.9399 42.8928 86.9402C42.9022 86.9412 42.9119 86.9419 42.9213 86.9425C43.0541 86.9536 43.1629 86.9609 43.2542 86.9609C43.2549 86.9609 43.2553 86.9609 43.2559 86.9609C43.2566 86.9609 43.2569 86.9609 43.2576 86.9609C43.6495 86.9606 43.7165 86.8218 43.9842 86.2158C43.9869 86.2092 43.9899 86.2025 43.9929 86.1955C44.0618 86.0397 44.1114 85.8738 44.1696 85.7127C44.6532 85.6523 45.1177 85.4184 45.3356 84.9025C45.6813 84.0817 45.9755 83.2489 46.5451 82.5622C46.5836 82.5161 46.593 82.4364 46.593 82.3473C46.593 82.2639 46.5853 82.1718 46.5853 82.0911C46.5853 82.0797 46.5853 82.0687 46.5856 82.058C46.586 82.0507 46.586 82.0434 46.586 82.036C46.5857 81.8118 46.4702 81.6676 46.2965 81.6653C46.2951 81.6653 46.2935 81.6653 46.2921 81.6653C46.2908 81.6653 46.2895 81.6653 46.2881 81.6653C46.2041 81.6663 46.1067 81.7 46.0026 81.7734C45.9966 81.7778 45.9906 81.7818 45.9845 81.7858C45.9812 81.7881 45.9782 81.7904 45.9748 81.7924C45.9715 81.7948 45.9681 81.7968 45.9651 81.7991C45.9648 81.7991 45.9648 81.7991 45.9648 81.7991C45.9601 81.8021 45.9554 81.8054 45.9508 81.8084C45.9498 81.8088 45.9488 81.8098 45.9477 81.8101C45.9441 81.8128 45.9404 81.8148 45.937 81.8171C45.9357 81.8181 45.9343 81.8188 45.933 81.8198C45.8497 81.8718 45.7831 81.8989 45.7299 81.8995C45.7292 81.8995 45.7289 81.8995 45.7282 81.8995C45.7269 81.8995 45.7252 81.8996 45.7235 81.8992C45.6305 81.8966 45.5786 81.8088 45.5461 81.6273C45.5448 81.6203 45.5434 81.6133 45.5424 81.6063C45.6023 81.4354 45.6619 81.2649 45.7215 81.0941C45.7801 80.9202 45.838 80.7464 45.8959 80.5725C45.9012 80.5745 45.9066 80.5769 45.9119 80.5789C45.9136 80.5796 45.9156 80.5802 45.9173 80.5809C46.1683 80.677 46.4139 80.7577 46.6633 80.7591C46.6653 80.7591 46.6673 80.7591 46.6693 80.7591C46.6716 80.7591 46.6737 80.7591 46.676 80.7591C46.9464 80.7574 47.2212 80.6613 47.5124 80.3881C47.516 80.3844 47.5201 80.3807 47.5241 80.3767C47.5264 80.3743 47.5291 80.372 47.5315 80.3697C47.5328 80.3683 47.5341 80.367 47.5355 80.366C47.6342 80.2743 47.7845 80.2582 47.9458 80.2582C47.9886 80.2582 48.0325 80.2592 48.076 80.2606C48.0994 80.2609 48.1228 80.2616 48.1459 80.2622C48.165 80.2626 48.1841 80.2626 48.2028 80.2626C48.2041 80.2626 48.2055 80.2626 48.2068 80.2626C48.2102 80.2626 48.2135 80.2626 48.2165 80.2626C48.239 80.2626 48.261 80.2622 48.2831 80.2612C48.3079 80.2602 48.3327 80.2586 48.3564 80.2559C48.3072 80.4284 48.2527 80.5996 48.1928 80.7687C47.9628 80.8054 47.8494 80.8792 47.8487 80.9883C47.848 81.068 47.9076 81.1665 48.0258 81.2836C47.9846 81.4458 47.9341 81.6069 47.907 81.7707C47.9056 81.7801 47.9049 81.7911 47.9049 81.8024C47.9049 81.8141 47.9056 81.8268 47.907 81.8395C47.914 81.9082 47.9367 81.984 47.9444 81.984C47.9444 81.984 47.9444 81.984 47.9448 81.9836C48.0492 81.9623 48.1874 81.9523 48.2483 81.8719C48.3427 81.7467 48.3842 81.5696 48.4481 81.4144C48.4498 81.4111 48.4518 81.4074 48.4535 81.404C48.7744 80.8008 48.8548 80.6536 49.2055 80.653C49.2062 80.653 49.2072 80.653 49.2078 80.653C49.2085 80.653 49.2095 80.653 49.2105 80.653C49.3012 80.653 49.41 80.663 49.5459 80.677C49.5736 80.68 49.6028 80.683 49.6332 80.6863C49.6372 80.6867 49.6413 80.6873 49.6456 80.6877C49.6476 80.701 49.6496 80.7144 49.652 80.7274C49.652 80.7277 49.652 80.7277 49.652 80.7277C49.7848 81.5242 50.1764 81.7657 50.6875 81.7664C50.6885 81.7664 50.6895 81.7664 50.6905 81.7664C50.6915 81.7664 50.6925 81.7664 50.6935 81.7664C50.912 81.7661 51.152 81.722 51.403 81.659C51.406 81.6583 51.4087 81.6576 51.4117 81.657C51.4167 81.6556 51.4221 81.6543 51.4274 81.6526C51.4314 81.6516 51.4351 81.651 51.4391 81.65C51.4478 81.6476 51.4566 81.6453 51.4653 81.6429C51.4703 81.6416 51.4753 81.6403 51.4803 81.6389C51.487 81.6373 51.4937 81.6356 51.5004 81.6336C51.646 81.9863 51.6972 82.4941 52.1175 82.4961C52.1182 82.4961 52.1192 82.4961 52.1199 82.4961C52.1205 82.4961 52.1209 82.4961 52.1215 82.4961C52.1791 82.4961 52.244 82.4865 52.317 82.4654C52.3247 82.4631 52.3324 82.4611 52.3401 82.4584C52.3488 82.4558 52.3575 82.4531 52.3662 82.4507C52.5007 82.4114 52.6299 82.395 52.7561 82.3947C52.7564 82.3947 52.7571 82.3947 52.7574 82.3947C52.7584 82.3947 52.7594 82.3947 52.7604 82.3947C53.1333 82.3957 53.4753 82.5405 53.8214 82.6746C53.8274 82.677 53.8338 82.6793 53.8401 82.682C54.1832 82.8145 54.3144 83.054 54.315 83.3613C54.3157 83.5282 54.2775 83.7147 54.2143 83.9152C54.0198 84.0373 53.8254 84.1595 53.631 84.2812C53.3656 83.9095 53.1001 83.5382 52.8438 83.1791C52.3682 83.4638 52.3103 84.1478 51.7634 84.2923C51.6232 84.3293 51.5673 84.418 51.5673 84.5135C51.567 84.6249 51.6436 84.7454 51.7507 84.8028C52.0974 84.9886 52.2092 85.2302 52.2089 85.4985C52.2082 85.8381 52.0282 86.2212 51.9171 86.5892C51.9074 86.5935 51.8973 86.5979 51.8873 86.6025C51.7668 86.6596 51.6292 86.7534 51.5118 86.8034C51.5104 86.8041 51.5088 86.8048 51.5074 86.8051C51.4857 86.8144 51.4646 86.8221 51.4445 86.8274C51.4422 86.8281 51.4398 86.8288 51.4375 86.8294C51.4164 86.8348 51.3963 86.8378 51.3776 86.8378C51.3776 86.8378 51.3772 86.8378 51.3769 86.8378C51.3585 86.8375 51.3414 86.8344 51.3257 86.8281C51.3254 86.8278 51.3253 86.8278 51.325 86.8278C51.3243 86.8274 51.324 86.8271 51.3233 86.8271C51.3227 86.8268 51.322 86.8264 51.3213 86.8261C51.3207 86.8258 51.3197 86.8254 51.319 86.8248C50.9405 86.6329 50.6356 86.2809 50.2624 86.0737C50.2587 86.0717 50.255 86.0697 50.2517 86.0677C50.2457 86.0647 50.24 86.0613 50.234 86.0583C50.2293 86.0557 50.2246 86.0533 50.2199 86.051C50.0904 85.9839 49.9766 85.9492 49.8745 85.9486C49.8735 85.9486 49.8728 85.9486 49.8718 85.9486C49.8702 85.9486 49.8685 85.9486 49.8668 85.9486C49.5797 85.9519 49.3866 86.2295 49.1928 86.8258C49.1904 86.8331 49.1878 86.8408 49.1854 86.8485C49.1848 86.8508 49.1837 86.8535 49.1831 86.8558C49.159 86.9312 49.1181 87.0013 49.0649 87.1174C48.4421 87.2112 47.7503 87.1237 47.2352 87.8451C46.8524 87.8455 46.4678 87.8591 46.085 87.8591Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M96.3555 85.4465C96.2685 85.221 96.1781 84.9951 96.0911 84.7695C95.6694 84.6421 95.2477 84.5143 94.8261 84.3868C94.1165 84.1342 93.4037 83.882 92.6908 83.6297C92.6942 83.6257 92.6975 83.6217 92.7042 83.6177C92.9016 83.3922 93.1025 83.3348 93.3133 83.3348C93.4237 83.3348 93.5376 83.3501 93.6513 83.3655C93.6647 83.3671 93.6781 83.3688 93.6915 83.3705C93.7952 83.3838 93.899 83.3958 94.0094 83.3962C94.0128 83.3962 94.0128 83.3962 94.0128 83.3962C94.2069 83.3958 94.4077 83.3578 94.6252 83.2243C94.6252 83.2227 94.6286 83.2207 94.6319 83.219C94.8562 82.3168 95.6125 81.595 96.225 80.7445C96.2384 80.7255 96.2451 80.6951 96.2451 80.6588C96.2418 80.5543 96.1949 80.3989 96.1447 80.3148C96.1413 80.3138 96.1413 80.3131 96.1413 80.3121C96.138 80.3064 96.1346 80.3004 96.1313 80.2947C96.1279 80.2924 96.1246 80.2897 96.1246 80.2874C96.0476 80.199 95.8903 80.1516 95.7564 80.1503C95.7531 80.1503 95.7531 80.1503 95.7497 80.1503H95.7464C95.6393 80.1506 95.549 80.1803 95.5289 80.2414C95.5255 80.242 95.5255 80.2424 95.5255 80.243C95.5255 80.2444 95.5255 80.2457 95.5255 80.247C95.1038 81.6805 94.1132 82.1259 93.0188 82.4606C92.6071 82.5864 92.4231 83.0548 92.249 83.4776C92.1821 83.4579 92.1185 83.4345 92.0482 83.4195C91.6633 83.3338 91.3186 83.2307 91.3186 82.8012C91.3186 82.6781 91.3454 82.5283 91.409 82.3445C91.409 82.3435 91.4123 82.3421 91.4123 82.3408C91.4492 82.223 91.3387 82.1443 91.2048 82.1429C91.2015 82.1429 91.2015 82.1429 91.2015 82.1429H91.1981C91.1011 82.1436 90.9906 82.1849 90.9137 82.2814C90.7664 82.4679 90.6694 82.7065 90.5489 82.922C90.2878 82.8162 90.0234 82.7105 89.759 82.6047C89.8494 82.2731 89.9397 81.9414 90.0335 81.6094C90.1472 80.9614 90.8199 80.9044 91.081 80.2537C90.6124 80.0972 90.154 79.9437 89.6954 79.7903C89.421 79.7072 89.1466 79.6241 88.8755 79.5403C88.7182 79.4896 88.5609 79.4382 88.4036 79.3872C88.2797 79.3195 88.1559 79.2591 88.0254 79.2063C88.2162 79.1089 88.4203 78.9264 88.5977 78.9191C88.6011 78.9191 88.6044 78.9191 88.6077 78.9191C88.6077 78.9191 88.6077 78.9191 88.6111 78.9191C88.6144 78.9191 88.6178 78.919 88.6245 78.9194C88.9759 78.9404 89.3072 79.0892 89.6519 79.168C89.6553 79.1686 89.6586 79.1696 89.662 79.1706C89.7222 79.1833 89.7791 79.1897 89.8327 79.1897C89.8327 79.1897 89.8327 79.1897 89.836 79.1897C90.2376 79.1887 90.4652 78.8423 90.6459 78.4095C90.6493 78.4065 90.6493 78.4035 90.6493 78.4009C90.6526 78.3975 90.6526 78.3945 90.6526 78.3912C90.656 78.3902 90.656 78.3889 90.656 78.3875C90.656 78.3845 90.6593 78.3815 90.6593 78.3785C90.7999 78.4246 90.9404 78.4679 91.081 78.5087C91.0843 78.51 91.0877 78.5113 91.0944 78.5123C91.0977 78.514 91.1011 78.5153 91.1078 78.5166C91.1178 78.5196 91.1279 78.523 91.1379 78.526C91.1379 78.5267 91.1412 78.5277 91.1446 78.5283C91.1479 78.5297 91.1513 78.531 91.158 78.5323C91.1647 78.5343 91.1714 78.5363 91.1781 78.5383C91.2149 78.5503 91.2517 78.562 91.2885 78.573C91.5797 78.6618 91.7805 78.7149 91.9344 78.7159C91.9344 78.7159 91.9344 78.7159 91.9378 78.7159C92.239 78.7155 92.3662 78.513 92.6774 77.9824C92.6808 77.9774 92.6841 77.9728 92.6874 77.9678C92.6874 77.9654 92.6908 77.9631 92.6908 77.9608C92.6975 77.9511 92.7042 77.9414 92.7075 77.9317C92.9385 77.873 93.0723 77.7139 93.0723 77.4563C93.0723 77.4456 93.0723 77.4349 93.0723 77.4242C93.0489 76.8664 93.0154 76.3111 92.9853 75.7549C92.992 75.7566 92.9987 75.7586 93.0054 75.7603C93.0087 75.7619 93.0154 75.7633 93.0221 75.7646C93.0422 75.7706 93.0656 75.7762 93.0857 75.7819C93.4171 75.8723 93.6413 75.9291 93.8086 75.9304C93.8086 75.9304 93.812 75.9304 93.8153 75.9304C94.1232 75.9301 94.2471 75.7365 94.5416 75.2104C94.5449 75.208 94.5449 75.2057 94.5449 75.2034C94.5483 75.1967 94.555 75.19 94.5583 75.1833C94.5617 75.1777 94.565 75.1723 94.5683 75.1667C94.5683 75.1643 94.5684 75.162 94.5717 75.1597C94.5717 75.1567 94.575 75.1537 94.575 75.151C94.5784 75.1476 94.5784 75.1443 94.5817 75.141C94.7859 75.0115 94.99 74.882 95.1942 74.7526C95.2009 75.2718 95.5188 75.4276 95.8703 75.5487C95.6996 76.0619 95.5289 76.5754 95.3548 77.0889C95.3247 77.0885 95.298 77.0886 95.2678 77.0886C95.2478 77.0886 95.2277 77.0886 95.2109 77.0886C95.2076 77.0886 95.2076 77.0886 95.2076 77.0886C94.5416 77.0886 94.5115 77.1246 94.3742 77.6952C94.3742 77.6962 94.3742 77.6972 94.3742 77.6982C94.3709 77.7045 94.3709 77.7109 94.3709 77.7175C94.3676 77.7269 94.3642 77.7366 94.3608 77.7466C94.3207 77.9167 94.3341 78.1099 94.2604 78.2584C94.1634 78.4596 94.0764 78.6491 94.0764 78.8336C94.0764 78.9597 94.1165 79.0836 94.2236 79.2067C94.2236 79.2077 94.2236 79.2087 94.2236 79.2097C94.2671 79.2587 94.3106 79.2841 94.3575 79.2847H94.3608C94.3642 79.2847 94.3642 79.2848 94.3675 79.2844C94.5215 79.2757 94.6989 78.9918 94.9164 78.3979C94.9198 78.3935 94.9198 78.3895 94.9231 78.3855C95.0135 78.1313 95.1038 77.876 95.1942 77.6211C95.7063 77.7128 95.9338 78.222 96.2852 78.5493C96.2283 78.7185 96.1748 78.8877 96.1213 79.0565C96.1179 79.0559 96.1112 79.0552 96.1079 79.0542C96.1012 79.0532 96.0945 79.0522 96.0911 79.0509C96.0811 79.0492 96.0744 79.0475 96.0644 79.0458C95.9773 79.0255 95.887 78.9968 95.7966 78.9948C95.7933 78.9944 95.7899 78.9945 95.7866 78.9945H95.7832C95.7665 78.9948 95.7498 78.9958 95.7297 78.9985C95.7297 78.9988 95.7297 78.9988 95.7263 78.9991C95.723 78.9998 95.7196 79.0005 95.7163 79.0011C95.6259 79.0192 95.5389 79.1563 95.4519 79.24C95.4921 79.2981 95.5222 79.3809 95.5757 79.4109C95.5858 79.4159 95.5925 79.4206 95.6025 79.4249C95.7196 79.4866 95.8401 79.5203 95.9539 79.521C95.9573 79.521 95.9573 79.521 95.9573 79.521C95.9606 79.521 95.964 79.5207 95.9707 79.5207C96.1581 79.5173 96.3421 79.4255 96.5195 79.2243C96.5195 79.2217 96.5229 79.2187 96.5262 79.2157C96.5296 79.2127 96.5296 79.21 96.5329 79.207C96.8107 79.4349 96.9981 79.8133 97.3997 79.8133C97.4868 79.8133 97.5838 79.7949 97.6976 79.7522C97.6206 80.3718 97.6875 80.8973 97.4867 81.2053C97.1387 81.7398 96.9312 82.3101 96.7036 82.887C96.5229 83.3384 96.2283 83.5343 95.8334 83.5343C95.8133 83.5343 95.7933 83.5336 95.7732 83.5326C95.7698 83.5326 95.7665 83.5323 95.7631 83.5323C95.6393 83.5323 95.5021 83.6438 95.3682 83.7028C95.5958 84.2103 96.1146 84.1436 96.4894 84.3605C96.978 84.6434 96.9513 84.893 96.3555 85.4465Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M10.0519 55.6177C10.0509 55.6177 10.0499 55.6177 10.0489 55.6177C9.79891 55.616 9.66838 55.4001 9.50305 55.2597C9.49736 55.2547 9.49133 55.2497 9.48498 55.2446C9.48364 55.2433 9.48198 55.2423 9.4803 55.241C9.47227 55.2343 9.46389 55.2283 9.45553 55.2223C9.45185 55.2196 9.44851 55.2169 9.44482 55.2146C9.54255 54.306 9.74904 53.4375 10.3464 52.7135C10.4154 52.7064 10.4873 52.6884 10.559 52.6698C10.657 52.6447 10.7548 52.6187 10.8448 52.6174C10.8475 52.6174 10.8498 52.6174 10.8525 52.6174C10.8542 52.6174 10.8558 52.6174 10.8575 52.6174C11.0148 52.619 11.147 52.7008 11.2123 53.0031C11.2136 53.0084 11.2146 53.0138 11.2159 53.0191C11.2591 53.2326 11.4214 53.4242 11.5757 53.5576C11.5781 53.5596 11.5804 53.5617 11.5831 53.5633C11.5834 53.5637 11.5837 53.564 11.5841 53.5643C11.6109 53.583 11.646 53.5903 11.6858 53.5907C11.6865 53.5907 11.6872 53.5907 11.6878 53.5907C11.7002 53.5907 11.7133 53.59 11.7263 53.5887C11.7293 53.5887 11.732 53.5883 11.735 53.588C11.7531 53.586 11.7715 53.5833 11.7902 53.58C11.8063 53.577 11.8227 53.5737 11.8391 53.5703C11.8699 53.5637 11.9007 53.5566 11.9301 53.5503C11.9335 53.5496 11.9368 53.549 11.9398 53.5483C11.9435 53.5476 11.9469 53.5469 11.9502 53.5463C11.9589 53.5446 11.9676 53.543 11.976 53.5413C11.9971 53.5376 12.0412 53.4358 12.0416 53.3878C12.0416 53.3808 12.0406 53.3751 12.0386 53.3708C11.7514 52.7405 11.6547 52.0688 11.6547 51.3761C11.6547 50.8109 11.7193 50.232 11.7976 49.6498C11.9495 49.3381 12.0486 48.9591 12.2635 48.7268C13.0175 47.911 13.4392 46.7642 14.3107 46.0745C14.6785 45.0392 15.4265 44.3228 16.0202 43.4736C16.3636 42.9825 16.6789 42.4246 16.874 41.8517C17.1391 41.0743 17.537 40.4119 17.9811 39.7633C18.0347 39.8951 18.1545 40.0479 18.1555 40.1633C18.1558 40.1787 18.1538 40.1934 18.1491 40.2071C18.0153 40.6228 17.9597 41.0195 17.9594 41.4026C17.9583 42.2157 18.2057 42.9681 18.4748 43.7155C18.2023 44.1319 17.8797 44.4666 17.7438 44.8647C17.3924 45.8957 16.7579 46.5237 15.9182 46.9431C15.7736 47.0151 15.6427 47.1379 15.4971 47.2053C14.8817 47.4906 14.8395 48.1533 14.634 48.7682C14.4235 48.7839 14.2013 48.7896 13.9784 48.8209C13.7367 48.855 13.4948 48.9924 13.4683 49.2871C13.4218 49.8096 13.4492 50.2894 13.1266 50.8089C13.0777 50.8873 13.0567 50.9561 13.0567 51.0165C13.0557 51.2474 13.3565 51.3601 13.5603 51.4562C13.555 51.4876 13.5523 51.5179 13.5523 51.5473C13.552 51.8956 13.9128 52.1049 13.9138 52.4599C13.9141 52.563 13.884 52.6781 13.806 52.8129C13.5563 53.2437 13.8301 53.893 13.2899 54.2163C13.2692 54.2286 13.2484 54.2407 13.2277 54.253C12.8103 54.4969 12.3723 54.6868 11.9512 54.6884C11.9496 54.6884 11.9479 54.6884 11.9462 54.6884C11.9455 54.6884 11.9449 54.6884 11.9442 54.6884C11.7528 54.6881 11.5647 54.6484 11.3833 54.5573C11.3829 54.557 11.3823 54.5566 11.3819 54.5563C11.3766 54.5536 11.3712 54.551 11.3662 54.5483C11.3629 54.5466 11.3595 54.5449 11.3565 54.5433C11.3425 54.5356 11.3291 54.5286 11.3157 54.5219C11.3117 54.5199 11.3076 54.5179 11.304 54.5159C11.1751 54.4519 11.068 54.4182 10.976 54.4172C10.9743 54.4172 10.9726 54.4172 10.971 54.4172C10.9703 54.4172 10.9699 54.4172 10.9693 54.4172C10.7695 54.4178 10.6396 54.5743 10.5091 54.91C10.415 55.1525 10.2949 55.3844 10.1985 55.5956C10.1945 55.5966 10.1905 55.598 10.1868 55.599C10.1841 55.5997 10.1814 55.6003 10.1788 55.601C10.1336 55.6123 10.0921 55.6177 10.0533 55.6177C10.0529 55.6177 10.0526 55.6177 10.0519 55.6177ZM15.6099 46.1182C15.6297 46.1056 15.6494 46.0932 15.6692 46.0805C15.7404 46.0352 15.8121 45.9901 15.8837 45.9448C15.8857 45.9444 15.888 45.9441 15.8901 45.9437C15.8921 45.9424 15.8941 45.9414 15.8961 45.9401C15.9597 45.9317 16.0263 45.9351 16.0835 45.906C16.1203 45.888 16.141 45.8163 16.1688 45.7689C16.0781 45.826 15.9871 45.883 15.8961 45.9401C15.8937 45.9404 15.8914 45.9407 15.889 45.9411H15.8894C15.8874 45.9424 15.8854 45.9434 15.8837 45.9448C15.8834 45.9448 15.8834 45.9448 15.8834 45.9448C15.8194 45.9531 15.7525 45.9494 15.6949 45.9784C15.6585 45.9971 15.6374 46.0699 15.6099 46.1182ZM13.5617 51.4569C13.5614 51.4565 13.561 51.4562 13.5603 51.4562C13.5607 51.4556 13.5607 51.4549 13.5607 51.4542L13.5617 51.4569Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M63.4949 55.0002V54.9999C63.4986 54.9635 63.5002 54.9282 63.5002 54.8945C63.4999 54.6566 63.4095 54.4794 63.2258 54.3646C63.1137 54.3706 63.0002 54.389 62.8871 54.408C62.8824 54.4087 62.8781 54.4097 62.8734 54.4103C62.865 54.4117 62.8566 54.413 62.8483 54.4147C62.7174 54.4364 62.5869 54.4571 62.4604 54.4574C62.4594 54.4574 62.4584 54.4574 62.4574 54.4574C62.4554 54.4574 62.4537 54.4574 62.4517 54.4574C62.2184 54.4564 61.9975 54.3847 61.8068 54.1234C61.8028 54.1181 61.7991 54.1127 61.795 54.1074C61.793 54.1044 61.791 54.1014 61.789 54.0987C61.7837 54.0907 61.7783 54.0833 61.773 54.0757C61.5869 53.8181 61.3757 53.716 61.1515 53.715C61.1508 53.715 61.1498 53.715 61.1488 53.715C61.1478 53.715 61.1464 53.715 61.1454 53.715C60.8693 53.7163 60.5745 53.8705 60.2833 54.077C60.283 54.077 60.2826 54.0773 60.2823 54.0777C60.2585 54.0947 60.2348 54.1117 60.211 54.1294C60.2073 54.1321 60.204 54.1344 60.2007 54.137C59.8814 53.9472 59.5634 53.7583 59.2458 53.5695C59.2117 53.2171 59.0494 52.8898 58.781 52.8862C58.7796 52.8862 58.7779 52.8862 58.7762 52.8862H58.7759C58.7585 52.8862 58.7408 52.8875 58.7224 52.8901C58.6233 52.9055 58.5269 52.9125 58.4325 52.9125C58.4325 52.9125 58.4322 52.9125 58.4319 52.9125C58.4305 52.9125 58.4292 52.9125 58.4275 52.9125C57.8649 52.9112 57.3756 52.6673 56.8656 52.5014C56.8334 52.4908 56.8016 52.4807 56.7695 52.4711C56.7642 52.4694 56.7585 52.4677 56.7531 52.4664C56.7384 52.4621 56.724 52.4577 56.7093 52.4534C56.7013 52.451 56.6929 52.4487 56.6849 52.4467C56.6243 52.4297 56.563 52.4144 56.5011 52.4013C56.4954 52.4 56.4897 52.399 56.4837 52.3977C56.4703 52.395 56.4566 52.3923 56.4432 52.3896C56.4372 52.3886 56.4312 52.3873 56.4251 52.3863C56.4225 52.386 56.4198 52.3853 56.4171 52.385C56.4044 52.3826 56.3917 52.3803 56.379 52.3777C56.3786 52.3777 56.3786 52.3777 56.3786 52.3777C56.2113 52.3446 56.049 52.2922 55.8883 52.2328C55.4342 52.0643 54.9954 51.8395 54.4991 51.8381C54.4977 51.8381 54.4961 51.8381 54.4947 51.8381C54.4944 51.8381 54.494 51.8381 54.4937 51.8381C54.3786 51.8381 54.2601 51.8505 54.1379 51.8782C53.1179 51.5448 52.1744 51.0503 51.3273 50.354C51.2621 50.1544 51.2022 49.9516 51.1299 49.7564C51.0348 49.4994 50.9301 49.2485 50.8293 48.9953C52.308 49.091 53.6945 49.5388 55.0891 49.9576C56.2749 50.3136 57.4596 50.6739 58.6451 51.0323C59.6621 51.772 60.9199 51.8658 62.0344 52.3433C62.1589 52.7834 62.4734 52.9469 62.8312 53.0637C63.3172 53.2218 63.8018 53.3867 64.273 53.5842C64.3701 53.6252 64.4055 53.8217 64.4708 53.9489C64.266 54.454 64.0053 54.8858 63.4949 55.0002Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M91.6268 71.2776C91.5365 71.042 91.4427 70.8058 91.3524 70.5696C91.4227 70.2356 91.4661 70.0147 91.4661 69.8565C91.4661 69.5596 91.3089 69.4838 90.8571 69.296C90.7265 69.2412 90.5826 69.2206 90.4454 69.1842C90.3617 69.1709 90.278 69.1455 90.1944 69.1225C90.104 69.0978 90.0136 69.0754 89.9266 69.0741C89.9233 69.0741 89.9233 69.0741 89.92 69.0741C89.92 69.0741 89.9199 69.0741 89.9166 69.0741C89.8764 69.0741 89.8363 69.0791 89.7961 69.0907C89.7861 69.0938 89.776 69.0964 89.766 69.0991C89.7626 69.0998 89.7626 69.1004 89.7593 69.1008C89.7526 69.1028 89.7459 69.1045 89.7392 69.1065C89.5384 69.1605 89.351 69.1865 89.1703 69.1869C89.1669 69.1869 89.1669 69.1869 89.1669 69.1869C88.4875 69.1859 87.9654 68.8122 87.529 68.1959C87.528 68.1942 87.5267 68.1925 87.5257 68.1909C87.5173 68.1792 87.5089 68.1668 87.5006 68.1548C87.4972 68.1502 87.4942 68.1455 87.4909 68.1408C87.537 67.9903 87.5872 67.8422 87.6475 67.696C87.7914 67.6006 87.8717 67.4738 87.8717 67.3587C87.8717 67.2746 87.8315 67.1965 87.7412 67.1412C87.0953 66.7414 86.2492 66.8045 85.6448 66.2129C85.6471 66.2109 85.6491 66.2089 85.6515 66.2069C85.7951 66.0701 85.9246 66.024 86.0467 66.0224C86.0487 66.0224 86.0504 66.0224 86.0524 66.0224C86.0544 66.0224 86.0561 66.0224 86.0581 66.0224C86.1849 66.0237 86.3038 66.0724 86.4216 66.1158C86.5159 66.1502 86.6096 66.1815 86.7064 66.1819C86.7114 66.1832 86.7167 66.1845 86.7218 66.1862C86.7298 66.1882 86.7375 66.1905 86.7455 66.1929C86.7546 66.1956 86.7636 66.1982 86.773 66.2009C86.7783 66.2026 86.7837 66.2042 86.7894 66.2059C86.7921 66.2069 86.7951 66.2079 86.7977 66.2089C86.7998 66.2092 86.8018 66.2099 86.8038 66.2106C86.8098 66.2126 86.8158 66.2146 86.8218 66.2166C86.8259 66.2179 86.8299 66.2192 86.8339 66.2206C86.8406 66.2226 86.8469 66.2249 86.8536 66.2273C86.8563 66.2279 86.8586 66.2289 86.8613 66.2299C87.2121 66.3511 87.5471 66.5406 87.9454 66.5416C87.9454 66.5416 87.9453 66.5416 87.9487 66.5416C88.0357 66.5416 88.1261 66.5325 88.2198 66.5115C88.2265 66.0904 88.2365 65.6717 88.2432 65.2523C88.2532 65.2456 88.2633 65.2393 88.2733 65.2336C88.2767 65.2323 88.28 65.2306 88.28 65.2293C88.2834 65.2283 88.2867 65.2269 88.2867 65.2259C88.2901 65.2243 88.2934 65.2229 88.2968 65.2216C88.3436 65.1962 88.3905 65.1789 88.4373 65.1679C88.4808 65.1575 88.5243 65.1529 88.5678 65.1529C88.7084 65.1529 88.8389 65.2012 88.9661 65.2496C88.9695 65.2513 88.9761 65.2529 88.9795 65.2549C88.9828 65.2566 88.9895 65.2583 88.9929 65.26C89.11 65.3037 89.2205 65.3447 89.3343 65.3464C89.3343 65.3464 89.3376 65.3464 89.3409 65.3464C89.3844 65.346 89.428 65.34 89.4715 65.3257C89.7693 64.8382 90.0337 64.4031 90.3015 63.968C90.3985 63.7351 90.4655 63.5069 90.4688 63.2887C90.4688 63.0991 90.4153 62.9176 90.2847 62.7481C90.3316 62.5519 90.3684 62.3574 90.3684 62.1725C90.3684 61.9723 90.3249 61.7832 90.191 61.6157C90.2412 61.4498 90.2948 61.2857 90.3517 61.1225C90.5793 61.1192 90.7533 60.9954 90.8704 60.7495C91.436 61.219 90.7901 62.0688 91.1281 62.6013C91.1884 62.6998 91.3223 62.7438 91.436 62.7792C91.436 62.7795 91.4394 62.7798 91.4394 62.7798C91.4795 62.7798 91.5733 62.6847 91.5866 62.6283C91.6201 62.4652 91.6168 62.297 91.6368 62.1315C91.7239 61.4055 91.7372 61.302 92.2928 61.302C92.3865 61.302 92.4936 61.305 92.6174 61.3084C92.2627 62.3611 92.005 63.4678 91.1649 64.2423C91.011 64.5399 90.847 64.8329 90.7065 65.1372C90.6496 65.254 90.5726 65.4525 90.5726 65.5386C90.5726 65.5556 90.5759 65.5679 90.5826 65.5749C90.76 65.7545 90.8035 65.9847 90.8035 66.2309C90.8035 66.4758 90.76 66.7367 90.76 66.98C90.76 67.2206 90.8035 67.4438 90.9742 67.617C91.0512 67.687 91.0947 67.7715 91.0913 67.8579C91.0913 67.932 91.0612 68.0073 90.9909 68.0768C90.8738 68.1925 90.6161 68.2119 90.5826 68.3203C90.5659 68.375 90.5592 68.4224 90.5592 68.4635C90.5592 68.691 90.7868 68.7227 90.9541 68.7658C91.1582 68.8185 91.3222 68.8495 91.4561 68.8499H91.4595H91.4628C91.8109 68.8492 91.9715 68.645 92.2058 68.0938C92.2125 68.0807 92.2158 68.0677 92.2225 68.0547C92.2225 68.0497 92.2259 68.0447 92.2292 68.0397C92.3665 67.707 92.4702 67.3594 92.5873 67.0181C93.0425 67.5322 93.3069 68.0908 92.6777 68.8158C92.0686 69.5189 91.9682 70.4521 91.6268 71.2776Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M94.5818 75.1411C94.1903 74.5799 93.7317 74.1348 93.0624 74.044C92.7813 73.9523 92.5001 73.8608 92.2224 73.7691C92.1253 73.6576 92.0818 73.5542 92.0818 73.4601C92.0818 73.2983 92.2056 73.1642 92.3997 73.0644C92.5838 72.9683 92.7946 72.957 92.9955 72.9076C93.0021 72.991 92.9854 73.0991 93.0256 73.1528C93.0657 73.2092 93.1092 73.2366 93.1528 73.2366C93.223 73.2366 93.3 73.1732 93.3703 73.0537C93.5309 73.0988 93.6916 73.1438 93.8522 73.1888C93.9024 73.3357 93.9192 73.5422 94.0162 73.6199C94.5919 74.0791 95.2579 74.2833 95.9875 74.3076C96.128 73.7237 95.9908 73.3343 95.5691 73.325C95.539 73.3243 95.5122 73.324 95.4821 73.324C95.3549 73.324 95.2311 73.3293 95.1039 73.335C94.9767 73.3407 94.8529 73.346 94.7257 73.346C94.4279 73.346 94.1367 73.3146 93.8589 73.1775C94.1099 72.8752 94.3576 72.5726 94.6086 72.2699C94.863 71.9406 95.1207 71.6687 95.4185 71.6687C95.5591 71.6687 95.7097 71.7281 95.8737 71.8689C95.8804 71.8732 95.8837 71.8752 95.8938 71.8752C95.9607 71.8752 96.1247 71.7297 96.2385 71.6637C96.2686 71.6693 96.2987 71.6764 96.3289 71.684C96.3456 71.6874 96.359 71.6907 96.3724 71.6944C96.446 71.7124 96.5196 71.7301 96.5932 71.7311H96.5966H96.5999C96.6133 71.7311 96.6267 71.7304 96.6401 71.7291C96.9949 71.6937 97.1455 71.619 97.1455 71.3727C97.1455 71.2322 97.0952 71.036 97.0049 70.7598C97.4835 69.2209 97.4835 69.2209 97.3228 67.7078C97.6508 67.3013 98.0123 67.1726 98.4005 67.1726C98.6013 67.1726 98.8055 67.2062 99.0197 67.2539C98.9326 68.2973 98.8423 69.3347 98.7452 70.4565C98.8423 70.8412 99.2473 70.8815 99.5418 71.0954C99.7694 71.2629 99.9534 71.5098 100.121 71.6833C100.071 71.957 100.077 72.1401 100.01 72.2809C99.853 72.5973 99.6656 72.8969 99.4815 73.1952C99.2338 73.5989 98.9059 73.8705 98.7251 73.8705C98.6682 73.8705 98.6247 73.8442 98.6013 73.7878C98.4306 73.37 98.8021 73.1952 98.9795 72.9323C99.2071 72.5956 99.197 72.2876 98.9695 72.0164C98.9259 71.8739 98.9092 71.6994 98.8289 71.5963C98.7553 71.4992 98.6582 71.4431 98.5578 71.4425H98.5545C98.5545 71.4425 98.5545 71.4425 98.5511 71.4425C98.4708 71.4438 98.3838 71.4818 98.3035 71.5649C98.3035 71.5672 98.3001 71.5699 98.2968 71.5726C98.2934 71.5753 98.2934 71.5779 98.2901 71.5806C98.2131 71.6657 98.1696 71.8372 98.1696 71.9686C98.1696 71.9846 98.1696 72 98.1696 72.015C98.1863 72.1568 98.2934 72.2739 98.3603 72.4024C98.0926 73.7137 97.1087 74.2499 96.2619 74.8705C96.195 74.9179 96.1147 74.9363 96.0277 74.9363C95.78 74.9363 95.462 74.7908 95.1943 74.7527C94.9901 74.8822 94.786 75.0117 94.5818 75.1411Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M95.1173 89.0129C95.0771 88.2292 94.478 88.2902 94.0363 88.1107C93.9091 87.6449 93.8053 87.1651 93.648 86.717C93.5777 86.5198 93.4338 86.4224 93.2765 86.4224C93.156 86.4224 93.0289 86.4774 92.9184 86.5865C92.8013 86.7023 92.6607 86.8064 92.577 86.9482C92.3428 87.3343 92.1621 87.8091 91.727 87.8091C91.6701 87.8091 91.6098 87.8014 91.5462 87.7847C91.1245 87.6766 91.0944 87.2352 91.0074 86.8368C90.974 86.6846 90.8668 86.5632 90.7932 86.4277C90.9974 86.3056 91.1982 86.1835 91.4023 86.0613C91.7069 86.2465 91.5161 86.8965 92.055 86.9559C92.1621 86.4684 92.3595 85.9662 92.3595 85.4971C92.3595 85.4818 92.3595 85.4668 92.3595 85.4517C92.3595 85.4177 92.3595 85.3837 92.3595 85.35C92.3595 84.765 92.4833 84.2202 92.6373 83.6619L92.6908 83.6296C93.4037 83.8818 94.1166 84.1341 94.8261 84.3867C94.8194 84.8428 94.8026 85.3003 94.8026 85.7547C94.8026 85.9065 94.8027 86.0577 94.8093 86.2082C94.8127 86.3176 94.9934 86.4587 95.1106 86.4671C95.1139 86.4671 95.1139 86.4671 95.1173 86.4674C95.1206 86.4674 95.124 86.4674 95.124 86.4674C95.1407 86.4674 95.1574 86.4657 95.1742 86.4627C95.298 86.4427 95.4519 86.357 95.4954 86.2609C95.7197 85.7764 95.897 85.2685 96.0912 84.7694C96.1782 84.9949 96.2685 85.2208 96.3556 85.4464C96.3355 86.081 96.5028 86.4637 97.0015 86.4637C97.0852 86.4637 97.1789 86.4527 97.2826 86.4304C97.3295 86.42 97.373 86.415 97.4198 86.415C97.6775 86.415 97.885 86.5882 97.9955 86.8678C98.1695 87.3213 97.7478 88.4203 97.3763 88.4203C97.3696 88.4203 97.3629 88.42 97.3562 88.4193C97.3027 88.4133 97.2491 88.4103 97.1956 88.4103C96.466 88.4103 95.8201 88.9492 95.1173 89.0129Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M62.3481 90.5994C62.2724 90.5994 62.1961 90.587 62.1185 90.561C61.3534 90.3027 60.5897 90.0391 59.8256 89.7776C59.8266 89.7762 59.8276 89.7749 59.8283 89.7735C59.8213 89.7712 59.8139 89.7689 59.8069 89.7669C59.8062 89.7665 59.8059 89.7665 59.8052 89.7662C59.7727 89.2967 59.4638 89.1649 59.1435 89.0395C58.85 88.9247 58.5588 88.7999 58.5588 88.3768C58.5592 88.3411 58.5612 88.3031 58.5655 88.2627C58.5706 88.2641 58.5759 88.2657 58.5809 88.2674C58.5853 88.2684 58.5896 88.2697 58.5943 88.2711C58.6964 88.3001 58.7975 88.3178 58.8969 88.3184C58.8986 88.3184 58.9002 88.3184 58.9019 88.3184C58.9029 88.3184 58.9036 88.3184 58.9046 88.3184C59.104 88.3178 59.2971 88.247 59.4789 88.0558C59.4812 88.0535 59.4832 88.0512 59.4852 88.0488C59.4939 88.0395 59.5026 88.0302 59.5113 88.0201C59.6506 88.0482 59.7898 88.0735 59.928 88.0739C59.929 88.0739 59.9304 88.0739 59.9314 88.0739C59.933 88.0739 59.9344 88.0739 59.9361 88.0739C60.1422 88.0729 60.346 88.0155 60.5445 87.8269C60.5505 87.8276 60.5565 87.8286 60.5626 87.8293C60.6335 87.8383 60.7038 87.8436 60.7738 87.8436C60.7741 87.8436 60.7744 87.8436 60.7751 87.8436C60.7771 87.8436 60.7794 87.8436 60.7814 87.8436C61.0552 87.8423 61.3166 87.7595 61.5582 87.5093C61.5602 87.507 61.5623 87.505 61.5643 87.5026C61.5723 87.4943 61.5803 87.4863 61.5884 87.4783C61.591 87.4756 61.5934 87.4733 61.596 87.4706C61.7855 87.2877 61.9846 87.2327 62.1874 87.2317C62.1891 87.2317 62.1908 87.2317 62.1924 87.2317C62.1934 87.2317 62.1944 87.2317 62.1955 87.2317C62.3036 87.232 62.4123 87.2474 62.5214 87.2667C62.5308 87.2684 62.5402 87.2701 62.5495 87.2717C62.5529 87.2724 62.5566 87.2731 62.5599 87.2734C62.5629 87.2741 62.5659 87.2747 62.569 87.2754C62.5757 87.2764 62.5823 87.2777 62.5887 87.2791C62.5897 87.2801 62.5907 87.2811 62.5917 87.2821C62.5947 87.2851 62.5977 87.2884 62.6008 87.2914C62.6064 87.2974 62.6121 87.3031 62.6178 87.3091C62.6192 87.3108 62.6205 87.3121 62.6222 87.3138C62.8608 87.5647 63.08 87.8143 63.4461 87.8163C63.4478 87.8163 63.4491 87.8163 63.4508 87.8163C63.4512 87.8163 63.4515 87.8163 63.4518 87.8163C63.5124 87.8163 63.577 87.8093 63.6463 87.7949C63.6503 87.7939 63.654 87.7932 63.658 87.7922C63.7129 87.7799 63.7684 87.7746 63.8243 87.7746C63.8247 87.7746 63.825 87.7746 63.8253 87.7746C63.8277 87.7746 63.8297 87.7746 63.832 87.7746C64.0218 87.7759 64.2159 87.8373 64.4097 87.893C64.4515 87.9054 64.4937 87.917 64.5355 87.928C64.5412 87.9294 64.5469 87.9307 64.5523 87.9324C64.5603 87.9344 64.5683 87.9364 64.5764 87.9384C64.6102 87.9464 64.644 87.9541 64.6778 87.9604C64.6811 87.9614 64.6845 87.9628 64.6878 87.9638C64.7086 87.9708 64.7297 87.9781 64.7507 87.9861C64.7574 87.9884 64.7641 87.9911 64.7708 87.9934C64.7725 87.9941 64.7738 87.9948 64.7755 87.9954C64.7788 87.9968 64.7825 87.9981 64.7859 87.9991C64.7922 88.0018 64.7986 88.0041 64.805 88.0068C65.0483 88.1022 65.2889 88.2287 65.5412 88.23C65.5423 88.23 65.5436 88.23 65.5446 88.23C65.5453 88.23 65.5459 88.23 65.5469 88.23C65.7287 88.2294 65.9167 88.1629 66.1162 87.9724C66.1186 87.9704 66.1206 87.9684 66.1229 87.9664C66.1273 87.9621 66.1313 87.9581 66.1356 87.9537C66.1383 87.9511 66.141 87.9484 66.144 87.9457C66.4285 88.0375 66.7133 88.1292 66.9974 88.2213C66.819 88.6231 66.6785 89.0552 66.4496 89.4169C66.3127 89.6324 66.1032 89.8296 65.8796 89.8296C65.8063 89.8296 65.7313 89.8082 65.657 89.7595C65.5172 89.6681 65.387 89.6287 65.2641 89.6287C64.9572 89.6287 64.6965 89.874 64.4502 90.1593C64.235 90.4085 64.0181 90.4883 63.7952 90.4883C63.666 90.4883 63.5348 90.4616 63.4006 90.4255C63.3815 89.9314 63.1112 89.7328 62.73 89.6781C62.7276 89.6778 62.7252 89.6774 62.7229 89.6771C62.7212 89.6771 62.7196 89.6771 62.7179 89.6771C62.7176 89.6771 62.7175 89.6771 62.7172 89.6771C62.7135 89.6771 62.7099 89.6774 62.7058 89.6778C62.67 89.6814 62.6305 89.7021 62.5911 89.7228C62.5793 89.7292 62.5676 89.7352 62.5559 89.7412C62.5506 89.7439 62.5455 89.7462 62.5402 89.7489C62.5351 89.7509 62.5301 89.7532 62.5251 89.7552C62.5241 89.7555 62.5231 89.7562 62.5221 89.7565C62.5509 89.8803 62.5476 90.0425 62.6158 90.1192C62.7095 90.2247 62.8574 90.265 62.9819 90.3331C62.7781 90.4959 62.5673 90.5994 62.3481 90.5994Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M110.834 92.4873C110.291 92.4873 109.733 92.3812 109.552 91.7896C109.428 91.3802 109.264 91.2584 109.063 91.2584C108.903 91.2584 108.722 91.3368 108.521 91.4082C108.511 91.4129 108.498 91.4146 108.484 91.4146C108.424 91.4146 108.35 91.3779 108.233 91.3535C108.37 90.4493 108.508 89.5314 108.648 88.6135C108.521 88.4984 108.384 88.4623 108.24 88.4623C108.116 88.4623 107.989 88.4887 107.862 88.515C107.735 88.5417 107.607 88.5681 107.484 88.5681C107.366 88.5681 107.253 88.5441 107.146 88.472C107.263 88.1293 107.38 87.7863 107.494 87.4436C107.915 87.5898 108.334 87.7416 108.755 87.8807C109.251 88.0429 109.418 88.4236 109.361 89.0399C109.304 89.6735 109.599 89.9184 109.994 89.9184C110.054 89.9184 110.114 89.9128 110.178 89.9017C110.395 89.864 110.609 89.844 110.81 89.844C111.513 89.844 112.126 90.0799 112.644 90.6418C112.919 90.9391 113.24 91.0339 113.605 91.0339C113.692 91.0339 113.782 91.0285 113.873 91.0195C113.983 91.0085 114.09 91.0035 114.197 91.0035C115.215 91.0035 116.108 91.4763 117.159 91.9381C116.547 92.1383 116.008 92.2437 115.506 92.2437C115.097 92.2437 114.713 92.1743 114.328 92.0295C113.371 91.6678 112.387 91.3749 111.292 91.0112C111.356 91.4323 111.399 91.6688 111.423 91.9101C111.456 92.2097 111.322 92.4706 111.071 92.4816C110.994 92.485 110.914 92.4873 110.834 92.4873Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M95.1876 68.2029C95.1542 68.2029 95.1241 68.2015 95.0939 68.1992C94.8195 68.1772 94.7525 67.8692 94.8295 67.6103C95.1742 66.4411 94.6522 65.6143 94.2974 64.7184C94.3777 64.4928 94.4413 64.271 94.4413 64.0624C94.4413 63.8666 94.3844 63.6824 94.2305 63.5179C94.3878 63.1001 94.5718 62.7224 95.0203 62.6941C95.2847 63.4018 95.5926 64.0924 95.5926 64.9143C95.5926 64.9933 95.5893 65.0734 95.5859 65.1548C95.5826 65.1548 95.5825 65.1548 95.5825 65.1548V65.1618C95.5825 65.1595 95.5859 65.1572 95.5859 65.1548C96.3958 65.1815 97.2057 65.2129 98.0224 65.2159C98.0491 65.2159 98.1529 64.9677 98.1529 64.8339C98.1529 64.8225 98.1529 64.8118 98.1495 64.8025C98.0726 64.3284 97.7145 64.1882 97.3764 64.0317C97.6308 63.8075 97.8584 63.7187 98.0692 63.7187C98.4173 63.7187 98.7151 63.9527 98.9963 64.2209C99.3912 64.598 99.3945 65.3604 99.0197 65.8926C98.8122 66.1882 98.5913 66.3307 98.3637 66.3307C98.1897 66.3307 98.0123 66.2479 97.8316 66.0868C97.7881 66.0497 97.7278 66.0401 97.6642 66.0401C97.6308 66.0401 97.5973 66.0431 97.5638 66.0457C97.5304 66.0487 97.5003 66.0518 97.4735 66.0518C97.4668 66.0518 97.4634 66.0517 97.4567 66.0514C96.8677 66.7337 96.3222 67.4081 95.7298 68.0287C95.6093 68.1585 95.3817 68.2029 95.1876 68.2029ZM95.2947 65.335C95.3851 65.2776 95.4755 65.2206 95.5692 65.1632C95.5725 65.1628 95.5792 65.1622 95.5825 65.1618V65.1548C95.5759 65.1575 95.5725 65.1605 95.5692 65.1632C95.5056 65.1682 95.4386 65.1625 95.3817 65.1899C95.3449 65.2076 95.3215 65.2843 95.2947 65.335Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M87.9486 66.5417C87.9452 66.5417 87.9452 66.5417 87.9452 66.5417C87.547 66.5407 87.2119 66.3512 86.8612 66.2301C86.8585 66.2291 86.8562 66.2281 86.8535 66.2274C86.8468 66.2251 86.8405 66.2228 86.8338 66.2208C86.8298 66.2194 86.8257 66.2181 86.8217 66.2168C86.8157 66.2147 86.8097 66.2128 86.8036 66.2108C86.8016 66.2101 86.7996 66.2094 86.7976 66.2091C86.795 66.2081 86.7919 66.2071 86.7893 66.2061C86.7836 66.2044 86.7782 66.2027 86.7729 66.2011C86.7635 66.1984 86.7544 66.1957 86.7454 66.1931C86.7374 66.1907 86.7297 66.1884 86.7216 66.1864C86.7166 66.1847 86.7113 66.1834 86.7063 66.182C86.6212 65.9578 86.5359 65.7333 86.4509 65.509C86.2752 64.6886 86.5657 64.068 87.1353 63.4494C87.7913 62.7376 87.7545 62.6869 87.2474 61.801C87.3023 61.6272 87.3572 61.4534 87.4118 61.2795C87.4757 61.1117 87.5336 60.9419 87.5838 60.7704C87.7043 60.4294 87.8214 60.0883 87.9419 59.7473C88.223 59.8434 88.5075 59.9395 88.7886 60.0353C88.6849 60.396 88.4874 60.7643 88.4874 61.1163C88.4874 61.3169 88.551 61.5121 88.7317 61.6973C88.7987 61.7837 88.8254 61.8684 88.8254 61.9575C88.8254 62.0876 88.7719 62.2265 88.7317 62.3906C88.6815 62.5845 88.6581 62.7596 88.6581 62.9165C88.6581 63.5164 89.0028 63.8421 89.6354 63.8824C89.8596 63.8968 90.0805 63.9388 90.3014 63.9682C90.0336 64.4033 89.7692 64.8384 89.4714 65.3259C89.4279 65.3402 89.3843 65.3462 89.3408 65.3466C89.3375 65.3466 89.3342 65.3466 89.3342 65.3466C89.2204 65.3449 89.1099 65.3038 88.9928 65.2601C88.9894 65.2585 88.9827 65.2568 88.9794 65.2551C88.976 65.2531 88.9694 65.2515 88.966 65.2498C88.8388 65.2014 88.7083 65.153 88.5677 65.153C88.5242 65.153 88.4807 65.1577 88.4372 65.1681C88.3903 65.1791 88.3435 65.1964 88.2967 65.2218C88.2933 65.2231 88.2899 65.2244 88.2866 65.2261C88.2866 65.2271 88.2833 65.2284 88.2799 65.2294C88.2799 65.2308 88.2766 65.2324 88.2732 65.2338C88.2632 65.2394 88.2531 65.2458 88.2431 65.2524C88.2364 65.6719 88.2263 66.0906 88.2197 66.5117C88.1259 66.5327 88.0356 66.5417 87.9486 66.5417ZM87.2471 61.8017L87.2431 61.793C87.2444 61.7957 87.2461 61.7984 87.2474 61.801C87.2474 61.8014 87.2474 61.8017 87.2471 61.8017Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M76.7414 87.4353C76.3093 87.3038 75.8769 87.1724 75.4445 87.0406C74.423 86.6272 74.0318 85.4934 73.4056 84.6278C73.4083 84.6262 73.411 84.6245 73.4137 84.6228C73.411 84.6245 73.4083 84.6262 73.4056 84.6278C73.4083 84.6262 73.411 84.6245 73.4137 84.6228L73.4056 84.6278C73.4063 84.6062 73.4066 84.5851 73.4066 84.5641C73.4076 84.0449 73.2433 83.6275 72.908 83.3149C72.913 83.3109 72.918 83.3072 72.9227 83.3035C73.3283 82.9955 73.7457 82.8611 74.166 82.8601C74.1677 82.8601 74.1694 82.8601 74.171 82.8601C74.1714 82.8601 74.172 82.8601 74.1727 82.8601C74.3096 82.8601 74.4468 82.8744 74.584 82.9015C74.8551 83.3779 74.8247 84.0583 75.4833 84.161C76.0596 84.2508 76.5971 84.5247 77.152 84.7173C77.2166 84.7903 77.2517 84.8814 77.2517 84.9632C77.2514 85.0473 77.2136 85.1213 77.1319 85.1544C77.1303 85.155 77.1286 85.1554 77.1273 85.156C77.0573 85.1834 76.984 85.1907 76.9091 85.1911C76.9084 85.1911 76.9077 85.1911 76.907 85.1911C76.9064 85.1911 76.9054 85.1911 76.9044 85.1911C76.8602 85.1907 76.8153 85.1884 76.7702 85.1857C76.7444 85.1841 76.7186 85.1827 76.6929 85.1817C76.6758 85.1811 76.6584 85.1804 76.6413 85.1804C76.6383 85.1804 76.6356 85.1804 76.6326 85.1804C76.6313 85.1804 76.6296 85.1804 76.6279 85.1804C76.5888 85.1804 76.5499 85.1827 76.5114 85.1884C76.5027 85.1897 76.4937 85.1914 76.485 85.1931C76.0837 85.2718 75.8665 85.5838 75.8679 86.0966C75.8679 86.1173 75.8682 86.1387 75.8689 86.16C75.8736 86.2875 76.0161 86.4036 76.1175 86.4924C76.1252 86.499 76.138 86.502 76.1534 86.5024C76.154 86.5024 76.1544 86.5024 76.155 86.5024C76.1631 86.5024 76.1714 86.5017 76.1804 86.5004C76.2317 86.4924 76.2952 86.4633 76.3187 86.4303C76.3197 86.429 76.3203 86.4276 76.3213 86.4263C76.411 86.2775 76.481 85.9662 76.5402 85.9645C77.2183 85.9432 77.8173 85.5137 78.4526 85.2818C78.4549 85.2812 78.4573 85.2802 78.4596 85.2795C78.4606 85.2792 78.462 85.2788 78.463 85.2785C78.4837 85.2721 78.5051 85.2692 78.5272 85.2692C78.5275 85.2692 78.5279 85.2692 78.5286 85.2692C78.5319 85.2692 78.5352 85.2691 78.5389 85.2695C78.5925 85.2715 78.6487 85.2882 78.7056 85.3078C78.7618 85.3272 78.8184 85.3492 78.8733 85.3619C78.8759 85.3626 78.8786 85.3632 78.8813 85.3639C78.7033 85.9602 78.224 86.2725 77.89 86.7216C77.4291 86.757 77.0422 86.9842 76.7414 87.4353Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M100.111 79.8308C99.4147 79.2709 99.1837 78.683 99.6021 77.9836C100.004 77.3156 100.235 76.739 99.9535 76.0434C99.6992 75.4161 100.248 74.9009 100.332 74.314C100.348 74.1992 100.72 74.0557 100.931 74.0137C100.958 74.0083 100.984 74.0057 101.008 74.0057C101.212 74.0057 101.336 74.1789 101.352 74.4384C101.362 74.6069 101.332 74.7838 101.326 74.9563C101.312 75.3296 101.409 75.634 101.724 75.7484C102.203 75.9242 102.695 76.0767 103.089 76.2092C103.176 76.3971 103.247 76.4721 103.23 76.5245C103.136 76.8478 103.022 77.1662 102.895 77.5442C103.163 77.5916 103.371 77.6086 103.565 77.667C103.826 77.7451 103.866 77.9412 103.675 78.2095C103.575 78.3516 103.468 78.4861 103.361 78.6243C103.354 78.6233 103.347 78.6223 103.34 78.6209C103.334 78.6199 103.33 78.6192 103.324 78.6182C103.253 78.6049 103.18 78.5825 103.106 78.5625C103.026 78.5402 102.942 78.5205 102.865 78.5195C102.862 78.5195 102.862 78.5195 102.859 78.5195C102.812 78.5195 102.768 78.5268 102.725 78.5445V78.5449C102.721 78.5462 102.718 78.5472 102.718 78.5482C102.715 78.5499 102.708 78.5515 102.705 78.5532C102.544 78.6263 102.4 78.6583 102.269 78.6586C102.269 78.6586 102.269 78.6586 102.266 78.6586H102.263C101.834 78.6556 101.553 78.3106 101.262 77.972C101.262 77.9696 101.259 77.9676 101.259 77.9656C101.249 77.9536 101.235 77.9416 101.225 77.9299C101.225 77.9289 101.225 77.9282 101.225 77.9272C101.222 77.9249 101.222 77.9226 101.219 77.9202C101.215 77.9189 101.212 77.9179 101.209 77.9166C101.205 77.9159 101.205 77.9149 101.202 77.9142C101.199 77.9132 101.195 77.9122 101.195 77.9112C101.188 77.9099 101.185 77.9082 101.182 77.9069C101.178 77.9056 101.175 77.9045 101.172 77.9035C101.034 77.8548 100.901 77.8148 100.767 77.8145C100.763 77.8145 100.763 77.8145 100.763 77.8145H100.76C100.576 77.8155 100.395 77.8932 100.225 78.1284C100.225 78.1318 100.221 78.1351 100.218 78.1384C100.158 78.3123 100.094 78.4861 100.034 78.6596C100.004 78.9472 100.084 79.1661 100.285 79.3106C100.228 79.4841 100.171 79.6576 100.111 79.8308ZM101.138 76.8141C101.135 76.8141 101.135 76.8141 101.135 76.8141C100.924 76.8148 100.837 77.0057 100.978 77.1161C101.125 77.2299 101.339 77.2396 101.53 77.2796C101.55 77.2799 101.593 77.1818 101.613 77.1501C101.56 76.8458 101.339 76.8141 101.138 76.8141Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M84.3149 85.9888C83.7443 85.7856 83.1737 85.5824 82.603 85.3788C82.7145 85.1613 82.8169 84.9374 82.9387 84.7272C83.092 84.4629 83.1777 84.3168 83.1783 84.1986C83.179 84.0515 83.0475 83.9481 82.751 83.7142C82.7931 83.5537 82.8373 83.3935 82.8838 83.2344C82.8835 83.2337 82.8835 83.2334 82.8832 83.2327C83.4223 83.0315 84.0194 83.1306 84.4986 82.6151C84.8895 82.3718 85.2808 82.1289 85.6717 81.886C85.7399 81.9137 85.8256 81.9207 85.8728 81.9735C86.0161 82.1346 86.241 82.2911 86.2554 82.4906C86.2564 82.5013 86.2567 82.512 86.2567 82.522C86.256 82.7746 86.0151 82.9134 85.7831 82.9578C85.7821 82.9581 85.7811 82.9584 85.7798 82.9584C85.7761 82.9591 85.7724 82.9598 85.7687 82.9604C85.7383 82.9648 85.7071 82.9661 85.6757 82.9661C85.6744 82.9661 85.6734 82.9661 85.672 82.9661C85.6707 82.9661 85.6697 82.9661 85.6683 82.9661C85.662 82.9661 85.6556 82.9661 85.6496 82.9661C85.6419 82.9661 85.6342 82.9658 85.6268 82.9658C85.6111 82.9654 85.5957 82.9651 85.58 82.9651C85.4344 82.9651 85.2831 82.9878 85.1432 83.24C85.1419 83.2427 85.1405 83.245 85.1392 83.2474C85.1379 83.25 85.1362 83.2527 85.1348 83.2554C85.1332 83.2584 85.1315 83.2614 85.1298 83.2647C85.1268 83.2711 85.1235 83.2774 85.1201 83.2841C85.6339 83.6805 86.2985 83.7225 86.8625 83.9945C86.9505 84.2047 87.0385 84.4149 87.1265 84.6248C87.0713 84.8019 87.0158 84.9788 86.9605 85.1559C86.9555 85.164 86.9508 85.1716 86.9458 85.1796C86.7985 85.4112 86.6058 85.5243 86.3698 85.5253C86.3688 85.5253 86.3678 85.5253 86.3668 85.5253C86.3668 85.5253 86.3665 85.5253 86.3661 85.5253L86.3641 85.5226C86.3645 85.5083 86.3645 85.4943 86.3648 85.4809C86.3661 85.251 86.3233 85.1319 86.2336 85.1299C86.2329 85.1299 86.2319 85.1299 86.2313 85.1299C86.2293 85.1299 86.2269 85.1299 86.2246 85.1303C86.1663 85.1336 86.0897 85.1836 85.9936 85.2814C85.9809 85.2941 85.9679 85.3078 85.9545 85.3224C85.9535 85.3234 85.9525 85.3248 85.9515 85.3258C85.9491 85.3284 85.9464 85.3315 85.9438 85.3345C85.9421 85.3361 85.9404 85.3381 85.9384 85.3401C85.6617 85.2764 85.3849 85.2127 85.1081 85.1486C84.9739 85.1032 84.8444 85.0311 84.7051 85.0178C84.6894 85.0165 84.6737 85.0155 84.6586 85.0155C84.6583 85.0155 84.6583 85.0155 84.6579 85.0155C84.6563 85.0155 84.6546 85.0155 84.6526 85.0155C84.4357 85.0181 84.3176 85.1773 84.3085 85.4519C84.3029 85.6197 84.3028 85.7872 84.3008 85.9547L84.3149 85.9888Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M52.7923 88.6877C51.7043 88.6877 50.64 88.6127 49.6109 88.2266C48.8733 87.95 48.0305 87.9624 47.2354 87.8452C47.7504 87.1239 48.4422 87.2113 49.065 87.1175C49.1182 87.0014 49.1591 86.9313 49.1832 86.8559C49.1839 86.8536 49.1849 86.8509 49.1855 86.8486C49.1879 86.8409 49.1905 86.8332 49.1929 86.8259C49.3867 86.2296 49.5798 85.952 49.8669 85.9487C49.8686 85.9487 49.8703 85.9487 49.872 85.9487C49.873 85.9487 49.8736 85.9487 49.8746 85.9487C49.9767 85.9493 50.0905 85.9841 50.22 86.0511C50.2247 86.0535 50.2294 86.0558 50.2341 86.0585C50.2401 86.0615 50.2458 86.0648 50.2518 86.0678C50.2551 86.0698 50.2588 86.0718 50.2625 86.0738C50.6357 86.281 50.9406 86.633 51.3191 86.8249C51.3198 86.8256 51.3208 86.8259 51.3214 86.8262C51.3221 86.8266 51.3228 86.8269 51.3235 86.8272C51.3241 86.8272 51.3245 86.8276 51.3251 86.8279C51.3255 86.8279 51.3255 86.8279 51.3258 86.8282C51.3415 86.8346 51.3586 86.8376 51.377 86.8379C51.3773 86.8379 51.3777 86.8379 51.3777 86.8379C51.3964 86.8379 51.4165 86.8349 51.4376 86.8296C51.4399 86.8289 51.4423 86.8282 51.4446 86.8276C51.4647 86.8222 51.4858 86.8146 51.5075 86.8052C51.5089 86.8049 51.5105 86.8042 51.5119 86.8035C51.6293 86.7535 51.7669 86.6597 51.8874 86.6027C51.8974 86.598 51.9075 86.5937 51.9172 86.5893C52.198 86.6687 52.4784 86.7485 52.7592 86.8282L52.7769 86.8953C52.8352 87.1185 52.8355 87.4131 52.9634 87.5503C53.1367 87.7365 53.209 87.9357 53.2094 88.1529C53.2097 88.319 53.1675 88.4959 53.0959 88.6861C52.9945 88.6871 52.8934 88.6877 52.7923 88.6877Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M49.8198 49.1812C49.8195 49.1812 49.8195 49.1812 49.8191 49.1812C49.8064 49.1812 49.794 49.1798 49.782 49.1778C49.1969 49.0697 48.6273 48.8882 48.0631 48.7003C43.6748 47.2386 39.2888 45.7688 34.9025 44.3016C34.7636 44.2482 34.6234 44.1985 34.4822 44.1518C34.5397 43.9783 34.5973 43.8051 34.6549 43.632C36.3313 44.2025 38.002 44.7901 39.6854 45.3397C42.9863 46.4177 46.2953 47.4731 49.5989 48.5438C49.878 48.6343 50.1421 48.7697 50.4135 48.8842C50.3981 48.8915 50.3827 48.8999 50.3673 48.9086C50.367 48.9086 50.3663 48.9089 50.366 48.9092C50.3097 48.9406 50.2519 48.9783 50.194 49.0153C50.1866 49.02 50.1796 49.0243 50.1722 49.029C50.1675 49.032 50.1628 49.035 50.1581 49.038C50.0581 49.1014 49.9594 49.1591 49.87 49.1761C49.8529 49.1791 49.8362 49.1812 49.8198 49.1812Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M89.5716 87.53C89.4343 87.53 89.3072 87.4303 89.2302 87.2221C89.0963 86.8527 88.9624 86.6111 88.7114 86.6111C88.5909 86.6111 88.4403 86.6668 88.2496 86.7906C87.8078 87.0769 87.3523 87.139 86.8938 87.139C86.614 87.139 86.3339 87.116 86.0564 87.1063C85.6762 87.0933 85.5712 86.5481 85.869 86.1186C86.0169 85.9054 86.1993 85.7222 86.366 85.5254C86.3663 85.5254 86.3667 85.5254 86.3667 85.5254C86.3677 85.5254 86.3687 85.5254 86.3697 85.5254C86.6056 85.5244 86.7984 85.4113 86.9457 85.1797C86.9507 85.1717 86.9554 85.164 86.9604 85.156C86.9681 85.1583 86.9758 85.161 86.9835 85.1637C86.9875 85.165 86.9919 85.1664 86.9959 85.1677C86.9986 85.1687 87.0012 85.1697 87.0036 85.1704C87.0079 85.172 87.0126 85.1737 87.017 85.175C87.0277 85.1787 87.0384 85.1827 87.0494 85.1864C87.5735 85.3726 88.0789 85.6438 88.6713 85.6448C88.6713 85.6448 88.6713 85.6448 88.6746 85.6448C88.7148 85.6448 88.7583 85.6435 88.7985 85.6408C88.8018 85.6405 88.8018 85.6405 88.8018 85.6405C88.8051 85.6402 88.8085 85.6402 88.8085 85.6398C88.8152 85.6395 88.8219 85.6392 88.8286 85.6385C88.9691 85.1493 89.1064 84.6692 89.2436 84.189C89.4511 84.455 89.6619 84.7206 89.8694 84.9862C89.8728 84.9969 89.8728 85.0072 89.8728 85.0175C89.9129 85.2855 90.0401 85.3465 90.1974 85.3469C90.1974 85.3469 90.1974 85.3469 90.2007 85.3469C90.2878 85.3465 90.3848 85.3285 90.4785 85.3168C90.4819 85.3165 90.4852 85.3162 90.4852 85.3158C90.4919 85.3155 90.4953 85.3152 90.4986 85.3148C90.502 85.3142 90.5053 85.3138 90.5087 85.3135C90.5555 85.3085 90.6023 85.3061 90.6459 85.3058H90.6492C91.0542 85.3078 91.3286 85.5244 91.3989 86.0349C91.3989 86.0436 91.4022 86.0526 91.4022 86.0616C91.1981 86.1837 90.9973 86.3058 90.7931 86.4279C90.3614 86.5264 90.1941 86.9698 89.9364 87.3065C89.8226 87.4533 89.692 87.53 89.5716 87.53Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M3.48755 65.7922C3.53373 64.3628 4.19873 63.0718 4.55316 61.7112C4.59633 61.5463 4.6944 61.3865 4.78845 61.2424C5.54415 60.0879 6.30486 58.9374 7.06391 57.7859C7.24163 57.8727 7.41967 57.9598 7.59739 58.0465C7.54551 58.2154 7.48393 58.3802 7.41264 58.5413C6.88051 58.8847 6.68104 59.0272 6.68171 59.3298C6.68205 59.5023 6.74765 59.7272 6.85374 60.0715C6.70481 60.7522 6.36577 61.3001 5.9491 61.838C5.76737 62.0725 5.63617 62.3531 5.63684 62.6351C5.63718 62.8149 5.6914 62.9951 5.81992 63.1643C5.56523 63.4596 5.31053 63.7549 5.05584 64.0502C4.41661 64.0622 4.39251 64.0565 4.28542 64.6184C4.18133 65.1646 4.06788 65.6701 3.48755 65.7922Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M92.0382 74.272C91.7437 74.1405 91.4224 73.9784 91.4224 73.5927C91.4224 73.5453 91.4257 73.4945 91.4391 73.4402C91.4659 73.295 91.4793 73.1652 91.4793 73.0484C91.4759 72.4538 91.1312 72.2049 90.6124 72.0741C90.4083 72.0224 90.2108 71.941 90.01 71.8733C90.0669 71.7031 90.1272 71.5319 90.1807 71.3604C90.1874 71.3604 90.1908 71.3604 90.1974 71.3604H90.2008C90.4317 71.3594 90.6191 71.247 90.7597 71.0107C90.763 71.0061 90.7664 71.0017 90.7697 70.9974C90.83 70.8286 90.8936 70.66 90.9572 70.4919C91.0877 70.5196 91.2182 70.5456 91.3521 70.5696C91.4425 70.8059 91.5362 71.0421 91.6265 71.2777C91.9311 71.3778 92.2356 71.5136 92.5435 71.5136C92.7979 71.5136 93.0523 71.4235 93.3167 71.1492C93.2899 70.8509 93.2631 70.5553 93.2296 70.2009C93.7283 70.2306 94.1634 70.2563 94.5817 70.2814C94.8127 70.9373 94.0362 71.7028 94.6085 72.27C94.3575 72.5726 94.1098 72.8753 93.8588 73.1776L93.8521 73.1889C93.6915 73.1439 93.5308 73.0988 93.3702 73.0538C93.2531 72.9824 93.1292 72.9337 92.9953 72.9076C92.7945 72.957 92.5837 72.9684 92.3996 73.0645C92.2055 73.1642 92.0817 73.2983 92.0817 73.4602C92.0817 73.5543 92.1252 73.6577 92.2222 73.7691C92.1553 73.9346 92.0951 74.1025 92.0382 74.272Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M105.69 75.8794C105.67 75.8794 105.65 75.8784 105.63 75.8761C104.689 75.7693 103.679 75.8277 103.053 74.9144C103.13 74.3856 103.19 73.8741 103.28 73.3663C103.357 72.9368 103.521 72.731 103.792 72.731C103.926 72.731 104.087 72.7817 104.281 72.8811C104.408 72.9482 104.539 73.0139 104.663 73.087C104.783 73.156 104.897 73.2334 105.011 73.3075C105.144 73.9021 104.582 74.2378 104.489 74.747C104.776 74.9308 104.997 75.0256 105.171 75.0256C105.422 75.0256 105.573 74.8297 105.673 74.4203C105.757 74.084 105.76 73.7309 105.844 73.3953C105.894 73.1994 106.118 73.08 106.326 73.08C106.433 73.08 106.537 73.1116 106.61 73.181C106.721 73.2845 106.821 73.4033 106.918 73.5254C107.079 73.7316 107.099 73.9745 106.868 74.172C106.543 74.4493 106.229 74.6979 106.225 75.2264C106.222 75.6278 105.988 75.8794 105.69 75.8794Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M12.8224 78.769C11.5992 78.0834 10.3726 77.4037 9.15737 76.7017C9.05128 76.6406 9.01347 76.4421 8.94653 76.3026C8.94653 76.2993 8.94653 76.2962 8.94653 76.2932C9.67412 76.4454 10.3954 76.6256 11.131 76.7374C11.5068 76.7944 11.5092 77.1801 11.6916 77.405C11.6966 77.411 11.7019 77.4174 11.7076 77.4234C11.7726 77.4904 11.8823 77.5428 11.976 77.5482C11.9811 77.5485 11.9861 77.5485 11.9911 77.5485C11.9914 77.5485 11.9918 77.5485 11.9924 77.5485C12.0172 77.5485 12.0406 77.5445 12.0614 77.5368C12.0627 77.5362 12.0644 77.5355 12.0661 77.5348C12.1802 77.4868 12.3338 77.2755 12.3402 77.1444C12.3459 77.0346 12.3482 76.9249 12.3482 76.8154C12.3482 76.4871 12.3274 76.1601 12.3124 75.8334C12.31 75.7864 12.3084 75.7454 12.3084 75.7083C12.3084 75.43 12.4074 75.3893 13.1585 74.8868C13.4958 74.6613 13.7545 74.2349 14.1675 74.1998C14.1772 74.1988 14.1876 74.1985 14.198 74.1985C14.198 74.1985 14.1983 74.1985 14.1986 74.1985C14.1996 74.1985 14.2006 74.1985 14.2016 74.1985C14.3231 74.1995 14.4717 74.2566 14.5343 74.3493C14.5353 74.3507 14.536 74.352 14.537 74.3533C14.539 74.3567 14.541 74.36 14.543 74.3633C14.5705 74.4127 14.5845 74.4951 14.5845 74.5795C14.5845 74.6813 14.5641 74.7857 14.5226 74.8368C14.3077 75.1027 14.0504 75.3289 13.7947 75.5442C13.4533 75.8308 13.2214 76.2155 13.2227 76.6439C13.2227 76.6613 13.223 76.6786 13.2241 76.6963C13.2284 76.7957 13.2311 76.8942 13.2311 76.992C13.2314 77.6096 13.131 78.1968 12.8224 78.769Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M58.7568 89.9666C57.5142 89.5945 56.2722 89.2221 55.0295 88.8498C54.8501 88.7447 54.6704 88.6396 54.491 88.5348C54.5185 88.4654 54.5299 88.405 54.5299 88.3523C54.5295 88.1864 54.4131 88.091 54.2912 87.9992C54.2568 87.6132 54.2223 87.2272 54.1885 86.8414C54.39 86.9252 54.6768 86.9352 54.7779 87.1057C54.7792 87.108 54.7805 87.1104 54.7819 87.1124C54.7866 87.1204 54.7912 87.1284 54.7963 87.1361C55.0941 87.6216 55.4753 87.78 55.9004 87.781C55.902 87.781 55.9041 87.781 55.9057 87.781C56.1788 87.781 56.4703 87.7166 56.7692 87.6326C57.305 87.8051 57.8412 87.9776 58.3773 88.1497L58.5657 88.2622C58.5614 88.3026 58.5594 88.3406 58.559 88.3763C58.559 88.7994 58.8502 88.9242 59.1437 89.039C59.464 89.1644 59.7729 89.2962 59.8054 89.7657C59.6682 89.7246 59.5313 89.6959 59.3951 89.6956C59.3941 89.6956 59.3931 89.6956 59.3917 89.6956C59.3901 89.6956 59.3884 89.6956 59.3867 89.6956C59.1842 89.6966 58.9841 89.7607 58.788 89.9378C58.787 89.9385 58.786 89.9395 58.7853 89.9402C58.7826 89.9425 58.7803 89.9445 58.7779 89.9469C58.7762 89.9482 58.7746 89.9499 58.7729 89.9515C58.7676 89.9565 58.7622 89.9615 58.7568 89.9666ZM59.8285 89.773C59.8215 89.7707 59.8141 89.7684 59.807 89.7664C59.8141 89.7684 59.8215 89.7707 59.8285 89.773Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M102.872 90.3362C102.869 90.3362 102.865 90.3362 102.865 90.3362C102.253 90.3242 101.657 90.2034 101.239 89.7339C100.978 89.441 100.707 89.3025 100.375 89.3025C100.271 89.3025 100.161 89.3162 100.044 89.3429C100.014 89.3495 99.9836 89.3525 99.9568 89.3525C99.7594 89.3525 99.572 89.2091 99.5887 88.9702C99.6021 88.7479 99.7828 88.5084 99.91 88.2915C100 88.1417 100.124 88.0179 100.235 87.8824C100.382 87.9285 100.532 87.9752 100.683 88.0212C100.777 88.0029 100.871 87.9949 100.961 87.9949C101.309 87.9949 101.634 88.117 101.958 88.2391C102.283 88.3615 102.607 88.4837 102.966 88.4837C103.049 88.4837 103.14 88.4767 103.23 88.461C103.247 88.4573 103.267 88.4557 103.287 88.4557C103.668 88.4557 103.933 89.1463 103.792 89.6081C103.689 89.9495 103.2 90.3362 102.872 90.3362Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M83.2762 89.0703C83.132 89.0186 82.9881 88.9669 82.8442 88.9148C82.8204 88.5248 82.7966 88.1344 82.7732 87.744C82.7357 87.2325 82.7565 86.6993 82.5031 86.2528C82.14 86.3513 81.7698 86.5398 81.4221 86.5398C81.1537 86.5398 80.899 86.4277 80.6711 86.0747C80.481 85.7797 80.0278 85.728 79.6948 85.5652C79.7574 85.4274 79.8167 85.2879 79.8722 85.1464C80.3746 85.2855 80.8809 85.412 81.3779 85.5678C81.4629 85.5942 81.5459 85.6072 81.6273 85.6075C81.6279 85.6075 81.6289 85.6075 81.6296 85.6075C81.6306 85.6075 81.6313 85.6075 81.6323 85.6075C81.8321 85.6069 82.0222 85.5298 82.211 85.3937C82.2113 85.3937 82.2113 85.3933 82.2116 85.3933C82.218 85.389 82.224 85.3843 82.23 85.3797C82.2327 85.378 82.2354 85.376 82.238 85.374C82.2417 85.371 82.2454 85.3683 82.2491 85.3656C82.2638 85.3693 82.2789 85.3723 82.2939 85.3753C82.3465 85.3853 82.4 85.3903 82.4539 85.3903C82.4549 85.3903 82.4563 85.3903 82.4573 85.3903C82.4583 85.3903 82.4593 85.3903 82.4603 85.3903C82.4803 85.3903 82.5005 85.3897 82.5205 85.3883C82.5312 85.3877 82.5416 85.3866 82.5523 85.3856C82.569 85.3836 82.5861 85.3817 82.6029 85.379C83.1735 85.5825 83.7441 85.7857 84.3147 85.9889C84.3632 86.7707 84.4118 87.5518 84.4603 88.3332C84.4469 88.3316 84.4339 88.3302 84.4212 88.3286C84.4172 88.3282 84.4134 88.3279 84.4098 88.3272C84.4091 88.3272 84.4081 88.3272 84.4071 88.3269C84.3987 88.3259 84.3907 88.3252 84.3827 88.3242C84.2327 88.3066 84.1149 88.2942 84.0179 88.2935C84.0158 88.2935 84.0142 88.2935 84.0125 88.2935C84.0122 88.2935 84.0115 88.2935 84.0112 88.2935C83.6849 88.2942 83.5982 88.4347 83.3204 88.9832C83.3187 88.9859 83.3174 88.9889 83.316 88.9916C83.3147 88.9946 83.313 88.9972 83.3117 88.9999C83.306 89.0113 83.3003 89.0226 83.2946 89.0343C83.2886 89.046 83.2826 89.058 83.2762 89.0703Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M106.055 91.4651C106.005 91.4651 105.954 91.4604 105.904 91.4507C105.272 91.334 105.081 91.0664 105.124 90.2749C105.158 89.682 105.124 89.1141 105.733 88.693C106.115 88.4291 106.068 88.324 105.446 87.9029C105.502 87.7307 105.563 87.5592 105.623 87.3874C105.944 87.2906 106.266 87.2292 106.577 87.2292C106.891 87.2292 107.199 87.2919 107.494 87.4438C107.38 87.7864 107.263 88.1294 107.146 88.4721C106.804 88.5572 106.577 88.7884 106.66 89.1858C106.707 89.4127 106.905 89.5745 107.015 89.7807C107.166 90.061 107.306 90.371 107.049 90.712C106.771 91.0804 106.496 91.4651 106.055 91.4651Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M90.9741 67.6167C90.8034 67.4435 90.7599 67.2203 90.7599 66.9797C90.7599 66.7365 90.8034 66.4756 90.8034 66.2307C90.8034 65.9844 90.7599 65.7542 90.5825 65.5747C90.5759 65.5677 90.5725 65.5553 90.5725 65.5383C90.5725 65.4522 90.6495 65.2537 90.7064 65.1369C90.8469 64.8326 91.0109 64.5397 91.1649 64.242C91.4426 64.3341 91.7204 64.4262 91.9982 64.518C91.9715 64.6858 91.9346 64.8536 91.9179 65.0211C91.9145 65.0331 91.9146 65.0448 91.9146 65.0565C91.8945 65.3198 91.9949 65.5019 92.2258 65.5036C92.2291 65.5036 92.2325 65.5036 92.2358 65.5033C92.3563 65.5009 92.5538 65.4075 92.6073 65.2957C92.7914 64.914 92.9487 64.5126 93.0725 64.1066C93.1127 63.9744 93.1328 63.8566 93.1328 63.7519C93.1328 63.3595 92.8751 63.1443 92.5337 63.0035C92.8517 62.5323 93.3369 62.2033 93.4842 61.5861C93.9695 62.0629 94.0632 62.6795 93.7988 63.4256C93.7051 63.7949 93.4976 64.1706 93.4976 64.535C93.5009 64.7192 93.5545 64.9007 93.7017 65.0768C93.1964 65.6678 92.6943 66.2587 92.1923 66.8496C92.1856 66.8493 92.1823 66.849 92.179 66.8486C92.0217 66.8379 91.8978 66.8296 91.7941 66.8293H91.7907C91.3824 66.8296 91.3088 66.9617 90.9842 67.598C90.9808 67.6017 90.9808 67.605 90.9775 67.6087C90.9775 67.6114 90.9741 67.614 90.9741 67.6167Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M98.0223 65.2158C97.2057 65.2128 96.3958 65.1815 95.5859 65.1548C95.5892 65.0733 95.5926 64.9933 95.5926 64.9142C95.5926 64.0924 95.2847 63.4017 95.0203 62.694C95.3047 62.5795 95.5993 62.4851 95.8771 62.3467C96.108 62.2322 96.2954 62.1778 96.4393 62.1778C96.774 62.1778 96.8777 62.4751 96.8108 63.004C96.7673 63.3326 96.7773 63.6897 96.8577 63.989C96.8945 64.1301 96.9748 64.1935 97.0718 64.1935C97.1655 64.1935 97.276 64.1351 97.3764 64.0317C97.7144 64.1882 98.0725 64.3283 98.1495 64.8024C98.1528 64.8118 98.1529 64.8225 98.1529 64.8338C98.1529 64.9676 98.0491 65.2158 98.0223 65.2158ZM95.5825 65.1618V65.1548C95.5825 65.1548 95.5825 65.1548 95.5859 65.1548C95.5859 65.1571 95.5825 65.1594 95.5825 65.1618Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M39.5194 87.4062C39.5117 87.4062 39.5043 87.4059 39.497 87.4049C38.1137 87.2281 36.7352 87.0249 35.3543 86.8363C34.6987 86.7469 34.027 86.7256 33.3867 86.5804C32.5336 86.3869 31.704 86.103 30.8643 85.8577C30.9225 85.6862 30.9811 85.5147 31.0393 85.3432C31.0564 85.3479 31.0734 85.3525 31.0902 85.3576C31.138 85.3709 31.1856 85.3852 31.2334 85.4003C31.2368 85.4016 31.2405 85.4026 31.2441 85.4036C31.2475 85.4046 31.2508 85.4059 31.2542 85.4069C31.2615 85.4093 31.2692 85.4116 31.2766 85.4139C31.283 85.4159 31.289 85.4179 31.2954 85.42C31.9319 85.6255 32.5634 85.9188 33.2124 85.9201C33.2137 85.9201 33.215 85.9201 33.2167 85.9201H33.2171C33.2546 85.9201 33.2917 85.9191 33.3292 85.9171C33.4055 85.9128 33.4815 85.9108 33.5561 85.9108C33.5564 85.9108 33.5567 85.9108 33.5571 85.9108C33.5587 85.9108 33.5608 85.9108 33.5628 85.9108C34.269 85.9118 34.9058 86.0856 35.5595 86.2508C35.5949 86.2598 35.6308 86.2685 35.6662 86.2775C35.6716 86.2788 35.6766 86.2801 35.6816 86.2811C35.7399 86.2945 35.7971 86.3011 35.8533 86.3011C35.8536 86.3011 35.8543 86.3011 35.855 86.3011C35.856 86.3011 35.857 86.3011 35.8577 86.3011C36.0829 86.3005 36.2914 86.1967 36.4902 86.0179C36.4926 86.0159 36.4949 86.0139 36.4972 86.0119C36.516 86.0262 36.535 86.0419 36.5538 86.0586C36.5571 86.0612 36.5601 86.0642 36.5632 86.0669C36.5776 86.0796 36.5916 86.0929 36.606 86.1063C36.7874 86.2785 36.9678 86.505 37.1505 86.507C37.1515 86.507 37.1522 86.507 37.1532 86.507H37.1535C37.1622 86.507 37.1709 86.5064 37.1796 86.5054C37.275 86.4937 37.3687 86.4883 37.4608 86.4883C37.4611 86.4883 37.4611 86.4883 37.4614 86.4883C37.4624 86.4883 37.4638 86.4883 37.4648 86.4883C38.1047 86.4893 38.6716 86.7479 39.257 86.9328C39.419 86.9842 39.5826 87.0299 39.7496 87.0626C39.759 87.0646 39.7687 87.0666 39.7784 87.0683C39.7788 87.0683 39.7787 87.0683 39.7791 87.0683C39.7791 87.0686 39.7791 87.0686 39.7791 87.0686C39.7908 87.0706 39.8029 87.0729 39.8146 87.0749C39.838 87.0789 39.8614 87.0829 39.8848 87.0863L39.9223 87.2297C39.7881 87.2881 39.6425 87.4062 39.5194 87.4062Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M7.5972 58.0464C7.41948 57.9596 7.24143 57.8726 7.06372 57.7858C7.0664 56.5659 7.47838 55.5152 8.26387 54.594C8.83015 53.9303 9.36429 53.23 9.91283 52.5456C10.0574 52.6017 10.2017 52.6574 10.3462 52.7131C9.74884 53.4371 9.54235 54.3057 9.44462 55.2142L9.44294 55.2086C9.43022 55.2062 9.41785 55.2042 9.40547 55.2019C9.4048 55.2019 9.40413 55.2019 9.40346 55.2016C9.39409 55.1999 9.38471 55.1983 9.37533 55.1966C9.26389 55.1766 9.15278 55.1559 9.04401 55.1555C9.043 55.1555 9.042 55.1555 9.041 55.1555C9.03933 55.1555 9.03765 55.1555 9.03631 55.1555C8.84186 55.1565 8.65678 55.2246 8.49882 55.4808C8.49815 55.4815 8.49781 55.4825 8.49748 55.4832C8.49513 55.4865 8.49313 55.4902 8.49079 55.4939C8.49079 55.4942 8.49078 55.4942 8.49045 55.4945C8.48677 55.5009 8.48308 55.5072 8.4794 55.5136C8.36528 55.7131 8.30538 55.9039 8.30471 56.0848C8.30404 56.2776 8.36997 56.4592 8.50852 56.628V56.6283C8.45732 56.8058 8.40645 56.984 8.35558 57.1618C8.19594 57.5642 8.05771 57.9917 7.5972 58.0464Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M69.1475 89.342C68.9845 89.342 68.8272 89.2746 68.6752 89.1191C68.4319 88.8696 68.1283 88.6971 67.8516 88.4905C67.8536 88.4625 67.8546 88.4351 67.8546 88.4088C67.8536 88.1519 67.7585 87.961 67.5594 87.8432C67.4332 87.7885 67.3074 87.7331 67.1819 87.6767C67.2344 87.5112 67.289 87.3467 67.3452 87.1829C67.457 86.8376 67.5691 86.4922 67.6809 86.1465C67.9516 86.1182 68.1521 85.961 68.2763 85.6641C68.3456 85.5373 68.4095 85.4075 68.4677 85.2743C68.6133 85.299 68.7492 85.3514 68.8744 85.4305C68.8797 85.9664 69.0457 86.3978 69.3931 86.7131L69.3938 86.7174C69.2455 87.1408 69.0725 87.5346 68.6234 87.6016C68.6234 87.6013 68.6234 87.601 68.6234 87.6003C68.6223 87.598 68.6213 87.5953 68.6203 87.593C68.6207 87.5533 68.6237 87.5119 68.6237 87.4722C68.6237 87.4388 68.6213 87.4068 68.6133 87.3774C68.6016 87.3367 68.5417 87.3204 68.5032 87.293C68.5424 87.3931 68.5812 87.4929 68.6203 87.593C68.6203 87.596 68.6203 87.599 68.6203 87.6023C68.6213 87.602 68.6223 87.602 68.6234 87.6016C68.6521 87.984 68.793 88.1946 69.0765 88.1956C69.0775 88.1956 69.0782 88.1956 69.0788 88.1956C69.0795 88.1956 69.0798 88.1956 69.0802 88.1956C69.1411 88.1952 69.208 88.1859 69.282 88.1662C69.286 88.1652 69.29 88.1642 69.294 88.1629C69.4962 88.1075 69.7003 88.0695 69.9038 88.0237C69.8975 88.0695 69.8944 88.1128 69.8944 88.1549C69.8934 88.3801 69.9791 88.5533 70.1481 88.6757L70.1548 88.6927C69.9825 88.8546 69.8238 89.0498 69.6351 89.1709C69.4677 89.279 69.3051 89.342 69.1475 89.342Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M100.482 84.8503C100.542 84.3962 100.539 84.2157 100.593 84.0555C100.977 82.9284 101.138 82.6465 101.848 82.6465C102.018 82.6465 102.219 82.6625 102.463 82.6872C102.577 82.6989 102.755 82.8547 102.751 82.9608C102.745 83.3936 102.725 83.8427 102.617 84.2658C102.567 84.4676 102.313 84.7533 102.146 84.7789C101.627 84.8587 101.105 84.8323 100.482 84.8503Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M100.683 88.021C100.533 87.975 100.382 87.9282 100.235 87.8822C99.5419 87.717 99.0265 87.3894 99.0666 86.4021C99.08 86.0777 98.8759 85.7764 99.0733 85.363C99.1269 85.3583 99.1838 85.356 99.2373 85.356C99.91 85.356 100.502 85.7084 101.135 85.8975C101.393 85.9746 101.506 86.2966 101.346 86.4541C101.232 86.5689 101.091 86.6727 100.951 86.7294C100.884 86.7567 100.82 86.7687 100.76 86.7687C100.529 86.7687 100.348 86.5942 100.154 86.4768C100.144 86.4714 100.131 86.4691 100.118 86.4691C100.061 86.4691 99.977 86.5032 99.9669 86.5328C99.9167 86.6757 99.8398 86.8769 99.8866 86.9706C100.087 87.3814 100.683 87.3837 100.683 88.021Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M11.6879 53.5903C11.6872 53.5903 11.6866 53.5903 11.6859 53.5903C11.6461 53.59 11.6109 53.5827 11.5841 53.564C11.5838 53.5636 11.5835 53.5633 11.5831 53.563C11.5805 53.5613 11.5781 53.5593 11.5758 53.5573C11.4215 53.4238 11.2592 53.2323 11.216 53.0188C11.2147 53.0134 11.2137 53.0081 11.2123 53.0028C11.1471 52.7005 11.0149 52.6187 10.8576 52.617C10.8559 52.617 10.8542 52.617 10.8525 52.617C10.8499 52.617 10.8475 52.617 10.8448 52.617C10.7548 52.6184 10.6571 52.6444 10.559 52.6694C10.4874 52.6881 10.4154 52.7061 10.3465 52.7131C10.2019 52.6574 10.0577 52.6017 9.91309 52.5456C10.4031 51.4672 10.963 50.4462 11.7977 49.6494C11.7193 50.2317 11.6548 50.8106 11.6548 51.3758C11.6548 52.0685 11.7515 52.7402 12.0386 53.3705C12.0406 53.3748 12.0416 53.3805 12.0416 53.3875C12.0413 53.4355 11.9971 53.5373 11.976 53.541C11.9677 53.5426 11.959 53.5443 11.9503 53.546C11.9469 53.5466 11.9436 53.5473 11.9399 53.548C11.9369 53.5486 11.9335 53.5493 11.9302 53.55C11.9007 53.5563 11.87 53.5633 11.8392 53.57C11.8228 53.5733 11.8064 53.5767 11.7903 53.5797C11.7716 53.583 11.7531 53.5857 11.7351 53.5877C11.7321 53.588 11.7294 53.5883 11.7264 53.5883C11.7133 53.5897 11.7003 53.5903 11.6879 53.5903Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M105.446 87.9028C104.873 87.4427 104.241 87.2182 103.538 87.2182C103.357 87.2182 103.173 87.2332 102.982 87.2632C102.892 87.2772 102.798 87.2852 102.708 87.2852C102.581 87.2852 102.454 87.2692 102.336 87.2325C102.256 87.2078 102.229 86.9766 102.216 86.8298C102.206 86.7624 102.266 86.6289 102.32 86.5982C102.708 86.3793 103.11 86.2282 103.508 86.2282C103.625 86.2282 103.742 86.2412 103.856 86.2685C104.351 86.3873 104.84 86.5592 105.298 86.7864C105.459 86.8668 105.516 87.1801 105.623 87.3873C105.563 87.5592 105.502 87.7307 105.446 87.9028Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M76.1553 86.5022C76.1547 86.5022 76.1543 86.5022 76.1537 86.5022C76.1383 86.5019 76.1255 86.4989 76.1178 86.4922C76.0164 86.4034 75.8739 86.2873 75.8692 86.1598C75.8685 86.1385 75.8682 86.1171 75.8682 86.0965C75.8668 85.5836 76.0841 85.2716 76.4853 85.1929C76.494 85.1912 76.503 85.1895 76.5117 85.1882C76.5502 85.1825 76.5891 85.1802 76.6282 85.1802C76.6299 85.1802 76.6316 85.1802 76.6329 85.1802C76.6359 85.1802 76.6386 85.1802 76.6416 85.1802C76.6587 85.1802 76.6761 85.1809 76.6932 85.1815C76.7189 85.1826 76.7447 85.1839 76.7705 85.1856C76.8156 85.1882 76.8605 85.1906 76.9047 85.1909C76.9057 85.1909 76.9067 85.1909 76.9073 85.1909C76.908 85.1909 76.9087 85.1909 76.9094 85.1909C76.9843 85.1906 77.0576 85.1832 77.1276 85.1559C77.1289 85.1552 77.1306 85.1549 77.1322 85.1542C77.2139 85.1212 77.2517 85.0471 77.252 84.963C77.252 84.8812 77.2169 84.7901 77.1523 84.7171C77.2153 84.5599 77.2668 84.3988 77.3076 84.2346C77.6316 84.336 77.9552 84.4385 78.2792 84.5386C78.2832 84.5396 78.2869 84.5409 78.2906 84.5419C78.3843 84.5696 78.4766 84.5843 78.567 84.5846C78.568 84.5846 78.5687 84.5846 78.5694 84.5846C78.5714 84.5846 78.573 84.5846 78.575 84.5846C78.7896 84.5833 78.9944 84.5009 79.1882 84.323C79.1882 84.3227 79.1882 84.3227 79.1885 84.3227C79.2046 84.308 79.2203 84.2927 79.236 84.2767C79.238 84.2747 79.2397 84.273 79.2414 84.271C79.2431 84.2693 79.2447 84.2676 79.2464 84.2663C79.2488 84.2636 79.2514 84.261 79.2538 84.2583C79.4763 84.5059 79.6986 84.7538 79.9208 85.0014L79.8726 85.1462C79.817 85.2877 79.7578 85.4271 79.6952 85.5649C79.4238 85.4979 79.1527 85.4308 78.8816 85.3637C78.8789 85.3631 78.8762 85.3624 78.8736 85.3617C78.8187 85.349 78.7621 85.327 78.7059 85.3077C78.649 85.288 78.5928 85.2713 78.5392 85.2693C78.5355 85.269 78.5322 85.269 78.5289 85.269C78.5282 85.269 78.5279 85.269 78.5275 85.269C78.5054 85.269 78.484 85.272 78.4633 85.2783C78.4623 85.2786 78.4609 85.279 78.4599 85.2793C78.4576 85.28 78.4552 85.281 78.4529 85.2816C77.8177 85.5135 77.2186 85.943 76.5405 85.9643C76.4813 85.966 76.4113 86.2773 76.3217 86.4261C76.3206 86.4274 76.32 86.4288 76.319 86.4301C76.2955 86.4632 76.232 86.4922 76.1808 86.5002C76.1717 86.5015 76.1634 86.5022 76.1553 86.5022Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M74.8457 87.3398C74.5572 87.3398 74.2794 87.1753 73.9953 87.1073C73.9555 86.7082 73.7911 86.5227 73.4735 86.5227C73.4237 86.5227 73.3698 86.5274 73.3119 86.5364C73.1834 86.5567 73.0548 86.5627 72.9263 86.5627C72.7158 86.5627 72.5049 86.546 72.2944 86.5457C72.4671 86.0295 72.6398 85.5133 72.8125 84.9972C73.0103 84.874 73.2081 84.7509 73.4059 84.6278C74.0321 85.4933 74.4233 86.6271 75.4448 87.0405C75.2366 87.2661 75.0388 87.3398 74.8457 87.3398ZM73.9956 87.1129L73.9936 87.1069C73.9939 87.1073 73.9946 87.1073 73.9953 87.1073C73.9953 87.1093 73.9956 87.1109 73.9956 87.1129Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M30.7791 85.8579C29.4093 85.8579 28.1412 85.4198 26.8413 85.1175C26.852 85.1048 26.8631 85.0928 26.8741 85.0808C26.8758 85.0788 26.8778 85.0768 26.8795 85.0748C27.083 84.8576 27.2988 84.7835 27.5294 84.7829C27.5304 84.7829 27.5314 84.7829 27.5321 84.7829C27.5331 84.7829 27.5338 84.7829 27.5348 84.7829C27.6204 84.7832 27.7078 84.7932 27.7978 84.8099C27.8029 84.8109 27.8079 84.8119 27.8132 84.8129C27.8193 84.8139 27.8256 84.8152 27.8316 84.8165C27.8387 84.8179 27.8454 84.8192 27.8524 84.8206C27.8564 84.8216 27.8604 84.8222 27.8644 84.8232C28.0984 84.8719 28.3326 84.904 28.5659 84.9043C28.5666 84.9043 28.5673 84.9043 28.5676 84.9043C28.5689 84.9043 28.5703 84.9043 28.5713 84.9043C29.01 84.9036 29.4451 84.7888 29.8661 84.4538C29.8665 84.4535 29.8668 84.4532 29.8668 84.4532C29.8912 84.4338 29.9153 84.4138 29.9394 84.3931C30.4558 84.4902 30.6898 85.0011 31.0392 85.3431C30.9809 85.5146 30.9224 85.6861 30.8641 85.8576C30.836 85.8579 30.8076 85.8579 30.7791 85.8579Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M96.2854 78.5496C95.934 78.2222 95.7064 77.7131 95.1943 77.6213C95.2479 77.4438 95.3014 77.2666 95.355 77.0891C95.529 76.5756 95.6997 76.0621 95.8704 75.5489C96.8209 76.2356 96.9012 76.4365 96.6134 77.5456C96.5264 77.8852 96.3958 78.2152 96.2854 78.5496Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M101.781 82.0864C101.433 81.97 101.088 81.8676 100.753 81.7394C100.372 81.593 100.194 81.2733 100.292 80.7708C100.365 80.4028 100.302 80.0945 100.111 79.8305C100.171 79.6574 100.228 79.4838 100.285 79.3103C100.345 79.1418 100.402 78.9727 100.459 78.8032C100.599 78.8506 100.743 78.8979 100.887 78.9453C101.011 79.597 101.205 80.2346 101.235 80.9043C101.259 81.4521 102.032 81.3133 101.781 82.0864Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M91.4594 68.8496H91.456C91.3221 68.8493 91.1581 68.8183 90.954 68.7655C90.7867 68.7225 90.5591 68.6908 90.5591 68.4632C90.5591 68.4222 90.5658 68.3748 90.5825 68.3201C90.616 68.2116 90.8737 68.1923 90.9908 68.0765C91.0611 68.0071 91.0912 67.9317 91.0912 67.8576C91.0946 67.7712 91.0511 67.6868 90.9741 67.6167C90.9741 67.614 90.9774 67.6114 90.9774 67.6087C90.9808 67.6051 90.9808 67.6017 90.9841 67.598C91.3088 66.9617 91.3824 66.8296 91.7907 66.8293H91.7941C91.8978 66.8296 92.0216 66.838 92.1789 66.8486C92.1823 66.849 92.1856 66.8493 92.1923 66.8496C92.3195 66.915 92.4533 66.9714 92.5872 67.0178C92.4701 67.3591 92.3664 67.7068 92.2291 68.0395C92.2258 68.0445 92.2224 68.0495 92.2224 68.0545C92.2157 68.0675 92.2124 68.0805 92.2057 68.0935C91.9714 68.6447 91.8108 68.8489 91.4627 68.8496H91.4594Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M105.111 80.0452C104.83 80.0452 104.669 79.7392 104.475 79.531C104.428 79.4809 104.418 79.3852 104.371 79.2534C104.833 78.7152 105.308 78.1583 105.794 77.589C106.175 77.922 106.038 78.4649 106.031 78.9264C106.021 79.3908 105.747 79.7612 105.372 79.9681C105.275 80.0221 105.188 80.0452 105.111 80.0452Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M102.571 79.4397C102.457 79.4397 102.316 79.4034 102.122 79.3483C101.704 79.2318 101.295 79.081 100.887 78.9456C100.743 78.8982 100.599 78.8508 100.459 78.8034C100.318 78.7504 100.178 78.7026 100.034 78.6596C100.094 78.4861 100.158 78.3122 100.218 78.1384C100.224 78.1411 100.235 78.1434 100.241 78.1458C100.251 78.1484 100.258 78.1511 100.268 78.1538C100.268 78.1541 100.268 78.1541 100.268 78.1541C100.402 78.1958 100.536 78.2322 100.666 78.2325C100.67 78.2325 100.67 78.2325 100.67 78.2325H100.673C100.85 78.2318 101.028 78.1644 101.192 77.9549C101.195 77.9499 101.198 77.9452 101.202 77.9402C101.208 77.9336 101.212 77.9269 101.218 77.9202C101.222 77.9225 101.222 77.9249 101.225 77.9272C101.225 77.9282 101.225 77.9289 101.225 77.9299C101.235 77.9415 101.249 77.9536 101.259 77.9656C101.259 77.9676 101.262 77.9696 101.262 77.9719C101.553 78.3106 101.834 78.6556 102.263 78.6586H102.266C102.269 78.6586 102.269 78.6586 102.269 78.6586C102.4 78.6582 102.544 78.6262 102.704 78.5532C102.708 78.5515 102.714 78.5498 102.718 78.5482C102.718 78.5472 102.721 78.5462 102.725 78.5448V78.5445C102.768 78.5268 102.812 78.5194 102.858 78.5194C102.862 78.5194 102.862 78.5194 102.865 78.5194C102.942 78.5204 103.026 78.5401 103.106 78.5625C103.18 78.5825 103.253 78.6049 103.324 78.6182C103.33 78.6192 103.334 78.6199 103.34 78.6209C103.347 78.6222 103.354 78.6232 103.36 78.6242C102.965 79.2432 102.835 79.4397 102.571 79.4397Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M54.3411 89.0464C53.9067 89.0464 53.5065 88.8345 53.0958 88.686C53.1674 88.4958 53.2096 88.319 53.2093 88.1528C53.2089 87.9356 53.1366 87.7364 52.9633 87.5502C52.8354 87.4131 52.8351 87.1185 52.7769 86.8952C53.2471 86.8772 53.718 86.8592 54.1882 86.8415C54.222 87.2272 54.2565 87.6133 54.2909 87.9993C54.0992 88.1451 54.0152 88.2106 54.0155 88.2623C54.0158 88.302 54.0657 88.334 54.1547 88.3881C54.2591 88.4515 54.3783 88.4868 54.4907 88.5349C54.6701 88.6396 54.8498 88.7447 55.0292 88.8499C54.7873 88.9927 54.56 89.0464 54.3411 89.0464Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M91.9982 64.5181C91.7204 64.4263 91.4426 64.3342 91.1648 64.2421C92.0048 63.4677 92.2626 62.3609 92.6173 61.3082C92.9051 61.4007 93.193 61.4934 93.4841 61.5862C93.3369 62.2035 92.8516 62.5324 92.5336 63.0036C92.3563 63.5084 92.1789 64.0132 91.9982 64.5181Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M72.2944 86.5459C72.0005 86.4858 71.7067 86.4261 71.4128 86.3664L71.446 86.2216C71.6602 85.973 71.8841 85.7364 71.8844 85.4578C71.8844 85.3167 71.8275 85.1649 71.6829 84.995C71.6334 84.9373 71.615 84.8299 71.6147 84.7087C71.6147 84.5759 71.6368 84.4265 71.6645 84.3094C71.7472 83.9587 71.9865 83.7501 72.3008 83.6947C72.2516 83.99 72.2181 84.1892 72.2184 84.3374C72.2184 84.6463 72.364 84.7321 72.8128 84.9974L72.8095 84.9994C72.8105 84.9987 72.8115 84.998 72.8125 84.9974C72.8115 84.998 72.8105 84.9987 72.8095 84.9994C72.8105 84.9987 72.8115 84.998 72.8125 84.9974C72.6398 85.5135 72.4671 86.0297 72.2944 86.5459Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M107.012 80.3208C106.918 80.3208 106.821 80.2961 106.724 80.2464C106.516 80.1403 106.376 79.9508 106.48 79.6538C106.61 79.2711 106.998 78.9858 107.296 78.9858C107.403 78.9858 107.5 79.0238 107.567 79.1086C107.681 79.2557 107.661 79.5527 107.688 79.7052C107.524 80.1153 107.279 80.3208 107.012 80.3208Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M88.7316 61.6973C88.5509 61.5121 88.4873 61.3169 88.4873 61.1163C88.4873 60.7643 88.6848 60.396 88.7885 60.0353C89.4846 60.2735 90.1774 60.5114 90.8702 60.7497C90.7531 60.9956 90.579 61.1194 90.3515 61.1227C90.144 61.058 89.9432 60.9689 89.729 60.9332C89.7122 60.9305 89.6955 60.9275 89.6788 60.9252C89.6788 60.9248 89.6754 60.9245 89.6754 60.9242C89.6687 60.9232 89.662 60.9222 89.6553 60.9212C89.5683 60.9072 89.4914 60.8981 89.4278 60.8978H89.4244C89.17 60.8985 89.073 61.0456 88.7785 61.6032C88.7651 61.6309 88.7484 61.6596 88.735 61.6889C88.7316 61.6916 88.7316 61.6943 88.7316 61.6973Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M91.1983 91.0503C91.0712 91.0503 90.944 91.0176 90.8135 90.9552C90.5959 90.8508 90.5056 90.6579 90.5792 90.3856C90.6528 90.111 90.8436 90.0393 91.0477 90.0393C91.0645 90.0393 91.0846 90.04 91.1013 90.041C91.2419 90.049 91.3791 90.092 91.5163 90.1194C91.6334 90.1964 91.7539 90.2625 91.861 90.3526C91.9982 90.468 91.9782 90.6162 91.8209 90.767C91.6167 90.9599 91.4092 91.0503 91.1983 91.0503Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M71.6275 89.481C71.4629 89.481 71.4401 89.3745 71.3447 88.7432C71.4609 88.6741 71.5834 88.6581 71.7079 88.6581C71.7631 88.6581 71.8186 88.6611 71.8742 88.6645C71.9301 88.6675 71.9857 88.6708 72.0409 88.6708C72.2474 88.6708 72.4482 88.6261 72.6232 88.3709C72.816 89.0312 72.7638 89.2407 72.3692 89.3515C72.145 89.4145 71.9164 89.4559 71.6905 89.4773C71.6674 89.4796 71.6466 89.481 71.6275 89.481ZM72.6232 88.3709C72.6229 88.3702 72.6229 88.3695 72.6225 88.3688L72.6259 88.3668C72.6249 88.3682 72.6239 88.3695 72.6232 88.3709Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M99.4044 84.4512C99.3475 84.4512 99.2906 84.4328 99.2404 84.3918C98.9493 84.1675 98.9426 83.66 99.2003 83.5132C99.3944 83.4015 99.6153 83.3187 99.8194 83.3107H99.8228C99.9232 83.3107 100.101 83.5186 100.084 83.603C100.034 83.8269 99.9232 84.0708 99.7793 84.24C99.6722 84.3674 99.5316 84.4512 99.4044 84.4512Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M93.7017 65.0771C93.5545 64.901 93.5009 64.7195 93.4976 64.5353C93.4976 64.1709 93.7051 63.7952 93.7988 63.4259C93.9393 63.4732 94.0833 63.5043 94.2305 63.5179C94.3845 63.6824 94.4414 63.8666 94.4414 64.0625C94.4414 64.271 94.3778 64.4929 94.2975 64.7185C94.0966 64.8379 93.8992 64.9574 93.7017 65.0771Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M72.6225 88.3689C72.6229 88.3679 72.6229 88.3669 72.6232 88.3659C72.6239 88.3662 72.6249 88.3666 72.6259 88.3669L72.6225 88.3689ZM72.6232 88.3659C72.3498 88.2551 72.0733 88.152 71.8066 88.0269C71.7494 88.0002 71.6784 87.8661 71.6968 87.826C71.7654 87.6809 71.8491 87.5027 71.9639 87.4303C72.1245 87.3289 72.2611 87.2788 72.3725 87.2788C72.5904 87.2788 72.7112 87.4707 72.7239 87.846C72.7293 88.0122 72.6593 88.1921 72.6232 88.3659Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M69.0788 88.1956C69.0782 88.1956 69.0775 88.1956 69.0765 88.1956C68.7931 88.1946 68.6522 87.984 68.6234 87.6016C69.0725 87.5346 69.2455 87.1408 69.3938 86.7174C69.62 86.9843 69.8463 87.2513 70.0728 87.5179C70.0712 87.5202 70.0698 87.5226 70.0685 87.5249C70.0712 87.5259 70.0735 87.5265 70.0762 87.5272C70.0207 87.6907 69.9661 87.8549 69.9129 88.019C69.9102 88.018 69.9075 88.017 69.9049 88.016C69.9045 88.0187 69.9042 88.0214 69.9038 88.0237C69.7004 88.0694 69.4962 88.1075 69.2941 88.1629C69.29 88.1642 69.286 88.1652 69.282 88.1662C69.208 88.1859 69.1411 88.1952 69.0802 88.1956C69.0798 88.1956 69.0795 88.1956 69.0788 88.1956ZM68.6204 87.6023L68.6234 87.6003C68.6234 87.601 68.6234 87.6013 68.6234 87.6016C68.6224 87.602 68.6214 87.602 68.6204 87.6023Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M67.4119 88.3032C67.2733 88.2779 67.1351 88.2498 66.9979 88.2201C66.7134 88.1291 66.4286 88.0373 66.1441 87.9455C66.0012 87.8124 65.7328 87.6853 65.7332 87.5451C65.7332 87.5431 65.7335 87.5408 65.7335 87.5385C65.7342 87.5268 65.7352 87.5155 65.7362 87.5048C65.7536 87.3386 65.8145 87.2885 65.8898 87.2869C65.8908 87.2869 65.8921 87.2869 65.8935 87.2869C65.8988 87.2869 65.9038 87.2869 65.9092 87.2875C65.9473 87.2906 65.9885 87.3039 66.0287 87.3199C66.0839 87.3416 66.1381 87.3676 66.182 87.3773C66.1826 87.3776 66.1833 87.3776 66.184 87.3776C66.5237 87.4494 66.8503 87.5738 67.182 87.6769C67.3075 87.7333 67.4333 87.7887 67.5595 87.8434L67.4969 88.0767L67.4119 88.3032Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M70.0682 87.5251C70.0695 87.5228 70.0709 87.5205 70.0725 87.5181C70.0709 87.5205 70.0695 87.5228 70.0682 87.5251ZM70.0725 87.5181C69.846 87.2515 69.6197 86.9846 69.3935 86.7177L69.3928 86.7133C69.4049 86.6997 69.4169 86.6863 69.429 86.6736C69.6238 86.4668 69.8115 86.3987 69.9959 86.3984C69.9969 86.3984 69.9976 86.3984 69.9982 86.3984C69.9996 86.3984 70.0006 86.3984 70.0016 86.3984C70.2215 86.3994 70.4367 86.4948 70.6529 86.5645C70.6863 86.5752 70.7198 86.5855 70.7536 86.5946C70.759 86.5962 70.7643 86.5975 70.7697 86.5989C70.771 86.5992 70.7727 86.5996 70.774 86.5999C70.7814 86.6019 70.7888 86.6039 70.7961 86.6056C70.8098 86.6089 70.8236 86.6119 70.8373 86.6149L70.8447 86.6323C70.7854 86.8004 70.7288 86.9696 70.6753 87.1398L70.6592 87.1504C70.6556 87.1504 70.6515 87.1504 70.6479 87.1504C70.6462 87.1504 70.6442 87.1504 70.6422 87.1504C70.4046 87.1524 70.2151 87.2759 70.0725 87.5181Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M83.724 89.1079C83.6096 89.1079 83.4664 89.0919 83.2766 89.0705C83.283 89.0582 83.289 89.0462 83.295 89.0345C83.3007 89.0228 83.3064 89.0115 83.3121 89.0001C83.3134 88.9975 83.3151 88.9948 83.3164 88.9918C83.3178 88.9891 83.3191 88.9861 83.3208 88.9835C83.5985 88.4349 83.6853 88.2944 84.0116 88.2938C84.0119 88.2938 84.0126 88.2938 84.0129 88.2938C84.0146 88.2938 84.0162 88.2938 84.0182 88.2938C84.1153 88.2944 84.2331 88.3068 84.383 88.3245C84.3911 88.3255 84.3991 88.3261 84.4075 88.3271C84.4085 88.3275 84.4095 88.3275 84.4101 88.3275C84.4138 88.3281 84.4175 88.3285 84.4215 88.3288C84.4343 88.3305 84.4473 88.3318 84.4607 88.3335C84.1515 88.9554 84.0758 89.1079 83.724 89.1079Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M8.9462 76.3157C8.36889 76.0554 7.72127 75.9086 7.43579 75.1725C7.82134 75.3033 8.21291 75.4185 8.59043 75.5699C8.86118 75.6784 8.9462 75.953 8.94653 76.2763C8.94653 76.282 8.94653 76.2876 8.94653 76.2933C8.94653 76.2963 8.94653 76.2993 8.94653 76.3027C8.94653 76.307 8.9462 76.3113 8.9462 76.3157Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M96.5966 71.7312H96.5933C96.5196 71.7302 96.446 71.7125 96.3724 71.6945C96.359 71.6908 96.3456 71.6875 96.3289 71.6841C96.2988 71.6765 96.2686 71.6695 96.2385 71.6638C96.3791 71.2334 96.5631 70.8503 97.0049 70.7599C97.0953 71.0362 97.1455 71.2324 97.1455 71.3728C97.1455 71.6191 96.9949 71.6938 96.6401 71.7292C96.6268 71.7305 96.6134 71.7312 96.6 71.7312H96.5966Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M99.8464 70.5403C99.7326 70.5403 99.6222 70.4802 99.5185 70.4068C99.4683 70.3714 99.4515 70.276 99.4214 70.208C99.4615 70.1596 99.5151 70.0655 99.5452 70.0655C99.5452 70.0655 99.5452 70.0655 99.5452 70.0658C99.7326 70.1125 99.9167 70.1742 100.094 70.2503L100.104 70.4332C100.017 70.5103 99.9301 70.5403 99.8464 70.5403Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M98.3604 72.4023C98.2935 72.2739 98.1864 72.1568 98.1697 72.015C98.1697 72 98.1697 71.9846 98.1697 71.9686C98.1697 71.8371 98.2132 71.6656 98.2901 71.5805C98.2935 71.5779 98.2935 71.5752 98.2968 71.5725C98.3002 71.5699 98.3035 71.5672 98.3035 71.5649C98.3839 71.4818 98.4709 71.4437 98.5512 71.4424C98.5545 71.4424 98.5546 71.4424 98.5546 71.4424H98.5579C98.6583 71.4431 98.7553 71.4991 98.829 71.5962C98.9093 71.6993 98.926 71.8738 98.9695 72.0163C98.7654 72.1448 98.5612 72.2735 98.3604 72.4023Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M95.9573 79.521C95.9573 79.521 95.9573 79.521 95.9539 79.521C95.8401 79.5203 95.7196 79.4866 95.6025 79.4249C95.5925 79.4206 95.5858 79.4159 95.5757 79.4109C95.5222 79.3809 95.4921 79.2981 95.4519 79.2401C95.5389 79.1563 95.6259 79.0192 95.7163 79.0011C95.7196 79.0005 95.723 78.9998 95.7263 78.9991C95.7297 78.9988 95.7297 78.9988 95.7297 78.9985C95.7498 78.9958 95.7665 78.9948 95.7832 78.9945H95.7866C95.7899 78.9945 95.7933 78.9945 95.7966 78.9948C95.887 78.9968 95.9773 79.0255 96.0644 79.0458C96.0744 79.0475 96.0811 79.0492 96.0911 79.0509C96.0945 79.0522 96.1012 79.0532 96.1079 79.0542C96.1112 79.0552 96.1179 79.0559 96.1213 79.0565C96.2585 79.1073 96.3957 79.1573 96.5329 79.207C96.5296 79.21 96.5296 79.2127 96.5262 79.2157C96.5229 79.2187 96.5195 79.2217 96.5195 79.2243C96.3421 79.4255 96.1581 79.517 95.9707 79.5207C95.964 79.5207 95.9606 79.521 95.9573 79.521Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M82.8443 88.9148C82.7801 88.8894 82.7088 88.8758 82.6525 88.8367C82.0136 88.3953 82.028 88.2665 82.7734 87.744C82.7968 88.1344 82.8206 88.5247 82.8443 88.9148Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M63.4005 90.425C63.2643 90.3817 63.1247 90.3513 62.9818 90.3326C62.8573 90.2646 62.7094 90.2242 62.6157 90.1187C62.5474 90.042 62.5508 89.8798 62.522 89.7561C62.523 89.7557 62.524 89.7551 62.525 89.7547C62.53 89.7527 62.535 89.7504 62.54 89.7484C62.5454 89.7457 62.5504 89.7434 62.5558 89.7407C62.5675 89.7347 62.5792 89.7287 62.5909 89.7223C62.6304 89.7017 62.6699 89.681 62.7057 89.6773C62.7097 89.677 62.7134 89.6766 62.7171 89.6766C62.7174 89.6766 62.7174 89.6766 62.7178 89.6766C62.7195 89.6766 62.7211 89.6766 62.7228 89.6766C62.7251 89.677 62.7275 89.6773 62.7298 89.6776C63.111 89.7324 63.3814 89.9309 63.4005 90.425Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M84.3008 85.9548C84.3028 85.7873 84.3028 85.6198 84.3085 85.452C84.3175 85.1774 84.4356 85.0182 84.6525 85.0156C84.6545 85.0156 84.6562 85.0156 84.6579 85.0156C84.6582 85.0156 84.6582 85.0156 84.6586 85.0156C84.6736 85.0156 84.6893 85.0166 84.7051 85.0179C84.8443 85.0312 84.9738 85.1033 85.108 85.1487C84.931 85.5471 84.7539 85.9452 84.3008 85.9548Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M95.1174 89.0129C94.6589 88.8605 94.0665 88.9115 94.0364 88.1107C94.4782 88.2902 95.0772 88.2292 95.1174 89.0129Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M77.5623 87.679C77.2886 87.5979 77.0151 87.5165 76.7417 87.4354C77.0426 86.9843 77.4295 86.757 77.8903 86.7217L77.897 86.7223C77.7852 87.0413 77.6738 87.36 77.5623 87.679Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M3.17886 66.8997C2.95094 66.1723 2.95697 66.1516 3.48677 65.7939C3.38402 66.1626 3.2816 66.531 3.17886 66.8997Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M77.562 87.679C77.6735 87.36 77.7849 87.0413 77.8967 86.7223C78.2079 87.3713 78.1982 87.3983 77.562 87.679Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M59.2707 90.1235C59.1013 90.1235 58.9293 90.0521 58.7566 89.967C58.7619 89.962 58.7673 89.957 58.7727 89.952C58.7743 89.9504 58.776 89.9487 58.7777 89.9474C58.78 89.945 58.7824 89.943 58.7851 89.9407C58.7857 89.94 58.7867 89.939 58.7877 89.9383C58.9839 89.7612 59.184 89.6971 59.3865 89.6961C59.3881 89.6961 59.3898 89.6961 59.3915 89.6961C59.3928 89.6961 59.3938 89.6961 59.3948 89.6961C59.531 89.6964 59.6679 89.7251 59.8051 89.7662C59.8058 89.7665 59.8061 89.7665 59.8068 89.7668C59.8138 89.7689 59.8212 89.7712 59.8282 89.7735C59.8276 89.7748 59.8266 89.7762 59.8256 89.7775C59.6455 90.0348 59.4598 90.1235 59.2707 90.1235Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M34.4819 44.1516C34.3129 44.0085 34.2316 43.8156 34.2319 43.5757C34.2319 43.5337 34.2346 43.4906 34.2396 43.4459C34.3778 43.5077 34.5164 43.5697 34.6546 43.6318C34.5971 43.8049 34.5395 43.9781 34.4819 44.1516Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M67.8516 88.4907C67.705 88.428 67.5581 88.3656 67.4119 88.3032L67.4969 88.0766L67.5595 87.8434C67.7586 87.9612 67.8536 88.152 67.8546 88.409C67.8546 88.4353 67.8536 88.4627 67.8516 88.4907Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M73.7144 87.2832C73.7428 87.2358 73.7639 87.1641 73.8007 87.1461C73.8559 87.119 73.9198 87.1217 73.9811 87.1147C73.8921 87.1711 73.8034 87.2271 73.7144 87.2832ZM73.9811 87.1147C73.9851 87.1124 73.9895 87.1097 73.9935 87.107L73.9955 87.113C73.9908 87.1137 73.9861 87.1144 73.9811 87.1147Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M70.8448 86.6323L70.8374 86.615C70.894 86.4642 70.9508 86.313 71.0081 86.1625C71.1577 86.1635 71.3039 86.1832 71.4458 86.2216L71.4127 86.3664C71.2229 86.4548 71.0338 86.5436 70.8448 86.6323Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M70.4961 87.6536C70.5533 87.4867 70.6079 87.3192 70.6594 87.1504L70.6755 87.1397C70.8977 87.5081 70.8977 87.5081 70.4961 87.6536Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M70.1546 88.6929L70.1479 88.6758C70.2102 88.508 70.2691 88.3392 70.3253 88.1694C70.5522 88.5294 70.5522 88.5294 70.1546 88.6929Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M70.4961 87.6536C70.3562 87.6105 70.2163 87.5685 70.0761 87.5274C70.0734 87.5268 70.071 87.5261 70.0684 87.5251C70.0697 87.5228 70.071 87.5204 70.0727 87.5181C70.2153 87.2759 70.4047 87.1524 70.6423 87.1504C70.6444 87.1504 70.6464 87.1504 70.648 87.1504C70.6517 87.1504 70.6557 87.1504 70.6594 87.1504C70.6079 87.3192 70.5533 87.4867 70.4961 87.6536Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M70.148 88.6758C69.979 88.5533 69.8933 88.3802 69.8943 88.1549C69.8943 88.1129 69.8973 88.0695 69.9037 88.0238C69.904 88.0215 69.9044 88.0188 69.9047 88.0161C69.9074 88.0171 69.91 88.0181 69.9127 88.0191C70.0506 88.0679 70.1885 88.1176 70.3254 88.1693C70.2691 88.3391 70.2102 88.5079 70.148 88.6758Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M86.3642 85.5227C86.2223 85.462 86.0804 85.4009 85.9385 85.3402C85.9405 85.3382 85.9421 85.3362 85.9438 85.3345C85.9465 85.3315 85.9492 85.3285 85.9515 85.3258C85.9525 85.3248 85.9535 85.3235 85.9545 85.3225C85.9679 85.3078 85.981 85.2941 85.9937 85.2815C86.0894 85.1837 86.1664 85.134 86.2246 85.1303C86.227 85.13 86.2293 85.13 86.2313 85.13C86.232 85.13 86.233 85.13 86.2336 85.13C86.3233 85.132 86.3662 85.2511 86.3648 85.481C86.3645 85.4943 86.3645 85.5084 86.3642 85.5227Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M40.1251 87.3101C40.0541 87.3101 39.9865 87.2834 39.9223 87.2293L39.8848 87.0862C40.0866 86.9814 40.2884 86.8763 40.4899 86.7715C40.4367 86.928 40.3834 87.0845 40.3299 87.241C40.2586 87.287 40.1903 87.3101 40.1251 87.3101Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M14.3968 70.365C14.3964 70.365 14.3961 70.365 14.3958 70.365C14.3703 70.365 14.3462 70.3627 14.3245 70.358C14.114 70.3139 14.0561 70.1304 14.0561 69.9105C14.0557 69.8648 14.0584 69.8178 14.0624 69.7697C14.0775 69.5966 14.0765 69.4237 14.0832 69.2445C14.0805 69.2405 14.0778 69.2369 14.0755 69.2329C14.0731 69.2299 14.0711 69.2269 14.0688 69.2239C13.9925 69.1187 13.9095 69.0824 13.8225 69.0817C13.8218 69.0817 13.8208 69.0817 13.8201 69.0817C13.8195 69.0817 13.8188 69.0817 13.8181 69.0817C13.7388 69.0824 13.6565 69.1121 13.5721 69.1465C13.5718 69.1465 13.5711 69.1468 13.5708 69.1471C13.5688 69.1478 13.5668 69.1485 13.5648 69.1495C13.5514 69.1548 13.538 69.1605 13.5246 69.1661C13.4232 69.2082 13.3198 69.2502 13.2177 69.2506C13.1852 69.2502 13.1528 69.2462 13.1206 69.2362C13.1203 69.2362 13.1203 69.2362 13.1203 69.2362C13.1166 69.2349 13.1126 69.2335 13.1086 69.2322C13.1086 69.2322 13.1086 69.2322 13.1083 69.2322C13.1063 69.2315 13.1039 69.2305 13.1019 69.2299C13.0785 69.2209 13.055 69.2088 13.0319 69.1932C13.0296 69.1915 13.0269 69.1898 13.0246 69.1882C13.0219 69.1832 13.0192 69.1781 13.0169 69.1735C13.0139 69.1675 13.0109 69.1618 13.0075 69.1558C13.0045 69.1498 13.0012 69.1434 12.9981 69.1374C12.7445 68.6546 12.6441 68.4791 12.3941 68.4775C12.3931 68.4775 12.392 68.4775 12.391 68.4775C12.3877 68.4775 12.3843 68.4775 12.3807 68.4778C12.2471 68.4801 12.0708 68.5298 11.8087 68.6076C11.8074 68.6079 11.806 68.6083 11.8047 68.6086C11.802 68.6096 11.7993 68.6103 11.7967 68.6109C11.7793 68.6163 11.7615 68.6216 11.7434 68.6269C11.6695 68.649 11.5948 68.681 11.5212 68.6887C11.5092 68.69 11.4971 68.6907 11.4847 68.6907C11.4844 68.6907 11.4837 68.6907 11.4834 68.6907C11.4814 68.6907 11.4794 68.6907 11.4774 68.6907C11.4238 68.69 11.3653 68.6793 11.2813 68.671C11.2732 68.67 11.2649 68.6693 11.2562 68.6686C11.2548 68.6683 11.2531 68.6683 11.2515 68.668C11.2729 68.3634 11.3174 68.049 11.3174 67.7417C11.3174 67.71 11.3171 67.6783 11.3157 67.647C11.305 67.3063 11.2732 66.9056 10.8954 66.8939C10.8924 66.8939 10.889 66.8939 10.8857 66.8939H10.8853C10.8823 66.8936 10.8793 66.8935 10.876 66.8935C10.876 66.8935 10.876 66.8935 10.8756 66.8935C10.875 66.8935 10.8739 66.8935 10.8733 66.8935C10.5687 66.8949 10.3592 67.1144 10.2725 67.4838C10.2712 67.4895 10.2702 67.4951 10.2689 67.5008C10.2682 67.5042 10.2672 67.5075 10.2665 67.5108C10.2645 67.5212 10.2622 67.5315 10.2601 67.5422C10.2156 67.7741 10.1162 67.8638 10.0061 67.8652C10.0051 67.8652 10.0041 67.8652 10.0035 67.8652C10.0021 67.8652 10.0008 67.8652 9.99978 67.8652C9.92882 67.8642 9.85384 67.8268 9.78624 67.7681C9.78523 67.7674 9.78424 67.7664 9.78358 67.7658C9.78123 67.7638 9.77922 67.7621 9.77688 67.7601C9.7752 67.7584 9.77319 67.7567 9.77152 67.7547C9.77018 67.7537 9.76884 67.7524 9.76784 67.7514C9.6082 67.6006 9.52352 67.3503 9.39567 67.1531C9.01046 66.5582 8.73134 65.7564 8.20322 65.4301C7.57971 65.0451 6.98265 64.6066 6.3501 64.2446C5.98865 64.038 5.49166 64.1055 5.05591 64.0497C5.3106 63.7544 5.56529 63.4592 5.81998 63.1639C5.69146 62.9947 5.63724 62.8145 5.6369 62.6347C5.63623 62.3527 5.76743 62.0721 5.94916 61.8375C6.36584 61.2997 6.70487 60.7518 6.8538 60.0711C6.99939 60.1245 7.14564 60.1779 7.29189 60.2313C7.22864 60.5389 7.18781 60.7414 7.18781 60.8902C7.18815 61.1755 7.33874 61.2643 7.77182 61.5189C7.78052 61.5205 7.78888 61.5215 7.79759 61.5225C7.80428 61.5232 7.81064 61.5239 7.817 61.5242C7.8247 61.5249 7.83239 61.5252 7.84009 61.5255C7.84812 61.5259 7.85582 61.5259 7.86385 61.5259C7.93112 61.5259 8.00274 61.5165 8.07437 61.5075C8.14565 61.4982 8.21727 61.4889 8.28488 61.4889C8.45992 61.4889 8.60885 61.5512 8.6634 61.8369C8.66474 61.8442 8.66608 61.8519 8.66742 61.8599C8.66843 61.8662 8.66977 61.8729 8.67077 61.8796C8.67111 61.8829 8.67176 61.8866 8.6721 61.8899C8.73635 62.3547 9.11321 62.6837 9.11355 63.1799C9.11355 63.2973 9.09245 63.4241 9.04091 63.5643C9.03556 63.5789 9.03321 63.5973 9.03321 63.6176C9.03288 63.7424 9.12224 63.9506 9.18784 63.9586C9.84013 64.0387 9.92447 64.6773 10.1079 65.2155C10.2424 65.6103 10.2933 65.4751 11.0363 65.8205C11.0403 65.8221 11.0443 65.8241 11.0483 65.8258C11.0567 65.8298 11.0654 65.8335 11.0738 65.8375C11.0751 65.8378 11.0764 65.8385 11.0778 65.8392C11.4011 65.9836 11.7073 66.052 12.0011 66.0527C12.0018 66.0527 12.0028 66.0527 12.0035 66.0527C12.0048 66.0527 12.0062 66.0527 12.0075 66.0527C12.6722 66.0514 13.2743 65.7004 13.8727 65.0884C13.874 65.0871 13.875 65.0861 13.8763 65.0847C13.8793 65.0814 13.8827 65.0784 13.8857 65.0751C13.8944 65.0664 13.9028 65.0574 13.9115 65.0484C13.9155 65.044 13.9198 65.0397 13.9242 65.0354C13.9249 65.0347 13.9255 65.0337 13.9262 65.033C13.9306 65.0284 13.9349 65.0237 13.9393 65.019C13.627 64.5929 13.1193 64.323 13.119 63.6533C13.119 63.5643 13.128 63.4685 13.1474 63.3641C13.1491 63.3544 13.1511 63.3447 13.1534 63.335C13.2291 63.0087 13.5614 62.5859 13.8158 62.5689C13.8211 62.5686 13.8261 62.5686 13.8315 62.5686C13.8318 62.5686 13.8322 62.5686 13.8328 62.5686C13.8743 62.5689 13.9138 62.5806 13.949 62.6063C14.4185 62.946 15.0434 62.927 15.4296 63.4822C15.4346 63.4895 15.4396 63.4965 15.4443 63.5032C15.446 63.5055 15.4473 63.5075 15.449 63.5098C15.4517 63.5138 15.4547 63.5179 15.4574 63.5219C15.4614 63.5275 15.4651 63.5329 15.4687 63.5382C15.6357 63.7731 15.7432 63.8902 15.875 63.8922C15.876 63.8922 15.877 63.8922 15.8784 63.8922C15.8794 63.8922 15.8807 63.8922 15.8821 63.8922C16.0176 63.8899 16.1796 63.7678 16.457 63.5292C16.4627 63.5242 16.4688 63.5192 16.4748 63.5138C16.4768 63.5122 16.4791 63.5102 16.4815 63.5082C16.4898 63.5008 16.4985 63.4935 16.5072 63.4858C16.5086 63.4848 16.5099 63.4835 16.5113 63.4825C16.5337 63.4628 16.5571 63.4425 16.5812 63.4214C16.5846 63.4188 16.5879 63.4158 16.5912 63.4128C16.607 63.3991 16.6234 63.3847 16.6401 63.3704C16.6438 63.367 16.6475 63.3637 16.6515 63.3604L16.6676 63.3517C17.0883 63.4895 17.5089 63.627 17.9293 63.7645C17.4142 64.2997 17.0203 64.8645 17.021 65.5322C17.0213 65.7834 17.0772 66.0494 17.2037 66.3337C17.2174 66.3644 17.2245 66.4077 17.2245 66.4521C17.2241 66.5022 17.2151 66.5536 17.1967 66.5896C17.1224 66.7371 17.0367 66.9276 16.9209 66.99C16.7131 67.1021 16.4801 67.1538 16.2566 67.1945C15.3483 67.3587 15.3483 67.3537 14.9778 68.6586C15.1187 68.639 15.2599 68.6133 15.4005 68.6002C15.539 68.5876 15.5561 68.5318 15.5514 68.4978C15.5511 68.4955 15.5504 68.4931 15.5501 68.4911C15.5568 68.5025 15.5678 68.5192 15.5852 68.5422C15.5872 68.5449 15.5892 68.5479 15.5912 68.5505C15.5932 68.5529 15.5949 68.5555 15.5969 68.5579C15.5973 68.5585 15.5976 68.5589 15.5979 68.5592C15.5989 68.5609 15.6003 68.5622 15.6013 68.5639C15.6056 68.5692 15.6096 68.5745 15.6143 68.5802C15.6618 68.6403 15.6863 68.7521 15.6863 68.8578C15.6863 68.9045 15.6813 68.9496 15.6716 68.9889C15.531 69.5568 15.0812 69.8492 14.7401 70.2312C14.7365 70.2352 14.7328 70.2389 14.7288 70.2429C14.7254 70.2462 14.7217 70.2496 14.7181 70.2529C14.7167 70.2542 14.7154 70.2555 14.7137 70.2569C14.634 70.3253 14.5062 70.3643 14.3998 70.365C14.3988 70.365 14.3978 70.365 14.3968 70.365ZM5.87989 63.1538C5.86182 63.1545 5.84341 63.1555 5.82567 63.1575L5.8357 63.1842C5.85043 63.1742 5.86516 63.1638 5.87989 63.1538C5.92741 63.1518 5.97493 63.1498 6.01811 63.1305C6.05392 63.1141 6.076 63.0444 6.10411 62.9987C6.02915 63.0504 5.95452 63.1021 5.87989 63.1538ZM15.5501 68.4911C15.5414 68.4764 15.5394 68.4705 15.5407 68.4705C15.5417 68.4705 15.5471 68.4788 15.5501 68.4911Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M29.7631 66.5859C29.3578 66.1395 28.9521 65.6934 28.5763 65.28C28.1436 65.4047 27.7858 65.5075 27.5405 65.5786C26.7734 64.978 27.0994 63.8819 26.6321 63.2403C26.691 63.0764 26.7479 62.9123 26.8032 62.7475C27.0609 62.4528 27.3186 62.1585 27.5763 61.8643C27.8075 61.8289 27.923 61.7548 27.923 61.6427C27.9227 61.5633 27.8648 61.4645 27.7496 61.3471C27.7537 61.3087 27.7557 61.2713 27.7557 61.2353C27.7553 61 27.6686 60.8189 27.4959 60.6914C27.5535 60.5196 27.6108 60.3481 27.6683 60.1766C27.6677 60.1739 27.6673 60.1715 27.6666 60.1692C27.666 60.1649 27.6653 60.1605 27.6643 60.1565C27.6195 59.9283 27.5973 59.8242 27.5341 59.8236C27.5338 59.8236 27.5338 59.8236 27.5334 59.8236C27.5321 59.8236 27.5308 59.8236 27.5294 59.8236C27.5003 59.8256 27.4632 59.8476 27.4116 59.8879C27.4049 59.8933 27.3979 59.8989 27.3905 59.905C27.3878 59.9073 27.3848 59.9096 27.3821 59.912C27.3805 59.9133 27.3785 59.915 27.3768 59.9163C27.3624 59.9286 27.347 59.9417 27.3306 59.956C27.3196 59.9657 27.3079 59.9757 27.2962 59.9864C27.2901 59.9914 27.2841 59.9967 27.2781 60.0021C27.2771 60.0031 27.2761 60.0037 27.2751 60.0047C27.2734 60.0061 27.2717 60.0077 27.27 60.0094C27.261 60.0174 27.2516 60.0257 27.2419 60.0341C27.2168 60.0261 27.1917 60.0184 27.1666 60.0111H27.1663C27.0458 59.9757 26.9263 59.9487 26.8085 59.9483C26.8075 59.9483 26.8062 59.948 26.8052 59.948C26.8045 59.948 26.8035 59.9483 26.8028 59.9483C26.6094 59.9487 26.4213 60.0221 26.2449 60.2503C26.2399 60.257 26.2346 60.2636 26.2295 60.2706C26.1854 60.4542 26.0829 60.6774 26.0823 60.8542C26.0819 60.979 26.1325 61.0811 26.2904 61.1292C26.5816 61.2183 26.6713 61.3717 26.6716 61.5619C26.672 61.7194 26.6107 61.9019 26.5515 62.0941C26.5384 62.0901 26.5254 62.0858 26.5123 62.0818C26.5093 62.0811 26.5063 62.0801 26.5036 62.0791C26.5033 62.0791 26.503 62.0791 26.503 62.0788H26.5026C26.4976 62.0775 26.4926 62.0758 26.4872 62.0741C26.3614 62.0361 26.2362 62.007 26.1127 62.0067C26.1121 62.0067 26.1114 62.0067 26.1107 62.0067C26.109 62.0067 26.1074 62.0067 26.1057 62.0067C25.9143 62.008 25.7272 62.0791 25.5498 62.294C25.5478 62.2963 25.5458 62.299 25.5434 62.3017C25.5411 62.3047 25.5388 62.3077 25.5364 62.3107C25.5331 62.3147 25.5297 62.319 25.5264 62.323C25.0802 61.9704 24.9189 61.8432 24.9193 61.5816C24.9193 61.4375 24.9688 61.2523 25.0468 60.9657C25.1371 60.6333 25.26 60.3087 25.3684 59.98C25.4337 59.9697 25.5036 59.9737 25.5632 59.943C25.5997 59.9243 25.6204 59.8526 25.6485 59.8049C25.5551 59.8629 25.4618 59.9213 25.3684 59.9794C25.2268 59.9317 25.0849 59.8839 24.943 59.8362C24.942 59.8346 24.9414 59.8329 24.9404 59.8312C24.9373 59.8249 24.934 59.8185 24.931 59.8125C24.93 59.8105 24.929 59.8085 24.928 59.8069C24.9189 59.7895 24.9106 59.7732 24.9022 59.7575C24.8215 59.6057 24.767 59.5292 24.7154 59.5229C24.7131 59.5226 24.7104 59.5222 24.7081 59.5222C24.7078 59.5222 24.7074 59.5222 24.7067 59.5222C24.6632 59.5232 24.6204 59.5746 24.5648 59.6727C24.5635 59.6757 24.5618 59.6784 24.5602 59.6814C24.5572 59.6871 24.5541 59.6924 24.5508 59.6981C24.5478 59.7037 24.5448 59.7094 24.5417 59.7154C24.5404 59.7178 24.5387 59.7204 24.5374 59.7231C24.4567 59.8749 24.4079 60.0464 24.3443 60.2089V60.2093C24.3423 60.2093 24.3403 60.2093 24.3383 60.2093C24.3363 60.2093 24.3343 60.2093 24.3322 60.2093C24.111 60.2109 23.9283 60.3144 23.7837 60.5189C23.7804 60.5236 23.777 60.5282 23.774 60.5332C23.7737 60.5336 23.7733 60.5339 23.773 60.5346C23.7703 60.5386 23.7676 60.5426 23.765 60.5466C23.763 60.5493 23.7609 60.5523 23.7593 60.5553C23.7543 60.5626 23.7496 60.5706 23.7445 60.5783C23.3935 60.2483 23.1605 59.7428 22.6501 59.65C22.7054 59.4752 22.7609 59.3 22.8165 59.1252C22.8185 59.1252 22.8205 59.1252 22.8225 59.1252C22.8265 59.1252 22.8302 59.1252 22.8339 59.1252C23.0732 59.1212 23.2663 58.9977 23.4132 58.7535C23.4715 58.5826 23.5287 58.4115 23.5849 58.2403C23.5893 58.1996 23.5916 58.1602 23.5916 58.1225C23.5916 57.891 23.5069 57.7115 23.3369 57.5837L23.3352 57.584C23.3931 57.4128 23.4514 57.2413 23.5096 57.0701C23.9872 57.0241 24.3868 56.7792 24.7024 56.3194C24.7623 56.1512 24.8209 55.9824 24.8778 55.8129C25.019 55.8603 25.1609 55.906 25.3031 55.9494C25.3871 56.1699 25.4712 56.3901 25.5552 56.6103C25.5016 56.7725 25.4484 56.9347 25.3955 57.0972C25.1164 57.2407 24.8249 57.3574 24.5652 57.5436C24.5049 57.587 24.4678 57.7555 24.4681 57.891C24.4681 57.9323 24.4718 57.971 24.4795 58.0017C24.515 58.1462 24.6408 58.3397 24.7509 58.3461C24.8262 58.3504 24.9015 58.3534 24.9762 58.3534C24.9765 58.3534 24.9768 58.3534 24.9772 58.3534C24.9782 58.3534 24.9792 58.3534 24.9802 58.3534C25.5066 58.3527 25.9929 58.2093 26.2202 57.4358C26.2205 57.4348 26.2208 57.4335 26.2212 57.4325C26.2228 57.4268 26.2242 57.4212 26.2258 57.4158L26.2459 57.3965C26.256 57.3968 26.266 57.3971 26.2757 57.3971C26.2777 57.3971 26.2794 57.3971 26.2814 57.3971C26.5066 57.3951 26.6867 57.2744 26.8259 57.0445C26.8273 57.0421 26.8286 57.0394 26.8303 57.0371C27.0676 57.0027 27.2065 56.887 27.2055 56.6334C27.2055 56.5973 27.2024 56.5583 27.1967 56.5163C27.173 56.3511 27.1817 56.1759 27.1757 56.0054L27.1774 56.0044C27.6877 56.1095 27.9287 56.6117 28.2804 56.9507C28.1677 57.292 28.0552 57.6337 27.9427 57.975C27.9367 58.0208 27.9337 58.0648 27.9337 58.1068C27.933 58.3344 28.0187 58.5099 28.1874 58.635L28.1871 58.6357C28.1834 58.6724 28.1814 58.7074 28.1814 58.7418C28.1807 58.9807 28.2691 59.1626 28.4484 59.286C28.7289 59.3838 29.0093 59.4812 29.2898 59.5787C29.3792 59.8015 29.4689 60.0244 29.5579 60.247C29.4311 60.5866 29.3042 60.926 29.1777 61.2656C28.9498 61.304 28.8457 61.3781 28.846 61.4825C28.8464 61.5623 28.9083 61.6597 29.0231 61.7728C28.8671 62.2503 28.7098 62.7278 28.5555 63.2059C28.5535 63.2119 28.5519 63.2179 28.5499 63.2236C28.4943 63.4094 28.5301 63.5109 28.6513 63.5125C28.6523 63.5125 28.6533 63.5125 28.6543 63.5125C28.6546 63.5125 28.6553 63.5125 28.6556 63.5125C28.6737 63.5122 28.6938 63.5102 28.7159 63.5055C28.7738 63.4935 28.8491 63.4525 28.8819 63.3988C28.9669 63.2589 29.0328 63.1045 29.1064 62.956C29.9475 63.1735 30.2008 64.261 31.0432 64.5856C31.1898 64.4418 31.3889 64.298 31.5258 64.1001C31.5275 64.0978 31.5291 64.0954 31.5308 64.0928C31.5315 64.0918 31.5322 64.0908 31.5332 64.0894C31.5338 64.0881 31.5348 64.0871 31.5355 64.0858C31.5389 64.0811 31.5419 64.0764 31.5449 64.0718C31.661 63.8946 31.7762 63.652 31.9328 63.648C31.9341 63.648 31.9354 63.648 31.9364 63.648C31.9368 63.648 31.9371 63.648 31.9375 63.648C31.9666 63.648 31.997 63.6564 32.0288 63.675C32.0302 63.6757 32.0318 63.6767 32.0332 63.6774C32.066 63.6971 32.0988 63.7131 32.1312 63.7257C32.2042 63.7544 32.2765 63.7665 32.3481 63.7665C32.5436 63.7665 32.7333 63.6767 32.9177 63.587C33.1021 63.4969 33.2812 63.4071 33.4546 63.4071C33.4586 63.4071 33.4626 63.4071 33.4666 63.4075C33.4994 63.4081 33.5319 63.4121 33.5643 63.4201C33.5667 63.4208 33.569 63.4214 33.5714 63.4221C33.6567 63.4448 33.7387 63.4548 33.818 63.4552C33.8184 63.4552 33.8187 63.4552 33.819 63.4552C33.8213 63.4552 33.8234 63.4552 33.8257 63.4548C34.2407 63.4522 34.5854 63.1762 34.9472 62.9867C34.9472 62.9864 34.9472 62.9864 34.9472 62.9864C34.9495 62.9854 34.9516 62.984 34.9539 62.983C34.9686 62.9753 34.9834 62.9677 34.9984 62.9603L34.9987 62.96C35.0346 62.9423 35.0707 62.9253 35.1069 62.91C35.1092 62.909 35.1112 62.9083 35.1136 62.9073C35.1316 62.8996 35.1497 62.8923 35.1678 62.8856C35.1695 62.8849 35.1711 62.8843 35.1728 62.8836C35.1832 62.8799 35.1932 62.8763 35.2036 62.8726C35.2099 62.8702 35.2163 62.8682 35.2227 62.8659C35.223 62.8659 35.223 62.8659 35.223 62.8659C35.2277 62.8642 35.2327 62.8629 35.2377 62.8612C35.2468 62.8582 35.2558 62.8556 35.2648 62.8529C35.2675 62.8522 35.2699 62.8516 35.2725 62.8506C35.2856 62.8469 35.2986 62.8436 35.3117 62.8402C35.3127 62.8402 35.3137 62.8399 35.3147 62.8395C35.3435 62.8329 35.3726 62.8295 35.4021 62.8292C35.4041 62.8292 35.4061 62.8292 35.4084 62.8292C35.5219 62.8292 35.6387 62.8679 35.7531 62.8812C35.7531 62.8816 35.7531 62.8819 35.7531 62.8819C35.7541 62.8823 35.7551 62.8826 35.7561 62.8829C35.5891 63.1809 35.4385 63.4925 35.2498 63.7721C35.1584 63.9076 35.1082 64.0287 35.1082 64.1435C35.1085 64.2416 35.1457 64.3353 35.2264 64.4291C35.0476 65.2739 34.6289 65.8395 33.8689 66.0237C33.806 66.0387 33.7497 66.1345 33.6905 66.1929C33.5469 66.1688 33.3893 66.1128 33.2364 66.0667C33.1162 66.0307 32.9987 66.001 32.893 65.998C32.8873 65.9977 32.8816 65.9977 32.8759 65.9977C32.8756 65.9977 32.8749 65.9977 32.8746 65.9977C32.7946 65.998 32.7223 66.0144 32.661 66.0567C32.656 66.0601 32.651 66.0638 32.646 66.0671C32.6456 66.0674 32.6453 66.0674 32.6446 66.0677C32.6403 66.0707 32.6356 66.0741 32.6309 66.0771C32.6259 66.0804 32.6212 66.0834 32.6162 66.0864C32.6142 66.0878 32.6125 66.0888 32.6108 66.0901C32.6102 66.0904 32.6095 66.0908 32.6088 66.0914C32.6072 66.0924 32.6055 66.0934 32.6038 66.0944C32.6028 66.0951 32.6021 66.0954 32.6011 66.0961C32.5988 66.0974 32.5964 66.0991 32.5938 66.1005C32.5898 66.1031 32.5854 66.1058 32.5811 66.1084C32.5804 66.1088 32.5797 66.1091 32.579 66.1095C32.5774 66.1105 32.576 66.1115 32.5747 66.1121C32.5737 66.1128 32.5727 66.1134 32.5717 66.1141C32.57 66.1148 32.5687 66.1158 32.567 66.1168C32.566 66.1171 32.5653 66.1178 32.5643 66.1185C32.5627 66.1191 32.5613 66.1201 32.5599 66.1208C32.5589 66.1215 32.5579 66.1221 32.5569 66.1225C32.2771 66.2836 32.0181 66.3063 31.7591 66.3063C31.7089 66.3063 31.6583 66.3056 31.6078 66.3046C31.5576 66.304 31.5074 66.303 31.4568 66.303C31.4036 66.303 31.3498 66.304 31.2952 66.3067H31.2949C31.2925 66.307 31.2905 66.307 31.2882 66.3073C31.2835 66.3073 31.2788 66.3077 31.2741 66.308C31.2738 66.308 31.2735 66.308 31.2731 66.308C31.2711 66.3083 31.2691 66.3083 31.2671 66.3083C31.2661 66.3087 31.2654 66.3086 31.2644 66.3086C31.2631 66.3086 31.2614 66.3087 31.2601 66.309C31.2557 66.3093 31.2517 66.3096 31.2473 66.31C31.2467 66.31 31.2463 66.31 31.246 66.31C31.2413 66.3103 31.2363 66.3107 31.2316 66.311C31.2276 66.3113 31.2233 66.3117 31.2189 66.312C31.1952 66.3137 31.171 66.3143 31.1473 66.3143C31.1466 66.3143 31.1463 66.3143 31.1459 66.3143C31.1446 66.3143 31.1436 66.3143 31.1423 66.3143C31.0342 66.314 30.9244 66.2993 30.8139 66.2843C30.8099 66.2836 30.8056 66.283 30.8012 66.2823C30.6854 66.2663 30.5693 66.2503 30.4535 66.2503C30.3394 66.2503 30.2256 66.2659 30.1138 66.3127C30.1088 66.3147 30.1041 66.3167 30.0991 66.319C30.0984 66.3193 30.0981 66.3193 30.0974 66.3197C30.0964 66.32 30.0954 66.3207 30.0947 66.321C30.0937 66.3213 30.0927 66.3217 30.0921 66.322C30.0917 66.3223 30.0914 66.3223 30.091 66.3227C30.0696 66.3323 30.0485 66.343 30.0274 66.3554C30.0271 66.3554 30.0268 66.3554 30.0268 66.3557C29.9659 66.3907 29.9056 66.4361 29.846 66.4948C29.842 66.4988 29.8384 66.5025 29.8343 66.5065C29.8243 66.5165 29.8146 66.5269 29.8049 66.5379C29.8042 66.5385 29.8035 66.5392 29.8029 66.5399C29.8019 66.5412 29.8005 66.5422 29.7995 66.5435C29.7962 66.5475 29.7929 66.5512 29.7895 66.5552C29.7892 66.5552 29.7892 66.5552 29.7892 66.5552C29.7888 66.5556 29.7885 66.5562 29.7882 66.5566C29.7818 66.5636 29.7758 66.5709 29.7698 66.5782C29.7674 66.5806 29.7654 66.5833 29.7631 66.5859ZM24.8778 55.8129C24.8774 55.8129 24.8771 55.8129 24.8768 55.8126L24.8781 55.8119C24.8781 55.8122 24.8778 55.8126 24.8778 55.8129Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M24.5827 63.7219C24.0847 63.6001 23.5947 63.4326 23.085 63.3746C22.7901 63.3409 22.4933 63.3866 22.2754 63.1303C22.271 63.1253 22.2667 63.12 22.262 63.115C22.0468 62.8701 21.8025 62.793 21.5451 62.7923C21.5441 62.7923 21.5431 62.7923 21.5421 62.7923C21.5411 62.7923 21.5404 62.7923 21.5398 62.7923C21.2928 62.7927 21.0341 62.8627 20.777 62.9228C20.7687 62.9245 20.7606 62.9265 20.7523 62.9285C20.7315 62.9331 20.7111 62.9378 20.6907 62.9421C20.683 62.9438 20.6753 62.9455 20.6679 62.9471C20.6642 62.9481 20.6609 62.9488 20.6572 62.9495C20.6542 62.9501 20.6512 62.9508 20.6478 62.9515C20.6405 62.9531 20.6328 62.9545 20.6254 62.9562C20.6127 62.9588 20.6 62.9615 20.5873 62.9638L20.5779 62.9485C20.5478 62.7179 20.53 62.488 20.53 62.2588C20.5304 61.7543 20.6167 61.2525 20.847 60.7553C20.8507 60.7553 20.854 60.7553 20.8577 60.7553C20.86 60.7553 20.862 60.7553 20.864 60.7553C20.9069 60.7553 20.9501 60.756 20.9929 60.7573C21.0508 60.759 21.1087 60.761 21.1666 60.7633C21.1746 60.7637 21.1827 60.764 21.1907 60.7643C21.2854 60.768 21.3798 60.7713 21.4745 60.7717C21.4758 60.7717 21.4772 60.7717 21.4782 60.7717C21.4798 60.7717 21.4812 60.7717 21.4825 60.7717C21.591 60.7713 21.6991 60.7666 21.8072 60.753C21.8195 60.7513 21.8319 60.7496 21.8443 60.7479C21.8463 60.7476 21.8487 60.7473 21.851 60.747C21.8584 60.7456 21.8661 60.7446 21.8738 60.7433C22.5656 60.6298 22.5649 60.6075 22.6502 59.6502C23.1606 59.743 23.3935 60.2485 23.7446 60.5785C23.7496 60.5785 23.7547 60.5785 23.7593 60.5785C23.763 60.5785 23.767 60.5785 23.7707 60.5785C23.9993 60.5748 24.1857 60.4587 24.33 60.2325C24.3333 60.2274 24.3363 60.2224 24.3393 60.2174C24.341 60.2148 24.3427 60.2121 24.3444 60.2094V60.2091C24.3467 60.2091 24.3491 60.2091 24.3511 60.2091C24.3531 60.2091 24.3551 60.2091 24.3567 60.2091C24.587 60.2074 24.7744 60.0953 24.9197 59.8738C24.9234 59.8681 24.9274 59.8621 24.931 59.8561C24.9351 59.8497 24.9391 59.8431 24.9431 59.8364C25.085 59.8841 25.2269 59.9318 25.3685 59.9795V59.9802C25.26 60.3088 25.1372 60.6335 25.0468 60.9658C24.9689 61.2525 24.9193 61.4376 24.9193 61.5818C24.919 61.8434 25.0803 61.9705 25.5264 62.3232C25.3798 62.9325 24.9133 63.2695 24.5827 63.7219Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M19.8821 60.0818C19.8818 60.0818 19.8815 60.0818 19.8808 60.0818C19.7861 60.0811 19.7061 60.0227 19.6305 59.9066C19.6301 59.9056 19.6295 59.9046 19.6288 59.9036C19.6224 59.8939 19.6161 59.8836 19.6101 59.8729C19.3925 59.5052 19.7021 58.7371 19.0224 58.7064C18.9812 58.7048 18.9189 58.5169 18.9189 58.3911C18.9189 58.3597 18.9226 58.3324 18.9317 58.3127C19.1797 57.7658 19.4092 57.1873 19.7506 56.7181C20.0337 56.3287 20.4621 56.0758 20.8236 55.7655C20.7985 55.4202 20.7744 55.0845 20.7513 54.7649C20.753 54.7635 20.755 54.7622 20.757 54.7605C20.7593 54.7588 20.7617 54.7568 20.764 54.7552C20.9277 54.6321 21.0836 54.595 21.2356 54.5943C21.2369 54.5943 21.2379 54.5943 21.2393 54.5943C21.2409 54.5943 21.2426 54.5943 21.2443 54.5943C21.3531 54.595 21.4595 54.6137 21.5656 54.6324C21.673 54.6514 21.7801 54.6704 21.8875 54.6704C21.925 54.6704 21.9622 54.6681 21.9996 54.6627C22.0094 54.6614 22.0191 54.6597 22.0288 54.6581C22.0345 54.6571 22.0401 54.6557 22.0458 54.6547C22.0475 54.6544 22.0492 54.6541 22.0508 54.6534C22.0579 54.6521 22.0646 54.6504 22.0716 54.6487C22.1375 54.7735 22.255 54.8906 22.258 55.0258C22.2587 55.0581 22.259 55.0902 22.259 55.1225C22.2587 55.4345 22.2262 55.7525 22.1964 56.0678C22.1891 56.1462 22.1854 56.2206 22.1854 56.2914C22.1844 57.1252 22.679 57.4378 23.3354 57.5843L23.337 57.584C23.2785 57.7555 23.2199 57.9263 23.1613 58.0978C22.7105 58.1652 22.5365 58.5586 22.3895 58.9844C22.1409 59.0221 22.0221 59.1812 21.9729 59.4739C21.9371 59.6877 21.835 59.7815 21.7188 59.7828C21.7178 59.7828 21.7168 59.7828 21.7158 59.7828C21.7155 59.7828 21.7148 59.7828 21.7145 59.7828C21.6539 59.7825 21.5893 59.7571 21.5288 59.7107C21.5247 59.7077 21.5207 59.7048 21.517 59.7014C21.3025 59.5263 21.1308 59.2853 20.9404 59.0728C20.9407 59.0721 20.9407 59.0714 20.9411 59.0711C20.9407 59.0708 20.9401 59.0708 20.9397 59.0705C21.1041 58.7645 21.2543 58.4475 21.4374 58.1562C21.5388 57.9947 21.5867 57.8422 21.5873 57.6837C21.5873 57.6037 21.5753 57.5219 21.5519 57.4372C21.5492 57.4272 21.5462 57.4175 21.5431 57.4078C21.4565 57.1329 21.2523 56.9767 21.006 56.974C21.004 56.974 21.002 56.974 21 56.974C20.9993 56.974 20.9983 56.974 20.9976 56.974C20.8909 56.9744 20.7764 57.0037 20.6603 57.0645C20.2841 57.2613 20.0659 57.6063 20.0666 57.9527C20.0666 58.0004 20.0706 58.0481 20.0793 58.0955C20.179 58.6504 20.5036 58.9223 20.9397 59.0705C20.9394 59.0708 20.9394 59.0711 20.9391 59.0714C20.9394 59.0721 20.9401 59.0724 20.9404 59.0728C20.8761 59.2449 20.8119 59.4175 20.7476 59.5896C20.5445 59.7158 20.3346 59.8272 20.1405 59.972C20.1378 59.974 20.1352 59.9757 20.1325 59.9777C20.1261 59.9824 20.1201 59.9867 20.1141 59.9907C20.0311 60.0484 19.9584 60.0785 19.8928 60.0815C19.8892 60.0818 19.8858 60.0818 19.8821 60.0818Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M29.4913 53.3516C29.1302 53.1941 28.8956 52.9672 28.8966 52.5441C28.8966 52.4337 28.913 52.3099 28.9474 52.1704C29.1496 51.3486 29.6024 50.7126 30.0663 50.0643C30.1509 49.9462 30.1914 49.8338 30.1918 49.7317C30.1928 49.5114 30.007 49.3409 29.6754 49.2698C29.4612 49.2241 29.2413 49.1808 29.0452 49.0873C28.8962 49.0163 28.8226 48.8514 28.8223 48.6462C28.8219 48.5008 28.8587 48.3353 28.9314 48.1681C28.9327 48.1648 28.9344 48.1618 28.9357 48.1584C28.9364 48.1564 28.9374 48.1547 28.9381 48.1527C28.9387 48.1511 28.9394 48.1498 28.9401 48.1481C28.9411 48.1461 28.9421 48.1437 28.9431 48.1417C28.9458 48.1364 28.9481 48.1311 28.9505 48.1261C29.0572 47.9038 29.1988 47.7917 29.3731 47.7907C29.3738 47.7907 29.3745 47.7907 29.3752 47.7907C29.3758 47.7907 29.3765 47.7907 29.3775 47.7907C29.4598 47.7914 29.5499 47.8164 29.6466 47.8665C29.6496 47.8678 29.6523 47.8691 29.6549 47.8705C29.6586 47.8725 29.6627 47.8748 29.6667 47.8768C29.6694 47.8785 29.6724 47.8798 29.675 47.8815C29.6781 47.8831 29.6814 47.8852 29.6844 47.8868C29.6904 47.8902 29.6961 47.8935 29.7021 47.8968C29.7068 47.8995 29.7118 47.9022 29.7165 47.9048C29.7169 47.9052 29.7172 47.9055 29.7175 47.9055C29.7242 47.9095 29.7306 47.9132 29.7373 47.9168C29.7399 47.9182 29.7426 47.9199 29.7456 47.9215C29.7537 47.9262 29.7614 47.9305 29.7694 47.9349C29.7701 47.9355 29.7711 47.9359 29.7718 47.9362C30.0653 48.102 30.2272 48.1841 30.3899 48.1854C30.3912 48.1854 30.3926 48.1854 30.3939 48.1854C30.3946 48.1854 30.3953 48.1854 30.3959 48.1854C30.5613 48.1848 30.7286 48.101 31.0362 47.9379C31.0455 47.9328 31.0556 47.9278 31.0653 47.9225C31.6724 48.9415 31.9201 49.3576 31.9204 49.773C31.9207 50.06 31.8032 50.3463 31.6044 50.8304C31.4579 50.6646 31.3113 50.4987 31.1553 50.3219C30.665 50.7433 30.6868 51.4156 30.4368 51.9515C29.987 52.0196 29.8119 52.412 29.6653 52.8374C29.6071 53.0089 29.5492 53.1801 29.4913 53.3516Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M25.6487 54.926C25.6487 54.9257 25.6487 54.9253 25.6491 54.925C25.6494 54.925 25.6497 54.9254 25.6501 54.9254L25.6487 54.926ZM25.6491 54.925C25.5185 54.8553 25.3913 54.7769 25.2568 54.7178C25.2525 54.7158 25.2485 54.7141 25.2444 54.7121C25.212 54.6958 25.1849 54.6744 25.1618 54.6491C24.9469 54.4132 25.0891 53.8283 24.6698 53.8266C24.6691 53.8266 24.6685 53.8266 24.6678 53.8266C24.6661 53.8266 24.6644 53.8266 24.6628 53.8266C24.6624 53.8266 24.6628 53.8266 24.6628 53.8266C24.6607 53.8266 24.6591 53.8266 24.6574 53.8266C24.3719 53.8333 24.0767 53.9591 23.8 54.0278C23.7708 53.9257 23.7578 53.831 23.7578 53.7422C23.7581 53.0729 24.4914 52.7395 24.4998 52.1126C24.3699 52.0545 24.2508 51.9931 24.1259 51.9464C23.554 51.7339 23.3274 51.4653 23.3274 50.9494C23.3274 50.8757 23.3321 50.7969 23.3411 50.7125C23.3763 50.3802 23.6771 49.9241 23.9067 49.9204C23.9077 49.9204 23.9084 49.9204 23.9094 49.9204C23.9104 49.9204 23.9117 49.9204 23.9128 49.9204C24.1296 49.9251 24.4054 49.9434 24.5336 50.0949C24.9098 50.5383 25.1976 51.0479 25.1969 51.7028C25.1966 51.8463 25.1828 51.9968 25.1527 52.1549C25.1326 52.2614 25.1089 52.3728 25.1086 52.4733C25.1082 52.6131 25.1537 52.7315 25.3191 52.7846C25.8181 52.9451 25.9777 53.2457 25.9777 53.6127C25.9777 53.9317 25.8572 54.3007 25.7337 54.6714C25.7056 54.7562 25.6772 54.8403 25.6491 54.925Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M20.3779 64.1499C20.3769 64.1499 20.3759 64.1499 20.3746 64.1499C19.7337 64.1489 19.22 63.7672 18.6697 63.4946C18.4907 63.4058 18.3076 63.3287 18.1152 63.2804C18.3217 63.0234 18.5325 62.7709 18.7317 62.5066C18.7691 62.4569 18.8056 62.3458 18.8053 62.2957C18.8053 62.2847 18.8033 62.2767 18.7996 62.2727C18.7303 62.2046 18.6383 62.1092 18.5576 62.0865C18.5459 62.0832 18.5349 62.0815 18.5238 62.0815C18.5235 62.0815 18.5231 62.0815 18.5228 62.0815C18.5148 62.0815 18.5068 62.0825 18.4991 62.0848C18.4984 62.0848 18.4977 62.0852 18.497 62.0855C18.0703 62.2173 17.6282 62.3378 17.2367 62.5807C17.0037 62.7248 16.8545 63.0878 16.6677 63.3521L16.6516 63.3608C16.5208 63.1816 16.4552 62.9894 16.4548 62.7912C16.4542 62.587 16.5228 62.3765 16.6603 62.1682C16.8514 61.8786 17.1011 61.6354 17.3297 61.3781C17.3364 61.3708 17.3427 61.3634 17.3494 61.3564C17.3514 61.3541 17.3535 61.3518 17.3558 61.3494C17.3568 61.3484 17.3578 61.3471 17.3591 61.3458C17.3625 61.3421 17.3662 61.3384 17.3695 61.3348C17.3735 61.3304 17.3779 61.3261 17.3819 61.3221C17.563 61.1352 17.7631 61.0175 17.982 61.0165C17.983 61.0165 17.9836 61.0165 17.9846 61.0165C17.9853 61.0165 17.9857 61.0165 17.986 61.0165C18.0405 61.0165 18.0964 61.0238 18.1533 61.0395C18.1573 61.0405 18.1614 61.0415 18.1654 61.0428C18.6637 61.1866 19.1567 61.3481 19.6517 61.5023C19.5469 61.8342 19.393 62.1642 19.3505 62.4989C19.3498 62.5046 19.3491 62.5106 19.3485 62.5162C19.3475 62.5253 19.3468 62.5339 19.3461 62.5423V62.5426C19.3314 62.7241 19.3843 62.7982 19.4713 62.7999C19.4723 62.7999 19.4733 62.7999 19.4746 62.7999C19.4863 62.7999 19.4987 62.7989 19.5115 62.7962C19.5794 62.7832 19.6614 62.7368 19.7461 62.6694C20.0235 62.7622 20.301 62.8553 20.5781 62.9484L20.5874 62.9637C20.6145 63.3497 20.642 63.7358 20.6691 64.1222L20.6531 64.1265C20.649 64.1272 20.6453 64.1279 20.6417 64.1285C20.6366 64.1292 20.6316 64.1302 20.6266 64.1309C20.5416 64.1439 20.4593 64.1499 20.3789 64.1499C20.3786 64.1499 20.3783 64.1499 20.3779 64.1499Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M19.5645 52.1218C19.5642 52.1218 19.5642 52.1218 19.5639 52.1218C19.5585 52.1218 19.5535 52.1218 19.5488 52.1215C19.5465 52.1215 19.5441 52.1211 19.5418 52.1211C19.4099 52.1118 19.2349 52.0184 19.1857 51.8939C18.855 51.0601 18.5424 50.2139 18.2539 49.3551C18.2476 49.3364 18.2446 49.3137 18.2449 49.289C18.2456 49.1615 18.3229 48.9704 18.4039 48.8799C18.4062 48.8776 18.4082 48.8753 18.4106 48.8729C18.4112 48.8719 18.4122 48.8713 18.4129 48.8703C18.5083 48.7732 18.6776 48.7268 18.8085 48.7258C18.8095 48.7258 18.8108 48.7258 18.8118 48.7258C18.8149 48.7258 18.8179 48.7261 18.8209 48.7261C19.2452 48.7334 19.519 49.0364 19.597 49.4652C19.6224 49.607 19.6311 49.7548 19.6315 49.9126C19.6318 50.2036 19.603 50.5279 19.5993 50.9066C20.0525 50.8192 20.349 50.7621 20.6502 50.7038C20.6747 50.7935 20.6857 50.8742 20.6857 50.9476C20.6844 51.4435 20.1757 51.604 19.9484 51.944C19.9471 51.946 19.9454 51.9483 19.9437 51.9507C19.942 51.953 19.9404 51.9553 19.9384 51.9577C19.9374 51.9593 19.936 51.9607 19.9347 51.9623C19.934 51.9633 19.9334 51.964 19.9327 51.965C19.932 51.9657 19.9313 51.9663 19.9307 51.9673C19.8597 52.0498 19.7248 52.1058 19.6124 52.1188C19.596 52.1208 19.5799 52.1218 19.5645 52.1218Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M31.6514 56.6809C31.4221 56.2348 31.2605 55.9205 31.0988 55.6058C31.0543 55.3629 31.0382 55.103 30.9583 54.8811C30.9572 54.8781 30.9559 54.8751 30.9549 54.8721C30.9535 54.8684 30.9522 54.8648 30.9505 54.8611C30.9492 54.8578 30.9482 54.8548 30.9469 54.8518C30.9465 54.8514 30.9465 54.8511 30.9465 54.8508C30.8946 54.727 30.8194 54.6642 30.735 54.6622C30.7337 54.6622 30.732 54.6622 30.7307 54.6622C30.73 54.6622 30.7293 54.6622 30.7287 54.6622C30.646 54.6632 30.555 54.722 30.47 54.8387C30.4683 54.8407 30.4666 54.8431 30.4649 54.8454C30.3675 54.9819 30.321 55.1641 30.2514 55.3252C30.1072 55.2755 29.9632 55.2251 29.8193 55.1748C29.9355 54.8338 30.0519 54.4924 30.1681 54.1511C30.1396 53.756 30.1112 53.3613 30.0827 52.9662C30.2009 52.6282 30.319 52.2902 30.4371 51.9522C30.5757 52.0003 30.7146 52.0487 30.8535 52.0967C30.8615 52.7277 31.0633 53.2178 31.554 53.4684C31.8629 53.6262 31.9743 53.8678 31.974 54.1611C31.974 54.3313 31.9362 54.5191 31.8776 54.718C31.8719 54.7613 31.8692 54.803 31.8692 54.8431C31.8686 55.073 31.9556 55.2492 32.1263 55.3739L32.1269 55.3743C31.984 55.7664 31.8415 56.1587 31.6514 56.6809Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M28.2806 56.9507C27.9288 56.6117 27.6879 56.1095 27.1775 56.0044C27.479 55.7508 27.7605 55.4359 28.0864 55.2557C28.8174 54.8506 29.2826 54.2343 29.4914 53.3514C29.5493 53.1799 29.6072 53.0088 29.6655 52.8373C29.8034 52.8833 29.9426 52.9263 30.0828 52.9664C30.1113 53.3614 30.1397 53.7562 30.1682 54.1513C29.7916 54.3641 29.64 54.4499 29.639 54.6267C29.6384 54.7458 29.706 54.9063 29.8194 55.1749C29.9633 55.2253 30.1072 55.2757 30.2515 55.3254C30.0293 55.8703 29.9827 56.5663 29.3033 56.7158C29.3351 56.4842 29.3954 56.2463 29.3957 56.0211C29.3957 55.9958 29.3951 55.9704 29.3934 55.9454C29.3867 55.8352 29.2063 55.7628 29.1045 55.6731C29.0299 55.7999 28.9198 55.9207 28.89 56.0548C28.8756 56.1205 28.8709 56.1879 28.8709 56.256C28.8706 56.3625 28.8813 56.4705 28.8817 56.577C28.88 56.577 28.8787 56.577 28.8773 56.577C28.8753 56.577 28.8736 56.577 28.8716 56.577C28.6303 56.5786 28.4352 56.7001 28.2863 56.9414C28.2843 56.9444 28.2823 56.9473 28.2806 56.9507Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M13.4103 59.8909C13.4097 59.8909 13.4087 59.8909 13.408 59.8909C13.1075 59.8899 12.9378 59.691 12.8043 59.4528C12.8032 59.4514 12.8022 59.4497 12.8012 59.4481C12.7976 59.4411 12.7939 59.4344 12.7902 59.4274C12.6824 59.2302 12.6208 59.012 12.6208 58.7834C12.6212 58.5879 12.6664 58.385 12.7664 58.1802C13.0071 57.688 13.3652 57.326 13.8538 56.9933C14.0827 57.2476 14.1597 57.5128 14.1597 57.7814C14.16 58.3353 13.8327 58.9036 13.8331 59.4194C13.8331 59.5369 13.8501 59.6513 13.892 59.7624C13.8809 59.7678 13.8702 59.7727 13.8595 59.7774C13.8555 59.7791 13.8518 59.7808 13.8481 59.7824C13.8478 59.7824 13.8478 59.7828 13.8474 59.7828C13.6791 59.8572 13.5375 59.8899 13.4167 59.8909C13.4147 59.8909 13.4124 59.8909 13.4103 59.8909Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M21.4782 60.7715C21.4772 60.7715 21.4758 60.7715 21.4745 60.7715C21.3798 60.7712 21.2854 60.7678 21.1907 60.7641C21.1826 60.7638 21.1746 60.7635 21.1666 60.7631C21.1087 60.7608 21.0508 60.7588 20.9929 60.7571C20.95 60.7558 20.9069 60.7551 20.864 60.7551C20.862 60.7551 20.86 60.7551 20.8577 60.7551C20.854 60.7551 20.8506 60.7551 20.847 60.7551C20.8138 60.3664 20.7807 59.9777 20.7476 59.5893C20.8118 59.4171 20.8761 59.2446 20.9403 59.0724C21.1308 59.285 21.3025 59.5259 21.517 59.7011C21.5207 59.7044 21.5247 59.7074 21.5287 59.7104C21.5893 59.7568 21.6539 59.7821 21.7144 59.7825C21.7148 59.7825 21.7155 59.7825 21.7158 59.7825C21.7168 59.7825 21.7178 59.7825 21.7188 59.7825C21.8349 59.7811 21.937 59.6874 21.9728 59.4735C22.022 59.1809 22.1408 59.0217 22.3895 58.984C22.5317 59.0311 22.6743 59.0781 22.8165 59.1252C22.761 59.3 22.7054 59.4752 22.6502 59.65C22.5649 60.6073 22.5655 60.6297 21.8738 60.7431C21.8661 60.7444 21.8584 60.7455 21.851 60.7468C21.8487 60.7471 21.8463 60.7474 21.8443 60.7478C21.8319 60.7494 21.8195 60.7511 21.8072 60.7528C21.6991 60.7665 21.5906 60.7712 21.4825 60.7715C21.4812 60.7715 21.4798 60.7715 21.4782 60.7715ZM20.9403 59.0724C20.94 59.0721 20.9393 59.0718 20.939 59.0711L20.941 59.0708C20.9407 59.0711 20.9407 59.0718 20.9403 59.0724Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M31.9909 47.3267C31.7429 47.0614 31.5144 46.7664 31.2413 46.5396C31.0348 46.3687 30.7549 46.2356 30.7556 45.9576C30.756 45.8689 30.7851 45.7651 30.854 45.641C30.8554 45.6386 30.8567 45.636 30.8584 45.6336C30.8587 45.633 30.8591 45.6323 30.8594 45.6316C30.8601 45.6306 30.8607 45.6297 30.8611 45.6287C30.9544 45.4708 31.091 45.4251 31.2386 45.4248C31.2392 45.4248 31.2396 45.4248 31.2402 45.4248C31.2416 45.4248 31.2426 45.4248 31.2436 45.4248C31.3611 45.4254 31.4852 45.4538 31.6004 45.4768C31.6047 45.4775 31.6094 45.4785 31.6138 45.4795C31.6228 45.4811 31.6315 45.4828 31.6405 45.4845C31.6465 45.4855 31.6526 45.4868 31.6586 45.4878L31.6696 45.5092C31.7473 45.7264 31.7831 45.9897 31.912 46.1508C32.0572 46.3323 32.1081 46.5275 32.1081 46.7334C32.1081 46.9179 32.0669 47.1108 32.0157 47.31L31.9909 47.3267Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M25.5552 56.6104C25.4712 56.3901 25.3872 56.1699 25.3032 55.9494C25.4184 55.6087 25.5338 55.268 25.6493 54.927C26.003 55.2614 26.242 55.7655 26.7514 55.869C26.4308 56.3197 26.0325 56.5676 25.5552 56.6104ZM25.6493 54.927C25.6489 54.927 25.6486 54.9267 25.6486 54.9264L25.6499 54.9257C25.6496 54.9264 25.6496 54.9267 25.6493 54.927Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M26.2258 57.4158C25.9491 57.3097 25.6723 57.2032 25.3955 57.0971C25.4484 56.9346 25.5016 56.7724 25.5551 56.6103C26.0324 56.5676 26.4307 56.3197 26.7513 55.8689C26.8928 55.9139 27.0344 55.9593 27.1756 56.0054C27.1817 56.1759 27.173 56.351 27.1967 56.5162C27.2024 56.5583 27.2054 56.5973 27.2054 56.6333C27.2065 56.8869 27.0675 57.0027 26.8303 57.037C26.8279 57.037 26.8256 57.037 26.8232 57.037C26.8216 57.037 26.8196 57.037 26.8179 57.037C26.5853 57.0387 26.3952 57.1508 26.2516 57.3871C26.2496 57.3901 26.2476 57.3931 26.2459 57.3964L26.2258 57.4158Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M23.5096 57.0703C23.5073 57.062 23.5049 57.0536 23.5026 57.045C23.4975 57.0266 23.4929 57.0083 23.4882 56.9906C23.4878 56.9886 23.4875 56.9869 23.4868 56.9852C23.4865 56.9829 23.4858 56.9806 23.4852 56.9786C23.3403 56.395 23.443 56.1147 23.8158 56.1137C23.8165 56.1137 23.8175 56.1137 23.8182 56.1137C23.8185 56.1137 23.8185 56.1137 23.8188 56.1137C23.8429 56.1137 23.8684 56.115 23.8948 56.1174C23.8981 56.1174 23.9015 56.1177 23.9052 56.118C24.1776 56.1451 24.4367 56.2498 24.7024 56.3196C24.3868 56.7794 23.9872 57.0243 23.5096 57.0703Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M7.29176 60.2317C7.14551 60.1783 6.99926 60.1249 6.85367 60.0715C6.74758 59.7272 6.68198 59.5023 6.68164 59.3298C6.68097 59.0272 6.88044 58.8847 7.41257 58.5413C7.44437 58.6685 7.52569 58.8577 7.52569 58.9451C7.52569 58.9621 7.52269 58.9754 7.51533 58.9834C7.32222 59.195 7.27838 59.4135 7.27838 59.6341C7.27804 59.8153 7.30715 59.9975 7.30715 60.178C7.30715 60.1927 7.30682 60.207 7.30648 60.2217C7.3028 60.2183 7.29913 60.2153 7.29578 60.212C7.29444 60.2187 7.2931 60.2253 7.29176 60.2317Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M8.50875 56.6282C8.37019 56.4593 8.30427 56.2778 8.30494 56.085C8.30561 55.9041 8.3655 55.7133 8.47963 55.5138C8.48331 55.5074 8.48699 55.5011 8.49068 55.4947C8.49101 55.4944 8.49102 55.4944 8.49102 55.494C8.49336 55.4904 8.49536 55.4867 8.4977 55.4834C8.49804 55.4827 8.49837 55.4817 8.49904 55.481C8.65701 55.2248 8.84209 55.1567 9.03654 55.1557C9.03788 55.1557 9.03955 55.1557 9.04123 55.1557C9.04223 55.1557 9.04323 55.1557 9.04423 55.1557C9.15301 55.156 9.26411 55.1768 9.37556 55.1968C9.38493 55.1984 9.39432 55.2001 9.40369 55.2018C9.40436 55.2021 9.40503 55.2021 9.4057 55.2021C9.41808 55.2044 9.43045 55.2064 9.44317 55.2088C9.31298 55.8317 8.84544 56.1757 8.50875 56.6282Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M14.6701 59.9321C14.6523 59.8637 14.6102 59.789 14.6102 59.7249C14.6098 59.7136 14.6112 59.7029 14.6142 59.6922C14.7551 59.192 14.8304 58.6595 15.3381 58.1086C15.3592 58.2258 15.3685 58.3365 15.3689 58.4423C15.3692 58.9518 15.154 59.3439 14.991 59.7403C14.9522 59.8347 14.7805 59.8697 14.6701 59.9321Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M7.77175 61.519C7.33867 61.2645 7.18808 61.1757 7.18774 60.8904C7.18774 60.7416 7.22857 60.5391 7.29182 60.2314C7.29316 60.2251 7.29451 60.2184 7.29584 60.2118C7.29919 60.2151 7.30287 60.2181 7.30655 60.2214C7.60977 60.4954 7.78681 60.8444 7.78547 61.2998C7.78547 61.3703 7.78078 61.4433 7.77175 61.519Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M19.4745 62.7998C19.4731 62.7998 19.4721 62.7998 19.4711 62.7998C19.3841 62.7981 19.3312 62.7241 19.346 62.5426V62.5422C19.3466 62.5339 19.3473 62.5252 19.3483 62.5162C19.349 62.5105 19.3496 62.5045 19.3503 62.4989C19.3928 62.1642 19.5468 61.8342 19.6515 61.5022C19.8138 61.6583 19.8694 61.8402 19.8691 62.0354C19.8687 62.2369 19.8088 62.4528 19.7459 62.6694C19.6612 62.7368 19.5792 62.7831 19.5113 62.7962C19.4986 62.7988 19.4862 62.7998 19.4745 62.7998Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M32.6624 48.1289C32.317 47.9998 31.9991 47.8389 31.9907 47.3271L32.0155 47.3104C32.3579 47.4422 32.6695 47.6087 32.6788 48.1145L32.6624 48.1289Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M8.35596 57.1619C8.40683 56.984 8.45769 56.8058 8.5089 56.6283C8.63039 56.7421 8.6923 56.8405 8.69163 56.9226C8.6913 57.0317 8.58086 57.1118 8.35596 57.1619Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M13.5618 51.4565L13.5608 51.4539C13.5631 51.4536 13.5651 51.4532 13.5671 51.4532C13.5655 51.4542 13.5638 51.4552 13.5618 51.4565ZM13.5671 51.4532C13.6592 51.3955 13.7512 51.3378 13.8433 51.28C13.8151 51.3284 13.7941 51.4012 13.7569 51.4195C13.699 51.4486 13.6314 51.4449 13.5671 51.4532Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M24.8764 55.8123C24.8764 55.8109 24.8764 55.8096 24.8764 55.8079C24.8768 55.8093 24.8774 55.8106 24.8778 55.8116L24.8764 55.8123ZM24.8764 55.8079C24.837 55.7062 24.7977 55.6047 24.7583 55.5026C24.797 55.5303 24.8571 55.5463 24.8691 55.587C24.8774 55.6164 24.8797 55.6484 24.8797 55.6818C24.8797 55.7225 24.8764 55.7645 24.8764 55.8053C24.8764 55.8063 24.8764 55.8073 24.8764 55.8079Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M27.6737 78.4795C27.6707 78.4795 27.668 78.4795 27.665 78.4791C27.8504 78.1201 27.9274 77.8085 27.9271 77.5309C27.9261 76.8919 27.5147 76.4334 27.074 75.988C27.2915 75.3167 27.5395 74.6523 27.7122 73.9717C27.7343 73.8859 27.7457 73.7988 27.7457 73.7117C27.7457 73.4618 27.6513 73.2143 27.4411 73.0131C27.2728 73.1072 27.0843 73.2583 26.8855 73.312C26.5954 73.3904 26.2835 73.3354 26.0087 73.4555C25.7386 73.5743 25.4826 73.8135 25.258 74.0494C25.1228 74.1912 25.0699 74.3323 25.0699 74.4752C25.0699 74.6296 25.1318 74.7865 25.2185 74.9493C25.2905 75.0854 25.3186 75.2239 25.3189 75.3637C25.3199 75.7214 25.1395 76.0881 25.0498 76.4475C24.7754 76.6019 24.501 76.7561 24.2262 76.9103C23.4872 75.5125 23.35 75.2529 23.3497 74.5669C23.3497 74.4108 23.3567 74.2323 23.3654 74.0134C23.0073 73.8105 22.6371 73.601 22.2663 73.3918C22.1659 73.4965 21.9879 73.6036 21.9805 73.7051C21.9467 74.1462 21.9547 74.5856 21.612 74.9316C21.6026 74.941 21.5923 74.9506 21.5809 74.96C21.5802 74.9603 21.5796 74.9606 21.5792 74.9613C21.5595 74.977 21.5377 74.9923 21.516 75.0047C21.5123 75.0067 21.5089 75.0084 21.5056 75.0104C21.5009 75.0127 21.4966 75.0147 21.4922 75.017C21.4855 75.02 21.4792 75.0224 21.4728 75.0247C21.4668 75.0271 21.4608 75.0287 21.4547 75.03C21.4474 75.0317 21.4403 75.0327 21.434 75.0327C21.4333 75.0327 21.433 75.0327 21.4323 75.0327C21.4269 75.0327 21.4216 75.0317 21.4169 75.03C21.4156 75.0297 21.4142 75.029 21.4129 75.0287C21.3031 74.977 21.122 74.8792 21.122 74.8025C21.122 74.8008 21.1224 74.7988 21.1224 74.7972C21.1833 74.2813 21.2439 73.7551 21.3888 73.255C21.4166 73.1589 21.429 73.0778 21.429 73.0084C21.43 72.621 21.0548 72.5913 20.8848 72.3721C20.9135 71.6724 21.6375 71.4331 21.7429 70.7725C21.7978 70.4288 21.9604 70.0938 22.0746 69.7551C22.4089 69.9073 22.1793 70.5643 22.604 70.6414C22.7553 70.4145 22.8841 70.1889 23.0421 69.9951C23.0438 69.9927 23.0458 69.9904 23.0478 69.988C23.0481 69.9874 23.0488 69.9867 23.0495 69.9864C23.0903 69.9383 23.1294 69.915 23.1663 69.9126C23.1683 69.9126 23.1703 69.9123 23.1719 69.9123C23.1736 69.9123 23.1753 69.9126 23.177 69.9126C23.2419 69.916 23.3005 69.9847 23.3534 70.0992C23.3537 70.1002 23.3544 70.1015 23.3547 70.1025C23.356 70.1052 23.3574 70.1082 23.3587 70.1108C23.4149 70.237 23.5304 70.3217 23.6194 70.4248C23.7011 70.2737 23.8296 70.1268 23.8557 69.9704C23.8708 69.8813 23.8778 69.7982 23.8775 69.7208C23.8761 69.1602 23.5003 68.9003 23.1131 68.6607C23.1094 68.6604 23.1057 68.6601 23.1023 68.6601C23.0933 68.6594 23.0846 68.6594 23.0756 68.6594C22.8995 68.6594 22.7302 68.7435 22.5575 68.8276C22.3845 68.912 22.2077 68.9964 22.0173 68.9964C21.9946 68.9964 21.9718 68.9951 21.9484 68.9924C21.8851 68.9854 21.8199 68.9684 21.7526 68.938C21.7519 68.9377 21.7509 68.9373 21.7499 68.937C21.7446 68.9343 21.7392 68.932 21.7335 68.9293C21.4788 68.5329 21.188 68.0798 20.8972 67.6267C21.1271 66.9453 21.357 66.264 21.5873 65.5827C21.7573 65.7388 21.7951 65.943 21.7954 66.1663C21.7954 66.3428 21.7723 66.5316 21.7727 66.7188C21.7727 66.9333 21.8038 67.1456 21.9357 67.3351C22.3249 67.4656 22.8015 67.6247 23.2817 67.7855C23.4822 67.3171 23.1589 66.6778 23.7168 66.276C23.7198 66.2727 23.7228 66.2693 23.7262 66.2657C23.7272 66.2647 23.7282 66.2637 23.7292 66.2627C23.8527 66.1279 23.9775 66.0478 24.1037 66.0031C24.2068 65.9664 24.3102 65.9534 24.4143 65.9534C24.5431 65.9534 24.6723 65.9734 24.8018 65.9934C24.8042 65.9938 24.8069 65.9941 24.8092 65.9944C24.9344 66.0138 25.0595 66.0324 25.184 66.0331C25.186 66.0331 25.1881 66.0331 25.1901 66.0331C25.1911 66.0331 25.1917 66.0331 25.1924 66.0331C25.255 66.0331 25.3172 66.0281 25.3795 66.0164C25.3895 66.0144 25.3996 66.0124 25.4096 66.0101C25.41 66.0101 25.4106 66.0101 25.411 66.0097C25.4143 66.0091 25.4177 66.0088 25.4213 66.0088H25.4217C25.4227 66.0088 25.4237 66.0088 25.4243 66.0088C25.5013 66.0124 25.5893 66.1686 25.676 66.3214C25.6867 66.3397 25.6971 66.3584 25.7078 66.3768C25.7128 66.3858 25.7182 66.3948 25.7235 66.4038C25.7255 66.4075 25.7276 66.4111 25.7299 66.4145C25.7399 66.4315 25.7496 66.4475 25.7593 66.4632C25.765 66.4719 25.7704 66.4806 25.7761 66.4889C25.7764 66.4892 25.7768 66.4899 25.7771 66.4906C25.7788 66.4929 25.7804 66.4956 25.7821 66.4979C25.7828 66.4986 25.7831 66.4996 25.7838 66.5002C25.7861 66.5036 25.7885 66.5073 25.7908 66.5106C25.7911 66.5113 25.7918 66.5119 25.7921 66.5126C25.7942 66.5153 25.7962 66.5183 25.7982 66.5213C25.7988 66.5226 25.7998 66.5243 25.8009 66.526C25.8035 66.5306 25.8062 66.5356 25.8089 66.5406C25.915 66.7578 25.7028 67.2096 26.0107 67.2109C26.011 67.2109 26.0114 67.2109 26.012 67.2109C26.013 67.2109 26.014 67.2109 26.015 67.2109C26.0378 67.2023 26.0592 67.1919 26.0793 67.1806C26.3899 67.0071 26.421 66.5666 26.839 66.5656C26.8397 66.5656 26.8404 66.5656 26.8407 66.5656C26.8517 66.5656 26.8628 66.566 26.8745 66.5663C26.7554 66.9877 26.6416 67.3935 26.5271 67.7992C26.4856 67.962 26.4341 68.1232 26.4063 68.287C26.4046 68.2964 26.4039 68.307 26.4039 68.3187C26.4039 68.3297 26.4046 68.3417 26.406 68.3537C26.4123 68.4231 26.4351 68.5006 26.4428 68.5006C26.5475 68.4799 26.6864 68.4705 26.7466 68.3908C26.8407 68.2657 26.8815 68.0881 26.9451 67.9327C27.003 67.7662 27.0633 67.6004 27.1248 67.4352C27.1349 67.4385 27.1449 67.4415 27.1549 67.4445C27.1593 67.4458 27.1637 67.4472 27.1683 67.4485C27.2985 67.4876 27.4287 67.5183 27.5562 67.5189C27.5576 67.5189 27.5586 67.5189 27.5596 67.5189C27.5613 67.5189 27.5629 67.5189 27.5646 67.5189C27.756 67.5179 27.9425 67.4479 28.1192 67.2356C28.1215 67.233 28.1239 67.23 28.1259 67.2273C28.1306 67.222 28.1349 67.2163 28.1396 67.2106C28.1409 67.2089 28.1422 67.2069 28.1436 67.2053C28.2868 67.2493 28.4297 67.2937 28.573 67.3381C28.5991 67.7305 28.6252 68.1225 28.6516 68.5146L28.6503 68.5126C28.649 68.5136 28.6476 68.5146 28.646 68.5152C28.582 68.5242 28.5141 68.5199 28.4558 68.5493C28.419 68.5676 28.3976 68.64 28.3698 68.6884C28.4616 68.6307 28.5539 68.573 28.646 68.5152C28.648 68.5152 28.6496 68.5149 28.6513 68.5146C28.728 68.649 28.8538 68.7702 28.8695 68.921C28.9077 69.2873 29.0091 69.4972 29.229 69.4989C29.23 69.4989 29.2306 69.4989 29.2316 69.4989C29.2337 69.4989 29.236 69.4989 29.2383 69.4989C29.3283 69.4972 29.4375 69.4615 29.57 69.3888C29.5723 69.3875 29.575 69.3858 29.5774 69.3845C29.5824 69.3818 29.5871 69.3791 29.5921 69.3764C29.7193 69.3034 29.8806 69.3274 30.0265 69.307C30.0874 69.4986 30.1162 69.6894 30.1168 69.8796C30.1178 70.243 30.0168 70.604 29.8438 70.9627C29.7919 70.9804 29.745 70.9884 29.7025 70.9884C29.7018 70.9884 29.7015 70.9884 29.7008 70.9884C29.6995 70.9884 29.6978 70.9884 29.6965 70.9884C29.4739 70.9854 29.3618 70.7685 29.2152 70.6183C29.2126 70.6153 29.2095 70.6127 29.2069 70.6097C29.2018 70.6047 29.1968 70.6 29.1915 70.595C29.1774 70.5816 29.163 70.5693 29.1483 70.5576C29.145 70.5553 29.1419 70.5526 29.1386 70.5503C29.1282 70.5426 29.1178 70.5352 29.1071 70.5282C28.9977 70.4545 28.8802 70.4158 28.7634 70.4155C28.7628 70.4155 28.7621 70.4155 28.7614 70.4155C28.7604 70.4155 28.7591 70.4155 28.7577 70.4155C28.6142 70.4165 28.4716 70.4755 28.3454 70.5997C28.3431 70.6017 28.341 70.604 28.3387 70.606C28.3357 70.609 28.3327 70.612 28.3297 70.6153C28.3243 70.621 28.319 70.6267 28.3136 70.6327C28.1941 70.7631 28.1476 70.8689 28.1473 70.957C28.1466 71.1379 28.3404 71.246 28.5027 71.3454C28.9134 71.5973 29.0994 72.0164 29.1319 72.5606C29.1573 72.9877 29.1881 73.4134 29.2166 73.8399C28.8601 74.1211 28.7012 74.2953 28.7005 74.4755C28.7002 74.5703 28.743 74.6664 28.8237 74.7805C29.0466 75.0965 29.3059 75.3757 29.5496 75.6707C29.5603 75.6713 29.5706 75.6717 29.5814 75.6717C29.5814 75.6717 29.5817 75.6717 29.582 75.6717C29.5837 75.6717 29.5857 75.6717 29.5874 75.6717C29.8039 75.6697 29.9827 75.5626 30.1246 75.3547C30.1323 75.343 30.14 75.3313 30.1477 75.319C30.1493 75.3167 30.1507 75.3143 30.1523 75.3117C30.2936 75.3574 30.4351 75.4044 30.576 75.4525C30.5724 75.4885 30.5707 75.5239 30.5707 75.5579C30.57 75.7961 30.6567 75.9793 30.8338 76.1055C30.9747 76.1532 31.1159 76.2002 31.2568 76.2469C31.2551 76.2489 31.2534 76.2509 31.2517 76.2529C31.0647 76.4711 30.8541 76.5676 30.6239 76.5683C30.6229 76.5683 30.6222 76.5683 30.6212 76.5683C30.6209 76.5683 30.6205 76.5683 30.6199 76.5683C30.5697 76.5683 30.5188 76.5636 30.4666 76.5549C30.4632 76.5542 30.4599 76.5536 30.4562 76.5532C30.4539 76.5529 30.4515 76.5526 30.4495 76.5522C30.4037 76.5449 30.3612 76.5416 30.322 76.5416C30.3217 76.5416 30.3213 76.5416 30.321 76.5416C29.9482 76.5416 29.8702 76.8509 29.8655 77.2853C29.8628 77.5245 29.7668 77.7751 29.7126 78.0203C29.5118 78.1448 29.3113 78.2696 29.1102 78.3941C28.9699 78.3453 28.8293 78.2976 28.6884 78.2506C28.7293 78.0888 28.7792 77.9279 28.8063 77.7648C28.8069 77.7621 28.8073 77.7591 28.8076 77.7561C28.8083 77.7484 28.8086 77.7397 28.8086 77.7311C28.8086 77.7114 28.8066 77.6897 28.8036 77.6683C28.8029 77.6637 28.8022 77.6593 28.8016 77.6546C28.8009 77.6513 28.8002 77.6483 28.7996 77.645C28.7989 77.641 28.7982 77.637 28.7975 77.6333C28.7969 77.6296 28.7959 77.6256 28.7952 77.622C28.7865 77.5819 28.7758 77.5516 28.7704 77.5516C28.666 77.5702 28.5278 77.5779 28.4666 77.657C28.3708 77.7805 28.3273 77.9569 28.2621 78.1108C28.2587 78.1161 28.2557 78.1215 28.2524 78.1268C28.251 78.1285 28.25 78.1301 28.249 78.1318C28.2483 78.1328 28.2477 78.1341 28.247 78.1351C28.1004 78.3647 27.9096 78.4785 27.6764 78.4795C27.6754 78.4795 27.6744 78.4795 27.6737 78.4795Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M28.7652 83.606C28.7649 83.606 28.7646 83.606 28.7646 83.606C28.7572 83.6056 28.7508 83.6043 28.7455 83.6013C28.1695 83.2713 27.4998 83.31 26.8736 83.1815C26.7431 82.0911 25.8719 82.4518 25.295 82.2863C24.6691 82.1065 23.9994 82.0708 23.3488 81.9723C23.3394 81.981 23.3301 81.9893 23.321 81.9977H23.3207C23.0951 82.1996 22.9017 82.2786 22.7243 82.2793C22.7233 82.2793 22.7226 82.2793 22.722 82.2793C22.7206 82.2793 22.7193 82.2793 22.7183 82.2793C22.4188 82.2776 22.1644 82.0528 21.8752 81.8192C21.8712 81.8159 21.8672 81.8128 21.8632 81.8095C21.8615 81.8082 21.8598 81.8068 21.8582 81.8055C21.8431 81.7932 21.8277 81.7808 21.8123 81.7688C21.808 81.7654 21.8036 81.7621 21.7996 81.7588C21.3461 81.4014 20.7005 81.348 20.1915 81.1775C20.1824 81.1262 20.1781 81.0791 20.1777 81.0354C20.1751 80.4548 20.9097 80.5386 20.909 79.9837C20.909 79.9543 20.907 79.9233 20.9027 79.8899C20.8966 79.8442 20.8939 79.7978 20.8939 79.7505C20.8946 79.3934 21.0459 78.9944 21.0496 78.626C21.0596 77.6621 21.0392 77.6604 21.7143 77.4465C21.9382 77.3754 22.1657 77.3324 22.392 77.2767C22.6109 77.2807 22.8311 77.275 23.0469 77.2954C23.1022 77.3004 23.144 77.3871 23.2277 77.4728C23.0406 78.5039 21.907 79.1559 21.908 80.4248C21.908 80.5713 21.9234 80.7261 21.9569 80.8906C22.2792 80.5573 22.5734 80.2529 22.8572 79.9597C23.8636 80.7077 24.9044 81.0237 25.9556 81.315C25.9596 81.316 25.9637 81.3173 25.9677 81.3183C25.9683 81.3183 25.969 81.3187 25.9697 81.3187C26.0329 81.335 26.0948 81.343 26.1554 81.343C26.1558 81.343 26.1564 81.343 26.1571 81.343C26.1578 81.343 26.1588 81.343 26.1598 81.343C26.3773 81.3424 26.5805 81.2416 26.7742 81.0704C26.7749 81.0698 26.7756 81.0691 26.7766 81.0684C26.7839 81.0618 26.7916 81.0551 26.799 81.0481C26.9269 81.1061 27.0855 81.1268 27.1772 81.2286C27.1862 81.2386 27.1953 81.2486 27.2043 81.2583C27.4623 81.5339 27.7522 81.687 28.0902 81.6877C28.0912 81.6877 28.0919 81.6877 28.0929 81.6877C28.0935 81.6877 28.0939 81.6877 28.0945 81.6877C28.2154 81.6877 28.3422 81.668 28.4758 81.6277C28.4841 81.625 28.4925 81.6226 28.5009 81.62L28.5025 81.6193C28.5019 81.6196 28.5015 81.6196 28.5009 81.62C28.5584 81.4491 28.615 81.2786 28.6708 81.1078C28.8154 81.1549 28.9604 81.2019 29.1056 81.2486C29.4041 81.3957 29.704 81.5496 29.7044 81.9653C29.7044 82.0227 29.6987 82.0851 29.6866 82.1529C29.5902 82.6917 29.4209 83.1975 28.956 83.5045C28.943 83.5132 28.9285 83.5232 28.9135 83.5332C28.8991 83.5432 28.8841 83.5529 28.8693 83.5622C28.861 83.5672 28.8529 83.5723 28.8452 83.5766C28.8445 83.5769 28.8442 83.5773 28.8435 83.5776C28.8328 83.5836 28.8221 83.5889 28.8121 83.5936C28.8111 83.5939 28.8104 83.5943 28.8094 83.5946C28.8047 83.5966 28.8004 83.5983 28.796 83.6C28.795 83.6003 28.794 83.6006 28.793 83.6006C28.783 83.6039 28.7736 83.606 28.7652 83.606ZM28.6206 81.9286C28.5815 81.8272 28.5424 81.7258 28.5025 81.6247C28.5025 81.6227 28.5025 81.621 28.5025 81.6193L28.5009 81.62C28.5015 81.6216 28.5019 81.623 28.5025 81.6247C28.5025 81.625 28.5025 81.6257 28.5025 81.6263C28.5025 81.667 28.4992 81.7091 28.4992 81.7498C28.4988 81.7831 28.5012 81.8155 28.5096 81.8445C28.5216 81.8856 28.5822 81.9016 28.6206 81.9286Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M25.0498 76.4473C25.1395 76.0879 25.3199 75.7212 25.3189 75.3635C25.3186 75.2237 25.2904 75.0852 25.2185 74.9491C25.1318 74.7863 25.0699 74.6294 25.0699 74.475C25.0699 74.3322 25.1228 74.191 25.258 74.0492C25.4825 73.8133 25.7386 73.5741 26.0087 73.4553C26.2834 73.3352 26.5954 73.3902 26.8855 73.3118C27.0843 73.2581 27.2727 73.107 27.4411 73.0129C27.6513 73.2141 27.7456 73.4616 27.7456 73.7115C27.7456 73.7986 27.7342 73.8857 27.7122 73.9715C27.5395 74.6521 27.2915 75.3165 27.0739 75.9878C27.0656 75.9855 27.0572 75.9831 27.0492 75.9808C27.0472 75.9805 27.0455 75.9798 27.0438 75.9795C26.8992 75.9407 26.755 75.9161 26.6091 75.9157C26.6081 75.9157 26.6074 75.9157 26.6067 75.9157C26.6057 75.9157 26.6047 75.9157 26.6037 75.9157C26.4461 75.9161 26.2864 75.9451 26.1208 76.0168C26.1184 76.0178 26.1164 76.0185 26.1144 76.0195C26.1057 76.0232 26.0973 76.0272 26.0886 76.0312C26.0863 76.0322 26.084 76.0335 26.0816 76.0345C26.0779 76.0362 26.0743 76.0379 26.0706 76.0399C26.0662 76.0419 26.0622 76.0439 26.0579 76.0459C25.7299 76.208 25.3865 76.3155 25.0498 76.4473Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M19.6165 72.594C19.6158 72.594 19.6149 72.594 19.6142 72.594C19.5101 72.593 19.4171 72.5283 19.3655 72.3698C19.3648 72.3674 19.3639 72.3644 19.3628 72.3618C19.3622 72.3591 19.3612 72.3561 19.3602 72.3531C19.2879 72.1295 19.2283 71.9087 18.997 71.9053C18.995 71.9053 18.9934 71.9053 18.9914 71.9053C18.9914 71.9053 18.991 71.9053 18.9907 71.9053C18.98 71.9053 18.9686 71.9057 18.9569 71.9067C18.9532 71.907 18.9488 71.9073 18.9448 71.908C18.9401 71.9083 18.9358 71.909 18.9311 71.9093C18.9271 71.9097 18.9231 71.91 18.9191 71.9107C18.8826 71.914 18.8478 71.9157 18.8153 71.9157C18.815 71.9157 18.8143 71.9157 18.814 71.9157C18.1188 71.9147 18.3769 71.1583 18.2715 70.6367C18.2715 70.6364 18.2715 70.6364 18.2715 70.6361C18.2698 70.6284 18.2681 70.621 18.2664 70.6137C18.2661 70.611 18.2654 70.6084 18.2648 70.6057C18.0656 70.6908 17.8675 70.8132 17.6677 70.8463C17.654 70.8486 17.6392 70.8496 17.6242 70.8496C17.6205 70.8496 17.6168 70.8496 17.6128 70.8496C17.5061 70.8459 17.3772 70.7899 17.324 70.7105C17.319 70.7028 17.3143 70.6948 17.3106 70.6864C17.3103 70.6858 17.3099 70.6851 17.3096 70.6841C17.2949 70.6491 17.2878 70.598 17.2878 70.542C17.2875 70.4142 17.3223 70.261 17.3789 70.2136C17.6262 70.0061 17.9234 69.7362 18.1814 69.7295C18.2146 69.7288 18.2477 69.7282 18.2808 69.7282C18.2812 69.7282 18.2812 69.7282 18.2815 69.7282C18.2835 69.7282 18.2858 69.7282 18.2879 69.7282C18.7229 69.7288 19.1597 69.8009 19.6989 69.8756C19.7451 69.882 19.7922 69.8883 19.8398 69.8947C19.8408 69.895 19.8421 69.895 19.8431 69.8953C19.8742 69.8993 19.906 69.9037 19.9382 69.9077C19.9884 69.9143 20.0396 69.9207 20.0918 69.927C20.1005 69.9284 20.1092 69.9294 20.1182 69.9304C20.1189 69.9304 20.1195 69.9304 20.1205 69.9307C20.1379 69.9327 20.1557 69.9347 20.1734 69.937C20.226 70.5977 20.3033 71.1582 20.3036 71.7218C20.3036 71.7592 20.3033 71.7969 20.3026 71.8343C20.2989 72.0325 20.075 72.299 19.9033 72.4592C19.9 72.4622 19.8966 72.4652 19.8933 72.4682C19.8906 72.4706 19.8876 72.4732 19.8849 72.4755C19.8826 72.4772 19.8806 72.4792 19.8782 72.4812C19.8779 72.4812 19.8779 72.4816 19.8776 72.4819C19.7956 72.5506 19.7039 72.5933 19.6189 72.594C19.6182 72.594 19.6172 72.594 19.6165 72.594Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M23.2817 67.7854C22.8015 67.6246 22.3249 67.4654 21.9356 67.335C21.8038 67.1454 21.7727 66.9332 21.7727 66.7187C21.7723 66.5315 21.7954 66.3426 21.7954 66.1661C21.7951 65.9429 21.7573 65.7387 21.5872 65.5825C20.9581 65.3897 20.6535 64.8979 20.6528 64.1264L20.6689 64.1221C21.3252 64.4187 22.0113 64.6259 22.6622 64.9582C23.2442 65.2555 23.4685 65.7263 23.7168 66.2759C23.1589 66.6776 23.4822 67.3169 23.2817 67.7854Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M28.0927 81.6875C28.0917 81.6875 28.091 81.6875 28.09 81.6875C27.752 81.6868 27.4622 81.5337 27.2041 81.2581C27.1951 81.2484 27.186 81.2384 27.177 81.2284C27.0853 81.1266 26.9267 81.1059 26.7988 81.0479C27.0873 80.1917 27.3761 79.3352 27.665 78.479C27.668 78.4793 27.6707 78.4793 27.6737 78.4793C27.6743 78.4793 27.6753 78.4793 27.6763 78.4793C27.9096 78.4783 28.1004 78.3645 28.247 78.135C28.2477 78.134 28.2483 78.1326 28.249 78.1316C28.25 78.13 28.251 78.1283 28.2523 78.1266C28.2557 78.1213 28.2587 78.1159 28.262 78.1106C28.4039 78.1577 28.5459 78.2044 28.6878 78.2514C28.735 78.491 28.7564 78.6008 28.8196 78.6034C28.8206 78.6034 28.8213 78.6034 28.822 78.6034C28.8273 78.6034 28.8327 78.6028 28.8387 78.6014C28.8702 78.5938 28.911 78.5658 28.9666 78.5197C28.9702 78.5167 28.9739 78.5137 28.9776 78.5104C28.9987 78.4927 29.0221 78.4723 29.0475 78.4496C29.0509 78.4469 29.0542 78.444 29.0576 78.4409C29.0589 78.4396 29.0603 78.4383 29.0616 78.4373C29.0626 78.4363 29.0636 78.4356 29.0646 78.4346C29.0656 78.4339 29.0666 78.4329 29.0676 78.4319C29.0689 78.4306 29.0703 78.4296 29.072 78.4279C29.0753 78.4249 29.079 78.4219 29.0824 78.4186C29.084 78.4176 29.0854 78.4162 29.0867 78.4149C29.0931 78.4092 29.0997 78.4033 29.1068 78.3973C29.1078 78.3959 29.1091 78.3949 29.1101 78.3939C29.3113 78.2694 29.5117 78.1446 29.7126 78.0202V78.0205L29.7129 78.0209C29.737 78.4136 29.7614 78.8063 29.7855 79.1994C29.2276 79.2868 28.9555 79.857 28.6054 80.2651C28.5094 80.3765 28.4699 80.4977 28.4699 80.6184C28.4702 80.7923 28.5532 80.9655 28.6707 81.1076C28.6148 81.2784 28.5582 81.4489 28.5007 81.6198C28.4923 81.6224 28.484 81.6248 28.4756 81.6274C28.342 81.6678 28.2152 81.6875 28.0944 81.6875C28.0937 81.6875 28.0934 81.6875 28.0927 81.6875ZM28.5007 81.6198C28.5014 81.6194 28.5017 81.6194 28.5024 81.6191L28.5007 81.6198Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M22.604 70.6411C22.1793 70.564 22.4089 69.907 22.0745 69.7549C21.5765 69.4826 21.0735 69.2217 20.5832 68.9347C20.3108 68.7752 20.1736 68.6338 20.1746 68.4599C20.1759 68.2691 20.3439 68.0395 20.6833 67.7049C20.7361 67.6528 20.8248 67.6515 20.8971 67.6264C21.188 68.0795 21.4788 68.5327 21.7335 68.9291C21.7392 68.9317 21.7445 68.9341 21.7499 68.9368C21.7509 68.9371 21.7519 68.9374 21.7526 68.9378C21.8198 68.9681 21.8851 68.9851 21.9484 68.9921C21.9718 68.9948 21.9945 68.9962 22.0173 68.9962C22.2077 68.9962 22.3844 68.9117 22.5575 68.8276C22.7302 68.7432 22.8995 68.6591 23.0755 68.6591C23.0846 68.6591 23.0933 68.6591 23.1023 68.6598C23.1057 68.6598 23.1093 68.6601 23.113 68.6605C23.5003 68.9 23.8761 69.16 23.8774 69.7205C23.8778 69.7979 23.8707 69.881 23.8557 69.9701C23.8296 70.1266 23.7011 70.2734 23.6194 70.4246C23.5304 70.3215 23.4149 70.2367 23.3587 70.1106C23.3573 70.1079 23.356 70.1049 23.3547 70.1022C23.3543 70.1012 23.3537 70.0999 23.3533 70.0989C23.3005 69.9845 23.2419 69.9157 23.177 69.9124C23.1753 69.9124 23.1736 69.912 23.1719 69.912C23.1703 69.912 23.1682 69.9124 23.1662 69.9124C23.1294 69.9144 23.0906 69.9378 23.0494 69.9861C23.0488 69.9865 23.0481 69.9871 23.0478 69.9878C23.0458 69.9901 23.0437 69.9925 23.0421 69.9948C22.8841 70.1887 22.7553 70.4142 22.604 70.6411Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M17.9292 63.7646C17.5089 63.6272 17.0882 63.4897 16.6675 63.3519C16.8542 63.0876 17.0035 62.7246 17.2364 62.5805C17.628 62.3376 18.0701 62.2171 18.4968 62.0853C18.4975 62.085 18.4982 62.0846 18.4988 62.0846C18.5065 62.0823 18.5146 62.0813 18.5226 62.0813C18.5229 62.0813 18.5233 62.0813 18.5236 62.0813C18.5346 62.0813 18.5457 62.083 18.5574 62.0863C18.6381 62.109 18.7301 62.2044 18.7994 62.2725C18.803 62.2765 18.8051 62.2845 18.8051 62.2955C18.8054 62.3456 18.7689 62.4567 18.7314 62.5064C18.5323 62.7707 18.3215 63.0232 18.115 63.2802C18.0514 63.441 17.9898 63.6025 17.9292 63.7646Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M41.424 54.4783C41.2808 54.4309 41.1375 54.3835 40.994 54.3358C41.0181 54.2527 41.0452 54.17 41.0659 54.0862C41.1114 53.8997 41.1493 53.6948 41.1493 53.5113C41.1493 53.2637 41.08 53.0549 40.8668 52.9811C40.8106 52.9618 40.7617 52.9531 40.7182 52.9528C40.7179 52.9528 40.7175 52.9528 40.7172 52.9528C40.7165 52.9528 40.7159 52.9528 40.7152 52.9528C40.3832 52.9548 40.3979 53.4776 40.2554 53.7656C40.2547 53.7669 40.254 53.7682 40.2533 53.7692C40.2527 53.7706 40.252 53.7719 40.2513 53.7736C40.2507 53.7749 40.25 53.7762 40.249 53.7776C40.248 53.7799 40.2466 53.7819 40.2456 53.7843C40.2446 53.7859 40.2436 53.7876 40.243 53.7892C40.2406 53.7932 40.2383 53.7973 40.2363 53.8009C40.2349 53.8029 40.2339 53.8046 40.2329 53.8066C40.1901 53.877 40.176 53.9691 40.1489 54.0515C39.9012 53.6324 39.7741 53.4179 39.7744 53.218C39.7744 53.0088 39.9143 52.8156 40.2004 52.4202C40.2985 52.2848 40.4073 52.1596 40.503 52.0225C40.6101 51.8687 40.6737 51.7749 40.6734 51.6908C40.6724 51.5634 40.5251 51.4583 40.1603 51.2017C40.4535 50.2037 40.8116 49.2574 41.6884 48.6872C41.6931 48.6842 41.6951 48.6745 41.6951 48.6602C41.6951 48.5861 41.6423 48.3836 41.6218 48.2594C41.6232 48.2581 41.6245 48.2568 41.6259 48.2554C41.6292 48.2518 41.6326 48.2481 41.6359 48.2444C41.6399 48.2401 41.6439 48.2361 41.6479 48.2317C41.7922 48.0809 41.9434 47.9791 42.1011 47.9775C42.1021 47.9775 42.1034 47.9775 42.1048 47.9775C42.1054 47.9775 42.1061 47.9775 42.1068 47.9775C42.1884 47.9778 42.2714 48.0052 42.3561 48.0662C42.3581 48.0676 42.3598 48.0689 42.3618 48.0702C42.6874 48.3108 43.0017 48.5694 43.321 48.82C43.0248 49.2397 42.6961 49.6378 42.4465 50.0886C42.3682 50.23 42.2684 50.4119 42.2688 50.5957C42.2688 50.7215 42.3156 50.8483 42.4478 50.9638C42.7919 50.4706 43.1607 50.0048 43.4508 49.4856C43.4662 49.4583 43.4726 49.4246 43.4726 49.3865C43.4723 49.23 43.3625 49.0002 43.323 48.817C43.326 48.814 43.329 48.811 43.332 48.8083C43.3347 48.8053 43.3377 48.8023 43.3407 48.7996C43.5245 48.6198 43.7256 48.506 43.9304 48.5053C43.9311 48.5053 43.9318 48.5053 43.9328 48.5053C43.9335 48.5053 43.9341 48.5053 43.9345 48.5053C44.0077 48.5053 44.0811 48.52 44.1543 48.5511C44.1554 48.5514 44.156 48.5517 44.157 48.552C44.1584 48.5527 44.1597 48.5534 44.1614 48.5541C44.1644 48.5554 44.1674 48.5567 44.1704 48.5581C44.8956 48.8884 45.567 49.3499 46.4137 49.3632C46.5429 49.3652 46.6303 49.7446 46.7371 49.9491C46.31 50.0659 45.8829 50.1823 45.3973 50.3148C45.3963 50.5764 45.3856 50.8059 45.3856 51.0215C45.3856 51.1383 45.3886 51.2507 45.3977 51.3618C45.3987 51.3742 45.4 51.3865 45.4013 51.3986C45.4248 51.6048 45.4937 51.7042 45.6467 51.7045C45.647 51.7045 45.6477 51.7045 45.648 51.7045C45.652 51.7045 45.6557 51.7045 45.6601 51.7045C45.7585 51.7012 45.89 51.6598 46.064 51.5821C46.065 51.5817 46.0657 51.5814 46.0667 51.5811C46.0925 51.5694 46.1196 51.5567 46.1477 51.5437C46.1477 51.5433 46.148 51.5434 46.1484 51.5434C46.1504 51.5424 46.1527 51.541 46.1551 51.54C46.1581 51.5387 46.1607 51.5373 46.1638 51.5357C46.1721 51.5317 46.1808 51.5277 46.1892 51.5237C46.1969 51.52 46.2046 51.516 46.2126 51.5123C46.3378 51.6508 46.4084 51.8049 46.4084 51.9648C46.4087 52.1106 46.3502 52.2607 46.221 52.4082C46.219 52.4105 46.2169 52.4129 46.2149 52.4152C46.0573 52.5947 45.8766 52.7672 45.6718 52.7699C45.6701 52.7699 45.6684 52.7699 45.6671 52.7699C45.6658 52.7699 45.6644 52.7699 45.6631 52.7699C45.5854 52.7692 45.5041 52.7436 45.4191 52.6845C45.4168 52.6828 45.4141 52.6812 45.4114 52.6792C45.0807 52.4416 44.5228 52.5454 44.471 51.8894C44.4686 51.8894 44.4666 51.8893 44.4646 51.889C44.4599 51.889 44.4552 51.889 44.4505 51.889C44.2571 51.889 44.1088 52.0118 43.9693 52.1553C43.9418 52.1833 43.9147 52.2124 43.8876 52.2411C43.7584 52.3789 43.6302 52.5166 43.4733 52.57C43.4304 52.5847 43.3853 52.5931 43.3371 52.5934C43.3364 52.5934 43.3354 52.5934 43.3347 52.5934C43.3344 52.5934 43.3344 52.5934 43.3341 52.5934C43.331 52.5934 43.328 52.5934 43.325 52.5931C43.322 52.5931 43.3186 52.5931 43.3156 52.5927C43.1065 52.5834 42.9057 52.49 42.7089 52.4142C42.7035 52.4122 42.6985 52.4102 42.6931 52.4082C42.6918 52.4075 42.6901 52.4069 42.6888 52.4066C42.4907 52.3315 42.3364 52.2904 42.2139 52.2898C42.2129 52.2898 42.2119 52.2898 42.2109 52.2898C42.2102 52.2898 42.2095 52.2898 42.2089 52.2898C41.9441 52.2908 41.83 52.4826 41.7463 52.9281C41.6493 53.4459 41.5325 53.9614 41.424 54.4783Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M40.7118 59.3906C40.5846 59.3329 40.4438 59.2975 40.3333 59.2128C40.2346 59.137 40.1911 59.048 40.1914 58.9509C40.1921 58.8474 40.2426 58.7353 40.3306 58.6212C40.4314 58.4907 40.5318 58.3603 40.6325 58.2298C40.8912 57.8808 41.1867 57.5685 41.1877 57.0984C41.1881 57.0216 41.1804 56.9405 41.1633 56.8541C41.1221 56.6469 41.1031 56.4247 41.1031 56.2002C41.1031 55.9953 41.1191 55.7884 41.1496 55.5889C41.1971 55.2806 41.4106 54.9869 41.5315 54.6789C41.5331 54.6749 41.5338 54.6703 41.5338 54.6653C41.5331 54.6179 41.4588 54.5398 41.424 54.4781C41.5325 53.9612 41.6493 53.4457 41.7463 52.9279C41.83 52.4824 41.9441 52.2906 42.2089 52.2896C42.2095 52.2896 42.2102 52.2896 42.2108 52.2896C42.2119 52.2896 42.2129 52.2896 42.2139 52.2896C42.3363 52.2903 42.4906 52.3313 42.6888 52.4064C42.6901 52.4067 42.6918 52.4074 42.6931 52.408C42.6985 52.41 42.7035 52.412 42.7088 52.414C42.9056 52.4898 43.1064 52.5832 43.3156 52.5926C43.3186 52.5929 43.322 52.5929 43.325 52.5929C43.328 52.5932 43.331 52.5932 43.334 52.5932C43.3344 52.5932 43.3344 52.5932 43.3347 52.5932C43.3354 52.5932 43.3364 52.5932 43.3371 52.5932C43.3852 52.5929 43.4304 52.5845 43.4732 52.5699C43.6302 52.5165 43.7584 52.3787 43.8876 52.2409C43.9147 52.2122 43.9418 52.1831 43.9692 52.1551C44.1091 52.0116 44.2574 51.8888 44.4505 51.8888C44.4552 51.8888 44.4599 51.8888 44.4646 51.8888C44.4666 51.8892 44.4686 51.8892 44.4709 51.8892C44.5228 52.5452 45.0807 52.4414 45.4114 52.679C45.414 52.681 45.4167 52.6827 45.4191 52.6843C45.5041 52.7434 45.5854 52.7691 45.6631 52.7697C45.6644 52.7697 45.6657 52.7697 45.6671 52.7697C45.6684 52.7697 45.6701 52.7697 45.6718 52.7697C45.8766 52.7671 46.0573 52.5946 46.2149 52.415C46.2169 52.4127 46.219 52.4104 46.221 52.408C46.3502 52.2606 46.4087 52.1104 46.4084 51.9646C46.4084 51.8048 46.3378 51.6506 46.2126 51.5122C46.2454 51.4931 46.2772 51.4748 46.3076 51.4574C46.313 51.4541 46.3183 51.4511 46.3234 51.4481C46.6102 51.2842 46.7936 51.1912 46.9318 51.1878C46.9345 51.1878 46.9368 51.1878 46.9392 51.1878C46.9399 51.1878 46.9402 51.1878 46.9405 51.1878C47.1464 51.1888 47.2538 51.3947 47.4643 51.8708C47.4649 51.8725 47.4656 51.8738 47.4663 51.8755C47.467 51.8772 47.4676 51.8788 47.4683 51.8802C47.471 51.8865 47.4737 51.8925 47.4763 51.8985C47.4777 51.9012 47.4787 51.9039 47.4797 51.9062C47.4803 51.9079 47.481 51.9092 47.4817 51.9105C47.484 51.9155 47.4861 51.9209 47.4884 51.9259C47.295 52.1935 47.062 52.4501 47.0627 52.7247C47.063 52.8788 47.1367 53.0386 47.3321 53.2095C47.48 53.3386 47.5289 53.6499 47.56 53.8969C47.562 53.9125 47.563 53.9292 47.563 53.9466C47.5627 54.0894 47.4974 54.2822 47.4104 54.3713C47.4057 54.376 47.4007 54.3803 47.3953 54.385C47.3947 54.3857 47.394 54.386 47.3934 54.3867C47.3408 54.4297 47.2558 54.4624 47.1778 54.4754C47.1768 54.4758 47.1758 54.4757 47.1748 54.4761C47.1591 54.4784 47.144 54.4801 47.1293 54.4808C47.1226 54.4814 47.1162 54.4814 47.1102 54.4814C47.1088 54.4814 47.1072 54.4814 47.1058 54.4814C47.0637 54.4808 47.0285 54.4717 47.0091 54.4521C47.0088 54.4514 47.0081 54.4507 47.0075 54.4501C46.6209 54.0213 46.1942 53.7891 45.7009 53.7881C45.6999 53.7881 45.6989 53.7881 45.6979 53.7881C45.6972 53.7881 45.6962 53.7881 45.6955 53.7881C45.3993 53.7884 45.0794 53.8722 44.7296 54.047C44.7293 54.047 44.7293 54.0473 44.729 54.0473C44.7206 54.0513 44.7126 54.0557 44.7042 54.0597C44.3588 54.7934 43.9883 55.5798 43.6178 56.3666C43.3377 56.2709 43.0572 56.1751 42.7771 56.079C42.903 55.751 43.0034 55.4077 43.162 55.0994C43.318 54.7947 43.5559 54.5392 43.7119 54.2349C43.7363 54.1875 43.7474 54.1194 43.7474 54.049C43.7477 53.9459 43.7239 53.8378 43.6824 53.7794C43.6797 53.775 43.6764 53.771 43.6731 53.767C43.6727 53.7664 43.672 53.7657 43.6714 53.765C43.671 53.7644 43.6704 53.7637 43.6701 53.7631C43.6078 53.691 43.4893 53.6416 43.3852 53.6393C43.3826 53.6393 43.3799 53.6389 43.3772 53.6389C43.3769 53.6389 43.3762 53.6389 43.3759 53.6389C43.3541 53.6392 43.333 53.6412 43.3133 53.6459C43.3123 53.6463 43.3116 53.6463 43.3106 53.6466C43.3083 53.6473 43.3063 53.6476 43.3039 53.6483C42.5977 53.8428 42.3102 54.4621 42.1901 55.2011C42.1804 55.2609 42.1757 55.3159 42.176 55.367C42.1767 55.7827 42.4819 55.9332 42.7771 56.0797C42.418 56.425 42.2319 56.8281 42.2323 57.2932C42.2323 57.398 42.2416 57.5058 42.2607 57.6165C42.0271 57.6546 41.8822 57.7647 41.8832 58.0196C41.8835 58.056 41.8865 58.0957 41.8929 58.138C41.908 58.2408 41.9093 58.3479 41.9093 58.4557C41.9093 58.4774 41.9093 58.4987 41.9093 58.5204C41.9093 58.5635 41.9096 58.6065 41.9107 58.6492C41.8862 58.6466 41.8625 58.6439 41.8394 58.6416C41.8347 58.6412 41.83 58.6406 41.8253 58.6402C41.8136 58.6389 41.8025 58.6379 41.7912 58.6366C41.6653 58.6239 41.5626 58.6152 41.4762 58.6152C41.4759 58.6152 41.4752 58.6152 41.4746 58.6152C41.4739 58.6152 41.4732 58.6152 41.4726 58.6152C41.1275 58.6155 41.0432 58.7563 40.7426 59.3316C40.7379 59.3409 40.7329 59.3503 40.7279 59.3599C40.7256 59.3643 40.7235 59.3686 40.7212 59.373C40.7202 59.3746 40.7192 59.3766 40.7185 59.3783C40.7162 59.3823 40.7142 59.3866 40.7118 59.3906Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M35.6283 60.874C35.6273 60.874 35.6259 60.874 35.6249 60.874C35.4797 60.8717 35.3364 60.7176 35.1929 60.4076C35.1912 60.4039 35.1895 60.4002 35.1882 60.3966C35.1865 60.3932 35.1848 60.3899 35.1835 60.3866C35.1822 60.3839 35.1811 60.3812 35.1798 60.3785C35.0573 60.1066 34.9536 59.8407 34.6855 59.8383C34.6845 59.8383 34.6835 59.8383 34.6825 59.8383C34.6822 59.8383 34.6818 59.8383 34.6815 59.8383C34.6524 59.8387 34.6209 59.8417 34.5874 59.8484C34.5857 59.8487 34.5837 59.849 34.5817 59.8497C34.5814 59.8497 34.5814 59.8497 34.5811 59.8497C34.5787 59.8504 34.5764 59.8507 34.574 59.8514C34.1383 59.9485 33.6651 59.8847 33.2909 60.3295L33.2882 60.3312C33.153 60.2845 33.0181 60.2387 32.8826 60.1937C32.7561 60.133 32.6289 60.0726 32.502 60.0125C32.3873 59.5581 32.1128 59.3412 31.7012 59.3175C31.6714 59.3158 31.6419 59.3148 31.6121 59.3148C31.6121 59.3148 31.6122 59.3148 31.6118 59.3148C31.6105 59.3148 31.6088 59.3148 31.6074 59.3148C30.8865 59.3172 30.2811 59.8127 29.6486 60.1934C29.6459 60.195 29.6436 60.1964 29.6409 60.198C29.6339 60.202 29.6268 60.2064 29.6198 60.2107C29.6131 60.2144 29.6064 60.2184 29.6001 60.2224C29.596 60.2247 29.592 60.2271 29.588 60.2294C29.5816 60.2331 29.5753 60.2371 29.5686 60.2407C29.5649 60.2427 29.5616 60.2447 29.5579 60.2467C29.4689 60.0242 29.3792 59.8013 29.2898 59.5784C29.2972 59.5718 29.3045 59.5647 29.3119 59.5581C29.3142 59.5561 29.3163 59.554 29.3183 59.5517C29.3189 59.5514 29.3196 59.5507 29.3203 59.5501C29.3256 59.545 29.3306 59.54 29.3356 59.535C29.3373 59.5337 29.339 59.532 29.3404 59.5304C29.3434 59.5277 29.346 59.5247 29.349 59.522C29.3541 59.517 29.3591 59.512 29.3638 59.5067C29.3648 59.5057 29.3658 59.5047 29.3668 59.5037C29.6908 59.1684 29.928 58.6568 30.4117 58.6545C30.4127 58.6545 30.4137 58.6545 30.4147 58.6545C30.4153 58.6545 30.4157 58.6545 30.416 58.6545C30.501 58.6545 30.5934 58.6705 30.6951 58.7056C30.6975 58.7062 30.7002 58.7072 30.7028 58.7079C30.7035 58.7082 30.7041 58.7082 30.7051 58.7086C30.7185 58.7122 30.7319 58.7142 30.745 58.7142C30.7453 58.7142 30.7456 58.7142 30.7456 58.7142C30.7473 58.7142 30.749 58.7142 30.7507 58.7139C30.9619 58.7072 31.1536 58.2628 31.2025 57.9301C31.2028 57.9291 31.2028 57.9281 31.2032 57.9268C31.2038 57.9225 31.2042 57.9178 31.2048 57.9131C31.2192 57.7846 31.1724 57.7156 31.0783 57.7136C31.077 57.7136 31.0753 57.7132 31.0737 57.7132C31.073 57.7132 31.0726 57.7132 31.072 57.7136C31.0405 57.7136 31.0044 57.7209 30.9635 57.7359C30.9615 57.7366 30.9595 57.7373 30.9575 57.7379C30.9572 57.7383 30.9572 57.7383 30.9572 57.7383C30.9568 57.7383 30.9565 57.7383 30.9562 57.7386C30.9535 57.7396 30.9505 57.7406 30.9475 57.7419C30.9441 57.7433 30.9411 57.7446 30.9378 57.7459C30.7969 57.8043 30.6606 57.8821 30.5221 57.9511C30.4548 57.6962 30.3939 57.445 30.3942 57.1961C30.3942 56.8954 30.4833 56.5978 30.7577 56.3002C30.9173 56.127 30.9876 55.8404 31.0988 55.6058C31.2604 55.9204 31.422 56.2348 31.6513 56.6809C31.8414 56.1587 31.984 55.7663 32.1269 55.3743C32.2658 55.4186 32.4053 55.4607 32.5455 55.5L32.5489 55.5151C32.5452 55.5514 32.5436 55.5865 32.5436 55.6205C32.5442 55.8574 32.6299 56.0409 32.8016 56.17C32.8009 56.172 32.8006 56.1737 32.7999 56.1757C32.8016 56.1804 32.8036 56.1851 32.8053 56.1894C32.8049 56.2254 32.8026 56.2628 32.8026 56.2985C32.8026 56.3328 32.8046 56.3662 32.8133 56.3963C32.8247 56.4363 32.8842 56.4523 32.9221 56.4793C32.8832 56.3826 32.8444 56.2862 32.8053 56.1894C32.8053 56.1841 32.8053 56.1784 32.8053 56.1727C32.8042 56.172 32.8029 56.171 32.8016 56.17C32.8605 55.9995 32.9194 55.829 32.9783 55.6582L32.9907 55.6485C33.2708 55.749 33.5509 55.8497 33.8311 55.9502C33.6239 56.6555 33.2383 57.3295 33.2394 58.0679C33.2394 58.1136 33.2407 58.16 33.244 58.2064C33.2571 58.3963 33.4826 58.5858 33.6557 58.6799C33.658 58.6812 33.66 58.6822 33.6624 58.6835C33.7099 58.7082 33.7571 58.7202 33.8023 58.7205C33.8026 58.7205 33.8033 58.7205 33.8036 58.7205C33.8049 58.7205 33.806 58.7205 33.8073 58.7205C33.9435 58.7189 34.062 58.6085 34.1262 58.4153C34.1279 58.4109 34.1293 58.4062 34.1306 58.4019C34.1316 58.3992 34.1322 58.3969 34.1329 58.3942C34.1349 58.3872 34.1373 58.3806 34.139 58.3732C34.1403 58.3682 34.142 58.3632 34.143 58.3582C34.1862 58.1907 34.1791 57.9928 34.2615 57.8597C34.2655 57.853 34.2702 57.8464 34.2755 57.84C34.2765 57.8387 34.2775 57.8377 34.2788 57.8363C34.3324 57.7746 34.4378 57.7232 34.5238 57.7116C34.5359 57.7099 34.5473 57.7092 34.5583 57.7092C34.5587 57.7092 34.559 57.7092 34.5593 57.7092C34.5767 57.7092 34.5931 57.7116 34.6068 57.7162C35.1226 57.8931 35.0914 58.6221 35.4613 58.9555C35.472 58.9468 35.4827 58.9384 35.4934 58.9304C35.6547 58.807 35.7725 58.7536 35.8599 58.7486C35.8646 58.7486 35.8692 58.7482 35.8736 58.7482C35.8739 58.7482 35.8743 58.7482 35.8749 58.7482C36.1738 58.7502 36.1025 59.3475 36.2615 59.5741C36.2889 59.6124 36.3227 59.6405 36.3662 59.6528C36.3659 59.6532 36.3656 59.6535 36.3652 59.6542C36.3656 59.6545 36.3659 59.6548 36.3662 59.6555C36.2745 59.9034 36.2029 60.163 36.0868 60.3969C36.0818 60.4069 36.0771 60.4162 36.0724 60.4259C36.0707 60.4286 36.0694 60.4313 36.068 60.4339C36.066 60.4383 36.0637 60.4423 36.0617 60.4463C35.9148 60.7276 35.7725 60.8717 35.6319 60.874C35.6306 60.874 35.6296 60.874 35.6283 60.874Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M52.2277 57.5266C52.2193 57.5236 52.2106 57.5203 52.2019 57.5173C52.0714 57.4702 51.9399 57.4268 51.8073 57.3868C51.8572 57.1859 51.9198 56.9697 51.9198 56.7742C51.9195 56.6464 51.8924 56.5273 51.8171 56.4275C51.8087 56.4162 51.7993 56.4048 51.7896 56.3941C51.7859 56.3901 51.7822 56.3861 51.7786 56.3821C51.7685 56.3711 51.7581 56.3608 51.7478 56.3504C51.6116 56.215 51.4563 56.1299 51.2896 56.1292C51.2889 56.1292 51.2883 56.1292 51.2873 56.1292C51.2849 56.1292 51.2826 56.1292 51.2799 56.1292C51.1296 56.1315 50.9703 56.2023 50.807 56.3668C50.8067 56.3671 50.8067 56.3675 50.8063 56.3675C50.8026 56.3715 50.799 56.3751 50.7949 56.3791C50.7946 56.3795 50.7946 56.3798 50.7943 56.3801C50.7916 56.3825 50.7889 56.3851 50.7866 56.3878C50.6912 56.4886 50.6075 56.5396 50.5346 56.5419C50.5329 56.5419 50.5309 56.5419 50.5292 56.5419C50.5285 56.5419 50.5279 56.5419 50.5272 56.5419C50.4358 56.5406 50.3615 56.4622 50.3016 56.3077C50.2146 56.0832 50.1186 55.8646 50.0265 55.6431C50.137 55.3031 50.2471 54.9634 50.3569 54.6237C50.554 54.3501 50.732 54.0528 50.9542 53.8116C51.1159 53.6361 51.3411 53.5446 51.5272 53.3952C51.5674 53.3631 51.6059 53.2574 51.6055 53.1966C51.6055 53.1839 51.6039 53.1733 51.5998 53.1652C51.5356 53.0338 51.4486 52.8339 51.3485 52.8303C51.3284 52.8293 51.3083 52.8289 51.2879 52.8289C51.2879 52.8289 51.2876 52.8289 51.2873 52.8289C51.2852 52.8289 51.2832 52.8289 51.2809 52.8289C51.0888 52.8299 50.8927 52.8626 50.6969 52.8943C50.6611 52.9 50.6256 52.9057 50.5901 52.9113C50.5854 52.912 50.5811 52.9127 50.5767 52.9133C50.5536 52.917 50.5306 52.9204 50.5075 52.9237C50.4991 52.925 50.4907 52.926 50.4827 52.927C50.4757 52.928 50.469 52.929 50.4623 52.93C50.562 52.608 50.6765 52.2891 50.7568 51.9634C50.7575 51.9604 50.7581 51.9577 50.7588 51.9551C50.807 51.7425 50.6909 51.589 50.5165 51.5854C50.5141 51.5854 50.5122 51.5854 50.5101 51.5854C50.5095 51.5854 50.5088 51.5854 50.5084 51.5854C50.4726 51.5854 50.4348 51.5917 50.3957 51.605C50.0476 51.7228 49.7016 51.8526 49.3545 51.9771C49.5292 51.4669 49.7039 50.9567 49.8789 50.4462C49.8829 50.4416 49.8873 50.4369 49.8913 50.4326C50.0941 50.2093 50.2889 50.1359 50.48 50.1349C50.4817 50.1349 50.483 50.1349 50.4847 50.1349C50.4867 50.1349 50.489 50.1349 50.4914 50.1349C50.718 50.1366 50.9395 50.2384 51.1624 50.3091C51.1647 50.3098 51.1671 50.3104 51.1694 50.3114C51.1718 50.3121 51.1741 50.3128 51.1768 50.3134C51.1992 50.3204 51.222 50.3271 51.2447 50.3335C51.2464 50.3338 51.2481 50.3345 51.2498 50.3348C51.2565 50.3368 51.2635 50.3385 51.2702 50.3405C51.2822 50.3435 51.2946 50.3465 51.3067 50.3491C51.3134 50.3508 51.3204 50.3521 51.3274 50.3538C52.1745 51.0502 53.1179 51.5447 54.138 51.878C54.0778 52.0372 54.0175 52.1963 53.9583 52.3558C53.7598 52.4879 53.5611 52.6197 53.3623 52.7515C53.3505 52.7509 53.3388 52.7499 53.3271 52.7489C53.2642 52.7428 53.2006 52.7312 53.1383 52.7215C53.0851 52.7135 53.0329 52.7072 52.9827 52.7068C52.9817 52.7068 52.9811 52.7068 52.9801 52.7068C52.9784 52.7068 52.9771 52.7068 52.9757 52.7068C52.796 52.7082 52.6434 52.7939 52.5711 53.1853C52.5701 53.192 52.5687 53.1986 52.5674 53.2057C52.5674 53.206 52.5674 53.2063 52.5674 53.2066C52.5667 53.2106 52.566 53.2146 52.5654 53.219C52.565 53.221 52.5644 53.2237 52.5641 53.2257C52.4576 53.8836 52.2414 54.532 52.0734 55.1846C52.0721 55.1829 52.0711 55.1816 52.0701 55.1799L52.0724 55.1883C52.0727 55.187 52.0731 55.1856 52.0734 55.1846C52.1999 55.3591 52.384 55.5062 52.4392 55.7148C52.4402 55.7181 52.4409 55.7211 52.4419 55.7245C52.4422 55.7258 52.4429 55.7275 52.4432 55.7292C52.5694 56.1856 52.8124 56.3307 53.1163 56.3317C53.1176 56.3317 53.1186 56.3317 53.1199 56.3317C53.1206 56.3317 53.1213 56.3317 53.1223 56.3317C53.2578 56.3314 53.4058 56.3027 53.5604 56.2603C53.5671 56.2587 53.5738 56.257 53.5805 56.255C53.5808 56.255 53.5808 56.255 53.5811 56.2547C53.5862 56.2533 53.5915 56.252 53.5965 56.2503C53.4386 56.6661 53.2619 57.0334 52.8194 57.1476C52.6156 57.2006 52.4245 57.3958 52.2277 57.5266ZM51.6343 55.4629C51.635 55.4629 51.6357 55.4629 51.636 55.4629C51.7679 55.4619 51.9057 55.3621 52.04 55.214C52.043 55.211 52.0456 55.2076 52.0486 55.2046C52.049 55.2039 52.0496 55.2033 52.0503 55.2026C52.056 55.1963 52.0614 55.1899 52.067 55.1836C52.0687 55.1849 52.0704 55.1866 52.0724 55.1883L52.0701 55.1799C52.0691 55.1813 52.0681 55.1823 52.067 55.1836C51.9051 55.0378 51.7475 54.8846 51.5768 54.7532C51.5764 54.7529 51.5757 54.7525 51.5751 54.7522C51.5697 54.7488 51.5627 54.7475 51.554 54.7472C51.5533 54.7472 51.5527 54.7472 51.552 54.7472C51.5343 54.7472 51.5115 54.7522 51.4894 54.7605C51.4479 54.7752 51.4081 54.7996 51.4031 54.8186C51.3733 54.9287 51.3251 55.0751 51.3251 55.1769C51.3251 55.2109 51.3304 55.2397 51.3438 55.2607C51.3478 55.267 51.3515 55.2727 51.3555 55.2787C51.4415 55.4068 51.5346 55.4615 51.631 55.4629C51.632 55.4629 51.6333 55.4629 51.6343 55.4629Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M36.3664 59.6528C36.3229 59.6405 36.2891 59.6124 36.2616 59.5741C36.1027 59.3475 36.174 58.7503 35.8751 58.7483C35.8744 58.7483 35.8741 58.7483 35.8738 58.7483C35.8694 58.7483 35.8647 58.7486 35.86 58.7486C35.7723 58.7536 35.6549 58.807 35.4935 58.9304C35.4828 58.9384 35.4721 58.9468 35.4614 58.9555C35.0916 58.6221 35.1227 57.8931 34.607 57.7162C34.5933 57.7116 34.5769 57.7092 34.5595 57.7092C34.5591 57.7092 34.5588 57.7092 34.5585 57.7092C34.5474 57.7092 34.536 57.7099 34.524 57.7116C34.438 57.7233 34.3325 57.7746 34.279 57.8363C34.2777 57.8377 34.2767 57.8387 34.2757 57.84C34.2703 57.8464 34.2656 57.853 34.2616 57.8597C34.1793 57.9928 34.1863 58.1907 34.1431 58.3582C34.1421 58.3632 34.1405 58.3682 34.1391 58.3732C34.1374 58.3806 34.1351 58.3873 34.1331 58.3943C34.1324 58.3969 34.1318 58.3992 34.1307 58.4019C34.1294 58.4063 34.1281 58.4109 34.1264 58.4153C34.0621 58.6085 33.9437 58.7186 33.8074 58.7206C33.8061 58.7206 33.8051 58.7206 33.8037 58.7206C33.8034 58.7206 33.8027 58.7206 33.8024 58.7206C33.7572 58.7202 33.71 58.7082 33.6625 58.6835C33.6602 58.6822 33.6582 58.6812 33.6558 58.6799C33.4828 58.5858 33.2572 58.3963 33.2442 58.2064C33.2408 58.16 33.2395 58.1136 33.2395 58.0679C33.2385 57.3295 33.624 56.6555 33.8312 55.9502C34.2024 56.1774 34.5464 56.5094 34.9534 56.6011C35.3249 56.6849 35.3286 57.1974 35.6408 57.3432C35.8801 56.8224 36.0625 56.4253 36.2476 56.0219C36.3517 56.1243 36.4886 56.1904 36.5247 56.3089C36.5257 56.3129 36.527 56.3168 36.5284 56.3208C36.5287 56.3218 36.529 56.3232 36.5294 56.3245C36.5301 56.3269 36.5311 56.3295 36.5317 56.3319C36.5913 56.5137 36.6833 56.6095 36.8075 56.6111C36.8085 56.6111 36.8095 56.6111 36.8105 56.6111C36.8115 56.6111 36.8125 56.6111 36.8135 56.6111C36.8661 56.6105 36.9246 56.5931 36.9889 56.5581C36.9899 56.5578 36.9912 56.5571 36.9922 56.5564C36.9953 56.5548 36.9979 56.5531 37.0009 56.5514C37.0039 56.5497 37.0073 56.5481 37.0103 56.5461C37.1308 56.475 37.2754 56.3102 37.3025 56.173C37.3276 56.0462 37.3336 55.9168 37.3336 55.7867C37.3336 55.6789 37.3296 55.5704 37.3296 55.4627C37.3296 55.4403 37.3296 55.418 37.3303 55.3956C37.3811 55.2471 37.4303 55.098 37.4775 54.9485C37.4842 54.9271 37.4909 54.9058 37.4976 54.8844C37.6753 55.0075 37.9712 55.082 38.0093 55.2625C38.1475 55.9091 38.5455 56.3145 38.8725 56.7947C38.4521 57.0532 38.0508 57.3135 37.9089 57.8824C37.7325 58.4053 37.5565 58.9281 37.3798 59.451C37.3771 59.4496 37.3741 59.4486 37.3711 59.4473C37.3634 59.4443 37.356 59.4413 37.3483 59.4383C37.2101 59.3849 37.0726 59.3459 36.9367 59.3452C36.9357 59.3452 36.9344 59.3452 36.9333 59.3452C36.9317 59.3452 36.9303 59.3452 36.9286 59.3452C36.7419 59.3462 36.5585 59.4216 36.3818 59.6338C36.3798 59.6361 36.3778 59.6388 36.3758 59.6415C36.3741 59.6432 36.3724 59.6452 36.3711 59.6472C36.3694 59.6488 36.3681 59.6508 36.3664 59.6528Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M39.7963 60.7146C39.7956 60.7146 39.7946 60.7146 39.7939 60.7146C39.233 60.7139 38.82 60.4267 38.5877 59.6626C38.5854 59.6556 38.5834 59.6489 38.5814 59.6422C38.581 59.6419 38.581 59.6416 38.581 59.6416C38.5131 59.4337 38.4137 59.3576 38.2979 59.3569C38.2972 59.3569 38.2969 59.3569 38.2962 59.3569C38.2919 59.3569 38.2875 59.3573 38.2832 59.3573C38.1098 59.3656 37.9016 59.5338 37.7085 59.6816C37.7078 59.6819 37.7072 59.6822 37.7065 59.6829C37.7025 59.6859 37.6981 59.6893 37.6941 59.6923C37.6921 59.6939 37.6898 59.6956 37.6878 59.6973C37.6831 59.701 37.6781 59.7046 37.6734 59.7079C37.6359 59.7363 37.6001 59.7493 37.567 59.7496C37.5666 59.7496 37.566 59.7496 37.5656 59.7496C37.5646 59.7496 37.5639 59.7496 37.5629 59.7496C37.4592 59.7476 37.3842 59.6202 37.3799 59.4514C37.5566 58.9285 37.7326 58.4057 37.909 57.8828C37.914 57.8848 37.919 57.8865 37.9241 57.8885C37.9298 57.8908 37.9354 57.8928 37.9411 57.8951C38.2299 58.0072 38.5218 58.1137 38.8213 58.1144C38.8227 58.1144 38.824 58.1144 38.825 58.1144C38.827 58.1144 38.8287 58.1144 38.8307 58.1144C39.0573 58.1134 39.2885 58.0516 39.5268 57.8861C39.5365 57.8791 39.5462 57.8725 39.5559 57.8651C39.6999 57.7604 39.821 57.718 39.9268 57.7173C39.9278 57.7173 39.9284 57.7173 39.9294 57.7173C39.9298 57.7173 39.9304 57.7173 39.9311 57.7173C40.1999 57.7187 40.3709 57.9882 40.573 58.1778C40.5807 58.1848 40.5884 58.1921 40.5961 58.1988C40.5981 58.2008 40.6002 58.2028 40.6025 58.2045C40.6048 58.2065 40.6072 58.2088 40.6095 58.2108C40.6122 58.2131 40.6145 58.2151 40.6172 58.2175C40.6185 58.2185 40.6199 58.2198 40.6212 58.2208C40.6249 58.2242 40.6289 58.2271 40.6326 58.2301C40.5319 58.3606 40.4315 58.4911 40.3307 58.6215C40.2427 58.7357 40.1922 58.8478 40.1915 58.9512C40.1912 59.0483 40.2347 59.1374 40.3334 59.2131C40.4439 59.2979 40.5847 59.3332 40.7119 59.391C40.8685 59.5511 40.9241 59.734 40.9238 59.9298C40.9234 60.1314 40.8635 60.3466 40.7932 60.5645C40.6413 60.5901 40.4894 60.6072 40.3388 60.6429C40.3314 60.6449 40.3244 60.6466 40.3173 60.6482C40.3143 60.6489 40.3117 60.6496 40.3086 60.6499C40.1272 60.6916 39.9569 60.7146 39.7983 60.7146C39.7976 60.7146 39.7969 60.7146 39.7963 60.7146Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M32.6788 48.1143C32.6695 47.6084 32.3579 47.4419 32.0155 47.3101C32.0667 47.1109 32.1078 46.9181 32.1078 46.7336C32.1078 46.5277 32.057 46.3325 31.9117 46.151C31.7829 45.9898 31.7471 45.7266 31.6694 45.5094C32.2996 45.6081 32.723 45.9848 32.8709 46.6235C33.4606 46.4209 34.0329 46.1483 34.6099 46.0486C34.6976 46.0332 34.7846 46.0255 34.87 46.0252C34.8706 46.0252 34.871 46.0252 34.8713 46.0252C34.875 46.0252 34.8783 46.0252 34.8817 46.0252C35.2923 46.0282 35.6658 46.211 35.9142 46.6178C35.9168 46.6221 35.9192 46.6261 35.9218 46.6305C35.9252 46.6361 35.9285 46.6422 35.9322 46.6478C35.9376 46.6572 35.9429 46.6668 35.9483 46.6765C36.0152 46.7973 36.0919 46.9414 36.0919 47.0846C36.0919 47.181 36.0571 47.2771 35.9607 47.3655C35.956 47.3695 35.9513 47.3739 35.9463 47.3782C35.9453 47.3792 35.9443 47.3799 35.9433 47.3809C35.9396 47.3839 35.9362 47.3869 35.9326 47.3899C35.9282 47.3935 35.9235 47.3969 35.9188 47.4006C35.9138 47.4046 35.9088 47.4086 35.9038 47.4126C35.9004 47.4149 35.8971 47.4176 35.8934 47.4199C35.8924 47.4206 35.8917 47.4212 35.8907 47.4219C35.888 47.4239 35.8857 47.4256 35.8834 47.4272C35.8804 47.4296 35.8777 47.4316 35.8746 47.4336C35.8599 47.4439 35.8442 47.4543 35.8285 47.4643C35.8265 47.4653 35.8248 47.4663 35.8231 47.4673C35.8194 47.4696 35.8158 47.472 35.8121 47.4743C35.7974 47.4833 35.7823 47.492 35.7669 47.5007C35.7418 47.5143 35.7164 47.5277 35.6913 47.5394C35.6909 47.5397 35.6909 47.5397 35.6906 47.5397C35.6802 47.5447 35.6698 47.5494 35.6595 47.554C35.6578 47.5547 35.6561 47.5554 35.6541 47.5561C35.6454 47.5601 35.6367 47.5634 35.628 47.5671C35.6267 47.5677 35.625 47.5684 35.6233 47.5691C35.5557 47.5954 35.4925 47.6118 35.4439 47.6118C35.4433 47.6118 35.4429 47.6118 35.4422 47.6118C35.4138 47.6114 35.3904 47.6058 35.3747 47.5927C35.374 47.5921 35.3733 47.5917 35.373 47.5911C35.372 47.5904 35.3713 47.5898 35.3703 47.5891C35.1052 47.3298 34.8382 47.228 34.5687 47.227C34.5677 47.227 34.5664 47.227 34.5654 47.227C34.5644 47.227 34.5634 47.227 34.562 47.227C34.1557 47.2284 33.7441 47.4586 33.3258 47.7249C33.3197 47.7285 33.3137 47.7325 33.308 47.7362C33.3037 47.7389 33.2993 47.7416 33.295 47.7446C33.0925 47.8744 32.8847 47.9915 32.6788 48.1143Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M40.1581 51.2026C40.0162 51.1539 39.8743 51.1049 39.7327 51.0561L39.7324 51.0565C39.555 50.2113 39.0252 49.7685 38.3833 49.4532C38.4308 49.2907 38.4744 49.1279 38.5145 48.9641L38.559 48.9397C38.6266 48.9611 38.6932 48.9871 38.7622 49.0031C38.8338 49.0194 38.9021 49.0298 38.965 49.0301C38.9653 49.0301 38.966 49.0301 38.9663 49.0301C38.9673 49.0301 38.968 49.0301 38.969 49.0301C39.1772 49.0291 39.3244 48.915 39.3325 48.543C39.3361 48.3755 39.3465 48.207 39.3542 48.0391C39.4821 48.0081 39.6049 47.9938 39.7251 47.9938C39.7257 47.9938 39.7264 47.9938 39.7274 47.9938C39.7284 47.9938 39.7294 47.9938 39.7307 47.9938C40.0002 47.9941 40.2545 48.0658 40.5142 48.1776C40.5152 48.178 40.5159 48.1783 40.5169 48.1786C40.5192 48.1796 40.5216 48.1806 40.5243 48.1816C40.541 48.189 40.5577 48.1966 40.5748 48.204C40.5845 48.2083 40.5942 48.2127 40.6039 48.2163C40.6063 48.2173 40.6086 48.2183 40.6106 48.219C40.6136 48.2203 40.6163 48.2213 40.619 48.2223C40.7391 48.2667 40.8727 48.2797 41.0112 48.2797C41.0125 48.2797 41.0136 48.2797 41.0149 48.2797C41.0159 48.2797 41.0169 48.2797 41.0176 48.2797C41.1033 48.2797 41.1906 48.275 41.2779 48.27C41.2816 48.2697 41.285 48.2697 41.2883 48.2694C41.2913 48.2694 41.2947 48.269 41.2977 48.2687C41.3834 48.264 41.4691 48.2594 41.5531 48.259C41.5561 48.259 41.5588 48.259 41.5614 48.259C41.5621 48.259 41.5624 48.259 41.5631 48.259C41.5728 48.259 41.5822 48.259 41.5919 48.2594C41.6019 48.2594 41.6116 48.2597 41.6217 48.2597C41.6421 48.3838 41.6949 48.5864 41.6949 48.6604C41.6949 48.6748 41.6929 48.6844 41.6882 48.6874C40.8114 49.2577 40.4533 50.204 40.1601 51.202L40.1581 51.2026Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M47.4885 51.9263C47.4862 51.9213 47.4842 51.9159 47.4818 51.9109C47.4812 51.9096 47.4805 51.9083 47.4798 51.9066C47.4788 51.9043 47.4778 51.9016 47.4765 51.8989C47.4738 51.8929 47.4711 51.8869 47.4684 51.8806C47.4678 51.8792 47.4671 51.8776 47.4664 51.8759C47.4658 51.8742 47.4651 51.8729 47.4644 51.8712C47.2539 51.3951 47.1465 51.1892 46.9407 51.1882C46.9403 51.1882 46.94 51.1882 46.9393 51.1882C46.937 51.1882 46.9346 51.1882 46.932 51.1882C46.7937 51.1915 46.6103 51.2846 46.3235 51.4485C46.3185 51.4515 46.3131 51.4545 46.3078 51.4578C46.2773 51.4752 46.2455 51.4935 46.2127 51.5125C46.2047 51.5162 46.197 51.5202 46.1893 51.5239C46.1809 51.5279 46.1722 51.5319 46.1639 51.5359C46.1609 51.5375 46.1582 51.5389 46.1552 51.5402C46.1528 51.5412 46.1505 51.5426 46.1485 51.5436C46.1481 51.5436 46.1478 51.5436 46.1478 51.5439C46.1197 51.5569 46.0926 51.5696 46.0668 51.5813C46.0658 51.5816 46.0651 51.5819 46.0641 51.5823C45.8901 51.66 45.7586 51.7014 45.6602 51.7047C45.6558 51.7047 45.6521 51.7047 45.6481 51.7047C45.6478 51.7047 45.6471 51.7047 45.6468 51.7047C45.4938 51.7044 45.4249 51.605 45.4015 51.3988C45.4001 51.3867 45.3988 51.3744 45.3978 51.362C45.3887 51.2509 45.3857 51.1385 45.3857 51.0217C45.3857 50.8061 45.3964 50.5766 45.3974 50.315C45.8831 50.1825 46.3101 50.0661 46.7372 49.9493C47.1589 50.0881 47.5806 50.2266 48.0019 50.3651C48.1649 50.5322 48.2221 50.7241 48.2218 50.9293C48.2215 51.1378 48.1619 51.3604 48.0943 51.5846C47.8921 51.6987 47.6907 51.8125 47.4885 51.9263Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M38.1244 51.6018C38.1238 51.6018 38.1228 51.6018 38.1221 51.6018C37.9782 51.6015 37.8319 51.5621 37.685 51.5147C37.9179 50.8274 38.1505 50.1403 38.3835 49.453C39.0254 49.7683 39.5552 50.2111 39.7326 51.0562C39.4588 50.9738 39.1897 50.8724 38.9099 50.815C38.9062 50.8144 38.9026 50.8137 38.8989 50.813C38.8965 50.8123 38.8945 50.812 38.8922 50.8117C38.8905 50.8114 38.8885 50.811 38.8868 50.8107C38.8574 50.8047 38.8319 50.8007 38.8102 50.7993C38.8082 50.7993 38.8062 50.7993 38.8045 50.799C38.8015 50.799 38.7985 50.799 38.7958 50.799C38.7955 50.799 38.7948 50.799 38.7944 50.799C38.6837 50.7997 38.6843 50.8951 38.7081 51.2778C38.7084 51.2808 38.7085 51.2842 38.7088 51.2875C38.7048 51.2925 38.7011 51.2972 38.6971 51.3018C38.6944 51.3055 38.6914 51.3092 38.6887 51.3125C38.688 51.3132 38.6874 51.3138 38.6867 51.3145C38.5086 51.5294 38.3212 51.6008 38.1291 51.6018C38.1274 51.6018 38.1261 51.6018 38.1244 51.6018ZM37.6843 51.516L37.685 51.5147C37.6847 51.515 37.6847 51.5154 37.6843 51.516Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M48.9401 51.8425C48.6583 51.7564 48.3762 51.6707 48.0941 51.5846C48.1617 51.3604 48.2213 51.1378 48.2216 50.9293C48.2219 50.7241 48.1647 50.5322 48.0017 50.3651C48.0084 50.3584 48.0148 50.3514 48.0214 50.345C48.0238 50.3424 48.0261 50.34 48.0285 50.3377C48.167 50.1992 48.3009 50.1252 48.4314 50.0931C48.4883 50.0791 48.5442 50.0731 48.6001 50.0731C48.8903 50.0731 49.1691 50.2373 49.4546 50.3063V50.3067C49.2829 50.8182 49.1115 51.3307 48.9401 51.8425Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M36.1274 53.4915C36.5766 52.1571 36.8286 51.4084 37.0836 50.6496C37.5585 50.669 37.3758 51.3357 37.684 51.5155C37.26 52.0003 36.8858 52.5495 36.1274 53.4915ZM37.6843 51.5158C37.6843 51.5155 37.684 51.5155 37.684 51.5155C37.6844 51.5152 37.6847 51.5148 37.685 51.5145L37.6843 51.5158Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M37.3303 55.3955C37.075 55.1513 36.8849 54.8523 36.8752 54.4529C36.8749 54.4426 36.8745 54.4319 36.8745 54.4215C36.8745 54.3902 36.8759 54.3581 36.8779 54.3254C36.897 54.0518 37.0763 53.8126 37.313 53.8083C37.3146 53.8079 37.3163 53.8079 37.3176 53.8079C37.3193 53.8079 37.321 53.8079 37.3227 53.8079C37.325 53.8079 37.3274 53.8079 37.3297 53.8079C37.5154 53.8106 37.7012 53.9067 37.8635 54.0108C37.8715 54.0161 37.8799 54.0215 37.8879 54.0268C37.8899 54.0281 37.8919 54.0295 37.8939 54.0308C37.9013 54.0355 37.9043 54.0498 37.9043 54.0705C37.904 54.1563 37.8491 54.3541 37.7969 54.4619C37.7229 54.6167 37.5998 54.7448 37.4977 54.8846C37.491 54.906 37.4843 54.9274 37.4776 54.9487C37.4304 55.0982 37.3812 55.2474 37.3303 55.3955Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M38.5147 48.9639C38.2914 48.789 38.0264 48.6562 37.861 48.4237C37.8232 48.3706 37.8102 48.2905 37.8098 48.1991C37.8095 48.0653 37.8369 47.9082 37.856 47.7784C37.8593 47.754 38.0334 47.7197 38.1693 47.717C38.175 47.717 38.1803 47.7166 38.1857 47.7166C38.186 47.7166 38.1863 47.7166 38.1867 47.7166C38.2057 47.717 38.2238 47.7176 38.2402 47.719C38.2449 47.7196 38.2496 47.72 38.254 47.7206C38.4648 47.7477 38.6666 47.8214 38.8718 47.8751C38.7677 48.2298 38.6632 48.5848 38.5591 48.9395L38.5147 48.9639Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M40.994 54.3357C40.7122 54.2409 40.4304 54.1462 40.1489 54.0514C40.176 53.969 40.1901 53.8769 40.233 53.8065C40.234 53.8045 40.2349 53.8029 40.2363 53.8009C40.2383 53.7972 40.2406 53.7932 40.243 53.7892C40.2437 53.7875 40.2447 53.7858 40.2457 53.7842C40.2467 53.7818 40.248 53.7798 40.249 53.7775C40.25 53.7762 40.2507 53.7748 40.2514 53.7735C40.252 53.7718 40.2527 53.7705 40.2533 53.7691C40.254 53.7681 40.2547 53.7668 40.2554 53.7655C40.3979 53.4775 40.3832 52.955 40.7152 52.9527C40.7159 52.9527 40.7166 52.9527 40.7172 52.9527C40.7176 52.9527 40.7179 52.9527 40.7182 52.9527C40.7617 52.953 40.8106 52.9617 40.8668 52.981C41.08 53.0548 41.1493 53.2636 41.1493 53.5112C41.1493 53.6947 41.1115 53.8996 41.066 54.0861C41.0452 54.1699 41.0181 54.2526 40.994 54.3357Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M38.9664 49.0298C38.9661 49.0298 38.9654 49.0298 38.9651 49.0298C38.9022 49.0295 38.8339 49.0191 38.7622 49.0027C38.6933 48.9867 38.6267 48.9607 38.5591 48.9394C38.6632 48.5847 38.7676 48.2296 38.8717 47.875C38.8844 47.8619 38.8968 47.8496 38.9088 47.8376C39.0076 47.7418 39.0912 47.6901 39.1589 47.6858C39.1622 47.6854 39.1652 47.6854 39.1682 47.6854C39.1692 47.6854 39.1702 47.6854 39.1712 47.6854C39.2669 47.6878 39.3278 47.7909 39.3509 48.0054C39.3516 48.0121 39.3523 48.0188 39.353 48.0258C39.3536 48.0301 39.354 48.0345 39.3543 48.0388C39.3466 48.2066 39.3362 48.3751 39.3325 48.5426C39.3245 48.9147 39.1769 49.0288 38.9691 49.0298C38.9681 49.0298 38.9674 49.0298 38.9664 49.0298Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M39.5599 51.5759C39.4167 51.5282 39.2731 51.4808 39.1298 51.4338C38.9906 51.3821 38.8504 51.3334 38.7088 51.2877C38.7085 51.2843 38.7085 51.281 38.7081 51.278C38.6844 50.8953 38.6837 50.7998 38.7945 50.7991C38.7948 50.7991 38.7955 50.7991 38.7958 50.7991C38.7985 50.7991 38.8015 50.7991 38.8045 50.7991C38.8062 50.7995 38.8082 50.7995 38.8102 50.7995C38.832 50.8008 38.8574 50.8048 38.8868 50.8108C38.8885 50.8112 38.8905 50.8115 38.8922 50.8119C38.8945 50.8122 38.8966 50.8125 38.8989 50.8132C38.9026 50.8138 38.9063 50.8145 38.91 50.8152C39.1897 50.8726 39.4588 50.974 39.7326 51.0564L39.7329 51.0561C39.676 51.2289 39.6195 51.4014 39.5629 51.5739L39.5599 51.5759Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M49.3548 51.9771C49.2152 51.9377 49.077 51.8926 48.9404 51.8422C49.1118 51.3304 49.2831 50.8179 49.4548 50.3064V50.3061C49.5884 50.3484 49.7206 50.3918 49.8528 50.4372C49.8615 50.4402 49.8705 50.4432 49.8792 50.4462C49.7042 50.9567 49.5295 51.4669 49.3548 51.9771Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M32.9784 55.6587C32.8351 55.611 32.6919 55.5633 32.549 55.5155L32.5457 55.5005C32.5467 55.4992 32.5477 55.4982 32.5487 55.4968C32.5503 55.4945 32.5523 55.4922 32.554 55.4898C32.5564 55.4872 32.5587 55.4845 32.561 55.4815C32.5634 55.4788 32.5657 55.4758 32.5681 55.4732C32.6765 55.3434 32.7639 55.276 32.8308 55.2703C32.8338 55.27 32.8365 55.27 32.8395 55.27C32.8398 55.27 32.8402 55.27 32.8405 55.27C32.9329 55.271 32.9827 55.3978 32.9908 55.649L32.9784 55.6587Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M32.1262 55.3743C31.9555 55.2495 31.8685 55.0733 31.8691 54.8434C31.8691 54.8034 31.8718 54.7617 31.8775 54.7183C32.0472 54.8477 32.1329 55.0289 32.1322 55.2632C32.1322 55.2989 32.1302 55.3362 32.1262 55.3743Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M39.2702 51.811C39.2695 51.811 39.2689 51.811 39.2682 51.811C39.1808 51.809 39.1343 51.6836 39.1296 51.4333C39.2729 51.4804 39.4164 51.5277 39.5597 51.5754C39.5573 51.5781 39.555 51.5811 39.553 51.5838C39.5516 51.5858 39.5503 51.5875 39.5486 51.5891C39.5486 51.5895 39.5483 51.5898 39.548 51.5901C39.546 51.5928 39.5439 51.5951 39.5419 51.5978C39.4325 51.7339 39.3445 51.805 39.2785 51.8107C39.2759 51.811 39.2729 51.811 39.2702 51.811Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M39.5681 51.5735C39.5661 51.5735 39.5644 51.5735 39.5627 51.5735C39.6193 51.401 39.6759 51.2285 39.7328 51.0556C39.8743 51.1043 40.0162 51.1534 40.1581 51.2021C40.1551 51.2071 40.1521 51.2121 40.1488 51.2171C40.1464 51.2211 40.1441 51.2248 40.1414 51.2288C40.1377 51.2348 40.1337 51.2408 40.1297 51.2468C40.1277 51.2502 40.1253 51.2532 40.1233 51.2565C40.1227 51.2572 40.122 51.2582 40.1213 51.2592C39.9781 51.4674 39.7943 51.5725 39.5708 51.5735C39.5698 51.5735 39.5691 51.5735 39.5681 51.5735Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M39.8846 87.0862C39.8611 87.0828 39.8377 87.0788 39.8143 87.0748C39.8026 87.0728 39.7905 87.0705 39.7788 87.0685C39.7788 87.0685 39.7788 87.0685 39.7788 87.0682C39.7785 87.0682 39.7785 87.0682 39.7782 87.0682C39.7684 87.0665 39.7587 87.0645 39.7494 87.0625C39.5824 87.0298 39.4187 86.9841 39.2567 86.9327C38.6714 86.7478 38.1044 86.4893 37.4645 86.4883C37.4635 86.4883 37.4622 86.4883 37.4612 86.4883C37.4608 86.4883 37.4608 86.4883 37.4605 86.4883C37.3685 86.4883 37.2747 86.4936 37.1794 86.5053C37.1707 86.5063 37.162 86.5069 37.1533 86.5069H37.1529C37.1519 86.5069 37.1512 86.5069 37.1502 86.5069C36.9675 86.5049 36.7871 86.2784 36.6057 86.1062C36.5913 86.0929 36.5773 86.0795 36.5629 86.0668C36.5599 86.0642 36.5569 86.0612 36.5535 86.0585C36.5348 86.0418 36.5157 86.0261 36.497 86.0118C36.6516 85.8246 36.7998 85.6304 36.9615 85.4522C37.091 85.3097 37.1683 85.1516 37.1677 84.9881C37.1673 84.924 37.1549 84.8593 37.1292 84.7942C37.1272 84.7889 37.1252 84.7839 37.1228 84.7789C37.1222 84.7769 37.1211 84.7749 37.1205 84.7732C37.0502 84.6144 36.928 84.5476 36.7778 84.5463C36.7767 84.5463 36.7754 84.5463 36.7741 84.5463C36.7738 84.5463 36.7731 84.5463 36.7724 84.5463C36.7282 84.5466 36.6817 84.5523 36.6332 84.563C36.6332 84.563 36.6328 84.563 36.6328 84.5633C36.6305 84.5637 36.6278 84.5643 36.6255 84.5647C36.6211 84.5657 36.6168 84.567 36.6121 84.568C36.4022 84.6201 36.1907 84.6451 35.9796 84.6821C36.0649 84.4372 36.167 84.1956 36.2296 83.9461C36.254 83.8476 36.2684 83.6915 36.2684 83.5857C36.2684 83.5213 36.263 83.4759 36.2516 83.4739C36.2349 83.4706 36.2178 83.4676 36.2004 83.4646C36.1144 83.4489 36.0214 83.4342 35.9317 83.4339C35.9307 83.4339 35.93 83.4339 35.929 83.4339C35.9277 83.4339 35.9263 83.4339 35.9247 83.4339C35.8417 83.4345 35.7617 83.4476 35.6927 83.4839C35.6921 83.4843 35.6917 83.4846 35.6911 83.4849C35.687 83.4869 35.683 83.4893 35.679 83.4916C35.6783 83.4923 35.6773 83.4926 35.6763 83.4933C35.6743 83.4943 35.6726 83.4956 35.6706 83.497C35.3423 83.7032 35.0492 83.9998 34.7413 84.2594C34.7356 84.2604 34.7295 84.2614 34.7235 84.262C34.7181 84.263 34.7131 84.2637 34.7081 84.2647C34.7021 84.2657 34.6964 84.2664 34.6907 84.2674C34.6877 84.268 34.6844 84.2684 34.6813 84.269C34.681 84.269 34.681 84.269 34.681 84.269C34.6767 84.2697 34.6726 84.2704 34.6683 84.271C34.6616 84.272 34.6546 84.2734 34.6482 84.2744C34.6449 84.2747 34.6415 84.2754 34.6382 84.276C34.6375 84.276 34.6372 84.276 34.6365 84.276C34.3621 84.3201 34.1559 84.3508 34.01 84.3508C33.5762 84.3508 33.6689 84.0809 34.0605 83.0896C34.0736 83.0569 34.0869 83.0231 34.1003 82.9884C34.1495 82.8643 34.1726 82.7422 34.1726 82.6277C34.1726 82.262 33.9367 81.9748 33.5565 81.9551C33.5535 81.9551 33.5501 81.9547 33.5471 81.9547C33.5444 81.9547 33.5418 81.9544 33.5391 81.9544C33.5334 81.9544 33.5277 81.9544 33.522 81.9544C33.5217 81.9544 33.5217 81.9544 33.5213 81.9544C33.517 81.9544 33.513 81.9544 33.5086 81.9544C33.3915 81.9564 33.271 81.9851 33.1515 82.0038C33.1365 82.0061 33.1214 82.0081 33.1067 82.0101C33.2995 81.4212 33.4926 80.8326 33.6847 80.2437C33.7238 80.1243 33.7416 80.0122 33.7416 79.9057C33.7419 79.6798 33.6633 79.48 33.5421 79.2941C33.6572 78.9448 33.7724 78.5951 33.8878 78.2457C33.9394 78.0819 33.9999 77.9217 34.0692 77.7646C34.2098 77.815 34.3504 77.8657 34.4913 77.9161C34.4026 78.182 34.3564 78.4279 34.3567 78.6538C34.3577 79.0846 34.5297 79.4426 34.9042 79.7275C35.2613 79.9991 35.5746 80.3418 35.9073 80.6525C35.6586 81.0525 35.5167 81.2808 35.5164 81.4546C35.516 81.6852 35.7647 81.8193 36.344 82.1319C36.4899 81.7312 36.6315 81.3425 36.7734 80.9541C37.0375 81.3341 37.0679 81.7856 37.0679 82.2771C37.0679 82.4249 37.0649 82.5764 37.0649 82.7305C37.0649 83.0505 37.0766 83.3828 37.1499 83.7192C37.4411 83.1833 37.6295 82.6294 38.1299 82.5517C38.1315 82.5564 38.1332 82.5613 38.1349 82.566C38.1365 82.5714 38.1382 82.5764 38.1402 82.5817C38.1409 82.584 38.1416 82.5864 38.1426 82.5887C38.1446 82.5947 38.1466 82.6007 38.1486 82.6067C38.2684 82.9624 38.3273 83.1189 38.4552 83.1202C38.4555 83.1202 38.4562 83.1202 38.4565 83.1202C38.4582 83.1202 38.4599 83.1202 38.4615 83.1199C38.5562 83.1172 38.6884 83.0328 38.9083 82.8837C38.91 82.8827 38.9117 82.8813 38.9134 82.8803C38.9157 82.8787 38.9177 82.8773 38.92 82.8757C38.9224 82.8743 38.9244 82.8727 38.9267 82.8713C38.9378 82.8637 38.9488 82.856 38.9605 82.8483C38.9625 82.847 38.9649 82.8453 38.9669 82.844C38.9702 82.8416 38.9736 82.8393 38.9769 82.8373C38.9799 82.8383 38.9833 82.8393 38.9866 82.8403C39.1329 82.8867 39.2785 82.9264 39.4227 82.9271C39.4237 82.9271 39.4251 82.9271 39.4261 82.9271C39.4267 82.9271 39.4277 82.9271 39.4284 82.9271C39.6185 82.9264 39.8052 82.8573 39.9853 82.6458C39.988 82.6427 39.9903 82.6401 39.9927 82.6371C40.1379 82.6745 40.2835 82.7118 40.4287 82.7495C40.2477 83.3188 40.0466 83.8626 39.6349 84.3118C39.4237 84.542 39.3022 84.8847 39.1396 85.1766C39.1372 85.4245 39.1781 85.5597 39.2708 85.5603C39.2711 85.5603 39.2711 85.5603 39.2714 85.5603C39.2751 85.5603 39.2788 85.5603 39.2828 85.5597C39.3451 85.553 39.4287 85.4903 39.5362 85.3655C39.5382 85.3631 39.5402 85.3608 39.5422 85.3585C39.5462 85.3538 39.5502 85.3491 39.5542 85.3441C39.8397 85.4272 40.1249 85.5099 40.4103 85.593C40.5549 85.6441 40.6989 85.6951 40.8434 85.7462C40.8498 85.9674 40.9191 86.1232 41.1085 86.1239C41.1092 86.1239 41.1095 86.1239 41.1102 86.1239C41.1102 86.1239 41.1105 86.1239 41.1108 86.1239C41.1255 86.1239 41.1413 86.1229 41.1577 86.1209C41.1604 86.1205 41.163 86.1202 41.1657 86.1199C41.3565 86.0939 41.5476 86.0418 41.7383 86.0011C41.8612 86.0552 41.9857 86.1052 42.1118 86.1506C42.3963 86.256 42.6808 86.3611 42.9656 86.4662C42.9134 86.6227 42.8595 86.7782 42.803 86.933C42.7993 86.932 42.7956 86.9314 42.7919 86.9304C42.7909 86.9304 42.7902 86.93 42.7892 86.93C42.7812 86.928 42.7732 86.9263 42.7652 86.9247H42.7648C42.6417 86.9 42.5161 86.8906 42.3893 86.8906C42.3886 86.8906 42.388 86.8906 42.387 86.8906C42.3843 86.8906 42.3813 86.8906 42.3786 86.8906C42.2595 86.891 42.1393 86.8993 42.0185 86.9103C41.9579 86.9157 41.8977 86.9217 41.8371 86.928C41.8331 86.9284 41.829 86.9287 41.8247 86.929C41.8193 86.9297 41.814 86.93 41.8086 86.9307C41.7959 86.932 41.7829 86.9334 41.7701 86.9347C41.6092 86.9507 41.4485 86.9647 41.2902 86.965C41.2892 86.965 41.2882 86.965 41.2872 86.965C41.2862 86.965 41.2852 86.965 41.2839 86.965C41.0245 86.9647 40.7711 86.9263 40.5315 86.7952C40.5312 86.7952 40.5312 86.7949 40.5309 86.7949C40.5245 86.7912 40.5178 86.7875 40.5111 86.7839C40.5084 86.7822 40.5057 86.7809 40.5031 86.7792C40.4984 86.7765 40.494 86.7739 40.4897 86.7715C40.2882 86.8763 40.0864 86.9814 39.8846 87.0862Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M35.8549 86.301C35.8542 86.301 35.8535 86.301 35.8532 86.301C35.797 86.301 35.7397 86.2943 35.6815 86.281C35.6765 86.28 35.6715 86.2787 35.6661 86.2773C35.6306 86.2683 35.5948 86.2597 35.5593 86.2506C34.9057 86.0855 34.2688 85.9116 33.5627 85.9106C33.5607 85.9106 33.5586 85.9106 33.557 85.9106C33.5566 85.9106 33.5563 85.9106 33.556 85.9106C33.481 85.9106 33.4057 85.9126 33.3291 85.917C33.2916 85.919 33.2544 85.92 33.217 85.92H33.2166C33.2149 85.92 33.2136 85.92 33.2122 85.92C32.5633 85.9186 31.9318 85.6254 31.2952 85.4198C31.2889 85.4178 31.2828 85.4158 31.2765 85.4138C31.2691 85.4115 31.2614 85.4091 31.2541 85.4068C31.2507 85.4058 31.2474 85.4045 31.244 85.4035C31.2403 85.4025 31.2366 85.4015 31.2333 85.4001C31.1854 85.3851 31.1379 85.3708 31.09 85.3574C31.0733 85.3524 31.0563 85.3477 31.0392 85.3431C30.6898 85.0011 30.4558 84.4902 29.9394 84.3931C29.9394 84.3908 29.9394 84.3885 29.9394 84.3861C29.9398 84.0848 29.9016 83.7859 29.9016 83.4849C29.9013 83.1909 29.9374 82.8957 30.081 82.5947C30.236 82.2694 30.3822 81.9564 30.7417 81.9213C30.745 81.921 30.748 81.9207 30.7514 81.9204C30.7521 81.9204 30.7527 81.9204 30.7534 81.9204C30.7788 81.918 30.8039 81.917 30.828 81.917C30.8283 81.917 30.8283 81.917 30.8287 81.917C30.831 81.917 30.833 81.917 30.8354 81.917C31.0931 81.919 31.2842 82.0431 31.401 82.2997C31.403 82.3044 31.405 82.3087 31.407 82.3134C31.4073 82.3137 31.4073 82.3141 31.4073 82.3144C31.4093 82.3184 31.411 82.3224 31.4127 82.3264C31.413 82.3274 31.4133 82.3281 31.4137 82.3287C31.4147 82.3317 31.416 82.3344 31.417 82.3374C31.4191 82.3421 31.4211 82.3468 31.4227 82.3514C31.4251 82.3575 31.4274 82.3638 31.4298 82.3698C31.4579 82.4452 31.4639 82.5336 31.4803 82.616C31.4766 82.615 31.4729 82.614 31.4689 82.6127C31.4612 82.6104 31.4532 82.608 31.4455 82.6053C31.4294 82.6 31.4134 82.5943 31.3973 82.5887C31.3595 82.5756 31.3213 82.5637 31.2825 82.5627C31.2805 82.5627 31.2782 82.5627 31.2761 82.5627C31.2745 82.5627 31.2725 82.5627 31.2708 82.5627C30.8946 82.5723 30.7223 82.6681 30.7226 82.8823C30.7226 82.934 30.7326 82.9931 30.7524 83.0595C30.8223 83.2914 30.909 83.5173 31.0108 83.7292C31.0124 83.7332 31.0144 83.7368 31.0164 83.7408C31.074 83.8566 31.1376 83.916 31.2112 83.918C31.2125 83.918 31.2139 83.918 31.2149 83.918C31.2186 83.918 31.2219 83.918 31.2256 83.9177C31.3347 83.9096 31.4659 83.7805 31.6336 83.526C31.6336 83.5256 31.6339 83.5256 31.6339 83.5253C31.6366 83.5213 31.6393 83.5173 31.6419 83.5132C31.6878 83.4432 31.7079 83.3524 31.7403 83.2713C32.1369 83.0241 32.5339 82.7769 32.9301 82.5296C32.8886 82.6868 32.8177 82.8476 32.8153 83.0004C32.8153 83.0014 32.8153 83.0021 32.8153 83.0027C32.8147 83.1028 32.9097 83.1919 32.9616 83.2864C33.0168 83.1642 33.1222 83.0301 33.1219 82.922C33.1219 82.9177 33.1219 82.9133 33.1215 82.909C33.1095 82.7699 32.9987 82.6551 32.9301 82.5299C32.989 82.3564 33.0479 82.1836 33.1068 82.0101C33.1216 82.0081 33.1366 82.0061 33.1517 82.0038C33.2712 81.9851 33.3916 81.9564 33.5088 81.9544C33.5131 81.9544 33.5171 81.9544 33.5215 81.9544C33.5218 81.9544 33.5218 81.9544 33.5221 81.9544C33.5278 81.9544 33.5336 81.9544 33.5392 81.9544C33.5419 81.9544 33.5446 81.9547 33.5472 81.9547C33.5503 81.9547 33.5536 81.9551 33.5566 81.9551C33.9368 81.9747 34.1728 82.262 34.1728 82.6277C34.1728 82.7421 34.1497 82.8643 34.1005 82.9884C34.0871 83.0231 34.0737 83.0568 34.0607 83.0895C33.6691 84.0808 33.5764 84.3508 34.0101 84.3508C34.1564 84.3508 34.3622 84.3201 34.6367 84.276C34.6373 84.276 34.6376 84.276 34.6383 84.276C34.6417 84.2753 34.645 84.2747 34.6484 84.2744C34.6547 84.2734 34.6617 84.272 34.6684 84.271C34.6728 84.2703 34.6768 84.2697 34.6812 84.269C34.6812 84.269 34.6812 84.269 34.6815 84.269C34.6845 84.2683 34.6879 84.268 34.6909 84.2673C34.6966 84.2663 34.7022 84.2657 34.7083 84.2647C34.7133 84.2637 34.7183 84.263 34.7237 84.262C34.7297 84.2613 34.7357 84.2603 34.7414 84.2593C35.1544 84.4001 35.5667 84.5409 35.9797 84.6821C36.1909 84.645 36.4024 84.62 36.6122 84.568C36.6169 84.567 36.6213 84.5656 36.6256 84.5646C36.628 84.5643 36.6306 84.5636 36.633 84.5633C36.633 84.563 36.6333 84.563 36.6333 84.563C36.6819 84.5523 36.7284 84.5466 36.7725 84.5463C36.7732 84.5463 36.7739 84.5463 36.7742 84.5463C36.7756 84.5463 36.7769 84.5463 36.7779 84.5463C36.9282 84.5476 37.0503 84.6144 37.1206 84.7732C37.1213 84.7749 37.1223 84.7769 37.123 84.7789C37.1253 84.7839 37.1273 84.7889 37.1293 84.7942C37.1551 84.8593 37.1675 84.924 37.1678 84.9881C37.1685 85.1515 37.0912 85.3097 36.9616 85.4522C36.8 85.6304 36.6517 85.8246 36.4971 86.0117C36.4948 86.0137 36.4924 86.0158 36.4901 86.0178C36.2913 86.1966 36.0828 86.3004 35.8575 86.301C35.8569 86.301 35.8559 86.301 35.8549 86.301Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M33.5422 79.2944C33.4007 79.2494 33.2607 79.2017 33.1215 79.1506C33.1242 79.1192 33.1255 79.0886 33.1255 79.0585C33.1259 78.8159 33.0372 78.6321 32.8545 78.5103C32.5181 78.5827 32.1821 78.6551 31.8457 78.7275C31.8882 78.5423 31.9548 78.3428 31.9545 78.1823C31.9542 77.9968 31.8645 77.8633 31.5455 77.863C31.5382 77.863 31.5312 77.863 31.5241 77.863C31.5191 77.863 31.5141 77.863 31.5094 77.863C31.507 77.863 31.505 77.863 31.5027 77.863C31.2972 77.863 31.1024 77.851 31.076 77.49C31.2868 77.147 31.6372 76.8089 31.6376 76.3465C31.6376 76.2964 31.6336 76.2451 31.6249 76.192C31.6135 76.1226 31.57 76.0909 31.5137 76.0899C31.5127 76.0899 31.5121 76.0899 31.511 76.0899C31.5087 76.0899 31.5064 76.0899 31.5037 76.0902C31.4337 76.0932 31.3467 76.1413 31.2771 76.2217C31.2745 76.225 31.2718 76.228 31.2691 76.2314C31.2664 76.2347 31.2641 76.238 31.2614 76.241C31.2597 76.243 31.2584 76.2451 31.2567 76.2471C31.1158 76.2004 30.9746 76.1533 30.8337 76.1056C30.837 76.0692 30.8387 76.0342 30.839 76.0001C30.8393 75.7616 30.7544 75.5777 30.576 75.4526C30.4351 75.4045 30.2935 75.3575 30.1523 75.3118C30.1479 75.3118 30.1436 75.3115 30.1392 75.3115C30.1389 75.3115 30.1385 75.3115 30.1385 75.3115C30.1345 75.3115 30.1305 75.3115 30.1268 75.3115C30.1265 75.3115 30.1262 75.3115 30.1262 75.3115C30.1241 75.3115 30.1225 75.3115 30.1205 75.3115C29.9053 75.3131 29.7282 75.4182 29.5853 75.6178C29.5826 75.6218 29.58 75.6254 29.5773 75.6291C29.5726 75.6358 29.5683 75.6425 29.5636 75.6491C29.5589 75.6562 29.5542 75.6635 29.5495 75.6708C29.3059 75.3759 29.0465 75.0966 28.8236 74.7806C28.7429 74.6665 28.7001 74.5704 28.7004 74.4756C28.7011 74.2955 28.8601 74.1213 29.2165 73.84C29.2205 73.841 29.2246 73.8423 29.2286 73.8433C29.2292 73.8433 29.2299 73.8437 29.2309 73.844C29.2369 73.8457 29.2429 73.8473 29.249 73.849C29.2905 73.861 29.332 73.8747 29.3731 73.8894C29.5994 73.9701 29.8239 74.0782 30.0552 74.0802C30.0575 74.0802 30.0596 74.0802 30.0619 74.0802C30.0626 74.0802 30.0636 74.0802 30.0643 74.0802C30.2574 74.0796 30.4555 74.0038 30.6627 73.775C30.6657 73.7716 30.6683 73.7686 30.671 73.7656V73.7653C30.7674 73.9828 30.8467 74.215 30.9655 74.4126C31.0268 74.514 31.158 74.554 31.2694 74.6298C31.505 74.0639 31.7396 73.5 31.9602 72.9698C31.9709 72.9685 31.9813 72.9675 31.9913 72.9661C31.999 72.9651 32.0067 72.9641 32.0141 72.9631C32.0864 72.9528 32.1366 72.9411 32.1771 72.9411C32.1774 72.9411 32.1781 72.9411 32.1784 72.9411C32.1868 72.9415 32.1948 72.9418 32.2022 72.9431C32.2042 72.9434 32.2062 72.9438 32.2082 72.9441C32.2122 72.9451 32.2162 72.9461 32.2202 72.9474C32.2865 72.9695 32.3722 73.0105 32.3953 73.0752C32.3969 73.0806 32.3989 73.0859 32.401 73.0913C32.4046 73.1013 32.408 73.1109 32.4117 73.1206C32.4133 73.1253 32.4154 73.13 32.417 73.1346C32.6741 73.8106 33.1055 74.0279 33.6195 74.0295C33.6215 74.0295 33.6236 74.0295 33.6256 74.0295C33.6266 74.0295 33.6272 74.0295 33.6279 74.0295C33.8568 74.0292 34.1018 73.9865 34.3552 73.9231C34.3575 73.9224 34.3595 73.9221 34.3619 73.9214C34.3679 73.9198 34.3742 73.9184 34.3806 73.9168C34.3853 73.9154 34.3899 73.9141 34.395 73.9131C34.409 73.9094 34.4234 73.9057 34.4375 73.9017C34.2133 74.5928 33.9007 75.1233 33.2337 75.4226C32.9358 75.5564 32.7648 75.9064 32.7658 76.2117C32.7661 76.4042 32.835 76.579 32.9833 76.6705C33.5543 77.0222 33.5466 77.7609 33.8879 78.2461C33.7725 78.5954 33.6574 78.9451 33.5422 79.2944Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M31.8449 78.7288C31.1344 78.4929 30.4238 78.257 29.713 78.0211L29.7126 78.0207V78.0204C29.7669 77.7751 29.8629 77.5246 29.8656 77.2853C29.8703 76.8509 29.9482 76.5416 30.3211 76.5416C30.3214 76.5416 30.3218 76.5416 30.3221 76.5416C30.3613 76.5416 30.4037 76.5449 30.4496 76.5522C30.4516 76.5526 30.4539 76.5529 30.4563 76.5533C30.46 76.5536 30.4633 76.5543 30.4667 76.5549C30.5189 76.5636 30.5697 76.5683 30.6199 76.5683C30.6206 76.5683 30.6209 76.5683 30.6213 76.5683C30.6223 76.5683 30.623 76.5683 30.624 76.5683C30.8542 76.5676 31.0647 76.4712 31.2518 76.253C31.2535 76.251 31.2552 76.249 31.2568 76.247C31.2585 76.245 31.2598 76.2429 31.2615 76.2409C31.2642 76.2379 31.2665 76.2346 31.2692 76.2313C31.2719 76.2279 31.2746 76.2249 31.2773 76.2216C31.3469 76.1412 31.4339 76.0931 31.5038 76.0901C31.5065 76.0898 31.5088 76.0898 31.5112 76.0898C31.5122 76.0898 31.5129 76.0898 31.5139 76.0898C31.5701 76.0908 31.6136 76.1225 31.625 76.1919C31.6337 76.245 31.6377 76.2963 31.6377 76.3464C31.6374 76.8088 31.2869 77.1469 31.0761 77.4899C31.1025 77.8509 31.2973 77.8629 31.5028 77.8629C31.5052 77.8629 31.5072 77.8629 31.5095 77.8629C31.5142 77.8629 31.5192 77.8629 31.5243 77.8629C31.5313 77.8629 31.5383 77.8629 31.5457 77.8629C31.8646 77.8632 31.9543 77.9967 31.9546 78.1822C31.955 78.3427 31.8884 78.5422 31.8459 78.7274C31.8455 78.7278 31.8449 78.7277 31.8445 78.7277C31.8449 78.7281 31.8449 78.7284 31.8449 78.7288Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M31.215 83.9182C31.214 83.9182 31.2126 83.9182 31.2113 83.9182C31.1376 83.9162 31.0741 83.8568 31.0165 83.741C31.0145 83.737 31.0125 83.7334 31.0108 83.7294C30.9091 83.5175 30.8224 83.2916 30.7524 83.0597C30.7327 82.9933 30.7227 82.9342 30.7227 82.8825C30.7223 82.6683 30.8947 82.5725 31.2709 82.5629C31.2725 82.5629 31.2745 82.5629 31.2762 82.5629C31.2782 82.5629 31.2805 82.5629 31.2826 82.5629C31.3214 82.5639 31.3596 82.5759 31.3974 82.5889C31.4134 82.5945 31.4295 82.6002 31.4455 82.6055C31.4532 82.6082 31.4613 82.6106 31.469 82.6129C31.473 82.6142 31.4767 82.6152 31.4804 82.6162C31.567 82.8348 31.6537 83.053 31.7404 83.2715C31.708 83.3526 31.6879 83.4434 31.642 83.5134C31.6393 83.5175 31.6366 83.5215 31.634 83.5255C31.634 83.5258 31.6336 83.5258 31.6336 83.5262C31.4663 83.7807 31.3348 83.9098 31.2257 83.9179C31.222 83.9182 31.2186 83.9182 31.215 83.9182Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M29.1055 81.2483C28.9603 81.2016 28.8154 81.1545 28.6708 81.1075C28.5533 80.9654 28.4703 80.7922 28.47 80.6183C28.47 80.4975 28.5095 80.3764 28.6055 80.265C28.9556 79.8569 29.2277 79.2867 29.7856 79.1993C29.5587 79.8823 29.3318 80.5653 29.1055 81.2483Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M30.7267 80.2532C30.6406 80.1864 30.5603 80.1457 30.5603 80.1227C30.5606 80.122 30.5607 80.1214 30.5607 80.1207C30.6172 79.8951 30.6507 79.6425 30.7665 79.4574C30.807 79.393 30.8552 79.363 30.898 79.362C30.8987 79.362 30.8993 79.362 30.9 79.362C30.9017 79.362 30.903 79.362 30.9044 79.362C30.9756 79.3653 31.0305 79.45 31.0098 79.5908C31.0095 79.5935 31.0088 79.5962 31.0085 79.5988C31.0081 79.6002 31.0081 79.6015 31.0078 79.6025C30.9703 79.8214 30.8277 80.0296 30.7267 80.2532Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M32.1687 79.2996C32.0328 79.2996 31.9759 79.1267 31.8451 78.7287C31.8451 78.7283 31.8451 78.728 31.8447 78.7277C31.8451 78.7277 31.8457 78.7277 31.8461 78.7273C32.1824 78.6549 32.5185 78.5825 32.8548 78.5101C32.8029 78.6796 32.7487 78.8481 32.6918 79.0159C32.6761 79.0266 32.6607 79.037 32.6456 79.0473C32.6322 79.0563 32.6192 79.0653 32.6061 79.074C32.6004 79.0777 32.5951 79.0813 32.5894 79.0854C32.5854 79.088 32.5814 79.0907 32.5774 79.0934C32.3792 79.2262 32.2574 79.2996 32.1687 79.2996Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M15.3006 79.2104C15.2982 79.2104 15.2959 79.2101 15.2935 79.2101C15.2892 79.2098 15.2849 79.2098 15.2805 79.2095C15.2735 79.2095 15.2661 79.2091 15.2591 79.2091C15.2567 79.2091 15.2544 79.2091 15.252 79.2091C15.2494 79.2091 15.247 79.2091 15.2447 79.2091C15.2413 79.2091 15.238 79.2091 15.2346 79.2091C15.2246 79.2091 15.2142 79.2095 15.2039 79.2095C15.1898 79.2095 15.1751 79.2098 15.161 79.2098C15.0733 79.2098 14.9887 79.2038 14.9482 79.1561C14.9482 79.1561 14.9478 79.1561 14.9478 79.1557C14.9471 79.1551 14.9465 79.1541 14.9458 79.1534C14.9445 79.1517 14.9435 79.1501 14.9421 79.1484C14.8729 79.0466 14.8474 78.9348 14.8474 78.8184C14.8471 78.6309 14.912 78.4304 14.9646 78.2368L14.9652 78.2358C15.0944 78.4904 15.2303 78.7403 15.3481 79.0026C15.3484 79.0033 15.3488 79.0043 15.3491 79.0049C15.3514 79.0116 15.3525 79.0203 15.3525 79.03C15.3525 79.0353 15.3521 79.0413 15.3514 79.0473C15.3447 79.1127 15.3066 79.2104 15.3006 79.2104Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M33.1217 79.1501C32.9785 79.1054 32.8349 79.0607 32.6917 79.0157C32.7485 78.8478 32.8028 78.6794 32.8546 78.5099C33.0374 78.6316 33.1261 78.8155 33.1257 79.0581C33.1257 79.0881 33.1244 79.1188 33.1217 79.1501Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M54.2142 83.9155C54.2775 83.715 54.3156 83.5285 54.3149 83.3616C54.3143 83.0543 54.1831 82.8148 53.8401 82.6823C53.8337 82.6796 53.8273 82.6773 53.8213 82.6749C53.4752 82.5408 53.1332 82.396 52.7604 82.395C52.7594 82.395 52.7584 82.395 52.7574 82.395C52.757 82.395 52.7563 82.395 52.756 82.395C52.6298 82.3953 52.5007 82.4117 52.3661 82.4511C52.3574 82.4534 52.3487 82.4561 52.34 82.4587C52.3323 82.4614 52.3246 82.4634 52.3169 82.4657C52.244 82.4868 52.179 82.4964 52.1215 82.4964C52.1208 82.4964 52.1205 82.4964 52.1198 82.4964C52.1191 82.4964 52.1181 82.4964 52.1174 82.4964C51.6971 82.4944 51.6459 81.9866 51.5003 81.6339C51.4936 81.6359 51.4869 81.6376 51.4802 81.6392C51.4752 81.6406 51.4702 81.6419 51.4652 81.6433C51.4565 81.6456 51.4478 81.6479 51.4391 81.6503C51.4351 81.6513 51.4314 81.6519 51.4273 81.6529C51.422 81.6546 51.4166 81.6559 51.4116 81.6573C51.4086 81.6579 51.4059 81.6586 51.4029 81.6593C51.1519 81.7223 50.9116 81.7664 50.6934 81.7667C50.6924 81.7667 50.6914 81.7667 50.6904 81.7667C50.6894 81.7667 50.6884 81.7667 50.6874 81.7667C50.1763 81.766 49.7847 81.5245 49.6519 80.728C49.6519 80.728 49.6519 80.728 49.6519 80.7277C49.6495 80.7147 49.6475 80.7013 49.6455 80.688C49.6412 80.6876 49.6372 80.687 49.6331 80.6866C49.6027 80.6833 49.5736 80.6803 49.5458 80.6773C49.4099 80.6633 49.3012 80.6533 49.2105 80.6533C49.2094 80.6533 49.2084 80.6533 49.2078 80.6533C49.2071 80.6533 49.2061 80.6533 49.2054 80.6533C48.8547 80.6536 48.7744 80.8011 48.4534 81.4043C48.4517 81.4077 48.4497 81.4114 48.448 81.4147C48.3048 81.3787 48.1646 81.335 48.0264 81.2829C48.0839 81.1124 48.1395 80.9412 48.1927 80.769C48.2526 80.5999 48.3071 80.4287 48.3563 80.2562C48.5515 79.8615 48.7469 79.4668 48.942 79.072C49.8098 78.984 50.0083 77.721 50.8286 77.4952C50.9454 77.4631 50.9949 77.3323 50.9946 77.1908C50.9946 77.0617 50.9534 76.9236 50.8855 76.8418C50.6937 76.6109 50.4304 76.4601 50.1978 76.2749C50.5478 75.9303 50.7262 75.5305 50.7259 75.0737C50.7259 74.9683 50.7165 74.8599 50.6971 74.7481C50.9324 74.9139 51.1974 75.043 51.3942 75.2562C51.592 75.4705 51.7015 75.7928 51.8952 76.0137C51.8959 76.0147 51.8966 76.0153 51.8972 76.016C51.9079 76.0264 51.9237 76.031 51.9438 76.031C51.9441 76.031 51.9444 76.031 51.9448 76.031C51.9518 76.031 51.9595 76.0303 51.9675 76.0293C51.9735 76.0287 51.9796 76.0277 51.9859 76.0263C52.0023 76.023 52.0204 76.018 52.0391 76.0117C52.0395 76.0117 52.0395 76.0117 52.0395 76.0117C52.1205 75.9853 52.2175 75.9366 52.2928 75.9012C52.2968 75.8992 52.3009 75.8975 52.3049 75.8955C52.3624 75.8692 52.4133 75.7751 52.4448 75.701C52.4672 75.648 52.4923 75.5592 52.492 75.5092C52.492 75.4935 52.4893 75.4815 52.4833 75.4758C52.2761 75.2899 52.2115 75.0721 52.2115 74.8372C52.2115 74.4475 52.3899 74.011 52.3902 73.5966C52.3906 73.4948 52.3798 73.3944 52.3531 73.2963C51.8979 73.4408 51.4722 73.5762 51.0461 73.7114C51.0468 73.7044 51.0475 73.6977 51.0482 73.6907C51.1191 73.0017 51.1426 72.7501 50.8654 72.7494C50.8651 72.7494 50.8648 72.7494 50.8644 72.7494C50.8581 72.7494 50.8514 72.7494 50.8447 72.7497C50.7326 72.7541 50.5753 72.7951 50.3581 72.8615C50.3537 72.8629 50.349 72.8642 50.3447 72.8659C50.3313 72.8699 50.3176 72.8742 50.3035 72.8786C50.2945 72.8812 50.2854 72.8842 50.2761 72.8872C50.2684 72.8896 50.261 72.8919 50.2533 72.8942C50.252 72.8946 50.251 72.8949 50.2496 72.8952C50.2403 72.8982 50.2309 72.9012 50.2212 72.9042C50.2091 72.9082 50.1971 72.9119 50.1847 72.9159C50.183 72.9166 50.1814 72.9169 50.1797 72.9176C50.177 72.9183 50.1743 72.9193 50.1716 72.9199C50.1388 72.9306 50.105 72.9413 50.0702 72.9523C50.0665 72.9536 50.0625 72.955 50.0585 72.9563C50.0515 72.9583 50.0445 72.9606 50.0374 72.963C50.0157 72.8849 50.0067 72.8085 50.0067 72.7334C50.0073 72.3911 50.2011 72.0774 50.2881 71.7484C50.2901 71.7484 50.2921 71.7481 50.2941 71.7478C50.3045 71.7471 50.3152 71.7457 50.3256 71.7447C50.4096 71.7354 50.4933 71.7204 50.5763 71.7044C50.7423 71.6723 50.9066 71.6366 51.0702 71.636C51.0712 71.636 51.0723 71.636 51.0733 71.636C51.0749 71.636 51.0763 71.636 51.0779 71.636C51.2751 71.637 51.4709 71.69 51.668 71.8632C51.6707 71.8656 51.6733 71.8679 51.676 71.8706C51.68 71.8742 51.6844 71.8779 51.6884 71.8816C51.6914 71.8846 51.6944 71.8872 51.6974 71.8899C51.9233 72.1025 52.1794 72.1962 52.4485 72.1965C52.4495 72.1965 52.4501 72.1965 52.4508 72.1965C52.4518 72.1965 52.4528 72.1965 52.4538 72.1965C52.8106 72.1955 53.1904 72.0317 53.5539 71.7654C53.575 71.7501 53.5961 71.7344 53.6172 71.7184C53.5047 72.0547 53.3919 72.3907 53.2791 72.7271C53.242 73.0063 53.2172 73.1909 53.2175 73.315C53.2179 73.5556 53.3119 73.5676 53.588 73.6013C53.5897 73.6013 53.591 73.6016 53.5927 73.6016C53.5967 73.6023 53.6011 73.6026 53.6051 73.6026C53.6068 73.6026 53.6081 73.6029 53.6098 73.6029C53.6142 73.6029 53.6185 73.6033 53.6228 73.6033C53.6523 73.6033 53.6821 73.5996 53.7122 73.5959C53.742 73.5926 53.7718 73.5889 53.8012 73.5889C53.8026 73.5889 53.8039 73.5889 53.8056 73.5893C53.8069 73.5893 53.8086 73.5893 53.8099 73.5893C53.8829 73.5909 53.9558 73.5979 54.0251 73.6153C54.3454 73.696 54.5007 73.8345 54.5007 74.0721C54.5003 74.2372 54.4254 74.4504 54.2785 74.7254C54.0904 75.0787 53.986 75.2746 53.9866 75.4278C53.9876 75.6183 54.152 75.7427 54.5211 76.022C54.3561 76.8131 53.9224 77.4134 53.3956 77.9479C53.0177 78.044 52.6352 78.1137 52.263 78.2429C51.8578 78.3837 51.6633 78.7477 51.6502 79.2852C51.6499 79.2926 51.6499 79.2999 51.6499 79.3073C51.6492 79.6726 51.8544 80.03 52.0719 80.0357C52.0736 80.0357 52.0753 80.0357 52.0769 80.0357C52.0773 80.0357 52.0773 80.0357 52.0776 80.0357C52.082 80.0357 52.0867 80.0357 52.0914 80.0353C52.4304 80.0106 52.6804 79.7647 52.8487 79.4454C53.0141 79.1324 53.1171 78.7804 53.2477 78.4457C53.3922 78.6132 53.4297 78.8084 53.4301 79.0173C53.4304 79.1705 53.4103 79.3309 53.3973 79.4928C53.3956 79.5165 53.3939 79.5405 53.3923 79.5642C53.3909 79.5882 53.3896 79.6109 53.3886 79.6332C53.3722 79.9739 53.4096 80.1244 53.577 80.1254C53.5777 80.1254 53.5787 80.1254 53.5793 80.1254C53.581 80.1254 53.583 80.1254 53.585 80.1254C53.6797 80.1237 53.815 80.076 54.003 79.9903C54.0041 79.9896 54.005 79.9893 54.0061 79.9886C54.0389 79.9736 54.073 79.9576 54.1088 79.9406C54.1111 79.9392 54.1131 79.9382 54.1155 79.9372C54.1168 79.9366 54.1178 79.9362 54.1188 79.9356C54.1245 79.9329 54.1302 79.9302 54.1356 79.9275C54.1366 79.9269 54.1376 79.9266 54.1389 79.9259C54.1466 79.9222 54.1546 79.9182 54.1627 79.9142C54.165 79.9132 54.167 79.9122 54.1694 79.9109C54.5161 80.2332 54.6704 80.674 54.6697 81.2108C54.6697 81.2152 54.6697 81.2192 54.6697 81.2235C54.6697 81.2278 54.6697 81.2318 54.6697 81.2362C54.6694 81.7744 54.834 82.2092 55.1771 82.5328C55.2075 82.6569 55.2882 82.8314 55.2875 82.9239C55.2872 82.9429 55.2835 82.9586 55.2751 82.9696C54.9746 83.3603 54.734 83.8758 54.2142 83.9155ZM49.6489 80.6793C49.6472 80.6793 49.6459 80.6796 49.6442 80.68L49.6489 80.6883C49.6489 80.6853 49.6489 80.6823 49.6489 80.6793C49.8858 80.6459 50.0776 80.5238 50.1613 80.2385C50.1626 80.2342 50.1636 80.2295 50.1649 80.2248C50.1656 80.2218 50.1663 80.2185 50.167 80.2155C50.1676 80.2128 50.1683 80.2102 50.1686 80.2075C50.2078 80.006 50.0722 79.7727 49.9377 79.7577C49.9333 79.7571 49.9287 79.7571 49.9243 79.7571C49.924 79.7571 49.9236 79.7571 49.9233 79.7571C49.8972 79.7571 49.8711 79.7661 49.8467 79.7854C49.7513 79.8625 49.68 80.0377 49.6532 80.1761C49.6412 80.2385 49.6375 80.3023 49.6375 80.3663C49.6375 80.4701 49.6475 80.5752 49.6489 80.6793Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M55.9054 87.7812C55.9037 87.7812 55.9017 87.7812 55.9 87.7812C55.475 87.7802 55.0938 87.6218 54.7959 87.1363C54.7909 87.1286 54.7862 87.1206 54.7815 87.1126C54.7802 87.1106 54.7788 87.1082 54.7775 87.1059C54.6764 86.9354 54.3896 86.9254 54.1881 86.8416C53.7179 86.8593 53.247 86.8773 52.7768 86.8954L52.759 86.8283C53.1402 86.4953 53.5214 86.1626 53.8906 85.84C53.7989 85.2891 53.7149 84.7853 53.6309 84.2814C53.8253 84.1596 54.0198 84.0375 54.2142 83.9154C54.734 83.8757 54.9746 83.3602 55.2752 82.9695C55.2835 82.9584 55.2872 82.9428 55.2876 82.9237C55.2882 82.8313 55.2075 82.6568 55.1771 82.5327C55.2356 82.3619 55.2939 82.191 55.3514 82.0198C55.3525 82.0198 55.3535 82.0198 55.3541 82.0198C55.3571 82.0198 55.3602 82.0198 55.3629 82.0198C55.5961 82.0172 55.7859 81.9024 55.9331 81.6755C55.9388 81.6669 55.9442 81.6578 55.9499 81.6492L55.9505 81.6495C56.1182 82.0859 56.2862 82.5227 56.4539 82.9591C56.4539 82.9598 56.4536 82.9601 56.4536 82.9608C56.4539 82.9608 56.4542 82.9608 56.4546 82.9608C56.4576 82.9745 56.4609 82.9882 56.4639 83.0018C56.4653 83.0072 56.4663 83.0122 56.4676 83.0175C56.4683 83.0209 56.4693 83.0245 56.47 83.0282C56.7083 84.0502 56.8164 84.3235 57.3545 84.3242C57.3548 84.3242 57.3555 84.3242 57.3559 84.3242C57.3569 84.3242 57.3575 84.3242 57.3585 84.3242C57.4874 84.3238 57.6407 84.3081 57.8261 84.2834C57.8331 84.2828 57.8401 84.2818 57.8468 84.2808C57.8552 84.2797 57.8632 84.2784 57.8712 84.2774C57.8803 84.2761 57.8893 84.2751 57.8987 84.2737C57.899 84.2737 57.8994 84.2738 57.8997 84.2734C57.9061 84.2728 57.9121 84.2717 57.9188 84.2711C57.9251 84.2701 57.9315 84.2691 57.9378 84.2681C57.9526 84.2661 57.9673 84.2641 57.9824 84.2621C58.1256 84.2417 58.2685 84.2134 58.4121 84.1883V84.1887C58.4891 84.4029 58.5657 84.6174 58.6423 84.8317C58.5506 84.9921 58.5165 85.1393 58.5165 85.2784C58.5168 85.7012 58.8375 86.0479 58.8385 86.4619C58.8385 86.539 58.8274 86.6187 58.8013 86.7015C58.7996 86.7035 58.798 86.7052 58.7966 86.7072C58.7899 86.7142 58.7836 86.7215 58.7772 86.7282C58.7766 86.7289 58.7759 86.7295 58.7752 86.7302C58.6052 86.9087 58.4308 86.9397 58.2548 86.9401C58.2534 86.9401 58.2518 86.9401 58.2504 86.9401C58.2498 86.9401 58.2491 86.9401 58.2484 86.9401C58.2284 86.9401 58.2086 86.9397 58.1885 86.9391C58.1651 86.9384 58.142 86.9374 58.1186 86.9364C58.0911 86.9354 58.0637 86.9344 58.0363 86.9337C58.0212 86.9334 58.0061 86.9331 57.9911 86.9331C57.9897 86.9331 57.9884 86.9331 57.987 86.9331C57.9864 86.9331 57.9854 86.9331 57.9844 86.9331C57.981 86.9331 57.9773 86.9331 57.9737 86.9331C57.9676 86.9331 57.9613 86.9331 57.9553 86.9334C57.4857 86.9437 57.0871 87.1843 56.7688 87.6328C56.47 87.7168 56.1785 87.7812 55.9054 87.7812Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M44.1699 85.7131L44.1692 85.7128C44.2405 85.3535 44.4135 84.945 44.4139 84.62C44.4142 84.556 44.4075 84.4956 44.3921 84.4392C44.2177 83.7962 43.8168 83.268 43.1809 83.1623C43.1769 83.1619 43.1732 83.1613 43.1692 83.1606C43.1678 83.1603 43.1665 83.1603 43.1652 83.1599C43.1203 83.1533 43.0765 83.1503 43.033 83.1499C43.033 83.1499 43.0326 83.1499 43.0323 83.1499C43.0306 83.1499 43.029 83.1503 43.0276 83.1503C42.6314 83.1523 42.287 83.4192 41.9941 83.7896C41.9905 83.7942 41.9864 83.7989 41.9827 83.8039C41.9797 83.8079 41.9764 83.8119 41.9734 83.8159C41.97 83.8203 41.9667 83.8246 41.9634 83.8289C41.9627 83.8303 41.9617 83.8313 41.9607 83.8326C41.96 83.8323 41.9596 83.8316 41.959 83.8313C41.959 83.8316 41.959 83.8323 41.9586 83.8326C41.6866 83.6164 41.5125 83.2747 41.0918 83.2554C40.8499 83.2444 40.6487 82.9284 40.4292 82.7499C40.2839 82.7122 40.1383 82.6748 39.9931 82.6374C39.8636 82.5673 39.7146 82.524 39.6089 82.4222C39.5242 82.3408 39.4867 82.252 39.4871 82.1656C39.4874 82.0392 39.5684 81.9174 39.7019 81.8303C39.9001 81.7015 40.1323 81.6574 40.3495 81.576C40.4205 81.5654 40.4968 81.5437 40.5727 81.5223C40.6658 81.4963 40.7588 81.4709 40.8405 81.4676C40.8465 81.4673 40.8525 81.4673 40.8586 81.4673C40.8589 81.4673 40.8596 81.4673 40.8599 81.4673C40.9031 81.4676 40.9426 81.4743 40.9774 81.4916C40.9787 81.4923 40.98 81.4929 40.9814 81.4936C40.9834 81.4946 40.9857 81.4959 40.9881 81.4973C40.9934 81.5003 40.9991 81.5036 41.0048 81.5066C41.1962 81.6137 41.383 81.6641 41.5691 81.6648C41.5701 81.6648 41.5711 81.6648 41.5721 81.6648C41.5734 81.6648 41.5744 81.6648 41.5754 81.6648C41.8358 81.6638 42.0959 81.5657 42.3676 81.3878C42.3703 81.3862 42.3726 81.3845 42.3753 81.3828C42.3787 81.3805 42.382 81.3785 42.3854 81.3762C42.3877 81.3748 42.3897 81.3732 42.3921 81.3718C42.5139 81.2901 42.6745 81.2994 42.8178 81.2667C42.8231 81.7592 43.2535 81.5553 43.4289 81.7285C43.4309 81.7305 43.4329 81.7325 43.4349 81.7345C43.4403 81.7399 43.4456 81.7452 43.451 81.7505C43.6963 81.9868 43.9316 82.0995 44.1625 82.1005C44.1635 82.1005 44.1642 82.1005 44.1652 82.1005C44.1662 82.1005 44.1668 82.1005 44.1678 82.1005C44.4697 82.0992 44.7632 81.9067 45.0604 81.5483C45.0608 81.5477 45.0614 81.5473 45.0618 81.5467C45.0681 81.539 45.0745 81.5313 45.0809 81.5236C45.0862 81.5166 45.0916 81.5099 45.0973 81.5033C45.0983 81.5016 45.0996 81.5 45.101 81.4983C45.1053 81.4929 45.1096 81.4873 45.1143 81.4816C45.119 81.4756 45.1237 81.4696 45.1284 81.4636C45.2676 81.5083 45.4055 81.5563 45.5427 81.6067C45.5437 81.6137 45.5451 81.6207 45.5464 81.6277C45.5789 81.8093 45.6307 81.897 45.7238 81.8997C45.7254 81.9 45.7271 81.9 45.7285 81.9C45.7291 81.9 45.7295 81.9 45.7301 81.9C45.7834 81.8994 45.8499 81.8723 45.9333 81.8203C45.9346 81.8193 45.936 81.8186 45.9373 81.8176C45.9406 81.8153 45.9443 81.8132 45.948 81.8106C45.949 81.8102 45.95 81.8092 45.951 81.8089C45.9557 81.8059 45.9604 81.8026 45.9651 81.7996C45.9651 81.7996 45.9651 81.7996 45.9654 81.7996C45.9684 81.7973 45.9718 81.7953 45.9751 81.7929C45.9785 81.7909 45.9815 81.7886 45.9848 81.7862C45.9908 81.7822 45.9969 81.7782 46.0029 81.7739C46.107 81.7005 46.2044 81.6668 46.2884 81.6658C46.2897 81.6658 46.2911 81.6658 46.2924 81.6658C46.2937 81.6658 46.2954 81.6658 46.2967 81.6658C46.4704 81.6681 46.5859 81.8123 46.5863 82.0365C46.5863 82.0438 46.5862 82.0512 46.5859 82.0585C46.5856 82.0692 46.5856 82.0802 46.5856 82.0916C46.5856 82.1723 46.5933 82.2644 46.5933 82.3478C46.5933 82.4369 46.5839 82.5166 46.5454 82.5627C45.9758 83.2493 45.6816 84.0822 45.3359 84.903C45.118 85.4188 44.6535 85.6527 44.1699 85.7131Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M46.6692 80.7593C46.6672 80.7593 46.6652 80.7593 46.6632 80.7593C46.4139 80.7579 46.1682 80.6772 45.9172 80.5811C45.9155 80.5804 45.9135 80.5798 45.9118 80.5791C45.9065 80.5771 45.9011 80.5748 45.8958 80.5728C45.4711 80.426 45.046 80.2788 44.6213 80.132C44.8238 80.0102 45.0266 79.8884 45.2294 79.767C45.3365 79.766 45.4517 79.749 45.5655 79.7353C45.6455 79.7253 45.7248 79.7169 45.7997 79.7162C45.8027 79.7162 45.8054 79.7162 45.8084 79.7162C45.8094 79.7162 45.8101 79.7162 45.8108 79.7162C45.9142 79.7166 46.0092 79.7323 46.0872 79.7803C46.2362 79.8717 46.3754 79.9104 46.5059 79.9108C46.5066 79.9108 46.5073 79.9111 46.5079 79.9111C46.5093 79.9111 46.5109 79.9108 46.5123 79.9108C46.868 79.9084 47.1605 79.6212 47.4253 79.3352C47.428 79.3325 47.4303 79.3299 47.4326 79.3272C47.4393 79.3198 47.446 79.3125 47.4527 79.3055C47.4544 79.3035 47.4561 79.3019 47.4577 79.2999C47.4628 79.2945 47.4678 79.2892 47.4728 79.2838C47.4745 79.2818 47.4758 79.2801 47.4775 79.2785C47.4818 79.2738 47.4862 79.2691 47.4902 79.2645C47.6508 79.0896 47.5785 78.6218 47.612 78.2868C48.1605 78.2531 48.2295 77.5688 48.5899 77.2805C48.6418 77.3192 48.7007 77.3476 48.7412 77.3973C48.7415 77.3979 48.7422 77.3986 48.7425 77.3989C48.7509 77.4093 48.759 77.42 48.767 77.4313C48.7687 77.434 48.7707 77.4366 48.7727 77.4393C48.7744 77.4416 48.7757 77.444 48.7774 77.4464C48.7807 77.451 48.7841 77.456 48.7871 77.4607C48.7917 77.4674 48.7961 77.474 48.8005 77.4807C48.8038 77.486 48.8072 77.4914 48.8105 77.4971C48.8145 77.5031 48.8182 77.5094 48.8222 77.5154C48.9159 77.6682 49.0046 77.8471 49.1094 77.8491C49.11 77.8491 49.1104 77.8491 49.111 77.8491C49.1117 77.8491 49.1124 77.8491 49.1134 77.8491C49.2914 77.8447 49.5508 77.6492 49.6646 77.456C49.8751 77.0986 50.0056 76.6832 50.1689 76.2922L50.1977 76.2748C50.4303 76.46 50.6937 76.6108 50.8855 76.8417C50.9534 76.9235 50.9946 77.0616 50.9946 77.1908C50.9949 77.3322 50.9454 77.463 50.8286 77.4951C50.0083 77.721 49.8098 78.9839 48.942 79.072C48.7469 79.4667 48.5514 79.8614 48.3563 80.2561C48.3326 80.2588 48.3078 80.2605 48.2831 80.2615C48.2613 80.2625 48.2389 80.2628 48.2164 80.2628C48.2134 80.2628 48.2101 80.2628 48.2067 80.2628C48.2054 80.2628 48.2041 80.2628 48.2027 80.2628C48.184 80.2628 48.1649 80.2628 48.1458 80.2625C48.1227 80.2618 48.0993 80.2611 48.0759 80.2608C48.032 80.2595 47.9882 80.2585 47.9454 80.2585C47.7841 80.2585 47.6341 80.2745 47.5354 80.3662C47.534 80.3672 47.5327 80.3686 47.5314 80.3699C47.529 80.3722 47.5263 80.3746 47.524 80.3769C47.52 80.3809 47.516 80.3846 47.5123 80.3883C47.2211 80.6615 46.9463 80.7576 46.6759 80.7593C46.6736 80.7593 46.6716 80.7593 46.6692 80.7593Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M44.1651 82.1001C44.1641 82.1001 44.1635 82.1001 44.1625 82.1001C43.9316 82.0991 43.6963 81.9863 43.4509 81.7501C43.4456 81.7447 43.4402 81.7394 43.4349 81.7341C43.4329 81.7321 43.4309 81.7301 43.4288 81.728C43.2535 81.5549 42.8231 81.7588 42.8177 81.2663C42.7324 81.045 42.6467 80.8242 42.561 80.6029C42.5634 80.5973 42.5657 80.5919 42.5681 80.5863C42.5788 80.5612 42.5892 80.5369 42.5992 80.5128C42.9212 79.7588 43.0681 79.4368 43.3211 79.4354C43.3214 79.4354 43.3221 79.4354 43.3224 79.4354C43.3271 79.4354 43.3315 79.4355 43.3362 79.4358C43.5099 79.4435 43.7347 79.5963 44.0965 79.8595C44.1076 79.8675 44.1186 79.8759 44.13 79.8839C44.1303 79.8842 44.1307 79.8846 44.1313 79.8849C44.1364 79.8886 44.1417 79.8926 44.1467 79.8962C44.1497 79.8986 44.1528 79.9006 44.1558 79.9029C44.1588 79.9049 44.1618 79.9072 44.1648 79.9092C44.1688 79.9123 44.1732 79.9156 44.1775 79.9186C44.1795 79.9203 44.1816 79.9216 44.1836 79.9233C44.1963 79.9323 44.2093 79.9419 44.2224 79.9513C44.3399 80.0374 44.4878 80.0727 44.6217 80.1318C45.0464 80.2786 45.4714 80.4258 45.8961 80.5726C45.8382 80.7464 45.7803 80.9202 45.7217 81.0941C45.713 81.0938 45.7047 81.0934 45.696 81.0934C45.6956 81.0934 45.6956 81.0934 45.6953 81.0934C45.6936 81.0934 45.6916 81.0934 45.6899 81.0934C45.4711 81.0954 45.293 81.2026 45.1561 81.4168C45.1551 81.4184 45.1541 81.4201 45.1531 81.4214C45.1498 81.4271 45.1461 81.4328 45.1428 81.4388C45.1377 81.4468 45.133 81.4548 45.1283 81.4631C45.1237 81.4691 45.119 81.4752 45.1143 81.4812C45.1096 81.4868 45.1053 81.4925 45.1009 81.4978C45.0996 81.4995 45.0982 81.5012 45.0972 81.5028C45.0915 81.5095 45.0862 81.5162 45.0808 81.5232C45.0745 81.5309 45.0681 81.5386 45.0617 81.5462C45.0614 81.5469 45.0607 81.5472 45.0604 81.5479C44.7632 81.9062 44.4694 82.0988 44.1678 82.1001C44.1668 82.1001 44.1661 82.1001 44.1651 82.1001Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M52.7592 86.8284C52.4784 86.7486 52.1979 86.6689 51.9171 86.5895C52.0282 86.2214 52.2083 85.8384 52.209 85.4987C52.2093 85.2304 52.0975 84.9889 51.7508 84.803C51.6437 84.7456 51.567 84.6252 51.5674 84.5137C51.5674 84.4183 51.6233 84.3296 51.7635 84.2925C52.3103 84.148 52.3683 83.464 52.8438 83.1794C53.1002 83.5384 53.3656 83.9098 53.631 84.2815C53.715 84.7853 53.799 85.2892 53.8907 85.8401C53.5216 86.1627 53.1403 86.4954 52.7592 86.8284Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M43.2561 86.9612C43.2554 86.9612 43.255 86.9612 43.2544 86.9612C43.163 86.9612 43.0542 86.9538 42.9214 86.9428C42.912 86.9422 42.9023 86.9415 42.8929 86.9405C42.8862 86.9402 42.8792 86.9395 42.8725 86.9388C42.8725 86.9388 42.8725 86.9388 42.8722 86.9388C42.8685 86.9385 42.8648 86.9382 42.8611 86.9378C42.8564 86.9375 42.8514 86.9372 42.8464 86.9368C42.8427 86.9365 42.839 86.9361 42.8354 86.9358C42.831 86.9355 42.8267 86.9352 42.8223 86.9348C42.8213 86.9345 42.8206 86.9345 42.8196 86.9345C42.8143 86.9341 42.8089 86.9335 42.8032 86.9331C42.8598 86.7783 42.9137 86.6228 42.9659 86.4664C43.166 86.3372 43.3665 86.2081 43.567 86.079C43.6245 85.9128 43.6864 85.748 43.7524 85.5851C43.8923 85.6238 44.0315 85.6666 44.169 85.7126L44.1697 85.7129C44.1115 85.8741 44.0619 86.0399 43.993 86.1958C43.99 86.2028 43.987 86.2094 43.9843 86.2161C43.7166 86.822 43.6496 86.9608 43.2577 86.9612C43.257 86.9612 43.2567 86.9612 43.2561 86.9612Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M47.9445 81.9844C47.9368 81.9844 47.9141 81.9086 47.9071 81.8399C47.9057 81.8272 47.905 81.8145 47.905 81.8028C47.905 81.7915 47.9057 81.7805 47.9071 81.7711C47.9342 81.6073 47.9847 81.4462 48.0259 81.284L48.0262 81.2843C48.0262 81.284 48.0265 81.2837 48.0265 81.283C48.1648 81.335 48.305 81.3788 48.4482 81.4148C48.3843 81.57 48.3428 81.7471 48.2484 81.8723C48.1875 81.9527 48.0493 81.9627 47.9449 81.984C47.9445 81.9844 47.9445 81.9844 47.9445 81.9844Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M45.5425 81.6067C45.4053 81.5563 45.2674 81.5083 45.1282 81.4635C45.1329 81.4552 45.1376 81.4472 45.1426 81.4392C45.1459 81.4332 45.1496 81.4275 45.1529 81.4218C45.154 81.4205 45.155 81.4188 45.156 81.4172C45.2928 81.203 45.4712 81.0958 45.6898 81.0938C45.6914 81.0938 45.6935 81.0938 45.6951 81.0938C45.6955 81.0938 45.6955 81.0938 45.6958 81.0938C45.7045 81.0938 45.7129 81.0942 45.7216 81.0945C45.662 81.2653 45.6024 81.4359 45.5425 81.6067Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M48.026 81.2842L48.0257 81.2839C47.9075 81.1667 47.848 81.0683 47.8486 80.9885C47.8493 80.8794 47.9628 80.8057 48.1927 80.769C48.1395 80.9412 48.0839 81.1123 48.0264 81.2828C48.0264 81.2835 48.026 81.2838 48.026 81.2842Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M87.6843 84.241C87.681 84.241 87.681 84.241 87.681 84.241C87.5772 84.241 87.4691 84.2219 87.3607 84.1909C87.3567 84.1899 87.353 84.1886 87.349 84.1876C87.1867 84.1232 87.0247 84.0588 86.8627 83.9944C86.2987 83.7225 85.6341 83.6804 85.1204 83.284C85.1237 83.2774 85.1271 83.271 85.1301 83.2647C85.1317 83.2613 85.1334 83.2583 85.1351 83.2553C85.1364 83.2527 85.1381 83.25 85.1394 83.2473C85.1408 83.245 85.1421 83.2426 85.1434 83.24C85.2833 82.9877 85.4346 82.965 85.5802 82.965C85.5959 82.965 85.6113 82.9654 85.6271 82.9657C85.6344 82.9657 85.6421 82.966 85.6498 82.966C85.6558 82.966 85.6622 82.966 85.6686 82.966C85.6699 82.966 85.6709 82.966 85.6723 82.966C85.6736 82.966 85.6746 82.966 85.6759 82.966C85.7074 82.966 85.7385 82.9647 85.769 82.9604C85.7726 82.9597 85.7763 82.959 85.78 82.9583C85.7813 82.9583 85.7823 82.958 85.7833 82.9577C86.0153 82.9133 86.2563 82.7745 86.2569 82.5219C86.2569 82.5119 86.2566 82.5012 86.2556 82.4906C86.2412 82.291 86.0163 82.1345 85.8731 81.9734C85.8259 81.9207 85.7402 81.9137 85.6719 81.886L85.6813 81.8786C85.7398 81.6988 85.7991 81.5183 85.858 81.3381L85.8623 81.3304C86.4286 81.5233 86.9946 81.7161 87.5605 81.9086C88.434 81.5763 88.4306 81.576 88.5377 80.7662C88.5746 80.5059 88.6482 80.248 88.7051 79.9891C88.7285 79.9981 88.7486 80.0071 88.772 80.0158C88.9025 80.0658 89.0331 80.1045 89.1603 80.1052C89.1636 80.1052 89.1636 80.1052 89.1636 80.1052H89.167C89.341 80.1038 89.5083 80.0321 89.6723 79.8216C89.6723 79.8192 89.6756 79.8166 89.6756 79.8142C89.679 79.8116 89.6823 79.8092 89.6823 79.8065C89.6823 79.8062 89.6823 79.8062 89.6823 79.8059C89.689 79.8006 89.6924 79.7956 89.6957 79.7902C90.1542 79.9437 90.6127 80.0972 91.0813 80.2537C90.8202 80.9043 90.1475 80.9614 90.0338 81.6093C90.0271 81.6073 90.017 81.6054 90.0103 81.6034C90.0036 81.6014 89.9969 81.5993 89.9903 81.5973C89.8731 81.5643 89.7526 81.5393 89.6388 81.5389C89.6355 81.5389 89.6355 81.5389 89.6321 81.5389C89.4213 81.5403 89.2238 81.6284 89.0599 81.9086C89.0565 81.9136 89.0532 81.919 89.0498 81.924C89.0498 81.9257 89.0498 81.9273 89.0465 81.929C89.0431 81.94 89.0364 81.9517 89.0297 81.9634C88.7954 82.6074 88.5645 83.2513 88.3336 83.8956C88.3302 83.8983 88.3269 83.901 88.3269 83.9036C88.3202 83.9106 88.3135 83.9176 88.3102 83.9243C88.3102 83.9246 88.3102 83.9246 88.3102 83.9246C88.116 84.1549 87.9086 84.2396 87.6877 84.241H87.6843Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M88.0256 79.207C87.8817 79.1657 87.7378 79.1243 87.5939 79.0829C87.6608 78.8637 87.7211 78.6458 87.7211 78.4416C87.7211 78.2531 87.6675 78.0762 87.5149 77.9221C88.0423 77.3759 88.4306 76.7272 88.6715 75.9741C88.695 75.9855 88.7184 75.9965 88.7385 76.0072C88.7452 76.0098 88.7518 76.0122 88.7552 76.0149C88.7585 76.0152 88.7586 76.0159 88.7586 76.0165C89.0129 76.1323 89.2706 76.2064 89.5317 76.207C89.5317 76.207 89.5317 76.207 89.535 76.207C89.8195 76.2067 90.1107 76.1203 90.4152 75.9087C90.6127 75.7709 90.8536 75.7342 91.0779 75.6512C91.0143 75.865 90.9641 76.0759 90.9641 76.2744C90.9641 76.4826 91.021 76.6772 91.1749 76.8477C91.0043 77.3582 90.8302 77.8687 90.6595 78.3789C90.6595 78.3819 90.6562 78.3849 90.6562 78.3879C90.6562 78.3892 90.6562 78.3905 90.6528 78.3915C90.6528 78.3949 90.6528 78.3979 90.6495 78.4012C90.6495 78.4039 90.6495 78.4069 90.6461 78.4099C90.4654 78.8426 90.2378 79.189 89.8362 79.19C89.8329 79.19 89.8329 79.19 89.8329 79.19C89.7793 79.19 89.7224 79.1837 89.6622 79.171C89.6588 79.17 89.6555 79.169 89.6522 79.1683C89.3074 79.0896 88.9761 78.9408 88.6247 78.9197C88.618 78.9194 88.6146 78.9194 88.6113 78.9194C88.6079 78.9194 88.608 78.9194 88.608 78.9194C88.6046 78.9194 88.6013 78.9194 88.5979 78.9194C88.4205 78.9267 88.2164 79.1093 88.0256 79.207Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M92.6372 83.6621C92.5134 83.6024 92.3896 83.5577 92.2557 83.5283L92.249 83.4776C92.4231 83.0549 92.6071 82.5864 93.0188 82.4606C94.1132 82.1259 95.1038 81.6805 95.5255 80.2471C95.5255 80.2457 95.5255 80.2444 95.5255 80.2431C95.5255 80.2424 95.5255 80.2421 95.5289 80.2414C95.5489 80.1803 95.6393 80.1506 95.7464 80.1503H95.7497C95.7531 80.1503 95.7531 80.1503 95.7564 80.1503C95.8903 80.1516 96.0476 80.199 96.1246 80.2874C96.1246 80.2898 96.1279 80.2924 96.1313 80.2948C96.1346 80.3004 96.138 80.3065 96.1413 80.3121C96.1413 80.3131 96.1413 80.3138 96.1447 80.3148C96.1949 80.3989 96.2417 80.5544 96.2451 80.6588C96.2451 80.6952 96.2384 80.7255 96.225 80.7446C95.6125 81.5951 94.8562 82.3168 94.6319 83.219C94.6286 83.2207 94.6252 83.2227 94.6252 83.2244C94.4077 83.3578 94.2069 83.3959 94.0128 83.3962C94.0128 83.3962 94.0128 83.3962 94.0094 83.3962C93.899 83.3959 93.7952 83.3839 93.6915 83.3705C93.6781 83.3688 93.6647 83.3672 93.6513 83.3655C93.5375 83.3501 93.4237 83.3348 93.3133 83.3348C93.1024 83.3348 92.9016 83.3922 92.7042 83.6178C92.6975 83.6218 92.6942 83.6257 92.6908 83.6298L92.6372 83.6621Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M91.0811 78.5088C90.9405 78.4681 90.8 78.4247 90.6594 78.3786C90.8301 77.8685 91.0042 77.358 91.1748 76.8475C91.1849 76.8478 91.1916 76.8481 91.2016 76.8481C91.2485 76.8491 91.2953 76.8501 91.3355 76.8508C91.3556 76.8511 91.3723 76.8515 91.389 76.8518C91.4225 76.8521 91.4526 76.8525 91.4827 76.8525C91.4827 76.8525 91.4827 76.8525 91.4861 76.8525C91.9714 76.8521 92.0483 76.7824 92.1454 76.2959C92.1454 76.2799 92.1487 76.2632 92.1521 76.2462C92.1554 76.2435 92.1554 76.2405 92.1554 76.2375C92.1554 76.2329 92.1554 76.2285 92.1588 76.2238C92.1588 76.2195 92.1588 76.2152 92.1621 76.2108C92.1621 76.2038 92.1621 76.1975 92.1655 76.1908C92.1655 76.1891 92.1655 76.1875 92.1655 76.1861C92.2592 75.761 92.4299 75.6536 92.6541 75.6526C92.6541 75.6526 92.6541 75.6526 92.6575 75.6526C92.7378 75.6526 92.8248 75.6666 92.9152 75.684C92.9219 75.685 92.9252 75.6863 92.9319 75.6873C92.9319 75.6876 92.9352 75.6877 92.9352 75.688C92.9386 75.6883 92.9386 75.689 92.9419 75.6893C92.9419 75.6893 92.9453 75.6896 92.9453 75.69C92.9486 75.6903 92.952 75.691 92.9553 75.6916L92.9854 75.755C93.0156 76.3113 93.049 76.8665 93.0724 77.4244C93.0724 77.4351 93.0724 77.4457 93.0724 77.4564C93.0724 77.714 92.9386 77.8732 92.7077 77.9319C92.7077 77.9309 92.7043 77.9299 92.701 77.9289C92.537 77.8642 92.3797 77.8324 92.2291 77.8321H92.2257C92.2224 77.8321 92.219 77.8321 92.2157 77.8324C91.804 77.8358 91.4325 78.068 91.0945 78.4934C91.0912 78.4984 91.0845 78.5038 91.0811 78.5088Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M87.5602 81.9087C86.9943 81.7162 86.4283 81.5233 85.8621 81.3304C85.9183 81.1723 85.9735 81.0138 86.0274 80.8546C86.0287 80.8553 86.0301 80.8557 86.0311 80.856C86.0311 80.8557 86.0311 80.855 86.0314 80.8546C86.3637 80.9417 86.6981 81.0295 87.6104 81.2684C87.1154 80.816 86.9424 80.4653 86.9421 80.1706C86.9417 79.7359 87.3162 79.4225 87.587 79.0839L87.5937 79.0825C87.7376 79.1239 87.8815 79.1653 88.0254 79.2067C88.1559 79.2591 88.2798 79.3195 88.4036 79.3872C88.1225 80.2277 87.8414 81.0682 87.5602 81.9087Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M91.0009 84.6392C90.8737 84.6392 90.616 84.6178 90.4587 84.6128C90.4587 84.5951 90.4587 84.5774 90.4587 84.5601C90.4587 84.2594 90.4119 83.9618 90.4119 83.6612C90.4119 83.4176 90.442 83.1724 90.5491 82.9221C90.6696 82.7066 90.7666 82.468 90.9139 82.2815C90.9909 82.185 91.1013 82.1437 91.1984 82.143H91.2017C91.2017 82.143 91.2017 82.143 91.2051 82.143C91.3389 82.1444 91.4494 82.2231 91.4126 82.3409C91.4126 82.3422 91.4092 82.3436 91.4092 82.3446C91.3456 82.5284 91.3189 82.6782 91.3189 82.8013C91.3189 83.2308 91.6636 83.3339 92.0485 83.4196C92.1187 83.4346 92.1823 83.458 92.2493 83.4777L92.256 83.5284C91.8744 83.9021 91.2385 83.8858 91.0746 84.6292C91.0746 84.6362 91.0444 84.6392 91.0009 84.6392Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M93.8155 75.9302C93.8122 75.9302 93.8088 75.9302 93.8088 75.9302C93.6415 75.9288 93.4173 75.8721 93.0859 75.7817C93.0658 75.776 93.0424 75.7704 93.0223 75.7644C93.0156 75.763 93.0089 75.7617 93.0056 75.76C92.9989 75.7584 92.9922 75.7563 92.9855 75.7547L92.9554 75.6913C92.9554 75.6612 92.9554 75.6312 92.9554 75.6012C92.9554 75.3339 92.9219 75.0683 92.9253 74.8007C92.9253 74.5505 92.952 74.2989 93.0625 74.0436C93.7318 74.1344 94.1904 74.5795 94.5819 75.1407C94.5786 75.1441 94.5786 75.1474 94.5752 75.1508C94.5752 75.1534 94.5719 75.1564 94.5719 75.1594C94.5686 75.1618 94.5685 75.1641 94.5685 75.1664C94.5652 75.1721 94.5619 75.1774 94.5585 75.1831C94.5552 75.1898 94.5485 75.1964 94.5451 75.2031C94.5451 75.2055 94.5451 75.2078 94.5418 75.2101C94.2473 75.736 94.1234 75.9298 93.8155 75.9302Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M95.124 86.4673C95.124 86.4673 95.1207 86.4673 95.1173 86.4673C95.114 86.467 95.114 86.4669 95.1106 86.4669C94.9935 86.4586 94.8128 86.3175 94.8094 86.208C94.8027 86.0575 94.8027 85.9064 94.8027 85.7546C94.8027 85.3001 94.8195 84.8427 94.8262 84.3866C95.2479 84.514 95.6695 84.6418 96.0912 84.7693C95.8971 85.2684 95.7198 85.7763 95.4955 86.2607C95.452 86.3568 95.2981 86.4423 95.1742 86.4626C95.1575 86.4656 95.1408 86.4673 95.124 86.4673Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M89.8695 84.9861C89.662 84.7205 89.4512 84.4549 89.2437 84.1889L89.1299 84.1693C89.2972 83.6694 89.4679 83.1699 89.6353 82.6701L89.7591 82.6047C90.0235 82.7105 90.2879 82.8163 90.5489 82.922C90.4418 83.1723 90.4117 83.4175 90.4117 83.6611C90.4117 83.9617 90.4586 84.2593 90.4586 84.56C90.4586 84.5773 90.4586 84.595 90.4586 84.6127C90.2109 84.6144 90.0168 84.7362 89.8695 84.9861Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M94.3609 79.2849H94.3576C94.3107 79.2842 94.2672 79.2589 94.2237 79.2098C94.2237 79.2088 94.2237 79.2078 94.2237 79.2068C94.1166 79.0837 94.0764 78.9599 94.0764 78.8338C94.0764 78.6493 94.1634 78.4598 94.2605 78.2586C94.3341 78.1101 94.3207 77.9169 94.3609 77.7467C94.3642 77.7367 94.3676 77.727 94.371 77.7177C94.371 77.711 94.3709 77.7047 94.3743 77.6983C94.3743 77.6973 94.3743 77.6963 94.3743 77.6953C94.5115 77.1251 94.5416 77.0887 95.2077 77.0887C95.2077 77.0887 95.2076 77.0887 95.211 77.0887C95.2277 77.0887 95.2478 77.0887 95.2679 77.0887C95.298 77.0887 95.3248 77.0887 95.3549 77.089C95.3013 77.2666 95.2478 77.4437 95.1943 77.6212C95.1039 77.8762 95.0135 78.1314 94.9232 78.3857C94.9198 78.3897 94.9198 78.3937 94.9165 78.398C94.6989 78.992 94.5215 79.2759 94.3676 79.2846C94.3642 79.2849 94.3642 79.2849 94.3609 79.2849Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M87.5605 81.9087C87.8417 81.0682 88.1228 80.2277 88.4039 79.3872C88.5612 79.4383 88.7185 79.4896 88.8758 79.5404C88.8122 79.6882 88.7553 79.8377 88.7051 79.9891C88.6482 80.2481 88.5746 80.506 88.5378 80.7662C88.4307 81.5761 88.4341 81.5764 87.5605 81.9087Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M91.9378 78.7161C91.9345 78.7161 91.9345 78.7161 91.9345 78.7161C91.7805 78.7151 91.5797 78.662 91.2886 78.5732C91.2517 78.5622 91.2149 78.5506 91.1781 78.5385C91.1714 78.5365 91.1648 78.5346 91.1581 78.5325C91.1514 78.5312 91.148 78.5299 91.1447 78.5285C91.1413 78.5279 91.138 78.5269 91.138 78.5262C91.1279 78.5232 91.1179 78.5198 91.1079 78.5168C91.1012 78.5155 91.0978 78.5142 91.0945 78.5125C91.0878 78.5115 91.0844 78.5102 91.0811 78.5089C91.0844 78.5039 91.0911 78.4985 91.0945 78.4935C91.4325 78.0681 91.804 77.8362 92.2156 77.8325C92.219 77.8322 92.2223 77.8322 92.2257 77.8322H92.229C92.3796 77.8325 92.5369 77.8642 92.7009 77.929C92.7043 77.93 92.7076 77.931 92.7076 77.932C92.7043 77.9416 92.6976 77.9513 92.6909 77.961C92.6909 77.9633 92.6875 77.9657 92.6875 77.968C92.6842 77.973 92.6808 77.9776 92.6775 77.9827C92.3662 78.5132 92.2391 78.7157 91.9378 78.7161Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M89.6353 82.6702C89.4345 82.4346 89.2303 82.199 89.0295 81.9635C89.0362 81.9518 89.0429 81.9401 89.0463 81.9291C89.0496 81.9274 89.0496 81.9257 89.0496 81.9241C89.053 81.9191 89.0563 81.9137 89.0597 81.9087C89.2237 81.6285 89.4211 81.5404 89.632 81.539C89.6353 81.539 89.6353 81.539 89.6387 81.539C89.7525 81.5394 89.8729 81.5644 89.9901 81.5974C89.9968 81.5994 90.0034 81.6014 90.0101 81.6034C90.0168 81.6055 90.0269 81.6074 90.0336 81.6094C89.9399 81.9414 89.8495 82.2731 89.7591 82.6048L89.6353 82.6702Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M89.1633 80.1055C89.1633 80.1055 89.1634 80.1055 89.16 80.1055C89.0328 80.1048 88.9023 80.0661 88.7718 80.0161C88.7483 80.0074 88.7283 79.9984 88.7048 79.9894C88.755 79.8379 88.812 79.6884 88.8755 79.5406C89.1466 79.6243 89.4211 79.7074 89.6955 79.7905C89.6922 79.7958 89.6888 79.8008 89.6821 79.8062C89.6821 79.8065 89.6821 79.8065 89.6821 79.8068C89.6821 79.8095 89.6787 79.8119 89.6754 79.8145C89.6754 79.8169 89.6721 79.8195 89.6721 79.8219C89.5081 80.0321 89.3407 80.1041 89.1667 80.1055H89.1633Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M15.6101 46.1179C15.6376 46.0695 15.6586 45.9968 15.6951 45.9781C15.7527 45.9491 15.8196 45.9528 15.8835 45.9444C15.8835 45.9444 15.8835 45.9444 15.8839 45.9444C15.8123 45.9898 15.7406 46.0348 15.6693 46.0802C15.6496 46.0929 15.6299 46.1052 15.6101 46.1179ZM15.8839 45.9444C15.8856 45.9431 15.8876 45.9421 15.8896 45.9408L15.8902 45.9434C15.8882 45.9438 15.8859 45.9441 15.8839 45.9444Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M15.8902 45.9434L15.8895 45.9407H15.8892C15.8915 45.9404 15.8938 45.94 15.8962 45.9397C15.8942 45.941 15.8922 45.942 15.8902 45.9434ZM15.8962 45.9397C15.9872 45.8826 16.0782 45.8256 16.1689 45.7685C16.1412 45.8159 16.1204 45.8876 16.0836 45.9057C16.0264 45.9347 15.9598 45.9313 15.8962 45.9397Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M64.001 57.8525C63.9437 57.5963 63.8611 57.3637 63.8433 57.1161C63.8182 56.7671 63.7446 56.604 63.604 56.6016C63.603 56.6016 63.602 56.6016 63.601 56.6016C63.595 56.6016 63.5893 56.602 63.5833 56.6023C63.4933 56.6103 63.3774 56.678 63.2315 56.7998C63.2285 56.8025 63.2255 56.8052 63.2225 56.8078C63.2215 56.8085 63.2205 56.8092 63.2195 56.8102C63.2171 56.8122 63.2148 56.8142 63.2125 56.8162C63.2125 56.8162 63.2124 56.8162 63.2121 56.8162C63.2104 56.8179 63.2088 56.8195 63.2068 56.8209C63.2018 56.8255 63.1964 56.8299 63.191 56.8345C63.1857 56.8392 63.1803 56.8439 63.175 56.8485C63.1733 56.8502 63.1713 56.8519 63.1696 56.8535C63.1689 56.8542 63.1683 56.8546 63.1676 56.8552C63.1656 56.8569 63.1636 56.8586 63.1616 56.8599C63.1244 56.8889 63.0716 56.9009 63.012 56.9009C63.0113 56.9009 63.011 56.9009 63.0103 56.9009C63.002 56.9009 62.9929 56.9009 62.9842 56.9003C62.8631 56.8939 62.7195 56.8449 62.6131 56.7898C62.6107 56.7885 62.608 56.7872 62.6057 56.7858C62.5993 56.7825 62.5933 56.7792 62.5873 56.7758C62.5853 56.7748 62.5833 56.7735 62.5813 56.7725C62.2707 56.5953 61.9959 56.3464 61.7061 56.1275C61.9273 55.8175 62.2228 55.7708 62.5213 55.6987C62.9039 55.6066 63.2342 55.3704 63.4949 55C64.0053 54.8856 64.266 54.4538 64.4708 53.9487C64.4056 53.8215 64.3701 53.625 64.273 53.584C63.8018 53.3864 63.3172 53.2216 62.8312 53.0634C62.4735 52.9467 62.1589 52.7832 62.0344 52.3431C64.9993 53.3404 67.9639 54.337 70.9285 55.334C71.0386 55.5092 71.1493 55.6841 71.2598 55.8589C71.1015 56.2816 70.9221 56.6857 70.5231 56.8839C70.5205 56.8852 70.5181 56.8862 70.5158 56.8876C70.4358 56.926 70.3622 56.942 70.2926 56.9423C70.2919 56.9423 70.2912 56.9423 70.2909 56.9423C70.2892 56.9423 70.2879 56.9423 70.2865 56.9423C70.1212 56.941 69.98 56.8492 69.8394 56.7504C69.8377 56.7491 69.8357 56.7478 69.8337 56.7464C69.8324 56.7454 69.831 56.7444 69.8297 56.7434C69.828 56.7424 69.8267 56.7414 69.825 56.7401C69.8227 56.7384 69.82 56.7368 69.8173 56.7348C69.816 56.7338 69.8143 56.7324 69.8126 56.7314C69.8093 56.7291 69.8059 56.7268 69.8026 56.7244C69.7986 56.7214 69.7942 56.7184 69.7902 56.7154C69.7885 56.7144 69.7869 56.7131 69.7852 56.7121C69.7849 56.7117 69.7845 56.7114 69.7842 56.7111C69.7775 56.7064 69.7708 56.7017 69.7641 56.6971C69.7634 56.6967 69.7628 56.6961 69.7621 56.6957C69.6229 56.598 69.4803 56.5082 69.312 56.5062C69.31 56.5062 69.308 56.5062 69.3063 56.5062C69.3056 56.5062 69.3053 56.5062 69.3046 56.5062C69.2433 56.5062 69.1784 56.5182 69.1091 56.5459C69.1081 56.5462 69.1071 56.5466 69.1061 56.5469C69.1055 56.5472 69.1048 56.5476 69.1041 56.5476C69.1008 56.5492 69.0974 56.5506 69.0941 56.5519C69.0904 56.5536 69.0871 56.5549 69.0834 56.5563C69.0506 56.5689 69.0191 56.5749 68.99 56.5749C68.9897 56.5749 68.9893 56.5749 68.989 56.5749C68.9873 56.5749 68.986 56.5749 68.9846 56.5749C68.8163 56.5719 68.7052 56.3788 68.6074 56.2046C68.6064 56.2029 68.6054 56.2009 68.6044 56.1992C68.6041 56.1986 68.6038 56.1976 68.6035 56.1969C68.6011 56.1932 68.5988 56.1892 68.5968 56.1852C68.4425 55.9113 68.2648 55.657 68.0977 55.3944C68.0931 55.3938 68.0887 55.3934 68.0843 55.3928C68.0803 55.3924 68.0767 55.3918 68.0726 55.3914C68.066 55.3904 68.0592 55.3898 68.0525 55.3891C68.0479 55.3884 68.0432 55.3878 68.0385 55.3874C67.8765 55.3681 67.7507 55.3544 67.6483 55.3541C67.6466 55.3541 67.6449 55.3541 67.6429 55.3541C67.6423 55.3541 67.6416 55.3541 67.6409 55.3541C67.3066 55.3547 67.2252 55.5019 66.9421 56.0798C66.9384 56.0871 66.9351 56.0945 66.931 56.1021C66.9294 56.1058 66.9277 56.1098 66.9257 56.1135C66.923 56.1191 66.9203 56.1248 66.9173 56.1305C66.9136 56.1295 66.91 56.1285 66.9063 56.1272C66.7386 56.0794 66.5803 56.0551 66.4307 56.0548C66.43 56.0548 66.4294 56.0548 66.4284 56.0548C66.426 56.0548 66.424 56.0548 66.4217 56.0548C65.8531 56.0574 65.419 56.4141 65.1415 57.1812C65.1415 57.1822 65.1412 57.1829 65.1408 57.1835C65.1345 57.2016 65.1282 57.2196 65.1218 57.2379C64.7908 57.4194 64.4595 57.601 64.001 57.8525Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M60.2973 57.3296C60.296 57.3296 60.2943 57.3296 60.2926 57.3296C60.0978 57.3279 59.9295 57.2178 59.8244 56.9929C59.8217 56.9873 59.8194 56.9816 59.8167 56.9759C59.8157 56.9732 59.8144 56.9706 59.8133 56.9679C59.6229 56.5258 59.326 56.2932 59.0667 55.9682C58.7601 55.5835 58.6587 54.9739 58.4683 54.4621C58.6128 54.0293 58.7896 53.6342 59.2461 53.5692C59.5637 53.758 59.8816 53.9469 60.2009 54.1367C60.2043 54.1341 60.2076 54.1317 60.2113 54.1291C60.235 54.1114 60.2588 54.0944 60.2825 54.0774C60.2829 54.077 60.2832 54.0767 60.2836 54.0767C60.5747 53.8701 60.8696 53.716 61.1457 53.7147C61.1467 53.7147 61.148 53.7147 61.1491 53.7147C61.1501 53.7147 61.1511 53.7147 61.1517 53.7147C61.376 53.7157 61.5871 53.8178 61.7732 54.0753C61.7786 54.083 61.7839 54.0904 61.7893 54.0984C61.7913 54.1011 61.7933 54.104 61.7953 54.1071C61.7993 54.1124 61.803 54.1177 61.807 54.1231C61.9978 54.3843 62.2187 54.4561 62.4519 54.4571C62.4539 54.4571 62.4556 54.4571 62.4576 54.4571C62.4586 54.4571 62.4596 54.4571 62.4606 54.4571C62.5871 54.4567 62.7177 54.436 62.8485 54.4144C62.8569 54.4127 62.8653 54.4114 62.8736 54.41C62.8783 54.4094 62.8827 54.4083 62.8873 54.4077C63.0005 54.3887 63.1139 54.3703 63.226 54.3643C63.3154 54.5762 63.4051 54.7877 63.4951 54.9996V54.9999C63.2344 55.3703 62.9041 55.6065 62.5216 55.6986C62.223 55.7707 61.9275 55.8174 61.7063 56.1274C61.6427 56.2932 61.5828 56.46 61.5259 56.6282C61.5225 56.6282 61.5192 56.6282 61.5162 56.6279C61.5128 56.6279 61.5098 56.6279 61.5068 56.6279C61.5065 56.6279 61.5065 56.6279 61.5061 56.6279C61.5045 56.6279 61.5025 56.6279 61.5005 56.6279C61.2712 56.6299 61.0868 56.747 60.9476 56.9766C60.9442 56.9819 60.9412 56.9876 60.9379 56.9929C60.9355 56.9969 60.9332 57.0013 60.9305 57.0056C60.9288 57.0073 60.9275 57.0089 60.9258 57.0106C60.9238 57.0123 60.9221 57.0139 60.9205 57.0156C60.9175 57.0186 60.9144 57.0216 60.9114 57.0246C60.7066 57.2242 60.4921 57.3279 60.302 57.3296C60.3003 57.3296 60.299 57.3296 60.2973 57.3296Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M57.0293 54.542C57.0279 54.5383 57.0266 54.5347 57.0253 54.5307C56.885 54.1506 56.8228 53.9848 56.6876 53.9834C56.6872 53.9834 56.6866 53.9834 56.6862 53.9834C56.6802 53.9834 56.6742 53.9838 56.6682 53.9844C56.5882 53.9921 56.4831 54.0515 56.3261 54.1536C56.3167 54.1596 56.307 54.1659 56.2973 54.1723C56.2933 54.175 56.2893 54.1776 56.2853 54.1803C56.2833 54.1816 56.2813 54.1829 56.2793 54.1843C56.2779 54.1849 56.2769 54.1856 56.2759 54.1863C56.2679 54.1916 56.2595 54.197 56.2512 54.2027C56.2505 54.203 56.2495 54.2037 56.2485 54.2043C56.2368 54.212 56.2247 54.22 56.2123 54.2283C56.2096 54.2303 56.2066 54.2323 56.2036 54.2343C56.1963 54.239 56.1889 54.244 56.1815 54.2487C56.1799 54.25 56.1782 54.251 56.1765 54.2523C56.1735 54.2544 56.1701 54.2564 56.1671 54.2584C55.8589 53.7762 55.5506 53.2941 55.2427 52.8123C54.8147 52.6601 54.3866 52.508 53.9583 52.3558C54.0175 52.1963 54.0777 52.0372 54.138 51.878C54.2601 51.8503 54.3786 51.838 54.4937 51.838C54.4941 51.838 54.4944 51.838 54.4947 51.838C54.4961 51.838 54.4978 51.838 54.4991 51.838C54.9954 51.8393 55.4342 52.0642 55.8883 52.2327C56.049 52.2921 56.2113 52.3445 56.3787 52.3775C56.3787 52.3775 56.3786 52.3775 56.379 52.3775C56.3917 52.3802 56.4044 52.3825 56.4172 52.3848C56.4198 52.3852 56.4225 52.3858 56.4252 52.3862C56.4312 52.3872 56.4372 52.3885 56.4432 52.3895C56.4566 52.3922 56.4703 52.3948 56.4837 52.3975C56.4898 52.3988 56.4955 52.3999 56.5011 52.4012C56.5631 52.4142 56.6243 52.4296 56.6849 52.4466C56.6929 52.4486 56.7013 52.4509 56.7093 52.4532C56.724 52.4576 56.7384 52.4619 56.7532 52.4663C56.7585 52.4676 56.7642 52.4693 56.7695 52.4709C56.8017 52.4806 56.8335 52.4906 56.8656 52.5013C57.3757 52.6671 57.8649 52.911 58.4275 52.9124C58.4292 52.9124 58.4305 52.9124 58.4319 52.9124C58.4322 52.9124 58.4326 52.9124 58.4326 52.9124C58.527 52.9124 58.6233 52.9053 58.7224 52.89C58.7408 52.8873 58.7585 52.886 58.7759 52.886H58.7763C58.7779 52.886 58.7796 52.886 58.781 52.886C59.0494 52.8897 59.2117 53.217 59.2458 53.5693C58.7893 53.6344 58.6126 54.0295 58.468 54.4622C58.4654 54.4612 58.463 54.4599 58.4607 54.4586C58.458 54.4576 58.4557 54.4562 58.453 54.4552C58.4497 54.4536 58.4463 54.4519 58.4429 54.4502C58.4426 54.4502 58.4423 54.4502 58.442 54.4499C58.3131 54.3908 58.1822 54.3688 58.0497 54.3688C58.049 54.3688 58.0484 54.3688 58.0474 54.3688C58.045 54.3688 58.0423 54.3688 58.0397 54.3688C57.8472 54.3698 57.6521 54.4165 57.457 54.4619C57.3275 54.4923 57.1979 54.522 57.0691 54.5377C57.0624 54.5383 57.0557 54.5393 57.049 54.54C57.0427 54.5406 57.036 54.5413 57.0293 54.542Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M63.4949 54.9998C63.4049 54.7879 63.3152 54.5763 63.2258 54.3645C63.4096 54.4792 63.4999 54.6564 63.5003 54.8943C63.5003 54.928 63.4986 54.9634 63.4949 54.9998Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M87.0444 68.019C86.6301 67.4488 86.119 67.0487 85.4487 66.9306C84.7127 66.6937 83.9771 66.4568 83.373 66.2623C82.6892 66.5282 82.6196 67.3951 82.0162 67.4618C82.039 67.3777 82.0631 67.2943 82.0842 67.2099C82.0848 67.2079 82.0852 67.2056 82.0858 67.2036C82.0875 67.1972 82.0888 67.1909 82.0905 67.1842C82.0918 67.1785 82.0932 67.1725 82.0945 67.1669C82.1688 66.8405 82.135 66.6183 81.8435 66.6177C81.8432 66.6177 81.8428 66.6177 81.8422 66.6177C81.8418 66.6177 81.8415 66.6177 81.8412 66.6177C81.804 66.618 81.7628 66.6213 81.717 66.629C81.6855 66.634 81.6541 66.636 81.6223 66.6363C81.6216 66.6363 81.621 66.6363 81.6203 66.6363C81.6186 66.6363 81.6169 66.6363 81.6153 66.6363C81.5614 66.636 81.5078 66.6296 81.454 66.623C81.4181 66.6183 81.382 66.6133 81.3462 66.609C81.3281 66.6069 81.3104 66.6053 81.2923 66.604C81.2906 66.604 81.2889 66.6036 81.2873 66.6036C81.3736 66.3981 81.4322 66.1975 81.4319 66.0084C81.4319 65.8278 81.3776 65.6573 81.2424 65.5022C81.4399 64.7394 81.8375 64.1248 82.38 63.6173C82.8941 63.6884 82.9808 64.0214 82.9808 64.4124C82.9808 64.6133 82.9577 64.8292 82.9577 65.0331C82.9577 65.0838 82.959 65.1342 82.9623 65.1829C83.1568 65.248 83.3706 65.2833 83.5507 65.3867C83.5561 65.3897 83.5611 65.3927 83.5664 65.3954C83.5664 65.3954 83.5664 65.3958 83.5668 65.3958C83.5718 65.3984 83.5768 65.4011 83.5815 65.4037C83.6782 65.4551 83.7606 65.4782 83.8315 65.4785C83.8322 65.4785 83.8325 65.4785 83.8332 65.4785C83.8342 65.4785 83.8352 65.4785 83.8362 65.4785C84.0925 65.4762 84.199 65.1759 84.3017 64.8552C84.3027 64.8516 84.3041 64.8482 84.3051 64.8445C84.3057 64.8429 84.3064 64.8412 84.3068 64.8395L84.4483 64.7815C85.1157 65.0241 85.7833 65.2663 86.4507 65.5089C86.5357 65.7331 86.621 65.9576 86.706 66.1819C86.6093 66.1815 86.5156 66.1502 86.4212 66.1158C86.3034 66.0724 86.1846 66.0237 86.0578 66.0224C86.0558 66.0224 86.0541 66.0224 86.0521 66.0224C86.0501 66.0224 86.0484 66.0224 86.0464 66.0224C85.9242 66.024 85.7947 66.0701 85.6512 66.2069C85.6488 66.2089 85.6468 66.2109 85.6445 66.2129C86.2489 66.8045 87.0949 66.7414 87.7409 67.1412C87.8312 67.1965 87.8714 67.2746 87.8714 67.3587C87.8714 67.4738 87.7911 67.6006 87.6472 67.696C87.617 67.6914 87.5903 67.6894 87.5602 67.6894H87.5568C87.3513 67.69 87.184 67.8108 87.0444 68.019Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M90.0101 71.8728C89.8696 71.8458 89.7324 71.8061 89.5985 71.7544C89.5449 71.6049 89.5315 71.3906 89.4311 71.3162C88.7149 70.7817 87.8983 70.5038 87.0088 70.4751C87.0074 70.4747 87.0061 70.4747 87.0047 70.4747C87.0007 70.4747 86.997 70.4751 86.993 70.4754C86.8946 70.4834 86.7835 70.5915 86.6757 70.6753C86.6741 70.6763 86.6727 70.6776 86.6711 70.6786C86.651 70.6943 86.6312 70.7087 86.6115 70.7213C86.0127 70.5028 85.4137 70.2839 84.7734 70.05C84.7778 70.0443 84.7825 70.0386 84.7868 70.033C84.7872 70.0326 84.7875 70.0323 84.7878 70.032C85.0204 69.7434 85.248 69.718 85.4669 69.718C85.4903 69.718 85.5141 69.7183 85.5375 69.7186C85.5606 69.719 85.584 69.7193 85.6071 69.7193C85.7152 69.7193 85.8213 69.7127 85.9244 69.6693C86.4167 69.4624 86.7085 69.0884 86.8695 68.5395C86.9284 68.3683 86.987 68.1968 87.0456 68.0257C87.1938 68.064 87.3424 68.1024 87.4907 68.1404C87.494 68.1451 87.4971 68.1498 87.5004 68.1544C87.5088 68.1664 87.5171 68.1788 87.5255 68.1905C87.5265 68.1921 87.5278 68.1938 87.5288 68.1955C87.9653 68.8118 88.4874 69.1855 89.1668 69.1865C89.1668 69.1865 89.1668 69.1865 89.1701 69.1865C89.3508 69.1861 89.5382 69.1601 89.7391 69.1061C89.7457 69.1041 89.7524 69.1024 89.7591 69.1004C89.7625 69.1001 89.7625 69.0994 89.7658 69.0987C89.7759 69.096 89.7859 69.0934 89.796 69.0904C89.8361 69.0787 89.8763 69.0737 89.9164 69.0737C89.9198 69.0737 89.9198 69.0737 89.9198 69.0737C89.9231 69.0737 89.9231 69.0737 89.9265 69.0737C90.0135 69.075 90.1038 69.0974 90.1942 69.1221C90.2779 69.1451 90.3615 69.1705 90.4452 69.1838C90.395 69.2519 90.3448 69.3169 90.3013 69.3883C90.1105 69.6976 90.0135 69.8651 90.0101 69.9786C90.0101 70.1014 90.1239 70.1611 90.3615 70.2692C90.5557 70.3566 90.7565 70.418 90.9573 70.4914C90.8937 70.6596 90.8301 70.8281 90.7699 70.9969C90.7598 70.9963 90.7498 70.9962 90.7431 70.9962C90.7397 70.9962 90.7397 70.9962 90.7364 70.9962C90.5055 70.9983 90.3247 71.1281 90.1808 71.36C90.1273 71.5315 90.067 71.7026 90.0101 71.8728Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M90.3012 63.9678C90.0803 63.9384 89.8595 63.8964 89.6352 63.882C89.0027 63.8416 88.658 63.516 88.658 62.916C88.658 62.7592 88.6814 62.5841 88.7316 62.3902C88.7718 62.226 88.8253 62.0872 88.8253 61.9571C88.8253 61.868 88.7985 61.7833 88.7316 61.6968C88.7316 61.6938 88.7316 61.6912 88.7349 61.6885C88.7483 61.6591 88.765 61.6305 88.7784 61.6028C89.0729 61.0452 89.17 60.898 89.4244 60.8974H89.4277C89.4913 60.8977 89.5683 60.9067 89.6553 60.9207C89.662 60.9217 89.6687 60.9227 89.6754 60.9237C89.6754 60.9241 89.6787 60.9244 89.6787 60.9247C89.6955 60.9271 89.7122 60.9301 89.7289 60.9328C89.9431 60.9685 90.1439 61.0575 90.3514 61.1223C90.2945 61.2854 90.241 61.4496 90.1908 61.6154C90.0837 61.8373 90 62.0535 90 62.249C89.9967 62.4389 90.077 62.6094 90.2845 62.7479C90.415 62.9174 90.4686 63.0989 90.4686 63.2884C90.4652 63.5066 90.3983 63.7349 90.3012 63.9678Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M91.3521 70.5693C91.2182 70.5453 91.0877 70.5193 90.9572 70.4916C90.7564 70.4182 90.5555 70.3568 90.3614 70.2694C90.1238 70.1613 90.01 70.1015 90.01 69.9787C90.0134 69.8653 90.1104 69.6978 90.3012 69.3885C90.3447 69.3171 90.3949 69.252 90.4451 69.184C90.5823 69.2203 90.7262 69.241 90.8568 69.2957C91.3086 69.4836 91.4659 69.5593 91.4659 69.8563C91.4659 70.0144 91.4224 70.2353 91.3521 70.5693Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M90.2846 62.7478C90.0771 62.6093 89.9968 62.4388 90.0001 62.249C90.0001 62.0534 90.0838 61.8372 90.1909 61.6154C90.3247 61.7829 90.3682 61.972 90.3682 62.1722C90.3682 62.3571 90.3314 62.5516 90.2846 62.7478Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M87.4908 68.1409C87.3425 68.1028 87.1939 68.0645 87.0457 68.0261C87.046 68.0248 87.0463 68.0238 87.047 68.0224C87.046 68.0214 87.0453 68.0201 87.0447 68.0191C87.1842 67.8109 87.3516 67.6901 87.5571 67.6894H87.5604C87.5905 67.6894 87.6173 67.6914 87.6474 67.6961C87.5872 67.8422 87.537 67.9904 87.4908 68.1409Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M91.4862 76.8523C91.4829 76.8523 91.4829 76.8523 91.4829 76.8523C91.4527 76.8523 91.4226 76.852 91.3892 76.8516C91.3724 76.8513 91.3557 76.851 91.3356 76.8506C91.2955 76.85 91.2486 76.849 91.2018 76.848C91.1917 76.848 91.185 76.8476 91.175 76.8473C91.021 76.6768 90.9641 76.4823 90.9641 76.2741C90.9641 76.0755 91.0143 75.8647 91.0779 75.6508C91.2687 75.1423 91.6 74.8563 92.0485 74.6902C92.1154 74.6661 92.1456 74.6007 92.1456 74.525C92.1456 74.4389 92.1054 74.3395 92.0384 74.2717C92.0953 74.1022 92.1556 73.9344 92.2225 73.7689C92.5003 73.8607 92.7814 73.9521 93.0625 74.0438C92.9521 74.2991 92.9253 74.5507 92.9253 74.8009C92.922 75.0685 92.9554 75.3341 92.9554 75.6014C92.9554 75.6314 92.9554 75.6614 92.9554 75.6915C92.9521 75.6908 92.9488 75.6901 92.9454 75.6898C92.9454 75.6895 92.9421 75.6892 92.9421 75.6892C92.9387 75.6888 92.9387 75.6882 92.9354 75.6878C92.9354 75.6875 92.932 75.6875 92.932 75.6871C92.9253 75.6861 92.922 75.6848 92.9153 75.6838C92.8249 75.6665 92.7379 75.6524 92.6576 75.6524C92.6543 75.6524 92.6542 75.6524 92.6542 75.6524C92.43 75.6534 92.2593 75.7609 92.1656 76.186C92.1656 76.1873 92.1656 76.189 92.1656 76.1906C92.1623 76.1973 92.1623 76.2037 92.1623 76.2107C92.1589 76.215 92.1589 76.2193 92.1589 76.2237C92.1556 76.2283 92.1556 76.2327 92.1556 76.2374C92.1556 76.2404 92.1556 76.2434 92.1522 76.246C92.1489 76.263 92.1456 76.2797 92.1456 76.2958C92.0485 76.7822 91.9715 76.852 91.4862 76.8523Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M92.0551 86.9561C91.5162 86.8967 91.707 86.2467 91.4024 86.0615C91.4024 86.0525 91.3991 86.0435 91.3991 86.0348C91.3288 85.5243 91.0544 85.3077 90.6494 85.3057H90.6461C90.6025 85.3061 90.5557 85.3084 90.5089 85.3134C90.5055 85.3137 90.5022 85.3141 90.4988 85.3147C90.4955 85.3151 90.4921 85.3154 90.4854 85.3158C90.4854 85.3161 90.4821 85.3164 90.4787 85.3167C90.385 85.3284 90.288 85.3464 90.2009 85.3468C90.1976 85.3468 90.1976 85.3468 90.1976 85.3468C90.0403 85.3464 89.9131 85.2854 89.873 85.0175C89.873 85.0071 89.873 84.9968 89.8696 84.9861C90.0169 84.7362 90.211 84.6144 90.4586 84.6127C90.6159 84.6177 90.8737 84.6391 91.0008 84.6391C91.0443 84.6391 91.0745 84.6361 91.0745 84.6291C91.2385 83.8857 91.8743 83.902 92.2559 83.5283C92.3897 83.5577 92.5136 83.6024 92.6374 83.6621C92.4834 84.2203 92.3596 84.7652 92.3596 85.3501C92.3596 85.3838 92.3596 85.4179 92.3596 85.4519C92.3596 85.4669 92.3596 85.4819 92.3596 85.4973C92.3596 85.9664 92.1622 86.4686 92.0551 86.9561Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M65.5447 88.2295C65.5437 88.2295 65.5424 88.2295 65.5414 88.2295C65.289 88.2282 65.0484 88.1017 64.8051 88.0063C64.7987 88.0036 64.7924 88.0013 64.786 87.9986C64.7827 87.9976 64.779 87.9963 64.7756 87.9949C64.774 87.9942 64.7726 87.9936 64.771 87.9929C64.7643 87.9906 64.7576 87.9879 64.7509 87.9856C64.7298 87.9776 64.7087 87.9702 64.688 87.9632C64.6846 87.9622 64.6812 87.9609 64.6779 87.9599C64.8529 87.6085 64.9771 87.2679 64.9778 86.9456C64.9784 86.6609 64.8831 86.3907 64.6411 86.1397C64.5507 86.046 64.5437 85.8458 64.4985 85.695C64.5655 85.4771 64.6327 85.2589 64.7 85.0406C65.2261 84.5412 65.7378 84.0156 66.284 83.5498C66.7362 83.1638 66.9848 82.6403 67.2439 82.1094C67.278 82.1051 67.3108 82.1031 67.342 82.1031C67.3426 82.1031 67.3433 82.1031 67.344 82.1031C67.8075 82.1044 67.9651 82.5682 68.2124 82.8965C68.2211 82.9082 68.2302 82.9199 68.2392 82.9312C68.2402 82.9326 68.2412 82.9336 68.2422 82.9349C68.2429 82.9359 68.2436 82.9369 68.2442 82.9375C68.2463 82.9402 68.2486 82.9426 68.2506 82.9452C68.2523 82.9476 68.2543 82.9499 68.2563 82.9522C68.2673 83.3076 68.2777 83.6633 68.2884 84.0186C68.2861 84.0176 68.2837 84.0163 68.281 84.0153C68.2787 84.0143 68.2764 84.0133 68.274 84.0123C68.2181 83.9883 68.1606 83.9763 68.1013 83.9759C68.1003 83.9759 68.0993 83.9759 68.0983 83.9759C68.0976 83.9759 68.0973 83.9759 68.0966 83.9759C68.0565 83.9759 68.0157 83.9816 67.9738 83.9926C67.9631 83.9953 67.9521 83.9986 67.941 84.0023C67.4765 84.3286 67.2867 84.4984 67.2874 84.7627C67.2881 84.9212 67.357 85.1137 67.4765 85.3947C67.6214 85.4414 67.766 85.4878 67.9112 85.5341C68.0227 85.6065 68.1442 85.6496 68.2764 85.6639C68.1522 85.9609 67.9517 86.1181 67.681 86.1464C67.2442 86.2605 66.782 86.2542 66.4012 86.6579C66.6214 87.035 67.012 87.0493 67.3453 87.1828C67.2891 87.3466 67.2345 87.5111 67.182 87.6766C66.8503 87.5735 66.5237 87.449 66.184 87.3773C66.1833 87.3773 66.1826 87.3773 66.182 87.377C66.1381 87.3673 66.0839 87.3413 66.0287 87.3196C65.9885 87.3036 65.9473 87.2902 65.9092 87.2872C65.9038 87.2865 65.8988 87.2865 65.8935 87.2865C65.8921 87.2865 65.8908 87.2865 65.8898 87.2865C65.8145 87.2882 65.7536 87.3383 65.7362 87.5044C65.7352 87.5151 65.7341 87.5265 65.7335 87.5381C65.7335 87.5405 65.7332 87.5428 65.7332 87.5448C65.7328 87.685 66.0012 87.8121 66.1441 87.9452C66.1411 87.9479 66.1385 87.9505 66.1358 87.9532C66.1314 87.9575 66.1274 87.9615 66.1231 87.9659C66.1207 87.9679 66.1187 87.9699 66.1164 87.9719C65.9169 88.1624 65.7288 88.2288 65.5471 88.2295C65.5461 88.2295 65.5454 88.2295 65.5447 88.2295Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M60.7751 87.8433C60.7744 87.8433 60.7741 87.8433 60.7737 87.8433C60.7038 87.8433 60.6335 87.8379 60.5625 87.8289C60.5565 87.8282 60.5505 87.8272 60.5445 87.8266L60.4775 87.6304C60.6824 87.2757 60.8514 86.91 60.851 86.5183C60.851 86.4162 60.8394 86.3121 60.8139 86.206C60.7841 86.0815 60.7711 85.9597 60.7711 85.8396C60.7714 85.3798 60.9632 84.9467 61.1275 84.5079L61.1328 84.5069C61.6968 84.5266 62.2674 84.513 62.8237 84.5757C62.828 84.576 62.8323 84.5764 62.8367 84.577C62.837 84.577 62.837 84.577 62.8374 84.577C62.8685 84.58 62.8989 84.5817 62.9287 84.5817H62.9291C62.9301 84.5817 62.9311 84.5817 62.9321 84.5817C63.3765 84.5804 63.6192 84.2387 63.8488 83.835C63.8524 83.8283 63.8561 83.8219 63.8598 83.8153C63.8605 83.8146 63.8608 83.8136 63.8615 83.8129C63.8638 83.8083 63.8665 83.8036 63.8692 83.7992C63.916 83.9557 63.998 84.1065 64.0047 84.2707C64.0258 84.7949 64.2912 84.9978 64.6998 85.0408C64.6326 85.259 64.5653 85.4772 64.4984 85.6951C64.0636 85.7325 63.6292 85.7649 63.1945 85.8079C62.9371 85.8333 62.8605 85.9073 62.8598 86.0024C62.8591 86.1269 62.9883 86.2877 63.0137 86.4242C63.0204 86.4605 63.0238 86.4946 63.0238 86.5273C63.0251 86.8576 62.7102 87.0144 62.5887 87.2787C62.5823 87.2774 62.5756 87.276 62.5689 87.275C62.5659 87.2744 62.5629 87.2737 62.5599 87.273C62.5566 87.2727 62.5529 87.272 62.5495 87.2714C62.5402 87.2697 62.5308 87.268 62.5214 87.2664C62.4123 87.247 62.3035 87.2317 62.1954 87.2313C62.1944 87.2313 62.1934 87.2313 62.1924 87.2313C62.1908 87.2313 62.1891 87.2313 62.1874 87.2313C61.9846 87.2323 61.7855 87.2874 61.596 87.4702C61.5934 87.4729 61.591 87.4752 61.5883 87.4779C61.5803 87.4859 61.5723 87.4939 61.5643 87.5022C61.5623 87.5046 61.5602 87.5066 61.5582 87.5089C61.3169 87.7592 61.0552 87.8419 60.7814 87.8433C60.7794 87.8433 60.7771 87.8433 60.7751 87.8433Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M64.6777 87.9602C64.6439 87.9539 64.6101 87.9462 64.5763 87.9382C64.5683 87.9362 64.5602 87.9342 64.5522 87.9322C64.5468 87.9305 64.5411 87.9292 64.5354 87.9278C64.4936 87.9168 64.4514 87.9051 64.4096 87.8928C64.2158 87.8371 64.0217 87.7757 63.832 87.7743C63.8296 87.7743 63.8276 87.7743 63.8253 87.7743C63.8249 87.7743 63.8246 87.7743 63.8243 87.7743C63.7684 87.7743 63.7131 87.7797 63.6579 87.792C63.6539 87.793 63.6502 87.7937 63.6462 87.7947C63.5769 87.8091 63.5123 87.8161 63.4518 87.8161C63.4514 87.8161 63.4511 87.8161 63.4507 87.8161C63.4491 87.8161 63.4477 87.8161 63.4461 87.8161C63.0799 87.814 62.8607 87.5645 62.6221 87.3136C62.6204 87.3119 62.6191 87.3106 62.6177 87.3089C62.6121 87.3029 62.6064 87.2972 62.6007 87.2912C62.5977 87.2882 62.5946 87.2849 62.5916 87.2819C62.5906 87.2809 62.5896 87.2799 62.5886 87.2789C62.7101 87.0146 63.025 86.8578 63.0237 86.5275C63.0237 86.4948 63.0204 86.4607 63.0137 86.4243C62.9882 86.2879 62.8591 86.1271 62.8597 86.0026C62.8604 85.9075 62.937 85.8334 63.1944 85.8081C63.6292 85.765 64.0636 85.7327 64.4983 85.6953C64.5435 85.8461 64.5505 86.0463 64.6409 86.1401C64.8829 86.391 64.9782 86.6613 64.9775 86.9459C64.9769 87.2682 64.8527 87.6089 64.6777 87.9602Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M58.9017 88.3181C58.9 88.3181 58.8984 88.3181 58.8967 88.3181C58.7973 88.3174 58.6962 88.2998 58.5942 88.2707C58.5895 88.2694 58.5851 88.2681 58.5808 88.2671C58.5757 88.2654 58.5704 88.2637 58.5654 88.2624L58.377 88.1499C58.3816 88.1463 58.3863 88.1423 58.391 88.1386C58.7133 87.8763 59.0624 87.8153 59.4201 87.8146C59.4228 87.8146 59.4258 87.8146 59.4285 87.8146C59.4372 87.8146 59.4459 87.8146 59.4546 87.8146L59.5112 88.0198C59.5025 88.0298 59.4938 88.0392 59.4851 88.0485C59.4831 88.0508 59.4811 88.0532 59.4787 88.0555C59.297 88.2467 59.1039 88.3174 58.9044 88.3181C58.9034 88.3181 58.9027 88.3181 58.9017 88.3181Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M59.9312 88.0735C59.9302 88.0735 59.9288 88.0735 59.9278 88.0735C59.7896 88.0732 59.6504 88.0478 59.5111 88.0198L59.4546 87.8146C59.6651 87.6454 59.88 87.5943 60.0962 87.5937C60.0978 87.5937 60.0995 87.5937 60.1012 87.5937C60.1022 87.5937 60.1028 87.5937 60.1035 87.5937C60.2116 87.5937 60.3201 87.6064 60.4285 87.6227C60.4308 87.623 60.4332 87.6234 60.4359 87.6237C60.4389 87.6244 60.4419 87.6247 60.4449 87.625C60.4499 87.626 60.4549 87.6267 60.46 87.6277C60.4657 87.6284 60.4717 87.6294 60.4774 87.6304L60.5443 87.8266C60.3458 88.0151 60.142 88.0725 59.9359 88.0735C59.9342 88.0735 59.9329 88.0735 59.9312 88.0735Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M78.4738 68.1812C78.4735 68.1812 78.4735 68.1812 78.4731 68.1812C78.4504 68.1812 78.4276 68.1808 78.4049 68.1801C77.936 68.1635 78.1297 67.2602 77.6187 67.1815C77.5474 67.1705 77.4822 67.1308 77.4139 67.1044C77.1097 66.9429 76.7937 66.8748 76.4688 66.8745C76.4681 66.8745 76.4671 66.8745 76.4664 66.8745C76.4651 66.8745 76.464 66.8745 76.4627 66.8745C76.1615 66.8752 75.8529 66.9332 75.5393 67.029C75.6555 66.6873 75.7716 66.3457 75.8877 66.004C76.4781 65.7854 77.0735 65.5909 77.6562 65.34C78.0471 65.1715 78.2271 64.8155 78.2275 64.368C78.2275 64.3383 78.2268 64.308 78.2251 64.2773C77.4912 63.995 76.8423 63.6927 76.3904 62.8468C76.0949 62.293 75.3482 62.1051 75.3492 61.2973C75.3492 61.1819 75.3646 61.0541 75.3988 60.9103C75.3994 60.9066 75.4001 60.9029 75.3998 60.8989C75.3984 60.8188 75.212 60.6694 75.0929 60.62C75.0768 60.6133 75.0608 60.6066 75.0447 60.6003C74.7174 60.4688 74.3773 60.3694 74.043 60.2566C74.043 60.2566 74.043 60.2566 74.0427 60.2566C73.9664 60.0334 73.9346 59.7611 73.8037 59.598C73.6571 59.4148 73.6042 59.2199 73.6042 59.0144C73.6039 58.8245 73.6491 58.626 73.707 58.4198C73.8472 58.4735 73.9871 58.5272 74.127 58.581C74.1293 58.8212 74.1739 58.9447 74.2626 58.9467C74.2632 58.9467 74.2639 58.9467 74.2649 58.9467C74.2679 58.9467 74.2712 58.9463 74.2746 58.946C74.3308 58.9406 74.4031 58.8906 74.4921 58.7948C74.4935 58.7935 74.4945 58.7925 74.4955 58.7912C74.5015 58.7848 74.5075 58.7782 74.5132 58.7715C74.5152 58.7695 74.5169 58.7675 74.5186 58.7655C74.5189 58.7655 74.5189 58.7651 74.5193 58.7651C74.5239 58.7598 74.5286 58.7541 74.5336 58.7484C74.535 58.7468 74.5363 58.7451 74.5377 58.7435C74.5397 58.7411 74.5417 58.7388 74.5437 58.7365C75.2227 58.5619 75.2927 57.8689 75.5106 57.302C75.695 57.2083 75.8794 57.1145 76.0638 57.0207C76.4199 57.1088 76.778 57.1889 77.1307 57.2873C77.4403 57.3737 77.5996 57.6293 77.6542 57.9874C77.682 58.245 77.6943 58.3594 77.7606 58.3604C77.7609 58.3604 77.7609 58.3604 77.7613 58.3604C77.7646 58.3604 77.7683 58.3601 77.772 58.3594C77.787 58.3571 77.8048 58.3497 77.8255 58.3377C77.8255 58.3377 77.8255 58.3377 77.8259 58.3377C77.8496 58.3237 77.8777 58.304 77.9109 58.2786C77.9119 58.278 77.9129 58.277 77.9139 58.2763C77.9169 58.274 77.9202 58.2717 77.9233 58.269C77.9239 58.2687 77.9246 58.268 77.9253 58.2673C77.9376 58.258 77.9507 58.2476 77.9641 58.2366C77.9761 58.2273 77.9882 58.2173 78.0009 58.2066C78.0026 58.2056 78.0042 58.2042 78.0059 58.2029C78.0093 58.1999 78.013 58.1969 78.0166 58.1939C78.0173 58.1936 78.0176 58.1932 78.018 58.1929C78.023 58.1889 78.0284 58.1846 78.0334 58.1802C78.034 58.1796 78.0347 58.1792 78.0354 58.1785C78.0367 58.1775 78.0384 58.1762 78.0397 58.1752C78.0451 58.1709 78.0504 58.1662 78.0558 58.1619L78.0625 58.1579C78.2529 58.0491 78.444 57.9403 78.6348 57.8319C78.7877 57.8412 78.93 57.8853 79.0608 57.9634C78.9497 58.2887 78.8386 58.6136 78.7275 58.9386C78.5307 59.0671 78.3342 59.1952 78.1374 59.3237C78.1371 59.3234 78.1364 59.3234 78.1358 59.323L78.1368 59.3244C78.1371 59.324 78.1374 59.324 78.1374 59.3237C78.276 59.3701 78.4126 59.4205 78.5481 59.4745C78.5665 59.9784 78.8791 60.1418 79.2262 60.265L79.1478 60.5202L79.0548 60.7708C78.9507 60.7688 78.8593 60.7671 78.7787 60.7671C78.7783 60.7671 78.778 60.7671 78.7777 60.7671C78.777 60.7671 78.7764 60.7671 78.7753 60.7671C78.2128 60.7674 78.1639 60.8509 77.8837 61.5165C77.8821 61.5202 77.8807 61.5239 77.8791 61.5279C77.8774 61.5312 77.8761 61.5346 77.8747 61.5382C77.8714 61.5459 77.868 61.5539 77.8647 61.5619C77.7984 61.7197 77.7546 61.8879 77.7004 62.0511C77.701 62.0531 77.702 62.0554 77.703 62.0574C77.7064 62.0651 77.7097 62.0731 77.7131 62.0808C77.7134 62.0811 77.7134 62.0811 77.7134 62.0814C77.7174 62.0908 77.7218 62.1004 77.7258 62.1098C77.7291 62.1171 77.7321 62.1248 77.7355 62.1321C77.7358 62.1331 77.7365 62.1341 77.7368 62.1351C77.9343 62.5876 78.031 62.7751 78.2412 62.7768C78.2419 62.7768 78.2429 62.7768 78.2435 62.7768C78.2509 62.7768 78.2583 62.7764 78.266 62.7761C78.3831 62.7694 78.535 62.71 78.7546 62.6106C78.7573 62.6093 78.76 62.6083 78.763 62.607C78.765 62.606 78.767 62.605 78.7686 62.6043C78.7717 62.603 78.7743 62.6016 78.7773 62.6003C78.7783 62.5996 78.7797 62.5993 78.7807 62.5986C78.7891 62.595 78.7974 62.5909 78.8061 62.5869C78.8081 62.5863 78.8098 62.5853 78.8118 62.5846C78.8168 62.5823 78.8215 62.5799 78.8266 62.5776C78.8302 62.5759 78.8339 62.5743 78.8376 62.5726C78.8382 62.5723 78.8389 62.5719 78.8396 62.5716C78.8533 62.5652 78.8674 62.5589 78.8814 62.5522C78.8861 62.5502 78.8908 62.5479 78.8958 62.5456C78.9035 62.5419 78.9116 62.5382 78.9199 62.5346C78.9223 62.5332 78.9246 62.5322 78.927 62.5312C78.935 62.5275 78.943 62.5239 78.9511 62.5199C78.9554 62.5179 78.9601 62.5155 78.9648 62.5135C79.3323 62.946 79.8564 63.2586 79.8574 63.959C79.8577 64.0811 79.842 64.2149 79.8068 64.363C79.7436 64.628 79.9025 64.7788 80.1094 64.7798C80.11 64.7798 80.111 64.7798 80.1117 64.7798C80.112 64.7798 80.1124 64.7798 80.1127 64.7798C80.1375 64.7798 80.1629 64.7778 80.189 64.7731C80.2309 64.7661 80.2707 64.7628 80.3082 64.7628C80.3085 64.7628 80.3088 64.7628 80.3092 64.7628C80.3095 64.7628 80.3102 64.7628 80.3108 64.7628C80.7212 64.7638 80.8915 65.1632 81.1475 65.4187H81.1479C81.1499 65.4211 81.1519 65.4231 81.1539 65.4251C81.1569 65.4278 81.1596 65.4304 81.1623 65.4331C81.1827 65.4528 81.2041 65.4718 81.2262 65.4895C81.2285 65.4915 81.2312 65.4935 81.2339 65.4955C81.2366 65.4978 81.2396 65.5002 81.2426 65.5022C81.3778 65.6573 81.432 65.8278 81.432 66.0083C81.4324 66.1975 81.3738 66.398 81.2874 66.6036C81.0923 66.7547 80.8972 66.9056 80.7017 67.0571C80.2703 67.1308 80.109 67.5185 79.9594 67.9196C79.9494 67.9216 79.939 67.9232 79.9286 67.9252C79.8942 67.9319 79.8597 67.9389 79.8252 67.9459C79.3744 68.0394 78.9183 68.1802 78.4795 68.1812C78.4775 68.1812 78.4755 68.1812 78.4738 68.1812ZM77.855 59.4989C77.9477 59.4408 78.0404 59.3828 78.1331 59.3247C78.1344 59.3247 78.1354 59.3244 78.1368 59.3244L78.1358 59.323C78.1351 59.3237 78.1341 59.3244 78.1331 59.3247C78.0682 59.334 77.9996 59.3304 77.941 59.3601C77.9039 59.3787 77.8831 59.4508 77.855 59.4989ZM76.208 58.8849C76.2137 58.8849 76.2198 58.8826 76.2261 58.8789C76.2274 58.8779 76.2288 58.8772 76.2301 58.8762C76.2562 58.8572 76.2853 58.8102 76.3141 58.7661C76.3175 58.7608 76.3208 58.7558 76.3242 58.7508C76.3252 58.7491 76.3265 58.7474 76.3275 58.7458C76.3332 58.7374 76.3389 58.7294 76.3442 58.7218C76.3462 58.7191 76.3483 58.7164 76.3506 58.7137C76.3513 58.7127 76.3519 58.7121 76.3526 58.7111C76.3395 58.6354 76.3462 58.5329 76.3061 58.4929C76.2994 58.4862 76.2873 58.4832 76.2726 58.4832C76.2723 58.4832 76.2716 58.4832 76.2713 58.4832C76.2602 58.4832 76.2478 58.4845 76.2351 58.4872C76.191 58.4965 76.1411 58.5199 76.1267 58.5466C76.0835 58.625 76.0624 58.6934 76.0621 58.7481C76.0618 58.8332 76.112 58.8839 76.2077 58.8849H76.208Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M81.7752 61.0618C81.7648 61.0594 81.7548 61.0575 81.7447 61.0551C81.7391 61.0541 81.7334 61.0528 81.7274 61.0518L81.727 61.0514C81.6166 61.0294 81.5041 61.0184 81.3896 61.0181C81.3876 61.0181 81.3856 61.0181 81.3836 61.0181C81.3799 61.0181 81.3763 61.0181 81.3729 61.0181C81.225 60.9714 81.0771 60.9246 80.9291 60.8779C80.9362 60.8262 80.9399 60.7765 80.9399 60.7288C80.9405 60.4986 80.8622 60.3124 80.6955 60.1752L80.6965 60.1739C80.7996 60.0364 80.9178 59.9093 81.0031 59.7595C81.0727 59.637 81.1062 59.5246 81.1062 59.4342C81.1065 59.3024 81.0359 59.2176 80.904 59.2176C80.9 59.2176 80.8957 59.2176 80.8916 59.2176C80.8893 59.2176 80.887 59.2176 80.885 59.2176C80.47 59.2176 80.0536 59.2273 79.6379 59.2333C79.6232 59.2336 79.6085 59.234 79.5934 59.234L79.5928 59.2303C79.6681 59.0718 79.7243 58.9063 79.7611 58.7348L79.7671 58.7311C80.2049 58.6701 80.3572 58.2984 80.4653 57.8779C80.7862 58.0801 81.051 58.3621 81.4693 58.3621C81.5316 58.3621 81.5968 58.3558 81.6661 58.3421C81.7039 58.3347 81.7421 58.3314 81.7802 58.3314C82.0851 58.3314 82.4 58.5473 82.7096 58.6477C82.6705 58.9233 82.5878 59.2099 82.5878 59.4762C82.5875 59.5089 82.5888 59.5413 82.5915 59.5733C82.5968 59.6347 82.5992 59.6951 82.5995 59.7548C82.5998 60.0968 82.5189 60.4125 82.3786 60.7324C82.1775 60.8422 81.976 60.952 81.7752 61.0618Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M74.2772 58.043C73.9513 57.6923 73.712 57.2151 73.214 57.1144C73.2126 57.1114 73.211 57.1084 73.2096 57.1054C73.2086 57.1034 73.2076 57.101 73.2066 57.0987C73.2036 57.092 73.2003 57.085 73.1969 57.078C73.1929 57.0687 73.1889 57.0593 73.1849 57.0497C73.1845 57.049 73.1839 57.048 73.1835 57.047C73.1829 57.045 73.1818 57.043 73.1812 57.041C73.1363 56.9359 73.0888 56.8057 73.045 56.708C73.044 56.7063 73.0433 56.7046 73.0426 56.7026C73.0386 56.694 73.0346 56.6856 73.0306 56.6776C73.0118 56.6379 72.9934 56.6059 72.9767 56.5862C72.9764 56.5855 72.9757 56.5849 72.9754 56.5845C72.9697 56.5778 72.9643 56.5732 72.959 56.5698C72.9536 56.5665 72.9486 56.5648 72.9439 56.5648H72.9436C72.9419 56.5648 72.9402 56.5648 72.9385 56.5655C72.8468 56.5912 72.7608 56.6029 72.6795 56.6029C72.6791 56.6029 72.6788 56.6029 72.6785 56.6029C72.6775 56.6029 72.6761 56.6029 72.6751 56.6029C72.2106 56.6012 71.903 56.2232 71.5382 55.9926C71.4887 55.9616 71.4382 55.9329 71.386 55.9085C71.3813 55.9062 71.3763 55.9038 71.3716 55.9018C71.3632 55.8978 71.3545 55.8942 71.3461 55.8905C71.3408 55.8885 71.3354 55.8862 71.3304 55.8842C71.3301 55.8842 71.3298 55.8838 71.3298 55.8838C71.3207 55.8802 71.3117 55.8768 71.303 55.8735C71.2886 55.8682 71.2742 55.8635 71.2598 55.8588C71.1493 55.684 71.0386 55.5091 70.9285 55.3339C72.2093 55.7483 73.4898 56.1631 74.7702 56.5775C74.6762 56.8982 74.5825 57.2185 74.4881 57.5391C74.4178 57.707 74.3475 57.8751 74.2772 58.043Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M74.5437 58.7366C74.4088 58.6742 74.2699 58.6225 74.127 58.5811C73.9871 58.5274 73.8472 58.4736 73.707 58.4199C73.2622 58.1533 73.1147 58.0649 73.115 57.7659C73.115 57.6171 73.1518 57.4163 73.2067 57.116L73.2141 57.1146C73.7121 57.2154 73.9513 57.6925 74.2773 58.0432C74.4139 58.0022 74.5511 57.9608 74.6876 57.9197C74.6214 57.793 74.5544 57.6662 74.4882 57.5394C74.5825 57.2187 74.6763 56.8984 74.7703 56.5778C75.0702 56.6759 75.3704 56.7736 75.6702 56.8714L75.5836 57.0839L75.5106 57.3021C75.2927 57.869 75.2228 58.5621 74.5437 58.7366Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M79.1666 59.0891C79.0314 59.0567 78.8945 59.0294 78.757 59.0067L78.7275 58.9386C78.8387 58.6136 78.9498 58.2887 79.0609 57.9634C79.43 58.0558 79.7195 58.2453 79.767 58.7311L79.761 58.7348C79.5629 58.8526 79.3651 58.9707 79.1666 59.0891Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M78.0625 58.1577C78.1994 57.9689 78.351 57.8241 78.5528 57.8241C78.5792 57.8241 78.6063 57.8264 78.6348 57.8317C78.444 57.9401 78.2529 58.0489 78.0625 58.1577Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M77.7614 58.3604C77.7611 58.3604 77.761 58.3604 77.7607 58.3604C77.6944 58.3594 77.6821 58.2449 77.6543 57.9873C77.7805 58.0644 77.9143 58.1224 78.0559 58.1618C78.0506 58.1662 78.0452 58.1708 78.0398 58.1752C78.0385 58.1762 78.0368 58.1775 78.0355 58.1785C78.0348 58.1792 78.0342 58.1795 78.0335 58.1802C78.0285 58.1845 78.0231 58.1889 78.0181 58.1929C78.0178 58.1932 78.0174 58.1935 78.0168 58.1939C78.0131 58.1969 78.0094 58.1999 78.006 58.2029C78.0044 58.2042 78.0027 58.2056 78.001 58.2066C77.9883 58.2172 77.9762 58.2272 77.9642 58.2366C77.9508 58.2476 77.9378 58.2579 77.9254 58.2673C77.9247 58.2679 77.924 58.2686 77.9234 58.269C77.9204 58.2716 77.917 58.2739 77.914 58.2763C77.913 58.277 77.912 58.2779 77.911 58.2786C77.8779 58.304 77.8497 58.3237 77.826 58.3377C77.8256 58.3377 77.8257 58.3377 77.8257 58.3377C77.8049 58.3497 77.7871 58.357 77.7721 58.3594C77.7684 58.36 77.7647 58.3604 77.7614 58.3604Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M75.5105 57.302L75.5834 57.0838L75.6701 56.8712C75.816 56.8819 75.9472 56.9316 76.0637 57.0207C75.8793 57.1145 75.6949 57.2082 75.5105 57.302Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M82.2042 62.1553C81.8431 61.8166 81.4059 61.6217 81.3728 61.0181C81.3761 61.0181 81.3798 61.0181 81.3835 61.0181C81.3855 61.0181 81.3875 61.0181 81.3895 61.0181C81.504 61.0185 81.6165 61.0295 81.7269 61.0515L81.7273 61.0518C81.7333 61.0528 81.739 61.0542 81.7446 61.0552C81.7547 61.0575 81.7647 61.0595 81.7751 61.0618C81.7784 61.0625 81.7818 61.0635 81.7851 61.0642C81.825 61.0725 81.8631 61.0765 81.9003 61.0769C81.9006 61.0769 81.9013 61.0769 81.9016 61.0769C81.904 61.0769 81.9059 61.0769 81.9083 61.0765C82.0997 61.0742 82.255 60.9604 82.3755 60.7378C82.3765 60.7362 82.3775 60.7342 82.3785 60.7325C82.5188 60.4125 82.5997 60.0969 82.5994 59.7549C82.5991 59.6951 82.5967 59.6348 82.5914 59.5734C82.5887 59.5413 82.5874 59.509 82.5877 59.4763C82.5877 59.21 82.6704 58.9234 82.7095 58.6478C83.4016 58.7816 84.1008 58.894 84.6992 59.3078C84.6061 59.6348 84.499 59.9587 84.4224 60.2887C84.3595 60.5573 84.3187 60.7359 84.3187 60.8733C84.3187 61.1446 84.479 61.2557 84.9485 61.5847C84.7524 61.7222 84.5563 61.8596 84.3598 61.9971C84.3558 61.9944 84.3515 61.9918 84.3474 61.9891C84.0995 61.8363 83.8464 61.7769 83.5911 61.7762C83.5901 61.7762 83.5891 61.7762 83.588 61.7762C83.5867 61.7762 83.5857 61.7762 83.5844 61.7762C83.1399 61.7772 82.6901 61.9567 82.253 62.1352C82.2447 62.1386 82.2366 62.1419 82.2286 62.1453C82.2262 62.1459 82.2243 62.1469 82.2222 62.1479C82.2162 62.1503 82.2102 62.1526 82.2042 62.1553Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M84.3068 64.8394C84.1796 64.6402 84.0146 64.463 83.9329 64.2371C83.7535 63.7416 83.4704 63.3946 83.0283 63.2247C83.0364 63.2057 83.0444 63.187 83.0521 63.1687C83.0538 63.165 83.0551 63.1613 83.0568 63.1577C83.3131 62.5524 83.3764 62.4373 83.7987 62.4373C83.7991 62.4373 83.7997 62.4373 83.8004 62.4373C83.8007 62.4373 83.8014 62.4373 83.8017 62.4373C83.8302 62.4373 83.86 62.4376 83.8915 62.4386C83.8961 62.4386 83.9008 62.439 83.9055 62.439C83.9617 62.441 84.0236 62.4436 84.0916 62.4473C84.0943 62.4473 84.0966 62.4476 84.0993 62.4476C84.1204 62.4486 84.1421 62.45 84.1646 62.451C84.5896 62.5948 85.0146 62.7386 85.4397 62.8824C85.3898 63.0696 85.3399 63.2568 85.2901 63.4443C85.0096 63.8897 84.7288 64.3355 84.4483 64.7813L84.3068 64.8394Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M85.4397 62.8826C85.0146 62.7388 84.5896 62.595 84.1646 62.4512C84.2328 62.3013 84.2981 62.1498 84.3596 61.997C84.5561 61.8596 84.7522 61.7221 84.9484 61.5846C85.1341 61.0664 85.3195 60.5486 85.5049 60.0307C85.5294 60.0344 85.5528 60.0361 85.5755 60.0364C85.5759 60.0364 85.5762 60.0364 85.5765 60.0364C85.5792 60.0364 85.5815 60.0361 85.5839 60.0361C85.773 60.0331 85.9163 59.9086 86.0374 59.7261C86.0374 59.7258 86.0374 59.7258 86.0374 59.7258C86.0414 59.7197 86.0454 59.7137 86.0491 59.7077C86.0535 59.7011 86.0575 59.6947 86.0615 59.6881C86.2881 59.942 86.2911 60.2533 86.1796 60.6183C86.0508 61.0394 85.952 61.4688 85.8406 61.8949C85.7071 62.2243 85.5732 62.5536 85.4397 62.8826Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M84.9485 61.5847C84.4789 61.2557 84.3186 61.1446 84.3186 60.8734C84.3186 60.7359 84.3594 60.5574 84.4223 60.2888C84.499 59.9588 84.6061 59.6348 84.6991 59.3078C85.0094 59.3836 85.3196 59.4586 85.6295 59.534C85.5817 59.6982 85.5402 59.8637 85.505 60.0309C85.3196 60.5487 85.1342 61.0665 84.9485 61.5847Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M85.2903 63.4443C85.3402 63.2568 85.39 63.0696 85.4399 62.8824C85.5734 62.5535 85.7073 62.2241 85.8408 61.8948C86.0885 62.8614 86.0885 62.8614 85.2903 63.4443Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M86.6611 62.9468C86.6323 62.7916 86.5516 62.6275 86.5848 62.4833C86.6704 62.1053 86.9044 61.8737 87.2387 61.8036C87.1089 62.132 86.9844 62.4626 86.8441 62.7859C86.814 62.8547 86.7237 62.8937 86.6611 62.9468ZM87.2387 61.8036C87.2401 61.8 87.2417 61.7966 87.2431 61.793L87.2471 61.8016C87.2444 61.8023 87.2417 61.803 87.2387 61.8036Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M85.5767 60.0366C85.5764 60.0366 85.5761 60.0366 85.5757 60.0366C85.553 60.0363 85.5296 60.0346 85.5051 60.031C85.5403 59.8638 85.5818 59.6983 85.6296 59.5341C85.7739 59.5855 85.9178 59.6369 86.0617 59.6883C86.0577 59.6949 86.0537 59.7013 86.0493 59.7079C86.0456 59.7139 86.0416 59.72 86.0376 59.726C86.0376 59.726 86.0376 59.726 86.0376 59.7263C85.9165 59.9088 85.7732 60.0333 85.5841 60.0363C85.5817 60.0363 85.5794 60.0366 85.5767 60.0366Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M95.2947 65.3347C95.3215 65.284 95.3449 65.2073 95.3817 65.1896C95.4386 65.1622 95.5055 65.1679 95.5691 65.1629C95.4754 65.2203 95.385 65.2773 95.2947 65.3347ZM95.5691 65.1629C95.5725 65.1602 95.5758 65.1572 95.5825 65.1545V65.1615C95.5791 65.1619 95.5725 65.1625 95.5691 65.1629Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M71.4458 86.2212C71.3039 86.1828 71.1576 86.1631 71.008 86.1621C70.7389 85.9896 70.3905 85.9052 70.3909 85.4354C70.3909 85.4241 70.3912 85.4127 70.3916 85.401C70.7701 85.0664 70.919 84.9119 70.9183 84.6997C70.9177 84.5809 70.8701 84.4434 70.7895 84.2459C70.7061 84.0413 70.5606 83.8775 70.4434 83.6953L70.4568 83.6543C70.4562 83.6543 70.4555 83.6543 70.4548 83.6543C70.5043 83.4745 70.5542 83.2949 70.6037 83.1151C70.6128 83.1171 70.6221 83.1191 70.6315 83.1214C70.6529 83.1268 70.6747 83.1328 70.6964 83.1391C70.7095 83.1428 70.7222 83.1468 70.7353 83.1505C70.7423 83.1525 70.7493 83.1545 70.7563 83.1565C70.8216 83.1755 70.8872 83.1922 70.9525 83.1932C70.9545 83.1932 70.9561 83.1932 70.9582 83.1932C70.9585 83.1932 70.9588 83.1932 70.9592 83.1932C70.9762 83.1932 70.9933 83.1918 71.0107 83.1892C71.0971 83.1768 71.1871 83.0434 71.2624 82.9503C71.263 82.9496 71.2631 82.9486 71.2634 82.9476C71.2637 82.9273 71.2022 82.8141 71.1526 82.7831C71.0351 82.7094 70.9043 82.66 70.7791 82.6006C70.8363 82.4311 70.8939 82.2616 70.9515 82.0921C71.0197 82.1068 71.0874 82.1278 71.1553 82.1508C71.3668 82.2236 71.5773 82.318 71.7929 82.319C71.7939 82.319 71.7949 82.319 71.7962 82.319C71.7969 82.319 71.7975 82.319 71.7985 82.319C71.9826 82.3183 72.1704 82.2489 72.3655 82.038C72.3661 82.0373 72.3668 82.0367 72.3672 82.036C72.3719 82.0314 72.3762 82.0263 72.3809 82.021C72.3845 82.017 72.3882 82.013 72.3919 82.0087C72.3946 82.0057 72.3969 82.003 72.3996 82C72.4026 82.001 72.4056 82.0023 72.4083 82.0033C72.4194 82.008 72.4304 82.0123 72.4415 82.0167C72.7299 82.1318 73.0178 82.2202 73.3119 82.2215C73.3146 82.2215 73.317 82.2215 73.3193 82.2215C73.3203 82.2215 73.321 82.2215 73.3217 82.2215C73.6112 82.2212 73.9063 82.1361 74.2142 81.9099C74.2179 81.9072 74.2216 81.9045 74.2253 81.9019C74.231 81.8975 74.2367 81.8935 74.242 81.8892C74.4171 81.7561 74.6574 81.7528 74.8675 81.6897C74.8947 82.053 75.069 82.2776 75.3428 82.4094C75.6175 82.5422 75.7835 82.7744 75.804 83.1391C75.8036 83.1388 75.8036 83.1388 75.8033 83.1388L75.804 83.1395V83.1391C75.9422 83.2052 76.0824 83.2299 76.2243 83.2299C76.225 83.2299 76.2253 83.2302 76.226 83.2302C76.2287 83.2302 76.2314 83.2299 76.234 83.2299C76.4519 83.2286 76.6724 83.1708 76.8933 83.1198C77.0018 83.0947 77.1106 83.0711 77.2187 83.0567C77.2264 83.0557 77.2337 83.0547 77.2411 83.0537C77.2451 83.0534 77.2488 83.053 77.2525 83.0524C77.1892 83.2839 77.1149 83.5175 77.1146 83.7364C77.1142 83.9152 77.1631 84.0841 77.3073 84.2345C77.2665 84.3987 77.215 84.5599 77.152 84.717C76.5972 84.5245 76.0596 84.2506 75.4833 84.1608C74.8247 84.058 74.8551 83.3777 74.584 82.9012C74.4468 82.8742 74.3096 82.8599 74.1727 82.8599C74.1721 82.8599 74.1714 82.8599 74.1711 82.8599C74.1694 82.8599 74.1677 82.8599 74.1661 82.8599C73.7457 82.8609 73.3283 82.9953 72.9227 83.3033C72.918 83.3069 72.913 83.3106 72.908 83.3146C72.7055 83.4411 72.503 83.5679 72.3006 83.6943C71.9863 83.7497 71.747 83.9583 71.6643 84.309C71.6366 84.4261 71.6145 84.5755 71.6145 84.7083C71.6148 84.8295 71.6332 84.9369 71.6827 84.9946C71.8273 85.1645 71.8842 85.3163 71.8842 85.4574C71.8839 85.736 71.66 85.9726 71.4458 86.2212ZM75.5218 83.314C75.6152 83.2559 75.7082 83.1979 75.8016 83.1398C75.8023 83.1398 75.803 83.1398 75.804 83.1395L75.8033 83.1388C75.8026 83.1391 75.8019 83.1395 75.8016 83.1398C75.736 83.1491 75.6671 83.1448 75.6078 83.1745C75.571 83.1932 75.5499 83.2656 75.5218 83.314Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M72.8093 84.9993L72.8126 84.9973C72.3638 84.732 72.2183 84.6463 72.2183 84.3373C72.2179 84.1891 72.2514 83.9899 72.3006 83.6947C72.5031 83.5682 72.7055 83.4414 72.908 83.3149C73.2434 83.6276 73.4077 84.045 73.4067 84.5642C73.4067 84.5852 73.4064 84.6062 73.4057 84.6279L73.4137 84.6229C73.411 84.6246 73.4084 84.6262 73.4057 84.6279C73.2079 84.751 73.0101 84.8741 72.8123 84.9973C72.8113 84.9979 72.8103 84.9986 72.8093 84.9993Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M100.67 78.2327C100.67 78.2327 100.67 78.2327 100.666 78.2327C100.536 78.2323 100.402 78.196 100.268 78.1543C100.268 78.1543 100.268 78.1542 100.268 78.1539C100.258 78.1512 100.251 78.1486 100.241 78.1459C100.235 78.1436 100.224 78.1412 100.218 78.1386C100.221 78.1352 100.224 78.1319 100.224 78.1286C100.395 77.8933 100.576 77.8159 100.76 77.8146H100.763C100.763 77.8146 100.763 77.8146 100.767 77.8146C100.901 77.8149 101.034 77.8549 101.172 77.9037C101.175 77.9047 101.178 77.9057 101.182 77.907C101.185 77.9084 101.188 77.91 101.195 77.9114C101.195 77.9124 101.198 77.9133 101.202 77.9143C101.205 77.915 101.205 77.916 101.208 77.9167C101.212 77.918 101.215 77.919 101.218 77.9203C101.212 77.927 101.208 77.9337 101.202 77.9404C101.198 77.9454 101.195 77.95 101.192 77.955C101.028 78.1646 100.85 78.232 100.673 78.2327H100.67Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M81.6299 85.6074C81.6292 85.6074 81.6282 85.6074 81.6275 85.6074C81.5462 85.6071 81.4632 85.5941 81.3782 85.5677C80.8812 85.4119 80.3749 85.2854 79.8725 85.1463L79.9207 85.0015C80.4257 84.5297 80.7969 84.0209 80.7975 83.3929C80.7975 83.1747 80.753 82.9421 80.654 82.6919C80.6352 82.6448 80.6282 82.5884 80.6282 82.5284C80.6278 82.4249 80.6486 82.3095 80.6667 82.2077C80.6777 82.1443 80.7731 82.0779 80.8394 82.0335C81.1878 81.798 81.316 81.5648 81.316 81.3322C81.316 81.0846 81.1707 80.8384 80.991 80.5915C80.825 80.6081 80.673 80.6285 80.5214 80.6388C79.5221 80.7069 79.5194 80.7049 79.1372 81.6802C79.0391 81.9301 78.9645 82.1897 78.8792 82.445C78.7577 82.4576 78.6352 82.485 78.5127 82.5157C78.5123 82.5157 78.5124 82.5157 78.5124 82.5157C78.5063 82.5174 78.5006 82.5187 78.4946 82.52C78.2771 82.5747 78.0589 82.6368 77.8433 82.6381C77.8407 82.6381 77.838 82.6381 77.8353 82.6381C77.8347 82.6381 77.834 82.6381 77.8333 82.6381C77.7108 82.6381 77.5893 82.6181 77.4692 82.5657C77.4652 82.5641 77.4611 82.5624 77.4571 82.5604C77.4534 82.4937 77.4518 82.4263 77.4514 82.3589C77.4508 81.6402 77.6539 80.8934 77.9692 80.3218C78.2112 79.8837 78.4053 79.4143 78.6208 78.9585C78.7999 78.4376 78.9792 77.9165 79.1583 77.3953C78.7439 77.2608 78.3293 77.1263 77.915 76.9915C77.9123 76.9832 77.91 76.9745 77.9076 76.9662C77.9066 76.9622 77.9053 76.9578 77.9042 76.9538C77.9036 76.9518 77.9029 76.9495 77.9023 76.9475C77.9019 76.9455 77.9016 76.9438 77.9009 76.9422C77.7915 76.5528 77.7316 76.3816 77.5927 76.3806C77.5923 76.3806 77.592 76.3806 77.5917 76.3806C77.5856 76.3806 77.5793 76.3809 77.5729 76.3816C77.4839 76.3906 77.3631 76.462 77.182 76.5851C77.1807 76.5861 77.1793 76.5871 77.1777 76.5881C77.1579 76.6018 77.1372 76.6158 77.1154 76.6308C77.105 76.6382 77.0943 76.6452 77.0836 76.6529C77.0786 76.6562 77.0739 76.6599 77.0689 76.6632C77.0642 76.6662 77.0595 76.6695 77.0548 76.6729L76.9742 76.7339C76.8678 76.6752 76.757 76.6255 76.6429 76.5861C76.7436 76.1674 76.844 75.749 76.9645 75.2491C76.5732 75.4263 76.2483 75.5735 75.923 75.7206C75.8527 75.2258 75.7827 74.731 75.7078 74.2004C76.1341 74.1567 76.5023 74.1387 76.8691 74.0756C77.1074 74.0346 77.2433 73.8998 77.2429 73.6512C77.2429 73.5615 77.2252 73.4567 77.1881 73.3359C77.1563 73.2331 77.1415 73.1437 77.1415 73.0656C77.1415 72.8047 77.3038 72.6662 77.5348 72.5438C77.6723 72.4704 77.8316 72.4667 77.9809 72.432C77.9869 72.6806 78.0348 72.8074 78.1248 72.8084C78.1251 72.8084 78.1255 72.8084 78.1258 72.8084C78.1315 72.8084 78.1368 72.8081 78.1429 72.8071C78.1994 72.7981 78.2707 72.745 78.3571 72.6476C78.3598 72.6446 78.3621 72.6415 78.3648 72.6385C78.3651 72.6385 78.3651 72.6385 78.3651 72.6382C78.3681 72.6349 78.3715 72.6312 78.3745 72.6275C78.3768 72.6249 78.3788 72.6225 78.3812 72.6199C78.3822 72.6182 78.3835 72.6169 78.3849 72.6155C78.3909 72.6082 78.3969 72.6009 78.4029 72.5932C78.4033 72.5928 78.4036 72.5925 78.4039 72.5922C78.4053 72.5902 78.4069 72.5885 78.4086 72.5865C78.4103 72.5842 78.4123 72.5815 78.4143 72.5792C78.6968 72.6723 78.9792 72.7654 79.262 72.8584C79.2617 72.8584 79.2617 72.8584 79.2617 72.8584C79.492 73.385 79.7219 73.9115 79.9575 74.4507C80.3521 74.1007 80.3809 73.6546 80.5301 73.2702C80.5931 73.1047 80.655 72.9388 80.7159 72.7727C80.8598 72.8277 81.0034 72.8824 81.1469 72.9372C81.1466 72.9382 81.146 72.9388 81.1456 72.9398C81.1496 72.9412 81.1536 72.9425 81.158 72.9438C81.3006 73.2228 81.4214 73.5234 81.5924 73.7753C81.5964 73.7813 81.6004 73.787 81.6045 73.7927C81.6061 73.7954 81.6081 73.7977 81.6098 73.8004C81.74 73.9812 81.8893 74.0673 82.0482 74.068C82.0489 74.068 82.0496 74.068 82.0502 74.068C82.0516 74.068 82.0526 74.068 82.0539 74.068C82.1972 74.0666 82.3484 73.9966 82.5007 73.8644C82.5141 73.8527 82.5275 73.8407 82.5406 73.8284C82.5439 73.8254 82.5469 73.8227 82.5499 73.8197C82.5523 73.8174 82.5549 73.8147 82.5576 73.8124C82.8003 73.5782 82.976 73.2915 82.977 72.9575C82.977 72.9322 82.9763 72.9068 82.9743 72.8811C82.9445 72.4917 82.6487 72.3686 82.3732 72.2518C82.3739 72.2308 82.3742 72.2095 82.3742 72.1884C82.3742 71.9902 82.3444 71.7977 82.3444 71.5998C82.3444 71.4036 82.3735 71.2021 82.4903 70.9836C82.5821 70.8114 82.5884 70.5849 82.5884 70.3546C82.5884 70.3213 82.5881 70.2872 82.5881 70.2535C82.5881 70.1581 82.5891 70.0633 82.5968 69.9726C82.826 69.2152 83.3133 68.8391 83.9469 68.7003C84.3756 68.6062 84.5744 68.2445 84.7427 67.8338C84.7467 67.8378 84.7507 67.8421 84.7544 67.8464C84.7655 67.8581 84.7765 67.8698 84.7879 67.8815C85.0332 68.1411 85.2775 68.361 85.652 68.3623C85.653 68.3623 85.654 68.3623 85.655 68.3623C85.6554 68.3623 85.6557 68.3623 85.6561 68.3623C85.712 68.3623 85.7709 68.3573 85.8331 68.3469C85.8351 68.3466 85.8371 68.3463 85.8391 68.346C85.8428 68.3453 85.8465 68.3446 85.8502 68.3439C85.8923 68.3373 85.9349 68.3343 85.9777 68.3343C85.978 68.3343 85.9783 68.3343 85.9787 68.3343C85.981 68.3343 85.9834 68.3343 85.9857 68.3343C86.2193 68.3359 86.4556 68.426 86.6912 68.4941C86.733 68.5064 86.7749 68.5178 86.8167 68.5278C86.8244 68.5298 86.8324 68.5315 86.8405 68.5335C86.8425 68.5338 86.8442 68.5345 86.8462 68.5348C86.8502 68.5358 86.8546 68.5368 86.8589 68.5375C86.8626 68.5385 86.8659 68.5391 86.8696 68.5398C86.7086 69.0887 86.4168 69.4627 85.9245 69.6696C85.821 69.713 85.715 69.7193 85.6062 69.7193C85.5834 69.7193 85.5603 69.7193 85.5376 69.719C85.5138 69.7186 85.4901 69.7183 85.466 69.7183C85.2478 69.7183 85.0205 69.744 84.7879 70.0323C84.7876 70.0326 84.7872 70.0329 84.7869 70.0333C84.7826 70.0389 84.7779 70.0446 84.7735 70.0503C85.4137 70.2842 86.0128 70.5031 86.6116 70.7217C86.5547 70.9062 86.4974 71.0907 86.4402 71.2748C86.3528 71.4897 86.2943 71.6989 86.2943 71.8968C86.294 72.0917 86.3505 72.2755 86.4921 72.443C86.4442 72.6082 86.3937 72.7727 86.3402 72.9365C86.0818 73.2278 85.8237 73.5188 85.565 73.81C85.552 73.8087 85.5389 73.8074 85.5262 73.806C85.5225 73.8054 85.5188 73.805 85.5155 73.8047C85.4961 73.8027 85.4777 73.8007 85.4593 73.799C85.3234 73.7847 85.2136 73.775 85.1226 73.7747C85.1206 73.7747 85.1189 73.7747 85.1172 73.7747C85.1166 73.7747 85.1156 73.7747 85.1149 73.7747C84.7668 73.7754 84.6912 73.9185 84.4278 74.4994C84.4251 74.5057 84.4221 74.5121 84.4191 74.5184C84.4181 74.5211 84.4168 74.5234 84.4158 74.5261C84.4134 74.5311 84.4111 74.5361 84.4087 74.5414C84.4077 74.5438 84.4067 74.5461 84.4054 74.5488C84.404 74.5518 84.4027 74.5548 84.4013 74.5578C84.2768 74.6592 84.1597 74.811 84.0269 74.8531C83.6557 74.9702 83.393 75.131 83.3923 75.5988C83.3923 75.6385 83.3943 75.6802 83.398 75.7246C83.3997 75.7426 83.4003 75.7613 83.4003 75.78C83.4007 75.9999 83.3009 76.2448 83.2524 76.477C83.1225 76.5341 82.9626 76.5541 82.8689 76.6565C82.7778 76.7563 82.7346 76.8758 82.735 76.9765C82.7357 77.089 82.7899 77.1777 82.892 77.189C82.8963 77.1894 82.9006 77.1897 82.9053 77.1904C82.9187 77.1917 82.9318 77.1927 82.9452 77.1934C82.9482 77.1934 82.9512 77.1937 82.9542 77.1937C82.9746 77.1947 82.995 77.1954 83.0158 77.1954C83.0161 77.1954 83.0165 77.1954 83.0171 77.1954C83.0195 77.1954 83.0222 77.1954 83.0245 77.1954C83.1664 77.1947 83.3123 77.1731 83.4562 77.1614C83.4639 77.1607 83.472 77.16 83.48 77.1594C83.3853 77.3923 83.3133 77.6222 83.3136 77.8414C83.3136 78.0266 83.3655 78.2044 83.4987 78.3702C83.3106 79.0312 83.1222 79.6919 82.9341 80.3529C82.7755 80.3645 82.6135 80.5107 82.6135 80.6185C82.6135 80.6382 82.6192 80.6569 82.6312 80.6732C83.1821 81.4076 83.6607 82.2437 84.4987 82.6151C84.0195 83.1306 83.4224 83.0315 82.8833 83.2327C82.8836 83.2334 82.8836 83.2337 82.8839 83.2344C82.8836 83.2334 82.8829 83.2324 82.8826 83.2314C82.9227 83.0719 82.9914 82.9087 82.9927 82.7539C82.9927 82.7529 82.9927 82.7522 82.9927 82.7512C82.9924 82.6498 82.8976 82.5594 82.8454 82.464C82.7915 82.5874 82.6888 82.7232 82.6888 82.8324C82.6888 82.838 82.6892 82.843 82.6895 82.8483C82.7029 82.9895 82.813 83.1053 82.8826 83.2314C82.8822 83.2321 82.8823 83.2327 82.8819 83.2331L82.8839 83.2344C82.8374 83.3936 82.7932 83.5537 82.7511 83.7142C82.4596 83.7472 82.2203 83.9067 82.0318 84.1884C81.8996 84.123 81.7735 84.0188 81.6326 84.0082C81.6309 84.0078 81.6292 84.0078 81.6279 84.0078C81.5496 84.0078 81.4492 84.153 81.3595 84.2307C81.4013 84.2891 81.4328 84.3815 81.4883 84.3996C81.6275 84.4439 81.7778 84.4546 81.9237 84.4786C81.9227 84.5017 81.9224 84.5247 81.9224 84.547C81.9227 84.8854 82.0355 85.1556 82.2494 85.3655C82.2457 85.3682 82.242 85.3709 82.2383 85.3739C82.2356 85.3759 82.233 85.3779 82.2303 85.3795C82.2243 85.3842 82.2182 85.3889 82.2119 85.3932C82.2116 85.3932 82.2116 85.3936 82.2112 85.3936C82.0225 85.5297 81.8324 85.6068 81.6326 85.6074C81.6316 85.6074 81.6309 85.6074 81.6299 85.6074ZM79.3598 78.5725C79.3474 78.6562 79.4615 78.7943 79.5141 78.9054C79.6613 78.8944 79.8126 78.9101 79.9548 78.8647C80.0904 78.8217 80.2176 78.7156 80.3484 78.6372C80.2694 78.5264 80.2099 78.3759 80.1054 78.3148C80.0994 78.3115 80.093 78.3078 80.0867 78.3045C80.085 78.3035 80.0834 78.3025 80.0817 78.3018C80.0753 78.2985 80.0686 78.2952 80.0619 78.2918C79.9849 78.2548 79.8946 78.2308 79.8079 78.2304C79.8072 78.2304 79.8062 78.2304 79.8056 78.2304C79.8049 78.2304 79.8042 78.2304 79.8035 78.2304C79.7681 78.2308 79.7329 78.2348 79.6998 78.2438C79.6995 78.2438 79.6988 78.2441 79.6981 78.2441C79.6951 78.2448 79.6921 78.2458 79.6891 78.2468C79.5673 78.2838 79.417 78.4246 79.3641 78.5561C79.3621 78.5614 79.3604 78.5668 79.3598 78.5725ZM79.6734 77.498C79.6744 77.498 79.6757 77.498 79.6767 77.498C80.0837 77.497 80.4906 77.3282 80.8969 77.162C80.9535 77.139 81.0288 77.0376 81.0338 76.9748C81.0395 76.8981 81.0482 76.796 81.0482 76.7076C81.0486 76.6135 81.0388 76.5351 81.006 76.5197C81.0013 76.5174 80.9967 76.5154 80.992 76.5131C80.8173 76.433 80.6476 76.393 80.4823 76.3926C80.4816 76.3926 80.4809 76.3926 80.4803 76.3926C80.4793 76.3926 80.4786 76.3926 80.4776 76.3926C80.0134 76.394 79.5873 76.7086 79.2038 77.3215C79.1958 77.3339 79.1881 77.3466 79.18 77.3596C79.1764 77.3659 79.1724 77.3723 79.1683 77.3786C79.165 77.3843 79.162 77.3896 79.1586 77.3953H79.1583H79.1586C79.3293 77.4677 79.5003 77.4977 79.6713 77.498C79.672 77.498 79.6727 77.498 79.6734 77.498ZM83.5864 71.8561C83.5874 71.8561 83.5884 71.8561 83.5894 71.8561C83.6533 71.8554 83.7206 71.8434 83.7896 71.8221C83.7956 71.8201 83.8013 71.8184 83.8073 71.8164C84.0807 71.7253 84.3535 71.6282 84.7565 71.4891C84.47 71.1854 84.2973 70.9002 84.052 70.769C84.0493 70.7677 84.0466 70.7664 84.0439 70.765C83.98 70.7323 83.9147 70.717 83.8505 70.7166C83.8498 70.7166 83.8491 70.7166 83.8488 70.7166C83.8478 70.7166 83.8471 70.7166 83.8461 70.7166C83.6426 70.718 83.4452 70.8674 83.2993 71.0827C83.2983 71.0843 83.2973 71.0857 83.2963 71.087C83.2899 71.0967 83.2832 71.1067 83.2768 71.1167C83.2735 71.1224 83.2698 71.128 83.2664 71.1337C83.2648 71.1364 83.2631 71.1391 83.2614 71.1421C83.2199 71.2111 83.1989 71.3202 83.1985 71.4233C83.1985 71.4987 83.2096 71.5708 83.232 71.6222C83.2343 71.6275 83.237 71.6329 83.2394 71.6379C83.242 71.6436 83.2447 71.6492 83.2477 71.6546C83.2484 71.6556 83.2487 71.6566 83.2494 71.6576C83.324 71.7977 83.4442 71.8551 83.5827 71.8561C83.5837 71.8561 83.5851 71.8561 83.5864 71.8561Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M84.4985 82.615C83.6605 82.2436 83.1819 81.4075 82.631 80.6731C82.619 80.6567 82.6133 80.638 82.6133 80.6183C82.6133 80.5106 82.7753 80.3644 82.9339 80.3527C83.2224 80.4285 83.5109 80.5039 83.8 80.5796C84.0681 80.6877 84.3365 80.7955 84.6049 80.9036C84.6247 81.1025 84.6876 81.2286 84.7917 81.2296C84.792 81.2296 84.7924 81.2296 84.793 81.2296C84.794 81.2296 84.7947 81.2296 84.7957 81.2296C84.8496 81.2286 84.9142 81.1946 84.9892 81.1205C84.9912 81.1188 84.9932 81.1169 84.9949 81.1152C84.9992 81.1109 85.0035 81.1065 85.0079 81.1018C85.0102 81.0992 85.0129 81.0965 85.0153 81.0938C85.0277 81.0808 85.04 81.0681 85.0521 81.0561C85.2492 80.8606 85.447 80.7899 85.6491 80.7892C85.6501 80.7892 85.6508 80.7892 85.6518 80.7892C85.6528 80.7892 85.6535 80.7892 85.6545 80.7892C85.7767 80.7899 85.9005 80.8155 86.0273 80.8546C85.9734 81.0137 85.9182 81.1722 85.862 81.3304L85.8577 81.3381C85.6267 81.4338 85.5273 81.4752 85.527 81.562C85.527 81.6274 85.5829 81.7188 85.6809 81.8786L85.6716 81.8859C85.2807 82.1289 84.8894 82.3717 84.4985 82.615Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M88.6747 85.6448C88.6713 85.6448 88.6713 85.6448 88.6713 85.6448C88.0789 85.6438 87.5736 85.3725 87.0494 85.1863C87.0384 85.1827 87.0277 85.1786 87.017 85.175C87.0126 85.1736 87.0079 85.172 87.0036 85.1703C87.0012 85.1696 86.9986 85.1686 86.9959 85.1676C86.9919 85.1663 86.9875 85.165 86.9835 85.1636C86.9758 85.161 86.9681 85.1583 86.9604 85.156C87.0157 84.9788 87.0712 84.8019 87.1264 84.6248C87.1944 84.4756 87.2687 84.3298 87.3487 84.1876C87.3527 84.1886 87.3563 84.19 87.3604 84.191C87.4688 84.222 87.5769 84.2411 87.6807 84.2411C87.6807 84.2411 87.6806 84.2411 87.684 84.2411H87.6874C87.9082 84.2397 88.1157 84.155 88.3098 83.9247C88.3098 83.9247 88.3098 83.9247 88.3098 83.9244C88.3132 83.9177 88.3199 83.9107 88.3266 83.9037C88.3266 83.901 88.3299 83.8984 88.3333 83.8957C88.5977 83.9868 88.8654 84.0779 89.1298 84.1693L89.2436 84.189C89.1064 84.6691 88.9692 85.1493 88.8286 85.6384C88.8219 85.6391 88.8152 85.6394 88.8085 85.6398C88.8085 85.6401 88.8052 85.6401 88.8018 85.6404C88.8018 85.6404 88.8018 85.6404 88.7985 85.6408C88.7583 85.6434 88.7148 85.6448 88.6747 85.6448Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M82.4575 85.3901C82.4565 85.3901 82.4552 85.3901 82.4542 85.3901C82.4003 85.3901 82.3467 85.3851 82.2942 85.3751C82.2791 85.3721 82.2641 85.3691 82.2493 85.3654C82.0355 85.1556 81.9227 84.8853 81.9224 84.547C81.9224 84.5246 81.9227 84.5016 81.9237 84.4786C81.9465 84.3768 81.9826 84.28 82.0318 84.1883C82.2202 83.9067 82.4595 83.7472 82.751 83.7141C83.0475 83.948 83.1791 84.0515 83.1784 84.1986C83.1777 84.3167 83.092 84.4629 82.9388 84.7272C82.8169 84.9374 82.7145 85.1612 82.6031 85.3788C82.5864 85.3815 82.5693 85.3835 82.5525 85.3855C82.5418 85.3865 82.5315 85.3875 82.5208 85.3881C82.5007 85.3895 82.4806 85.3901 82.4605 85.3901C82.4595 85.3901 82.4585 85.3901 82.4575 85.3901Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M87.1266 84.625C87.0386 84.4151 86.9506 84.2049 86.8625 83.9947C87.0245 84.0591 87.1865 84.1235 87.3488 84.1879C87.2689 84.33 87.1946 84.4759 87.1266 84.625Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M89.5351 76.2068C89.5317 76.2068 89.5317 76.2068 89.5317 76.2068C89.2707 76.2061 89.013 76.132 88.7586 76.0163C88.7586 76.0156 88.7586 76.0149 88.7553 76.0146C88.7519 76.0119 88.7452 76.0096 88.7385 76.0069C88.7184 75.9962 88.695 75.9852 88.6716 75.9739L88.6482 75.9676C88.762 75.6362 88.8724 75.3052 88.9862 74.9739C89.3845 74.8474 89.6221 74.5538 89.6723 74.0807C89.6756 74.0433 89.6756 74.0083 89.6756 73.9749C89.6756 73.5335 89.3544 73.419 89.0699 73.2715C89.2439 72.765 89.4179 72.2582 89.592 71.7517L89.5987 71.7547C89.7325 71.8064 89.8697 71.8461 90.0103 71.8732C90.2111 71.9409 90.4086 72.0223 90.6127 72.074C91.1315 72.2048 91.4762 72.4537 91.4796 73.0483C91.4796 73.1651 91.4662 73.2949 91.4394 73.44C91.426 73.4944 91.4227 73.5452 91.4227 73.5925C91.4227 73.9783 91.744 74.1404 92.0385 74.2719C92.1054 74.3396 92.1456 74.439 92.1456 74.5251C92.1456 74.6008 92.1154 74.6663 92.0485 74.6903C91.6 74.8564 91.2687 75.1424 91.0779 75.6509C90.8537 75.734 90.6127 75.7707 90.4153 75.9085C90.1107 76.12 89.8196 76.2065 89.5351 76.2068Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M90.1976 71.3604C90.1909 71.3604 90.1876 71.3604 90.1809 71.3604C90.3248 71.1285 90.5055 70.9986 90.7365 70.9966C90.7398 70.9966 90.7398 70.9966 90.7432 70.9966C90.7499 70.9966 90.7599 70.9967 90.7699 70.9973C90.7666 71.0017 90.7632 71.006 90.7599 71.0107C90.6193 71.2469 90.4319 71.3594 90.201 71.3604H90.1976Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M58.3772 88.1497C57.841 87.9775 57.3049 87.805 56.769 87.6325C57.0873 87.184 57.4859 86.9435 57.9555 86.9331C57.9615 86.9328 57.9679 86.9328 57.9739 86.9328C57.9776 86.9328 57.9813 86.9328 57.9846 86.9328C57.9856 86.9328 57.9866 86.9328 57.9873 86.9328C57.9886 86.9328 57.9899 86.9328 57.9913 86.9328C58.0063 86.9328 58.0214 86.9331 58.0365 86.9334C58.0639 86.9341 58.0914 86.9351 58.1188 86.9361C58.1422 86.9371 58.1653 86.9381 58.1887 86.9388C58.2088 86.9395 58.2286 86.9398 58.2487 86.9398C58.2493 86.9398 58.25 86.9398 58.2506 86.9398C58.252 86.9398 58.2537 86.9398 58.255 86.9398C58.431 86.9394 58.6054 86.9084 58.7754 86.7299C58.7761 86.7293 58.7768 86.7286 58.7774 86.7279C58.7838 86.7212 58.7902 86.7139 58.7969 86.7069C58.7982 86.7049 58.7999 86.7032 58.8015 86.7012C58.8276 86.6185 58.8387 86.5387 58.8387 86.4617C58.8377 86.0476 58.5171 85.7009 58.5167 85.2781C58.5167 85.139 58.5509 84.9919 58.6426 84.8314C58.6901 84.839 58.7373 84.848 58.7845 84.857C58.9361 84.8867 59.0874 84.9198 59.2413 84.9211C59.2447 84.9211 59.248 84.9211 59.251 84.9211C59.2574 84.9211 59.2637 84.9211 59.2701 84.9211C59.4049 84.9184 59.5472 84.803 59.6884 84.77C60.2216 84.6455 60.2139 83.7726 60.7423 83.6235C60.8889 83.9602 61.0084 84.2341 61.1275 84.5077C60.9632 84.9465 60.7715 85.3796 60.7711 85.8394C60.7711 85.9595 60.7842 86.0813 60.814 86.2057C60.8394 86.3118 60.8511 86.4159 60.8511 86.518C60.8514 86.9098 60.6824 87.2755 60.4776 87.6301C60.4719 87.6291 60.4659 87.6281 60.4602 87.6275C60.4552 87.6265 60.4502 87.6258 60.4451 87.6248C60.4421 87.6245 60.4391 87.6241 60.4361 87.6235C60.4334 87.6231 60.4311 87.6228 60.4287 87.6225C60.3203 87.6061 60.2119 87.5934 60.1038 87.5934C60.1031 87.5934 60.1024 87.5934 60.1014 87.5934C60.0998 87.5934 60.0981 87.5934 60.0964 87.5934C59.8802 87.5941 59.6653 87.6452 59.4548 87.8143C59.4461 87.8143 59.4374 87.8143 59.4287 87.8143C59.426 87.8143 59.423 87.8143 59.4204 87.8143C59.0626 87.815 58.7135 87.8761 58.3912 88.1383C58.3865 88.142 58.3818 88.146 58.3772 88.1497Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M54.4909 88.5352C54.3784 88.4871 54.2593 88.4517 54.1549 88.3883C54.0658 88.3343 54.016 88.3023 54.0156 88.2626C54.0153 88.2108 54.0993 88.1454 54.2911 87.9996C54.4129 88.0914 54.5294 88.1868 54.5297 88.3526C54.5297 88.4054 54.5183 88.4658 54.4909 88.5352Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M92.2259 65.5039C91.9949 65.5022 91.8945 65.3201 91.9146 65.0568C91.9146 65.0451 91.9146 65.0334 91.9179 65.0214C91.9347 64.8539 91.9715 64.6861 91.9983 64.5183C92.179 64.0134 92.3564 63.5086 92.5338 63.0038C92.8751 63.1446 93.1329 63.3598 93.1329 63.7522C93.1329 63.8569 93.1127 63.9747 93.0726 64.1069C92.9488 64.513 92.7915 64.9143 92.6074 65.2961C92.5539 65.4078 92.3564 65.5012 92.2359 65.5036C92.2325 65.5039 92.2292 65.5039 92.2259 65.5039Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M69.393 86.7131C69.0456 86.3978 68.8796 85.9664 68.8743 85.4305C69.2799 85.3137 69.5376 85.0088 69.6792 84.5573C69.7508 84.5707 69.8234 84.5777 69.8967 84.5777C69.8977 84.5777 69.8984 84.5777 69.8991 84.5777C69.9004 84.5777 69.9014 84.5777 69.9027 84.5777C69.9529 84.5777 70.0038 84.5743 70.055 84.568C70.06 84.5673 70.0654 84.5667 70.0704 84.566C70.07 84.5767 70.0701 84.5877 70.0701 84.5984C70.0694 84.933 70.1782 85.1996 70.3917 85.4012C70.3914 85.4128 70.391 85.4242 70.391 85.4355C70.3907 85.9053 70.7391 85.9898 71.0082 86.1623C70.9509 86.3127 70.8941 86.4639 70.8375 86.6147C70.8238 86.6117 70.81 86.6087 70.7963 86.6054C70.7889 86.6037 70.7816 86.6017 70.7742 86.5997C70.7729 86.5994 70.7712 86.599 70.7699 86.5987C70.7645 86.5973 70.7592 86.596 70.7538 86.5943C70.72 86.5853 70.6865 86.575 70.6531 86.5643C70.4369 86.4946 70.2217 86.3992 70.0018 86.3982C70.0008 86.3982 69.9998 86.3982 69.9984 86.3982C69.9978 86.3982 69.9971 86.3982 69.9961 86.3982C69.8117 86.3985 69.6239 86.4666 69.4292 86.6734C69.4171 86.6861 69.4051 86.6995 69.393 86.7131Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M67.3452 87.1831C67.0119 87.0496 66.6213 87.0353 66.4011 86.6583C66.782 86.2545 67.2442 86.2609 67.6809 86.1467C67.5692 86.4924 67.457 86.8378 67.3452 87.1831Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M68.8743 85.4309C68.7492 85.3518 68.6133 85.2994 68.4677 85.2747L68.449 85.2237C68.4517 85.2207 68.454 85.218 68.4563 85.215C68.4707 85.1987 68.4851 85.1823 68.4998 85.166C68.5018 85.164 68.5035 85.162 68.5055 85.16C68.5075 85.1576 68.5099 85.1553 68.5119 85.153C68.8305 84.8029 69.1822 84.5577 69.6116 84.5557C69.6136 84.5557 69.6153 84.5557 69.617 84.5557C69.6173 84.5557 69.6173 84.5557 69.6177 84.5557C69.6371 84.5557 69.6568 84.5564 69.6766 84.5574C69.6776 84.5574 69.6782 84.5577 69.6792 84.5577C69.5377 85.0091 69.28 85.3141 68.8743 85.4309Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M68.62 87.6023C68.62 87.599 68.62 87.596 68.62 87.593C68.621 87.5953 68.622 87.598 68.623 87.6003L68.62 87.6023ZM68.62 87.593C68.5809 87.4929 68.5422 87.3931 68.5032 87.293C68.5415 87.3203 68.6012 87.3367 68.6129 87.3774C68.6209 87.4068 68.6233 87.4388 68.6233 87.4722C68.6233 87.5119 68.6203 87.5533 68.62 87.593Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M68.276 85.6641C68.1438 85.6497 68.0223 85.6067 67.9109 85.5343C68.0899 85.4305 68.2693 85.3267 68.4487 85.2233L68.4675 85.2743C68.4092 85.4075 68.3453 85.5373 68.276 85.6641Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M79.9207 85.0012C79.6984 84.7536 79.4762 84.5057 79.2537 84.2581C79.34 84.0112 79.3815 83.7823 79.3819 83.5698C79.3822 83.1273 79.2038 82.7567 78.8792 82.4447C78.9645 82.1894 79.0391 81.9298 79.1372 81.6799C79.5194 80.7046 79.5221 80.7066 80.5214 80.6386C80.673 80.6282 80.825 80.6079 80.991 80.5912C81.1707 80.8381 81.316 81.0843 81.316 81.3319C81.316 81.5645 81.1878 81.7977 80.8394 82.0333C80.7731 82.0776 80.6777 82.144 80.6667 82.2074C80.6486 82.3092 80.6278 82.4247 80.6282 82.5281C80.6282 82.5882 80.6352 82.6446 80.654 82.6916C80.753 82.9419 80.7975 83.1744 80.7975 83.3926C80.7969 84.0206 80.4257 84.5294 79.9207 85.0012Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M78.5693 84.5847C78.5686 84.5847 78.5679 84.5847 78.5669 84.5847C78.4765 84.5844 78.3842 84.5697 78.2905 84.542C78.2868 84.541 78.2831 84.5397 78.2791 84.5387C77.9551 84.4386 77.6315 84.3361 77.3075 84.2347C77.1633 84.0842 77.1144 83.9154 77.1147 83.7365C77.1151 83.5177 77.1894 83.2841 77.2526 83.0525C77.3276 82.8917 77.3959 82.7275 77.4571 82.5604C77.4611 82.5624 77.4652 82.5641 77.4692 82.5657C77.5893 82.6181 77.7108 82.6381 77.8333 82.6381C77.834 82.6381 77.8346 82.6381 77.8353 82.6381C77.838 82.6381 77.8406 82.6381 77.8433 82.6381C78.0589 82.6368 78.2771 82.5747 78.4946 82.52C78.5006 82.5187 78.5063 82.5173 78.5124 82.5157C78.5124 82.5157 78.5123 82.5157 78.5127 82.5157C78.6352 82.485 78.7577 82.4576 78.8792 82.4449C79.2038 82.7569 79.3822 83.1276 79.3819 83.57C79.3815 83.7826 79.34 84.0115 79.2537 84.2584C79.2513 84.2611 79.2487 84.2637 79.2463 84.2664C79.2447 84.2677 79.243 84.2694 79.2413 84.2711C79.2396 84.2731 79.2379 84.2748 79.2359 84.2768C79.2202 84.2928 79.2045 84.3081 79.1884 84.3228C79.1881 84.3228 79.1881 84.3228 79.1881 84.3231C78.9943 84.501 78.7891 84.5834 78.5749 84.5847C78.5729 84.5847 78.5713 84.5847 78.5693 84.5847Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M72.8093 84.9993C72.8103 84.9986 72.8113 84.9979 72.8123 84.9973C73.0101 84.8741 73.2079 84.751 73.4057 84.6279C73.4084 84.6262 73.4111 84.6246 73.4137 84.6229C73.4111 84.6246 73.4084 84.6262 73.4057 84.6279C73.2079 84.751 73.0101 84.8741 72.8123 84.9973C72.8113 84.9979 72.8103 84.9986 72.8093 84.9993Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M5.83572 63.1841L5.82568 63.1574C5.84342 63.1554 5.86183 63.1544 5.87991 63.1537C5.86518 63.1637 5.85044 63.1741 5.83572 63.1841ZM5.87991 63.1537C5.95454 63.102 6.02916 63.0503 6.10413 62.9986C6.07602 63.0443 6.05393 63.114 6.01812 63.1304C5.97495 63.1497 5.92743 63.1517 5.87991 63.1537Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M26.945 67.9326C26.8041 67.8926 26.6649 67.8482 26.527 67.7992C26.6415 67.3934 26.7553 66.9877 26.8744 66.5663C26.8627 66.566 26.8517 66.5656 26.8406 66.5656C26.8403 66.5656 26.8396 66.5656 26.8389 66.5656C26.4209 66.5666 26.3898 67.007 26.0792 67.1805C26.0591 67.1919 26.0377 67.2022 26.015 67.2109C26.014 67.2109 26.013 67.2109 26.012 67.2109C26.0113 67.2109 26.011 67.2109 26.0106 67.2109C25.7027 67.2096 25.9149 66.7578 25.8088 66.5406C25.8061 66.5356 25.8035 66.5306 25.8008 66.5259C25.7998 66.5242 25.7988 66.5226 25.7981 66.5212C25.7961 66.5182 25.7941 66.5152 25.7921 66.5126C25.7917 66.5119 25.7911 66.5112 25.7907 66.5106C25.7884 66.5072 25.786 66.5035 25.7837 66.5002C25.783 66.4995 25.7827 66.4985 25.782 66.4979C25.7804 66.4955 25.7787 66.4929 25.777 66.4905C25.7767 66.4899 25.7763 66.4892 25.776 66.4889C25.7703 66.4805 25.765 66.4718 25.7593 66.4632C25.7496 66.4475 25.7399 66.4315 25.7298 66.4144C25.7275 66.4111 25.7255 66.4075 25.7235 66.4038C25.7181 66.3948 25.7127 66.3858 25.7077 66.3767C25.697 66.3584 25.6867 66.3397 25.6759 66.3213C25.5893 66.1685 25.5012 66.0124 25.4243 66.0087C25.4236 66.0087 25.4226 66.0087 25.4216 66.0087H25.4213C25.4176 66.0087 25.4142 66.009 25.4109 66.0097C25.4105 66.01 25.4099 66.0101 25.4095 66.0101C25.3995 66.0124 25.3895 66.0144 25.3794 66.0164C25.3172 66.0281 25.2549 66.0331 25.1923 66.0331C25.1917 66.0331 25.191 66.0331 25.19 66.0331C25.188 66.0331 25.186 66.0331 25.184 66.0331C25.0595 66.0324 24.9343 66.0137 24.8091 65.9944C24.8068 65.994 24.8041 65.9937 24.8018 65.9934C24.6722 65.9734 24.5431 65.9533 24.4142 65.9533C24.3101 65.9533 24.2067 65.9663 24.1036 66.003C23.9775 66.0477 23.8526 66.1278 23.7291 66.2626C23.7281 66.2636 23.7271 66.2646 23.7261 66.2656C23.7228 66.2693 23.7198 66.2727 23.7167 66.276C23.4684 65.7264 23.2442 65.2556 22.6622 64.9583C22.0112 64.626 21.3251 64.4188 20.6688 64.1222C20.6417 63.7358 20.6143 63.3497 20.5872 62.9637C20.5999 62.9613 20.6126 62.9587 20.6253 62.956C20.6327 62.9544 20.6404 62.953 20.6477 62.9513C20.6511 62.9507 20.6541 62.95 20.6571 62.9493C20.6608 62.9487 20.6641 62.948 20.6678 62.947C20.6752 62.9453 20.6829 62.9437 20.6906 62.942C20.711 62.9377 20.7314 62.933 20.7522 62.9283C20.7605 62.9263 20.7686 62.9243 20.7769 62.9227C21.034 62.8626 21.2927 62.7925 21.5397 62.7922C21.5403 62.7922 21.541 62.7922 21.542 62.7922C21.543 62.7922 21.544 62.7922 21.545 62.7922C21.8024 62.7929 22.0467 62.8699 22.2619 63.1148C22.2666 63.1198 22.2709 63.1252 22.2753 63.1302C22.4932 63.3864 22.79 63.3407 23.0849 63.3744C23.5946 63.4325 24.0846 63.6 24.5826 63.7218C24.5872 63.7231 24.5919 63.7241 24.5966 63.7254C24.6 63.7261 24.6033 63.7271 24.6066 63.7281C24.7268 63.7581 24.8459 63.7792 24.9637 63.7795C24.9647 63.7795 24.9658 63.7795 24.9668 63.7795C24.9701 63.7795 24.9738 63.7795 24.9771 63.7795C25.1933 63.7772 25.4045 63.7038 25.6053 63.4869C25.6124 63.4792 25.6197 63.4715 25.6267 63.4642C25.6287 63.4622 25.6304 63.4605 25.6324 63.4585C25.8302 63.2583 26.0397 63.1973 26.2536 63.1963C26.2556 63.1963 26.2573 63.1963 26.259 63.1963C26.261 63.1963 26.263 63.1963 26.265 63.1963C26.3798 63.1969 26.4966 63.2143 26.6134 63.2366C26.6197 63.238 26.6258 63.2393 26.6321 63.2403C27.0993 63.8819 26.7734 64.978 27.5404 65.5786C27.7858 65.5075 28.1435 65.4048 28.5763 65.28C28.9521 65.6934 29.3577 66.1395 29.763 66.586C29.6469 66.9346 29.5304 67.2833 29.4139 67.632C29.3145 67.5192 29.2041 67.4171 29.1178 67.2923C29.1161 67.29 29.1148 67.2877 29.1131 67.2857C29.1111 67.283 29.1094 67.2803 29.1077 67.278C29.1057 67.2753 29.1034 67.2727 29.1014 67.2697C29.0277 67.1716 28.9538 67.1262 28.8788 67.1255C28.8781 67.1255 28.8778 67.1255 28.8772 67.1255C28.8761 67.1255 28.8755 67.1255 28.8748 67.1255C28.7834 67.1268 28.691 67.1932 28.595 67.3104C28.595 67.3104 28.5947 67.3107 28.5947 67.311C28.5893 67.3173 28.5839 67.324 28.5786 67.331C28.5772 67.3324 28.5763 67.3337 28.5753 67.3351C28.5746 67.3361 28.5736 67.337 28.5729 67.338C28.4297 67.2937 28.2867 67.2493 28.1435 67.2052C28.183 67.0464 28.2305 66.8886 28.2576 66.7288C28.26 66.7137 28.261 66.6961 28.261 66.6774C28.261 66.6073 28.2449 66.5232 28.2249 66.5202C28.2008 66.5169 28.1743 66.5132 28.1472 66.5102C28.1251 66.5079 28.1027 66.5059 28.0803 66.5052C28.0752 66.5052 28.0699 66.5052 28.0649 66.5052C28.0639 66.5052 28.0632 66.5052 28.0622 66.5052C28.007 66.5056 27.9558 66.5146 27.921 66.5432C27.9186 66.5453 27.9166 66.5472 27.9143 66.5492C27.9136 66.5499 27.9133 66.5503 27.9126 66.5509C27.6378 66.8285 27.3855 67.1379 27.1248 67.4352C27.0632 67.6003 27.0029 67.7661 26.945 67.9326Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M31.0432 64.5854C30.2008 64.2608 29.9475 63.1734 29.1064 62.9558C29.6332 62.6178 30.1506 62.2501 30.6918 61.9592C30.7501 61.9278 30.8146 61.9168 30.8829 61.9165C30.8839 61.9165 30.8849 61.9165 30.8859 61.9165C30.8883 61.9165 30.8906 61.9165 30.8926 61.9165C30.9723 61.9175 31.0559 61.9321 31.1396 61.9458C31.2042 61.9565 31.2688 61.9665 31.3307 61.9689C32.0864 61.6592 32.5376 60.9895 32.8826 60.1937C33.0182 60.2388 33.153 60.2845 33.2883 60.3312C33.1671 60.7346 33.0463 61.138 32.9004 61.6238C32.9027 61.6238 32.905 61.6238 32.907 61.6242C32.9623 61.6268 33.0138 61.6298 33.0623 61.6328C33.0764 61.6338 33.0904 61.6345 33.1038 61.6355C33.2718 61.6462 33.4034 61.6569 33.5289 61.6569C33.5295 61.6569 33.5302 61.6569 33.5309 61.6569C33.5316 61.6569 33.5319 61.6569 33.5322 61.6569C33.552 61.6569 33.5714 61.6565 33.5911 61.6562C33.5988 61.6559 33.6065 61.6555 33.6139 61.6552C33.8264 61.6465 34.063 61.6062 34.1012 61.2885C34.1039 61.2672 34.1052 61.2445 34.1052 61.2214C34.1055 61.0796 34.0593 60.9138 33.982 60.8387C33.7752 60.6379 33.5239 60.4954 33.2909 60.3296C33.6651 59.8848 34.1383 59.9485 34.5741 59.8514C34.5764 59.8507 34.5788 59.8504 34.5811 59.8498C34.5814 59.8498 34.5814 59.8498 34.5818 59.8498C34.5838 59.8491 34.5858 59.8488 34.5874 59.8484C34.6209 59.8417 34.6524 59.8387 34.6815 59.8384C34.6818 59.8384 34.6822 59.8384 34.6825 59.8384C34.6835 59.8384 34.6845 59.8384 34.6855 59.8384C34.9536 59.8407 35.0573 60.1067 35.1798 60.3786C35.1812 60.3813 35.1822 60.3839 35.1835 60.3866C35.1849 60.39 35.1865 60.3933 35.1882 60.3966C35.1895 60.4003 35.1912 60.404 35.1929 60.4076C35.3365 60.7176 35.4797 60.8717 35.6249 60.8741C35.626 60.8741 35.6273 60.8741 35.6283 60.8741C35.6297 60.8741 35.6306 60.8741 35.632 60.8741C35.7725 60.8717 35.9148 60.7276 36.0617 60.4463C36.0637 60.4423 36.0661 60.4383 36.0681 60.434C36.0694 60.4313 36.0707 60.4286 36.0724 60.426C36.0771 60.4163 36.0818 60.407 36.0868 60.3969C36.203 60.163 36.2746 59.9035 36.3663 59.6556C36.4941 59.8261 36.5751 60.0179 36.5741 60.2331C36.5738 60.3349 36.5554 60.442 36.5149 60.5548C36.4014 60.8711 36.3151 61.2511 36.1119 61.4703C35.703 61.9121 35.7843 62.3946 35.7531 62.8811C35.6387 62.8677 35.5219 62.829 35.4084 62.829C35.4061 62.829 35.4041 62.829 35.4021 62.829C35.3726 62.8294 35.3435 62.8327 35.3147 62.8394C35.3137 62.8397 35.3127 62.8401 35.3117 62.8401C35.2987 62.8434 35.2856 62.8467 35.2726 62.8504C35.2699 62.8514 35.2675 62.8521 35.2648 62.8527C35.2558 62.8554 35.2468 62.8581 35.2377 62.8611C35.2327 62.8627 35.2277 62.8641 35.223 62.8657C35.223 62.8657 35.223 62.8657 35.2227 62.8657C35.2163 62.8681 35.21 62.8701 35.2036 62.8724C35.1932 62.8761 35.1832 62.8798 35.1728 62.8834C35.1711 62.8841 35.1695 62.8848 35.1678 62.8854C35.1497 62.8921 35.1317 62.8994 35.1136 62.9071C35.1112 62.9081 35.1092 62.9088 35.1069 62.9098C35.0707 62.9251 35.0346 62.9422 34.9988 62.9598L34.9984 62.9602C34.9834 62.9675 34.9687 62.9752 34.9539 62.9828C34.9516 62.9838 34.9496 62.9852 34.9472 62.9862C34.9472 62.9862 34.9472 62.9862 34.9472 62.9865C34.5858 63.1761 34.2404 63.452 33.8257 63.4547C33.8234 63.455 33.8214 63.455 33.819 63.455C33.8187 63.455 33.8184 63.455 33.818 63.455C33.7387 63.4547 33.6567 63.4446 33.5714 63.422C33.569 63.4213 33.5667 63.4206 33.5644 63.42C33.5319 63.412 33.4994 63.408 33.4666 63.4073C33.4626 63.407 33.4586 63.4069 33.4542 63.4069C33.2812 63.4069 33.1025 63.4967 32.9181 63.5864C32.7337 63.6765 32.5436 63.7663 32.3481 63.7663C32.2765 63.7663 32.2042 63.7543 32.1313 63.7256C32.0988 63.7129 32.066 63.6969 32.0332 63.6772C32.0319 63.6766 32.0302 63.6755 32.0289 63.6749C31.9971 63.6562 31.9666 63.6479 31.9375 63.6479C31.9371 63.6479 31.9368 63.6479 31.9365 63.6479C31.9355 63.6479 31.9341 63.6479 31.9328 63.6479C31.7762 63.6519 31.6611 63.8944 31.5449 64.0716C31.5419 64.0763 31.5389 64.0809 31.5355 64.0856C31.5349 64.0869 31.5339 64.088 31.5332 64.0893C31.5322 64.0906 31.5315 64.0916 31.5308 64.0926C31.5292 64.0953 31.5275 64.0976 31.5258 64.1C31.3889 64.2978 31.1898 64.4416 31.0432 64.5854ZM31.0921 63.0566C31.0924 63.1497 31.1015 63.2431 31.1045 63.3366C31.1128 63.3315 31.1212 63.3269 31.1296 63.3222C31.1818 63.2925 31.2337 63.2631 31.2859 63.2334C31.2862 63.2334 31.2862 63.2334 31.2862 63.2331C31.2815 63.098 31.2768 62.9632 31.2721 62.8277C31.2119 62.8617 31.1031 62.8941 31.0991 62.9298C31.0938 62.9718 31.0921 63.0142 31.0921 63.0566ZM35.7531 62.8818C35.7531 62.8818 35.7531 62.8814 35.7531 62.8811C35.7531 62.8814 35.7531 62.8814 35.7531 62.8818Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M33.1129 69.0588C33.1116 69.0588 33.1099 69.0588 33.1086 69.0588C32.0547 69.0582 31.0574 68.8149 30.0948 68.4185C30.0928 68.4179 30.0908 68.4168 30.0888 68.4162C30.068 68.4075 30.0473 68.3988 30.0262 68.3902C29.989 68.3745 29.9516 68.3585 29.9144 68.3424C29.6299 68.2193 29.4777 67.9704 29.4141 67.6317C29.5305 67.2831 29.647 66.9344 29.7632 66.5857C29.7655 66.583 29.7675 66.5804 29.7699 66.578C29.7759 66.5707 29.7819 66.5634 29.7883 66.5564C29.7886 66.556 29.7889 66.5553 29.7893 66.555C29.7893 66.555 29.7893 66.555 29.7896 66.555C29.7929 66.551 29.7963 66.5473 29.7996 66.5433C29.8006 66.542 29.802 66.541 29.803 66.5397C29.8036 66.539 29.8043 66.5383 29.805 66.5376C29.8147 66.5266 29.8244 66.5163 29.8344 66.5063C29.8385 66.5023 29.8421 66.4986 29.8461 66.4946C29.9057 66.4359 29.966 66.3905 30.0269 66.3555C30.0269 66.3551 30.0272 66.3551 30.0275 66.3551C30.0486 66.3428 30.0697 66.3321 30.0911 66.3224C30.0915 66.3221 30.0918 66.3221 30.0921 66.3218C30.0928 66.3214 30.0938 66.3211 30.0948 66.3208C30.0955 66.3204 30.0965 66.3198 30.0975 66.3194C30.0982 66.3191 30.0985 66.3191 30.0992 66.3188C30.1042 66.3164 30.1089 66.3144 30.1139 66.3124C30.2257 66.2657 30.3395 66.25 30.4536 66.25C30.5694 66.25 30.6855 66.266 30.8013 66.2821C30.8057 66.2827 30.81 66.2834 30.814 66.2841C30.9245 66.2991 31.0343 66.3138 31.1424 66.3141C31.1437 66.3141 31.1447 66.3141 31.146 66.3141C31.1464 66.3141 31.1467 66.3141 31.1474 66.3141C31.1711 66.3141 31.1952 66.3134 31.219 66.3118C31.2234 66.3114 31.2277 66.3111 31.2317 66.3108C31.2364 66.3104 31.2414 66.3101 31.2461 66.3098C31.2464 66.3098 31.2468 66.3098 31.2474 66.3098C31.2518 66.3094 31.2558 66.3091 31.2602 66.3088C31.2615 66.3084 31.2632 66.3084 31.2645 66.3084C31.2655 66.3084 31.2662 66.3084 31.2672 66.3081C31.2692 66.3081 31.2712 66.3081 31.2732 66.3078C31.2736 66.3078 31.2739 66.3078 31.2742 66.3078C31.2789 66.3074 31.2836 66.3071 31.2883 66.3071C31.2906 66.3067 31.2926 66.3068 31.295 66.3064H31.2953C31.3492 66.3038 31.4027 66.3027 31.456 66.3027C31.5068 66.3027 31.5574 66.3037 31.6079 66.3044C31.6581 66.3054 31.7083 66.3061 31.7581 66.3061C32.0175 66.3061 32.2769 66.2837 32.557 66.1222C32.558 66.1219 32.559 66.1212 32.56 66.1206C32.5614 66.1199 32.5627 66.1189 32.5644 66.1183C32.5654 66.1176 32.5661 66.1169 32.5671 66.1166C32.5688 66.1156 32.5701 66.1146 32.5718 66.1139C32.5728 66.1132 32.5738 66.1126 32.5748 66.1119C32.5761 66.1112 32.5774 66.1102 32.5791 66.1092C32.5798 66.1089 32.5805 66.1086 32.5811 66.1082C32.5855 66.1055 32.5898 66.1029 32.5939 66.1002C32.5965 66.0989 32.5989 66.0972 32.6012 66.0959C32.6022 66.0952 32.6029 66.0949 32.6039 66.0942C32.6056 66.0932 32.6073 66.0922 32.6089 66.0912C32.6096 66.0905 32.6103 66.0902 32.6109 66.0899C32.6126 66.0885 32.6143 66.0875 32.6163 66.0862C32.6213 66.0832 32.626 66.0802 32.631 66.0769C32.6357 66.0739 32.6404 66.0705 32.6447 66.0675C32.6454 66.0672 32.6457 66.0672 32.6461 66.0669C32.6511 66.0635 32.6561 66.0598 32.6611 66.0565C32.7224 66.0141 32.7947 65.9978 32.8746 65.9975C32.875 65.9975 32.8756 65.9975 32.876 65.9975C32.8817 65.9975 32.8874 65.9975 32.893 65.9978C32.9988 66.0008 33.1163 66.0305 33.2364 66.0665C33.3894 66.1126 33.547 66.1686 33.6906 66.1926C34.2003 66.2947 34.4396 66.7976 34.793 67.1319C34.7904 67.1359 34.788 67.1399 34.7853 67.1439C34.785 67.1442 34.785 67.1446 34.7847 67.1449C34.7803 67.1513 34.7763 67.1576 34.7719 67.1636C34.7679 67.1699 34.7639 67.1756 34.7596 67.1816C34.5952 67.4095 34.3988 67.4416 34.1973 67.4422C34.195 67.4422 34.1926 67.4422 34.1906 67.4422C34.1899 67.4422 34.1896 67.4422 34.1889 67.4422C34.1592 67.4422 34.129 67.4416 34.0989 67.4406C34.0932 67.4406 34.0875 67.4405 34.0818 67.4402C34.0638 67.4399 34.0457 67.4392 34.0276 67.4389C34.0102 67.4385 33.9925 67.4385 33.9751 67.4385C33.9747 67.4385 33.9741 67.4385 33.9734 67.4385C33.9711 67.4385 33.9684 67.4385 33.966 67.4385C33.8151 67.4389 33.6665 67.4572 33.5319 67.562C33.5306 67.563 33.5293 67.5643 33.5276 67.5653C33.5253 67.5673 33.5226 67.5694 33.5202 67.5714C33.6357 67.891 33.7943 68.1983 33.794 68.5503C33.794 68.7018 33.7645 68.8616 33.6896 69.0345C33.6685 69.0361 33.6471 69.0381 33.626 69.0395C33.454 69.0525 33.2833 69.0588 33.114 69.0588C33.1136 69.0588 33.1133 69.0588 33.1129 69.0588Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M29.2897 59.5786C29.0092 59.4812 28.7288 59.3837 28.4483 59.286C28.361 59.0694 28.274 58.8525 28.187 58.6357L28.1873 58.635C28.106 58.4151 28.0243 58.1952 27.9426 57.975C28.0551 57.6337 28.1676 57.292 28.2803 56.9506C28.282 56.9473 28.284 56.9443 28.286 56.9413C28.435 56.7001 28.6301 56.5786 28.8714 56.5769C28.8734 56.5769 28.8751 56.5769 28.8771 56.5769C28.8784 56.5769 28.8798 56.5769 28.8814 56.5769C29.021 56.627 29.1615 56.673 29.3031 56.7157C29.9825 56.5663 30.029 55.8702 30.2513 55.3254C30.3209 55.1642 30.3674 54.982 30.4648 54.8456C30.4664 54.8432 30.4681 54.8409 30.4698 54.8389C30.5548 54.7221 30.6458 54.6634 30.7285 54.6624C30.7292 54.6624 30.7298 54.6624 30.7305 54.6624C30.7319 54.6624 30.7335 54.6624 30.7349 54.6624C30.8192 54.6644 30.8945 54.7271 30.9464 54.8509C30.9464 54.8512 30.9464 54.8516 30.9467 54.8519C30.9481 54.8549 30.949 54.8579 30.9504 54.8612C30.9521 54.8649 30.9534 54.8686 30.9547 54.8722C30.9557 54.8752 30.9571 54.8783 30.9581 54.8813C31.0381 55.1032 31.0542 55.3631 31.0987 55.606C30.9876 55.8405 30.9173 56.1272 30.7576 56.3004C30.4832 56.598 30.3941 56.8956 30.3941 57.1962C30.3938 57.4451 30.4547 57.6964 30.522 57.9513C30.6606 57.8822 30.7968 57.8045 30.9377 57.7461C30.941 57.7448 30.944 57.7435 30.9474 57.7421C30.9504 57.7408 30.9534 57.7398 30.9561 57.7388C30.9564 57.7384 30.9567 57.7384 30.9571 57.7384C30.9571 57.7384 30.9571 57.7384 30.9574 57.7381C30.9594 57.7374 30.9614 57.7368 30.9635 57.7361C31.0043 57.7211 31.0404 57.7137 31.0719 57.7137C31.0725 57.7134 31.0729 57.7134 31.0736 57.7134C31.0752 57.7134 31.0769 57.7137 31.0782 57.7137C31.1723 57.7157 31.2191 57.7848 31.2048 57.9133C31.2041 57.918 31.2038 57.9226 31.2031 57.927C31.2028 57.9283 31.2027 57.9293 31.2024 57.9303C31.1535 58.263 30.9618 58.7074 30.7506 58.7141C30.7489 58.7144 30.7472 58.7144 30.7456 58.7144C30.7456 58.7144 30.7452 58.7144 30.7449 58.7144C30.7318 58.7144 30.7184 58.7124 30.7051 58.7087C30.7041 58.7084 30.7034 58.7084 30.7027 58.7081C30.7001 58.7074 30.6974 58.7064 30.695 58.7057C30.5933 58.6707 30.5009 58.6547 30.4159 58.6547C30.4156 58.6547 30.4152 58.6547 30.4146 58.6547C30.4136 58.6547 30.4126 58.6547 30.4116 58.6547C29.9276 58.6567 29.6907 59.1685 29.3667 59.5039C29.3657 59.5049 29.3647 59.5059 29.3637 59.5069C29.359 59.5122 29.354 59.5172 29.349 59.5222C29.3459 59.5249 29.3433 59.5279 29.3403 59.5306C29.3389 59.5322 29.3372 59.5339 29.3356 59.5352C29.3305 59.5402 29.3255 59.5452 29.3202 59.5502C29.3195 59.5509 29.3188 59.5516 29.3182 59.5519C29.3162 59.5542 29.3141 59.5562 29.3118 59.5582C29.3044 59.5649 29.2971 59.5719 29.2897 59.5786Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M28.6543 63.5127C28.6533 63.5127 28.6523 63.5127 28.6513 63.5127C28.5302 63.511 28.4944 63.4096 28.5499 63.2237C28.5519 63.2181 28.5536 63.2121 28.5556 63.2061C28.7099 62.7279 28.8672 62.2505 29.0231 61.773C29.241 61.6832 29.3364 61.6438 29.3367 61.5648C29.3367 61.5034 29.2795 61.4176 29.1778 61.2658C29.3043 60.9261 29.4311 60.5868 29.558 60.2471C29.5617 60.2451 29.565 60.2431 29.5687 60.2411C29.5754 60.2374 29.5817 60.2334 29.5881 60.2298C29.5921 60.2274 29.5961 60.2251 29.6001 60.2228C29.6065 60.2188 29.6132 60.2147 29.6199 60.2111C29.6269 60.2067 29.6339 60.2024 29.641 60.1984C29.6436 60.1967 29.646 60.1954 29.6487 60.1937C30.2812 59.813 30.8866 59.3175 31.6075 59.3152C31.6089 59.3152 31.6106 59.3152 31.6119 59.3152C31.6122 59.3152 31.6122 59.3152 31.6122 59.3152C31.642 59.3152 31.6715 59.3162 31.7013 59.3179C32.1129 59.3416 32.3873 59.5584 32.5021 60.0129C32.129 60.1227 31.8716 60.3949 31.725 60.8083C31.5885 61.1934 31.4619 61.5821 31.3308 61.9692C31.2688 61.9668 31.2042 61.9568 31.1397 61.9461C31.056 61.9325 30.9723 61.9178 30.8927 61.9168C30.8907 61.9168 30.8883 61.9168 30.886 61.9168C30.885 61.9168 30.884 61.9168 30.883 61.9168C30.8147 61.9171 30.7501 61.9281 30.6919 61.9595C30.1507 62.2504 29.6333 62.6182 29.1065 62.9562C29.0329 63.1046 28.9669 63.2591 28.8819 63.3989C28.8491 63.4526 28.7738 63.4937 28.7159 63.5057C28.6938 63.5104 28.6738 63.5124 28.6557 63.5127C28.6553 63.5127 28.6547 63.5127 28.6543 63.5127Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M34.7931 67.1323C34.4397 66.798 34.2004 66.2951 33.6907 66.193C33.7499 66.1347 33.8061 66.0389 33.8691 66.0239C34.6291 65.8397 35.0478 65.2741 35.2265 64.4293C35.9046 64.2655 35.9581 63.5684 36.181 63.0159C36.183 63.0126 36.185 63.0096 36.187 63.0062C36.5415 62.3969 36.6456 62.2204 36.9297 62.2191C36.931 62.2191 36.932 62.2191 36.9334 62.2191C36.9341 62.2191 36.935 62.2191 36.936 62.2191C37.0405 62.2194 37.1697 62.2428 37.344 62.2768C37.3454 62.2772 37.3467 62.2775 37.348 62.2778C37.3624 62.2805 37.3772 62.2835 37.3922 62.2865C37.5315 62.3135 37.663 62.3702 37.7978 62.4133C37.6543 62.8317 37.5084 63.2494 37.3671 63.6689C37.242 64.0399 36.9996 64.2418 36.689 64.3515C36.2336 64.4026 36.0622 64.7987 35.9126 65.2214H35.9119C35.6803 65.2554 35.5659 65.3285 35.5656 65.4393C35.5652 65.519 35.6238 65.6181 35.7399 65.7362C35.6221 66.0759 35.504 66.4156 35.3855 66.7553C35.1887 66.8804 34.9919 67.0055 34.7951 67.1306L34.7931 67.1323Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M26.8034 62.7476C26.6317 62.6204 26.545 62.4402 26.5454 62.2057C26.5454 62.17 26.5477 62.1326 26.5517 62.0942C26.611 61.902 26.6722 61.7195 26.6719 61.562C26.6715 61.3718 26.5819 61.2184 26.2907 61.1293C26.1327 61.0812 26.0822 60.9791 26.0825 60.8543C26.0832 60.6775 26.1856 60.4543 26.2298 60.2707C26.6521 60.4109 27.0738 60.5514 27.4962 60.6915C27.6689 60.819 27.7556 61.0001 27.7559 61.2354C27.7559 61.2714 27.7539 61.3088 27.7499 61.3472C27.692 61.5197 27.6344 61.6922 27.5765 61.8644C27.3188 62.1586 27.0611 62.4529 26.8034 62.7476Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M24.967 63.7795C24.966 63.7795 24.965 63.7795 24.9639 63.7795C24.8461 63.7792 24.727 63.7582 24.6069 63.7282C24.6035 63.7272 24.6002 63.7262 24.5968 63.7255C24.5921 63.7241 24.5874 63.7232 24.5828 63.7218C24.9134 63.2694 25.38 62.9324 25.5265 62.3231C25.5299 62.3191 25.5332 62.3148 25.5366 62.3108C25.5389 62.3078 25.5413 62.3047 25.5436 62.3017C25.546 62.2991 25.548 62.2964 25.55 62.2941C25.7274 62.0792 25.9144 62.0081 26.1059 62.0068C26.1075 62.0068 26.1092 62.0068 26.1109 62.0068C26.1116 62.0068 26.1122 62.0068 26.1129 62.0068C26.2364 62.0071 26.3616 62.0361 26.4874 62.0742C26.4928 62.0758 26.4978 62.0775 26.5028 62.0789H26.5031C26.5031 62.0792 26.5035 62.0792 26.5038 62.0792C26.5065 62.0802 26.5095 62.0812 26.5125 62.0819C26.5256 62.0859 26.5386 62.0902 26.5517 62.0942C26.5477 62.1326 26.5453 62.1699 26.5453 62.2056C26.545 62.4402 26.6316 62.6204 26.8033 62.7475C26.7481 62.9124 26.6912 63.0765 26.6323 63.2403C26.626 63.2393 26.6199 63.238 26.6136 63.2367C26.4968 63.2143 26.38 63.197 26.2652 63.1963C26.2632 63.1963 26.2612 63.1963 26.2592 63.1963C26.2575 63.1963 26.2558 63.1963 26.2538 63.1963C26.0396 63.1973 25.8304 63.2584 25.6326 63.4586C25.6306 63.4606 25.629 63.4622 25.6269 63.4642C25.6199 63.4716 25.6126 63.4793 25.6055 63.4869C25.4047 63.7038 25.1936 63.7772 24.9774 63.7795C24.974 63.7795 24.9703 63.7795 24.967 63.7795Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M24.9773 58.3533C24.977 58.3533 24.9766 58.3533 24.9763 58.3533C24.9017 58.3533 24.8264 58.3503 24.7511 58.3459C24.6409 58.3396 24.5151 58.1461 24.4796 58.0016C24.4719 57.9709 24.4683 57.9322 24.4683 57.8908C24.4679 57.7554 24.5051 57.5869 24.5653 57.5435C24.825 57.3573 25.1165 57.2405 25.3957 57.097C25.6724 57.2031 25.9492 57.3096 26.226 57.4157C26.2243 57.421 26.223 57.4267 26.2213 57.4324C26.221 57.4334 26.2206 57.4347 26.2203 57.4357C25.993 58.2091 25.5068 58.3526 24.9803 58.3533C24.9793 58.3533 24.9783 58.3533 24.9773 58.3533Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M35.2265 64.4292C35.1459 64.3354 35.1087 64.2417 35.1084 64.1436C35.1084 64.0288 35.1586 63.9077 35.25 63.7722C35.4387 63.4926 35.5893 63.181 35.7563 62.883C35.8982 62.9267 36.0398 62.9711 36.181 63.0158C35.9581 63.5684 35.9046 64.2654 35.2265 64.4292Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M27.4962 60.6912C27.0738 60.551 26.6521 60.4105 26.2297 60.2704C26.2348 60.2634 26.2401 60.2567 26.2451 60.2501C26.4215 60.0218 26.6096 59.9484 26.803 59.9481C26.8037 59.9481 26.8047 59.9477 26.8054 59.9477C26.8064 59.9477 26.8077 59.9481 26.8087 59.9481C26.9265 59.9484 27.046 59.9755 27.1665 60.0108H27.1668C27.1919 60.0182 27.217 60.0258 27.2421 60.0338C27.3844 60.0812 27.5263 60.1286 27.6685 60.1763C27.611 60.3478 27.5537 60.5193 27.4962 60.6912Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M22.8225 59.125C22.8205 59.125 22.8185 59.125 22.8165 59.125C22.6742 59.078 22.5316 59.0309 22.3894 58.9839C22.5363 58.5581 22.7104 58.1647 23.1612 58.0973L23.1615 58.098C23.1575 58.1367 23.1551 58.1737 23.1551 58.2098C23.1548 58.4443 23.2405 58.6258 23.4132 58.7533C23.2663 58.9976 23.0732 59.121 22.8339 59.125C22.8302 59.125 22.8265 59.125 22.8225 59.125Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M24.3512 60.2087C24.3492 60.2087 24.3468 60.2087 24.3445 60.2087C24.4081 60.0462 24.4569 59.8747 24.5376 59.7229C24.5389 59.7202 24.5406 59.7176 24.5419 59.7152C24.545 59.7092 24.548 59.7036 24.551 59.6979C24.5543 59.6922 24.5573 59.6869 24.5604 59.6812C24.562 59.6782 24.5637 59.6755 24.565 59.6725C24.6206 59.5744 24.6634 59.5231 24.7069 59.5221C24.7076 59.5221 24.7079 59.5221 24.7083 59.5221C24.7106 59.5221 24.7133 59.5224 24.7156 59.5227C24.7672 59.529 24.8217 59.6055 24.9024 59.7573C24.9108 59.773 24.9191 59.7893 24.9282 59.8067C24.9292 59.8083 24.9302 59.8103 24.9312 59.8124C24.9342 59.8184 24.9375 59.8247 24.9405 59.831C24.9415 59.8327 24.9422 59.8344 24.9432 59.836C24.9392 59.8427 24.9352 59.8494 24.9312 59.8557C24.9275 59.8617 24.9235 59.8677 24.9198 59.8734C24.7749 60.095 24.5871 60.2067 24.3569 60.2087C24.3552 60.2087 24.3532 60.2087 24.3512 60.2087Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M29.0232 61.7727C28.9084 61.6596 28.8465 61.5622 28.8462 61.4824C28.8459 61.378 28.9499 61.3039 29.1779 61.2655C29.2796 61.4173 29.3368 61.5031 29.3368 61.5645C29.3365 61.6436 29.2411 61.6829 29.0232 61.7727Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M28.4485 59.2861C28.2691 59.1627 28.1807 58.9808 28.1814 58.7419C28.1814 58.7076 28.1834 58.6725 28.1871 58.6358C28.2741 58.8527 28.3611 59.0696 28.4485 59.2861Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M26.2759 57.397C26.2662 57.397 26.2561 57.3967 26.2461 57.3963C26.2478 57.393 26.2498 57.39 26.2518 57.387C26.3954 57.1507 26.5855 57.0386 26.8181 57.0369C26.8197 57.0369 26.8217 57.0369 26.8234 57.0369C26.8258 57.0369 26.8281 57.0369 26.8304 57.0369C26.8288 57.0393 26.8274 57.042 26.8261 57.0443C26.6869 57.2739 26.5068 57.395 26.2816 57.397C26.2796 57.397 26.2779 57.397 26.2759 57.397Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M25.3684 59.9802V59.9796C25.4618 59.9215 25.5551 59.8631 25.6485 59.8051C25.6204 59.8528 25.5997 59.9245 25.5632 59.9432C25.5036 59.9739 25.4337 59.9699 25.3684 59.9802Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M23.7594 60.5784C23.7543 60.5784 23.7496 60.5784 23.7446 60.5784C23.7496 60.5707 23.7543 60.5627 23.7594 60.5553C23.761 60.5523 23.763 60.5493 23.765 60.5467C23.7677 60.5427 23.7704 60.5386 23.7731 60.5346C23.7734 60.534 23.7737 60.5336 23.7741 60.5333C23.7771 60.5283 23.7804 60.5236 23.7838 60.519C23.9284 60.3144 24.1111 60.211 24.3323 60.2093C24.3343 60.2093 24.3363 60.2093 24.3383 60.2093C24.3403 60.2093 24.3424 60.2093 24.3444 60.2093C24.3427 60.212 24.341 60.2147 24.3394 60.2173C24.3363 60.2223 24.3333 60.2273 24.33 60.2324C24.1857 60.4586 23.9993 60.5747 23.7707 60.5784C23.767 60.5784 23.763 60.5784 23.7594 60.5784Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M27.5764 61.8643C27.6343 61.6921 27.6919 61.5196 27.7498 61.3471C27.8649 61.4645 27.9228 61.5633 27.9231 61.6427C27.9231 61.7548 27.8077 61.8289 27.5764 61.8643Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M28.1875 58.635C28.0189 58.5099 27.9332 58.3344 27.9338 58.1068C27.9338 58.0648 27.9368 58.0207 27.9429 57.975C28.0245 58.1952 28.1062 58.4151 28.1875 58.635Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M27.6683 60.1768C27.5261 60.129 27.3842 60.0816 27.2419 60.0343C27.2516 60.0259 27.261 60.0176 27.2701 60.0096C27.2717 60.0079 27.2734 60.0062 27.2751 60.0049C27.2761 60.0039 27.2771 60.0032 27.2781 60.0022C27.2841 59.9969 27.2901 59.9916 27.2962 59.9866C27.3079 59.9759 27.3196 59.9659 27.3306 59.9562C27.347 59.9418 27.3624 59.9288 27.3768 59.9165C27.3785 59.9151 27.3805 59.9135 27.3822 59.9121C27.3848 59.9098 27.3878 59.9075 27.3905 59.9051C27.3979 59.8991 27.4049 59.8935 27.4116 59.8881C27.4632 59.8478 27.5003 59.8257 27.5294 59.8237C27.5308 59.8237 27.5321 59.8237 27.5334 59.8237C27.5338 59.8237 27.5338 59.8237 27.5341 59.8237C27.5974 59.8244 27.6195 59.9285 27.6643 60.1567C27.6653 60.1607 27.666 60.1651 27.6666 60.1694C27.6673 60.1717 27.6677 60.1741 27.6683 60.1768Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M23.5848 58.2405C23.4439 58.1924 23.3027 58.1454 23.1615 58.0983L23.1611 58.0977C23.2197 57.9262 23.2783 57.7553 23.3368 57.5838C23.5069 57.7116 23.5915 57.8911 23.5915 58.1227C23.5915 58.1604 23.5892 58.1998 23.5848 58.2405Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M23.4131 58.7534C23.2404 58.626 23.1547 58.4444 23.155 58.2099C23.155 58.1738 23.1574 58.1368 23.1614 58.0981C23.3026 58.1452 23.4439 58.1922 23.5848 58.2402C23.5285 58.4114 23.4713 58.5826 23.4131 58.7534Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M20.9392 59.071C20.9395 59.0707 20.9395 59.0704 20.9398 59.0701C20.9402 59.0704 20.9408 59.0704 20.9412 59.0707L20.9392 59.071ZM20.9398 59.0701C20.5037 58.9219 20.1791 58.65 20.0794 58.0951C20.0707 58.0477 20.0667 58 20.0667 57.9523C20.066 57.6059 20.2842 57.2609 20.6604 57.0641C20.7765 57.0033 20.891 56.974 20.9977 56.9736C20.9984 56.9736 20.9994 56.9736 21.0001 56.9736C21.0021 56.9736 21.0041 56.9736 21.0061 56.9736C21.2524 56.9763 21.4566 57.1325 21.5432 57.4074C21.5462 57.4171 21.5493 57.4268 21.5519 57.4368C21.5754 57.5215 21.5874 57.6033 21.5874 57.6833C21.5868 57.8418 21.5389 57.9943 21.4375 58.1558C21.2544 58.4471 21.1041 58.7641 20.9398 59.0701Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M30.0829 52.9663C29.9426 52.9263 29.8034 52.8833 29.6655 52.8372C29.8121 52.4115 29.9871 52.019 30.4376 51.9513C30.4376 51.9516 30.4373 51.952 30.4373 51.9523C30.3191 52.2903 30.201 52.6283 30.0829 52.9663Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M29.8193 55.175C29.7058 54.9064 29.6383 54.746 29.6389 54.6268C29.6399 54.45 29.7915 54.3643 30.168 54.1514C30.0519 54.4927 29.9354 54.834 29.8193 55.175Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M29.3033 56.7158C29.1617 56.6731 29.0211 56.6271 28.8816 56.577C28.8812 56.4706 28.8705 56.3625 28.8709 56.2561C28.8709 56.188 28.8756 56.1206 28.8899 56.0548C28.9197 55.9207 29.0298 55.7999 29.1044 55.6731C29.2062 55.7629 29.3866 55.8353 29.3933 55.9454C29.395 55.9704 29.3956 55.9958 29.3956 56.0212C29.3953 56.2464 29.3351 56.4843 29.3033 56.7158Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M31.2694 74.6296C31.158 74.5539 31.0268 74.5139 30.9655 74.4124C30.8467 74.2149 30.7674 73.9827 30.671 73.7651C31.2145 72.987 31.7771 72.2239 32.2835 71.4168C32.3126 71.3704 32.3247 71.3027 32.3244 71.2253C32.3244 71.0554 32.2648 70.8399 32.1971 70.7084C32.1951 70.7044 32.1931 70.7008 32.1911 70.6971C32.1898 70.6948 32.1885 70.6924 32.1871 70.6901C32.1372 70.603 32.0757 70.5676 32.0077 70.5666C32.0067 70.5666 32.0054 70.5666 32.0044 70.5666C32.0034 70.5666 32.0027 70.5666 32.0017 70.5666C31.8953 70.568 31.7748 70.6517 31.6627 70.7515C31.6607 70.7535 31.6583 70.7555 31.6563 70.7571C31.6523 70.7608 31.6483 70.7645 31.6446 70.7678C30.9793 71.3748 30.6523 72.1906 30.4859 73.0741C30.4813 73.0978 30.4792 73.1218 30.4792 73.1465C30.4786 73.3447 30.6115 73.5596 30.671 73.7655C30.6684 73.7685 30.6657 73.7715 30.6627 73.7748C30.4555 74.0037 30.2574 74.0794 30.0643 74.0801C30.0636 74.0801 30.0626 74.0801 30.0619 74.0801C30.0596 74.0801 30.0576 74.0801 30.0552 74.0801C29.8239 74.0781 29.5994 73.97 29.3731 73.8893C29.332 73.8746 29.2905 73.8609 29.249 73.8489C29.243 73.8472 29.2369 73.8455 29.2309 73.8439C29.2299 73.8435 29.2293 73.8432 29.2286 73.8432C29.2246 73.8422 29.2205 73.8409 29.2165 73.8399C29.1881 73.4134 29.1573 72.9877 29.1318 72.5606C29.0994 72.0164 28.9133 71.5973 28.5027 71.3454C28.3403 71.246 28.1465 71.1379 28.1472 70.957C28.1476 70.8689 28.1941 70.7631 28.3135 70.6327C28.3189 70.6267 28.3243 70.621 28.3296 70.6153C28.3326 70.612 28.3356 70.609 28.3386 70.606C28.341 70.604 28.343 70.6017 28.3453 70.5997C28.4715 70.4755 28.6141 70.4165 28.7577 70.4155C28.759 70.4155 28.7603 70.4155 28.7613 70.4155C28.762 70.4155 28.7627 70.4155 28.7634 70.4155C28.8802 70.4158 28.9976 70.4545 29.1071 70.5282C29.1178 70.5352 29.1282 70.5426 29.1385 70.5503C29.1419 70.5526 29.1449 70.5553 29.1482 70.5576C29.163 70.5693 29.1774 70.5816 29.1914 70.595C29.1968 70.6 29.2018 70.6047 29.2068 70.6097C29.2095 70.6127 29.2125 70.6153 29.2152 70.6183C29.3618 70.7685 29.4739 70.9854 29.6964 70.9884C29.6978 70.9884 29.6995 70.9884 29.7008 70.9884C29.7015 70.9884 29.7018 70.9884 29.7025 70.9884C29.745 70.9884 29.7918 70.9804 29.8437 70.9627C30.0167 70.604 30.1178 70.243 30.1168 69.8796C30.1161 69.6894 30.0874 69.4986 30.0264 69.307C29.8805 69.3274 29.7192 69.3034 29.592 69.3764C29.587 69.3791 29.5823 69.3818 29.5773 69.3845C29.575 69.3858 29.5723 69.3875 29.5699 69.3888C29.4374 69.4615 29.3283 69.4972 29.2383 69.4989C29.2359 69.4989 29.2336 69.4989 29.2316 69.4989C29.2306 69.4989 29.2299 69.4989 29.2289 69.4989C29.009 69.4972 28.9076 69.2873 28.8695 68.921C28.8537 68.7702 28.7279 68.649 28.6513 68.5146C28.6516 68.5146 28.6516 68.5146 28.6516 68.5146L28.6502 68.5126L28.6516 68.5146C28.6251 68.1225 28.599 67.7305 28.5729 67.3381C28.5736 67.3371 28.5746 67.3361 28.5753 67.3351C28.5763 67.3338 28.5773 67.3324 28.5786 67.3311C28.584 67.3241 28.5893 67.3174 28.5947 67.311C28.5947 67.3107 28.595 67.3104 28.595 67.3104C28.6911 67.1933 28.7834 67.1269 28.8748 67.1255C28.8755 67.1255 28.8762 67.1255 28.8772 67.1255C28.8778 67.1255 28.8782 67.1255 28.8788 67.1255C28.9538 67.1262 29.0277 67.1716 29.1014 67.2697C29.1034 67.2727 29.1057 67.2754 29.1078 67.278C29.1094 67.2804 29.1111 67.283 29.1131 67.2857C29.1148 67.2877 29.1161 67.29 29.1178 67.2924C29.2041 67.4172 29.3146 67.5193 29.414 67.632C29.4775 67.9707 29.6298 68.2196 29.9143 68.3427C29.9515 68.3587 29.9889 68.3748 30.0261 68.3905C30.0472 68.3991 30.0679 68.4078 30.0887 68.4165C30.0907 68.4171 30.0927 68.4181 30.0947 68.4188C31.0573 68.8152 32.0546 69.0585 33.1085 69.0591C33.1098 69.0591 33.1115 69.0591 33.1128 69.0591C33.1132 69.0591 33.1135 69.0591 33.1139 69.0591C33.2832 69.0591 33.4539 69.0528 33.6259 69.0398C33.647 69.0384 33.6684 69.0364 33.6895 69.0348C33.7116 69.0374 33.7333 69.0384 33.7547 69.0384C33.7551 69.0384 33.7554 69.0384 33.7554 69.0384C33.7571 69.0384 33.7588 69.0384 33.7604 69.0384C33.9656 69.0368 34.1313 68.9223 34.2641 68.7148C34.2685 68.7081 34.2732 68.7011 34.2775 68.6938C34.4208 68.7311 34.563 68.7725 34.7039 68.8182L34.7052 68.8189C34.656 69.0615 34.562 69.3114 34.5617 69.5463C34.5613 69.5536 34.5617 69.5613 34.5617 69.5686C34.5737 70.0748 34.7086 70.2967 35.0135 70.2984C35.0145 70.2984 35.0158 70.2984 35.0168 70.2984C35.0178 70.2984 35.0185 70.2984 35.0192 70.2984C35.1132 70.298 35.2226 70.2773 35.3495 70.2376C35.3562 70.2356 35.3629 70.2333 35.3696 70.2313C35.6527 70.1395 35.9402 69.993 36.219 69.9787C36.2334 69.978 36.2478 69.9777 36.2618 69.9777C36.2625 69.9777 36.2635 69.9777 36.2645 69.9777C36.639 69.979 36.8699 70.2416 36.9238 70.6937C36.6263 71.0594 36.2354 71.4018 36.2364 71.8329C36.2367 72.0164 36.3084 72.2162 36.4884 72.4411C36.5246 72.4865 36.543 72.5819 36.543 72.6787C36.543 72.7725 36.5256 72.8676 36.4911 72.9193C36.2531 73.2743 35.9881 73.6176 35.6949 73.9116C35.6939 73.9126 35.6929 73.9136 35.6915 73.9146C35.6892 73.9173 35.6865 73.9196 35.6842 73.9223C35.553 74.0481 35.4101 74.0858 35.2648 74.0861C35.2641 74.0861 35.2635 74.0861 35.2628 74.0861C35.2608 74.0861 35.2585 74.0861 35.2561 74.0861C35.1423 74.0851 35.0269 74.0621 34.9134 74.0404C34.901 74.0381 34.8886 74.0357 34.8759 74.0334C34.8702 74.0324 34.8645 74.0314 34.8588 74.0304C34.8565 74.0297 34.8542 74.0294 34.8518 74.029C34.8508 74.0287 34.8501 74.0287 34.8491 74.0284C34.8428 74.0274 34.8364 74.0264 34.8301 74.0251C34.7022 73.9747 34.5714 73.9333 34.4375 73.9016C34.4234 73.9056 34.409 73.9093 34.395 73.9129C34.39 73.9139 34.3853 73.9153 34.3806 73.9166C34.3742 73.9183 34.3679 73.9196 34.3619 73.9213C34.3595 73.922 34.3575 73.9223 34.3552 73.9229C34.1018 73.9863 33.8568 74.0291 33.6279 74.0294C33.6272 74.0294 33.6266 74.0294 33.6256 74.0294C33.6236 74.0294 33.6215 74.0294 33.6195 74.0294C33.1055 74.0277 32.6741 73.8105 32.417 73.1345C32.4154 73.1298 32.4134 73.1252 32.4117 73.1205C32.408 73.1108 32.4046 73.1011 32.401 73.0911C32.399 73.0858 32.3969 73.0804 32.3953 73.0751C32.3722 73.0104 32.2865 72.9693 32.2203 72.9473C32.2162 72.946 32.2122 72.945 32.2082 72.944C32.2062 72.9436 32.2042 72.9433 32.2022 72.943C32.1948 72.9416 32.1868 72.9413 32.1784 72.941C32.1781 72.941 32.1774 72.941 32.1771 72.941C32.1366 72.941 32.0864 72.9527 32.0141 72.963C32.0067 72.964 31.999 72.965 31.9913 72.966C31.9813 72.9673 31.9709 72.9683 31.9602 72.9697C31.7396 73.4998 31.505 74.0637 31.2694 74.6296Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M27.5595 67.5188C27.5585 67.5188 27.5575 67.5188 27.5561 67.5188C27.4286 67.5181 27.2984 67.4874 27.1683 67.4484C27.1636 67.447 27.1592 67.4457 27.1549 67.4444C27.1448 67.4414 27.1348 67.4384 27.1248 67.4351C27.3855 67.1378 27.6378 66.8285 27.9126 66.5508C27.9133 66.5502 27.9136 66.5498 27.9143 66.5492C27.9166 66.5471 27.9186 66.5452 27.921 66.5432C27.9558 66.5145 28.007 66.5055 28.0622 66.5051C28.0632 66.5051 28.0639 66.5051 28.0649 66.5051C28.0699 66.5051 28.0752 66.5051 28.0803 66.5051C28.1027 66.5058 28.1251 66.5078 28.1472 66.5101C28.1743 66.5131 28.2007 66.5168 28.2248 66.5201C28.2449 66.5231 28.261 66.6072 28.261 66.6773C28.261 66.696 28.26 66.7136 28.2576 66.7287C28.2305 66.8885 28.183 67.0463 28.1435 67.2051C28.1422 67.2068 28.1408 67.2088 28.1395 67.2105C28.1348 67.2162 28.1305 67.2218 28.1258 67.2272C28.1238 67.2298 28.1214 67.2328 28.1191 67.2355C27.9424 67.4477 27.7559 67.5178 27.5645 67.5188C27.5628 67.5188 27.5612 67.5188 27.5595 67.5188Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M28.6879 78.2515C28.546 78.2044 28.4041 78.1577 28.2622 78.1106C28.3275 77.9568 28.371 77.7803 28.4667 77.6569C28.528 77.5778 28.6662 77.5701 28.7706 77.5514C28.776 77.5514 28.7867 77.5818 28.7954 77.6218C28.796 77.6255 28.797 77.6295 28.7977 77.6332C28.7984 77.6368 28.799 77.6408 28.7997 77.6448C28.8004 77.6482 28.801 77.6512 28.8017 77.6545C28.8024 77.6592 28.8031 77.6635 28.8037 77.6682C28.8068 77.6896 28.8087 77.7112 28.8087 77.7309C28.8087 77.7396 28.8084 77.7483 28.8078 77.756C28.8074 77.759 28.8071 77.762 28.8064 77.7646C28.7793 77.9278 28.7294 78.0886 28.6886 78.2505C28.6883 78.2505 28.6883 78.2501 28.6879 78.2501C28.6879 78.2505 28.6879 78.2511 28.6879 78.2515Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M26.4429 68.5002C26.4352 68.5002 26.4124 68.4228 26.4061 68.3534C26.4047 68.3414 26.4041 68.3294 26.4041 68.3184C26.4041 68.3067 26.4047 68.296 26.4064 68.2867C26.4342 68.1229 26.4857 67.9617 26.5272 67.7989C26.6651 67.8479 26.8043 67.8923 26.9452 67.9323C26.8816 68.0878 26.8408 68.2653 26.7468 68.3905C26.6865 68.4702 26.5476 68.4796 26.4429 68.5002Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M28.3699 68.6882C28.3977 68.6399 28.419 68.5674 28.4559 68.5491C28.5141 68.5197 28.5821 68.5241 28.646 68.515C28.5539 68.5728 28.4616 68.6305 28.3699 68.6882ZM28.646 68.515C28.6477 68.5144 28.649 68.5134 28.6503 68.5124L28.6517 68.5144C28.6517 68.5144 28.6517 68.5144 28.6513 68.5144C28.6497 68.5147 28.648 68.515 28.646 68.515Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M30.8336 76.1052C30.6566 75.9791 30.5699 75.7959 30.5706 75.5577C30.5706 75.5236 30.5722 75.4883 30.5759 75.4522C30.7543 75.5774 30.8393 75.7612 30.839 75.9998C30.8386 76.0338 30.837 76.0689 30.8336 76.1052Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M28.8219 78.6038C28.8213 78.6038 28.8206 78.6038 28.8196 78.6038C28.7563 78.6011 28.7349 78.4913 28.6877 78.2517C28.6877 78.2514 28.6877 78.2507 28.6877 78.2504C28.6881 78.2504 28.6881 78.2507 28.6884 78.2507C28.8293 78.2978 28.9699 78.3455 29.1101 78.3942C29.1091 78.3952 29.1077 78.3962 29.1067 78.3976C29.0997 78.4036 29.093 78.4096 29.0867 78.4152C29.0853 78.4166 29.084 78.4179 29.0823 78.4189C29.079 78.4222 29.0753 78.4253 29.0719 78.4283C29.0703 78.4299 29.0689 78.4309 29.0676 78.4322C29.0666 78.4332 29.0656 78.4342 29.0646 78.4349C29.0636 78.4359 29.0626 78.4366 29.0616 78.4376C29.0602 78.4386 29.0589 78.4399 29.0576 78.4413C29.0542 78.4443 29.0509 78.4473 29.0475 78.4499C29.0221 78.4726 28.9987 78.493 28.9776 78.5107C28.9739 78.514 28.9702 78.517 28.9665 78.52C28.911 78.5661 28.8701 78.5941 28.8387 78.6017C28.8327 78.6031 28.8273 78.6038 28.8219 78.6038Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M29.582 75.6714C29.5817 75.6714 29.5813 75.6714 29.5813 75.6714C29.5706 75.6714 29.5603 75.671 29.5496 75.6704C29.5542 75.663 29.5589 75.6557 29.5636 75.6487C29.5683 75.642 29.5727 75.6353 29.5773 75.6287C29.58 75.625 29.5827 75.6213 29.5853 75.6173C29.7283 75.4178 29.9053 75.3127 30.1205 75.311C30.1225 75.311 30.1242 75.311 30.1262 75.311C30.1262 75.311 30.1265 75.311 30.1269 75.311C30.1306 75.311 30.1346 75.311 30.1386 75.311C30.1389 75.311 30.1389 75.311 30.1393 75.311C30.1436 75.311 30.148 75.3114 30.1523 75.3114C30.1506 75.314 30.1493 75.3164 30.1476 75.3187C30.1399 75.331 30.1322 75.3427 30.1245 75.3544C29.9826 75.5623 29.8039 75.6694 29.5874 75.6714C29.5857 75.6714 29.5837 75.6714 29.582 75.6714Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M28.6202 81.9285C28.5818 81.9014 28.5214 81.8854 28.5094 81.8444C28.5011 81.8154 28.4987 81.783 28.4991 81.7496C28.4991 81.7089 28.5024 81.6669 28.5024 81.6262C28.5024 81.6255 28.5024 81.6249 28.5024 81.6245C28.5421 81.7256 28.5811 81.827 28.6202 81.9285ZM28.5024 81.6245C28.5017 81.6229 28.5014 81.6215 28.5007 81.6198L28.5024 81.6192C28.5024 81.6208 28.5024 81.6225 28.5024 81.6245Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M42.4478 50.9639C42.3156 50.8484 42.2688 50.7216 42.2688 50.5958C42.2685 50.412 42.3682 50.2301 42.4465 50.0886C42.6962 49.6379 43.0248 49.2398 43.321 48.8201L43.323 48.8171C43.3625 49.0003 43.4723 49.2301 43.4726 49.3866C43.4726 49.4247 43.4663 49.4584 43.4509 49.4857C43.1607 50.0049 42.7919 50.4707 42.4478 50.9639Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M44.0838 65.0222C44.0825 65.0222 44.0811 65.0222 44.0798 65.0222C43.9221 65.0215 43.7645 64.9848 43.6089 64.9335C43.6022 64.9311 43.5955 64.9288 43.5888 64.9268C43.7247 64.5124 43.9017 64.095 43.9004 63.6835C43.8997 63.4356 43.8345 63.1904 43.6568 62.9492C43.3288 63.118 42.9911 63.2922 42.6534 63.4663C42.7551 63.0946 42.7903 62.7343 42.7903 62.3803C42.7906 61.7159 42.6675 61.0746 42.6273 60.425C42.6146 60.4243 42.6022 60.4236 42.5901 60.4236C42.5898 60.4236 42.5898 60.4236 42.5898 60.4236C42.5888 60.4236 42.5881 60.4237 42.5875 60.424C42.3067 60.425 42.2106 60.6295 42.148 60.8514C42.1474 60.8527 42.147 60.8544 42.1467 60.8557C42.1453 60.8607 42.144 60.8658 42.1427 60.8708C42.055 61.1897 42.0429 61.7346 41.9044 61.7967C41.9017 61.798 41.8987 61.799 41.896 61.8004C41.8947 61.801 41.8937 61.8014 41.8923 61.802C41.8264 61.8301 41.7688 61.8427 41.718 61.843C41.7173 61.843 41.717 61.843 41.7166 61.843C41.716 61.843 41.7153 61.843 41.7146 61.843C41.4204 61.8414 41.3525 61.4196 41.2015 61.1564C41.2005 61.1544 41.1992 61.1527 41.1982 61.1507C41.1949 61.1447 41.1912 61.1387 41.1875 61.133C41.0657 60.9352 40.9218 60.7563 40.7879 60.5691L40.7932 60.5641C40.8635 60.3462 40.9234 60.131 40.9238 59.9295C40.9241 59.7336 40.8685 59.5508 40.7119 59.3906C40.7143 59.3866 40.7163 59.3823 40.7186 59.3783C40.7193 59.3766 40.7203 59.3746 40.7213 59.373C40.7236 59.3686 40.7257 59.3643 40.728 59.3599C40.733 59.3502 40.738 59.3409 40.7427 59.3316C41.0432 58.7563 41.1276 58.6155 41.4727 58.6152C41.4733 58.6152 41.474 58.6152 41.4746 58.6152C41.4753 58.6152 41.476 58.6152 41.4763 58.6152C41.5627 58.6152 41.6654 58.6239 41.7913 58.6365C41.8026 58.6379 41.8137 58.6389 41.8254 58.6402C41.8301 58.6406 41.8348 58.6412 41.8395 58.6416C41.8626 58.6439 41.8863 58.6466 41.9107 58.6492L41.9087 58.6529C41.9101 58.6592 41.9114 58.6656 41.9127 58.6719C41.9147 58.6816 41.9164 58.6909 41.9184 58.7C41.9191 58.703 41.9198 58.7056 41.9201 58.7083C41.9626 58.9098 41.987 59.0029 42.0453 59.0046C42.0456 59.0046 42.0463 59.0046 42.0466 59.0046C42.0503 59.0046 42.054 59.0042 42.0577 59.0036C42.1005 58.9962 42.1608 58.9472 42.2548 58.8618C42.2591 58.8574 42.2638 58.8531 42.2689 58.8488C42.2755 58.8428 42.2822 58.8364 42.2892 58.8301C42.2976 58.8224 42.3063 58.8144 42.315 58.806C42.3201 58.8017 42.3251 58.7967 42.3304 58.792C42.3324 58.79 42.3348 58.788 42.3371 58.7857C42.4087 58.5678 42.4686 58.3523 42.4686 58.1501C42.4683 57.9569 42.4134 57.776 42.2608 57.6165C42.2417 57.5057 42.2323 57.398 42.2323 57.2932C42.232 56.8281 42.4181 56.425 42.7772 56.0797V56.079C43.0573 56.1751 43.3378 56.2709 43.6179 56.3666C43.6159 56.394 43.6152 56.4213 43.6152 56.4487C43.6149 56.6956 43.6788 56.9482 43.6792 57.1951C43.6798 57.4223 43.6263 57.6449 43.4198 57.8534C43.136 58.1397 42.9757 58.4547 42.9763 58.777C42.9767 58.9348 43.0155 59.094 43.0972 59.2525C43.309 59.6636 43.0101 60.4567 43.5403 60.5307C43.544 60.5311 43.5476 60.5317 43.551 60.5321C43.5533 60.5324 43.5557 60.5328 43.5577 60.5331C43.5804 60.5354 43.6019 60.5368 43.6223 60.5368C43.6226 60.5368 43.6226 60.5368 43.623 60.5368C43.6233 60.5368 43.624 60.5368 43.6243 60.5368C44.1548 60.5351 43.976 59.7003 44.3067 59.396C44.308 59.3946 44.309 59.3933 44.3104 59.3923C44.4335 59.2815 44.5302 59.1277 44.639 58.9936C44.8395 58.8708 45.0403 58.748 45.2411 58.6252C45.381 58.6726 45.5206 58.7193 45.6608 58.7654C45.6564 58.8041 45.6541 58.8411 45.6541 58.8768C45.6534 59.11 45.7431 59.2859 45.9172 59.407C46.0547 59.4594 46.1926 59.5098 46.3308 59.5591C46.2739 59.7313 46.2174 59.9035 46.1601 60.0756C46.1541 60.0746 46.1484 60.0733 46.1427 60.0723C46.1327 60.0706 46.1226 60.0686 46.1129 60.0666C46.1109 60.0663 46.1089 60.066 46.1069 60.0656C45.9861 60.0419 45.8623 60.0129 45.7411 60.0126C45.7398 60.0126 45.7388 60.0126 45.7378 60.0126C45.7364 60.0126 45.7354 60.0126 45.7341 60.0126C45.5899 60.0133 45.4493 60.0553 45.3231 60.1958C45.3218 60.1974 45.3201 60.1991 45.3188 60.2011C45.3181 60.2018 45.3174 60.2024 45.3167 60.2031C45.3157 60.2044 45.3144 60.2058 45.3131 60.2074C45.3094 60.2118 45.3057 60.2161 45.302 60.2204C45.0654 60.5084 44.8914 60.8528 44.8907 61.2291C44.8904 61.2945 44.8957 61.3609 44.9068 61.4283C44.9175 61.496 45.0467 61.5735 45.1481 61.5888C45.1594 61.5905 45.1708 61.5915 45.1815 61.5915C45.1819 61.5915 45.1822 61.5915 45.1825 61.5915C45.2003 61.5911 45.2164 61.5885 45.2297 61.5825C45.8315 61.3172 45.9587 60.6642 46.1605 60.0773C46.3609 59.9512 46.5618 59.8251 46.7622 59.6986C46.7652 59.6956 46.7679 59.6923 46.7706 59.6892C46.7753 59.6842 46.7796 59.6793 46.784 59.6746C46.8783 59.5728 46.9677 59.5254 47.0578 59.5238C47.0591 59.5238 47.0608 59.5238 47.0624 59.5238C47.0638 59.5238 47.0651 59.5238 47.0664 59.5238C47.1458 59.5251 47.2258 59.5618 47.3098 59.6285C47.3168 59.6342 47.3241 59.6402 47.3315 59.6465C47.5534 59.8347 47.8048 59.9786 48.0434 60.1417C47.9597 60.3953 47.9045 60.6439 47.9038 60.8934C47.9035 61.0383 47.9215 61.1834 47.9634 61.3302C48.0675 61.6969 48.1237 62.088 48.201 62.468C48.0551 62.4203 47.9088 62.3726 47.7629 62.3249C47.5464 62.4083 47.3185 62.461 47.117 62.5838C46.9784 62.6682 46.9085 62.7837 46.9091 62.9001C46.9098 62.9935 46.9557 63.088 47.0477 63.168C47.1552 63.2615 47.3054 63.2925 47.4376 63.3499C47.2572 63.7379 47.2247 64.2088 46.8757 64.5057C46.2187 64.3806 46.4098 63.3436 45.8158 63.156C45.617 63.2948 45.4242 63.5031 45.217 63.5578C44.8803 63.6462 44.7398 63.7887 44.7394 64.0015C44.7391 64.119 44.7816 64.2578 44.8576 64.4206C44.8609 64.428 44.8626 64.4376 44.8626 64.4493C44.8616 64.5421 44.7505 64.7516 44.6611 64.8207C44.6584 64.8227 44.6558 64.8247 44.6531 64.827C44.6514 64.8284 44.6498 64.8297 44.6477 64.831C44.6454 64.8327 44.643 64.8344 44.6404 64.8364C44.6394 64.8374 44.638 64.838 44.6367 64.839C44.455 64.9718 44.2702 65.0219 44.0861 65.0222C44.0855 65.0222 44.0845 65.0222 44.0838 65.0222ZM45.2411 58.6252C45.0403 58.748 44.8395 58.8708 44.639 58.9936C44.8395 58.8708 45.0403 58.748 45.2411 58.6252Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M43.6227 60.5369C43.6223 60.5369 43.6223 60.5369 43.622 60.5369C43.6016 60.5369 43.5802 60.5355 43.5574 60.5332C43.5554 60.5328 43.5531 60.5325 43.5507 60.5322C43.5474 60.5318 43.5437 60.5312 43.54 60.5308C43.0099 60.4568 43.3088 59.6637 43.0969 59.2526C43.0152 59.0941 42.9764 58.9349 42.9761 58.7771C42.9754 58.4548 43.1357 58.1398 43.4195 57.8535C43.626 57.645 43.6796 57.4224 43.6789 57.1952C43.6786 56.9483 43.6146 56.6957 43.615 56.4488C43.615 56.4214 43.6156 56.3941 43.6177 56.3667C43.9881 55.5799 44.3586 54.7935 44.704 54.0598C44.7124 54.0558 44.7204 54.0514 44.7288 54.0474C44.7291 54.0474 44.7291 54.0471 44.7294 54.0471C45.0788 53.8722 45.3991 53.7885 45.6953 53.7882C45.696 53.7882 45.697 53.7882 45.6977 53.7882C45.6987 53.7882 45.6997 53.7882 45.7007 53.7882C46.194 53.7892 46.6207 54.0214 47.0073 54.4502C47.0079 54.4508 47.0086 54.4515 47.0089 54.4521C47.0284 54.4718 47.0635 54.4808 47.1057 54.4815C47.107 54.4815 47.1087 54.4815 47.11 54.4815C47.116 54.4815 47.1224 54.4815 47.1291 54.4808C47.1438 54.4802 47.1589 54.4785 47.1746 54.4762C47.1756 54.4758 47.1766 54.4758 47.1776 54.4755C47.2556 54.4628 47.3406 54.4298 47.3932 54.3867C47.3938 54.3861 47.3945 54.3858 47.3952 54.3851C47.4005 54.3804 47.4055 54.3761 47.4102 54.3714C47.4972 54.2823 47.5625 54.0895 47.5628 53.9467C47.5628 53.9293 47.5618 53.9126 47.5598 53.8969C47.5287 53.65 47.4798 53.3387 47.3319 53.2096C47.1365 53.0387 47.0628 52.8789 47.0625 52.7248C47.0618 52.4502 47.2948 52.1936 47.4882 51.926C47.6904 51.8122 47.8918 51.6984 48.094 51.5843C48.3761 51.6704 48.6582 51.7561 48.94 51.8422C49.0766 51.8926 49.2148 51.9377 49.3544 51.977C49.7014 51.8526 50.0475 51.7228 50.3956 51.605C50.4347 51.5916 50.4728 51.5853 50.5083 51.5853C50.5087 51.5853 50.5094 51.5853 50.51 51.5853C50.512 51.5853 50.514 51.5853 50.5164 51.5853C50.6907 51.589 50.8069 51.7425 50.7587 51.955C50.758 51.9577 50.7574 51.9603 50.7567 51.9633C50.6764 52.289 50.5619 52.608 50.4621 52.93C50.3544 53.0621 50.2325 53.1835 50.1415 53.329C49.9153 53.69 49.6087 54.0401 49.5046 54.4338C49.5036 54.4378 49.5026 54.4415 49.5016 54.4455C49.501 54.4475 49.5003 54.4495 49.4999 54.4515C49.4986 54.4562 49.4973 54.4608 49.4959 54.4655C49.4959 54.4655 49.4959 54.4658 49.4956 54.4658C49.4919 54.4795 49.4876 54.4929 49.4836 54.5059C49.4836 54.5059 49.4832 54.5059 49.4832 54.5062C49.4822 54.5092 49.4812 54.5122 49.4802 54.5152C49.4802 54.5159 49.4802 54.5162 49.4799 54.5165C49.4795 54.5175 49.4792 54.5189 49.4789 54.5202C49.4785 54.5209 49.4782 54.5219 49.4778 54.5229C49.4775 54.5236 49.4772 54.5242 49.4772 54.5249C49.4769 54.5255 49.4765 54.5265 49.4762 54.5272C49.4758 54.5279 49.4759 54.5289 49.4755 54.5296C49.4752 54.5299 49.4752 54.5306 49.4748 54.5312C49.4745 54.5322 49.4742 54.5332 49.4739 54.5342C49.4735 54.5346 49.4735 54.5349 49.4735 54.5352C49.4728 54.5366 49.4725 54.5376 49.4722 54.5389C49.4718 54.5392 49.4718 54.5396 49.4718 54.5403C49.4712 54.5413 49.4708 54.5422 49.4705 54.5432C49.4702 54.5442 49.4698 54.5449 49.4695 54.5456C49.4695 54.5462 49.4692 54.5472 49.4688 54.5479C49.4685 54.5489 49.4681 54.5496 49.4678 54.5503C49.4675 54.5509 49.4675 54.5516 49.4672 54.5522C49.4668 54.5536 49.4662 54.5549 49.4658 54.5562C49.4658 54.5562 49.4655 54.5566 49.4655 54.5569C49.4652 54.5576 49.4648 54.5586 49.4645 54.5596C49.4641 54.5602 49.4638 54.5606 49.4638 54.5613C49.4635 54.5623 49.4631 54.5629 49.4628 54.5636C49.4625 54.5642 49.4625 54.5649 49.4621 54.5656C49.4618 54.5666 49.4614 54.5676 49.4611 54.5686C49.4608 54.5689 49.4605 54.5696 49.4605 54.5699C49.4598 54.5713 49.4595 54.5726 49.4588 54.5739C49.4588 54.5743 49.4588 54.5743 49.4588 54.5743C49.4581 54.5753 49.4578 54.5766 49.4575 54.5776C49.4571 54.5779 49.4571 54.5783 49.4568 54.5786C49.4558 54.5813 49.4544 54.5843 49.4534 54.5869C49.4524 54.5896 49.4511 54.5923 49.4501 54.595C49.4501 54.5953 49.4497 54.5953 49.4497 54.5953C49.4474 54.601 49.4451 54.6063 49.4427 54.6116C49.439 54.6197 49.4353 54.6273 49.4317 54.6346V54.635C49.2991 54.9023 49.0983 54.9186 48.9009 54.9186C48.8875 54.9186 48.8741 54.9183 48.8607 54.9183C48.8477 54.9183 48.8349 54.9183 48.8222 54.9183C48.7476 54.9183 48.6746 54.9206 48.608 54.938C48.608 54.9383 48.6077 54.9383 48.6077 54.9383C48.6067 54.9383 48.606 54.9386 48.605 54.939C48.6047 54.939 48.6047 54.939 48.6044 54.939C48.6037 54.9393 48.603 54.9396 48.602 54.9396C48.602 54.9396 48.6017 54.94 48.6013 54.94C48.6007 54.9403 48.6 54.9403 48.5993 54.9406C48.599 54.9406 48.5983 54.9406 48.598 54.941C48.5973 54.941 48.597 54.9413 48.5963 54.9413C48.596 54.9416 48.5953 54.9416 48.595 54.9416C48.5943 54.942 48.594 54.942 48.5933 54.9423C48.593 54.9423 48.5923 54.9426 48.5916 54.9426C48.5913 54.943 48.591 54.943 48.5906 54.9433C48.59 54.9433 48.5893 54.9436 48.5886 54.9436C48.5883 54.944 48.588 54.944 48.5876 54.944C48.5869 54.9443 48.5863 54.9446 48.5856 54.9446C48.5853 54.945 48.5849 54.945 48.5846 54.945C48.5839 54.9453 48.5833 54.9456 48.5826 54.9456C48.5822 54.946 48.5819 54.946 48.5816 54.946C48.5809 54.9463 48.5799 54.9466 48.5792 54.947H48.5789C48.5779 54.9473 48.5772 54.9476 48.5762 54.948H48.5759C48.5749 54.9483 48.5742 54.9487 48.5732 54.949C48.5351 54.963 48.4996 54.9827 48.4671 55.0117H48.4668C48.4661 55.0124 48.4655 55.013 48.4648 55.0137L48.4645 55.014C48.4635 55.0147 48.4628 55.0154 48.4621 55.0164C48.4618 55.0164 48.4618 55.0164 48.4618 55.0164C48.4611 55.017 48.4604 55.0174 48.4598 55.018C48.4598 55.0184 48.4594 55.0184 48.4594 55.0187C48.4588 55.0191 48.4584 55.0197 48.4578 55.0201C48.4574 55.0204 48.4571 55.0207 48.4571 55.021C48.4564 55.0214 48.4561 55.0217 48.4558 55.0224C48.4554 55.0227 48.4548 55.023 48.4544 55.0234C48.4541 55.024 48.4534 55.0244 48.4527 55.025C48.4524 55.0254 48.4524 55.0254 48.4521 55.0257C48.4514 55.0267 48.4504 55.0274 48.4497 55.028C48.4497 55.028 48.4497 55.0281 48.4497 55.0284C48.4464 55.0314 48.4434 55.0351 48.44 55.0384C48.0498 55.4708 47.7258 55.9854 47.3738 56.4645C46.9286 56.5226 46.4832 56.5816 46.0377 56.6387C45.5307 56.7041 45.2271 57.0417 45.2271 57.4955C45.2271 57.6196 45.2495 57.7528 45.2971 57.8912C45.4008 58.1929 45.5384 58.4748 45.6605 58.7654C45.5203 58.7194 45.3807 58.6727 45.2408 58.6253C45.04 58.7481 44.8392 58.8709 44.6387 58.9937C44.53 59.1278 44.4333 59.2816 44.3101 59.3924C44.3088 59.3934 44.3078 59.3947 44.3064 59.3961C43.9758 59.7004 44.1542 60.5352 43.624 60.5369C43.6237 60.5369 43.623 60.5369 43.6227 60.5369ZM48.5009 53.5055C48.5013 53.5382 48.5739 53.5889 48.6104 53.6307C48.6726 53.5856 48.757 53.5562 48.7938 53.4932C48.8781 53.3477 48.9491 53.1956 48.9497 53.0427C48.9501 52.9627 48.9313 52.8823 48.8848 52.8028C48.8848 52.8025 48.8845 52.8018 48.8842 52.8015C48.8798 52.7958 48.8684 52.7935 48.8534 52.7932C48.853 52.7932 48.8524 52.7932 48.852 52.7932C48.847 52.7932 48.8416 52.7935 48.8359 52.7938C48.7918 52.7978 48.7335 52.8165 48.7255 52.8365C48.6392 53.0531 48.5639 53.2756 48.502 53.5002C48.5013 53.5019 48.5009 53.5035 48.5009 53.5055Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M42.7771 56.0796C42.4819 55.9331 42.1767 55.7826 42.176 55.3669C42.1757 55.3158 42.1804 55.2608 42.1901 55.201C42.3102 54.462 42.5977 53.8427 43.3039 53.6482C43.3063 53.6475 43.3083 53.6472 43.3106 53.6465C43.3116 53.6462 43.3123 53.6462 43.3133 53.6458C43.333 53.6412 43.3541 53.6392 43.3759 53.6388C43.3762 53.6388 43.3769 53.6388 43.3772 53.6388C43.3799 53.6388 43.3826 53.6392 43.3852 53.6392C43.4893 53.6415 43.6078 53.6909 43.6701 53.763C43.6704 53.7636 43.671 53.7643 43.6714 53.765C43.672 53.7656 43.6727 53.7663 43.6731 53.7669C43.6764 53.7709 43.6797 53.775 43.6824 53.7793C43.7239 53.8377 43.7477 53.9458 43.7474 54.0489C43.7474 54.1193 43.7363 54.1874 43.7119 54.2348C43.5559 54.5391 43.318 54.7947 43.162 55.0993C43.0034 55.4076 42.903 55.7509 42.7771 56.0789V56.0796Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M42.3369 58.7859C42.194 58.7418 42.0511 58.6975 41.9085 58.6531L41.9105 58.6494C41.9095 58.6067 41.9092 58.5637 41.9092 58.5206C41.9092 58.4989 41.9092 58.4776 41.9092 58.4559C41.9092 58.3481 41.9078 58.241 41.8928 58.1382C41.8864 58.0959 41.8834 58.0562 41.8831 58.0198C41.8821 57.7649 42.027 57.6548 42.2606 57.6167C42.4132 57.7762 42.4681 57.9571 42.4684 58.1503C42.4684 58.3525 42.4085 58.568 42.3369 58.7859Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M31.3306 61.9692C31.4618 61.5822 31.5883 61.1935 31.7248 60.8084C31.8714 60.395 32.1288 60.1227 32.5019 60.013C32.6288 60.073 32.756 60.1334 32.8825 60.1941C32.5374 60.9899 32.0863 61.6596 31.3306 61.9692Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M32.9218 56.4795C32.8841 56.4525 32.8247 56.4365 32.8134 56.3964C32.8047 56.3664 32.8027 56.333 32.8027 56.2986C32.8027 56.2629 32.805 56.2256 32.8054 56.1896C32.8444 56.2863 32.8831 56.3827 32.9218 56.4795ZM32.8054 56.1896C32.8037 56.1852 32.8017 56.1805 32.8 56.1759L32.8054 56.1729C32.8054 56.1785 32.8054 56.1842 32.8054 56.1896Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M32.8001 56.1758C32.8007 56.1738 32.8011 56.1721 32.8017 56.1701C32.8031 56.1711 32.8044 56.1721 32.8054 56.1728L32.8001 56.1758ZM32.8017 56.1701C32.63 56.041 32.5444 55.8575 32.5437 55.6206C32.5437 55.5865 32.5454 55.5515 32.5491 55.5151C32.692 55.5628 32.8352 55.6106 32.9784 55.6583C32.9195 55.8291 32.8606 55.9996 32.8017 56.1701Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M49.4468 60.7649C49.4445 60.7649 49.4418 60.7649 49.4395 60.7649C49.3735 60.7639 49.3022 60.7532 49.2504 60.7342C49.249 60.7339 49.2477 60.7332 49.2464 60.7329C49.2447 60.7322 49.243 60.7315 49.2413 60.7308C49.239 60.7298 49.2363 60.7288 49.234 60.7278C48.8294 60.5503 48.4388 60.3401 48.0432 60.1419C47.8046 59.9788 47.5532 59.8349 47.3313 59.6468C47.324 59.6404 47.3166 59.6344 47.3096 59.6288C47.2256 59.562 47.1456 59.5253 47.0663 59.524C47.0649 59.524 47.0636 59.524 47.0623 59.524C47.0606 59.524 47.0589 59.524 47.0576 59.524C46.9675 59.5256 46.8782 59.573 46.7838 59.6748C46.7794 59.6795 46.7751 59.6845 46.7704 59.6895C46.7677 59.6925 46.7651 59.6958 46.7621 59.6988C46.6185 59.6521 46.4746 59.6057 46.3307 59.5594C46.1924 59.51 46.0545 59.4596 45.917 59.4072C46.0659 58.9764 46.2503 58.5894 46.7018 58.525C46.7132 58.5287 46.7246 58.5323 46.7359 58.536C46.907 58.5887 47.0773 58.6141 47.2473 58.6144C47.2483 58.6144 47.249 58.6144 47.2497 58.6144C47.251 58.6144 47.2527 58.6144 47.2544 58.6144C47.6476 58.6134 48.0405 58.4773 48.4395 58.2307C48.4438 58.228 48.4485 58.225 48.4528 58.2224C48.4441 57.3285 47.7306 57.0595 47.3778 56.475L47.3739 56.4646C47.7259 55.9855 48.0499 55.471 48.4401 55.0385C48.4435 55.0352 48.4465 55.0315 48.4498 55.0285C48.4498 55.0282 48.4498 55.0282 48.4498 55.0282C48.4505 55.0275 48.4515 55.0269 48.4522 55.0259C48.4525 55.0255 48.4525 55.0255 48.4528 55.0252C48.4535 55.0245 48.4542 55.0242 48.4545 55.0235C48.4549 55.0232 48.4555 55.0228 48.4559 55.0225C48.4562 55.0218 48.4565 55.0215 48.4572 55.0212C48.4572 55.0208 48.4575 55.0205 48.4579 55.0202C48.4585 55.0199 48.4589 55.0192 48.4595 55.0189C48.4595 55.0185 48.4599 55.0185 48.4599 55.0182C48.4605 55.0175 48.4612 55.0172 48.4619 55.0165C48.4619 55.0165 48.4619 55.0165 48.4622 55.0165C48.4629 55.0155 48.4636 55.0148 48.4646 55.0142L48.4649 55.0138C48.4656 55.0132 48.4662 55.0125 48.4669 55.0118H48.4672C48.4997 54.9828 48.5352 54.9631 48.5733 54.9491C48.5743 54.9488 48.575 54.9484 48.576 54.9481H48.5763C48.5773 54.9478 48.578 54.9474 48.579 54.9471H48.5793C48.58 54.9468 48.581 54.9464 48.5817 54.9461C48.582 54.9461 48.5823 54.9461 48.5827 54.9458C48.5834 54.9458 48.584 54.9454 48.5847 54.9451C48.585 54.9451 48.5854 54.9451 48.5857 54.9448C48.5864 54.9448 48.587 54.9444 48.5877 54.9441C48.588 54.9441 48.5884 54.9441 48.5887 54.9438C48.5894 54.9438 48.5901 54.9434 48.5907 54.9434C48.5911 54.9431 48.5914 54.9431 48.5917 54.9428C48.5924 54.9428 48.5931 54.9424 48.5934 54.9424C48.5941 54.9421 48.5944 54.9421 48.5951 54.9418C48.5954 54.9418 48.5961 54.9418 48.5964 54.9414C48.5971 54.9414 48.5974 54.9411 48.5981 54.9411C48.5984 54.9408 48.5991 54.9408 48.5994 54.9408C48.6001 54.9404 48.6008 54.9404 48.6014 54.9401C48.6018 54.9401 48.6021 54.9398 48.6021 54.9398C48.6031 54.9398 48.6038 54.9394 48.6044 54.9391C48.6048 54.9391 48.6048 54.9391 48.6051 54.9391C48.6061 54.9388 48.6068 54.9384 48.6078 54.9384C48.6078 54.9384 48.6081 54.9384 48.6081 54.9381C48.6744 54.9208 48.7464 54.9184 48.8203 54.9184C48.8337 54.9184 48.8471 54.9184 48.8608 54.9184C48.8739 54.9187 48.8869 54.9188 48.9 54.9188C49.0974 54.9188 49.2989 54.9031 49.4318 54.6351V54.6348C49.4354 54.6274 49.4391 54.6198 49.4428 54.6118C49.4452 54.6064 49.4475 54.6011 49.4498 54.5954C49.4498 54.5954 49.4502 54.5954 49.4502 54.5951C49.4512 54.5924 49.4525 54.5897 49.4535 54.5871C49.4545 54.5844 49.4559 54.5814 49.4569 54.5787C49.4572 54.5784 49.4572 54.5781 49.4576 54.5777C49.4579 54.5767 49.4582 54.5754 49.4589 54.5744C49.4589 54.5744 49.4589 54.5744 49.4589 54.5741C49.4596 54.5727 49.4599 54.5714 49.4606 54.5701C49.4606 54.5697 49.4609 54.5691 49.4612 54.5687C49.4615 54.5677 49.4619 54.5667 49.4622 54.5657C49.4626 54.5651 49.4626 54.5644 49.4629 54.5637C49.4632 54.563 49.4636 54.5624 49.4639 54.5614C49.4639 54.5607 49.4642 54.5604 49.4646 54.5597C49.4649 54.5587 49.4653 54.5577 49.4656 54.5571C49.4656 54.5567 49.4659 54.5564 49.4659 54.5564C49.4663 54.555 49.4669 54.5537 49.4673 54.5524C49.4676 54.5517 49.4676 54.5511 49.4679 54.5504C49.4682 54.5497 49.4686 54.549 49.4689 54.548C49.4693 54.5474 49.4696 54.5464 49.4696 54.5457C49.4699 54.545 49.4703 54.5444 49.4706 54.5434C49.4709 54.5424 49.4713 54.5414 49.4719 54.5404C49.4719 54.5397 49.4719 54.5394 49.4723 54.539C49.4726 54.5377 49.4729 54.5367 49.4736 54.5354C49.4736 54.535 49.4736 54.5347 49.474 54.5344C49.4743 54.5334 49.4746 54.5324 49.4749 54.5314C49.4753 54.5307 49.4753 54.53 49.4756 54.5297C49.476 54.529 49.4759 54.528 49.4763 54.5273C49.4766 54.5267 49.477 54.5257 49.4773 54.525C49.4773 54.5243 49.4776 54.5237 49.4779 54.523C49.4783 54.522 49.4786 54.521 49.479 54.5203C49.4793 54.519 49.4796 54.5177 49.48 54.5167C49.4803 54.5163 49.4803 54.516 49.4803 54.5154C49.4813 54.5124 49.4823 54.5093 49.4833 54.5063C49.4833 54.506 49.4837 54.506 49.4837 54.506C49.4877 54.493 49.492 54.4796 49.4957 54.466C49.496 54.466 49.496 54.4656 49.496 54.4656C49.4974 54.461 49.4987 54.4563 49.5 54.4516C49.5004 54.4496 49.5011 54.4476 49.5017 54.4456C49.5027 54.4416 49.5037 54.4379 49.5047 54.4339C49.6088 54.0402 49.9154 53.6902 50.1416 53.3292C50.2326 53.1837 50.3545 53.0622 50.4622 52.9301C50.4689 52.9291 50.4756 52.9281 50.4827 52.9271C50.4907 52.9261 50.4991 52.9251 50.5074 52.9238C50.5305 52.9204 50.5536 52.9171 50.5767 52.9134C50.581 52.9127 50.5854 52.9121 50.5901 52.9114C50.6256 52.9057 50.6611 52.9001 50.6969 52.8944C50.8927 52.8627 51.0888 52.83 51.2809 52.829C51.2832 52.829 51.2852 52.829 51.2872 52.829C51.2876 52.829 51.2879 52.829 51.2879 52.829C51.3083 52.829 51.3284 52.8293 51.3485 52.8303C51.4485 52.834 51.5356 53.0339 51.5998 53.1653C51.6038 53.1733 51.6055 53.184 51.6055 53.1967C51.6058 53.2574 51.5674 53.3632 51.5272 53.3952C51.3411 53.5447 51.1159 53.6361 50.9542 53.8116C50.732 54.0529 50.554 54.3502 50.3568 54.6238C49.9857 54.8357 49.8351 54.9217 49.8354 55.0956C49.8357 55.2144 49.907 55.3742 50.0265 55.6431C50.1185 55.8647 50.2146 56.0832 50.3016 56.3078C50.3615 56.4623 50.4358 56.5407 50.5272 56.542C50.5278 56.542 50.5285 56.542 50.5292 56.542C50.5308 56.542 50.5329 56.542 50.5345 56.542C50.6075 56.5397 50.6912 56.4886 50.7866 56.3879C50.7889 56.3852 50.7916 56.3825 50.7942 56.3802C50.7946 56.3799 50.7946 56.3795 50.7949 56.3792C50.7989 56.3752 50.8026 56.3715 50.8063 56.3675C50.8066 56.3675 50.8066 56.3672 50.807 56.3668C50.9703 56.2023 51.1296 56.1316 51.2799 56.1293C51.2826 56.1293 51.2849 56.1293 51.2872 56.1293C51.2882 56.1293 51.2889 56.1293 51.2896 56.1293C51.4563 56.1299 51.6115 56.215 51.7477 56.3505C51.7581 56.3609 51.7685 56.3712 51.7785 56.3822C51.7822 56.3862 51.7859 56.3902 51.7896 56.3942C51.7993 56.4049 51.8087 56.4162 51.817 56.4276C51.8923 56.5273 51.9195 56.6464 51.9198 56.7742C51.9198 56.9698 51.8572 57.186 51.8073 57.3869C51.6902 57.7279 51.5734 58.0692 51.4562 58.4105C51.4512 58.4139 51.4465 58.4169 51.4415 58.4202C51.4375 58.4225 51.4338 58.4249 51.4298 58.4272C51.2849 58.518 51.1614 58.5557 51.0523 58.556C51.0519 58.556 51.0513 58.556 51.0506 58.556C51.0496 58.556 51.0486 58.556 51.0476 58.556C50.6965 58.554 50.4984 58.1623 50.2189 57.9044C50.1088 57.8026 49.986 57.7219 49.8364 57.6938C49.6935 58.0906 49.5529 58.4803 49.4127 58.8703C49.5616 59.2437 49.7584 59.5984 49.8401 59.9984C49.8448 60.0218 49.8468 60.0465 49.8468 60.0722C49.8464 60.266 49.7209 60.5216 49.6185 60.7155C49.6004 60.7489 49.5302 60.7642 49.4505 60.7649C49.4492 60.7649 49.4478 60.7649 49.4468 60.7649Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M53.8454 59.7791C53.6777 59.6402 53.6355 59.4611 53.6355 59.2652C53.6355 59.0677 53.6787 58.8528 53.6787 58.6456C53.6787 58.5431 53.6683 58.4424 53.6369 58.346C53.3735 58.6002 53.1218 58.8435 52.8561 59.0994C52.7225 58.5765 52.5421 58.1561 52.0759 58.0346C52.1214 57.8638 52.172 57.6947 52.2279 57.5265C52.4247 57.3957 52.6158 57.2005 52.8196 57.1474C53.262 57.0333 53.4388 56.666 53.5967 56.2502C53.7969 56.1301 53.9973 56.01 54.1975 55.8898C54.3421 55.9379 54.4866 55.9859 54.6312 56.0343C55.3243 55.8905 55.3464 55.1808 55.5643 54.6366C55.7654 54.5105 55.9666 54.3844 56.1674 54.2582C56.1704 54.2562 56.1737 54.2542 56.1767 54.2522C56.1784 54.2509 56.1801 54.2499 56.1818 54.2486C56.1891 54.2439 56.1965 54.2389 56.2039 54.2342C56.2069 54.2322 56.2099 54.2302 56.2126 54.2282C56.2249 54.2199 56.237 54.2119 56.2487 54.2042C56.2497 54.2035 56.2507 54.2028 56.2514 54.2025C56.2598 54.1968 56.2681 54.1915 56.2761 54.1862C56.2771 54.1855 56.2782 54.1848 56.2795 54.1841C56.2815 54.1828 56.2835 54.1815 56.2855 54.1802C56.2895 54.1775 56.2936 54.1748 56.2976 54.1721C56.3073 54.1658 56.317 54.1594 56.3263 54.1534C56.4833 54.0513 56.5884 53.992 56.6684 53.9843C56.6744 53.9836 56.6805 53.9833 56.6865 53.9833C56.6868 53.9833 56.6875 53.9833 56.6878 53.9833C56.823 53.9846 56.8853 54.1505 57.0255 54.5305C57.0268 54.5345 57.0282 54.5382 57.0295 54.5419C56.9987 54.7978 56.9773 54.9719 56.9776 55.0927C56.978 55.3493 57.075 55.365 57.3802 55.4074C57.5268 55.4274 57.6845 55.4037 57.8247 55.4424C58.14 55.5295 58.311 55.7407 58.3117 56.041C58.312 56.1541 58.2882 56.2799 58.2387 56.4164C58.1497 56.6623 57.9582 56.8698 57.8645 57.1154C57.8561 57.1371 57.8528 57.1611 57.8528 57.1871C57.8528 57.2889 57.9084 57.4157 57.9509 57.5105C57.9609 57.5325 58.0011 57.5432 58.0459 57.5435C58.0466 57.5435 58.0473 57.5435 58.0479 57.5435C58.0486 57.5435 58.0493 57.5435 58.0499 57.5435C58.0797 57.5432 58.1108 57.5385 58.1363 57.5301C58.1386 57.5291 58.141 57.5285 58.1433 57.5275C58.1443 57.5271 58.145 57.5268 58.146 57.5265C58.1483 57.5255 58.151 57.5245 58.1534 57.5235C58.3625 57.4254 58.5667 57.3059 58.8073 57.1761C58.8096 57.2162 58.811 57.2552 58.811 57.2932C58.8103 58.1398 58.1979 58.4778 57.7805 58.9599C57.7718 58.9552 57.7631 58.9505 57.7544 58.9459C57.4294 58.7747 57.0968 58.6633 56.7464 58.6626C56.7457 58.6626 56.7447 58.6626 56.7437 58.6626C56.7427 58.6626 56.7413 58.6626 56.7403 58.6626C56.5395 58.6629 56.3331 58.7 56.1189 58.783C56.1051 58.7884 56.0914 58.7941 56.0777 58.7997C56.1516 58.5338 56.2012 58.2789 56.2008 58.0446C56.2002 57.6406 56.0502 57.2976 55.6188 57.0633C55.0482 57.9876 54.6044 59.0176 53.8454 59.7791Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M53.1197 56.3318C53.1184 56.3318 53.1174 56.3318 53.1161 56.3318C52.8122 56.3308 52.5692 56.1857 52.443 55.7292C52.4427 55.7275 52.442 55.7258 52.4417 55.7245C52.4407 55.7212 52.44 55.7182 52.439 55.7148C52.3838 55.5063 52.1997 55.3592 52.0732 55.1847C52.2412 54.532 52.4574 53.8837 52.5638 53.2257C52.5642 53.2237 52.5648 53.221 52.5651 53.219C52.5658 53.2147 52.5665 53.2107 52.5672 53.2067C52.5672 53.2063 52.5672 53.206 52.5672 53.2057C52.5685 53.1987 52.5699 53.192 52.5709 53.1853C52.6432 52.7939 52.7958 52.7082 52.9755 52.7069C52.9768 52.7069 52.9782 52.7069 52.9798 52.7069C52.9808 52.7069 52.9815 52.7069 52.9825 52.7069C53.0327 52.7072 53.0849 52.7135 53.1381 52.7215C53.2004 52.7312 53.264 52.7429 53.3269 52.7489C53.3386 52.7499 53.3503 52.7509 53.362 52.7516C53.3704 53.2744 53.6947 53.4353 54.0481 53.5634L53.9524 53.8136L53.8681 54.0672H53.8677C53.8674 54.0672 53.8671 54.0676 53.8667 54.0679C53.8617 54.0665 53.857 54.0655 53.852 54.0642C53.8423 54.0619 53.8326 54.0592 53.8229 54.0569C53.7037 54.0265 53.5842 53.9958 53.4641 53.9955C53.4628 53.9955 53.4618 53.9955 53.4608 53.9955C53.4598 53.9955 53.4588 53.9955 53.4578 53.9955C53.3346 53.9958 53.2104 54.0285 53.0849 54.1259C53.0842 54.1263 53.0836 54.1269 53.0829 54.1276C53.0819 54.1283 53.0809 54.1289 53.0799 54.1299C53.0772 54.1319 53.0745 54.1339 53.0719 54.1363C53.0156 54.1823 52.9554 54.2661 52.9423 54.3375C52.9417 54.3422 52.9407 54.3468 52.94 54.3515C52.9139 54.5153 52.9658 54.6278 53.0611 54.6288C53.0615 54.6288 53.0618 54.6288 53.0625 54.6288C53.0632 54.6288 53.0642 54.6288 53.0648 54.6288C53.0916 54.6281 53.1217 54.6191 53.1545 54.5997C53.4032 54.4546 53.6304 54.2484 53.8667 54.0679C53.8671 54.0679 53.8674 54.0682 53.8677 54.0682L53.8681 54.0672C54.3212 54.3875 54.4815 54.5003 54.4812 54.7689C54.4808 54.9144 54.433 55.1056 54.3594 55.4005C54.3179 55.566 54.2516 55.7268 54.1971 55.89C53.9969 56.0101 53.7964 56.1303 53.5963 56.2504C53.5913 56.2521 53.5859 56.2534 53.5809 56.2547C53.5806 56.2551 53.5806 56.2551 53.5802 56.2551C53.5735 56.2571 53.5668 56.2587 53.5602 56.2604C53.4055 56.3028 53.2576 56.3315 53.1221 56.3318C53.1211 56.3318 53.1204 56.3318 53.1197 56.3318ZM52.0722 55.1883L52.0698 55.18C52.0708 55.1817 52.0719 55.183 52.0732 55.1847C52.0729 55.1857 52.0725 55.187 52.0722 55.1883Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M54.4628 53.5906C54.4611 53.5906 54.4595 53.5906 54.4578 53.5906C54.3755 53.5902 54.2787 53.5833 54.1616 53.5732C54.1375 53.5712 54.1128 53.5689 54.0867 53.5666C54.083 53.5662 54.0793 53.5659 54.0752 53.5656C54.0722 53.5652 54.0696 53.5649 54.0666 53.5649C54.0605 53.5642 54.0542 53.5636 54.0482 53.5632C53.6947 53.4351 53.3704 53.2743 53.3621 52.7514C53.5609 52.6196 53.7596 52.4878 53.9581 52.3557C54.3865 52.5078 54.8145 52.66 55.2426 52.8122C55.2379 52.8215 55.2329 52.8308 55.2282 52.8398C55.2279 52.8408 55.2275 52.8415 55.2269 52.8422C55.2252 52.8458 55.2232 52.8492 55.2215 52.8529C55.2125 52.8699 55.2038 52.8866 55.1954 52.9029C55.1948 52.9042 55.1941 52.9056 55.1931 52.9069C54.9039 53.4611 54.8182 53.5899 54.4652 53.5906C54.4645 53.5906 54.4635 53.5906 54.4628 53.5906Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M51.6344 55.4631C51.6334 55.4631 51.6321 55.4631 51.6311 55.4631C51.5347 55.4618 51.4417 55.4071 51.3557 55.279C51.3516 55.273 51.3479 55.2673 51.3439 55.2609C51.3305 55.2399 51.3252 55.2112 51.3252 55.1772C51.3252 55.0754 51.3734 54.929 51.4032 54.8188C51.4082 54.7998 51.448 54.7755 51.4895 54.7608C51.5116 54.7524 51.5344 54.7474 51.5521 54.7474C51.5528 54.7474 51.5534 54.7474 51.5541 54.7474C51.5628 54.7478 51.5698 54.7491 51.5752 54.7524C51.5759 54.7528 51.5766 54.7531 51.5769 54.7534C51.7476 54.8849 51.9052 55.038 52.0672 55.1839C52.0615 55.1902 52.0561 55.1965 52.0504 55.2029C52.0498 55.2036 52.0491 55.2042 52.0488 55.2049C52.0458 55.2079 52.0431 55.2112 52.0401 55.2142C51.9059 55.3624 51.768 55.4621 51.6361 55.4631C51.6358 55.4631 51.6351 55.4631 51.6344 55.4631ZM52.0725 55.1885C52.0705 55.1869 52.0688 55.1852 52.0672 55.1839C52.0682 55.1825 52.0692 55.1815 52.0702 55.1802L52.0725 55.1885Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M51.4563 58.4106C51.5734 58.0693 51.6902 57.728 51.8074 57.387C51.9399 57.427 52.0714 57.4704 52.202 57.5174C52.2107 57.5204 52.2194 57.5238 52.2277 57.5268C52.1718 57.695 52.1213 57.8641 52.0758 58.0349C51.8693 58.1604 51.6628 58.2855 51.4563 58.4106Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M50.0265 55.6431C49.9071 55.3741 49.8358 55.2143 49.8354 55.0955C49.8351 54.9217 49.9857 54.8356 50.3569 54.6237C50.2471 54.9634 50.137 55.3031 50.0265 55.6431Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M36.1809 63.0156C36.0397 62.9709 35.8981 62.9265 35.7562 62.8828C35.7552 62.8825 35.7542 62.8822 35.7532 62.8818C35.7532 62.8815 35.7532 62.8815 35.7532 62.8811C35.7843 62.3947 35.703 61.9122 36.112 61.4704C36.3151 61.2512 36.4015 60.8712 36.5149 60.5548C36.5554 60.4421 36.5738 60.3349 36.5741 60.2332C36.5752 60.018 36.4942 59.8261 36.3663 59.6556C36.366 59.6549 36.3656 59.6546 36.3653 59.6543C36.3656 59.6536 36.366 59.6533 36.3663 59.6529C36.368 59.6509 36.3693 59.6489 36.371 59.6473C36.3723 59.6453 36.374 59.6433 36.3757 59.6416C36.3777 59.6389 36.3797 59.6362 36.3817 59.6339C36.5584 59.4217 36.7418 59.3463 36.9286 59.3453C36.9302 59.3453 36.9316 59.3453 36.9333 59.3453C36.9343 59.3453 36.9356 59.3453 36.9366 59.3453C37.0725 59.346 37.21 59.385 37.3483 59.4384C37.356 59.4414 37.3633 59.4444 37.371 59.4474C37.374 59.4487 37.3771 59.4497 37.3797 59.4511C37.3841 59.6199 37.459 59.7474 37.5628 59.7494C37.5638 59.7494 37.5645 59.7494 37.5655 59.7494C37.5658 59.7494 37.5665 59.7494 37.5668 59.7494C37.5999 59.749 37.6357 59.736 37.6732 59.7077C37.6779 59.7043 37.683 59.7007 37.6876 59.697C37.6896 59.6953 37.692 59.6936 37.694 59.692C37.698 59.689 37.7023 59.6856 37.7064 59.6826C37.707 59.682 37.7077 59.6816 37.7084 59.6813C37.9015 59.5338 38.1096 59.3653 38.283 59.357C38.2873 59.357 38.2917 59.3567 38.2961 59.3567C38.2967 59.3567 38.2971 59.3567 38.2977 59.3567C38.4135 59.3573 38.5129 59.4334 38.5809 59.6413C38.5809 59.6413 38.5809 59.6416 38.5812 59.6419C38.5832 59.6486 38.5852 59.6553 38.5876 59.6623C38.8198 60.4264 39.2328 60.7136 39.7938 60.7143C39.7944 60.7143 39.7954 60.7143 39.7961 60.7143C39.7968 60.7143 39.7974 60.7143 39.7981 60.7143C39.9567 60.7143 40.1271 60.6913 40.3085 60.6496C40.3115 60.6493 40.3142 60.6486 40.3172 60.6479C40.3242 60.6463 40.3313 60.6446 40.3386 60.6426C40.4892 60.6069 40.6411 60.5899 40.7931 60.5642L40.7878 60.5692C40.6746 60.9099 40.5612 61.2508 40.448 61.5915C40.445 61.5955 40.4417 61.5999 40.4383 61.6039C40.4363 61.6065 40.4343 61.6092 40.432 61.6119C40.4273 61.6176 40.423 61.6229 40.4183 61.6286C40.4176 61.6292 40.4169 61.6299 40.4162 61.6309C40.2392 61.8395 40.0518 61.9052 39.8597 61.9062C39.858 61.9062 39.8563 61.9062 39.855 61.9062C39.8537 61.9062 39.8526 61.9062 39.8513 61.9062C39.7281 61.9055 39.6027 61.8791 39.4768 61.8471C39.4748 61.8468 39.4725 61.8461 39.4701 61.8455C39.4688 61.8451 39.4671 61.8448 39.4658 61.8444C39.4608 61.8431 39.4557 61.8418 39.451 61.8404C39.449 61.8401 39.447 61.8395 39.445 61.8391C39.4377 61.8371 39.4306 61.8351 39.4233 61.8334C39.4196 61.8324 39.4159 61.8314 39.4122 61.8304C39.2777 61.7754 39.1411 61.728 39.0019 61.688C38.6592 61.761 38.3171 61.8348 37.9748 61.9079V61.9075C37.9744 61.9042 37.9744 61.9008 37.9744 61.8972C37.9748 61.8575 37.9778 61.8161 37.9778 61.7767C37.9778 61.743 37.9755 61.7106 37.9668 61.6816C37.955 61.6406 37.8934 61.6246 37.8543 61.5972C37.8945 61.7007 37.9346 61.8044 37.9748 61.9075C37.9118 62.0747 37.853 62.2432 37.7981 62.413H37.7977C37.6628 62.37 37.5313 62.3132 37.3921 62.2862C37.3771 62.2832 37.3623 62.2802 37.3479 62.2776C37.3466 62.2772 37.3452 62.2769 37.3439 62.2765C37.1695 62.2425 37.0403 62.2192 36.9359 62.2188C36.9349 62.2188 36.9339 62.2188 36.9333 62.2188C36.9319 62.2188 36.9309 62.2188 36.9296 62.2188C36.6451 62.2202 36.5413 62.3967 36.1869 63.0059C36.1849 63.0093 36.1829 63.0123 36.1809 63.0156Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M39.4264 82.9272C39.4254 82.9272 39.4241 82.9272 39.4231 82.9272C39.2788 82.9266 39.1332 82.8869 38.987 82.8405C38.9836 82.8395 38.9803 82.8385 38.9773 82.8375C38.6952 82.7417 38.413 82.646 38.1309 82.5505C38.0914 82.3894 38.0693 82.2159 38.0064 82.0711C37.9425 81.9242 37.8032 81.8225 37.7607 81.6696C37.745 81.6129 37.736 81.5412 37.7363 81.4691C37.7363 81.3677 37.7547 81.2659 37.7979 81.2072C37.7992 81.2055 37.8002 81.2042 37.8016 81.2025C37.8367 81.1608 37.9157 81.1421 37.9974 81.1418C37.998 81.1418 37.9987 81.1418 37.9994 81.1418C38.0014 81.1418 38.0037 81.1418 38.0057 81.1418C38.07 81.1428 38.1356 81.1545 38.1821 81.1755C38.2691 81.2149 38.3514 81.2339 38.4281 81.2339C38.4287 81.2339 38.4294 81.2339 38.4301 81.2339C38.4304 81.2339 38.4311 81.2339 38.4318 81.2339C38.6486 81.2332 38.8183 81.0834 38.9084 80.8255C38.91 80.8205 38.9117 80.8155 38.9134 80.8105C38.9157 80.8038 38.9177 80.7975 38.9197 80.7908C38.9314 80.7527 38.9368 80.711 38.9365 80.667C38.9361 80.4851 38.8461 80.2646 38.7584 80.1148C38.4713 79.6226 37.7714 79.7548 37.4712 78.9736C37.4819 78.8612 37.4873 78.7491 37.487 78.638C37.4863 77.8312 37.1935 77.0721 36.4672 76.5746C36.3126 76.4685 36.2875 76.1285 36.2122 75.8916C36.2102 75.8852 36.2082 75.8782 36.2065 75.8712C36.2062 75.8705 36.2062 75.8699 36.2058 75.8692C36.2055 75.8669 36.2048 75.8649 36.2045 75.8625C36.1673 75.7047 36.1911 75.4478 36.0505 75.4458C36.0499 75.4458 36.0492 75.4458 36.0489 75.4458C36.0482 75.4458 36.0475 75.4458 36.0472 75.4458C36.0164 75.4461 35.9786 75.4585 35.9307 75.4855C35.9224 75.4902 35.9137 75.4955 35.9046 75.5012C35.761 75.5919 35.6459 75.9566 35.6463 76.1852C35.6463 76.1905 35.6463 76.1959 35.6466 76.2012C35.6493 76.3033 35.6509 76.4051 35.6509 76.5065C35.6513 77.0227 35.6051 77.5285 35.3849 78.0287C35.3802 78.0394 35.3755 78.0497 35.3708 78.0594C35.2891 78.2272 35.1874 78.2953 35.0766 78.2966C35.0756 78.2966 35.0749 78.2966 35.0739 78.2966C35.0726 78.2966 35.0716 78.2966 35.0702 78.2966C34.9976 78.2956 34.921 78.2659 34.8443 78.2172C34.8423 78.2159 34.8403 78.2146 34.8383 78.2132C34.7132 78.1321 34.6067 78.0167 34.4916 77.9162C34.3507 77.8659 34.2101 77.8151 34.0696 77.7648C34.7239 77.1091 35.1318 76.4027 35.1322 75.6056C35.1325 75.2629 35.0572 74.9033 34.8939 74.5236C34.8336 74.3837 34.8497 74.1926 34.8303 74.0251C34.8366 74.0264 34.843 74.0274 34.8494 74.0284C34.8504 74.0287 34.851 74.0287 34.8521 74.029C34.8544 74.0294 34.8567 74.0297 34.8591 74.0304C34.8648 74.0314 34.8705 74.0324 34.8761 74.0334C34.8889 74.0358 34.9012 74.0381 34.9136 74.0404C35.0271 74.0621 35.1426 74.0851 35.2563 74.0861C35.2587 74.0861 35.261 74.0861 35.263 74.0861C35.2637 74.0861 35.2644 74.0861 35.265 74.0861C35.4103 74.0858 35.5532 74.0481 35.6844 73.9223C35.6867 73.9196 35.6894 73.9173 35.6918 73.9146C35.6931 73.9136 35.6941 73.9126 35.6951 73.9116C35.9883 73.6177 36.2534 73.2743 36.4913 72.9193C36.5258 72.8676 36.5432 72.7725 36.5432 72.6787C36.5432 72.582 36.5248 72.4865 36.4886 72.4411C36.3086 72.2163 36.237 72.0164 36.2366 71.8329C36.2356 71.4018 36.6265 71.0594 36.924 70.6937C37.2022 70.7922 37.4806 70.8906 37.7587 70.9891C37.7885 71.1726 37.8424 71.263 37.9398 71.2653C37.9411 71.2653 37.9421 71.2653 37.9435 71.2653C37.9451 71.2653 37.9472 71.2653 37.9492 71.265C38.0084 71.263 38.0834 71.23 38.1778 71.1669C38.1804 71.1652 38.1828 71.1635 38.1854 71.1619C38.2005 71.1519 38.2152 71.1415 38.2299 71.1319C38.236 71.1279 38.242 71.1239 38.248 71.1195C38.2494 71.1189 38.2507 71.1178 38.252 71.1168C38.2534 71.1162 38.2544 71.1155 38.2557 71.1145C38.4579 70.979 38.5837 70.9023 38.6777 70.8949C38.6828 70.8943 38.6878 70.8943 38.6928 70.8943C38.6938 70.8943 38.6948 70.8943 38.6962 70.8943C38.8264 70.8966 38.896 71.0451 39.0395 71.3701C39.0399 71.3711 39.0406 71.3724 39.0409 71.3734C39.0419 71.3758 39.0432 71.3784 39.0442 71.3808C39.0472 71.3881 39.0506 71.3955 39.0539 71.4031C38.9739 71.7838 39.1667 72.2186 38.6446 72.4912C38.1694 72.7394 37.7136 73.0518 37.7129 73.5609C37.7122 73.7525 37.7765 73.972 37.9281 74.2263C37.8488 74.9056 37.9214 75.584 37.672 76.2676C37.6536 76.3187 37.6453 76.3667 37.6453 76.4111C37.6456 76.614 37.8227 76.7401 38.0031 76.7501C38.0342 76.7518 38.0656 76.7524 38.0971 76.7524C38.0978 76.7524 38.0984 76.7524 38.0991 76.7524C38.1004 76.7524 38.1018 76.7524 38.1031 76.7524C38.1884 76.7524 38.2748 76.7468 38.3615 76.7394C38.3986 76.7364 38.4358 76.7331 38.4729 76.7297C38.487 76.7284 38.5014 76.7271 38.5158 76.7257C38.6249 76.7161 38.7336 76.7071 38.8404 76.7071C38.8417 76.7071 38.8431 76.7071 38.8444 76.7071C38.8451 76.7071 38.8461 76.7071 38.8468 76.7071C38.9174 76.7071 38.9867 76.7111 39.0549 76.7208C39.0603 76.7218 39.066 76.7224 39.0717 76.7234C39.0754 76.7241 39.079 76.7248 39.0824 76.7251C39.0871 76.7261 39.0914 76.7268 39.0958 76.7278C39.243 76.7545 39.3217 77.0774 39.4318 77.2656C39.3555 77.4831 39.2962 77.6967 39.2959 77.8976C39.2956 78.0954 39.3521 78.281 39.5057 78.4454C39.8003 79.2586 39.5369 80.4127 40.4315 80.8775C40.4452 80.8845 40.4509 80.9092 40.4509 80.9456C40.4512 81.0814 40.3742 81.385 40.3495 81.5759C40.1323 81.6573 39.9 81.7014 39.7019 81.8302C39.5683 81.9172 39.4873 82.039 39.487 82.1655C39.4867 82.2519 39.5242 82.3406 39.6088 82.4221C39.7146 82.5238 39.8635 82.5672 39.9931 82.6373C39.9907 82.6403 39.9883 82.6429 39.9857 82.6459C39.8059 82.8575 39.6189 82.9266 39.4288 82.9272C39.4281 82.9272 39.4271 82.9272 39.4264 82.9272Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M37.1502 83.719C37.0769 83.3827 37.0651 83.0503 37.0651 82.7303C37.0651 82.5762 37.0682 82.4247 37.0682 82.2769C37.0682 81.7854 37.0377 81.334 36.7736 80.9539C36.6722 80.8385 36.5605 80.7333 36.4721 80.6055C36.4691 80.6009 36.4657 80.5962 36.4627 80.5919C36.4587 80.5865 36.4547 80.5812 36.4507 80.5759C36.4503 80.5755 36.45 80.5752 36.4497 80.5749C36.3787 80.4831 36.3071 80.4427 36.2348 80.4411C36.2335 80.4411 36.2321 80.4411 36.2308 80.4411C36.2291 80.4411 36.2274 80.4411 36.2261 80.4414C36.1257 80.4437 36.024 80.5201 35.9189 80.6389C35.9172 80.6409 35.9155 80.6429 35.9135 80.6449C35.9125 80.6462 35.9115 80.6476 35.9105 80.6486C35.9095 80.6499 35.9085 80.6509 35.9075 80.6523C35.5748 80.3416 35.2616 79.9989 34.9045 79.7273C34.53 79.4424 34.3579 79.0844 34.3569 78.6536C34.3566 78.4277 34.4028 78.1818 34.4915 77.9159C34.6066 78.0163 34.713 78.1318 34.8382 78.2128C34.8402 78.2142 34.8422 78.2155 34.8442 78.2168C34.9209 78.2656 34.9975 78.2953 35.0701 78.2963C35.0715 78.2963 35.0725 78.2963 35.0738 78.2963C35.0748 78.2963 35.0755 78.2963 35.0765 78.2963C35.1873 78.2949 35.289 78.2268 35.3707 78.059C35.3754 78.0493 35.38 78.039 35.3847 78.0283C35.6049 77.5282 35.6511 77.0223 35.6508 76.5061C35.6508 76.4047 35.6491 76.3029 35.6465 76.2008C35.6461 76.1955 35.6461 76.1902 35.6461 76.1848C35.6458 75.9563 35.7609 75.5916 35.9045 75.5008C35.9135 75.4951 35.9222 75.4898 35.9306 75.4851C35.9785 75.4581 36.0163 75.4457 36.0471 75.4454C36.0474 75.4454 36.0481 75.4454 36.0487 75.4454C36.0491 75.4454 36.0497 75.4454 36.0504 75.4454C36.191 75.4474 36.1672 75.7043 36.2044 75.8622C36.2047 75.8645 36.2054 75.8665 36.2057 75.8688C36.206 75.8695 36.206 75.8702 36.2064 75.8708C36.208 75.8778 36.21 75.8849 36.212 75.8912C36.2873 76.1281 36.3125 76.4681 36.4671 76.5742C37.1933 77.0717 37.4862 77.8308 37.4869 78.6376C37.4872 78.7487 37.4818 78.8608 37.4711 78.9733C37.7713 79.7544 38.4711 79.6222 38.7583 80.1144C38.846 80.2642 38.936 80.4848 38.9363 80.6666C38.9367 80.7107 38.9313 80.7524 38.9196 80.7904C38.9176 80.7971 38.9156 80.8034 38.9132 80.8101C38.9116 80.8151 38.9099 80.8201 38.9082 80.8251C38.8182 81.083 38.6485 81.2329 38.4316 81.2335C38.431 81.2335 38.4303 81.2335 38.43 81.2335C38.4293 81.2335 38.4286 81.2335 38.4279 81.2335C38.3513 81.2335 38.269 81.2145 38.182 81.1751C38.1354 81.1541 38.0699 81.1424 38.0056 81.1414C38.0036 81.1414 38.0012 81.1414 37.9992 81.1414C37.9986 81.1414 37.9979 81.1414 37.9972 81.1414C37.9156 81.1418 37.8366 81.1604 37.8014 81.2021C37.8001 81.2038 37.7991 81.2052 37.7977 81.2068C37.7546 81.2656 37.7362 81.3673 37.7362 81.4687C37.7358 81.5408 37.7449 81.6125 37.7606 81.6693C37.8031 81.8221 37.9423 81.9239 38.0063 82.0707C38.0692 82.2155 38.0913 82.389 38.1308 82.5502C38.1304 82.5498 38.1301 82.5498 38.1298 82.5495C38.1298 82.5501 38.1301 82.5508 38.1301 82.5515C37.6298 82.6292 37.4413 83.1831 37.1502 83.719Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M33.8881 78.2456C33.5467 77.7605 33.5544 77.0217 32.9834 76.67C32.8352 76.5786 32.7662 76.4038 32.7659 76.2112C32.7649 75.9059 32.9359 75.5559 33.2338 75.4221C33.9008 75.1228 34.2134 74.5923 34.4376 73.9013C34.5715 73.933 34.7023 73.9744 34.8302 74.0247C34.8496 74.1922 34.8335 74.3834 34.8938 74.5232C35.0571 74.9029 35.1324 75.2626 35.1321 75.6053C35.1317 76.4024 34.7237 77.1088 34.0695 77.7644C34.0002 77.9216 33.9396 78.0818 33.8881 78.2456Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M41.1102 86.124C41.1096 86.124 41.1092 86.124 41.1086 86.124C40.9191 86.1234 40.8499 85.9675 40.8435 85.7463C40.8415 85.4921 40.7946 85.3666 40.7043 85.3659C40.7039 85.3659 40.7036 85.3659 40.7033 85.3659C40.7016 85.3659 40.6999 85.3659 40.6983 85.3659C40.6966 85.3659 40.6949 85.3663 40.6929 85.3663C40.6875 85.3669 40.6822 85.3676 40.6765 85.3689C40.6213 85.382 40.5523 85.434 40.47 85.5241C40.4693 85.5248 40.4683 85.5258 40.4676 85.5264C40.4579 85.5375 40.4479 85.5488 40.4375 85.5605C40.4359 85.5628 40.4342 85.5648 40.4322 85.5668C40.4262 85.5738 40.4201 85.5812 40.4141 85.5885C40.4128 85.5902 40.4117 85.5915 40.4104 85.5932C40.1249 85.5101 39.8398 85.4273 39.5543 85.3443C39.4184 85.2825 39.2802 85.2268 39.1396 85.1768C39.3023 84.8848 39.4238 84.5421 39.635 84.3119C40.0466 83.8628 40.2478 83.3189 40.4288 82.7497C40.6484 82.9282 40.8495 83.2442 41.0915 83.2552C41.5122 83.2745 41.6862 83.6162 41.9583 83.8324C41.9546 83.8705 41.9529 83.9075 41.9529 83.9432C41.9536 84.1784 42.04 84.3609 42.212 84.4901L42.2133 84.4947C42.055 84.9969 41.8967 85.4991 41.7384 86.0012C41.5476 86.042 41.3566 86.094 41.1658 86.12C41.1631 86.1204 41.1604 86.1207 41.1577 86.121C41.1414 86.123 41.1256 86.124 41.1109 86.124C41.1105 86.124 41.1102 86.124 41.1102 86.124Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M42.112 86.1504C41.9859 86.105 41.8614 86.055 41.7385 86.0009C41.8968 85.4987 42.0551 84.9966 42.2134 84.4944C42.2151 84.4954 42.2171 84.4964 42.2188 84.4974C42.2282 84.5027 42.2372 84.5084 42.2463 84.5148C42.2473 84.5154 42.2479 84.5158 42.2489 84.5164C42.2569 84.5221 42.2647 84.5281 42.2727 84.5344C42.2734 84.5351 42.274 84.5358 42.2747 84.5365C42.2864 84.5458 42.2978 84.5561 42.3092 84.5668C42.4558 84.7083 42.5725 84.9429 42.7647 84.9439C42.765 84.9439 42.7653 84.9439 42.766 84.9439C42.7673 84.9439 42.7687 84.9439 42.7703 84.9439C42.857 84.9422 42.9591 84.8931 43.086 84.7663C43.0863 84.7663 43.0863 84.7663 43.0863 84.7663C43.0903 84.762 43.0943 84.758 43.0987 84.7537C43.0997 84.7527 43.1007 84.7513 43.102 84.7503C43.1047 84.7473 43.1074 84.7446 43.1101 84.742C43.1101 84.742 43.1104 84.742 43.1104 84.7417C43.1944 84.6576 43.277 84.6182 43.3517 84.6169C43.353 84.6169 43.3544 84.6169 43.3554 84.6169C43.3567 84.6169 43.3581 84.6169 43.3594 84.6169C43.4668 84.6189 43.5569 84.7003 43.6114 84.8414C43.6117 84.8424 43.6121 84.8434 43.6124 84.8444C43.6137 84.8478 43.6151 84.8508 43.6161 84.8541C43.6967 85.0767 43.7095 85.3396 43.7523 85.5848C43.6864 85.7477 43.6245 85.9125 43.5669 86.0787C43.5609 86.0773 43.5552 86.076 43.5492 86.0746C43.5478 86.0743 43.5465 86.074 43.5451 86.0736C43.5401 86.0723 43.5351 86.0713 43.5297 86.07C43.5006 86.0626 43.4712 86.0546 43.4417 86.046C43.434 86.0436 43.426 86.0409 43.418 86.0386C43.4116 86.0366 43.4049 86.0346 43.3985 86.0326C43.173 85.9612 42.9494 85.8628 42.7192 85.8618C42.7182 85.8618 42.7171 85.8618 42.7158 85.8618C42.7145 85.8618 42.7128 85.8618 42.7114 85.8618C42.5207 85.8628 42.3259 85.9318 42.1221 86.1397C42.1188 86.143 42.1154 86.1467 42.112 86.1504Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M36.3442 82.1318C35.7649 81.8192 35.5163 81.6851 35.5166 81.4545C35.5169 81.2807 35.6588 81.0524 35.9075 80.6524C35.9085 80.651 35.9095 80.65 35.9105 80.6487C35.9115 80.6477 35.9125 80.6463 35.9135 80.645C35.9155 80.643 35.9172 80.641 35.9189 80.639C36.024 80.5202 36.1257 80.4438 36.2261 80.4415C36.2274 80.4412 36.2291 80.4412 36.2308 80.4412C36.2321 80.4412 36.2335 80.4412 36.2348 80.4412C36.3071 80.4428 36.3787 80.4832 36.4497 80.575C36.45 80.5753 36.4503 80.5756 36.4507 80.576C36.4547 80.5813 36.4587 80.5866 36.4627 80.592C36.4657 80.5963 36.4691 80.601 36.4721 80.6056C36.5605 80.7334 36.6722 80.8386 36.7736 80.954C36.6317 81.3424 36.4902 81.7311 36.3442 82.1318Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M35.9798 84.6821C35.5668 84.541 35.1544 84.4002 34.7415 84.2594C35.0494 83.9998 35.3425 83.7032 35.6708 83.497C35.6728 83.4956 35.6745 83.4943 35.6765 83.4933C35.6775 83.4926 35.6785 83.4923 35.6792 83.4916C35.6832 83.4893 35.6873 83.4869 35.6913 83.4849C35.6919 83.4846 35.6923 83.4843 35.6929 83.4839C35.7619 83.4476 35.8419 83.4346 35.9249 83.4339C35.9265 83.4339 35.9279 83.4339 35.9292 83.4339C35.9302 83.4339 35.9309 83.4339 35.9319 83.4339C36.0216 83.4342 36.1146 83.4489 36.2006 83.4646C36.218 83.4676 36.2351 83.4706 36.2519 83.4739C36.2632 83.4759 36.2686 83.5213 36.2686 83.5857C36.2686 83.6915 36.2542 83.8476 36.2298 83.9461C36.1672 84.1957 36.0651 84.4372 35.9798 84.6821Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M42.9658 86.4663C42.681 86.3612 42.3965 86.2561 42.1121 86.1507C42.1154 86.147 42.1188 86.1433 42.1221 86.14C42.3259 85.9321 42.5207 85.863 42.7115 85.862C42.7128 85.862 42.7145 85.862 42.7158 85.862C42.7172 85.862 42.7182 85.862 42.7192 85.862C42.9494 85.863 43.173 85.9615 43.3986 86.0329C43.4049 86.0349 43.4116 86.0369 43.418 86.0389C43.426 86.0412 43.4341 86.0439 43.4418 86.0462C43.4712 86.0549 43.5007 86.0629 43.5298 86.0702C43.5351 86.0716 43.5401 86.0726 43.5452 86.0739C43.5465 86.0742 43.5478 86.0746 43.5492 86.0749C43.5552 86.0763 43.5609 86.0776 43.5669 86.0789C43.3665 86.2081 43.166 86.3372 42.9658 86.4663Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M38.4568 83.1204C38.4565 83.1204 38.4558 83.1204 38.4555 83.1204C38.3277 83.119 38.2688 82.9625 38.1489 82.6068C38.1469 82.6008 38.1449 82.5948 38.1429 82.5888C38.1419 82.5865 38.1412 82.5841 38.1406 82.5818C38.1386 82.5765 38.1369 82.5715 38.1352 82.5661C38.1335 82.5615 38.1319 82.5565 38.1302 82.5518C38.1302 82.5511 38.1299 82.5504 38.1299 82.5498C38.1302 82.5501 38.1305 82.5501 38.1309 82.5505C38.413 82.6459 38.6951 82.7416 38.9773 82.8374C38.9739 82.8394 38.9706 82.8417 38.9672 82.8441C38.9652 82.8454 38.9629 82.8471 38.9609 82.8484C38.9491 82.8561 38.9381 82.8638 38.9271 82.8714C38.9247 82.8728 38.9227 82.8744 38.9204 82.8758C38.918 82.8775 38.916 82.8788 38.9137 82.8804C38.912 82.8814 38.9103 82.8828 38.9087 82.8838C38.6888 83.0329 38.5566 83.1173 38.4619 83.12C38.4602 83.1203 38.4585 83.1204 38.4568 83.1204Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M39.2716 85.5603C39.2713 85.5603 39.2713 85.5603 39.2709 85.5603C39.1782 85.5596 39.1374 85.4245 39.1397 85.1766C39.2803 85.2266 39.4185 85.2824 39.5544 85.3441C39.5504 85.3491 39.5464 85.3538 39.5424 85.3584C39.5404 85.3608 39.5383 85.3631 39.5363 85.3654C39.4289 85.4902 39.3452 85.553 39.283 85.5596C39.279 85.5603 39.2753 85.5603 39.2716 85.5603Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M40.8437 85.7463C40.6992 85.6953 40.5552 85.6442 40.4106 85.5932C40.412 85.5915 40.413 85.5902 40.4143 85.5885C40.4204 85.5812 40.4264 85.5738 40.4324 85.5668C40.4344 85.5648 40.4361 85.5628 40.4378 85.5605C40.4481 85.5488 40.4582 85.5375 40.4679 85.5265C40.4685 85.5258 40.4696 85.5248 40.4702 85.5241C40.5526 85.434 40.6215 85.382 40.6767 85.369C40.6824 85.3676 40.6878 85.367 40.6931 85.3663C40.6951 85.3663 40.6968 85.366 40.6985 85.366C40.7002 85.366 40.7018 85.366 40.7035 85.366C40.7038 85.366 40.7042 85.366 40.7045 85.366C40.7949 85.3666 40.8417 85.4921 40.8437 85.7463Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M32.9617 83.2864C32.9098 83.1919 32.8148 83.1029 32.8154 83.0028C32.8154 83.0021 32.8154 83.0014 32.8154 83.0004C32.8178 82.8476 32.8887 82.6868 32.9302 82.5296V82.53C32.9988 82.6551 33.1096 82.7699 33.1216 82.909C33.122 82.9134 33.122 82.9177 33.122 82.922C33.1223 83.0301 33.0169 83.1643 32.9617 83.2864Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M47.3762 77.6174C47.0816 77.4049 46.6857 77.2741 46.5167 76.9608C46.516 76.9591 46.515 76.9574 46.514 76.9561C46.513 76.9538 46.5117 76.9517 46.5107 76.9497C46.4257 76.8036 46.2848 76.7789 46.1355 76.7789C46.0977 76.7789 46.0592 76.7806 46.0211 76.7823C45.9829 76.7839 45.9451 76.7853 45.9083 76.7853C45.7269 76.7853 45.5709 76.7469 45.5338 76.4806C45.5338 76.4803 45.5338 76.4803 45.5338 76.4799C45.5324 76.4713 45.5314 76.4619 45.5304 76.4526C45.5301 76.4486 45.5297 76.4446 45.5294 76.4406C45.5294 76.4402 45.5291 76.4399 45.5291 76.4399C45.5281 76.4276 45.5274 76.4149 45.5267 76.4015C45.5267 76.4009 45.5264 76.3999 45.5264 76.3992C45.5264 76.3969 45.5264 76.3949 45.5264 76.3929C45.5264 76.3922 45.5264 76.3919 45.5261 76.3915C45.5261 76.3872 45.5261 76.3832 45.5257 76.3789C45.5257 76.3765 45.5257 76.3745 45.5257 76.3725C45.5254 76.3672 45.5254 76.3622 45.5254 76.3568C45.8276 75.831 46.2724 75.4169 46.4126 74.7776C46.4397 74.6548 46.4541 74.5397 46.4544 74.4313C46.4548 74.209 46.3972 74.0138 46.27 73.834C46.4672 73.4997 46.8229 73.2591 46.8233 72.8106C46.8233 72.7746 46.8209 72.7373 46.8159 72.6985C46.8102 72.6502 46.8076 72.6011 46.8076 72.5514C46.8079 72.2674 46.8912 71.9651 46.8912 71.6825C46.8909 71.5084 46.8591 71.3419 46.757 71.192C46.5923 70.9505 46.5251 70.7092 46.5254 70.471C46.5257 70.0606 46.7259 69.6592 46.9729 69.2808C47.5867 68.3405 48.241 67.4276 49.1232 66.792C49.2882 67.2274 49.4535 67.6625 49.6192 68.0979C49.3424 68.9271 49.0676 69.7332 48.4823 70.4169C48.2671 70.6682 48.0378 71.0212 48.0375 71.4079C48.0375 71.5344 48.0616 71.6642 48.1188 71.7953C48.323 71.8854 48.5321 71.9461 48.7102 72.0636C48.8307 72.143 48.9458 72.179 49.0556 72.1797C49.0563 72.1797 49.0572 72.1797 49.0579 72.1797C49.0589 72.1797 49.0599 72.1797 49.0609 72.1797C49.2791 72.1783 49.4759 72.0369 49.6533 71.817C49.6627 71.8056 49.6717 71.794 49.6808 71.7823C49.6841 71.7783 49.6871 71.774 49.6905 71.77C49.8394 71.5728 49.9197 71.3078 50.0312 71.0736C50.0894 70.9124 50.1383 70.7466 50.2075 70.5908C50.2092 70.5864 50.2109 70.5824 50.2129 70.5784C50.4917 69.9445 50.5506 69.8203 50.9947 69.82C50.9954 69.82 50.996 69.82 50.9964 69.82C50.997 69.82 50.9977 69.82 50.9981 69.82C51.0851 69.82 51.1868 69.8247 51.3076 69.831C51.3368 69.8327 51.3672 69.8344 51.399 69.8364C51.24 70.124 51.0864 70.4156 50.9211 70.6989C50.7152 71.0522 50.4994 71.3986 50.2882 71.7483C50.2012 72.0772 50.0074 72.3909 50.0067 72.7333C50.0067 72.8083 50.0158 72.8847 50.0375 72.9628C50.0446 72.9605 50.0516 72.9581 50.0586 72.9561C50.0626 72.9548 50.0666 72.9535 50.0703 72.9521C50.1051 72.9411 50.1389 72.9304 50.1717 72.9198C50.1744 72.9191 50.1771 72.9181 50.1798 72.9174C50.1814 72.9168 50.1831 72.9164 50.1848 72.9158C50.1971 72.9118 50.2092 72.9081 50.2213 72.9041C50.231 72.9011 50.2403 72.8981 50.2497 72.8951C50.251 72.8947 50.2521 72.8944 50.2534 72.8941C50.2611 72.8917 50.2685 72.8894 50.2761 72.887C50.2855 72.884 50.2946 72.8811 50.3036 72.8784C50.3177 72.874 50.3314 72.8697 50.3448 72.8657C50.3491 72.864 50.3538 72.8627 50.3582 72.8614C50.5754 72.795 50.7327 72.7539 50.8448 72.7496C50.8515 72.7492 50.8582 72.7492 50.8645 72.7492C50.8648 72.7492 50.8652 72.7492 50.8655 72.7492C51.1426 72.7499 51.1192 73.0015 51.0483 73.6905C51.0476 73.6975 51.0469 73.7042 51.0462 73.7112C50.9301 74.0566 50.8136 74.4026 50.6972 74.7479C50.7166 74.8597 50.7259 74.9681 50.7259 75.0736C50.7263 75.5304 50.5479 75.9301 50.1978 76.2748L50.169 76.2921C50.1567 76.2761 50.1443 76.2601 50.1319 76.2444C49.8959 75.9388 49.6647 75.6158 49.3504 75.6131C49.3491 75.6131 49.3481 75.6131 49.3467 75.6131C49.3447 75.6131 49.3427 75.6131 49.341 75.6131C49.1744 75.6151 48.984 75.7075 48.7574 75.9398C48.7453 75.9521 48.7333 75.9651 48.7209 75.9781C48.6901 76.0112 48.6292 76.0325 48.5777 76.0345C48.575 76.0348 48.5726 76.0348 48.5699 76.0348C48.5686 76.0348 48.5673 76.0348 48.5659 76.0348C48.5499 76.0345 48.5352 76.0319 48.5228 76.0272C48.5198 76.0258 48.5171 76.0245 48.5144 76.0232C48.5121 76.0218 48.5097 76.0208 48.5074 76.0195C48.505 76.0182 48.5027 76.0168 48.5003 76.0158C48.3979 75.9618 48.3099 75.9377 48.2329 75.9374C48.2326 75.9374 48.2319 75.9374 48.2312 75.9374C48.2296 75.9374 48.2282 75.9374 48.2269 75.9374C47.9675 75.9404 47.84 76.217 47.7309 76.5337C47.7246 76.552 47.7182 76.5704 47.7122 76.5887C47.7112 76.5921 47.7102 76.5951 47.7092 76.5981C47.7082 76.6004 47.7075 76.6027 47.7068 76.6051C47.5944 76.9417 47.4863 77.2798 47.3762 77.6174Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M55.5474 77.3098C55.5468 77.3098 55.5461 77.3098 55.5454 77.3098C55.2355 77.3081 55.2365 76.9188 55.1639 76.6281C55.1636 76.6271 55.1632 76.6258 55.1629 76.6248C55.0725 76.2685 54.7988 76.136 54.5213 76.0219C54.1522 75.7426 53.9879 75.6182 53.9868 75.4276C53.9862 75.2745 54.0906 75.0786 54.2787 74.7252C54.4256 74.4503 54.5006 74.2371 54.5009 74.0719C54.5009 73.8344 54.3456 73.6959 54.0253 73.6152C53.956 73.5978 53.8831 73.5908 53.8101 73.5891C53.8088 73.5891 53.8071 73.5891 53.8058 73.5891C53.8044 73.5888 53.8028 73.5888 53.8014 73.5888C53.772 73.5888 53.7422 73.5925 53.7124 73.5958C53.6823 73.5995 53.6525 73.6031 53.623 73.6031C53.6187 73.6031 53.6144 73.6028 53.61 73.6028C53.6083 73.6028 53.607 73.6025 53.6053 73.6025C53.6013 73.6025 53.5969 73.6021 53.5929 73.6015C53.5912 73.6015 53.5899 73.6011 53.5882 73.6011C53.3121 73.5674 53.2181 73.5554 53.2177 73.3149C53.2174 73.1907 53.2422 73.0062 53.2793 72.7269C53.6521 72.5247 53.8021 72.4437 53.8014 72.2678C53.8008 72.1494 53.7322 71.9882 53.6174 71.7183C53.5963 71.7343 53.5752 71.75 53.5541 71.7653C53.1906 72.0316 52.8108 72.1954 52.454 72.1964C52.453 72.1964 52.452 72.1964 52.451 72.1964C52.4503 72.1964 52.4497 72.1964 52.4487 72.1964C52.1796 72.1961 51.9235 72.1023 51.6976 71.8898C51.6946 71.8871 51.6916 71.8844 51.6886 71.8814C51.6846 71.8778 51.6802 71.8741 51.6762 71.8704C51.6736 71.8678 51.6709 71.8654 51.6682 71.8631C51.4711 71.6899 51.2753 71.6369 51.0782 71.6359C51.0765 71.6359 51.0752 71.6359 51.0735 71.6359C51.0725 71.6359 51.0714 71.6359 51.0704 71.6359C50.9068 71.6365 50.7425 71.6722 50.5765 71.7042C50.4935 71.7203 50.4098 71.7353 50.3258 71.7446C50.3154 71.7456 50.3047 71.747 50.2943 71.7476C50.2923 71.748 50.2903 71.7483 50.2883 71.7483C50.4995 71.3986 50.7154 71.0523 50.9212 70.6989C51.0865 70.4156 51.2401 70.124 51.3991 69.8364C51.4018 69.8367 51.4041 69.8367 51.4068 69.8371C51.4205 69.8387 51.4346 69.8394 51.4487 69.8394C51.4493 69.8394 51.45 69.8394 51.4503 69.8394C51.5012 69.8394 51.5547 69.8311 51.6096 69.8197C51.622 69.8171 51.6344 69.8144 51.6471 69.8117C51.6548 69.81 51.6622 69.808 51.6699 69.8064C51.6786 69.8044 51.6873 69.8024 51.6963 69.8004C51.7023 69.799 51.7087 69.7974 51.7147 69.796C51.716 69.7957 51.7174 69.7954 51.7184 69.7954C51.7207 69.7947 51.7227 69.794 51.7251 69.7937C51.7994 69.7767 51.8733 69.7613 51.9419 69.7613C51.9426 69.7613 51.9433 69.7613 51.9436 69.7613C52.0996 69.762 52.2281 69.8424 52.2753 70.1621C52.276 70.1671 52.2766 70.1721 52.2776 70.1768C52.2783 70.1798 52.2786 70.1831 52.2793 70.1857C52.3104 70.3576 52.3964 70.4477 52.5109 70.4494C52.5119 70.4494 52.5129 70.4494 52.5136 70.4494C52.5149 70.4494 52.5159 70.4494 52.5169 70.4494C52.5779 70.4484 52.6465 70.423 52.7191 70.3716C52.7204 70.3706 52.7218 70.3699 52.7231 70.3689C52.7244 70.3679 52.7258 70.3669 52.7271 70.3659C52.7341 70.3609 52.7412 70.3556 52.7482 70.3499C52.8677 70.2558 53.0236 70.0803 53.0307 69.9489C53.0313 69.9342 53.0323 69.9195 53.033 69.9045C53.0682 69.2111 52.9968 68.5892 52.2572 68.5875C52.2562 68.5875 52.2552 68.5875 52.2542 68.5875C52.2505 68.5875 52.2472 68.5875 52.2435 68.5875H52.2432C52.2395 68.5875 52.2361 68.5875 52.2325 68.5878H52.2321C52.2288 68.5878 52.2251 68.5878 52.2217 68.5878C52.2214 68.5878 52.2211 68.5878 52.2204 68.5878C52.2174 68.5882 52.2137 68.5882 52.2104 68.5882C52.21 68.5882 52.2097 68.5882 52.2094 68.5882C52.206 68.5885 52.2027 68.5885 52.1993 68.5885C52.199 68.5885 52.1986 68.5885 52.1983 68.5888C52.1946 68.5888 52.191 68.5888 52.1876 68.5892C52.1873 68.5892 52.1873 68.5892 52.1869 68.5892C52.1796 68.5895 52.1719 68.5898 52.1642 68.5905C52.1639 68.5905 52.1635 68.5905 52.1632 68.5905C52.1615 68.5905 52.1602 68.5902 52.1585 68.5898C52.1528 68.5885 52.1471 68.5845 52.1411 68.5785C52.1397 68.5775 52.1388 68.5758 52.1374 68.5745C52.1066 68.5401 52.0751 68.457 52.0718 68.401C52.0718 68.3993 52.0718 68.3973 52.0718 68.3957C52.0718 68.394 52.0715 68.3923 52.0715 68.3906C52.0718 68.3179 52.1127 68.1911 52.1542 68.1738C52.7178 67.9335 53.285 67.7093 53.8258 67.4914C53.9109 67.0113 53.9875 66.5785 54.0645 66.1457C54.1224 65.9742 54.1803 65.8024 54.2379 65.6306C54.2964 65.4631 54.3546 65.2952 54.4129 65.1277C54.4243 65.1424 54.4356 65.1567 54.4474 65.1714C54.7352 65.5341 55.0277 65.8808 55.4926 65.8822C55.4936 65.8822 55.4945 65.8822 55.4952 65.8822C55.4956 65.8822 55.4962 65.8822 55.4966 65.8822C55.5765 65.8822 55.6619 65.8715 55.7536 65.8491C55.7546 65.8491 55.7559 65.8488 55.7573 65.8488H55.7576C55.7583 65.8488 55.7593 65.8488 55.76 65.8488C55.7633 65.8495 55.7666 65.8508 55.77 65.8528C55.7727 65.8544 55.775 65.8565 55.7777 65.8588C55.778 65.8591 55.7787 65.8598 55.779 65.8601C55.7824 65.8631 55.7857 65.8671 55.7887 65.8715C55.7924 65.8758 55.7958 65.8805 55.7991 65.8861C55.7994 65.8865 55.7995 65.8868 55.7998 65.8868C55.8051 65.8958 55.8108 65.9055 55.8165 65.9165C55.8195 65.9222 55.8225 65.9282 55.8255 65.9342C55.8302 65.9442 55.8353 65.9546 55.8403 65.9656C55.8627 66.0153 55.8858 66.0737 55.9082 66.1257C55.9139 66.1387 55.9196 66.1514 55.9253 66.1634C55.9286 66.1708 55.932 66.1778 55.9353 66.1844C55.936 66.1858 55.9367 66.1871 55.9373 66.1888C55.938 66.1898 55.9384 66.1908 55.939 66.1918C55.94 66.1934 55.9407 66.1954 55.9417 66.1971C55.778 66.8331 55.1853 67.2702 55.1873 68.0086C55.1877 68.0513 55.1897 68.095 55.194 68.1401C55.1967 68.1678 55.198 68.1951 55.198 68.2221C55.1984 68.6279 54.9099 68.9639 54.5149 69.1404C54.3091 69.2325 54.1046 69.3963 53.9413 69.5788C53.8068 69.729 53.7422 69.9605 53.7422 70.2034C53.7422 70.4106 53.7894 70.6262 53.8801 70.806C53.9473 70.9388 54.0608 71.0056 54.2047 71.0066C54.2061 71.0066 54.2071 71.0066 54.2084 71.0066C54.2124 71.0066 54.2168 71.0066 54.2211 71.0066C54.3406 71.0036 54.4805 70.9565 54.6324 70.8654C54.6385 70.8621 54.6445 70.8584 54.6505 70.8547C54.6606 70.8484 54.6706 70.8421 54.681 70.8354C55.027 70.6108 55.3771 70.3963 55.5849 69.9645C55.7382 69.6465 55.8804 69.3162 56.0722 69.0286C56.1428 68.9228 56.3447 68.8865 56.4802 68.8865C56.5896 68.8861 56.6526 69.0213 56.6529 69.1858C56.6532 69.2965 56.6248 69.4207 56.5635 69.5261C56.4755 69.6766 56.3386 69.7907 56.2406 69.9358C56.1545 70.0629 56.0719 70.2355 56.0716 70.3649C56.0716 70.458 56.114 70.5291 56.2285 70.5461C56.841 70.6365 56.5622 71.419 56.9133 71.6799C56.9387 71.809 56.9514 71.9345 56.9514 72.0556C56.9504 72.4987 56.7767 72.8871 56.4149 73.2161C56.4069 73.2161 56.3988 73.2161 56.3905 73.2161C56.3888 73.2161 56.3872 73.2161 56.3852 73.2161C56.358 73.2161 56.3306 73.2154 56.3032 73.2144C56.274 73.2134 56.2449 73.2121 56.2155 73.2108C56.2111 73.2104 56.2068 73.2104 56.2024 73.2101C56.1495 73.2077 56.097 73.2054 56.0444 73.2054C56.0434 73.2054 56.0424 73.2054 56.0417 73.2054C56.0394 73.2054 56.0374 73.2054 56.0351 73.2054C55.9521 73.2057 55.8697 73.2118 55.7887 73.2318C55.7821 73.2334 55.7754 73.2351 55.769 73.2368C55.5983 73.2842 55.4905 73.4603 55.4905 73.6318C55.4902 73.7113 55.5133 73.7896 55.5635 73.8537C55.6977 74.0242 55.8992 74.1217 56.0712 74.2515L56.0719 74.2518C55.9698 74.5861 55.8004 74.9368 55.8004 75.2311C55.8001 75.4947 55.9357 75.7126 56.3771 75.832C56.5488 75.8784 56.5776 76.4139 56.6719 76.7232C56.598 76.7229 56.5214 76.7136 56.4451 76.7049C56.3842 76.6982 56.3232 76.6922 56.264 76.6919C56.262 76.6919 56.26 76.6916 56.2579 76.6916C56.2573 76.6916 56.2566 76.6916 56.256 76.6916C56.172 76.6919 56.0923 76.7042 56.021 76.7433C55.8557 76.8334 55.7616 77.2785 55.6274 77.3022C55.599 77.3072 55.5725 77.3098 55.5481 77.3098C55.5478 77.3098 55.5474 77.3098 55.5474 77.3098Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M55.1771 82.5327C54.8341 82.2091 54.6694 81.7743 54.6698 81.2361C54.6698 81.2317 54.6698 81.2277 54.6698 81.2234C54.6698 81.2191 54.6698 81.2151 54.6698 81.2107C54.6705 80.6739 54.5162 80.2331 54.1694 79.9108C54.1781 79.8998 54.1868 79.8884 54.1952 79.8774C54.4372 79.5658 54.6795 79.3322 54.9452 79.3305C54.9462 79.3302 54.9472 79.3302 54.9482 79.3302C54.9496 79.3302 54.9509 79.3302 54.9522 79.3302C55.1008 79.3316 55.2565 79.4056 55.4235 79.5791C55.4245 79.5798 55.4251 79.5804 55.4258 79.5814C55.4278 79.5834 55.4298 79.5855 55.4318 79.5878C55.4368 79.5928 55.4415 79.5978 55.4462 79.6031C55.4489 79.6058 55.4516 79.6088 55.4539 79.6115C55.4556 79.6135 55.4573 79.6152 55.459 79.6168C55.459 79.6172 55.4593 79.6172 55.4593 79.6172C55.5125 79.6722 55.5891 79.7006 55.6655 79.7016C55.6668 79.7016 55.6678 79.7016 55.6691 79.7016C55.6698 79.7016 55.6701 79.7016 55.6708 79.7016C55.804 79.7009 55.9342 79.6165 55.9328 79.4447C55.9328 79.442 55.9328 79.439 55.9328 79.4363C55.9322 79.4193 55.9319 79.4026 55.9319 79.3859C55.9329 78.6953 56.4051 78.3619 56.7307 77.9098C56.7334 77.9105 56.7361 77.9115 56.7387 77.9125C56.897 77.9665 57.0554 77.9895 57.2137 77.9895C57.2143 77.9895 57.215 77.9895 57.2157 77.9895C57.2173 77.9895 57.219 77.9895 57.2207 77.9895C57.6123 77.9885 58.0032 77.8497 58.3934 77.7046C58.4031 77.7009 58.4125 77.6976 58.4222 77.6939C58.4272 77.6919 58.4322 77.6903 58.4372 77.6883C58.4389 77.6876 58.4406 77.6872 58.4419 77.6866C58.448 77.6842 58.4536 77.6822 58.4593 77.6799C58.4664 77.6776 58.4737 77.6749 58.4807 77.6722C58.4868 77.6699 58.4928 77.6676 58.4992 77.6652C58.5541 77.6449 58.635 77.5241 58.6347 77.464C58.6347 77.462 58.6347 77.4603 58.6344 77.4583C58.62 77.3182 58.5882 77.1587 58.5112 77.066C58.4178 76.9535 58.2702 76.9021 58.1421 76.8217C58.1949 76.1834 58.4566 75.6546 58.8375 75.1471C59.0899 74.8111 59.2699 74.3953 59.4473 73.9979C59.5029 73.8738 59.5263 73.7553 59.5259 73.6419C59.5253 73.426 59.4373 73.2295 59.3181 73.05C59.3737 72.8774 59.4289 72.7049 59.4844 72.5328C59.9105 72.6766 60.3362 72.8201 60.7623 72.9642C60.7077 73.1344 60.6538 73.3045 60.5999 73.4754C59.7462 73.9792 59.5624 74.8007 59.5627 75.6796C59.5627 75.7747 59.5651 75.8704 59.5688 75.9665C59.5859 76.3949 59.7241 76.801 59.8071 77.2171C59.7622 77.44 59.6561 77.6869 59.6555 77.8924C59.6551 77.9258 59.6578 77.9585 59.6642 77.9895C59.6963 78.1487 59.711 78.2998 59.711 78.4443C59.7094 79.2014 59.2913 79.7703 58.7702 80.3082L58.7706 80.3062C58.7672 80.3059 58.7639 80.3058 58.7605 80.3058C58.7579 80.3058 58.7552 80.3058 58.7525 80.3058H58.7522C58.7502 80.3058 58.7485 80.3058 58.7465 80.3058C58.5219 80.3075 58.3382 80.4189 58.1939 80.6352C58.1919 80.6385 58.1899 80.6415 58.1879 80.6448C58.1822 80.6535 58.1765 80.6622 58.1708 80.6715C58.1678 80.6705 58.1645 80.6695 58.1615 80.6685C58.1581 80.6675 58.1548 80.6662 58.1514 80.6652C58.0119 80.6218 57.8726 80.5875 57.7354 80.5871C57.7348 80.5871 57.7341 80.5868 57.7334 80.5868C57.7324 80.5868 57.7317 80.5868 57.7307 80.5871C57.5336 80.5875 57.3412 80.6595 57.1578 80.8778C57.1564 80.8794 57.1548 80.8811 57.1534 80.8827C57.1518 80.8847 57.1501 80.8868 57.1484 80.8888C57.1467 80.8911 57.1447 80.8934 57.1427 80.8958C57.133 80.8948 57.1233 80.8941 57.1136 80.8931C57.1109 80.8928 57.1082 80.8927 57.1055 80.8924C57.0999 80.8917 57.0945 80.8914 57.0888 80.8908C57.0861 80.8904 57.0835 80.8904 57.0804 80.8901C57.0798 80.8901 57.0788 80.8897 57.0778 80.8897C57.058 80.8881 57.039 80.8861 57.0202 80.8844C57.0169 80.8841 57.0135 80.8841 57.0102 80.8837C56.8974 80.8737 56.8037 80.8667 56.7233 80.8667C56.7227 80.8667 56.7217 80.8667 56.721 80.8667C56.7204 80.8667 56.72 80.8667 56.7193 80.8667C56.3562 80.8671 56.2779 81.0072 55.969 81.6135C55.9673 81.6168 55.9657 81.6201 55.964 81.6235C55.9626 81.6255 55.9616 81.6278 55.9606 81.6298C55.9573 81.6365 55.9539 81.6428 55.9506 81.6495L55.9499 81.6492C55.9466 81.6489 55.9432 81.6488 55.9399 81.6488C55.9379 81.6488 55.9362 81.6488 55.9342 81.6488C55.7012 81.6508 55.5111 81.7643 55.3662 81.9959C55.3659 81.9965 55.3656 81.9972 55.3652 81.9978C55.3605 82.0052 55.3562 82.0125 55.3515 82.0199C55.2939 82.191 55.2357 82.3619 55.1771 82.5327Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M53.5795 80.1252C53.5788 80.1252 53.5778 80.1252 53.5771 80.1252C53.4098 80.1242 53.3723 79.9738 53.3887 79.6331C53.3897 79.6107 53.3911 79.5881 53.3924 79.564C53.3941 79.5404 53.3957 79.5163 53.3974 79.4926C53.4104 79.3308 53.4305 79.1703 53.4302 79.0171C53.4299 78.8083 53.3924 78.6131 53.2478 78.4456C53.2963 78.2794 53.3455 78.1136 53.3957 77.9478C53.9225 77.4132 54.3562 76.813 54.5212 76.0219C54.7987 76.136 55.0725 76.2684 55.1628 76.6248C55.1632 76.6258 55.1635 76.6271 55.1638 76.6281C55.2365 76.9187 55.2354 77.3081 55.5453 77.3098C55.546 77.3098 55.5467 77.3098 55.5474 77.3098C55.5474 77.3098 55.5477 77.3098 55.548 77.3098C55.5725 77.3098 55.5989 77.3071 55.6273 77.3021C55.7616 77.2784 55.8556 76.8333 56.0209 76.7432C56.0922 76.7042 56.1719 76.6919 56.2559 76.6915C56.2566 76.6915 56.2572 76.6915 56.2579 76.6915C56.2599 76.6915 56.2619 76.6919 56.2639 76.6919C56.3232 76.6922 56.3841 76.6982 56.445 76.7049C56.5213 76.7135 56.5979 76.7229 56.6719 76.7232C56.7656 76.8193 56.8342 76.9224 56.8339 77.0395C56.8335 77.1236 56.7981 77.2147 56.7104 77.3158C56.617 77.4236 56.5785 77.5193 56.5789 77.6074C56.5792 77.7175 56.6398 77.8156 56.7308 77.9097C56.4052 78.3618 55.9329 78.6952 55.9319 79.3859C55.9319 79.4026 55.9322 79.4192 55.9329 79.4362C55.9329 79.4389 55.9329 79.4419 55.9329 79.4446C55.9342 79.6164 55.8041 79.7008 55.6709 79.7015C55.6702 79.7015 55.6699 79.7015 55.6692 79.7015C55.6678 79.7015 55.6669 79.7015 55.6655 79.7015C55.5892 79.7005 55.5126 79.6721 55.4594 79.6171C55.4594 79.6171 55.459 79.6171 55.459 79.6168C55.4574 79.6151 55.4557 79.6134 55.454 79.6114C55.4517 79.6088 55.449 79.6057 55.4463 79.6031C55.4416 79.5977 55.4369 79.5927 55.4319 79.5877C55.4299 79.5854 55.4279 79.5834 55.4259 79.5814C55.4252 79.5804 55.4245 79.5797 55.4235 79.5791C55.2565 79.4056 55.1009 79.3315 54.9523 79.3302C54.951 79.3302 54.9496 79.3302 54.9483 79.3302C54.9473 79.3302 54.9463 79.3301 54.9453 79.3305C54.6795 79.3321 54.4372 79.5657 54.1953 79.8773C54.1869 79.8884 54.1782 79.8997 54.1695 79.9107C54.1672 79.912 54.1651 79.9131 54.1628 79.9141C54.1548 79.9181 54.1467 79.9221 54.139 79.9257C54.1377 79.9264 54.1367 79.9267 54.1357 79.9274C54.1304 79.9301 54.1247 79.9327 54.119 79.9354C54.118 79.9361 54.117 79.9364 54.1156 79.9371C54.1133 79.9381 54.1113 79.9391 54.1089 79.9404C54.0731 79.9574 54.039 79.9734 54.0062 79.9885C54.0052 79.9891 54.0042 79.9894 54.0032 79.9901C53.8151 80.0759 53.6799 80.1232 53.5852 80.1252C53.5832 80.1252 53.5811 80.1252 53.5795 80.1252Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M51.945 76.0308C51.9446 76.0308 51.9443 76.0308 51.9439 76.0308C51.9239 76.0308 51.9081 76.0261 51.8974 76.0158C51.8967 76.0151 51.8961 76.0144 51.8954 76.0134C51.7016 75.7925 51.5922 75.4702 51.3944 75.256C51.1976 75.0428 50.9325 74.9137 50.6973 74.7478C50.8137 74.4025 50.9302 74.0565 51.0463 73.7111C51.4724 73.576 51.8981 73.4405 52.3532 73.296C52.38 73.3941 52.3907 73.4946 52.3904 73.5963C52.3901 74.0108 52.2117 74.4472 52.2117 74.8369C52.2117 75.0718 52.2763 75.2897 52.4834 75.4756C52.4895 75.4812 52.4921 75.4932 52.4921 75.5089C52.4925 75.559 52.4674 75.6477 52.4449 75.7008C52.4135 75.7749 52.3626 75.8689 52.3051 75.8953C52.301 75.8973 52.297 75.899 52.293 75.901C52.2177 75.9363 52.1206 75.9851 52.0396 76.0114C52.0396 76.0114 52.0396 76.0114 52.0393 76.0114C52.0206 76.0178 52.0025 76.0228 51.9861 76.0261C51.9797 76.0274 51.9737 76.0284 51.9677 76.0291C51.9597 76.0301 51.952 76.0308 51.945 76.0308Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M52.0772 80.0356C52.0755 80.0356 52.0739 80.0356 52.0722 80.0356C51.8546 80.03 51.6495 79.6726 51.6501 79.3073C51.6501 79.2999 51.6501 79.2926 51.6505 79.2852C51.6635 78.7477 51.858 78.3837 52.2633 78.2428C52.6355 78.1137 53.018 78.044 53.3958 77.9479C53.3456 78.1137 53.2964 78.2796 53.2479 78.4457C53.1174 78.7804 53.0143 79.1324 52.849 79.4454C52.6806 79.7647 52.4306 80.0106 52.0916 80.0353C52.0873 80.0357 52.0822 80.0356 52.0779 80.0356C52.0775 80.0356 52.0775 80.0356 52.0772 80.0356Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M49.6488 80.6882L49.6442 80.6799C49.6458 80.6796 49.6472 80.6792 49.6488 80.6792C49.6488 80.6822 49.6488 80.6852 49.6488 80.6882ZM49.6488 80.6792C49.6475 80.5751 49.6375 80.47 49.6375 80.3663C49.6375 80.3022 49.6411 80.2385 49.6532 80.1761C49.6799 80.0376 49.7512 79.8624 49.8466 79.7853C49.8711 79.766 49.8972 79.757 49.9233 79.757C49.9236 79.757 49.9239 79.757 49.9243 79.757C49.9286 79.757 49.9333 79.757 49.9376 79.7577C50.0722 79.7727 50.2077 80.0059 50.1686 80.2074C50.1683 80.2101 50.1676 80.2128 50.1669 80.2154C50.1663 80.2184 50.1656 80.2218 50.1649 80.2248C50.1636 80.2295 50.1626 80.2341 50.1612 80.2385C50.0776 80.5238 49.8858 80.6459 49.6488 80.6792Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M53.2793 72.7273C53.3921 72.391 53.5049 72.0549 53.6173 71.7186C53.7321 71.9885 53.8007 72.1497 53.8014 72.2682C53.8021 72.444 53.6521 72.5251 53.2793 72.7273Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M59.2508 84.9211C59.2478 84.9211 59.2445 84.9211 59.2411 84.9211C59.0872 84.9198 58.9359 84.8868 58.7843 84.8571C58.7371 84.8481 58.6899 84.8391 58.6424 84.8314C58.5657 84.6172 58.4891 84.4026 58.4121 84.1884C58.5938 84.125 58.6949 84.0449 58.6956 83.9218C58.6956 83.8587 58.6698 83.7843 58.6146 83.6949C58.6072 83.6829 58.5996 83.6709 58.5912 83.6586C58.469 83.4767 58.4118 83.2328 58.3254 83.0166C58.5038 82.2371 58.9289 81.6319 59.4456 81.091C59.6303 80.9232 59.8007 80.7173 60.0028 80.5972C60.0079 80.5942 60.0132 80.5912 60.0182 80.5882C60.0771 80.5555 60.1307 80.5391 60.1792 80.5375C60.1816 80.5375 60.1842 80.5375 60.1869 80.5375C60.1879 80.5375 60.1889 80.5375 60.1899 80.5375C60.3168 80.5391 60.4065 80.6459 60.4587 80.8301C60.4594 80.8324 60.46 80.8348 60.4607 80.8371C60.463 80.8458 60.4654 80.8545 60.4677 80.8635C60.5256 81.097 60.6361 81.3069 60.7234 81.5278C60.6853 81.7306 60.6123 81.9415 60.6123 82.1394C60.6123 82.2618 60.6404 82.3796 60.7218 82.4874C60.7274 82.4948 60.7334 82.5024 60.7395 82.5098C60.8208 82.6119 60.9376 82.7213 61.043 82.723C61.044 82.7233 61.0447 82.7233 61.0457 82.7233C61.046 82.7233 61.046 82.7233 61.0464 82.7233C61.048 82.7233 61.0497 82.723 61.0514 82.723C61.0534 82.723 61.0557 82.723 61.0577 82.7226C61.2495 82.707 61.5002 82.6429 61.6264 82.4901C61.6926 82.4093 61.7197 82.3266 61.7197 82.2475C61.7194 82.0943 61.616 81.9562 61.4995 81.8794C61.2622 81.7233 60.9841 81.6415 60.7234 81.5278C60.7328 81.5158 60.7418 81.5038 60.7512 81.4918C60.7532 81.4888 60.7555 81.4861 60.7575 81.4834C60.7582 81.4828 60.7585 81.4824 60.7589 81.4817C60.9975 81.1744 61.2415 80.9309 61.5213 80.9292C61.5223 80.9289 61.5233 80.9289 61.5246 80.9289C61.5253 80.9289 61.5256 80.9289 61.5263 80.9289C61.6648 80.9295 61.8121 80.9892 61.9721 81.1297C61.9751 81.1324 61.9784 81.1354 61.9818 81.1381C61.9838 81.1401 61.9858 81.142 61.9882 81.1441C61.9885 81.1444 61.9888 81.1447 61.9891 81.1451C61.9942 81.1487 62.0005 81.1507 62.0082 81.1507C62.0082 81.1507 62.0082 81.1507 62.0086 81.1507C62.0708 81.1507 62.2164 81.0336 62.3265 80.9656C62.3352 80.9602 62.3439 80.9552 62.3523 80.9505C62.3536 80.9499 62.355 80.9489 62.3563 80.9482C62.5749 81.3463 62.6652 81.7593 62.6652 82.1838C62.6655 82.7043 62.53 83.2408 62.3282 83.7857C62.3215 83.7847 62.3145 83.784 62.3078 83.7834C62.3044 83.7827 62.3007 83.7824 62.2971 83.782C62.2904 83.7814 62.2837 83.7803 62.277 83.7797C62.1147 83.7613 61.9885 83.7483 61.8857 83.748C61.8841 83.748 61.8821 83.748 61.8804 83.748C61.8797 83.748 61.8791 83.748 61.8784 83.748C61.539 83.7483 61.456 83.8931 61.1525 84.4694C61.1511 84.4717 61.1498 84.474 61.1488 84.4764C61.1465 84.4807 61.1441 84.4851 61.1418 84.4897C61.1388 84.4954 61.1357 84.5011 61.1327 84.5067L61.1274 84.5077C61.0082 84.2341 60.8887 83.9602 60.7421 83.6235C60.2137 83.7727 60.2214 84.6456 59.6882 84.77C59.547 84.803 59.4048 84.9185 59.2699 84.9211C59.2635 84.9211 59.2572 84.9211 59.2508 84.9211Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M57.3559 84.3242C57.3555 84.3242 57.3549 84.3242 57.3545 84.3242C56.8164 84.3236 56.7083 84.0503 56.47 83.0282C56.4693 83.0246 56.4683 83.0209 56.4676 83.0176C56.4663 83.0122 56.4653 83.0072 56.4639 83.0019C56.4609 82.9882 56.4576 82.9745 56.4546 82.9609C56.559 82.9609 56.6637 82.9602 56.7682 82.9598C56.817 82.9595 56.8662 82.9592 56.9151 82.9589C56.9626 82.9589 57.0101 82.9589 57.058 82.9589C57.0593 82.9589 57.0607 82.9589 57.062 82.9589C57.0633 82.9589 57.065 82.9589 57.0664 82.9589C57.1373 82.9589 57.2083 82.9588 57.2792 82.9598C57.3515 82.9605 57.4238 82.9618 57.4961 82.9639C57.7739 82.9712 58.049 82.9985 58.3254 83.0169C58.4118 83.2331 58.469 83.477 58.5912 83.6589C58.5995 83.6712 58.6072 83.6832 58.6146 83.6952C58.6698 83.7847 58.6956 83.8591 58.6956 83.9221C58.6949 84.0452 58.5938 84.1253 58.4121 84.1884C58.2685 84.2134 58.1256 84.2418 57.9824 84.2621C57.9673 84.2641 57.9526 84.2661 57.9379 84.2681C57.9315 84.2691 57.9252 84.2701 57.9188 84.2711C57.9121 84.2718 57.9061 84.2728 57.8997 84.2735C57.8994 84.2738 57.899 84.2738 57.8987 84.2738C57.8893 84.2751 57.8803 84.2762 57.8713 84.2775C57.8632 84.2785 57.8552 84.2798 57.8468 84.2808C57.8401 84.2818 57.8331 84.2828 57.8261 84.2835C57.6407 84.3082 57.4874 84.3239 57.3585 84.3242C57.3575 84.3242 57.3569 84.3242 57.3559 84.3242Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M56.4537 82.9607C56.4537 82.96 56.454 82.9597 56.454 82.959C56.454 82.9597 56.4537 82.96 56.4537 82.9607ZM56.454 82.959C56.2864 82.5226 56.1184 82.0858 55.9507 81.6494C55.954 81.6427 55.9574 81.6364 55.9607 81.6297C55.9617 81.6277 55.9627 81.6254 55.9641 81.6234C55.9658 81.62 55.9674 81.6167 55.9691 81.6134C56.278 81.0074 56.3566 80.867 56.7194 80.8666C56.7201 80.8666 56.7205 80.8666 56.7211 80.8666C56.7218 80.8666 56.7228 80.8666 56.7234 80.8666C56.8038 80.8666 56.8975 80.8736 57.0103 80.8836C57.0136 80.884 57.017 80.8839 57.0203 80.8843C57.0391 80.8859 57.0581 80.888 57.0779 80.8896C57.0789 80.8896 57.0799 80.89 57.0805 80.89C57.0836 80.8903 57.0862 80.8903 57.0889 80.8906C57.0946 80.8913 57.1 80.8916 57.1056 80.8923C57.1083 80.8926 57.111 80.8926 57.1137 80.893C57.1234 80.894 57.1331 80.8947 57.1428 80.8957C56.9132 81.5837 56.6836 82.271 56.454 82.959Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M55.3542 82.0198C55.3536 82.0198 55.3526 82.0198 55.3516 82.0198C55.3562 82.0124 55.3606 82.0051 55.3653 81.9977C55.3656 81.9971 55.366 81.9964 55.3663 81.9958C55.5112 81.7642 55.7013 81.6507 55.9342 81.6487C55.9362 81.6487 55.9379 81.6487 55.9399 81.6487C55.9433 81.6487 55.9466 81.6488 55.95 81.6491C55.9443 81.6578 55.939 81.6668 55.9333 81.6755C55.786 81.9023 55.5959 82.0171 55.363 82.0198C55.3603 82.0198 55.3573 82.0198 55.3542 82.0198Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M41.5719 81.6643C41.5709 81.6643 41.5699 81.6643 41.5689 81.6643C41.3828 81.6636 41.1961 81.6132 41.0046 81.5061C40.9989 81.5031 40.9933 81.4998 40.9879 81.4968C40.9856 81.4955 40.9832 81.4941 40.9812 81.4931C40.9799 81.4924 40.9785 81.4918 40.9772 81.4911C40.9424 81.4738 40.9029 81.4671 40.8597 81.4668C40.8594 81.4668 40.8587 81.4668 40.8584 81.4668C40.8524 81.4668 40.8463 81.4668 40.8403 81.4671C40.7586 81.4704 40.6656 81.4958 40.5726 81.5218C40.4966 81.5432 40.4203 81.5649 40.3493 81.5755C40.3741 81.3847 40.4511 81.081 40.4508 80.9452C40.4508 80.9089 40.4451 80.8842 40.4313 80.8772C39.5367 80.4124 39.8001 79.2582 39.5056 78.4451C39.5217 78.4438 39.5374 78.4424 39.5531 78.4414C39.5906 78.4384 39.6265 78.4357 39.6609 78.4331C39.766 78.4251 39.857 78.4191 39.936 78.4161C39.9384 78.4161 39.9407 78.4161 39.943 78.4161C39.9678 78.4151 39.9916 78.4147 40.014 78.4147C40.016 78.4144 40.018 78.4144 40.02 78.4144C40.0204 78.4144 40.021 78.4144 40.0217 78.4144C40.421 78.4151 40.4675 78.5445 40.597 79.0997C40.6713 79.4171 40.6485 79.7561 41.0274 79.7754C41.3761 79.7931 41.4511 80.1468 41.5867 80.4177C41.5873 80.4194 41.5883 80.4211 41.589 80.4227C41.5947 80.4338 41.6004 80.4444 41.6064 80.4548C41.6111 80.4631 41.6158 80.4711 41.6205 80.4788C41.6218 80.4805 41.6231 80.4825 41.6241 80.4845C41.6258 80.4868 41.6272 80.4888 41.6285 80.4911C41.6402 80.5088 41.6522 80.5252 41.6646 80.5402C41.6663 80.5418 41.6677 80.5435 41.669 80.5452C41.7594 80.651 41.8664 80.6833 41.9809 80.6833C42.0713 80.6833 42.1663 80.663 42.261 80.6429C42.2647 80.6423 42.2681 80.6413 42.2717 80.6406C42.2811 80.6386 42.2905 80.6366 42.3002 80.6346C42.3152 80.6316 42.33 80.6286 42.345 80.6256C42.3621 80.6222 42.3792 80.6193 42.3962 80.6163C42.4103 80.6139 42.4243 80.6119 42.4381 80.6099C42.4685 80.6059 42.499 80.6032 42.5288 80.6029C42.5328 80.6026 42.5371 80.6026 42.5415 80.6026C42.5418 80.6026 42.5422 80.6026 42.5425 80.6026C42.5452 80.6026 42.5475 80.6026 42.5498 80.6026C42.5502 80.6026 42.5508 80.6026 42.5512 80.6026C42.5545 80.6029 42.5575 80.6029 42.5609 80.6029C42.6466 80.8241 42.7322 81.045 42.8176 81.2662C42.6743 81.2989 42.5137 81.2896 42.3919 81.3713C42.3895 81.3727 42.3875 81.3743 42.3852 81.3757C42.3818 81.378 42.3785 81.38 42.3752 81.3824C42.3725 81.384 42.3701 81.3857 42.3674 81.3873C42.0957 81.5652 41.8356 81.6633 41.5753 81.6643C41.5743 81.6643 41.5733 81.6643 41.5719 81.6643Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M44.169 85.7126C44.0314 85.6666 43.8922 85.6239 43.7523 85.5852C43.7095 85.3399 43.6967 85.077 43.6161 84.8545C43.6151 84.8511 43.6137 84.8481 43.6124 84.8448C43.6121 84.8438 43.6117 84.8428 43.6114 84.8418C43.5569 84.7006 43.4668 84.6192 43.3594 84.6172C43.358 84.6172 43.3567 84.6172 43.3554 84.6172C43.3544 84.6172 43.353 84.6172 43.3517 84.6172C43.277 84.6185 43.1944 84.6579 43.1104 84.742C43.1104 84.7423 43.11 84.7423 43.11 84.7423C43.1074 84.745 43.1047 84.7477 43.102 84.7507C43.1007 84.7517 43.0997 84.753 43.0987 84.754C43.0943 84.7584 43.0903 84.7624 43.0863 84.7667C43.0863 84.7667 43.0863 84.7667 43.086 84.7667C42.9591 84.8932 42.857 84.9426 42.7703 84.9442C42.7687 84.9442 42.7673 84.9442 42.766 84.9442C42.7653 84.9442 42.765 84.9442 42.7646 84.9442C42.5725 84.9432 42.4558 84.7086 42.3092 84.5672C42.2978 84.5565 42.2864 84.5462 42.2747 84.5368C42.274 84.5362 42.2734 84.5355 42.2727 84.5348C42.2647 84.5285 42.2569 84.5225 42.2489 84.5168C42.2479 84.5161 42.2473 84.5158 42.2463 84.5151C42.2372 84.5088 42.2282 84.5031 42.2188 84.4978C42.2171 84.4968 42.2151 84.4958 42.2134 84.4948L42.2121 84.4901C42.2161 84.4514 42.2178 84.4143 42.2178 84.378C42.2175 84.1434 42.1325 83.9609 41.9604 83.8324C41.9614 83.8311 41.9625 83.8301 41.9631 83.8288C41.9665 83.8244 41.9698 83.8201 41.9732 83.8158C41.9762 83.8118 41.9795 83.8077 41.9825 83.8037C41.9862 83.7987 41.9902 83.7941 41.9939 83.7894C42.2868 83.419 42.6311 83.1521 43.0274 83.1501C43.0287 83.1501 43.0304 83.1498 43.0321 83.1498C43.0324 83.1498 43.0327 83.1498 43.0327 83.1498C43.0763 83.1501 43.1201 83.1531 43.1649 83.1598C43.1663 83.1601 43.1676 83.1601 43.1689 83.1605C43.173 83.1611 43.1767 83.1618 43.1807 83.1621C43.8166 83.2679 44.2175 83.7961 44.3919 84.439C44.4072 84.4954 44.414 84.5558 44.4136 84.6199C44.4133 84.9449 44.2402 85.3533 44.169 85.7126ZM41.9604 83.8324C41.9598 83.8321 41.9594 83.8314 41.9587 83.8311C41.9594 83.8314 41.9598 83.8321 41.9604 83.8324Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M41.9808 80.6833C41.8663 80.6833 41.7592 80.651 41.6689 80.5452C41.6675 80.5436 41.6662 80.5419 41.6645 80.5402C41.6521 80.5252 41.6401 80.5089 41.6284 80.4912C41.627 80.4888 41.6257 80.4868 41.624 80.4845C41.623 80.4825 41.6217 80.4805 41.6203 80.4788C41.6156 80.4711 41.611 80.4631 41.6063 80.4548C41.6002 80.4445 41.5945 80.4338 41.5889 80.4228C41.5882 80.4211 41.5872 80.4194 41.5865 80.4178C41.451 80.1468 41.376 79.7931 41.0273 79.7754C40.6484 79.7561 40.6712 79.4171 40.5969 79.0998C40.4674 78.5446 40.4208 78.4151 40.0216 78.4144C40.0209 78.4144 40.0202 78.4144 40.0199 78.4144C40.0179 78.4144 40.0159 78.4144 40.0139 78.4148C39.9914 78.4148 39.9677 78.4151 39.9429 78.4161C39.9406 78.4161 39.9382 78.4161 39.9359 78.4161C39.8569 78.4191 39.7659 78.4251 39.6608 78.4331C39.6263 78.4358 39.5905 78.4384 39.553 78.4414C39.5373 78.4424 39.5215 78.4438 39.5055 78.4451C39.3519 78.2806 39.2953 78.0951 39.2957 77.8972C39.296 77.6964 39.3552 77.4828 39.4315 77.2653C39.5828 77.3086 39.7347 77.3524 39.8863 77.3957C40.3636 77.3223 40.789 77.0808 41.0467 76.5799C41.2963 76.0958 41.5748 75.8519 42.0142 75.8506C42.0156 75.8506 42.0166 75.8506 42.0179 75.8506C42.0179 75.8506 42.0182 75.8506 42.0186 75.8506C42.0654 75.8506 42.114 75.8532 42.1645 75.8586C42.205 75.8632 42.2462 75.8652 42.2873 75.8652C42.2877 75.8652 42.288 75.8652 42.2883 75.8652C42.2897 75.8652 42.291 75.8652 42.292 75.8652C42.5437 75.8645 42.8084 75.7905 43.0701 75.7324C43.0705 75.7324 43.0705 75.7324 43.0705 75.7324C43.0845 75.7291 43.0983 75.7261 43.1123 75.7231C43.1568 75.7137 43.2013 75.7047 43.2455 75.6967C43.2505 75.6957 43.2552 75.6947 43.2602 75.6941C43.2653 75.693 43.2703 75.6924 43.2753 75.6914C43.2753 75.6924 43.2753 75.6937 43.275 75.6947C43.2766 75.6957 43.2783 75.6967 43.2797 75.6981C43.275 75.7401 43.2723 75.7805 43.2723 75.8192C43.2723 76.0394 43.353 76.2102 43.5196 76.3277V76.328L43.5246 76.331C43.4125 76.676 43.3001 77.021 43.188 77.3661C43.19 77.3707 43.192 77.3757 43.194 77.3804C43.1953 77.3844 43.197 77.3881 43.1983 77.3917C43.2007 77.3971 43.2027 77.4024 43.205 77.4074C43.2053 77.4084 43.2057 77.4091 43.206 77.4098C43.207 77.4121 43.2077 77.4144 43.2087 77.4168C43.211 77.4221 43.2134 77.4275 43.2154 77.4328C43.2171 77.4365 43.2184 77.4401 43.2201 77.4438C43.2204 77.4445 43.2207 77.4451 43.2207 77.4458C43.4189 77.9216 43.523 78.1268 43.7291 78.1278C43.7295 78.1278 43.7298 78.1278 43.7301 78.1278C43.7425 78.1278 43.7552 78.1268 43.7683 78.1255C43.9088 78.1101 44.0966 78.0124 44.3828 77.8495C44.3851 77.8482 44.3871 77.8472 44.3895 77.8459C44.3915 77.8445 44.3938 77.8435 44.3958 77.8422C44.4042 77.8375 44.4125 77.8328 44.4209 77.8278C44.4289 77.8235 44.437 77.8188 44.4453 77.8142C44.4487 77.8122 44.452 77.8102 44.4557 77.8082C44.4594 77.8058 44.4634 77.8035 44.4674 77.8015C44.6076 77.8512 44.7472 77.9013 44.8871 77.9513C44.8466 78.1105 44.7753 78.274 44.7753 78.4271C44.7753 78.4281 44.7753 78.4295 44.7753 78.4305C44.776 78.5309 44.8787 78.6206 44.949 78.6997C44.949 78.7 44.9497 78.7 44.9504 78.7C44.9658 78.7 45.0739 78.616 45.1056 78.5549C45.1816 78.4098 45.2375 78.2523 45.3011 78.0998C45.4614 78.28 45.5183 78.4678 45.5186 78.6603C45.5196 79.0217 45.3212 79.3984 45.2295 79.7668C45.0267 79.8882 44.8239 80.01 44.6214 80.1318C44.4875 80.0727 44.3396 80.0374 44.2221 79.9513C44.2091 79.9419 44.196 79.9323 44.1833 79.9233C44.1813 79.9216 44.1793 79.9203 44.1772 79.9186C44.1729 79.9156 44.1685 79.9122 44.1645 79.9092C44.1615 79.9072 44.1585 79.9049 44.1555 79.9029C44.1525 79.9006 44.1495 79.8986 44.1465 79.8962C44.1414 79.8926 44.1361 79.8886 44.1311 79.8849C44.1304 79.8846 44.1301 79.8842 44.1297 79.8839C44.1183 79.8759 44.1073 79.8675 44.0963 79.8595C43.7345 79.5963 43.5096 79.4435 43.3359 79.4358C43.3312 79.4355 43.3268 79.4354 43.3222 79.4354C43.3218 79.4354 43.3211 79.4354 43.3208 79.4354C43.0675 79.4368 42.9209 79.7588 42.5989 80.5128C42.5889 80.5369 42.5785 80.5612 42.5678 80.5862C42.5654 80.5919 42.5631 80.5973 42.5608 80.6029C42.5574 80.6029 42.5544 80.6029 42.5511 80.6026C42.5507 80.6026 42.55 80.6026 42.5497 80.6026C42.5474 80.6026 42.545 80.6026 42.5424 80.6026C42.542 80.6026 42.5417 80.6026 42.5413 80.6026C42.537 80.6026 42.5326 80.6026 42.5286 80.6029C42.4988 80.6033 42.4684 80.6059 42.4379 80.6099C42.4242 80.6119 42.4102 80.614 42.3961 80.6163C42.379 80.6193 42.362 80.6223 42.3449 80.6256C42.3298 80.6286 42.3151 80.6316 42.3 80.6346C42.2903 80.6366 42.281 80.6386 42.2716 80.6406C42.2679 80.6413 42.2646 80.6423 42.2609 80.643C42.1662 80.663 42.0711 80.6833 41.9808 80.6833Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M46.508 79.9114C46.5073 79.9114 46.5066 79.9111 46.506 79.9111C46.3754 79.9107 46.2362 79.872 46.0873 79.7806C46.0093 79.7325 45.9143 79.7169 45.8109 79.7165C45.8102 79.7165 45.8095 79.7165 45.8085 79.7165C45.8055 79.7165 45.8028 79.7165 45.7998 79.7165C45.7248 79.7172 45.6455 79.7255 45.5655 79.7356C45.4518 79.7492 45.3366 79.7663 45.2295 79.7673C45.3212 79.3989 45.5197 79.0222 45.5187 78.6608C45.5183 78.4683 45.4614 78.2804 45.3011 78.1003C45.1659 78.0432 45.028 77.9938 44.8871 77.9518C44.7472 77.9017 44.6077 77.8517 44.4674 77.802C44.4902 77.7209 44.5274 77.6395 44.5324 77.5594C44.5347 77.5254 44.5367 77.493 44.5384 77.4623C44.5384 77.4616 44.5384 77.4613 44.5384 77.4606C44.5384 77.4586 44.5384 77.4563 44.5388 77.4543C44.5528 77.164 44.5304 77.0299 44.441 77.0292C44.4407 77.0292 44.4404 77.0292 44.44 77.0292C44.4357 77.0292 44.431 77.0295 44.4263 77.0302C44.3791 77.0365 44.3155 77.0746 44.2322 77.1413C44.2319 77.1413 44.2318 77.1413 44.2315 77.1416C44.2258 77.1463 44.2198 77.151 44.2138 77.156C44.2128 77.157 44.2118 77.1576 44.2104 77.1586C44.2077 77.161 44.2051 77.163 44.2024 77.1653C44.2017 77.166 44.2007 77.167 44.1997 77.1677C44.197 77.17 44.194 77.1723 44.1913 77.1747C44.1883 77.1773 44.1853 77.1797 44.1826 77.182C44.1816 77.1827 44.1806 77.1837 44.1796 77.1844C44.1773 77.1864 44.1749 77.1884 44.1729 77.19C44.1699 77.1924 44.1669 77.195 44.1639 77.1974C44.1619 77.1987 44.1602 77.2004 44.1582 77.2017C43.9504 77.3672 43.7589 77.4273 43.5665 77.4279C43.5658 77.4279 43.5652 77.4279 43.5642 77.4279C43.5622 77.4279 43.5605 77.4279 43.5585 77.4279C43.4517 77.4273 43.3443 77.4082 43.2335 77.3792C43.2305 77.3782 43.2275 77.3775 43.2245 77.3769C43.2124 77.3735 43.2 77.3702 43.188 77.3665C43.3001 77.0215 43.4125 76.6765 43.5247 76.3315C43.523 76.3305 43.5217 76.3295 43.5203 76.3285C44.9039 76.2391 45.8209 75.4086 46.27 73.8347V73.8343C46.3972 74.0142 46.4548 74.2094 46.4544 74.4316C46.4541 74.5401 46.4397 74.6552 46.4126 74.778C46.2724 75.4173 45.8276 75.8313 45.5254 76.3572C45.5254 76.3625 45.5254 76.3675 45.5257 76.3729C45.5257 76.3749 45.5257 76.3769 45.5257 76.3792C45.526 76.3836 45.5261 76.3876 45.5261 76.3919C45.5264 76.3922 45.5264 76.3926 45.5264 76.3932C45.5264 76.3952 45.5264 76.3972 45.5264 76.3996C45.5264 76.4002 45.5267 76.4012 45.5267 76.4019C45.5274 76.4152 45.5281 76.4279 45.5291 76.4403C45.5291 76.4403 45.5294 76.4406 45.5294 76.4409C45.5297 76.4449 45.5301 76.449 45.5304 76.453C45.5314 76.4623 45.5324 76.4716 45.5337 76.4803C45.5337 76.4806 45.5337 76.4806 45.5337 76.481C45.5709 76.7472 45.7269 76.7856 45.9083 76.7856C45.9451 76.7856 45.9829 76.7843 46.021 76.7826C46.0592 76.7809 46.0977 76.7793 46.1355 76.7793C46.2848 76.7793 46.4257 76.804 46.5107 76.9501C46.5117 76.9521 46.513 76.9541 46.514 76.9565C46.515 76.9578 46.516 76.9594 46.5167 76.9611C46.6857 77.2744 47.0816 77.4052 47.3761 77.6178L47.3768 77.6261C47.3678 77.6812 47.3637 77.7336 47.3637 77.7836C47.3644 77.9998 47.4477 78.1673 47.6121 78.2871C47.5786 78.6221 47.6509 79.0899 47.4903 79.2647C47.4862 79.2694 47.4819 79.2741 47.4776 79.2787C47.4759 79.2804 47.4746 79.2821 47.4729 79.2841C47.4679 79.2894 47.4628 79.2948 47.4578 79.3001C47.4561 79.3021 47.4545 79.3038 47.4528 79.3058C47.4461 79.3128 47.4394 79.3201 47.4327 79.3275C47.4304 79.3301 47.428 79.3328 47.4254 79.3355C47.1606 79.6214 46.8678 79.9087 46.5123 79.9111C46.511 79.9111 46.5093 79.9114 46.508 79.9114Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M47.6122 78.2869C47.6185 78.2395 47.6215 78.1938 47.6215 78.1504C47.6209 77.9278 47.5382 77.7537 47.3769 77.6259L47.3762 77.6175C47.4863 77.2799 47.5944 76.9418 47.7069 76.6052C47.7075 76.6028 47.7082 76.6005 47.7092 76.5982C47.7102 76.5952 47.7112 76.5922 47.7122 76.5889C47.7183 76.5705 47.7246 76.5521 47.731 76.5338C47.8401 76.2171 47.9676 75.9405 48.227 75.9375C48.2283 75.9375 48.2296 75.9375 48.2313 75.9375C48.232 75.9375 48.2327 75.9375 48.233 75.9375C48.31 75.9379 48.398 75.9619 48.5004 76.016C48.5027 76.017 48.5051 76.0183 48.5074 76.0196C48.5098 76.0209 48.5121 76.022 48.5145 76.0233C48.5172 76.0246 48.5198 76.026 48.5229 76.0273C48.5352 76.032 48.5499 76.0346 48.566 76.035C48.5673 76.035 48.5687 76.035 48.57 76.035C48.5727 76.035 48.575 76.035 48.5777 76.0346C48.6293 76.033 48.6902 76.0113 48.721 75.9783C48.7334 75.9652 48.7454 75.9522 48.7575 75.9399C48.984 75.7076 49.1744 75.6152 49.3411 75.6132C49.3428 75.6132 49.3448 75.6132 49.3468 75.6132C49.3481 75.6132 49.3492 75.6132 49.3505 75.6132C49.6648 75.6159 49.896 75.9389 50.132 76.2445C50.1443 76.2602 50.1567 76.2762 50.1691 76.2922C50.0058 76.6833 49.8753 77.0987 49.6647 77.456C49.551 77.6492 49.2916 77.8448 49.1135 77.8491C49.1125 77.8491 49.1119 77.8491 49.1112 77.8491C49.1105 77.8491 49.1102 77.8491 49.1095 77.8491C49.0048 77.8471 48.9161 77.6682 48.8224 77.5154C48.8183 77.5094 48.8147 77.5031 48.8107 77.4971C48.8073 77.4914 48.804 77.4861 48.8006 77.4807C48.7963 77.4741 48.7919 77.4674 48.7872 77.4607C48.7842 77.456 48.7809 77.4511 48.7775 77.4464C48.7758 77.444 48.7742 77.4417 48.7728 77.4393C48.7708 77.4367 48.7688 77.434 48.7672 77.4314C48.7591 77.42 48.7511 77.4093 48.7427 77.399C48.7424 77.3986 48.7417 77.398 48.7414 77.3973C48.7009 77.3476 48.642 77.3192 48.5901 77.2805C48.2297 77.5688 48.1607 78.2532 47.6122 78.2869Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M89.13 84.1694C88.8656 84.078 88.5979 83.9869 88.3335 83.8958C88.5644 83.2515 88.7953 82.6076 89.0296 81.9636C89.2304 82.1992 89.4346 82.4347 89.6354 82.6703C89.4681 83.1701 89.2974 83.6696 89.13 84.1694Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M85.681 81.8787C85.583 81.7188 85.5271 81.6274 85.5271 81.562C85.5274 81.4753 85.6268 81.4339 85.8578 81.3381C85.7989 81.5183 85.7396 81.6988 85.681 81.8787Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M87.5147 77.9219L87.4996 77.8922C87.2188 77.8001 86.938 77.708 86.6572 77.6162C86.3794 77.4084 86.104 77.1961 85.8225 76.9949C85.5963 76.8335 85.3623 76.6853 85.1321 76.5315V76.5281C85.1793 76.1087 85.1314 75.6406 85.2954 75.2809C85.4869 74.8618 85.5759 74.4691 85.5755 74.056C85.5755 73.9779 85.5725 73.8989 85.5662 73.8188C85.7061 73.8868 85.8486 73.9119 85.9929 73.9122C85.9936 73.9122 85.9942 73.9122 85.9949 73.9122C85.9976 73.9122 86.0003 73.9122 86.0029 73.9122C86.276 73.9105 86.5541 73.8208 86.8302 73.7651C86.8389 73.7634 86.8473 73.7617 86.856 73.7601C86.8627 73.7587 86.8694 73.7577 86.8761 73.7564C86.9012 73.7517 86.926 73.7474 86.9511 73.7434C86.9524 73.743 86.9538 73.7431 86.9551 73.7427C86.9762 73.7394 86.9969 73.7367 87.0177 73.734C87.1522 73.7794 87.2868 73.8241 87.4223 73.8678L87.4581 73.8892C87.2017 74.1771 86.945 74.4651 86.6883 74.753C86.679 74.8101 86.6743 74.8648 86.6743 74.9165C86.6743 75.1301 86.7543 75.2986 86.9149 75.4211L86.9139 75.4257C86.9142 75.4284 86.9146 75.4311 86.9149 75.4334C86.9159 75.4451 86.9176 75.4568 86.9189 75.4681C86.9866 75.9746 87.2737 76.1668 87.6673 76.1675C87.6706 76.1675 87.6706 76.1675 87.6706 76.1675C87.7108 76.1675 87.7543 76.1654 87.7945 76.1614C88.0789 76.1354 88.3634 76.0347 88.6479 75.9676L88.6713 75.9739C88.4303 76.727 88.0421 77.3757 87.5147 77.9219Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M87.5871 79.0837C87.241 78.9509 86.9087 78.8028 86.9097 78.2756C87.1577 78.2729 87.3588 78.1565 87.4997 77.8919L87.5148 77.9216C87.6674 78.0758 87.7209 78.2526 87.7209 78.4411C87.7209 78.6453 87.6607 78.8632 87.5938 79.0824L87.5871 79.0837Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M87.6105 81.2686C86.6982 81.0297 86.3638 80.9419 86.0315 80.8548C86.0385 79.8988 86.0459 78.9429 86.0536 77.9873C86.2008 78.03 86.3484 78.0727 86.4954 78.1154C86.6326 78.1705 86.7708 78.2242 86.9097 78.2759C86.9087 78.8031 87.241 78.9512 87.5871 79.084C87.3163 79.4227 86.9418 79.736 86.9422 80.1708C86.9425 80.4654 87.1155 80.8161 87.6105 81.2686Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M56.3604 66.3269C56.2225 66.2782 56.083 66.2351 55.9417 66.1971C55.9407 66.1954 55.9401 66.1934 55.9391 66.1917C55.9384 66.1907 55.938 66.1897 55.9374 66.1887C55.9367 66.1871 55.936 66.1857 55.9354 66.1844C55.932 66.1777 55.9287 66.1707 55.9253 66.1634C55.9196 66.1514 55.914 66.1387 55.9083 66.1257C55.8858 66.0736 55.8627 66.0153 55.8403 65.9655C55.8353 65.9545 55.8303 65.9442 55.8256 65.9342C55.8226 65.9282 55.8196 65.9221 55.8166 65.9165C55.8109 65.9055 55.8052 65.8958 55.7998 65.8868C55.7995 65.8868 55.7995 65.8864 55.7991 65.8861C55.7958 65.8804 55.7925 65.8758 55.7888 65.8714C55.7858 65.8671 55.7824 65.8631 55.7791 65.8601C55.7787 65.8598 55.7781 65.8591 55.7777 65.8588C55.7751 65.8564 55.7727 65.8544 55.77 65.8527C55.7667 65.8507 55.7633 65.8494 55.76 65.8488C55.7593 65.8488 55.7583 65.8488 55.7577 65.8488H55.7573C55.756 65.8488 55.7547 65.8491 55.7536 65.8491C55.6623 65.8714 55.5766 65.8818 55.4966 65.8821C55.4963 65.8821 55.4956 65.8821 55.4953 65.8821C55.4946 65.8821 55.4936 65.8821 55.4926 65.8821C55.0277 65.8808 54.7352 65.5341 54.4474 65.1714C54.4357 65.1567 54.4243 65.1424 54.4129 65.1277C54.4142 65.1237 54.4156 65.1194 54.4173 65.1153C54.4146 65.1164 54.4119 65.117 54.4092 65.118C54.4116 65.0082 54.4119 64.8988 54.4119 64.79C54.4119 64.73 54.4119 64.6702 54.4119 64.6105C54.4119 64.1918 54.4173 63.7734 54.5073 63.3286C54.5572 63.083 54.5819 62.8621 54.5813 62.6656C54.5796 61.8127 54.108 61.411 53.1943 61.387C53.0959 61.3843 52.9972 61.3833 52.8982 61.3833C52.8975 61.3833 52.8972 61.3833 52.8965 61.3833C52.8945 61.3833 52.8928 61.3833 52.8911 61.3833C52.6532 61.3833 52.4142 61.3893 52.1756 61.3943C52.0762 61.3963 51.9768 61.398 51.8777 61.3993C51.8673 60.8838 51.5417 60.7343 51.197 60.6065C51.274 60.3613 51.3717 60.1191 51.4232 59.8698C51.4467 59.7574 51.4591 59.6656 51.4591 59.5905C51.4591 59.3603 51.3429 59.2842 51.0671 59.2302C50.5129 59.1221 49.9637 58.9913 49.4128 58.8701C49.5531 58.4801 49.6936 58.0904 49.8365 57.6937C49.9862 57.7217 50.109 57.8027 50.2191 57.9042C50.4985 58.1621 50.6967 58.5538 51.0477 58.5558C51.0487 58.5558 51.0497 58.5558 51.0507 58.5558C51.0514 58.5558 51.0521 58.5558 51.0524 58.5558C51.1615 58.5555 51.285 58.5178 51.4299 58.427C51.4339 58.4247 51.4376 58.4224 51.4417 58.42C51.4467 58.4167 51.4514 58.4137 51.4564 58.4103C51.6629 58.2852 51.8694 58.1601 52.0759 58.0346C52.5421 58.1561 52.7225 58.5765 52.856 59.0994C53.1217 58.8435 53.3734 58.6002 53.6368 58.346C53.6683 58.4424 53.6786 58.5431 53.6786 58.6456C53.6786 58.8528 53.6355 59.0677 53.6355 59.2652C53.6355 59.4611 53.6776 59.6403 53.8453 59.7791C54.1291 59.7514 54.436 59.8051 54.692 59.6779C55.1693 59.4404 55.6174 59.098 56.0776 58.7997C56.0913 58.7941 56.1051 58.7884 56.1188 58.783C56.333 58.7 56.5395 58.6633 56.7403 58.6626C56.7413 58.6626 56.7426 58.6626 56.7436 58.6626C56.7446 58.6626 56.7456 58.6626 56.7463 58.6626C57.0967 58.6633 57.4294 58.7747 57.7543 58.9459C57.763 58.9505 57.7717 58.9552 57.7804 58.9599C58.1978 58.4778 58.8102 58.1398 58.8109 57.2933C58.8109 57.2552 58.8096 57.2162 58.8072 57.1761C58.5666 57.3059 58.3625 57.4254 58.1533 57.5235C58.151 57.5245 58.1482 57.5255 58.1459 57.5265C58.1449 57.5268 58.1442 57.5271 58.1432 57.5275C58.1409 57.5285 58.1385 57.5291 58.1362 57.5301C58.1108 57.5385 58.0796 57.5432 58.0499 57.5435C58.0492 57.5435 58.0485 57.5435 58.0479 57.5435C58.0472 57.5435 58.0465 57.5435 58.0458 57.5435C58.001 57.5432 57.9608 57.5325 57.9508 57.5105C57.9083 57.4157 57.8527 57.2889 57.8527 57.1871C57.8527 57.1611 57.8561 57.1371 57.8644 57.1154C57.9581 56.8698 58.1496 56.6623 58.2386 56.4164C58.2882 56.2799 58.3119 56.1541 58.3116 56.041C58.3109 55.7407 58.1399 55.5295 57.8246 55.4424C57.6844 55.4037 57.5268 55.4274 57.3802 55.4074C57.0749 55.365 56.9779 55.3493 56.9775 55.0927C56.9772 54.9719 56.9987 54.7978 57.0294 54.5419C57.0361 54.5412 57.0428 54.5405 57.0492 54.5398C57.0559 54.5392 57.0626 54.5382 57.0693 54.5375C57.1981 54.5218 57.3276 54.4921 57.4571 54.4618C57.6523 54.4164 57.8474 54.3697 58.0398 54.3687C58.0425 54.3687 58.0452 54.3687 58.0475 54.3687C58.0485 54.3687 58.0492 54.3687 58.0499 54.3687C58.1824 54.3687 58.3133 54.3907 58.4421 54.4497C58.4425 54.4501 58.4428 54.4501 58.4431 54.4501C58.4464 54.4518 58.4498 54.4534 58.4532 54.4551C58.4558 54.4561 58.4582 54.4574 58.4608 54.4584C58.4632 54.4598 58.4655 54.4611 58.4682 54.4621C58.6586 54.9739 58.76 55.5836 59.0666 55.9683C59.326 56.2933 59.6229 56.5258 59.8133 56.9679C59.8143 56.9706 59.8156 56.9733 59.8166 56.9759C59.8193 56.9816 59.8217 56.9873 59.8243 56.993C59.9294 57.2178 60.0978 57.328 60.2926 57.3296C60.2942 57.3296 60.2959 57.3296 60.2972 57.3296C60.2989 57.3296 60.3002 57.3296 60.3019 57.3296C60.492 57.328 60.7065 57.2242 60.9113 57.0247C60.9144 57.0217 60.9174 57.0186 60.9204 57.0156C60.9221 57.014 60.9238 57.0123 60.9258 57.0106C60.9274 57.009 60.9288 57.0073 60.9304 57.0056C61.0717 57.041 61.2096 57.096 61.3545 57.1074C61.3833 57.1097 61.4093 57.1111 61.4328 57.1111C61.4334 57.1111 61.4338 57.1111 61.4344 57.1111C61.4351 57.1111 61.4361 57.1111 61.4368 57.1111C61.6343 57.1104 61.6419 57.016 61.5305 56.6443C61.5292 56.6393 61.5275 56.6336 61.5258 56.6282C61.5827 56.4601 61.6426 56.2932 61.7062 56.1274C61.996 56.3463 62.2708 56.5952 62.5814 56.7724C62.5834 56.7734 62.5854 56.7747 62.5874 56.7758C62.5934 56.7791 62.5995 56.7824 62.6058 56.7858C62.6082 56.7871 62.6109 56.7884 62.6132 56.7898C62.7196 56.8448 62.8632 56.8939 62.9844 56.9002C62.9931 56.9009 63.0021 56.9009 63.0105 56.9009C63.0111 56.9009 63.0115 56.9009 63.0121 56.9009C63.0717 56.9009 63.1246 56.8888 63.1617 56.8598C63.1637 56.8585 63.1657 56.8568 63.1677 56.8552C63.1684 56.8545 63.1691 56.8541 63.1698 56.8535C63.1714 56.8518 63.1735 56.8501 63.1751 56.8485C63.1805 56.8438 63.1858 56.8391 63.1912 56.8345C63.1965 56.8298 63.2019 56.8255 63.2069 56.8208C63.2089 56.8194 63.2106 56.8178 63.2123 56.8161C63.2126 56.8161 63.2126 56.8161 63.2126 56.8161C63.215 56.8141 63.2173 56.8121 63.2196 56.8101C63.2206 56.8091 63.2216 56.8084 63.2226 56.8078C63.2257 56.8051 63.2287 56.8024 63.2317 56.7998C63.3776 56.678 63.4934 56.6102 63.5834 56.6022C63.5895 56.6019 63.5951 56.6016 63.6012 56.6016C63.6022 56.6016 63.6032 56.6016 63.6042 56.6016C63.7447 56.6039 63.8184 56.767 63.8435 57.1161C63.8612 57.3636 63.9439 57.5962 64.0011 57.8525C64.4596 57.6009 64.7909 57.4194 65.1219 57.2379C65.2565 57.2933 65.3924 57.3463 65.5289 57.3967C65.2709 58.2205 64.6163 58.6796 64.1524 59.3139C64.0058 59.5144 63.9241 59.6679 63.9238 59.8181C63.9235 59.9859 64.0249 60.1494 64.2511 60.3697C64.469 60.5812 64.6688 60.7734 64.6688 61.067C64.6688 61.1731 64.6427 61.2926 64.5818 61.431C64.5794 61.4364 64.5768 61.4414 64.5737 61.4467C64.5088 61.5605 64.2816 61.6936 64.2642 61.6936C64.2642 61.6936 64.2641 61.6936 64.2638 61.6936C64.2635 61.6936 64.2635 61.6936 64.2632 61.6933C64.0968 61.4304 64.0075 61.0607 63.7906 60.8875C63.7819 60.8801 63.7729 60.8731 63.7641 60.8665C63.4757 60.6439 63.1805 60.5471 62.8806 60.5471C62.8793 60.5471 62.8783 60.5471 62.8769 60.5471C62.4358 60.5485 61.9843 60.7577 61.5285 61.0823C61.5221 61.087 61.5158 61.0917 61.5094 61.096C61.5041 61.1 61.4987 61.1037 61.4937 61.1074C61.4837 61.1147 61.4736 61.1221 61.4636 61.1294C61.239 61.2946 61.1125 61.4917 61.1135 61.6652C61.1145 61.8204 61.2176 61.9562 61.4442 62.0319C61.7577 62.1374 61.8608 62.2902 61.8615 62.4898C61.8619 62.6309 61.8113 62.7954 61.7477 62.9832C61.2581 63.0323 60.7681 63.0553 60.2802 63.1427C60.0881 63.1771 59.9006 63.3543 59.7109 63.4664C59.6436 63.6269 59.5817 63.7897 59.5255 63.9549C59.5131 63.9522 59.501 63.9492 59.4886 63.9465C59.4873 63.9462 59.486 63.9459 59.4846 63.9455C59.4796 63.9445 59.4746 63.9432 59.4692 63.9419C59.4689 63.9419 59.4686 63.9415 59.4679 63.9415C59.4652 63.9409 59.4622 63.9402 59.4592 63.9395C59.4562 63.9385 59.4532 63.9379 59.4498 63.9372C59.4471 63.9362 59.4441 63.9355 59.4411 63.9348C59.4358 63.9335 59.4301 63.9318 59.4244 63.9305C59.4214 63.9298 59.4184 63.9288 59.4154 63.9282C59.413 63.9275 59.4103 63.9268 59.408 63.9262C59.2855 63.8931 59.1637 63.8511 59.0425 63.8064C58.6727 63.6703 58.3052 63.5104 57.9173 63.5098C57.9163 63.5098 57.915 63.5098 57.914 63.5098C57.913 63.5098 57.9117 63.5098 57.9107 63.5098C57.6165 63.5104 57.3109 63.6029 56.9832 63.8661C56.9755 63.8721 56.9682 63.8781 56.9608 63.8841C56.9601 63.8848 56.9595 63.8851 56.9588 63.8858C56.9521 63.8905 56.9437 63.8928 56.934 63.8928H56.9337C56.8698 63.8928 56.749 63.8007 56.6519 63.7216C56.6499 63.72 56.6482 63.7186 56.6462 63.717C56.6452 63.716 56.6442 63.7153 56.6429 63.7143C56.6378 63.7099 56.6328 63.7059 56.6282 63.7019C56.6235 63.6983 56.6191 63.6946 56.6144 63.691C56.6128 63.6893 56.6111 63.6879 56.6091 63.6863C56.6064 63.6843 56.6037 63.6819 56.601 63.6796C56.599 63.6779 56.597 63.6766 56.5953 63.6749C56.5937 63.6736 56.5923 63.6726 56.591 63.6712C56.4166 63.5271 56.2637 63.3509 56.092 63.2021C56.0833 63.1944 56.0743 63.1868 56.0652 63.1798C55.9882 63.1187 55.9076 63.08 55.8279 63.0787C55.8266 63.0787 55.8253 63.0787 55.8239 63.0787C55.8229 63.0787 55.8222 63.0787 55.8212 63.0787C55.7245 63.0797 55.6305 63.1364 55.5481 63.2759C55.5458 63.2799 55.5438 63.2839 55.5415 63.2879C55.4725 63.4097 55.4129 63.5825 55.4123 63.7206C55.4123 63.746 55.4143 63.7704 55.4186 63.793C55.5552 64.5198 56.0023 64.9875 56.5542 64.9892C56.5552 64.9892 56.5562 64.9896 56.5572 64.9896C56.5579 64.9896 56.5582 64.9892 56.5585 64.9892C56.6941 64.9892 56.8357 64.9608 56.9806 64.9018C56.9886 64.8985 56.997 64.8948 57.005 64.8915C57.0117 64.8885 57.0184 64.8855 57.0251 64.8828C57.0277 64.8815 57.0304 64.8804 57.0331 64.8794C57.344 64.747 57.6355 64.6599 57.9116 64.6592C57.913 64.6592 57.914 64.6592 57.915 64.6592C57.916 64.6592 57.917 64.6592 57.9177 64.6592C58.2574 64.6599 58.5736 64.7917 58.8738 65.1307C58.8802 65.138 58.8866 65.1451 58.8926 65.1524C58.6978 65.3272 58.5331 65.5511 58.337 65.6355C57.6881 65.9148 56.9685 65.777 56.3604 66.3269ZM56.5278 61.1875C56.5291 61.1875 56.5304 61.1875 56.5318 61.1875C56.5676 61.1871 56.6054 61.1831 56.6439 61.1788C56.6486 61.1785 56.6532 61.1778 56.6583 61.1771C56.671 61.1758 56.684 61.1741 56.6968 61.1728C56.7252 61.1698 56.753 61.1674 56.7801 61.1671C56.7824 61.1671 56.7851 61.1671 56.7878 61.1671C56.7881 61.1671 56.7885 61.1671 56.7888 61.1671C56.7888 61.0887 56.8052 60.9932 56.8052 60.9145C56.8055 60.8658 56.7992 60.8231 56.7788 60.7951C56.6533 60.6232 56.4866 60.4904 56.3239 60.362C56.3203 60.359 56.3156 60.3576 56.3099 60.3576C56.3096 60.3576 56.3089 60.3576 56.3085 60.3576C56.3065 60.3576 56.3045 60.3576 56.3022 60.358C56.2982 60.3583 56.2935 60.3593 56.2888 60.3606C56.2627 60.3683 56.2289 60.3877 56.1988 60.41C56.1968 60.4114 56.1947 60.413 56.1924 60.4147C56.182 60.4227 56.1723 60.431 56.1636 60.4394C56.162 60.4407 56.1603 60.4424 56.1589 60.4437C56.1552 60.4474 56.1522 60.4507 56.1489 60.454C56.1044 60.5044 56.088 60.5892 56.0294 60.7307C56.1372 60.8625 56.2416 61.049 56.3925 61.1541C56.4287 61.1791 56.4749 61.1871 56.5254 61.1875C56.5261 61.1875 56.5271 61.1875 56.5278 61.1875Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M68.8404 60.1208C68.8394 60.1208 68.8387 60.1208 68.8381 60.1208C68.7035 60.1202 68.5646 60.0865 68.4264 60.0514C68.4211 60.0501 68.4157 60.0488 68.4103 60.0474C68.4405 59.9647 68.4746 59.8833 68.5004 59.7995C68.6282 59.3811 68.8019 58.9664 68.8695 58.5429C68.8749 58.5099 68.8772 58.4799 68.8772 58.4522C68.8752 58.0371 68.3059 58.1769 68.2333 57.7298C68.156 57.2563 67.9194 56.8376 67.7527 56.3948C67.8678 56.0615 67.9826 55.7278 68.0978 55.3945C68.2648 55.6571 68.4425 55.9113 68.5968 56.1853C68.5988 56.1893 68.6011 56.1933 68.6035 56.1969C68.6038 56.1976 68.6041 56.1986 68.6044 56.1993C68.6055 56.2009 68.6064 56.203 68.6075 56.2046C68.7052 56.3788 68.8163 56.572 68.9847 56.575C68.986 56.575 68.9873 56.575 68.989 56.575C68.9893 56.575 68.9897 56.575 68.99 56.575C69.0191 56.575 69.0503 56.569 69.0834 56.5563C69.0871 56.555 69.0904 56.5536 69.0941 56.5519C69.0974 56.5506 69.1008 56.5493 69.1041 56.5476C69.1048 56.5476 69.1055 56.5473 69.1061 56.547C69.1071 56.5466 69.1081 56.5463 69.1091 56.5459C69.1784 56.5182 69.2433 56.5063 69.3046 56.5063C69.3053 56.5063 69.3056 56.5063 69.3063 56.5063C69.308 56.5063 69.31 56.5063 69.312 56.5063C69.4803 56.5083 69.6229 56.598 69.7621 56.6958C69.7628 56.6961 69.7634 56.6968 69.7641 56.6971C69.7708 56.7018 69.7775 56.7064 69.7842 56.7111C69.7845 56.7114 69.7849 56.7118 69.7852 56.7121C69.7869 56.7131 69.7886 56.7144 69.7902 56.7154C69.7942 56.7185 69.7986 56.7215 69.8026 56.7245C69.8059 56.7268 69.8093 56.7291 69.8127 56.7315C69.8143 56.7325 69.816 56.7338 69.8173 56.7348C69.82 56.7368 69.8227 56.7385 69.825 56.7401C69.8267 56.7415 69.828 56.7425 69.8297 56.7435C69.8311 56.7445 69.8324 56.7455 69.8337 56.7465C69.8357 56.7478 69.8377 56.7491 69.8394 56.7505C69.98 56.8492 70.1212 56.941 70.2865 56.9423C70.2879 56.9423 70.2892 56.9423 70.2909 56.9423C70.2912 56.9423 70.2919 56.9423 70.2926 56.9423C70.3622 56.942 70.4358 56.926 70.5158 56.8876C70.5181 56.8863 70.5205 56.8853 70.5232 56.8839C70.9221 56.6857 71.1015 56.2817 71.2598 55.8589C71.2742 55.8636 71.2886 55.8683 71.303 55.8736C71.3117 55.877 71.3207 55.8803 71.3298 55.884C71.3298 55.884 71.3301 55.8843 71.3304 55.8843C71.3354 55.8863 71.3408 55.8886 71.3461 55.8906C71.3545 55.8943 71.3632 55.898 71.3716 55.902C71.3763 55.904 71.3813 55.9063 71.386 55.9087C71.4382 55.933 71.4887 55.9617 71.5382 55.9927C71.903 56.2233 72.2106 56.6013 72.6751 56.603C72.6761 56.603 72.6775 56.603 72.6785 56.603C72.6788 56.603 72.6791 56.603 72.6795 56.603C72.7608 56.603 72.8468 56.5913 72.9385 56.5656C72.9402 56.565 72.9419 56.565 72.9436 56.565H72.9439C72.9486 56.565 72.9536 56.5666 72.959 56.57C72.9643 56.5733 72.9697 56.578 72.9754 56.5847C72.9757 56.585 72.9764 56.5856 72.9767 56.5863C72.9934 56.606 73.0118 56.638 73.0306 56.6777C73.0346 56.6858 73.0386 56.6941 73.0426 56.7028C73.0433 56.7048 73.044 56.7064 73.045 56.7081C73.0888 56.8059 73.1363 56.936 73.1812 57.0411C73.1818 57.0431 73.1828 57.0451 73.1835 57.0471C73.1839 57.0481 73.1845 57.0491 73.1849 57.0498C73.1889 57.0595 73.1929 57.0688 73.1969 57.0781C73.2003 57.0852 73.2036 57.0922 73.2066 57.0988C73.2076 57.1012 73.2086 57.1035 73.2096 57.1055C73.211 57.1085 73.2126 57.1115 73.214 57.1145L73.2066 57.1158C72.7665 57.1569 72.5871 57.5449 72.4151 57.9427C72.309 57.8336 72.2063 57.7201 72.0975 57.6153C72.0861 57.6047 72.0751 57.594 72.064 57.5837C72.0617 57.581 72.059 57.5786 72.0563 57.5763C72.0553 57.575 72.0543 57.574 72.053 57.573C71.8542 57.3835 71.7263 57.279 71.6109 57.274C71.6078 57.2737 71.6048 57.2737 71.6022 57.2737C71.6015 57.2737 71.6008 57.2737 71.6001 57.2737C71.4546 57.275 71.3261 57.4365 71.0931 57.7872C71.0891 57.7935 71.0848 57.8002 71.0804 57.8065C71.0707 57.8212 71.061 57.8359 71.0513 57.8509C71.0038 57.923 70.976 58.0117 70.9392 58.0928C70.244 58.4058 69.8237 59.0628 69.4217 59.7465C69.4117 59.7635 69.4017 59.7795 69.3916 59.7948C69.229 60.0451 69.0419 60.1195 68.8451 60.1208C68.8434 60.1208 68.8421 60.1208 68.8404 60.1208Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M66.1982 58.2004C65.9749 57.9325 65.752 57.6646 65.5288 57.3966C65.3923 57.3463 65.2564 57.2932 65.1218 57.2378C65.1282 57.2195 65.1345 57.2015 65.1409 57.1834C65.1412 57.1828 65.1416 57.1821 65.1416 57.1811C65.419 56.4143 65.8531 56.0577 66.4217 56.0547C66.4241 56.0547 66.4261 56.0547 66.4284 56.0547C66.4294 56.0547 66.4301 56.0547 66.4307 56.0547C66.5803 56.055 66.7386 56.0793 66.9063 56.1271C66.91 56.1284 66.9137 56.1294 66.9174 56.1304C67.0526 56.1968 67.1875 56.2635 67.3223 56.3296C67.158 56.6095 66.9957 56.8905 66.8287 57.1678C66.6205 57.5134 66.4087 57.8561 66.1982 58.2004Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M67.7526 56.395C67.6104 56.3667 67.4671 56.345 67.3222 56.33C67.1873 56.2639 67.0524 56.1972 66.9172 56.1308C66.9202 56.1251 66.9229 56.1194 66.9256 56.1138C66.9276 56.1101 66.9293 56.1061 66.931 56.1024C66.935 56.0947 66.9383 56.0874 66.942 56.0801C67.2251 55.5025 67.3065 55.355 67.6408 55.3543C67.6415 55.3543 67.6422 55.3543 67.6428 55.3543C67.6448 55.3543 67.6465 55.3543 67.6482 55.3543C67.7506 55.3547 67.8764 55.3684 68.0384 55.3877C68.0431 55.388 68.0478 55.3887 68.0525 55.3894C68.0592 55.39 68.0659 55.3907 68.0726 55.3917C68.0766 55.392 68.0802 55.3927 68.0843 55.393C68.0886 55.3937 68.093 55.394 68.0977 55.3947C67.9825 55.728 67.8677 56.0617 67.7526 56.395Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M61.4344 57.1111C61.4338 57.1111 61.4334 57.1111 61.4328 57.1111C61.4093 57.1111 61.3832 57.1097 61.3545 57.1074C61.2095 57.0961 61.0717 57.041 60.9304 57.0056C60.9331 57.0013 60.9354 56.997 60.9378 56.993C60.9411 56.9876 60.9441 56.9819 60.9475 56.9766C61.0867 56.747 61.2711 56.6299 61.5004 56.6279C61.5024 56.6279 61.5044 56.6279 61.5061 56.6279C61.5064 56.6279 61.5064 56.6279 61.5067 56.6279C61.5097 56.6279 61.5128 56.6279 61.5161 56.6279C61.5191 56.6283 61.5225 56.6282 61.5258 56.6282C61.5275 56.6336 61.5291 56.6393 61.5305 56.6443C61.6419 57.016 61.6342 57.1104 61.4368 57.1111C61.4361 57.1111 61.4351 57.1111 61.4344 57.1111Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M54.631 56.0344C54.4864 55.986 54.3418 55.938 54.1972 55.8899C54.2518 55.7268 54.318 55.566 54.3595 55.4005C54.4332 55.1055 54.481 54.9143 54.4814 54.7688C54.4817 54.5002 54.3214 54.3875 53.8682 54.0671L53.9526 53.8136L54.0483 53.5633C54.0543 53.5637 54.0607 53.5643 54.0667 53.565C54.0697 53.565 54.0724 53.5653 54.0754 53.5656C54.0794 53.566 54.0831 53.5663 54.0868 53.5666C54.1129 53.569 54.1376 53.5713 54.1617 53.5733C54.2789 53.5833 54.3756 53.5903 54.458 53.5907C54.4596 53.5907 54.4613 53.5907 54.463 53.5907C54.4636 53.5907 54.4646 53.5907 54.4653 53.5907C54.8184 53.59 54.9041 53.4612 55.1932 52.907C55.1942 52.9057 55.1949 52.9043 55.1956 52.903C55.204 52.8866 55.2126 52.87 55.2217 52.8529C55.2233 52.8493 55.2254 52.8459 55.227 52.8423C55.2277 52.8416 55.228 52.8409 55.2284 52.8399C55.2331 52.8309 55.2381 52.8216 55.2427 52.8122C55.5506 53.2941 55.8589 53.7762 56.1671 54.2583C55.9663 54.3845 55.7652 54.5106 55.5641 54.6367C54.8853 54.7932 54.8442 55.4862 54.631 56.0344ZM53.8679 54.0681V54.0671H53.8682L53.8679 54.0681Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M81.2426 65.5022C81.2396 65.5002 81.2366 65.4979 81.234 65.4955C81.2313 65.4935 81.2286 65.4915 81.2262 65.4895C81.2042 65.4718 81.1828 65.4528 81.1623 65.4332C81.1597 65.4305 81.157 65.4278 81.154 65.4251C81.152 65.4231 81.1499 65.4211 81.1479 65.4188H81.1476C80.8916 65.1632 80.7212 64.7638 80.3109 64.7628C80.3102 64.7628 80.3096 64.7628 80.3092 64.7628C80.3089 64.7628 80.3086 64.7628 80.3082 64.7628C80.2707 64.7628 80.2309 64.7661 80.1891 64.7732C80.163 64.7778 80.1375 64.7798 80.1128 64.7798C80.1124 64.7798 80.1121 64.7798 80.1118 64.7798C80.1111 64.7798 80.1101 64.7798 80.1094 64.7798C79.9026 64.7788 79.7436 64.628 79.8069 64.3631C79.842 64.2149 79.8578 64.0811 79.8574 63.959C79.8564 63.2586 79.3323 62.946 78.9648 62.5136C79.0261 62.3264 79.0877 62.1395 79.1489 61.9523C79.4311 62.0431 79.7132 62.1342 79.995 62.2246C80.0023 62.2263 80.0094 62.2283 80.0164 62.2303C80.0218 62.2316 80.0275 62.233 80.0328 62.2346C80.0345 62.235 80.0361 62.2356 80.0375 62.236C80.0392 62.2363 80.0405 62.237 80.0422 62.2373C80.0572 62.2416 80.0726 62.2463 80.0877 62.2513C80.0894 62.2516 80.0907 62.252 80.092 62.2526C80.2985 62.3194 80.4997 62.4238 80.7339 62.4245C80.7349 62.4245 80.7356 62.4245 80.7363 62.4245C80.737 62.4245 80.7373 62.4245 80.7379 62.4245C80.8548 62.4241 80.9796 62.3981 81.1175 62.3287C81.1195 62.3277 81.1218 62.3267 81.1238 62.3254C80.9809 62.0191 80.8377 61.7061 80.838 61.3551C80.838 61.2039 80.8648 61.0458 80.929 60.8779C81.077 60.9247 81.2249 60.9714 81.3728 61.0181C81.406 61.6217 81.8431 61.8166 82.2042 62.1552C82.2102 62.1526 82.2162 62.1502 82.2223 62.1479C82.2243 62.1469 82.2263 62.1459 82.2286 62.1452C82.2366 62.1419 82.2447 62.1385 82.2531 62.1352C82.6901 61.9567 83.1403 61.7772 83.5844 61.7762C83.5857 61.7762 83.5867 61.7762 83.5881 61.7762C83.5891 61.7762 83.5901 61.7762 83.5911 61.7762C83.8464 61.7768 84.0995 61.8362 84.3475 61.989C84.3515 61.9917 84.3558 61.9944 84.3598 61.9971C84.2982 62.1499 84.233 62.3014 84.1647 62.4512C84.1423 62.4502 84.1206 62.4488 84.0995 62.4478C84.0968 62.4478 84.0944 62.4475 84.0918 62.4475C84.0238 62.4438 83.9619 62.4412 83.9057 62.4392C83.901 62.4392 83.8963 62.4388 83.8916 62.4388C83.8602 62.4378 83.8304 62.4375 83.8019 62.4375C83.8016 62.4375 83.8009 62.4375 83.8006 62.4375C83.7999 62.4375 83.7992 62.4375 83.7989 62.4375C83.3765 62.4375 83.3133 62.5526 83.0569 63.1579C83.0553 63.1615 83.0539 63.1652 83.0523 63.1689C83.0446 63.1872 83.0365 63.2059 83.0285 63.2249C82.7671 63.2333 82.5472 63.3547 82.3802 63.6173C81.8377 64.1248 81.4401 64.7394 81.2426 65.5022Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M82.5968 69.9727C82.3147 69.8759 82.0325 69.7788 81.7504 69.6817C81.7146 69.2446 81.6791 68.8075 81.6433 68.3704C81.7678 68.0677 81.892 67.7648 82.0165 67.4618C82.6199 67.3951 82.6895 66.5282 83.3733 66.2623C83.9774 66.4568 84.713 66.6937 85.4489 66.9306C85.2133 67.2316 84.9781 67.5325 84.7428 67.8338C84.5744 68.2446 84.3756 68.6063 83.9469 68.7004C83.3134 68.8392 82.8261 69.2152 82.5968 69.9727Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M81.0851 68.8223C80.9643 68.7799 80.8401 68.7479 80.7132 68.7262C80.6282 68.5146 80.5433 68.3031 80.4583 68.0916C80.5396 67.7469 80.6205 67.4019 80.7019 67.0572C80.8973 66.9057 81.0924 66.7549 81.2876 66.6037C81.2892 66.6037 81.2909 66.6041 81.2926 66.6041C81.3107 66.6054 81.3284 66.6071 81.3465 66.6091C81.3823 66.6134 81.4184 66.6184 81.4542 66.6231C81.5081 66.6297 81.5617 66.6361 81.6155 66.6364C81.6172 66.6364 81.6189 66.6364 81.6206 66.6364C81.6212 66.6364 81.6219 66.6364 81.6226 66.6364C81.6544 66.6361 81.6858 66.6341 81.7173 66.6291C81.7628 66.6214 81.8043 66.6181 81.8414 66.6178C81.8418 66.6178 81.8421 66.6178 81.8425 66.6178C81.8431 66.6178 81.8435 66.6178 81.8438 66.6178C82.1353 66.6184 82.1691 66.8407 82.0948 67.167C82.0935 67.1726 82.0921 67.1786 82.0908 67.1843C82.0891 67.191 82.0878 67.1973 82.0861 67.2037C82.0854 67.2057 82.0851 67.208 82.0844 67.21C82.0634 67.2944 82.0393 67.3778 82.0165 67.4619C81.892 67.7649 81.7678 68.0678 81.6433 68.3705C81.4572 68.521 81.2712 68.6714 81.0851 68.8223Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M83.8333 65.4785C83.8326 65.4785 83.8323 65.4785 83.8316 65.4785C83.7607 65.4782 83.6783 65.4552 83.5816 65.4038C83.5769 65.4011 83.5719 65.3985 83.5669 65.3958C83.5666 65.3958 83.5666 65.3954 83.5666 65.3954C83.5612 65.3928 83.5562 65.3898 83.5508 65.3868C83.3708 65.2833 83.1569 65.248 82.9624 65.1829C82.9591 65.1342 82.9578 65.0838 82.9578 65.0331C82.9578 64.8292 82.9809 64.6133 82.9809 64.4124C82.9809 64.0214 82.8942 63.6884 82.3801 63.6173C82.5471 63.3547 82.767 63.2333 83.0284 63.2249C83.4705 63.3948 83.7536 63.7418 83.933 64.2373C84.0147 64.4632 84.1797 64.6404 84.3069 64.8396C84.3065 64.8412 84.3058 64.8429 84.3052 64.8446C84.3042 64.8482 84.3028 64.8516 84.3018 64.8552C84.1991 65.1759 84.0927 65.4762 83.8363 65.4785C83.8353 65.4785 83.8343 65.4785 83.8333 65.4785Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M86.8695 68.54C86.8659 68.5394 86.8625 68.5387 86.8589 68.5377C86.8545 68.5371 86.8501 68.5361 86.8461 68.5351C86.8441 68.5347 86.8424 68.5341 86.8404 68.5337C86.8324 68.5317 86.8244 68.53 86.8167 68.528C86.7748 68.518 86.733 68.5067 86.6912 68.4943C86.4555 68.4263 86.2193 68.3362 85.9857 68.3345C85.9833 68.3345 85.981 68.3345 85.9786 68.3345C85.9783 68.3345 85.978 68.3345 85.9777 68.3345C85.9348 68.3345 85.8926 68.3375 85.8501 68.3442C85.8464 68.3448 85.8428 68.3455 85.8391 68.3462C85.8371 68.3465 85.8351 68.3468 85.8331 68.3472C85.7708 68.3575 85.7119 68.3626 85.656 68.3626C85.6557 68.3626 85.6553 68.3626 85.655 68.3626C85.654 68.3626 85.653 68.3626 85.652 68.3626C85.2775 68.3612 85.0332 68.1413 84.7878 67.8817C84.7765 67.8701 84.7654 67.8584 84.7544 67.8467C84.7507 67.8423 84.7467 67.838 84.7427 67.834C84.978 67.5327 85.2132 67.2318 85.4488 66.9308C86.1192 67.0489 86.6303 67.449 87.0446 68.0192C87.0453 68.0202 87.0459 68.0215 87.0469 68.0225C87.0463 68.0239 87.0459 68.0249 87.0456 68.0262C86.987 68.1974 86.9285 68.3689 86.8695 68.54Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M87.4224 73.8679C87.2869 73.8242 87.1524 73.7795 87.0178 73.7341C87.0145 73.2126 86.6959 73.0534 86.3401 72.9367C86.3936 72.7728 86.4442 72.6083 86.492 72.4432C86.8823 72.1782 87.0717 72.0127 87.073 71.8499C87.074 71.7041 86.9241 71.5599 86.6322 71.3484C86.5774 71.3087 86.5044 71.2987 86.4401 71.275C86.4974 71.0908 86.5546 70.9063 86.6115 70.7218C86.6312 70.7091 86.651 70.6948 86.6711 70.6791C86.6727 70.6781 86.6741 70.6767 86.6757 70.6757C86.7835 70.592 86.8946 70.4839 86.993 70.4759C86.9971 70.4755 87.0007 70.4752 87.0047 70.4752C87.0061 70.4752 87.0074 70.4752 87.0088 70.4755C87.8983 70.5042 88.7149 70.7822 89.4312 71.3167C89.5316 71.3911 89.5449 71.6053 89.5985 71.7548L89.5918 71.7518C89.2437 71.8249 88.8957 71.8983 88.5443 71.9713C87.8649 72.1055 87.8414 72.7752 87.6708 73.3217C87.5871 73.5039 87.5048 73.6857 87.4224 73.8679Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M64.6998 85.0408C64.2912 84.9977 64.0258 84.7949 64.0047 84.2707C63.998 84.1065 63.916 83.9557 63.8691 83.7992L63.7383 83.6474C63.8417 83.4062 63.9485 83.1663 64.0479 82.923C64.1928 82.568 64.4183 82.3641 64.7487 82.3461C64.7497 82.3464 64.7507 82.3468 64.7517 82.3471C64.7915 82.5697 64.7995 82.8132 64.8795 83.0097C64.8812 83.0138 64.8829 83.0181 64.8846 83.0221C64.8852 83.0234 64.8859 83.0248 64.8865 83.0261C64.9361 83.1379 65.0114 83.2086 65.0977 83.2096C65.0984 83.2096 65.0994 83.2096 65.1001 83.2096C65.1011 83.2096 65.1021 83.2096 65.1034 83.2096C65.17 83.2083 65.243 83.1659 65.3166 83.0698C65.3199 83.0655 65.3233 83.0611 65.3267 83.0565C65.3287 83.0538 65.3303 83.0511 65.3323 83.0488C65.4214 82.9227 65.4672 82.7568 65.5328 82.609C65.5365 82.611 65.5398 82.6124 65.5432 82.614C65.651 82.6671 65.753 82.6898 65.8501 82.6898C65.8511 82.6898 65.8521 82.6898 65.8531 82.6898C66.2239 82.6881 66.5271 82.3565 66.8514 82.1262C66.9358 82.0665 67.0215 82.0134 67.1102 81.9751C67.1115 81.9741 67.1132 81.9734 67.1148 81.9727C67.1182 81.9714 67.1218 81.9697 67.1252 81.9684C67.1289 81.967 67.1322 81.9654 67.1359 81.964C67.1383 81.963 67.1406 81.9624 67.1429 81.9614C67.1439 81.9607 67.1453 81.9604 67.1463 81.96C67.155 81.9567 67.1637 81.9534 67.1724 81.9504C67.1777 81.9487 67.1828 81.9467 67.1881 81.945L67.2437 82.1095C66.9846 82.6404 66.736 83.1639 66.2838 83.55C65.7376 84.0158 65.2259 84.5413 64.6998 85.0408Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M67.9111 85.5344C67.7658 85.488 67.6212 85.4417 67.4763 85.395C67.6313 84.9308 67.7862 84.4667 67.9408 84.0026C67.9519 83.9989 67.963 83.9956 67.9737 83.9929C68.0155 83.9819 68.0563 83.9762 68.0965 83.9762C68.0972 83.9762 68.0975 83.9762 68.0982 83.9762C68.0992 83.9762 68.1002 83.9762 68.1012 83.9762C68.1604 83.9765 68.218 83.9885 68.2739 84.0126C68.2762 84.0136 68.2785 84.0146 68.2809 84.0156C68.2836 84.0166 68.2859 84.0179 68.2882 84.0189C68.3247 84.0236 68.3595 84.0259 68.3927 84.0259C68.393 84.0259 68.393 84.0259 68.3933 84.0259C68.3944 84.0259 68.395 84.0259 68.396 84.0259C68.8254 84.0246 68.9991 83.6425 69.1514 83.2285C69.1517 83.2278 69.1521 83.2271 69.1524 83.2265C69.1534 83.2231 69.1547 83.2198 69.1561 83.2161C69.1598 83.2061 69.1634 83.1958 69.1671 83.1858C69.1681 83.1828 69.1691 83.1798 69.1705 83.1771C69.8509 83.1304 70.2876 82.6976 70.5242 81.9472L70.5256 81.9459C70.6631 81.9916 70.802 82.0323 70.9419 82.0683L70.9516 82.0923C70.894 82.2618 70.8365 82.4313 70.7793 82.6008C70.7207 82.7723 70.6625 82.9439 70.6039 83.1154C70.5544 83.2952 70.5045 83.4747 70.455 83.6546C69.958 83.6769 69.8007 84.0997 69.6722 84.5561C69.6735 84.5564 69.6752 84.5568 69.6765 84.5571C69.6568 84.5561 69.637 84.5555 69.6176 84.5555C69.6173 84.5555 69.6173 84.5555 69.6169 84.5555C69.6152 84.5555 69.6136 84.5555 69.6116 84.5555C69.1822 84.5575 68.8304 84.8027 68.5118 85.1527C68.5098 85.155 68.5075 85.1574 68.5055 85.1597C68.5034 85.1617 68.5018 85.1637 68.4998 85.1657C68.485 85.1821 68.4707 85.1984 68.4563 85.2148C68.4539 85.2178 68.4516 85.2205 68.4489 85.2235C68.2695 85.3269 68.0901 85.4307 67.9111 85.5344Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M68.2562 82.9524C68.2542 82.9501 68.2521 82.9477 68.2505 82.9454C68.2485 82.9427 68.2461 82.9404 68.2441 82.9377C68.2435 82.937 68.2428 82.9361 68.2421 82.9351C68.2411 82.9337 68.2401 82.9327 68.2391 82.9314C68.2301 82.92 68.221 82.9084 68.2123 82.8967C67.965 82.5683 67.8074 82.1045 67.3438 82.1032C67.3432 82.1032 67.3425 82.1032 67.3418 82.1032C67.3107 82.1032 67.2779 82.1052 67.2438 82.1096L67.1882 81.945C67.38 81.7579 67.5734 81.6544 67.7695 81.6531C67.7712 81.6531 67.7726 81.6528 67.7742 81.6528C67.7752 81.6528 67.7762 81.6531 67.7773 81.6531C67.9024 81.6538 68.0289 81.6958 68.1564 81.7846C68.3726 81.9344 68.4235 82.1533 68.4239 82.3932C68.4239 82.5443 68.4041 82.7042 68.3931 82.86L68.2562 82.9524Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M67.4764 85.3948C67.3569 85.1138 67.288 84.9213 67.2874 84.7628C67.2867 84.4985 67.4764 84.3287 67.941 84.0024C67.7863 84.4665 67.6314 84.9306 67.4764 85.3948Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M68.3936 84.0261C68.3933 84.0261 68.3932 84.0261 68.3929 84.0261C68.3598 84.0261 68.325 84.0238 68.2885 84.0191C68.2778 83.6638 68.2674 83.3081 68.2563 82.9527L68.3933 82.8603C68.6526 82.9661 68.9113 83.0719 69.1707 83.1773C69.1694 83.18 69.1684 83.183 69.1674 83.186C69.1637 83.196 69.16 83.2063 69.1563 83.2163C69.155 83.22 69.1536 83.2233 69.1526 83.2267C69.1523 83.2273 69.1519 83.228 69.1516 83.2287C68.9993 83.6427 68.8257 84.0245 68.3963 84.0261C68.3953 84.0261 68.3946 84.0261 68.3936 84.0261Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M62.929 84.5818H62.9287C62.8989 84.5818 62.8685 84.5801 62.8373 84.5771C62.837 84.5771 62.837 84.5771 62.8367 84.5771C62.8323 84.5765 62.828 84.5761 62.8236 84.5758C62.2674 84.5131 61.6967 84.5267 61.1328 84.507C61.1358 84.5014 61.1389 84.4957 61.1419 84.49C61.1442 84.4854 61.1465 84.481 61.1489 84.4767C61.1499 84.4743 61.1512 84.472 61.1526 84.4697C61.4558 83.8934 61.5395 83.7486 61.8785 83.7483C61.8792 83.7483 61.8798 83.7483 61.8805 83.7483C61.8822 83.7483 61.8842 83.7483 61.8858 83.7483C61.9886 83.7486 62.1148 83.7616 62.2771 83.78C62.2838 83.7806 62.2905 83.7817 62.2972 83.7823C62.3008 83.7827 62.3045 83.783 62.3079 83.7837C62.3146 83.7843 62.3216 83.785 62.3283 83.786C62.7982 83.7396 63.2684 83.6936 63.7383 83.6475L63.8691 83.7993C63.8665 83.8037 63.8638 83.8084 63.8615 83.813C63.8608 83.8137 63.8605 83.8147 63.8598 83.8154C63.8561 83.822 63.8524 83.8284 63.8487 83.835C63.6191 84.2388 63.3765 84.5805 62.932 84.5818C62.931 84.5818 62.93 84.5818 62.929 84.5818Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M67.2432 73.4165C67.4155 72.9714 67.5464 72.532 67.5467 72.0972C67.5471 71.8186 67.4935 71.5416 67.3623 71.266C67.2699 71.0712 67.288 70.7959 67.2556 70.5573C67.368 70.3061 67.3995 70.0598 67.3991 69.8156C67.3991 69.5016 67.3466 69.1906 67.3466 68.8766C67.6173 68.7989 67.8881 68.5664 67.8874 68.3308C67.8874 68.2791 67.8744 68.2273 67.8453 68.1773C67.6281 67.8026 67.5447 67.4222 67.5444 67.0335C67.5437 66.6444 67.626 66.2474 67.7395 65.8386C67.7465 65.8353 67.7532 65.8316 67.7596 65.8279C67.7642 65.8256 67.7686 65.8233 67.773 65.8206C67.7746 65.8196 67.7766 65.8186 67.7783 65.8176C67.786 65.8133 67.7934 65.8089 67.8004 65.8046C67.8235 65.7906 67.8449 65.7766 67.865 65.7646C67.8663 65.7639 67.8673 65.7632 67.8687 65.7622C67.871 65.7609 67.8737 65.7596 67.876 65.7579C67.8827 65.7539 67.8894 65.7502 67.8961 65.7469C67.9149 65.7369 67.9326 65.7295 67.9487 65.7265C67.9537 65.7259 67.958 65.7255 67.9627 65.7255C67.9631 65.7255 67.9634 65.7255 67.9634 65.7255C67.9654 65.7255 67.9671 65.7255 67.9691 65.7255C67.9711 65.7259 67.9731 65.7262 67.9751 65.7265C68.2579 65.7839 68.5354 65.8637 68.8148 65.9357C68.8108 65.9741 68.8084 66.0115 68.8084 66.0472C68.8078 66.2811 68.8945 66.4606 69.0672 66.5864C69.0675 66.588 69.0678 66.5897 69.0682 66.5914C69.0688 66.5954 69.0695 66.5994 69.0705 66.6034C69.1143 66.8316 69.1361 66.9364 69.198 66.9391C69.1987 66.9391 69.1993 66.9391 69.2 66.9391C69.2014 66.9391 69.2027 66.9391 69.204 66.9391C69.2439 66.9364 69.2994 66.895 69.3858 66.8196C69.3861 66.8193 69.3864 66.8189 69.3868 66.8186C69.3988 66.8083 69.4112 66.7969 69.4243 66.7852C69.4259 66.7842 69.4273 66.7829 69.4286 66.7816C69.4299 66.7802 69.4316 66.7789 69.433 66.7776C69.4336 66.7769 69.4346 66.7762 69.4353 66.7756C69.441 66.7706 69.4463 66.7655 69.452 66.7605C69.4537 66.7589 69.4554 66.7576 69.4571 66.7559C69.4678 66.7465 69.4785 66.7365 69.4899 66.7265C69.6321 66.8857 69.7807 67.0375 69.9149 67.2053C69.9176 67.2087 69.9199 67.2117 69.9226 67.2147C69.9256 67.2187 69.9289 67.2227 69.9323 67.2263C69.936 67.2307 69.94 67.2354 69.9437 67.2394C69.9447 67.2404 69.9453 67.2414 69.9463 67.2424C70.0357 67.3408 70.1375 67.3982 70.2493 67.3988C70.2496 67.3988 70.2499 67.3988 70.2506 67.3988C70.2513 67.3988 70.2516 67.3988 70.2523 67.3988C70.3132 67.3985 70.3768 67.3812 70.443 67.3445C70.4447 67.3435 70.4464 67.3428 70.4484 67.3418C70.449 67.3415 70.4497 67.3408 70.4501 67.3404C70.4517 67.3398 70.4531 67.3388 70.4547 67.3378C70.4554 67.3374 70.4564 67.3371 70.4571 67.3365C70.4591 67.3355 70.4611 67.3341 70.4631 67.3331C70.6485 67.22 70.7295 67.0308 70.7298 66.8073C70.7298 66.7752 70.7285 66.7429 70.7252 66.7095C70.7024 66.4716 70.698 66.2287 70.6853 65.9878C71.2021 66.0095 71.7188 66.0311 72.2389 66.0532C72.4588 66.3782 72.6783 66.7018 72.9487 67.1016C73.8356 66.6014 74.668 65.8577 75.6486 65.6578C75.6506 65.6575 75.6526 65.6571 75.6546 65.6571C75.655 65.6571 75.6549 65.6571 75.6553 65.6571C75.6559 65.6571 75.6563 65.6571 75.657 65.6571C75.7122 65.6598 75.7741 65.7966 75.835 65.912C75.8527 65.9457 75.8705 65.9778 75.8879 66.0041C75.7718 66.3458 75.6556 66.6875 75.5395 67.0291C75.3926 67.0695 75.2339 67.0769 75.1007 67.1556C74.6603 67.4172 74.5867 67.4976 74.587 67.9347C74.587 68.0061 74.589 68.0872 74.5917 68.1803C74.6014 68.5253 74.6077 68.8633 74.8494 69.0885C74.8872 69.2494 74.9063 69.4215 74.9648 69.5694C75.0324 69.7409 75.0676 69.8776 75.0679 69.9847C75.0686 70.1966 74.9341 70.2924 74.6482 70.3074C74.6442 70.3077 74.6402 70.3077 74.6362 70.3081C74.6084 70.3094 74.581 70.3101 74.5535 70.3101C74.5532 70.3101 74.5532 70.3101 74.5529 70.3101C74.5515 70.3101 74.5502 70.3101 74.5485 70.3101C74.0355 70.3087 73.5906 70.0912 73.1328 69.9074C73.1114 69.899 73.0903 69.8907 73.0692 69.8823C73.0512 69.8753 73.0328 69.8683 73.0147 69.8613C73.014 69.861 73.013 69.8606 73.012 69.8603C73.012 69.8603 73.0117 69.86 73.0113 69.86C73.0043 69.858 72.9969 69.8566 72.9892 69.8566C72.9889 69.8566 72.9889 69.8566 72.9886 69.8566C72.9815 69.8566 72.9742 69.8576 72.9665 69.859C72.9605 69.8603 72.9544 69.862 72.9481 69.8643C72.8621 69.893 72.7479 69.9978 72.6489 70.0628C72.6445 70.0655 72.6405 70.0682 72.6362 70.0708C72.6338 70.0725 72.6311 70.0739 72.6288 70.0755C72.6261 70.0772 72.6238 70.0785 72.6211 70.0799C72.4852 70.0325 72.3493 69.9854 72.2131 69.9387C71.5592 69.8933 70.8968 69.8883 70.2556 69.7842C69.9802 69.7398 69.7563 69.4746 69.4955 69.3378C69.4323 69.3047 69.3617 69.2894 69.2877 69.2894C69.2827 69.2894 69.278 69.2894 69.273 69.2897C68.9336 69.2984 68.527 69.6187 68.4226 69.9971C68.4219 69.9994 68.4212 70.0014 68.4206 70.0038C68.4175 70.0158 68.4145 70.0281 68.4119 70.0405C68.376 70.211 68.3145 70.3868 68.3148 70.5527C68.3148 70.5553 68.3148 70.558 68.3148 70.5607C68.3232 71.1649 68.3543 71.7662 68.3787 72.4182C67.9691 72.7468 67.7776 73.3321 67.2432 73.4165Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M72.9487 67.1013C72.6783 66.7016 72.4587 66.3779 72.2388 66.0529C71.7187 66.0309 71.202 66.0092 70.6853 65.9875C70.6809 65.9872 70.6769 65.9868 70.6725 65.9862C70.6662 65.9855 70.6595 65.9849 70.6531 65.9842C70.6364 65.9822 70.6203 65.9805 70.6043 65.9785C70.4573 65.9625 70.3409 65.9508 70.2448 65.9508C70.2441 65.9508 70.2432 65.9508 70.2422 65.9508C70.2408 65.9508 70.2395 65.9508 70.2381 65.9508C69.9075 65.9518 69.8194 66.091 69.5333 66.6392C69.5303 66.6448 69.5276 66.6505 69.5246 66.6562C69.5176 66.6699 69.5102 66.6835 69.5028 66.6979C69.5015 66.7006 69.4998 66.7036 69.4985 66.7066C69.4955 66.7123 69.4925 66.7179 69.4895 66.7239C69.3486 66.6795 69.208 66.6325 69.0688 66.5835C69.1233 66.4133 69.1786 66.2431 69.2341 66.0733C69.2401 66.0276 69.2428 65.9835 69.2428 65.9415C69.2425 65.7266 69.1645 65.5588 69.0005 65.4427C69.1337 65.0243 69.2779 64.6182 69.7314 64.5484C69.8225 64.7553 69.9128 64.9622 70.0039 65.1691C70.0089 65.1711 70.0136 65.1734 70.0186 65.1754C70.0192 65.1757 70.0203 65.1761 70.0209 65.1764C70.0256 65.1784 70.03 65.1801 70.0347 65.1821C70.0363 65.1827 70.0377 65.1834 70.0393 65.1841C70.199 65.2488 70.3616 65.2845 70.524 65.2848C70.5246 65.2848 70.5256 65.2848 70.5266 65.2848C70.5276 65.2848 70.5286 65.2848 70.5296 65.2848C70.7676 65.2842 71.0035 65.2077 71.2244 65.0379C71.2298 65.0339 71.2351 65.0299 71.2401 65.0256C71.2445 65.0223 71.2488 65.0189 71.2529 65.0156C71.2582 65.0112 71.2636 65.0069 71.2689 65.0022C71.2716 65.0002 71.2743 64.9979 71.2766 64.9959C71.28 64.9932 71.2833 64.9905 71.2867 64.9879C71.2894 64.9855 71.292 64.9835 71.2947 64.9815C71.3131 64.9669 71.3319 64.9545 71.3503 64.9438C71.3506 64.9435 71.3509 64.9435 71.3513 64.9432C71.3633 64.9365 71.3754 64.9301 71.3874 64.9248C71.3878 64.9248 71.3877 64.9248 71.3877 64.9248C71.3888 64.9245 71.3898 64.9238 71.3904 64.9235C71.3911 64.9235 71.3914 64.9232 71.3918 64.9228C71.3968 64.9208 71.4018 64.9188 71.4068 64.9171C71.4072 64.9168 71.4075 64.9168 71.4082 64.9165C71.4085 64.9165 71.4088 64.9161 71.4095 64.9161C71.4102 64.9158 71.4112 64.9155 71.4122 64.9151C71.4129 64.9148 71.4135 64.9145 71.4142 64.9141C71.4149 64.9141 71.4155 64.9138 71.4162 64.9135C71.4169 64.9135 71.4175 64.9131 71.4182 64.9128C71.4189 64.9128 71.4195 64.9125 71.4202 64.9121C71.4205 64.9121 71.4212 64.9118 71.4215 64.9118C71.4225 64.9115 71.4232 64.9111 71.4242 64.9108C71.4246 64.9108 71.4249 64.9105 71.4252 64.9105C71.4276 64.9098 71.4299 64.9091 71.4323 64.9084C71.4326 64.9081 71.4329 64.9081 71.4333 64.9081C71.4343 64.9078 71.4353 64.9074 71.4363 64.9071C71.44 64.9061 71.4437 64.9051 71.447 64.9044C71.4473 64.9041 71.448 64.9041 71.4483 64.9041C71.4493 64.9038 71.45 64.9035 71.451 64.9035C71.4513 64.9031 71.452 64.9031 71.4523 64.9031C71.4804 64.8964 71.5082 64.8934 71.5357 64.8934C71.6424 64.8934 71.7462 64.9372 71.8486 64.9805C71.951 65.0242 72.0524 65.0676 72.1545 65.0676C72.2626 65.0676 72.3717 65.0186 72.4841 64.8691C72.6274 64.9165 72.7706 64.9638 72.9139 65.0115C72.9694 65.0623 73.0377 65.1013 73.0786 65.1654C73.0856 65.1764 73.0926 65.1871 73.0993 65.1971C73.0996 65.1978 73.1 65.1981 73.1003 65.1984C73.103 65.2024 73.1053 65.2061 73.108 65.2098C73.2777 65.454 73.4771 65.5427 73.6883 65.5441C73.69 65.5441 73.6917 65.5441 73.6933 65.5441C73.6957 65.5441 73.6977 65.5441 73.6997 65.5441C73.9531 65.5421 74.2225 65.4163 74.4758 65.2835C74.4802 65.2812 74.4849 65.2788 74.4892 65.2765C74.8486 65.0876 74.921 64.6799 74.9206 64.2745C74.9206 64.2248 74.9196 64.1751 74.9176 64.1257C74.9136 64.0136 74.9126 63.9008 74.9126 63.7877C74.9126 63.6585 74.9143 63.5294 74.9143 63.4003C74.9143 63.3839 74.9143 63.3679 74.9143 63.3519C75.0304 63.3065 75.1465 63.2612 75.263 63.2158C75.1971 63.1037 75.1318 62.9916 75.0665 62.8791C74.6492 62.3139 74.1345 61.9255 73.4778 61.764C73.0568 61.6606 72.6505 61.5031 72.2375 61.3696C71.5651 61.2215 71.1237 60.8514 71.1244 60.088C71.1244 59.9672 71.1357 59.8364 71.1588 59.6953C71.1776 59.5828 71.3663 59.4854 71.4765 59.3813C71.9909 59.4847 72.2332 59.9936 72.5919 60.3282C72.5919 60.3282 72.5919 60.3283 72.5919 60.3279C72.5933 60.3319 72.5946 60.3359 72.5959 60.3399C72.5986 60.3486 72.6016 60.3569 72.6043 60.3649C72.7264 60.736 72.783 60.8955 72.9189 60.8955C72.9256 60.8955 72.9326 60.8951 72.94 60.8945C73.0176 60.8858 73.1207 60.8314 73.272 60.7397C73.272 60.7397 73.272 60.7396 73.2723 60.7393C73.276 60.7373 73.2797 60.735 73.2834 60.7327C73.2937 60.7263 73.3044 60.7196 73.3152 60.713C73.3249 60.7073 73.3346 60.701 73.3446 60.695C73.356 60.6879 73.3674 60.6809 73.3791 60.6736C73.3798 60.6729 73.3804 60.6726 73.3807 60.6722C73.3911 60.6659 73.4018 60.6592 73.4129 60.6526C73.4192 60.6486 73.4256 60.6445 73.4323 60.6402C73.435 60.6385 73.4377 60.6369 73.4403 60.6352C73.6411 60.5088 73.8419 60.3826 74.0431 60.2565C74.3774 60.3693 74.7175 60.4687 75.0448 60.6002C75.0609 60.6065 75.0769 60.6132 75.093 60.6199C75.2121 60.6693 75.3985 60.8187 75.3999 60.8988C75.4002 60.9028 75.3995 60.9065 75.3988 60.9101C75.3647 61.054 75.3493 61.1818 75.3493 61.2972C75.3483 62.105 76.095 62.2928 76.3905 62.8467C76.8423 63.6926 77.4913 63.9949 78.2252 64.2772C78.2269 64.3079 78.2276 64.3382 78.2276 64.3679C78.2272 64.8154 78.0472 65.1714 77.6563 65.3399C77.0736 65.5908 76.4782 65.7853 75.8878 66.0039C75.8704 65.9775 75.8527 65.9455 75.8349 65.9118C75.774 65.7963 75.7121 65.6596 75.6569 65.6569C75.6562 65.6569 75.6559 65.6569 75.6552 65.6569C75.6549 65.6569 75.6549 65.6569 75.6546 65.6569C75.6526 65.6569 75.6506 65.6572 75.6485 65.6575C74.6679 65.8574 73.8356 66.6012 72.9487 67.1013Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M80.0056 70.7876C80.0033 70.7853 80.0013 70.7829 79.9993 70.7809C79.9896 70.7702 79.9802 70.7599 79.9705 70.7499C79.9671 70.7462 79.9634 70.7422 79.9598 70.7386C79.7051 70.4716 79.4206 70.2994 79.0816 70.2981C79.0802 70.2981 79.0789 70.2981 79.0776 70.2981C79.0769 70.2981 79.0762 70.2981 79.0755 70.2981C78.9507 70.2984 78.8188 70.3218 78.6786 70.3719C78.6742 70.3732 78.6699 70.3749 78.6659 70.3762C78.5367 70.3258 78.4049 70.2838 78.2703 70.2504C78.1 70.2581 77.9276 70.2961 77.7556 70.3328C77.5799 70.3702 77.4045 70.4062 77.2315 70.4069C77.2301 70.4069 77.2288 70.4069 77.2275 70.4069C77.2268 70.4069 77.2261 70.4069 77.2254 70.4069C77.0842 70.4065 76.9446 70.3825 76.8081 70.3161L76.8068 70.3148C76.8037 70.0642 76.7592 69.9371 76.6732 69.9331C76.6719 69.9331 76.6705 69.9331 76.6689 69.9331C76.6628 69.9331 76.6565 69.9338 76.6501 69.9348C76.5882 69.9464 76.5086 70.0122 76.4105 70.1316C76.4075 70.1353 76.4045 70.139 76.4015 70.1426C76.4015 70.143 76.4015 70.1429 76.4015 70.1429C76.3998 70.1449 76.3981 70.147 76.3968 70.149C76.3907 70.1563 76.3847 70.164 76.3787 70.172C76.1943 70.0529 76.1066 69.8697 76.106 69.6291C76.106 69.5971 76.1073 69.5641 76.1103 69.5304C76.3948 68.6261 76.7117 67.7426 77.4139 67.1043C77.4822 67.1306 77.5474 67.1703 77.6187 67.1813C78.1297 67.2601 77.936 68.1633 78.4048 68.18C78.4276 68.1807 78.4504 68.181 78.4731 68.181C78.4735 68.181 78.4735 68.181 78.4738 68.181C78.4755 68.181 78.4775 68.181 78.4795 68.181C78.9183 68.18 79.3744 68.0395 79.8252 67.9458C79.8597 67.9388 79.8942 67.9318 79.9286 67.9251C79.939 67.9231 79.9494 67.9214 79.9594 67.9194L79.9772 67.9578C79.9839 68.5157 80.3262 68.6488 80.7131 68.7259C80.8399 68.7476 80.9641 68.7796 81.0849 68.822C80.9648 69.1697 80.8443 69.518 80.7242 69.866C80.2931 69.9771 80.1063 70.3385 80.0056 70.7876Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M76.1104 69.5305C75.9226 69.2145 75.7429 68.8915 75.5451 68.5856C75.5428 68.5816 75.5404 68.5782 75.5377 68.5746C75.5367 68.5726 75.5354 68.5706 75.534 68.5689C75.4721 68.4801 75.4035 68.4381 75.3332 68.4368C75.3322 68.4368 75.3309 68.4368 75.3299 68.4368C75.3282 68.4368 75.3269 68.4368 75.3252 68.4368C75.2369 68.4391 75.1462 68.5048 75.0638 68.6206C75.0601 68.6256 75.0565 68.6309 75.0531 68.6359C74.9631 68.7681 74.9156 68.9366 74.8493 69.0884C74.6077 68.8632 74.6013 68.5252 74.5916 68.1802C74.5889 68.0871 74.5869 68.006 74.5869 67.9346C74.5866 67.4975 74.6602 67.4171 75.1007 67.1555C75.2339 67.0767 75.3925 67.0694 75.5394 67.029C75.853 66.9336 76.1616 66.8752 76.4628 66.8745C76.4641 66.8745 76.4651 66.8745 76.4665 66.8745C76.4671 66.8745 76.4682 66.8745 76.4688 66.8745C76.7938 66.8749 77.1097 66.9429 77.414 67.1044C76.7118 67.7427 76.3949 68.6263 76.1104 69.5305Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M73.4402 60.6355C73.1574 60.5331 72.8746 60.4306 72.5921 60.3282C72.7363 59.9585 72.8535 59.5958 72.8531 59.2514C72.8528 58.9568 72.7668 58.6755 72.5379 58.4149C72.4492 58.3138 72.4535 58.103 72.415 57.9428C72.5871 57.5451 72.7664 57.157 73.2065 57.116C73.1516 57.4163 73.1149 57.6172 73.1149 57.766C73.1145 58.0649 73.2621 58.1534 73.7069 58.42C73.649 58.6262 73.6038 58.8247 73.6042 59.0146C73.6042 59.2201 73.657 59.4149 73.8036 59.5981C73.9345 59.7613 73.9663 60.0335 74.0426 60.2568C73.8421 60.3829 73.641 60.509 73.4402 60.6355Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M78.2434 62.7769C78.2427 62.7769 78.2417 62.7769 78.241 62.7769C78.0309 62.7752 77.9341 62.5877 77.7367 62.1352C77.7363 62.1342 77.7357 62.1332 77.7353 62.1322C77.732 62.1249 77.729 62.1172 77.7256 62.1099C77.7216 62.1005 77.7173 62.0908 77.7132 62.0815C77.7132 62.0812 77.7132 62.0812 77.7129 62.0808C77.7096 62.0731 77.7062 62.0651 77.7029 62.0575C77.7019 62.0555 77.7009 62.0531 77.7002 62.0511C78.3117 61.8653 78.6155 61.2166 79.0546 60.7709L79.1477 60.5203L79.226 60.265C79.2876 60.0932 79.3488 59.9217 79.4104 59.7505C79.8388 59.8916 80.2678 60.0328 80.6962 60.1739L80.6952 60.1753L80.6095 60.3971L80.5409 60.6247C80.3947 60.6177 80.2501 60.6003 80.1075 60.5726C79.6313 60.6174 79.4609 61.0175 79.3351 61.4696C79.2725 61.6304 79.2103 61.7912 79.1487 61.9524C79.0874 62.1396 79.0259 62.3264 78.9646 62.5136C78.9599 62.5156 78.9552 62.5179 78.9509 62.5199C78.9429 62.5239 78.9348 62.5276 78.9268 62.5313C78.9245 62.5323 78.9221 62.5333 78.9198 62.5346C78.9114 62.5383 78.9034 62.542 78.8957 62.5456C78.8906 62.548 78.886 62.5503 78.8813 62.5523C78.8672 62.559 78.8532 62.5653 78.8394 62.5716C78.8388 62.572 78.8381 62.5723 78.8374 62.5726C78.8337 62.5743 78.8301 62.576 78.8264 62.5777C78.8214 62.58 78.8167 62.5823 78.8117 62.5847C78.8097 62.5853 78.808 62.5863 78.806 62.587C78.7973 62.591 78.7889 62.595 78.7805 62.5987C78.7795 62.5994 78.7782 62.5997 78.7772 62.6003C78.7742 62.6017 78.7715 62.603 78.7685 62.6044C78.7668 62.605 78.7648 62.606 78.7628 62.607C78.7598 62.6084 78.7571 62.6093 78.7544 62.6107C78.5349 62.7101 78.383 62.7695 78.2658 62.7762C78.2581 62.7765 78.2507 62.7769 78.2434 62.7769Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M77.7002 62.051C77.7544 61.8879 77.7983 61.7197 77.8645 61.5619C77.8679 61.5539 77.8712 61.5459 77.8746 61.5382C77.8759 61.5345 77.8772 61.5312 77.8789 61.5278C77.8806 61.5238 77.8819 61.5201 77.8836 61.5165C78.1637 60.8508 78.2126 60.7674 78.7752 60.7671C78.7762 60.7671 78.7769 60.7671 78.7775 60.7671C78.7779 60.7671 78.7782 60.7671 78.7785 60.7671C78.8592 60.7671 78.9505 60.7687 79.0546 60.7707C78.6155 61.2165 78.3117 61.8652 77.7002 62.051Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M79.2261 60.2646C78.8791 60.1415 78.5665 59.978 78.5481 59.4742L78.6214 59.4205C78.6388 59.4222 78.6562 59.4228 78.6733 59.4228C78.6733 59.4228 78.6736 59.4228 78.6739 59.4228C78.6756 59.4228 78.6773 59.4228 78.6786 59.4228C78.8787 59.4212 79.0371 59.3061 79.1619 59.1015C79.3058 59.1442 79.449 59.1873 79.5926 59.23L79.5933 59.2336C79.5324 59.4058 79.4715 59.578 79.4105 59.7501C79.349 59.9213 79.2877 60.0928 79.2261 60.2646Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M80.4582 68.0916C80.2978 68.0472 80.1375 68.0028 79.9772 67.9581L79.9595 67.9197C80.1091 67.5186 80.2704 67.1309 80.7018 67.0572C80.6205 67.4019 80.5395 67.7469 80.4582 68.0916Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M76.2082 58.885H76.2079C76.1121 58.884 76.0619 58.8333 76.0623 58.7482C76.0626 58.6935 76.0837 58.6251 76.1268 58.5467C76.1412 58.52 76.1911 58.4966 76.2353 58.4873C76.248 58.4846 76.2604 58.4833 76.2714 58.4833C76.2718 58.4833 76.2724 58.4833 76.2728 58.4833C76.2875 58.4833 76.2995 58.4863 76.3062 58.493C76.3464 58.533 76.3397 58.6354 76.3527 58.7112C76.3521 58.7122 76.3514 58.7128 76.3508 58.7138C76.3484 58.7165 76.3464 58.7192 76.3444 58.7218C76.339 58.7295 76.3333 58.7375 76.3276 58.7458C76.3266 58.7475 76.3253 58.7492 76.3243 58.7509C76.321 58.7559 76.3176 58.7609 76.3143 58.7662C76.2855 58.8103 76.2564 58.8573 76.2303 58.8763C76.2289 58.8773 76.2276 58.878 76.2263 58.879C76.2199 58.8827 76.2139 58.885 76.2082 58.885Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M78.5481 59.4744C78.4125 59.4203 78.276 59.3699 78.1374 59.3235C78.3342 59.1951 78.5307 59.0669 78.7275 58.9385L78.7569 59.0066L78.6816 59.2111L78.6214 59.4206L78.5481 59.4744ZM78.1368 59.3242L78.1357 59.3229C78.1364 59.3232 78.1371 59.3232 78.1374 59.3235C78.1374 59.3239 78.1371 59.3239 78.1368 59.3242Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M77.855 59.499C77.8831 59.451 77.9039 59.3789 77.941 59.3602C77.9996 59.3305 78.0682 59.3342 78.1331 59.3249C78.0404 59.3829 77.9477 59.441 77.855 59.499ZM78.1331 59.3249C78.1341 59.3245 78.1351 59.3239 78.1358 59.3232L78.1368 59.3245C78.1354 59.3245 78.1344 59.3249 78.1331 59.3249Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M74.2648 58.9468C74.2638 58.9468 74.2632 58.9468 74.2625 58.9468C74.1738 58.9448 74.1293 58.8213 74.127 58.5811C74.2699 58.6225 74.4088 58.6742 74.5436 58.7366C74.5416 58.7389 74.5396 58.7412 74.5376 58.7436C74.5363 58.7452 74.5349 58.7469 74.5336 58.7486C74.5286 58.7542 74.5239 58.7599 74.5192 58.7652C74.5189 58.7652 74.5189 58.7656 74.5185 58.7656C74.5169 58.7676 74.5152 58.7696 74.5132 58.7716C74.5075 58.7783 74.5015 58.7849 74.4955 58.7913C74.4945 58.7926 74.4934 58.7936 74.4921 58.795C74.4031 58.8907 74.3308 58.9408 74.2746 58.9461C74.2712 58.9464 74.2679 58.9468 74.2648 58.9468Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M80.7362 62.4243C80.7355 62.4243 80.7348 62.4243 80.7338 62.4243C80.4996 62.4236 80.2984 62.3192 80.0919 62.2525C80.0906 62.2518 80.0893 62.2515 80.0876 62.2512C80.0725 62.2462 80.0571 62.2415 80.0421 62.2372C80.0404 62.2368 80.0391 62.2361 80.0374 62.2358C80.0361 62.2355 80.0344 62.2348 80.0327 62.2345C80.0274 62.2328 80.0217 62.2315 80.0163 62.2301C80.0093 62.2281 80.0022 62.2261 79.9949 62.2245C80.1769 61.6913 80.359 61.1577 80.5411 60.6245L80.6097 60.397L80.6954 60.1751C80.862 60.3122 80.9404 60.4984 80.9397 60.7287C80.9397 60.7764 80.936 60.8261 80.929 60.8778C80.8647 61.0456 80.8379 61.2038 80.8379 61.3549C80.8376 61.7059 80.9808 62.0189 81.1238 62.3252C81.1217 62.3266 81.1194 62.3276 81.1174 62.3286C80.9795 62.398 80.8547 62.424 80.7379 62.4243C80.7372 62.4243 80.7369 62.4243 80.7362 62.4243Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M80.6965 60.1741C80.2681 60.0329 79.839 59.8918 79.4106 59.7506C79.4716 59.5785 79.5325 59.4063 79.5934 59.2341C79.6084 59.2341 79.6232 59.2338 79.6379 59.2335C80.0536 59.2275 80.4699 59.2178 80.8849 59.2178C80.8869 59.2178 80.8893 59.2178 80.8916 59.2178C80.8956 59.2178 80.9 59.2178 80.904 59.2178C81.0358 59.2178 81.1065 59.3025 81.1061 59.4343C81.1061 59.5248 81.0727 59.6372 81.003 59.7597C80.9177 59.9095 80.7996 60.0366 80.6965 60.1741Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M79.5926 59.2302C79.449 59.1875 79.3058 59.1445 79.1619 59.1018C79.1645 59.0978 79.1669 59.0938 79.1692 59.0898C79.1685 59.0894 79.1675 59.0891 79.1665 59.0891C79.365 58.9706 79.5628 58.8525 79.761 58.7347C79.7241 58.9062 79.6679 59.0717 79.5926 59.2302Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M81.9017 61.0769C81.9013 61.0769 81.9007 61.0769 81.9003 61.0769C81.8632 61.0766 81.825 61.0726 81.7852 61.0642C81.7818 61.0636 81.7785 61.0626 81.7751 61.0619C81.976 60.9521 82.1774 60.8423 82.3786 60.7326C82.3776 60.7342 82.3766 60.7362 82.3756 60.7379C82.2554 60.9605 82.0998 61.0742 81.9083 61.0766C81.906 61.0769 81.904 61.0769 81.9017 61.0769Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M74.2773 58.043C74.3476 57.8751 74.4179 57.707 74.4882 57.5391C74.5545 57.6659 74.6214 57.7927 74.6877 57.9195C74.5511 57.9605 74.4139 58.0019 74.2773 58.043Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M78.6741 59.4231C78.6738 59.4231 78.6735 59.4231 78.6735 59.4231C78.6564 59.4231 78.639 59.4224 78.6216 59.4207L78.6819 59.2112L78.7572 59.0067C78.8947 59.0294 79.0316 59.0567 79.1668 59.0891C79.1678 59.0891 79.1688 59.0894 79.1695 59.0898C79.1671 59.0938 79.1648 59.0978 79.1621 59.1018C79.0373 59.3063 78.8789 59.4214 78.6788 59.4231C78.6775 59.4231 78.6758 59.4231 78.6741 59.4231Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M76.2261 83.2305C76.2254 83.2305 76.2251 83.2301 76.2244 83.2301C76.0825 83.2301 75.9423 83.2054 75.8041 83.1394C75.7837 82.7747 75.6176 82.5425 75.3429 82.4097C75.0691 82.2779 74.8948 82.0533 74.8677 81.6899C75.3864 81.6289 75.9078 81.6029 76.4226 81.4867C76.606 81.4457 76.8309 81.2211 76.939 81.0189C77.0933 80.7286 77.2248 80.424 77.2245 80.1227C77.2241 79.9389 77.1746 79.7564 77.0511 79.5792C76.9761 79.4514 76.9005 79.3236 76.8252 79.1958C76.7281 79.3366 76.6237 79.4724 76.5377 79.6209C76.4955 79.6943 76.4878 79.7917 76.4647 79.8781C76.108 79.7697 75.7569 79.6389 75.3928 79.5602C75.3851 79.5585 75.3774 79.5565 75.3697 79.5545C75.367 79.5535 75.3643 79.5528 75.3616 79.5518C75.3047 79.5345 75.2529 79.5051 75.2037 79.4694C75.0153 79.3316 74.8656 79.0997 74.6247 79.099C74.6243 79.099 74.624 79.099 74.6233 79.099C74.623 79.099 74.6223 79.099 74.622 79.099C74.5641 79.099 74.5008 79.1127 74.4306 79.1441C74.4289 79.1448 74.4272 79.1457 74.4256 79.1464C74.1568 79.7053 73.6775 80.0927 73.5078 80.7487C73.5062 80.7553 73.5045 80.762 73.5025 80.7684C73.5022 80.77 73.5018 80.7714 73.5015 80.7727C73.5008 80.775 73.5001 80.777 73.4995 80.779C73.4991 80.7804 73.4988 80.7817 73.4982 80.7831C73.4339 80.9916 73.31 81.051 73.1688 81.0523C73.1675 81.0523 73.1658 81.0523 73.1641 81.0523C73.1621 81.0523 73.1601 81.0523 73.1578 81.0523C73.04 81.051 72.9111 81.0113 72.7943 80.9849C72.7916 80.9842 72.7886 80.9836 72.786 80.9829C72.7856 80.9829 72.7856 80.9829 72.7856 80.9829C72.7773 80.9809 72.7685 80.9792 72.7602 80.9775C72.7541 80.9762 72.7481 80.9749 72.7418 80.9739C72.4533 80.8595 72.1651 80.745 71.8763 80.6306C72.0968 80.2722 72.3509 79.9318 72.5289 79.5508C72.5902 79.4193 72.6186 79.2722 72.6183 79.1264C72.6173 78.7237 72.3977 78.3316 72.0564 78.3076C71.546 78.2722 71.3887 77.7984 71.0583 77.5475C71.0594 77.5448 71.0604 77.5425 71.0614 77.5398C71.0697 77.5195 71.0781 77.4994 71.0865 77.4794C71.2662 77.0567 71.5038 76.751 71.8857 76.7497C71.8863 76.7497 71.8873 76.7497 71.888 76.7497C71.8884 76.7497 71.889 76.7497 71.8894 76.7497C71.955 76.75 72.0249 76.759 72.0999 76.7781C72.1052 76.7794 72.1106 76.7811 72.1163 76.7824C72.1186 76.7831 72.121 76.7837 72.1233 76.7841C72.1273 76.7851 72.131 76.7861 72.1347 76.7871C72.5346 76.8902 72.9248 77.009 73.3459 77.01C73.3475 77.01 73.3492 77.01 73.3509 77.01C73.3512 77.01 73.3519 77.01 73.3526 77.01C73.5002 77.01 73.6511 76.9953 73.8081 76.9606C73.8114 76.9596 73.8148 76.9589 73.8181 76.9582C73.8358 76.9542 73.8539 76.9522 73.872 76.9522C73.8723 76.9522 73.8723 76.9522 73.8727 76.9522C73.876 76.9522 73.8793 76.9522 73.8827 76.9522C74.044 76.9586 74.216 77.1104 74.3854 77.2405C74.4249 77.2705 74.464 77.2996 74.5029 77.3256C74.5072 77.3283 74.5112 77.331 74.5156 77.334C74.5209 77.3373 74.5259 77.3403 74.5313 77.3436C74.5356 77.3466 74.5403 77.3493 74.5447 77.352C74.7201 77.4567 74.8308 77.5234 74.9269 77.5255C74.9286 77.5255 74.9299 77.5255 74.9316 77.5255C74.9326 77.5255 74.9339 77.5255 74.9353 77.5255C75.0828 77.5228 75.199 77.3643 75.4681 76.9539C75.4687 76.9529 75.4694 76.9519 75.4701 76.9509C75.4788 76.9379 75.4875 76.9242 75.4965 76.9105C75.4989 76.9068 75.5012 76.9032 75.5036 76.8995C75.5056 76.8965 75.5076 76.8938 75.5092 76.8908C75.5109 76.8882 75.5126 76.8858 75.5142 76.8831C75.5179 76.8778 75.5216 76.8722 75.525 76.8668C75.5283 76.8618 75.5316 76.8568 75.535 76.8518C75.537 76.8481 75.5393 76.8448 75.5417 76.8411C75.5444 76.8371 75.5471 76.8331 75.5497 76.8291C75.5537 76.8298 75.5574 76.8308 75.5614 76.8314C75.5668 76.8328 75.5722 76.8341 75.5775 76.8351C75.7141 76.8658 75.8499 76.8915 75.9845 76.8918C75.9855 76.8918 75.9868 76.8918 75.9878 76.8918C75.9888 76.8918 75.9895 76.8918 75.9905 76.8918C76.2024 76.8912 76.4098 76.8278 76.6076 76.6239C76.6083 76.6229 76.609 76.6222 76.6097 76.6216C76.6117 76.6199 76.613 76.6182 76.615 76.6162C76.618 76.6129 76.6214 76.6092 76.6247 76.6059C76.6271 76.6032 76.6294 76.6009 76.6314 76.5986C76.6354 76.5946 76.6391 76.5902 76.6428 76.5862C76.7569 76.6256 76.8677 76.6753 76.9741 76.734C77.027 77.1508 77.0384 77.5869 77.1414 77.9799C77.1424 77.9842 77.1438 77.9889 77.1448 77.9933C77.1458 77.9959 77.1465 77.9986 77.1471 78.0009C77.1485 78.0059 77.1498 78.0109 77.1512 78.0159C77.1535 78.024 77.1555 78.032 77.1579 78.0396C77.3382 78.6683 77.7031 79.0026 78.2466 79.0039C78.2479 79.0039 78.2489 79.0039 78.2499 79.0039C78.2506 79.0039 78.2512 79.0039 78.2519 79.0039C78.3597 79.0036 78.4745 78.9906 78.5966 78.9639C78.6047 78.9622 78.6127 78.9606 78.6207 78.9585C78.4052 79.4143 78.2111 79.8838 77.9691 80.3219C77.6539 80.8935 77.4507 81.6402 77.4513 82.3589C77.4517 82.4263 77.4534 82.4937 77.457 82.5605C77.3958 82.7276 77.3275 82.8918 77.2526 83.0526C77.2489 83.0533 77.2452 83.0536 77.2412 83.054C77.2338 83.055 77.2265 83.056 77.2188 83.057C77.1107 83.0713 77.0019 83.095 76.8934 83.12C76.6729 83.1711 76.4517 83.2288 76.2342 83.2301C76.2315 83.2301 76.2288 83.2305 76.2261 83.2305ZM75.8041 83.1397L75.8034 83.139C75.8038 83.139 75.8037 83.139 75.8041 83.1394V83.1397Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M73.3196 82.2219C73.3172 82.2219 73.3149 82.2219 73.3122 82.2219C73.018 82.2206 72.7302 82.1322 72.4417 82.0171C72.4307 82.0127 72.4196 82.0084 72.4086 82.0037C72.4059 82.0027 72.4029 82.0014 72.3999 82.0004C72.4565 81.8275 72.5127 81.655 72.5692 81.4822C72.6295 81.3137 72.6867 81.1442 72.7419 80.974C72.7483 80.975 72.7543 80.9764 72.7603 80.9777C72.7687 80.9794 72.7774 80.981 72.7858 80.983C72.7858 80.983 72.7858 80.983 72.7861 80.983C72.7888 80.9837 72.7918 80.9844 72.7945 80.9851C72.9113 81.0114 73.0401 81.0511 73.1579 81.0524C73.1603 81.0524 73.1623 81.0524 73.1643 81.0524C73.166 81.0524 73.1676 81.0524 73.169 81.0524C73.3102 81.0511 73.4341 80.9917 73.4983 80.7832C73.499 80.7819 73.4993 80.7805 73.4996 80.7792C73.5003 80.7772 73.501 80.7752 73.5017 80.7728C73.502 80.7715 73.5023 80.7702 73.5027 80.7685C73.5047 80.7622 73.5063 80.7555 73.508 80.7488C73.6777 80.0928 74.157 79.7054 74.4257 79.1465C74.4274 79.1459 74.429 79.1449 74.4307 79.1442C74.501 79.1129 74.5642 79.0992 74.6221 79.0992C74.6225 79.0992 74.6231 79.0992 74.6235 79.0992C74.6242 79.0992 74.6245 79.0992 74.6248 79.0992C74.8658 79.0998 75.0154 79.3317 75.2038 79.4695C75.253 79.5052 75.3049 79.5346 75.3618 79.552C75.3645 79.553 75.3672 79.5536 75.3698 79.5546C75.3775 79.5566 75.3852 79.5586 75.3929 79.5603C75.757 79.639 76.1081 79.7698 76.4649 79.8783C76.6603 79.7789 76.8558 79.6791 77.0512 79.5793C77.1747 79.7565 77.2243 79.939 77.2246 80.1229C77.225 80.4242 77.0934 80.7288 76.9391 81.0191C76.831 81.2213 76.6061 81.4458 76.4227 81.4869C75.908 81.603 75.3866 81.629 74.8678 81.6901C74.6576 81.7531 74.4173 81.7565 74.2423 81.8896C74.2369 81.8939 74.2313 81.8979 74.2256 81.9023C74.2219 81.9049 74.2182 81.9076 74.2145 81.9103C73.9066 82.1365 73.6114 82.2216 73.3219 82.2219C73.3213 82.2219 73.3206 82.2219 73.3196 82.2219Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M70.392 85.4009C70.1784 85.1993 70.0696 84.9327 70.0703 84.5981C70.0703 84.5874 70.0703 84.5764 70.0706 84.5657C70.1998 84.2618 70.3284 83.9578 70.4572 83.6541L70.4438 83.6952C70.561 83.8773 70.7065 84.0412 70.7899 84.2457C70.8705 84.4432 70.9181 84.5807 70.9187 84.6995C70.9194 84.9117 70.7705 85.0662 70.392 85.4009Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M71.7963 82.3191C71.795 82.3191 71.794 82.3191 71.793 82.3191C71.5775 82.3181 71.367 82.2237 71.1554 82.151C71.0875 82.1279 71.0199 82.1069 70.9516 82.0922L70.9419 82.0682C70.9988 81.905 71.0554 81.7422 71.1119 81.579C71.1186 81.582 71.1253 81.5851 71.1317 81.5881C71.2642 81.6465 71.3981 81.6685 71.5336 81.6688C71.5343 81.6688 71.535 81.6688 71.5356 81.6688C71.5366 81.6688 71.5376 81.6688 71.5383 81.6688C71.7639 81.6681 71.9924 81.6074 72.2207 81.5523C72.302 81.533 72.3834 81.514 72.4644 81.499C72.4644 81.499 72.4643 81.499 72.4647 81.499C72.4901 81.4943 72.5152 81.4899 72.5407 81.4859C72.5427 81.4859 72.5444 81.4856 72.546 81.4853C72.5537 81.4843 72.5614 81.4829 72.5691 81.4819C72.5125 81.6548 72.4563 81.8273 72.3998 82.0001C72.3971 82.0031 72.3947 82.0058 72.3921 82.0088C72.3884 82.0131 72.3847 82.0171 72.381 82.0211C72.3763 82.0265 72.372 82.0315 72.3673 82.0362C72.367 82.0368 72.3663 82.0375 72.3656 82.0381C72.1705 82.249 71.9828 82.3184 71.7987 82.3191C71.7977 82.3191 71.797 82.3191 71.7963 82.3191Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M70.9582 83.1934C70.9562 83.1934 70.9545 83.1934 70.9525 83.1934C70.8872 83.1924 70.8216 83.1757 70.7564 83.1567C70.7493 83.1547 70.7423 83.1527 70.7353 83.1507C70.7222 83.147 70.7095 83.143 70.6964 83.1393C70.6747 83.133 70.653 83.127 70.6315 83.1216C70.6222 83.1193 70.6128 83.1173 70.6038 83.1153C70.6623 82.9438 70.7206 82.7723 70.7791 82.6008C70.9043 82.6602 71.0352 82.7095 71.1526 82.7833C71.2022 82.8143 71.2637 82.9274 71.2634 82.9478C71.2631 82.9488 71.2631 82.9498 71.2624 82.9505C71.1871 83.0436 71.0971 83.177 71.0107 83.1894C70.9933 83.192 70.9763 83.1934 70.9592 83.1934C70.9589 83.1934 70.9585 83.1934 70.9582 83.1934Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M75.522 83.3142C75.5501 83.2658 75.5711 83.1934 75.608 83.1747C75.6672 83.1451 75.7361 83.1494 75.8017 83.14C75.7084 83.1981 75.6153 83.2562 75.522 83.3142ZM75.8017 83.14C75.8021 83.1397 75.8028 83.1394 75.8034 83.139L75.8041 83.1397C75.8031 83.1401 75.8024 83.14 75.8017 83.14Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M71.0584 77.5474C70.9162 77.4996 70.774 77.4523 70.6314 77.4049C70.6833 77.1056 70.7184 76.9044 70.7181 76.7549C70.7177 76.4486 70.5701 76.3575 70.1207 76.0799C70.1765 75.9191 70.2325 75.7589 70.2887 75.5984C70.4236 75.4012 70.5818 75.216 70.6812 75.0005C70.6879 74.9861 70.6906 74.9698 70.6909 74.9515C70.6913 74.8634 70.6257 74.7356 70.5775 74.6515C70.5765 74.6498 70.5755 74.6482 70.5742 74.6468C70.5608 74.6308 70.5313 74.6231 70.4972 74.6225C70.4955 74.6225 70.4938 74.6225 70.4918 74.6225C70.4912 74.6225 70.4905 74.6225 70.4901 74.6225C70.4517 74.6228 70.4095 74.6315 70.3807 74.6465C70.0885 74.7997 69.9955 75.116 69.8958 75.4239C69.6036 74.4219 69.6093 73.3365 69.5654 72.2674C69.5654 72.2654 69.5654 72.2635 69.5654 72.2611C69.5651 72.1293 69.7184 71.9678 69.8001 71.8187C69.943 71.9708 70.0681 72.2221 70.2345 72.2401C70.2368 72.2401 70.2388 72.2404 70.2412 72.2404H70.2415C70.2629 72.2404 70.2857 72.2304 70.3094 72.2131C70.3245 72.2024 70.3395 72.1891 70.3549 72.1734C70.3573 72.1714 70.3596 72.169 70.362 72.1667C70.3697 72.1584 70.3777 72.15 70.3858 72.141C70.3871 72.1397 70.3881 72.138 70.3894 72.1366C70.3914 72.1343 70.3934 72.1323 70.3954 72.13C70.3998 72.1247 70.4045 72.1193 70.4092 72.114C70.4132 72.109 70.4175 72.104 70.4219 72.0986C70.4235 72.0966 70.4252 72.0943 70.4272 72.0919C70.4299 72.0889 70.4323 72.0856 70.4349 72.0823C70.5089 71.9902 70.5872 71.8777 70.6642 71.8013C70.6682 71.797 70.6725 71.793 70.6769 71.789C70.8536 71.6221 71.0343 71.3976 71.2315 71.3372C71.8831 71.137 71.9835 70.4893 72.2131 69.9385C72.3493 69.9852 72.4852 70.0322 72.621 70.0796C72.7131 70.3839 72.7308 70.7916 72.9179 70.9632C73.1036 71.1343 73.4691 71.0369 73.7385 71.1146C73.7436 71.116 73.7482 71.1177 73.7533 71.1193C73.7593 71.1213 73.765 71.1233 73.771 71.1257C73.772 71.1263 73.7734 71.1266 73.7747 71.1273C73.7871 71.1323 73.7991 71.138 73.8108 71.144C73.8139 71.1457 73.8165 71.147 73.8192 71.1487C73.839 71.1594 73.858 71.172 73.8761 71.1857C73.8784 71.1874 73.8804 71.1894 73.8828 71.191C73.8851 71.1927 73.8875 71.1947 73.8898 71.1967C74.1006 71.3662 74.2262 71.7012 74.524 71.7056C74.5257 71.7056 74.5277 71.7056 74.5297 71.7056H74.53C74.5575 71.7056 74.5863 71.7026 74.6164 71.6969C74.7506 71.6705 74.8791 71.5294 75.0106 71.441L75.012 71.4403C75.2038 71.3903 75.3929 71.3599 75.5836 71.3595C75.5846 71.3595 75.5856 71.3595 75.5866 71.3595C75.5876 71.3595 75.5886 71.3595 75.5896 71.3595C75.8283 71.3599 76.0699 71.4073 76.3236 71.5204C76.3239 71.5207 76.3246 71.5211 76.3253 71.5214C76.3303 71.5234 76.3353 71.5257 76.3403 71.5281C76.3454 71.5304 76.3504 71.5327 76.355 71.5351C76.508 71.1237 76.6583 70.7199 76.8082 70.3162C76.9447 70.3826 77.0843 70.4066 77.2255 70.4069C77.2262 70.4069 77.2269 70.4069 77.2276 70.4069C77.2289 70.4069 77.2302 70.4069 77.2316 70.4069C77.4046 70.4063 77.58 70.3702 77.7557 70.3329C77.9277 70.2962 78.1001 70.2581 78.2704 70.2505C78.2641 70.2975 78.2607 70.3422 78.2607 70.3849C78.2604 70.5988 78.3417 70.7623 78.5037 70.8761C78.502 70.8808 78.5003 70.8858 78.499 70.8904L78.5127 70.8821C78.5097 70.8801 78.5067 70.8781 78.5037 70.8761C78.5586 70.7099 78.6124 70.5431 78.666 70.3762C78.67 70.3749 78.6744 70.3732 78.6787 70.3719C78.8189 70.3219 78.9508 70.2985 79.0756 70.2982C79.0763 70.2982 79.077 70.2982 79.0777 70.2982C79.079 70.2982 79.0803 70.2982 79.0817 70.2982C79.4207 70.2995 79.7052 70.4717 79.9599 70.7386C79.9635 70.7423 79.9672 70.7463 79.9706 70.75C79.9803 70.76 79.9897 70.7703 79.9994 70.781C80.0014 70.783 80.0034 70.7853 80.0057 70.7877C80.1336 70.8534 80.2507 70.9385 80.3558 71.0429C80.3839 71.5478 80.5506 71.9585 80.8819 72.2581C80.8243 72.429 80.7688 72.6005 80.7159 72.7726C80.655 72.9388 80.5931 73.1046 80.5302 73.2701C80.3086 72.9395 80.0305 72.7803 79.7002 72.779C79.6988 72.779 79.6975 72.779 79.6961 72.779C79.6955 72.779 79.6948 72.779 79.6941 72.779C79.5616 72.7793 79.4204 72.805 79.2714 72.855C79.2681 72.856 79.2651 72.8574 79.2621 72.8584C79.2547 72.8367 79.2477 72.8153 79.241 72.795C79.1242 72.4443 79.0656 72.2891 78.9394 72.2878C78.9387 72.2878 78.9384 72.2878 78.9378 72.2878C78.9321 72.2878 78.9261 72.2882 78.92 72.2888C78.8411 72.2972 78.7359 72.3585 78.579 72.4646C78.5787 72.465 78.578 72.4653 78.5776 72.4657C78.5753 72.4673 78.573 72.4686 78.5709 72.4703C78.5676 72.4723 78.5646 72.4747 78.5612 72.4767C78.5505 72.4843 78.5391 72.4917 78.5281 72.4997C78.5254 72.5014 78.5228 72.503 78.5201 72.505C78.5198 72.505 78.5197 72.5054 78.5194 72.5054C78.5167 72.507 78.5144 72.509 78.5117 72.5107C78.5087 72.513 78.5054 72.515 78.5023 72.517C78.5003 72.5187 78.4983 72.52 78.496 72.5214C78.493 72.5237 78.49 72.5257 78.4866 72.5281C78.486 72.5284 78.4853 72.5287 78.485 72.5294C78.4816 72.5314 78.4782 72.5337 78.4749 72.5361C78.4669 72.5417 78.4585 72.5474 78.4501 72.5531C78.4465 72.5557 78.4428 72.5581 78.4391 72.5607C78.4351 72.5634 78.4311 72.5664 78.427 72.5691C78.4264 72.5697 78.4254 72.5704 78.4247 72.5708C78.4213 72.5731 78.418 72.5754 78.4147 72.5778C78.2701 72.5291 78.1255 72.4803 77.9809 72.432C77.8316 72.4667 77.6723 72.4703 77.5348 72.5437C77.3039 72.6662 77.1415 72.8047 77.1415 73.0656C77.1415 73.1437 77.1563 73.2331 77.1881 73.3359C77.2252 73.4566 77.243 73.5614 77.243 73.6512C77.2433 73.8998 77.1074 74.0345 76.8691 74.0756C76.5023 74.1386 76.1342 74.1567 75.7078 74.2004C75.7827 74.7309 75.8527 75.2257 75.923 75.7205C75.5582 75.9725 75.4213 76.0669 75.4216 76.2745C75.4216 76.3992 75.4708 76.5644 75.5498 76.829C75.5471 76.833 75.5445 76.837 75.5418 76.841C75.5394 76.8447 75.5371 76.848 75.5351 76.8517C75.5317 76.8567 75.5284 76.8617 75.525 76.8667C75.5217 76.872 75.518 76.8777 75.5143 76.883C75.5127 76.8857 75.511 76.8881 75.5093 76.8907C75.5077 76.8937 75.5056 76.8964 75.5036 76.8994C75.5013 76.9031 75.499 76.9067 75.4966 76.9104C75.4876 76.9241 75.4789 76.9378 75.4702 76.9508C75.4695 76.9518 75.4688 76.9528 75.4681 76.9538C75.1991 77.3642 75.0826 77.5227 74.9353 77.5253C74.934 77.5253 74.9327 77.5253 74.9316 77.5253C74.93 77.5253 74.9286 77.5253 74.927 77.5253C74.8309 77.5233 74.7201 77.4566 74.5448 77.3519C74.5404 77.3492 74.5357 77.3465 74.5314 77.3435C74.526 77.3402 74.521 77.3372 74.5157 77.3338C74.5113 77.3308 74.5073 77.3282 74.5029 77.3255C74.4641 77.2995 74.425 77.2704 74.3855 77.2404C74.2161 77.1103 74.0441 76.9585 73.8828 76.9521C73.8794 76.9521 73.8761 76.9521 73.8727 76.9521C73.8724 76.9521 73.8724 76.9521 73.8721 76.9521C73.854 76.9521 73.8359 76.9541 73.8182 76.9581C73.8148 76.9588 73.8115 76.9595 73.8082 76.9605C73.6512 76.9952 73.5002 77.0099 73.3526 77.0099C73.352 77.0099 73.3513 77.0099 73.351 77.0099C73.3493 77.0099 73.3476 77.0099 73.3459 77.0099C72.9249 77.0088 72.5347 76.89 72.1348 76.7869C72.1311 76.7859 72.1274 76.7849 72.1234 76.7839C72.1211 76.7836 72.1187 76.7829 72.1164 76.7823C72.1107 76.7809 72.1053 76.7793 72.1 76.7779C72.025 76.7589 71.955 76.7499 71.8894 76.7496C71.8891 76.7496 71.8884 76.7496 71.8881 76.7496C71.8874 76.7496 71.8864 76.7496 71.8858 76.7496C71.5039 76.7509 71.2663 77.0565 71.0865 77.4793C71.0782 77.4993 71.0698 77.5194 71.0614 77.5397C71.0604 77.5424 71.0594 77.5447 71.0584 77.5474ZM78.6242 71.2004C78.5863 71.107 78.5489 71.0135 78.511 70.9201C78.5117 70.9074 78.5124 70.8948 78.5127 70.8821L78.499 70.8904C78.503 70.9004 78.507 70.9104 78.511 70.9201C78.5087 70.9581 78.505 70.9965 78.505 71.0332C78.505 71.0609 78.507 71.0876 78.5134 71.1123C78.5241 71.1537 78.5853 71.1717 78.6242 71.2004Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M84.2642 79.1025C84.2629 79.1019 84.2619 79.1009 84.2605 79.1002C84.2605 79.1005 84.2602 79.1012 84.2602 79.1019C84.0062 78.8579 83.7528 78.6144 83.4988 78.3705C83.3656 78.2046 83.3137 78.0268 83.3137 77.8416C83.3134 77.6224 83.3854 77.3925 83.4801 77.1596C83.4888 77.1589 83.4978 77.1583 83.5065 77.1579C83.5031 77.1489 83.4998 77.1399 83.4965 77.1309C83.6973 77.0021 83.8984 76.8733 84.0996 76.7445C84.4436 76.6725 84.7883 76.6004 85.1324 76.5283V76.5316C85.132 76.5486 85.1317 76.566 85.1317 76.5827C85.132 77.1082 85.3114 77.5229 85.6354 77.8483C85.4664 78.2543 85.2823 78.6157 84.8479 78.7292C84.6467 78.7819 84.4583 78.9734 84.2642 79.1025Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M78.2499 79.0039C78.2489 79.0039 78.2479 79.0039 78.2466 79.0039C77.7031 79.0026 77.3383 78.6682 77.1579 78.0396C77.1555 78.0319 77.1535 78.0239 77.1512 78.0159C77.1498 78.0109 77.1485 78.0059 77.1471 78.0009C77.1465 77.9986 77.1458 77.9959 77.1448 77.9932C77.1438 77.9889 77.1425 77.9842 77.1415 77.9799C77.0384 77.5868 77.027 77.1507 76.9741 76.734L77.0548 76.6729C77.3416 76.779 77.6281 76.8855 77.9149 76.9916C78.3292 77.1264 78.7439 77.2608 79.1582 77.3953C78.9792 77.9165 78.7998 78.4377 78.6207 78.9585C78.6127 78.9605 78.6047 78.9622 78.5967 78.9639C78.4745 78.9906 78.3597 79.0036 78.2519 79.0039C78.2512 79.0039 78.2506 79.0039 78.2499 79.0039Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M81.1469 72.9373C81.0033 72.8825 80.8597 72.8278 80.7158 72.7728C80.7687 72.6006 80.8243 72.4291 80.8818 72.2583C80.9913 72.1241 81.0927 71.979 81.2122 71.8588C81.3306 71.7391 81.3818 71.6303 81.3818 71.5278C81.3818 71.4171 81.3223 71.314 81.2229 71.2135C81.3989 70.703 81.5746 70.1925 81.7503 69.6817C82.0324 69.7788 82.3146 69.8759 82.5967 69.9727C82.589 70.0634 82.588 70.1582 82.588 70.2536C82.588 70.2873 82.5883 70.3213 82.5883 70.3547C82.5883 70.5849 82.582 70.8115 82.4903 70.9837C82.3735 71.2022 82.3444 71.4037 82.3444 71.5999C82.3444 71.7978 82.3742 71.9903 82.3742 72.1885C82.3742 72.2096 82.3738 72.2309 82.3732 72.2519L82.3651 72.2289C82.3624 72.2286 82.3594 72.2282 82.3564 72.2282C82.3179 72.2249 82.2798 72.2232 82.2423 72.2232C82.242 72.2232 82.2416 72.2232 82.2416 72.2232C82.2396 72.2232 82.238 72.2232 82.2363 72.2232C81.8096 72.2249 81.4561 72.4338 81.1844 72.8742C81.1807 72.8805 81.1767 72.8869 81.173 72.8932C81.1676 72.9022 81.162 72.9112 81.1569 72.9202C81.1536 72.9259 81.1502 72.9316 81.1469 72.9373Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M84.0994 76.7444C84.2389 76.3303 84.3771 75.9155 84.5194 75.5025C84.5636 75.374 84.5833 75.2532 84.583 75.1384C84.5823 74.9269 84.5133 74.736 84.4012 74.5579C84.4026 74.5549 84.4039 74.5518 84.4052 74.5488C84.4066 74.5462 84.4076 74.5438 84.4086 74.5415C84.411 74.5362 84.4133 74.5312 84.4156 74.5262C84.4166 74.5235 84.418 74.5212 84.419 74.5185C84.422 74.5122 84.425 74.5058 84.4277 74.4995C84.6911 73.9186 84.7667 73.7754 85.1148 73.7748C85.1154 73.7748 85.1165 73.7748 85.1171 73.7748C85.1188 73.7748 85.1204 73.7748 85.1225 73.7748C85.2135 73.7751 85.3233 73.7848 85.4592 73.7991C85.4776 73.8008 85.496 73.8028 85.5154 73.8048C85.5187 73.8051 85.5224 73.8054 85.5261 73.8061C85.5388 73.8074 85.5519 73.8088 85.5649 73.8101C85.5632 73.8121 85.5616 73.8138 85.5599 73.8158C85.5619 73.8168 85.5643 73.8178 85.5663 73.8188C85.5726 73.8989 85.5756 73.978 85.5756 74.056C85.5759 74.4691 85.4869 74.8618 85.2955 75.2809C85.1315 75.6406 85.1793 76.1087 85.1322 76.5282C84.7881 76.6002 84.4434 76.6723 84.0994 76.7444Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M82.0502 74.0681C82.0495 74.0681 82.0489 74.0681 82.0482 74.0681C81.8892 74.0674 81.74 73.9813 81.6098 73.8005C81.6081 73.7978 81.6061 73.7955 81.6044 73.7928C81.6004 73.7872 81.5964 73.7815 81.5924 73.7755C81.4214 73.5236 81.3005 73.2229 81.158 72.944C81.159 72.9443 81.1603 72.9447 81.1613 72.945C81.1633 72.9457 81.1657 72.9463 81.168 72.947C81.2765 72.9807 81.3792 72.9977 81.4759 72.998C81.4769 72.998 81.4776 72.998 81.4786 72.998C81.4799 72.998 81.4816 72.998 81.4829 72.998C81.8608 72.996 82.1496 72.7408 82.3558 72.2516C82.3591 72.244 82.3621 72.2366 82.3652 72.229L82.3732 72.252C82.6486 72.3687 82.9445 72.4919 82.9743 72.8813C82.9763 72.907 82.977 72.9323 82.977 72.9577C82.9759 73.2917 82.8002 73.5783 82.5576 73.8125C82.5549 73.8149 82.5523 73.8175 82.5499 73.8199C82.5469 73.8229 82.5439 73.8255 82.5405 73.8285C82.5275 73.8409 82.5141 73.8529 82.5007 73.8646C82.3484 73.9967 82.1972 74.0668 82.0539 74.0681C82.0526 74.0681 82.0516 74.0681 82.0502 74.0681Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M83.5065 77.158C83.5031 77.149 83.4998 77.1399 83.4964 77.1309C83.4998 77.1399 83.5031 77.149 83.5065 77.158ZM83.4964 77.1309C83.4151 76.913 83.3341 76.6952 83.2524 76.4773C83.301 76.245 83.4007 76.0001 83.4004 75.7803C83.4004 75.7616 83.3997 75.7429 83.398 75.7249C83.3944 75.6805 83.3924 75.6388 83.3924 75.5991C83.393 75.1313 83.6557 74.9704 84.0269 74.8533C84.1598 74.8113 84.2769 74.6595 84.4014 74.558C84.5135 74.7362 84.5825 74.9271 84.5831 75.1386C84.5835 75.2534 84.5637 75.3742 84.5195 75.5026C84.3773 75.9157 84.2391 76.3305 84.0995 76.7446C83.8984 76.8734 83.6972 77.0021 83.4964 77.1309Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M79.6735 77.498C79.6729 77.498 79.6722 77.498 79.6715 77.498C79.5005 77.4977 79.3295 77.4677 79.1588 77.3953C79.1622 77.3896 79.1652 77.3843 79.1685 77.3786C79.1725 77.3723 79.1765 77.3659 79.1802 77.3596C79.1882 77.3466 79.1959 77.3339 79.204 77.3215C79.5875 76.7086 80.0135 76.394 80.4777 76.3926C80.4787 76.3926 80.4794 76.3926 80.4804 76.3926C80.4811 76.3926 80.4818 76.3926 80.4825 76.3926C80.6478 76.393 80.8174 76.433 80.9921 76.5131C80.9968 76.5154 81.0015 76.5174 81.0062 76.5197C81.039 76.5351 81.0487 76.6135 81.0484 76.7076C81.0484 76.796 81.0397 76.8981 81.034 76.9748C81.029 77.0376 80.9537 77.139 80.8971 77.162C80.4911 77.3282 80.0835 77.497 79.6769 77.498C79.6759 77.498 79.6745 77.498 79.6735 77.498ZM79.1584 77.3953H79.1588H79.1584Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M75.9877 76.8918C75.9867 76.8918 75.9853 76.8918 75.9843 76.8918C75.8498 76.8915 75.7139 76.8658 75.5774 76.8351C75.572 76.8341 75.5666 76.8328 75.5613 76.8314C75.5573 76.8308 75.5536 76.8298 75.5496 76.8291C75.4706 76.5645 75.4214 76.3994 75.4214 76.2746C75.4211 76.067 75.5579 75.9726 75.9227 75.7207C76.248 75.5735 76.573 75.4264 76.9642 75.2492C76.8438 75.749 76.7434 76.1675 76.6426 76.5862C76.639 76.5902 76.6352 76.5945 76.6312 76.5986C76.6292 76.6009 76.6269 76.6032 76.6246 76.6059C76.6212 76.6092 76.6179 76.6129 76.6149 76.6162C76.6128 76.6182 76.6115 76.6199 76.6095 76.6216C76.6088 76.6222 76.6081 76.6229 76.6075 76.6239C76.4097 76.8278 76.2019 76.8912 75.9903 76.8918C75.9893 76.8918 75.9887 76.8918 75.9877 76.8918Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M83.5864 71.8564C83.585 71.8564 83.5837 71.8564 83.5827 71.8564C83.4441 71.8554 83.324 71.798 83.2493 71.6579C83.2487 71.6569 83.2483 71.6559 83.2477 71.6549C83.2447 71.6496 83.242 71.6439 83.2393 71.6382C83.237 71.6332 83.2343 71.6279 83.232 71.6225C83.2095 71.5711 83.1985 71.4991 83.1985 71.4237C83.1988 71.3206 83.2199 71.2115 83.2614 71.1424C83.2631 71.1394 83.2647 71.1367 83.2664 71.134C83.2697 71.1284 83.2734 71.1227 83.2768 71.117C83.2832 71.107 83.2899 71.097 83.2962 71.0873C83.2972 71.086 83.2982 71.0847 83.2992 71.083C83.4451 70.8678 83.6426 70.7183 83.8461 70.717C83.8471 70.717 83.8478 70.717 83.8488 70.717C83.8491 70.717 83.8498 70.717 83.8504 70.717C83.9147 70.7173 83.98 70.7327 84.0439 70.7654C84.0466 70.7667 84.0492 70.768 84.0519 70.7694C84.2972 70.9005 84.4699 71.1858 84.7564 71.4894C84.3535 71.6286 84.0807 71.7256 83.8072 71.8167C83.8012 71.8187 83.7956 71.8204 83.7895 71.8224C83.7209 71.8437 83.6533 71.8558 83.5894 71.8564C83.5884 71.8564 83.5874 71.8564 83.5864 71.8564Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M83.8002 80.5793C83.5111 80.5039 83.2226 80.4285 82.9341 80.3528C83.1222 79.6918 83.3106 79.0311 83.4987 78.3702C83.7527 78.6141 84.0061 78.8576 84.2601 79.1015C84.1065 79.594 83.9535 80.0869 83.8002 80.5793Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M79.9575 74.4509C79.7219 73.9117 79.492 73.3852 79.2617 72.8587C79.2617 72.8587 79.2617 72.8587 79.262 72.8587C79.2651 72.8577 79.2681 72.8563 79.2714 72.8553C79.4204 72.8053 79.5616 72.7796 79.6941 72.7792C79.6948 72.7792 79.6954 72.7792 79.6961 72.7792C79.6975 72.7792 79.6988 72.7792 79.7001 72.7792C80.0305 72.7806 80.3086 72.9398 80.5301 73.2704C80.3809 73.6548 80.3521 74.1009 79.9575 74.4509Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M86.492 72.4431C86.3504 72.2756 86.2939 72.0918 86.2942 71.8969C86.2942 71.699 86.3527 71.4898 86.4401 71.2749C86.5043 71.2986 86.5773 71.3086 86.6322 71.3483C86.924 71.5599 87.074 71.704 87.073 71.8499C87.0716 72.0127 86.8822 72.1782 86.492 72.4431Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M85.9951 73.9121C85.9945 73.9121 85.9938 73.9121 85.9931 73.9121C85.8489 73.9118 85.7063 73.8868 85.5664 73.8187C85.5644 73.8177 85.5621 73.8167 85.5601 73.8157C85.5617 73.8137 85.5634 73.812 85.5651 73.81C85.8238 73.5187 86.0818 73.2278 86.3402 72.9365C86.696 73.0533 87.0146 73.2124 87.0179 73.7339C86.9972 73.7366 86.9764 73.7393 86.9553 73.7426C86.954 73.743 86.9527 73.743 86.9513 73.7433C86.9262 73.7473 86.9015 73.7516 86.8763 73.7563C86.8697 73.7576 86.863 73.7586 86.8563 73.76C86.8476 73.7616 86.8392 73.7633 86.8305 73.765C86.5544 73.8207 86.2763 73.9104 86.0032 73.9121C86.0005 73.9121 85.9978 73.9121 85.9951 73.9121Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M79.5139 78.9055C79.4613 78.7944 79.3472 78.6563 79.3596 78.5725C79.3602 78.5669 79.3619 78.5615 79.3639 78.5562C79.4168 78.4247 79.5671 78.2839 79.6889 78.2469C79.6919 78.2459 79.6949 78.2449 79.6979 78.2442C79.6986 78.2442 79.6993 78.2439 79.6996 78.2439C79.7327 78.2348 79.7679 78.2309 79.8033 78.2305C79.804 78.2305 79.8047 78.2305 79.8054 78.2305C79.806 78.2305 79.807 78.2305 79.8077 78.2305C79.8944 78.2309 79.9847 78.2549 80.0617 78.2919C80.0684 78.2953 80.0751 78.2986 80.0815 78.3019C80.0832 78.3026 80.0848 78.3036 80.0865 78.3046C80.0928 78.3079 80.0992 78.3116 80.1052 78.3149C80.2097 78.376 80.2692 78.5265 80.3482 78.6372C80.2174 78.7157 80.0902 78.8218 79.9546 78.8648C79.8124 78.9102 79.6611 78.8945 79.5139 78.9055Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M83.0173 77.1956C83.0166 77.1956 83.0163 77.1956 83.0159 77.1956C82.9952 77.1956 82.9747 77.1949 82.9543 77.1939C82.9513 77.1939 82.9483 77.1936 82.9453 77.1936C82.9319 77.1929 82.9188 77.1919 82.9055 77.1905C82.9008 77.1899 82.8964 77.1895 82.8921 77.1892C82.79 77.1779 82.7358 77.0891 82.7351 76.9767C82.7348 76.8759 82.7779 76.7564 82.869 76.6567C82.9627 76.5542 83.1227 76.5342 83.2525 76.4772C83.3342 76.6951 83.4152 76.9129 83.4965 77.1308C83.4998 77.1398 83.5032 77.1488 83.5065 77.1579C83.4978 77.1582 83.4888 77.1589 83.4801 77.1595C83.4721 77.1602 83.464 77.1609 83.4563 77.1615C83.3124 77.1732 83.1665 77.1949 83.0246 77.1956C83.0223 77.1956 83.0196 77.1956 83.0173 77.1956Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M79.262 72.8584C78.9792 72.7653 78.6968 72.6722 78.4143 72.5791C78.4146 72.5788 78.415 72.5784 78.4153 72.5781C78.415 72.5781 78.4146 72.5778 78.4146 72.5778C78.418 72.5754 78.4213 72.5731 78.4247 72.5708C78.4253 72.5704 78.4264 72.5697 78.427 72.5691C78.431 72.5664 78.4351 72.5634 78.4391 72.5607C78.4428 72.5581 78.4464 72.5558 78.4501 72.5531C78.4585 72.5474 78.4668 72.5417 78.4749 72.5361C78.4782 72.5337 78.4816 72.5314 78.4849 72.5294C78.4853 72.5287 78.4859 72.5284 78.4866 72.5281C78.4899 72.5257 78.4929 72.5237 78.4959 72.5214C78.4983 72.52 78.5003 72.5187 78.5023 72.517C78.5053 72.515 78.5087 72.513 78.5117 72.5107C78.5144 72.509 78.5167 72.507 78.5194 72.5054C78.5197 72.5054 78.5197 72.505 78.5201 72.505C78.5227 72.503 78.5254 72.5014 78.5281 72.4997C78.5391 72.4917 78.5505 72.4843 78.5612 72.4767C78.5646 72.4747 78.5676 72.4723 78.5709 72.4703C78.5729 72.4686 78.5753 72.4673 78.5776 72.4657C78.578 72.4653 78.5786 72.465 78.579 72.4646C78.7359 72.3589 78.841 72.2972 78.92 72.2888C78.926 72.2882 78.932 72.2878 78.9377 72.2878C78.9384 72.2878 78.9387 72.2878 78.9394 72.2878C79.0656 72.2891 79.1242 72.4443 79.241 72.795C79.2477 72.8153 79.2547 72.8367 79.262 72.8584Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M77.9148 76.9917C77.628 76.8856 77.3415 76.7792 77.0547 76.6731C77.0594 76.6697 77.0641 76.6664 77.0687 76.6634C77.0738 76.66 77.0785 76.6564 77.0835 76.653C77.0942 76.6454 77.1049 76.6384 77.1152 76.631C77.137 76.616 77.1578 76.602 77.1775 76.5883C77.1792 76.5873 77.1805 76.5863 77.1819 76.5853C77.3629 76.4622 77.4838 76.3908 77.5728 76.3818C77.5791 76.3811 77.5855 76.3808 77.5915 76.3808C77.5918 76.3808 77.5922 76.3808 77.5925 76.3808C77.7314 76.3818 77.7913 76.5529 77.9008 76.9423C77.9014 76.944 77.9018 76.9457 77.9021 76.9477C77.9028 76.9497 77.9034 76.952 77.9041 76.954C77.9051 76.958 77.9065 76.9623 77.9075 76.9663C77.9098 76.9747 77.9121 76.9834 77.9148 76.9917Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M82.8838 83.2346L82.8818 83.2333C82.8822 83.2329 82.8822 83.2323 82.8825 83.2316C82.8828 83.2326 82.8835 83.2336 82.8838 83.2346ZM82.8825 83.2316C82.8129 83.1055 82.7028 82.9897 82.6894 82.8486C82.6891 82.8432 82.6887 82.8382 82.6887 82.8326C82.6887 82.7235 82.7915 82.5876 82.8453 82.4642C82.8975 82.5596 82.9923 82.65 82.9926 82.7515C82.9926 82.7525 82.9926 82.7531 82.9926 82.7541C82.9913 82.9089 82.9227 83.0721 82.8825 83.2316Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M78.1259 72.8086C78.1255 72.8086 78.1252 72.8086 78.1249 72.8086C78.0348 72.8076 77.987 72.6808 77.981 72.4322C78.1255 72.4806 78.2701 72.5293 78.4147 72.578C78.4147 72.578 78.415 72.5784 78.4154 72.5784C78.415 72.5787 78.4147 72.579 78.4144 72.5794C78.4124 72.5817 78.4104 72.5844 78.4087 72.5867C78.407 72.5887 78.4053 72.5904 78.404 72.5924C78.4036 72.5927 78.4033 72.593 78.403 72.5934C78.397 72.601 78.3909 72.6084 78.3849 72.6157C78.3836 72.6171 78.3822 72.6184 78.3812 72.6201C78.3789 72.6227 78.3769 72.625 78.3745 72.6277C78.3715 72.6314 78.3682 72.6351 78.3652 72.6384C78.3652 72.6387 78.3652 72.6387 78.3648 72.6387C78.3621 72.6417 78.3598 72.6448 78.3571 72.6478C78.2708 72.7452 78.1995 72.7982 78.1429 72.8073C78.1369 72.8083 78.1316 72.8086 78.1259 72.8086Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M84.7933 81.2297C84.7926 81.2297 84.7923 81.2297 84.792 81.2297C84.6879 81.2287 84.625 81.1026 84.6052 80.9037C84.7675 80.3532 84.8616 80.0349 84.8609 79.8133C84.8603 79.5107 84.6835 79.3889 84.2642 79.1023C84.4583 78.9732 84.6467 78.7816 84.8479 78.7289C85.2823 78.6155 85.4663 78.2541 85.6354 77.848C85.7749 77.8944 85.9145 77.9405 86.0537 77.9872C86.046 78.9428 86.0386 79.8987 86.0316 80.8547C86.0313 80.855 86.0313 80.8557 86.0313 80.856C86.0303 80.8557 86.0289 80.8554 86.0276 80.8547C85.9007 80.8157 85.7769 80.79 85.6548 80.7893C85.6538 80.7893 85.6531 80.7893 85.6521 80.7893C85.6511 80.7893 85.6504 80.7893 85.6494 80.7893C85.4473 80.79 85.2495 80.8607 85.0524 81.0562C85.0403 81.0682 85.0279 81.0809 85.0155 81.0939C85.0132 81.0966 85.0105 81.0993 85.0082 81.1019C85.0038 81.1066 84.9995 81.111 84.9951 81.1153C84.9934 81.117 84.9914 81.1189 84.9894 81.1206C84.9145 81.1947 84.8499 81.2287 84.796 81.2297C84.795 81.2297 84.7943 81.2297 84.7933 81.2297ZM84.2642 79.1023C84.2629 79.1016 84.2618 79.1006 84.2605 79.1C84.2618 79.1006 84.2629 79.1016 84.2642 79.1023Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M84.6052 80.9036C84.3368 80.7955 84.0684 80.6877 83.8003 80.5793C83.9536 80.0868 84.1065 79.5939 84.2601 79.1014C84.2601 79.1008 84.2605 79.1001 84.2605 79.0998C84.2618 79.1005 84.2628 79.1015 84.2642 79.1021C84.6835 79.3888 84.8602 79.5105 84.8609 79.8132C84.8616 80.0347 84.7675 80.353 84.6052 80.9036Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M87.6708 76.1677C87.6708 76.1677 87.6708 76.1677 87.6674 76.1677C87.2738 76.1671 86.9867 75.9749 86.9191 75.4684C86.9178 75.457 86.9161 75.4453 86.9151 75.4337C86.9147 75.4313 86.9144 75.4286 86.9141 75.426C86.9241 75.428 86.9345 75.4296 86.9445 75.4316C86.9465 75.432 86.9482 75.4323 86.9502 75.4327C86.9539 75.4333 86.9576 75.434 86.9613 75.4346C87.0791 75.4567 87.1969 75.4797 87.312 75.4804C87.3144 75.4804 87.3163 75.4804 87.3184 75.4804C87.319 75.4804 87.32 75.4804 87.3207 75.4804C87.5198 75.48 87.7109 75.4123 87.8816 75.1597C87.9988 74.9896 88.059 74.8374 88.059 74.6902C88.059 74.4287 87.8682 74.1844 87.4582 73.8895L87.4225 73.8681C87.5048 73.6859 87.5871 73.5041 87.6708 73.3219C88.3267 73.1667 88.3334 72.487 88.5443 71.9715C88.8957 71.8985 89.2437 71.825 89.5918 71.752C89.4178 72.2585 89.2438 72.7653 89.0697 73.2718C88.9626 73.5181 88.9292 73.7586 88.9292 73.9972C88.9292 74.3219 88.9861 74.6425 88.9861 74.9675C88.9861 74.9695 88.9861 74.9719 88.9861 74.9742C88.8723 75.3055 88.7618 75.6365 88.648 75.9679C88.3636 76.0349 88.0791 76.1357 87.7946 76.1617C87.7545 76.1657 87.7109 76.1677 87.6708 76.1677Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M88.9861 74.9739C88.9861 74.9715 88.9861 74.9692 88.9861 74.9672C88.9861 74.6422 88.9292 74.3216 88.9292 73.9969C88.9292 73.7583 88.9627 73.5178 89.0698 73.2715C89.3542 73.419 89.6755 73.5335 89.6755 73.9749C89.6755 74.0083 89.6755 74.0433 89.6722 74.0807C89.622 74.5538 89.3844 74.8474 88.9861 74.9739Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M69.899 84.5776C69.8984 84.5776 69.8977 84.5776 69.8967 84.5776C69.8234 84.5776 69.7508 84.5706 69.6791 84.5573C69.6781 84.5573 69.6775 84.5569 69.6765 84.5569C69.6751 84.5566 69.6735 84.5563 69.6721 84.5559C69.8006 84.0988 69.9583 83.6757 70.4569 83.6544C70.3281 83.958 70.1996 84.262 70.0704 84.566C70.0653 84.5666 70.06 84.5673 70.055 84.568C70.0038 84.5743 69.9529 84.5776 69.9027 84.5776C69.9014 84.5776 69.9004 84.5776 69.899 84.5776Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M33.5309 61.657C33.5302 61.657 33.5296 61.657 33.5289 61.657C33.4034 61.657 33.2719 61.6463 33.1038 61.6356C33.0905 61.6346 33.0764 61.634 33.0624 61.633C33.0138 61.63 32.9623 61.627 32.9071 61.6243C32.905 61.624 32.9027 61.624 32.9004 61.624C33.0463 61.1382 33.1671 60.7347 33.2883 60.3313L33.291 60.3297C33.5239 60.4955 33.7752 60.638 33.982 60.8389C34.0594 60.9139 34.1056 61.0797 34.1052 61.2216C34.1052 61.2446 34.1039 61.2673 34.1012 61.2886C34.0631 61.6063 33.8264 61.6466 33.6139 61.6553C33.6065 61.6557 33.5989 61.656 33.5912 61.6563C33.5714 61.6567 33.552 61.657 33.5323 61.657C33.5319 61.657 33.5316 61.657 33.5309 61.657Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M31.1044 63.3364C31.1014 63.243 31.0924 63.1496 31.092 63.0565C31.092 63.0141 31.0937 62.9717 31.099 62.9297C31.1031 62.894 31.2115 62.8616 31.2715 62.8276C31.2762 62.9631 31.2809 63.0978 31.2852 63.2333C31.2332 63.263 31.1815 63.2924 31.1294 63.3221C31.1211 63.3267 31.1127 63.3314 31.1044 63.3364Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M33.7556 69.0383C33.7556 69.0383 33.7552 69.0383 33.7549 69.0383C33.7334 69.0383 33.7117 69.0373 33.6896 69.0346C33.7646 68.8618 33.794 68.702 33.794 68.5505C33.7944 68.1985 33.6357 67.8912 33.5203 67.5715C33.5226 67.5695 33.5253 67.5675 33.5276 67.5655C33.5293 67.5645 33.5306 67.5632 33.532 67.5622C33.6665 67.4574 33.8151 67.4391 33.9661 67.4387C33.9684 67.4387 33.9711 67.4387 33.9734 67.4387C33.9741 67.4387 33.9748 67.4387 33.9751 67.4387C33.9925 67.4387 34.0102 67.4387 34.0276 67.4391C34.0457 67.4394 34.0638 67.4401 34.0819 67.4404C34.0876 67.4407 34.0932 67.4407 34.0989 67.4407C34.129 67.4417 34.1592 67.4424 34.189 67.4424C34.1896 67.4424 34.19 67.4424 34.1906 67.4424C34.1926 67.4424 34.195 67.4424 34.1973 67.4424C34.3988 67.4417 34.5953 67.4097 34.7596 67.1818C34.7639 67.1758 34.768 67.1701 34.772 67.1638C34.7763 67.1578 34.7803 67.1514 34.7847 67.1451C34.785 67.1448 34.785 67.1444 34.7853 67.1441C34.788 67.1401 34.7904 67.1361 34.7931 67.1321L34.795 67.1304C34.9369 67.1795 35.0785 67.2289 35.2201 67.2779L35.2214 67.2796C35.2372 67.5128 35.2455 67.7477 35.2703 67.9786C35.2753 68.0283 35.278 68.0754 35.278 68.1204C35.2773 68.5175 35.0698 68.7327 34.7054 68.8188L34.704 68.8181C34.703 68.8128 34.7017 68.8074 34.7007 68.8021C34.7007 68.8018 34.7003 68.8014 34.7003 68.8011C34.6993 68.7954 34.698 68.7894 34.6967 68.7841C34.6512 68.5682 34.6267 68.4678 34.5678 68.4661C34.5671 68.4661 34.5668 68.4661 34.5661 68.4661C34.5611 68.4661 34.5554 68.4668 34.5497 68.4684C34.5082 68.4791 34.4507 68.5278 34.3637 68.6106C34.3536 68.6202 34.3432 68.6303 34.3322 68.6406C34.3285 68.6446 34.3245 68.6483 34.3208 68.6519C34.3191 68.6533 34.3178 68.6546 34.3165 68.656C34.3148 68.6576 34.3128 68.6596 34.3111 68.6613C34.3094 68.663 34.3078 68.6643 34.3061 68.666C34.3001 68.6716 34.2941 68.6776 34.288 68.6836C34.2857 68.686 34.2833 68.688 34.2813 68.6903C34.28 68.6913 34.2786 68.6927 34.2776 68.6937C34.2733 68.701 34.2686 68.708 34.2643 68.7147C34.1314 68.9222 33.9657 69.0367 33.7606 69.0383C33.7589 69.0383 33.7572 69.0383 33.7556 69.0383Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M35.2213 67.2795L35.22 67.2779C35.2752 67.1037 35.3304 66.9292 35.3853 66.755C35.5038 66.4153 35.6219 66.0757 35.7397 65.736C35.7973 65.5645 35.8549 65.393 35.9117 65.2211H35.9124C36.3572 65.1574 36.5336 64.767 36.6889 64.3513C36.9994 64.2415 37.2418 64.0396 37.3669 63.6686C37.5082 63.2492 37.6541 62.8314 37.7976 62.413H37.798C37.8074 62.414 37.8164 62.415 37.8251 62.4164C37.8254 62.4164 37.8258 62.4164 37.8258 62.4164C38.0075 62.4394 38.1451 62.4561 38.2552 62.4561C38.2562 62.4561 38.2572 62.4561 38.2578 62.4561C38.2585 62.4561 38.2588 62.4561 38.2592 62.4561C38.5831 62.4557 38.6725 62.3113 38.964 61.7594C38.969 61.75 38.9741 61.7407 38.9791 61.731C38.9798 61.73 38.9804 61.7287 38.9811 61.7273C38.9854 61.719 38.9898 61.711 38.9941 61.7023C38.9941 61.702 38.9945 61.7016 38.9948 61.7013C38.9971 61.697 38.9995 61.6923 39.0018 61.688C39.1411 61.728 39.2776 61.7754 39.4121 61.8304C39.2545 62.9466 38.3853 63.7784 38.2535 64.9349C38.2528 64.9409 38.2518 64.9472 38.2508 64.9532C38.2505 64.9569 38.2498 64.9609 38.2488 64.9649C38.2013 65.2308 37.9265 65.4938 37.6149 65.4948C37.6142 65.4948 37.6136 65.4948 37.6132 65.4948C37.6126 65.4948 37.6122 65.4948 37.6119 65.4948C37.5329 65.4948 37.4516 65.4774 37.3709 65.4394C37.3693 65.4387 37.3676 65.4377 37.3659 65.437C37.3629 65.4357 37.3599 65.434 37.3569 65.4327C37.2565 65.382 37.1725 65.36 37.1009 65.3596C37.1002 65.3596 37.0999 65.3596 37.0995 65.3596C37.0992 65.3596 37.0985 65.3596 37.0979 65.3596C36.8197 65.361 36.732 65.6963 36.6192 65.9959C36.6182 65.9989 36.6169 66.0023 36.6159 66.0053C36.6152 66.0066 36.6146 66.0083 36.6142 66.0096C36.6129 66.0129 36.6116 66.0163 36.6102 66.0196C36.6099 66.0213 36.6092 66.0226 36.6086 66.0243C36.6079 66.026 36.6072 66.028 36.6065 66.0296C36.6052 66.033 36.6038 66.0363 36.6025 66.04C36.5386 66.2021 36.4723 66.3636 36.4047 66.5241C36.0105 66.776 35.6159 67.028 35.2213 67.2795Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M35.9124 65.2209C36.062 64.7982 36.2333 64.4021 36.6888 64.3511C36.5335 64.7668 36.3571 65.1572 35.9124 65.2209Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M35.22 67.2781C35.0784 67.229 34.9368 67.1796 34.7949 67.1306C34.9917 67.0054 35.1885 66.8803 35.3853 66.7552C35.3304 66.9294 35.2752 67.1039 35.22 67.2781Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M35.7398 65.7358C35.6237 65.6177 35.5651 65.5186 35.5654 65.4389C35.5658 65.3281 35.6802 65.255 35.9118 65.221C35.8549 65.3928 35.7974 65.5643 35.7398 65.7358Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M37.7585 70.989C37.4804 70.8906 37.2019 70.7921 36.9238 70.6937C36.8699 70.2416 36.639 69.979 36.2645 69.9777C36.2635 69.9777 36.2625 69.9777 36.2618 69.9777C36.2478 69.9777 36.2334 69.978 36.219 69.9787C35.9402 69.993 35.6527 70.1395 35.3696 70.2313C35.3629 70.2333 35.3562 70.2356 35.3495 70.2376C35.2227 70.2773 35.1132 70.298 35.0192 70.2983C35.0185 70.2983 35.0178 70.2983 35.0168 70.2983C35.0158 70.2983 35.0145 70.2983 35.0135 70.2983C34.7086 70.2967 34.5737 70.0748 34.5617 69.5686C34.5617 69.5613 34.5613 69.5536 34.5617 69.5462C34.562 69.3113 34.6561 69.0614 34.7053 68.8189C35.0697 68.7328 35.2772 68.5176 35.2779 68.1205C35.2779 68.0755 35.2752 68.0284 35.2702 67.9787C35.2454 67.7478 35.2371 67.5129 35.2213 67.2797C35.6159 67.0281 36.0105 66.7761 36.4048 66.5242C36.4529 66.6814 36.4603 66.9363 36.5557 66.9797C37.2853 67.3104 37.5085 68.1929 38.0196 68.7561C38.0142 68.8205 38.0125 68.8843 38.0125 68.948C38.0125 69.0608 38.0179 69.1725 38.0179 69.2853C38.0179 69.5159 37.9951 69.7495 37.8542 70.0004C37.7739 70.1438 37.7615 70.333 37.7615 70.5306C37.7619 70.621 37.7645 70.7134 37.7642 70.8038C37.7642 70.8669 37.7628 70.929 37.7585 70.989Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M30.671 73.7654C30.6115 73.5595 30.4786 73.3446 30.4793 73.1464C30.4793 73.1217 30.4813 73.0977 30.486 73.074C30.6523 72.1905 30.9793 71.3747 31.6446 70.7677C31.6483 70.7644 31.6523 70.7607 31.6563 70.7571C31.6583 70.7554 31.6607 70.7534 31.6627 70.7514C31.7748 70.6516 31.8953 70.5679 32.0017 70.5665C32.0027 70.5665 32.0034 70.5665 32.0044 70.5665C32.0054 70.5665 32.0067 70.5665 32.0077 70.5665C32.0757 70.5675 32.1373 70.6029 32.1871 70.69C32.1885 70.6923 32.1898 70.6947 32.1911 70.697C32.1931 70.7007 32.1951 70.7043 32.1972 70.7083C32.2648 70.8398 32.3244 71.0554 32.3244 71.2252C32.3247 71.3026 32.3126 71.3703 32.2835 71.4167C31.7771 72.2238 31.2146 72.9869 30.671 73.7651V73.7654Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M34.7037 68.8181C34.5628 68.7724 34.4206 68.731 34.2773 68.6937C34.2783 68.6927 34.2797 68.6913 34.281 68.6903C34.283 68.688 34.2854 68.686 34.2877 68.6837C34.2938 68.6777 34.2998 68.6717 34.3058 68.666C34.3075 68.6643 34.3091 68.663 34.3108 68.6613C34.3125 68.6597 34.3145 68.6576 34.3162 68.656C34.3175 68.6546 34.3188 68.6533 34.3205 68.652C34.3242 68.6483 34.3282 68.6446 34.3319 68.6406C34.3429 68.6303 34.3533 68.6203 34.3634 68.6106C34.4504 68.5278 34.5079 68.4791 34.5494 68.4685C34.5551 68.4668 34.5608 68.4661 34.5658 68.4661C34.5665 68.4661 34.5668 68.4661 34.5675 68.4661C34.6264 68.4678 34.6509 68.5682 34.6964 68.7841C34.6977 68.7894 34.699 68.7954 34.7 68.8011C34.7 68.8014 34.7004 68.8018 34.7004 68.8021C34.7014 68.8075 34.7027 68.8128 34.7037 68.8181Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M43.4185 68.2856C43.4667 68.1191 43.5159 67.953 43.5671 67.7868C43.5661 67.7818 43.5651 67.7768 43.5641 67.7718C43.5627 67.7638 43.5611 67.7565 43.5597 67.7488C43.5199 67.5346 43.4981 67.4348 43.4406 67.4325C43.4396 67.4325 43.4389 67.4325 43.4382 67.4325C43.4355 67.4325 43.4329 67.4325 43.4302 67.4331C43.4269 67.4335 43.4232 67.4341 43.4192 67.4355C43.4188 67.4355 43.4185 67.4355 43.4182 67.4358C43.3914 67.4438 43.3579 67.4672 43.3137 67.5049C43.3117 67.5066 43.3097 67.5082 43.308 67.5099C43.306 67.5115 43.3044 67.5129 43.3027 67.5146C43.294 67.5222 43.285 67.5302 43.2756 67.5386C43.2729 67.5413 43.2699 67.5439 43.2672 67.5462C43.2595 67.5532 43.2515 67.5606 43.2435 67.5683C43.2425 67.5689 43.2418 67.5699 43.2411 67.5706C43.2317 67.5793 43.2217 67.5883 43.2117 67.598C43.21 67.5997 43.2083 67.6013 43.2066 67.6026C43.2063 67.6033 43.2056 67.6036 43.2053 67.6043C43.2026 67.6066 43.2003 67.609 43.1976 67.6113C43.1899 67.6186 43.1822 67.626 43.1742 67.6337C43.1725 67.635 43.1708 67.6367 43.1691 67.6384C43.1638 67.6437 43.1581 67.649 43.1524 67.6544C43.1484 67.656 43.1444 67.658 43.1404 67.66C43.139 67.661 43.1373 67.6617 43.1357 67.6624C43.0965 67.6821 43.057 67.7048 43.0176 67.7285C43.0132 67.7311 43.0088 67.7338 43.0045 67.7364C42.8535 67.8275 42.7013 67.931 42.561 67.9393C42.555 67.9396 42.549 67.9396 42.5433 67.9396C42.539 67.9396 42.5349 67.9396 42.5309 67.9396C41.5794 67.8973 41.1581 67.2329 41.1567 66.1569C41.1567 66.1395 41.1567 66.1225 41.1567 66.1052C40.722 66.1936 40.3565 66.268 39.9914 66.342C39.7039 65.998 39.2899 65.7965 39.2531 65.1962C39.2477 65.1075 39.2444 65.0221 39.2444 64.938C39.2444 64.3694 39.3866 63.8576 39.9161 62.7551C40.2176 63.2954 40.721 63.4041 41.1989 63.567C41.2177 63.572 41.236 63.5776 41.2544 63.5833C41.2568 63.584 41.2591 63.5846 41.2615 63.5853C41.304 63.599 41.3465 63.6137 41.389 63.6287C41.5988 63.7041 41.808 63.7915 42.0216 63.7925C42.0226 63.7925 42.0236 63.7925 42.0249 63.7925C42.0256 63.7925 42.0262 63.7925 42.0272 63.7925C42.2307 63.7918 42.4379 63.7118 42.6531 63.4665C42.9908 63.2924 43.3285 63.1182 43.6564 62.9494C43.8342 63.1906 43.8994 63.4358 43.9001 63.6837C43.9014 64.0952 43.7244 64.5126 43.5885 64.927C43.5952 64.929 43.6019 64.9313 43.6086 64.9336C43.7642 64.985 43.9218 65.0217 44.0795 65.0224C44.0808 65.0224 44.0821 65.0224 44.0835 65.0224C44.0842 65.0224 44.0852 65.0224 44.0858 65.0224C44.2699 65.0221 44.4547 64.972 44.6364 64.8392C44.6377 64.8382 44.639 64.8375 44.6401 64.8365C44.6427 64.8345 44.6451 64.8329 44.6474 64.8312C44.6494 64.8299 44.6511 64.8286 44.6528 64.8272C44.6554 64.8249 44.6581 64.8229 44.6608 64.8209C44.7502 64.7518 44.8613 64.5423 44.8623 64.4495C44.8623 64.4378 44.8606 64.4281 44.8573 64.4208C44.7813 64.258 44.7388 64.1192 44.7391 64.0017C44.7394 63.7889 44.88 63.6464 45.2167 63.558C45.4239 63.5032 45.6166 63.295 45.8154 63.1562C46.4095 63.3438 46.2184 64.3808 46.8754 64.5059C47.2244 64.209 47.2569 63.7381 47.4373 63.3501C47.4396 63.3514 47.442 63.3524 47.4446 63.3534C47.4446 63.3524 47.445 63.3518 47.4453 63.3508C47.5367 63.558 47.6277 63.7652 47.7194 63.9724C47.7178 64.0001 47.7168 64.0267 47.7168 64.0524C47.7178 64.5339 48.029 64.6878 48.3637 64.8172C48.3031 64.9847 48.2432 65.1526 48.1846 65.3207C48.1793 65.3201 48.1739 65.3197 48.1689 65.319C48.1632 65.3184 48.1582 65.318 48.1528 65.3174C48.1515 65.3174 48.1505 65.3174 48.1495 65.317C48.1465 65.317 48.1435 65.3167 48.1408 65.3164C48.1351 65.3157 48.1294 65.3154 48.1237 65.3147C48.112 65.3137 48.1003 65.3124 48.0889 65.3114C48.0879 65.3114 48.0869 65.3114 48.0863 65.311C48.0618 65.309 48.0384 65.3067 48.016 65.3047C47.9169 65.296 47.8332 65.2904 47.7606 65.2904C47.7596 65.2904 47.7589 65.2904 47.7579 65.2904C47.7572 65.2904 47.7566 65.2904 47.7559 65.2904C47.3881 65.2907 47.3125 65.4385 46.9868 66.0741C46.9811 66.0825 46.9751 66.0908 46.9694 66.0988C46.9691 66.0988 46.9691 66.0988 46.9691 66.0988C46.8995 66.1912 46.8211 66.2453 46.7472 66.247C46.7458 66.247 46.7445 66.247 46.7435 66.247C46.7425 66.247 46.7418 66.247 46.7408 66.247C46.691 66.2463 46.6431 66.2213 46.6019 66.1676C46.6013 66.1666 46.6006 66.1659 46.5999 66.1649C46.5939 66.1569 46.5882 66.1479 46.5835 66.1385C46.5825 66.1372 46.5819 66.1355 46.5809 66.1339C46.5802 66.1325 46.5795 66.1312 46.5789 66.1295C46.5032 65.971 46.5528 65.6574 46.3697 65.656C46.3694 65.656 46.369 65.656 46.3687 65.656C46.3627 65.656 46.3559 65.6564 46.3496 65.6574C46.2903 65.6637 46.2097 65.6987 46.0986 65.7748C46.0962 65.7765 46.0936 65.7782 46.0912 65.7798C46.0885 65.7818 46.0859 65.7835 46.0832 65.7855C45.283 66.3457 44.4567 66.8215 43.9757 67.8505C43.8847 68.0457 43.6092 68.1432 43.4185 68.2856ZM43.3984 66.2987C43.4048 66.2987 43.4108 66.2987 43.4175 66.2984C43.4955 66.2937 43.5949 66.263 43.6702 66.2226C43.6718 66.2216 43.6735 66.2206 43.6752 66.2199C43.6835 66.2152 43.6916 66.2106 43.6993 66.2056C43.7046 66.2022 43.7097 66.1989 43.7147 66.1956C43.8071 66.1308 43.9232 65.9353 43.9225 65.8332C43.9222 65.8245 43.9215 65.8165 43.9195 65.8095C43.8415 65.5015 43.7023 65.2216 43.5862 64.9313C43.5865 64.931 43.5868 64.931 43.5872 64.931L43.5835 64.925C43.5845 64.927 43.5852 64.929 43.5862 64.9313C43.2592 64.9891 43.0319 65.1959 43.0313 65.5583C43.0313 65.5793 43.0319 65.6007 43.0336 65.6227C43.0497 65.8586 43.1692 66.0972 43.3037 66.2677C43.304 66.268 43.3044 66.2683 43.3047 66.2687C43.306 66.2703 43.3074 66.272 43.3091 66.2737C43.3271 66.291 43.3586 66.2987 43.3964 66.2987C43.3971 66.2987 43.3977 66.2987 43.3984 66.2987Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M48.364 64.8171C48.0293 64.6877 47.718 64.5338 47.717 64.0523C47.717 64.0267 47.718 64 47.7197 63.9723C48.208 63.6503 48.4011 63.5075 48.4008 63.2265C48.4004 63.0524 48.3258 62.8248 48.201 62.4681C48.1237 62.0881 48.0674 61.697 47.9633 61.3303C47.9215 61.1835 47.9035 61.0384 47.9038 60.8935C47.9045 60.644 47.9597 60.3954 48.0434 60.1418C48.4389 60.34 48.8295 60.5502 49.2341 60.7277C49.2365 60.7287 49.2391 60.7297 49.2415 60.7307C49.2432 60.7314 49.2448 60.7321 49.2465 60.7327C49.2478 60.7331 49.2492 60.7337 49.2505 60.7341C49.3024 60.7531 49.3737 60.7638 49.4396 60.7648C49.442 60.7648 49.4446 60.7648 49.447 60.7648C49.448 60.7648 49.4493 60.7648 49.4507 60.7648C49.5303 60.7641 49.6006 60.7487 49.6187 60.7154C49.7211 60.5215 49.8466 60.2659 49.8469 60.0721C49.8469 60.0464 49.8449 60.0217 49.8402 59.9983C49.7586 59.5983 49.5618 59.2436 49.4129 58.8702C49.9637 58.9913 50.5129 59.1221 51.0672 59.2302C51.3429 59.2843 51.4591 59.3604 51.4591 59.5906C51.4591 59.6657 51.4467 59.7574 51.4232 59.8699C51.3717 60.1191 51.274 60.3614 51.197 60.6066L51.1873 60.6163C50.8904 60.6787 50.6799 60.8525 50.6799 61.1748C50.6799 61.2126 50.6829 61.2526 50.689 61.295C50.7198 61.5118 50.9259 61.7067 50.9252 61.8985C50.9252 61.9116 50.9242 61.9243 50.9222 61.9369C50.864 62.312 50.525 62.3827 50.2492 62.5005C49.9788 62.6163 49.7191 62.7784 49.4543 62.9199C48.9533 63.2422 48.7609 63.3804 48.7602 63.664C48.7602 63.8311 48.8268 64.049 48.9363 64.385L48.9754 64.4544C48.7716 64.5752 48.5678 64.696 48.364 64.8171Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M42.025 63.7925C42.0237 63.7925 42.0227 63.7925 42.0217 63.7925C41.8081 63.7915 41.599 63.7041 41.3891 63.6287C41.3466 63.6137 41.3041 63.599 41.2616 63.5853C41.2592 63.5846 41.2569 63.584 41.2546 63.5833C41.2362 63.5776 41.2178 63.5719 41.199 63.5669C41.1615 62.7771 40.9222 62.1121 40.448 61.5916C40.5611 61.251 40.6746 60.91 40.7877 60.5693C40.9216 60.7565 41.0655 60.9353 41.1873 61.1332C41.191 61.1389 41.1947 61.1449 41.198 61.1509C41.199 61.1529 41.2003 61.1545 41.2014 61.1565C41.3523 61.4198 41.4202 61.8415 41.7144 61.8432C41.7151 61.8432 41.7158 61.8432 41.7164 61.8432C41.7168 61.8432 41.7171 61.8432 41.7178 61.8432C41.7687 61.8429 41.8262 61.8302 41.8921 61.8022C41.8935 61.8015 41.8945 61.8012 41.8958 61.8005C41.8985 61.7992 41.9015 61.7982 41.9042 61.7968C42.0427 61.7348 42.0548 61.1899 42.1425 60.8709C42.1438 60.8659 42.1451 60.8609 42.1465 60.8559C42.1468 60.8546 42.1472 60.8529 42.1478 60.8516C42.2104 60.6297 42.3065 60.4252 42.5873 60.4242C42.5879 60.4238 42.5886 60.4238 42.5896 60.4238C42.5896 60.4238 42.5896 60.4238 42.5899 60.4238C42.602 60.4238 42.6144 60.4245 42.6271 60.4251C42.6673 61.0748 42.7904 61.7161 42.7901 62.3804C42.7901 62.7345 42.7549 63.0948 42.6532 63.4665C42.438 63.7117 42.2305 63.7918 42.0274 63.7925C42.0264 63.7925 42.0257 63.7925 42.025 63.7925Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M45.9168 59.407C45.7428 59.2859 45.6531 59.11 45.6538 58.8768C45.6538 58.8411 45.6561 58.8041 45.6605 58.7654C45.5383 58.4747 45.4007 58.1928 45.297 57.8912C45.2495 57.7527 45.2271 57.6195 45.2271 57.4954C45.2271 57.0416 45.5306 56.704 46.0377 56.6386C46.4831 56.5815 46.9286 56.5225 47.3737 56.4644L47.3777 56.4747C47.1528 57.1581 46.9272 57.8414 46.7017 58.5248C46.2502 58.5892 46.0658 58.9762 45.9168 59.407Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M45.1815 61.5916C45.1707 61.5916 45.1594 61.5906 45.148 61.5889C45.0466 61.5736 44.9174 61.4961 44.9067 61.4284C44.8956 61.361 44.8903 61.2946 44.8906 61.2292C44.8913 60.8528 45.0653 60.5085 45.302 60.2205C45.3056 60.2162 45.3093 60.2119 45.313 60.2075C45.3143 60.2059 45.3157 60.2045 45.3167 60.2032C45.3173 60.2025 45.318 60.2018 45.3187 60.2012C45.32 60.1992 45.3217 60.1975 45.323 60.1959C45.4492 60.0554 45.5898 60.0133 45.734 60.0127C45.7354 60.0127 45.7364 60.0127 45.7377 60.0127C45.7387 60.0127 45.7397 60.0127 45.7411 60.0127C45.8622 60.013 45.986 60.042 46.1069 60.0657C46.1089 60.0661 46.1109 60.0664 46.1129 60.0667C46.1226 60.0687 46.1326 60.0707 46.1427 60.0724C46.1484 60.0734 46.154 60.0747 46.1601 60.0757L46.1604 60.0774C45.9586 60.6643 45.8314 61.3173 45.2297 61.5826C45.2163 61.5886 45.2002 61.5912 45.1825 61.5916C45.1821 61.5916 45.1818 61.5916 45.1815 61.5916Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M47.7197 63.9727C47.628 63.7655 47.5369 63.5582 47.4456 63.351C47.5513 63.009 47.6571 62.6674 47.7628 62.3253C47.9087 62.3731 48.055 62.4208 48.2009 62.4685C48.3258 62.8252 48.4004 63.0527 48.4007 63.2269C48.4011 63.5078 48.208 63.6507 47.7197 63.9727Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M47.445 63.3533C47.4423 63.3523 47.44 63.3512 47.4376 63.3499C47.3054 63.2925 47.1552 63.2615 47.0478 63.1681C46.9557 63.088 46.9099 62.9936 46.9092 62.9002C46.9085 62.7837 46.9785 62.6682 47.117 62.5838C47.3185 62.461 47.5464 62.4083 47.7629 62.3249C47.6572 62.6669 47.5514 63.0086 47.4457 63.3506C47.4453 63.3516 47.445 63.3523 47.445 63.3533Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M42.0463 59.0046C42.046 59.0046 42.0453 59.0046 42.045 59.0046C41.9868 59.003 41.9624 58.9099 41.9199 58.7083C41.9195 58.7057 41.9188 58.703 41.9182 58.7C41.9161 58.691 41.9145 58.6816 41.9125 58.672C41.9111 58.6656 41.9098 58.6593 41.9084 58.653C42.051 58.6973 42.194 58.7417 42.3369 58.7857C42.3345 58.7881 42.3322 58.7901 42.3302 58.7921C42.3248 58.7968 42.3198 58.8018 42.3148 58.8061C42.3061 58.8144 42.2973 58.8224 42.289 58.8301C42.282 58.8365 42.2753 58.8428 42.2686 58.8488C42.2636 58.8532 42.2589 58.8575 42.2545 58.8618C42.1605 58.9472 42.1002 58.9963 42.0574 59.0036C42.0537 59.0043 42.05 59.0046 42.0463 59.0046Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M44.6389 58.9937C44.8394 58.8709 45.0402 58.7481 45.241 58.6253C45.0402 58.7481 44.8394 58.8709 44.6389 58.9937Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M46.1605 60.0771L46.1602 60.0755C46.2174 59.9033 46.274 59.7312 46.3309 59.559C46.4748 59.6054 46.6187 59.6517 46.7622 59.6985C46.5618 59.8249 46.361 59.951 46.1605 60.0771Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M48.6104 53.6306C48.5739 53.5889 48.5013 53.5382 48.501 53.5055C48.501 53.5035 48.5013 53.5018 48.502 53.5001C48.5639 53.2756 48.6392 53.053 48.7255 52.8365C48.7336 52.8165 48.7918 52.7978 48.836 52.7938C48.8417 52.7934 48.847 52.7931 48.8521 52.7931C48.8524 52.7931 48.8531 52.7931 48.8534 52.7931C48.8685 52.7935 48.8798 52.7958 48.8842 52.8015C48.8845 52.8018 48.8848 52.8025 48.8848 52.8028C48.9314 52.8822 48.9501 52.9626 48.9498 53.0427C48.9491 53.1955 48.8782 53.3477 48.7938 53.4931C48.757 53.5562 48.6727 53.5856 48.6104 53.6306Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M47.2498 58.6143C47.2491 58.6143 47.2484 58.6143 47.2474 58.6143C47.0774 58.6139 46.907 58.5886 46.736 58.5359C46.7246 58.5322 46.7133 58.5285 46.7019 58.5248C46.9275 57.8415 47.153 57.1581 47.3779 56.4748C47.7307 57.0594 48.4442 57.3283 48.4529 58.2222C48.4486 58.2249 48.4439 58.2279 48.4395 58.2305C48.0406 58.4771 47.6477 58.6133 47.2544 58.6143C47.2528 58.6143 47.2511 58.6143 47.2498 58.6143Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M53.8452 59.7791C54.6043 59.0176 55.0481 57.9876 55.6187 57.0633C56.0501 57.2976 56.2 57.6406 56.2007 58.0446C56.201 58.2789 56.1515 58.5338 56.0775 58.7997C55.6173 59.098 55.1692 59.4404 54.6919 59.6779C54.4359 59.8051 54.129 59.7514 53.8452 59.7791Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M54.6311 56.0344C54.8443 55.4862 54.8855 54.7932 55.5642 54.6367C55.3463 55.1809 55.3242 55.8906 54.6311 56.0344Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M53.0626 54.6289C53.0619 54.6289 53.0616 54.6289 53.0612 54.6289C52.9658 54.6279 52.914 54.5155 52.9401 54.3516C52.9407 54.347 52.9418 54.3423 52.9424 54.3376C52.9555 54.2662 53.0157 54.1825 53.072 54.1364C53.0746 54.1341 53.0773 54.1321 53.08 54.1301C53.081 54.1291 53.082 54.1284 53.083 54.1278C53.0837 54.1271 53.0843 54.1264 53.085 54.1261C53.2105 54.0286 53.3347 53.996 53.4578 53.9956C53.4588 53.9956 53.4598 53.9956 53.4609 53.9956C53.4619 53.9956 53.4628 53.9956 53.4642 53.9956C53.5843 53.996 53.7038 54.0267 53.823 54.057C53.8327 54.0594 53.8424 54.062 53.8521 54.0643C53.8571 54.0657 53.8618 54.0667 53.8668 54.068C53.6305 54.2485 53.4033 54.4547 53.1546 54.5999C53.1218 54.6192 53.0917 54.6282 53.0649 54.6289C53.0643 54.6289 53.0632 54.6289 53.0626 54.6289ZM53.8678 54.0684C53.8675 54.0684 53.8671 54.068 53.8668 54.068C53.8671 54.0677 53.8675 54.0673 53.8678 54.0673V54.0684Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M40.8319 70.2991C40.6903 70.252 40.5484 70.2053 40.4069 70.1582C40.4069 70.1579 40.4072 70.1572 40.4072 70.1569C40.4072 70.1566 40.4069 70.1566 40.4069 70.1563C40.5561 69.7809 40.6649 69.4232 40.6645 69.0902C40.6642 68.7355 40.5404 68.4089 40.21 68.1196C40.2057 68.1159 40.2013 68.1119 40.197 68.1082C40.1883 68.1005 40.1796 68.0932 40.1706 68.0855C39.9436 67.8937 39.7298 67.7749 39.4543 67.7742C39.4537 67.7742 39.4527 67.7742 39.452 67.7742C39.4517 67.7742 39.451 67.7742 39.4507 67.7742C39.3928 67.7742 39.3325 67.7796 39.2689 67.7902C39.2669 67.7906 39.2653 67.7909 39.2636 67.7912C39.2579 67.7922 39.2522 67.7932 39.2465 67.7942C39.1692 67.8089 39.0915 67.8142 39.0132 67.8142C39.0129 67.8142 39.0122 67.8142 39.0116 67.8142C39.0072 67.8142 39.0029 67.8142 38.9985 67.8142C38.8657 67.8132 38.7321 67.7972 38.5986 67.7832C38.528 67.7759 38.4573 67.7692 38.3867 67.7659C38.2298 67.4236 38.131 66.8306 37.9044 66.7886C37.367 66.6895 37.1283 66.0849 36.6025 66.0398C36.6039 66.0362 36.6052 66.0328 36.6066 66.0295C36.6072 66.0278 36.6079 66.0258 36.6086 66.0242C36.6093 66.0225 36.6099 66.0211 36.6103 66.0195C36.6116 66.0161 36.6129 66.0128 36.6143 66.0095C36.6146 66.0081 36.6153 66.0065 36.6159 66.0051C36.6169 66.0021 36.6183 65.9988 36.6193 65.9958C36.7321 65.6961 36.8198 65.3608 37.0979 65.3595C37.0986 65.3595 37.0992 65.3595 37.0996 65.3595C37.0999 65.3595 37.1002 65.3595 37.1009 65.3595C37.1725 65.3598 37.2565 65.3818 37.3569 65.4326C37.3599 65.4339 37.3629 65.4356 37.366 65.4369C37.3676 65.4376 37.3693 65.4386 37.371 65.4392C37.4516 65.4773 37.5329 65.4946 37.6119 65.4946C37.6123 65.4946 37.6126 65.4946 37.6133 65.4946C37.6136 65.4946 37.6143 65.4946 37.6149 65.4946C37.9269 65.4936 38.2013 65.2307 38.2488 64.9648C38.2498 64.9608 38.2505 64.9567 38.2508 64.9531C38.2518 64.9471 38.2528 64.9407 38.2535 64.9347C38.3854 63.7782 39.2545 62.9464 39.4122 61.8303C39.4158 61.8313 39.4195 61.8323 39.4232 61.8333C39.4306 61.835 39.4376 61.837 39.445 61.839C39.447 61.8393 39.449 61.84 39.451 61.8403C39.4557 61.8416 39.4607 61.843 39.4657 61.8443C39.4671 61.8447 39.4687 61.845 39.4701 61.8453C39.4724 61.846 39.4748 61.8467 39.4768 61.847C39.6026 61.879 39.7281 61.9054 39.8513 61.9061C39.8526 61.9061 39.8536 61.9061 39.855 61.9061C39.8563 61.9061 39.858 61.9061 39.8596 61.9061C40.0517 61.9051 40.2392 61.8393 40.4162 61.6308C40.4169 61.6298 40.4176 61.6291 40.4182 61.6284C40.4229 61.6228 40.4273 61.6174 40.432 61.6118C40.4343 61.6091 40.4363 61.6064 40.4383 61.6037C40.4416 61.5997 40.445 61.5954 40.448 61.5914C40.9222 62.1119 41.1615 62.7769 41.199 63.5667C40.7211 63.4039 40.2178 63.2951 39.9162 62.7549C39.3867 63.8573 39.2445 64.3692 39.2445 64.9377C39.2445 65.0218 39.2478 65.1072 39.2532 65.196C39.29 65.7963 39.704 65.9978 39.9915 66.3418C40.3566 66.2677 40.7221 66.1933 41.1568 66.1049C41.1568 66.1222 41.1568 66.1393 41.1568 66.1566C41.1582 67.2327 41.5796 67.897 42.531 67.9394C42.5351 67.9394 42.5391 67.9394 42.5434 67.9394C42.5491 67.9394 42.5551 67.9394 42.5611 67.939C42.7014 67.9307 42.8537 67.8273 43.0046 67.7362C43.0089 67.7335 43.0133 67.7309 43.0177 67.7282C43.0572 67.7045 43.0966 67.6818 43.1358 67.6621C43.1375 67.6614 43.1392 67.6608 43.1405 67.6598C43.1445 67.6578 43.1485 67.6558 43.1525 67.6541C43.2921 67.6938 43.4307 67.7379 43.5672 67.7866C43.516 67.9527 43.4668 68.1189 43.4186 68.2854C42.531 68.9077 41.5946 69.4355 40.8319 70.2991Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M38.2579 62.4563C38.2572 62.4563 38.2563 62.4563 38.2553 62.4563C38.1452 62.4563 38.0076 62.4396 37.8259 62.4166C37.8259 62.4166 37.8255 62.4166 37.8252 62.4166C37.8165 62.4153 37.8075 62.4143 37.7981 62.4133C37.853 62.2434 37.9119 62.0749 37.9748 61.9078C37.9748 61.9081 37.9748 61.9081 37.9748 61.9081C38.3172 61.835 38.6592 61.7613 39.0019 61.6882C38.9996 61.6926 38.9972 61.6972 38.9949 61.7015C38.9946 61.7019 38.9942 61.7022 38.9942 61.7026C38.9899 61.7112 38.9855 61.7192 38.9812 61.7276C38.9805 61.7289 38.9798 61.7303 38.9792 61.7313C38.9742 61.7409 38.9691 61.7503 38.9641 61.7596C38.6726 62.3115 38.5832 62.456 38.2593 62.4563C38.2589 62.4563 38.2586 62.4563 38.2579 62.4563Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M37.9744 61.908C37.9744 61.908 37.9744 61.908 37.9744 61.9076V61.908ZM37.9744 61.9076C37.9343 61.8045 37.8943 61.7008 37.8542 61.5973C37.8933 61.6247 37.9547 61.6407 37.9664 61.6817C37.975 61.7108 37.9774 61.7431 37.9774 61.7768C37.9774 61.8162 37.9744 61.8576 37.974 61.8973C37.974 61.9009 37.974 61.9043 37.9744 61.9076Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M39.8863 77.3958C39.7347 77.3524 39.5828 77.3087 39.4315 77.2653C39.3214 77.0771 39.2428 76.7541 39.0955 76.7274C39.0912 76.7264 39.0868 76.7258 39.0821 76.7248C39.0788 76.7244 39.0751 76.7237 39.0714 76.7231C39.0657 76.7221 39.06 76.7214 39.0547 76.7204C38.9864 76.7108 38.9171 76.7068 38.8465 76.7068C38.8459 76.7068 38.8448 76.7068 38.8442 76.7068C38.8428 76.7068 38.8415 76.7068 38.8402 76.7068C38.7334 76.7068 38.6246 76.7157 38.5155 76.7254C38.5011 76.7268 38.4868 76.7281 38.4727 76.7294C38.4355 76.7328 38.3984 76.7361 38.3612 76.7391C38.2746 76.7465 38.1882 76.7521 38.1028 76.7521C38.1015 76.7521 38.1002 76.7521 38.0988 76.7521C38.0982 76.7521 38.0975 76.7521 38.0968 76.7521C38.0654 76.7521 38.0339 76.7515 38.0028 76.7498C37.8224 76.7398 37.6454 76.6137 37.645 76.4108C37.645 76.3664 37.6534 76.3184 37.6718 76.2673C37.9211 75.5836 37.8485 74.9053 37.9278 74.2259C37.7762 73.9717 37.712 73.7522 37.7126 73.5606C37.7133 73.0515 38.1691 72.7391 38.6444 72.4909C39.1665 72.2183 38.9737 71.7835 39.0537 71.4028C39.5028 71.3444 39.6584 70.946 39.8013 70.5326C39.9446 70.579 40.0885 70.6254 40.2321 70.6721C40.2321 70.6754 40.2321 70.6791 40.2321 70.6828C40.2321 70.7211 40.2291 70.7612 40.2291 70.7996C40.2291 70.8343 40.2314 70.868 40.2404 70.898C40.2522 70.939 40.3138 70.955 40.3526 70.9824C40.3134 70.8783 40.2739 70.7745 40.2344 70.6704C40.2923 70.4999 40.3496 70.3294 40.4068 70.1582C40.5484 70.2053 40.6902 70.252 40.8318 70.2991C40.9844 70.4809 41.0397 70.6691 41.04 70.8603C41.041 71.2256 40.8425 71.6037 40.7411 71.9754C40.7378 71.975 40.7341 71.975 40.7308 71.9747C40.6126 71.9684 40.5132 71.963 40.4292 71.961C40.4255 71.9607 40.4219 71.9607 40.4182 71.9607C40.3941 71.96 40.3716 71.9597 40.3502 71.9597C40.3492 71.9597 40.3485 71.9597 40.3479 71.9597C40.3472 71.9597 40.3469 71.9597 40.3465 71.9597C39.9861 71.96 39.9851 72.0481 40.0149 72.4475C40.0152 72.4545 40.0159 72.4612 40.0162 72.4682C40.0339 72.7051 40.0473 72.8813 40.0473 73.0171C40.048 73.4081 39.9406 73.4669 39.5219 73.6851C39.3087 73.7962 39.0708 73.8486 38.8787 73.9961C38.7936 74.0615 38.7766 74.2964 38.7645 74.4535C38.7642 74.4555 38.7642 74.4579 38.7642 74.4599C38.7642 74.5269 38.8405 74.6377 38.892 74.6397C38.9432 74.6417 38.9945 74.6427 39.046 74.6427C39.0467 74.6427 39.0473 74.6427 39.0483 74.6427C39.0503 74.6427 39.0524 74.6427 39.0544 74.6427C39.0985 74.6427 39.143 74.642 39.1872 74.641C39.1906 74.641 39.1936 74.641 39.1969 74.6407C39.2143 74.6404 39.2321 74.64 39.2495 74.6397C39.2813 74.6387 39.3131 74.6377 39.3448 74.637C39.3964 74.6354 39.4476 74.634 39.4991 74.6327C39.545 74.632 39.5908 74.6314 39.6367 74.6314C39.6377 74.6314 39.639 74.631 39.6404 74.631C39.6424 74.631 39.6441 74.631 39.6461 74.6314C39.7555 74.6314 39.8639 74.635 39.9714 74.6464C39.9861 74.648 40.0011 74.6497 40.0159 74.6514C40.5922 74.7241 40.8851 74.9927 40.8837 75.4041C40.8834 75.6467 40.7803 75.939 40.5731 76.27C40.3402 76.6424 40.1149 77.0204 39.8863 77.3958Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M39.0538 71.4028C39.0504 71.3952 39.0471 71.3878 39.044 71.3805C39.043 71.3781 39.0417 71.3755 39.0407 71.3731C39.0404 71.3721 39.0397 71.3708 39.0394 71.3698C38.8958 71.0448 38.8262 70.8963 38.696 70.894C38.6947 70.894 38.6936 70.894 38.6926 70.894C38.6876 70.894 38.6826 70.894 38.6776 70.8946C38.5835 70.902 38.4577 70.9787 38.2556 71.1142C38.2542 71.1152 38.2532 71.1159 38.2519 71.1165C38.2505 71.1175 38.2492 71.1185 38.2478 71.1192C38.2418 71.1236 38.2358 71.1276 38.2298 71.1316C38.215 71.1412 38.2003 71.1516 38.1853 71.1616C38.1826 71.1632 38.1803 71.1649 38.1776 71.1666C38.0832 71.2297 38.0082 71.2627 37.949 71.2647C37.947 71.265 37.945 71.265 37.9433 71.265C37.942 71.265 37.9409 71.265 37.9396 71.265C37.8422 71.2627 37.7883 71.1723 37.7585 70.9887C37.7629 70.9287 37.7642 70.8666 37.7642 70.8036C37.7646 70.7131 37.7619 70.6207 37.7616 70.5303C37.7616 70.3328 37.774 70.1436 37.8543 70.0001C37.9952 69.7492 38.0179 69.5156 38.0179 69.285C38.0179 69.1723 38.0126 69.0605 38.0126 68.9477C38.0126 68.884 38.0143 68.8203 38.0196 68.7559C38.0825 68.6034 38.1461 68.4509 38.2104 68.2991C38.5628 68.6221 38.7994 69.1196 39.3024 69.216L39.3028 69.2156V69.216C39.2452 69.3872 39.1876 69.5586 39.1301 69.7298C39.2716 69.7775 39.4135 69.8249 39.5551 69.8723C39.6371 70.0925 39.7194 70.3124 39.8014 70.5326C39.6585 70.946 39.5029 71.3444 39.0538 71.4028ZM38.8493 69.9047C38.9427 69.8463 39.0364 69.7882 39.1301 69.7298C39.0675 69.7395 39.0009 69.7358 38.9433 69.7615C38.9406 69.7629 38.9376 69.7642 38.935 69.7655C38.8981 69.7842 38.8774 69.8566 38.8493 69.9047Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M42.2122 84.49C42.0401 84.3609 41.9538 84.1784 41.9531 83.9431C41.9531 83.9068 41.9548 83.8697 41.9588 83.831C41.9595 83.8313 41.9598 83.832 41.9605 83.8323C42.1325 83.9608 42.2175 84.1433 42.2179 84.3779C42.2179 84.4142 42.2162 84.4513 42.2122 84.49Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M46.2701 73.8345C46.1181 73.66 46.0602 73.4534 46.0596 73.2215C46.0596 73.1161 46.071 73.0056 46.0911 72.8902C46.1085 72.7911 46.1168 72.6993 46.1171 72.6142C46.1181 72.0587 45.7724 71.7871 45.3203 71.5826C45.1365 71.7384 44.9511 71.9092 44.755 72.058C44.6238 72.1578 44.4799 72.2382 44.3367 72.3069C44.3323 72.3089 44.328 72.3109 44.3236 72.3129C44.2714 72.3356 44.2185 72.3463 44.1663 72.3463C44.166 72.3463 44.1653 72.3463 44.165 72.3463C44.1629 72.3463 44.1613 72.3463 44.1593 72.3463C43.9247 72.343 43.7118 72.1311 43.7122 71.8845C43.7122 71.8785 43.7122 71.8725 43.7125 71.8665C43.7125 71.8645 43.7128 71.8625 43.7128 71.8605C43.7463 71.2876 44.0883 70.7053 44.0877 70.1261C44.0873 69.8722 44.0211 69.6189 43.834 69.367C43.833 69.3657 43.832 69.3643 43.8313 69.363C43.8293 69.3603 43.8276 69.3577 43.8263 69.355C43.8256 69.3537 43.8249 69.3527 43.8243 69.3517C43.7115 69.1355 44.2433 68.5452 44.6666 68.4938C44.6864 68.4915 44.7055 68.4901 44.7246 68.4901C44.7246 68.4901 44.7246 68.4901 44.7249 68.4901C44.7366 68.4901 44.7483 68.4908 44.76 68.4918C44.7895 68.4942 44.8166 68.4955 44.8424 68.4955C44.8427 68.4955 44.843 68.4955 44.8434 68.4955C44.8444 68.4955 44.8454 68.4955 44.8464 68.4955C45.0719 68.4948 45.1683 68.3957 45.2416 68.1555C45.2437 68.1485 45.246 68.1411 45.248 68.1338C45.3176 67.8932 45.3829 67.6516 45.4448 67.4277C45.497 67.4197 45.5415 67.4094 45.5807 67.4014C45.6001 67.3974 45.6185 67.3941 45.6355 67.3914C45.6399 67.3907 45.6442 67.3901 45.6486 67.3897C45.6549 67.3891 45.661 67.3884 45.6673 67.3881C45.6734 67.3874 45.6794 67.3874 45.6854 67.3874C45.6858 67.3874 45.6861 67.3874 45.6868 67.3874C45.6951 67.3874 45.7031 67.3877 45.7112 67.3887C45.7132 67.389 45.7149 67.3894 45.7165 67.3897C45.8628 67.4117 46.0047 67.4548 46.1479 67.4908C46.1513 67.4915 46.1546 67.4925 46.158 67.4931C46.16 67.4938 46.1617 67.4942 46.1637 67.4948C46.1677 67.4958 46.1714 67.4965 46.1754 67.4975C46.176 67.4978 46.1767 67.4978 46.1774 67.4978C46.2698 67.5199 46.3621 67.5359 46.4525 67.5362C46.4532 67.5362 46.4542 67.5362 46.4549 67.5362C46.4562 67.5362 46.4579 67.5362 46.4592 67.5362C46.6443 67.5352 46.8206 67.4668 46.9746 67.2459C47.1202 67.037 47.1891 66.8352 47.1894 66.641C47.1898 66.4438 47.1198 66.2546 46.987 66.0741C47.3126 65.4385 47.3883 65.2906 47.7561 65.2903C47.7567 65.2903 47.7574 65.2903 47.7581 65.2903C47.7591 65.2903 47.7597 65.2903 47.7607 65.2903C47.8334 65.2903 47.917 65.296 48.0161 65.3046C48.0385 65.3066 48.062 65.309 48.0864 65.311C48.0871 65.3113 48.088 65.3113 48.0891 65.3113C48.1004 65.3123 48.1121 65.3136 48.1239 65.3146C48.1295 65.3153 48.1353 65.3157 48.141 65.3163C48.1436 65.3167 48.1466 65.317 48.1496 65.317C48.1507 65.3173 48.1516 65.3173 48.153 65.3173C48.1583 65.318 48.1634 65.3183 48.1691 65.319C48.1741 65.3196 48.1794 65.32 48.1848 65.3207C48.1844 65.3327 48.1845 65.345 48.1845 65.357C48.1838 66.1228 48.5067 66.5916 49.1232 66.7921C48.241 67.4278 47.5867 68.3407 46.9729 69.2809C46.7259 69.6593 46.5258 70.0607 46.5254 70.4711C46.5251 70.7093 46.5924 70.9506 46.757 71.1922C46.8591 71.342 46.8909 71.5085 46.8913 71.6827C46.8913 71.9653 46.8079 72.2676 46.8076 72.5515C46.8076 72.6012 46.8103 72.6503 46.816 72.6987C46.821 72.7374 46.8233 72.7747 46.8233 72.8108C46.823 73.2592 46.4672 73.4998 46.2701 73.8341V73.8345ZM45.0572 70.3894C45.0753 70.3894 45.0951 70.386 45.1161 70.3797C45.1171 70.3794 45.1185 70.379 45.1195 70.3787C45.1228 70.3774 45.1265 70.3763 45.1298 70.375C45.1335 70.3737 45.1376 70.3723 45.1412 70.3707C45.1506 70.367 45.1603 70.3627 45.17 70.358C45.1733 70.3563 45.1767 70.3543 45.18 70.3527C45.1804 70.3527 45.1804 70.3527 45.1807 70.3527C45.1841 70.3507 45.1878 70.3487 45.1914 70.3467C45.1921 70.3463 45.1931 70.3457 45.1938 70.3453C45.1981 70.343 45.2025 70.3403 45.2068 70.3376C45.2092 70.3363 45.2115 70.335 45.2142 70.3333C45.2155 70.3326 45.2169 70.3317 45.2182 70.331C45.2182 70.3307 45.2185 70.3306 45.2185 70.3306C45.2219 70.3286 45.2252 70.3266 45.2282 70.3243C45.2303 70.3233 45.2323 70.322 45.2339 70.3206C45.2343 70.3206 45.2346 70.3203 45.2346 70.3203H45.2349C45.238 70.3183 45.2413 70.316 45.2443 70.314C45.2456 70.3129 45.2466 70.3123 45.248 70.3113C45.248 70.3113 45.248 70.3113 45.2483 70.3113C45.2483 70.3109 45.2487 70.311 45.249 70.3106C45.253 70.3076 45.2574 70.3046 45.2617 70.3016C45.2641 70.2999 45.2661 70.2986 45.2681 70.2969C45.2684 70.2969 45.2684 70.2966 45.2687 70.2966C45.2691 70.2963 45.2691 70.2963 45.2694 70.2959C45.2734 70.2933 45.2774 70.2903 45.2815 70.2869C45.2825 70.2863 45.2835 70.2856 45.2845 70.2846C45.2898 70.2806 45.2952 70.2766 45.3005 70.2722L45.3009 70.2719C45.3079 70.2662 45.3152 70.2606 45.3223 70.2546C45.3293 70.2486 45.3367 70.2426 45.344 70.2359C45.3444 70.2359 45.3444 70.2359 45.3444 70.2359C45.3474 70.2332 45.3507 70.2305 45.3537 70.2275C45.3591 70.2229 45.3644 70.2182 45.3698 70.2135C45.3902 70.1948 45.4113 70.1748 45.4324 70.1538C45.4709 70.1154 45.5111 70.073 45.5526 70.026C45.5542 70.0243 45.5559 70.0223 45.5572 70.0203C45.5592 70.0183 45.5612 70.0163 45.5629 70.014C45.5633 70.014 45.5632 70.0137 45.5636 70.0133C45.6817 69.8785 45.8103 69.7097 45.9448 69.5105C45.9471 69.5071 45.9495 69.5035 45.9521 69.4998C45.9642 69.4815 45.9766 69.4631 45.9893 69.4441C45.992 69.4398 45.9953 69.4351 45.998 69.4304C46.006 69.4184 46.014 69.406 46.0224 69.3937C46.0238 69.391 46.0254 69.3884 46.0271 69.386C46.0449 69.359 46.0623 69.3313 46.08 69.3033C46.1259 69.2305 46.2129 69.1711 46.2293 69.0974C46.2494 69.005 46.2611 68.9179 46.2611 68.8375C46.2617 68.5959 46.1586 68.4164 45.8742 68.3487C45.748 68.5552 45.5894 68.7598 45.4879 68.9923C45.33 69.3527 44.8738 69.5873 44.8742 70.0127C44.8742 70.1008 44.8939 70.1975 44.9401 70.305C44.9407 70.3063 44.9414 70.308 44.9421 70.3093C44.9424 70.31 44.9424 70.3103 44.9428 70.311C44.9672 70.3637 45.006 70.389 45.0562 70.3894C45.0566 70.3894 45.0569 70.3894 45.0572 70.3894Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M49.058 72.1799C49.0573 72.1799 49.0564 72.1799 49.0557 72.1799C48.9459 72.1793 48.8308 72.1432 48.7103 72.0638C48.5322 71.9464 48.3231 71.8857 48.1189 71.7956C48.0617 71.6644 48.0376 71.5346 48.0376 71.4082C48.0379 71.0215 48.2672 70.6684 48.4824 70.4172C49.0677 69.7335 49.3425 68.9274 49.6193 68.0982C49.7337 67.9974 49.9245 67.909 49.9496 67.7936C50.0199 67.4669 49.9821 67.1209 50.0611 66.7973C50.0821 66.7112 50.0915 66.6371 50.0915 66.572C50.0908 66.176 49.7311 66.1319 49.4523 65.9147C49.6166 65.3685 49.7886 64.7959 49.9607 64.223L50.0185 64.1993C50.2388 64.3872 50.4342 64.7028 50.6846 64.7352C51.1478 64.7956 51.2565 65.1253 51.3382 65.548C51.3723 65.7255 51.3147 66.0011 51.5413 66.0031C51.5423 66.0031 51.5433 66.0031 51.544 66.0031C51.5447 66.0031 51.545 66.0031 51.5453 66.0031C51.5698 66.0031 51.5979 65.9998 51.6293 65.9931C51.7277 65.8486 51.8225 65.7075 51.9192 65.5677C51.9215 65.5644 51.9239 65.5607 51.9262 65.5574C51.9265 65.557 51.9269 65.5564 51.9272 65.556C51.9279 65.555 51.9285 65.554 51.9292 65.553C52.0316 65.4072 52.1314 65.2964 52.2565 65.2958C52.2572 65.2958 52.2575 65.2958 52.2582 65.2958C52.2592 65.2958 52.2606 65.2958 52.2619 65.2958C52.3195 65.2968 52.382 65.3208 52.453 65.3749C52.4567 65.3779 52.4604 65.3805 52.464 65.3835C52.4657 65.3852 52.4677 65.3865 52.4694 65.3882C52.6963 65.5737 52.963 65.6982 53.2124 65.8493L53.2167 65.8833C53.0611 66.2964 52.8834 66.6825 52.4426 66.7462C52.4426 66.7439 52.4426 66.7416 52.4426 66.7389C52.4426 66.6978 52.4463 66.6555 52.4463 66.6144C52.4463 66.5807 52.4439 66.5484 52.4356 66.519C52.4232 66.4776 52.3619 66.4613 52.3225 66.4339C52.3619 66.5383 52.4018 66.6424 52.4413 66.7469C52.1397 67.0011 51.8583 67.3158 51.5326 67.4976C50.8024 67.9047 50.3355 68.5213 50.126 69.4052C49.7488 69.6204 49.5968 69.7071 49.5972 69.8847C49.5972 70.0041 49.6661 70.1646 49.7816 70.4332C49.7779 70.4709 49.7759 70.5073 49.7759 70.5427C49.7756 70.7732 49.8569 70.9527 50.0313 71.0739C49.9198 71.3081 49.8395 71.573 49.6906 71.7702C49.6872 71.7742 49.6842 71.7786 49.6809 71.7826C49.6718 71.7942 49.6628 71.8059 49.6534 71.8172C49.476 72.0371 49.2792 72.1786 49.061 72.1799C49.06 72.1799 49.059 72.1799 49.058 72.1799Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M50.031 71.0735C49.8566 70.9524 49.7753 70.7729 49.7756 70.5423C49.7756 70.5069 49.7776 70.4705 49.7813 70.4328C49.8961 70.0902 50.0109 69.7475 50.1257 69.4048C50.3352 68.521 50.8021 67.9043 51.5324 67.4972C51.858 67.3154 52.1395 67.0008 52.441 66.7465L52.4423 66.7458C52.8831 66.6821 53.0609 66.2961 53.2165 65.883C53.4989 65.9707 53.7814 66.0582 54.0642 66.1456C53.9872 66.5783 53.9106 67.0111 53.8256 67.4912C53.2847 67.7091 52.7175 67.9334 52.1539 68.1736C52.1124 68.191 52.0715 68.3177 52.0712 68.3905C52.0712 68.3922 52.0715 68.3938 52.0715 68.3955C52.0715 68.3972 52.0715 68.3991 52.0715 68.4008C52.0749 68.4569 52.1064 68.54 52.1371 68.5743C52.1385 68.5757 52.1395 68.5773 52.1408 68.5783C52.1468 68.5843 52.1525 68.5883 52.1582 68.5897C52.1599 68.59 52.1612 68.5904 52.1629 68.5904C52.1632 68.5904 52.1636 68.5904 52.1639 68.5904C52.1716 68.5897 52.1793 68.5894 52.1867 68.589C52.187 68.589 52.187 68.589 52.1873 68.589C52.1907 68.5887 52.1943 68.5887 52.198 68.5887C52.1984 68.5883 52.1987 68.5883 52.199 68.5883C52.2024 68.5883 52.2057 68.5883 52.2091 68.588C52.2094 68.588 52.2098 68.588 52.2101 68.588C52.2134 68.588 52.2171 68.588 52.2201 68.5877C52.2208 68.5877 52.2211 68.5877 52.2215 68.5877C52.2248 68.5877 52.2285 68.5877 52.2318 68.5877H52.2322C52.2359 68.5873 52.2392 68.5874 52.2429 68.5874H52.2432C52.2469 68.5874 52.2502 68.5874 52.2539 68.5874C52.2549 68.5874 52.2559 68.5874 52.2569 68.5874C52.9966 68.589 53.0679 69.211 53.0327 69.9043C53.0321 69.9193 53.031 69.934 53.0304 69.9487C53.0233 70.0802 52.8674 70.2557 52.7479 70.3498C52.7409 70.3554 52.7338 70.3608 52.7268 70.3658C52.7255 70.3668 52.7242 70.3678 52.7228 70.3688C52.7215 70.3698 52.7201 70.3705 52.7188 70.3715C52.6462 70.4228 52.5776 70.4482 52.5167 70.4492C52.5157 70.4492 52.5146 70.4492 52.5133 70.4492C52.5126 70.4492 52.5116 70.4492 52.5106 70.4492C52.3962 70.4475 52.3101 70.3574 52.279 70.1856C52.2783 70.1829 52.278 70.1796 52.2774 70.1766C52.2763 70.1719 52.2757 70.1669 52.275 70.1619C52.2278 69.8423 52.0993 69.7618 51.9434 69.7612C51.943 69.7612 51.9423 69.7612 51.9417 69.7612C51.8731 69.7612 51.7991 69.7765 51.7248 69.7935C51.7225 69.7939 51.7204 69.7945 51.7181 69.7952C51.7171 69.7952 51.7158 69.7955 51.7144 69.7959C51.7084 69.7972 51.702 69.7989 51.696 69.8002C51.687 69.8022 51.6783 69.8042 51.6696 69.8062C51.6619 69.8079 51.6545 69.8099 51.6468 69.8116C51.6341 69.8142 51.6217 69.8169 51.6093 69.8196C51.5544 69.8309 51.5009 69.8393 51.45 69.8393C51.4497 69.8393 51.449 69.8393 51.4484 69.8393C51.4343 69.8393 51.4203 69.8386 51.4065 69.8369C51.4039 69.8366 51.4015 69.8366 51.3988 69.8363C51.367 69.8343 51.3366 69.8326 51.3075 69.8309C51.1867 69.8246 51.0849 69.8199 50.9979 69.8199C50.9976 69.8199 50.9969 69.8199 50.9962 69.8199C50.9959 69.8199 50.9952 69.8199 50.9945 69.8199C50.5504 69.8202 50.4915 69.944 50.2127 70.5783C50.2107 70.5823 50.2091 70.5863 50.2074 70.5906C50.1381 70.7465 50.0892 70.9123 50.031 71.0735Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M49.6193 68.0981C49.4537 67.6627 49.2883 67.2276 49.1233 66.7922C48.5069 66.5917 48.1839 66.1229 48.1846 65.3571C48.1846 65.3451 48.1846 65.3328 48.1849 65.3207C48.2435 65.1526 48.3034 64.9847 48.364 64.8172C48.5678 64.6961 48.7716 64.5753 48.9754 64.4546C49.3037 64.3775 49.6324 64.3 49.9607 64.223C49.7887 64.7959 49.6167 65.3685 49.4523 65.9147C49.7311 66.1319 50.0909 66.1759 50.0915 66.572C50.0915 66.6371 50.0822 66.7111 50.0611 66.7972C49.9821 67.1209 50.02 67.4669 49.9497 67.7935C49.9246 67.909 49.7338 67.9974 49.6193 68.0981Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M56.072 74.2517L56.0713 74.2514C56.1861 73.906 56.3006 73.561 56.415 73.216C56.7768 72.887 56.9505 72.4986 56.9515 72.0555C56.9515 71.9344 56.9388 71.8089 56.9133 71.6798C57.0911 71.1847 57.2387 70.6995 57.2648 70.1603C57.3076 69.2711 57.3454 69.2684 58.2172 69.2511C58.2189 69.2594 58.2206 69.2678 58.2223 69.2758C58.2236 69.2818 58.225 69.2881 58.226 69.2941C58.227 69.2981 58.2276 69.3021 58.2287 69.3065C58.229 69.3088 58.2296 69.3111 58.23 69.3138C58.2721 69.517 58.2966 69.6108 58.3555 69.6121C58.3558 69.6124 58.3565 69.6124 58.3568 69.6124C58.3628 69.6124 58.3689 69.6114 58.3756 69.6098C58.3762 69.6094 58.3769 69.6091 58.3779 69.6091C58.3786 69.6087 58.3796 69.6084 58.3806 69.6081C58.3846 69.6068 58.389 69.6051 58.3933 69.6031C58.3943 69.6027 58.3953 69.6024 58.3963 69.6017C58.3967 69.6017 58.397 69.6014 58.3977 69.6014C58.398 69.6011 58.3987 69.6007 58.399 69.6004C58.4234 69.5884 58.4522 69.5677 58.4877 69.5384C58.4954 69.532 58.5034 69.5253 58.5114 69.518C58.5151 69.515 58.5188 69.5117 58.5228 69.5087C58.5272 69.5046 58.5318 69.5003 58.5365 69.4963C58.5412 69.4923 58.5459 69.488 58.5506 69.484C58.5523 69.4823 58.5539 69.4806 58.5559 69.479C58.5733 69.4636 58.5914 69.4469 58.6112 69.4289C58.6132 69.4269 58.6152 69.4252 58.6172 69.4232C58.6179 69.4226 58.6189 69.4219 58.6195 69.4212C58.6212 69.4199 58.6225 69.4182 58.6242 69.4169C58.6272 69.4142 58.6303 69.4112 58.6333 69.4086C58.6376 69.4049 58.6416 69.4009 58.646 69.3969C58.7042 69.223 58.7624 69.0489 58.8207 68.875C58.8849 68.7129 58.9482 68.55 59.0104 68.3869C59.0797 68.4082 59.152 68.4219 59.2176 68.4519C59.7193 68.6805 59.9455 68.7843 59.9462 69.0205C59.9469 69.2134 59.797 69.4947 59.5242 70.0042C59.4716 70.1026 59.4395 70.19 59.4395 70.2684C59.4395 70.3402 59.4663 70.4042 59.5282 70.4626C59.5657 70.498 59.6253 70.516 59.6805 70.518C59.6842 70.5183 59.6878 70.5183 59.6915 70.5183C59.6922 70.5183 59.6929 70.5183 59.6935 70.5183C59.6955 70.5183 59.6979 70.5183 59.7002 70.518C59.7042 70.518 59.7079 70.518 59.7119 70.5177C60.2625 70.477 60.7481 70.3131 60.9559 69.5707C61.0496 69.2351 61.1822 68.9094 61.297 68.5787C61.4365 68.6221 61.5754 68.6665 61.714 68.7125C61.6611 68.882 61.6072 69.0512 61.5527 69.22C61.5473 69.2634 61.5446 69.3051 61.5446 69.3452C61.5446 69.5747 61.6317 69.7519 61.7987 69.8807C61.7431 70.0499 61.6885 70.2197 61.6336 70.3892C61.634 70.3892 61.634 70.3892 61.634 70.3895C61.6333 70.3892 61.6326 70.3889 61.632 70.3885L61.6333 70.3915C61.6336 70.3909 61.6337 70.3902 61.634 70.3895C61.7699 70.4406 61.9064 70.4916 62.0426 70.5424C62.0045 70.7129 61.9369 70.8873 61.9355 71.0535C61.9355 71.0552 61.9355 71.0569 61.9355 71.0589C61.9352 71.2787 62.0269 71.3768 62.1541 71.3775C62.1544 71.3775 62.1551 71.3775 62.1554 71.3775C62.1564 71.3775 62.1574 71.3775 62.1584 71.3775C62.2133 71.3768 62.2742 71.3585 62.3375 71.3241C62.3402 71.3225 62.3432 71.3211 62.3458 71.3195C62.3492 71.3175 62.3525 71.3158 62.3556 71.3138C62.3572 71.3128 62.3589 71.3118 62.3606 71.3108C62.5594 71.192 62.7267 70.9878 62.9078 70.8213C62.9078 70.8213 62.9078 70.8213 62.9074 70.8213C62.9078 70.8209 62.9078 70.821 62.9078 70.821C62.963 70.6488 63.0182 70.4766 63.0734 70.3045C63.0795 70.2975 63.0855 70.2904 63.0915 70.2838C63.1869 70.1787 63.2772 70.1296 63.3683 70.128C63.3696 70.128 63.3713 70.128 63.3726 70.128C63.374 70.128 63.3753 70.128 63.3766 70.128C63.4576 70.1293 63.5396 70.1676 63.6266 70.237C63.6297 70.2397 63.6327 70.2421 63.6357 70.2447C63.6374 70.2461 63.6394 70.2474 63.6411 70.2491C63.8626 70.4336 64.116 70.5704 64.3553 70.7275C64.3553 70.7292 64.3553 70.7309 64.3553 70.7325C64.3563 70.7329 64.3576 70.7332 64.3586 70.7335C64.3552 70.8203 64.3516 70.907 64.3475 70.9935C64.3184 71.6534 64.1819 71.9885 63.8827 71.9911C63.8813 71.9911 63.8803 71.9911 63.879 71.9911C63.8787 71.9911 63.8783 71.9911 63.878 71.9911C63.8097 71.9908 63.7331 71.9734 63.6474 71.9391C63.6471 71.9391 63.6471 71.9391 63.6467 71.9391C63.6417 71.9367 63.6364 71.9347 63.6313 71.9324C63.6293 71.9317 63.627 71.9307 63.625 71.9297C63.4596 71.859 63.31 71.8213 63.1675 71.8206C63.1665 71.8206 63.1651 71.8206 63.1641 71.8206C63.1635 71.8206 63.1625 71.8206 63.1618 71.8206C62.968 71.8213 62.7873 71.8903 62.5969 72.0378C62.5948 72.0395 62.5928 72.0412 62.5905 72.0428C62.5865 72.0462 62.5821 72.0495 62.5778 72.0528C62.2538 72.3121 61.9489 72.6114 61.6504 72.9134C61.3364 73.2303 60.9941 73.4269 60.6002 73.4753C60.654 73.3044 60.7079 73.1343 60.7625 72.9641C60.7869 72.7626 60.8568 72.539 60.8572 72.3491C60.8572 72.2984 60.8522 72.2501 60.8401 72.2053C60.722 71.7702 60.3508 71.6635 59.986 71.6061C59.983 71.6057 59.98 71.6054 59.977 71.6047C59.975 71.6044 59.973 71.6041 59.971 71.6037C59.969 71.6037 59.9666 71.6034 59.9646 71.6031C59.9151 71.5957 59.8649 71.5904 59.815 71.5904C59.8147 71.5904 59.814 71.5904 59.8133 71.5904C59.8127 71.5904 59.812 71.5904 59.8113 71.5904C59.6547 71.5907 59.5038 71.6428 59.402 71.845C59.4007 71.8473 59.3997 71.8497 59.3983 71.8523C59.3973 71.8547 59.396 71.8573 59.3947 71.8597C59.3505 71.9531 59.3311 72.0418 59.3311 72.1259C59.3314 72.2757 59.393 72.4112 59.4847 72.5327C59.4291 72.7048 59.3739 72.8773 59.3184 73.0498C59.2976 73.0498 59.2775 73.0495 59.2578 73.0495C59.2494 73.0492 59.2411 73.0492 59.2327 73.0492C59.2086 73.0488 59.1851 73.0485 59.1624 73.0485C59.1336 73.0482 59.1065 73.0482 59.0804 73.0482C59.0797 73.0482 59.0794 73.0482 59.0787 73.0482C59.078 73.0482 59.0774 73.0482 59.0767 73.0482C58.5476 73.0482 58.481 73.1036 58.3448 73.6318C58.3411 73.6454 58.3377 73.6595 58.3341 73.6735C58.3334 73.6758 58.3327 73.6778 58.3324 73.6801C58.2517 73.9988 58.149 74.1636 57.9997 74.1663C57.9984 74.1663 57.9974 74.1663 57.996 74.1663C57.994 74.1663 57.9917 74.1663 57.9893 74.1663C57.9204 74.1639 57.8417 74.1282 57.7511 74.0578C57.749 74.0565 57.7474 74.0548 57.7454 74.0535C57.7434 74.0518 57.7414 74.0502 57.7394 74.0488C57.7363 74.0465 57.7333 74.0442 57.7303 74.0418C57.7296 74.0412 57.729 74.0405 57.7283 74.0402C57.7273 74.0395 57.7263 74.0388 57.7253 74.0378C57.7169 74.0315 57.7082 74.0248 57.6998 74.0185C57.5536 73.9084 57.417 73.8299 57.2577 73.8286C57.2564 73.8286 57.255 73.8286 57.2537 73.8286C57.2524 73.8286 57.2507 73.8286 57.2494 73.8286C57.1667 73.8293 57.078 73.8506 56.9789 73.899C56.9669 73.905 56.9548 73.9114 56.9425 73.918C56.6647 74.0685 56.3631 74.1433 56.072 74.2517ZM61.3482 70.5657C61.4409 70.508 61.5329 70.4503 61.6256 70.3925C61.6283 70.3922 61.6306 70.3919 61.633 70.3915L61.632 70.3885C61.63 70.3899 61.628 70.3912 61.6256 70.3925C61.5617 70.4005 61.4938 70.3965 61.4352 70.4256C61.3984 70.4439 61.3766 70.517 61.3482 70.5657Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M57.2159 77.9895C57.2152 77.9895 57.2146 77.9895 57.2139 77.9895C57.0556 77.9895 56.8973 77.9665 56.739 77.9124C56.7363 77.9114 56.7336 77.9104 56.731 77.9098C56.6399 77.8157 56.5794 77.7176 56.579 77.6074C56.5787 77.5194 56.6172 77.4236 56.7105 77.3159C56.7982 77.2148 56.8337 77.1237 56.834 77.0396C56.8344 76.9225 56.7657 76.8193 56.672 76.7232C56.5777 76.4139 56.5489 75.8784 56.3772 75.832C55.9358 75.7126 55.8002 75.4947 55.8005 75.2311C55.8005 74.9368 55.9699 74.5861 56.072 74.2518C56.3631 74.1434 56.6647 74.0686 56.9425 73.9181C56.9548 73.9115 56.9669 73.9051 56.9789 73.8991C57.078 73.8507 57.1667 73.8294 57.2494 73.8287C57.2507 73.8287 57.2524 73.8287 57.2537 73.8287C57.255 73.8287 57.2564 73.8287 57.2577 73.8287C57.417 73.83 57.5536 73.9085 57.6998 74.0186C57.7082 74.0249 57.7169 74.0316 57.7253 74.0379C57.7263 74.0389 57.7273 74.0396 57.7283 74.0403C57.729 74.0406 57.7296 74.0413 57.7303 74.0419C57.7333 74.0443 57.7363 74.0466 57.7393 74.0489C57.7414 74.0503 57.7434 74.0519 57.7454 74.0536C57.7474 74.0549 57.749 74.0566 57.751 74.0579C57.8417 74.1283 57.9204 74.164 57.9893 74.1664C57.9917 74.1664 57.994 74.1664 57.996 74.1664C57.9974 74.1664 57.9984 74.1664 57.9997 74.1664C58.149 74.1637 58.2517 73.9989 58.3324 73.6802C58.3327 73.6779 58.3334 73.6759 58.3341 73.6736C58.3377 73.6595 58.3411 73.6455 58.3448 73.6319C58.481 73.1037 58.5476 73.0483 59.0767 73.0483C59.0774 73.0483 59.078 73.0483 59.0787 73.0483C59.0794 73.0483 59.0797 73.0483 59.0804 73.0483C59.1065 73.0483 59.1336 73.0483 59.1624 73.0486C59.1851 73.0486 59.2086 73.0489 59.2327 73.0493C59.2411 73.0493 59.2494 73.0493 59.2578 73.0496C59.2775 73.0496 59.2976 73.0499 59.3183 73.0499C59.4375 73.2294 59.5255 73.426 59.5262 73.6419C59.5265 73.7553 59.5031 73.8738 59.4475 73.9979C59.2702 74.3953 59.0901 74.811 58.8377 75.147C58.4569 75.6545 58.1952 76.1834 58.1423 76.8217C58.2705 76.9021 58.4181 76.9535 58.5114 77.0659C58.5884 77.1587 58.6202 77.3182 58.6346 77.4583C58.6349 77.4603 58.6349 77.462 58.6349 77.464C58.6353 77.524 58.5543 77.6448 58.4994 77.6652C58.493 77.6675 58.487 77.6699 58.481 77.6722C58.4739 77.6749 58.4666 77.6775 58.4596 77.6799C58.4539 77.6822 58.4482 77.6842 58.4422 77.6865C58.4408 77.6872 58.4391 77.6876 58.4375 77.6882C58.4324 77.6902 58.4274 77.6919 58.4224 77.6939C58.4127 77.6976 58.4033 77.7009 58.3936 77.7046C58.0037 77.8497 57.6122 77.9882 57.2209 77.9895C57.2193 77.9895 57.2176 77.9895 57.2159 77.9895Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M56.9133 71.6799C56.5622 71.419 56.841 70.6365 56.2285 70.5461C56.1141 70.5291 56.0716 70.458 56.0716 70.365C56.0719 70.2355 56.1546 70.063 56.2406 69.9358C56.3386 69.7907 56.4755 69.6766 56.5635 69.5261C56.6248 69.4207 56.6532 69.2966 56.6529 69.1858C56.6526 69.0213 56.5896 68.8862 56.4802 68.8865C56.3447 68.8865 56.1428 68.9229 56.0722 69.0286C55.8804 69.3163 55.7382 69.6466 55.5849 69.9646C55.3771 70.3963 55.027 70.6109 54.681 70.8354C54.6706 70.8421 54.6606 70.8484 54.6505 70.8548C54.6445 70.8584 54.6385 70.8621 54.6325 70.8655C54.4805 70.9565 54.3406 71.0036 54.2211 71.0066C54.2168 71.0066 54.2124 71.0066 54.2084 71.0066C54.2071 71.0066 54.2061 71.0066 54.2047 71.0066C54.0608 71.0056 53.9473 70.9388 53.8801 70.806C53.7894 70.6262 53.7422 70.4107 53.7422 70.2035C53.7422 69.9606 53.8068 69.729 53.9413 69.5789C54.1047 69.3963 54.3091 69.2325 54.515 69.1404C54.9099 68.9639 55.1984 68.6279 55.198 68.2222C55.198 68.1951 55.1967 68.1678 55.194 68.1401C55.1897 68.095 55.1877 68.0513 55.1873 68.0086C55.1853 67.2702 55.7781 66.8331 55.9417 66.1971C56.0829 66.2352 56.2225 66.2782 56.3604 66.327C56.4062 66.3894 56.4688 66.4421 56.4946 66.5161C56.6606 67.0026 56.6823 67.6366 57.2968 67.6379C57.2975 67.6379 57.2982 67.6379 57.2988 67.6379H57.2992C57.3336 67.6379 57.3698 67.6359 57.4082 67.6319C57.4113 67.6316 57.4143 67.6312 57.4173 67.6312C57.4176 67.6312 57.4176 67.6312 57.418 67.6312C57.4293 67.6312 57.4414 67.6332 57.4541 67.6369C57.5535 67.6669 57.6793 67.8064 57.6957 67.9135C57.8055 68.6443 58.3437 68.7076 58.8206 68.8751C58.7624 69.049 58.7041 69.2232 58.6459 69.397C58.503 69.3486 58.3601 69.2999 58.2172 69.2512C57.3453 69.2685 57.3075 69.2712 57.2647 70.1604C57.2386 70.6996 57.091 71.1848 56.9133 71.6799Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M54.0644 66.146C53.7816 66.0586 53.4992 65.9712 53.2167 65.8834L53.2123 65.8494C53.2987 65.5594 53.3666 65.2801 53.367 65.0366C53.3676 64.6629 53.209 64.3736 52.7153 64.2598C52.453 64.1991 52.469 63.9231 52.4443 63.6709C52.4011 63.2351 52.2675 62.8524 51.9529 62.6042C51.9252 62.2068 51.8974 61.809 51.8696 61.4116L51.8776 61.3996C51.9767 61.3983 52.0761 61.3966 52.1755 61.3946C52.4141 61.3896 52.6531 61.3836 52.891 61.3836C52.8927 61.3836 52.8944 61.3836 52.8964 61.3836C52.8971 61.3836 52.8974 61.3836 52.8981 61.3836C52.9971 61.3836 53.0959 61.3846 53.1943 61.3873C54.1079 61.4113 54.5795 61.813 54.5812 62.6659C54.5818 62.8624 54.5571 63.0833 54.5072 63.3289C54.4172 63.7736 54.4118 64.1921 54.4118 64.6108C54.4118 64.6705 54.4118 64.7303 54.4118 64.7903C54.4118 64.8991 54.4115 65.0085 54.4092 65.1183C54.1822 65.2034 54.0852 65.2404 54.0859 65.3242C54.0862 65.3869 54.1417 65.476 54.2378 65.6308C54.1802 65.8027 54.1223 65.9745 54.0644 66.146Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M56.0711 74.2517C55.8991 74.1219 55.6976 74.0245 55.5634 73.854C55.5132 73.7899 55.4901 73.7115 55.4905 73.6321C55.4905 73.4606 55.5983 73.2844 55.7689 73.237C55.7753 73.2354 55.782 73.2337 55.7887 73.232C55.8697 73.212 55.952 73.206 56.035 73.2057C56.0374 73.2057 56.0393 73.2057 56.0417 73.2057C56.0424 73.2057 56.0434 73.2057 56.0444 73.2057C56.0969 73.2057 56.1495 73.208 56.2024 73.2103C56.2067 73.2106 56.211 73.2107 56.2154 73.211C56.2449 73.2123 56.274 73.2137 56.3031 73.2147C56.3305 73.2157 56.358 73.2163 56.3851 73.2163C56.3871 73.2163 56.3887 73.2163 56.3904 73.2163C56.3988 73.2163 56.4068 73.2163 56.4149 73.2163C56.3004 73.5613 56.1859 73.9064 56.0711 74.2517Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M54.2376 65.6306C54.1416 65.4758 54.086 65.3867 54.0857 65.324C54.085 65.2392 54.1841 65.2022 54.417 65.1154C54.4153 65.1194 54.414 65.1238 54.4127 65.1278C54.3544 65.2953 54.2962 65.4631 54.2376 65.6306Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M60.7069 77.4314C60.7066 77.4314 60.7063 77.4314 60.7056 77.4314C60.6259 77.4311 60.5443 77.4234 60.4606 77.4084C60.4556 77.4074 60.4506 77.4067 60.4455 77.4057C60.228 77.364 60.0199 77.2812 59.8073 77.2172C59.7243 76.8011 59.5861 76.395 59.569 75.9666C59.5654 75.8705 59.563 75.7748 59.563 75.6797C59.5627 74.8008 59.7464 73.9793 60.6002 73.4754C60.9941 73.4271 61.3365 73.2305 61.6504 72.9136C61.9489 72.6116 62.2538 72.3123 62.5778 72.053C62.5821 72.0497 62.5865 72.0464 62.5905 72.043C62.5928 72.0414 62.5948 72.0397 62.5969 72.038C62.7873 71.8905 62.968 71.8215 63.1618 71.8208C63.1625 71.8208 63.1635 71.8208 63.1641 71.8208C63.1651 71.8208 63.1665 71.8208 63.1675 71.8208C63.31 71.8215 63.4596 71.8592 63.625 71.9299C63.627 71.9309 63.6293 71.9319 63.6314 71.9326C63.6364 71.9349 63.6417 71.9369 63.6467 71.9393C63.6471 71.9393 63.6471 71.9393 63.6474 71.9393C63.7331 71.9736 63.8097 71.991 63.878 71.9913C63.8783 71.9913 63.8787 71.9913 63.879 71.9913C63.8803 71.9913 63.8813 71.9913 63.8827 71.9913C64.1819 71.9887 64.3184 71.654 64.3475 70.9937C64.3516 70.9072 64.3552 70.8205 64.3586 70.7337C64.6404 70.8275 64.9215 70.9209 65.203 71.0143C65.4132 70.8886 65.6233 70.7631 65.8339 70.6373C65.9055 70.6196 65.9865 70.6229 66.0474 70.5809C66.0551 70.5756 66.0624 70.5706 66.0698 70.5652C66.3998 70.337 66.5698 70.2209 66.7164 70.2155C66.7201 70.2152 66.7234 70.2152 66.7271 70.2152C66.7288 70.2152 66.7304 70.2152 66.7321 70.2152C66.8673 70.2179 66.9868 70.316 67.2014 70.5085C67.2188 70.5242 67.2368 70.5402 67.2556 70.5572C67.288 70.7958 67.27 71.0711 67.3623 71.2659C67.4935 71.5415 67.5471 71.8185 67.5468 72.0971C67.5464 72.5319 67.4156 72.9713 67.2432 73.4164C67.2415 73.4187 67.2398 73.4211 67.2378 73.4234C67.2368 73.4251 67.2355 73.4264 67.2345 73.4281C67.1635 73.5178 67.0678 73.5722 66.9902 73.5789C66.9848 73.5792 66.9795 73.5796 66.9741 73.5796C66.9738 73.5796 66.9731 73.5796 66.9728 73.5796C66.9105 73.5792 66.8633 73.5452 66.855 73.4708C66.7921 72.9079 66.5427 72.5399 66.1632 72.2663C66.1598 72.2639 66.1562 72.2612 66.1522 72.2589C66.119 72.2386 66.0758 72.2256 66.0347 72.2246C66.033 72.2246 66.0317 72.2246 66.03 72.2246C66.029 72.2246 66.0276 72.2246 66.0263 72.2246C66.0106 72.2249 65.9952 72.2272 65.9811 72.2316C65.9778 72.2326 65.9744 72.2339 65.9711 72.2352C65.9072 72.2609 65.8078 72.349 65.8057 72.4027C65.7944 72.716 65.7907 73.0293 65.7907 73.342C65.7907 73.4644 65.7914 73.5866 65.7924 73.7087C65.7927 73.7671 65.793 73.8211 65.793 73.8712C65.793 74.4968 65.7298 74.5242 64.8472 74.8955C64.8713 74.8148 64.8995 74.7344 64.9182 74.6526C64.941 74.5512 64.9634 74.4444 64.9634 74.349C64.9634 74.2182 64.9215 74.1081 64.7826 74.0604C64.7806 74.0594 64.7783 74.0587 64.7763 74.058C64.7244 74.0413 64.6685 74.0334 64.6109 74.0334C64.6106 74.0334 64.6099 74.0334 64.6096 74.0334C64.6052 74.0334 64.6009 74.0334 64.5966 74.0334C64.3355 74.0387 64.04 74.1988 63.9081 74.397C63.9041 74.403 63.9004 74.409 63.8967 74.4151C63.8954 74.4167 63.8944 74.4184 63.8934 74.4204C63.8924 74.4221 63.8914 74.4237 63.8904 74.4254C63.8891 74.4278 63.8877 74.4301 63.8864 74.4324C63.882 74.4404 63.878 74.4478 63.874 74.4548C63.8727 74.4571 63.8716 74.4594 63.8703 74.4618C63.8643 74.4725 63.8589 74.4818 63.8546 74.4901C63.8542 74.4908 63.8539 74.4911 63.8536 74.4915C63.8398 74.5162 63.8315 74.5315 63.8275 74.5399C63.8258 74.5432 63.8248 74.5455 63.8244 74.5469C63.8244 74.5469 63.8244 74.5468 63.8244 74.5472C63.8244 74.5479 63.8248 74.5482 63.8251 74.5482C63.8278 74.5482 63.8409 74.5342 63.8589 74.5202C63.877 74.5062 63.8997 74.4921 63.9222 74.4921C63.951 74.4921 63.9787 74.5148 63.9948 74.5886C63.9951 74.5906 63.9958 74.5929 63.9961 74.5952C63.9961 74.5959 63.9965 74.5966 63.9965 74.5972C63.9972 74.6012 63.9981 74.6052 63.9988 74.6096C63.9991 74.6123 63.9998 74.6153 64.0002 74.6179C64.0005 74.6206 64.0008 74.6233 64.0012 74.6259C63.9426 74.7931 63.885 74.9603 63.8278 75.1278C63.3027 75.2339 62.7679 75.2863 62.2822 75.7274C62.141 76.0243 62.0035 76.3543 61.8338 76.6626C61.8271 76.6746 61.8204 76.6863 61.8137 76.698C61.8137 76.6983 61.8134 76.6987 61.8134 76.699C61.5296 77.1935 61.1534 77.4301 60.7106 77.4314C60.7093 77.4314 60.7083 77.4314 60.7069 77.4314Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M60.7235 81.5283C60.6361 81.3074 60.5256 81.0976 60.4677 80.864C60.4654 80.855 60.4631 80.8463 60.4607 80.8377C60.46 80.8353 60.4594 80.833 60.4587 80.8307C60.4065 80.6465 60.3168 80.5397 60.19 80.538C60.189 80.538 60.188 80.538 60.187 80.538C60.1843 80.538 60.1816 80.538 60.1792 80.538C60.1307 80.5397 60.0772 80.556 60.0183 80.5887C60.0133 80.5918 60.0079 80.5947 60.0029 80.5977C59.8007 80.7179 59.6304 80.9237 59.4456 81.0916C59.2207 80.8303 58.9955 80.5694 58.7703 80.3085C59.2914 79.7706 59.7094 79.2017 59.7111 78.4446C59.7111 78.3001 59.6963 78.149 59.6642 77.9898C59.6578 77.9588 59.6552 77.9261 59.6555 77.8927C59.6562 77.6872 59.7623 77.4403 59.8071 77.2174C60.0196 77.2815 60.2278 77.3642 60.4453 77.4059C60.4503 77.4069 60.4554 77.4076 60.4604 77.4086C60.5441 77.4236 60.6257 77.4313 60.7054 77.4316C60.7061 77.4316 60.7064 77.4316 60.7067 77.4316C60.7081 77.4316 60.709 77.4316 60.7104 77.4316C61.1532 77.4303 61.5293 77.1937 61.8132 76.6992C61.8132 76.6989 61.8135 76.6985 61.8135 76.6982C61.8202 76.6865 61.8269 76.6749 61.8336 76.6628C62.0033 76.3545 62.1408 76.0245 62.282 75.7276C62.7676 75.2865 63.3025 75.2341 63.8276 75.128C63.7777 75.4476 63.7449 75.6645 63.7449 75.8227C63.7449 76.1577 63.8922 76.2267 64.3363 76.4449C64.4632 76.507 64.5987 76.5507 64.7299 76.6031C64.6295 76.9371 64.5294 77.2711 64.4297 77.6048C64.2034 78.1626 64.0197 78.7476 63.7372 79.2691C63.5849 79.5504 63.3594 79.7339 63.0936 79.7369C63.0916 79.7369 63.0896 79.7369 63.0876 79.7369C63.0866 79.7369 63.0859 79.7369 63.0853 79.7369C62.9902 79.7366 62.8905 79.7132 62.7871 79.6632C62.7847 79.6622 62.7824 79.6608 62.7801 79.6595C62.7791 79.6591 62.7784 79.6588 62.7777 79.6585C62.7539 79.6471 62.7271 79.6428 62.6977 79.6425C62.6974 79.6425 62.697 79.6425 62.6967 79.6425C62.6924 79.6425 62.6877 79.6428 62.683 79.6428C62.6639 79.6438 62.6442 79.6461 62.6234 79.6498C62.614 79.6511 62.6044 79.6531 62.5946 79.6551C62.5873 79.6565 62.5799 79.6581 62.5722 79.6598C62.5665 79.6611 62.5611 79.6621 62.5555 79.6635C62.5498 79.6648 62.5441 79.6662 62.5384 79.6675C62.4969 79.6772 62.4527 79.6885 62.4059 79.6979C62.3911 79.7009 62.3761 79.7035 62.3607 79.7062C62.3604 79.7062 62.3604 79.7062 62.3604 79.7062C62.3547 79.7072 62.349 79.7082 62.3433 79.7092C62.3379 79.7099 62.3322 79.7105 62.3265 79.7115C62.3366 80.1253 62.3466 80.5374 62.3563 80.9488C62.355 80.9494 62.3537 80.9504 62.3523 80.9511C62.344 80.9558 62.3352 80.9608 62.3265 80.9661C62.2164 81.0342 62.0708 81.1513 62.0086 81.1513C62.0083 81.1513 62.0083 81.1513 62.0083 81.1513C62.0006 81.1513 61.9942 81.1493 61.9892 81.1456C61.9889 81.1453 61.9885 81.1449 61.9882 81.1446C61.9859 81.1426 61.9838 81.1406 61.9818 81.1386C61.9785 81.1359 61.9751 81.1329 61.9721 81.1303C61.8121 80.9898 61.6649 80.9301 61.5263 80.9294C61.5257 80.9294 61.5253 80.9294 61.5247 80.9294C61.5233 80.9294 61.5223 80.9294 61.5213 80.9297C61.2415 80.9314 60.9975 81.1746 60.7589 81.4823C60.7586 81.4829 60.7582 81.4833 60.7576 81.484C60.7556 81.4866 60.7532 81.4893 60.7512 81.4923C60.7419 81.5043 60.7328 81.5163 60.7235 81.5283Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M58.3255 83.0168C58.049 82.9985 57.7739 82.9711 57.4961 82.9638C57.4238 82.9618 57.3516 82.9605 57.2793 82.9598C57.2083 82.9588 57.1373 82.9588 57.0664 82.9588C57.0651 82.9588 57.0634 82.9588 57.062 82.9588C57.0607 82.9588 57.0594 82.9588 57.058 82.9588C57.0102 82.9588 56.9627 82.9588 56.9151 82.9588C56.8663 82.9591 56.8171 82.9595 56.7682 82.9598C56.6638 82.9601 56.559 82.9608 56.4546 82.9608C56.4543 82.9608 56.4539 82.9608 56.4536 82.9608C56.4536 82.9601 56.4539 82.9598 56.4539 82.9591C56.6835 82.2711 56.9131 81.5838 57.1427 80.8958C57.1447 80.8934 57.1467 80.8911 57.1484 80.8888C57.1501 80.8868 57.1518 80.8847 57.1534 80.8827C57.1548 80.8811 57.1564 80.8794 57.1578 80.8777C57.3412 80.6595 57.5336 80.5875 57.7307 80.5871C57.7318 80.5868 57.7324 80.5868 57.7334 80.5868C57.7341 80.5868 57.7348 80.5871 57.7354 80.5871C57.8726 80.5875 58.0119 80.6218 58.1514 80.6652C58.1548 80.6662 58.1581 80.6675 58.1615 80.6685C58.1645 80.6695 58.1678 80.6705 58.1708 80.6715C58.1748 80.6715 58.1785 80.6715 58.1826 80.6715C58.1859 80.6718 58.1889 80.6719 58.1923 80.6719C58.1926 80.6719 58.1926 80.6719 58.1929 80.6719C58.1939 80.6719 58.1946 80.6719 58.1956 80.6719C58.4239 80.6709 58.6096 80.5567 58.7545 80.3322C58.7599 80.3235 58.7652 80.3149 58.7706 80.3062L58.7702 80.3082C58.9955 80.5691 59.2207 80.83 59.4456 81.0913C58.9289 81.6321 58.5038 82.2374 58.3255 83.0168Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M60.7625 72.9641C60.3364 72.82 59.9107 72.6765 59.4847 72.5327C59.393 72.4112 59.3314 72.2758 59.3311 72.1259C59.3311 72.0419 59.3505 71.9531 59.3947 71.8597C59.396 71.8573 59.3973 71.8547 59.3983 71.8523C59.3997 71.8497 59.4007 71.8473 59.402 71.845C59.5038 71.6428 59.6547 71.5907 59.8113 71.5904C59.812 71.5904 59.8127 71.5904 59.8133 71.5904C59.814 71.5904 59.8147 71.5904 59.815 71.5904C59.8649 71.5904 59.9151 71.5958 59.9646 71.6031C59.9666 71.6034 59.969 71.6037 59.971 71.6037C59.973 71.6041 59.975 71.6044 59.977 71.6048C59.98 71.6054 59.983 71.6058 59.986 71.6061C60.3508 71.6635 60.722 71.7703 60.8401 72.2053C60.8522 72.2501 60.8572 72.2984 60.8572 72.3491C60.8568 72.539 60.7869 72.7626 60.7625 72.9641Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M58.193 80.6719C58.1927 80.6719 58.1927 80.6719 58.1923 80.6719C58.189 80.6719 58.186 80.6719 58.1826 80.6715C58.1786 80.6715 58.1749 80.6715 58.1709 80.6715C58.1766 80.6622 58.1823 80.6535 58.188 80.6448C58.19 80.6415 58.192 80.6385 58.194 80.6352C58.3383 80.4189 58.522 80.3075 58.7466 80.3058C58.7486 80.3058 58.7502 80.3058 58.7522 80.3058H58.7526C58.7552 80.3058 58.7579 80.3058 58.7606 80.3058C58.764 80.3058 58.7673 80.3058 58.7706 80.3062C58.7653 80.3149 58.7599 80.3235 58.7546 80.3322C58.6097 80.5567 58.4239 80.6709 58.1957 80.6719C58.1947 80.6719 58.194 80.6719 58.193 80.6719Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M62.3281 83.7859C62.5299 83.241 62.6654 82.7045 62.6651 82.1839C62.6651 81.7595 62.5748 81.3465 62.3562 80.9484C62.3465 80.537 62.3365 80.1249 62.3264 79.7112C62.3321 79.7102 62.3378 79.7095 62.3431 79.7088C62.3488 79.7078 62.3546 79.7068 62.3602 79.7058C62.3602 79.7058 62.3602 79.7058 62.3606 79.7058C62.376 79.7032 62.391 79.7005 62.4057 79.6975C62.4526 79.6881 62.4968 79.6768 62.5383 79.6671C62.544 79.6658 62.5496 79.6644 62.5553 79.6631C62.561 79.6618 62.5664 79.6608 62.5721 79.6594C62.5798 79.6578 62.5872 79.6561 62.5945 79.6548C62.6042 79.6528 62.6139 79.6508 62.6233 79.6494C62.644 79.6458 62.6638 79.6434 62.6829 79.6424C62.6875 79.6424 62.6922 79.6421 62.6966 79.6421C62.6969 79.6421 62.6972 79.6421 62.6976 79.6421C62.727 79.6424 62.7538 79.6467 62.7776 79.6581C62.7782 79.6584 62.7789 79.6588 62.7799 79.6591C62.7823 79.6604 62.7846 79.6618 62.787 79.6628C62.8904 79.7128 62.9901 79.7362 63.0851 79.7365C63.0858 79.7365 63.0865 79.7365 63.0875 79.7365C63.0895 79.7365 63.0915 79.7365 63.0935 79.7365C63.3592 79.7339 63.5848 79.55 63.7371 79.2687C64.0196 78.7472 64.2033 78.1623 64.4295 77.6044C64.5326 77.7138 64.625 77.841 64.7415 77.9287C64.7475 77.9334 64.7538 77.9377 64.7599 77.9421C64.8338 77.9938 64.9061 78.0192 64.9707 78.0208C64.9731 78.0208 64.9751 78.0208 64.9774 78.0208C64.9777 78.0208 64.9781 78.0208 64.9784 78.0208C65.1056 78.0205 65.2007 77.9257 65.2134 77.7559C65.2167 77.7162 65.2177 77.6761 65.2177 77.6364C65.2177 77.4869 65.2003 77.3375 65.2 77.189C65.2 77.1236 65.2033 77.0585 65.2127 76.9938C65.2321 76.8623 65.3753 76.7315 65.4777 76.6198C65.4818 76.6157 65.4881 76.6138 65.4968 76.6138C65.4972 76.6138 65.4975 76.6138 65.4975 76.6138C65.5079 76.6138 65.5206 76.6161 65.5343 76.6204C65.5397 76.6221 65.5454 76.6241 65.5511 76.6264C65.5527 76.6271 65.5547 76.6278 65.5567 76.6284C65.5845 76.6404 65.6136 76.6578 65.6327 76.6768C65.6344 76.6788 65.6364 76.6805 65.6381 76.6825C65.6401 76.6848 65.6417 76.6871 65.6437 76.6895C65.8215 76.9367 65.9697 77.217 66.1645 77.4439C66.1665 77.4462 66.1682 77.4483 66.1702 77.4506C66.2241 77.51 66.2934 77.5367 66.3677 77.537C66.3683 77.537 66.369 77.537 66.3697 77.537C66.3757 77.537 66.3817 77.5367 66.3878 77.5363C66.5691 77.5263 66.7773 77.3698 66.8817 77.163C66.8834 77.1596 66.8854 77.1559 66.8868 77.1526C66.8871 77.1523 66.8874 77.152 66.8874 77.1516C66.8908 77.1446 66.8938 77.1379 66.8968 77.1309C66.9885 76.9247 67.0153 76.7259 67.0153 76.5307C67.0156 76.2607 66.9651 75.9968 66.9651 75.7279C66.9654 75.6885 66.9664 75.6491 66.9691 75.6094C67.8697 74.6401 67.8697 74.6401 69.0039 74.1676C68.8081 74.6788 68.6284 75.1463 68.449 75.6137C68.3848 75.8053 68.3503 75.9781 68.3506 76.1306C68.3506 76.4603 68.5116 76.6962 68.8774 76.8256C69.3537 76.9945 69.9367 77.0208 70.0394 77.7719C69.2978 78.4616 68.9761 79.5944 68.1257 80.1693C68.1194 80.1673 68.1134 80.1653 68.107 80.1633C68.102 80.1619 68.0973 80.1603 68.0926 80.1589C68.0859 80.1566 68.0795 80.1546 68.0728 80.1526C68.0708 80.1519 68.0692 80.1516 68.0672 80.1509C68.0651 80.1503 68.0631 80.1496 68.0611 80.1489C68.0464 80.1443 68.0317 80.1396 68.0176 80.1353C68.0093 80.1326 68.0012 80.1302 67.9932 80.1276C67.9898 80.1266 67.9862 80.1256 67.9828 80.1246C67.9802 80.1236 67.9771 80.1226 67.9741 80.1216C67.4714 79.9644 67.194 79.8867 66.8606 79.8863C66.86 79.8863 66.8593 79.8863 66.8586 79.8863C66.8559 79.8863 66.8529 79.8863 66.8503 79.8863C66.5357 79.8877 66.1699 79.9574 65.5182 80.0945C65.5115 80.0959 65.5049 80.0972 65.4982 80.0985C65.4925 80.0999 65.4864 80.1012 65.4808 80.1022C65.4787 80.1029 65.4768 80.1032 65.4744 80.1036C65.4724 80.1039 65.4707 80.1046 65.4687 80.1049C65.4543 80.1079 65.4396 80.1109 65.4249 80.1142C65.4198 80.1152 65.4148 80.1162 65.4095 80.1172C65.4078 80.1176 65.4061 80.1182 65.4045 80.1186C65.3998 80.1196 65.3951 80.1206 65.3904 80.1212C65.3559 80.1286 65.3208 80.1363 65.285 80.1436C65.2846 80.1439 65.2843 80.1439 65.284 80.1439C65.2679 80.1473 65.2519 80.1506 65.2358 80.1543C65.2258 80.1563 65.2157 80.1573 65.2053 80.1573C65.205 80.1573 65.2047 80.1573 65.2043 80.1573C65.2036 80.1573 65.2026 80.1573 65.2016 80.1573C65.1836 80.157 65.1655 80.1539 65.1474 80.1496C65.1397 80.1476 65.132 80.1456 65.1243 80.1432C65.0932 80.1339 65.0618 80.1222 65.0306 80.1146C65.0273 80.1139 65.0239 80.1132 65.0206 80.1125C64.8425 79.7956 64.6645 79.4786 64.2221 78.6925C64.2411 78.8186 64.2498 78.9364 64.2502 79.0475C64.2518 80.0101 63.62 80.4436 63.6226 81.1212C63.6226 81.1649 63.6256 81.21 63.6313 81.2557C63.6347 81.258 63.6384 81.2604 63.6417 81.2627C63.8014 81.3695 63.9419 81.4169 64.0674 81.4172C64.0681 81.4172 64.0688 81.4172 64.0694 81.4172C64.0701 81.4172 64.0708 81.4172 64.0714 81.4172C64.4168 81.4159 64.6478 81.0595 64.8496 80.6134C64.8509 80.6104 64.8522 80.6077 64.8532 80.6051C64.8549 80.6017 64.8563 80.5984 64.8579 80.595C64.9376 80.8366 65.0173 81.0779 65.0976 81.3198C64.9798 81.6611 64.8619 82.0031 64.7445 82.3448C64.7458 82.3451 64.7471 82.3458 64.7485 82.3461C64.4182 82.3641 64.1926 82.568 64.0477 82.923C63.9483 83.1663 63.8415 83.4062 63.7381 83.6474C63.2682 83.6935 62.798 83.7395 62.3281 83.7859Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M61.0457 82.7236C61.0447 82.7236 61.044 82.7236 61.043 82.7233C60.9376 82.7216 60.8208 82.6122 60.7395 82.5101C60.7335 82.5028 60.7275 82.4951 60.7218 82.4878C60.6404 82.38 60.6123 82.2622 60.6123 82.1397C60.6123 81.9419 60.6853 81.731 60.7234 81.5281C60.9841 81.6419 61.2622 81.7236 61.4995 81.8798C61.616 81.9565 61.7194 82.0947 61.7197 82.2478C61.7197 82.3269 61.6926 82.4097 61.6264 82.4904C61.5002 82.6432 61.2495 82.7073 61.0577 82.723C61.0557 82.7233 61.0534 82.7233 61.0514 82.7233C61.0497 82.7233 61.048 82.7236 61.0464 82.7236C61.046 82.7236 61.0461 82.7236 61.0457 82.7236Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M39.8863 77.3958C40.1149 77.0204 40.3402 76.6424 40.5731 76.27C40.7803 75.939 40.8833 75.6467 40.8837 75.4041C40.885 74.9927 40.5922 74.7241 40.0158 74.6514C40.0011 74.6497 39.986 74.648 39.9713 74.6464C39.8639 74.635 39.7555 74.6314 39.646 74.6314C39.644 74.631 39.6423 74.631 39.6403 74.631C39.639 74.631 39.6376 74.6314 39.6366 74.6314C39.5908 74.6314 39.545 74.632 39.4991 74.6327C39.4476 74.634 39.3964 74.6354 39.3448 74.637C39.313 74.6377 39.2812 74.6387 39.2494 74.6397C39.232 74.64 39.2143 74.6404 39.1969 74.6407C39.1935 74.641 39.1905 74.641 39.1872 74.641C39.143 74.642 39.0985 74.6427 39.0543 74.6427C39.0523 74.6427 39.0503 74.6427 39.0483 74.6427C39.0473 74.6427 39.0466 74.6427 39.046 74.6427C38.9944 74.6427 38.9432 74.6417 38.892 74.6397C38.8404 74.6377 38.7642 74.5269 38.7642 74.4599C38.7642 74.4579 38.7642 74.4555 38.7645 74.4535C38.7765 74.2964 38.7936 74.0615 38.8786 73.9961C39.0707 73.8486 39.3087 73.7962 39.5219 73.6851C39.9405 73.4669 40.048 73.4081 40.0473 73.0171C40.0473 72.8813 40.0339 72.7051 40.0162 72.4682C40.0158 72.4612 40.0152 72.4545 40.0148 72.4475C39.985 72.0481 39.986 71.96 40.3465 71.9597C40.3468 71.9597 40.3472 71.9597 40.3478 71.9597C40.3485 71.9597 40.3492 71.9597 40.3502 71.9597C40.3716 71.9597 40.394 71.96 40.4181 71.9607C40.4218 71.9607 40.4255 71.9607 40.4292 71.961C40.5132 71.963 40.6126 71.9684 40.7307 71.9747C40.7341 71.975 40.7377 71.975 40.7411 71.9754C40.7464 71.9767 40.7515 71.9784 40.7568 71.9797C40.7588 71.9804 40.7612 71.9807 40.7635 71.9814C40.7658 71.9821 40.7682 71.9827 40.7705 71.9834C40.8569 72.0054 40.9409 72.0161 41.0236 72.0164C41.0242 72.0164 41.0249 72.0164 41.0256 72.0164C41.0266 72.0164 41.0276 72.0164 41.0286 72.0164C41.2903 72.0157 41.5393 71.909 41.8208 71.7255C42.0099 71.602 42.1802 71.5429 42.3218 71.5423C42.3231 71.5419 42.3241 71.542 42.3251 71.542C42.3265 71.542 42.3278 71.542 42.3291 71.542C42.6564 71.5446 42.8258 71.8613 42.707 72.4098C42.7063 72.4125 42.7057 72.4155 42.705 72.4182C42.7037 72.4252 42.702 72.4325 42.7003 72.4399C42.6631 72.599 42.6454 72.7225 42.6454 72.8185C42.6451 73.1325 42.8352 73.1529 43.1752 73.1582C43.3616 73.1612 43.464 73.2833 43.4647 73.4248C43.465 73.5072 43.4309 73.5956 43.359 73.6711C43.0691 73.974 42.7655 74.258 42.4787 74.5399C42.6501 75.0451 43.2786 75.0284 43.2773 75.634C43.2773 75.6527 43.2766 75.6717 43.2753 75.6914C43.2703 75.6924 43.2652 75.6931 43.2602 75.6941C43.2552 75.6947 43.2505 75.6957 43.2455 75.6967C43.2013 75.7047 43.1568 75.7138 43.1123 75.7231C43.0982 75.7261 43.0845 75.7291 43.0705 75.7324C43.0705 75.7324 43.0704 75.7324 43.0701 75.7324C42.8084 75.7905 42.5436 75.8646 42.292 75.8652C42.291 75.8652 42.2896 75.8652 42.2883 75.8652C42.288 75.8652 42.2876 75.8652 42.2873 75.8652C42.2461 75.8652 42.205 75.8633 42.1645 75.8586C42.1139 75.8532 42.0654 75.8506 42.0185 75.8506C42.0182 75.8506 42.0179 75.8506 42.0179 75.8506C42.0166 75.8506 42.0155 75.8506 42.0142 75.8506C41.5748 75.8516 41.2963 76.0958 41.0466 76.5799C40.7889 77.0808 40.3636 77.3223 39.8863 77.3958ZM43.2749 75.6947C43.2753 75.6937 43.2753 75.6924 43.2753 75.6914C43.2753 75.6924 43.2753 75.6937 43.2749 75.6947Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M43.7302 78.1282C43.7298 78.1282 43.7295 78.1282 43.7292 78.1282C43.523 78.1272 43.4189 77.922 43.2208 77.4461C43.2208 77.4455 43.2205 77.4448 43.2201 77.4442C43.2184 77.4405 43.2171 77.4368 43.2154 77.4331C43.2134 77.4278 43.2111 77.4225 43.2087 77.4171C43.2077 77.4148 43.2071 77.4124 43.2061 77.4101C43.2057 77.4094 43.2054 77.4088 43.205 77.4078C43.2027 77.4028 43.2007 77.3974 43.1983 77.3921C43.197 77.3884 43.1953 77.3848 43.194 77.3808C43.192 77.3761 43.19 77.3711 43.188 77.3664C43.2 77.3701 43.2124 77.3734 43.2245 77.3767C43.2275 77.3774 43.2305 77.3781 43.2335 77.3791C43.3443 77.4081 43.4517 77.4271 43.5585 77.4278C43.5605 77.4278 43.5622 77.4278 43.5642 77.4278C43.5652 77.4278 43.5658 77.4278 43.5665 77.4278C43.7589 77.4271 43.9504 77.3671 44.1582 77.2016C44.1602 77.2002 44.1619 77.1986 44.1639 77.1972C44.1669 77.1949 44.1699 77.1922 44.1729 77.1899C44.1749 77.1882 44.1773 77.1862 44.1796 77.1842C44.1806 77.1836 44.1816 77.1826 44.1826 77.1819C44.1853 77.1796 44.1883 77.1772 44.1913 77.1746C44.194 77.1722 44.197 77.1699 44.1997 77.1676C44.2007 77.1669 44.2017 77.1659 44.2024 77.1652C44.2051 77.1629 44.2077 77.1609 44.2104 77.1585C44.2118 77.1575 44.2128 77.1569 44.2138 77.1559C44.2198 77.1508 44.2258 77.1462 44.2315 77.1415C44.2318 77.1412 44.2319 77.1412 44.2322 77.1412C44.3155 77.0745 44.3791 77.0364 44.4263 77.0301C44.431 77.0294 44.4357 77.0291 44.44 77.0291C44.4404 77.0291 44.4407 77.0291 44.441 77.0291C44.5304 77.0297 44.5528 77.1639 44.5388 77.4542C44.5384 77.4562 44.5384 77.4585 44.5384 77.4605C44.5384 77.4612 44.5384 77.4615 44.5384 77.4622C44.5367 77.4929 44.5347 77.5252 44.5324 77.5593C44.5274 77.6394 44.4902 77.7208 44.4674 77.8018C44.4634 77.8038 44.4594 77.8062 44.4557 77.8085C44.4521 77.8105 44.4487 77.8125 44.4454 77.8145C44.437 77.8192 44.429 77.8239 44.4209 77.8282C44.4126 77.8332 44.4042 77.8379 44.3958 77.8425C44.3938 77.8439 44.3915 77.8449 44.3895 77.8462C44.3872 77.8476 44.3851 77.8486 44.3828 77.8499C44.0966 78.0127 43.9089 78.1105 43.7683 78.1258C43.7553 78.1272 43.7426 78.1282 43.7302 78.1282Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M44.9504 78.7002C44.9498 78.7002 44.9491 78.7002 44.9491 78.6999C44.8788 78.6208 44.7761 78.5311 44.7754 78.4306C44.7754 78.4296 44.7754 78.4283 44.7754 78.4273C44.7754 78.2741 44.8467 78.1106 44.8872 77.9515C45.0281 77.9935 45.166 78.0429 45.3012 78.1C45.2376 78.2524 45.1817 78.4099 45.1057 78.5551C45.0739 78.6161 44.9658 78.7002 44.9504 78.7002Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M43.5246 76.3313L43.5196 76.3283C43.5199 76.3283 43.5199 76.3283 43.5202 76.3283C43.5216 76.3293 43.5229 76.3303 43.5246 76.3313ZM43.5196 76.328C43.3529 76.2105 43.2722 76.0397 43.2722 75.8195C43.2722 75.7808 43.2749 75.7404 43.2796 75.6983C43.4439 75.8171 43.5283 75.9853 43.5279 76.2065C43.5276 76.2456 43.5249 76.2859 43.5196 76.328Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M43.5197 76.3284C43.5251 76.2863 43.5278 76.2456 43.5281 76.2066C43.5284 75.9854 43.4441 75.8172 43.2798 75.6984C43.2784 75.6971 43.2767 75.6961 43.2751 75.6951C43.2754 75.6941 43.2754 75.6927 43.2754 75.6917C43.2768 75.672 43.2774 75.653 43.2774 75.6344C43.2787 75.0288 42.6502 75.0454 42.4789 74.5403C42.7657 74.2583 43.0693 73.9744 43.3591 73.6714C43.431 73.596 43.4651 73.5076 43.4648 73.4252C43.4641 73.2837 43.3618 73.1616 43.1753 73.1586C42.8353 73.1532 42.6452 73.1329 42.6455 72.8189C42.6455 72.7228 42.6633 72.5994 42.7004 72.4402C42.7021 72.4329 42.7038 72.4255 42.7051 72.4185C42.7058 72.4158 42.7064 72.4128 42.7071 72.4102C42.8259 71.8616 42.6566 71.545 42.3293 71.5423C42.3279 71.5423 42.3266 71.5423 42.3252 71.5423C42.3242 71.5423 42.3232 71.5423 42.3219 71.5426C42.1803 71.5433 42.01 71.6024 41.8209 71.7258C41.5394 71.9093 41.2904 72.0161 41.0287 72.0168C41.0277 72.0168 41.0267 72.0168 41.0257 72.0168C41.025 72.0168 41.0244 72.0168 41.0237 72.0168C40.941 72.0164 40.857 72.0057 40.7707 71.9837C40.7683 71.9831 40.766 71.9824 40.7636 71.9817C40.7613 71.9811 40.759 71.9807 40.757 71.9801C40.7516 71.9787 40.7466 71.977 40.7412 71.9757C40.8426 71.604 41.0411 71.226 41.0401 70.8606C41.0398 70.6694 40.9845 70.4812 40.8319 70.2994C41.5946 69.4359 42.5311 68.908 43.4186 68.2857C43.6094 68.1432 43.8849 68.0458 43.9759 67.8506C44.4568 66.8216 45.2831 66.3458 46.0833 65.7856C46.086 65.7836 46.0887 65.7819 46.0914 65.7799C46.0937 65.7782 46.0964 65.7766 46.0987 65.7749C46.2098 65.6988 46.2905 65.6638 46.3497 65.6574C46.3561 65.6564 46.3628 65.6561 46.3688 65.6561C46.3692 65.6561 46.3695 65.6561 46.3698 65.6561C46.5529 65.6574 46.5034 65.9711 46.579 66.1296C46.5797 66.1312 46.5803 66.1326 46.581 66.1339C46.582 66.1356 46.5827 66.1373 46.5837 66.1386C46.5884 66.1479 46.5941 66.1569 46.6001 66.165C46.6008 66.166 46.6014 66.1666 46.6021 66.1676C46.6433 66.2213 46.6911 66.2464 46.741 66.247C46.742 66.247 46.7427 66.247 46.7437 66.247C46.7447 66.247 46.746 66.247 46.7473 66.247C46.8213 66.2454 46.8996 66.1913 46.9692 66.0989C46.9692 66.0989 46.9692 66.0989 46.9696 66.0989C46.9753 66.0909 46.9813 66.0825 46.987 66.0742C47.1198 66.2547 47.1898 66.4439 47.1894 66.6411C47.1891 66.8353 47.1202 67.0371 46.9746 67.246C46.821 67.4669 46.6443 67.5353 46.4592 67.5363C46.4579 67.5363 46.4562 67.5363 46.4549 67.5363C46.4542 67.5363 46.4532 67.5363 46.4525 67.5363C46.3621 67.536 46.2698 67.52 46.1774 67.4979C46.1767 67.4979 46.176 67.4979 46.1754 67.4976C46.1714 67.4966 46.1677 67.496 46.1637 67.495C46.1617 67.4943 46.16 67.4939 46.158 67.4933C46.1546 67.4926 46.1513 67.4916 46.1479 67.4909C46.0047 67.4549 45.8628 67.4119 45.7165 67.3898C45.7149 67.3895 45.7132 67.3892 45.7112 67.3888C45.7031 67.3878 45.6951 67.3875 45.6868 67.3875C45.6861 67.3875 45.6858 67.3875 45.6854 67.3875C45.6794 67.3875 45.6734 67.3875 45.6673 67.3882C45.661 67.3885 45.6549 67.3892 45.6486 67.3898C45.6442 67.3902 45.6399 67.3908 45.6355 67.3915C45.6185 67.3942 45.6001 67.3975 45.5807 67.4015C45.5415 67.4095 45.497 67.4199 45.4448 67.4279C45.3829 67.6517 45.3176 67.8933 45.248 68.1339C45.246 68.1412 45.2437 68.1486 45.2416 68.1556C45.1684 68.3958 45.0719 68.4949 44.8464 68.4956C44.8454 68.4956 44.8444 68.4956 44.8434 68.4956C44.843 68.4956 44.8427 68.4956 44.8424 68.4956C44.8166 68.4956 44.7895 68.4943 44.76 68.4919C44.7483 68.4909 44.7366 68.4902 44.7249 68.4902C44.7246 68.4902 44.7246 68.4902 44.7246 68.4902C44.7055 68.4902 44.6864 68.4916 44.6666 68.4939C44.2433 68.5453 43.7115 69.1356 43.8243 69.3518C43.8249 69.3528 43.8256 69.3538 43.8263 69.3551C43.8276 69.3578 43.8293 69.3604 43.8313 69.3631C43.832 69.3645 43.833 69.3658 43.834 69.3671C44.0211 69.619 44.0873 69.8723 44.0877 70.1262C44.0883 70.7055 43.7463 71.2877 43.7128 71.8606C43.7128 71.8626 43.7125 71.8646 43.7125 71.8666C43.7122 71.8726 43.7122 71.8786 43.7122 71.8846C43.7118 72.1312 43.9247 72.3431 44.1593 72.3464C44.1613 72.3464 44.163 72.3464 44.165 72.3464C44.1653 72.3464 44.166 72.3464 44.1663 72.3464C44.2185 72.3464 44.2714 72.3357 44.3236 72.3131C44.328 72.3111 44.3323 72.3091 44.3367 72.3071C44.4799 72.2383 44.6238 72.1579 44.755 72.0581C44.9511 71.9093 45.1365 71.7385 45.3203 71.5827C45.7724 71.7872 46.1181 72.0588 46.1171 72.6144C46.1168 72.6994 46.1085 72.7912 46.0911 72.8903C46.071 73.0057 46.0596 73.1162 46.0596 73.2216C46.0603 73.4535 46.1182 73.6601 46.2701 73.8346C45.821 75.4085 44.9039 76.2389 43.5204 76.3284C43.52 76.3284 43.5201 76.3284 43.5197 76.3284Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M47.6121 78.2869C47.4478 78.1671 47.3644 77.9996 47.3638 77.7834C47.3638 77.7333 47.3678 77.6809 47.3768 77.6259C47.5382 77.7537 47.6208 77.9278 47.6215 78.1504C47.6215 78.1938 47.6185 78.2395 47.6121 78.2869Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M87.3184 75.4802C87.3163 75.4802 87.3144 75.4802 87.312 75.4802C87.1969 75.4796 87.0791 75.4565 86.9613 75.4345C86.9576 75.4338 86.9539 75.4332 86.9502 75.4325C86.9482 75.4322 86.9465 75.4318 86.9445 75.4315C86.9345 75.4295 86.9241 75.4278 86.9141 75.4258L86.9151 75.4212C86.8394 75.1986 86.7641 74.9757 86.6885 74.7532C86.9452 74.4652 87.2019 74.1773 87.4582 73.8893C87.8682 74.1843 88.059 74.4285 88.059 74.6901C88.059 74.8373 87.9988 74.9894 87.8816 75.1596C87.7109 75.4122 87.5198 75.4799 87.3207 75.4802C87.32 75.4802 87.319 75.4802 87.3184 75.4802Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M86.4954 78.1155C86.3485 78.0728 86.2009 78.0301 86.0536 77.9874C85.9144 77.9406 85.7748 77.8946 85.6353 77.8482C85.3113 77.5229 85.1319 77.1081 85.1316 76.5826C85.1316 76.5659 85.1319 76.5486 85.1322 76.5315C85.3625 76.6854 85.5965 76.8335 85.8227 76.995C86.1042 77.1962 86.3796 77.4084 86.6574 77.6163C86.6018 77.7821 86.5473 77.9483 86.4954 78.1155Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M86.9097 78.2756C86.7708 78.2239 86.6326 78.1702 86.4954 78.1152C86.5472 77.948 86.6018 77.7818 86.6573 77.616C86.9381 77.7078 87.2189 77.7998 87.4997 77.8919C87.3588 78.1565 87.1577 78.273 86.9097 78.2756Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M86.9142 75.4211C86.7541 75.2987 86.6743 75.1302 86.6743 74.9166C86.6743 74.8649 86.679 74.8102 86.6883 74.7531C86.7637 74.9757 86.8388 75.1986 86.9142 75.4211Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M65.535 68.5022C65.533 68.5022 65.5307 68.5022 65.5286 68.5022C65.2837 68.5009 65.0631 68.4201 64.9108 68.1205C64.9098 68.1185 64.9088 68.1165 64.9078 68.1145C64.9051 68.1088 64.9021 68.1028 64.8995 68.0971C64.8991 68.0965 64.8988 68.0958 64.8984 68.0951C64.8961 68.0901 64.8938 68.0851 64.8914 68.0801C64.7582 67.7881 64.6013 67.5085 64.5012 67.1982C64.5005 67.1956 64.4995 67.1929 64.4989 67.1902C64.4958 67.1815 64.4932 67.1729 64.4902 67.1645C64.4895 67.1625 64.4885 67.1605 64.4878 67.1585C64.4865 67.1542 64.4848 67.1498 64.4831 67.1455C64.3288 66.7311 64.0216 66.6287 63.6571 66.6277C63.6558 66.6277 63.6541 66.6277 63.6528 66.6277H63.6525C63.6478 66.6277 63.6428 66.6277 63.6381 66.6277C63.6334 66.6277 63.6284 66.628 63.6233 66.628C63.4838 66.63 63.3432 66.6433 63.2026 66.656C63.0688 66.6684 62.9349 66.6797 62.8024 66.68C62.8 66.68 62.798 66.68 62.796 66.68C62.7957 66.68 62.7953 66.68 62.795 66.68C62.7702 66.68 62.7452 66.6797 62.7204 66.6787C62.4614 66.6697 62.2461 66.3624 62.2458 66.0468C62.2458 66.0171 62.2478 65.9874 62.2518 65.958C62.3104 65.5192 62.4359 65.0775 62.4486 64.6454C62.4486 64.642 62.4486 64.6383 62.4486 64.635C62.4496 64.4198 62.2756 64.2216 62.1876 64.0268C61.7859 64.1786 61.71 64.5556 61.5801 64.8793C61.4366 65.2376 61.221 65.4802 60.8914 65.5719C60.7471 65.5229 60.6025 65.4739 60.4579 65.4248C60.4322 65.3057 60.3616 65.1626 60.3623 65.0578C60.3623 65.0338 60.3663 65.0114 60.3753 64.992C60.5463 64.6307 61.053 64.5723 61.0681 63.9203C60.6394 63.7772 60.1751 63.6217 59.7109 63.4665C59.9007 63.3544 60.0881 63.1772 60.2802 63.1429C60.7682 63.0554 61.2582 63.0324 61.7478 62.9834C61.7662 62.9867 61.7843 62.9884 61.802 62.9887C61.8024 62.9887 61.8027 62.9887 61.803 62.9887C61.8047 62.9887 61.8064 62.9887 61.808 62.9884C61.9335 62.9864 62.044 62.9023 62.1524 62.8089C62.1621 62.8005 62.1718 62.7922 62.1812 62.7835C62.1846 62.7809 62.1876 62.7782 62.1909 62.7752C62.1919 62.7745 62.1929 62.7735 62.1936 62.7728C62.1993 62.7678 62.205 62.7631 62.2103 62.7581C62.3275 62.6564 62.4453 62.5586 62.5812 62.557C62.5822 62.557 62.5835 62.557 62.5845 62.557C62.5852 62.557 62.5858 62.557 62.5868 62.557C62.628 62.5573 62.6712 62.5666 62.7167 62.5877C62.718 62.5883 62.7197 62.589 62.721 62.5897C62.7251 62.5913 62.7287 62.5933 62.7327 62.5953C62.7341 62.6013 62.7354 62.6073 62.7368 62.613C62.7371 62.6147 62.7374 62.616 62.7378 62.6173C62.7441 62.6454 62.7502 62.6727 62.7562 62.6994C62.7562 62.7004 62.7565 62.7014 62.7569 62.7024C62.9265 63.4598 62.9965 63.7031 63.3419 63.7038C63.3422 63.7038 63.3429 63.7038 63.3432 63.7038C63.3553 63.7038 63.3676 63.7034 63.3807 63.7028C63.5209 63.6964 63.704 63.6557 63.9503 63.5963C63.952 63.596 63.9533 63.5956 63.955 63.595C63.9851 63.5876 64.0166 63.5803 64.0487 63.5723C64.0658 63.568 64.0832 63.564 64.1009 63.5596C64.1039 63.559 64.1066 63.5583 64.1093 63.5576C64.1116 63.557 64.1136 63.5566 64.1156 63.5559C64.1177 63.5556 64.1196 63.5553 64.1217 63.5546C64.122 63.5546 64.1227 63.5546 64.1234 63.5543C64.1655 63.5453 64.2087 63.5413 64.2522 63.541C64.2529 63.541 64.2535 63.541 64.2539 63.541C64.2565 63.541 64.2589 63.541 64.2612 63.541C64.3941 63.5426 64.5307 63.58 64.6562 63.626C64.6699 63.631 64.6836 63.636 64.697 63.6414C64.6973 63.6414 64.698 63.6417 64.6987 63.642C64.7077 63.6454 64.7167 63.6491 64.7254 63.6524C64.9855 63.7565 65.2228 63.92 65.441 64.0418C65.4614 64.1008 65.4701 64.1559 65.4701 64.2076C65.4687 64.5596 65.0571 64.7728 65.0578 65.1168C65.0578 65.1555 65.0631 65.1963 65.0748 65.239C65.1826 65.6277 65.2535 66.0501 65.6023 66.254C65.699 66.1268 65.8801 65.981 65.8797 65.8816C65.8797 65.8793 65.8797 65.8769 65.8794 65.8746C65.8737 65.8105 65.871 65.7501 65.871 65.6931C65.872 64.9814 66.3168 64.7915 66.8583 64.6954L66.859 64.7285C66.6873 65.2316 66.5153 65.7351 66.3433 66.2383C66.3001 66.6444 66.2606 67.0504 66.2127 67.4565C66.1736 67.7822 66.1247 68.1081 66.0802 68.4338C66.0601 68.4368 66.0401 68.4401 66.02 68.4435C65.8567 68.4705 65.6923 68.5019 65.5377 68.5022C65.5367 68.5022 65.5357 68.5022 65.535 68.5022Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M65.6022 66.2539C65.2535 66.05 65.1826 65.6276 65.0748 65.2389C65.0631 65.1962 65.0577 65.1555 65.0577 65.1168C65.0571 64.7728 65.4687 64.5596 65.47 64.2075C65.47 64.1558 65.4614 64.1008 65.4409 64.0417C65.2227 63.9199 64.9854 63.7564 64.7254 63.6523C64.7167 63.649 64.7076 63.6453 64.6986 63.642C64.6979 63.6416 64.6973 63.6413 64.6969 63.6413C64.6836 63.636 64.6698 63.631 64.6561 63.626C64.5306 63.5799 64.3941 63.5426 64.2612 63.5409C64.2589 63.5409 64.2565 63.5409 64.2538 63.5409C64.2535 63.5409 64.2528 63.5409 64.2521 63.5409C64.2086 63.5412 64.1655 63.5452 64.1233 63.5542C64.1226 63.5546 64.1219 63.5545 64.1216 63.5545C64.1196 63.5552 64.1176 63.5555 64.1156 63.5559C64.1136 63.5565 64.1116 63.5569 64.1093 63.5576C64.1066 63.5582 64.1039 63.5589 64.1009 63.5596C64.0832 63.5639 64.0657 63.5679 64.0487 63.5722C64.0165 63.5802 63.9851 63.5876 63.955 63.5949C63.9533 63.5956 63.952 63.5959 63.9503 63.5963C63.704 63.6556 63.5209 63.6964 63.3806 63.7027C63.3676 63.7034 63.3552 63.7037 63.3432 63.7037C63.3428 63.7037 63.3422 63.7037 63.3418 63.7037C62.9964 63.703 62.9265 63.4598 62.7568 62.7024C62.7565 62.7014 62.7561 62.7004 62.7561 62.6994C62.7501 62.6727 62.7441 62.6453 62.7377 62.6173C62.7374 62.616 62.7371 62.6146 62.7367 62.613C62.7354 62.6073 62.734 62.6013 62.7327 62.5953C62.7287 62.5933 62.725 62.5913 62.721 62.5896C62.7197 62.5889 62.718 62.5883 62.7167 62.5876C62.6711 62.5666 62.628 62.5572 62.5868 62.5569C62.5858 62.5569 62.5851 62.5569 62.5844 62.5569C62.5834 62.5569 62.5821 62.5569 62.5811 62.5569C62.4452 62.5586 62.3274 62.6563 62.2103 62.7581C62.2049 62.7631 62.1992 62.7678 62.1936 62.7728C62.1929 62.7734 62.1919 62.7745 62.1909 62.7751C62.1875 62.7781 62.1845 62.7808 62.1812 62.7835C62.1718 62.7921 62.1621 62.8005 62.1524 62.8088C62.0439 62.9022 61.9335 62.9863 61.808 62.9883C61.8063 62.9887 61.8047 62.9887 61.803 62.9887C61.8027 62.9887 61.8023 62.9887 61.802 62.9887C61.7842 62.9883 61.7662 62.9866 61.7478 62.9833C61.8113 62.7955 61.8619 62.631 61.8616 62.4898C61.8609 62.2903 61.7578 62.1375 61.4442 62.032C61.2176 61.9563 61.1145 61.8205 61.1135 61.6653C61.1125 61.4918 61.239 61.2946 61.4636 61.1295C61.4736 61.1221 61.4837 61.1148 61.4937 61.1075C61.4988 61.1038 61.5041 61.1001 61.5095 61.0961C61.5158 61.0918 61.5222 61.0871 61.5285 61.0824C61.9844 60.7581 62.4359 60.5486 62.877 60.5472C62.8783 60.5472 62.8793 60.5472 62.8807 60.5472C63.1805 60.5472 63.4757 60.644 63.7642 60.8666C63.7729 60.8732 63.7819 60.8802 63.7906 60.8876C64.0075 61.0607 64.0969 61.4305 64.2632 61.6934C64.2635 61.6937 64.2635 61.6937 64.2638 61.6937C64.2642 61.6937 64.2642 61.6937 64.2642 61.6937C64.2816 61.6937 64.5089 61.5606 64.5738 61.4468C64.5768 61.4414 64.5795 61.4365 64.5818 61.4311C64.6427 61.2926 64.6688 61.1732 64.6688 61.0671C64.6688 60.7735 64.469 60.5813 64.2511 60.3697C64.0249 60.1495 63.9235 59.986 63.9238 59.8182C63.9242 59.668 64.0058 59.5145 64.1524 59.314C64.6163 58.6797 65.2709 58.2206 65.529 57.3968C65.7522 57.6647 65.9751 57.9326 66.1983 58.2006C66.1515 58.3677 66.1016 58.5346 66.0484 58.7001C65.7264 58.9293 65.4041 59.1589 65.0798 59.3901C65.1568 59.7421 65.2585 60.0581 65.2883 60.3924C65.291 60.4231 65.2923 60.4538 65.2923 60.4848C65.2923 60.7027 65.2348 60.936 65.2043 61.1609C65.1431 61.6123 65.1026 61.9376 65.1029 62.1852C65.1032 62.7768 65.3358 62.9249 66.0745 63.2936C66.2703 63.3914 66.4918 63.4391 66.6715 63.5629C66.8804 63.7067 66.9483 63.9082 66.948 64.1351C66.9476 64.3116 66.9065 64.5035 66.8583 64.6954C66.3168 64.7915 65.872 64.9813 65.871 65.693C65.871 65.7501 65.8737 65.8105 65.8794 65.8745C65.8797 65.8769 65.8797 65.8792 65.8797 65.8815C65.88 65.981 65.699 66.1268 65.6022 66.2539Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M58.8205 68.875C58.3435 68.7075 57.8054 68.6441 57.6956 67.9134C57.6792 67.8063 57.5534 67.6668 57.454 67.6368C57.4413 67.6331 57.4292 67.6311 57.4178 67.6311C57.4175 67.6311 57.4175 67.6311 57.4172 67.6311C57.4142 67.6311 57.4111 67.6314 57.4081 67.6318C57.37 67.6358 57.3335 67.6378 57.299 67.6378H57.2987C57.298 67.6378 57.2973 67.6378 57.2967 67.6378C56.6822 67.6364 56.6605 67.0025 56.4945 66.516C56.4687 66.4419 56.4061 66.3892 56.3603 66.3268C56.9684 65.777 57.6879 65.9147 58.3368 65.6355C58.533 65.551 58.6976 65.3272 58.8924 65.1523C58.8864 65.145 58.88 65.138 58.8737 65.1306C58.5735 64.7916 58.2572 64.6598 57.9175 64.6592C57.9169 64.6592 57.9158 64.6592 57.9148 64.6592C57.9138 64.6592 57.9128 64.6592 57.9115 64.6592C57.6354 64.6598 57.3439 64.7469 57.0329 64.8794C57.0303 64.8804 57.0276 64.8814 57.0249 64.8827C57.0182 64.8854 57.0115 64.8884 57.0048 64.8914C56.9968 64.8947 56.9885 64.8984 56.9804 64.9017C56.8355 64.9608 56.6939 64.9891 56.5584 64.9891C56.558 64.9891 56.5577 64.9895 56.557 64.9895C56.556 64.9895 56.555 64.9891 56.554 64.9891C56.0022 64.9875 55.555 64.5197 55.4184 63.793C55.4141 63.7703 55.4121 63.7459 55.4121 63.7206C55.4128 63.5824 55.4724 63.4096 55.5413 63.2878C55.5436 63.2838 55.5456 63.2798 55.548 63.2758C55.6303 63.1363 55.7244 63.0796 55.8211 63.0786C55.8221 63.0786 55.8228 63.0786 55.8238 63.0786C55.8251 63.0786 55.8264 63.0786 55.8278 63.0786C55.9074 63.0799 55.9881 63.1186 56.0651 63.1797C56.0741 63.1867 56.0831 63.1944 56.0918 63.202C56.2635 63.3509 56.4165 63.527 56.5908 63.6712C56.5922 63.6725 56.5935 63.6735 56.5952 63.6748C56.5969 63.6765 56.5989 63.6778 56.6009 63.6795C56.6035 63.6818 56.6062 63.6842 56.6089 63.6862C56.6109 63.6879 56.6126 63.6892 56.6143 63.6909C56.619 63.6945 56.6233 63.6982 56.628 63.7019C56.6327 63.7059 56.6377 63.7099 56.6427 63.7142C56.644 63.7152 56.6451 63.7159 56.6461 63.7169C56.6481 63.7185 56.6497 63.7199 56.6518 63.7216C56.7488 63.8007 56.8696 63.8927 56.9336 63.8927H56.9339C56.9436 63.8927 56.952 63.8904 56.9587 63.8857C56.9593 63.8851 56.96 63.8847 56.9606 63.884C56.968 63.878 56.9754 63.8721 56.9831 63.8661C57.3107 63.6028 57.6163 63.5103 57.9105 63.5097C57.9115 63.5097 57.9128 63.5097 57.9138 63.5097C57.9148 63.5097 57.9162 63.5097 57.9172 63.5097C58.3051 63.5103 58.6725 63.6702 59.0424 63.8063C59.1635 63.851 59.2853 63.8931 59.4078 63.9261C59.4102 63.9268 59.4129 63.9274 59.4152 63.9281C59.4182 63.9288 59.4212 63.9298 59.4242 63.9304C59.4299 63.9318 59.4356 63.9334 59.441 63.9348C59.444 63.9354 59.447 63.9361 59.4497 63.9371C59.453 63.9378 59.456 63.9384 59.459 63.9394C59.462 63.9401 59.465 63.9408 59.4677 63.9415C59.4684 63.9415 59.4687 63.9418 59.4691 63.9418C59.4744 63.9431 59.4794 63.9445 59.4845 63.9455C59.4858 63.9458 59.4871 63.9461 59.4885 63.9464C59.5009 63.9491 59.5129 63.9521 59.5253 63.9548C59.5625 64.3832 59.5805 64.8177 59.6404 65.2384C59.6776 65.501 59.7432 65.6224 59.9028 65.6231C59.9031 65.6231 59.9038 65.6231 59.9041 65.6231C59.9155 65.6231 59.9276 65.6224 59.94 65.6214C60.0357 65.6118 60.1615 65.5661 60.3285 65.4877C60.3359 65.4843 60.3432 65.4806 60.3506 65.4773C60.3536 65.4756 60.3566 65.4743 60.3597 65.473C60.3617 65.472 60.3637 65.471 60.3657 65.47C60.3687 65.4686 60.3717 65.467 60.3747 65.4656C60.3761 65.465 60.3771 65.4646 60.3781 65.464C60.3801 65.463 60.3817 65.4623 60.3834 65.4613C60.3874 65.4596 60.3911 65.4576 60.3951 65.4556C60.3985 65.454 60.4018 65.4523 60.4055 65.4506C60.4095 65.4486 60.4139 65.4466 60.4179 65.4443C60.4226 65.4423 60.4273 65.4399 60.432 65.4376C60.4403 65.4333 60.449 65.4289 60.4577 65.4246C60.6023 65.4736 60.7469 65.5227 60.8911 65.5717C60.8028 65.8156 60.7338 66.0709 60.6214 66.3014C60.6144 66.3155 60.6076 66.3291 60.601 66.3428C60.5996 66.3455 60.5979 66.3485 60.5966 66.3515C60.4326 66.6795 60.3278 66.8036 60.1317 66.8043C60.1314 66.8043 60.1307 66.8043 60.1301 66.8043C60.128 66.8043 60.1257 66.8043 60.1234 66.8043C60.0377 66.803 59.9343 66.7789 59.8017 66.7389C59.7914 66.7356 59.781 66.7322 59.7703 66.7289C59.7663 66.7279 59.7622 66.7265 59.7579 66.7252C59.7549 66.7242 59.7519 66.7232 59.7485 66.7222C59.7442 66.7209 59.7398 66.7195 59.7355 66.7182C59.6257 66.6845 59.5276 66.6672 59.4413 66.6665C59.4399 66.6665 59.4386 66.6665 59.4373 66.6665C59.4363 66.6665 59.4356 66.6665 59.4346 66.6665C59.1176 66.6678 58.9587 66.8987 58.945 67.3865C58.944 67.4129 58.9436 67.4389 58.9436 67.4653C58.9433 67.7746 58.9885 68.0795 59.0102 68.3869C58.948 68.55 58.8847 68.7128 58.8205 68.875Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M59.9042 65.6233C59.9039 65.6233 59.9032 65.6233 59.9029 65.6233C59.7432 65.6226 59.6777 65.5012 59.6405 65.2386C59.5806 64.8178 59.5625 64.3834 59.5254 63.955C59.5816 63.7898 59.6435 63.627 59.7108 63.4665C60.175 63.6216 60.6392 63.7771 61.0679 63.9203C61.0529 64.5722 60.5461 64.6306 60.3751 64.992C60.3661 65.0114 60.3621 65.0337 60.3621 65.0578C60.3614 65.1625 60.432 65.3057 60.4578 65.4248C60.4491 65.4291 60.4404 65.4335 60.432 65.4378C60.4273 65.4401 60.4227 65.4425 60.418 65.4445C60.414 65.4468 60.4096 65.4488 60.4056 65.4508C60.4019 65.4525 60.3985 65.4541 60.3952 65.4558C60.3912 65.4578 60.3875 65.4598 60.3835 65.4615C60.3818 65.4625 60.3801 65.4631 60.3781 65.4641C60.3771 65.4648 60.3761 65.4651 60.3748 65.4658C60.3718 65.4671 60.3688 65.4688 60.3657 65.4701C60.3637 65.4711 60.3617 65.4721 60.3597 65.4731C60.3567 65.4745 60.3537 65.4758 60.3507 65.4775C60.3433 65.4808 60.336 65.4845 60.3286 65.4878C60.1619 65.5662 60.0358 65.612 59.94 65.6216C59.9277 65.6226 59.9156 65.6233 59.9042 65.6233Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M56.5277 61.1875C56.527 61.1875 56.526 61.1875 56.5253 61.1875C56.4748 61.1872 56.4286 61.1792 56.3924 61.1541C56.2415 61.049 56.1371 60.8625 56.0293 60.7307C56.0879 60.5892 56.1043 60.5045 56.1488 60.4541C56.1521 60.4508 56.1551 60.4474 56.1588 60.4438C56.1602 60.4424 56.1619 60.4408 56.1635 60.4394C56.1722 60.4311 56.1819 60.4227 56.1923 60.4147C56.1946 60.4131 56.1967 60.4114 56.1987 60.4101C56.2288 60.3877 56.2626 60.3683 56.2887 60.3607C56.2934 60.3593 56.2981 60.3583 56.3021 60.358C56.3044 60.3577 56.3064 60.3577 56.3084 60.3577C56.3088 60.3577 56.3095 60.3577 56.3098 60.3577C56.3155 60.3577 56.3202 60.359 56.3238 60.362C56.4865 60.4905 56.6532 60.6233 56.7787 60.7951C56.7991 60.8231 56.8054 60.8658 56.8051 60.9145C56.8051 60.9933 56.7887 61.0887 56.7887 61.1671C56.7884 61.1671 56.788 61.1671 56.7877 61.1671C56.785 61.1671 56.7823 61.1671 56.78 61.1671C56.7529 61.1675 56.7251 61.1698 56.6967 61.1728C56.6839 61.1741 56.6709 61.1758 56.6582 61.1771C56.6531 61.1778 56.6485 61.1785 56.6438 61.1788C56.6056 61.1832 56.5675 61.1872 56.5317 61.1875C56.5303 61.1875 56.529 61.1875 56.5277 61.1875Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M51.8697 61.4114C51.5243 61.2832 51.2006 61.1294 51.1873 60.6163L51.197 60.6066C51.5417 60.7344 51.8673 60.8838 51.8777 61.3994L51.8697 61.4114Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M70.0038 65.1692C69.9127 64.9623 69.8223 64.7554 69.7313 64.5486C69.9074 64.1558 70.0171 63.7895 70.0165 63.4655C70.0151 63.0214 69.8059 62.6567 69.2725 62.4128C69.0302 62.609 68.7862 62.8519 68.5134 63.0184C68.5051 63.0237 68.4967 63.0287 68.4883 63.0337C68.4863 63.0351 68.484 63.036 68.482 63.0374C68.2463 63.1769 68.0352 63.248 67.8454 63.249C67.8437 63.249 67.8421 63.249 67.8407 63.249C67.8397 63.249 67.8391 63.249 67.8381 63.249C67.5141 63.248 67.251 63.0424 67.0308 62.6253C67.0285 62.6207 67.0261 62.616 67.0238 62.6113C67.0194 62.6033 67.0151 62.595 67.0111 62.5866C66.9077 62.3831 66.9076 62.1008 66.8601 61.8546C67.0348 61.332 67.2092 60.8095 67.3839 60.2873L67.3886 60.286C67.49 60.3931 67.5914 60.5012 67.6931 60.6077C67.6995 60.6143 67.7058 60.6207 67.7119 60.6267C67.7125 60.627 67.7129 60.6273 67.7132 60.6277C67.7149 60.6297 67.7169 60.6313 67.7189 60.633C67.7909 60.7014 67.8648 60.7404 67.9385 60.7418C67.9398 60.7418 67.9408 60.7418 67.9421 60.7418C67.9438 60.7418 67.9451 60.7418 67.9465 60.7418C68.0325 60.7401 68.1175 60.6861 68.1975 60.566C68.1992 60.5636 68.2005 60.5613 68.2022 60.5589C68.2029 60.5579 68.2035 60.5569 68.2042 60.5559C68.2072 60.5509 68.2105 60.5459 68.2136 60.5409C68.3012 60.3985 68.3468 60.2246 68.4114 60.0651L68.4103 60.0474C68.4157 60.0488 68.4211 60.0501 68.4264 60.0514C68.5646 60.0865 68.7035 60.1202 68.8381 60.1208C68.8387 60.1208 68.8394 60.1208 68.8404 60.1208C68.8421 60.1208 68.8434 60.1208 68.8451 60.1208C69.0419 60.1195 69.229 60.0451 69.3916 59.7948C69.4017 59.7795 69.4117 59.7635 69.4217 59.7465C69.8237 59.0628 70.244 58.4058 70.9392 58.0928C71.1182 58.5223 71.2973 58.952 71.4763 59.3814C71.3662 59.4855 71.1775 59.583 71.1587 59.6954C71.1356 59.8366 71.1242 59.9673 71.1242 60.0881C71.1236 60.8516 71.565 61.2216 72.2374 61.3697C72.2725 61.6063 72.2578 61.8799 72.3519 62.0728C72.4861 62.3467 72.5409 62.622 72.5406 62.8989C72.5406 63.3307 72.4064 63.7668 72.229 64.2092C72.0004 64.1198 71.7082 64.0361 71.7089 63.7418C71.7089 63.7014 71.7146 63.6567 71.7267 63.6076C71.7638 63.4575 71.7923 63.3257 71.7926 63.2159C71.7929 63.0387 71.72 62.9196 71.4921 62.8746C71.4268 62.8619 71.3655 62.8552 71.3073 62.8552C71.3066 62.8552 71.3063 62.8552 71.306 62.8552C71.305 62.8552 71.3043 62.8552 71.3033 62.8552C70.9971 62.8562 70.7825 63.0367 70.6262 63.4198C70.6229 63.4278 70.6199 63.4358 70.6165 63.4441C70.6162 63.4451 70.6155 63.4461 70.6152 63.4471C70.6132 63.4528 70.6108 63.4588 70.6085 63.4645C70.394 64.0274 70.2042 64.6006 70.0038 65.1692Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M67.384 60.2874C67.2455 60.2436 67.1056 60.2046 66.964 60.1702C66.8743 59.9574 66.7247 59.7585 66.707 59.5283C66.6688 59.0281 66.382 58.8503 66.0483 58.7001C66.1016 58.5346 66.1514 58.3678 66.1983 58.2006C66.4088 57.8563 66.6206 57.5136 66.8288 57.1679C66.9958 56.8907 67.1581 56.6097 67.3225 56.3298C67.4674 56.3448 67.6106 56.3665 67.7528 56.3948C67.9195 56.8376 68.1561 57.2564 68.2335 57.7298C68.3061 58.1769 68.8754 58.0371 68.8774 58.4522C68.8774 58.4799 68.875 58.5099 68.8697 58.543C68.8021 58.9664 68.6284 59.3811 68.5005 59.7995C68.4748 59.8833 68.4406 59.9647 68.4105 60.0475L68.4115 60.0651C68.4082 60.0641 68.4048 60.0628 68.4015 60.0618C68.2562 60.0178 68.1116 59.9797 67.9694 59.9794C67.9681 59.9791 67.967 59.9791 67.9657 59.9791C67.9644 59.9791 67.9627 59.9791 67.961 59.9791C67.7696 59.9804 67.5822 60.0508 67.4038 60.2677C67.4021 60.2693 67.4008 60.2713 67.3991 60.2733C67.3974 60.275 67.3961 60.277 67.3948 60.2787C67.3928 60.2814 67.3907 60.2837 67.3887 60.286L67.384 60.2874Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M72.5919 60.3281C72.2331 59.9935 71.9908 59.4846 71.4764 59.3812C71.2973 58.9518 71.1183 58.522 70.9392 58.0926C70.976 58.0115 71.0038 57.9227 71.0513 57.8507C71.0611 57.8356 71.0708 57.821 71.0805 57.8063C71.0848 57.7999 71.0892 57.7933 71.0932 57.7869C71.3261 57.4362 71.4549 57.2748 71.6002 57.2734C71.6009 57.2734 71.6016 57.2734 71.6022 57.2734C71.6049 57.2734 71.6079 57.2734 71.6109 57.2738C71.7264 57.2788 71.8542 57.3832 72.053 57.5727C72.0544 57.5737 72.0554 57.5747 72.0564 57.576C72.0591 57.5784 72.0617 57.5807 72.0641 57.5834C72.0751 57.5937 72.0862 57.6044 72.0975 57.6151C72.2063 57.7198 72.3091 57.8333 72.4152 57.9424C72.4536 58.1026 72.4493 58.3134 72.538 58.4145C72.7669 58.6751 72.8529 58.9564 72.8532 59.251C72.8536 59.5954 72.7364 59.9581 72.5922 60.3278C72.5919 60.3278 72.5919 60.3278 72.5919 60.3278C72.5919 60.3281 72.5919 60.3281 72.5919 60.3281Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M79.995 62.2246C79.7132 62.1342 79.4311 62.0431 79.1489 61.9523C79.2105 61.7912 79.2727 61.6304 79.3353 61.4695C79.75 61.3531 79.9424 60.9787 80.1078 60.5726C80.2503 60.6003 80.3949 60.6177 80.5412 60.6247C80.3591 61.1579 80.177 61.6914 79.995 62.2246Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M81.2228 71.2136C81.0816 71.1656 80.9397 71.1172 80.7981 71.0688C80.8878 70.8449 80.9537 70.626 80.9544 70.4212C80.9547 70.2196 80.8911 70.0318 80.7241 69.8663C80.8443 69.5183 80.9648 69.1699 81.0849 68.8222C81.271 68.6714 81.4571 68.5209 81.6431 68.3705C81.679 68.8076 81.7144 69.2447 81.7502 69.6818C81.5745 70.1926 81.3988 70.7031 81.2228 71.2136Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M80.7132 68.7258C80.3263 68.6488 79.984 68.5156 79.9773 67.9577C80.1376 68.0025 80.2979 68.0468 80.4582 68.0912C80.5432 68.3028 80.6282 68.5143 80.7132 68.7258Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M87.6707 73.3215C87.8413 72.775 87.8648 72.1053 88.5442 71.9712C88.3333 72.4867 88.3266 73.1664 87.6707 73.3215Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M69.1705 83.1772C68.9111 83.0718 68.6524 82.966 68.393 82.8603C68.4041 82.7044 68.4238 82.5446 68.4238 82.3935C68.4235 82.1536 68.3726 81.9347 68.1564 81.7848C68.0289 81.6961 67.9024 81.654 67.7772 81.6534C67.7762 81.6534 67.7752 81.653 67.7742 81.653C67.7725 81.653 67.7712 81.6534 67.7695 81.6534C67.5734 81.6547 67.38 81.7581 67.1882 81.9453C67.1828 81.947 67.1778 81.949 67.1724 81.9507C67.1637 81.9537 67.1551 81.957 67.1464 81.9603C67.1453 81.9607 67.144 81.961 67.143 81.9617C67.1406 81.9627 67.1383 81.9634 67.136 81.9644C67.1323 81.9657 67.1289 81.9674 67.1252 81.9687C67.1219 81.97 67.1182 81.9717 67.1149 81.973C67.1132 81.9737 67.1115 81.9744 67.1102 81.9754C67.0215 82.0137 66.9358 82.0668 66.8515 82.1265C66.5272 82.3568 66.224 82.6884 65.8531 82.6901C65.8521 82.6901 65.8511 82.6901 65.8501 82.6901C65.7531 82.6901 65.651 82.6674 65.5432 82.6143C65.5399 82.6127 65.5366 82.6113 65.5329 82.6093L65.5409 82.6043C65.6245 82.2686 65.6774 82.0561 65.6778 81.9033C65.6781 81.6397 65.5222 81.554 65.0978 81.3201C65.0175 81.0782 64.9378 80.8369 64.8582 80.5953C64.9017 80.4308 64.9559 80.27 65.0208 80.1128C65.0241 80.1135 65.0275 80.1142 65.0309 80.1149C65.062 80.1225 65.0934 80.1342 65.1246 80.1435C65.1323 80.1459 65.1399 80.1479 65.1476 80.1499C65.1657 80.1542 65.1838 80.1572 65.2019 80.1576C65.2029 80.1576 65.2039 80.1576 65.2045 80.1576C65.2049 80.1576 65.2052 80.1576 65.2055 80.1576C65.2159 80.1576 65.226 80.1566 65.236 80.1545C65.2521 80.1509 65.2681 80.1476 65.2842 80.1442C65.2845 80.1442 65.2849 80.1442 65.2852 80.1439C65.321 80.1366 65.3562 80.1289 65.3906 80.1215C65.3953 80.1209 65.4 80.1199 65.4047 80.1189C65.4064 80.1185 65.408 80.1179 65.4097 80.1175C65.415 80.1165 65.4201 80.1155 65.4251 80.1145C65.4398 80.1112 65.4546 80.1082 65.4689 80.1052C65.4709 80.1049 65.4726 80.1042 65.4746 80.1038C65.477 80.1035 65.479 80.1032 65.481 80.1025C65.4867 80.1015 65.4927 80.1002 65.4984 80.0988C65.5051 80.0975 65.5118 80.0962 65.5185 80.0948C66.1697 79.9577 66.5359 79.888 66.8505 79.8866C66.8531 79.8866 66.8562 79.8866 66.8588 79.8866C66.8595 79.8866 66.8602 79.8866 66.8609 79.8866C67.1942 79.887 67.4716 79.9647 67.9743 80.1219C67.9773 80.1229 67.9804 80.1239 67.983 80.1249C67.9864 80.1259 67.9901 80.1269 67.9934 80.1279C68.0014 80.1305 68.0095 80.1329 68.0179 80.1356C68.0319 80.1399 68.0466 80.1446 68.0614 80.1492C68.0634 80.1499 68.0654 80.1506 68.0674 80.1512C68.0694 80.1519 68.071 80.1522 68.0731 80.1529C68.0797 80.1549 68.0861 80.1569 68.0928 80.1592C68.0975 80.1606 68.1022 80.1622 68.1072 80.1636C68.1136 80.1656 68.1196 80.1676 68.1259 80.1696C68.9764 79.5947 69.298 78.4619 70.0396 77.7722C70.2367 77.6497 70.4342 77.5273 70.6313 77.4052C70.7739 77.4526 70.9162 77.4999 71.0584 77.5476C71.3887 77.7985 71.546 78.2724 72.0564 78.3077C72.3978 78.3318 72.6173 78.7238 72.6183 79.1265C72.6187 79.2724 72.5902 79.4195 72.5289 79.551C72.3509 79.932 72.0969 80.2724 71.8763 80.6307C71.7391 80.6087 71.6033 80.5823 71.468 80.5519C71.2274 80.578 71.1146 80.6541 71.1149 80.7742C71.1153 80.8563 71.1685 80.959 71.2699 81.0805C71.214 81.2456 71.1615 81.4118 71.1119 81.5793C71.0554 81.7425 70.9988 81.9053 70.9419 82.0685C70.802 82.0324 70.6631 81.9917 70.5256 81.946C70.4151 81.3384 70.305 80.7308 70.1946 80.1229C70.5349 80.0535 70.7709 79.8176 70.8573 79.4362C70.8629 79.4125 70.8653 79.3881 70.8653 79.3634C70.8656 79.2373 70.8054 79.1005 70.7813 78.9704C70.718 79.0201 70.625 79.0555 70.5955 79.1219C70.4513 79.4479 70.3238 79.7822 70.1902 80.1135C70.1872 80.1125 70.1842 80.1115 70.1809 80.1105C70.0584 80.0715 69.9449 80.0528 69.8388 80.0525C69.8381 80.0525 69.8378 80.0525 69.8371 80.0525C69.8345 80.0525 69.8318 80.0525 69.8291 80.0525C69.3391 80.0568 69.0158 80.4559 68.7652 81.0261C68.7645 81.0281 68.7635 81.0298 68.7628 81.0318C68.7575 81.0441 68.7518 81.0568 68.7464 81.0695C68.7451 81.0728 68.7437 81.0758 68.7424 81.0791C68.7441 81.0838 68.7461 81.0888 68.7478 81.0935C68.7491 81.0978 68.7508 81.1018 68.7521 81.1062C68.7565 81.1179 68.7608 81.1295 68.7655 81.1412C69.0025 81.7628 69.3713 82.0845 69.8813 82.0858C69.8823 82.0858 69.8833 82.0858 69.8843 82.0858C69.8853 82.0858 69.886 82.0858 69.8867 82.0858C70.0714 82.0855 70.2742 82.0431 70.4961 81.9584C70.5055 81.9547 70.5149 81.951 70.5242 81.9473C70.2876 82.6978 69.8509 83.1305 69.1705 83.1772Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M65.1001 83.2097C65.0994 83.2097 65.0985 83.2097 65.0978 83.2097C65.0114 83.2087 64.9361 83.138 64.8866 83.0262C64.8859 83.0249 64.8853 83.0235 64.8846 83.0222C64.8829 83.0182 64.8812 83.0138 64.8796 83.0098C64.7996 82.8133 64.7915 82.5698 64.7517 82.3472C65.0148 82.4326 65.2778 82.5184 65.5409 82.6041L65.5329 82.6091C65.4673 82.7569 65.4214 82.9228 65.3324 83.0489C65.3304 83.0512 65.3287 83.0539 65.3267 83.0566C65.3234 83.0612 65.32 83.0656 65.3166 83.0699C65.243 83.166 65.1701 83.2084 65.1035 83.2097C65.1021 83.2097 65.1011 83.2097 65.1001 83.2097Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M64.7299 76.603C64.5987 76.5506 64.4631 76.5069 64.3363 76.4449C63.8922 76.2266 63.7449 76.1576 63.7449 75.8226C63.7449 75.6644 63.7777 75.4475 63.8276 75.1279C63.8848 74.9604 63.9423 74.7932 64.0009 74.6261C64.283 74.7158 64.5652 74.8059 64.847 74.8957C65.7295 74.5243 65.7928 74.4969 65.7928 73.8713C65.7928 73.8213 65.7925 73.7672 65.7921 73.7088C65.7911 73.5867 65.7904 73.4646 65.7904 73.3421C65.7904 73.0295 65.7941 72.7162 65.8055 72.4029C65.8075 72.3491 65.9069 72.261 65.9708 72.2353C65.9742 72.234 65.9775 72.2327 65.9809 72.2317C65.9949 72.2274 66.0103 72.225 66.026 72.2247C66.0274 72.2247 66.0287 72.2247 66.0297 72.2247C66.0314 72.2247 66.0327 72.2247 66.0344 72.2247C66.0756 72.2257 66.1188 72.2387 66.1519 72.259C66.1559 72.2614 66.1596 72.2641 66.1629 72.2664C66.5424 72.54 66.7918 72.908 66.8547 73.4709C66.8631 73.5453 66.9103 73.5793 66.9725 73.5797C66.9729 73.5797 66.9735 73.5797 66.9739 73.5797C66.9792 73.5797 66.9846 73.5794 66.9899 73.579C67.0676 73.5724 67.1633 73.5179 67.2342 73.4282C67.2353 73.4265 67.2366 73.4252 67.2376 73.4235C67.2396 73.4212 67.2413 73.4189 67.2429 73.4165C67.7774 73.3321 67.9688 72.7469 68.3785 72.4182C68.3541 71.7662 68.3229 71.165 68.3146 70.5607C68.3146 70.558 68.3146 70.5553 68.3146 70.5527C68.3142 70.3868 68.3758 70.211 68.4116 70.0405C68.4143 70.0281 68.4173 70.0158 68.4203 70.0038C68.421 70.0015 68.4217 69.9995 68.4224 69.9971C68.5264 69.6187 68.9334 69.2987 69.2728 69.2897C69.2778 69.2894 69.2825 69.2894 69.2875 69.2894C69.3614 69.2894 69.4321 69.3048 69.4953 69.3378C69.756 69.4746 69.9799 69.7399 70.2554 69.7842C70.8966 69.8883 71.5589 69.8933 72.2129 69.9387C71.9833 70.4896 71.8829 71.1372 71.2313 71.3374C71.0342 71.3978 70.8534 71.6224 70.6767 71.7892C70.6724 71.7932 70.668 71.7972 70.664 71.8016C70.587 71.878 70.5087 71.9904 70.4348 72.0825C70.4321 72.0859 70.4297 72.0892 70.4271 72.0922C70.425 72.0945 70.4234 72.0969 70.4217 72.0989C70.4173 72.1042 70.413 72.1092 70.409 72.1142C70.4043 72.1196 70.3996 72.1249 70.3953 72.1303C70.3932 72.1326 70.3913 72.1346 70.3892 72.1369C70.3879 72.1382 70.3869 72.1399 70.3856 72.1413C70.3775 72.1503 70.3695 72.1586 70.3618 72.1669C70.3594 72.1693 70.3571 72.1716 70.3548 72.1736C70.3394 72.1893 70.3243 72.2026 70.3093 72.2133C70.2855 72.2307 70.2627 72.2407 70.2413 72.2407H70.241C70.2386 72.2407 70.2366 72.2404 70.2343 72.2404C70.068 72.2223 69.9428 71.9711 69.7999 71.8189C69.7182 71.9681 69.5649 72.1296 69.5653 72.2614C69.5653 72.2637 69.5653 72.2657 69.5653 72.2677C69.6091 73.3368 69.6034 74.4222 69.8956 75.4242C70.0281 75.4789 70.1593 75.5373 70.2885 75.5987C70.2323 75.7592 70.1764 75.9194 70.1205 76.0802C69.5632 75.9247 69.006 75.7692 68.4491 75.614C68.6285 75.1466 68.8082 74.6791 69.004 74.1679C67.8698 74.6404 67.8698 74.6404 66.9692 75.6097C66.9427 75.6034 66.9166 75.597 66.8912 75.5907C66.8845 75.589 66.8775 75.5873 66.8708 75.5857C66.8637 75.584 66.8567 75.5823 66.8497 75.5807C66.8373 75.5777 66.8249 75.5747 66.8125 75.5717C66.8122 75.5717 66.8119 75.5717 66.8116 75.5713C66.4347 75.4806 66.1636 75.4235 65.9484 75.4225C65.9464 75.4225 65.9447 75.4225 65.9427 75.4225C65.9421 75.4225 65.9414 75.4225 65.9407 75.4225C65.4521 75.4232 65.2523 75.7171 64.7516 76.566C64.7472 76.573 64.7432 76.58 64.7392 76.587C64.7359 76.5923 64.7329 76.5977 64.7299 76.603Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M67.3466 68.8765C67.0641 68.7864 66.7813 68.696 66.4988 68.6059C66.3593 68.5485 66.2197 68.4911 66.0802 68.4337C66.1247 68.1081 66.1735 67.7821 66.2127 67.4564C66.2606 67.0503 66.3001 66.6443 66.3432 66.2382C66.8513 65.9062 67.0501 65.7577 67.0501 65.4691C67.0501 65.2959 66.9784 65.0724 66.859 64.7284L66.8583 64.6953C66.9065 64.5035 66.9476 64.3116 66.948 64.1351C66.9483 63.9082 66.8804 63.7067 66.6715 63.5629C66.4918 63.4391 66.2703 63.3914 66.0745 63.2936C65.3359 62.9249 65.1032 62.7767 65.1029 62.1851C65.1026 61.9376 65.1431 61.6123 65.2043 61.1608C65.2348 60.9359 65.2923 60.7027 65.2923 60.4848C65.2923 60.4538 65.291 60.4231 65.2883 60.3924C65.2585 60.0581 65.1568 59.7421 65.0798 59.3901C65.4041 59.1588 65.7264 58.9293 66.0484 58.7C66.382 58.8502 66.6689 59.028 66.707 59.5282C66.7247 59.7584 66.8744 59.9573 66.9641 60.1702C66.5929 60.5048 66.2117 60.8248 65.8569 61.1825C65.7676 61.2732 65.7037 61.4718 65.7037 61.6149C65.7037 61.6259 65.704 61.6363 65.7047 61.6466C65.7238 61.9049 65.8814 61.9836 66.0705 61.985C66.0718 61.985 66.0735 61.985 66.0748 61.985C66.0755 61.985 66.0758 61.985 66.0762 61.985C66.1016 61.985 66.127 61.9836 66.1531 61.981C66.1578 61.9806 66.1625 61.98 66.1669 61.9796C66.1702 61.9793 66.1735 61.9786 66.1769 61.9783C66.1809 61.978 66.1853 61.9773 66.1893 61.977C66.4128 61.9473 66.6364 61.8962 66.8603 61.8545C66.9078 62.1008 66.9078 62.383 67.0113 62.5866C67.0153 62.5949 67.0196 62.6032 67.024 62.6113C67.0263 62.6159 67.0287 62.6206 67.031 62.6253C67.2512 63.0423 67.5143 63.2479 67.8382 63.2489C67.8392 63.2489 67.8399 63.2489 67.8409 63.2489C67.8423 63.2489 67.8439 63.2489 67.8456 63.2489C68.0354 63.2479 68.2465 63.1768 68.4821 63.0373C68.4841 63.036 68.4865 63.035 68.4885 63.0337C68.4969 63.0287 68.5052 63.0237 68.5136 63.0183C68.7864 62.8518 69.0303 62.6089 69.2727 62.4127C69.8061 62.6566 70.0153 63.0213 70.0167 63.4654C70.0173 63.7894 69.9075 64.1558 69.7315 64.5485C69.278 64.6182 69.1338 65.0243 69.0006 65.4427C68.931 65.6032 68.8694 65.7671 68.8158 65.9339L68.8148 65.9356C68.5354 65.8635 68.2579 65.7838 67.9751 65.7264C67.9731 65.726 67.9711 65.7257 67.9691 65.7254C67.9671 65.7254 67.9654 65.7254 67.9634 65.7254C67.9634 65.7254 67.9631 65.7254 67.9627 65.7254C67.9581 65.7254 67.9537 65.7257 67.9487 65.7264C67.9326 65.7294 67.9149 65.7367 67.8961 65.7467C67.8894 65.75 67.8828 65.7537 67.8761 65.7577C67.8737 65.7594 67.871 65.7607 67.8687 65.762C67.8673 65.763 67.8664 65.7637 67.865 65.7644C67.8449 65.7764 67.8235 65.7904 67.8004 65.8044C67.7934 65.8088 67.786 65.8131 67.7783 65.8174C67.7767 65.8184 67.7747 65.8194 67.773 65.8204C67.7686 65.8231 67.7643 65.8254 67.7596 65.8278C67.7532 65.8314 67.7465 65.8351 67.7395 65.8385C67.6261 66.2472 67.5437 66.6443 67.5444 67.0333C67.5447 67.422 67.6281 67.8024 67.8453 68.1771C67.8744 68.2272 67.8874 68.2789 67.8874 68.3306C67.8881 68.5662 67.6173 68.7987 67.3466 68.8765Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M74.5295 71.7058C74.5275 71.7058 74.5255 71.7058 74.5238 71.7058C74.226 71.7015 74.1005 71.3665 73.8896 71.197C73.8873 71.195 73.8849 71.193 73.8826 71.1913C73.8802 71.1896 73.8782 71.1876 73.8759 71.186C73.8578 71.1723 73.8388 71.1596 73.819 71.1489C73.8163 71.1473 73.8137 71.1459 73.8107 71.1443C73.7989 71.1382 73.7869 71.1326 73.7745 71.1276C73.7732 71.1269 73.7718 71.1266 73.7708 71.1259C73.7648 71.1236 73.7591 71.1216 73.7531 71.1196C73.748 71.1179 73.7434 71.1162 73.7384 71.1149C73.4689 71.0371 73.1035 71.1346 72.9177 70.9634C72.7306 70.7919 72.7129 70.3842 72.6208 70.0799C72.6235 70.0785 72.6259 70.0772 72.6286 70.0755C72.6309 70.0739 72.6336 70.0725 72.6359 70.0709C72.6403 70.0682 72.6443 70.0655 72.6486 70.0629C72.7477 69.9978 72.8618 69.893 72.9478 69.8643C72.9542 69.862 72.9602 69.8603 72.9662 69.859C72.9739 69.8577 72.9813 69.8566 72.9883 69.8566C72.9887 69.8566 72.9887 69.8566 72.989 69.8566C72.9967 69.8566 73.0041 69.858 73.0111 69.86C73.0114 69.86 73.0118 69.8603 73.0118 69.8603C73.0128 69.8607 73.0138 69.861 73.0145 69.8613C73.0325 69.8683 73.0509 69.8753 73.069 69.8824C73.0901 69.8907 73.1112 69.899 73.1326 69.9074C73.5904 70.0912 74.0352 70.3088 74.5483 70.3101C74.55 70.3101 74.5513 70.3101 74.5526 70.3101C74.553 70.3101 74.553 70.3101 74.5533 70.3101C74.5807 70.3101 74.6082 70.3094 74.636 70.3081C74.64 70.3078 74.644 70.3077 74.648 70.3074C74.9338 70.2924 75.0684 70.1966 75.0677 69.9848C75.0674 69.8777 75.0322 69.7409 74.9646 69.5694C74.906 69.4216 74.887 69.2494 74.8491 69.0886C74.9154 68.9367 74.963 68.7682 75.053 68.6361C75.0563 68.6311 75.06 68.6258 75.0637 68.6207C75.146 68.505 75.2367 68.4392 75.3251 68.4369C75.3267 68.4369 75.3281 68.4369 75.3297 68.4369C75.3308 68.4369 75.3321 68.4369 75.3331 68.4369C75.4034 68.4382 75.472 68.4803 75.5339 68.569C75.5352 68.5707 75.5366 68.5727 75.5376 68.5747C75.5403 68.5784 75.5426 68.5817 75.5449 68.5857C75.7427 68.8917 75.9225 69.2147 76.1102 69.5307C76.1072 69.5644 76.1059 69.5974 76.1059 69.6294C76.1065 69.87 76.1942 70.0532 76.3786 70.1723C76.5215 70.22 76.6638 70.2674 76.8067 70.3151L76.808 70.3164C76.6581 70.7202 76.5078 71.1239 76.3549 71.5353C76.3502 71.533 76.3452 71.5307 76.3402 71.5283C76.3351 71.526 76.3301 71.5236 76.3251 71.5216C76.3244 71.5213 76.3238 71.521 76.3234 71.5206C76.0697 71.4075 75.8281 71.3601 75.5894 71.3598C75.5884 71.3598 75.5874 71.3598 75.5864 71.3598C75.5854 71.3598 75.5844 71.3598 75.5834 71.3598C75.3927 71.3601 75.2036 71.3905 75.0118 71.4406C75.0115 71.4332 75.0115 71.4262 75.0115 71.4189C75.0115 71.3872 75.0131 71.3552 75.0131 71.3238C75.0131 71.2851 75.0108 71.2474 75.0008 71.214C74.9887 71.173 74.9295 71.1559 74.8906 71.1283C74.9308 71.2324 74.9706 71.3368 75.0105 71.4412C74.8789 71.5296 74.7504 71.6708 74.6162 71.6971C74.5861 71.7028 74.5573 71.7058 74.5299 71.7058H74.5295Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M65.8337 70.6372C65.8692 70.4727 65.9097 70.3092 65.9556 70.1464C65.9492 70.0673 65.9459 69.9892 65.9459 69.9125C65.9459 69.411 66.0894 68.9609 66.4987 68.6059C66.7812 68.6959 67.064 68.7864 67.3465 68.8764C67.3465 69.1904 67.399 69.5014 67.399 69.8154C67.3994 70.0596 67.3679 70.3059 67.2555 70.5571C67.2367 70.5401 67.2186 70.5241 67.2012 70.5084C66.9867 70.3159 66.8672 70.2178 66.732 70.2151C66.7303 70.2151 66.7287 70.2151 66.727 70.2151C66.7233 70.2151 66.72 70.2151 66.7163 70.2154C66.5697 70.2208 66.3997 70.3366 66.0697 70.5651C66.0623 70.5705 66.055 70.5755 66.0473 70.5808C65.9863 70.6228 65.9054 70.6195 65.8337 70.6372Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M70.2506 67.3989C70.2499 67.3989 70.2496 67.3989 70.2492 67.3989C70.1374 67.3983 70.0357 67.3409 69.9463 67.2425C69.9453 67.2415 69.9446 67.2405 69.9436 67.2395C69.94 67.2355 69.9359 67.2308 69.9323 67.2264C69.9289 67.2228 69.9256 67.2188 69.9226 67.2148C69.9199 67.2118 69.9176 67.2087 69.9149 67.2054C69.7807 67.0376 69.6321 66.8858 69.4898 66.7266C69.4905 66.7259 69.4912 66.7256 69.4915 66.7249C69.4908 66.7246 69.4902 66.7246 69.4895 66.7243C69.4925 66.7183 69.4955 66.7126 69.4985 66.7069C69.4999 66.7039 69.5015 66.7009 69.5029 66.6982C69.5102 66.6839 69.5176 66.6702 69.5246 66.6565C69.5276 66.6508 69.5303 66.6452 69.5333 66.6395C69.8195 66.0913 69.9075 65.9522 70.2382 65.9512C70.2395 65.9512 70.2409 65.9512 70.2422 65.9512C70.2432 65.9512 70.2442 65.9512 70.2448 65.9512C70.3409 65.9512 70.4574 65.9628 70.6043 65.9789C70.6204 65.9809 70.6364 65.9825 70.6532 65.9845C70.6595 65.9852 70.6662 65.9859 70.6726 65.9865C70.6769 65.9872 70.6809 65.9875 70.6853 65.9879C70.698 66.2288 70.7024 66.4717 70.7251 66.7096C70.7285 66.743 70.7298 66.7753 70.7298 66.8074C70.7295 67.0309 70.6485 67.2201 70.4631 67.3332C70.4611 67.3342 70.4591 67.3356 70.4571 67.3366C70.4564 67.3372 70.4554 67.3375 70.4547 67.3379C70.453 67.3389 70.4517 67.3399 70.45 67.3405C70.4497 67.3409 70.449 67.3415 70.4483 67.3419C70.4463 67.3429 70.4447 67.3435 70.443 67.3445C70.3767 67.3812 70.3131 67.3986 70.2522 67.3989C70.2516 67.3989 70.2512 67.3989 70.2506 67.3989Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M69.0673 66.5864C68.8946 66.4606 68.8079 66.2811 68.8086 66.0472C68.8086 66.0115 68.811 65.9742 68.815 65.9358L68.816 65.9341C68.9562 65.9788 69.0958 66.0252 69.2343 66.0736C69.1788 66.2434 69.1235 66.4136 69.069 66.5838C69.0683 66.5834 69.0673 66.5831 69.0666 66.5831C69.067 66.5841 69.067 66.5851 69.0673 66.5864Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M69.1997 66.9387C69.199 66.9387 69.1984 66.9387 69.1977 66.9387C69.1358 66.9361 69.114 66.8313 69.0702 66.603C69.0692 66.599 69.0685 66.595 69.0679 66.591C69.0675 66.5894 69.0672 66.5877 69.0668 66.586C69.0665 66.5847 69.0665 66.5837 69.0662 66.5827C69.0668 66.5827 69.0678 66.583 69.0685 66.5834C69.2077 66.6324 69.3483 66.6794 69.4892 66.7238C69.4899 66.7242 69.4905 66.7242 69.4912 66.7245C69.4909 66.7252 69.4902 66.7255 69.4895 66.7262C69.4782 66.7362 69.4675 66.7462 69.4568 66.7555C69.4551 66.7572 69.4534 66.7585 69.4517 66.7602C69.446 66.7652 69.4407 66.7702 69.435 66.7752C69.4343 66.7759 69.4333 66.7766 69.4326 66.7772C69.4313 66.7786 69.4296 66.7799 69.4283 66.7812C69.427 66.7825 69.4256 66.7839 69.4239 66.7849C69.4109 66.7966 69.3985 66.8079 69.3865 66.8183C69.3861 66.8186 69.3858 66.8189 69.3854 66.8193C69.2991 66.8947 69.2436 66.9361 69.2037 66.9387C69.2024 66.9387 69.201 66.9387 69.1997 66.9387Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M73.6932 65.5442C73.6915 65.5442 73.6899 65.5442 73.6882 65.5442C73.477 65.5429 73.2776 65.4541 73.1079 65.2099C73.1052 65.2062 73.1029 65.2025 73.1002 65.1985C73.0998 65.1982 73.0995 65.1979 73.0992 65.1972C73.0925 65.1872 73.0855 65.1765 73.0784 65.1655C73.0376 65.1014 72.9693 65.0624 72.9138 65.0117C72.9178 64.973 72.9198 64.9356 72.9198 64.8996C72.9191 64.664 72.8311 64.4838 72.6581 64.357C72.5148 64.3077 72.3719 64.2586 72.229 64.2092C72.4064 63.7668 72.5406 63.3307 72.5406 62.8989C72.5409 62.622 72.4861 62.3467 72.3519 62.0728C72.2578 61.8799 72.2725 61.6063 72.2374 61.3697C72.6504 61.5032 73.0567 61.6607 73.4777 61.7641C74.1343 61.9256 74.6491 62.314 75.0664 62.8792L74.976 63.1111L74.9141 63.352C74.9141 63.3681 74.9141 63.384 74.9141 63.4004C74.9141 63.5295 74.9125 63.6587 74.9125 63.7878C74.9125 63.9009 74.9135 64.0137 74.9175 64.1258C74.9195 64.1752 74.9205 64.2249 74.9205 64.2746C74.9208 64.68 74.8485 65.0878 74.4891 65.2766C74.4847 65.2789 74.4801 65.2813 74.4757 65.2836C74.2224 65.4164 73.9529 65.5422 73.6996 65.5442C73.6976 65.5442 73.6956 65.5442 73.6932 65.5442Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M70.5264 65.2849C70.5254 65.2849 70.5248 65.2849 70.5238 65.2849C70.3614 65.2846 70.1988 65.2489 70.0391 65.1842C70.0375 65.1835 70.0361 65.1828 70.0344 65.1821C70.0298 65.1801 70.0254 65.1785 70.0207 65.1765C70.0201 65.1761 70.019 65.1758 70.0184 65.1755C70.0133 65.1735 70.0087 65.1711 70.0037 65.1691C70.2041 64.6006 70.3939 64.0273 70.6084 63.4645C70.6107 63.4588 70.6131 63.4528 70.6151 63.4471C70.6154 63.4461 70.6161 63.4451 70.6164 63.4441C70.6198 63.4357 70.6228 63.4277 70.6261 63.4197C70.7824 63.0367 70.997 62.8562 71.3032 62.8552C71.3042 62.8552 71.3049 62.8552 71.3059 62.8552C71.3062 62.8552 71.3065 62.8552 71.3072 62.8552C71.3654 62.8552 71.4267 62.8618 71.492 62.8745C71.7199 62.9196 71.7928 63.0387 71.7925 63.2159C71.7922 63.3256 71.7637 63.4574 71.7266 63.6076C71.7145 63.6566 71.7088 63.7013 71.7088 63.7417C71.7082 64.036 72.0003 64.1197 72.2289 64.2092C72.3718 64.2586 72.5147 64.3076 72.658 64.357L72.5663 64.6112L72.4839 64.8692C72.3718 65.0186 72.2624 65.0677 72.1543 65.0677C72.0522 65.0677 71.9508 65.024 71.8484 64.9806C71.746 64.9372 71.6422 64.8935 71.5355 64.8935C71.508 64.8935 71.4802 64.8965 71.4521 64.9032C71.4518 64.9032 71.4511 64.9032 71.4508 64.9035C71.4498 64.9035 71.4491 64.9039 71.4481 64.9042C71.4478 64.9042 71.4471 64.9042 71.4468 64.9045C71.4434 64.9052 71.4398 64.9062 71.4361 64.9072C71.4351 64.9075 71.4341 64.9079 71.4331 64.9082C71.4327 64.9082 71.4324 64.9082 71.4321 64.9085C71.4297 64.9092 71.4274 64.9099 71.425 64.9105C71.4247 64.9105 71.4244 64.9109 71.424 64.9109C71.423 64.9112 71.4223 64.9116 71.4213 64.9119C71.421 64.9119 71.4203 64.9122 71.42 64.9122C71.4193 64.9125 71.4187 64.9129 71.418 64.9129C71.4173 64.9132 71.4166 64.9135 71.416 64.9135C71.4153 64.9139 71.4147 64.9142 71.414 64.9142C71.4133 64.9145 71.4127 64.9149 71.412 64.9152C71.411 64.9155 71.41 64.9159 71.4093 64.9162C71.4086 64.9162 71.4083 64.9165 71.408 64.9165C71.4073 64.9169 71.407 64.9169 71.4066 64.9172C71.4016 64.9189 71.3966 64.9209 71.3916 64.9229C71.3912 64.9232 71.3909 64.9236 71.3902 64.9236C71.3896 64.9239 71.3885 64.9246 71.3875 64.9249C71.3875 64.9249 71.3875 64.9249 71.3872 64.9249C71.3752 64.9302 71.3631 64.9366 71.3511 64.9432C71.3507 64.9436 71.3504 64.9436 71.3501 64.9439C71.3316 64.9546 71.3129 64.9669 71.2945 64.9816C71.2918 64.9836 71.2892 64.9856 71.2865 64.9879C71.2831 64.9906 71.2798 64.9933 71.2764 64.996C71.2741 64.998 71.2714 65.0003 71.2687 65.0023C71.2634 65.007 71.258 65.0113 71.2527 65.0156C71.2486 65.019 71.2443 65.0223 71.2399 65.0257C71.2349 65.03 71.2296 65.034 71.2242 65.038C71.0033 65.2078 70.7674 65.2842 70.5294 65.2849C70.5284 65.2849 70.5274 65.2849 70.5264 65.2849Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M72.9188 60.8955C72.7829 60.8955 72.7263 60.736 72.6042 60.365C72.6015 60.357 72.5985 60.3486 72.5958 60.3399C72.5944 60.3359 72.5931 60.332 72.5918 60.328C72.5918 60.328 72.5918 60.328 72.5921 60.328C72.8746 60.4304 73.1574 60.5328 73.4402 60.6353C73.4375 60.6369 73.4348 60.6386 73.4322 60.6402C73.4255 60.6446 73.4191 60.6486 73.4127 60.6526C73.4017 60.6593 73.391 60.6659 73.3806 60.6723C73.3803 60.6726 73.3796 60.6729 73.3789 60.6736C73.3672 60.6809 73.3558 60.688 73.3445 60.695C73.3344 60.701 73.3247 60.7073 73.315 60.713C73.3043 60.7197 73.2936 60.7263 73.2832 60.7327C73.2795 60.735 73.2759 60.7373 73.2722 60.7393C73.2719 60.7397 73.2718 60.7397 73.2718 60.7397C73.1206 60.8314 73.0175 60.8858 72.9398 60.8945C72.9325 60.8952 72.9255 60.8955 72.9188 60.8955Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M74.9143 63.3523L74.9762 63.1114L75.0666 62.8795C75.1318 62.9919 75.1971 63.104 75.263 63.2162C75.1466 63.2615 75.0304 63.3069 74.9143 63.3523Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M69.234 66.0735C69.0955 66.0251 68.9559 65.9787 68.8157 65.934C68.8692 65.7672 68.9308 65.6034 69.0004 65.4429C69.1644 65.559 69.2424 65.7268 69.2427 65.9417C69.2427 65.9837 69.24 66.0278 69.234 66.0735Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M72.9136 65.0117C72.7704 64.964 72.6271 64.9166 72.4839 64.8693L72.5662 64.6113L72.6579 64.3571C72.831 64.4839 72.919 64.6641 72.9197 64.8996C72.9197 64.9357 72.9176 64.973 72.9136 65.0117Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M80.7981 71.0688C80.6495 71.0662 80.5023 71.0575 80.3557 71.0432C80.2506 70.9387 80.1335 70.8536 80.0056 70.7879C80.1064 70.3388 80.2931 69.9774 80.7242 69.8663C80.8912 70.0318 80.9547 70.2197 80.9544 70.4212C80.9537 70.6261 80.8878 70.845 80.7981 71.0688Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M78.4988 70.8901C78.5001 70.8855 78.5018 70.8805 78.5035 70.8758C78.5065 70.8778 78.5095 70.8798 78.5125 70.8818L78.4988 70.8901ZM78.5035 70.8758C78.3415 70.762 78.2602 70.5985 78.2605 70.3846C78.2605 70.3419 78.2638 70.2972 78.2702 70.2502C78.4047 70.2835 78.5366 70.3256 78.6658 70.376C78.6122 70.5428 78.5584 70.7096 78.5035 70.8758Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M76.8067 70.3152C76.6638 70.2675 76.5216 70.2201 76.3787 70.1724C76.3847 70.1644 76.3907 70.1567 76.3967 70.1494C76.3981 70.1474 76.3998 70.1453 76.4014 70.1433C76.4014 70.1433 76.4014 70.1433 76.4014 70.143C76.4045 70.1393 76.4075 70.1357 76.4105 70.132C76.5085 70.0125 76.5882 69.9468 76.6501 69.9352C76.6565 69.9342 76.6628 69.9335 76.6688 69.9335C76.6705 69.9335 76.6718 69.9335 76.6732 69.9335C76.7592 69.9375 76.8037 70.0646 76.8067 70.3152Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M79.3352 61.4692C79.461 61.0171 79.6314 60.617 80.1076 60.5723C79.9423 60.9784 79.7499 61.3528 79.3352 61.4692Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M71.5355 81.6689C71.5349 81.6689 71.5342 81.6689 71.5335 81.6689C71.398 81.6686 71.2641 81.6466 71.1316 81.5882C71.1252 81.5852 71.1185 81.5822 71.1118 81.5792C71.1613 81.4117 71.2139 81.2455 71.2698 81.0803C71.3357 80.9042 71.402 80.728 71.4679 80.5518C71.6031 80.5822 71.739 80.6086 71.8762 80.6306C72.165 80.745 72.4532 80.8595 72.7417 80.9739C72.6865 81.1441 72.6292 81.3136 72.569 81.4821C72.5613 81.4831 72.5536 81.4844 72.5459 81.4854C72.5443 81.4858 72.5426 81.4861 72.5406 81.4861C72.5151 81.4901 72.49 81.4944 72.4646 81.4991C72.4642 81.4991 72.4643 81.4991 72.4643 81.4991C72.3833 81.5141 72.3019 81.5331 72.2206 81.5525C71.9923 81.6075 71.7638 81.6683 71.5382 81.6689C71.5375 81.6689 71.5365 81.6689 71.5355 81.6689Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M76.4648 79.8779C76.4879 79.7915 76.4956 79.6941 76.5378 79.6207C76.6238 79.4722 76.7282 79.3364 76.8253 79.1956C76.9006 79.3234 76.9762 79.4512 77.0512 79.579C76.8557 79.6787 76.6603 79.7785 76.4648 79.8779Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M70.0396 77.772C69.9369 77.0209 69.3539 76.9945 68.8776 76.8257C68.5118 76.6962 68.3508 76.4603 68.3508 76.1307C68.3505 75.9782 68.385 75.8053 68.4492 75.6138C69.0061 75.769 69.5634 75.9245 70.1206 76.08C70.5701 76.3576 70.7177 76.4486 70.718 76.7549C70.7184 76.9044 70.6832 77.1056 70.6313 77.4049C70.4342 77.5271 70.2367 77.6495 70.0396 77.772Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M80.8818 72.2581C80.5505 71.9584 80.3838 71.5477 80.3557 71.0429C80.5023 71.0572 80.6496 71.0659 80.7981 71.0685C80.9397 71.1169 81.0816 71.1653 81.2229 71.2133C81.3223 71.3138 81.3818 71.4169 81.3818 71.5276C81.3818 71.6301 81.3306 71.7389 81.2121 71.8586C81.0927 71.9788 80.9913 72.1239 80.8818 72.2581Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M70.2887 75.5986C70.1595 75.5372 70.0283 75.4789 69.8958 75.4241C69.9955 75.1162 70.0885 74.7999 70.3807 74.6467C70.4095 74.6317 70.4516 74.623 70.4901 74.6227C70.4905 74.6227 70.4912 74.6227 70.4918 74.6227C70.4938 74.6227 70.4955 74.6227 70.4972 74.6227C70.5313 74.6233 70.5608 74.631 70.5742 74.647C70.5755 74.6484 70.5765 74.65 70.5775 74.6517C70.6257 74.7358 70.6913 74.8636 70.6909 74.9517C70.6906 74.97 70.6879 74.9864 70.6812 75.0007C70.5818 75.2163 70.4235 75.4014 70.2887 75.5986Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M78.6235 71.2004C78.5848 71.1717 78.5238 71.1537 78.5131 71.1124C78.5068 71.0877 78.5048 71.061 78.5048 71.0333C78.5048 70.9966 78.5084 70.9582 78.5108 70.9201C78.5485 71.0136 78.5858 71.107 78.6235 71.2004ZM78.5108 70.9201C78.5068 70.9105 78.5028 70.9005 78.4988 70.8905L78.5124 70.8821C78.5121 70.8948 78.5114 70.9075 78.5108 70.9201Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M81.4785 72.9976C81.4775 72.9976 81.4768 72.9976 81.4758 72.9976C81.3791 72.9972 81.2764 72.9802 81.1679 72.9465C81.1656 72.9458 81.1632 72.9452 81.1612 72.9445C81.1602 72.9442 81.1589 72.9438 81.1579 72.9435C81.1535 72.9422 81.1495 72.9408 81.1455 72.9395C81.1458 72.9385 81.1465 72.9378 81.1468 72.9368C81.1502 72.9311 81.1535 72.9255 81.1569 72.9198C81.1619 72.9108 81.1676 72.9018 81.1729 72.8928C81.1766 72.8864 81.1806 72.8801 81.1843 72.8738C81.4561 72.4333 81.8095 72.2245 82.2362 72.2228C82.2379 72.2228 82.2396 72.2228 82.2416 72.2228C82.2416 72.2228 82.2419 72.2228 82.2422 72.2228C82.2797 72.2228 82.3179 72.2244 82.3564 72.2278C82.3594 72.2278 82.3624 72.2281 82.3651 72.2285C82.362 72.2361 82.359 72.2435 82.3557 72.2511C82.1495 72.7403 81.8607 72.9956 81.4828 72.9976C81.4815 72.9976 81.4798 72.9976 81.4785 72.9976Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M38.0198 68.7561C37.5088 68.1929 37.2856 67.3103 36.556 66.9797C36.4606 66.9363 36.4532 66.6814 36.405 66.5242C36.4726 66.3637 36.5389 66.2022 36.6028 66.0401C37.1286 66.0851 37.3672 66.6897 37.9047 66.7888C38.1313 66.8309 38.23 67.4238 38.387 67.7661C38.3281 67.944 38.2695 68.1215 38.2106 68.2993C38.1463 68.4511 38.0828 68.6036 38.0198 68.7561Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M43.3986 66.2986C43.398 66.2986 43.3973 66.2986 43.3966 66.2986C43.3588 66.2986 43.3273 66.2909 43.3093 66.2736C43.3076 66.2719 43.3063 66.2702 43.3049 66.2686C43.3046 66.2682 43.3042 66.2679 43.3039 66.2676C43.1694 66.0971 43.0499 65.8585 43.0338 65.6226C43.0321 65.6006 43.0315 65.5792 43.0315 65.5582C43.0322 65.1958 43.2594 64.989 43.5864 64.9312C43.7025 65.2215 43.8418 65.5015 43.9197 65.8094C43.9217 65.8164 43.9224 65.8244 43.9227 65.8331C43.9234 65.9352 43.8073 66.1308 43.7149 66.1955C43.7099 66.1988 43.7049 66.2022 43.6995 66.2055C43.6918 66.2105 43.6838 66.2152 43.6754 66.2198C43.6737 66.2205 43.6721 66.2215 43.6704 66.2225C43.5951 66.2629 43.4957 66.2936 43.4177 66.2983C43.411 66.2986 43.405 66.2986 43.3986 66.2986ZM43.5864 64.9312C43.5854 64.9289 43.5847 64.9269 43.5837 64.9249L43.5874 64.9309C43.587 64.9309 43.5867 64.9309 43.5864 64.9312Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M43.5673 67.7869C43.4307 67.7382 43.2921 67.6941 43.1526 67.6544C43.1583 67.649 43.164 67.6437 43.1693 67.6384C43.171 67.6367 43.1727 67.635 43.1744 67.6337C43.1824 67.626 43.1901 67.6187 43.1978 67.6113C43.2005 67.609 43.2028 67.6067 43.2055 67.6043C43.2058 67.6037 43.2065 67.6033 43.2068 67.6027C43.2085 67.6013 43.2102 67.5997 43.2118 67.598C43.2219 67.5883 43.2319 67.5793 43.2413 67.5706C43.242 67.57 43.2426 67.569 43.2436 67.5683C43.2517 67.5606 43.2597 67.5533 43.2674 67.5463C43.2701 67.5439 43.2731 67.5413 43.2758 67.5386C43.2851 67.5303 43.2942 67.5223 43.3029 67.5146C43.3045 67.5129 43.3062 67.5116 43.3082 67.5099C43.3099 67.5082 43.3119 67.5066 43.3139 67.5049C43.3581 67.4672 43.3916 67.4438 43.4183 67.4358C43.4187 67.4355 43.419 67.4355 43.4193 67.4355C43.4234 67.4342 43.427 67.4335 43.4304 67.4332C43.4331 67.4325 43.4357 67.4325 43.4384 67.4325C43.4391 67.4325 43.4398 67.4325 43.4408 67.4325C43.4983 67.4348 43.5201 67.5346 43.5599 67.7488C43.5613 67.7565 43.5629 67.7638 43.5643 67.7718C43.5653 67.7768 43.5663 67.7819 43.5673 67.7869Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M48.9752 64.4546L48.936 64.3852C49.1087 63.8967 49.2814 63.4085 49.4541 62.9201C49.7188 62.7786 49.9785 62.6164 50.249 62.5006C50.5247 62.3828 50.8638 62.3121 50.922 61.9371C50.924 61.9244 50.925 61.9117 50.925 61.8987C50.9257 61.7068 50.7195 61.512 50.6887 61.2951C50.6827 61.2527 50.6797 61.2127 50.6797 61.175C50.6797 60.8527 50.8902 60.6788 51.1871 60.6164C51.2005 61.1296 51.5241 61.2834 51.8695 61.4116C51.8973 61.809 51.925 62.2067 51.9528 62.6041C51.9254 62.6845 51.8949 62.7636 51.8708 62.8447C51.8695 62.849 51.8685 62.853 51.8671 62.8573C51.8668 62.8587 51.8661 62.86 51.8658 62.8613C51.8648 62.8643 51.8641 62.8673 51.8631 62.87C51.8625 62.8727 51.8618 62.8753 51.8608 62.8777C51.678 63.4786 51.4327 63.9397 50.9006 63.9414C50.8993 63.9414 50.8982 63.9417 50.8972 63.9417C50.8969 63.9417 50.8962 63.9414 50.8959 63.9414C50.8116 63.9414 50.7202 63.9297 50.6208 63.9057C50.6185 63.905 50.6158 63.9044 50.6134 63.9037C50.6084 63.9023 50.6034 63.9014 50.5981 63.9C50.5974 63.8997 50.5967 63.8994 50.596 63.8994H50.5957C50.594 63.899 50.5927 63.8987 50.591 63.8984C50.5813 63.8964 50.5716 63.8953 50.5616 63.8953C50.5612 63.8953 50.5612 63.8953 50.5609 63.8953C50.5539 63.8953 50.5465 63.8957 50.5392 63.8967C50.5234 63.8983 50.5067 63.9024 50.4896 63.9077C50.4853 63.9094 50.4809 63.9107 50.4766 63.9124C50.4548 63.9204 50.4324 63.9307 50.4093 63.9431C50.4089 63.9434 50.4083 63.9437 50.4076 63.9441C50.3942 63.9511 50.3808 63.9588 50.3674 63.9671C50.3621 63.9704 50.3564 63.9738 50.3511 63.9771C50.3464 63.9801 50.3413 63.9831 50.3363 63.9864C50.333 63.9888 50.3293 63.9911 50.3256 63.9935C50.3216 63.9961 50.3176 63.9988 50.3136 64.0015C50.2272 64.0589 50.1372 64.1286 50.0525 64.1796C50.0412 64.1863 50.0298 64.193 50.0184 64.1993L49.9605 64.223C49.6322 64.3001 49.3035 64.3775 48.9752 64.4546Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M48.936 64.3853C48.8266 64.0493 48.76 63.8314 48.76 63.6642C48.7607 63.3806 48.9531 63.2424 49.4541 62.9201C49.2814 63.4086 49.1087 63.8968 48.936 64.3853Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M40.4067 70.1565C40.1808 69.8906 39.9545 69.625 39.7286 69.359C39.7283 69.3557 39.7276 69.3527 39.727 69.3497C39.7266 69.347 39.726 69.3447 39.7256 69.342C39.725 69.3393 39.7246 69.337 39.724 69.3344C39.7233 69.3304 39.7226 69.3267 39.7216 69.3227C39.6791 69.1058 39.6567 69.007 39.5955 69.0064C39.5951 69.0064 39.5948 69.0064 39.5944 69.0064C39.5924 69.0064 39.5901 69.0064 39.5877 69.0067C39.5466 69.011 39.4884 69.0554 39.3977 69.1342C39.397 69.1345 39.3963 69.1352 39.3956 69.1358C39.3866 69.1438 39.3769 69.1522 39.3669 69.1612C39.3649 69.1628 39.3629 69.1645 39.3612 69.1662C39.3595 69.1675 39.3578 69.1689 39.3565 69.1702C39.3551 69.1715 39.3538 69.1725 39.3521 69.1738C39.3491 69.1768 39.3458 69.1795 39.3424 69.1825C39.3337 69.1902 39.3247 69.1986 39.3153 69.2066C39.3143 69.2076 39.3137 69.2082 39.3126 69.2089C39.311 69.2105 39.309 69.2122 39.307 69.2139L39.3026 69.2159L39.3023 69.2162C38.7993 69.1198 38.5626 68.6223 38.2102 68.2993C38.2691 68.1215 38.3277 67.944 38.3866 67.7661C38.4572 67.7695 38.5278 67.7761 38.5985 67.7835C38.732 67.7975 38.8655 67.8135 38.9984 67.8145C39.0027 67.8145 39.0071 67.8145 39.0114 67.8145C39.0121 67.8145 39.0128 67.8145 39.0131 67.8145C39.0914 67.8145 39.1691 67.8092 39.2464 67.7945C39.2521 67.7935 39.2578 67.7925 39.2635 67.7915C39.2651 67.7911 39.2668 67.7908 39.2688 67.7905C39.3324 67.7798 39.393 67.7745 39.4505 67.7745C39.4509 67.7745 39.4515 67.7745 39.4519 67.7745C39.4525 67.7745 39.4535 67.7745 39.4542 67.7745C39.7296 67.7751 39.9435 67.8939 40.1704 68.0858C40.1795 68.0935 40.1882 68.1008 40.1969 68.1085C40.2012 68.1121 40.2056 68.1161 40.2099 68.1198C40.5402 68.4091 40.6641 68.7357 40.6644 69.0904C40.6647 69.4234 40.556 69.7811 40.4067 70.1565Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M40.2322 70.6724C40.0886 70.6257 39.9447 70.5793 39.8015 70.5329C39.7195 70.3127 39.6372 70.0928 39.5552 69.8726C39.6131 69.7014 39.6703 69.5302 39.7282 69.359C39.7285 69.359 39.7289 69.3594 39.7292 69.3594C39.7292 69.3591 39.7292 69.359 39.7289 69.359C39.9551 69.6253 40.1814 69.8912 40.4073 70.1572C40.4073 70.1575 40.4069 70.1582 40.4069 70.1585C40.3497 70.3297 40.2925 70.5002 40.2346 70.6707L40.2322 70.6724Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M40.3524 70.9824C40.3137 70.9551 40.2523 70.9391 40.2406 70.898C40.2316 70.868 40.2292 70.8343 40.2292 70.7996C40.2292 70.7612 40.2322 70.7212 40.2322 70.6828C40.2322 70.6791 40.2322 70.6755 40.2322 70.6721L40.2346 70.6705C40.274 70.7746 40.3133 70.8783 40.3524 70.9824Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M38.8494 69.9048C38.8775 69.8567 38.8982 69.7843 38.935 69.7656C38.9377 69.7643 38.9407 69.763 38.9434 69.7616C39.001 69.7359 39.0676 69.7396 39.1301 69.7299C39.0364 69.7883 38.9427 69.8464 38.8494 69.9048Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M39.5552 69.8726C39.4136 69.8252 39.2717 69.7778 39.1301 69.7301C39.1877 69.5589 39.2453 69.3874 39.3028 69.2162L39.3072 69.2139C39.4471 69.2639 39.5873 69.3123 39.7282 69.359C39.6703 69.5302 39.6131 69.7014 39.5552 69.8726Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M45.0571 70.3894C45.0567 70.3894 45.0564 70.3894 45.0561 70.3894C45.0059 70.3891 44.9671 70.3637 44.9426 70.311C44.9423 70.3103 44.9423 70.31 44.942 70.3093C44.9413 70.308 44.9406 70.3063 44.9399 70.305C44.8938 70.1975 44.874 70.1008 44.874 70.0127C44.8737 69.5873 45.3298 69.3527 45.4878 68.9923C45.5892 68.7598 45.7479 68.5552 45.874 68.3487C46.1585 68.4164 46.2616 68.5959 46.2609 68.8375C46.2609 68.9179 46.2492 69.005 46.2291 69.0974C46.2127 69.1712 46.1257 69.2306 46.0799 69.3033C46.0621 69.3313 46.0447 69.359 46.027 69.3861C46.0253 69.3884 46.0236 69.3911 46.0223 69.3937C46.0139 69.4061 46.0059 69.4184 45.9979 69.4304C45.9952 69.4351 45.9919 69.4398 45.9892 69.4441C45.9765 69.4631 45.9641 69.4815 45.952 69.4998C45.9493 69.5035 45.947 69.5072 45.9447 69.5105C45.8101 69.7094 45.6816 69.8785 45.5634 70.0133C45.5631 70.0137 45.5631 70.014 45.5628 70.014C45.5608 70.0164 45.5591 70.0184 45.5571 70.0204C45.5558 70.0224 45.5541 70.0244 45.5524 70.026C45.5109 70.0731 45.4707 70.1154 45.4323 70.1538C45.4112 70.1748 45.3901 70.1949 45.3697 70.2135C45.3643 70.2182 45.359 70.2229 45.3536 70.2276C45.3506 70.2306 45.3473 70.2332 45.3442 70.2359C45.3442 70.2359 45.3442 70.2359 45.3439 70.2359C45.3365 70.2426 45.3292 70.2486 45.3221 70.2546C45.3148 70.2606 45.3078 70.2663 45.3007 70.2719L45.3004 70.2723C45.2951 70.2766 45.2897 70.2806 45.2843 70.2846C45.2833 70.2856 45.2823 70.2863 45.2813 70.287C45.2773 70.2903 45.2733 70.2933 45.2693 70.296C45.2689 70.2963 45.2689 70.2963 45.2686 70.2966C45.2683 70.2966 45.2683 70.297 45.268 70.297C45.2659 70.2986 45.2639 70.3 45.2616 70.3016C45.2572 70.3046 45.2529 70.3076 45.2489 70.3106C45.2485 70.311 45.2482 70.311 45.2482 70.3113C45.2478 70.3113 45.2479 70.3113 45.2479 70.3113C45.2465 70.3123 45.2455 70.313 45.2442 70.314C45.2412 70.316 45.2378 70.3183 45.2348 70.3203H45.2345C45.2345 70.3203 45.2341 70.3207 45.2338 70.3207C45.2321 70.322 45.2301 70.3233 45.2281 70.3243C45.2251 70.3267 45.2218 70.3287 45.2184 70.3307C45.2184 70.3307 45.2181 70.3307 45.2181 70.331C45.2167 70.3317 45.2154 70.3327 45.2141 70.3333C45.2114 70.335 45.2091 70.3363 45.2067 70.3377C45.2024 70.3403 45.198 70.343 45.1936 70.3454C45.193 70.3457 45.192 70.3464 45.1913 70.3467C45.1876 70.3487 45.1839 70.3507 45.1806 70.3527C45.1803 70.3527 45.1802 70.3527 45.1799 70.3527C45.1766 70.3543 45.1732 70.3564 45.1699 70.358C45.1602 70.3627 45.1505 70.367 45.1411 70.3707C45.1374 70.3724 45.1334 70.3737 45.1297 70.375C45.1264 70.3764 45.1227 70.3774 45.1193 70.3787C45.1183 70.3791 45.117 70.3794 45.116 70.3797C45.0949 70.3861 45.0752 70.3894 45.0571 70.3894Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M51.5438 66.0029C51.5431 66.0029 51.5421 66.0029 51.5411 66.0029C51.3145 66.0009 51.3721 65.7253 51.3379 65.5478C51.2563 65.1251 51.1475 64.7954 50.6843 64.735C50.434 64.7026 50.2385 64.387 50.0183 64.1992C50.0297 64.1928 50.0411 64.1861 50.0525 64.1795C50.1371 64.1284 50.2272 64.0587 50.3135 64.0013C50.3175 63.9986 50.3215 63.996 50.3255 63.9933C50.3292 63.9909 50.3329 63.9886 50.3363 63.9863C50.3413 63.9829 50.3463 63.9799 50.351 63.9769C50.3563 63.9736 50.362 63.9703 50.3674 63.9669C50.3808 63.9586 50.3941 63.9509 50.4075 63.9439C50.4082 63.9436 50.4089 63.9432 50.4092 63.9429C50.4323 63.9306 50.4547 63.9202 50.4765 63.9122C50.4808 63.9105 50.4852 63.9092 50.4895 63.9075C50.5066 63.9022 50.5234 63.8982 50.5391 63.8965C50.5465 63.8955 50.5538 63.8952 50.5608 63.8952C50.5612 63.8952 50.5612 63.8952 50.5615 63.8952C50.5715 63.8952 50.5813 63.8962 50.591 63.8982C50.5926 63.8985 50.594 63.8988 50.5956 63.8992H50.596C50.5966 63.8992 50.5973 63.8995 50.598 63.8999C50.6033 63.9012 50.6084 63.9022 50.6134 63.9035C50.6157 63.9042 50.6184 63.9049 50.6207 63.9055C50.7201 63.9296 50.8115 63.9412 50.8958 63.9412C50.8962 63.9412 50.8968 63.9416 50.8972 63.9416C50.8982 63.9416 50.8992 63.9412 50.9005 63.9412C51.433 63.9396 51.678 63.4784 51.8607 62.8775C51.8617 62.8752 51.8624 62.8725 51.8631 62.8698C51.8641 62.8672 51.8647 62.8642 51.8657 62.8612C51.8661 62.8598 51.8667 62.8585 51.8671 62.8572C51.8684 62.8528 51.8694 62.8488 51.8707 62.8445C51.8948 62.7634 51.9253 62.6843 51.9527 62.6039C52.2673 62.8522 52.4009 63.2349 52.4441 63.6706C52.4688 63.9229 52.4528 64.1988 52.7151 64.2595C53.2088 64.3733 53.3674 64.6626 53.3668 65.0363C53.3664 65.2799 53.2985 65.5592 53.2121 65.8491C52.9628 65.698 52.6961 65.5735 52.4692 65.388C52.4675 65.3863 52.4655 65.385 52.4638 65.3833C52.4601 65.3803 52.4564 65.3777 52.4528 65.3747C52.3818 65.3206 52.3192 65.2966 52.2617 65.2956C52.2603 65.2956 52.259 65.2956 52.258 65.2956C52.2573 65.2956 52.257 65.2956 52.2563 65.2956C52.1311 65.2963 52.0314 65.407 51.929 65.5528C51.9283 65.5538 51.9277 65.5548 51.927 65.5558C51.9267 65.5562 51.9263 65.5568 51.926 65.5572C51.9236 65.5605 51.9213 65.5642 51.9189 65.5675C51.8222 65.7073 51.7275 65.8484 51.6291 65.9929C51.5977 65.9996 51.5695 66.0029 51.5451 66.0029C51.5448 66.0029 51.5444 66.0029 51.5438 66.0029Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M49.7816 70.4331C49.6661 70.1645 49.5972 70.004 49.5972 69.8845C49.5968 69.707 49.7488 69.6203 50.126 69.4051C50.0112 69.7478 49.8964 70.0904 49.7816 70.4331Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M52.4407 66.7466C52.4013 66.6421 52.3616 66.538 52.3223 66.4336C52.3616 66.461 52.4227 66.4773 52.435 66.5187C52.4434 66.5481 52.4457 66.5804 52.4457 66.6141C52.4457 66.6552 52.442 66.6976 52.442 66.7386C52.442 66.7413 52.442 66.7436 52.442 66.7459L52.4407 66.7466Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M64.355 70.7327C64.355 70.731 64.355 70.7293 64.355 70.7277C64.355 70.7293 64.355 70.731 64.355 70.7327ZM64.355 70.7277C64.1157 70.5705 63.8624 70.4337 63.6408 70.2492C63.6392 70.2475 63.6371 70.2462 63.6355 70.2449C63.6325 70.2422 63.6294 70.2399 63.6264 70.2372C63.5394 70.1678 63.4574 70.1294 63.3764 70.1281C63.3751 70.1281 63.3737 70.1281 63.3724 70.1281C63.3711 70.1281 63.3694 70.1281 63.3681 70.1281C63.277 70.1298 63.1867 70.1788 63.0913 70.2839C63.0853 70.2906 63.0792 70.2976 63.0732 70.3046C62.7606 69.6136 62.6 68.7474 61.7201 68.708C61.9286 68.4424 62.1505 68.1885 62.3406 67.9069C62.3918 67.8315 62.4149 67.7424 62.4145 67.6559C62.4145 67.4818 62.3205 67.3183 62.1713 67.2963C61.7639 67.2366 61.35 67.2069 60.8001 67.1505C60.9952 67.7117 61.1461 68.1454 61.2967 68.5789C61.1819 68.9095 61.0494 69.2352 60.9557 69.5709C60.7479 70.3133 60.2622 70.4771 59.7117 70.5178C59.7077 70.5181 59.704 70.5181 59.7 70.5181C59.6977 70.5185 59.6953 70.5185 59.6933 70.5185C59.6926 70.5185 59.692 70.5185 59.6913 70.5185C59.688 70.5185 59.6839 70.5185 59.6803 70.5181C59.625 70.5161 59.5654 70.4981 59.528 70.4627C59.466 70.4043 59.4393 70.3403 59.4393 70.2686C59.4393 70.1902 59.4714 70.1027 59.524 70.0043C59.7967 69.4948 59.9466 69.2135 59.946 69.0206C59.9453 68.7844 59.7191 68.6806 59.2174 68.4521C59.1518 68.4221 59.0795 68.4084 59.0102 68.387C58.9885 68.0797 58.9433 67.7747 58.9436 67.4654C58.9436 67.4391 58.9439 67.4131 58.9449 67.3867C58.9587 66.8989 59.118 66.668 59.4346 66.6666C59.4356 66.6666 59.4363 66.6666 59.4373 66.6666C59.4386 66.6666 59.4399 66.6666 59.4413 66.6666C59.5276 66.6673 59.6257 66.6847 59.7355 66.7184C59.7398 66.7197 59.7442 66.721 59.7485 66.7224C59.7519 66.7234 59.7549 66.7244 59.7579 66.7254C59.7622 66.7267 59.7662 66.728 59.7703 66.729C59.781 66.7324 59.7914 66.7357 59.8017 66.739C59.9343 66.7791 60.0377 66.8031 60.1233 66.8044C60.1257 66.8044 60.128 66.8044 60.13 66.8044C60.1307 66.8044 60.1314 66.8044 60.1317 66.8044C60.3282 66.8038 60.4326 66.6796 60.5966 66.3517C60.5979 66.3487 60.5996 66.3457 60.6009 66.343C60.6076 66.3293 60.6143 66.3156 60.6214 66.3016C60.7338 66.071 60.8028 65.8158 60.8911 65.5719C61.2208 65.4801 61.4363 65.2376 61.5799 64.8792C61.7097 64.5555 61.7857 64.1785 62.1873 64.0267C62.2753 64.2215 62.4494 64.4197 62.4484 64.6349C62.4484 64.6383 62.4484 64.642 62.4484 64.6453C62.4357 65.0774 62.3102 65.5192 62.2516 65.9579C62.2476 65.9873 62.2455 66.017 62.2455 66.0467C62.2459 66.3623 62.4611 66.6696 62.7201 66.6786C62.7449 66.6796 62.77 66.68 62.7948 66.68C62.7951 66.68 62.7954 66.68 62.7958 66.68C62.7978 66.68 62.7998 66.68 62.8021 66.68C62.9346 66.6796 63.0685 66.6683 63.2024 66.656C63.3429 66.6433 63.4835 66.6299 63.6231 66.6279C63.6281 66.6279 63.6331 66.6276 63.6378 66.6276C63.6425 66.6276 63.6475 66.6276 63.6522 66.6276H63.6525C63.6539 66.6276 63.6555 66.6276 63.6569 66.6276C64.0213 66.6286 64.3286 66.731 64.4829 67.1454C64.4846 67.1498 64.4862 67.1541 64.4876 67.1585C64.4882 67.1605 64.4892 67.1625 64.4899 67.1645C64.4929 67.1728 64.4956 67.1815 64.4986 67.1901C64.4993 67.1928 64.5003 67.1955 64.501 67.1982C64.601 67.5085 64.758 67.7881 64.8912 68.08C64.8935 68.085 64.8958 68.09 64.8982 68.0951C64.8985 68.0957 64.8989 68.0964 64.8992 68.0971C64.9019 68.1027 64.9049 68.1087 64.9076 68.1144C64.9086 68.1164 64.9096 68.1184 64.9106 68.1204C65.0629 68.4201 65.2834 68.5008 65.5284 68.5021C65.5304 68.5021 65.5328 68.5021 65.5348 68.5021C65.5354 68.5021 65.5364 68.5021 65.5374 68.5021C65.6921 68.5018 65.8564 68.4704 66.0197 68.4434C66.0398 68.4401 66.0599 68.4367 66.08 68.4337C66.2195 68.4911 66.3591 68.5485 66.4986 68.6059C66.0893 68.9609 65.9458 69.411 65.9458 69.9125C65.9458 69.9893 65.9491 70.0674 65.9555 70.1464C65.8259 70.0894 65.6944 70.0376 65.5609 69.9916C65.3587 69.9262 65.1602 69.8468 64.9538 69.7981C64.9477 69.7967 64.9421 69.7951 64.9364 69.7937C64.93 69.7924 64.9236 69.7911 64.9176 69.7897C64.9106 69.7881 64.9039 69.7864 64.8972 69.7851C64.8079 69.7654 64.7355 69.754 64.6763 69.753C64.674 69.753 64.6716 69.753 64.6693 69.753C64.6686 69.753 64.668 69.753 64.667 69.753C64.4836 69.754 64.428 69.8638 64.3785 70.1725C64.3778 70.1771 64.3771 70.1818 64.3761 70.1865C64.3754 70.1908 64.3751 70.1952 64.3744 70.1992C64.3731 70.2062 64.3721 70.2128 64.3711 70.2199C64.3707 70.2232 64.3701 70.2265 64.3698 70.2299C64.357 70.3156 64.3543 70.402 64.3543 70.4884C64.3547 70.5462 64.3557 70.6042 64.3557 70.662C64.3557 70.684 64.3557 70.7057 64.355 70.7277Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M61.714 68.7126C61.5754 68.6666 61.4365 68.6222 61.2969 68.5788C61.1463 68.1454 60.9954 67.7116 60.8003 67.1504C61.3502 67.2068 61.7642 67.2365 62.1715 67.2962C62.3207 67.3183 62.4148 67.4817 62.4148 67.6559C62.4151 67.7423 62.392 67.8314 62.3408 67.9068C62.1507 68.1884 61.9288 68.4424 61.7203 68.708C61.7186 68.708 61.717 68.708 61.7153 68.708C61.715 68.7096 61.7143 68.711 61.714 68.7126Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M62.9076 70.821C62.6191 70.7283 62.3306 70.6355 62.0425 70.5424C61.9063 70.4917 61.7697 70.4407 61.6338 70.3896C61.6884 70.2198 61.7429 70.0503 61.7985 69.8808C61.8045 69.8351 61.8072 69.791 61.8072 69.749C61.8069 69.5214 61.7208 69.3459 61.5525 69.2201C61.607 69.0513 61.6609 68.8821 61.7138 68.7126C61.7142 68.711 61.7148 68.7096 61.7152 68.7079C61.7168 68.7079 61.7185 68.7079 61.7202 68.7079C62.6 68.7473 62.7607 69.6135 63.0733 70.3045C63.0181 70.4767 62.9628 70.6489 62.9076 70.821ZM61.6332 70.3916L61.6318 70.3886C61.6325 70.389 61.6332 70.3893 61.6338 70.3896C61.6335 70.3903 61.6335 70.3909 61.6332 70.3916Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M62.1552 71.3774C62.1548 71.3774 62.1542 71.3774 62.1538 71.3774C62.0266 71.3768 61.935 71.2787 61.9353 71.0588C61.9353 71.0568 61.9353 71.0551 61.9353 71.0535C61.9366 70.8873 62.0043 70.7128 62.0424 70.5423C62.3306 70.6354 62.6191 70.7281 62.9072 70.8212C62.9075 70.8212 62.9075 70.8212 62.9075 70.8212C62.7265 70.9877 62.5591 71.1919 62.3604 71.3107C62.3587 71.3117 62.357 71.3127 62.3553 71.3137C62.3523 71.3157 62.349 71.3174 62.3456 71.3194C62.3429 71.3211 62.3399 71.3224 62.3372 71.3241C62.274 71.3584 62.2131 71.3768 62.1582 71.3774C62.1572 71.3774 62.1562 71.3774 62.1552 71.3774Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M61.3481 70.5657C61.3766 70.517 61.3983 70.4439 61.4351 70.4256C61.4937 70.3965 61.5617 70.4005 61.6256 70.3925C61.5329 70.4502 61.4409 70.5079 61.3481 70.5657ZM61.6256 70.3925C61.6279 70.3912 61.6299 70.3898 61.6319 70.3885L61.6329 70.3915C61.6306 70.3918 61.6283 70.3922 61.6256 70.3925Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M61.7985 69.8809C61.6315 69.7521 61.5444 69.5749 61.5444 69.3453C61.5444 69.3053 61.5471 69.2636 61.5525 69.2202C61.7208 69.346 61.8068 69.5215 61.8072 69.7491C61.8072 69.7911 61.8045 69.8351 61.7985 69.8809Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M58.3566 69.6125C58.3563 69.6125 58.3556 69.6126 58.3553 69.6122C58.2964 69.6109 58.2719 69.5171 58.2298 69.3139C58.2294 69.3112 58.2288 69.3089 58.2284 69.3066C58.2274 69.3022 58.2268 69.2982 58.2258 69.2942C58.2248 69.2882 58.2234 69.2819 58.2221 69.2759C58.2204 69.2679 58.2187 69.2595 58.217 69.2512C58.3599 69.2999 58.5029 69.3486 58.6458 69.397C58.6414 69.401 58.6374 69.405 58.6331 69.4087C58.6301 69.4113 58.627 69.4143 58.624 69.417C58.6223 69.4183 58.621 69.42 58.6193 69.4213C58.6187 69.422 58.6177 69.4227 58.617 69.4234C58.615 69.4254 58.613 69.427 58.611 69.429C58.5912 69.4471 58.5731 69.4637 58.5557 69.4791C58.5537 69.4808 58.5521 69.4824 58.5504 69.4841C58.5457 69.4881 58.541 69.4924 58.5363 69.4964C58.5316 69.5004 58.5269 69.5048 58.5226 69.5088C58.5186 69.5118 58.5149 69.5151 58.5112 69.5181C58.5032 69.5255 58.4952 69.5321 58.4875 69.5385C58.452 69.5678 58.4232 69.5885 58.3988 69.6005C58.3985 69.6009 58.3978 69.6012 58.3975 69.6015C58.3968 69.6015 58.3964 69.6019 58.3961 69.6019C58.3951 69.6025 58.3941 69.6029 58.3931 69.6032C58.3888 69.6052 58.3844 69.6069 58.3804 69.6082C58.3794 69.6085 58.3784 69.6089 58.3777 69.6092C58.3767 69.6092 58.376 69.6095 58.3754 69.6099C58.3687 69.6115 58.3626 69.6125 58.3566 69.6125Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M65.2027 71.0144C64.9212 70.921 64.6401 70.8275 64.3583 70.7338C64.3573 70.7335 64.3559 70.7331 64.3549 70.7328C64.3549 70.7311 64.3549 70.7295 64.3549 70.7278C64.3556 70.7058 64.3556 70.6841 64.3556 70.6621C64.3556 70.6043 64.3546 70.5463 64.3542 70.4886C64.3542 70.4021 64.357 70.3157 64.3697 70.23C64.37 70.2266 64.3706 70.2233 64.371 70.22C64.372 70.213 64.373 70.2063 64.3743 70.1993C64.375 70.1953 64.3753 70.1909 64.376 70.1866C64.377 70.1819 64.3777 70.1773 64.3784 70.1726C64.4279 69.8639 64.4838 69.7542 64.6669 69.7532C64.6679 69.7532 64.6685 69.7532 64.6692 69.7532C64.6715 69.7532 64.6739 69.7532 64.6762 69.7532C64.7355 69.7542 64.8078 69.7655 64.8971 69.7852C64.9038 69.7865 64.9105 69.7882 64.9175 69.7898C64.9235 69.7912 64.9299 69.7925 64.9363 69.7939C64.942 69.7952 64.9476 69.7969 64.9537 69.7982C65.1602 69.8469 65.3586 69.9263 65.5608 69.9917C65.4413 70.3327 65.3222 70.6737 65.2027 71.0144Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M64.847 74.8955C64.5652 74.8058 64.2831 74.7157 64.0009 74.6259C64.0006 74.6232 64.0003 74.6206 63.9999 74.6179C63.9996 74.6152 63.9989 74.6122 63.9986 74.6095C63.9979 74.6052 63.9969 74.6012 63.9963 74.5972C63.9963 74.5965 63.9959 74.5959 63.9959 74.5952C63.9956 74.5929 63.9949 74.5905 63.9946 74.5885C63.9785 74.5148 63.9507 74.4921 63.9219 74.4921C63.8995 74.4921 63.8768 74.5061 63.8587 74.5201C63.8406 74.5341 63.8276 74.5482 63.8249 74.5482C63.8246 74.5482 63.8242 74.5478 63.8242 74.5471C63.8242 74.5468 63.8242 74.5468 63.8242 74.5468C63.8246 74.5455 63.8256 74.5432 63.8272 74.5398C63.8312 74.5315 63.8396 74.5161 63.8533 74.4914C63.8537 74.4911 63.854 74.4908 63.8544 74.4901C63.8587 74.4818 63.864 74.4724 63.8701 74.4617C63.8714 74.4594 63.8724 74.4571 63.8738 74.4547C63.8778 74.4477 63.8818 74.4404 63.8862 74.4324C63.8875 74.43 63.8888 74.4277 63.8902 74.4254C63.8912 74.4237 63.8922 74.422 63.8932 74.4204C63.8942 74.4184 63.8952 74.4167 63.8965 74.415C63.9002 74.409 63.9039 74.403 63.9079 74.397C64.0398 74.1988 64.3353 74.0387 64.5963 74.0333C64.6007 74.0333 64.605 74.0333 64.6094 74.0333C64.6097 74.0333 64.6104 74.0333 64.6107 74.0333C64.6683 74.0333 64.7242 74.0413 64.7761 74.058C64.7781 74.0587 64.7804 74.0593 64.7824 74.0603C64.9213 74.108 64.9631 74.2182 64.9631 74.349C64.9631 74.4444 64.9407 74.5512 64.918 74.6526C64.8992 74.7343 64.8711 74.8148 64.847 74.8955Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M65.2029 71.0144C65.3224 70.6737 65.4415 70.3327 65.561 69.9917C65.6945 70.0378 65.8261 70.0895 65.9556 70.1465C65.9097 70.3094 65.8692 70.4729 65.8337 70.6374C65.6232 70.7632 65.4131 70.8886 65.2029 71.0144Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M64.9776 78.0212C64.9752 78.0212 64.9732 78.0212 64.9709 78.0212C64.9063 78.0196 64.834 77.9942 64.76 77.9425C64.754 77.9381 64.7476 77.9338 64.7416 77.9292C64.6251 77.8414 64.5328 77.7143 64.4297 77.6048C64.5294 77.2711 64.6295 76.9372 64.7299 76.6032C64.7329 76.5978 64.7359 76.5925 64.7393 76.5871C64.7433 76.5801 64.7473 76.5731 64.7517 76.5661C65.2523 75.7173 65.4521 75.4233 65.9408 75.4227C65.9414 75.4227 65.9421 75.4227 65.9428 75.4227C65.9448 75.4227 65.9465 75.4227 65.9485 75.4227C66.1637 75.4237 66.4348 75.4807 66.8116 75.5715C66.812 75.5718 66.8123 75.5718 66.8126 75.5718C66.825 75.5748 66.8374 75.5778 66.8498 75.5808C66.8568 75.5825 66.8638 75.5841 66.8708 75.5858C66.8775 75.5875 66.8846 75.5892 66.8913 75.5908C66.9167 75.5972 66.9428 75.6035 66.9693 75.6098C66.9666 75.6495 66.9656 75.6889 66.9652 75.7283C66.9652 75.9972 67.0158 76.2612 67.0154 76.5311C67.0154 76.7263 66.9887 76.9252 66.897 77.1314C66.8939 77.1384 66.8909 77.145 66.8876 77.152C66.8876 77.1524 66.8873 77.1527 66.8869 77.153C66.8856 77.1564 66.8836 77.1601 66.8819 77.1634C66.7775 77.3699 66.5693 77.5267 66.3879 77.5367C66.3819 77.5371 66.3759 77.5374 66.3698 77.5374C66.3692 77.5374 66.3685 77.5374 66.3678 77.5374C66.2935 77.5371 66.2243 77.5104 66.1704 77.451C66.1684 77.4487 66.1667 77.4467 66.1647 77.4443C65.9699 77.2174 65.8216 76.9372 65.6439 76.6899C65.6419 76.6876 65.6402 76.6852 65.6382 76.6829C65.6365 76.6809 65.6345 76.6792 65.6329 76.6772C65.6138 76.6582 65.5847 76.6409 65.5569 76.6288C65.5549 76.6282 65.5529 76.6275 65.5512 76.6269C65.5455 76.6245 65.5398 76.6225 65.5345 76.6209C65.5208 76.6165 65.508 76.6142 65.4976 76.6142C65.4976 76.6142 65.4973 76.6142 65.497 76.6142C65.4883 76.6142 65.4819 76.6162 65.4779 76.6202C65.3755 76.732 65.2323 76.8627 65.2128 76.9942C65.2035 77.0589 65.2001 77.124 65.2001 77.1894C65.2005 77.3379 65.2179 77.4874 65.2179 77.6368C65.2179 77.6765 65.2169 77.7166 65.2135 77.7563C65.2008 77.9261 65.1057 78.0209 64.9786 78.0212C64.9782 78.0212 64.9779 78.0212 64.9776 78.0212Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M64.0696 81.4172C64.0689 81.4172 64.0683 81.4172 64.0676 81.4172C63.9421 81.4169 63.8015 81.3695 63.6419 81.2628C63.6386 81.2604 63.6349 81.2581 63.6315 81.2557C63.6258 81.21 63.6228 81.165 63.6228 81.1213C63.6201 80.4436 64.252 80.0102 64.2503 79.0475C64.25 78.9364 64.2413 78.8186 64.2222 78.6925C64.6647 79.4786 64.8427 79.7956 65.0207 80.1126C64.9558 80.2697 64.9016 80.4306 64.8581 80.5951C64.8564 80.5984 64.8551 80.6018 64.8534 80.6051C64.8524 80.6078 64.8511 80.6104 64.8497 80.6134C64.6479 81.0596 64.417 81.4159 64.0716 81.4172C64.071 81.4172 64.0703 81.4172 64.0696 81.4172Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M65.5408 82.6042C65.2778 82.5185 65.0147 82.4328 64.7517 82.3474C64.7507 82.347 64.7497 82.3467 64.7486 82.3463C64.7473 82.346 64.746 82.3453 64.7446 82.345C64.8621 82.0033 64.9799 81.6613 65.0977 81.32C65.5221 81.5539 65.678 81.6396 65.6777 81.9032C65.6774 82.056 65.6245 82.2686 65.5408 82.6042Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M66.343 66.2385C66.515 65.7354 66.687 65.2319 66.8587 64.7287C66.9782 65.0727 67.0498 65.2962 67.0498 65.4694C67.0498 65.758 66.8511 65.9065 66.343 66.2385Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M66.0745 61.9851C66.0732 61.9851 66.0715 61.9851 66.0702 61.9851C65.8811 61.9838 65.7235 61.905 65.7044 61.6468C65.7037 61.6364 65.7034 61.6261 65.7034 61.6151C65.7034 61.4719 65.7673 61.2734 65.8567 61.1827C66.2114 60.825 66.5926 60.505 66.9638 60.1703C67.1053 60.2047 67.2452 60.2437 67.3838 60.2874C67.2091 60.8096 67.0347 61.3322 66.86 61.8547C66.6361 61.8964 66.4125 61.9474 66.189 61.9771C66.185 61.9775 66.1806 61.9781 66.1766 61.9785C66.1732 61.9788 66.1699 61.9795 66.1666 61.9798C66.1622 61.9801 66.1575 61.9808 66.1528 61.9811C66.1267 61.9838 66.1013 61.9851 66.0759 61.9851C66.0755 61.9851 66.0752 61.9851 66.0745 61.9851Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M67.9422 60.7419C67.9409 60.7419 67.9399 60.7419 67.9386 60.7419C67.8649 60.7406 67.791 60.7016 67.719 60.6332C67.717 60.6315 67.715 60.6298 67.7133 60.6278C67.713 60.6275 67.7126 60.6272 67.712 60.6268C67.706 60.6208 67.6996 60.6145 67.6932 60.6078C67.5915 60.5014 67.4901 60.3933 67.3887 60.2862C67.3907 60.2838 67.3927 60.2815 67.3947 60.2788C67.3961 60.2772 67.3974 60.2751 67.3991 60.2735C67.4007 60.2715 67.4021 60.2695 67.4037 60.2678C67.5821 60.0509 67.7696 59.9805 67.961 59.9792C67.9627 59.9792 67.9643 59.9792 67.9657 59.9792C67.967 59.9792 67.968 59.9792 67.9694 59.9795C68.1116 59.9799 68.2562 60.0179 68.4014 60.0619C68.4048 60.0629 68.4081 60.0643 68.4115 60.0653C68.3469 60.2248 68.3014 60.3986 68.2137 60.5411C68.2107 60.5461 68.2073 60.5511 68.2043 60.5561C68.2036 60.5571 68.203 60.5581 68.2023 60.5591C68.2006 60.5614 68.1993 60.5638 68.1976 60.5661C68.1176 60.6862 68.0326 60.7403 67.9466 60.7419C67.9452 60.7419 67.9439 60.7419 67.9422 60.7419Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M69.8844 82.0854C69.8834 82.0854 69.8824 82.0854 69.8813 82.0854C69.3713 82.0841 69.0025 81.7625 68.7655 81.1409C68.7609 81.1292 68.7565 81.1175 68.7521 81.1058C68.7508 81.1015 68.7491 81.0975 68.7478 81.0932C68.7461 81.0885 68.7441 81.0835 68.7424 81.0788C68.7438 81.0754 68.7451 81.0724 68.7465 81.0691C68.7518 81.0564 68.7575 81.0438 68.7629 81.0314C68.7635 81.0294 68.7645 81.0277 68.7652 81.0257C69.0159 80.4555 69.3395 80.0565 69.8291 80.0521C69.8318 80.0521 69.8345 80.0521 69.8372 80.0521C69.8378 80.0521 69.8382 80.0521 69.8388 80.0521C69.9449 80.0524 70.0584 80.0711 70.1809 80.1102C70.1842 80.1112 70.1872 80.1122 70.1902 80.1132L70.1946 80.1225C70.305 80.7305 70.4152 81.3381 70.5256 81.9457L70.5243 81.947C70.5149 81.9507 70.5055 81.9543 70.4962 81.958C70.2743 82.0428 70.0715 82.0851 69.8867 82.0854C69.886 82.0854 69.8854 82.0854 69.8844 82.0854Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M70.1945 80.1228L70.1902 80.1135C70.3237 79.7821 70.4512 79.4478 70.5955 79.1218C70.6249 79.0554 70.718 79.02 70.7812 78.9703C70.8053 79.1005 70.8656 79.2372 70.8652 79.3634C70.8652 79.388 70.8629 79.4124 70.8572 79.4361C70.7709 79.8175 70.5349 80.0534 70.1945 80.1228Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M71.27 81.0803C71.1686 80.9589 71.1153 80.8561 71.115 80.774C71.1147 80.6539 71.2275 80.5778 71.4681 80.5518C71.4022 80.728 71.3359 80.9041 71.27 81.0803Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M75.0101 71.4409C74.9704 71.3365 74.9307 71.232 74.8906 71.1279C74.9293 71.1556 74.9884 71.1727 75.0004 71.2137C75.0104 71.2471 75.0128 71.2848 75.0128 71.3235C75.0128 71.3548 75.0111 71.3869 75.0111 71.4186C75.0111 71.4259 75.0111 71.4329 75.0114 71.4403L75.0101 71.4409Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M39.7292 69.3591C39.7288 69.3591 39.7285 69.3588 39.7282 69.3588C39.5873 69.3121 39.447 69.2637 39.3071 69.2136C39.3091 69.212 39.3111 69.2103 39.3128 69.2086C39.3138 69.208 39.3145 69.2073 39.3155 69.2063C39.3249 69.1983 39.3339 69.1899 39.3426 69.1823C39.3459 69.1793 39.3493 69.1766 39.3523 69.1736C39.354 69.1723 39.3553 69.1713 39.3566 69.1699C39.358 69.1686 39.3597 69.1673 39.3614 69.1659C39.363 69.1643 39.365 69.1626 39.367 69.1609C39.3771 69.1519 39.3868 69.1436 39.3958 69.1356C39.3965 69.1349 39.3972 69.1342 39.3978 69.1339C39.4885 69.0552 39.5467 69.0108 39.5879 69.0064C39.5903 69.0061 39.5926 69.0061 39.5946 69.0061C39.5949 69.0061 39.5953 69.0061 39.5956 69.0061C39.6569 69.0068 39.6793 69.1055 39.7218 69.3224C39.7228 69.3264 39.7235 69.3301 39.7241 69.3341C39.7248 69.3368 39.7251 69.3391 39.7258 69.3418C39.7261 69.3444 39.7268 69.3468 39.7271 69.3495C39.7278 69.3525 39.7285 69.3554 39.7288 69.3588C39.7291 69.3588 39.7292 69.3588 39.7292 69.3591Z"
      fill="#DBDFF3"
      fillOpacity="0.3"
    />
    <path
      d="M117.541 33.4294C117.303 33.4944 116.975 33.4307 116.624 33.2529C116.497 33.1878 116.386 33.1197 116.299 33.049C116.343 32.8855 116.329 32.7063 116.242 32.5448C116.175 32.418 116.068 32.3326 115.948 32.2705C115.968 32.1464 116.018 32.0083 116.132 31.8561C116.513 31.346 117.286 31.0453 117.819 31.1978C118.324 31.3433 118.424 31.7694 118.421 32.1014C118.418 32.6316 118.106 33.2776 117.541 33.4294ZM96.3152 5.90268C96.6957 5.39551 97.4672 5.09189 98 5.24871C98.5043 5.39219 98.6067 5.81928 98.6037 6.1496C98.5987 6.68013 98.2888 7.32743 97.7239 7.47758C97.4846 7.54432 97.1582 7.48093 96.8055 7.30075C96.5451 7.17062 96.3624 7.02715 96.2627 6.87366C96.1853 6.75355 95.9514 6.39317 96.3152 5.90268ZM75.5769 9.47289C75.7332 9.26268 76.0381 9.11587 76.28 9.11587C76.3266 9.11587 76.3714 9.1192 76.4119 9.13255C76.4725 9.14923 76.6331 9.19596 76.6308 9.48625C76.6285 9.74318 76.4772 10.0568 76.2375 10.1202C76.1422 10.1502 75.9819 10.1102 75.8105 10.0234C75.6482 9.94002 75.5802 9.87331 75.5518 9.8266H75.5515C75.4952 9.73985 75.4507 9.64306 75.5769 9.47289ZM86.0028 2.07222C86.383 1.56171 87.1547 1.25806 87.6875 1.41489C88.1919 1.55836 88.294 1.98545 88.2913 2.31578C88.2866 2.84631 87.9764 3.49361 87.4111 3.64376C87.1722 3.71049 86.8455 3.64711 86.4927 3.46693C86.2327 3.3368 86.05 3.19333 85.9499 3.03984C85.8733 2.91972 85.639 2.55936 86.0028 2.07222ZM91.3242 4.6748C91.4805 4.46459 91.7853 4.31777 92.0276 4.31777C92.0742 4.31777 92.119 4.32111 92.1595 4.33446C92.2201 4.35114 92.3807 4.39787 92.3777 4.68816C92.3757 4.94175 92.2244 5.25873 91.9838 5.32212C91.8884 5.34882 91.7295 5.3121 91.5584 5.22535C91.3958 5.14193 91.3278 5.07185 91.2994 5.02847H91.2991C91.2428 4.94172 91.1983 4.84497 91.3242 4.6748ZM101.674 9.50626C101.828 9.29605 102.132 9.14923 102.377 9.14923C102.423 9.14923 102.467 9.15257 102.507 9.16591C102.567 9.1826 102.728 9.22933 102.728 9.51962C102.725 9.77654 102.574 10.0902 102.333 10.1536C102.236 10.1836 102.079 10.1436 101.908 10.0568C101.744 9.97339 101.677 9.90668 101.647 9.85996C101.59 9.77321 101.547 9.67643 101.674 9.50626ZM108.548 14.1943C108.93 13.6837 109.699 13.3801 110.231 13.5369C110.737 13.6837 110.841 14.1108 110.837 14.4412C110.831 14.9717 110.523 15.619 109.957 15.7692C109.82 15.8092 109.656 15.7992 109.472 15.7558C109.445 15.7424 109.422 15.7191 109.388 15.7091C109.355 15.6991 109.321 15.7058 109.288 15.7024C109.204 15.6724 109.124 15.6357 109.037 15.5923C108.779 15.4622 108.595 15.3154 108.494 15.1619C108.417 15.0451 108.183 14.6847 108.548 14.1943ZM115.268 18.2016C115.426 17.9914 115.73 17.8446 115.971 17.8446C116.018 17.8446 116.062 17.8512 116.105 17.8612C116.165 17.8779 116.326 17.9246 116.323 18.2149C116.319 18.4718 116.169 18.7855 115.928 18.8522C115.834 18.8789 115.673 18.8389 115.503 18.7521C115.339 18.6687 115.272 18.602 115.245 18.5586H115.242C115.188 18.4685 115.141 18.3718 115.268 18.2016ZM118.203 29.8772C117.119 29.5665 115.754 30.0627 115.027 31.036C114.666 31.5191 114.515 32.064 114.572 32.5989C112.467 33.447 110.077 33.3777 108.17 33.2025C104.612 32.8752 101.647 32.0987 99.1118 30.8295C96.8206 29.6817 94.8952 28.0851 93.5257 26.2376C94.6545 26.7157 95.864 27.1118 97.1666 27.3987C98.6686 27.729 100.141 27.8939 101.557 27.8939C103.414 27.8939 105.171 27.6092 106.761 27.0433C109.465 26.0807 114.12 23.3967 115.519 20.1869C115.633 20.2102 115.75 20.2336 115.861 20.2336C116.008 20.2336 116.152 20.2136 116.289 20.1769C117.099 19.96 117.691 19.1392 117.701 18.2283C117.708 17.4075 117.243 16.7601 116.487 16.5399C115.69 16.313 114.693 16.6734 114.164 17.3841C113.719 17.978 113.692 18.6954 114.087 19.3027C114.144 19.3928 114.217 19.4762 114.294 19.5562C113.2 22.2256 108.913 24.8181 106.296 25.7497C103.742 26.66 100.686 26.7667 97.4642 26.057C96.8062 25.9122 96.181 25.7317 95.5709 25.5355C95.7299 25.5389 95.8848 25.5522 96.0465 25.5522C97.187 25.5522 98.3922 25.4154 99.6021 25.1351C100.931 24.8282 102.661 24.361 104.251 23.4902C106.747 22.1188 108.679 19.8299 109.642 17.1605C109.679 17.1639 109.719 17.1672 109.756 17.1672C109.95 17.1672 110.138 17.1438 110.315 17.0971C111.55 16.7635 112.206 15.5156 112.213 14.4545C112.223 13.3634 111.61 12.5059 110.616 12.2189C109.532 11.9053 108.166 12.4025 107.44 13.3734C106.858 14.1609 106.818 15.1085 107.336 15.9093C107.557 16.2496 107.885 16.5299 108.32 16.7668C107.464 19.0958 105.77 21.0878 103.585 22.2856C102.146 23.0764 100.532 23.5068 99.2901 23.7971C97.4521 24.2209 95.6445 24.2909 94.1214 24.0207C96.1857 22.5459 97.6549 20.3937 98.843 18.4084C100.158 16.2062 101.326 13.8906 102.33 11.5283C102.454 11.525 102.574 11.5116 102.691 11.4816C103.501 11.2613 104.097 10.4439 104.103 9.53295C104.114 8.71213 103.648 8.06483 102.892 7.84462C102.095 7.61772 101.095 7.97809 100.566 8.68546C100.124 9.27938 100.094 10.0001 100.489 10.6074C100.619 10.8042 100.79 10.971 101.004 11.1179C100.04 13.3801 98.919 15.5956 97.6589 17.7044C96.3192 19.9466 94.6104 22.4024 92.0969 23.6336L92.0702 23.6536C92.2522 18.8622 93.9477 13.607 96.8728 8.79224C97.095 8.84896 97.3125 8.87898 97.5237 8.87898C97.7172 8.87898 97.9036 8.85561 98.0833 8.80556C99.3169 8.4719 99.9736 7.22399 99.9836 6.16293C99.9903 5.07185 99.3792 4.21433 98.3838 3.92738C97.2995 3.61373 95.9347 4.1109 95.2087 5.0852C94.6237 5.86931 94.5849 6.81693 95.1053 7.61773C95.2416 7.82794 95.421 8.01477 95.6375 8.1816C92.8573 12.7895 91.1491 17.7945 90.7582 22.4658C89.715 21.1011 89.3251 19.2693 89.1912 17.8279C88.8318 13.954 89.7565 10.0068 91.786 6.68679C91.8292 6.69013 91.8737 6.70348 91.9159 6.70348C92.0628 6.70348 92.206 6.68681 92.3432 6.6501C93.1535 6.42988 93.7479 5.61239 93.7563 4.70149C93.764 3.87733 93.2988 3.23338 92.5431 3.01316C91.7469 2.78293 90.7468 3.14663 90.218 3.854C89.7756 4.44792 89.7468 5.16529 90.1417 5.77589C90.2344 5.91937 90.3509 6.04615 90.4905 6.16293C88.3887 9.69311 87.4392 13.8639 87.8191 17.9547C87.8991 18.8155 88.0651 19.7998 88.3807 20.7741C87.063 19.1659 86.0864 17.2806 85.5613 15.262C84.6711 11.8419 85.1012 8.12489 86.731 4.99178C86.894 5.02181 87.0547 5.04515 87.2116 5.04515C87.4041 5.04515 87.5918 5.02182 87.7709 4.97178C89.0042 4.63811 89.6598 3.3902 89.6692 2.32914C89.6792 1.23806 89.0671 0.380539 88.0711 0.0935898C86.9871 -0.220055 85.6222 0.277111 84.8967 1.25141C84.3116 2.03553 84.2728 2.98311 84.7926 3.78391H84.7929C84.9569 4.03749 85.1801 4.25439 85.4603 4.44791C83.7139 7.86464 83.2607 11.8953 84.2273 15.609C85.0831 18.8956 87.0346 21.8619 89.6849 23.9806C86.7421 23.4534 83.9348 22.1622 81.7544 20.2669C79.1134 17.9747 77.2838 14.8616 76.5371 11.4549L76.5963 11.4482C77.4066 11.228 78.0006 10.4105 78.009 9.49958C78.016 8.67876 77.5515 8.03147 76.7955 7.81125C75.9993 7.58436 74.9996 7.94472 74.4708 8.65209C74.0277 9.24601 73.9992 9.96338 74.3941 10.574C74.5498 10.8142 74.7717 11.0111 75.0615 11.1779C75.7827 15.0918 77.837 18.6887 80.8494 21.3047C83.4388 23.5536 86.8365 25.025 90.3496 25.4755C88.5949 28.8875 85.3883 31.695 81.3872 33.2722C77.5779 34.7734 72.9878 35.2005 68.1139 34.5041C67.7377 34.4511 67.388 34.7116 67.3344 35.0873C67.2805 35.463 67.5419 35.8114 67.9188 35.8648C69.5031 36.091 71.0601 36.2031 72.5755 36.2031C75.9484 36.2031 79.1121 35.6469 81.8939 34.5498C86.2725 32.8241 89.7786 29.714 91.6662 25.9279C93.1699 28.4284 95.5598 30.5885 98.4936 32.0573C101.185 33.4053 104.311 34.2272 108.043 34.5712C108.762 34.6376 109.545 34.6899 110.362 34.6899C111.915 34.6899 113.582 34.4961 115.148 33.8528C115.365 34.092 115.647 34.2986 115.998 34.4781C116.46 34.711 116.915 34.8291 117.34 34.8291C117.534 34.8291 117.722 34.8047 117.902 34.7563C119.134 34.4237 119.79 33.1751 119.8 32.1134C119.81 31.022 119.197 30.1651 118.203 29.8772Z"
      fill="#3D5D82"
    />
    <path
      d="M21.6956 128.562H21.6953C21.6729 128.608 21.6618 128.632 21.5638 128.625C21.3489 128.607 21.1176 128.424 21.0785 128.287C21.0681 128.25 21.0534 128.199 21.1742 128.125C21.2565 128.075 21.3556 128.05 21.4443 128.05C21.5209 128.05 21.5899 128.069 21.6317 128.108C21.6521 128.127 21.6939 128.205 21.708 128.362C21.72 128.501 21.7 128.552 21.6956 128.562ZM12.494 124.314C12.419 124.474 12.2872 124.656 11.9254 124.622C11.4622 124.584 10.9615 124.216 10.8534 123.835C10.7771 123.566 10.8819 123.342 11.1643 123.17C11.337 123.065 11.5592 123.001 11.7741 123.001C11.9759 123.001 12.172 123.058 12.3139 123.19C12.4391 123.306 12.5218 123.529 12.5472 123.818C12.5659 124.032 12.5482 124.199 12.494 124.314ZM11.5686 119.763C11.5462 119.81 11.5358 119.835 11.4367 119.826C11.2222 119.808 10.9909 119.626 10.9521 119.488C10.9411 119.451 10.9267 119.4 11.0482 119.326C11.1298 119.277 11.2296 119.251 11.3179 119.251C11.3949 119.251 11.4632 119.27 11.5054 119.309C11.5251 119.328 11.5673 119.406 11.581 119.564C11.5934 119.701 11.5729 119.753 11.5686 119.763ZM10.7068 115.542C10.6318 115.701 10.4996 115.878 10.1382 115.85C9.675 115.812 9.17398 115.445 9.06588 115.062C8.98991 114.794 9.09466 114.57 9.37713 114.398C9.54982 114.293 9.77204 114.229 9.98657 114.229C10.1887 114.229 10.3848 114.285 10.5267 114.418C10.6519 114.534 10.7346 114.757 10.76 115.046C10.7788 115.26 10.761 115.427 10.7068 115.542ZM10.4595 110.535C10.4367 110.583 10.4253 110.608 10.3273 110.598C10.1131 110.581 9.88149 110.398 9.84267 110.26C9.83229 110.223 9.81791 110.173 9.93872 110.099C10.0204 110.049 10.1198 110.024 10.2085 110.024C10.2855 110.024 10.3537 110.043 10.3959 110.082C10.4163 110.1 10.4581 110.178 10.4719 110.336C10.4842 110.474 10.4638 110.526 10.4595 110.535ZM11.1867 103.522C11.1114 103.681 10.9796 103.861 10.6174 103.83C10.1549 103.792 9.65391 103.424 9.54548 103.043C9.46951 102.774 9.57425 102.55 9.85672 102.378C10.0298 102.273 10.2516 102.209 10.4662 102.209C10.6686 102.209 10.8644 102.265 11.0067 102.398C11.0739 102.461 11.1278 102.556 11.1683 102.675L11.174 102.755L11.2108 102.829C11.2239 102.89 11.2336 102.956 11.2396 103.026C11.2587 103.24 11.2406 103.407 11.1867 103.522ZM10.6318 97.3993C10.6091 97.4467 10.5987 97.4723 10.5 97.4623C10.2855 97.4447 10.0538 97.2621 10.015 97.1247C10.0043 97.0873 9.98993 97.0369 10.1108 96.9628C10.1927 96.9135 10.2925 96.8878 10.3808 96.8878C10.4578 96.8878 10.5264 96.9068 10.5683 96.9455C10.5887 96.9642 10.6305 97.0422 10.6446 97.2004C10.6566 97.3379 10.6362 97.3896 10.6318 97.3993ZM19.6079 90.9749C19.1447 90.9365 18.6437 90.5688 18.5356 90.1871C18.4596 89.9182 18.5644 89.6946 18.8468 89.5228C19.0195 89.4174 19.2414 89.3536 19.4563 89.3536C19.6584 89.3536 19.8546 89.41 19.9965 89.5421C20.1213 89.6583 20.2043 89.8811 20.2297 90.1708C20.2371 90.2548 20.2341 90.3259 20.2301 90.3953C20.1059 90.4527 19.9924 90.5361 19.9185 90.6636C19.8639 90.758 19.8412 90.8594 19.8348 90.9615C19.7709 90.9759 19.6962 90.9819 19.6079 90.9749ZM36.317 113.469C33.2715 111.223 29.6596 110.136 26.2509 110.402C27.277 108.302 27.7148 105.776 27.4745 103.177C27.2473 100.721 26.4668 98.1964 25.0882 95.458C24.3242 93.9402 23.2462 92.1057 21.5514 90.8661C21.6093 90.6199 21.629 90.352 21.6029 90.051C21.5467 89.413 21.3154 88.8888 20.9356 88.5365C20.1257 87.7844 18.9108 87.8745 18.1286 88.3499C17.3154 88.8451 16.9629 89.692 17.2096 90.5602C17.4733 91.4921 18.4556 92.2588 19.4951 92.3443C19.5577 92.3496 19.6196 92.3516 19.6812 92.3516C20.0985 92.3516 20.4764 92.2298 20.7893 92.0103C22.2224 93.083 23.1729 94.7169 23.856 96.074C25.1562 98.6565 25.8908 101.022 26.1023 103.303C26.276 105.181 26.0595 107.007 25.5012 108.623C25.3423 107.786 25.111 106.935 24.8051 106.073C23.8295 103.322 22.2987 101.065 20.379 99.5477C18.5503 98.1016 14.7116 96.0633 11.8474 96.4183C11.7624 96.2334 11.6493 96.0716 11.5077 95.9398C10.9652 95.4373 10.0756 95.3743 9.39219 95.7907C8.77706 96.1654 8.50061 96.8357 8.6887 97.4977C8.88917 98.2067 9.60371 98.768 10.3872 98.8324C10.4354 98.8357 10.4829 98.8377 10.5304 98.8377C11.1262 98.8377 11.6238 98.5257 11.8795 97.9829C11.9073 97.9238 11.9167 97.8557 11.9367 97.793C14.2273 97.449 17.7812 99.2471 19.5226 100.624C21.2391 101.981 22.6167 104.024 23.5059 106.531C23.5852 106.753 23.6455 106.972 23.7137 107.193C23.2693 106.545 22.7465 105.913 22.1528 105.322C21.3596 104.531 20.2819 103.53 18.9777 102.802C16.9462 101.668 14.5288 101.313 12.2533 101.779C12.1643 101.636 12.0649 101.503 11.9451 101.392C11.1359 100.64 9.92031 100.729 9.1385 101.205C8.32524 101.701 7.97317 102.547 8.21915 103.416C8.48355 104.348 9.46582 105.114 10.505 105.2C10.5676 105.205 10.6298 105.207 10.6907 105.207C11.4615 105.207 12.1044 104.805 12.4341 104.105C12.5713 103.814 12.6299 103.483 12.6198 103.104C14.5469 102.729 16.5864 103.041 18.3047 104.001C19.4613 104.646 20.4483 105.565 21.1782 106.293C22.1699 107.281 22.9443 108.379 23.4199 109.447C21.5607 108.752 19.5303 108.674 17.716 108.711C15.6396 108.752 13.5506 108.941 11.497 109.262C11.4471 109.196 11.3949 109.132 11.335 109.076C10.7928 108.572 9.90358 108.51 9.22016 108.926C8.60469 109.301 8.32858 109.971 8.516 110.634C8.71714 111.343 9.43168 111.904 10.2145 111.968C10.263 111.971 10.3106 111.973 10.3577 111.973C10.9535 111.973 11.4515 111.661 11.7065 111.119C11.7801 110.963 11.8169 110.787 11.8353 110.6C13.7872 110.302 15.7715 110.124 17.7434 110.085C19.7936 110.036 22.127 110.16 24.0076 111.246C20.6705 113.095 16.4338 114.146 11.9722 114.214C11.8571 113.896 11.6911 113.621 11.4659 113.412C10.6563 112.66 9.44105 112.749 8.65891 113.226C7.84564 113.721 7.49356 114.567 7.73988 115.436C8.00361 116.367 8.98589 117.135 10.0254 117.22C10.088 117.225 10.1499 117.227 10.2115 117.227C10.9816 117.227 11.6248 116.825 11.9545 116.126C12.0335 115.958 12.0867 115.779 12.1168 115.584C16.3622 115.502 20.4302 114.577 23.7736 112.934C23.2425 114.072 22.2572 115.002 21.4038 115.648C18.9114 117.536 15.8297 118.587 12.7015 118.636C12.6285 118.513 12.5462 118.398 12.4441 118.303C11.9019 117.801 11.0127 117.738 10.3289 118.154C9.71381 118.529 9.43772 119.199 9.62547 119.861C9.82628 120.57 10.5408 121.132 11.324 121.196C11.3722 121.199 11.42 121.201 11.4672 121.201C12.0629 121.201 12.5603 120.889 12.8163 120.346C12.8662 120.24 12.8953 120.122 12.9197 120C16.2718 119.907 19.5647 118.767 22.2378 116.742C22.6548 116.426 23.0983 116.048 23.5213 115.616C22.9744 116.965 22.1826 118.215 21.1735 119.274C19.225 121.32 16.5262 122.595 13.7105 122.841C13.5981 122.583 13.4445 122.362 13.253 122.184C12.4434 121.432 11.2282 121.521 10.4461 121.998C9.63282 122.493 9.2804 123.339 9.52706 124.208C9.79079 125.14 10.7731 125.907 11.8126 125.992C11.8752 125.997 11.9374 125.999 11.9983 125.999C12.7688 125.999 13.412 125.597 13.7413 124.897C13.8407 124.687 13.8963 124.454 13.9187 124.2C17.0339 123.906 20.0152 122.486 22.1729 120.22C24.0005 118.302 25.188 115.825 25.5943 113.219C26.363 115.343 26.6057 117.653 26.259 119.809C25.8168 122.555 24.4882 125.102 22.5126 127.057C21.9667 126.599 21.1163 126.55 20.456 126.952C19.8408 127.327 19.5644 127.998 19.7521 128.66C19.9529 129.369 20.6671 129.93 21.4506 129.995C21.4992 129.998 21.5467 130 21.5939 130C22.1896 130 22.6873 129.688 22.943 129.145C23.0407 128.938 23.0762 128.695 23.0762 128.433C25.4875 126.23 27.1013 123.248 27.6194 120.026C28.0582 117.303 27.6415 114.362 26.4849 111.762C29.5274 111.559 32.7554 112.551 35.4967 114.573C38.1658 116.542 40.4279 119.509 42.0387 123.153C42.1525 123.41 42.4048 123.563 42.6695 123.563C42.7623 123.563 42.857 123.544 42.9473 123.505C43.2954 123.351 43.4534 122.946 43.2998 122.599C41.5926 118.737 39.1779 115.579 36.317 113.469Z"
      fill="#3D5D82"
    />
    <path
      d="M109.13 59.0474L109.298 60.023C109.341 60.2713 109.328 60.4698 109.251 60.6213C109.177 60.7731 109.053 60.8632 108.883 60.8926C108.531 60.953 108.307 60.7274 108.22 60.2162L108.053 59.2312L109.13 59.0474ZM110.978 58.7307L111.132 59.6193C111.215 60.1088 111.085 60.3827 110.744 60.4418C110.399 60.5008 110.185 60.29 110.101 59.8111L109.947 58.9079L110.978 58.7307ZM107.916 62.0103C108.2 62.2963 108.548 62.4034 108.963 62.3336C109.244 62.2853 109.472 62.1418 109.649 61.9042C109.83 61.6653 109.924 61.369 109.93 61.012C110.041 61.298 110.208 61.5165 110.432 61.667C110.653 61.8171 110.911 61.8669 111.202 61.8171C111.597 61.7501 111.871 61.5392 112.032 61.1852C112.189 60.8308 112.216 60.3637 112.119 59.7828L111.671 57.1915L106.871 58.013L107.326 60.6687C107.43 61.2763 107.628 61.7234 107.916 62.0103Z"
      fill="#3D5D82"
    />
    <path
      d="M111.436 70.7586C111.179 71.0242 110.837 71.1543 110.409 71.1477C109.981 71.141 109.643 70.9988 109.395 70.7209C109.147 70.4443 109.027 70.0796 109.033 69.6258C109.043 69.167 109.174 68.8046 109.432 68.539C109.689 68.2734 110.031 68.143 110.456 68.1497C110.888 68.1563 111.229 68.2975 111.473 68.5728C111.721 68.846 111.838 69.2127 111.831 69.6715C111.825 70.1303 111.694 70.4927 111.436 70.7586ZM111.761 67.1353C111.383 66.8697 110.958 66.7326 110.483 66.7246C110.004 66.7166 109.572 66.84 109.187 67.0936C108.799 67.3459 108.498 67.6936 108.277 68.135C108.056 68.5764 107.942 69.0676 107.932 69.6085C107.922 70.1493 108.023 70.6431 108.227 71.0913C108.434 71.5394 108.726 71.8964 109.104 72.162C109.482 72.4279 109.907 72.5647 110.386 72.5727C110.864 72.5794 111.293 72.4586 111.677 72.2077C112.059 71.9581 112.36 71.6118 112.584 71.1703C112.805 70.7289 112.919 70.2351 112.929 69.6889C112.936 69.1483 112.839 68.6545 112.631 68.2061C112.424 67.7566 112.133 67.3996 111.761 67.1353Z"
      fill="#3D5D82"
    />
    <path
      d="M111.041 78.7751L107.176 78.0276L106.908 79.411L110.77 80.1588L110.469 81.702L111.39 81.8801L112.256 77.425L111.336 77.2469L111.041 78.7751Z"
      fill="#3D5D82"
    />
    <path
      d="M106.503 87.2624L107.912 88.5827L105.981 88.6147L106.503 87.2624ZM105.098 85.9501L105.797 86.6047L105.014 88.6311L104.057 88.6484L103.518 90.0398L108.796 89.7916L109.378 88.2861L105.626 84.5744L105.098 85.9501Z"
      fill="#3D5D82"
    />
    <path
      d="M100.914 94.8926L103.454 96.4638L99.6757 96.8826L98.9341 98.0727L103.076 100.633L103.816 99.4431L101.252 97.8569L105.054 97.4515L105.794 96.2613L101.654 93.7024L100.914 94.8926Z"
      fill="#3D5D82"
    />
    <path
      d="M95.1855 102.76L98.8884 105.917L99.7997 104.853L96.0995 101.696L95.1855 102.76Z"
      fill="#3D5D82"
    />
    <path
      d="M93.7747 107.83C93.4601 107.465 93.0909 107.216 92.6696 107.082C92.2475 106.948 91.8055 106.942 91.3466 107.061C90.8864 107.181 90.4423 107.424 90.0142 107.791C89.4527 108.272 89.0962 108.793 88.943 109.357C88.7897 109.921 88.8392 110.456 89.0895 110.966L90.2171 110C90.1568 109.761 90.1702 109.519 90.2589 109.275C90.3479 109.03 90.5109 108.807 90.7479 108.603C91.0584 108.336 91.3911 108.215 91.7452 108.241C92.1003 108.266 92.4156 108.439 92.69 108.759C92.9658 109.078 93.0909 109.416 93.0642 109.77C93.0384 110.124 92.8691 110.436 92.5578 110.703C92.3208 110.906 92.0749 111.033 91.8182 111.083C91.5621 111.134 91.3182 111.109 91.0899 111.01L89.9621 111.977C90.4316 112.304 90.9577 112.434 91.538 112.366C92.1177 112.297 92.6887 112.022 93.2486 111.541C93.6766 111.175 93.9849 110.774 94.172 110.338C94.3591 109.903 94.4179 109.467 94.3497 109.031C94.2811 108.595 94.0886 108.195 93.7747 107.83Z"
      fill="#3D5D82"
    />
    <path
      d="M82.4472 115.272L83.707 114.549L83.968 116.46L82.4472 115.272ZM83.4432 112.646L83.5738 113.595L81.6865 114.677L80.9301 114.09L79.6343 114.833L83.8927 117.954L85.295 117.149L84.7244 111.91L83.4432 112.646Z"
      fill="#3D5D82"
    />
    <path
      d="M72.7671 117.615L73.082 118.458L74.8384 117.808L76.2193 121.517L77.5373 121.03L75.8398 116.477L72.7671 117.615Z"
      fill="#3D5D82"
    />
    <path
      d="M69.1407 121.524C68.9389 121.365 68.714 121.261 68.4667 121.21C68.219 121.159 67.9051 121.118 67.5242 121.086C67.2629 121.065 67.057 121.041 66.9068 121.018C66.7572 120.994 66.6266 120.951 66.5162 120.889C66.4061 120.827 66.3385 120.735 66.314 120.614C66.2873 120.48 66.3171 120.362 66.4031 120.259C66.4881 120.159 66.6199 120.091 66.7976 120.054C67.0004 120.014 67.1798 120.032 67.3314 120.109C67.4841 120.186 67.5891 120.312 67.6467 120.488L69.1126 120.195C68.9804 119.735 68.6819 119.417 68.216 119.238C67.7502 119.061 67.1986 119.036 66.5594 119.163C66.1353 119.248 65.7866 119.383 65.5135 119.568C65.2414 119.754 65.0489 119.967 64.9385 120.21C64.8284 120.451 64.7986 120.697 64.8488 120.949C64.9104 121.259 65.0449 121.494 65.2494 121.654C65.4552 121.813 65.6845 121.921 65.9349 121.976C66.1865 122.031 66.5055 122.073 66.8904 122.103C67.1584 122.129 67.3639 122.153 67.5082 122.176C67.6534 122.199 67.7772 122.24 67.881 122.301C67.9861 122.363 68.049 122.448 68.0721 122.561C68.1002 122.701 68.0721 122.816 67.9871 122.907C67.9027 122.999 67.7786 123.062 67.6173 123.094C67.4298 123.131 67.2712 123.114 67.1434 123.044C67.0142 122.974 66.9215 122.863 66.8619 122.711L65.3722 123.009C65.5095 123.44 65.7893 123.743 66.2136 123.92C66.6373 124.097 67.1661 124.123 67.799 123.996C68.1919 123.918 68.5286 123.793 68.8094 123.622C69.0909 123.452 69.297 123.245 69.4262 123.005C69.5567 122.764 69.5932 122.502 69.5367 122.219C69.4747 121.914 69.3442 121.682 69.1407 121.524Z"
      fill="#3D5D82"
    />
    <path
      d="M1.57837 75.5057L1.5014 74.7973C1.44116 74.2378 1.62389 73.9358 2.04793 73.8901C2.46394 73.8444 2.70222 74.1023 2.7628 74.6619L2.83944 75.3702L1.57837 75.5057ZM3.77754 75.2695L3.68485 74.4053C3.63632 73.9558 3.5272 73.5801 3.35752 73.2795C3.18918 72.9792 2.978 72.7616 2.72632 72.6262C2.47331 72.492 2.19619 72.441 1.89465 72.473C1.41171 72.5254 1.04523 72.7456 0.798903 73.1347C0.551242 73.5237 0.465245 74.0593 0.538874 74.7436L0.78284 76.9995L5.62697 76.4787L5.47771 75.086L3.77754 75.2695Z"
      fill="#3D5D82"
    />
    <path
      d="M4.18821 67.523C4.51786 67.3422 4.77223 67.0789 4.95128 66.7356C5.13033 66.3919 5.23509 65.9878 5.26622 65.5251C5.296 65.0623 5.24478 64.6408 5.10991 64.2634C4.97671 63.8854 4.76051 63.5791 4.45997 63.3459C4.1601 63.1136 3.78024 62.9822 3.32273 62.9511L0.516456 62.7673L0.424763 64.1657L3.2297 64.3495C3.54999 64.3696 3.79095 64.4717 3.94891 64.6542C4.10722 64.838 4.17482 65.0929 4.15307 65.4189C4.13165 65.7463 4.03091 65.9892 3.85052 66.1503C3.66879 66.3115 3.41846 66.3812 3.09784 66.3595L0.291562 66.1757L0.200195 67.5647L3.00479 67.7486C3.46363 67.7796 3.85821 67.7042 4.18821 67.523Z"
      fill="#3D5D82"
    />
    <path
      d="M4.06687 55.8111L3.85803 56.6536L2.66021 56.36L2.86872 55.5158C2.93465 55.2516 3.03706 55.0677 3.17562 54.9629C3.31585 54.8595 3.4785 54.8315 3.66559 54.8772C3.86204 54.9256 3.99524 55.026 4.06385 55.1778C4.1328 55.3293 4.13414 55.5398 4.06687 55.8111ZM4.73422 54.0304C4.54881 53.7461 4.28474 53.5619 3.9417 53.4775C3.65086 53.4064 3.37475 53.4197 3.11136 53.5178C2.84864 53.6156 2.61436 53.8034 2.40854 54.0787C2.20237 54.355 2.04509 54.7147 1.93464 55.1601L1.36133 57.4831L6.09133 58.6453L6.42769 57.2859L4.64151 56.8458L4.71816 56.5355L6.8062 55.7587L7.17737 54.2559L4.98623 55.1348C5.00363 54.6827 4.91896 54.315 4.73422 54.0304Z"
      fill="#3D5D82"
    />
    <path
      d="M10.0244 46.9182L9.1562 46.5465L8.28269 48.5702L7.28936 48.1448L8.06582 46.3467L7.24887 45.9963L6.47241 47.7944L5.53565 47.392L6.40882 45.3683L5.54904 44.9993L4.11963 48.3099L8.59495 50.2285L10.0244 46.9182Z"
      fill="#3D5D82"
    />
    <path
      d="M15.8457 37.5181L13.5224 35.6393L17.3263 35.7L18.2105 34.6116L14.4283 31.5505L13.5428 32.6389L15.8858 34.5352L12.0622 34.4571L11.1763 35.5455L14.9601 38.6062L15.8457 37.5181Z"
      fill="#3D5D82"
    />
    <path
      d="M22.722 27.9248L21.6132 28.8627L21.0128 27.0283L22.722 27.9248ZM22.215 30.6866L21.9158 29.7766L23.5768 28.3743L24.4275 28.817L25.5688 27.8534L20.819 25.5454L19.5837 26.5868L21.0854 31.6392L22.215 30.6866Z"
      fill="#3D5D82"
    />
    <path
      d="M28.0391 21.5587L30.0241 24.9487L31.2437 24.2347L29.2597 20.848L30.6218 20.0572L30.1496 19.2497L26.2195 21.5387L26.6917 22.3461L28.0391 21.5587Z"
      fill="#3D5D82"
    />
    <path
      d="M36.3153 20.7209C36.6155 20.9478 36.9599 21.0712 37.3477 21.0946C37.7366 21.1146 38.1483 21.0445 38.5847 20.8844C39.0208 20.7209 39.3856 20.504 39.6761 20.2237C39.9669 19.9501 40.158 19.6264 40.2484 19.2594C40.3381 18.889 40.3033 18.492 40.143 18.0616L39.162 15.4356L37.8458 15.9228L38.827 18.5487C38.9385 18.8523 38.9438 19.1126 38.8418 19.3295C38.7393 19.5497 38.5349 19.7165 38.2266 19.83C37.9184 19.9434 37.6533 19.9501 37.4328 19.8534C37.2115 19.7533 37.0449 19.5531 36.9327 19.2528L35.9518 16.6268L34.6436 17.1106L35.6235 19.7399C35.7848 20.167 36.0151 20.4973 36.3153 20.7209Z"
      fill="#3D5D82"
    />
    <path
      d="M46.8206 14.6016C47.09 14.5549 47.3012 14.5715 47.4521 14.655C47.6041 14.7384 47.6968 14.8752 47.7306 15.0654C47.7667 15.2656 47.7292 15.4257 47.6188 15.5492C47.507 15.676 47.3146 15.7627 47.0401 15.8128L46.1827 15.9663L45.9635 14.7551L46.8206 14.6016ZM46.6522 18.5622L46.3256 16.757L46.6402 16.7003L48.2045 18.2819L49.7319 18.0083L48.0348 16.3733C48.4545 16.2065 48.7574 15.9796 48.9418 15.6927C49.1275 15.4091 49.1884 15.0921 49.1265 14.7451C49.0726 14.4514 48.9475 14.2079 48.7493 14.0077C48.5529 13.8075 48.2848 13.6707 47.9498 13.5973C47.6131 13.5205 47.2192 13.5238 46.7654 13.6039L44.4045 14.031L45.269 18.8091L46.6522 18.5622Z"
      fill="#3D5D82"
    />
    <path
      d="M57.6088 17.5945L57.5937 16.6535L55.3835 16.6902L55.3648 15.6125L57.3287 15.5791L57.314 14.6916L55.35 14.725L55.334 13.7073L57.5425 13.6706L57.5265 12.7363L53.9126 12.7964L53.9946 17.6545L57.6088 17.5945Z"
      fill="#3D5D82"
    />
    <path
      d="M77.2277 91.6653V47.0142H68.2821V77.625L48.2365 47.0142H39.2913V91.6653H48.2365V61.3075L68.2821 91.6653H77.2277Z"
      fill="#3D5D82"
    />
  </svg>
);

export default Svg;
