import React from "react";

function Icon() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="480"
      height="480"
      version="1.1"
      viewBox="0 0 4946.667 4946.667"
      xmlSpace="preserve"
    >
      <defs>
        <clipPath id="clipPath22" clipPathUnits="userSpaceOnUse">
          <path d="M17364 4554.8c-690 0-1374.7 50.7-2049.3 154.6-1011.4 155.8-3784.2 619.9-6239.21 2809.2-3993.04 3561-5333.91 10070.6-3354.33 15551.6 236.25-1427.6 724.42-2862.3 1645.28-4176.5 1334.42-1904.3 3455.36-2442.6 3455.36-2442.6-929.39 688.9-1748.88 1643.1-2095.93 3414.6 3194.23 3739.7 2527.63 7724.8 1859.83 9744.1 2547.8 1899.1 5663.4 2940.2 8701 2940.2 113.3 0 226.2-1.4 339.2-4.3 842.1-21.7 3657.3-135.6 6545.9-1774.7 1.6-1.3 3.2-2.6 5-3.8 6-4.2 12.4-7.4 18.9-9.9 595.6-339.6 1193.8-744 1778.5-1226.2 503.6-415.2 1614.4-1402 2615.4-2967.5 48.7-76.1 96.4-152.8 143.2-230-9.3-6.5-18.7-12.8-28-19.1-38.6-26-48.8-78.4-22.9-117 16.3-24.1 42.9-37.2 70-37.2 5.2 0 10.3.5 15.4 1.5 11 2 21.8 6.3 31.6 12.9 6.8 4.6 13.5 9.2 20.3 13.8 206.7-353.2 394.7-718.5 563.9-1093.7h-2268.7c-197.7 0-374.3 102.5-472.4 274.2-97.3 170.4-95.9 372.8 3.5 541.4 327.6 555.3 395 1182 200.5 1862.9-206.3 722-678.3 1201.3-1329 1349.7-142.9 32.5-291.7 48.3-443.7 48.3-446.8 0-920.2-136-1344-380.2-4.5 79.1-6 158.8-4.6 237.5.8 46.5-36.2 84.9-82.7 85.7h-1.3c-46.1 0-83.6-36.6-84.4-82.7-1.7-95.1.6-191.7 7-287.1 1.2-17 7.3-32.5 16.9-45.1-85.1-55.8-167.7-116.1-247.1-180.7-8.3 5.7-18.4 9-29.3 9h-.4c-79.6-.7-160.5-5.8-240.2-15-12.1-1.4-24.2-2.9-36.2-4.5-28.5-2.9-48.6-29.9-44.7-58.5 3.5-26.1 25.9-45.1 51.6-45.1 2.2 0 4.6.1 6.9.4 11.3 1.6 22.6 3 34.2 4.3 47.9 5.6 96.2 9.6 144.3 11.9-77.4-69.8-151.1-143.7-220.4-221.8-493.4-555.1-470.5-1346.8 66.1-2289.4 98-172.1 97.5-376.5-1.5-546.6-97.8-168.2-272.7-268.6-468-268.6h-3633.2c-37.2 0-67.4-30.2-67.4-67.4v-4336.7c0-64.2-26.2-78.4-36.1-83.7-18.7-10.1-43.6-14.7-73.3-14.7-156.8 0-447.6 129.3-672.2 276.6-378.3 248-803.2 371.9-1245.5 371.9-457.5 0-933.6-132.5-1395.8-397.2-854.9-489.8-1452.1-1312.1-1419.9-1955.4 33.8-676.8 102.5-1449.3 355.1-2047.1 285.3-675.2 765.3-1017.8 1426.4-1017.7 29 0 58.4.6 88.1 1.9 918.9 40 1834.6 477.8 2440.8 838.1 58.9 35 123.6 52.5 188.4 52.5 62.2 0 124.4-16.2 181.3-48.6 115.6-65.7 184.6-184.7 184.6-318.2V11724c0-37.3 30.2-67.5 67.4-67.5h3423.6c163.1 0 313.1-82.8 401-221.5 84.8-133.7 95.6-290.8 29.5-431-439.7-933.1-448.6-2513 167.8-3026.7 268.2-223.5 781.4-409.7 1354.5-493.9C23704.3 5599.3 20490 4554.8 17364 4554.8m5945.7 20900.5c-6.9 0-14-1.4-20.8-4.4-26.3-11.5-38.4-42.1-26.9-68.4 17.6-40.6 36.7-81.1 56.7-120.5 9.2-18 27.5-28.4 46.4-28.4 3.2 0 6.4.3 9.6.9 4.7.9 9.5 2.4 14 4.7 25.6 13.1 35.8 44.4 22.8 70-19.1 37.5-37.3 76.2-54.1 114.8-8.5 19.6-27.6 31.3-47.7 31.3m5383 323.2c-43.8 0-80.7-34.2-83.8-78.6-3.2-46.3 31.9-86.6 78.3-89.7 76.2-5.3 153.5-7.9 230.4-7.9 17.4 0 34.8.1 52.2.4 4.9.1 9.7.6 14.3 1.4 39.6 7.4 69.3 42.5 68.6 84.2-.7 46-38.2 82.9-84.2 82.9h-1.3c-16.4-.3-32.8-.4-49.2-.4-73.2 0-146.7 2.5-219.3 7.4-2 .2-4 .3-6 .3m-5535.7 194.9c-2.9 0-5.7-.2-8.6-.7-26.6-5.5-47.5-31.5-42.8-59.9 2.6-15.8 5.4-31.7 8.3-47.4 14-74.7 32-149.6 53.5-222.6 6.6-22.6 27.4-37.3 49.9-37.3 3.1 0 6.3.3 9.5.9 1.7.3 3.4.7 5.2 1.2 27.5 8.2 43.3 37.1 35.2 64.7-20.5 69.5-37.7 141-51 212.2-2.8 15.1-5.4 30.2-8 45.4-4.2 25.4-26.2 43.5-51.2 43.5m6528.2-112.3c-6.5 0-13-.8-19.6-2.3-86.1-20.5-174.5-37.7-263.7-51.3-45.7-6.8-77.6-50-70.5-96 6.3-41.7 42.2-71.6 83.2-71.6 4.2 0 8.4.4 12.7 1 38.6 5.9 77 12.4 115.1 19.5 54.4 10.2 109 21.8 162.3 34.5 45.2 10.8 73.2 56.2 62.4 101.5-9.2 38.7-43.8 64.7-81.9 64.7m679.5 243.9c-12.5 0-25.1-2.8-37-8.6-80.2-39.3-162.9-75.5-245.9-107.8-43.3-16.9-64.8-65.7-47.9-109 12.9-33.4 44.8-53.8 78.5-53.8 5.1 0 10.2.5 15.4 1.5 5 .9 10.1 2.3 15.1 4.3 87.4 34 174.5 72.1 258.9 113.5 41.8 20.5 59 70.9 38.6 112.7-14.7 29.9-44.6 47.2-75.7 47.2m-7230.3 408.1c-26.7 0-49.7-20.6-51.9-47.8-7.4-91.6-9.2-184.8-5.4-276.9 1.2-28 24.3-49.9 52.1-49.9h2.1c2.5.2 5 .5 7.5.9 25 4.7 43.4 27.2 42.3 53.3-3.7 87.9-2 176.8 5.1 264.2 2.4 28.6-18.9 53.7-47.6 56-1.4.1-2.8.2-4.2.2m110.2 529c-21.6 0-41.7-13.6-49.1-35.2-29.9-87.2-54.5-177.1-73.3-267.2-5.9-28.2 12.1-55.8 40.2-61.6 3.6-.7 7.2-1.1 10.7-1.1 3.3 0 6.4.3 9.5.9 20.1 3.7 37 19.2 41.4 40.5 17.9 85.9 41.5 171.7 69.9 254.8 9.3 27.2-5.2 56.8-32.4 66.1-5.6 1.9-11.3 2.8-16.9 2.8m236.7 485.7c-17 0-33.7-8.3-43.6-23.7-50.2-77-96.1-158.2-136.5-241.1-12.6-25.8-1.8-57 24-69.6 7.4-3.5 15.1-5.2 22.8-5.2 3.2 0 6.4.3 9.5.9 15.7 2.9 29.8 13 37.3 28.4 38.5 79 82.3 156.4 130.1 229.9 15.7 24.1 8.9 56.3-15.2 72-8.8 5.6-18.6 8.4-28.4 8.4m347.5 413.5c-12.7 0-25.4-4.6-35.4-14-67.4-62.6-131.6-130.1-190.8-200.6-18.5-22-15.7-54.8 6.3-73.3 9.7-8.2 21.6-12.2 33.5-12.2 3.2 0 6.4.3 9.6.9 11.4 2.1 22.2 8.1 30.2 17.6 56.6 67.3 117.8 131.7 182.1 191.5 21 19.5 22.2 52.4 2.6 73.5-10.2 11-24.2 16.6-38.1 16.6m437.5 316.2c-8.5 0-17.1-2-25-6.4-80.6-44.2-159.4-94-234-148-23.3-16.8-28.5-49.4-11.7-72.6 10.2-14.1 26.1-21.6 42.2-21.6 3.2 0 6.4.3 9.6.9 7.3 1.4 14.5 4.3 20.9 9 71.1 51.4 146.2 98.9 223 141.1 25.2 13.8 34.4 45.4 20.6 70.6-9.5 17.3-27.3 27-45.6 27m501.6 199.3c-4.2 0-8.5-.5-12.8-1.5-89.3-23.3-177.9-52.2-263.2-86.1-26.7-10.7-39.8-40.9-29.2-67.6 8.1-20.4 27.7-32.8 48.4-32.8 3.1 0 6.3.3 9.5.8 3.2.7 6.5 1.6 9.7 2.8 81.3 32.4 165.8 60 251 82.1 27.9 7.3 44.5 35.7 37.3 63.5-6.1 23.5-27.3 38.8-50.7 38.8m968.1 1385.1c-37.8 0-72.3-25.6-81.8-64-23-92.6-42.2-187.3-57.2-281.5-7.3-46 24.1-89.1 70-96.4 4.5-.7 8.9-1.1 13.3-1.1 5.3 0 10.4.5 15.4 1.4 34.1 6.4 62 33.5 67.7 69.7 14.2 89.4 32.5 179.4 54.3 267.3 11.2 45.1-16.3 90.9-61.4 102.1-6.8 1.6-13.6 2.5-20.3 2.5m256 688c-30.8 0-60.5-16.9-75.3-46.2-43.1-85.1-83-173.2-118.7-261.7-17.3-43.1 3.6-92.2 46.7-109.6 10.3-4.2 21-6.1 31.5-6.1 5.2 0 10.3.5 15.4 1.4 27.3 5.1 51.6 23.6 62.7 51.3 33.9 84.2 71.8 167.8 112.7 248.6 21 41.5 4.4 92.2-37.1 113.2a83.53 83.53 0 01-37.9 9.1m3040.8-20637.6c-81.1 397-221.4 750.6-419.9 1056.7-93.3 144-100.4 319.4-18.9 469.3 81.1 149.2 231.3 238.2 401.8 238.2h1354.1c-394.7-624.2-836.5-1213.5-1317.1-1764.2m1018.4 6066.4c-324.9 0-613.5 119.4-860.6 356.2-648.1 621.2-880.1 1921-877.9 2643.1 1.2 395.1 313.4 1141.6 980 1489.1 196.4 102.3 451.1 183.4 765.5 183.4 428.4 0 967.5-150.7 1620-603.6 99.5-69 215-104 330.8-104 91.3 0 182.8 21.7 266.9 65.7 115.2 60.3 202.4 153 253.4 264.5 68.5-1263.1-23.6-2543.9-272.3-3788.6-78.9 38-163.4 56.9-248 56.9-99.7 0-199.6-26.3-290.9-78.9-512-294.9-1052.7-457.3-1607.2-482.4-20-.9-39.9-1.4-59.7-1.4M8750.82 27182.8c-36.92 227.3-82.82 445.8-136.53 656.9 231.58 250.2 471.34 491.1 718.92 723-156.53-403.1-348.05-861.8-582.39-1379.9"></path>
        </clipPath>
        <linearGradient
          id="linearGradient28"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-27664.7 27664.7) rotate(41.186 -.832 -1.605)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#dae3fe" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#e9effd" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath46" clipPathUnits="userSpaceOnUse">
          <path d="M26999.7 7569.6c-777.1.1-1565.2 226.2-1907.3 511.2-517.3 431.2-585.2 1904.2-132.1 2865.7 84.9 180.2 70.8 389.8-37.6 560.7-112.9 177.9-305.3 284.2-514.9 284.2h-3356.1v4557.7c0 182.6-94.6 345.4-252.8 435.4-77.9 44.3-163 66.5-248.1 66.5-88.4 0-176.8-23.9-257.1-71.6-593-352.5-1486.9-780.6-2377.9-819.3-27.8-1.2-55.2-1.8-82.3-1.8-610.3 0-1036.5 306.6-1302.1 935.2-244.4 578.5-311.4 1336.4-344.7 2001.4-29.2 585.8 552.1 1373.3 1352.4 1831.6 440.7 252.5 893.8 378.9 1328.4 378.9 416.9 0 816.7-116.3 1171.9-349.3 21.6-14.2 458-297.7 746.8-297.6 51.3 0 97.9 8.9 136.7 29.9 48.8 26.3 106.9 82.8 106.9 202.3V24960h3565.7c243.9 0 462.4 125.4 584.6 335.6 123.4 212.1 124.1 466.8 2.1 681.1-638.5 1121.5-397.3 1779-82.5 2133.1 514.5 578.8 1277.2 927.1 1970.3 927.1 142.9 0 282.8-14.8 417-45.4 424.9-96.9 983.1-393.3 1229.4-1255.3 183.9-643.8 121-1235.1-187-1757.2-124.4-210.9-126.1-463.9-4.5-676.8 122.4-214.3 342.8-342.2 589.5-342.2h3331.2v-4467.3c0-164.7-86.8-308.5-232.2-384.6-65.5-34.3-135.5-51.3-205.2-51.3-88.1 0-175.8 27.2-253.1 80.9-678.5 470.9-1243.9 628.2-1696.7 628.2-339.2 0-615.2-88.3-828-199.3-723.8-377.3-1051.3-1167.6-1052.6-1608.2-2.2-745.4 240.8-2090.3 919.6-2740.9 272.6-261.3 592.7-393.7 951.3-393.7 22.6 0 45.4.5 68.3 1.5 576.2 26.2 1137.5 194.5 1668.4 500.4 70.2 40.4 147 60.7 223.6 60.7 75.9 0 151.6-19.9 220.4-59.7 135.4-78.3 216.2-218.9 216.2-376.1v-4159.2h-3449.8c-220.8 0-415.2-115.4-520.3-308.7-105.4-194-96.4-421 24.3-607 308.7-476.3 470.4-1075.6 480.5-1781.3 8.7-604.8-255.1-1039.4-784-1291.8-345-164.6-769.1-233-1196.6-233m-3971 14041.1c-980.8 0-1682.8-237.5-1682.8-237.5l-122.6-791.7c-109.1-704.9 116.7-1381.4 365.3-2049.9 790.1-2124.5 1026.1-2773.4 1262-3894.2 241.9-66.1 476.8-99.8 704.6-99.8 652.5 0 1246.1 277.1 1773 866.6 16.5 52 32.5 103.6 48.2 154.8l466.5 75.4c50.9 8.3 89.5 50.6 91.9 101.9 3.3 71.7.6 178-29.4 284.8-31.7 112.5-135.6 188-251 188-9.1 0-18.2-.5-27.4-1.4-21.8-2.3-45.4-4.8-70.5-7.6 1097.7 4295.7-973.2 5194.9-973.2 5194.9-551.2 161.2-1084.8 215.7-1554.6 215.7m2197.5 2528.5c-27.6 0-50.9-21.8-52.1-49.9-1.2-28.7 21.1-52.9 49.8-54.1 31.7-1.4 63.6-2 95.5-2 59.1 0 118.3 2.3 176.9 6.8 1.9.2 3.8.4 5.6.8 25.8 4.8 44.3 28.4 42.2 55.2-2.1 27.2-24.9 47.9-51.7 47.9-1.4 0-2.8 0-4.2-.1-55.9-4.4-112.3-6.6-168.6-6.6-30.5 0-61 .7-91.3 2h-2.1m-524.4 87.2c-22.4 0-43.2-14.6-49.9-37.2-8.2-27.6 7.6-56.6 35.1-64.7 86.9-25.7 176.3-46.2 265.7-61.1 2.9-.5 5.7-.7 8.6-.7 3.2 0 6.4.3 9.5.9 20.9 3.9 38.1 20.4 41.8 42.6 4.7 28.3-14.5 55.1-42.8 59.8-85.2 14.3-170.5 33.8-253.3 58.3-4.9 1.4-9.8 2.1-14.7 2.1m1311.3 21.9c-5.4 0-10.8-.8-16.1-2.5-81.9-27-166.4-49.3-251.2-66.3-28.2-5.7-46.4-33.1-40.8-61.3 5-24.7 26.7-41.8 51-41.8 3.2 0 6.4.3 9.6.9l.7.1c88.9 17.8 177.5 41.3 263.3 69.6 27.3 9 42.1 38.4 33.1 65.7-7.2 22-27.7 35.6-49.6 35.6m-1681.3 125.1c-19 0-37.4-10.4-46.6-28.4-13-25.7-2.7-57 22.9-70 39.1-19.8 79.6-38.8 120.4-56.6 6.8-2.9 13.8-4.3 20.7-4.3 3.3 0 6.5.3 9.6.9 16.4 3.1 31 14 38.2 30.4 11.4 26.3-.6 57-27 68.5-38.9 16.9-77.6 35.1-114.8 54-7.6 3.8-15.6 5.5-23.4 5.5m2162 101.9c-9.5 0-19.1-2.5-27.8-8-72.9-46-149.5-88.1-227.8-125.2-25.9-12.2-37-43.3-24.8-69.2 8.9-18.8 27.6-29.8 47.1-29.8 3.2 0 6.4.3 9.5.9 4.3.8 8.6 2.2 12.7 4.1 82.1 38.8 162.4 82.9 238.8 131.2 24.3 15.4 31.6 47.5 16.3 71.8-9.9 15.7-26.8 24.2-44 24.2m411.3 336c-13.6 0-27.3-5.3-37.5-16-59.8-62.4-124-121.6-190.9-176.2-22.3-18.2-25.6-50.9-7.4-73.2 10.2-12.6 25.2-19.1 40.3-19.1 3.2 0 6.4.3 9.6.8 8.2 1.6 16.3 5.2 23.3 10.9 70.1 57.2 137.4 119.4 200.2 184.7 19.9 20.7 19.2 53.7-1.5 73.6-10.1 9.7-23.1 14.5-36.1 14.5m319.4 424.7c-18 0-35.5-9.3-45.1-26-43.2-74.6-91.4-147.6-143.4-216.8-17.3-23-12.6-55.6 10.4-72.9 9.3-7 20.3-10.4 31.2-10.4 3.2 0 6.4.3 9.6.9 12.3 2.3 23.9 9.1 32 19.9 54.5 72.5 105 149 150.3 227.3 14.3 24.9 5.8 56.7-19.1 71-8.1 4.8-17.1 7-25.9 7m208.1 489.1c-22.6 0-43.4-14.8-50-37.6-23.9-82.8-53.2-165.3-87.2-244.8-11.2-26.5 1.1-57.1 27.5-68.3 6.7-2.9 13.6-4.2 20.4-4.2 3.2 0 6.4.3 9.5.9 16.6 3.1 31.3 14.1 38.4 30.7 35.6 83.6 66.3 170 91.4 256.9 7.9 27.6-8 56.4-35.6 64.4-4.8 1.4-9.7 2-14.4 2m549.7 182.2c-36.3 0-69.7-23.6-80.7-60.1-13.3-44.6 12-91.5 56.6-104.8 89.9-26.9 182.2-50.3 274.1-69.5 5.8-1.2 11.6-1.8 17.4-1.8 5.2 0 10.3.5 15.3 1.4 32.5 6.1 59.8 31.2 67 65.7 9.5 45.5-19.7 90.1-65.3 99.6-87.3 18.3-174.8 40.5-260.2 66-8.1 2.4-16.2 3.5-24.2 3.5M27440 26124c-30.7 0-60.3-16.9-75.2-46.2-21-41.5-4.4-92.2 37.1-113.2 41.1-20.9 83-41 124.5-60 11.3-5.1 23.1-7.5 34.8-7.5 5.2 0 10.4.4 15.5 1.4 26.1 4.9 49.4 21.9 61.2 47.9 19.4 42.3.7 92.3-41.7 111.5-39.3 18-79.1 37.2-118.2 56.9-12.2 6.2-25.2 9.2-38 9.2m-1731.1 2259.7c-5.1 0-10.3-.4-15.6-1.4l-1.6-.3c-45.5-9.4-74.8-54-65.4-99.6 19.4-93.6 42.9-187.4 70.1-278.6 10.9-36.6 44.4-60.2 80.7-60.2 5.1 0 10.3.4 15.4 1.4 2.9.5 5.8 1.2 8.6 2.1 44.6 13.2 70 60.2 56.8 104.8-25.8 86.6-48.2 175.7-66.6 264.6-8.2 39.9-43.3 67.2-82.4 67.2"></path>
        </clipPath>
        <linearGradient
          id="linearGradient52"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="rotate(106.485 29036.751 1227.761) scale(82404.6)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#4f52ff" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#4042e2" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath64" clipPathUnits="userSpaceOnUse">
          <path d="M8021.64 16574.5c-399.84-268.4-927.49-529.3-1522.32-588.8-1317.04-131.7-1843.84 1317-1909.71 2568.2-65.83 1251.2 1053.63 2436.5 2041.41 2304.8 465.24-62 974.29-357.8 1382.71-653.3 329.83-238.8 790.39-4 790.39 403.2v4493.9h4546.38c378.9 0 630.1 391.2 471.7 735.5-356.7 775.3-757.4 1953.4-198.6 2461.9 868.5 790.3 3214.4 790.3 3609.5-395.1 221.3-663.7-79.3-1462.2-386.6-2036.4-185.4-346.2 64.7-764.1 457.4-764.1h3880.3v-4161.8c0-444-502.1-719.9-864.2-463-1678.5 1191.3-3511.6-65.3-3679.5-1464.7-197.6-1646.2 856-3029.1 1975.5-2897.4 568.5 66.9 1221.8 388.4 1727.3 688.8 371.2 220.6 840.9-44.3 840.9-476.2v-4596.9h-4469.3c-511.4 0-853.4 533.4-631.8 994.3 264.2 549.2 1346.8 1223.4 1281.7 1743.7-131.7 1053.6-2477.6 1314.3-3741.2 1118.1-964.4-149.7-485-1658.3 63.2-2867.3 210.1-463.4-124.6-988.8-633.3-988.8H8804.12v4432.1c0 402.3-448.37 633.4-782.48 409.3z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient70"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="rotate(106.484 14948.635 3231.842) scale(81428.8)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#4f52ff" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#4042e2" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath82" clipPathUnits="userSpaceOnUse">
          <path d="M25777.1 27943.6c-36.3 0-69.8 23.6-80.7 60.2-27.2 91.2-50.7 185-70.1 278.6-9.4 45.6 19.9 90.2 65.4 99.6l1.6.3c5.3 1 10.5 1.4 15.6 1.4 39.1 0 74.2-27.3 82.4-67.2 18.4-88.9 40.8-178 66.6-264.6 13.2-44.6-12.2-91.6-56.8-104.8-2.8-.9-5.7-1.6-8.6-2.1-5.1-1-10.3-1.4-15.4-1.4"></path>
        </clipPath>
        <linearGradient
          id="linearGradient88"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="rotate(106.485 29036.751 1227.761) scale(82404.6)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#636ffd" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#5864e9" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath98" clipPathUnits="userSpaceOnUse">
          <path d="M25580.2 28699.4c-9.6 12.6-15.7 28.1-16.9 45.1-6.4 95.4-8.7 192-7 287.1.8 46.1 38.3 82.7 84.4 82.7h1.3c46.5-.8 83.5-39.2 82.7-85.7-1.4-78.7.1-158.4 4.6-237.5-50.4-29-100.2-59.6-149.1-91.7"></path>
        </clipPath>
        <linearGradient
          id="linearGradient104"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-27664.7 27664.7) rotate(41.186 -.832 -1.605)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#c4d5fd" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ceddfc" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath116" clipPathUnits="userSpaceOnUse">
          <path d="M25680.3 29398.9c-4.4 0-8.8.4-13.3 1.1-45.9 7.3-77.3 50.4-70 96.4 15 94.2 34.2 188.9 57.2 281.5 9.5 38.4 44 64 81.8 64 6.7 0 13.5-.9 20.3-2.5 45.1-11.2 72.6-57 61.4-102.1-21.8-87.9-40.1-177.9-54.3-267.3-5.7-36.2-33.6-63.3-67.7-69.7-5-.9-10.1-1.4-15.4-1.4m195.9 707.4c-10.5 0-21.2 1.9-31.5 6.1-43.1 17.4-64 66.5-46.7 109.6 35.7 88.5 75.6 176.6 118.7 261.7 14.8 29.3 44.5 46.2 75.3 46.2 12.7 0 25.7-2.9 37.9-9.1 41.5-21 58.1-71.7 37.1-113.2-40.9-80.8-78.8-164.4-112.7-248.6-11.1-27.7-35.4-46.2-62.7-51.3-5.1-.9-10.2-1.4-15.4-1.4"></path>
        </clipPath>
        <linearGradient
          id="linearGradient122"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-27664.7 27664.7) rotate(41.186 -.832 -1.605)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#c4d5fd" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ceddfc" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath134" clipPathUnits="userSpaceOnUse">
          <path d="M26195.7 30757.3c-6.5 2.5-12.9 5.7-18.9 9.9-1.8 1.2-3.4 2.5-5 3.8 7.9-4.5 16-9.2 23.9-13.7"></path>
        </clipPath>
        <linearGradient
          id="linearGradient140"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-27664.7 27664.7) rotate(41.186 -.832 -1.605)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#c4d5fd" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ceddfc" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath156" clipPathUnits="userSpaceOnUse">
          <path d="M28917.6 25602.3c-76.9 0-154.2 2.6-230.4 7.9-46.4 3.1-81.5 43.4-78.3 89.7 3.1 44.4 40 78.6 83.8 78.6 2 0 4-.1 6-.3 72.6-4.9 146.1-7.4 219.3-7.4 16.4 0 32.8.1 49.2.4h1.3c46 0 83.5-36.9 84.2-82.9.7-41.7-29-76.8-68.6-84.2-4.6-.8-9.4-1.3-14.3-1.4-17.4-.3-34.8-.4-52.2-.4m497 37.6c-41 0-76.9 29.9-83.2 71.6-7.1 46 24.8 89.2 70.5 96 89.2 13.6 177.6 30.8 263.7 51.3 6.6 1.5 13.1 2.3 19.6 2.3 38.1 0 72.7-26 81.9-64.7 10.8-45.3-17.2-90.7-62.4-101.5-53.3-12.7-107.9-24.3-162.3-34.5-38.1-7.1-76.5-13.6-115.1-19.5-4.3-.6-8.5-1-12.7-1"></path>
        </clipPath>
        <linearGradient
          id="linearGradient162"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-27664.7 27664.7) rotate(41.186 -.832 -1.605)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#c4d5fd" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ceddfc" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath172" clipPathUnits="userSpaceOnUse">
          <path d="M28249.7 25671.1c-5.8 0-11.6.6-17.4 1.8-91.9 19.2-184.2 42.6-274.1 69.5-44.6 13.3-69.9 60.2-56.6 104.8 11 36.5 44.4 60.1 80.7 60.1 8 0 16.1-1.1 24.2-3.5 85.4-25.5 172.9-47.7 260.2-66 45.6-9.5 74.8-54.1 65.3-99.6-7.2-34.5-34.5-59.6-67-65.7-5-.9-10.1-1.4-15.3-1.4"></path>
        </clipPath>
        <linearGradient
          id="linearGradient178"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="rotate(106.485 29036.751 1227.761) scale(82404.6)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#636ffd" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#5864e9" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath188" clipPathUnits="userSpaceOnUse">
          <path d="M30112.4 25825.8c-33.7 0-65.6 20.4-78.5 53.8-16.9 43.3 4.6 92.1 47.9 109 83 32.3 165.7 68.5 245.9 107.8 11.9 5.8 24.5 8.6 37 8.6 31.1 0 61-17.3 75.7-47.2 20.4-41.8 3.2-92.2-38.6-112.7-84.4-41.4-171.5-79.5-258.9-113.5-5-2-10.1-3.4-15.1-4.3-5.2-1-10.3-1.5-15.4-1.5"></path>
        </clipPath>
        <linearGradient
          id="linearGradient194"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-27664.7 27664.7) rotate(41.186 -.832 -1.605)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#c4d5fd" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ceddfc" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath206" clipPathUnits="userSpaceOnUse">
          <path d="M30751.9 26160.3c-27.1 0-53.7 13.1-70 37.2-25.9 38.6-15.7 91 22.9 117 9.3 6.3 18.7 12.6 28 19.1 29.1-48.1 57.9-96.5 86.4-145.1-6.8-4.6-13.5-9.2-20.3-13.8-9.8-6.6-20.6-10.9-31.6-12.9-5.1-1-10.2-1.5-15.4-1.5"></path>
        </clipPath>
        <linearGradient
          id="linearGradient212"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-27664.7 27664.7) rotate(41.186 -.832 -1.605)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#c4d5fd" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ceddfc" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath224" clipPathUnits="userSpaceOnUse">
          <path d="M27561.2 25897.1c-11.7 0-23.5 2.4-34.8 7.5-41.5 19-83.4 39.1-124.5 60-41.5 21-58.1 71.7-37.1 113.2 14.9 29.3 44.5 46.2 75.2 46.2 12.8 0 25.8-3 38-9.2 39.1-19.7 78.9-38.9 118.2-56.9 42.4-19.2 61.1-69.2 41.7-111.5-11.8-26-35.1-43-61.2-47.9-5.1-1-10.3-1.4-15.5-1.4"></path>
        </clipPath>
        <linearGradient
          id="linearGradient230"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="rotate(106.485 29036.751 1227.761) scale(82404.6)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#636ffd" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#5864e9" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath246" clipPathUnits="userSpaceOnUse">
          <path d="M23365.1 25233.6c-18.9 0-37.2 10.4-46.4 28.4-20 39.4-39.1 79.9-56.7 120.5-11.5 26.3.6 56.9 26.9 68.4 6.8 3 13.9 4.4 20.8 4.4 20.1 0 39.2-11.7 47.7-31.3 16.8-38.6 35-77.3 54.1-114.8 13-25.6 2.8-56.9-22.8-70-4.5-2.3-9.3-3.8-14-4.7-3.2-.6-6.4-.9-9.6-.9"></path>
        </clipPath>
        <linearGradient
          id="linearGradient252"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-27664.7 27664.7) rotate(41.186 -.832 -1.605)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#c4d5fd" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ceddfc" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath262" clipPathUnits="userSpaceOnUse">
          <path d="M23217.3 25605.5c-22.5 0-43.3 14.7-49.9 37.3-21.5 73-39.5 147.9-53.5 222.6-2.9 15.7-5.7 31.6-8.3 47.4-4.7 28.4 16.2 54.4 42.8 59.9 2.9.5 5.7.7 8.6.7 25 0 47-18.1 51.2-43.5 2.6-15.2 5.2-30.3 8-45.4 13.3-71.2 30.5-142.7 51-212.2 8.1-27.6-7.7-56.5-35.2-64.7-1.8-.5-3.5-.9-5.2-1.2-3.2-.6-6.4-.9-9.5-.9m-88.1 533c-27.8 0-50.9 21.9-52.1 49.9-3.8 92.1-2 185.3 5.4 276.9 2.2 27.2 25.2 47.8 51.9 47.8 1.4 0 2.8-.1 4.2-.2 28.7-2.3 50-27.4 47.6-56-7.1-87.4-8.8-176.3-5.1-264.2 1.1-26.1-17.3-48.6-42.3-53.3-2.5-.4-5-.7-7.5-.9h-2.1m43.9 538.5c-3.5 0-7.1.4-10.7 1.1-28.1 5.8-46.1 33.4-40.2 61.6 18.8 90.1 43.4 180 73.3 267.2 7.4 21.6 27.5 35.2 49.1 35.2 5.6 0 11.3-.9 16.9-2.8 27.2-9.3 41.7-38.9 32.4-66.1-28.4-83.1-52-168.9-69.9-254.8-4.4-21.3-21.3-36.8-41.4-40.5-3.1-.6-6.2-.9-9.5-.9m174.9 511.2c-7.7 0-15.4 1.7-22.8 5.2-25.8 12.6-36.6 43.8-24 69.6 40.4 82.9 86.3 164.1 136.5 241.1 9.9 15.4 26.6 23.7 43.6 23.7 9.8 0 19.6-2.8 28.4-8.4 24.1-15.7 30.9-47.9 15.2-72-47.8-73.5-91.6-150.9-130.1-229.9-7.5-15.4-21.6-25.5-37.3-28.4-3.1-.6-6.3-.9-9.5-.9m294.4 453c-11.9 0-23.8 4-33.5 12.2-22 18.5-24.8 51.3-6.3 73.3 59.2 70.5 123.4 138 190.8 200.6 10 9.4 22.7 14 35.4 14 13.9 0 27.9-5.6 38.1-16.6 19.6-21.1 18.4-54-2.6-73.5-64.3-59.8-125.5-124.2-182.1-191.5-8-9.5-18.8-15.5-30.2-17.6-3.2-.6-6.4-.9-9.6-.9m395.4 367.7c-16.1 0-32 7.5-42.2 21.6-16.8 23.2-11.6 55.8 11.7 72.6 74.6 54 153.4 103.8 234 148 7.9 4.4 16.5 6.4 25 6.4 18.3 0 36.1-9.7 45.6-27 13.8-25.2 4.6-56.8-20.6-70.6-76.8-42.2-151.9-89.7-223-141.1-6.4-4.7-13.6-7.6-20.9-9-3.2-.6-6.4-.9-9.6-.9m473.3 259.9c-20.7 0-40.3 12.4-48.4 32.8-10.6 26.7 2.5 56.9 29.2 67.6 85.3 33.9 173.9 62.8 263.2 86.1 4.3 1 8.6 1.5 12.8 1.5 23.4 0 44.6-15.3 50.7-38.8 7.2-27.8-9.4-56.2-37.3-63.5-85.2-22.1-169.7-49.7-251-82.1-3.2-1.2-6.5-2.1-9.7-2.8-3.2-.5-6.4-.8-9.5-.8m522.8 135.8c-25.7 0-48.1 19-51.6 45.1-3.9 28.6 16.2 55.6 44.7 58.5 12 1.6 24.1 3.1 36.2 4.5 79.7 9.2 160.6 14.3 240.2 15h.4c10.9 0 21-3.3 29.3-9-38.7-31.5-76.7-64-113.8-97.5-48.1-2.3-96.4-6.3-144.3-11.9-11.6-1.3-22.9-2.7-34.2-4.3-2.3-.3-4.7-.4-6.9-.4"></path>
        </clipPath>
        <linearGradient
          id="linearGradient268"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-27664.7 27664.7) rotate(41.186 -.832 -1.605)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#c4d5fd" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ceddfc" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath280" clipPathUnits="userSpaceOnUse">
          <path d="M25319.4 24033.2c-31.9 0-63.8.6-95.5 2-28.7 1.2-51 25.4-49.8 54.1 1.2 28.1 24.5 49.9 52.1 49.9h2.1c30.3-1.3 60.8-2 91.3-2 56.3 0 112.7 2.2 168.6 6.6 1.4.1 2.8.1 4.2.1 26.8 0 49.6-20.7 51.7-47.9 2.1-26.8-16.4-50.4-42.2-55.2-1.8-.4-3.7-.6-5.6-.8-58.6-4.5-117.8-6.8-176.9-6.8m-358.1 29.5c-2.9 0-5.7.2-8.6.7-89.4 14.9-178.8 35.4-265.7 61.1-27.5 8.1-43.3 37.1-35.1 64.7 6.7 22.6 27.5 37.2 49.9 37.2 4.9 0 9.8-.7 14.7-2.1 82.8-24.5 168.1-44 253.3-58.3 28.3-4.7 47.5-31.5 42.8-59.8-3.7-22.2-20.9-38.7-41.8-42.6-3.1-.6-6.3-.9-9.5-.9m794.7 13.7c-24.3 0-46 17.1-51 41.8-5.6 28.2 12.6 55.6 40.8 61.3 84.8 17 169.3 39.3 251.2 66.3 5.3 1.7 10.7 2.5 16.1 2.5 21.9 0 42.4-13.6 49.6-35.6 9-27.3-5.8-56.7-33.1-65.7-85.8-28.3-174.4-51.8-263.3-69.6l-.7-.1c-3.2-.6-6.4-.9-9.6-.9m504.5 166.7c-19.5 0-38.2 11-47.1 29.8-12.2 25.9-1.1 57 24.8 69.2 78.3 37.1 154.9 79.2 227.8 125.2 8.7 5.5 18.3 8 27.8 8 17.2 0 34.1-8.5 44-24.2 15.3-24.3 8-56.4-16.3-71.8-76.4-48.3-156.7-92.4-238.8-131.2-4.1-1.9-8.4-3.3-12.7-4.1-3.1-.6-6.3-.9-9.5-.9m449.1 283.7c-15.1 0-30.1 6.5-40.3 19.1-18.2 22.3-14.9 55 7.4 73.2 66.9 54.6 131.1 113.8 190.9 176.2 10.2 10.7 23.9 16 37.5 16 13 0 26-4.8 36.1-14.5 20.7-19.9 21.4-52.9 1.5-73.6-62.8-65.3-130.1-127.5-200.2-184.7-7-5.7-15.1-9.3-23.3-10.9-3.2-.5-6.4-.8-9.6-.8m368 383.1c-10.9 0-21.9 3.4-31.2 10.4-23 17.3-27.7 49.9-10.4 72.9 52 69.2 100.2 142.2 143.4 216.8 9.6 16.7 27.1 26 45.1 26 8.8 0 17.8-2.2 25.9-7 24.9-14.3 33.4-46.1 19.1-71-45.3-78.3-95.8-154.8-150.3-227.3-8.1-10.8-19.7-17.6-32-19.9-3.2-.6-6.4-.9-9.6-.9m265.7 460.3c-6.8 0-13.7 1.3-20.4 4.2-26.4 11.2-38.7 41.8-27.5 68.3 34 79.5 63.3 162 87.2 244.8 6.6 22.8 27.4 37.6 50 37.6 4.7 0 9.6-.6 14.4-2 27.6-8 43.5-36.8 35.6-64.4-25.1-86.9-55.8-173.3-91.4-256.9-7.1-16.6-21.8-27.6-38.4-30.7-3.1-.6-6.3-.9-9.5-.9"></path>
        </clipPath>
        <linearGradient
          id="linearGradient286"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="rotate(106.485 29036.751 1227.761) scale(82404.6)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#636ffd" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#5864e9" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath296" clipPathUnits="userSpaceOnUse">
          <path d="M24449.2 24214.1c-6.9 0-13.9 1.4-20.7 4.3-40.8 17.8-81.3 36.8-120.4 56.6-25.6 13-35.9 44.3-22.9 70 9.2 18 27.6 28.4 46.6 28.4 7.8 0 15.8-1.7 23.4-5.5 37.2-18.9 75.9-37.1 114.8-54 26.4-11.5 38.4-42.2 27-68.5-7.2-16.4-21.8-27.3-38.2-30.4-3.1-.6-6.3-.9-9.6-.9"></path>
        </clipPath>
        <linearGradient
          id="linearGradient302"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="rotate(106.485 29036.751 1227.761) scale(82404.6)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#636ffd" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#5864e9" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath318" clipPathUnits="userSpaceOnUse">
          <path d="M16881.8 18382.5s-156.7 412.3-339.6 374.5c-183-37.7-383.1-178.3-383.1-178.3l-293.9-397.5s825.1-325 1115.2-138.7c0 0 842.8-145.6 1907 29-154.1 325.2-245.9 650.9-299.8 903.6-539-305.1-1119.6-533-1705.8-592.6z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient324"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(344.666 -344.666) rotate(-19.12 -130.21 -163.098)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#febbba" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ff928e" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath334" clipPathUnits="userSpaceOnUse">
          <path d="M21345.9 21373.2s-1206.6-1519.8-2758.3-2398.1c53.9-252.7 145.7-578.4 299.8-903.6 804.9 132.1 1736.5 447.3 2526.3 1147.7z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient340"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(7014.73 -7014.73) rotate(-47.467 -1.486 -4.185)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#09005d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#1a0f91" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath350" clipPathUnits="userSpaceOnUse">
          <path d="M23555.2 14537.6c-227.8 0-462.7 33.7-704.6 99.8-235.9 1120.8-471.9 1769.7-1262 3894.2-248.6 668.5-474.4 1345-365.3 2049.9l122.6 791.7s702 237.5 1682.8 237.5c469.8 0 1003.4-54.5 1554.6-215.7 0 0 2070.9-899.2 973.2-5194.9-457.9-50.6-1441.2-188.3-1968.9-479.3-58.8-32.5-98.1-91.3-105.5-157.9-7.1-63.5-6.5-146.9 23.7-228.1 14.3-38.1 51.1-62.4 91-62.4 5.3 0 10.5.4 15.8 1.3l1763.8 285.3c-15.7-51.2-31.7-102.8-48.2-154.8-526.9-589.5-1120.5-866.6-1773-866.6"></path>
        </clipPath>
        <linearGradient
          id="linearGradient356"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(7014.73 -7014.73) rotate(-47.467 -1.01 -4.394)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#09005d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#1a0f91" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath366" clipPathUnits="userSpaceOnUse">
          <path d="M21607.2 22383.6l398.2-956.5c25.1-60.5 79.5-103.5 144-114.6 229.5-39.3 784.7-100.8 1149.4 138.9 43.4 28.6 54.5 87.6 24.7 130.3l-735.5 1056.1z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient372"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-1532.534 1532.534) rotate(71.565 -16.875 -3.562)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#febbba" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ff928e" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath382" clipPathUnits="userSpaceOnUse">
          <path d="M22019 23847c-16.7-15.7-705.7-1368.7-705.7-1368.7l780.9-377 843.5 1185.4s-638.8 823.9-918.7 560.3z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient388"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(1899.365 -1899.365) rotate(23.499 35.132 21.076)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#febbba" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ff928e" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath398" clipPathUnits="userSpaceOnUse">
          <path d="M22582.9 23144.4l-389.5-649.2c-5.9-9.8-13-18.7-21.4-26.6-46.3-43.1-205-168.6-327.6 2.2-104.5 145.7-202.6 278.1-307.7 332.7-61.3 31.9-136.9 6.5-168-55.3-64.2-127.2-188.5-386.4-266.6-632.3-19.5-61.6 12.3-127.7 72.2-152 158.1-64.1 470.6-179.9 747.9-218.2 45.6-6.3 90.7 12.9 117.8 50.1 119.3 163.4 455.6 620.2 570.4 734.5 106.6 106.2 303.4 66.2 392.1 40.7 33.6-9.7 69.5-5 99.5 13.1 90 54.2 247 189.1 103.3 417.6-35.7 56.8-17.5 132.5 38.6 169.3 100.4 66.1 209.4 190.1 105.6 391-105.2 203.3-292.9 221.6-420.7 205.9-56.6-6.9-114 22.8-135.8 75.5-9.6 23.4-28.7 43.4-64.2 50.6-67 13.6-111 74.9-97.9 142 22.6 115.1 5.6 264.5-178.1 365.5-337 185.3-632.1-116.6-707.1-371.4-75.1-254.8 301.6-434.8 538.6-464.9 174.1-22.1 269.5-212.1 307.9-311.4 14-36 10.5-76.2-9.3-109.4z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient404"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="rotate(133.27 6572.684 16036.863) scale(2080.65)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#09005d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#1a0f91" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath414" clipPathUnits="userSpaceOnUse">
          <path d="M22446.3 22336s167.6 394.3 359.4 378.2c191.8-16.1 342.7-207.2 105-421.9-295.6-267.2-464.4 43.7-464.4 43.7z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient420"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(1899.364 -1899.364) rotate(23.499 34.788 21.004)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#febbba" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ff928e" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath430" clipPathUnits="userSpaceOnUse">
          <path d="M22699.5 4759.4c370.8-32 1014.4-84.1 1521.8-106.4 305-13.5 480.6 16.4 581.8 56.9-.2-11.4-.5-22.2-1-32.2-2.4-53.4-45.8-96.1-99.7-99.1-958.7-53.5-1721.2-18.5-1992.7-2-56.1 3.4-89.6 64.4-60.9 112.3 14.4 23.9 31.8 47.3 50.7 70.5z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient436"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="rotate(180 12401.55 2327.35) scale(2164.74)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#4f52ff" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#4042e2" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath446" clipPathUnits="userSpaceOnUse">
          <path d="M24221.3 4653c-507.4 22.3-1151 74.4-1521.8 106.4 364.6 447.3 1521.8 748.8 1521.8 748.8h326.9c224.8-324 257.3-632.5 254.9-798.3-101.2-40.5-276.8-70.4-581.8-56.9z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient452"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-8150.49 8150.49) rotate(-15.909 1.09 13.593)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#09005d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#1a0f91" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath462" clipPathUnits="userSpaceOnUse">
          <path d="M24603.2 6041.8l-30.6-605.2c-3.3-65.6-52.4-120.7-118-130-65.3-9.4-152.8-10.6-245.5 20.3-57.1 19-99.4 67.1-110 125.7l-105.7 589.2z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient468"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="rotate(180 12301.6 2835.65) scale(609.769)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#febbba" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ff928e" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath478" clipPathUnits="userSpaceOnUse">
          <path d="M28848.5 4657.5c160.8 22.4 233.6 106 264.1 195.3l.6-2.4c23.7-94.2-31.2-191.9-140.8-238.3-132.6-56.1-277.5-65.7-390-61.1-120.7 5-231.5 55-292.4 134.9l-.9 1.2c121.2-60 291.2-67 559.4-29.6z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient484"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="rotate(180 14559.35 2350.7) scale(829.558)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#4f52ff" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#4042e2" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath494" clipPathUnits="userSpaceOnUse">
          <path d="M28090.3 6045.7h269.5c410.6 8.4 668.4-857.6 752.8-1192.9-30.5-89.3-103.3-172.9-264.1-195.3-268.2-37.4-438.2-30.4-559.4 29.6-221.8 291.9-331.8 719.4-384.6 968.9-60.2 283.7 185.8 389.7 185.8 389.7z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient500"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(5829.06 -5829.06) rotate(33.071 4.262 6.801)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#09005d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#1a0f91" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath510" clipPathUnits="userSpaceOnUse">
          <path d="M28325.2 6607.5l149.7-595.3c18.3-73-16.6-148.5-84.1-183.1-83.7-43-201.6-88.1-310-75.1-50.9 6.2-93.2 42.1-110.1 90l-219.7 626.4z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient516"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="rotate(180 14239.85 3089.8) scale(728.727)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#febbba" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ff928e" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath526" clipPathUnits="userSpaceOnUse">
          <path d="M28503.7 6435.4c-186.2-165.2-791.9-187-791.9-187-2181.8 5236.6-3091.5 6678.2-3091.5 6678.2 315.1-1976.5 67.9-7050 67.9-7050-360-158.8-824.2 0-824.2 0-29.2 3235.9-484.8 6713-1072.4 8937.7 1474.7 33.2 2276.1 354.7 2532.2 557.2 1229.2-1981.8 3179.9-8936.1 3179.9-8936.1z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient532"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-18973.5) rotate(-54.122 -1.017 1.34)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#09005d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#1a0f91" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath542" clipPathUnits="userSpaceOnUse">
          <path d="M22420.1 13351l271.4-1687.7c47.3-294.3 319.9-498.4 617.2-462.2l4061.2 495.4c198.7 24.2 349.3 190.1 353.3 389.3 8.7 436.1-8.4 1212.2-191.4 1919.3z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient548"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(1973.762 -1973.762) rotate(82.147 10.715 3.332)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#e1473d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#e9605a" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath560" clipPathUnits="userSpaceOnUse">
          <path d="M23452 14733.4l-4.5 132.3c9.8 32.9 35.6 58.7 68.7 68.4 123.9 36.3 432.9 111.8 598.3 18.3l42-149z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient566"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-729.44 729.44) rotate(80.342 -28.08 -9.475)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#e1473d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#e9605a" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath576" clipPathUnits="userSpaceOnUse">
          <path d="M23830.9 14909.7c-28.2-10.8-57.4-14.5-87.5-11.1-36.5 4.2-65.5 32.6-70.1 68.9l-52.4 409.2 208.3 26.6 52.3-408.9c4.7-36.4-16.2-71.5-50.6-84.7z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient582"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(2093.952 -2093.952) rotate(78.589 10.184 3.204)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#e1473d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#e9605a" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath592" clipPathUnits="userSpaceOnUse">
          <path d="M25469.3 14991.5l-4.5 132.3c9.8 33 35.5 58.7 68.7 68.4 123.8 36.3 432.8 111.8 598.3 18.3l42-149z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient598"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-729.43 729.43) rotate(80.342 -29.73 -10.868)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#e1473d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#e9605a" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath608" clipPathUnits="userSpaceOnUse">
          <path d="M25848.1 15167.8c-28.2-10.8-57.3-14.5-87.5-11.1-36.4 4.2-65.4 32.6-70.1 68.9l-57.8 452.3 208.2 26.7 57.9-452.1c4.6-36.4-16.3-71.5-50.7-84.7z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient614"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(2093.942 -2093.942) rotate(78.589 10.777 3.69)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#e1473d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#e9605a" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath624" clipPathUnits="userSpaceOnUse">
          <path d="M23596.8 15272.4c-39.9 0-76.7 24.3-91 62.4-30.2 81.2-30.8 164.6-23.7 228.1 7.4 66.6 46.7 125.4 105.5 157.9 527.7 291 1511 428.7 1968.9 479.3 25.1 2.8 48.7 5.3 70.5 7.6 9.2.9 18.3 1.4 27.4 1.4 115.4 0 219.3-75.5 251-188 30-106.8 32.7-213.1 29.4-284.8-2.4-51.3-41-93.6-91.9-101.9l-466.5-75.4-1763.8-285.3c-5.3-.9-10.5-1.3-15.8-1.3m599.7 633.1c-1.5 0-3.1-.1-4.6-.3-196.5-30.8-428.9-124.3-549.8-177.3-66.2-28.9-113.3-90.9-123-161.8-12.1-87.6 7.7-174.5 8.5-178.1 3.3-14.3 16-23.9 30-23.9 2.3 0 4.7.2 7.1.8 16.5 3.8 26.9 20.4 23.1 37-.2.8-18.1 79.3-7.5 155.8 6.8 49.7 40 93.3 86.5 113.7 95.2 41.7 337.9 142 534.7 172.7 16.8 2.7 28.3 18.5 25.7 35.3-2.4 15.4-15.6 26.1-30.7 26.1"></path>
        </clipPath>
        <linearGradient
          id="linearGradient630"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-1501.0403 1501.0403) rotate(-89.531 -2.582 13.906)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#ff928e" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#fe7062" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath640" clipPathUnits="userSpaceOnUse">
          <path d="M23557.6 15364.1c-14 0-26.7 9.6-30 23.9-.8 3.6-20.6 90.5-8.5 178.1 9.7 70.9 56.8 132.9 123 161.8 120.9 53 353.3 146.5 549.8 177.3 1.5.2 3.1.3 4.6.3 15.1 0 28.3-10.7 30.7-26.1 2.6-16.8-8.9-32.6-25.7-35.3-196.8-30.7-439.5-131-534.7-172.7-46.5-20.4-79.7-64-86.5-113.7-10.6-76.5 7.3-155 7.5-155.8 3.8-16.6-6.6-33.2-23.1-37-2.4-.6-4.8-.8-7.1-.8"></path>
        </clipPath>
        <linearGradient
          id="linearGradient646"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-1501.0403 1501.0403) rotate(-89.531 -2.582 13.906)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#ffd1d0" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ffc3bd" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath656" clipPathUnits="userSpaceOnUse">
          <path d="M22406.3 14651.3c722.4 101.9 3848.5 535.4 4771.9 542 79.5.6 150.7-48.5 177.4-123 84.8-236 265.1-786.5 323.9-1347.5 8-76.3-39.6-147.7-112.9-171.5l-2025.4-658.3-737.3-94.3-2267.8 156.6c-79.9 5.5-145.8 64.2-160 142.7-50.4 279.6-157.3 937-135.6 1371.7 4.6 92.4 73.8 168.7 165.8 181.6z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient662"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-2584.6277 2584.6277) rotate(89.502 -7.057 -2.67)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#ff928e" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#fe7062" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath674" clipPathUnits="userSpaceOnUse">
          <path d="M25511.4 12574.6l-645.9-82.6c-84.6-10.9-164 43-184.7 125.4l-154.2 611.9c-24.5 97.5 42 194.6 142.2 207.4l775.9 99.3c98.2 12.5 185.9-61.4 189.7-159.8l24.1-628.6c3.4-86.8-60.5-161.9-147.1-173z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient680"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(1172.538 -1172.538) rotate(-77.829 4.138 -18.416)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#e1473d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#e9605a" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath690" clipPathUnits="userSpaceOnUse">
          <path d="M25417.4 12678.8l-491.7-63c-64.4-8.2-124.8 32.8-140.6 95.5l-117.3 465.8c-18.7 74.2 31.9 148 108.2 157.8l590.6 75.6c74.7 9.5 141.5-46.7 144.3-121.6l18.4-478.5c2.5-66.1-46-123.2-111.9-131.6z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient696"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(851.958 -851.958) rotate(-7.296 -104.759 -234.918)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#ff928e" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#fe7062" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath706" clipPathUnits="userSpaceOnUse">
          <path d="M25033.2 17631.9c152.3-629.6 156.4-1245.5 133.2-1469.7-8.8-84.6-76.7-150.6-161.5-156.5-96.3-6.7-227.4-15.6-344.5-22.3-128.8-7.5-271.7 73.9-367.3 141.9-48.8 34.8-111.9-19.3-84.7-72.6 47-91.9 128.5-164.2 209.5-225.7 48.7-37 210.5-102.8 199.2-175.6-3.6-23-17.4-43-32.3-60.9-89.9-107.9-226-165.5-360.3-206.7-16.8-5.2-34.6-10.7-46.5-23.8-3.3-86.8 263.8-183.3 332.8-206.2 103.3-34.2 212.8-48.8 321.3-37.3 268.8 28.3 517 213.8 661.8 437.5 387 598 587.1 1320.2 660.3 1872.5-360.1 359.9-903.6 268.7-1121 205.4z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient712"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-3576.81 3576.81) rotate(-62.526 .398 8.313)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#febbba" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ff928e" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath722" clipPathUnits="userSpaceOnUse">
          <path d="M26154.2 17369.6c287.1 2169-1384.4 3836.8-1384.4 3836.8l-994.5-1159.4c755-941.1 1113.9-1803.5 1277.9-2480.8 217.4 63.3 740.9 163.4 1101-196.6z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient728"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(7014.7 -7014.7) rotate(-47.467 -.855 -4.463)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#09005d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#1a0f91" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath738" clipPathUnits="userSpaceOnUse">
          <path d="M25029.5 17576.8c-27.8 0-53 18.9-59.9 47.1-202 835-628 1661.6-1266 2456.8-21.3 26.5-17 65.3 9.5 86.6 26.5 21.2 65.3 17 86.6-9.5 649.4-809.5 1083.3-1652.3 1289.7-2504.9 8-33.1-12.3-66.3-45.4-74.3-4.8-1.2-9.7-1.8-14.5-1.8z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient744"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(4475.13 -4475.13) rotate(-75.754 -.069 -5.718)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#09005d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#1a0f91" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath754" clipPathUnits="userSpaceOnUse">
          <path d="M11560.6 4718.5c.2 10.6-.5 21.3-3.2 32.1-160 634.1-953.8 1029-953.8 1029L10289 5755c-180.9-558.9-157.6-901.7-128.6-1054.4.8-4.3 2.1-8.3 3.3-12.5 259.5-23.1 793.6-38.3 1396.9 30.4z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient760"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="matrix(1420.09 0 0 -1420.09 10140.6 5224.1)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#09005d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#1a0f91" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath770" clipPathUnits="userSpaceOnUse">
          <path d="M10163.7 4688.1c14-50.9 51.6-90.6 99.8-100.8 369.1-77.6 955.8-15.1 1202.2 17.1 54.3 7.1 94 57.3 94.9 114.1-603.3-68.7-1137.4-53.5-1396.9-30.4z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient776"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-6568.66 6568.66) rotate(-38.139 .477 3.54)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#4f52ff" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#4042e2" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath786" clipPathUnits="userSpaceOnUse">
          <path d="M10162.5 6223.5l133.3-641.4c9.7-47 45.8-82.1 89.6-86.3 53.5-5 129.7-7.9 206.4 3.3 68.7 10.1 116.6 80 104.4 154.9l-92.6 569.5z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient792"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-2382.87 2382.87) rotate(-83.463 -.601 3.914)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#febbba" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ff928e" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath802" clipPathUnits="userSpaceOnUse">
          <path d="M12923 4696.3c-347.4 9.7-527.1 50.6-620 88.6-.2-34.6 0-69.7 1.1-106.2 1.2-38.9 30-69.9 65.4-69.7l1907.6 12.3c60.9.4 96.5 71 70.1 126.8-250.1-20.6-887.1-66.9-1424.2-51.8z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient808"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-6568.67 6568.67) rotate(-38.139 .15 3.654)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#4f52ff" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#4042e2" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath818" clipPathUnits="userSpaceOnUse">
          <path d="M14347.2 4748.1c-2.3 4.9-4.3 9.8-7.6 14.4-168.4 235.4-597.5 704.1-1445.4 907.4l-406.7 12.9s-181.1-314.8-184.5-897.9c92.9-38 272.6-78.9 620-88.6 537.1-15.1 1174.1 31.2 1424.2 51.8z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient824"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="matrix(2044.2 0 0 -2044.2 12303 5188)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#09005d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#1a0f91" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath834" clipPathUnits="userSpaceOnUse">
          <path d="M12394 6280.3c6.4-30 91-486.4 123.8-663.3 7.8-42.1 40.6-72.9 79.5-75.1 69.7-3.9 182-4.4 278.6 21.9 52.1 14.1 87.1 67.2 83.4 126.2l-45.5 721.9z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient840"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-2382.866 2382.866) rotate(-87.07 -1.211 4.19)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#febbba" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ff928e" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath850" clipPathUnits="userSpaceOnUse">
          <path d="M12085.8 14706.7s559.5-3844.7 963.3-8419.9c7.5-85.2-60.4-159.3-144.1-176.9-123.4-26-304.7-56.9-454.8-52.7-80.1 2.3-147.1 61.7-160.6 140.7-137.5 806.7-1119.1 5136-1376.7 6088.8 0 0-295.9-4047.4-201.3-6147.2 2.3-52.2-35.9-97.5-87.8-103.5-78.8-9.1-204.8-16-365.1 1-60.9 6.5-110 52.5-118.7 113.1-98 682.7-661.9 4746.4-637.92 7673.7 1.35 165.1 193.68 1521.5 193.68 1521.5z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient856"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-15033.94 15033.94) rotate(-72.466 .276 1.099)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#09005d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#1a0f91" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath866" clipPathUnits="userSpaceOnUse">
          <path d="M9611.67 14485.1c-57.52 20.4-97.63 72.6-103.89 133.3-74.4 721.9-434.66 5197.7 1839.72 7038.8 0 0 130.4 341.3 1202.5-497.6 1072.1-838.8 498.1-1718.1 241.4-2930.8-310.6-1467.5-855.5-2667.1-614.4-3570.2 16.6-62.3-16.1-127.7-76.7-150-832.8-307-1662.3-317.1-2488.63-23.5z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient872"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(8146.74 -8146.74) rotate(-50.822 -1.325 -2.001)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#ff928e" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#fe7062" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath882" clipPathUnits="userSpaceOnUse">
          <path d="M12234.7 22998.3c-.7-63.7-908.9-1353.7-908.9-1353.7s163-321 941.2-581.7l671.8 1381.2z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient888"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(2196.96 -2196.96) rotate(-30.763 -15.12 -13.994)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#febbba" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ff928e" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath898" clipPathUnits="userSpaceOnUse">
          <path d="M12949.7 23737.4s323.2-742.3 344.9-1131.9c21.7-389.6 105.6-642.4-344.9-720.9s-830 146-1035.6 534.1c0 0-322.1 598-249.9 842.9 72.3 244.9 1285.5 475.8 1285.5 475.8z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient904"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-1958.36 1958.36) rotate(55.763 -14 -.691)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#febbba" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ff928e" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath914" clipPathUnits="userSpaceOnUse">
          <path d="M12068 22697.7l25.7 11.3c32.6 14.4 46.6 53.3 30.2 85-63.5 122.7-187.4 404-27.4 469.6 206.2 84.6 1022.9 251.1 1199.1 540.9 169.4 278.5 19.3 638.1-206.2 740.3-15.1 6.9-32.9 1.4-40.6-13.2l-18.8-35.6c-12.9-24.3-48.8-20.6-56.5 5.8-7.3 25.4-41.1 30.3-55.1 7.9-54.2-86.7-200.4-227.2-591.5-299.4-555.7-102.6-923.2-327.5-932.3-711.6-.6-24.4-26.6-37.9-47.4-25.2-41 25-106.7 36.7-194.5-37.1-152.6-128.3-90.2-461.2 244.5-735.1 15.8-13 15.7-37.8-1.5-49-60.7-39.5-151.1-133.5 83.2-258.7 242.4-129.6 423.4-118.9 493-107.4 17.4 2.8 28.5 19.6 24.8 36.8l-74.4 337.5c-4.2 19.1 10.3 37.2 29.9 37.2z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient920"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(2398.89 -2398.89) rotate(49.509 13.56 -.185)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#09005d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#1a0f91" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath930" clipPathUnits="userSpaceOnUse">
          <path d="M12082 22626.5s-123.2 474.2-335.8 341.2c-212.6-132.9 110.3-531.3 281.2-549z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient936"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-1957.32 1957.32) rotate(55.762 -13.695 -.526)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#febbba" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ff928e" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath946" clipPathUnits="userSpaceOnUse">
          <path d="M12894.9 20770.4l62.6-1681.7c177.9-61.2 347.2-108.8 508.4-144.4 100.9 324.7 323 723.2 504.8 1019.5-668.1 236.2-1075.8 806.6-1075.8 806.6z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient952"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(4036.66 -4036.66) rotate(-53.832 -2.793 -4.85)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#ff928e" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#fe7062" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath962" clipPathUnits="userSpaceOnUse">
          <path d="M16230.6 20799c-916.5-989.6-1658.3-1047.8-2259.9-835.2-181.8-296.3-403.9-694.8-504.8-1019.5 2447.5-539.6 3023.9 1710.4 3023.9 1710.4z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient968"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-4426.43 4426.43) rotate(-26.448 8.096 10.749)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#febbba" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ff928e" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath978" clipPathUnits="userSpaceOnUse">
          <path d="M16416.4 20904.1s105.6 113.3 301 77.7c195.4-35.6 369.3-103.5 491.1 0 121.7 103.5 164.5-35.4 164.5-35.4l-364.5-277.1z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient984"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-1960.19 1960.19) rotate(-46.245 8.37 15.851)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#febbba" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ff928e" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath994" clipPathUnits="userSpaceOnUse">
          <path d="M16198.4 20710.3s72.3 302.4 290.3 261c218-41.5 712.9-310.6 840.5-261 127.5 49.5 290.6 168.2 374.3 126.3l-147.4-183.3s378.9 218.6 444.1 84.3l-630.4-354.8s-922.4 92.4-1171.4 327.5z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient1000"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-4426.42 4426.42) rotate(-26.448 8.105 10.76)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#febbba" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ff928e" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath1010" clipPathUnits="userSpaceOnUse">
          <path d="M11877.5 18569.4s1723.1-1443.1 3583.7-813.4c115.4 39 241.6 30.5 349.3-26.3l534.9-282.6c224.5-118.5 502.6-40.7 632.9 177.2 74.3 124.4 137.7 266.3 150.3 402.4l-1046.7 423.7 77.2 128.3s-511 43.3-644.8-322.9c0 0-973.3-404.9-2614.9 1400.7 0 0-744.9-633.4-1021.9-1087.1z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient1016"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-11687.93 11687.93) rotate(10.25 -9.222 -8.364)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#febbba" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#ff928e" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath1026" clipPathUnits="userSpaceOnUse">
          <path d="M11784.8 18584.3c-5.7 0-11.5 1.6-16.5 5.1-725.5 490.2-1066.8 1281.3-1070.2 1289.3-6.3 15 .7 32.3 15.7 38.7 15 6.3 32.2-.6 38.6-15.7 3.3-7.7 338.3-783.3 1048.9-1263.5 13.5-9.1 17.1-27.4 7.9-40.9-5.7-8.4-15-13-24.4-13z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient1032"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-9204.75 9204.75) rotate(-56.879 1.54 2.583)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#e1473d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#e9605a" stopOpacity="1"></stop>
        </linearGradient>
        <clipPath id="clipPath1042" clipPathUnits="userSpaceOnUse">
          <path d="M12865.4 19680.9c-9.6 0-19.1 4.8-24.8 13.6-2.2 3.4-223.8 348.4-646 1104.3-129.8 232.5-300.4 379.6-507.1 437.5-342.2 95.6-672.1-87.9-675.3-89.7-14.2-7.8-32.2-3.1-40.2 11.1-8.1 14.1-3.1 32.1 11 40.2 14.3 8 353.5 197.8 719.9 95.3 222.6-62.1 405.4-218.7 543.2-465.6 421.1-754 641.9-1097.8 644.1-1101.2 8.8-13.7 4.9-31.9-8.8-40.8-5-3.2-10.5-4.7-16-4.7z"></path>
        </clipPath>
        <linearGradient
          id="linearGradient1048"
          x1="0"
          x2="1"
          y1="0"
          y2="0"
          gradientTransform="scale(-9204.79 9204.79) rotate(-56.879 1.55 2.579)"
          gradientUnits="userSpaceOnUse"
          spreadMethod="pad"
        >
          <stop offset="0" stopColor="#e1473d" stopOpacity="1"></stop>
          <stop offset="1" stopColor="#e9605a" stopOpacity="1"></stop>
        </linearGradient>
      </defs>
      <g transform="matrix(1.33333 0 0 -1.33333 0 4946.667)">
        <g transform="scale(.1)">
          <path
            fill="#fff"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M0 0h37100v37100H0z"
          ></path>
          <g>
            <g clipPath="url(#clipPath22)">
              <path
                fill="url(#linearGradient28)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M17364 4554.8c-690 0-1374.7 50.7-2049.3 154.6-1011.4 155.8-3784.2 619.9-6239.21 2809.2-3993.04 3561-5333.91 10070.6-3354.33 15551.6 236.25-1427.6 724.42-2862.3 1645.28-4176.5 1334.42-1904.3 3455.36-2442.6 3455.36-2442.6-929.39 688.9-1748.88 1643.1-2095.93 3414.6 3194.23 3739.7 2527.63 7724.8 1859.83 9744.1 2547.8 1899.1 5663.4 2940.2 8701 2940.2 113.3 0 226.2-1.4 339.2-4.3 842.1-21.7 3657.3-135.6 6545.9-1774.7 1.6-1.3 3.2-2.6 5-3.8 6-4.2 12.4-7.4 18.9-9.9 595.6-339.6 1193.8-744 1778.5-1226.2 503.6-415.2 1614.4-1402 2615.4-2967.5 48.7-76.1 96.4-152.8 143.2-230-9.3-6.5-18.7-12.8-28-19.1-38.6-26-48.8-78.4-22.9-117 16.3-24.1 42.9-37.2 70-37.2 5.2 0 10.3.5 15.4 1.5 11 2 21.8 6.3 31.6 12.9 6.8 4.6 13.5 9.2 20.3 13.8 206.7-353.2 394.7-718.5 563.9-1093.7h-2268.7c-197.7 0-374.3 102.5-472.4 274.2-97.3 170.4-95.9 372.8 3.5 541.4 327.6 555.3 395 1182 200.5 1862.9-206.3 722-678.3 1201.3-1329 1349.7-142.9 32.5-291.7 48.3-443.7 48.3-446.8 0-920.2-136-1344-380.2-4.5 79.1-6 158.8-4.6 237.5.8 46.5-36.2 84.9-82.7 85.7h-1.3c-46.1 0-83.6-36.6-84.4-82.7-1.7-95.1.6-191.7 7-287.1 1.2-17 7.3-32.5 16.9-45.1-85.1-55.8-167.7-116.1-247.1-180.7-8.3 5.7-18.4 9-29.3 9h-.4c-79.6-.7-160.5-5.8-240.2-15-12.1-1.4-24.2-2.9-36.2-4.5-28.5-2.9-48.6-29.9-44.7-58.5 3.5-26.1 25.9-45.1 51.6-45.1 2.2 0 4.6.1 6.9.4 11.3 1.6 22.6 3 34.2 4.3 47.9 5.6 96.2 9.6 144.3 11.9-77.4-69.8-151.1-143.7-220.4-221.8-493.4-555.1-470.5-1346.8 66.1-2289.4 98-172.1 97.5-376.5-1.5-546.6-97.8-168.2-272.7-268.6-468-268.6h-3633.2c-37.2 0-67.4-30.2-67.4-67.4v-4336.7c0-64.2-26.2-78.4-36.1-83.7-18.7-10.1-43.6-14.7-73.3-14.7-156.8 0-447.6 129.3-672.2 276.6-378.3 248-803.2 371.9-1245.5 371.9-457.5 0-933.6-132.5-1395.8-397.2-854.9-489.8-1452.1-1312.1-1419.9-1955.4 33.8-676.8 102.5-1449.3 355.1-2047.1 285.3-675.2 765.3-1017.8 1426.4-1017.7 29 0 58.4.6 88.1 1.9 918.9 40 1834.6 477.8 2440.8 838.1 58.9 35 123.6 52.5 188.4 52.5 62.2 0 124.4-16.2 181.3-48.6 115.6-65.7 184.6-184.7 184.6-318.2V11724c0-37.3 30.2-67.5 67.4-67.5h3423.6c163.1 0 313.1-82.8 401-221.5 84.8-133.7 95.6-290.8 29.5-431-439.7-933.1-448.6-2513 167.8-3026.7 268.2-223.5 781.4-409.7 1354.5-493.9C23704.3 5599.3 20490 4554.8 17364 4554.8m5945.7 20900.5c-6.9 0-14-1.4-20.8-4.4-26.3-11.5-38.4-42.1-26.9-68.4 17.6-40.6 36.7-81.1 56.7-120.5 9.2-18 27.5-28.4 46.4-28.4 3.2 0 6.4.3 9.6.9 4.7.9 9.5 2.4 14 4.7 25.6 13.1 35.8 44.4 22.8 70-19.1 37.5-37.3 76.2-54.1 114.8-8.5 19.6-27.6 31.3-47.7 31.3m5383 323.2c-43.8 0-80.7-34.2-83.8-78.6-3.2-46.3 31.9-86.6 78.3-89.7 76.2-5.3 153.5-7.9 230.4-7.9 17.4 0 34.8.1 52.2.4 4.9.1 9.7.6 14.3 1.4 39.6 7.4 69.3 42.5 68.6 84.2-.7 46-38.2 82.9-84.2 82.9h-1.3c-16.4-.3-32.8-.4-49.2-.4-73.2 0-146.7 2.5-219.3 7.4-2 .2-4 .3-6 .3m-5535.7 194.9c-2.9 0-5.7-.2-8.6-.7-26.6-5.5-47.5-31.5-42.8-59.9 2.6-15.8 5.4-31.7 8.3-47.4 14-74.7 32-149.6 53.5-222.6 6.6-22.6 27.4-37.3 49.9-37.3 3.1 0 6.3.3 9.5.9 1.7.3 3.4.7 5.2 1.2 27.5 8.2 43.3 37.1 35.2 64.7-20.5 69.5-37.7 141-51 212.2-2.8 15.1-5.4 30.2-8 45.4-4.2 25.4-26.2 43.5-51.2 43.5m6528.2-112.3c-6.5 0-13-.8-19.6-2.3-86.1-20.5-174.5-37.7-263.7-51.3-45.7-6.8-77.6-50-70.5-96 6.3-41.7 42.2-71.6 83.2-71.6 4.2 0 8.4.4 12.7 1 38.6 5.9 77 12.4 115.1 19.5 54.4 10.2 109 21.8 162.3 34.5 45.2 10.8 73.2 56.2 62.4 101.5-9.2 38.7-43.8 64.7-81.9 64.7m679.5 243.9c-12.5 0-25.1-2.8-37-8.6-80.2-39.3-162.9-75.5-245.9-107.8-43.3-16.9-64.8-65.7-47.9-109 12.9-33.4 44.8-53.8 78.5-53.8 5.1 0 10.2.5 15.4 1.5 5 .9 10.1 2.3 15.1 4.3 87.4 34 174.5 72.1 258.9 113.5 41.8 20.5 59 70.9 38.6 112.7-14.7 29.9-44.6 47.2-75.7 47.2m-7230.3 408.1c-26.7 0-49.7-20.6-51.9-47.8-7.4-91.6-9.2-184.8-5.4-276.9 1.2-28 24.3-49.9 52.1-49.9h2.1c2.5.2 5 .5 7.5.9 25 4.7 43.4 27.2 42.3 53.3-3.7 87.9-2 176.8 5.1 264.2 2.4 28.6-18.9 53.7-47.6 56-1.4.1-2.8.2-4.2.2m110.2 529c-21.6 0-41.7-13.6-49.1-35.2-29.9-87.2-54.5-177.1-73.3-267.2-5.9-28.2 12.1-55.8 40.2-61.6 3.6-.7 7.2-1.1 10.7-1.1 3.3 0 6.4.3 9.5.9 20.1 3.7 37 19.2 41.4 40.5 17.9 85.9 41.5 171.7 69.9 254.8 9.3 27.2-5.2 56.8-32.4 66.1-5.6 1.9-11.3 2.8-16.9 2.8m236.7 485.7c-17 0-33.7-8.3-43.6-23.7-50.2-77-96.1-158.2-136.5-241.1-12.6-25.8-1.8-57 24-69.6 7.4-3.5 15.1-5.2 22.8-5.2 3.2 0 6.4.3 9.5.9 15.7 2.9 29.8 13 37.3 28.4 38.5 79 82.3 156.4 130.1 229.9 15.7 24.1 8.9 56.3-15.2 72-8.8 5.6-18.6 8.4-28.4 8.4m347.5 413.5c-12.7 0-25.4-4.6-35.4-14-67.4-62.6-131.6-130.1-190.8-200.6-18.5-22-15.7-54.8 6.3-73.3 9.7-8.2 21.6-12.2 33.5-12.2 3.2 0 6.4.3 9.6.9 11.4 2.1 22.2 8.1 30.2 17.6 56.6 67.3 117.8 131.7 182.1 191.5 21 19.5 22.2 52.4 2.6 73.5-10.2 11-24.2 16.6-38.1 16.6m437.5 316.2c-8.5 0-17.1-2-25-6.4-80.6-44.2-159.4-94-234-148-23.3-16.8-28.5-49.4-11.7-72.6 10.2-14.1 26.1-21.6 42.2-21.6 3.2 0 6.4.3 9.6.9 7.3 1.4 14.5 4.3 20.9 9 71.1 51.4 146.2 98.9 223 141.1 25.2 13.8 34.4 45.4 20.6 70.6-9.5 17.3-27.3 27-45.6 27m501.6 199.3c-4.2 0-8.5-.5-12.8-1.5-89.3-23.3-177.9-52.2-263.2-86.1-26.7-10.7-39.8-40.9-29.2-67.6 8.1-20.4 27.7-32.8 48.4-32.8 3.1 0 6.3.3 9.5.8 3.2.7 6.5 1.6 9.7 2.8 81.3 32.4 165.8 60 251 82.1 27.9 7.3 44.5 35.7 37.3 63.5-6.1 23.5-27.3 38.8-50.7 38.8m968.1 1385.1c-37.8 0-72.3-25.6-81.8-64-23-92.6-42.2-187.3-57.2-281.5-7.3-46 24.1-89.1 70-96.4 4.5-.7 8.9-1.1 13.3-1.1 5.3 0 10.4.5 15.4 1.4 34.1 6.4 62 33.5 67.7 69.7 14.2 89.4 32.5 179.4 54.3 267.3 11.2 45.1-16.3 90.9-61.4 102.1-6.8 1.6-13.6 2.5-20.3 2.5m256 688c-30.8 0-60.5-16.9-75.3-46.2-43.1-85.1-83-173.2-118.7-261.7-17.3-43.1 3.6-92.2 46.7-109.6 10.3-4.2 21-6.1 31.5-6.1 5.2 0 10.3.5 15.4 1.4 27.3 5.1 51.6 23.6 62.7 51.3 33.9 84.2 71.8 167.8 112.7 248.6 21 41.5 4.4 92.2-37.1 113.2a83.53 83.53 0 01-37.9 9.1m3040.8-20637.6c-81.1 397-221.4 750.6-419.9 1056.7-93.3 144-100.4 319.4-18.9 469.3 81.1 149.2 231.3 238.2 401.8 238.2h1354.1c-394.7-624.2-836.5-1213.5-1317.1-1764.2m1018.4 6066.4c-324.9 0-613.5 119.4-860.6 356.2-648.1 621.2-880.1 1921-877.9 2643.1 1.2 395.1 313.4 1141.6 980 1489.1 196.4 102.3 451.1 183.4 765.5 183.4 428.4 0 967.5-150.7 1620-603.6 99.5-69 215-104 330.8-104 91.3 0 182.8 21.7 266.9 65.7 115.2 60.3 202.4 153 253.4 264.5 68.5-1263.1-23.6-2543.9-272.3-3788.6-78.9 38-163.4 56.9-248 56.9-99.7 0-199.6-26.3-290.9-78.9-512-294.9-1052.7-457.3-1607.2-482.4-20-.9-39.9-1.4-59.7-1.4M8750.82 27182.8c-36.92 227.3-82.82 445.8-136.53 656.9 231.58 250.2 471.34 491.1 718.92 723-156.53-403.1-348.05-861.8-582.39-1379.9"
              ></path>
            </g>
          </g>
          <path
            fill="#bdd0fb"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M5829.35 31737.3c-25.94 110.4 129.4 183.8 224.54 106.7 965.99-783.3 3286.98-3129.1 2708.55-7228.3-725.73-5143.2 515-7019.9 2059.36-8164.6 0 0-2120.94 538.3-3455.36 2442.6-3276.31 4675.5-1075.81 10880-1537.09 12843.6"
          ></path>
          <path
            fill="#dce6fd"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M10006.9 16843.5c-27.65 0-55.54 7.6-79.19 23.3-542.33 359.3-1034.63 784-1442.82 1262.7-203.35 239.7-385.85 492.3-547.96 753.7-80.28 131.1-157.85 263.3-228.48 398.3-73.48 133.7-138.15 272.1-199.66 410.9-246.03 557-370.02 1151.2-411.9 1740.2-42.61 590.2-15.8 1176.3 7 1758.2 26.58 582 50.71 1161.9 45.97 1742.2-1.73 580.3-32.03 1160.4-74.93 1739.9-45.47 579.4-111.94 1157.8-198.66 1734.2-83.23 576.9-190.94 1151.2-311.79 1723.8-3.28 15.7 8.32 31.2 26.59 34.8 2.63.5 5.25.8 7.83.8 15.93 0 30.32-9.5 34.03-23.5 150.59-568.6 275.81-1142.2 383.34-1718.6 104.33-576.7 187.56-1156.6 250.27-1738.4 15.36-145.4 29.36-291 42.42-436.7 11.44-145.8 23.19-291.6 31.67-437.5 18.9-291.8 31.74-584 38.51-876.2 12.86-489.2 6.18-978.7-6.36-1466.6-96.35-706.2-80.07-1357.3-7.34-1927.5 2.12-31 4.43-62 6.94-92.9 23.19-286.3 65.12-570.3 131.78-849.4 66.89-279.1 158.53-553 273.14-820.1 236.13-531.8 547.8-1044.7 937.13-1505 193.56-231.2 406.9-449.9 637.19-654.9 56.57-52 117.31-100.7 175.75-151.2 60.64-48.7 120.23-98.3 182.4-145.7 122.5-96.4 250.18-188.2 379.23-278.8l.4-.3c54.4-38.3 64-107.3 21-155.7-25.7-28.8-64.4-44-103.5-44"
          ></path>
          <path
            fill="#91b3fa"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M8331.72 19426.7c-118.45-125.7-326.75-89.6-397.99 67.7-393.16 868-1282.81 3422.5 186.5 6365.5 1240.77 2485.2 1677.4 3950.7 1829.5 4629.7 32.17 143.6 228.97 162.6 288.37 28 655.2-1485.2 2385.5-6537.3-1906.38-11090.9"
          ></path>
          <path
            fill="#c0d6fc"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M8104.72 19517.2h-1.13c-37.23.6-66.96 31.2-66.39 68.5.65 42.2 82.79 4261 1651.9 7794.4 11.16 25.1 35.83 40.1 61.69 40.1 9.13 0 18.41-1.9 27.3-5.8 34.02-15.1 49.36-55 34.26-89-1557.69-3507.7-1639.68-7699.9-1640.33-7741.8-.49-32.8-24.32-59.8-55.45-65.3-3.86-.7-7.8-1.1-11.85-1.1"
          ></path>
          <g>
            <g clipPath="url(#clipPath46)">
              <path
                fill="url(#linearGradient52)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M26999.7 7569.6c-777.1.1-1565.2 226.2-1907.3 511.2-517.3 431.2-585.2 1904.2-132.1 2865.7 84.9 180.2 70.8 389.8-37.6 560.7-112.9 177.9-305.3 284.2-514.9 284.2h-3356.1v4557.7c0 182.6-94.6 345.4-252.8 435.4-77.9 44.3-163 66.5-248.1 66.5-88.4 0-176.8-23.9-257.1-71.6-593-352.5-1486.9-780.6-2377.9-819.3-27.8-1.2-55.2-1.8-82.3-1.8-610.3 0-1036.5 306.6-1302.1 935.2-244.4 578.5-311.4 1336.4-344.7 2001.4-29.2 585.8 552.1 1373.3 1352.4 1831.6 440.7 252.5 893.8 378.9 1328.4 378.9 416.9 0 816.7-116.3 1171.9-349.3 21.6-14.2 458-297.7 746.8-297.6 51.3 0 97.9 8.9 136.7 29.9 48.8 26.3 106.9 82.8 106.9 202.3V24960h3565.7c243.9 0 462.4 125.4 584.6 335.6 123.4 212.1 124.1 466.8 2.1 681.1-638.5 1121.5-397.3 1779-82.5 2133.1 514.5 578.8 1277.2 927.1 1970.3 927.1 142.9 0 282.8-14.8 417-45.4 424.9-96.9 983.1-393.3 1229.4-1255.3 183.9-643.8 121-1235.1-187-1757.2-124.4-210.9-126.1-463.9-4.5-676.8 122.4-214.3 342.8-342.2 589.5-342.2h3331.2v-4467.3c0-164.7-86.8-308.5-232.2-384.6-65.5-34.3-135.5-51.3-205.2-51.3-88.1 0-175.8 27.2-253.1 80.9-678.5 470.9-1243.9 628.2-1696.7 628.2-339.2 0-615.2-88.3-828-199.3-723.8-377.3-1051.3-1167.6-1052.6-1608.2-2.2-745.4 240.8-2090.3 919.6-2740.9 272.6-261.3 592.7-393.7 951.3-393.7 22.6 0 45.4.5 68.3 1.5 576.2 26.2 1137.5 194.5 1668.4 500.4 70.2 40.4 147 60.7 223.6 60.7 75.9 0 151.6-19.9 220.4-59.7 135.4-78.3 216.2-218.9 216.2-376.1v-4159.2h-3449.8c-220.8 0-415.2-115.4-520.3-308.7-105.4-194-96.4-421 24.3-607 308.7-476.3 470.4-1075.6 480.5-1781.3 8.7-604.8-255.1-1039.4-784-1291.8-345-164.6-769.1-233-1196.6-233m-3971 14041.1c-980.8 0-1682.8-237.5-1682.8-237.5l-122.6-791.7c-109.1-704.9 116.7-1381.4 365.3-2049.9 790.1-2124.5 1026.1-2773.4 1262-3894.2 241.9-66.1 476.8-99.8 704.6-99.8 652.5 0 1246.1 277.1 1773 866.6 16.5 52 32.5 103.6 48.2 154.8l466.5 75.4c50.9 8.3 89.5 50.6 91.9 101.9 3.3 71.7.6 178-29.4 284.8-31.7 112.5-135.6 188-251 188-9.1 0-18.2-.5-27.4-1.4-21.8-2.3-45.4-4.8-70.5-7.6 1097.7 4295.7-973.2 5194.9-973.2 5194.9-551.2 161.2-1084.8 215.7-1554.6 215.7m2197.5 2528.5c-27.6 0-50.9-21.8-52.1-49.9-1.2-28.7 21.1-52.9 49.8-54.1 31.7-1.4 63.6-2 95.5-2 59.1 0 118.3 2.3 176.9 6.8 1.9.2 3.8.4 5.6.8 25.8 4.8 44.3 28.4 42.2 55.2-2.1 27.2-24.9 47.9-51.7 47.9-1.4 0-2.8 0-4.2-.1-55.9-4.4-112.3-6.6-168.6-6.6-30.5 0-61 .7-91.3 2h-2.1m-524.4 87.2c-22.4 0-43.2-14.6-49.9-37.2-8.2-27.6 7.6-56.6 35.1-64.7 86.9-25.7 176.3-46.2 265.7-61.1 2.9-.5 5.7-.7 8.6-.7 3.2 0 6.4.3 9.5.9 20.9 3.9 38.1 20.4 41.8 42.6 4.7 28.3-14.5 55.1-42.8 59.8-85.2 14.3-170.5 33.8-253.3 58.3-4.9 1.4-9.8 2.1-14.7 2.1m1311.3 21.9c-5.4 0-10.8-.8-16.1-2.5-81.9-27-166.4-49.3-251.2-66.3-28.2-5.7-46.4-33.1-40.8-61.3 5-24.7 26.7-41.8 51-41.8 3.2 0 6.4.3 9.6.9l.7.1c88.9 17.8 177.5 41.3 263.3 69.6 27.3 9 42.1 38.4 33.1 65.7-7.2 22-27.7 35.6-49.6 35.6m-1681.3 125.1c-19 0-37.4-10.4-46.6-28.4-13-25.7-2.7-57 22.9-70 39.1-19.8 79.6-38.8 120.4-56.6 6.8-2.9 13.8-4.3 20.7-4.3 3.3 0 6.5.3 9.6.9 16.4 3.1 31 14 38.2 30.4 11.4 26.3-.6 57-27 68.5-38.9 16.9-77.6 35.1-114.8 54-7.6 3.8-15.6 5.5-23.4 5.5m2162 101.9c-9.5 0-19.1-2.5-27.8-8-72.9-46-149.5-88.1-227.8-125.2-25.9-12.2-37-43.3-24.8-69.2 8.9-18.8 27.6-29.8 47.1-29.8 3.2 0 6.4.3 9.5.9 4.3.8 8.6 2.2 12.7 4.1 82.1 38.8 162.4 82.9 238.8 131.2 24.3 15.4 31.6 47.5 16.3 71.8-9.9 15.7-26.8 24.2-44 24.2m411.3 336c-13.6 0-27.3-5.3-37.5-16-59.8-62.4-124-121.6-190.9-176.2-22.3-18.2-25.6-50.9-7.4-73.2 10.2-12.6 25.2-19.1 40.3-19.1 3.2 0 6.4.3 9.6.8 8.2 1.6 16.3 5.2 23.3 10.9 70.1 57.2 137.4 119.4 200.2 184.7 19.9 20.7 19.2 53.7-1.5 73.6-10.1 9.7-23.1 14.5-36.1 14.5m319.4 424.7c-18 0-35.5-9.3-45.1-26-43.2-74.6-91.4-147.6-143.4-216.8-17.3-23-12.6-55.6 10.4-72.9 9.3-7 20.3-10.4 31.2-10.4 3.2 0 6.4.3 9.6.9 12.3 2.3 23.9 9.1 32 19.9 54.5 72.5 105 149 150.3 227.3 14.3 24.9 5.8 56.7-19.1 71-8.1 4.8-17.1 7-25.9 7m208.1 489.1c-22.6 0-43.4-14.8-50-37.6-23.9-82.8-53.2-165.3-87.2-244.8-11.2-26.5 1.1-57.1 27.5-68.3 6.7-2.9 13.6-4.2 20.4-4.2 3.2 0 6.4.3 9.5.9 16.6 3.1 31.3 14.1 38.4 30.7 35.6 83.6 66.3 170 91.4 256.9 7.9 27.6-8 56.4-35.6 64.4-4.8 1.4-9.7 2-14.4 2m549.7 182.2c-36.3 0-69.7-23.6-80.7-60.1-13.3-44.6 12-91.5 56.6-104.8 89.9-26.9 182.2-50.3 274.1-69.5 5.8-1.2 11.6-1.8 17.4-1.8 5.2 0 10.3.5 15.3 1.4 32.5 6.1 59.8 31.2 67 65.7 9.5 45.5-19.7 90.1-65.3 99.6-87.3 18.3-174.8 40.5-260.2 66-8.1 2.4-16.2 3.5-24.2 3.5M27440 26124c-30.7 0-60.3-16.9-75.2-46.2-21-41.5-4.4-92.2 37.1-113.2 41.1-20.9 83-41 124.5-60 11.3-5.1 23.1-7.5 34.8-7.5 5.2 0 10.4.4 15.5 1.4 26.1 4.9 49.4 21.9 61.2 47.9 19.4 42.3.7 92.3-41.7 111.5-39.3 18-79.1 37.2-118.2 56.9-12.2 6.2-25.2 9.2-38 9.2m-1731.1 2259.7c-5.1 0-10.3-.4-15.6-1.4l-1.6-.3c-45.5-9.4-74.8-54-65.4-99.6 19.4-93.6 42.9-187.4 70.1-278.6 10.9-36.6 44.4-60.2 80.7-60.2 5.1 0 10.3.4 15.4 1.4 2.9.5 5.8 1.2 8.6 2.1 44.6 13.2 70 60.2 56.8 104.8-25.8 86.6-48.2 175.7-66.6 264.6-8.2 39.9-43.3 67.2-82.4 67.2"
              ></path>
            </g>
          </g>
          <path
            fill="#fcfcfc"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M21051.7 11791.4h3356.1c209.6 0 402-106.3 514.9-284.2 108.4-170.9 122.5-380.5 37.6-560.7-453.1-961.5-385.2-2434.5 132.1-2865.7 530.2-441.8 2131.6-742.1 3103.9-278.2 528.9 252.4 792.7 687 784 1291.8-10.1 705.7-171.8 1305-480.5 1781.3-120.7 186-129.7 413-24.3 607 105.1 193.3 299.5 308.7 520.3 308.7h3449.8v4159.2c0 157.2-80.8 297.8-216.2 376.1-138.2 79.9-304.1 79.5-444-1-530.9-305.9-1092.2-474.2-1668.4-500.4-386.3-17.8-729.8 114.4-1019.6 392.2-678.8 650.6-921.8 1995.5-919.6 2740.9 1.3 440.6 328.8 1230.9 1052.6 1608.2 496.7 259 1338 394.8 2524.7-428.9 138.5-96.2 309.9-107.2 458.3-29.6 145.4 76.1 232.2 219.9 232.2 384.6V24960h-3331.2c-246.7 0-467.1 127.9-589.5 342.2-121.6 212.9-119.9 465.9 4.5 676.8 308 522.1 370.9 1113.4 187 1757.2-246.3 862-804.5 1158.4-1229.4 1255.3-785 179.2-1766.8-183.5-2387.3-881.7-314.8-354.1-556-1011.6 82.5-2133.1 122-214.3 121.3-469-2.1-681.1-122.2-210.2-340.7-335.6-584.6-335.6h-3565.7v-4269.3c0-119.5-58.1-176-106.9-202.3-257.5-139.1-858.1 251-883.5 267.7-725.6 475.9-1636.9 465.1-2500.3-29.6-800.3-458.3-1381.6-1245.8-1352.4-1831.6 33.3-665 100.3-1422.9 344.7-2001.4 277.5-656.5 729.9-961.8 1384.4-933.4 891 38.7 1784.9 466.8 2377.9 819.3 157.6 93.6 346.4 95.5 505.2 5.1 158.2-90 252.8-252.8 252.8-435.4v-4557.7m5955.5-4356.3c-179 0-364.4 11.8-553.8 35.7-610.2 76.9-1164.7 271-1447.3 506.5-616.4 513.7-607.5 2093.6-167.8 3026.7 66.1 140.2 55.3 297.3-29.5 431-87.9 138.7-237.9 221.5-401 221.5h-3423.6c-37.2 0-67.4 30.2-67.4 67.5v4625.1c0 133.5-69 252.5-184.6 318.2-116.1 66.1-254.3 64.7-369.7-3.9-606.2-360.3-1521.9-798.1-2440.8-838.1-706.6-31.4-1216.7 311-1514.5 1015.8-252.6 597.8-321.3 1370.3-355.1 2047.1-32.2 643.3 565 1465.6 1419.9 1955.4 909.2 520.7 1871.8 529.8 2641.3 25.3 267.2-175.3 628.2-325.1 745.5-261.9 9.9 5.3 36.1 19.5 36.1 83.7v4336.7c0 37.2 30.2 67.4 67.4 67.4h3633.2c195.3 0 370.2 100.4 468 268.6 99 170.1 99.5 374.5 1.5 546.6-536.6 942.6-559.5 1734.3-66.1 2289.4 651.8 733.2 1687.5 1112.9 2518.1 923.6 650.7-148.4 1122.7-627.7 1329-1349.7 194.5-680.9 127.1-1307.6-200.5-1862.9-99.4-168.6-100.8-371-3.5-541.4 98.1-171.7 274.7-274.2 472.4-274.2H32513c37.3 0 67.5-30.2 67.5-67.4v-4534.7c0-215.9-113.9-404.3-304.6-504.1-190.8-99.8-419.8-85.1-597.7 38.3-1131.4 785.3-1921.7 661.9-2385.5 420.2-666.6-347.5-978.8-1094-980-1489.1-2.2-722.1 229.8-2021.9 877.9-2643.1 262.2-251.3 571-370.3 920.3-354.8 554.5 25.1 1095.2 187.5 1607.2 482.4 182 104.9 398.3 105.2 578.8 1 177.6-102.7 283.6-286.9 283.6-492.9V11724c0-37.3-30.2-67.5-67.5-67.5h-3517.2c-170.5 0-320.7-89-401.8-238.2-81.5-149.9-74.4-325.3 18.9-469.3 322.8-497.9 491.8-1121.2 502.3-1852.7 9.3-652.8-288.4-1142.2-860.8-1415.4-339.8-162.1-770.7-245.8-1247.2-245.8"
          ></path>
          <g>
            <g clipPath="url(#clipPath64)">
              <path
                fill="url(#linearGradient70)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M8021.64 16574.5c-399.84-268.4-927.49-529.3-1522.32-588.8-1317.04-131.7-1843.84 1317-1909.71 2568.2-65.83 1251.2 1053.63 2436.5 2041.41 2304.8 465.24-62 974.29-357.8 1382.71-653.3 329.83-238.8 790.39-4 790.39 403.2v4493.9h4546.38c378.9 0 630.1 391.2 471.7 735.5-356.7 775.3-757.4 1953.4-198.6 2461.9 868.5 790.3 3214.4 790.3 3609.5-395.1 221.3-663.7-79.3-1462.2-386.6-2036.4-185.4-346.2 64.7-764.1 457.4-764.1h3880.3v-4161.8c0-444-502.1-719.9-864.2-463-1678.5 1191.3-3511.6-65.3-3679.5-1464.7-197.6-1646.2 856-3029.1 1975.5-2897.4 568.5 66.9 1221.8 388.4 1727.3 688.8 371.2 220.6 840.9-44.3 840.9-476.2v-4596.9h-4469.3c-511.4 0-853.4 533.4-631.8 994.3 264.2 549.2 1346.8 1223.4 1281.7 1743.7-131.7 1053.6-2477.6 1314.3-3741.2 1118.1-964.4-149.7-485-1658.3 63.2-2867.3 210.1-463.4-124.6-988.8-633.3-988.8H8804.12v4432.1c0 402.3-448.37 633.4-782.48 409.3"
              ></path>
            </g>
          </g>
          <path
            fill="#fcfcfc"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M14488.3 15715.8c884.2 0 1951.3-160.2 2538.3-602.8 238.8-180.1 375.1-393.3 405.1-633.5 42.5-339.2-333.4-715.1-697-1078.7-239.5-239.5-487.2-487.3-590.8-702.6-93.1-193.5-80-418.3 34.9-601.1 116.8-185.7 317.2-296.6 536.1-296.6h4401.9V16330c0 177.5-91.9 335.8-245.8 423.4-155 88.2-339.4 86.3-493.3-5.2-470.4-279.5-1156.6-627.5-1753.8-697.8-452.3-53.3-911.3 127.1-1291 507.8-581 582.3-872 1526.7-759.4 2464.7 90.7 755.7 640.8 1461.8 1401.5 1798.9 785.9 348.1 1632.6 246.1 2384.1-287.3 144.9-102.8 327.5-114.6 488.3-31.5 166.2 85.9 269.4 254.3 269.4 439.5v4094.4h-3812.9c-208.3 0-396.4 106.5-503.3 284.9-106.8 178.4-111.9 394.7-13.6 578.4 293.3 547.9 597.7 1336.8 382.2 1983.3-126.9 380.7-491.7 667.3-1027.3 807.1-866.7 226.2-1952.7 32.7-2472.9-440.6-232.3-211.3-513.3-802.1 214.5-2383.8 83.9-182.5 69.4-392.3-38.7-561.2-108.3-169-293.1-269.9-494.3-269.9H8871.53v-4426.5c0-213.7-118.02-406.8-308.01-503.8-190.15-97.1-415.99-79.5-589.32 46-510.74 369.5-978.28 591.2-1352.11 641.1-392.64 52.4-834.44-117.4-1211.69-465.6-497.99-459.7-786.68-1137.4-753.46-1768.8 51.36-975.4 362.43-1798.4 832.14-2201.5 279.44-239.8 617.08-342.1 1003.51-303.2 491.8 49.1 993.59 243.5 1491.49 577.7 177.38 118.9 403.58 131 590.37 31.3 186.04-99.2 297.08-284.8 297.08-496.6v-4364.7h4181.97c214.6 0 412 107.5 528.1 287.5 117.1 181.7 133.5 408.3 43.7 606.1-585.6 1291.7-758.7 2175.7-514.5 2627.4 100.3 185.7 269.4 298.1 502.5 334.3 243.8 37.9 546.8 60 875 60zm6695.9-4050.1h-4469.3c-265.6 0-508.7 134.4-650.2 359.6-139.8 222.4-155.6 495.8-42.3 731.3 113.5 236 369.5 492 617 739.6 340.6 340.6 692.8 692.8 658.6 966.5-25.4 202.7-144 385.3-352.7 542.6-475.4 358.6-1890.6 737.8-3311.3 517.3-191.9-29.8-324.3-116.6-404.6-265.2-219.9-406.9-40.6-1274 518.7-2507.6 108.7-239.7 88.9-514.4-53.2-734.8-141-218.7-380.7-349.3-641.4-349.3H8804.11c-37.23 0-67.43 30.2-67.43 67.4v4432.1c0 161.1-84.37 302.3-225.67 377.7-144.95 77.2-313.87 68.2-451.81-24.4-516.49-346.7-1039.09-548.5-1553.18-599.9-424.85-42.5-796.26 70.3-1104.77 335.1-238.71 204.8-802.22 838.7-878.96 2296.7-35.29 670.4 269.99 1388.9 796.63 1875 406.83 375.5 888.47 557.7 1321.02 500.1 401.48-53.5 876.99-277.4 1413.34-665.5 134.05-97 301.92-110.2 448.91-35.1 146.83 75 234.49 218.4 234.49 383.7v4493.9c0 37.2 30.2 67.4 67.43 67.4h4546.39c155 0 297.3 77.7 380.7 207.8 83.3 130 94.4 291.6 29.7 432.2-400.3 870.2-757 2017.2-182.6 2539.9 550.4 500.9 1691.5 708 2597.7 471.3 581.1-151.7 979.3-469.6 1121.1-894.9 230.6-692.1-85.4-1518.4-391.2-2089.6-75.8-141.6-71.9-308.1 10.4-445.5 82.3-137.3 227.2-219.3 387.6-219.3h3880.3c37.3 0 67.5-30.2 67.5-67.5v-4161.8c0-235.9-131.2-450.2-342.4-559.3-206.6-106.7-441.5-91.2-628.3 41.4-711.3 504.8-1510.8 602.1-2251.3 273.9-718.1-318.2-1237.1-982.2-1322.3-1691.7-107.8-897.9 168.5-1799.7 720.9-2353.4 350-350.8 768.7-517.5 1179.9-469.1 573.6 67.5 1241.4 407 1700.6 679.9 196.1 116.5 431.2 118.9 628.8 6.4 196.7-111.8 314.1-313.9 314.1-540.6v-4596.9c0-37.2-30.2-67.4-67.5-67.4"
          ></path>
          <g>
            <g clipPath="url(#clipPath82)">
              <path
                fill="url(#linearGradient88)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M25777.1 27943.6c-36.3 0-69.8 23.6-80.7 60.2-27.2 91.2-50.7 185-70.1 278.6-9.4 45.6 19.9 90.2 65.4 99.6l1.6.3c5.3 1 10.5 1.4 15.6 1.4 39.1 0 74.2-27.3 82.4-67.2 18.4-88.9 40.8-178 66.6-264.6 13.2-44.6-12.2-91.6-56.8-104.8-2.8-.9-5.7-1.6-8.6-2.1-5.1-1-10.3-1.4-15.4-1.4"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath98)">
              <path
                fill="url(#linearGradient104)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M25580.2 28699.4c-9.6 12.6-15.7 28.1-16.9 45.1-6.4 95.4-8.7 192-7 287.1.8 46.1 38.3 82.7 84.4 82.7h1.3c46.5-.8 83.5-39.2 82.7-85.7-1.4-78.7.1-158.4 4.6-237.5-50.4-29-100.2-59.6-149.1-91.7"
              ></path>
            </g>
          </g>
          <path
            fill="#dce6fb"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M25647.3 28665.9c-27.1 0-51.6 13-67.1 33.5 48.9 32.1 98.7 62.7 149.1 91.7.6-11.8 1.4-23.5 2.2-35.3 2.9-43-27.1-80.7-68.5-88.4-3.3-.6-6.6-1-9.9-1.3-2-.1-3.9-.2-5.8-.2"
          ></path>
          <g>
            <g clipPath="url(#clipPath116)">
              <path
                fill="url(#linearGradient122)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M25680.3 29398.9c-4.4 0-8.8.4-13.3 1.1-45.9 7.3-77.3 50.4-70 96.4 15 94.2 34.2 188.9 57.2 281.5 9.5 38.4 44 64 81.8 64 6.7 0 13.5-.9 20.3-2.5 45.1-11.2 72.6-57 61.4-102.1-21.8-87.9-40.1-177.9-54.3-267.3-5.7-36.2-33.6-63.3-67.7-69.7-5-.9-10.1-1.4-15.4-1.4m195.9 707.4c-10.5 0-21.2 1.9-31.5 6.1-43.1 17.4-64 66.5-46.7 109.6 35.7 88.5 75.6 176.6 118.7 261.7 14.8 29.3 44.5 46.2 75.3 46.2 12.7 0 25.7-2.9 37.9-9.1 41.5-21 58.1-71.7 37.1-113.2-40.9-80.8-78.8-164.4-112.7-248.6-11.1-27.7-35.4-46.2-62.7-51.3-5.1-.9-10.2-1.4-15.4-1.4"
              ></path>
            </g>
          </g>
          <path
            fill="#dee8fd"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M26224.7 30752.2c-9.8 0-19.6 1.7-29 5.1-7.9 4.5-16 9.2-23.9 13.7-34.1 27.4-41.6 77-16.2 113.4 54.2 78.3 112.6 155.3 173.5 228.8 16.7 20.2 40.7 30.6 65 30.6 18.9 0 37.9-6.3 53.7-19.3 35.8-29.7 40.8-82.8 11.2-118.6-57.9-70-113.4-143.2-165-217.5-13.2-19-32.7-30.8-53.7-34.8-5.2-.9-10.4-1.4-15.6-1.4"
          ></path>
          <g>
            <g clipPath="url(#clipPath134)">
              <path
                fill="url(#linearGradient140)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M26195.7 30757.3c-6.5 2.5-12.9 5.7-18.9 9.9-1.8 1.2-3.4 2.5-5 3.8 7.9-4.5 16-9.2 23.9-13.7"
              ></path>
            </g>
          </g>
          <path
            fill="#dee8fd"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M26707.5 31304.8c-22.8 0-45.5 9.2-62.1 27.4-31.4 34.3-29 87.6 5.3 119 70.3 64.4 144.3 126.6 219.9 184.7 15.3 11.8 33.4 17.5 51.3 17.5 25.3 0 50.2-11.3 66.8-32.8 28.4-36.9 21.5-89.8-15.3-118.2-71.9-55.3-142.1-114.3-209-175.5-12-11-26.4-17.8-41.3-20.6-5.1-1-10.4-1.5-15.6-1.5m593.1 431.7c-29.3 0-57.8 15.3-73.3 42.6-23 40.5-8.8 91.9 31.6 114.9 82.9 47.1 168.9 91.2 255.5 131 11.4 5.2 23.4 7.7 35.1 7.7 32 0 62.5-18.1 76.7-49 19.4-42.3.9-92.3-41.4-111.7-82.3-37.9-163.9-79.7-242.6-124.5-8.4-4.7-17.2-7.9-26.2-9.6-5.1-1-10.2-1.4-15.4-1.4m674.5 288.3c-36.2 0-69.7 23.6-80.7 60.1-13.3 44.6 12 91.5 56.5 104.9 91.3 27.4 185 51.1 278.4 70.6l1.8.4c5.2.9 10.4 1.4 15.5 1.4 39.1 0 74.1-27.3 82.4-67 9.5-45.6-19.7-90.2-65.3-99.7-88.7-18.5-177.7-41.1-264.4-67.1-2.9-.9-5.9-1.6-8.8-2.1-5.1-1-10.3-1.5-15.4-1.5m1730.2 44.5c-6.7 0-13.5.8-20.3 2.5-87.8 21.6-177.8 39.8-267.5 53.8-45.9 7.2-77.4 50.3-70.2 96.3 6.5 41.5 42.4 71.2 83.2 71.2 4.3 0 8.7-.3 13.1-1 94.4-14.8 189.2-33.9 281.8-56.7 45.1-11.1 72.7-56.8 61.6-102-8.2-33.1-34.9-56.8-66.4-62.7-5-.9-10.1-1.4-15.3-1.4m-1008.1 86.7c-43.9 0-80.9 34-84 78.4-3.2 46.5 31.8 86.9 78.2 89.9 77.8 5.4 156.5 8.1 234.7 8.1 17.5 0 35-.2 52.5-.4 46.5-.8 83.7-39.1 82.9-85.6-.6-40.7-30.1-74.3-68.7-81.5-5-.9-10.2-1.4-15.5-1.4h-1.3c-16.8.2-33.7.4-50.5.4-74.1 0-148.7-2.6-222.4-7.7-2-.1-4-.2-5.9-.2"
          ></path>
          <path
            fill="#dee8fd"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M30264.3 31876.3c-11.5 0-23.2 2.4-34.4 7.5-39.6 17.8-80.3 35.1-120.8 51.4-43.2 17.3-64.1 66.4-46.8 109.6 13.2 32.8 44.8 52.8 78.2 52.8 10.4 0 21.1-1.9 31.4-6.1 42.7-17.1 85.4-35.3 127.1-54.1 42.4-19.1 61.3-69 42.3-111.3-11.8-26.2-35.3-43.4-61.5-48.3-5.1-1-10.2-1.5-15.5-1.5"
          ></path>
          <path
            fill="#dee8fd"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M32009.1 29991.5c-34.6 0-67 21.4-79.3 55.9-14.6 40.9-30.4 82.1-46.8 122.6-17.5 43.2 3.3 92.3 46.5 109.7 10.4 4.2 21.1 6.2 31.7 6.2 33.3 0 64.7-19.9 78-52.6 17.2-42.6 33.8-86.1 49.2-129.2 15.7-43.8-7.1-92-50.9-107.7-4.3-1.5-8.7-2.7-13-3.5-5.1-.9-10.3-1.4-15.4-1.4"
          ></path>
          <g>
            <g clipPath="url(#clipPath156)">
              <path
                fill="url(#linearGradient162)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M28917.6 25602.3c-76.9 0-154.2 2.6-230.4 7.9-46.4 3.1-81.5 43.4-78.3 89.7 3.1 44.4 40 78.6 83.8 78.6 2 0 4-.1 6-.3 72.6-4.9 146.1-7.4 219.3-7.4 16.4 0 32.8.1 49.2.4h1.3c46 0 83.5-36.9 84.2-82.9.7-41.7-29-76.8-68.6-84.2-4.6-.8-9.4-1.3-14.3-1.4-17.4-.3-34.8-.4-52.2-.4m497 37.6c-41 0-76.9 29.9-83.2 71.6-7.1 46 24.8 89.2 70.5 96 89.2 13.6 177.6 30.8 263.7 51.3 6.6 1.5 13.1 2.3 19.6 2.3 38.1 0 72.7-26 81.9-64.7 10.8-45.3-17.2-90.7-62.4-101.5-53.3-12.7-107.9-24.3-162.3-34.5-38.1-7.1-76.5-13.6-115.1-19.5-4.3-.6-8.5-1-12.7-1"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath172)">
              <path
                fill="url(#linearGradient178)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M28249.7 25671.1c-5.8 0-11.6.6-17.4 1.8-91.9 19.2-184.2 42.6-274.1 69.5-44.6 13.3-69.9 60.2-56.6 104.8 11 36.5 44.4 60.1 80.7 60.1 8 0 16.1-1.1 24.2-3.5 85.4-25.5 172.9-47.7 260.2-66 45.6-9.5 74.8-54.1 65.3-99.6-7.2-34.5-34.5-59.6-67-65.7-5-.9-10.1-1.4-15.3-1.4"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath188)">
              <path
                fill="url(#linearGradient194)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M30112.4 25825.8c-33.7 0-65.6 20.4-78.5 53.8-16.9 43.3 4.6 92.1 47.9 109 83 32.3 165.7 68.5 245.9 107.8 11.9 5.8 24.5 8.6 37 8.6 31.1 0 61-17.3 75.7-47.2 20.4-41.8 3.2-92.2-38.6-112.7-84.4-41.4-171.5-79.5-258.9-113.5-5-2-10.1-3.4-15.1-4.3-5.2-1-10.3-1.5-15.4-1.5"
              ></path>
            </g>
          </g>
          <path
            fill="#dee8fd"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M30819.2 26188.5c-28.5 48.6-57.3 97-86.4 145.1 64.1 44.2 127.3 91.2 188 140.1 15.6 12.5 34.2 18.5 52.8 18.5 24.6 0 49-10.7 65.7-31.4 29.1-36.3 23.3-89.3-12.9-118.5-66.9-53.7-136.5-105.4-207.2-153.8"
          ></path>
          <g>
            <g clipPath="url(#clipPath206)">
              <path
                fill="url(#linearGradient212)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M30751.9 26160.3c-27.1 0-53.7 13.1-70 37.2-25.9 38.6-15.7 91 22.9 117 9.3 6.3 18.7 12.6 28 19.1 29.1-48.1 57.9-96.5 86.4-145.1-6.8-4.6-13.5-9.2-20.3-13.8-9.8-6.6-20.6-10.9-31.6-12.9-5.1-1-10.2-1.5-15.4-1.5"
              ></path>
            </g>
          </g>
          <path
            fill="#dee8fd"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M31302.5 26627.1c-20.8 0-41.6 7.6-57.9 23-33.8 32-35.3 85.3-3.3 119.1 61.3 64.8 120.6 133 176.3 202.6 16.6 20.8 41.1 31.7 65.8 31.7 18.4 0 37-6 52.6-18.5 36.3-29 42.2-82 13.2-118.4-58.6-73.2-121-145-185.5-213.2-12.7-13.4-28.8-21.7-45.7-24.9-5.1-.9-10.3-1.4-15.5-1.4m435.9 575.7c-14.7 0-29.6 3.8-43.1 11.9-40 23.9-53 75.6-29.2 115.6 45.8 76.6 88.9 156.1 128 236.1 14.6 29.9 44.5 47.2 75.7 47.2 12.4 0 25-2.7 36.9-8.5 41.8-20.5 59.2-70.9 38.7-112.7-41.2-84.2-86.4-167.9-134.6-248.5-12.9-21.6-34-35.4-56.9-39.7-5.1-.9-10.3-1.4-15.5-1.4m300 657c-8.7 0-17.6 1.4-26.3 4.3-44.2 14.5-68.3 62.1-53.7 106.3 27.9 84.8 52.4 171.7 73 258.4 9.2 38.7 43.8 64.8 82 64.8 6.4 0 12.9-.8 19.4-2.3 45.3-10.8 73.3-56.2 62.6-101.4-21.7-91.3-47.6-182.9-77-272.1-9.9-30.3-35.4-51.1-64.6-56.5-5-1-10.2-1.5-15.4-1.5m148.5 707.1c-2.8 0-5.5.2-8.3.4-46.3 4.5-80.2 45.6-75.8 91.9 8.5 88.6 13.3 178.8 14.3 268 .5 46.2 38.3 83.3 84.3 83.3h.9c46.5-.5 83.8-38.6 83.3-85.2-1-93.9-6.1-188.8-15.1-282.1-3.6-38.3-32.3-68.1-68.3-74.8-5-1-10.1-1.5-15.3-1.5m-10.9 721.9c-41.9 0-78.2 31.2-83.5 73.9-8.1 65.2-18.3 130.8-30.4 195.3-4.4 23.3-9 46.5-13.8 69.6-9.6 45.6 19.6 90.2 65.2 99.8 6.2 1.4 12.4 2.1 18.4 2.1 38.8 0 73-27.9 81.3-67.3 5.1-24.3 9.9-48.7 14.5-73.3 12.7-67.7 23.4-136.9 32-205.4 5.5-44.4-24.6-85.1-68.1-93.2-1.7-.3-3.4-.6-5.1-.8-3.5-.4-7-.7-10.5-.7"
          ></path>
          <g>
            <g clipPath="url(#clipPath224)">
              <path
                fill="url(#linearGradient230)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M27561.2 25897.1c-11.7 0-23.5 2.4-34.8 7.5-41.5 19-83.4 39.1-124.5 60-41.5 21-58.1 71.7-37.1 113.2 14.9 29.3 44.5 46.2 75.2 46.2 12.8 0 25.8-3 38-9.2 39.1-19.7 78.9-38.9 118.2-56.9 42.4-19.2 61.1-69.2 41.7-111.5-11.8-26-35.1-43-61.2-47.9-5.1-1-10.3-1.4-15.5-1.4"
              ></path>
            </g>
          </g>
          <path
            fill="#91b3fa"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M27508.9 26879.9c12.8-10.9 31.1-12.4 45.5-3.8l411.8 245.2c199.3-101.6 416.3-172.2 644.2-205.7l193.5-438.1c6.8-15.4 22.6-24.7 39.3-23.3l572.8 48.1c16.7 1.4 30.7 13.3 34.9 29.6l117.6 464.2c219.1 71.1 421.3 177 600.9 310.5l446.8-173.1c15.7-6.1 33.5-1.5 44.3 11.3l371 439.1c10.9 12.8 12.4 31.1 3.8 45.5l-245.3 411.8c101.7 199.3 172.2 416.4 205.8 644.2l438.1 193.5c15.3 6.8 24.7 22.6 23.3 39.3l-48.1 572.8c-1.5 16.8-13.3 30.8-29.6 34.9l-464.2 117.6c-71.2 219.1-177 421.3-310.5 600.9l173.1 446.9c6 15.6 1.5 33.4-11.3 44.2l-439.1 371c-12.9 10.9-31.2 12.4-45.6 3.8l-411.7-245.3c-199.4 101.7-416.4 172.3-644.2 205.8l-193.5 438.1c-6.8 15.4-22.6 24.7-39.4 23.3l-572.7-48.1c-16.8-1.4-30.8-13.3-34.9-29.6l-117.7-464.2c-219-71.2-421.2-177-600.8-310.5l-446.9 173.1c-15.6 6-33.4 1.5-44.3-11.3l-370.9-439.1c-10.9-12.8-12.4-31.1-3.8-45.6l245.2-411.7c-101.6-199.4-172.2-416.4-205.7-644.2l-438.1-193.5c-15.4-6.8-24.8-22.6-23.3-39.3l48.1-572.8c1.4-16.8 13.3-30.8 29.6-34.9l464.2-117.6c71.1-219.1 176.9-421.3 310.5-600.9l-173.1-446.9c-6.1-15.6-1.5-33.4 11.3-44.3l439.1-370.9"
          ></path>
          <path
            fill="#bdd0fb"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M28837.7 29428.9c-21.4-4-42.6-9.6-63.6-16.8-231-79.4-354.3-332-274.9-562.9 79.5-231 332-354.5 563-274.9 231 79.4 354.3 331.9 274.9 562.9-38.5 111.9-118.2 202.1-224.5 254.1-86.5 42.2-182.1 55-274.9 37.6zm186.3-1003.8c-276.9-51.7-558 106.1-652.2 380.2-103.6 301.3 57.2 630.7 358.5 734.3 146 50.2 302.7 40.5 441.4-27.2s242.7-185.4 292.9-331.3c103.6-301.3-57.3-630.7-358.6-734.3-27.1-9.3-54.6-16.5-82-21.7"
          ></path>
          <path
            fill="#bdd0fb"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M29189 27607c-47.6-8.9-95.8-15.4-144.7-19.6-15.4-1.3-30.8-2.3-46.2-3.1-76-3.9-152.2-1.8-227.4 6.3-1.1.1-2.1.2-3.1.3-2.9.4-5.8.7-8.7 1.1-5.7.6-11.4 1.3-17 2-14.8 1.9-26.2 13.3-28.8 27.2-.7 3.4-.8 7-.3 10.6 2.4 18.4 19.3 31.4 37.7 29.1 95-12.3 191.9-14.4 288.1-6.3 477.9 40.1 877.4 325.3 1085.4 721.3 115.7 220.3 172.2 474.9 149.8 740.6-3.9 46.6-10.1 92.7-18.6 138.1-57.1 305.2-216.1 579.2-456.5 782.3-276.1 233.3-626.6 345.1-986.8 314.8-743.9-62.6-1297.7-718.4-1235.2-1461.9 3.9-45.9 10-91.4 18.5-136.3 36.4-194.7 115-379.2 230.9-540.1 2.9-4.2 4.9-8.8 5.7-13.5 2.4-12.4-2.5-25.7-13.4-33.5-15.2-10.9-36.2-7.5-47.1 7.6-121.6 168.9-204.1 362.7-242.4 567.1-8.8 47.2-15.3 94.9-19.3 143-65.7 780.7 516.3 1469.1 1296.7 1534.8 378.1 31.8 746-85.6 1035.9-330.6 252.3-213.1 419.2-500.8 479.2-821.2 8.9-47.7 15.5-96 19.6-144.9 31.8-378.2-85.6-746.1-330.5-1035.9-213.3-252.5-501-419.4-821.5-479.3"
          ></path>
          <g>
            <g clipPath="url(#clipPath246)">
              <path
                fill="url(#linearGradient252)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M23365.1 25233.6c-18.9 0-37.2 10.4-46.4 28.4-20 39.4-39.1 79.9-56.7 120.5-11.5 26.3.6 56.9 26.9 68.4 6.8 3 13.9 4.4 20.8 4.4 20.1 0 39.2-11.7 47.7-31.3 16.8-38.6 35-77.3 54.1-114.8 13-25.6 2.8-56.9-22.8-70-4.5-2.3-9.3-3.8-14-4.7-3.2-.6-6.4-.9-9.6-.9"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath262)">
              <path
                fill="url(#linearGradient268)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M23217.3 25605.5c-22.5 0-43.3 14.7-49.9 37.3-21.5 73-39.5 147.9-53.5 222.6-2.9 15.7-5.7 31.6-8.3 47.4-4.7 28.4 16.2 54.4 42.8 59.9 2.9.5 5.7.7 8.6.7 25 0 47-18.1 51.2-43.5 2.6-15.2 5.2-30.3 8-45.4 13.3-71.2 30.5-142.7 51-212.2 8.1-27.6-7.7-56.5-35.2-64.7-1.8-.5-3.5-.9-5.2-1.2-3.2-.6-6.4-.9-9.5-.9m-88.1 533c-27.8 0-50.9 21.9-52.1 49.9-3.8 92.1-2 185.3 5.4 276.9 2.2 27.2 25.2 47.8 51.9 47.8 1.4 0 2.8-.1 4.2-.2 28.7-2.3 50-27.4 47.6-56-7.1-87.4-8.8-176.3-5.1-264.2 1.1-26.1-17.3-48.6-42.3-53.3-2.5-.4-5-.7-7.5-.9h-2.1m43.9 538.5c-3.5 0-7.1.4-10.7 1.1-28.1 5.8-46.1 33.4-40.2 61.6 18.8 90.1 43.4 180 73.3 267.2 7.4 21.6 27.5 35.2 49.1 35.2 5.6 0 11.3-.9 16.9-2.8 27.2-9.3 41.7-38.9 32.4-66.1-28.4-83.1-52-168.9-69.9-254.8-4.4-21.3-21.3-36.8-41.4-40.5-3.1-.6-6.2-.9-9.5-.9m174.9 511.2c-7.7 0-15.4 1.7-22.8 5.2-25.8 12.6-36.6 43.8-24 69.6 40.4 82.9 86.3 164.1 136.5 241.1 9.9 15.4 26.6 23.7 43.6 23.7 9.8 0 19.6-2.8 28.4-8.4 24.1-15.7 30.9-47.9 15.2-72-47.8-73.5-91.6-150.9-130.1-229.9-7.5-15.4-21.6-25.5-37.3-28.4-3.1-.6-6.3-.9-9.5-.9m294.4 453c-11.9 0-23.8 4-33.5 12.2-22 18.5-24.8 51.3-6.3 73.3 59.2 70.5 123.4 138 190.8 200.6 10 9.4 22.7 14 35.4 14 13.9 0 27.9-5.6 38.1-16.6 19.6-21.1 18.4-54-2.6-73.5-64.3-59.8-125.5-124.2-182.1-191.5-8-9.5-18.8-15.5-30.2-17.6-3.2-.6-6.4-.9-9.6-.9m395.4 367.7c-16.1 0-32 7.5-42.2 21.6-16.8 23.2-11.6 55.8 11.7 72.6 74.6 54 153.4 103.8 234 148 7.9 4.4 16.5 6.4 25 6.4 18.3 0 36.1-9.7 45.6-27 13.8-25.2 4.6-56.8-20.6-70.6-76.8-42.2-151.9-89.7-223-141.1-6.4-4.7-13.6-7.6-20.9-9-3.2-.6-6.4-.9-9.6-.9m473.3 259.9c-20.7 0-40.3 12.4-48.4 32.8-10.6 26.7 2.5 56.9 29.2 67.6 85.3 33.9 173.9 62.8 263.2 86.1 4.3 1 8.6 1.5 12.8 1.5 23.4 0 44.6-15.3 50.7-38.8 7.2-27.8-9.4-56.2-37.3-63.5-85.2-22.1-169.7-49.7-251-82.1-3.2-1.2-6.5-2.1-9.7-2.8-3.2-.5-6.4-.8-9.5-.8m522.8 135.8c-25.7 0-48.1 19-51.6 45.1-3.9 28.6 16.2 55.6 44.7 58.5 12 1.6 24.1 3.1 36.2 4.5 79.7 9.2 160.6 14.3 240.2 15h.4c10.9 0 21-3.3 29.3-9-38.7-31.5-76.7-64-113.8-97.5-48.1-2.3-96.4-6.3-144.3-11.9-11.6-1.3-22.9-2.7-34.2-4.3-2.3-.3-4.7-.4-6.9-.4"
              ></path>
            </g>
          </g>
          <path
            fill="#dce6fb"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M25219.3 28421.2c37.1 33.5 75.1 66 113.8 97.5 13.6-9.3 22.6-24.8 22.7-42.5.3-25.6-18-47.1-42.4-51.6-2.9-.5-6-.9-9.1-.9-28.2-.3-56.6-1.1-85-2.5"
          ></path>
          <g>
            <g clipPath="url(#clipPath280)">
              <path
                fill="url(#linearGradient286)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M25319.4 24033.2c-31.9 0-63.8.6-95.5 2-28.7 1.2-51 25.4-49.8 54.1 1.2 28.1 24.5 49.9 52.1 49.9h2.1c30.3-1.3 60.8-2 91.3-2 56.3 0 112.7 2.2 168.6 6.6 1.4.1 2.8.1 4.2.1 26.8 0 49.6-20.7 51.7-47.9 2.1-26.8-16.4-50.4-42.2-55.2-1.8-.4-3.7-.6-5.6-.8-58.6-4.5-117.8-6.8-176.9-6.8m-358.1 29.5c-2.9 0-5.7.2-8.6.7-89.4 14.9-178.8 35.4-265.7 61.1-27.5 8.1-43.3 37.1-35.1 64.7 6.7 22.6 27.5 37.2 49.9 37.2 4.9 0 9.8-.7 14.7-2.1 82.8-24.5 168.1-44 253.3-58.3 28.3-4.7 47.5-31.5 42.8-59.8-3.7-22.2-20.9-38.7-41.8-42.6-3.1-.6-6.3-.9-9.5-.9m794.7 13.7c-24.3 0-46 17.1-51 41.8-5.6 28.2 12.6 55.6 40.8 61.3 84.8 17 169.3 39.3 251.2 66.3 5.3 1.7 10.7 2.5 16.1 2.5 21.9 0 42.4-13.6 49.6-35.6 9-27.3-5.8-56.7-33.1-65.7-85.8-28.3-174.4-51.8-263.3-69.6l-.7-.1c-3.2-.6-6.4-.9-9.6-.9m504.5 166.7c-19.5 0-38.2 11-47.1 29.8-12.2 25.9-1.1 57 24.8 69.2 78.3 37.1 154.9 79.2 227.8 125.2 8.7 5.5 18.3 8 27.8 8 17.2 0 34.1-8.5 44-24.2 15.3-24.3 8-56.4-16.3-71.8-76.4-48.3-156.7-92.4-238.8-131.2-4.1-1.9-8.4-3.3-12.7-4.1-3.1-.6-6.3-.9-9.5-.9m449.1 283.7c-15.1 0-30.1 6.5-40.3 19.1-18.2 22.3-14.9 55 7.4 73.2 66.9 54.6 131.1 113.8 190.9 176.2 10.2 10.7 23.9 16 37.5 16 13 0 26-4.8 36.1-14.5 20.7-19.9 21.4-52.9 1.5-73.6-62.8-65.3-130.1-127.5-200.2-184.7-7-5.7-15.1-9.3-23.3-10.9-3.2-.5-6.4-.8-9.6-.8m368 383.1c-10.9 0-21.9 3.4-31.2 10.4-23 17.3-27.7 49.9-10.4 72.9 52 69.2 100.2 142.2 143.4 216.8 9.6 16.7 27.1 26 45.1 26 8.8 0 17.8-2.2 25.9-7 24.9-14.3 33.4-46.1 19.1-71-45.3-78.3-95.8-154.8-150.3-227.3-8.1-10.8-19.7-17.6-32-19.9-3.2-.6-6.4-.9-9.6-.9m265.7 460.3c-6.8 0-13.7 1.3-20.4 4.2-26.4 11.2-38.7 41.8-27.5 68.3 34 79.5 63.3 162 87.2 244.8 6.6 22.8 27.4 37.6 50 37.6 4.7 0 9.6-.6 14.4-2 27.6-8 43.5-36.8 35.6-64.4-25.1-86.9-55.8-173.3-91.4-256.9-7.1-16.6-21.8-27.6-38.4-30.7-3.1-.6-6.3-.9-9.5-.9"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath296)">
              <path
                fill="url(#linearGradient302)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M24449.2 24214.1c-6.9 0-13.9 1.4-20.7 4.3-40.8 17.8-81.3 36.8-120.4 56.6-25.6 13-35.9 44.3-22.9 70 9.2 18 27.6 28.4 46.6 28.4 7.8 0 15.8-1.7 23.4-5.5 37.2-18.9 75.9-37.1 114.8-54 26.4-11.5 38.4-42.2 27-68.5-7.2-16.4-21.8-27.3-38.2-30.4-3.1-.6-6.3-.9-9.6-.9"
              ></path>
            </g>
          </g>
          <path
            fill="#91b3fa"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M24377.8 24883.7c8.6-7.3 20.8-8.3 30.5-2.6l275.5 164.1c133.4-68 278.6-115.2 431.1-137.7l129.4-293.1c4.6-10.3 15.1-16.5 26.3-15.6l383.3 32.2c11.2 1 20.6 8.9 23.4 19.8l78.7 310.6c146.6 47.6 281.9 118.4 402 207.8l299.1-115.8c10.5-4.1 22.4-1 29.6 7.6l248.3 293.8c7.2 8.6 8.2 20.8 2.5 30.4l-164.1 275.5c68 133.5 115.2 278.7 137.7 431.2l293.1 129.4c10.3 4.6 16.6 15.1 15.6 26.3l-32.2 383.3c-1 11.2-8.9 20.6-19.8 23.4l-310.6 78.7c-47.6 146.6-118.4 281.8-207.8 402l115.8 299.1c4.1 10.5 1 22.3-7.5 29.6l-293.9 248.2c-8.5 7.3-20.8 8.3-30.4 2.5l-275.5-164c-133.4 68-278.7 115.2-431.1 137.7l-129.5 293.1c-4.6 10.3-15.1 16.5-26.3 15.6l-383.3-32.2c-11.2-1-20.6-8.9-23.3-19.8l-78.8-310.7c-146.5-47.5-281.8-118.3-402-207.7l-299 115.8c-10.5 4.1-22.4 1-29.7-7.6l-248.2-293.8c-7.3-8.5-8.3-20.8-2.5-30.4l164.1-275.5c-68.1-133.5-115.3-278.7-137.7-431.2l-293.2-129.4c-10.3-4.6-16.5-15.1-15.6-26.3l32.2-383.3c1-11.2 8.9-20.6 19.8-23.4l310.7-78.7c47.6-146.6 118.4-281.8 207.7-402l-115.8-299.1c-4.1-10.5-1-22.3 7.6-29.6l293.8-248.2"
          ></path>
          <path
            fill="#bdd0fb"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M25267.8 26582.4c-13.8-2.5-27.5-6.1-41.1-10.8-151-52-231.6-217-179.7-367.9 25.2-73.1 77.3-132.1 146.8-166 69.5-34 148-38.7 221.1-13.7 73.2 25.2 132.1 77.3 166.1 146.7 33.9 69.6 38.7 148.1 13.6 221.3-47.2 137.3-188.1 216.4-326.8 190.4zm124.5-671.7c-82.5-15.4-167.4-4-244.2 33.4-94.5 46.2-165.3 126.3-199.5 225.8-70.5 205.1 39 429.5 244.2 500.1 205.6 70.3 429.7-39 500.2-244.2 34.2-99.5 27.6-206.3-18.5-300.7-46.1-94.5-126.3-165.3-225.8-199.5-18.5-6.4-37.4-11.3-56.4-14.9"
          ></path>
          <path
            fill="#bdd0fb"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M25506.4 25341.1c-32.3-6-65.3-10.5-98.7-13.3-66.5-5.6-133.7-4.5-199.7 3.4-3 .4-5.9.8-8.9 1.1-23 3-40.5 20.4-44.5 42-1 5.3-1.2 10.8-.5 16.3 3.7 28.5 29.9 48.5 58.3 44.9 61.6-7.9 124.4-9.3 186.5-4 3.4.2 6.9.6 10.2.9 147 13.8 284.9 63.7 404.2 143.9 64.8 43.5 124.1 96 176.3 156.7l1.3 1.5 3.9 4.5c151 178.8 223.4 405.7 203.8 638.9-2.6 30.1-6.6 59.9-12.1 89.3-37 197.6-139.9 375-295.5 506.5-178.8 151-405.7 223.4-638.8 203.7-233-19.6-444.8-128.8-595.9-307.5-151-178.8-223.4-405.7-203.8-638.8 2.5-29.7 6.5-59.2 12-88.2 23.6-126.1 74.4-245.5 149.4-349.7 4.6-6.4 7.6-13.5 8.9-20.8 3.6-19.2-3.8-39.7-20.7-51.8-23.4-16.7-55.8-11.5-72.6 11.8-83.9 116.6-140.9 250.3-167.3 391.2-6.1 32.6-10.6 65.5-13.4 98.7-21.9 260.9 59.1 514.7 228.1 714.7 168.9 200 405.5 322.4 666.5 344.2 260.9 21.9 514.7-59 714.7-228.1 174.1-147 289.3-345.5 330.7-566.6 6.1-32.8 10.6-66.2 13.5-99.9 42.4-505.1-307.9-954.3-795.9-1045.5"
          ></path>
          <g>
            <g clipPath="url(#clipPath318)">
              <path
                fill="url(#linearGradient324)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M16881.8 18382.5s-156.7 412.3-339.6 374.5c-183-37.7-383.1-178.3-383.1-178.3l-293.9-397.5s825.1-325 1115.2-138.7c0 0 842.8-145.6 1907 29-154.1 325.2-245.9 650.9-299.8 903.6-539-305.1-1119.6-533-1705.8-592.6"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath334)">
              <path
                fill="url(#linearGradient340)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M21345.9 21373.2s-1206.6-1519.8-2758.3-2398.1c53.9-252.7 145.7-578.4 299.8-903.6 804.9 132.1 1736.5 447.3 2526.3 1147.7l-67.8 2154"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath350)">
              <path
                fill="url(#linearGradient356)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M23555.2 14537.6c-227.8 0-462.7 33.7-704.6 99.8-235.9 1120.8-471.9 1769.7-1262 3894.2-248.6 668.5-474.4 1345-365.3 2049.9l122.6 791.7s702 237.5 1682.8 237.5c469.8 0 1003.4-54.5 1554.6-215.7 0 0 2070.9-899.2 973.2-5194.9-457.9-50.6-1441.2-188.3-1968.9-479.3-58.8-32.5-98.1-91.3-105.5-157.9-7.1-63.5-6.5-146.9 23.7-228.1 14.3-38.1 51.1-62.4 91-62.4 5.3 0 10.5.4 15.8 1.3l1763.8 285.3c-15.7-51.2-31.7-102.8-48.2-154.8-526.9-589.5-1120.5-866.6-1773-866.6"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath366)">
              <path
                fill="url(#linearGradient372)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M21607.2 22383.6l398.2-956.5c25.1-60.5 79.5-103.5 144-114.6 229.5-39.3 784.7-100.8 1149.4 138.9 43.4 28.6 54.5 87.6 24.7 130.3l-735.5 1056.1-980.8-254.2"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath382)">
              <path
                fill="url(#linearGradient388)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M22019 23847c-16.7-15.7-705.7-1368.7-705.7-1368.7l780.9-377 843.5 1185.4s-638.8 823.9-918.7 560.3"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath398)">
              <path
                fill="url(#linearGradient404)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M22582.9 23144.4l-389.5-649.2c-5.9-9.8-13-18.7-21.4-26.6-46.3-43.1-205-168.6-327.6 2.2-104.5 145.7-202.6 278.1-307.7 332.7-61.3 31.9-136.9 6.5-168-55.3-64.2-127.2-188.5-386.4-266.6-632.3-19.5-61.6 12.3-127.7 72.2-152 158.1-64.1 470.6-179.9 747.9-218.2 45.6-6.3 90.7 12.9 117.8 50.1 119.3 163.4 455.6 620.2 570.4 734.5 106.6 106.2 303.4 66.2 392.1 40.7 33.6-9.7 69.5-5 99.5 13.1 90 54.2 247 189.1 103.3 417.6-35.7 56.8-17.5 132.5 38.6 169.3 100.4 66.1 209.4 190.1 105.6 391-105.2 203.3-292.9 221.6-420.7 205.9-56.6-6.9-114 22.8-135.8 75.5-9.6 23.4-28.7 43.4-64.2 50.6-67 13.6-111 74.9-97.9 142 22.6 115.1 5.6 264.5-178.1 365.5-337 185.3-632.1-116.6-707.1-371.4-75.1-254.8 301.6-434.8 538.6-464.9 174.1-22.1 269.5-212.1 307.9-311.4 14-36 10.5-76.2-9.3-109.4"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath414)">
              <path
                fill="url(#linearGradient420)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M22446.3 22336s167.6 394.3 359.4 378.2c191.8-16.1 342.7-207.2 105-421.9-295.6-267.2-464.4 43.7-464.4 43.7"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath430)">
              <path
                fill="url(#linearGradient436)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M22699.5 4759.4c370.8-32 1014.4-84.1 1521.8-106.4 305-13.5 480.6 16.4 581.8 56.9-.2-11.4-.5-22.2-1-32.2-2.4-53.4-45.8-96.1-99.7-99.1-958.7-53.5-1721.2-18.5-1992.7-2-56.1 3.4-89.6 64.4-60.9 112.3 14.4 23.9 31.8 47.3 50.7 70.5"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath446)">
              <path
                fill="url(#linearGradient452)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M24221.3 4653c-507.4 22.3-1151 74.4-1521.8 106.4 364.6 447.3 1521.8 748.8 1521.8 748.8h326.9c224.8-324 257.3-632.5 254.9-798.3-101.2-40.5-276.8-70.4-581.8-56.9"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath462)">
              <path
                fill="url(#linearGradient468)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M24603.2 6041.8l-30.6-605.2c-3.3-65.6-52.4-120.7-118-130-65.3-9.4-152.8-10.6-245.5 20.3-57.1 19-99.4 67.1-110 125.7l-105.7 589.2h609.8"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath478)">
              <path
                fill="url(#linearGradient484)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M28848.5 4657.5c160.8 22.4 233.6 106 264.1 195.3l.6-2.4c23.7-94.2-31.2-191.9-140.8-238.3-132.6-56.1-277.5-65.7-390-61.1-120.7 5-231.5 55-292.4 134.9l-.9 1.2c121.2-60 291.2-67 559.4-29.6"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath494)">
              <path
                fill="url(#linearGradient500)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M28090.3 6045.7h269.5c410.6 8.4 668.4-857.6 752.8-1192.9-30.5-89.3-103.3-172.9-264.1-195.3-268.2-37.4-438.2-30.4-559.4 29.6-221.8 291.9-331.8 719.4-384.6 968.9-60.2 283.7 185.8 389.7 185.8 389.7"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath510)">
              <path
                fill="url(#linearGradient516)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M28325.2 6607.5l149.7-595.3c18.3-73-16.6-148.5-84.1-183.1-83.7-43-201.6-88.1-310-75.1-50.9 6.2-93.2 42.1-110.1 90l-219.7 626.4 574.2 137.1"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath526)">
              <path
                fill="url(#linearGradient532)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M28503.7 6435.4c-186.2-165.2-791.9-187-791.9-187-2181.8 5236.6-3091.5 6678.2-3091.5 6678.2 315.1-1976.5 67.9-7050 67.9-7050-360-158.8-824.2 0-824.2 0-29.2 3235.9-484.8 6713-1072.4 8937.7 1474.7 33.2 2276.1 354.7 2532.2 557.2 1229.2-1981.8 3179.9-8936.1 3179.9-8936.1"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath542)">
              <path
                fill="url(#linearGradient548)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M22420.1 13351l271.4-1687.7c47.3-294.3 319.9-498.4 617.2-462.2l4061.2 495.4c198.7 24.2 349.3 190.1 353.3 389.3 8.7 436.1-8.4 1212.2-191.4 1919.3l-5111.7-654.1"
              ></path>
            </g>
          </g>
          <path
            fill="#fff"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M27082.7 13936c-5.8 0-10.8 4.3-11.5 10.1-.8 6.4 3.7 12.2 10 13l91.9 11.8c7.2.7 12.1-3.8 12.9-10 .9-6.4-3.6-12.2-10-13l-91.8-11.8zm344-28.2c-5.2 0-9.9 3.5-11.2 8.8-4.9 20.1-9.8 40.1-14.9 60l-10.2-1.3c-6.6-1-12.1 3.7-12.9 10-.9 6.4 3.6 12.2 10 13l30.4 3.9 2.5-9.9c6.1-23.3 11.9-46.7 17.6-70.2 1.5-6.2-2.3-12.5-8.5-14-1-.2-1.9-.3-2.8-.3zm-650.3-11c-5.8 0-10.8 4.3-11.5 10.1-.8 6.4 3.7 12.2 10 13l91.9 11.8c7.3.8 12.1-3.8 12.9-10 .9-6.4-3.6-12.2-10-13l-91.8-11.8zm-306.3-39.2c-5.7 0-10.7 4.3-11.5 10.2-.8 6.3 3.7 12.1 10 12.9l91.9 11.8c7.3.9 12.2-3.7 13-10 .8-6.4-3.7-12.2-10-13l-91.9-11.8zm-306.3-39.2c-5.7 0-10.7 4.3-11.4 10.1-.9 6.4 3.6 12.2 10 13l91.8 11.8c7.4 1 12.2-3.7 13-10 .8-6.4-3.7-12.2-10-13l-91.9-11.8zm-306.2-39.1c-5.8 0-10.8 4.2-11.5 10.1-.8 6.3 3.7 12.1 10 12.9l91.9 11.8c7 .7 12.2-3.7 13-10 .8-6.4-3.7-12.2-10.1-13l-91.8-11.7zm-306.3-39.2c-5.7 0-10.7 4.2-11.5 10.1-.8 6.3 3.7 12.1 10 12.9l91.9 11.8c7 .7 12.2-3.7 13-10 .8-6.4-3.7-12.2-10-13l-91.9-11.7zm-306.3-39.2c-5.7 0-10.7 4.3-11.5 10.1-.8 6.3 3.7 12.1 10 13l91.9 11.7c7.1.8 12.2-3.7 13-10 .8-6.4-3.7-12.1-10-13l-91.9-11.7zm-306.2-39.2c-5.8 0-10.8 4.2-11.5 10.1-.9 6.3 3.6 12.1 10 12.9l91.9 11.8c7.1.9 12.1-3.7 12.9-10 .8-6.4-3.7-12.2-10-13l-91.9-11.7zm-306.3-39.2c-5.8 0-10.7 4.3-11.5 10.1-.8 6.4 3.7 12.1 10 13l91.9 11.7c7.2 1 12.1-3.7 13-10 .8-6.3-3.7-12.1-10.1-13l-91.8-11.7zm2857.1-17c-5.5 0-10.4 3.9-11.4 9.5-5.4 30.3-11 60.6-16.9 90.9-1.2 6.3 2.9 12.4 9.1 13.6 6.2 1.4 12.4-2.9 13.6-9.2 6-30.4 11.6-60.8 17-91.2 1.1-6.3-3.1-12.3-9.4-13.4zm-3163.4-22.2c-5.7 0-10.7 4.3-11.5 10.1-.8 6.3 3.7 12.1 10 13l91.9 11.7c7.3.6 12.2-3.7 13-10 .8-6.3-3.7-12.1-10-13l-91.9-11.7zm-306.3-39.2c-5.7 0-10.7 4.3-11.5 10.1-.8 6.4 3.7 12.2 10 13l91.9 11.7c7.4.7 12.2-3.7 13-10 .8-6.3-3.7-12.1-10-12.9l-91.9-11.8zm-306.2-39.2c-5.8 0-10.8 4.3-11.5 10.1-.9 6.4 3.7 12.2 10 13l91.9 11.7c7.3.8 12.1-3.7 12.9-10 .9-6.3-3.7-12.1-10-13l-91.9-11.7zm-306.3-39.2c-5.8 0-10.7 4.3-11.5 10.1-.8 6.4 3.7 12.2 10 13l91.9 11.8c7 .8 12.2-3.8 13-10.1.8-6.3-3.7-12.1-10-12.9l-91.9-11.8zm-306.3-39.2c-5.7 0-10.7 4.3-11.5 10.1-.8 6.4 3.7 12.2 10 13l91.9 11.7c7.1 1 12.2-3.7 13-10 .8-6.3-3.7-12.1-10-12.9l-91.9-11.8zm-306.2-39.2c-5.8 0-10.8 4.3-11.5 10.1-.9 6.4 3.7 12.2 10 13l91.8 11.8c7.1 1 12.2-3.8 13-10 .8-6.4-3.7-12.2-10-13l-91.9-11.8zm4740.5-87.2c-5.8 0-10.8 4.3-11.5 10.1-3.8 30.5-7.9 61-12.1 91.8-.9 6.3 3.5 12.1 9.9 13 6 1.3 12.2-3.5 13-9.9 4.3-30.8 8.3-61.4 12.2-92 .8-6.3-3.8-12.1-10.1-12.9zm-4976.1-36.3c-5.5 0-10.5 4.1-11.4 9.8l-16.6 103.3 47.7 6.1c7.1.7 12.1-3.8 12.9-10.1.8-6.3-3.6-12.1-10-12.9l-23.9-3.1 12.8-79.6c1-6.3-3.3-12.3-9.6-13.3zm5007.4-270.9c-5.9 0-11 4.6-11.5 10.6-2.4 30.5-5.1 61.2-8 92.2-.6 6.4 4.1 12 10.5 12.6 6.8.7 12-4.1 12.6-10.5 2.8-31 5.5-61.8 8-92.4.5-6.4-4.2-12-10.6-12.5zm-4958.3-33.9c-5.6 0-10.5 4-11.5 9.7l-14.7 91.5c-1 6.3 3.3 12.3 9.6 13.3 6.5.9 12.3-3.3 13.3-9.6l14.7-91.5c1-6.3-3.3-12.2-9.6-13.2zm4977.2-274.4c-6.2 0-11.3 4.9-11.6 11.1-1.3 30.4-2.7 61.2-4.4 92.4-.4 6.4 4.6 11.9 10.9 12.2 7.2.7 11.9-4.6 12.2-10.9 1.7-31.4 3.1-62.3 4.4-92.7.3-6.4-4.6-11.8-11-12.1zm-4928.2-30.4c-5.6 0-10.6 4-11.5 9.7l-14.7 91.5c-1 6.3 3.3 12.2 9.6 13.2 6.7 1.1 12.3-3.3 13.3-9.6l14.7-91.4c1-6.3-3.3-12.3-9.6-13.3zm4935.5-278.4c-6.3 0-11.5 5.1-11.5 11.5-.2 30-.6 60.8-1.1 92.5-.1 6.4 5 11.7 11.4 11.8 6.1 1.1 11.6-5 11.8-11.4.5-31.7.8-62.7 1-92.7.1-6.4-5.1-11.6-11.5-11.7zm-4886.5-26.5c-5.6 0-10.6 4-11.4 9.7l-14.7 91.5c-1.1 6.3 3.2 12.2 9.5 13.2 6.5 1 12.3-3.2 13.3-9.5l14.7-91.5c1-6.3-3.3-12.3-9.6-13.3zm4874.1-281.4c-.9 0-1.8.2-2.8.4-6.2 1.5-10 7.8-8.4 14 6.5 26.3 10 53.5 10.6 80.8l.1 8.3c.1 6.4 5.3 11.5 11.6 11.5h.1c6.4-.1 11.6-5.4 11.5-11.8l-.2-8.5c-.6-28.9-4.3-57.8-11.3-85.9-1.3-5.3-6-8.8-11.2-8.8zm-4825.1-23.5c-5.6 0-10.5 4.1-11.4 9.8l-14.8 91.4c-1 6.3 3.3 12.3 9.6 13.3 6.6 1.2 12.3-3.3 13.3-9.6l14.7-91.4c1-6.4-3.2-12.3-9.6-13.3zm4643.8-215.9c-4 0-7.9 2.1-10 5.8-3.2 5.5-1.3 12.6 4.3 15.8 26 14.8 50.1 32.8 71.8 53.5 4.7 4.4 12 4.2 16.4-.4 4.4-4.6 4.2-12-.4-16.4-23.1-21.9-48.7-41.1-76.4-56.8-1.8-1-3.7-1.5-5.7-1.5zm-298.9-66.6c-5.8 0-10.8 4.3-11.5 10.2-.8 6.3 3.7 12.1 10.1 12.9l91.9 11.2c6.5 1 12.2-3.8 12.9-10.1.8-6.3-3.7-12.1-10-12.9l-92-11.2zm-4295.8-22.3c-5.5 0-10.4 4-11.4 9.6l-14.8 91.6c-1 6.3 3.2 12.2 9.6 13.2 6.4 1.1 12.2-3.3 13.2-9.5l14.8-91.3c1.1-6.3-3.1-12.3-9.4-13.4zm3989.3-15.1c-5.8 0-10.8 4.3-11.5 10.2-.8 6.4 3.8 12.1 10.1 12.9l92 11.2c6.4.8 12.1-3.8 12.8-10.1.8-6.3-3.7-12.1-10.1-12.9l-91.9-11.2zm-306.5-37.4c-5.8 0-10.8 4.3-11.5 10.2-.8 6.4 3.8 12.1 10.1 12.9l91.9 11.2c6.5.7 12.2-3.7 12.9-10 .8-6.4-3.7-12.2-10-13l-92-11.2zm-306.5-37.4c-5.8 0-10.8 4.3-11.5 10.2-.8 6.4 3.8 12.2 10.1 12.9l91.9 11.2c6.6 1 12.2-3.7 12.9-10 .8-6.4-3.7-12.2-10-12.9l-92-11.3zm-306.5-37.3c-5.8 0-10.8 4.3-11.5 10.2-.8 6.3 3.8 12.1 10.1 12.8l91.9 11.2c6.6.9 12.2-3.7 12.9-10 .8-6.4-3.7-12.2-10-12.9l-92-11.2zm-306.5-37.4c-5.8 0-10.8 4.3-11.5 10.1-.8 6.4 3.8 12.2 10.1 12.9l91.9 11.3c6.6.7 12.2-3.8 13-10.1.7-6.4-3.8-12.1-10.1-12.9l-92-11.2zm-306.5-37.4c-5.8 0-10.8 4.3-11.5 10.2-.8 6.3 3.7 12.1 10.1 12.9l91.9 11.2c6.1 1 12.2-3.8 12.9-10.1.8-6.4-3.7-12.2-10.1-12.9l-91.9-11.2zm-306.5-37.4c-5.8 0-10.8 4.3-11.5 10.2-.8 6.3 3.8 12.1 10.1 12.9l91.9 11.2c6.6.9 12.2-3.7 12.9-10.1.8-6.3-3.7-12.1-10-12.9l-92-11.2zm-2012.2-31.7c-3 0-6 1.1-8.3 3.5-21.8 22.8-41.8 47.6-59.2 73.7-3.6 5.3-2.2 12.5 3.1 16 5.3 3.7 12.5 2.2 16.1-3.1 16.7-25.1 35.8-48.8 56.7-70.5 4.4-4.7 4.3-12-.3-16.4-2.3-2.1-5.2-3.2-8.1-3.2zm1705.7-5.7c-5.8 0-10.8 4.3-11.5 10.2-.8 6.3 3.8 12.1 10.1 12.9l91.9 11.2c6.6.7 12.2-3.8 12.9-10.1.8-6.3-3.7-12.1-10-12.9l-92-11.2zm-306.5-37.4c-5.8 0-10.8 4.3-11.5 10.2-.8 6.4 3.8 12.2 10.1 12.9l91.9 11.2c6.6 1.1 12.2-3.7 12.9-10.1.8-6.3-3.7-12.1-10-12.9l-92-11.2zm-306.5-37.4c-5.8 0-10.8 4.4-11.5 10.2-.8 6.4 3.8 12.2 10.1 12.9l91.9 11.2c6.6.9 12.2-3.7 12.9-10 .8-6.4-3.7-12.2-10-12.9l-92-11.3zm-306.5-37.3c-5.8 0-10.8 4.3-11.5 10.1-.8 6.4 3.8 12.2 10.1 12.9l92 11.2c6.1.8 12.1-3.7 12.8-10.1.8-6.3-3.7-12.1-10-12.8l-92-11.2zm-521.3-32.1l-2.5.3c-30.7 6.9-60.9 16.7-90 28.9-5.9 2.5-8.7 9.3-6.2 15.2 2.6 5.9 9.4 8.7 15.2 6.2 27.8-11.7 56.8-21.1 86.1-27.7 6.2-1.4 10.1-7.6 8.7-13.9-1.2-5.3-6-9-11.3-9zm214.8-5.3c-5.8 0-10.8 4.3-11.5 10.1-.8 6.4 3.8 12.2 10.1 12.9l91.9 11.3c6.6 1 12.2-3.8 12.9-10.1.8-6.3-3.7-12.1-10-12.9l-92-11.2-1.4-.1"
          ></path>
          <g>
            <g clipPath="url(#clipPath560)">
              <path
                fill="url(#linearGradient566)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M23452 14733.4l-4.5 132.3c9.8 32.9 35.6 58.7 68.7 68.4 123.9 36.3 432.9 111.8 598.3 18.3l42-149-704.5-70"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath576)">
              <path
                fill="url(#linearGradient582)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M23830.9 14909.7c-28.2-10.8-57.4-14.5-87.5-11.1-36.5 4.2-65.5 32.6-70.1 68.9l-52.4 409.2 208.3 26.6 52.3-408.9c4.7-36.4-16.2-71.5-50.6-84.7"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath592)">
              <path
                fill="url(#linearGradient598)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M25469.3 14991.5l-4.5 132.3c9.8 33 35.5 58.7 68.7 68.4 123.8 36.3 432.8 111.8 598.3 18.3l42-149-704.5-70"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath608)">
              <path
                fill="url(#linearGradient614)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M25848.1 15167.8c-28.2-10.8-57.3-14.5-87.5-11.1-36.4 4.2-65.4 32.6-70.1 68.9l-57.8 452.3 208.2 26.7 57.9-452.1c4.6-36.4-16.3-71.5-50.7-84.7"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath624)">
              <path
                fill="url(#linearGradient630)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M23596.8 15272.4c-39.9 0-76.7 24.3-91 62.4-30.2 81.2-30.8 164.6-23.7 228.1 7.4 66.6 46.7 125.4 105.5 157.9 527.7 291 1511 428.7 1968.9 479.3 25.1 2.8 48.7 5.3 70.5 7.6 9.2.9 18.3 1.4 27.4 1.4 115.4 0 219.3-75.5 251-188 30-106.8 32.7-213.1 29.4-284.8-2.4-51.3-41-93.6-91.9-101.9l-466.5-75.4-1763.8-285.3c-5.3-.9-10.5-1.3-15.8-1.3m599.7 633.1c-1.5 0-3.1-.1-4.6-.3-196.5-30.8-428.9-124.3-549.8-177.3-66.2-28.9-113.3-90.9-123-161.8-12.1-87.6 7.7-174.5 8.5-178.1 3.3-14.3 16-23.9 30-23.9 2.3 0 4.7.2 7.1.8 16.5 3.8 26.9 20.4 23.1 37-.2.8-18.1 79.3-7.5 155.8 6.8 49.7 40 93.3 86.5 113.7 95.2 41.7 337.9 142 534.7 172.7 16.8 2.7 28.3 18.5 25.7 35.3-2.4 15.4-15.6 26.1-30.7 26.1"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath640)">
              <path
                fill="url(#linearGradient646)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M23557.6 15364.1c-14 0-26.7 9.6-30 23.9-.8 3.6-20.6 90.5-8.5 178.1 9.7 70.9 56.8 132.9 123 161.8 120.9 53 353.3 146.5 549.8 177.3 1.5.2 3.1.3 4.6.3 15.1 0 28.3-10.7 30.7-26.1 2.6-16.8-8.9-32.6-25.7-35.3-196.8-30.7-439.5-131-534.7-172.7-46.5-20.4-79.7-64-86.5-113.7-10.6-76.5 7.3-155 7.5-155.8 3.8-16.6-6.6-33.2-23.1-37-2.4-.6-4.8-.8-7.1-.8"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath656)">
              <path
                fill="url(#linearGradient662)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M22406.3 14651.3c722.4 101.9 3848.5 535.4 4771.9 542 79.5.6 150.7-48.5 177.4-123 84.8-236 265.1-786.5 323.9-1347.5 8-76.3-39.6-147.7-112.9-171.5l-2025.4-658.3-737.3-94.3-2267.8 156.6c-79.9 5.5-145.8 64.2-160 142.7-50.4 279.6-157.3 937-135.6 1371.7 4.6 92.4 73.8 168.7 165.8 181.6"
              ></path>
            </g>
          </g>
          <path
            fill="#fff"
            fillOpacity="1"
            fillRule="nonzero"
            stroke="none"
            d="M26825.8 14986.1c-6.1 0-11.2 4.7-11.6 10.8-.4 6.3 4.4 11.9 10.8 12.3 32.1 2.1 63 4 92.6 5.7 6.9 1 11.9-4.5 12.2-10.9.4-6.4-4.5-11.8-10.9-12.2-29.5-1.7-60.3-3.6-92.4-5.7zm-307.9-23.8c-5.9 0-11 4.5-11.5 10.6-.6 6.3 4.1 11.9 10.5 12.5 31.6 2.7 62.4 5.3 92.4 7.7 6.4.4 12-4.2 12.5-10.6.5-6.4-4.3-12-10.7-12.5-29.9-2.4-60.6-5-92.2-7.7zm681.3-1.8c-4.8 0-9.3 3-10.9 7.8l-11.8 33.1c-13.5-.1-27.5-.3-42.1-.6h-.2c-6.3 0-11.5 5-11.6 11.4-.2 6.3 4.9 11.6 11.3 11.8 15.8.3 31 .5 45.5.6 8 0 15-4.6 17.4-11.4l13.3-37.2c2.1-6-1-12.7-7.1-14.8-1.3-.4-2.5-.7-3.8-.7zm-988.8-26.7c-5.9 0-10.9 4.5-11.5 10.5-.6 6.3 4 12 10.4 12.6l92.3 8.9c6.5.9 12-4.1 12.6-10.4.6-6.4-4.1-12-10.5-12.6l-92.1-8.9zm-307.2-31.4c-5.8 0-10.9 4.4-11.5 10.4-.7 6.4 3.9 12.1 10.3 12.7l92.1 9.7c7 .2 12.1-4 12.8-10.3.6-6.4-4-12.1-10.3-12.7l-92.2-9.7zm-306.9-33.5c-5.9 0-10.9 4.4-11.6 10.3-.7 6.3 3.9 12.1 10.3 12.8l92.1 10.2c7 .4 12-3.9 12.7-10.2.7-6.4-3.9-12.1-10.2-12.8l-92.1-10.2zm-306.8-35.1c-5.8 0-10.8 4.3-11.5 10.2-.8 6.4 3.8 12.1 10.1 12.8l92.1 10.7c6.6 1 12.1-3.8 12.8-10.1.8-6.4-3.8-12.1-10.1-12.8l-92.1-10.7zm-306.7-36.5c-5.8 0-10.7 4.3-11.5 10.2-.7 6.3 3.8 12.1 10.2 12.9l91.9 11c6.8 1 12.1-3.8 12.9-10.1.7-6.3-3.8-12.1-10.1-12.9l-92-11zm-306.4-37.6c-5.8 0-10.8 4.3-11.5 10.2-.8 6.3 3.7 12.1 10.1 12.9l91.9 11.4c6.8 1 12.1-3.8 12.9-10.1.8-6.4-3.7-12.1-10.1-12.9l-91.9-11.4zm-306.4-38.5c-5.8 0-10.7 4.3-11.5 10.2-.8 6.3 3.7 12.1 10.1 12.9l91.9 11.6c6.5 1.1 12.2-3.7 12.9-10 .8-6.4-3.7-12.2-10-12.9l-91.9-11.7zm-306.3-39.2c-5.8 0-10.7 4.2-11.5 10.1-.8 6.3 3.7 12.1 10 12.9l91.9 11.9c6.2.8 12.2-3.7 13-10 .8-6.3-3.6-12.1-10-13l-91.9-11.8zm3230.9-15.3c-5 0-9.6 3.2-11.1 8.3-9.2 30.7-18.3 60.3-27.1 88.4-2 6.1 1.4 12.6 7.5 14.5 6.3 2.1 12.6-1.5 14.5-7.5 8.9-28.3 18-57.9 27.3-88.8 1.9-6.1-1.6-12.6-7.8-14.4-1.1-.4-2.2-.5-3.3-.5zm-3537.2-24.8c-5.7 0-10.7 4.2-11.5 10.1-.8 6.3 3.6 12.1 10 13l91.9 12.1c6.4.8 12.2-3.7 13-10 .8-6.4-3.7-12.2-10-13l-91.9-12.1zm-306.2-40.7c-5.7 0-10.7 4.2-11.5 10-.8 6.4 3.6 12.2 10 13.1l91.8 12.3c6.6 1 12.2-3.7 13.1-10 .8-6.3-3.7-12.2-10-13l-91.8-12.3zm-306.1-41.3c-5.7 0-10.7 4.2-11.4 10.1-.9 6.3 3.5 12.1 9.9 13l91.8 12.4c6.5.8 12.2-3.5 13.1-9.9.8-6.3-3.6-12.2-10-13l-91.8-12.5zm-306.1-41.9c-5.7 0-10.6 4.2-11.4 10-.9 6.3 3.5 12.2 9.9 13.1l91.7 12.6c6.2 1.3 12.2-3.5 13.1-9.9.9-6.3-3.6-12.2-9.9-13l-91.8-12.7zm-305.9-42.5c-5.7 0-10.7 4.2-11.5 10-.9 6.3 3.5 12.2 9.9 13.1l91.8 12.8c6 1.2 12.2-3.6 13-9.9.9-6.3-3.5-12.2-9.9-13.1l-91.7-12.8zm4843.4-106.7c-5.2 0-9.9 3.5-11.2 8.8-7.6 30.4-15.3 60.3-23.1 89.6-1.7 6.2 2 12.5 8.2 14.1 6.2 1.5 12.5-2 14.2-8.2 7.7-29.3 15.5-59.4 23.1-89.9 1.6-6.2-2.2-12.5-8.4-14-.9-.3-1.9-.4-2.8-.4zm-4957.7-108.3c-6.3 0-11.4 5-11.6 11.4-.6 25-.9 49.7-.9 73.9l.1 19.1c0 6.3 5.2 11.5 11.5 11.5h.1c6.4 0 11.6-5.3 11.5-11.7v-18.9c0-24 .3-48.5.9-73.4.1-6.4-4.9-11.7-11.3-11.9zm5024.8-193.2c-5.5 0-10.3 3.8-11.4 9.4-6 30.5-12.1 60.7-18.4 90.6-1.3 6.3 2.7 12.4 9 13.7 6.5 1.3 12.4-2.7 13.7-8.9 6.3-30 12.5-60.4 18.4-91 1.2-6.3-2.8-12.4-9.1-13.6zm-5006.2-115.1c-5.9 0-11 4.5-11.5 10.6-2.8 30.9-5.4 61.8-7.7 92.5-.4 6.4 4.4 11.9 10.7 12.4 7.3-.5 12-4.3 12.5-10.7 2.3-30.6 4.8-61.3 7.5-92.2.6-6.3-4.1-12-10.5-12.5zm5054.8-189.8c-5.8 0-10.8 4.3-11.5 10.1-3.8 30.6-7.9 61.2-12.4 91.6-.9 6.4 3.5 12.2 9.8 13.1 6.4 1.3 12.3-3.4 13.2-9.7 4.4-30.7 8.6-61.3 12.4-92.1.8-6.4-3.7-12.1-10.1-12.9zm-5020.7-117.3c-5.7 0-10.7 4.2-11.4 10-4 30.4-7.8 61.1-11.6 92.1-.7 6.4 3.8 12.1 10.1 12.9 6.4.7 12.2-3.8 12.9-10.1 3.7-30.9 7.6-61.6 11.5-91.8.9-6.4-3.6-12.2-9.9-13zm4786.3-16.2c-4.9 0-9.5 3.2-11 8-2.1 6.1 1.3 12.7 7.4 14.6l88.1 28.7c6 2 12.6-1.4 14.5-7.4 2-6.1-1.3-12.6-7.4-14.6l-88.1-28.7c-1.1-.4-2.4-.6-3.5-.6zm-293.7-95.4c-4.9 0-9.4 3.1-11 8-2 6.1 1.3 12.6 7.4 14.6l88.1 28.6c6.1 2.1 12.6-1.4 14.6-7.4 2-6.1-1.4-12.6-7.4-14.6l-88.1-28.6c-1.2-.4-2.4-.6-3.6-.6zm-293.7-95.4c-4.8 0-9.4 3.1-11 8-2 6.1 1.4 12.6 7.4 14.6l88.1 28.6c6.1 1.9 12.7-1.4 14.6-7.4 2-6.1-1.3-12.6-7.4-14.6l-88.1-28.6c-1.2-.4-2.4-.6-3.6-.6zm-293.6-95.5c-4.9 0-9.4 3.2-11 8-2 6.1 1.4 12.6 7.4 14.6l88.1 28.7c6.1 1.9 12.7-1.4 14.6-7.5 2-6-1.3-12.6-7.4-14.5l-88.1-28.7c-1.2-.4-2.4-.6-3.6-.6zm-3860.7-3.3c-5.6 0-10.6 4.1-11.5 9.8-4.6 29.2-9.5 59.9-14.3 91.7-.9 6.3 3.4 12.2 9.8 13.2 6.6.6 12.2-3.5 13.2-9.7 4.8-31.7 9.5-62.3 14.2-91.6 1-6.3-3.3-12.2-9.6-13.2zm3567.1-92.1c-4.9 0-9.5 3.1-11.1 8-1.9 6.1 1.4 12.6 7.5 14.6l88.1 28.6c6.1 1.8 12.6-1.4 14.6-7.4 2-6.1-1.4-12.7-7.5-14.6l-88.1-28.6c-1.1-.4-2.4-.6-3.5-.6zm-293.7-95.4c-4.9 0-9.4 3.1-11 8-2 6 1.4 12.6 7.4 14.6l88.1 28.6c6 1.8 12.6-1.4 14.6-7.5 2-6-1.4-12.6-7.4-14.6l-88.1-28.6c-1.2-.3-2.4-.5-3.6-.5zm-3147.1-34.7l-.8.1-98.7 6.8-1.6 8.8c-1.1 6.3 2.7 13.7 9 14.8 3.5.8 6.7.1 9.2-1.6l83.7-5.7c6.4-.5 11.2-6 10.7-12.4-.4-6.1-5.5-10.8-11.5-10.8zm308-21.3l-.8.1-92.4 6.3c-6.4.5-11.2 6-10.7 12.4.4 6.3 6.2 10.6 12.3 10.8l92.4-6.4c6.4-.4 11.2-6 10.8-12.3-.5-6.2-5.5-10.9-11.6-10.9zm308.1-21.2h-.8l-92.4 6.4c-6.4.4-11.2 5.9-10.8 12.3.5 6.4 6.3 10.5 12.3 10.8l92.4-6.4c6.4-.5 11.2-6 10.8-12.3-.4-6.2-5.5-10.8-11.5-10.8zm2237.1-17.2c-5.7 0-10.7 4.3-11.5 10.1-.8 6.4 3.7 12.2 10.1 13l5.9.7 80.3 26.3c6 1.9 12.6-1.4 14.6-7.4 1.9-6.1-1.4-12.6-7.5-14.6l-90.4-28zm-1929.1-4.1h-.8l-92.4 6.4c-6.4.5-11.2 6-10.8 12.4.5 6.3 6.5 10.4 12.4 10.7l92.4-6.4c6.4-.4 11.2-5.9 10.8-12.3-.5-6.1-5.5-10.8-11.6-10.8zm308-21.3l-.7.1-92.5 6.3c-6.3.5-11.1 6-10.7 12.4.4 6.4 6.5 10.4 12.3 10.8l92.4-6.4c6.4-.5 11.2-6 10.8-12.4-.4-6.1-5.5-10.8-11.6-10.8zm1314.8-13.8c-5.7 0-10.7 4.3-11.4 10.1-.9 6.4 3.6 12.1 10 13l91.8 11.7c7.3.9 12.2-3.7 13-10 .8-6.3-3.7-12.1-10-13l-91.9-11.7zm-1006.7-7.4h-.8l-92.4 6.3c-6.4.5-11.2 6-10.8 12.4.4 6.4 6.6 10.3 12.3 10.8l92.4-6.4c6.4-.4 11.2-6 10.8-12.3-.4-6.2-5.5-10.8-11.5-10.8zm308-21.3h-.8l-92.4 6.4c-6.4.4-11.2 5.9-10.8 12.3.5 6.4 6 10.3 12.4 10.8l92.4-6.4c6.4-.5 11.2-6 10.7-12.3-.4-6.2-5.4-10.8-11.5-10.8zm392.4-10.5c-5.7 0-10.7 4.3-11.4 10.1-.9 6.3 3.6 12.1 10 13l91.8 11.7c7.4 1 12.2-3.7 13-10 .8-6.3-3.7-12.1-10-13l-91.9-11.7zm-84.4-10.8h-.7l-92.5 6.4c-6.3.5-11.2 6-10.7 12.4.4 6.3 6 10.2 12.3 10.7l92.4-6.4c6.4-.4 11.2-5.9 10.8-12.3-.4-6.1-5.5-10.8-11.6-10.8"
          ></path>
          <g>
            <g clipPath="url(#clipPath674)">
              <path
                fill="url(#linearGradient680)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M25511.4 12574.6l-645.9-82.6c-84.6-10.9-164 43-184.7 125.4l-154.2 611.9c-24.5 97.5 42 194.6 142.2 207.4l775.9 99.3c98.2 12.5 185.9-61.4 189.7-159.8l24.1-628.6c3.4-86.8-60.5-161.9-147.1-173"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath690)">
              <path
                fill="url(#linearGradient696)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M25417.4 12678.8l-491.7-63c-64.4-8.2-124.8 32.8-140.6 95.5l-117.3 465.8c-18.7 74.2 31.9 148 108.2 157.8l590.6 75.6c74.7 9.5 141.5-46.7 144.3-121.6l18.4-478.5c2.5-66.1-46-123.2-111.9-131.6"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath706)">
              <path
                fill="url(#linearGradient712)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M25033.2 17631.9c152.3-629.6 156.4-1245.5 133.2-1469.7-8.8-84.6-76.7-150.6-161.5-156.5-96.3-6.7-227.4-15.6-344.5-22.3-128.8-7.5-271.7 73.9-367.3 141.9-48.8 34.8-111.9-19.3-84.7-72.6 47-91.9 128.5-164.2 209.5-225.7 48.7-37 210.5-102.8 199.2-175.6-3.6-23-17.4-43-32.3-60.9-89.9-107.9-226-165.5-360.3-206.7-16.8-5.2-34.6-10.7-46.5-23.8-3.3-86.8 263.8-183.3 332.8-206.2 103.3-34.2 212.8-48.8 321.3-37.3 268.8 28.3 517 213.8 661.8 437.5 387 598 587.1 1320.2 660.3 1872.5-360.1 359.9-903.6 268.7-1121 205.4"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath722)">
              <path
                fill="url(#linearGradient728)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M26154.2 17369.6c287.1 2169-1384.4 3836.8-1384.4 3836.8l-994.5-1159.4c755-941.1 1113.9-1803.5 1277.9-2480.8 217.4 63.3 740.9 163.4 1101-196.6"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath738)">
              <path
                fill="url(#linearGradient744)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M25029.5 17576.8c-27.8 0-53 18.9-59.9 47.1-202 835-628 1661.6-1266 2456.8-21.3 26.5-17 65.3 9.5 86.6 26.5 21.2 65.3 17 86.6-9.5 649.4-809.5 1083.3-1652.3 1289.7-2504.9 8-33.1-12.3-66.3-45.4-74.3-4.8-1.2-9.7-1.8-14.5-1.8"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath754)">
              <path
                fill="url(#linearGradient760)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M11560.6 4718.5c.2 10.6-.5 21.3-3.2 32.1-160 634.1-953.8 1029-953.8 1029L10289 5755c-180.9-558.9-157.6-901.7-128.6-1054.4.8-4.3 2.1-8.3 3.3-12.5 259.5-23.1 793.6-38.3 1396.9 30.4"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath770)">
              <path
                fill="url(#linearGradient776)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M10163.7 4688.1c14-50.9 51.6-90.6 99.8-100.8 369.1-77.6 955.8-15.1 1202.2 17.1 54.3 7.1 94 57.3 94.9 114.1-603.3-68.7-1137.4-53.5-1396.9-30.4"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath786)">
              <path
                fill="url(#linearGradient792)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M10162.5 6223.5l133.3-641.4c9.7-47 45.8-82.1 89.6-86.3 53.5-5 129.7-7.9 206.4 3.3 68.7 10.1 116.6 80 104.4 154.9l-92.6 569.5h-441.1"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath802)">
              <path
                fill="url(#linearGradient808)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M12923 4696.3c-347.4 9.7-527.1 50.6-620 88.6-.2-34.6 0-69.7 1.1-106.2 1.2-38.9 30-69.9 65.4-69.7l1907.6 12.3c60.9.4 96.5 71 70.1 126.8-250.1-20.6-887.1-66.9-1424.2-51.8"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath818)">
              <path
                fill="url(#linearGradient824)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M14347.2 4748.1c-2.3 4.9-4.3 9.8-7.6 14.4-168.4 235.4-597.5 704.1-1445.4 907.4l-406.7 12.9s-181.1-314.8-184.5-897.9c92.9-38 272.6-78.9 620-88.6 537.1-15.1 1174.1 31.2 1424.2 51.8"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath834)">
              <path
                fill="url(#linearGradient840)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M12394 6280.3c6.4-30 91-486.4 123.8-663.3 7.8-42.1 40.6-72.9 79.5-75.1 69.7-3.9 182-4.4 278.6 21.9 52.1 14.1 87.1 67.2 83.4 126.2l-45.5 721.9-519.8-131.6"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath850)">
              <path
                fill="url(#linearGradient856)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M12085.8 14706.7s559.5-3844.7 963.3-8419.9c7.5-85.2-60.4-159.3-144.1-176.9-123.4-26-304.7-56.9-454.8-52.7-80.1 2.3-147.1 61.7-160.6 140.7-137.5 806.7-1119.1 5136-1376.7 6088.8 0 0-295.9-4047.4-201.3-6147.2 2.3-52.2-35.9-97.5-87.8-103.5-78.8-9.1-204.8-16-365.1 1-60.9 6.5-110 52.5-118.7 113.1-98 682.7-661.9 4746.4-637.92 7673.7 1.35 165.1 193.68 1521.5 193.68 1521.5l2390.04-638.6"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath866)">
              <path
                fill="url(#linearGradient872)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M9611.67 14485.1c-57.52 20.4-97.63 72.6-103.89 133.3-74.4 721.9-434.66 5197.7 1839.72 7038.8 0 0 130.4 341.3 1202.5-497.6 1072.1-838.8 498.1-1718.1 241.4-2930.8-310.6-1467.5-855.5-2667.1-614.4-3570.2 16.6-62.3-16.1-127.7-76.7-150-832.8-307-1662.3-317.1-2488.63-23.5"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath882)">
              <path
                fill="url(#linearGradient888)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M12234.7 22998.3c-.7-63.7-908.9-1353.7-908.9-1353.7s163-321 941.2-581.7l671.8 1381.2-704.1 554.2"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath898)">
              <path
                fill="url(#linearGradient904)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M12949.7 23737.4s323.2-742.3 344.9-1131.9c21.7-389.6 105.6-642.4-344.9-720.9s-830 146-1035.6 534.1c0 0-322.1 598-249.9 842.9 72.3 244.9 1285.5 475.8 1285.5 475.8"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath914)">
              <path
                fill="url(#linearGradient920)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M12068 22697.7l25.7 11.3c32.6 14.4 46.6 53.3 30.2 85-63.5 122.7-187.4 404-27.4 469.6 206.2 84.6 1022.9 251.1 1199.1 540.9 169.4 278.5 19.3 638.1-206.2 740.3-15.1 6.9-32.9 1.4-40.6-13.2l-18.8-35.6c-12.9-24.3-48.8-20.6-56.5 5.8-7.3 25.4-41.1 30.3-55.1 7.9-54.2-86.7-200.4-227.2-591.5-299.4-555.7-102.6-923.2-327.5-932.3-711.6-.6-24.4-26.6-37.9-47.4-25.2-41 25-106.7 36.7-194.5-37.1-152.6-128.3-90.2-461.2 244.5-735.1 15.8-13 15.7-37.8-1.5-49-60.7-39.5-151.1-133.5 83.2-258.7 242.4-129.6 423.4-118.9 493-107.4 17.4 2.8 28.5 19.6 24.8 36.8l-74.4 337.5c-4.2 19.1 10.3 37.2 29.9 37.2h115.8"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath930)">
              <path
                fill="url(#linearGradient936)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M12082 22626.5s-123.2 474.2-335.8 341.2c-212.6-132.9 110.3-531.3 281.2-549l54.6 207.8"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath946)">
              <path
                fill="url(#linearGradient952)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M12894.9 20770.4l62.6-1681.7c177.9-61.2 347.2-108.8 508.4-144.4 100.9 324.7 323 723.2 504.8 1019.5-668.1 236.2-1075.8 806.6-1075.8 806.6"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath962)">
              <path
                fill="url(#linearGradient968)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M16230.6 20799c-916.5-989.6-1658.3-1047.8-2259.9-835.2-181.8-296.3-403.9-694.8-504.8-1019.5 2447.5-539.6 3023.9 1710.4 3023.9 1710.4l-259.2 144.3"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath978)">
              <path
                fill="url(#linearGradient984)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M16416.4 20904.1s105.6 113.3 301 77.7c195.4-35.6 369.3-103.5 491.1 0 121.7 103.5 164.5-35.4 164.5-35.4l-364.5-277.1-592.1 234.8"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath994)">
              <path
                fill="url(#linearGradient1000)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M16198.4 20710.3s72.3 302.4 290.3 261c218-41.5 712.9-310.6 840.5-261 127.5 49.5 290.6 168.2 374.3 126.3l-147.4-183.3s378.9 218.6 444.1 84.3l-630.4-354.8s-922.4 92.4-1171.4 327.5"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath1010)">
              <path
                fill="url(#linearGradient1016)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M11877.5 18569.4s1723.1-1443.1 3583.7-813.4c115.4 39 241.6 30.5 349.3-26.3l534.9-282.6c224.5-118.5 502.6-40.7 632.9 177.2 74.3 124.4 137.7 266.3 150.3 402.4l-1046.7 423.7 77.2 128.3s-511 43.3-644.8-322.9c0 0-973.3-404.9-2614.9 1400.7 0 0-744.9-633.4-1021.9-1087.1"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath1026)">
              <path
                fill="url(#linearGradient1032)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M11784.8 18584.3c-5.7 0-11.5 1.6-16.5 5.1-725.5 490.2-1066.8 1281.3-1070.2 1289.3-6.3 15 .7 32.3 15.7 38.7 15 6.3 32.2-.6 38.6-15.7 3.3-7.7 338.3-783.3 1048.9-1263.5 13.5-9.1 17.1-27.4 7.9-40.9-5.7-8.4-15-13-24.4-13"
              ></path>
            </g>
          </g>
          <g>
            <g clipPath="url(#clipPath1042)">
              <path
                fill="url(#linearGradient1048)"
                fillOpacity="1"
                fillRule="nonzero"
                stroke="none"
                d="M12865.4 19680.9c-9.6 0-19.1 4.8-24.8 13.6-2.2 3.4-223.8 348.4-646 1104.3-129.8 232.5-300.4 379.6-507.1 437.5-342.2 95.6-672.1-87.9-675.3-89.7-14.2-7.8-32.2-3.1-40.2 11.1-8.1 14.1-3.1 32.1 11 40.2 14.3 8 353.5 197.8 719.9 95.3 222.6-62.1 405.4-218.7 543.2-465.6 421.1-754 641.9-1097.8 644.1-1101.2 8.8-13.7 4.9-31.9-8.8-40.8-5-3.2-10.5-4.7-16-4.7"
              ></path>
            </g>
          </g>
        </g>
      </g>
    </svg>
  );
}

export default Icon;
