import React from "react";

function Icon() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="400"
      height="200"
      version="1.1"
      viewBox="0 0 400 400"
    >
      <g fillRule="evenodd" stroke="none">
        <path
          fill="#284d73"
          d="M0 158.003v32.014h11.33l.101-2.451.101-2.452 1.696 1.404c16.47 13.627 39.507-4.752 33.645-26.843-4.128-15.552-21.502-22.09-33.258-12.514-1.046.851-1.981 1.548-2.078 1.548-.098 0-.177-5.112-.177-11.36V125.99H0v32.013m135.284-20.631v11.383l-1.979-1.548c-12.96-10.137-30.706-2.397-33.694 14.693-3.734 21.368 17.344 37.224 33.349 25.087l2.324-1.761v4.791h11.36V125.99h-11.36v11.382m13.425 20.631v32.014h11.36v-10.499c0-5.774.118-10.499.263-10.499.145 0 4.599 4.721 9.897 10.492l9.633 10.492 7.173.007 7.172.007-6.477-6.971a8273.108 8273.108 0 00-11.045-11.86c-2.512-2.69-4.568-5.025-4.568-5.189 0-.164 4.337-5.125 9.639-11.024 5.301-5.9 9.638-10.807 9.638-10.905 0-.098-3.17-.178-7.044-.178h-7.044l-8.532 9.524-8.533 9.523-.089-18.473-.089-18.474h-11.354v32.013m109.467 0v32.014h11.015v-2.409c0-2.824-.064-2.79 2.004-1.07 13.542 11.263 33.272.909 34.366-18.035 1.172-20.287-18.575-32.956-33.669-21.601-1.321.994-2.469 1.807-2.552 1.807-.082 0-.149-5.112-.149-11.36V125.99h-11.015v32.013m99.483 0v32.014h11.36l.011-11.962c.011-13.158.232-15.928 1.5-18.793 3.555-8.038 13.679-8.117 15.981-.126.411 1.425.547 4.778.666 16.337l.149 14.544h11.348l-.141-17.298c-.151-18.533-.172-18.777-2.005-22.446-3.039-6.086-11.695-9.044-19.146-6.542-2.415.81-6.945 3.388-7.482 4.256-.749 1.212-.881-.414-.881-10.81V125.99h-11.36v32.013m-140.704-20.458c-19.512 4.276-28.947 27.516-17.896 44.081 15.642 23.446 51.788 13.289 52.826-14.845.698-18.914-16.467-33.281-34.93-29.236m10.841 5.513c18.256 3.771 24.86 26.154 11.583 39.26-12.125 11.969-32.731 7-38.156-9.202-5.624-16.794 9.263-33.634 26.573-30.058m-162.047.347c-10.087 2.68-16.741 13.074-16.066 25.098 1.041 18.556 19.944 28.922 33.708 18.484l2.323-1.761v4.791h11.36V143.89h-11.36v4.902l-1.463-1.193c-5.266-4.293-12.206-5.866-18.502-4.194m258.988.134c-17.091 4.481-23.135 27.495-10.623 40.456 9.409 9.748 27.852 9.522 36.643-.45 2.269-2.574 2.416-2.335-2.948-4.802l-4.679-2.152-1.255.988c-7.652 6.026-19.369 3.833-22.37-4.187-1.391-3.718-3.415-3.34 17.895-3.34h18.639l-.232-3.598c-1.093-16.899-14.972-27.135-31.07-22.915m13.031 10.114c2.973 1.431 6.466 5.262 6.466 7.091 0 .241-4.099.358-12.573.358h-12.574l.574-1.119c3.448-6.726 11.464-9.528 18.107-6.33m-308.86.76c5.155 2.314 8.222 8.607 7.228 14.831-2.651 16.596-24.977 14.545-24.94-2.29.024-10.487 8.661-16.603 17.712-12.541m47.44-.871c6.843 1.578 10.942 8.157 9.771 15.684-2.297 14.778-21.82 15.294-24.846.656-2.033-9.828 5.923-18.451 15.075-16.34m49.57 0c6.843 1.578 10.941 8.157 9.771 15.684-2.297 14.778-21.82 15.294-24.847.656-2.036-9.846 5.907-18.455 15.076-16.34m159.131.182c13.438 3.878 11.597 25.415-2.296 26.867-15.298 1.599-19.501-22.877-4.612-26.856 2.498-.667 4.623-.671 6.908-.011m-178.973 48.99c-.679.431-.335 1.572.51 1.693.863.124 1.352-.834.779-1.525-.454-.546-.651-.572-1.289-.168m133.98.212c-.302.787.121 1.549.86 1.549.814 0 1.232-.951.7-1.593-.518-.624-1.313-.601-1.56.044m19.204-.212c-.679.431-.335 1.572.51 1.693.864.124 1.352-.834.779-1.525-.454-.546-.65-.572-1.289-.168m-231.377 6.925c0 6.655.023 6.884.688 6.884.666 0 .689-.229.689-6.884 0-6.656-.023-6.885-.689-6.885-.665 0-.688.229-.688 6.885m7.917 0c0 6.655.023 6.884.689 6.884.665 0 .688-.229.688-6.884 0-6.656-.023-6.885-.688-6.885-.666 0-.689.229-.689 6.885m17.669-6.061c-1.886 1.623-1.438 3.274 1.68 6.182 3.093 2.885 3.432 3.635 2.203 4.864-1.215 1.215-2.662 1.152-3.769-.164-.817-.971-1.948-1.135-1.948-.283 0 2.358 5.066 3.422 6.916 1.453 2.017-2.147 1.293-3.735-3.691-8.097-2.288-2.003.023-4.565 2.419-2.681 1.757 1.383 2.584.235.87-1.207-1.406-1.183-3.35-1.211-4.68-.067m128.287 1.781v2.605l-.983-.7c-3.427-2.44-7.967.107-7.967 4.47 0 4.072 4.717 6.521 7.953 4.129.989-.732.997-.732.997-.039 0 .47.226.699.688.699.666 0 .689-.229.689-6.884 0-6.656-.023-6.885-.689-6.885-.628 0-.688.229-.688 2.605m49.569-.712c0 1.79-.047 1.893-.86 1.893-1.086 0-1.16.943-.086 1.095.751.107.777.243.871 4.499.077 3.547.191 4.389.592 4.389.4 0 .514-.842.592-4.389l.096-4.389.947-.109c1.323-.152 1.249-1.096-.086-1.096-1.023 0-1.033-.019-1.033-1.893 0-1.453-.12-1.893-.516-1.893-.397 0-.517.44-.517 1.893M0 209.811c0 6.483.024 6.712.688 6.712.641 0 .689-.229.689-3.27v-3.27h2.754c2.524 0 2.754-.058 2.754-.689 0-.631-.23-.688-2.754-.688H1.377v-4.102l2.664-.101c2.216-.083 2.683-.201 2.779-.702.104-.542-.236-.603-3.352-.603H0v6.713m160.468-6.286c-.219.22-.399.506-.399.636s-1.143 2.627-2.539 5.548c-3.145 6.582-3.225 6.814-2.336 6.814.499 0 .957-.593 1.726-2.237l1.047-2.238h5.741l1.103 2.238c.827 1.677 1.282 2.237 1.815 2.237.392 0 .652-.116.578-.258a66.75 66.75 0 01-.759-1.635c-.344-.757-1.609-3.45-2.812-5.983-1.203-2.533-2.187-4.731-2.187-4.885 0-.505-.571-.644-.978-.237m152.316 1.201c-1.133 2.235-5.383 11.42-5.383 11.633 0 1.148 1.525-.178 2.385-2.073l1.014-2.238h5.748l1.103 2.238c.811 1.645 1.286 2.237 1.795 2.237.876 0 1.14.764-2.262-6.554-3.547-7.629-3.325-7.365-4.4-5.243m-243.716 1.809c-4.978 1.568-4.252 9.377.95 10.222 2.406.39 6.24-1.911 5.094-3.056-.274-.275-.716-.081-1.612.706-2.301 2.02-5.573 1.205-6.356-1.584l-.315-1.119h8.902l-.001-.947c-.004-2.909-3.598-5.187-6.662-4.222m15.175.35c-1.047.824-1.283.855-1.283.172 0-.287-.306-.517-.688-.517-.657 0-.689.23-.689 4.992 0 4.659.044 4.991.649 4.991.582 0 .662-.349.786-3.433.152-3.782.785-5.231 2.387-5.465.978-.144 1.475-.786.894-1.156-.654-.416-1.118-.322-2.056.416m33.13-.365c-4.198 1.276-5.305 6.555-1.917 9.14 2.138 1.631 5.732 1.471 7.423-.329 1.103-1.173.195-1.528-1.408-.551-4.386 2.674-9.108-2.614-5.383-6.028 1.637-1.501 3.641-1.625 5.529-.343.976.662 1.307.744 1.596.396 1.067-1.285-3.391-3.029-5.84-2.285m15.329.144c-6.271 2.9-2.296 12.438 4.056 9.731 1.352-.575 2.813-2.095 2.5-2.6-.289-.469-1.22-.485-1.22-.021 0 .636-2.216 1.714-3.523 1.715-1.516.002-3.21-1.35-3.559-2.838l-.222-.947h4.513c4.353 0 4.512-.025 4.512-.723 0-3.168-4.108-5.681-7.057-4.317m30.056 3.843c-.111.11-1.071.154-2.135.097l-1.933-.105 1.07-2.237 1.07-2.238 1.064 2.141c.586 1.177.975 2.231.864 2.342m44.299-3.825c-2.921 1.298-3.984 4.362-2.546 7.334 1.69 3.49 6.667 3.783 8.833.521.815-1.228-.365-1.431-1.391-.24-1.871 2.176-5.986 1.156-6.642-1.646l-.222-.947h9.115l-.196-1.208c-.517-3.182-4.033-5.111-6.951-3.814m15.404.199c-.913.556-1.118.588-1.118.171 0-.282-.31-.512-.689-.512-.657 0-.688.23-.688 4.992s.031 4.991.688 4.991c.637 0 .689-.229.689-3.047 0-4.379.695-5.903 2.694-5.903.835 0 1.239-.903.526-1.176-.76-.292-.871-.266-2.102.484m26.05.321c-1.644 1.643-1.041 3.32 1.757 4.893.748.42 1.442 1.025 1.543 1.343.501 1.577-1.313 2.573-2.963 1.626-.881-.506-1.688-.288-1.688.456 0 .576 2.522 1.403 3.638 1.194 3.289-.617 2.998-3.952-.537-6.172-1.311-.824-1.669-1.689-1.022-2.469.495-.596 1.758-.656 2.304-.11.421.421 1.469.178 1.469-.34 0-.387-2.126-1.427-2.918-1.427-.318 0-1.03.453-1.583 1.006m21.84-.51c-.592.258-1.182.639-1.311.847-.378.612-.882.434-.882-.31 0-.383-.229-.689-.516-.689-.435 0-.516.785-.516 4.992 0 3.999.094 4.991.472 4.991.352 0 .534-.885.72-3.5.293-4.135 1.12-5.45 3.428-5.45 2.212 0 2.609.784 2.609 5.164 0 3.557.041 3.786.688 3.786.778 0 1.05-6.232.353-8.067-.694-1.825-3.028-2.642-5.045-1.764m14.476.181c-3.556 1.807-3.823 6.653-.49 8.9 1.545 1.041 4.295.924 5.883-.251l1.043-.771-.231 1.317c-.569 3.24-6.167 4.506-7.266 1.642-.239-.624-1.494-.66-1.494-.042 0 1.352 2.529 2.642 5.181 2.642 2.014 0 2.201-.072 3.465-1.337l1.337-1.336v-5.548c0-4.703-.079-5.549-.517-5.549-.286 0-.516.306-.516.689 0 .862-.141.859-1.338-.026-1.433-1.06-3.372-1.186-5.057-.33m30.159 1.702l.992 2.096h-4.46l.708-1.388c.39-.764.862-1.793 1.05-2.286.415-1.093.471-1.042 1.71 1.578m13.506-1.703c-3.971 1.803-3.811 7.624.256 9.309 1.294.536 3.943.271 4.77-.478.85-.769 1.078-.7 1.078.327 0 3.027-4.446 4.38-6.844 2.082-1.811-1.736-2.828-.986-1.06.781 2.495 2.495 7.531 1.786 8.812-1.24.836-1.977.656-11.113-.22-11.113-.442 0-.688.23-.688.642 0 .602-.101.591-1.608-.172-1.935-.98-2.596-1-4.496-.138m16.603.021c-5.284 2.672-2.839 10.654 3.022 9.868 1.495-.201 2.799-1.004 3.609-2.224.868-1.308-.376-1.386-1.823-.116-2.014 1.768-4.829 1.35-5.973-.887-.899-1.758-.736-1.83 4.134-1.83h4.518l-.222-1.106c-.702-3.511-4.161-5.275-7.265-3.705m17.167-.261c-.403.233-1.061.624-1.463.867-.65.394-.73.366-.73-.258 0-.471-.226-.701-.689-.701-.656 0-.688.23-.688 4.992 0 4.68.041 4.991.656 4.991.594 0 .668-.328.775-3.471.136-4.006 1.081-5.479 3.512-5.479 2.004 0 2.44.881 2.574 5.199.109 3.507.163 3.751.818 3.751.962 0 .795-7.148-.202-8.666-.952-1.449-3.157-2.041-4.563-1.225m15.191-.056c-5.151 1.582-4.693 9.132.614 10.128 2.576.483 6.378-1.251 5.38-2.454-.328-.395-.566-.33-1.413.383-2.211 1.86-6.016.697-6.769-2.068-.99-3.635 3.313-6.403 6.534-4.202 1.606 1.097 2.584.713 1.398-.549-1.291-1.374-3.648-1.882-5.744-1.238m-364.716 3.418c0 2.253.175 3.872.504 4.659 1.164 2.787 6.155 2.914 7.562.193.892-1.724.774-8.306-.149-8.306-.645 0-.688.23-.688 3.631 0 4.254-.586 5.32-2.926 5.32-2.341 0-2.926-1.066-2.926-5.32 0-3.401-.044-3.631-.689-3.631-.643 0-.688.23-.688 3.454m78.95-1.671c2.704 6.025 3.806 8.197 4.036 7.956.284-.297 4.449-9.234 4.449-9.546 0-1.416-1.479.29-2.868 3.306-.885 1.924-1.709 3.399-1.829 3.278-.121-.12-.864-1.656-1.651-3.412-1.116-2.491-1.599-3.217-2.195-3.303l-.764-.111.822 1.832m14.337 3.209c0 4.762.032 4.991.689 4.991.656 0 .688-.229.688-4.991s-.032-4.992-.688-4.992c-.657 0-.689.23-.689 4.992m85.23-.102c2.544 5.577 2.347 5.246 2.787 4.671.353-.461 4.238-9.057 4.238-9.376 0-1.427-1.469.3-2.771 3.258-.833 1.893-1.608 3.442-1.722 3.442-.114 0-.92-1.549-1.792-3.442-1.241-2.696-1.735-3.443-2.278-3.443-.622 0-.466.498 1.538 4.89m49.021.102c0 4.762.032 4.991.689 4.991.657 0 .688-.229.688-4.991s-.031-4.992-.688-4.992c-.657 0-.689.23-.689 4.992m18.933 0c0 4.762.032 4.991.689 4.991.657 0 .688-.229.688-4.991s-.031-4.992-.688-4.992c-.657 0-.689.23-.689 4.992m130.121-4.848c0 .08.852 2.042 1.893 4.362 2.179 4.855 2.172 4.809 1.037 7.25-.74 1.593-.782 1.858-.307 1.96.79.171.797.158 3.869-6.912 3.165-7.286 3.011-6.804 2.169-6.804-.477 0-1.004.875-2.13 3.529-.823 1.94-1.593 3.646-1.711 3.79-.118.144-.956-1.444-1.862-3.528-1.269-2.922-1.797-3.791-2.302-3.791-.361 0-.656.065-.656.144M72.64 208.093c.974.504 1.715 1.459 1.715 2.211 0 .237-1.286.367-3.615.367-3.855 0-4.166-.164-3.004-1.59 1.262-1.549 3.103-1.919 4.904-.988m64.025.053c.805.476 1.717 1.734 1.717 2.369 0 .086-1.626.156-3.614.156-3.876 0-4.133-.14-3.062-1.669 1.021-1.457 3.28-1.847 4.959-.856m43.677.31c1.945 1.636 2.08 4.25.311 6.019-2.365 2.365-6.471.549-6.471-2.862 0-3.415 3.638-5.279 6.16-3.157m31.224.288c1.788 1.787 1.61 1.927-2.444 1.927-3.876 0-4.132-.14-3.061-1.669 1.265-1.806 3.837-1.927 5.505-.258m77.635-.632c2.769 1.432 2.497 5.667-.439 6.842-3.589 1.436-6.698-1.918-4.937-5.324.978-1.89 3.357-2.562 5.376-1.518m44.224.632c3.118 3.118-.284 8.11-4.218 6.189-1.816-.888-2.74-2.752-2.189-4.421.989-2.995 4.274-3.902 6.407-1.768m16.51-.118c1.745 1.639 1.227 2.045-2.603 2.045-3.939 0-4.438-.478-2.339-2.244 1.368-1.151 3.601-1.061 4.942.199M0 250.775v23.235h400V227.539H0v23.236m388.574-10.793l.105.912-3.108.121c-2.627.102-3.223.236-3.85.862-1.488 1.49-3.269.222-1.983-1.412 1.501-1.908 8.626-2.298 8.836-.483M69.88 242.488c0 1.108-.112 1.222-1.808 1.863-.994.375-2.246.852-2.783 1.06l-.977.378 2.933 3.115c3.197 3.397 3.69 4.466 2.825 6.138-.884 1.709-1.197 1.757-11.514 1.757h-9.648l-.367 1.361c-.793 2.947-3.41 4.623-6.906 4.425l-1.876-.107v-2.409l2.527-.172c3.915-.267 5.623-2.84 2.109-3.177-5.307-.51-5.001-8.871.325-8.871 2.719 0 4.161 1.726 4.161 4.98v1.56h9.305c11.257 0 10.895.235 6.613-4.29-4.768-5.038-4.745-5.566.336-7.42 4.576-1.67 4.745-1.677 4.745-.191m108.357.044c1.506 1.055.819 3.251-1.017 3.251-1.863 0-2.516-2.577-.856-3.38.999-.483.998-.483 1.873.129m111.532 0c1.441 1.01.652 3.251-1.145 3.251-1.799 0-2.385-2.774-.728-3.443 1.019-.411 1.01-.412 1.873.192m-201.989 5.42c0 6.98-.535 6.438 6.351 6.432 6.478-.006 6.316.058 6.452-2.585l.105-2.057h2.41v2.471c0 1.976-.145 2.665-.725 3.442l-.725.972-7.126.093-7.125.093-1.014-1.014-1.013-1.013v-12.445h2.41v5.611m116.429.327l.094 5.938 6.102.094 6.101.094.159-.783c.087-.43.241-1.398.343-2.151.751-5.538 6.782-4.941 7.928.785l.393 1.961 5.322.098c7.079.131 6.814.224 6.94-2.424l.103-2.149h2.409l.094 2.065c.108 2.395-.632 4.219-1.987 4.896-1.325.662-12.115.601-13.424-.076-.919-.475-1.094-.458-2.232.213-1.355.8-2.945.71-3.977-.224-.511-.462-.682-.462-1.572.002-.773.403-2.28.521-6.678.522-8.754.003-8.899-.143-8.931-8.976-.021-5.902-.042-5.823 1.579-5.823h1.14l.094 5.938m67.047-.327c0 7.05-.716 6.443 7.556 6.413 8.373-.03 8.42-.045 6.412-2.016-1.655-1.624-1.644-2.289.069-4.242.668-.762 4.701-.837 6.419-.12 2.067.864 2.37 3.554.582 5.164-1.246 1.123-.849 1.263 3.317 1.163l4.045-.097.172-2.238.172-2.237h2.41l.172 2.237.172 2.238h3.442l.094-5.938.095-5.938h2.721l.094 5.938.094 5.938 2.009.104c2.624.136 2.983-.192 2.983-2.728v-2.023h2.409v2.023c0 2.592.324 2.857 3.326 2.726l2.354-.102.172-2.238.172-2.237h2.41l-.017 2.677c-.027 4.038-.67 4.572-5.412 4.493a216.005 216.005 0 00-4.554-.042c-.568.01-2.194.006-3.614-.008a153.3 153.3 0 00-3.615-.002c-.568.014-2.078.014-3.356 0-2.575-.028-2.808-.027-8.705.054-3.429.047-4.395-.057-5.606-.604-1.437-.648-1.485-.648-2.741-.008-1.086.554-2.235.671-7.632.775-11.381.219-11.03.485-11.03-8.352v-6.384h2.409v5.611m103.271 1.618v7.229h-2.41v-7c0-7.541-.016-7.458 1.434-7.458h.976v7.229m4.878-6.66c.732.663.81 1.508.199 2.166-.329.354-.33.408-.007.225 1.253-.706 2.621 1.466 1.62 2.572-.796.879-1.709.84-2.368-.101-.295-.421-.536-.572-.536-.337 0 .236-.367.596-.817.801-1.835.836-3.183-1.437-1.536-2.591.409-.287.846-.459.97-.382.124.077.159-.318.077-.878-.264-1.793 1.112-2.639 2.398-1.475m6.137 6.66v7.229h-2.409v-14.458h2.409v7.229m-148.153-2.963c-.262 1.047-1.667 1.547-2.471.879-.852-.707-.505-2.489.538-2.759 1.207-.311 2.233.686 1.933 1.88m3.575-1.512c1.545 1.545-.503 3.651-2.125 2.184-.846-.767-.793-1.686.136-2.337.985-.69 1.16-.676 1.989.153m21.767.147c.497.725.256 1.898-.468 2.286-1.508.807-3.051-.877-2.103-2.296.548-.819 2.007-.814 2.571.01m3.72-.205c1.03.833.717 2.357-.549 2.675-1.74.437-2.789-1.358-1.53-2.617.848-.848 1.095-.855 2.079-.058m55.937.423c.382.617-.152 1.987-.861 2.213-1.091.346-2.078-.399-2.078-1.569 0-1.584 2.077-2.039 2.939-.644m4.03.197c.714 1.568-1.24 2.809-2.553 1.622-.805-.729-.796-1.329.034-2.159.83-.83 2.01-.578 2.519.537m-212.201-.149c.712.712.487 1.977-.426 2.393-1.521.693-2.544-.247-2.118-1.947.239-.951 1.77-1.22 2.544-.446m4.206.288c.756 1.413-.463 2.735-2.054 2.23-1.62-.514-1.067-2.931.671-2.931.662 0 1.137.24 1.383.701m248.027.353c.438.708-.183 2.03-1.055 2.249-1.125.282-1.884-.376-1.884-1.635 0-1.557 2.088-1.993 2.939-.614m11.175-.58c0 .525.975.859 1.154.395.138-.361-.011-.525-.477-.525-.372 0-.677.058-.677.13m-359.057 4.173c4.651 4.934 4.058 4.682 10.738 4.57l5.634-.095.172-2.238.172-2.237h1.205c1.202 0 1.205.004 1.313 1.72.322 5.108-.047 5.337-8.623 5.337H22.24l-1.323-.918-1.324-.917-.523.747c-1.101 1.572-3.768 2.252-5.402 1.377-2.603-1.393-3.075-4.259-1.159-7.049.632-.921 1.076-1.89.987-2.155-.148-.44 1.247-1.843 1.653-1.662.096.042 1.634 1.627 3.419 3.52m60.606-.818c5.157 5.575 4.536 7.875-2.126 7.875h-3.726v-2.41h3.109c3.963 0 4.203-.374 1.837-2.867-3.86-4.069-3.764-3.921-3.058-4.7.942-1.041 1.166-.922 3.964 2.102m75.217-1.678c.509.615 2.25 2.474 3.87 4.131l2.946 3.012h13.262l2.353-1.242c4.257-2.248 4.048-2.889-.944-2.889-3.146 0-3.392-.142-3.412-1.979-.007-.666 6.952-.589 8.268.092 3.301 1.706 2.709 3.921-1.732 6.48l-3.615 2.082-6.972.14c-6.267.126-7.102.076-8.261-.497-1.235-.611-1.341-.612-2.495-.036-2.144 1.071-8.52.872-8.958-.28-.704-1.851-.664-1.871 3.795-1.871 4.884 0 5.128-.264 2.553-2.768-3.112-3.028-3.757-4.045-3.057-4.82.849-.937 1.332-.847 2.399.445m-10.255 1.807c3.394 3.881-.013 9.984-4.371 7.828-1.3-.643-1.502-.659-2.45-.186-.85.424-2.107.48-7.126.313-3.351-.112-6.402-.196-6.781-.187-.379.009-3.632.097-7.229.195-9.435.256-10.322-.196-10.085-5.149l.102-2.125h2.41l.172 2.237.172 2.238h12.737l.172-2.238.172-2.237 1.291-.107 1.291-.107v2.044c0 2.869-.046 2.85 6.758 2.739l5.806-.094.217-2.013c.452-4.212 4.259-5.991 6.742-3.151m52.491-.863c2.706 1.288 2.667 7.022-.058 8.431-3.211 1.66-5.716-.036-6.098-4.127-.218-2.335-.599-2.73-1.634-1.695-.448.448-.541 1.514-.541 6.196v5.656h-2.41v-5.978c0-5.615.046-6.038.753-6.971.414-.546.79-1.046.835-1.111.734-1.049 7.196-1.333 9.153-.401m69.06 3.445c.25 4.265-1 5.508-5.54 5.508h-2.572l-.216 1.35c-.504 3.153-2.524 4.273-7.399 4.104-5.39-.186-6.703-1.579-6.738-7.147l-.021-3.299 1.291-.106 1.291-.107v3.099c0 4.509.501 5.032 4.817 5.032 3.422 0 4.133-.367 4.133-2.131 0-.749-.129-.795-2.237-.795-2.144 0-2.24-.036-2.289-.861a92.968 92.968 0 00-.087-1.291c-.025-.324 1.535-.472 6.334-.602l6.369-.172.095-1.893c.133-2.633.237-2.816 1.537-2.69 1.101.106 1.124.142 1.232 2.001m65.18 2.269c.145 5.517.258 5.648 4.815 5.648 4.506 0 4.766-.317 4.766-5.836v-4.146h2.753v2.2c0 1.69.127 2.25.545 2.41 1.689.648 2.553-.281 2.553-2.742v-1.868h2.41v2.072c0 3.885 2.841 3.925 3.029.043l.102-2.115h2.721v2.2c0 2.728-.253 2.62 6.138 2.614 5.958-.007 5.842.043 5.977-2.585l.105-2.057h2.41v2.641c0 2.321-.101 2.748-.834 3.528l-.835.888h-6.232c-4.907 0-6.384-.107-6.949-.503-.623-.437-.804-.438-1.368-.011-.835.632-3.558.636-4.39.005-.557-.422-.752-.416-1.455.045-.541.354-1.387.491-2.541.411-1.621-.112-1.73-.068-1.73.689.001 3.217-2.334 4.699-7.401 4.699-6.317 0-7.057-.845-7.057-8.055v-4.509h2.354l.114 4.334m49.315.141c-.036 6.296-1.434 8.336-5.758 8.401l-2.135.032-.107-1.29-.107-1.291h1.769c3.16 0 3.781-1.017 3.781-6.191v-4.178l1.291.107 1.291.107-.025 4.303M14.7 251.27c-1.551 1.844-1.101 3.463.963 3.463 2.077 0 2.497-1.54.93-3.416l-.962-1.153-.931 1.106m28.865-.247c-1.043 1.489-.094 3.366 1.702 3.366.798 0 .86-.119.86-1.652 0-2.427-1.404-3.367-2.562-1.714m96.607-.352c-.535.535-.535 3.114 0 3.649 1.066 1.066 3.029-.116 3.029-1.824 0-1.709-1.963-2.891-3.029-1.825m53.012 1.567l.103 1.979h1.377c1.368 0 1.378-.01 1.481-1.421.124-1.702-.547-2.538-2.039-2.538h-1.025l.103 1.98m26.411-1.431c-1.099 1.323-.283 3.926 1.231 3.926 1.044 0 1.687-.853 1.687-2.237 0-1.384-.643-2.238-1.687-2.238-.427 0-.981.247-1.231.549m68.163.634c1.093 1.127 1.185 1.157 1.961.649 1.57-1.029 1.067-1.832-1.146-1.832h-1.961l1.146 1.183m-254.689 8.124c1.017.544.896 2.307-.193 2.803-1.721.784-3.025-1.538-1.474-2.624.908-.636.83-.627 1.667-.179m65.06 0c1.018.544.896 2.307-.193 2.803-1.67.761-2.87-1.152-1.55-2.471.796-.796.855-.808 1.743-.332m201.502.184c.72.72.682 1.29-.133 2.028-1.383 1.252-3.309-.227-2.431-1.867.45-.841 1.8-.925 2.564-.161m3.903.28c.527 1.156-.332 2.357-1.582 2.211-1.127-.131-1.805-1.656-1.108-2.495.701-.845 2.25-.681 2.69.284m12.404-.408c.73.73.49 2.275-.447 2.889-1.352.885-2.834-.216-2.59-1.925.184-1.296 2.098-1.903 3.037-.964"
        ></path>
       
        <path
          fill="#9eaabe"
          d="M11.514 137.349c0 6.343.047 8.938.103 5.766.057-3.171.057-8.36 0-11.532-.056-3.171-.103-.576-.103 5.766m148.638 6.799c-.078 17.197.014 19.222.81 17.933.152-.245.095-.304-.148-.154-.294.182-.418-4.382-.487-17.933l-.092-18.176-.083 18.33m209.021-7.143c0 6.153.046 8.671.103 5.594a359.71 359.71 0 000-11.188c-.057-3.076-.103-.559-.103 5.594M148.53 158.176c0 17.607.042 24.76.093 15.894.051-8.865.051-23.271 0-32.013-.051-8.743-.093-1.489-.093 16.119m208.946-12.221c0 10.697.044 15.073.097 9.725.053-5.349.053-14.101 0-19.449-.053-5.349-.097-.973-.097 9.724m-137.08-9.057c.331.087.873.087 1.205 0 .331-.086.06-.157-.603-.157-.662 0-.933.071-.602.157m1.721 5.861a7.59 7.59 0 001.893 0c.521-.078.095-.143-.946-.143-1.042 0-1.468.065-.947.143m-132.172 1.042c1.286.067 3.3.066 4.476-.001 1.175-.067.123-.121-2.338-.121-2.462.001-3.423.056-2.138.122m90.864.001c1.846.062 4.867.062 6.713 0 1.845-.062.335-.112-3.357-.112s-5.202.05-3.356.112m62.737 1.465c.932.946 1.772 1.721 1.867 1.721.095 0-.591-.775-1.523-1.721-.933-.947-1.773-1.721-1.868-1.721-.094 0 .591.774 1.524 1.721m-187.285 3.528l-1.011 1.119 1.118-1.011c.616-.556 1.119-1.06 1.119-1.119 0-.266-.284-.032-1.226 1.011m49.569 0l-1.011 1.119 1.119-1.011c1.043-.943 1.277-1.227 1.011-1.227-.059 0-.563.504-1.119 1.119m191.932-1.011c0 .059.504.563 1.119 1.119l1.119 1.011-1.011-1.119c-.942-1.043-1.227-1.277-1.227-1.011m80.813 5.644c.429.082 1.048.079 1.377-.007.329-.086-.021-.154-.778-.15-.757.004-1.027.074-.599.157m-147.422 4.231c.74.758 1.422 1.377 1.517 1.377.095 0-.433-.619-1.173-1.377-.739-.757-1.422-1.377-1.516-1.377-.095 0 .433.62 1.172 1.377m-10.892 3.133c-3.715 2.213-3.616 8.277.166 10.071 6.362 3.019 11.787-5.39 6.218-9.638-1.712-1.306-4.592-1.501-6.384-.433m31.798 2.719c0 .663.071.934.158.603a2.846 2.846 0 000-1.205c-.087-.332-.158-.06-.158.602m-51.941 2.238c.001 1.514.062 2.091.134 1.281.073-.809.072-2.048-.002-2.753-.074-.705-.133-.043-.132 1.472m46.116 0c.002 1.136.066 1.559.143.94.076-.619.075-1.548-.004-2.065-.078-.517-.141-.011-.139 1.125m-196.905 1.205c0 1.041.064 1.467.143.946a7.59 7.59 0 000-1.893c-.079-.521-.143-.095-.143.947m49.565-.173c.002.947.069 1.293.148.77.079-.523.077-1.298-.005-1.721-.081-.423-.146.005-.143.951m288.18 11.36c0 6.627.046 9.289.103 5.916.056-3.373.056-8.795 0-12.048-.057-3.254-.103-.494-.103 6.132m-17.901.689c0 6.247.046 8.852.103 5.787.057-3.064.057-8.176.001-11.359-.057-3.184-.104-.676-.104 5.572m-208.951.86c0 5.775.047 8.137.104 5.25.058-2.888.058-7.612 0-10.499-.057-2.888-.104-.525-.104 5.249m197.245.172c0 5.68.047 8.052.105 5.271.058-2.781.058-7.428.001-10.327-.058-2.899-.105-.624-.106 5.056m-293.439-3.851c0 .06.503.563 1.118 1.119l1.119 1.011-1.011-1.119c-.942-1.042-1.226-1.277-1.226-1.011m49.569 0c0 .06.504.563 1.119 1.119l1.119 1.011-1.011-1.119c-.943-1.042-1.227-1.277-1.227-1.011m92.255 5.164c0 .059.503.563 1.119 1.119l1.119 1.011-1.012-1.119c-.942-1.043-1.226-1.277-1.226-1.011m-194.394 7.293c.003.947.07 1.293.149.77.079-.523.077-1.298-.005-1.721-.082-.424-.146.005-.144.951m210.659.423c.71.074 1.872.074 2.582 0 .71-.074.129-.135-1.291-.135s-2.001.061-1.291.135m-197.426 2.407c.611.076 1.696.078 2.41.003.714-.074.214-.137-1.111-.138-1.326-.002-1.91.059-1.299.135m45.791.001c.615.076 1.622.076 2.237 0 .616-.076.112-.139-1.118-.139-1.231 0-1.734.063-1.119.139m49.57 0c.615.076 1.622.076 2.237 0s.112-.139-1.119-.139c-1.23 0-1.734.063-1.118.139m162.478 0c.615.076 1.622.076 2.238 0 .615-.076.112-.139-1.119-.139s-1.734.063-1.119.139m48.031.004c.905.072 2.299.071 3.098-.002.799-.072.059-.13-1.645-.129-1.704.001-2.358.06-1.453.131M28.485 202.635c1.155.248 1.232 13.738.081 13.996-.577.13-.562.148.086.11l.78-.046v-14.113l-.861-.057c-.758-.049-.768-.036-.086.11m7.125.215c-.653 1.7.045 13.847.798 13.891.649.038.663.02.086-.11-1.151-.258-1.073-13.756.081-13.978l.774-.15-.785-.046c-.432-.026-.861.151-.954.393m-33.975.158c.994.069 2.621.069 3.615 0 .994-.07.18-.127-1.808-.127s-2.801.057-1.807.127m10.882 6.631c0 1.798.058 2.534.128 1.635.071-.9.071-2.371 0-3.271-.07-.899-.128-.163-.128 1.636m93.32 1.893l.015 5.163.861.057c.74.048.753.033.095-.109-.743-.16-.769-.316-.876-5.22l-.11-5.055.015 5.164m134.251 0l.015 5.163.861.057c.74.048.754.033.095-.109-.743-.16-.769-.316-.875-5.22l-.11-5.055.014 5.164m18.933 0l.015 5.163.861.057c.74.048.754.033.095-.109-.743-.16-.769-.316-.876-5.22l-.109-5.055.014 5.164m7.918 0l.015 5.163.86.057c.741.048.754.033.095-.109-.742-.16-.768-.316-.875-5.22l-.11-5.055.015 5.164M2.668 208.514c.804.072 2.121.072 2.926 0 .804-.073.146-.132-1.463-.132s-2.268.059-1.463.132m273.134 4.801c-.066 2.978-.115 3.169-.845 3.31l-.775.149.786.047c1.044.062 1.158-.358 1.021-3.769l-.117-2.897-.07 3.16m90.272.282c.017 2.851.074 3.101.707 3.132.499.025.526-.005.099-.108-.489-.118-.61-.654-.708-3.132l-.118-2.99.02 3.098m-5.937.062c-.063 2.621-.122 2.827-.843 2.966l-.774.149.785.047c1.031.061 1.164-.385 1.021-3.428l-.12-2.55-.069 2.816M159.294 212.3c.805.073 2.122.073 2.926 0 .805-.072.147-.132-1.463-.132-1.609 0-2.267.06-1.463.132m153.023.002c.905.071 2.299.07 3.098-.002.799-.072.058-.131-1.646-.13-1.704.001-2.357.06-1.452.132m-157.24 4.221l-1.032.263.926.041c.51.022 1.022-.114 1.139-.304.117-.189.165-.326.107-.303-.059.022-.572.159-1.14.303m152.84 0l-1.032.263.926.041c.509.022 1.022-.114 1.139-.304.117-.189.165-.326.106-.303a31.15 31.15 0 01-1.139.303m75.646 22.628c.899.071 2.371.071 3.27 0 .899-.07.164-.128-1.635-.128s-2.534.058-1.635.128m-180.818 3.383l1.025.193.107 5.487.108 5.487-.013-5.594-.013-5.594-1.119-.086c-1.087-.084-1.09-.081-.095.107m67.126 0l1.024.193.108 5.229.108 5.228-.014-5.335-.013-5.336-1.118-.086c-1.087-.084-1.09-.081-.095.107m36.658.23c-.099.256-.132 2.861-.074 5.787l.105 5.322.076-5.594.077-5.594h2.065v5.66c0 3.112.116 5.731.258 5.819.142.089.181-2.497.086-5.745l-.172-5.906-1.121-.108c-.708-.068-1.187.064-1.3.359m-221.017 5.773c0 3.313.051 4.669.114 3.012a96.025 96.025 0 000-6.024c-.063-1.657-.114-.301-.114 3.012m286.751 1.205c0 3.976.05 5.555.111 3.51.061-2.046.061-5.299 0-7.229-.062-1.931-.112-.257-.111 3.719m11.015 0c.001 3.976.051 5.555.112 3.51.061-2.046.06-5.299-.001-7.229-.061-1.931-.111-.257-.111 3.719m2.066 0c0 3.976.05 5.555.111 3.51.061-2.046.061-5.299-.001-7.229-.061-1.931-.111-.257-.11 3.719m-212.884-1.635c0 .142 1.123.216 2.496.164 4.517-.17 4.965-.306 1.206-.365-2.035-.031-3.701.059-3.702.201m158.135 5.249c0 2.178.056 3.068.124 1.98.068-1.089.068-2.87 0-3.959s-.124-.198-.124 1.979m9.983 0c0 2.178.056 3.068.124 1.98.068-1.089.068-2.87 0-3.959s-.124-.198-.124 1.979m7.894-1.893c.001 1.136.066 1.559.142.94.077-.618.075-1.548-.003-2.065-.079-.517-.141-.011-.139 1.125m3.442 0c.002 1.136.066 1.559.143.94.076-.618.075-1.548-.004-2.065-.078-.517-.141-.011-.139 1.125m-314.282.516c0 1.231.062 1.734.139 1.119.076-.615.076-1.622 0-2.237-.077-.616-.139-.112-.139 1.118m62.988-.344c0 1.041.064 1.467.143.947a7.598 7.598 0 000-1.894c-.079-.52-.143-.094-.143.947m5.514.344c0 1.231.063 1.734.139 1.119.076-.615.076-1.622 0-2.237-.076-.616-.139-.112-.139 1.118m18.238-.344c0 1.041.064 1.467.143.947a7.598 7.598 0 000-1.894c-.079-.52-.143-.094-.143.947m49.724-1.469c.805.072 2.122.072 2.926 0 .805-.072.147-.132-1.463-.132-1.609 0-2.267.06-1.463.132m18.815.225c-.101.262-.123 1.153-.05 1.979l.134 1.503.06-1.785c.056-1.664.124-1.794 1.007-1.927l.947-.144-.958-.051c-.538-.029-1.037.157-1.14.425m44.717 1.416c.002 1.136.066 1.559.143.941.077-.619.075-1.548-.004-2.066-.078-.517-.141-.011-.139 1.125m25.474 0c.001 1.136.066 1.559.142.941.077-.619.075-1.548-.003-2.066-.079-.517-.141-.011-.139 1.125m2.413.172c0 1.231.062 1.734.138 1.119a10.86 10.86 0 000-2.237c-.076-.616-.138-.112-.138 1.118m21.841-1.816c.618.077 1.548.075 2.065-.003.517-.079.011-.141-1.125-.139-1.136.002-1.559.066-.94.142m12.579 1.644c.001 1.136.066 1.559.142.941.077-.619.075-1.548-.003-2.066-.079-.517-.141-.011-.139 1.125m22.719 0c.002 1.136.066 1.559.143.941.076-.619.075-1.548-.004-2.066-.078-.517-.141-.011-.139 1.125m46.475.172c0 1.231.063 1.734.139 1.119.076-.615.076-1.622 0-2.237-.076-.616-.139-.112-.139 1.118m8.625 1.549c0 2.083.057 2.891.126 1.795.068-1.095.067-2.799-.002-3.787-.069-.987-.125-.09-.124 1.992m-179.377-1.032c.003.946.07 1.293.149.769.079-.523.077-1.297-.005-1.721-.082-.423-.146.005-.144.952m18.57-.172c0 .662.071.933.158.602a2.846 2.846 0 000-1.205c-.087-.331-.158-.06-.158.603m-168.272.772l.034 1.465 9.209.009 9.208.008-9.103-.1-9.103-.1-.139-1.374-.139-1.374.033 1.466m88.754-.428c0 .662.071.934.158.602a2.846 2.846 0 000-1.205c-.087-.331-.158-.06-.158.603m58.864 0c0 .662.071.934.158.602a2.846 2.846 0 000-1.205c-.087-.331-.158-.06-.158.603m-184.846.516c.003.757.074 1.027.156.599.083-.429.079-1.048-.007-1.377-.086-.329-.153.021-.149.778m176.505 3.937v5.142l-1.119.139c-1.101.136-1.099.139.172.194l1.291.055v-5.336c0-2.935-.077-5.336-.172-5.336-.095 0-.172 2.314-.172 5.142m56.354-4.894l1.105.138.117 2.647.117 2.647.069-2.84.069-2.84-1.291.055c-1.25.054-1.256.06-.186.193m-217.698 2.418c1.476.065 3.799.064 5.163-.001 1.364-.065.157-.118-2.683-.117-2.84 0-3.956.053-2.48.118m46.769 1.035c.053 1.251.059 1.257.193.186l.138-1.106 2.819-.115 2.819-.116-3.012-.07-3.012-.07.055 1.291m19.308-1.036c1.278.066 3.369.066 4.647 0s.233-.12-2.323-.12-3.602.054-2.324.12m19.983.002c1.665.063 4.299.062 5.851-.001 1.553-.064.19-.116-3.028-.115-3.219 0-4.489.052-2.823.116m15.645-.001a84.04 84.04 0 005.68 0c1.562-.064.284-.116-2.84-.116-3.124 0-4.402.052-2.84.116m20.281-.027c-.126.127-.227.398-.224.603.003.23.107.213.271-.045.174-.274 1.564-.456 4.039-.529l3.774-.112-3.815-.073c-2.098-.04-3.918.03-4.045.156m16.054.028c1.856.062 4.799.062 6.54-.001 1.742-.062.223-.113-3.374-.113-3.597.001-5.022.052-3.166.114m43.183-.001a84.04 84.04 0 005.68 0c1.562-.064.284-.116-2.84-.116-3.124 0-4.402.052-2.84.116m20.31 0a84.04 84.04 0 005.68 0c1.562-.064.284-.116-2.84-.116-3.124 0-4.402.052-2.84.116m24.94 0c1.647.063 4.435.063 6.196.001 1.761-.063.413-.114-2.995-.115-3.408 0-4.848.051-3.201.114m22.22 0c1.751.063 4.617.063 6.369 0 1.751-.062.318-.113-3.185-.113-3.502 0-4.935.051-3.184.113m18.589-.002c.994.069 2.62.069 3.614 0 .994-.07.181-.127-1.807-.127s-2.801.057-1.807.127m9.987-.011c.428.083 1.047.08 1.377-.006.329-.087-.022-.154-.779-.15-.757.004-1.027.074-.598.156m7.057.004c.523.079 1.298.077 1.721-.005.424-.081-.004-.146-.951-.144-.947.003-1.293.07-.77.149m7.747.002c.619.077 1.548.075 2.065-.003.518-.079.011-.141-1.125-.139-1.136.002-1.559.066-.94.142m39.581.007c1.372.065 3.618.065 4.991 0 1.373-.066.25-.119-2.496-.119-2.745 0-3.868.053-2.495.119m-164.372 2.391c.331.086.873.086 1.205 0 .331-.087.06-.158-.603-.158-.662 0-.933.071-.602.158m140.275 2.769c.805.072 2.122.072 2.926 0 .805-.073.147-.132-1.463-.132-1.609 0-2.267.059-1.463.132m38.086.583c-.104.27-.12.851-.036 1.291.118.62.163.553.199-.298.043-1.005.157-1.11 1.338-1.234l1.291-.135-1.302-.057c-.852-.038-1.366.111-1.49.433m-38.093 1.823c.611.076 1.695.077 2.409.002.714-.074.214-.136-1.111-.138-1.325-.001-1.91.06-1.298.136m-85.191.348c.9.071 2.371.071 3.271 0 .899-.071.163-.129-1.636-.129-1.798 0-2.534.058-1.635.129"
        ></path>
        <path
          fill="#848484"
          d="M146.809 158.003c0 17.703.042 24.945.093 16.093.051-8.851.051-23.334 0-32.186-.051-8.851-.093-1.609-.093 16.093m111.187 0c0 17.703.042 24.945.093 16.093.052-8.851.052-23.334 0-32.186-.051-8.851-.093-1.609-.093 16.093m11.349-20.654c0 6.343.047 8.938.104 5.766.056-3.171.056-8.36 0-11.532-.057-3.171-.104-.576-.104 5.766m-243.958 5.407a4.908 4.908 0 001.549 0c.426-.082.078-.149-.774-.149s-1.201.067-.775.149m44.928.004c.523.079 1.297.077 1.721-.005.423-.081-.005-.146-.952-.144-.946.003-1.293.07-.769.149m49.737-.004a4.908 4.908 0 001.549 0c.426-.082.077-.149-.775-.149s-1.2.067-.774.149m163.167 0a4.908 4.908 0 001.549 0c.426-.082.077-.149-.775-.149s-1.2.067-.774.149m47.332.003a7.59 7.59 0 001.893 0c.521-.078.095-.143-.947-.143-1.041 0-1.467.065-.946.143m51.811-.003c.428.083 1.048.08 1.377-.007.329-.086-.021-.153-.779-.149-.757.004-1.026.074-.598.156M97.237 166.954c0 12.779.043 18.007.095 11.617.052-6.389.052-16.846 0-23.235-.052-6.39-.095-1.162-.095 11.618m123.668-18.356c-.786.093-1.21.295-1.076.513.141.227-.027.281-.451.146-1.246-.395-4.977 1.345-4.312 2.011.127.127-.035.129-.36.004-.352-.135-.592-.064-.592.174 0 .221-.148.311-.328.199-.18-.111-.824.241-1.43.783-.761.68-.931.986-.549.986.306 0 .465-.146.355-.324-.117-.19.137-.228.618-.092.53.15.66.122.371-.08-.363-.252-.355-.387.039-.714.399-.332.468-.243.386.504-.125 1.138-.638 1.675-1.24 1.299-.882-.551-1.434-.427-2.149.482-.396.504-.643.969-.548 1.035.094.065-.1.271-.433.457-.448.25-.521.494-.282.941.177.331.197.805.044 1.053-.226.366-.307.367-.427.006-.173-.52-.97-.128-.963.473.004.28.097.265.296-.048.204-.322.356-.131.511.645.333 1.667.24 1.995-.245.859l-.435-1.02-.756 1.562c-.604 1.249-.71 1.896-.528 3.225.18 1.314.134 1.605-.218 1.388-.611-.378-.217 3.648.599 6.106.522 1.575.709 1.798 1.46 1.742.473-.035.675.014.449.109-.226.095-.316.42-.199.723.148.385.08.469-.226.28-.346-.214-.355-.116-.041.47.217.407.566.634.776.504.209-.129.289-.087.177.093-.287.465.109.965 1.301 1.644.568.324.762.506.43.405-.91-.277-.722.344.345 1.14.52.388 1.195.945 1.499 1.238.58.557 1.836.349 1.469-.243-.116-.189.156-.152.605.082 1.099.573 1.093.563.468.802-.318.122-.46.068-.338-.13.26-.42-.183-.433-.829-.024-.365.231-.123.489.987 1.055 1.153.588 1.554.659 1.859.328.302-.328.234-.368-.299-.18-.525.186-.593.148-.288-.16.437-.441 1.276-.122.973.369-.279.451 1.067 1.059 1.757.794.379-.145.515-.095.371.137-.134.217.089.368.546.371.425.002 1.469.108 2.321.236 1.22.182 1.439.145 1.033-.173-.541-.423-.233-.366 1.261.236.401.161.494.103.311-.194-.2-.323.047-.367 1.026-.183.918.172 1.219.13 1.048-.146-.154-.249-.047-.314.299-.182.296.114.73.048.965-.146.234-.195.548-.351.698-.347.651.015 2.284-.861 2.115-1.134-.102-.165.025-.22.282-.121.995.382 3.407-1.842 3.228-2.976-.128-.808-.068-.958.271-.676.24.198.571.246.737.105.165-.14.093.016-.16.348-.256.334-.306.602-.112.602.563 0 .832-1.121.349-1.458-.294-.205-.199-.24.287-.105 1.02.285 2.043-1.197 1.324-1.916-.338-.339-.378-.631-.133-.996.287-.428.329-.405.246.136-.055.359.115.728.378.82.291.101.384.014.237-.223-.132-.214-.072-.389.133-.389.221 0 .145-.383-.189-.946-.379-.641-.397-.752-.056-.345.882 1.052 1.866-.743 2.183-3.981.093-.95.243-1.845.332-1.99.251-.405-.252-4.102-.534-3.927-.136.084-.182-.191-.101-.612.182-.955-.477-2.767-.91-2.5-.177.11-.433.017-.57-.204-.156-.252-.1-.311.148-.158.236.146.397.027.397-.291 0-.295-.18-.536-.401-.536-.221 0-.305-.097-.186-.216.561-.561-3.167-5.221-3.842-4.804-.188.116-.446.044-.573-.162-.127-.205-.442-.292-.701-.192-.639.245-1.012-.442-.511-.939.308-.305.344-.244.152.259-.179.471-.132.585.167.401.23-.142.643-.071.919.157.28.233.501.266.501.076 0-.39-2.548-2.153-3.111-2.153-.204 0-.296.121-.204.27.092.149-.106.27-.439.27s-.606-.184-.606-.409c0-.226.245-.335.545-.243.381.117.341.002-.133-.384-1.401-1.14-6.531-2.041-9.57-1.681m6.806 1.144c.434.186.497.296.172.296-.284 0-.826-.133-1.205-.296-.434-.187-.497-.296-.172-.296.284 0 .826.133 1.205.296m-9.364.817c.716-.135.719-.125.07.184-.423.201-.501.337-.201.352.268.013.388.123.266.245-.289.289-1.278-.537-1.243-1.038.02-.282.071-.28.189.006.088.216.502.329.919.251m-2.662 4.427c.056.386-.089.494-.469.349-.408-.157-.434-.251-.099-.362.367-.123.364-.212-.018-.48-.39-.273-.388-.307.017-.198.268.072.523.383.569.691m12.266-.107c-.139.363-.018.425.464.24.359-.138.541-.14.406-.005-.462.463 1.107 1.27 1.628.837.332-.275.538-.282.699-.021.126.203.101.347-.055.32-.872-.151-.748.196.615 1.721 2.054 2.295 2.437 2.786 2.173 2.786-.124 0-.008.349.257.775.265.426.53 1.317.589 1.979.129 1.456.308 1.691.78 1.023.291-.411.32-.388.154.124-.113.347-.207.812-.21 1.033-.003.231-.148.182-.339-.114-.241-.372-.337-.036-.347 1.204-.007.953-.316 2.391-.692 3.219-.374.824-.599 1.63-.499 1.79.099.161-.146.467-.545.68-.432.232-.646.594-.53.896.108.279.078.436-.065.347-.143-.088-.728.252-1.3.757-.572.504-.841.782-.597.617.711-.481.512-.038-.304.677-.411.361-.634.462-.496.226.33-.564.245-.549-1.273.225-1.177.6-1.24.702-.737 1.205.302.302.402.549.223.549-.18 0-.501-.209-.713-.465-.299-.361-.791-.394-2.194-.147-.994.176-1.962.304-2.151.287-1.375-.129-2.146-.264-2.427-.425-.327-.188-1.82-.584-2.307-.612-.142-.008-.568-.325-.946-.703-.379-.379-.882-.684-1.119-.678-.242.006-.139.232.238.516.367.278.503.506.3.506-.442 0-1.355-1.029-.924-1.042.165-.005-.242-.483-.905-1.062-.663-.579-.99-.94-.728-.802.262.138.117-.237-.323-.832-.865-1.171-1.205-1.32-1.475-.651-.125.31-.181.316-.201.02-.015-.225.11-.495.278-.598.299-.185-.179-1.96-.781-2.901-.251-.393-.35-.393-.626 0-.264.377-.297.367-.172-.05.086-.284.348-.471.584-.416.3.07.376-.238.254-1.033-.095-.623-.018-1.984.172-3.026.19-1.041.342-2.265.338-2.72-.005-.522.09-.67.256-.401.18.291.329.173.473-.378.116-.442.176-.811.134-.821-.315-.07 4.056-3.941 4.45-3.941.278 0 .411-.153.295-.34-.124-.203.03-.249.381-.114.432.166.515.104.309-.229-.171-.277-.148-.373.059-.246.187.116.792.07 1.344-.102 1.7-.531 8.353-.272 8.128.316m-16.196.8c.122-.034.136.27.03.676-.193.736-.193.736-.485-.051-.24-.649-.382-.714-.801-.366-.28.232-.409.584-.287.781.134.217.053.254-.206.094-.308-.19-.323-.369-.053-.638.497-.498.48-1.032-.023-.72-.247.152-.304.094-.152-.153.186-.3.433-.295 1 .02.415.23.854.39.977.357m1.67 1.678c0 .253.208.223.603-.086.533-.418.553-.409.175.076-.235.301-.326.65-.201.774.124.125.147.227.05.227-.097 0-.456-.31-.799-.689-.353-.39-.451-.688-.225-.688.218 0 .397.174.397.386m20.248.893c-.262.316-.245.589.062.958.78.941.153.536-.977-.631-.726-.749-.934-1.147-.599-1.147.282 0 .443.113.358.251-.085.137.071.337.348.443.277.107.595.045.707-.136.112-.181.03-.329-.181-.329-.212 0-.279-.171-.15-.381.165-.267.32-.244.517.075.158.255.12.65-.085.897m-26.237 2.906c-.378.54-.551.623-.551.263 0-.552.713-1.441.958-1.195.08.08-.104.499-.407.932m3.219 3.388c.059-.787.088-.802.338-.172.163.41.125.783-.094.924-.581.372-.92-.026-.875-1.031l.04-.926.263 1.033c.248.973.267.983.328.172m176.344.344c0 .663.071.934.157.603a2.814 2.814 0 000-1.205c-.086-.332-.157-.061-.157.602m-134.94 1.033c0 .662.071.934.158.602a2.846 2.846 0 000-1.205c-.087-.331-.158-.06-.158.603m117.04.344c0 .663.071.934.157.602a2.81 2.81 0 000-1.204c-.086-.332-.157-.061-.157.602m-332.875.689c0 .662.071.933.158.602a2.846 2.846 0 000-1.205c-.087-.331-.158-.06-.158.603m291.745 3.356c5.159.053 13.602.053 18.761 0 5.159-.054.938-.098-9.381-.098-10.318 0-14.539.044-9.38.098m-119.949 1.004c-.205.533.443.631.703.106.097-.194.139-.165.094.065-.137.7-.832.712-1.202.022-.262-.49-.234-.652.116-.652.256 0 .386.206.289.459m25.937 3.999c-.029.48-.269.787-.612.787-.522 0-.522-.057-.001-.776.697-.96.672-.959.613-.011m-193.356 9.455l-1.186 1.291 1.291-1.187c1.201-1.104 1.449-1.395 1.186-1.395-.058 0-.638.581-1.291 1.291m228.637 2.926c.049 2.628.203 2.341.37-.689.055-.994-.017-1.807-.159-1.807-.142 0-.237 1.123-.211 2.496m-38.154 17.125c0 1.042.065 1.468.144.947a7.686 7.686 0 000-1.893c-.079-.521-.144-.095-.144.946m1.377 0c0 1.042.065 1.468.144.947a7.686 7.686 0 000-1.893c-.079-.521-.144-.095-.144.946M21.458 208.95c0 1.42.061 2.001.135 1.291.075-.71.075-1.872 0-2.582-.074-.71-.135-.129-.135 1.291m207.911-1.893c.043.42.367.731.831.797.732.105.765.272.874 4.475l.113 4.366-.017-4.475c-.016-4.335-.04-4.478-.77-4.582-.415-.059-.832-.369-.927-.688-.125-.419-.154-.389-.104.107m5.054-.08c0 .345-.353.591-.946.659l-.947.109-.017 4.475-.016 4.475.113-4.389.113-4.389h.861c.823 0 1.505-.826 1.054-1.277-.118-.118-.215.034-.215.337m57.965 3.866c.001 2.462.056 3.423.122 2.138.067-1.286.066-3.3-.001-4.476-.067-1.175-.121-.123-.121 2.338m-83.438-.516l-3.614.209 3.7.068c2.283.041 3.701-.065 3.701-.277 0-.189-.039-.314-.086-.277-.048.037-1.713.162-3.701.277m-140.005.255c1.096.068 2.8.068 3.787-.002.987-.069.091-.125-1.992-.124-2.083.001-2.89.057-1.795.126m64.028 0c1.096.068 2.799.068 3.787-.002.987-.069.09-.125-1.992-.124-2.083.001-2.891.057-1.795.126m212.552-.001c.994.069 2.62.069 3.614 0 .994-.07.181-.127-1.807-.127s-2.801.057-1.807.127m-262.442 3.016c-.001 1.704.057 2.445.129 1.646.072-.799.073-2.193.002-3.098-.071-.905-.13-.252-.131 1.452m185.182 1.033c.002 1.136.066 1.559.143.94.076-.618.075-1.548-.004-2.065-.078-.517-.141-.011-.139 1.125m18.4 5.923c.428.083 1.048.079 1.377-.007.329-.086-.021-.153-.779-.149-.757.003-1.026.074-.598.156m43.542-.006a2.81 2.81 0 001.204 0c.332-.086.061-.157-.602-.157s-.934.071-.602.157M85.976 242.584c.429.083 1.048.079 1.377-.007.33-.086-.021-.153-.778-.149-.757.003-1.027.074-.599.156m286.916-.006a2.81 2.81 0 001.204 0c.332-.087.061-.157-.602-.157s-.934.07-.602.157m10.847.006c.428.083 1.048.079 1.377-.007.329-.086-.021-.153-.779-.149-.757.003-1.026.074-.598.156m-182.222 5.609c0 3.124.052 4.402.116 2.84a84.04 84.04 0 000-5.68c-.064-1.562-.116-.284-.116 2.84m-10.381-.438c.71.074 1.872.074 2.582 0 .71-.074.129-.135-1.291-.135s-2.001.061-1.291.135m95.878.002c.81.073 2.049.071 2.754-.002.705-.074.043-.134-1.472-.133-1.515.002-2.091.062-1.282.135m-222.986 1.641c.642.662 1.245 1.204 1.339 1.204.095 0-.353-.542-.995-1.204-.642-.663-1.245-1.205-1.34-1.205-.095 0 .353.542.996 1.205m-28.777.649c-.1.262-.122 1.153-.049 1.979l.134 1.502.06-1.785c.059-1.741.088-1.789 1.179-1.924l1.119-.139-1.13-.055c-.687-.034-1.201.132-1.313.422m66.626-.285c.978.186 1.022.276 1.148 2.324l.131 2.131-.029-2.238-.029-2.237-1.119-.086c-1.073-.083-1.077-.079-.102.106m5.507 0c.937.178 1.025.324 1.148 1.896l.134 1.702-.03-1.809c-.03-1.787-.044-1.81-1.149-1.895-1.071-.083-1.075-.078-.103.106m14.616.282c-.1.26-.124 1.229-.052 2.151l.131 1.678.062-1.959.062-1.958 1.291-.136 1.291-.135-1.302-.057c-.831-.037-1.367.113-1.483.416m116.883-.282c.977.186 1.021.276 1.147 2.324l.131 2.131-.029-2.238-.029-2.237-1.118-.086c-1.074-.083-1.078-.079-.102.106m24.886.045c.332.087.874.087 1.205 0 .332-.087.06-.157-.602-.157-.663 0-.934.07-.603.157m37.417-.045c.871.166 1.033.372 1.148 1.463l.135 1.271-.03-1.377c-.028-1.3-.092-1.382-1.148-1.463-1.068-.082-1.073-.078-.105.106m13.706.051c.428.083 1.048.079 1.377-.007.329-.086-.021-.153-.778-.149-.758.003-1.027.074-.599.156m9.016-.051c.978.186 1.022.276 1.148 2.324l.131 2.131-.029-2.238-.029-2.237-1.119-.086c-1.073-.083-1.077-.079-.102.106m19.056 1.701c.002 1.136.066 1.559.143.94.076-.618.075-1.548-.004-2.065-.078-.517-.141-.011-.139 1.125m11.36 0c.001 1.136.066 1.559.142.94.077-.618.075-1.548-.003-2.065-.079-.517-.141-.011-.139 1.125m12.422-1.41c-.102.266-.122 1.002-.044 1.635.129 1.055.146 1.03.196-.289.052-1.354.123-1.45 1.174-1.58l1.119-.139-1.13-.055c-.693-.034-1.201.131-1.315.428m11.986-.246l1.279.147.117 3.423.117 3.423-.019-3.529-.019-3.529-1.377-.041-1.377-.041 1.279.147m-188.272 2c.002.947.069 1.293.148.77.08-.523.077-1.298-.004-1.721-.082-.424-.147.005-.144.951m-144.239 1.205c0 .852.067 1.201.149.775a4.908 4.908 0 000-1.549c-.082-.426-.149-.078-.149.774m196.926 1.893c.002 1.515.062 2.092.135 1.282.072-.81.071-2.049-.003-2.754-.073-.705-.133-.042-.132 1.472m-131.185 2.15c1.846.062 4.867.062 6.713 0s.335-.112-3.357-.112c-3.691 0-5.202.05-3.356.112m16.351 0a84.04 84.04 0 005.68 0c1.562-.064.284-.116-2.84-.116-3.124 0-4.402.052-2.84.116m22.548-.002c1.088.068 2.87.068 3.958 0 1.089-.068.198-.124-1.979-.124s-3.068.056-1.979.124m13.443.002c1.855.062 4.799.062 6.54 0 1.741-.062.223-.113-3.374-.113s-5.022.051-3.166.113m43.011 0c1.657.063 4.367.063 6.024 0s.301-.115-3.012-.115-4.669.052-3.012.115m20.981 0c1.647.063 4.435.063 6.196 0 1.761-.062.413-.114-2.995-.114-3.407-.001-4.848.051-3.201.114m22.915-.007c.619.077 1.548.075 2.065-.003.518-.079.011-.142-1.125-.14-1.136.002-1.559.066-.94.143m5.931.009c0 .142.968.215 2.152.162 3.658-.164 4.01-.315.861-.369-1.657-.028-3.012.065-3.013.207m18.178-.001c1.95.061 5.048.061 6.884-.001 1.836-.062.24-.112-3.547-.112-3.786.001-5.288.051-3.337.113m18.742-.003c1.089.068 2.87.068 3.959 0 1.088-.068.198-.124-1.98-.124-2.177 0-3.068.056-1.979.124m9.466-.005c.616.076 1.623.076 2.238 0 .615-.077.112-.139-1.119-.139-1.23 0-1.734.062-1.119.139m6.877-.001c.611.076 1.696.077 2.41.003.714-.075.214-.137-1.111-.138-1.325-.002-1.91.059-1.299.135m7.764.005c.905.071 2.299.07 3.098-.002.799-.072.058-.13-1.646-.129-1.704.001-2.357.06-1.452.131m-278.448 3.336c-.591 1.539-.043 2.09 2.103 2.115l2.066.025-1.98-.127c-2.952-.19-3.094-2.046-.172-2.25l1.808-.127-1.818-.064c-1.303-.045-1.872.076-2.007.428m333.52 2.165c.523.08 1.297.077 1.721-.004.423-.082-.005-.147-.952-.144-.946.002-1.293.069-.769.148"
        ></path>
        <path
          fill="#8c8c8c"
          d="M226.678 149.742c.379.163.921.296 1.205.296.325 0 .262-.11-.172-.296-.379-.163-.921-.296-1.205-.296-.325 0-.262.109.172.296m-9.439.56c-.035.501.954 1.327 1.243 1.038.122-.122.002-.232-.266-.245-.3-.015-.222-.151.201-.352.649-.309.646-.319-.07-.184-.417.078-.831-.035-.919-.251-.118-.286-.169-.288-.189-.006m13.609.191c.159.257.063.328-.269.201-.284-.109-.516-.014-.516.212 0 .225.273.409.606.409.333 0 .539-.108.457-.241-.082-.132.038-.303.266-.379.257-.086.186-.226-.188-.37-.409-.157-.524-.103-.356.168m-16.706.597c-.363.363-.775.557-.915.43-.141-.126-.156-.053-.033.162.239.418-.476 1.171-1.215 1.279-.488.072-.778.549-.361.597.142.016.468.204.726.417.528.438 1.491-.536 1.239-1.255-.212-.607.765-1.71 1.249-1.41.257.158.332.116.193-.109-.125-.202-.033-.446.205-.542.344-.139.344-.18.002-.202-.236-.014-.727.27-1.09.633m18.388 1.061c-.286.463.135 1.097.555.837.185-.114.528-.048.763.147.292.243.585.242.931-.003.418-.296.403-.324-.086-.167-.326.104-.69.03-.81-.164-.12-.194-.452-.262-.738-.153-.361.139-.459.041-.32-.321.225-.585.03-.701-.295-.176m-17.431 2.342c.382.268.385.357.018.48-.335.111-.309.205.099.362.38.145.525.037.469-.349-.046-.308-.301-.619-.569-.691-.405-.109-.407-.075-.017.198m-5.617.96c-.365.267-.51.485-.322.485.187 0 .527-.186.754-.413.229-.23.413-.26.413-.069 0 .189-.168.513-.374.719-.27.269-.255.448.053.638.259.16.34.123.206-.094-.122-.197.007-.549.287-.781.419-.348.561-.283.801.366.292.787.292.787.485.051.106-.406.092-.71-.03-.676-.123.033-.535-.113-.917-.325-.533-.297-.846-.274-1.356.099m-1.048 1.518c.117.189.042.344-.166.344-.243 0-.219.171.066.478.293.316.521.356.67.118.282-.45-.014-1.284-.455-1.284-.181 0-.232.154-.115.344m4.819.688c.343.379.702.689.799.689.097 0 .074-.102-.05-.227-.125-.124-.034-.473.201-.774.378-.485.358-.494-.175-.076-.395.309-.603.339-.603.086a.393.393 0 00-.397-.386c-.226 0-.128.298.225.688m19.988-.381c-.129.21-.062.381.15.381.211 0 .293.148.181.329-.112.181-.43.243-.707.136-.277-.106-.433-.306-.348-.443.085-.138-.073-.251-.352-.251-.388 0-.344.174.19.742.384.409.619.848.523.976-.097.128-.074.156.051.063.124-.093.473.023.774.258.485.378.494.358.076-.175-.34-.433-.37-.726-.106-1.044.205-.247.243-.642.085-.897-.197-.319-.352-.342-.517-.075m-25.754 1.496c-.331.41-.597.909-.591 1.107.006.198.222.081.481-.261.44-.58.494-.558.823.345.403 1.106.497.133.113-1.175l-.223-.763-.603.747m-.075 1.622c-.127.205-.36.292-.519.194-.159-.098-.206.138-.105.525.184.703.185.703.692-.022.279-.398.43-.802.335-.897-.095-.095-.277-.005-.403.2m-1.371 3.201c-.145.332-.145.874 0 1.205.249.574.269.574.406 0 .243-1.016-.076-1.963-.406-1.205m4.081.92c.023.586.245.849.746.885.625.044.667-.047.344-.739l-.369-.79-.207.766c-.204.752-.211.75-.378-.095l-.17-.861.034.834m25.11.183c-.218.236-.278.621-.134.855.18.29.328.175.469-.365.25-.955.183-1.053-.335-.49m-27.617 6.807c.37.69 1.065.678 1.202-.022.045-.23.003-.259-.094-.065-.26.525-.908.427-.703-.106.097-.253-.033-.459-.289-.459-.35 0-.378.162-.116.652m.38 1.587c-.336.214-.284.418.224.878.613.555 1.509.186.938-.386-.114-.114-.209.013-.212.281-.005.407-.058.404-.326-.02-.212-.334-.181-.596.091-.769.227-.144.257-.262.068-.262s-.542.125-.783.278m29.074.53c-.198.515.37 1.253.952 1.236.198-.005.096-.164-.227-.353-.324-.189-.501-.57-.393-.85.107-.279.117-.507.022-.507s-.254.213-.354.474m-21.453 1.331c.107.703.574 1.294 1.014 1.282.225-.005.135-.17-.2-.365-.335-.195-.526-.49-.425-.654.102-.165.041-.388-.134-.497-.176-.109-.291-.003-.255.234m17.728.369c-.521.719-.521.776.001.776.343 0 .583-.307.612-.787.059-.948.084-.949-.613.011m-23.641 1.289c.079.238.514.489.966.558.925.141.874.044-.296-.566-.65-.338-.785-.337-.67.008m26.089-.139c.194.097.353.304.353.461 0 .325-.669.274-1.261-.096-.258-.161-.359-.036-.285.354.064.332.128.823.142 1.092.031.569.543.164.543-.431 0-.221.232-.401.516-.401.627 0 .695-.939.078-1.065-.242-.048-.28-.01-.086.086m-21.546 2.808c.119.192.022.439-.216.548-.238.109-.065.105.385-.008.545-.137.74-.08.584.172-.147.238-.031.299.316.166.625-.239.631-.229-.468-.802-.449-.234-.719-.268-.601-.076m2.119 1.763c-.134.216-.008.276.316.152.391-.15.48-.055.326.348-.117.305-.055.555.137.555.457 0 .291-1.13-.189-1.291-.203-.067-.468.039-.59.236M65.404 250.71c0 .059.504.563 1.119 1.119l1.119 1.011-1.011-1.119c-.942-1.043-1.227-1.277-1.227-1.011"
        ></path>
      </g>
    </svg>
  );
}

export default Icon;