import React from "react";

function Icon() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="400"
      height="200"
      version="1.1"
      viewBox="0 0 400 400"
    >
      <g fillRule="evenodd" stroke="none">
        <path
          fill="#355367"
          d="M349.577 138.282c-5.751 1.282-8.676 4.019-11.826 11.069-.693 1.551-.51 11.217.252 13.303 2.55 6.982 7.519 10.489 14.888 10.506 7.808.019 13.198-3.612 10.41-7.014-1.661-2.027-1.448-1.99-3.1-.54-7.571 6.648-17.021 1.073-17.021-10.042 0-10.697 9.53-16.459 16.6-10.036l.984.893 1.556-1.768c1.881-2.137 1.876-2.055.225-3.505-3.214-2.822-8.21-3.926-12.968-2.866m-104.831.707c-.11.288-.148 1.349-.084 2.357l.117 1.834 4.885.106c2.687.058 5.057.278 5.268.488.24.24.454 5.699.571 14.57l.188 14.187 2.729.11c1.5.061 2.765.061 2.811 0 .045-.061.172-6.63.282-14.598l.199-14.487 5.08-.188 5.08-.188v-4.516l-13.462-.099c-11.212-.082-13.496-.011-13.664.424m32.081-.262c-.366.365-.297 32.961.07 33.54.218.343 1.085.455 2.911.376l2.6-.112.188-6.021.189-6.021 2.153-.112c2.119-.111 3.679.345 3.679 1.074 0 .203.397 1.002.882 1.774a98.673 98.673 0 012.131 3.661c3.558 6.43 2.88 5.833 6.629 5.833 3.785 0 3.75.234.706-4.69-1.345-2.176-2.446-4.047-2.446-4.157 0-.109-.423-.87-.94-1.689-1.281-2.03-1.199-2.452.692-3.56 8.396-4.921 6.881-16.559-2.547-19.557-1.912-.608-16.339-.898-16.897-.339m41.481.357c-.59.711-1.456 2.897-1.736 4.383-.108.571-.346 1.132-.529 1.245-.183.113-.333.466-.333.785s-.238 1.113-.529 1.765c-.291.652-.817 2.032-1.168 3.067-.674 1.98-.935 2.685-1.67 4.5-.248.612-.786 2.136-1.196 3.387-.41 1.25-.884 2.533-1.053 2.85-.17.317-.428 1.12-.574 1.783-.145.664-.421 1.303-.612 1.421-.191.118-.347.524-.347.902s-.253 1.172-.562 1.765c-.31.593-.564 1.341-.565 1.661-.001.321-.158.744-.349.941-.191.197-.465 1-.61 1.785l-.262 1.428 2.955-.111 2.955-.11 1.343-3.952c2.11-6.204 1.327-5.644 7.889-5.644 6.517 0 5.809-.466 7.576 4.986 1.633 5.039 1.399 4.798 4.666 4.798 2.549 0 2.809-.069 2.809-.745 0-.752-.796-3.076-2.647-7.722a14.655 14.655 0 01-.491-1.505c-.105-.414-.728-2.192-1.384-3.951a209.415 209.415 0 01-1.509-4.139c-.173-.518-.851-2.38-1.505-4.14a221.631 221.631 0 01-1.506-4.139c-.681-2.034-2.623-7.221-2.827-7.552-.396-.641-5.664-.423-6.229.258m51.965 16.508v17.127h10.872c12.068 0 11.329.169 11.329-2.59 0-2.272-.11-2.302-8.501-2.302-8.875 0-8.056.536-8.056-5.268 0-5.748-.595-5.267 6.532-5.274 7.154-.007 7.095.016 6.942-2.664l-.115-2.034-6.45-.103c-7.504-.119-6.899.317-6.898-4.977.001-4.418-.609-4.107 8.285-4.225l7.697-.102v-4.516l-10.819-.1-10.818-.1v17.128m-79.268-11.672c4.262 1.018 5.922 4.353 4.022 8.078-1.315 2.577-7.369 4.291-11.497 3.255l-.934-.234v-5.431c0-4.775.08-5.476.659-5.814.943-.549 5.174-.469 7.75.146m30.887 3.049c.325.326.592.831.592 1.124 0 .668 2.134 7.281 2.63 8.148.84 1.469.137 1.802-3.8 1.802-4.079 0-4.355-.22-3.386-2.71.185-.476.644-1.881 1.02-3.122.376-1.242.795-2.427.931-2.634.137-.207.363-1.012.503-1.788.278-1.542.608-1.721 1.51-.82M36.757 191.627a243.938 243.938 0 00-2.14 4.61 391.274 391.274 0 01-2.062 4.516 683.215 683.215 0 00-2.075 4.515 917.34 917.34 0 01-4.309 9.407 313.745 313.745 0 00-1.814 3.952 492.888 492.888 0 01-4.407 9.595 306.718 306.718 0 00-2.265 4.892 894.738 894.738 0 01-3.948 8.655 962.466 962.466 0 00-2.071 4.515 823.308 823.308 0 01-2.428 5.268 321.672 321.672 0 00-1.814 3.951 784.986 784.986 0 01-3.679 8.091c-1.863 4.028-1.081 10.73 1.668 14.299 5.889 7.644 15.373 8.685 22.639 2.484 1.396-1.191 3.125-2.571 7.32-5.845a440.569 440.569 0 003.763-2.958c.31-.254 2.511-1.982 4.891-3.84 2.38-1.857 4.412-3.465 4.516-3.572.103-.106 1.416-1.167 2.916-2.357l5.456-4.325c1.501-1.19 2.813-2.255 2.917-2.368.103-.112 2.05-1.635 4.327-3.384 2.277-1.749 4.478-3.464 4.892-3.811.414-.346 2.192-1.76 3.951-3.142a515.767 515.767 0 004.196-3.324c.548-.446 3.164-2.505 5.812-4.574 2.649-2.07 5.502-4.398 6.341-5.174l1.525-1.41-1.402-1.224a93.435 93.435 0 00-3.339-2.728 181.354 181.354 0 01-2.622-2.07 98.603 98.603 0 00-1.902-1.505c-.668-.518-1.397-1.118-1.62-1.335-.222-.217-1.42-1.148-2.662-2.07-1.241-.921-2.427-1.862-2.634-2.089-.207-.228-1.053-.906-1.881-1.506-.828-.6-1.675-1.279-1.882-1.51-.207-.23-1.392-1.16-2.634-2.067-1.241-.907-2.342-1.739-2.446-1.849-.103-.11-.95-.783-1.881-1.497-.931-.714-1.778-1.391-1.882-1.505-.103-.114-.95-.792-1.881-1.505-.931-.714-1.778-1.391-1.882-1.506-.103-.114-.95-.794-1.881-1.511-2.358-1.816-2.591-2.001-3.185-2.534-.288-.258-.607-.47-.708-.47-.101 0-.909-.677-1.797-1.505-.888-.828-1.761-1.505-1.94-1.505-.179 0-.543-.212-.808-.471-.743-.725-4.004-3.415-4.885-4.03a12.414 12.414 0 01-1.291-1.04c-2.998-2.929-3.519-2.892-5.073.366m283.708.747c-1.281 4.78-1.108 4.858 10.485 4.722l9.031-.106v-5.268l-9.644-.101-9.644-.1-.228.853m-60.822 10.742c-3.155 1.251-2.998.859-3.005 7.497-.007 7.331-.74 8.766-4.477 8.766-4.72 0-5.846-1.924-6.001-10.254l-.125-6.679h-.915c-.504 0-1.21.149-1.569.33-.36.182-1.289.603-2.065.935l-1.411.604v5.858c0 7.654-.807 9.206-4.785 9.206-4.558 0-5.751-2.158-5.751-10.404v-6.529h-.946c-.52 0-1.24.152-1.599.338-.359.185-1.373.634-2.253.997l-1.599.661v11.56c0 13.226-.1 13.741-3.182 16.454-4.52 3.979-19.347 3.87-23.466-.172-2.982-2.928-3.446-4.953-3.451-15.069-.003-4.604-.153-8.372-.335-8.372-.182 0-1.409.405-2.728.901l-2.398.901-.101 8.718c-.083 7.151.006 9.035.494 10.482 1.5 4.445 4.719 8.095 8.721 9.891l2.433 1.092H217.496l2.434-1.15c4.757-2.248 8.172-7.113 9.23-13.149.627-3.577.68-3.624 2.75-2.468 3.507 1.958 7.912 1.265 11.022-1.733l1.54-1.484 1.847 1.459c4.679 3.696 9.927 3.701 13.912.012l1.154-1.067 1.668 1.271c2.337 1.78 5.072 2.128 16.721 2.128 13.383 0 14.674-.395 17.467-5.344l1.16-2.054v-7.38c0-8.445.175-8.055-3.02-6.724l-2.437 1.016-.199 5.445c-.333 9.082.407 8.644-14.627 8.644-16.072 0-15.465.375-15.465-9.537 0-7.172.168-6.858-3.01-5.597m87.676-.333c-.311.161-1.242.617-2.07 1.013l-1.505.72-.188 5.96-.188 5.96-1.056.907-1.056.907h-12.057c-16.091 0-15.818.123-16.123-7.281l-.188-4.572-1.129.049c-.621.027-1.744.286-2.496.576-2.709 1.044-2.584.506-2.584 11.105 0 8.119-.093 9.75-.616 10.772-2.053 4.015-5.286 5.984-10.202 6.216-3.364.158-3.528.299-2.543 2.189.31.593.569 1.332.577 1.642.04 1.598.925 1.965 4.387 1.819 7.788-.328 12.748-5.605 14.442-15.365.577-3.328.856-3.613 2.394-2.448 2.266 1.716 24.043 2.481 28.514 1.002 4.642-1.536 6.311-5.503 6.317-15.017l.004-6.491-1.035.022c-.569.012-1.289.154-1.599.315M270.06 230.16c-.142.141-.258 1.329-.258 2.64v2.383h19.602l-.111-2.54-.111-2.54-9.433-.1c-5.188-.055-9.548.015-9.689.157"
        ></path>
      
        <path
          fill="#a1aab3"
          d="M87.488 94.398c-4.659.862-8.666 4.472-11.451 10.319-2.32 4.87-4.541 9.693-4.541 9.859 0 .071-.863 1.964-1.918 4.206a374.122 374.122 0 00-2.498 5.395c-.318.724-1.049 2.333-1.623 3.575a1979.535 1979.535 0 00-6.377 13.923 593.827 593.827 0 01-2.076 4.515c-1.546 3.325-3.458 7.509-4.212 9.219-.319.725-1.152 2.545-1.851 4.045-4.173 8.963-4.147 8.905-6.379 13.829a807.963 807.963 0 01-5.196 11.193c-.955 2.018-1.737 3.838-1.737 4.046a.378.378 0 01-.376.377c-.207 0-.376.199-.376.441s-.489 1.47-1.086 2.728a980.069 980.069 0 00-2.487 5.298 488.457 488.457 0 01-2.544 5.37c-.629 1.297-1.056 2.446-.949 2.553.195.195.495-.378 2.379-4.536 2.261-4.993 4.723-10.223 5.315-11.289 1.512-2.727 6.521-13.108 6.521-13.516 0-.166 1.814-4.169 3.764-8.309 3.103-6.588 4.139-8.847 4.139-9.025 0-.109.781-1.848 1.736-3.865 2.123-4.484 4.14-8.807 5.047-10.817a795.786 795.786 0 014.208-9.219l2.196-4.704c2.082-4.458 3.746-8.148 3.746-8.306 0-.089.825-1.897 1.833-4.018a451.773 451.773 0 002.684-5.738c3.631-8.031 4.52-9.902 5.078-10.693 1.169-1.657 4.076-4.171 5.679-4.912a106.9 106.9 0 002.5-1.185c1.83-.927 7.826-.378 10.641.976 2.517 1.211 6.956 5.176 6.956 6.213 0 .373 1.924 4.62 4.36 9.627.914 1.877 1.661 3.531 1.661 3.676 0 .146.697 1.743 1.55 3.55 3.263 6.917 5.889 12.588 7.009 15.138.568 1.293 2.07 4.558 4.327 9.407a378.826 378.826 0 011.978 4.327c2.08 4.658 2.101 4.705 6.35 13.829a320.371 320.371 0 011.935 4.234c.365.827 1.217 2.69 1.893 4.139a823.665 823.665 0 012.43 5.268c1.936 4.244 3.378 7.393 4.306 9.407 2.007 4.351 2.008 4.425.084 5.738-.682.466-1.568 1.147-1.969 1.515-.402.368-1.831 1.503-3.176 2.523-1.345 1.02-2.531 1.951-2.634 2.07-.104.118-.95.801-1.882 1.517-.931.716-1.88 1.474-2.108 1.684-.228.21-2.166 1.736-4.308 3.392-2.141 1.655-4.918 3.857-6.17 4.891-1.253 1.035-2.955 2.384-3.782 2.997-.828.614-1.703 1.291-1.943 1.505-.241.215-.991.814-1.666 1.331-.675.517-1.409 1.115-1.632 1.329-.222.213-1.505 1.221-2.85 2.24-1.345 1.019-2.53 1.949-2.634 2.068-.103.118-.949.803-1.88 1.522-.931.719-2.031 1.59-2.446 1.935-.415.345-2.193 1.752-3.952 3.127l-3.771 2.948c-.314.246-1.246.941-2.069 1.545-.824.604-2.599 1.969-3.944 3.032a11016.54 11016.54 0 01-6.961 5.499 6977.282 6977.282 0 00-9.972 7.892 13230.619 13230.619 0 01-19.044 15.083c-2.713 2.143-7.94 6.267-11.617 9.165-3.677 2.897-8.061 6.408-9.743 7.801-3.2 2.651-5.671 4.096-8.514 4.98-1.601.498-1.628.528-.493.552.661.014 1.306-.144 1.433-.351.128-.207.505-.376.836-.376.877 0 4.53-2.385 6.646-4.34.231-.213 1.521-1.221 2.867-2.24 1.345-1.018 2.53-1.945 2.634-2.06.103-.114.808-.67 1.566-1.235.758-.564 1.605-1.241 1.882-1.503.276-.261 1.519-1.238 2.76-2.169 1.242-.931 2.428-1.88 2.634-2.108.207-.227 1.051-.905 1.876-1.505 1.707-1.242 9.465-7.389 13.176-10.44.621-.51 2.568-2.052 4.328-3.427a762.085 762.085 0 004.327-3.4 169.63 169.63 0 013.01-2.313c1.035-.776 1.966-1.51 2.07-1.631.103-.12.95-.807 1.88-1.526.931-.719 2.031-1.59 2.446-1.935.746-.62 5.955-4.733 8.431-6.657.704-.546 2.208-1.741 3.341-2.653 2.322-1.87 2.162-1.892 5.351.719 1.49 1.22 6.353 5.077 15.804 12.534a2779.03 2779.03 0 014.139 3.27l4.139 3.273c1.553 1.227 6.209 4.919 10.349 8.206 4.139 3.287 8.795 6.975 10.348 8.197a267.376 267.376 0 013.574 2.85 73.42 73.42 0 002.247 1.751c.821.617 3.271 2.547 5.444 4.287 9.45 7.57 13.646 8.448 21.324 4.46 5.853-3.039 9.338-12.044 6.957-17.973-1.048-2.608-3.209-7.399-5.728-12.699-1.009-2.121-1.833-3.929-1.833-4.018 0-.173-1.93-4.408-3.958-8.682-1.88-3.965-3.945-8.503-3.945-8.67 0-.082-.827-1.89-1.837-4.018a452.34 452.34 0 01-2.858-6.127c-.561-1.242-1.428-3.147-1.925-4.233a4405.93 4405.93 0 01-3.915-8.561c-.66-1.449-1.763-3.82-2.451-5.268a343.734 343.734 0 01-3.006-6.585c-.965-2.173-1.995-4.443-2.288-5.044-.294-.601-.534-1.226-.534-1.389 0-.163-.678-1.755-1.505-3.539-.828-1.784-1.506-3.305-1.506-3.382 0-.147-1.749-3.978-4.212-9.224-3.042-6.477-4.582-9.824-6.323-13.735a357.98 357.98 0 00-2.154-4.703c-.724-1.553-1.618-3.5-1.986-4.328a495.574 495.574 0 00-4.228-9.219c-1.976-4.205-3.803-8.149-4.53-9.784a456.995 456.995 0 00-3.753-8.278 544.7 544.7 0 01-2.166-4.704 2241.43 2241.43 0 00-4.205-9.219c-4.258-9.294-5.77-11.297-10.152-13.455-2.644-1.302-7.131-1.856-10.289-1.272m263.218 42.827c-.725.097-1.487.346-1.694.555-.252.254.12.276 1.129.067 1.928-.399 4.531-.394 6.209.013.919.223 1.203.199.941-.077-.436-.459-4.651-.816-6.585-.558m-156.324 1.466c-.325.325-.591.884-.591 1.242s-.147.811-.328 1.008c-.18.196-.638 1.373-1.017 2.615-.379 1.242-.908 2.681-1.175 3.198-.267.518-.487 1.155-.488 1.417-.001.261-.157.769-.345 1.129-.189.359-.628 1.5-.976 2.534-.349 1.035-.872 2.415-1.163 3.068-.291.652-.529 1.374-.529 1.604 0 .23-.148.713-.33 1.072-.802 1.586-1.551 3.546-1.551 4.058 0 .306-.16.851-.356 1.21-.196.359-.729 1.754-1.183 3.099-1.298 3.837-1.689 4.859-1.966 5.136-.6.6-.235 1.932.589 2.153 2.737.734 5.852.118 6.171-1.219.129-.544.339-1.159.466-1.366.126-.207.738-1.9 1.359-3.763l1.129-3.386 5.554-.105 5.553-.104.42 1.045c1.388 3.455 2.208 5.89 2.208 6.557 0 1.641 1.455 2.578 4.003 2.578 3.896 0 4.333-.613 2.815-3.951-.188-.414-.63-1.599-.982-2.634-.351-1.035-.877-2.415-1.168-3.067-.291-.652-.529-1.374-.529-1.604 0-.231-.155-.713-.343-1.072-.189-.36-.625-1.5-.97-2.535-.345-1.035-.771-2.22-.947-2.634-.176-.414-.659-1.776-1.072-3.026-.414-1.251-.955-2.775-1.203-3.387l-.753-1.866c-.167-.414-.678-1.853-1.137-3.198-2.277-6.681-2.029-6.397-5.603-6.397-2.198 0-3.124.153-3.562.591m21.516-.372c-.606.607-.33 34.267.285 34.778.76.63 12.354.256 15.238-.491 8.412-2.182 12.585-8.937 11.846-19.173-.533-7.379-3.592-11.747-10-14.277-2.109-.832-16.672-1.535-17.369-.837m28.392.232c-.249.249-.452 1.315-.452 2.371 0 2.74.168 2.822 5.72 2.822h4.816v13.898c0 16.972-.277 15.892 4.042 15.75l3.296-.109.009-14.487.009-14.487-.197 14.299-.197 14.299h-6.021l-.188-14.299c-.103-7.865-.325-14.511-.493-14.77-.217-.336-1.691-.47-5.174-.47h-4.869v-2.415c0-1.579.162-2.48.47-2.604.259-.104.293-.203.075-.22-.217-.016-.598.174-.846.422m27.511-.003c.541.409.657.938.564 2.573l-.117 2.059-4.885.106c-2.686.058-5.007.227-5.156.376-.15.149 2.133.186 5.073.082l5.345-.188v-2.629c0-2.334-.085-2.644-.753-2.762-.715-.126-.719-.107-.071.383m4.571.022c-.099.259-.136 8.175-.083 17.592l.099 17.121 2.974.111c3.878.145 3.765.327 3.987-6.431l.188-5.721 1.585-.115c1.728-.126 3.119.414 3.119 1.211 0 .278.282.737.626 1.021.572.473.584.436.14-.424-1.013-1.959-1.521-2.258-3.835-2.258h-2.199l-.006 5.739c-.007 6.986.118 6.744-3.414 6.603l-2.789-.112v-17.404c0-9.572-.048-17.403-.106-17.403-.058 0-.187.211-.286.47m15.841-.124c4.237.682 7.163 2.659 8.678 5.863.489 1.034.891 1.598.893 1.253.018-3.097-5.148-7.12-9.404-7.324l-2.07-.099 1.903.307m25.454.105c-.248.249-.446.714-.44 1.035.008.433.122.389.438-.169.235-.414.611-.877.835-1.029.273-.185.278-.279.014-.283-.218-.003-.599.198-.847.446m6.757-.065c.342.2.931 1.338 1.308 2.529.387 1.224.743 1.871.819 1.488.074-.372-.026-.88-.222-1.129-.195-.249-.476-.958-.625-1.577-.266-1.111-.794-1.691-1.527-1.68-.207.003-.096.169.247.369m20.825.587c-.828.491-1.717.999-1.975 1.129-.259.13-.471.399-.471.598 0 .199.466.035 1.035-.364.962-.674 2.914-1.635 4.233-2.085.311-.105.142-.187-.376-.182-.517.006-1.618.413-2.446.904m14.723.144c3.097 1.548 4.613 3.148 3.837 4.05-2.995 3.484-3.193 3.606-4.089 2.526-.267-.322-.839-.756-1.269-.965-.497-.24-.333.043.445.773.676.635 1.46 1.153 1.742 1.153.559 0 3.99-3.595 3.99-4.181 0-1.025-4.804-4.473-6.233-4.473-.363 0 .346.503 1.577 1.117m9.623-.666c-.649.65-.649 33.819 0 34.469.645.645 22.535.645 23.18 0 .554-.554.597-4.218.062-5.218-.366-.684-.864-.728-8.267-.728h-7.878l-.123-4.797-.124-4.798.018 4.892.019 4.891 7.822.189c8.708.209 8.53.15 8.541 2.844.011 2.922.434 2.825-11.848 2.712l-10.912-.1-.098-17.097c-.077-13.428.004-17.161.376-17.398.261-.165.296-.303.079-.307-.217-.003-.598.198-.847.446m22.439 2.192l.125 2.608-7.18.115-7.181.115 7.244-.013 7.244-.012.113-2.408c.063-1.324-.022-2.544-.188-2.711-.166-.167-.245.871-.177 2.306m-190.976-1.044c1.041 2.404 1.454 3.481 2.195 5.723.414 1.25.889 2.612 1.056 3.026 1.07 2.645 2.633 6.944 3.968 10.912.348 1.035.787 2.176.976 2.535.188.36.342.842.342 1.072 0 .23.269 1.037.596 1.793.328.755.836 1.93 1.129 2.609.293.68.533 1.465.533 1.745 0 .279.241.972.535 1.539.876 1.688.442 2.066-2.371 2.066-2.864 0-3.02-.167-4.406-4.704-.379-1.242-.799-2.427-.934-2.634-.135-.207-.352-.822-.482-1.366-.311-1.305-.972-1.445-6.865-1.451-5.338-.006-5.766.146-6.34 2.253a19.97 19.97 0 01-.553 1.693c-.687 1.744-1.25 3.447-1.431 4.327-.293 1.421-1.16 1.882-3.543 1.882-2.59 0-2.778-.22-1.991-2.327.334-.893.695-2.092.803-2.664.107-.571.345-1.132.528-1.245.184-.113.334-.492.336-.842.001-.35.255-1.121.564-1.714.309-.593.562-1.293.562-1.556 0-.263.253-.964.562-1.557.31-.592.564-1.346.565-1.673.001-.328.118-.712.26-.854.274-.274.638-1.22 1.972-5.136.93-2.727 1.157-3.324 2.045-5.374.34-.784.617-1.747.617-2.142 0-.395.169-.822.376-.95s.378-.519.379-.869c.001-.35.255-1.121.564-1.714.309-.593.562-1.342.562-1.664 0-2.339 5.924-2.974 6.891-.739m30.553-.36c7.718 2.261 11.067 7.117 11.08 16.07.016 9.976-4.46 15.674-13.274 16.9-4.753.662-12.915.546-13.196-.185-.333-.867-.281-33.093.054-33.434.485-.496 13.276.046 15.336.649m84.934 2.041c-1.475 3.905-2.34 6.383-2.338 6.699.004.598.892-1.351 1.633-3.582.378-1.139.87-2.451 1.094-2.916.225-.465.318-.936.207-1.047-.11-.11-.379.27-.596.846m24.207 1.316c-1.484 1.733-3.611 5.707-3.563 6.659.025.508.06.513.232.034.626-1.742 2.621-5.293 3.752-6.68 1.69-2.071 1.35-2.082-.421-.013m-118.457.674c-.778.487-1.026 22.69-.269 24.105.711 1.327 6.778.825 9.841-.815 5.905-3.16 7.124-15.174 2.088-20.571-2.064-2.211-9.643-3.979-11.66-2.719m104.352.003c-.037.293 1.421 4.2 1.654 4.433.325.325.234-.624-.128-1.339a57.015 57.015 0 01-.917-1.97c-.322-.725-.596-1.23-.609-1.124m22.546.728c-1.582.837-3.255 2.45-3.965 3.823-.809 1.566-1.664 4.213-1.627 5.039.018.414.282-.094.585-1.129 1.665-5.674 4.259-7.95 9.342-8.193l2.634-.126-2.822-.057c-2.111-.043-3.157.12-4.147.643m-119.992.046c5.962 1.877 8.689 7.966 6.861 15.324-1.363 5.488-4.25 7.706-10.098 7.76l-3.386.031-.1-11.759-.099-11.759h2.771c1.524 0 3.347.181 4.051.403m54.242-.154c-.346.14-.47 1.627-.47 5.615v5.425l3.292-.006c6.225-.011 9.125-1.864 9.125-5.833 0-2.197-1.695-4.705-3.17-4.689-.6.007-.487.154.491.635 2.167 1.068 2.95 4.346 1.599 6.694-.966 1.679-2.906 2.461-6.718 2.708-4.342.281-4.298.338-4.161-5.395l.106-4.462 3.951-.188c3.18-.152 3.657-.243 2.446-.467-1.672-.308-5.759-.332-6.491-.037m92.93 3.796c-.078 4.175-.068 4.233.767 4.19.617-.032.672-.09.201-.213-.55-.145-.664-.77-.767-4.19l-.121-4.02-.08 4.233m-180.844 3.505c-2.385 7.111-2.444 6.911 2.062 7.044 4.067.121 4.978-.295 4.178-1.907-.228-.458-.941-2.527-1.585-4.597-2.23-7.166-2.424-7.189-4.655-.54m106.329-2.282c-.005 1.964.058 2.231.32 1.355.182-.608.185-1.691.006-2.446-.284-1.198-.322-1.073-.326 1.091m-103.354-.094c.349.983.767 2.126.928 2.54 2.204 5.668 2.044 6.209-1.835 6.209-3.694 0-3.624.235-1.669-5.588.878-2.618 1.604-4.802 1.612-4.854.068-.443.431.195.964 1.693m122.098-1.115c0 .421.281.672.753.672.894 0 1.006-.79.157-1.116-.855-.328-.91-.301-.91.444m7.905.696c-.004.697 1.095 3.015 1.111 2.344.008-.339-.238-1.101-.547-1.694-.309-.592-.563-.885-.564-.65m-15.081 1.499c-.237.596-.56 1.343-.719 1.661-.158.317-.407 1.119-.553 1.783-.145.663-.421 1.303-.612 1.421-.191.118-.346.585-.345 1.039.003 1.129.66-.176 1.668-3.315.399-1.242.888-2.474 1.086-2.737.199-.264.259-.582.134-.707-.126-.126-.422.26-.659.855m6.338.708c-.327 1.034-.724 2.205-.883 2.601-.193.483-.153.637.123.466.226-.139.529-.802.672-1.473.143-.67.424-1.422.624-1.67.2-.249.295-.757.211-1.129-.095-.422-.376.032-.747 1.205m2.371-1.129c-.001.787 1.065 2.95 1.088 2.207.007-.235-.234-.997-.537-1.694-.379-.874-.55-1.033-.551-.513m14.383 2.352c-.388 1.825-.312 6.817.119 7.879.219.541.334-.917.334-4.233 0-5.552-.018-5.698-.453-3.646m-6.885-.206c0 .293 1.495 4.178 1.678 4.361.112.112.204-.069.204-.402 0-.332-.151-.697-.334-.811-.184-.113-.444-.795-.579-1.514-.187-.998-.969-2.316-.969-1.634m59.571.748c.541.409.657.938.565 2.573l-.117 2.059-6.209.207-6.209.207 6.397-.019 6.397-.019v-2.629c0-2.334-.084-2.644-.752-2.762-.716-.126-.719-.107-.072.383m-88.12 1.247c-.681 1.888-3.047 4.412-4.933 5.262-1.693.764-1.749.876-.943 1.908.547.701.562.692.361-.211-.173-.775-.014-1.026.905-1.429 2.249-.986 5.519-4.958 5.242-6.367-.065-.326-.348.05-.632.837m22.152-.705c0 .408.163.904.363 1.103.2.2.411.953.47 1.675l.108 1.312h-5.645l.099-1.506.098-1.505-.548 1.48c-.748 2.02-.634 2.095 3.174 2.095 3.952 0 3.956-.004 2.945-2.857-.907-2.556-1.064-2.821-1.064-1.797m8.292 3.764c-.007.235.234.997.536 1.693.38.875.55 1.034.551.514.002-.788-1.064-2.951-1.087-2.207m-20.944 1.118a67.978 67.978 0 01-.762 1.982c-.519 1.294-.671 2.217-.306 1.851.362-.361 1.67-4.195 1.492-4.373-.094-.094-.285.149-.424.54m33.016.336c-.13 2.759 4.304 9.888 5.442 8.751.099-.099-.425-.639-1.163-1.202-1.468-1.12-3.177-3.573-3.223-4.625-.047-1.075-1.017-3.761-1.056-2.924m-10.798 2.291c.158.396.565 1.566.905 2.601.368 1.121.671 1.608.749 1.205.072-.372-.033-.88-.233-1.129s-.481-1-.624-1.671c-.144-.67-.446-1.333-.672-1.473-.276-.17-.317-.016-.125.467m4.376 1.272c-.029.84 1.168 3.775 1.54 3.775.181 0 .171-.296-.023-.658-.193-.363-.609-1.336-.924-2.164-.315-.828-.582-1.257-.593-.953m-40.685 1.423c.89 1.694 2.278 3.771 2.282 3.414.003-.33-2.672-4.825-2.872-4.825-.083 0 .182.635.59 1.411m12.148-.119c-.251.551-.45 1.29-.442 1.642.008.353.266.061.574-.648.66-1.52.535-2.458-.132-.994m6.514 1.324c-.315.61-.561 1.415-.546 1.787.015.372.304-.042.642-.922l.615-1.599h5.566c5.046 0 5.568.061 5.58.658.015.736 1.082 2.783 1.103 2.116.007-.234-.243-1.038-.557-1.788l-.569-1.363H315.73l-.575 1.111m-25.785-.162c0 .107.423.866.94 1.685.518.82.941 1.573.941 1.673 0 .1.778 1.464 1.73 3.031l1.729 2.849 3.633-.108 3.633-.107-.123-1.129c-.067-.621-.363-1.396-.658-1.723-.295-.326-.536-.792-.536-1.034 0-.243-.151-.441-.336-.441-.185 0-.442-.424-.572-.941-.129-.517-.398-.941-.597-.941-.199 0 .088.805.639 1.788 2.474 4.416 2.542 4.233-1.577 4.233-3.652 0-3.259.332-6.563-5.55-1.759-3.132-2.283-3.886-2.283-3.285m69.861 1.113c-1.65 1.458-4.974 2.646-6.531 2.334-.579-.116-1.562-.306-2.183-.423l-1.128-.213 1.128.549c2.374 1.155 6.386.271 9.261-2.039 1.861-1.496 2.174-1.451 3.845.549 1.621 1.939 1.531 2.476-.703 4.18-.727.555-1.23 1.101-1.116 1.215.294.294 3.577-3.003 3.577-3.592 0-.819-3.122-3.87-3.942-3.853-.419.008-1.412.59-2.208 1.293m-24.529.384c.153.414.427 1.261.609 1.882s.489 1.467.682 1.881c1.578 3.384 1.448 3.575-2.44 3.575h-3.105l-.638-1.787c-1.238-3.468-1.643-4.416-1.65-3.857-.009.681 1.135 3.995 1.785 5.174.431.78.731.846 3.852.846 3.586 0 4.365-.415 3.469-1.849-.213-.342-.507-1.164-.653-1.828-.145-.663-.421-1.302-.612-1.421-.191-.118-.353-.585-.359-1.039-.007-.453-.284-1.163-.615-1.577l-.603-.752.278.752m-27.027.1c-.411.665-1.423 3.926-1.267 4.082.088.088.517-.81.953-1.995.712-1.931.87-2.988.314-2.087m31.365.325c0 .916 4.191 5.408 5.046 5.408.197 0-.372-.625-1.265-1.389-.892-.764-2.108-2.059-2.701-2.879-.594-.819-1.08-1.332-1.08-1.14m-25.131 1.808c-.251.551-.457 1.322-.457 1.714 0 .392-.169.817-.376.945s-.376.487-.376.797c0 1.067.724.117.975-1.28.139-.769.415-1.604.615-1.856.199-.252.298-.652.219-.889-.079-.238-.349.018-.6.569m-8.367 3.621c-.689 1.663-.198 1.907 3.587 1.782 2.558-.085 3.361-.24 3.494-.674.138-.456.075-.474-.328-.094-.312.294-1.61.47-3.475.47h-2.977l.247-1.317c.304-1.623.083-1.691-.548-.167m41.161 1.298c.593.309 1.44.555 1.882.546.52-.011.272-.208-.702-.559-1.957-.705-2.544-.699-1.18.013m11.34.011c-.859.394-.949.518-.376.521.414.002 1.176-.238 1.693-.534 1.195-.683.182-.673-1.317.013m-7.526.928c.414.177 1.515.323 2.446.323.932 0 2.032-.146 2.446-.323.498-.214-.329-.324-2.446-.324-2.116 0-2.944.11-2.446.324m43.274 3.742a329.927 329.927 0 01-6.773 3.019c-2.094.897-6.132 2.759-6.962 3.212-.882.481-.947.726-1.048 3.925-.139 4.373-.368 4.347 7.148.83 1.388-.65 2.609-1.182 2.713-1.182.104 0 1.811-.758 3.793-1.684l3.604-1.683-.109-3.46c-.12-3.846-.224-3.977-2.366-2.977m2.07 3.013v2.993l-1.411.633c-.776.349-2.512 1.133-3.857 1.744a258.706 258.706 0 01-3.199 1.433c-.414.178-1.599.695-2.634 1.149-3.467 1.523-5.141 2.226-5.299 2.226-.232 0-.105-3.778.17-5.053.187-.867.677-1.318 2.307-2.123 3.108-1.533 7.105-3.36 7.353-3.36.258 0 4.246-1.779 5.065-2.259 1.315-.772 1.505-.443 1.505 2.617m-75.729 10.581c-1.018.598-.962 5.805.069 6.357.447.239 4.432.389 10.335.389 11.06 0 10.531.19 10.287-3.678l-.135-2.154-.071 2.361c-.094 3.12-.01 3.095-10.657 3.095-10.421 0-9.979.156-9.734-3.443l.188-2.766 9.549-.1c7.277-.077 9.686.012 10.127.376.478.394.546.379.392-.088-.23-.696-19.206-1.022-20.35-.349m69.144 1.542c-.621.191-2.018.628-3.105.972l-1.975.625v15.14c0 8.327.127 15.214.282 15.304.782.455 6.185-1.76 6.534-2.679.488-1.282.27-28.897-.231-29.36-.23-.212-.816-.213-1.505-.002m1.311 14.894c-.003 7.813-.13 14.376-.282 14.584-.366.503-3.812 1.695-4.891 1.692l-.851-.001.099-14.57.098-14.569 1.693-.632c.932-.347 2.244-.649 2.917-.67l1.223-.039-.006 14.205m-28.216-11.947c-.311.2-.889.367-1.285.37-.963.008-3.607 1.193-3.607 1.616 0 .285 2.592 3.169 5.467 6.082 13.108 13.284 13.092 14.101-.271 14.12-10.209.015-9.731-.307-6.98 4.717l1.236 2.257 7.33.109c10.284.153 13.874-1.304 15.325-6.217 1.536-5.203.397-7.211-10.464-18.445-4.675-4.835-5.515-5.409-6.751-4.609m3.865 2.392c11.676 11.967 12.815 13.54 12.852 17.739.058 6.733-3.556 8.8-15.436 8.829-6.495.016-6.214.142-8.077-3.605-1.441-2.9-1.785-2.778 7.823-2.778 9.643 0 9.885-.065 9.885-2.68 0-1.66-.357-2.104-8.996-11.179-5.95-6.251-6.356-6.759-5.606-7.008.27-.089 1.253-.418 2.184-.73 2.735-.917 3.224-.789 5.371 1.412m-16.827 3.219c-.139.225-.514.409-.832.409-.554 0-2.246.649-4.268 1.638-.933.456-.941.502-.957 5.526l-.016 5.066.12-4.959.121-4.959 1.777-.656c.977-.361 1.946-.774 2.153-.917 2.459-1.706 2.822-.862 2.822 6.562 0 8.411-1.023 11.575-4.578 14.15-.855.62-1.318 1.122-1.029 1.117 1.107-.021 4.855-4.149 4.855-5.346 0-.283.211-.726.47-.984.636-.636.676-15.992.043-16.627-.306-.306-.501-.312-.681-.02m-121.187.302c-.808.195-2.802.999-4.327 1.745l-.941.46-.009 10.522-.009 10.522.109-10.388.109-10.388 2.346-.96c4.691-1.919 4.415-2.304 4.415 6.164 0 7.094.134 7.573 2.499 8.968 2.072 1.223 4.679 1.062 6.118-.377l1.149-1.149.103-6.283.103-6.283 1.317-.658c1.088-.543 1.17-.658.471-.658-2.012-.002-2.352 1.016-2.352 7.028 0 7.441-.604 8.776-3.969 8.776-4.065 0-5.061-1.861-5.068-9.466-.006-7.958-.035-8.065-2.064-7.575m16.105.143c-.662.194-1.325.548-1.473.787-.189.305-.055.342.452.125.396-.171 1.26-.386 1.92-.479l1.199-.169.118 6.97c.143 8.475 1.025 10.04 5.659 10.04 3.63 0 4.43-1.686 4.43-9.332 0-6.319-.385-5.548 3.571-7.157 2.787-1.133 2.826-1.045 2.826 6.291 0 7.728.752 9.148 4.779 9.025.787-.024 1.091-.114.677-.2-4.943-1.03-4.843-.846-5.08-9.352l-.188-6.773-1.046.073c-.576.04-1.576.336-2.222.658-.646.322-1.38.586-1.631.586-.25 0-.902.351-1.447.78l-.991.78-.006 5.711c-.002 3.141-.109 6.099-.236 6.573-.494 1.848-4.019 2.562-6.175 1.251-2.286-1.39-2.409-1.834-2.614-9.446-.207-7.624-.138-7.44-2.522-6.742m52.313.087c-.657.243-1.321.569-1.473.724-.153.155-.566.282-.917.282-2.133 0-2.623 1.227-2.623 6.566 0 6.413-.143 7.103-1.636 7.847-.652.325-.932.598-.621.607 2.133.059 3.01-2.505 3.01-8.804 0-4.778.031-4.974.847-5.347 2.712-1.243 3.792-1.621 4.622-1.621h.928l.038 7.243c.021 4.216.163 6.851.338 6.303.453-1.414.442-12.721-.013-13.571-.44-.823-.802-.856-2.5-.229m14.555 3.617c-1.208.66-3.437 1.528-3.924 1.528-.533 0-1.132 1.09-.789 1.434.109.108.197.018.197-.201 0-.411 2.03-1.347 4.762-2.195 1.955-.607 1.999-.49 2.006 5.318.005 3.844.071 4.227.852 4.925 1.004.898 3.071 1.769 3.701 1.559.245-.082-.294-.394-1.2-.692-2.796-.923-2.97-1.281-2.976-6.102-.008-5.901-.422-6.78-2.629-5.574M29.068 206.68c-.225.465-1.034 2.201-1.798 3.856-.763 1.656-1.862 4.027-2.442 5.268a430.927 430.927 0 00-2.07 4.516 465.281 465.281 0 01-1.588 3.494c-.315.68-.488 1.32-.386 1.423.103.103.41-.369.682-1.048.273-.679 1.327-3.013 2.344-5.186s2.359-5.052 2.983-6.397a301.07 301.07 0 012.096-4.422c.529-1.087.878-2.061.775-2.164-.102-.102-.371.194-.596.66m162.089 1.767c-.31.183-1.411.656-2.446 1.051l-1.881.718-.101 8.809c-.114 9.864.215 11.828 2.544 15.214 2.531 3.678 7.065 6.991 9.514 6.952.491-.008.032-.304-1.109-.715-3.558-1.281-7.19-4.409-8.767-7.55-1.754-3.495-1.913-4.699-1.806-13.719.109-9.246-.027-8.649 2.171-9.521.517-.205 1.414-.564 1.993-.796 2.149-.864 2.068-1.192 2.211 8.89.211 14.779 1.825 16.73 14.034 16.959 10.209.192 15.404-2.529 15.226-7.974-.015-.44-.283.046-.595 1.081-1.469 4.859-5.138 6.585-14.005 6.585-6.792 0-9.715-.844-11.903-3.436-1.863-2.207-1.872-2.261-2.07-12.745l-.188-9.972-1.129-.081c-.62-.045-1.382.068-1.693.25m151.542 7.15c-.105.404-.76 1.081-1.455 1.504-.859.524-1.047.771-.587.772.827.001 2.523-1.63 2.523-2.428 0-.806-.251-.727-.481.152m-44.251 1.713c-.089 1.235-2.203 4.588-3.522 5.587-2.608 1.975-4.538 2.209-16.774 2.029-11.855-.174-13.418-.381-15.143-2.007-1.124-1.059-1.944-1.148-2.656-.29-3.041 3.663-9.667 3.574-14.393-.194l-1.453-1.159-1.456 1.38c-.8.759-1.372 1.463-1.269 1.565.102.103.742-.352 1.421-1.011 1.479-1.433 1.697-1.453 2.826-.262 3.224 3.4 9.519 3.764 13.577.785l1.901-1.395 1.231.906c2.609 1.92 3.003 1.968 16.313 1.968h12.446l2.06-1.042c2.38-1.204 5.409-5.217 5.109-6.77-.143-.738-.17-.749-.218-.09m-23.45.845c2.547.065 6.611.065 9.031 0 2.42-.066.336-.119-4.631-.119-4.967 0-6.947.054-4.4.119m49.484 0c2.858.064 7.43.064 10.16 0 2.729-.064.391-.117-5.197-.116-5.588 0-7.822.052-4.963.116m-11.558 7.903c-.347 1.811-.768 3.632-.937 4.045-2.284 5.617-5.39 8.92-9.853 10.483-1.209.423-1.415.587-.753.6 2.282.045 7.969-4.478 9.504-7.559 1.566-3.143 1.82-3.941 2.631-8.247l.393-2.09 1.935.961 1.936.961h12.681c10.323 0 12.772-.097 13.17-.522.412-.439.341-.473-.451-.213-4.076 1.337-26.494.417-28.236-1.159-1.093-.989-1.379-.601-2.02 2.74m-83.147-1.505c-.469 2.452-.61 4.417-.263 3.669.192-.414.36-1.378.375-2.141.036-1.888.451-2.02 2.83-.894 2.632 1.245 8.485.881 8.485-.528 0-.154-1.045.06-2.323.474-2.573.833-4.867.543-7.261-.917-1.49-.908-1.609-.886-1.843.337M18.993 228.66a662.579 662.579 0 01-2.852 5.973c-.806 1.663-1.462 3.272-1.457 3.575.009.595.058.5 3.181-6.223 1.154-2.484 2.275-4.828 2.491-5.211.216-.382.309-.778.208-.879-.101-.102-.808 1.143-1.571 2.765m286.57-.665c-1.299 3.937-5.463 6.436-10.725 6.436-2.073 0-2.837.291-2.823 1.075.01.548.055.544.395-.04.303-.521.897-.659 2.834-.659 5.368 0 11.631-4.466 10.983-7.832-.067-.344-.365.115-.664 1.02m-36.137 1.544c-1.088 1.088-1.077 4.944.018 6.039 1.021 1.021 19.665 1.004 20.31-.018.612-.969.448-5.511-.223-6.182-1.017-1.017-19.072-.872-20.105.161m-40.61-.046c-.198 3.454-5.559 9.409-9.867 10.959-1.109.399-1.656.731-1.217.739 2.344.039 9.549-5.461 9.549-7.291 0-.329.127-.599.282-.599.43-.003 1.695-3.303 1.475-3.848-.145-.362-.199-.352-.222.04m60.757.913c.12.477.165 1.789.101 2.916l-.116 2.05h-19.944l-.113-2.407c-.175-3.714-1.021-3.426 10.066-3.426h9.788l.218.867m2.822 6.543c-.008.453.133.915.313 1.027.18.111.436.745.569 1.408.476 2.384 3.683 3.462 6.441 2.166.508-.239-.12-.285-1.934-.143-2.755.216-4.275-.594-4.275-2.28 0-.936-1.098-3.083-1.114-2.178m-278.472 2.373c0 .375-1.477 3.704-3.298 7.433-.531 1.087-.883 2.058-.783 2.159.165.165 1.583-2.711 3.942-7.992.485-1.087.715-1.976.51-1.976a.375.375 0 00-.371.376m186.561 2.326c.355.141 3.862.256 7.794.256 3.933 0 7.44-.115 7.795-.256.354-.141-3.153-.256-7.795-.256-4.641 0-8.148.115-7.794.256M8.439 251.6a430.811 430.811 0 01-1.898 4.128c-.493 1.055-.897 2.113-.897 2.352 0 .238-.155.434-.346.434-.191 0-.458.506-.593 1.124-.136.619-.404 1.221-.595 1.339-.191.119-.338.501-.327.851.021.652 1.013-1.286 3.721-7.265.843-1.863 1.713-3.7 1.932-4.082.22-.383.311-.785.202-.893-.109-.109-.649.796-1.199 2.012m-5.398 11.748c-.224.419-.407 1.1-.407 1.516 0 .415-.169.859-.376.987-.491.304-.491 6.847 0 7.15.207.128.376.556.376.951 0 2.336 4.402 7.534 7.774 9.181 1.209.59 2.492 1.218 2.851 1.397.36.178 1.037.307 1.505.286.542-.025.167-.27-1.029-.672-9.169-3.083-14.53-13.933-10.214-20.67.174-.272.229-.583.122-.69-.107-.108-.378.146-.602.564m13.61 21.776c.569.086 1.5.086 2.07 0 .569-.087.103-.157-1.035-.157s-1.604.07-1.035.157"
        ></path>
        <path
          fill="#728c9c"
          d="M86.548 95.18c-.311.17-1.396.693-2.412 1.163-1.603.74-4.51 3.254-5.679 4.911-.558.791-1.447 2.662-5.078 10.693a451.773 451.773 0 01-2.684 5.738c-1.008 2.121-1.833 3.929-1.833 4.018 0 .161-1.719 3.968-3.792 8.4-2.966 6.34-3.713 7.966-6.358 13.829-.907 2.01-2.924 6.333-5.047 10.817-.955 2.017-1.736 3.756-1.736 3.865 0 .178-1.036 2.437-4.139 9.025-1.941 4.12-3.764 8.143-3.764 8.306 0 .089-.824 1.897-1.832 4.018a1725.468 1725.468 0 00-2.803 5.926c-.534 1.138-1.33 2.662-1.768 3.387-.438.724-.511.936-.161.47.837-1.116 2.191-1.075 3.11.094.407.517.914.941 1.125.941.212 0 .442.128.511.285.069.157.887.865 1.818 1.573.932.709 2.032 1.657 2.446 2.107.414.451 1.134.939 1.599 1.086.466.147.847.426.847.619s.169.351.376.351 1.054.677 1.882 1.505c.828.828 1.634 1.505 1.791 1.505.157 0 .743.423 1.301.941.558.517 1.191.94 1.407.94.216 0 .393.254.393.565 0 .31.254.564.564.564.311 0 .565.158.565.351 0 .193.317.452.705.575.388.123 1.311.812 2.051 1.531.74.718 1.523 1.306 1.74 1.306.218 0 .395.174.395.386 0 .212.424.546.941.743.518.197.941.531.941.743 0 .212.182.386.405.386.223 0 .913.508 1.534 1.129s1.262 1.129 1.424 1.129c.162 0 .923.592 1.691 1.317.768.724 1.481 1.317 1.585 1.317.103 0 .424.211.712.47 1.168 1.047 1.661 1.411 1.91 1.411.145 0 .889.658 1.654 1.462.764.804 1.754 1.578 2.199 1.719.445.141.809.414.809.607s.177.351.395.351c.217 0 1.005.593 1.751 1.317.746.725 1.493 1.317 1.661 1.317.169 0 .826.508 1.461 1.129.635.621 1.318 1.129 1.518 1.129.2 0 .363.147.363.327 0 .179.685.779 1.521 1.332.837.554 2.19 1.676 3.008 2.494l1.487 1.486-1.409 1.352c-1.347 1.292.605.036 3.664-2.358l3.771-2.948a302.387 302.387 0 003.952-3.127c.415-.345 1.515-1.216 2.446-1.935.931-.719 1.777-1.404 1.88-1.522.104-.119 1.289-1.049 2.634-2.068 1.345-1.019 2.628-2.027 2.85-2.24.223-.214.957-.812 1.632-1.329a41.885 41.885 0 001.666-1.331c.24-.214 1.115-.891 1.943-1.505.827-.613 2.529-1.962 3.782-2.997 1.252-1.034 4.029-3.236 6.17-4.891 2.142-1.656 4.08-3.182 4.308-3.392.228-.21 1.177-.968 2.108-1.684.932-.716 1.778-1.399 1.882-1.517.103-.119 1.289-1.05 2.634-2.07 1.345-1.02 2.774-2.155 3.176-2.523.401-.368 1.287-1.049 1.969-1.515 1.924-1.313 1.923-1.387-.084-5.738-.928-2.014-2.37-5.163-4.306-9.407a823.665 823.665 0 00-2.43-5.268 282.512 282.512 0 01-1.893-4.139 320.371 320.371 0 00-1.935-4.234c-4.249-9.124-4.27-9.171-6.35-13.829a378.826 378.826 0 00-1.978-4.327c-2.257-4.849-3.759-8.114-4.327-9.407-1.12-2.55-3.746-8.221-7.009-15.138-.853-1.807-1.55-3.404-1.55-3.55 0-.145-.747-1.799-1.661-3.676-2.436-5.007-4.36-9.254-4.36-9.627 0-1.037-4.439-5.002-6.956-6.213-2.776-1.335-9.022-1.89-10.729-.953m193.697 43.2c1.914.068 5.047.068 6.961 0 1.914-.068.348-.124-3.481-.124-3.828 0-5.395.056-3.48.124m-85.455.784c-.342.379-.623.952-.623 1.274 0 .322-.253 1.071-.562 1.664-.309.593-.563 1.364-.564 1.714-.001.35-.172.741-.379.869-.207.128-.376.555-.376.95 0 .395-.277 1.358-.617 2.142-.888 2.05-1.115 2.647-2.045 5.374-1.334 3.916-1.698 4.862-1.972 5.136-.142.142-.259.526-.26.854-.001.327-.255 1.081-.565 1.673-.309.593-.562 1.294-.562 1.557 0 .263-.253.963-.562 1.556-.309.593-.563 1.364-.564 1.714-.002.35-.152.729-.336.842-.183.113-.421.674-.528 1.245-.108.572-.469 1.771-.803 2.664-.787 2.107-.599 2.327 1.991 2.327 2.383 0 3.25-.461 3.543-1.882.181-.88.744-2.583 1.431-4.327a19.97 19.97 0 00.553-1.693c.574-2.107 1.002-2.259 6.34-2.253 5.893.006 6.554.146 6.865 1.451.13.544.347 1.159.482 1.366.135.207.555 1.392.934 2.634 1.386 4.537 1.542 4.704 4.406 4.704 2.813 0 3.247-.378 2.371-2.066-.294-.567-.535-1.26-.535-1.539 0-.28-.24-1.065-.533-1.745-.293-.679-.801-1.854-1.129-2.609-.327-.756-.596-1.563-.596-1.793 0-.23-.154-.712-.342-1.072-.189-.359-.628-1.5-.976-2.535-1.335-3.968-2.898-8.267-3.968-10.912-.167-.414-.642-1.776-1.056-3.026-2.254-6.816-2.353-6.946-5.282-6.946-2 0-2.694.15-3.181.688m21.485-.474c-.335.341-.387 32.567-.054 33.434.281.731 8.443.847 13.196.185 8.814-1.226 13.29-6.924 13.274-16.9-.013-8.953-3.362-13.809-11.08-16.07-2.06-.603-14.851-1.145-15.336-.649m14.867 5.592c7.674 3.631 8.153 18.403.725 22.378-3.063 1.64-9.13 2.142-9.841.815-.757-1.415-.509-23.618.269-24.105 1.165-.728 6.556-.172 8.847.912m-32.64 2.859c.281.512 1.038 2.624 1.682 4.693.644 2.07 1.357 4.139 1.585 4.597.8 1.612-.111 2.028-4.178 1.907-4.506-.133-4.447.067-2.062-7.044 1.819-5.421 2.077-5.782 2.973-4.153m194.08 23.132c.003 1.035.076 1.413.162.841.087-.572.084-1.418-.005-1.881-.089-.463-.16.005-.157 1.04m1.774 7.713c-.819.48-4.807 2.259-5.065 2.259-.248 0-4.245 1.827-7.353 3.36-1.63.805-2.12 1.256-2.307 2.123-.275 1.275-.402 5.053-.17 5.053.158 0 1.832-.703 5.299-2.226a569.43 569.43 0 012.634-1.149c.414-.177 1.853-.822 3.199-1.433 1.345-.611 3.081-1.395 3.857-1.744l1.411-.633v-2.993c0-3.06-.19-3.389-1.505-2.617m-73.879 13.422c-.138.138-.249.434-.245.658.003.247.122.225.3-.056.218-.342 2.792-.491 9.872-.571l9.577-.107-9.627-.088c-5.294-.048-9.739.026-9.877.164m19.688 3.025c-.101 1.491-.048 2.574.118 2.407.166-.167.248-1.387.184-2.711l-.118-2.407-.184 2.711m46.288-.309l-1.693.632-.098 14.569-.099 14.57.851.001c1.079.003 4.525-1.189 4.891-1.692.152-.208.279-6.771.282-14.584l.006-14.205-1.223.039c-.673.021-1.985.323-2.917.67m-25.588 2.529c-.931.312-1.914.641-2.184.73-.75.249-.344.757 5.606 7.008 8.639 9.075 8.996 9.519 8.996 11.179 0 2.615-.242 2.68-9.885 2.68-9.608 0-9.264-.122-7.823 2.778 1.863 3.747 1.582 3.621 8.077 3.605 11.88-.029 15.494-2.096 15.436-8.829-.033-3.802-.596-4.756-6.557-11.11-9.052-9.648-8.339-9.157-11.666-8.041m-35.465.806c2.535.065 6.684.065 9.219 0 2.535-.065.461-.118-4.61-.118-5.07 0-7.144.053-4.609.118M31.293 202.65c-.63 1.384-.51 1.679.172.421.318-.587.508-1.138.422-1.224-.086-.086-.353.275-.594.803m230.88-.553c.309.396.498 2.628.574 6.773l.114 6.182.084-6.257c.075-5.573.012-6.313-.574-6.773-.581-.456-.604-.447-.198.075m-35.644.537c-1.229.703-.799.71.803.015.697-.303 1.012-.551.702-.551-.311-.001-.988.24-1.505.536m19.477 3.668c.18 7.706.323 8.456.395 2.071.039-3.467-.056-6.304-.211-6.304-.155-.001-.238 1.904-.184 4.233m52.553 3.105c0 4.14.055 5.884.122 3.877.068-2.007.068-5.393.001-7.526-.068-2.132-.123-.49-.123 3.649m-68.864-.376c0 3.725.056 5.198.125 3.274.068-1.925.068-4.973-.001-6.774-.069-1.8-.125-.225-.124 3.5m120.413 0c.001 3.725.057 5.198.126 3.274.068-1.925.068-4.973-.001-6.774-.069-1.8-.125-.225-.125 3.5m-109.573-5.247c-.81.568-.834.771-.757 6.491l.08 5.906.203-5.958c.2-5.873.216-5.966 1.143-6.478.518-.286.767-.526.554-.533-.212-.008-.763.25-1.223.572m103.774-.021c-.518.296-.772.538-.565.538.207 0 .8-.242 1.317-.538.518-.296.772-.538.565-.538-.207 0-.8.242-1.317.538m-32.362 2.07l-.94.301 1.034.037c.57.021 1.035-.131 1.035-.338 0-.207-.042-.36-.094-.339-.052.02-.517.173-1.035.339m1.272 4.891c0 2.38.061 3.354.135 2.164.075-1.19.075-3.137 0-4.327-.074-1.19-.135-.217-.135 2.163m-121.686-1.864c-.419.284-.3.321.463.144l1.028-.239.109 8.223.109 8.224.087-8.373c.092-8.963.035-9.217-1.796-7.979m114.934 9.202c0 5.381.053 7.53.117 4.776.065-2.755.065-7.157 0-9.784-.065-2.627-.117-.373-.117 5.008m36.713-3.052c0 1.284-1.124 2.498-2.643 2.856-1.231.289-1.246.309-.245.346 1.364.049 3.264-1.774 3.264-3.131 0-.534-.085-.97-.188-.97-.104 0-.188.405-.188.899m-78.737 2.017c.487.466 1.088.842 1.335.835.247-.006.111-.199-.303-.428a16.563 16.563 0 01-1.335-.836c-.321-.229-.185-.036.303.429m-33.586.473c.252.407 2.445 1.629 2.445 1.362 0-.089-.603-.517-1.34-.952-.736-.434-1.234-.619-1.105-.41m59.435-.034c-.197.189-.781.42-1.299.513l-.94.169.988.051c.544.028 1.2-.203 1.458-.513.512-.617.366-.772-.207-.22m25.795.18c.517.318 1.533.562 2.257.544l1.317-.034-1.505-.275c-.828-.151-1.844-.395-2.258-.543-.487-.174-.42-.065.189.308m-18.378.808c-.63 1.384-.51 1.679.172.421.318-.587.508-1.138.422-1.224-.086-.086-.353.275-.594.803m-30.07-.311c.569.087 1.5.087 2.069 0 .57-.086.104-.156-1.034-.156-1.139 0-1.604.07-1.035.156m-32.922 1.126c.469.09 1.146.087 1.506-.008.359-.094-.024-.167-.851-.163-.828.004-1.123.081-.655.171m16.741-.007c.362.095.955.095 1.317 0 .362-.094.066-.172-.658-.172-.725 0-1.021.078-.659.172m44.82 1.839c-.349.533-1.239 1.38-1.978 1.881-.738.502-1.202.913-1.031.913.581 0 2.464-1.53 3.261-2.649.436-.613.701-1.114.588-1.114-.113 0-.491.436-.84.969m50.453 1.006l-1.105 1.223 1.223-1.105c.672-.608 1.222-1.158 1.222-1.223 0-.291-.31-.035-1.34 1.105m-101.134.009c1.991 1.602 2.573 1.892 1.063.531-.827-.747-1.645-1.365-1.816-1.372-.171-.008.168.371.753.841m17.515.85c.563.592 1.091 1.001 1.173.909.083-.093-.378-.577-1.023-1.077l-1.174-.908 1.024 1.076m50.363-.416c-.254.306-.382.86-.285 1.232.142.551.183.525.219-.138.024-.449.255-.891.514-.984.259-.092.367-.279.242-.416-.126-.137-.436.001-.69.306m-291.932 1.439c-.405 1.105-.395 1.153.105.492.479-.632.761-1.715.448-1.715-.058 0-.307.55-.553 1.223m219.849-.236c-.676.576-.815.805-.345.572.69-.343 1.983-1.581 1.614-1.546-.077.008-.648.446-1.269.974m-11.723-.03c-.123.319-.117.686.012.815.129.129.234-.066.234-.433 0-.448.192-.594.584-.443.335.128.486.065.354-.148-.342-.554-.931-.45-1.184.209m27.339.767c-.525.292-.691.52-.376.516.311-.004.893-.255 1.295-.559.906-.685.347-.659-.919.043m60.019-.219c.414.178 1.007.323 1.317.323.356 0 .287-.119-.188-.323-.414-.178-1.006-.323-1.317-.323-.356 0-.286.119.188.323m-42.803.658c2.949.063 7.775.063 10.724 0 2.949-.064.536-.116-5.362-.116s-8.311.052-5.362.116m50.611 0c3.053.063 8.048.063 11.101 0 3.053-.064.555-.115-5.55-.115-6.106 0-8.603.051-5.551.115m-101.974 1.412c.004.827.081 1.122.171.654.09-.468.086-1.146-.008-1.506-.094-.359-.168.024-.163.852m12.256-.799a4.703 4.703 0 002.391 0c1.032-.296.867-.343-1.196-.343-2.063 0-2.227.047-1.195.343m17.475-.248c.572.086 1.419.084 1.882-.006.462-.089-.006-.16-1.04-.157-1.035.003-1.414.076-.842.163m-65.487 1.987c0 .725.078 1.021.172.659a3.079 3.079 0 000-1.317c-.094-.362-.172-.066-.172.658m6.716.775c-.016.323.233.915.555 1.317.576.719.58.718.239-.022-.19-.414-.44-1.007-.555-1.317-.181-.488-.213-.485-.239.022m75.856 1.734c-.346.346-.318 5.307.031 5.525.156.096.227-1.076.159-2.606l-.124-2.781 9.908-.107 9.907-.107-9.815-.087c-5.398-.049-9.928.025-10.066.163m34.772.973c-.502.619-1.586 1.613-2.408 2.209-.823.595-1.309 1.083-1.08 1.083.517 0 4.848-4.004 4.589-4.243-.103-.095-.599.333-1.101.951m-15.084 2.052c-.101 1.491-.048 2.574.118 2.407.166-.167.249-1.387.184-2.711l-.118-2.408-.184 2.712m-101.192-1.583c0 .207.242.8.538 1.317.296.518.538.772.538.565 0-.207-.242-.8-.538-1.317-.296-.518-.538-.772-.538-.565m9.22 1.683c.813.615 1.631 1.123 1.817 1.129.186.006-.363-.497-1.22-1.118-2.021-1.464-2.529-1.473-.597-.011m111.709 2.145c-.58.759-.862 1.262-.627 1.117.482-.298 2.111-2.499 1.849-2.499-.093 0-.643.622-1.222 1.382m-224.826.903l-1.303 1.156 1.411-1.012c1.247-.895 1.653-1.3 1.303-1.3-.06 0-.695.52-1.411 1.156m121.086-.876c1.708.07 4.502.07 6.209 0 1.707-.07.31-.127-3.104-.127-3.415 0-4.812.057-3.105.127m87.148.301c-.123.319-.117.686.012.815.129.129.234-.04.234-.375 0-.489.503-.636 2.54-.742l2.54-.131-2.551-.074c-2.001-.058-2.6.052-2.775.507m-100.6 1.489c.702.724 1.361 1.317 1.464 1.317.104 0-.386-.593-1.088-1.317-.702-.725-1.361-1.317-1.465-1.317-.103 0 .387.592 1.089 1.317m115.098.434c-.285.342-1.279 1.101-2.21 1.686-.932.585-1.563 1.067-1.404 1.071.482.012 3.049-1.723 3.814-2.578.394-.441.627-.801.516-.801-.11 0-.432.28-.716.622m-226.105 1.31l-1.693 1.534 1.594-1.196c1.386-1.041 2.276-1.918 1.909-1.883-.064.006-.879.702-1.81 1.545m-66.543.906c-.63 1.384-.51 1.679.172.421.318-.588.508-1.139.422-1.225-.086-.086-.353.276-.594.804m279.15-.537c-.002 1.221 1.486 2.593 2.754 2.541l1.196-.05-1.317-.232c-1.02-.18-1.466-.53-1.975-1.55-.362-.724-.658-1.044-.658-.709m-217.256 3.185c-1.418 1.122-2.464 2.039-2.323 2.039.33 0 4.61-3.289 4.908-3.772.351-.567.173-.448-2.585 1.733m123.652-1.088c.362.095.955.095 1.317 0 .362-.094.066-.172-.659-.172-.724 0-1.02.078-.658.172m15.428 0c.362.095.955.095 1.317 0 .362-.094.066-.172-.659-.172-.724 0-1.02.078-.658.172m83.353.007c.468.09 1.146.087 1.506-.008.359-.094-.024-.167-.852-.163-.827.004-1.122.081-.654.171m-93.119.39c1.613.071 4.153.07 5.644-.001 1.491-.071.171-.129-2.934-.128-3.104 0-4.324.058-2.71.129m-193.089 2.182c-.631 1.384-.51 1.679.171.421.319-.587.509-1.138.423-1.224-.086-.086-.354.275-.594.803m57.512 3.591l-1.694 1.534 1.788-1.393c1.567-1.221 2.031-1.681 1.693-1.677-.052 0-.856.691-1.787 1.536m-9.031 7.149l-1.694 1.535 1.788-1.393c1.566-1.221 2.031-1.681 1.693-1.678-.052.001-.856.692-1.787 1.536m-4.809 3.692c-1.506 1.186-3.03 2.462-3.386 2.835-.357.373.829-.451 2.634-1.831 2.754-2.105 4.141-3.333 3.607-3.192-.064.017-1.348 1.002-2.855 2.188m-7.33 5.83c-3.493 2.834-4.084 3.426-1.784 1.788 1.824-1.299 5.2-4.173 4.892-4.164-.104.003-1.502 1.072-3.108 2.376M2.495 266.51c-.301 1.121-.252 5.191.071 6.007.141.354.256-1.043.256-3.105 0-4.113-.001-4.12-.327-2.902m38.521 3.7l-1.693 1.535 1.787-1.393c1.567-1.221 2.031-1.681 1.693-1.677-.051 0-.856.691-1.787 1.535m-7.164 5.64l-1.303 1.156 1.411-1.012c1.247-.895 1.653-1.3 1.303-1.3-.059 0-.694.52-1.411 1.156m-3.771 2.904c-1.15.975-2.674 2.249-3.387 2.832-1.166.954-1.126.944.399-.102 1.725-1.183 5.61-4.503 5.268-4.503-.103 0-1.129.798-2.28 1.773m-23.12 1.538c.621.683 1.637 1.484 2.258 1.779.621.295.804.322.406.06-.397-.261-1.413-1.062-2.257-1.779l-1.535-1.303 1.128 1.243m9.502 4.458c.672.084 1.773.084 2.446 0 .672-.083.122-.152-1.223-.152-1.345 0-1.896.069-1.223.152"
        ></path>
        <path
          fill="#7c7c7c"
          d="M349.2 138.1c-.745.238-.784.301-.188.301.414 0 1.176-.136 1.694-.301.744-.239.784-.302.188-.302-.414 0-1.176.136-1.694.302m6.586 0c.413.178 1.091.318 1.505.312.605-.009.568-.07-.188-.312-1.287-.412-2.276-.412-1.317 0m-104.164.281c3.557.062 9.483.062 13.17 0 3.687-.061.777-.112-6.467-.112-7.243 0-10.26.05-6.703.112m66.498.565c-.712.842-.712.843.045.208.511-.43 1.623-.684 3.386-.773l2.626-.134-2.67-.074c-2.355-.065-2.754.026-3.387.773m57.515-.565c2.846.064 7.502.064 10.348 0 2.846-.064.517-.116-5.174-.116-5.691 0-8.02.052-5.174.116m-103.763 2.541c0 1.306.127 2.295.282 2.2.156-.096.283-1.086.283-2.2s-.127-2.104-.283-2.2c-.155-.096-.282.894-.282 2.2m52.798-1.882c.19.414.44 1.007.555 1.317.181.488.214.485.239-.022.017-.322-.233-.915-.555-1.317-.576-.718-.58-.718-.239.022m34.314 0c.517.296 1.11.538 1.317.538.207 0-.047-.242-.564-.538-.518-.295-1.11-.537-1.317-.537-.207 0 .047.242.564.537m11.101 16.651v17.216h11.069c8.669 0 11.09-.104 11.166-.48.054-.264.012-.306-.094-.094-.124.25-4.015.386-11.068.386H370.28l-.097-17.122-.098-17.121v17.215m-72.061-14.839c0 .064.551.615 1.223 1.222l1.223 1.106-1.105-1.223c-1.03-1.14-1.341-1.396-1.341-1.105m54.281 2.409c.569.086 1.5.086 2.069 0 .57-.086.104-.157-1.034-.157-1.139 0-1.604.071-1.035.157m-97.704.483c.186.311.423 6.999.526 14.864l.188 14.299h2.979c2.329 0 3.013-.123 3.133-.565.119-.436.076-.453-.19-.075-.241.341-1.132.455-2.945.376l-2.601-.112-.188-14.187c-.152-11.478-.288-14.28-.713-14.676-.437-.406-.469-.393-.189.076m29.312-.189c.207.07 1.901.201 3.763.29 1.863.09 2.964.036 2.446-.119-.895-.27-6.995-.438-6.209-.171m73.65.698c.771.474 1.784 1.188 2.251 1.587.803.686.82.687.298.017-.582-.748-3.167-2.497-3.66-2.477-.16.006.34.399 1.111.873m-74.801-.02c-.103.268-.14 2.851-.081 5.738l.107 5.25.186-5.739c.184-5.647.161-6.221-.212-5.249m93.293 3.462c.001 2.07.064 2.868.14 1.775.076-1.094.076-2.787-.002-3.763-.077-.976-.139-.081-.138 1.988m-82.175-2.255c1.498 1.805 1.624 1.921 1.215 1.122-.213-.416-.784-1.092-1.269-1.502-.85-.72-.849-.706.054.38m7.66 3.76c.001 1.656.068 2.287.147 1.402.08-.886.078-2.24-.002-3.011-.081-.77-.146-.046-.145 1.609m19.062-2.446c0 .207.26.377.577.377.317 0 .729.381.917.846.243.606.347.667.364.215.025-.671-.925-1.814-1.509-1.814-.192 0-.349.17-.349.376m-25.104 2.446c.003 1.035.076 1.414.162.842.087-.572.085-1.419-.005-1.882-.089-.462-.16.006-.157 1.04m47.916 2.273c-.129.336-.203 2.333-.165 4.437l.07 3.827.214-4.328c.232-4.708.228-4.839-.119-3.936m-48.818.628c-.245.457-.801 1.145-1.236 1.528-.784.689-.782.69.185.104.537-.326 1.169-1.013 1.403-1.528.528-1.158.255-1.239-.352-.104m24.21.392c-.641 1.772-.552 2.252.127.687.307-.709.509-1.441.447-1.626-.062-.185-.32.237-.574.939m60.61-.19c1.821.069 4.7.069 6.397-.001 1.698-.069.208-.126-3.311-.125-3.518 0-4.907.057-3.086.126m9.991 2.232c.092 1.46-.023 2.209-.376 2.457-.409.287-.398.326.056.204.623-.168 1.036-3.911.492-4.457-.167-.168-.244.64-.172 1.796m-52.495 1.062c.001 1.656.067 2.287.147 1.402.079-.886.078-2.24-.003-3.011-.081-.77-.146-.046-.144 1.609m-51.964-.287c.983.077 2.592.077 3.575 0 .983-.078.179-.141-1.787-.141s-2.771.063-1.788.141m13.668 1.569l-1.101 1.352 1.27-1.21c.699-.666 1.194-1.275 1.102-1.353-.093-.078-.665.467-1.271 1.211m18.975.882c0 .155 1.736.255 3.858.222 4.012-.063 3.557-.224-1.13-.401-1.501-.057-2.729.024-2.728.179m58.471 4.798c0 2.587.06 3.645.134 2.352a50.547 50.547 0 000-4.704c-.074-1.294-.134-.235-.134 2.352m-93.3-1.77c-.103.268-.135 2.935-.071 5.926l.116 5.439.083-5.738.083-5.739h2.231c1.526 0 2.417.187 2.822.592.325.325.591.415.591.201 0-1.107-5.448-1.741-5.855-.681m6.819 3.181c1.287 2.224 2.046 3.347 2.046 3.027 0-.355-2.688-4.814-2.901-4.814-.099 0 .285.804.855 1.787m54.729-1.568c.001.19.439.853.972 1.474l.97 1.129-.85-1.317c-1.09-1.69-1.094-1.694-1.092-1.286m-28.73.815c-.096.156 2.503.283 5.775.283 3.272 0 5.87-.127 5.774-.283-.096-.155-2.694-.282-5.774-.282s-5.679.127-5.775.282m-19.061.548c0 .355 2.688 4.814 2.902 4.814.099 0-.286-.804-.855-1.787-1.287-2.224-2.047-3.347-2.047-3.027m63.029 2.048c-1.133 1.013-1.217 1.153-.342.568 1.04-.695 2.348-1.963 1.988-1.927-.077.008-.818.62-1.646 1.359m-20.332.109c.315.607.743 1.21.951 1.339.209.129.024-.368-.41-1.105-.954-1.615-1.342-1.784-.541-.234m24.605.842c.902 1.025.874 1.294-.283 2.774-.332.424-.137.295.432-.288.569-.582 1.035-1.196 1.035-1.363 0-.168-.466-.716-1.035-1.217l-1.035-.913.886 1.007m19.969.969c5.355.076 7.866.25 8.279.572.524.408.533.385.077-.196-.466-.594-1.272-.65-8.279-.573l-7.762.086 7.685.111m-42.115 1.411c.702.724 1.361 1.317 1.464 1.317.104 0-.386-.593-1.088-1.317-.702-.724-1.361-1.317-1.465-1.317-.103 0 .386.593 1.089 1.317m-35.705 3.104c-.044.859 5.601 1.38 6.109.565.096-.155-1.149-.228-2.767-.161-2.591.107-2.964.04-3.121-.564-.142-.55-.186-.519-.221.16m24.051-.451c-.028.947 1.006 1.298 3.827 1.298 2.805 0 2.933-.037 2.891-.847-.033-.637-.086-.683-.216-.188-.144.552-.62.659-2.948.659-2.246 0-2.849-.126-3.159-.659-.211-.362-.389-.481-.395-.263m-53.35.545c.165.608 5.925 1.08 5.926.487.001-.164-1.208-.241-2.685-.171-1.934.091-2.786-.014-3.04-.377-.282-.401-.323-.389-.201.061m17.919.095c.539.687 6.556 1.012 6.952.376.097-.155-1.257-.227-3.009-.16-2.234.086-3.376-.027-3.823-.376-.572-.449-.584-.432-.12.16m55.462.928c.572.087 1.419.084 1.882-.005.462-.089-.005-.16-1.04-.157-1.035.002-1.414.076-.842.162m4.322-.004a5.407 5.407 0 001.694 0c.465-.09.084-.163-.847-.163-.931 0-1.312.073-.847.163M39.135 189.044c0 .08.465.445 1.034.811l1.035.666-.717-.811c-.634-.717-1.352-1.071-1.352-.666m4.891 3.733c0 .075.508.59 1.129 1.143s1.129.867 1.129.697c0-.169-.508-.684-1.129-1.143-.621-.459-1.129-.773-1.129-.697m3.942 3.505c.336.335.724.495.863.356.139-.14.004-.411-.3-.604-.889-.562-1.225-.414-.563.248m10.369 7.948c.007.157.427.587.934.956.581.423.852.49.733.18-.216-.564-1.684-1.565-1.667-1.136m234.189 5.177c.001 2.691.061 3.742.133 2.337.073-1.406.073-3.607-.001-4.892-.073-1.285-.132-.135-.132 2.555m-227.419.328c.513.49 1.005.827 1.093.748.202-.18-1.343-1.64-1.736-1.64-.16 0 .13.401.643.892m1.497 1.085c0 .077.508.515 1.129.974.621.459 1.129.696 1.129.528 0-.169-.508-.607-1.129-.973-.621-.367-1.129-.605-1.129-.529m120.572 7.995c0 4.139.055 5.884.122 3.877.068-2.007.068-5.394.001-7.526-.067-2.133-.123-.491-.123 3.649M79.03 220.647c.513.491 1.005.828 1.093.749.202-.18-1.344-1.641-1.736-1.641-.16 0 .13.402.643.892m2.626 2.083c2.123 1.865 2.257 1.962 2.257 1.639 0-.375-.94-1.185-2.446-2.105-1.037-.634-1.022-.596.189.466m153.998 2.553c.362.095.955.095 1.317 0s.066-.172-.659-.172c-.724 0-1.02.077-.658.172m-148.818 1.573c.676.648 1.418 1.178 1.65 1.178.231 0-.068-.369-.665-.82-1.914-1.446-2.246-1.567-.985-.358m187.952 8.609c2.639.064 6.957.064 9.596 0 2.639-.065.48-.118-4.798-.118-5.277 0-7.436.053-4.798.118m-70.009 5.643c1.8.069 4.848.069 6.773 0 1.925-.068.452-.124-3.274-.125-3.725 0-5.3.056-3.499.125m90.894-.015c.465.09 1.227.09 1.693 0 .466-.089.085-.163-.847-.163-.931 0-1.312.074-.846.163"
        ></path>
      </g>
    </svg>
  );
}

export default Icon;
