/** @format */

import Document, { Html, Head, Main, NextScript } from "next/document";

class MyDocument extends Document {
  static async getInitialProps(ctx) {
    const initialProps = await Document.getInitialProps(ctx);
    return { ...initialProps };
  }

  render() {
    return (
      <Html dir="rtl">
        <Head>
          <meta httpEquiv="Content-Type" content="text/html; CharSet=utf-8" />
          <meta name="format-detection" content="telephone=no" />
          <meta name="viewport" content="width=device-width, initial-scale=1" />
          <link rel="icon" type="image/x-icon" href="favicon.ico" />
          <meta name="description" content="" />
          <meta name="keywords" content="" />
          <meta name="it-rating" content="it-rat-cd303c3f80473535b3c667d0d67a7a11" />
          <meta name="cmsmagazine" content="3f86e43372e678604d35804a67860df7" />
          <link rel="stylesheet" type="text/css" href="css/first-screen.css" />
          <link rel="stylesheet" type="text/css" href="css/first-screen-inner.css" />
          <link rel="preload " href="fonts/AleoBold.woff2" as="font" crossOrigin />
          <link rel="preload " href="fonts/Lato/LatoRegular.woff2" as="font" crossOrigin />
          <link rel="preload " href="fonts/Lato/LatoBold.woff2" as="font" crossOrigin />
          <link rel="preload" href="css/style.css" as="style"></link>
        </Head>
        <body>
          <Main />
          <NextScript />

          <script src="js/jquery-3.5.1.min.js" defer></script>
          <script src="js/components/jquery.lazy.min.js" defer></script>
          <script src="js/components/jquery.fancybox.min.js" defer></script>
          <script src="js/components/jquery.singlePageNav.min.js" defer></script>
          <script src="js/components/swiper.js" defer></script>
          <script src="js/custom.js" defer></script>
          <NextScript
            async
            src="https://www.googletagmanager.com/gtag/js?id=G-7VH9WQ3L6J"
          ></NextScript>
          <script>
            {`
            window.dataLayer = window.dataLayer || []; function gtag()
            {dataLayer.push(arguments)}
            gtag('js', new Date()); gtag('config', 'G-7VH9WQ3L6J');
         
                `}
          </script>
        </body>
      </Html>
    );
  }
}

export default MyDocument;
