import React, { useState } from "react";
import { Notification, toaster } from "rsuite";
import { feachers } from "../../api/Api";
import Question from "./../../public/svg/question";

export default function faqweb() {
  // eslint-disable-next-line react-hooks/rules-of-hooks
  const [values, setValues] = useState({
    fullname: "",
    description: "",
    phoneNumber: "",
    subject: "",
    email: "",
  });

  const handleChange = async ({ target: { name, value } }) => {
    await setValues({ ...values, [name]: value });
  };
  const message = (
    <Notification type={"success"} header={"موفقیت"} closable>
      درخواست با موفقیت ثبت شد
    </Notification>
  );
  const messageError = (
    <Notification type={"error"} header={"خطا"} closable>
      درخواست با موفقیت ثبت نشد
    </Notification>
  );
  const handleSubmit = async () => {
    try {
      const { data } = await feachers.UserComplaint(values);
      //   console.log(data);
      toaster.push(message);
      setValues({
        fullname: "",
        phoneNumber: "",
        email: "",
        description: "",
        subject: "",
      });
    } catch (error) {
      console.error(error);
      toaster.push(messageError);
    }
  };
  return (
    <>
      <div className="section-newsletter">
        <div
          className="section-newsletter__bg js-lazy"
          data-src="img/bg/bg-3.svg"
        ></div>
        <div className="wrapper">
          <div className="consultation-form-wrap">
            <div className="consultation-form">
              <div className="section-heading rtl">
                <span>همین الان شروع کن</span>
              </div>
              <h2 className="h2" style={{ textAlign: "right!important" }}>
                ثبت مشکلات
              </h2>
              <div className="content-block__text">
                <p>
                  کافیست همین الان مشکلتان را ثبت کنید و منتظر تماس پشتیبان‌های
                  جیب جیب باشید تا در اسرع وقت شاهد حل مشکل پیش آمده باشید
                </p>
              </div>
              <div className="consultation-form__form">
                <form>
                  <div className="box-fileds">
                    <div className="box-filed ">
                      <input
                        required
                        onChange={(e) => handleChange(e)}
                        name="fullname"
                        value={values.fullname}
                        type="text"
                        placeholder="نام و نام خانوادگی"
                      />
                    </div>

                    <div className="box-filed ">
                      <input
                        required
                        onChange={(e) => handleChange(e)}
                        name="phoneNumber"
                        type="number"
                        value={values.phoneNumber}
                        placeholder="شماره همراه"
                      />
                    </div>
                    <div className="box-filed ">
                      <input
                        required
                        onChange={(e) => handleChange(e)}
                        name="subject"
                        type="text"
                        value={values.subject}
                        placeholder="موضوع"
                      />
                    </div>
                    <div className="box-filed ">
                      <input
                        required
                        onChange={(e) => handleChange(e)}
                        name="email"
                        type="email"
                        value={values.email}
                        placeholder="پست الکترونیک"
                      />
                    </div>

                    <div className=" box-problem">
                      <textarea
                        name="description"
                        onChange={(e) => handleChange(e)}
                        required
                        type="text"
                        value={values.description}
                        placeholder="متن پیام"
                      />
                    </div>
                    <div className="box-filed box-filed_btn">
                      <button
                        onClick={handleSubmit}
                        type="button"
                        className="btn"
                        value="ثبت"
                      >
                        ثبت
                      </button>
                    </div>
                  </div>
                </form>
              </div>
            </div>
            <div className="consultation-img">
              <Question />
            </div>
          </div>
        </div>
      </div>
    </>
  );
}
