import React, { useState } from "react";
import { Notification, toaster } from "rsuite";
import { feachers } from "../../api/Api";
import Checkout from "./../../public/svg/checkout";
export default function checkoutreq() {
  // eslint-disable-next-line react-hooks/rules-of-hooks
  const [values, setValues] = useState({
    fullname: "",
    phoneNumber: "",
    email: "",
    cartNumber: "",
  });

  const handleChange = async ({ target: { name, value } }) => {
    await setValues({ ...values, [name]: value });
  };
  const message = (
    <Notification type={"success"} header={"موفقیت"} closable>
      درخواست با موفقیت ثبت شد
    </Notification>
  );
  const messageError = (
    <Notification type={"error"} header={"خطا"} closable>
      درخواست با موفقیت ثبت نشد
    </Notification>
  );
  const handleSubmit = async () => {
    try {
      const { data } = await feachers.UserCheckout(values);
      //   console.log(data);
      toaster.push(message);
      setValues({
        fullname: "",
        phoneNumber: "",
        email: "",
        cartNumber: "",
      });
    } catch (error) {
      console.error(error);
      toaster.push(messageError);
    }
  };
  return (
    <>
      <div className="section-newsletter">
        <div
          className="section-newsletter__bg js-lazy"
          data-src="img/bg/bg-3.svg"
        ></div>
        <div className="wrapper">
          <div className="consultation-form-wrap">
            <div className="consultation-form">
              <div className="section-heading ">
                <span>همین الان شروع کن</span>
              </div>
              <h2 className="h2" style={{ textAlign: "right!important" }}>
                {" "}
                تسویه حساب
              </h2>
              <div className="content-block__text">
                <p>
                  لطفاً جهت ثبت درخواست تسویه حساب اطلاعات زیر را تکمیل نمایید{" "}
                </p>
              </div>
              <div className="consultation-form__form">
                <form>
                  <div className="box-fileds">
                    <div className="box-filed ">
                      <input
                        required
                        onChange={(e) => handleChange(e)}
                        name="fullname"
                        value={values.fullname}
                        type="text"
                        placeholder="نام و نام خانوادگی"
                      />
                    </div>

                    <div className="box-filed ">
                      <input
                        required
                        onChange={(e) => handleChange(e)}
                        name="phoneNumber"
                        type="number"
                        value={values.phoneNumber}
                        placeholder="شماره همراه"
                      />
                    </div>
                    <div className="box-filed ">
                      <input
                        required
                        onChange={(e) => handleChange(e)}
                        name="email"
                        type="email"
                        value={values.email}
                        placeholder="پست الکترونیک"
                      />
                    </div>

                    <div className=" box-filed">
                      <input
                        required
                        onChange={(e) => handleChange(e)}
                        name="cartNumber"
                        type="number"
                        value={values.cartNumber}
                        placeholder="شماره کارت"
                      />
                    </div>
                    <div className="box-filed box-filed_btn">
                      <button
                        onClick={handleSubmit}
                        type="button"
                        className="btn"
                        value="ثبت"
                      >
                        ثبت
                      </button>
                    </div>
                  </div>
                </form>
              </div>
            </div>
            <div className="consultation-img">
              <Checkout style={{ zIndex: -2 }} />
            </div>
          </div>
        </div>
      </div>
    </>
  );
}
