import React from "react";
import Link from "next/link";
import Step1 from "../../public/svg/step1";
import Step2 from "../../public/svg/step2";
import Step3 from "../../public/svg/step3";
import Step4 from "../../public/svg/step4";

export default function Steps() {
  return (
    <div>
      <div className="section-steps" id="steps">
        <div className="wrapper">
          <div className="section-heading h-center">
            <span>همراهتان هستیم</span>
          </div>
          <div className="h-decor-3">
            <h2 className="h2 h-center">
              <span>پشتیبانی</span>
            </h2>
          </div>
          <div className="steps">
            <Link href="/Support">
              <div className="steps__item">
                <span className="steps__count">01</span>
                <div className="steps__icon">
                  <Step1 />
                
                </div>
                <div className="steps__title">سوالات متداول</div>
              </div>
            </Link>
            <Link href="/Question">
              <div className="steps__item">
                <span className="steps__count">02</span>
                <div className="steps__icon">
                  <Step2 />
                
                </div>
                <div className="steps__title">ثبت مشکلات</div>
              </div>
            </Link>
            <Link href="/Callus">
              <div className="steps__item">
                <span className="steps__count">03</span>
                <div className="steps__icon">
                  <Step3 />
                
                </div>
                <div className="steps__title">تماس با پشتیبان</div>
              </div>
            </Link>
            <Link href="/Checkout">
              <div className="steps__item">
                <span className="steps__count">04</span>
                <div className="steps__icon">
                  <Step4 />
                 
                </div>
                <div className="steps__title">درخواست تسویه کیف پول</div>
              </div>
            </Link>
          </div>
          {/* <div className="steps-text">
            Pariatur magna cupidatat magna sit incididunt non pariatur. Sint
            nulla commodo qui magna eiusmod quis aliqua laboris officia
            excepteur non eu in. Consequat esse in dolore laborum dolore ut duis
            elit deserunt minim.
          </div> */}
        </div>
      </div>
    </div>
  );
}
