import Link from "next/link";
import React, { useState, useEffect } from "react";
import { blog } from "../../api/Api";
import jMoment from "moment-jalaali";


export default function MainBlog() {
  const [values, setValues] = useState([]);

  useEffect(() => {
    getAll();
  }, []);

  const getAll = async () => {
    try {
      const { data } = await blog.getAll();
      const slicedArray = data.data.slice(0, 2);
      setValues(slicedArray);
    } catch (error) {
      console.error(error);
    }
  };
  return (
    <div>
      <div className="section-main-blog" id="blog">
        <div className="wrapper">
          <div className="section-heading h-center">
            <span>مقاله</span>
          </div>
          <h2 className="h2 h-center">بلاگ</h2>
          <div className="section-subtitle h-center">
            آخرین مقالات جیب جیب را بخوانید{" "}
          </div>
        
          <div className="news">
            {values && values.length
              ? values.map((x) => {
                  return (
                    <div key={Math.random()} className="news__item">
                    
                        <a>
                          <a className="news__img">
                            <img
                              data-src="img/examples/news_1.jpg"
                              alt=""
                              className="js-lazy"
                              src={x.file}
                            />
                          </a>
                          <div className="news__content">
                            <div className="news-header">
                              <div className="news__date">
                                {jMoment(values.createdAt).format(
                                  "jYYYY/jMM/jDD"
                                )}
                              </div>
                            
                             
                            </div>
                            <div className="news__title">
                              <Link href={`/BlogPage/${x.id}`}>
                              <a>{x.title}</a>
                              </Link>
                             
                            </div>
                            <p className="txt-desc">{x.description.slice(0, 130)}...</p>
                          </div>
                        </a>
                     
                    </div>
                  );
                })
              : "مقاله ای موجود نیست"}
          </div>
          <div className="blog-more">
            <Link href="/BlogPage">
              <a href="blog.html" className="btn">
                مشاهده همه
              </a>
            </Link>
          </div>
        </div>
      </div>
    </div>
  );
}
