import React, { useState } from "react";
import { Notification, toaster , Checkbox , Button} from "rsuite";
import { feachers } from "../../api/Api";
import ConsultationS from "../../public/svg/ConsultationS";


export default function Consultation() {
    const [accepted, setAccepted] = useState(false);
  

  const [values, setValues] = useState({
    fullname: "",
    company: "",
    phoneNumber: "",
    siteName: "",
  });
  const onChange =  () => {
    setAccepted(!accepted);
    console.log(!accepted);

  }
  const handleChange = async ({ target: { name, value } }) => {
    await setValues({ ...values, [name]: value });
  };
  const message = (
    <Notification type={"success"} header={"موفقیت"} closable>
      درخواست با موفقیت ثبت شد
    </Notification>
  );
  const messageError = (
    <Notification type={"error"} header={"خطا"} closable>
      درخواست با موفقیت ثبت نشد
    </Notification>
  );
  const handleSubmit = async () => {
    try {
      const { data } = await feachers.CooperationRequest(values);
      //   console.log(data);
      toaster.push(message);
      setValues({ fullname: "", company: "", phoneNumber: "", siteName: "" });
    } catch (error) {
      console.error(error);
      toaster.push(messageError);
    }
  };

  return (
    <div>
      <div className="section-consultation-style" id="consultation">
        <div
          className="section-consultation__bg js-lazy"
          data-src="img/bg/bg-2.svg"
        ></div>
        <div className="wrapper">
          <div className="consultation-form-wrap">
            <div className="consultation-form">
              {/* <div className="section-heading">
                <span>get started</span>
              </div> */}
              <h2 className="h2" style={{ fontSize: 38 }}>
                شروع همکاری با جیب جیب
              </h2>
              <div className="content-block__text">
                <p>
                  برای عضویت در جیب جیب به عنوان سرویس پرووایدر فرم زیر را تکمیل
                  کنید.
                </p>
              </div>
              <div className="consultation-form__form">
                <form onSubmit="successSubmit();return false;">
                  <div className="box-fileds">
                    <div className="box-filed">
                      <input
                        required
                        onChange={(e) => handleChange(e)}
                        name="fullname"
                        value={values.fullname}
                        type="text"
                        placeholder="نام و نام خانوادگی"
                      />
                    </div>
                    <div className="box-filed">
                      <input
                        required
                        onChange={(e) => handleChange(e)}
                        name="company"
                        type="text"
                        value={values.company}
                        placeholder="نام کسب و کار"
                      />
                    </div>
                    <div className="box-filed">
                      <input
                        required
                        onChange={(e) => handleChange(e)}
                        name="siteName"
                        type="text"
                        placeholder="آدرس وب سایت"
                        value={values.siteName}
                      />
                    </div>
                    <div className="box-filed">
                      <input
                        required
                        onChange={(e) => handleChange(e)}
                        name="phoneNumber"
                        type="number"
                        value={values.phoneNumber}
                        placeholder="شماره تماس"
                      />
                    </div>

                    <div className="box-filed box-field__accept">
                    <Checkbox defaultChecked onClick={onChange} value={accepted}> قوانین و مقررات جیب‌ جیب را پذیرفته‌ام</Checkbox>
                    <br />
                      <br />
                      <div className="box-filed box-filed_btn">
                        <button
                          onClick={handleSubmit}
                          type="submit"
                          className="btn"
                          value="ثبت"
                          disabled={accepted}
                        >
                          ثبت
                        </button>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
            <div className="consultation-img">
              <ConsultationS />
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}
