import Link from "next/link";
import React, { useState, useEffect } from "react";
import { blog } from "../../api/Api";
import jMoment from "moment-jalaali";

export default function BlogPage() {
  const [values, setValues] = useState([]);

  useEffect(() => {
    getAll();
  }, []);

  const getAll = async () => {
    try {
      const { data } = await blog.getAll();
      setValues(data.data);
    } catch (error) {
      console.error(error);
    }
  };
  let articleid = 100;
  return (
    <div >
      <main className="content">
        <div
          className="section-main-screen section-main-screen_inner"
          style={{ backgroundImage: `url(img/bg/header.svg)` }}
        >
          <div className="wrapper">
            <div className="main-screen main-screen_inner">
              <h1 className="h1-2">وبلاگ</h1>
              <ul
                className="breadcrumbs"
                itemScope=""
                itemType="https://schema.org/BreadcrumbList"
              >
                <li
                  itemProp="itemListElement"
                  itemScope=""
                  itemType="https://schema.org/ListItem"
                >
                  <a href="#" itemProp="item">
                    <span itemProp="name">خانه</span>
                  </a>
                  <meta itemProp="position" content="1" />
                </li>
                <li
                  itemProp="itemListElement"
                  itemcope=""
                  itemType="https://schema.org/ListItem"
                >
                  <span itemProp="name">وبلاگ</span>
                  <meta itemProp="position" content="2" />
                </li>
              </ul>
              <div className="leaf-left-decor"></div>
            </div>
            <div className="circle-decor"></div>
          </div>
          <div className="leaf-right-decor"></div>
        </div>
        <div className="section-post">
          <div className="wrapper">
            <div className="columns" style={{textAlign:'right'}}>
              <div className="columns_center">
                <div className="news news-page">
                  {values && values.length
                    ? values.map((x) => {
                        return (
                          <Link key={Math.random()} href={`/BlogPage/${x.id}`}>
                            <a>
                              <div className="news__item rtl">
                                <a href="#" className="news__img">
                                  <picture>
                                    <img src={x.file} alt="" />
                                  </picture>
                                </a>
                                <div className="news__content">
                                  <div className="news-header">
                                    <div className="news__date">
                                      Jun 25, 2021
                                    </div>
                                    {/* <div className="news__author">
                                      <img
                                        data-src="img/examples/avatar_2.jpg"
                                        alt=""
                                        className="js-lazy"
                                        src="data:image/gif;base64,R0lGODlhAQABAAAAACw="
                                      />
                                      {/* <span className="news__author-title">
                                        Annette Black
                                      </span>
                                    </div> */}
                                    <a href="#" className="news__category">
                                      Community
                                    </a>
                                  </div>
                                  <div className="news__title">
                                    <a href="article.html">{x.title}</a>
                                  </div>
                                  <div className="news__text txt-desc" style={{textAlign:'justify'}}>
                                    {x.description}
                                  </div>
                                </div>
                              </div>
                            </a>
                          </Link>
                        );
                      })
                    : ""}

                  <div className="blog-more blog-more-inner">
                    <a href="#" className="btn">
                      بیشتر بدانید
                    </a>
                  </div>
                </div>
              </div>
              <aside className="columns_sidebar sidebar">
                <div className="sidebar_search">
                  <form>
                    <div className="search">
                      <input type="text" placeholder="جستجو ..." />
                      <button type="submit">
                        <span className="icon-search"></span>
                      </button>
                    </div>
                  </form>
                </div>
                <div className="sidebar-widget sidebar-widget_post">
                  <h3 className="sidebar-widget__title">پست های اخیر</h3>
                  <div className="stories">
                    {values && values.length
                      ? values.map((x) => {
                          return (
                            <div key={Math.random()} className="stories-item">
                             <a
                                href="article.html"
                                className="stories-item__img"
                              >
                                <img
                                  dataSrc="img/examples/img1.jpg"
                                  src={x.file}
                                  className="js-lazy"
                                  alt=""
                                />
                              </a>
                             
                              <div className="stories-item__infoline">
                                <div className="stories-item__title">
                                  <Link key={Math.random()} href={`/BlogPage/${x.id}`}>
                                    <a href="">{x.title}</a>
                                  </Link>
                                </div>
                                <div className="stories-item__date">
                                  {jMoment(x.createdAt).format("jYYYY/jMM/jDD")}
                                </div>
                              </div>
                            </div>
                          );
                        })
                      : ""}
                  </div>
                </div>
                <div className="sidebar-widget sidebar-widget_datepicker">
                  <div id="datepicker" className="datepicker"></div>
                </div>
            
              </aside>
            </div>
          </div>
        </div>
      </main>
    </div>
  );
}
