/** @format */

import axios from "axios";

// const baseURL = "http://localhost:3085/client/v1";
const baseURL = "https://api.jibjib.app/client/v1";

const APIClient = axios.create({ baseURL });

function setAuthToken(token) {
  APIClient.defaults.headers["Cache-Control"] = "no-cache";
  APIClient.defaults.headers.Pragma = "no-cache";
  APIClient.defaults.headers.Authorization = `Bearer ${token}`;
}

function unsetAuthToken() {
  APIClient.defaults.headers.Authorization = "";
}

export { APIClient, setAuthToken, unsetAuthToken };
